/*
==============================================================================
LLVM Release License
==============================================================================
University of Illinois/NCSA
Open Source License

Copyright (c) 2003, 2004, 2005 University of Illinois at Urbana-Champaign.
All rights reserved.

Developed by:

    LLVM Team

    University of Illinois at Urbana-Champaign

    http://llvm.org/

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal with
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

    * Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimers.

    * Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimers in the
        documentation and/or other materials provided with the distribution.

    * Neither the names of the LLVM Team, University of Illinois at
        Urbana-Champaign, nor the names of its contributors may be used to
        endorse or promote products derived from this Software without specific
        prior written permission.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
CONTRIBUTORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS WITH THE
SOFTWARE.

Copyright (C) 2014 Apple Inc. All rights reserved.
        
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.
        
THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
//OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  
*/

var referenceScore = 10981;

if (typeof (WScript) === "undefined") {
    var WScript = {
        Echo: print
    }
}
var print = function () {};

var performance = performance || {};
performance.now = (function () {
    return performance.now ||
        performance.mozNow ||
        performance.msNow ||
        performance.oNow ||
        performance.webkitNow ||
        Date.now;
})();


function reportResult(score) {
    WScript.Echo("### SCORE: " + (100 * referenceScore / score));
}

var top = {};
top.JetStream = {
    goodTime: performance.now,
    reportResult: reportResult
};

var __time_before = top.JetStream.goodTime();

////////////////////////////////////////////////////////////////////////////////
// Test
////////////////////////////////////////////////////////////////////////////////

// The Module object: Our interface to the outside world. We import
// and export values on it, and do the work to get that through
// closure compiler if necessary. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to do an eval in order to handle the closure compiler
// case, where this code here is minified but Module was defined
// elsewhere (e.g. case 4 above). We also need to check if Module
// already exists (e.g. case 3 above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module;
if (!Module) Module = eval('(function() { try { return Module || {} } catch(e) { return {} } })()');

// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
for (var key in Module) {
    if (Module.hasOwnProperty(key)) {
        moduleOverrides[key] = Module[key];
    }
}

// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof require === 'function';
var ENVIRONMENT_IS_WEB = typeof window === 'object';
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;

if (ENVIRONMENT_IS_NODE) {
    // Expose functionality in the same simple way that the shells work
    // Note that we pollute the global namespace here, otherwise we break in node
    if (!Module['print']) Module['print'] = function print(x) {
        process['stdout'].write(x + '\n');
    };
    if (!Module['printErr']) Module['printErr'] = function printErr(x) {
        process['stderr'].write(x + '\n');
    };

    var nodeFS = require('fs');
    var nodePath = require('path');

    Module['read'] = function read(filename, binary) {
        filename = nodePath['normalize'](filename);
        var ret = nodeFS['readFileSync'](filename);
        // The path is absolute if the normalized version is the same as the resolved.
        if (!ret && filename != nodePath['resolve'](filename)) {
            filename = path.join(__dirname, '..', 'src', filename);
            ret = nodeFS['readFileSync'](filename);
        }
        if (ret && !binary) ret = ret.toString();
        return ret;
    };

    Module['readBinary'] = function readBinary(filename) {
        return Module['read'](filename, true)
    };

    Module['load'] = function load(f) {
        globalEval(read(f));
    };

    Module['arguments'] = process['argv'].slice(2);

    module['exports'] = Module;
} else if (ENVIRONMENT_IS_SHELL) {
    if (!Module['print']) Module['print'] = print;
    if (typeof printErr != 'undefined') Module['printErr'] = printErr; // not present in v8 or older sm

    if (typeof read != 'undefined') {
        Module['read'] = read;
    } else {
        Module['read'] = function read() {
            throw 'no read() available (jsc?)'
        };
    }

    Module['readBinary'] = function readBinary(f) {
        return read(f, 'binary');
    };

    if (typeof scriptArgs != 'undefined') {
        Module['arguments'] = scriptArgs;
    } else if (typeof arguments != 'undefined') {
        Module['arguments'] = arguments;
    }

    this['Module'] = Module;

    eval("if (typeof gc === 'function' && gc.toString().indexOf('[native code]') > 0) var gc = undefined"); // wipe out the SpiderMonkey shell 'gc' function, which can confuse closure (uses it as a minified name, and it is then initted to a non-falsey value unexpectedly)
} else if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
    Module['read'] = function read(url) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, false);
        xhr.send(null);
        return xhr.responseText;
    };

    if (typeof arguments != 'undefined') {
        Module['arguments'] = arguments;
    }

    if (typeof console !== 'undefined') {
        if (!Module['print']) Module['print'] = function print(x) {
            console.log(x);
        };
        if (!Module['printErr']) Module['printErr'] = function printErr(x) {
            console.log(x);
        };
    } else {
        // Probably a worker, and without console.log. We can do very little here...
        var TRY_USE_DUMP = false;
        if (!Module['print']) Module['print'] = (TRY_USE_DUMP && (typeof (dump) !== "undefined") ? (function (x) {
            dump(x);
        }) : (function (x) {
            // self.postMessage(x); // enable this if you want stdout to be sent as messages
        }));
    }

    if (ENVIRONMENT_IS_WEB) {
        this['Module'] = Module;
    } else {
        Module['load'] = importScripts;
    }
} else {
    // Unreachable because SHELL is dependant on the others
    throw 'Unknown runtime environment. Where are we?';
}

function globalEval(x) {
    eval.call(null, x);
}
if (!Module['load'] == 'undefined' && Module['read']) {
    Module['load'] = function load(f) {
        globalEval(Module['read'](f));
    };
}
if (!Module['print']) {
    Module['print'] = function () {};
}
if (!Module['printErr']) {
    Module['printErr'] = Module['print'];
}
if (!Module['arguments']) {
    Module['arguments'] = [];
}
// *** Environment setup code ***

// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];

// Callbacks
Module['preRun'] = [];
Module['postRun'] = [];

// Merge back in the overrides
for (var key in moduleOverrides) {
    if (moduleOverrides.hasOwnProperty(key)) {
        Module[key] = moduleOverrides[key];
    }
}



// === Auto-generated preamble library stuff ===

//========================================
// Runtime code shared with compiler
//========================================

var Runtime = {
    stackSave: function () {
        return STACKTOP;
    },
    stackRestore: function (stackTop) {
        STACKTOP = stackTop;
    },
    forceAlign: function (target, quantum) {
        quantum = quantum || 4;
        if (quantum == 1) return target;
        if (isNumber(target) && isNumber(quantum)) {
            return Math.ceil(target / quantum) * quantum;
        } else if (isNumber(quantum) && isPowerOfTwo(quantum)) {
            return '(((' + target + ')+' + (quantum - 1) + ')&' + -quantum + ')';
        }
        return 'Math.ceil((' + target + ')/' + quantum + ')*' + quantum;
    },
    isNumberType: function (type) {
        return type in Runtime.INT_TYPES || type in Runtime.FLOAT_TYPES;
    },
    isPointerType: function isPointerType(type) {
        return type[type.length - 1] == '*';
    },
    isStructType: function isStructType(type) {
        if (isPointerType(type)) return false;
        if (isArrayType(type)) return true;
        if (/<?\{ ?[^}]* ?\}>?/.test(type)) return true; // { i32, i8 } etc. - anonymous struct types
        // See comment in isStructPointerType()
        return type[0] == '%';
    },
    INT_TYPES: {
        "i1": 0,
        "i8": 0,
        "i16": 0,
        "i32": 0,
        "i64": 0
    },
    FLOAT_TYPES: {
        "float": 0,
        "double": 0
    },
    or64: function (x, y) {
        var l = (x | 0) | (y | 0);
        var h = (Math.round(x / 4294967296) | Math.round(y / 4294967296)) * 4294967296;
        return l + h;
    },
    and64: function (x, y) {
        var l = (x | 0) & (y | 0);
        var h = (Math.round(x / 4294967296) & Math.round(y / 4294967296)) * 4294967296;
        return l + h;
    },
    xor64: function (x, y) {
        var l = (x | 0) ^ (y | 0);
        var h = (Math.round(x / 4294967296) ^ Math.round(y / 4294967296)) * 4294967296;
        return l + h;
    },
    getNativeTypeSize: function (type) {
        switch (type) {
        case 'i1':
        case 'i8':
            return 1;
        case 'i16':
            return 2;
        case 'i32':
            return 4;
        case 'i64':
            return 8;
        case 'float':
            return 4;
        case 'double':
            return 8;
        default:
            {
                if (type[type.length - 1] === '*') {
                    return Runtime.QUANTUM_SIZE; // A pointer
                } else if (type[0] === 'i') {
                    var bits = parseInt(type.substr(1));
                    assert(bits % 8 === 0);
                    return bits / 8;
                } else {
                    return 0;
                }
            }
        }
    },
    getNativeFieldSize: function (type) {
        return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE);
    },
    dedup: function dedup(items, ident) {
        var seen = {};
        if (ident) {
            return items.filter(function (item) {
                if (seen[item[ident]]) return false;
                seen[item[ident]] = true;
                return true;
            });
        } else {
            return items.filter(function (item) {
                if (seen[item]) return false;
                seen[item] = true;
                return true;
            });
        }
    },
    set: function set() {
        var args = typeof arguments[0] === 'object' ? arguments[0] : arguments;
        var ret = {};
        for (var i = 0; i < args.length; i++) {
            ret[args[i]] = 0;
        }
        return ret;
    },
    STACK_ALIGN: 8,
    getAlignSize: function (type, size, vararg) {
        // we align i64s and doubles on 64-bit boundaries, unlike x86
        if (!vararg && (type == 'i64' || type == 'double')) return 8;
        if (!type) return Math.min(size, 8); // align structures internally to 64 bits
        return Math.min(size || (type ? Runtime.getNativeFieldSize(type) : 0), Runtime.QUANTUM_SIZE);
    },
    calculateStructAlignment: function calculateStructAlignment(type) {
        type.flatSize = 0;
        type.alignSize = 0;
        var diffs = [];
        var prev = -1;
        var index = 0;
        type.flatIndexes = type.fields.map(function (field) {
            index++;
            var size, alignSize;
            if (Runtime.isNumberType(field) || Runtime.isPointerType(field)) {
                size = Runtime.getNativeTypeSize(field); // pack char; char; in structs, also char[X]s.
                alignSize = Runtime.getAlignSize(field, size);
            } else if (Runtime.isStructType(field)) {
                if (field[1] === '0') {
                    // this is [0 x something]. When inside another structure like here, it must be at the end,
                    // and it adds no size
                    // XXX this happens in java-nbody for example... assert(index === type.fields.length, 'zero-length in the middle!');
                    size = 0;
                    if (Types.types[field]) {
                        alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
                    } else {
                        alignSize = type.alignSize || QUANTUM_SIZE;
                    }
                } else {
                    size = Types.types[field].flatSize;
                    alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
                }
            } else if (field[0] == 'b') {
                // bN, large number field, like a [N x i8]
                size = field.substr(1) | 0;
                alignSize = 1;
            } else if (field[0] === '<') {
                // vector type
                size = alignSize = Types.types[field].flatSize; // fully aligned
            } else if (field[0] === 'i') {
                // illegal integer field, that could not be legalized because it is an internal structure field
                // it is ok to have such fields, if we just use them as markers of field size and nothing more complex
                size = alignSize = parseInt(field.substr(1)) / 8;
                assert(size % 1 === 0, 'cannot handle non-byte-size field ' + field);
            } else {
                assert(false, 'invalid type for calculateStructAlignment');
            }
            if (type.packed) alignSize = 1;
            type.alignSize = Math.max(type.alignSize, alignSize);
            var curr = Runtime.alignMemory(type.flatSize, alignSize); // if necessary, place this on aligned memory
            type.flatSize = curr + size;
            if (prev >= 0) {
                diffs.push(curr - prev);
            }
            prev = curr;
            return curr;
        });
        if (type.name_ && type.name_[0] === '[') {
            // arrays have 2 elements, so we get the proper difference. then we scale here. that way we avoid
            // allocating a potentially huge array for [999999 x i8] etc.
            type.flatSize = parseInt(type.name_.substr(1)) * type.flatSize / 2;
        }
        type.flatSize = Runtime.alignMemory(type.flatSize, type.alignSize);
        if (diffs.length == 0) {
            type.flatFactor = type.flatSize;
        } else if (Runtime.dedup(diffs).length == 1) {
            type.flatFactor = diffs[0];
        }
        type.needsFlattening = (type.flatFactor != 1);
        return type.flatIndexes;
    },
    generateStructInfo: function (struct, typeName, offset) {
        var type, alignment;
        if (typeName) {
            offset = offset || 0;
            type = (typeof Types === 'undefined' ? Runtime.typeInfo : Types.types)[typeName];
            if (!type) return null;
            if (type.fields.length != struct.length) {
                printErr('Number of named fields must match the type for ' + typeName + ': possibly duplicate struct names. Cannot return structInfo');
                return null;
            }
            alignment = type.flatIndexes;
        } else {
            var type = {
                fields: struct.map(function (item) {
                    return item[0]
                })
            };
            alignment = Runtime.calculateStructAlignment(type);
        }
        var ret = {
            __size__: type.flatSize
        };
        if (typeName) {
            struct.forEach(function (item, i) {
                if (typeof item === 'string') {
                    ret[item] = alignment[i] + offset;
                } else {
                    // embedded struct
                    var key;
                    for (var k in item) key = k;
                    ret[key] = Runtime.generateStructInfo(item[key], type.fields[i], alignment[i]);
                }
            });
        } else {
            struct.forEach(function (item, i) {
                ret[item[1]] = alignment[i];
            });
        }
        return ret;
    },
    dynCall: function (sig, ptr, args) {
        if (args && args.length) {
            if (!args.splice) args = Array.prototype.slice.call(args);
            args.splice(0, 0, ptr);
            return Module['dynCall_' + sig].apply(null, args);
        } else {
            return Module['dynCall_' + sig].call(null, ptr);
        }
    },
    functionPointers: [],
    addFunction: function (func) {
        for (var i = 0; i < Runtime.functionPointers.length; i++) {
            if (!Runtime.functionPointers[i]) {
                Runtime.functionPointers[i] = func;
                return 2 * (1 + i);
            }
        }
        throw 'Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.';
    },
    removeFunction: function (index) {
        Runtime.functionPointers[(index - 2) / 2] = null;
    },
    getAsmConst: function (code, numArgs) {
        // code is a constant string on the heap, so we can cache these
        if (!Runtime.asmConstCache) Runtime.asmConstCache = {};
        var func = Runtime.asmConstCache[code];
        if (func) return func;
        var args = [];
        for (var i = 0; i < numArgs; i++) {
            args.push(String.fromCharCode(36) + i); // $0, $1 etc
        }
        code = Pointer_stringify(code);
        if (code[0] === '"') {
            // tolerate EM_ASM("..code..") even though EM_ASM(..code..) is correct
            if (code.indexOf('"', 1) === code.length - 1) {
                code = code.substr(1, code.length - 2);
            } else {
                // something invalid happened, e.g. EM_ASM("..code($0)..", input)
                abort('invalid EM_ASM input |' + code + '|. Please use EM_ASM(..code..) (no quotes) or EM_ASM({ ..code($0).. }, input) (to input values)');
            }
        }
        return Runtime.asmConstCache[code] = eval('(function(' + args.join(',') + '){ ' + code + ' })'); // new Function does not allow upvars in node
    },
    warnOnce: function (text) {
        if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
        if (!Runtime.warnOnce.shown[text]) {
            Runtime.warnOnce.shown[text] = 1;
            Module.printErr(text);
        }
    },
    funcWrappers: {},
    getFuncWrapper: function (func, sig) {
        assert(sig);
        if (!Runtime.funcWrappers[func]) {
            Runtime.funcWrappers[func] = function dynCall_wrapper() {
                return Runtime.dynCall(sig, func, arguments);
            };
        }
        return Runtime.funcWrappers[func];
    },
    UTF8Processor: function () {
        var buffer = [];
        var needed = 0;
        this.processCChar = function (code) {
            code = code & 0xFF;

            if (buffer.length == 0) {
                if ((code & 0x80) == 0x00) { // 0xxxxxxx
                    return String.fromCharCode(code);
                }
                buffer.push(code);
                if ((code & 0xE0) == 0xC0) { // 110xxxxx
                    needed = 1;
                } else if ((code & 0xF0) == 0xE0) { // 1110xxxx
                    needed = 2;
                } else { // 11110xxx
                    needed = 3;
                }
                return '';
            }

            if (needed) {
                buffer.push(code);
                needed--;
                if (needed > 0) return '';
            }

            var c1 = buffer[0];
            var c2 = buffer[1];
            var c3 = buffer[2];
            var c4 = buffer[3];
            var ret;
            if (buffer.length == 2) {
                ret = String.fromCharCode(((c1 & 0x1F) << 6) | (c2 & 0x3F));
            } else if (buffer.length == 3) {
                ret = String.fromCharCode(((c1 & 0x0F) << 12) | ((c2 & 0x3F) << 6) | (c3 & 0x3F));
            } else {
                // http://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
                var codePoint = ((c1 & 0x07) << 18) | ((c2 & 0x3F) << 12) |
                    ((c3 & 0x3F) << 6) | (c4 & 0x3F);
                ret = String.fromCharCode(
                    Math.floor((codePoint - 0x10000) / 0x400) + 0xD800, (codePoint - 0x10000) % 0x400 + 0xDC00);
            }
            buffer.length = 0;
            return ret;
        }
        this.processJSString = function processJSString(string) {
            string = unescape(encodeURIComponent(string));
            var ret = [];
            for (var i = 0; i < string.length; i++) {
                ret.push(string.charCodeAt(i));
            }
            return ret;
        }
    },
    getCompilerSetting: function (name) {
        throw 'You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work';
    },
    stackAlloc: function (size) {
        var ret = STACKTOP;
        STACKTOP = (STACKTOP + size) | 0;
        STACKTOP = (((STACKTOP) + 7) & -8);
        return ret;
    },
    staticAlloc: function (size) {
        var ret = STATICTOP;
        STATICTOP = (STATICTOP + size) | 0;
        STATICTOP = (((STATICTOP) + 7) & -8);
        return ret;
    },
    dynamicAlloc: function (size) {
        var ret = DYNAMICTOP;
        DYNAMICTOP = (DYNAMICTOP + size) | 0;
        DYNAMICTOP = (((DYNAMICTOP) + 7) & -8);
        if (DYNAMICTOP >= TOTAL_MEMORY) enlargeMemory();;
        return ret;
    },
    alignMemory: function (size, quantum) {
        var ret = size = Math.ceil((size) / (quantum ? quantum : 8)) * (quantum ? quantum : 8);
        return ret;
    },
    makeBigInt: function (low, high, unsigned) {
        var ret = (unsigned ? ((+((low >>> 0))) + ((+((high >>> 0))) * (+4294967296))) : ((+((low >>> 0))) + ((+((high | 0))) * (+4294967296))));
        return ret;
    },
    GLOBAL_BASE: 8,
    QUANTUM_SIZE: 4,
    __dummy__: 0
}


Module['Runtime'] = Runtime;




//========================================
// Runtime essentials
//========================================

var __THREW__ = 0; // Used in checking for thrown exceptions.

var ABORT = false; // whether we are quitting the application. no code should run after this. set in exit() and abort()
var EXITSTATUS = 0;

var undef = 0;
// tempInt is used for 32-bit signed values or smaller. tempBigInt is used
// for 32-bit unsigned values or more than 32 bits. TODO: audit all uses of tempInt
var tempValue, tempInt, tempBigInt, tempInt2, tempBigInt2, tempPair, tempBigIntI, tempBigIntR, tempBigIntS, tempBigIntP, tempBigIntD, tempDouble, tempFloat;
var tempI64, tempI64b;
var tempRet0, tempRet1, tempRet2, tempRet3, tempRet4, tempRet5, tempRet6, tempRet7, tempRet8, tempRet9;

function assert(condition, text) {
    if (!condition) {
        abort('Assertion failed: ' + text);
    }
}

var globalScope = this;

// C calling interface. A convenient way to call C functions (in C files, or
// defined with extern "C").
//
// Note: LLVM optimizations can inline and remove functions, after which you will not be
//       able to call them. Closure can also do so. To avoid that, add your function to
//       the exports using something like
//
//         -s EXPORTED_FUNCTIONS='["_main", "_myfunc"]'
//
// @param ident      The name of the C function (note that C++ functions will be name-mangled - use extern "C")
// @param returnType The return type of the function, one of the JS types 'number', 'string' or 'array' (use 'number' for any C pointer, and
//                   'array' for JavaScript arrays and typed arrays; note that arrays are 8-bit).
// @param argTypes   An array of the types of arguments for the function (if there are no arguments, this can be ommitted). Types are as in returnType,
//                   except that 'array' is not possible (there is no way for us to know the length of the array)
// @param args       An array of the arguments to the function, as native JS values (as in returnType)
//                   Note that string arguments will be stored on the stack (the JS string will become a C string on the stack).
// @return           The return value, as a native JS value (as in returnType)
function ccall(ident, returnType, argTypes, args) {
    return ccallFunc(getCFunc(ident), returnType, argTypes, args);
}
Module["ccall"] = ccall;

// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
    try {
        var func = Module['_' + ident]; // closure exported function
        if (!func) func = eval('_' + ident); // explicit lookup
    } catch (e) {}
    assert(func, 'Cannot call unknown function ' + ident + ' (perhaps LLVM optimizations or closure removed it?)');
    return func;
}

// Internal function that does a C call using a function, not an identifier
function ccallFunc(func, returnType, argTypes, args) {
    var stack = 0;

    function toC(value, type) {
        if (type == 'string') {
            if (value === null || value === undefined || value === 0) return 0; // null string
            value = intArrayFromString(value);
            type = 'array';
        }
        if (type == 'array') {
            if (!stack) stack = Runtime.stackSave();
            var ret = Runtime.stackAlloc(value.length);
            writeArrayToMemory(value, ret);
            return ret;
        }
        return value;
    }

    function fromC(value, type) {
        if (type == 'string') {
            return Pointer_stringify(value);
        }
        assert(type != 'array');
        return value;
    }
    var i = 0;
    var cArgs = args ? args.map(function (arg) {
        return toC(arg, argTypes[i++]);
    }) : [];
    var ret = fromC(func.apply(null, cArgs), returnType);
    if (stack) Runtime.stackRestore(stack);
    return ret;
}

// Returns a native JS wrapper for a C function. This is similar to ccall, but
// returns a function you can call repeatedly in a normal way. For example:
//
//   var my_function = cwrap('my_c_function', 'number', ['number', 'number']);
//   alert(my_function(5, 22));
//   alert(my_function(99, 12));
//
function cwrap(ident, returnType, argTypes) {
    var func = getCFunc(ident);
    return function () {
        return ccallFunc(func, returnType, argTypes, Array.prototype.slice.call(arguments));
    }
}
Module["cwrap"] = cwrap;

// Sets a value in memory in a dynamic way at run-time. Uses the
// type data. This is the same as makeSetValue, except that
// makeSetValue is done at compile-time and generates the needed
// code then, whereas this function picks the right code at
// run-time.
// Note that setValue and getValue only do *aligned* writes and reads!
// Note that ccall uses JS types as for defining types, while setValue and
// getValue need LLVM types ('i8', 'i32') - this is a lower-level operation
function setValue(ptr, value, type, noSafe) {
    type = type || 'i8';
    if (type.charAt(type.length - 1) === '*') type = 'i32'; // pointers are 32-bit
    switch (type) {
    case 'i1':
        HEAP8[(ptr)] = value;
        break;
    case 'i8':
        HEAP8[(ptr)] = value;
        break;
    case 'i16':
        HEAP16[((ptr) >> 1)] = value;
        break;
    case 'i32':
        HEAP32[((ptr) >> 2)] = value;
        break;
    case 'i64':
        (tempI64 = [value >>> 0, (tempDouble = value, (+(Math_abs(tempDouble))) >= (+1) ? (tempDouble > (+0) ? ((Math_min((+(Math_floor((tempDouble) / (+4294967296)))), (+4294967295))) | 0) >>> 0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble))) >>> 0)) / (+4294967296)))))) >>> 0) : 0)], HEAP32[((ptr) >> 2)] = tempI64[0], HEAP32[(((ptr) + (4)) >> 2)] = tempI64[1]);
        break;
    case 'float':
        HEAPF32[((ptr) >> 2)] = value;
        break;
    case 'double':
        HEAPF64[((ptr) >> 3)] = value;
        break;
    default:
        abort('invalid type for setValue: ' + type);
    }
}
Module['setValue'] = setValue;

// Parallel to setValue.
function getValue(ptr, type, noSafe) {
    type = type || 'i8';
    if (type.charAt(type.length - 1) === '*') type = 'i32'; // pointers are 32-bit
    switch (type) {
    case 'i1':
        return HEAP8[(ptr)];
    case 'i8':
        return HEAP8[(ptr)];
    case 'i16':
        return HEAP16[((ptr) >> 1)];
    case 'i32':
        return HEAP32[((ptr) >> 2)];
    case 'i64':
        return HEAP32[((ptr) >> 2)];
    case 'float':
        return HEAPF32[((ptr) >> 2)];
    case 'double':
        return HEAPF64[((ptr) >> 3)];
    default:
        abort('invalid type for setValue: ' + type);
    }
    return null;
}
Module['getValue'] = getValue;

var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_DYNAMIC = 3; // Cannot be freed except through sbrk
var ALLOC_NONE = 4; // Do not allocate
Module['ALLOC_NORMAL'] = ALLOC_NORMAL;
Module['ALLOC_STACK'] = ALLOC_STACK;
Module['ALLOC_STATIC'] = ALLOC_STATIC;
Module['ALLOC_DYNAMIC'] = ALLOC_DYNAMIC;
Module['ALLOC_NONE'] = ALLOC_NONE;

// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
function allocate(slab, types, allocator, ptr) {
    var zeroinit, size;
    if (typeof slab === 'number') {
        zeroinit = true;
        size = slab;
    } else {
        zeroinit = false;
        size = slab.length;
    }

    var singleType = typeof types === 'string' ? types : null;

    var ret;
    if (allocator == ALLOC_NONE) {
        ret = ptr;
    } else {
        ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc, Runtime.dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
    }

    if (zeroinit) {
        var ptr = ret,
            stop;
        assert((ret & 3) == 0);
        stop = ret + (size & ~3);
        for (; ptr < stop; ptr += 4) {
            HEAP32[((ptr) >> 2)] = 0;
        }
        stop = ret + size;
        while (ptr < stop) {
            HEAP8[((ptr++) | 0)] = 0;
        }
        return ret;
    }

    if (singleType === 'i8') {
        if (slab.subarray || slab.slice) {
            HEAPU8.set(slab, ret);
        } else {
            HEAPU8.set(new Uint8Array(slab), ret);
        }
        return ret;
    }

    var i = 0,
        type, typeSize, previousType;
    while (i < size) {
        var curr = slab[i];

        if (typeof curr === 'function') {
            curr = Runtime.getFunctionIndex(curr);
        }

        type = singleType || types[i];
        if (type === 0) {
            i++;
            continue;
        }

        if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later

        setValue(ret + i, curr, type);

        // no need to look up size unless type changes, so cache it
        if (previousType !== type) {
            typeSize = Runtime.getNativeTypeSize(type);
            previousType = type;
        }
        i += typeSize;
    }

    return ret;
}
Module['allocate'] = allocate;

function Pointer_stringify(ptr, /* optional */ length) {
    // TODO: use TextDecoder
    // Find the length, and check for UTF while doing so
    var hasUtf = false;
    var t;
    var i = 0;
    while (1) {
        t = HEAPU8[(((ptr) + (i)) | 0)];
        if (t >= 128) hasUtf = true;
        else if (t == 0 && !length) break;
        i++;
        if (length && i == length) break;
    }
    if (!length) length = i;

    var ret = '';

    if (!hasUtf) {
        var MAX_CHUNK = 1024; // split up into chunks, because .apply on a huge string can overflow the stack
        var curr;
        while (length > 0) {
            curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
            ret = ret ? ret + curr : curr;
            ptr += MAX_CHUNK;
            length -= MAX_CHUNK;
        }
        return ret;
    }

    var utf8 = new Runtime.UTF8Processor();
    for (i = 0; i < length; i++) {
        t = HEAPU8[(((ptr) + (i)) | 0)];
        ret += utf8.processCChar(t);
    }
    return ret;
}
Module['Pointer_stringify'] = Pointer_stringify;

// Given a pointer 'ptr' to a null-terminated UTF16LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.
function UTF16ToString(ptr) {
    var i = 0;

    var str = '';
    while (1) {
        var codeUnit = HEAP16[(((ptr) + (i * 2)) >> 1)];
        if (codeUnit == 0)
            return str;
        ++i;
        // fromCharCode constructs a character from a UTF-16 code unit, so we can pass the UTF16 string right through.
        str += String.fromCharCode(codeUnit);
    }
}
Module['UTF16ToString'] = UTF16ToString;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF16LE form. The copy will require at most (str.length*2+1)*2 bytes of space in the HEAP.
function stringToUTF16(str, outPtr) {
    for (var i = 0; i < str.length; ++i) {
        // charCodeAt returns a UTF-16 encoded code unit, so it can be directly written to the HEAP.
        var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
        HEAP16[(((outPtr) + (i * 2)) >> 1)] = codeUnit;
    }
    // Null-terminate the pointer to the HEAP.
    HEAP16[(((outPtr) + (str.length * 2)) >> 1)] = 0;
}
Module['stringToUTF16'] = stringToUTF16;

// Given a pointer 'ptr' to a null-terminated UTF32LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.
function UTF32ToString(ptr) {
    var i = 0;

    var str = '';
    while (1) {
        var utf32 = HEAP32[(((ptr) + (i * 4)) >> 2)];
        if (utf32 == 0)
            return str;
        ++i;
        // Gotcha: fromCharCode constructs a character from a UTF-16 encoded code (pair), not from a Unicode code point! So encode the code point to UTF-16 for constructing.
        if (utf32 >= 0x10000) {
            var ch = utf32 - 0x10000;
            str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
        } else {
            str += String.fromCharCode(utf32);
        }
    }
}
Module['UTF32ToString'] = UTF32ToString;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF32LE form. The copy will require at most (str.length+1)*4 bytes of space in the HEAP,
// but can use less, since str.length does not return the number of characters in the string, but the number of UTF-16 code units in the string.
function stringToUTF32(str, outPtr) {
    var iChar = 0;
    for (var iCodeUnit = 0; iCodeUnit < str.length; ++iCodeUnit) {
        // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
        var codeUnit = str.charCodeAt(iCodeUnit); // possibly a lead surrogate
        if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) {
            var trailSurrogate = str.charCodeAt(++iCodeUnit);
            codeUnit = 0x10000 + ((codeUnit & 0x3FF) << 10) | (trailSurrogate & 0x3FF);
        }
        HEAP32[(((outPtr) + (iChar * 4)) >> 2)] = codeUnit;
        ++iChar;
    }
    // Null-terminate the pointer to the HEAP.
    HEAP32[(((outPtr) + (iChar * 4)) >> 2)] = 0;
}
Module['stringToUTF32'] = stringToUTF32;

function demangle(func) {
    var i = 3;
    // params, etc.
    var basicTypes = {
        'v': 'void',
        'b': 'bool',
        'c': 'char',
        's': 'short',
        'i': 'int',
        'l': 'long',
        'f': 'float',
        'd': 'double',
        'w': 'wchar_t',
        'a': 'signed char',
        'h': 'unsigned char',
        't': 'unsigned short',
        'j': 'unsigned int',
        'm': 'unsigned long',
        'x': 'long long',
        'y': 'unsigned long long',
        'z': '...'
    };
    var subs = [];
    var first = true;

    function dump(x) {
        //return;
        if (x) Module.print(x);
        Module.print(func);
        var pre = '';
        for (var a = 0; a < i; a++) pre += ' ';
        Module.print(pre + '^');
    }

    function parseNested() {
        i++;
        if (func[i] === 'K') i++; // ignore const
        var parts = [];
        while (func[i] !== 'E') {
            if (func[i] === 'S') { // substitution
                i++;
                var next = func.indexOf('_', i);
                var num = func.substring(i, next) || 0;
                parts.push(subs[num] || '?');
                i = next + 1;
                continue;
            }
            if (func[i] === 'C') { // constructor
                parts.push(parts[parts.length - 1]);
                i += 2;
                continue;
            }
            var size = parseInt(func.substr(i));
            var pre = size.toString().length;
            if (!size || !pre) {
                i--;
                break;
            } // counter i++ below us
            var curr = func.substr(i + pre, size);
            parts.push(curr);
            subs.push(curr);
            i += pre + size;
        }
        i++; // skip E
        return parts;
    }

    function parse(rawList, limit, allowVoid) { // main parser
        limit = limit || Infinity;
        var ret = '',
            list = [];

        function flushList() {
            return '(' + list.join(', ') + ')';
        }
        var name;
        if (func[i] === 'N') {
            // namespaced N-E
            name = parseNested().join('::');
            limit--;
            if (limit === 0) return rawList ? [name] : name;
        } else {
            // not namespaced
            if (func[i] === 'K' || (first && func[i] === 'L')) i++; // ignore const and first 'L'
            var size = parseInt(func.substr(i));
            if (size) {
                var pre = size.toString().length;
                name = func.substr(i + pre, size);
                i += pre + size;
            }
        }
        first = false;
        if (func[i] === 'I') {
            i++;
            var iList = parse(true);
            var iRet = parse(true, 1, true);
            ret += iRet[0] + ' ' + name + '<' + iList.join(', ') + '>';
        } else {
            ret = name;
        }
        paramLoop: while (i < func.length && limit-- > 0) {
            //dump('paramLoop');
            var c = func[i++];
            if (c in basicTypes) {
                list.push(basicTypes[c]);
            } else {
                switch (c) {
                case 'P':
                    list.push(parse(true, 1, true)[0] + '*');
                    break; // pointer
                case 'R':
                    list.push(parse(true, 1, true)[0] + '&');
                    break; // reference
                case 'L':
                    { // literal
                        i++; // skip basic type
                        var end = func.indexOf('E', i);
                        var size = end - i;
                        list.push(func.substr(i, size));
                        i += size + 2; // size + 'EE'
                        break;
                    }
                case 'A':
                    { // array
                        var size = parseInt(func.substr(i));
                        i += size.toString().length;
                        if (func[i] !== '_') throw '?';
                        i++; // skip _
                        list.push(parse(true, 1, true)[0] + ' [' + size + ']');
                        break;
                    }
                case 'E':
                    break paramLoop;
                default:
                    ret += '?' + c;
                    break paramLoop;
                }
            }
        }
        if (!allowVoid && list.length === 1 && list[0] === 'void') list = []; // avoid (void)
        return rawList ? list : ret + flushList();
    }
    try {
        // Special-case the entry point, since its name differs from other name mangling.
        if (func == 'Object._main' || func == '_main') {
            return 'main()';
        }
        if (typeof func === 'number') func = Pointer_stringify(func);
        if (func[0] !== '_') return func;
        if (func[1] !== '_') return func; // C function
        if (func[2] !== 'Z') return func;
        switch (func[3]) {
        case 'n':
            return 'operator new()';
        case 'd':
            return 'operator delete()';
        }
        return parse();
    } catch (e) {
        return func;
    }
}

function demangleAll(text) {
    return text.replace(/__Z[\w\d_]+/g, function (x) {
        var y = demangle(x);
        return x === y ? x : (x + ' [' + y + ']')
    });
}

function stackTrace() {
    var stack = new Error().stack;
    return stack ? demangleAll(stack) : '(no stack trace available)'; // Stack trace is not available at least on IE10 and Safari 6.
}

// Memory management

var PAGE_SIZE = 4096;

function alignMemoryPage(x) {
    return (x + 4095) & -4096;
}

var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;

var STATIC_BASE = 0,
    STATICTOP = 0,
    staticSealed = false; // static area
var STACK_BASE = 0,
    STACKTOP = 0,
    STACK_MAX = 0; // stack area
var DYNAMIC_BASE = 0,
    DYNAMICTOP = 0; // dynamic area handled by sbrk

function enlargeMemory() {
    abort('Cannot enlarge memory arrays. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value ' + TOTAL_MEMORY + ', (2) compile with ALLOW_MEMORY_GROWTH which adjusts the size at runtime but prevents some optimizations, or (3) set Module.TOTAL_MEMORY before the program runs.');
}

var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 16777216;
var FAST_MEMORY = Module['FAST_MEMORY'] || 2097152;

var totalMemory = 4096;
while (totalMemory < TOTAL_MEMORY || totalMemory < 2 * TOTAL_STACK) {
    if (totalMemory < 16 * 1024 * 1024) {
        totalMemory *= 2;
    } else {
        totalMemory += 16 * 1024 * 1024
    }
}
if (totalMemory !== TOTAL_MEMORY) {
    Module.printErr('increasing TOTAL_MEMORY to ' + totalMemory + ' to be more reasonable');
    TOTAL_MEMORY = totalMemory;
}

// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(typeof Int32Array !== 'undefined' && typeof Float64Array !== 'undefined' && !!(new Int32Array(1)['subarray']) && !!(new Int32Array(1)['set']),
    'JS engine does not provide full typed array support');

var buffer = new ArrayBuffer(TOTAL_MEMORY);
HEAP8 = new Int8Array(buffer);
HEAP16 = new Int16Array(buffer);
HEAP32 = new Int32Array(buffer);
HEAPU8 = new Uint8Array(buffer);
HEAPU16 = new Uint16Array(buffer);
HEAPU32 = new Uint32Array(buffer);
HEAPF32 = new Float32Array(buffer);
HEAPF64 = new Float64Array(buffer);

// Endianness check (note: assumes compiler arch was little-endian)
HEAP32[0] = 255;
assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, 'Typed arrays 2 must be run on a little-endian system');

Module['HEAP'] = HEAP;
Module['HEAP8'] = HEAP8;
Module['HEAP16'] = HEAP16;
Module['HEAP32'] = HEAP32;
Module['HEAPU8'] = HEAPU8;
Module['HEAPU16'] = HEAPU16;
Module['HEAPU32'] = HEAPU32;
Module['HEAPF32'] = HEAPF32;
Module['HEAPF64'] = HEAPF64;

function callRuntimeCallbacks(callbacks) {
    while (callbacks.length > 0) {
        var callback = callbacks.shift();
        if (typeof callback == 'function') {
            callback();
            continue;
        }
        var func = callback.func;
        if (typeof func === 'number') {
            if (callback.arg === undefined) {
                Runtime.dynCall('v', func);
            } else {
                Runtime.dynCall('vi', func, [callback.arg]);
            }
        } else {
            func(callback.arg === undefined ? null : callback.arg);
        }
    }
}

var __ATPRERUN__ = []; // functions called before the runtime is initialized
var __ATINIT__ = []; // functions called during startup
var __ATMAIN__ = []; // functions called when main() is to be run
var __ATEXIT__ = []; // functions called during shutdown
var __ATPOSTRUN__ = []; // functions called after the runtime has exited

var runtimeInitialized = false;

function preRun() {
    // compatibility - merge in anything from Module['preRun'] at this time
    if (Module['preRun']) {
        if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
        while (Module['preRun'].length) {
            addOnPreRun(Module['preRun'].shift());
        }
    }
    callRuntimeCallbacks(__ATPRERUN__);
}

function ensureInitRuntime() {
    if (runtimeInitialized) return;
    runtimeInitialized = true;
    callRuntimeCallbacks(__ATINIT__);
}

function preMain() {
    callRuntimeCallbacks(__ATMAIN__);
}

function exitRuntime() {
    callRuntimeCallbacks(__ATEXIT__);
}

function postRun() {
    // compatibility - merge in anything from Module['postRun'] at this time
    if (Module['postRun']) {
        if (typeof Module['postRun'] == 'function') Module['postRun'] = [Module['postRun']];
        while (Module['postRun'].length) {
            addOnPostRun(Module['postRun'].shift());
        }
    }
    callRuntimeCallbacks(__ATPOSTRUN__);
}

function addOnPreRun(cb) {
    __ATPRERUN__.unshift(cb);
}
Module['addOnPreRun'] = Module.addOnPreRun = addOnPreRun;

function addOnInit(cb) {
    __ATINIT__.unshift(cb);
}
Module['addOnInit'] = Module.addOnInit = addOnInit;

function addOnPreMain(cb) {
    __ATMAIN__.unshift(cb);
}
Module['addOnPreMain'] = Module.addOnPreMain = addOnPreMain;

function addOnExit(cb) {
    __ATEXIT__.unshift(cb);
}
Module['addOnExit'] = Module.addOnExit = addOnExit;

function addOnPostRun(cb) {
    __ATPOSTRUN__.unshift(cb);
}
Module['addOnPostRun'] = Module.addOnPostRun = addOnPostRun;

// Tools

// This processes a JS string into a C-line array of numbers, 0-terminated.
// For LLVM-originating strings, see parser.js:parseLLVMString function
function intArrayFromString(stringy, dontAddNull, length /* optional */ ) {
    var ret = (new Runtime.UTF8Processor()).processJSString(stringy);
    if (length) {
        ret.length = length;
    }
    if (!dontAddNull) {
        ret.push(0);
    }
    return ret;
}
Module['intArrayFromString'] = intArrayFromString;

function intArrayToString(array) {
    var ret = [];
    for (var i = 0; i < array.length; i++) {
        var chr = array[i];
        if (chr > 0xFF) {
            chr &= 0xFF;
        }
        ret.push(String.fromCharCode(chr));
    }
    return ret.join('');
}
Module['intArrayToString'] = intArrayToString;

// Write a Javascript array to somewhere in the heap
function writeStringToMemory(string, buffer, dontAddNull) {
    var array = intArrayFromString(string, dontAddNull);
    var i = 0;
    while (i < array.length) {
        var chr = array[i];
        HEAP8[(((buffer) + (i)) | 0)] = chr;
        i = i + 1;
    }
}
Module['writeStringToMemory'] = writeStringToMemory;

function writeArrayToMemory(array, buffer) {
    for (var i = 0; i < array.length; i++) {
        HEAP8[(((buffer) + (i)) | 0)] = array[i];
    }
}
Module['writeArrayToMemory'] = writeArrayToMemory;

function writeAsciiToMemory(str, buffer, dontAddNull) {
    for (var i = 0; i < str.length; i++) {
        HEAP8[(((buffer) + (i)) | 0)] = str.charCodeAt(i);
    }
    if (!dontAddNull) HEAP8[(((buffer) + (str.length)) | 0)] = 0;
}
Module['writeAsciiToMemory'] = writeAsciiToMemory;

function unSign(value, bits, ignore) {
    if (value >= 0) {
        return value;
    }
    return bits <= 32 ? 2 * Math.abs(1 << (bits - 1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
        : Math.pow(2, bits) + value;
}

function reSign(value, bits, ignore) {
    if (value <= 0) {
        return value;
    }
    var half = bits <= 32 ? Math.abs(1 << (bits - 1)) // abs is needed if bits == 32
        : Math.pow(2, bits - 1);
    if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
        // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
        // TODO: In i64 mode 1, resign the two parts separately and safely
        value = -2 * half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
    }
    return value;
}

// check for imul support, and also for correctness ( https://bugs.webkit.org/show_bug.cgi?id=126345 )
if (!Math['imul'] || Math['imul'](0xffffffff, 5) !== -5) Math['imul'] = function imul(a, b) {
    var ah = a >>> 16;
    var al = a & 0xffff;
    var bh = b >>> 16;
    var bl = b & 0xffff;
    return (al * bl + ((ah * bl + al * bh) << 16)) | 0;
};
Math.imul = Math['imul'];


var Math_abs = Math.abs;
var Math_cos = Math.cos;
var Math_sin = Math.sin;
var Math_tan = Math.tan;
var Math_acos = Math.acos;
var Math_asin = Math.asin;
var Math_atan = Math.atan;
var Math_atan2 = Math.atan2;
var Math_exp = Math.exp;
var Math_log = Math.log;
var Math_sqrt = Math.sqrt;
var Math_ceil = Math.ceil;
var Math_floor = Math.floor;
var Math_pow = Math.pow;
var Math_imul = Math.imul;
var Math_fround = Math.fround;
var Math_min = Math.min;

// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyWatcher = null;
var dependenciesFulfilled = null; // overridden to take different actions when all run dependencies are fulfilled

function addRunDependency(id) {
    runDependencies++;
    if (Module['monitorRunDependencies']) {
        Module['monitorRunDependencies'](runDependencies);
    }
}
Module['addRunDependency'] = addRunDependency;

function removeRunDependency(id) {
    runDependencies--;
    if (Module['monitorRunDependencies']) {
        Module['monitorRunDependencies'](runDependencies);
    }
    if (runDependencies == 0) {
        if (runDependencyWatcher !== null) {
            clearInterval(runDependencyWatcher);
            runDependencyWatcher = null;
        }
        if (dependenciesFulfilled) {
            var callback = dependenciesFulfilled;
            dependenciesFulfilled = null;
            callback(); // can add another dependenciesFulfilled
        }
    }
}
Module['removeRunDependency'] = removeRunDependency;

Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data


var memoryInitializer = null;

// === Body ===
var __ZTVN10__cxxabiv117__class_type_infoE = 15392;
var __ZTVN10__cxxabiv120__si_class_type_infoE = 15432;




STATIC_BASE = 8;

STATICTOP = STATIC_BASE + Runtime.alignMemory(16259);
/* global initializers */
__ATINIT__.push({
    func: function () {
        __GLOBAL__I_a()
    }
}, {
    func: function () {
        __GLOBAL__I_a18()
    }
});


/* memory initializer */
allocate([], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE);
/* memory initializer */
allocate([144, 14, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 4, 0, 0, 0, 1, 0, 0, 0, 3, 0, 0, 0, 2, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 49, 95, 95, 115, 116, 100, 111, 117, 116, 98, 117, 102, 73, 119, 69, 69, 0, 0, 0, 0, 0, 0, 0, 0, 80, 60, 0, 0, 112, 14, 0, 0, 192, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248, 14, 0, 0, 3, 0, 0, 0, 4, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 5, 0, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, 6, 0, 0, 0, 7, 0, 0, 0, 3, 0, 0, 0, 4, 0, 0, 0, 4, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 48, 95, 95, 115, 116, 100, 105, 110, 98, 117, 102, 73, 119, 69, 69, 0, 80, 60, 0, 0, 224, 14, 0, 0, 192, 20, 0, 0, 0, 0, 0, 0, 117, 110, 115, 117, 112, 112, 111, 114, 116, 101, 100, 32, 108, 111, 99, 97, 108, 101, 32, 102, 111, 114, 32, 115, 116, 97, 110, 100, 97, 114, 100, 32, 105, 110, 112, 117, 116, 0, 0, 0, 0, 0, 0, 0, 144, 15, 0, 0, 5, 0, 0, 0, 6, 0, 0, 0, 3, 0, 0, 0, 5, 0, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, 8, 0, 0, 0, 9, 0, 0, 0, 6, 0, 0, 0, 10, 0, 0, 0, 11, 0, 0, 0, 5, 0, 0, 0, 7, 0, 0, 0, 6, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 49, 95, 95, 115, 116, 100, 111, 117, 116, 98, 117, 102, 73, 99, 69, 69, 0, 0, 0, 0, 0, 0, 0, 0, 80, 60, 0, 0, 112, 15, 0, 0, 128, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248, 15, 0, 0, 7, 0, 0, 0, 8, 0, 0, 0, 4, 0, 0, 0, 5, 0, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, 12, 0, 0, 0, 9, 0, 0, 0, 6, 0, 0, 0, 13, 0, 0, 0, 14, 0, 0, 0, 7, 0, 0, 0, 8, 0, 0, 0, 8, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 48, 95, 95, 115, 116, 100, 105, 110, 98, 117, 102, 73, 99, 69, 69, 0, 80, 60, 0, 0, 224, 15, 0, 0, 128, 20, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 52, 95, 95, 115, 104, 97, 114, 101, 100, 95, 99, 111, 117, 110, 116, 69, 0, 0, 0, 0, 0, 0, 0, 0, 40, 60, 0, 0, 8, 16, 0, 0, 0, 0, 0, 0, 112, 16, 0, 0, 9, 0, 0, 0, 10, 0, 0, 0, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 216, 16, 0, 0, 11, 0, 0, 0, 12, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 83, 116, 49, 49, 108, 111, 103, 105, 99, 95, 101, 114, 114, 111, 114, 0, 80, 60, 0, 0, 96, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 176, 16, 0, 0, 9, 0, 0, 0, 13, 0, 0, 0, 15, 0, 0, 0, 0, 0, 0, 0, 83, 116, 49, 50, 108, 101, 110, 103, 116, 104, 95, 101, 114, 114, 111, 114, 0, 0, 0, 0, 0, 0, 0, 0, 80, 60, 0, 0, 152, 16, 0, 0, 112, 16, 0, 0, 0, 0, 0, 0, 83, 116, 49, 51, 114, 117, 110, 116, 105, 109, 101, 95, 101, 114, 114, 111, 114, 0, 0, 0, 0, 0, 0, 0, 80, 60, 0, 0, 192, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 58, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 17, 0, 0, 14, 0, 0, 0, 15, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 50, 115, 121, 115, 116, 101, 109, 95, 101, 114, 114, 111, 114, 69, 0, 0, 80, 60, 0, 0, 8, 17, 0, 0, 216, 16, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 52, 101, 114, 114, 111, 114, 95, 99, 97, 116, 101, 103, 111, 114, 121, 69, 0, 0, 0, 0, 0, 0, 0, 0, 40, 60, 0, 0, 48, 17, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 50, 95, 95, 100, 111, 95, 109, 101, 115, 115, 97, 103, 101, 69, 0, 0, 80, 60, 0, 0, 88, 17, 0, 0, 80, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 98, 97, 115, 105, 99, 95, 115, 116, 114, 105, 110, 103, 0, 0, 0, 0, 0, 0, 0, 0, 128, 20, 0, 0, 16, 0, 0, 0, 17, 0, 0, 0, 5, 0, 0, 0, 5, 0, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, 12, 0, 0, 0, 9, 0, 0, 0, 6, 0, 0, 0, 10, 0, 0, 0, 11, 0, 0, 0, 5, 0, 0, 0, 8, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 192, 20, 0, 0, 18, 0, 0, 0, 19, 0, 0, 0, 6, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 5, 0, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 4, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 0, 4, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 248, 20, 0, 0, 20, 0, 0, 0, 21, 0, 0, 0, 248, 255, 255, 255, 248, 255, 255, 255, 248, 20, 0, 0, 22, 0, 0, 0, 23, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 64, 21, 0, 0, 24, 0, 0, 0, 25, 0, 0, 0, 248, 255, 255, 255, 248, 255, 255, 255, 64, 21, 0, 0, 26, 0, 0, 0, 27, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 136, 21, 0, 0, 28, 0, 0, 0, 29, 0, 0, 0, 252, 255, 255, 255, 252, 255, 255, 255, 136, 21, 0, 0, 30, 0, 0, 0, 31, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 208, 21, 0, 0, 32, 0, 0, 0, 33, 0, 0, 0, 252, 255, 255, 255, 252, 255, 255, 255, 208, 21, 0, 0, 34, 0, 0, 0, 35, 0, 0, 0, 105, 111, 115, 116, 114, 101, 97, 109, 0, 0, 0, 0, 0, 0, 0, 0, 117, 110, 115, 112, 101, 99, 105, 102, 105, 101, 100, 32, 105, 111, 115, 116, 114, 101, 97, 109, 95, 99, 97, 116, 101, 103, 111, 114, 121, 32, 101, 114, 114, 111, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 152, 19, 0, 0, 36, 0, 0, 0, 37, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 19, 0, 0, 38, 0, 0, 0, 39, 0, 0, 0, 105, 111, 115, 95, 98, 97, 115, 101, 58, 58, 99, 108, 101, 97, 114, 0, 78, 83, 116, 51, 95, 95, 49, 56, 105, 111, 115, 95, 98, 97, 115, 101, 55, 102, 97, 105, 108, 117, 114, 101, 69, 0, 0, 0, 0, 0, 0, 0, 80, 60, 0, 0, 120, 19, 0, 0, 32, 17, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 56, 105, 111, 115, 95, 98, 97, 115, 101, 69, 0, 0, 0, 0, 0, 0, 0, 40, 60, 0, 0, 168, 19, 0, 0, 78, 83, 116, 51, 95, 95, 49, 57, 98, 97, 115, 105, 99, 95, 105, 111, 115, 73, 99, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 99, 69, 69, 69, 69, 0, 0, 0, 0, 0, 0, 0, 80, 60, 0, 0, 200, 19, 0, 0, 192, 19, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 57, 98, 97, 115, 105, 99, 95, 105, 111, 115, 73, 119, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 119, 69, 69, 69, 69, 0, 0, 0, 0, 0, 0, 0, 80, 60, 0, 0, 8, 20, 0, 0, 192, 19, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 53, 98, 97, 115, 105, 99, 95, 115, 116, 114, 101, 97, 109, 98, 117, 102, 73, 99, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 99, 69, 69, 69, 69, 0, 0, 0, 0, 0, 0, 0, 0, 40, 60, 0, 0, 72, 20, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 53, 98, 97, 115, 105, 99, 95, 115, 116, 114, 101, 97, 109, 98, 117, 102, 73, 119, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 119, 69, 69, 69, 69, 0, 0, 0, 0, 0, 0, 0, 0, 40, 60, 0, 0, 136, 20, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 51, 98, 97, 115, 105, 99, 95, 105, 115, 116, 114, 101, 97, 109, 73, 99, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 99, 69, 69, 69, 69, 0, 0, 176, 60, 0, 0, 200, 20, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 248, 19, 0, 0, 3, 244, 255, 255, 78, 83, 116, 51, 95, 95, 49, 49, 51, 98, 97, 115, 105, 99, 95, 105, 115, 116, 114, 101, 97, 109, 73, 119, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 119, 69, 69, 69, 69, 0, 0, 176, 60, 0, 0, 16, 21, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 56, 20, 0, 0, 3, 244, 255, 255, 78, 83, 116, 51, 95, 95, 49, 49, 51, 98, 97, 115, 105, 99, 95, 111, 115, 116, 114, 101, 97, 109, 73, 99, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 99, 69, 69, 69, 69, 0, 0, 176, 60, 0, 0, 88, 21, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 248, 19, 0, 0, 3, 244, 255, 255, 78, 83, 116, 51, 95, 95, 49, 49, 51, 98, 97, 115, 105, 99, 95, 111, 115, 116, 114, 101, 97, 109, 73, 119, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 119, 69, 69, 69, 69, 0, 0, 176, 60, 0, 0, 160, 21, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 56, 20, 0, 0, 3, 244, 255, 255, 0, 0, 0, 0, 48, 22, 0, 0, 40, 0, 0, 0, 41, 0, 0, 0, 17, 0, 0, 0, 1, 0, 0, 0, 9, 0, 0, 0, 10, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 57, 95, 95, 105, 111, 115, 116, 114, 101, 97, 109, 95, 99, 97, 116, 101, 103, 111, 114, 121, 69, 0, 0, 0, 80, 60, 0, 0, 16, 22, 0, 0, 112, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 88, 36, 0, 0, 42, 0, 0, 0, 43, 0, 0, 0, 44, 0, 0, 0, 1, 0, 0, 0, 3, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 36, 0, 0, 45, 0, 0, 0, 46, 0, 0, 0, 44, 0, 0, 0, 2, 0, 0, 0, 4, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 41, 0, 0, 47, 0, 0, 0, 48, 0, 0, 0, 44, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 4, 0, 0, 0, 5, 0, 0, 0, 6, 0, 0, 0, 7, 0, 0, 0, 8, 0, 0, 0, 9, 0, 0, 0, 10, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 65, 66, 67, 68, 69, 70, 120, 88, 43, 45, 112, 80, 105, 73, 110, 78, 0, 0, 0, 0, 0, 0, 0, 0, 37, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 200, 41, 0, 0, 49, 0, 0, 0, 50, 0, 0, 0, 44, 0, 0, 0, 12, 0, 0, 0, 13, 0, 0, 0, 14, 0, 0, 0, 15, 0, 0, 0, 16, 0, 0, 0, 17, 0, 0, 0, 18, 0, 0, 0, 19, 0, 0, 0, 20, 0, 0, 0, 21, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 136, 42, 0, 0, 51, 0, 0, 0, 52, 0, 0, 0, 44, 0, 0, 0, 3, 0, 0, 0, 4, 0, 0, 0, 23, 0, 0, 0, 5, 0, 0, 0, 24, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 43, 0, 0, 53, 0, 0, 0, 54, 0, 0, 0, 44, 0, 0, 0, 7, 0, 0, 0, 8, 0, 0, 0, 25, 0, 0, 0, 9, 0, 0, 0, 26, 0, 0, 0, 3, 0, 0, 0, 4, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 0, 0, 0, 0, 0, 0, 0, 37, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 38, 0, 0, 55, 0, 0, 0, 56, 0, 0, 0, 44, 0, 0, 0, 18, 0, 0, 0, 27, 0, 0, 0, 28, 0, 0, 0, 29, 0, 0, 0, 30, 0, 0, 0, 31, 0, 0, 0, 1, 0, 0, 0, 248, 255, 255, 255, 72, 38, 0, 0, 19, 0, 0, 0, 20, 0, 0, 0, 21, 0, 0, 0, 22, 0, 0, 0, 23, 0, 0, 0, 24, 0, 0, 0, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 72, 58, 37, 77, 58, 37, 83, 37, 109, 47, 37, 100, 47, 37, 121, 37, 89, 45, 37, 109, 45, 37, 100, 37, 73, 58, 37, 77, 58, 37, 83, 32, 37, 112, 0, 0, 0, 0, 0, 37, 72, 58, 37, 77, 0, 0, 0, 37, 72, 58, 37, 77, 58, 37, 83, 0, 0, 0, 0, 232, 38, 0, 0, 57, 0, 0, 0, 58, 0, 0, 0, 44, 0, 0, 0, 26, 0, 0, 0, 32, 0, 0, 0, 33, 0, 0, 0, 34, 0, 0, 0, 35, 0, 0, 0, 36, 0, 0, 0, 2, 0, 0, 0, 248, 255, 255, 255, 232, 38, 0, 0, 27, 0, 0, 0, 28, 0, 0, 0, 29, 0, 0, 0, 30, 0, 0, 0, 31, 0, 0, 0, 32, 0, 0, 0, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 0, 0, 0, 72, 0, 0, 0, 58, 0, 0, 0, 37, 0, 0, 0, 77, 0, 0, 0, 58, 0, 0, 0, 37, 0, 0, 0, 83, 0, 0, 0, 37, 0, 0, 0, 109, 0, 0, 0, 47, 0, 0, 0, 37, 0, 0, 0, 100, 0, 0, 0, 47, 0, 0, 0, 37, 0, 0, 0, 121, 0, 0, 0, 37, 0, 0, 0, 89, 0, 0, 0, 45, 0, 0, 0, 37, 0, 0, 0, 109, 0, 0, 0, 45, 0, 0, 0, 37, 0, 0, 0, 100, 0, 0, 0, 37, 0, 0, 0, 73, 0, 0, 0, 58, 0, 0, 0, 37, 0, 0, 0, 77, 0, 0, 0, 58, 0, 0, 0, 37, 0, 0, 0, 83, 0, 0, 0, 32, 0, 0, 0, 37, 0, 0, 0, 112, 0, 0, 0, 0, 0, 0, 0, 37, 0, 0, 0, 72, 0, 0, 0, 58, 0, 0, 0, 37, 0, 0, 0, 77, 0, 0, 0, 0, 0, 0, 0, 37, 0, 0, 0, 72, 0, 0, 0, 58, 0, 0, 0, 37, 0, 0, 0, 77, 0, 0, 0, 58, 0, 0, 0, 37, 0, 0, 0, 83, 0, 0, 0, 0, 0, 0, 0, 120, 39, 0, 0, 59, 0, 0, 0, 60, 0, 0, 0, 44, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 39, 0, 0, 61, 0, 0, 0, 62, 0, 0, 0, 44, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 208, 36, 0, 0, 63, 0, 0, 0, 64, 0, 0, 0, 44, 0, 0, 0, 34, 0, 0, 0, 35, 0, 0, 0, 7, 0, 0, 0, 8, 0, 0, 0, 9, 0, 0, 0, 10, 0, 0, 0, 36, 0, 0, 0, 11, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 37, 0, 0, 65, 0, 0, 0, 66, 0, 0, 0, 44, 0, 0, 0, 37, 0, 0, 0, 38, 0, 0, 0, 13, 0, 0, 0, 14, 0, 0, 0, 15, 0, 0, 0, 16, 0, 0, 0, 39, 0, 0, 0, 17, 0, 0, 0, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 80, 37, 0, 0, 67, 0, 0, 0, 68, 0, 0, 0, 44, 0, 0, 0, 40, 0, 0, 0, 41, 0, 0, 0, 19, 0, 0, 0, 20, 0, 0, 0, 21, 0, 0, 0, 22, 0, 0, 0, 42, 0, 0, 0, 23, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 144, 37, 0, 0, 69, 0, 0, 0, 70, 0, 0, 0, 44, 0, 0, 0, 43, 0, 0, 0, 44, 0, 0, 0, 25, 0, 0, 0, 26, 0, 0, 0, 27, 0, 0, 0, 28, 0, 0, 0, 45, 0, 0, 0, 29, 0, 0, 0, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 176, 43, 0, 0, 71, 0, 0, 0, 72, 0, 0, 0, 44, 0, 0, 0, 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 0, 0, 0, 0, 0, 0, 37, 76, 102, 0, 0, 0, 0, 0, 109, 111, 110, 101, 121, 95, 103, 101, 116, 32, 101, 114, 114, 111, 114, 0, 0, 0, 0, 0, 64, 44, 0, 0, 73, 0, 0, 0, 74, 0, 0, 0, 44, 0, 0, 0, 5, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 208, 44, 0, 0, 75, 0, 0, 0, 76, 0, 0, 0, 44, 0, 0, 0, 1, 0, 0, 0, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 46, 48, 76, 102, 0, 0, 0, 0, 0, 0, 0, 96, 45, 0, 0, 77, 0, 0, 0, 78, 0, 0, 0, 44, 0, 0, 0, 2, 0, 0, 0, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 40, 0, 0, 79, 0, 0, 0, 80, 0, 0, 0, 44, 0, 0, 0, 13, 0, 0, 0, 11, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 40, 0, 0, 81, 0, 0, 0, 82, 0, 0, 0, 44, 0, 0, 0, 14, 0, 0, 0, 12, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 118, 101, 99, 116, 111, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 36, 0, 0, 83, 0, 0, 0, 84, 0, 0, 0, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 33, 0, 0, 85, 0, 0, 0, 86, 0, 0, 0, 44, 0, 0, 0, 9, 0, 0, 0, 15, 0, 0, 0, 10, 0, 0, 0, 16, 0, 0, 0, 11, 0, 0, 0, 1, 0, 0, 0, 17, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 232, 33, 0, 0, 87, 0, 0, 0, 88, 0, 0, 0, 44, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 4, 0, 0, 0, 46, 0, 0, 0, 47, 0, 0, 0, 5, 0, 0, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 35, 0, 0, 89, 0, 0, 0, 90, 0, 0, 0, 44, 0, 0, 0, 49, 0, 0, 0, 50, 0, 0, 0, 33, 0, 0, 0, 34, 0, 0, 0, 35, 0, 0, 0, 0, 0, 0, 0, 8, 36, 0, 0, 91, 0, 0, 0, 92, 0, 0, 0, 44, 0, 0, 0, 51, 0, 0, 0, 52, 0, 0, 0, 36, 0, 0, 0, 37, 0, 0, 0, 38, 0, 0, 0, 116, 114, 117, 101, 0, 0, 0, 0, 116, 0, 0, 0, 114, 0, 0, 0, 117, 0, 0, 0, 101, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 102, 97, 108, 115, 101, 0, 0, 0, 102, 0, 0, 0, 97, 0, 0, 0, 108, 0, 0, 0, 115, 0, 0, 0, 101, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 109, 47, 37, 100, 47, 37, 121, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 0, 0, 0, 109, 0, 0, 0, 47, 0, 0, 0, 37, 0, 0, 0, 100, 0, 0, 0, 47, 0, 0, 0, 37, 0, 0, 0, 121, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 72, 58, 37, 77, 58, 37, 83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 0, 0, 0, 72, 0, 0, 0, 58, 0, 0, 0, 37, 0, 0, 0, 77, 0, 0, 0, 58, 0, 0, 0, 37, 0, 0, 0, 83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 97, 32, 37, 98, 32, 37, 100, 32, 37, 72, 58, 37, 77, 58, 37, 83, 32, 37, 89, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 0, 0, 0, 97, 0, 0, 0, 32, 0, 0, 0, 37, 0, 0, 0, 98, 0, 0, 0, 32, 0, 0, 0, 37, 0, 0, 0, 100, 0, 0, 0, 32, 0, 0, 0, 37, 0, 0, 0, 72, 0, 0, 0, 58, 0, 0, 0, 37, 0, 0, 0, 77, 0, 0, 0, 58, 0, 0, 0, 37, 0, 0, 0, 83, 0, 0, 0, 32, 0, 0, 0, 37, 0, 0, 0, 89, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 73, 58, 37, 77, 58, 37, 83, 32, 37, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 0, 0, 0, 73, 0, 0, 0, 58, 0, 0, 0, 37, 0, 0, 0, 77, 0, 0, 0, 58, 0, 0, 0, 37, 0, 0, 0, 83, 0, 0, 0, 32, 0, 0, 0, 37, 0, 0, 0, 112, 0, 0, 0, 0, 0, 0, 0, 108, 111, 99, 97, 108, 101, 32, 110, 111, 116, 32, 115, 117, 112, 112, 111, 114, 116, 101, 100, 0, 0, 0, 0, 0, 0, 0, 0, 64, 32, 0, 0, 93, 0, 0, 0, 94, 0, 0, 0, 44, 0, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 54, 108, 111, 99, 97, 108, 101, 53, 102, 97, 99, 101, 116, 69, 0, 0, 0, 80, 60, 0, 0, 40, 32, 0, 0, 40, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 208, 32, 0, 0, 93, 0, 0, 0, 95, 0, 0, 0, 44, 0, 0, 0, 18, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 4, 0, 0, 0, 12, 0, 0, 0, 19, 0, 0, 0, 13, 0, 0, 0, 20, 0, 0, 0, 14, 0, 0, 0, 5, 0, 0, 0, 21, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 53, 99, 116, 121, 112, 101, 73, 119, 69, 69, 0, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 48, 99, 116, 121, 112, 101, 95, 98, 97, 115, 101, 69, 0, 0, 0, 0, 40, 60, 0, 0, 176, 32, 0, 0, 176, 60, 0, 0, 152, 32, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 200, 32, 0, 0, 2, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 53, 99, 116, 121, 112, 101, 73, 99, 69, 69, 0, 0, 0, 0, 0, 0, 0, 176, 60, 0, 0, 240, 32, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 200, 32, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 160, 33, 0, 0, 93, 0, 0, 0, 96, 0, 0, 0, 44, 0, 0, 0, 3, 0, 0, 0, 4, 0, 0, 0, 7, 0, 0, 0, 53, 0, 0, 0, 54, 0, 0, 0, 8, 0, 0, 0, 55, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 55, 99, 111, 100, 101, 99, 118, 116, 73, 99, 99, 49, 49, 95, 95, 109, 98, 115, 116, 97, 116, 101, 95, 116, 69, 69, 0, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 50, 99, 111, 100, 101, 99, 118, 116, 95, 98, 97, 115, 101, 69, 0, 0, 40, 60, 0, 0, 128, 33, 0, 0, 176, 60, 0, 0, 88, 33, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 152, 33, 0, 0, 2, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 55, 99, 111, 100, 101, 99, 118, 116, 73, 119, 99, 49, 49, 95, 95, 109, 98, 115, 116, 97, 116, 101, 95, 116, 69, 69, 0, 0, 0, 0, 0, 0, 0, 176, 60, 0, 0, 192, 33, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 152, 33, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 96, 34, 0, 0, 93, 0, 0, 0, 97, 0, 0, 0, 44, 0, 0, 0, 5, 0, 0, 0, 6, 0, 0, 0, 9, 0, 0, 0, 56, 0, 0, 0, 57, 0, 0, 0, 10, 0, 0, 0, 58, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 55, 99, 111, 100, 101, 99, 118, 116, 73, 68, 115, 99, 49, 49, 95, 95, 109, 98, 115, 116, 97, 116, 101, 95, 116, 69, 69, 0, 0, 0, 0, 0, 0, 176, 60, 0, 0, 56, 34, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 152, 33, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 216, 34, 0, 0, 93, 0, 0, 0, 98, 0, 0, 0, 44, 0, 0, 0, 7, 0, 0, 0, 8, 0, 0, 0, 11, 0, 0, 0, 59, 0, 0, 0, 60, 0, 0, 0, 12, 0, 0, 0, 61, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 55, 99, 111, 100, 101, 99, 118, 116, 73, 68, 105, 99, 49, 49, 95, 95, 109, 98, 115, 116, 97, 116, 101, 95, 116, 69, 69, 0, 0, 0, 0, 0, 0, 176, 60, 0, 0, 176, 34, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 152, 33, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 80, 35, 0, 0, 93, 0, 0, 0, 99, 0, 0, 0, 44, 0, 0, 0, 7, 0, 0, 0, 8, 0, 0, 0, 11, 0, 0, 0, 59, 0, 0, 0, 60, 0, 0, 0, 12, 0, 0, 0, 61, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 54, 95, 95, 110, 97, 114, 114, 111, 119, 95, 116, 111, 95, 117, 116, 102, 56, 73, 76, 106, 51, 50, 69, 69, 69, 0, 0, 0, 0, 0, 0, 0, 80, 60, 0, 0, 40, 35, 0, 0, 216, 34, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 184, 35, 0, 0, 93, 0, 0, 0, 100, 0, 0, 0, 44, 0, 0, 0, 7, 0, 0, 0, 8, 0, 0, 0, 11, 0, 0, 0, 59, 0, 0, 0, 60, 0, 0, 0, 12, 0, 0, 0, 61, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 55, 95, 95, 119, 105, 100, 101, 110, 95, 102, 114, 111, 109, 95, 117, 116, 102, 56, 73, 76, 106, 51, 50, 69, 69, 69, 0, 0, 0, 0, 0, 0, 80, 60, 0, 0, 144, 35, 0, 0, 216, 34, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 56, 110, 117, 109, 112, 117, 110, 99, 116, 73, 99, 69, 69, 0, 0, 0, 0, 80, 60, 0, 0, 200, 35, 0, 0, 64, 32, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 56, 110, 117, 109, 112, 117, 110, 99, 116, 73, 119, 69, 69, 0, 0, 0, 0, 80, 60, 0, 0, 240, 35, 0, 0, 64, 32, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 54, 108, 111, 99, 97, 108, 101, 53, 95, 95, 105, 109, 112, 69, 0, 0, 0, 80, 60, 0, 0, 24, 36, 0, 0, 64, 32, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 55, 99, 111, 108, 108, 97, 116, 101, 73, 99, 69, 69, 0, 0, 0, 0, 0, 80, 60, 0, 0, 64, 36, 0, 0, 64, 32, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 55, 99, 111, 108, 108, 97, 116, 101, 73, 119, 69, 69, 0, 0, 0, 0, 0, 80, 60, 0, 0, 104, 36, 0, 0, 64, 32, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 48, 109, 111, 110, 101, 121, 112, 117, 110, 99, 116, 73, 99, 76, 98, 48, 69, 69, 69, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 48, 109, 111, 110, 101, 121, 95, 98, 97, 115, 101, 69, 0, 0, 0, 0, 40, 60, 0, 0, 176, 36, 0, 0, 176, 60, 0, 0, 144, 36, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 200, 36, 0, 0, 2, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 48, 109, 111, 110, 101, 121, 112, 117, 110, 99, 116, 73, 99, 76, 98, 49, 69, 69, 69, 0, 0, 0, 0, 0, 176, 60, 0, 0, 240, 36, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 200, 36, 0, 0, 2, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 48, 109, 111, 110, 101, 121, 112, 117, 110, 99, 116, 73, 119, 76, 98, 48, 69, 69, 69, 0, 0, 0, 0, 0, 176, 60, 0, 0, 48, 37, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 200, 36, 0, 0, 2, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 48, 109, 111, 110, 101, 121, 112, 117, 110, 99, 116, 73, 119, 76, 98, 49, 69, 69, 69, 0, 0, 0, 0, 0, 176, 60, 0, 0, 112, 37, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 200, 36, 0, 0, 2, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 56, 116, 105, 109, 101, 95, 103, 101, 116, 73, 99, 78, 83, 95, 49, 57, 105, 115, 116, 114, 101, 97, 109, 98, 117, 102, 95, 105, 116, 101, 114, 97, 116, 111, 114, 73, 99, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 99, 69, 69, 69, 69, 69, 69, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 57, 116, 105, 109, 101, 95, 98, 97, 115, 101, 69, 0, 0, 0, 0, 0, 0, 40, 60, 0, 0, 248, 37, 0, 0, 78, 83, 116, 51, 95, 95, 49, 50, 48, 95, 95, 116, 105, 109, 101, 95, 103, 101, 116, 95, 99, 95, 115, 116, 111, 114, 97, 103, 101, 73, 99, 69, 69, 0, 0, 0, 0, 0, 0, 0, 40, 60, 0, 0, 24, 38, 0, 0, 176, 60, 0, 0, 176, 37, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 16, 38, 0, 0, 2, 0, 0, 0, 64, 38, 0, 0, 0, 8, 0, 0, 78, 83, 116, 51, 95, 95, 49, 56, 116, 105, 109, 101, 95, 103, 101, 116, 73, 119, 78, 83, 95, 49, 57, 105, 115, 116, 114, 101, 97, 109, 98, 117, 102, 95, 105, 116, 101, 114, 97, 116, 111, 114, 73, 119, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 119, 69, 69, 69, 69, 69, 69, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 50, 48, 95, 95, 116, 105, 109, 101, 95, 103, 101, 116, 95, 99, 95, 115, 116, 111, 114, 97, 103, 101, 73, 119, 69, 69, 0, 0, 0, 0, 0, 0, 0, 40, 60, 0, 0, 184, 38, 0, 0, 176, 60, 0, 0, 112, 38, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 16, 38, 0, 0, 2, 0, 0, 0, 224, 38, 0, 0, 0, 8, 0, 0, 78, 83, 116, 51, 95, 95, 49, 56, 116, 105, 109, 101, 95, 112, 117, 116, 73, 99, 78, 83, 95, 49, 57, 111, 115, 116, 114, 101, 97, 109, 98, 117, 102, 95, 105, 116, 101, 114, 97, 116, 111, 114, 73, 99, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 99, 69, 69, 69, 69, 69, 69, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 48, 95, 95, 116, 105, 109, 101, 95, 112, 117, 116, 69, 0, 0, 0, 0, 40, 60, 0, 0, 88, 39, 0, 0, 176, 60, 0, 0, 16, 39, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 112, 39, 0, 0, 0, 8, 0, 0, 78, 83, 116, 51, 95, 95, 49, 56, 116, 105, 109, 101, 95, 112, 117, 116, 73, 119, 78, 83, 95, 49, 57, 111, 115, 116, 114, 101, 97, 109, 98, 117, 102, 95, 105, 116, 101, 114, 97, 116, 111, 114, 73, 119, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 119, 69, 69, 69, 69, 69, 69, 0, 0, 0, 0, 176, 60, 0, 0, 152, 39, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 112, 39, 0, 0, 0, 8, 0, 0, 78, 83, 116, 51, 95, 95, 49, 56, 109, 101, 115, 115, 97, 103, 101, 115, 73, 99, 69, 69, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 51, 109, 101, 115, 115, 97, 103, 101, 115, 95, 98, 97, 115, 101, 69, 0, 40, 60, 0, 0, 24, 40, 0, 0, 176, 60, 0, 0, 0, 40, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 48, 40, 0, 0, 2, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 56, 109, 101, 115, 115, 97, 103, 101, 115, 73, 119, 69, 69, 0, 0, 0, 0, 176, 60, 0, 0, 88, 40, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 48, 40, 0, 0, 2, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 55, 110, 117, 109, 95, 103, 101, 116, 73, 99, 78, 83, 95, 49, 57, 105, 115, 116, 114, 101, 97, 109, 98, 117, 102, 95, 105, 116, 101, 114, 97, 116, 111, 114, 73, 99, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 99, 69, 69, 69, 69, 69, 69, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 57, 95, 95, 110, 117, 109, 95, 103, 101, 116, 73, 99, 69, 69, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 52, 95, 95, 110, 117, 109, 95, 103, 101, 116, 95, 98, 97, 115, 101, 69, 0, 0, 0, 0, 0, 0, 0, 0, 40, 60, 0, 0, 240, 40, 0, 0, 176, 60, 0, 0, 216, 40, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 16, 41, 0, 0, 0, 0, 0, 0, 176, 60, 0, 0, 144, 40, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 24, 41, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 55, 110, 117, 109, 95, 103, 101, 116, 73, 119, 78, 83, 95, 49, 57, 105, 115, 116, 114, 101, 97, 109, 98, 117, 102, 95, 105, 116, 101, 114, 97, 116, 111, 114, 73, 119, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 119, 69, 69, 69, 69, 69, 69, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 57, 95, 95, 110, 117, 109, 95, 103, 101, 116, 73, 119, 69, 69, 0, 0, 0, 176, 60, 0, 0, 152, 41, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 16, 41, 0, 0, 0, 0, 0, 0, 176, 60, 0, 0, 80, 41, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 176, 41, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 55, 110, 117, 109, 95, 112, 117, 116, 73, 99, 78, 83, 95, 49, 57, 111, 115, 116, 114, 101, 97, 109, 98, 117, 102, 95, 105, 116, 101, 114, 97, 116, 111, 114, 73, 99, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 99, 69, 69, 69, 69, 69, 69, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 57, 95, 95, 110, 117, 109, 95, 112, 117, 116, 73, 99, 69, 69, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 52, 95, 95, 110, 117, 109, 95, 112, 117, 116, 95, 98, 97, 115, 101, 69, 0, 0, 0, 0, 0, 0, 0, 0, 40, 60, 0, 0, 72, 42, 0, 0, 176, 60, 0, 0, 48, 42, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 104, 42, 0, 0, 0, 0, 0, 0, 176, 60, 0, 0, 232, 41, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 112, 42, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 55, 110, 117, 109, 95, 112, 117, 116, 73, 119, 78, 83, 95, 49, 57, 111, 115, 116, 114, 101, 97, 109, 98, 117, 102, 95, 105, 116, 101, 114, 97, 116, 111, 114, 73, 119, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 119, 69, 69, 69, 69, 69, 69, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 57, 95, 95, 110, 117, 109, 95, 112, 117, 116, 73, 119, 69, 69, 0, 0, 0, 176, 60, 0, 0, 240, 42, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 104, 42, 0, 0, 0, 0, 0, 0, 176, 60, 0, 0, 168, 42, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 8, 43, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 57, 109, 111, 110, 101, 121, 95, 103, 101, 116, 73, 99, 78, 83, 95, 49, 57, 105, 115, 116, 114, 101, 97, 109, 98, 117, 102, 95, 105, 116, 101, 114, 97, 116, 111, 114, 73, 99, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 99, 69, 69, 69, 69, 69, 69, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 49, 95, 95, 109, 111, 110, 101, 121, 95, 103, 101, 116, 73, 99, 69, 69, 0, 0, 0, 0, 0, 0, 0, 0, 40, 60, 0, 0, 136, 43, 0, 0, 176, 60, 0, 0, 64, 43, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 168, 43, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 57, 109, 111, 110, 101, 121, 95, 103, 101, 116, 73, 119, 78, 83, 95, 49, 57, 105, 115, 116, 114, 101, 97, 109, 98, 117, 102, 95, 105, 116, 101, 114, 97, 116, 111, 114, 73, 119, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 119, 69, 69, 69, 69, 69, 69, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 49, 95, 95, 109, 111, 110, 101, 121, 95, 103, 101, 116, 73, 119, 69, 69, 0, 0, 0, 0, 0, 0, 0, 0, 40, 60, 0, 0, 24, 44, 0, 0, 176, 60, 0, 0, 208, 43, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 56, 44, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 57, 109, 111, 110, 101, 121, 95, 112, 117, 116, 73, 99, 78, 83, 95, 49, 57, 111, 115, 116, 114, 101, 97, 109, 98, 117, 102, 95, 105, 116, 101, 114, 97, 116, 111, 114, 73, 99, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 99, 69, 69, 69, 69, 69, 69, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 49, 95, 95, 109, 111, 110, 101, 121, 95, 112, 117, 116, 73, 99, 69, 69, 0, 0, 0, 0, 0, 0, 0, 0, 40, 60, 0, 0, 168, 44, 0, 0, 176, 60, 0, 0, 96, 44, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 200, 44, 0, 0, 0, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 57, 109, 111, 110, 101, 121, 95, 112, 117, 116, 73, 119, 78, 83, 95, 49, 57, 111, 115, 116, 114, 101, 97, 109, 98, 117, 102, 95, 105, 116, 101, 114, 97, 116, 111, 114, 73, 119, 78, 83, 95, 49, 49, 99, 104, 97, 114, 95, 116, 114, 97, 105, 116, 115, 73, 119, 69, 69, 69, 69, 69, 69, 0, 0, 0, 78, 83, 116, 51, 95, 95, 49, 49, 49, 95, 95, 109, 111, 110, 101, 121, 95, 112, 117, 116, 73, 119, 69, 69, 0, 0, 0, 0, 0, 0, 0, 0, 40, 60, 0, 0, 56, 45, 0, 0, 176, 60, 0, 0, 240, 44, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 64, 32, 0, 0, 2, 0, 0, 0, 88, 45, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 0, 0, 0, 77, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 80, 0, 0, 0, 77, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 77, 0, 0, 0, 0, 0, 0, 80, 77, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 0, 0, 0, 97, 0, 0, 0, 110, 0, 0, 0, 117, 0, 0, 0, 97, 0, 0, 0, 114, 0, 0, 0, 121, 0, 0, 0, 0, 0, 0, 0, 70, 0, 0, 0, 101, 0, 0, 0, 98, 0, 0, 0, 114, 0, 0, 0, 117, 0, 0, 0, 97, 0, 0, 0, 114, 0, 0, 0, 121, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 77, 0, 0, 0, 97, 0, 0, 0, 114, 0, 0, 0, 99, 0, 0, 0, 104, 0, 0, 0, 0, 0, 0, 0, 65, 0, 0, 0, 112, 0, 0, 0, 114, 0, 0, 0, 105, 0, 0, 0, 108, 0, 0, 0, 0, 0, 0, 0, 74, 0, 0, 0, 117, 0, 0, 0, 110, 0, 0, 0, 101, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 0, 0, 0, 117, 0, 0, 0, 108, 0, 0, 0, 121, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 0, 0, 0, 117, 0, 0, 0, 103, 0, 0, 0, 117, 0, 0, 0, 115, 0, 0, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 0, 0, 0, 101, 0, 0, 0, 112, 0, 0, 0, 116, 0, 0, 0, 101, 0, 0, 0, 109, 0, 0, 0, 98, 0, 0, 0, 101, 0, 0, 0, 114, 0, 0, 0, 0, 0, 0, 0, 79, 0, 0, 0, 99, 0, 0, 0, 116, 0, 0, 0, 111, 0, 0, 0, 98, 0, 0, 0, 101, 0, 0, 0, 114, 0, 0, 0, 0, 0, 0, 0, 78, 0, 0, 0, 111, 0, 0, 0, 118, 0, 0, 0, 101, 0, 0, 0, 109, 0, 0, 0, 98, 0, 0, 0, 101, 0, 0, 0, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68, 0, 0, 0, 101, 0, 0, 0, 99, 0, 0, 0, 101, 0, 0, 0, 109, 0, 0, 0, 98, 0, 0, 0, 101, 0, 0, 0, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 0, 0, 0, 97, 0, 0, 0, 110, 0, 0, 0, 0, 0, 0, 0, 70, 0, 0, 0, 101, 0, 0, 0, 98, 0, 0, 0, 0, 0, 0, 0, 77, 0, 0, 0, 97, 0, 0, 0, 114, 0, 0, 0, 0, 0, 0, 0, 65, 0, 0, 0, 112, 0, 0, 0, 114, 0, 0, 0, 0, 0, 0, 0, 77, 0, 0, 0, 97, 0, 0, 0, 121, 0, 0, 0, 0, 0, 0, 0, 74, 0, 0, 0, 117, 0, 0, 0, 110, 0, 0, 0, 0, 0, 0, 0, 74, 0, 0, 0, 117, 0, 0, 0, 108, 0, 0, 0, 0, 0, 0, 0, 65, 0, 0, 0, 117, 0, 0, 0, 103, 0, 0, 0, 0, 0, 0, 0, 83, 0, 0, 0, 101, 0, 0, 0, 112, 0, 0, 0, 0, 0, 0, 0, 79, 0, 0, 0, 99, 0, 0, 0, 116, 0, 0, 0, 0, 0, 0, 0, 78, 0, 0, 0, 111, 0, 0, 0, 118, 0, 0, 0, 0, 0, 0, 0, 68, 0, 0, 0, 101, 0, 0, 0, 99], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE + 3628);
/* memory initializer */
allocate([74, 97, 110, 117, 97, 114, 121, 0, 70, 101, 98, 114, 117, 97, 114, 121, 0, 0, 0, 0, 0, 0, 0, 0, 77, 97, 114, 99, 104, 0, 0, 0, 65, 112, 114, 105, 108, 0, 0, 0, 77, 97, 121, 0, 0, 0, 0, 0, 74, 117, 110, 101, 0, 0, 0, 0, 74, 117, 108, 121, 0, 0, 0, 0, 65, 117, 103, 117, 115, 116, 0, 0, 83, 101, 112, 116, 101, 109, 98, 101, 114, 0, 0, 0, 0, 0, 0, 0, 79, 99, 116, 111, 98, 101, 114, 0, 78, 111, 118, 101, 109, 98, 101, 114, 0, 0, 0, 0, 0, 0, 0, 0, 68, 101, 99, 101, 109, 98, 101, 114, 0, 0, 0, 0, 0, 0, 0, 0, 74, 97, 110, 0, 0, 0, 0, 0, 70, 101, 98, 0, 0, 0, 0, 0, 77, 97, 114, 0, 0, 0, 0, 0, 65, 112, 114, 0, 0, 0, 0, 0, 74, 117, 110, 0, 0, 0, 0, 0, 74, 117, 108, 0, 0, 0, 0, 0, 65, 117, 103, 0, 0, 0, 0, 0, 83, 101, 112, 0, 0, 0, 0, 0, 79, 99, 116, 0, 0, 0, 0, 0, 78, 111, 118, 0, 0, 0, 0, 0, 68, 101, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 0, 0, 0, 117, 0, 0, 0, 110, 0, 0, 0, 100, 0, 0, 0, 97, 0, 0, 0, 121, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 77, 0, 0, 0, 111, 0, 0, 0, 110, 0, 0, 0, 100, 0, 0, 0, 97, 0, 0, 0, 121, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 0, 0, 0, 117, 0, 0, 0, 101, 0, 0, 0, 115, 0, 0, 0, 100, 0, 0, 0, 97, 0, 0, 0, 121, 0, 0, 0, 0, 0, 0, 0, 87, 0, 0, 0, 101, 0, 0, 0, 100, 0, 0, 0, 110, 0, 0, 0, 101, 0, 0, 0, 115, 0, 0, 0, 100, 0, 0, 0, 97, 0, 0, 0, 121, 0, 0, 0, 0, 0, 0, 0, 84, 0, 0, 0, 104, 0, 0, 0, 117, 0, 0, 0, 114, 0, 0, 0, 115, 0, 0, 0, 100, 0, 0, 0, 97, 0, 0, 0, 121, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70, 0, 0, 0, 114, 0, 0, 0, 105, 0, 0, 0, 100, 0, 0, 0, 97, 0, 0, 0, 121, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 0, 0, 0, 97, 0, 0, 0, 116, 0, 0, 0, 117, 0, 0, 0, 114, 0, 0, 0, 100, 0, 0, 0, 97, 0, 0, 0, 121, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 0, 0, 0, 117, 0, 0, 0, 110, 0, 0, 0, 0, 0, 0, 0, 77, 0, 0, 0, 111, 0, 0, 0, 110, 0, 0, 0, 0, 0, 0, 0, 84, 0, 0, 0, 117, 0, 0, 0, 101, 0, 0, 0, 0, 0, 0, 0, 87, 0, 0, 0, 101, 0, 0, 0, 100, 0, 0, 0, 0, 0, 0, 0, 84, 0, 0, 0, 104, 0, 0, 0, 117, 0, 0, 0, 0, 0, 0, 0, 70, 0, 0, 0, 114, 0, 0, 0, 105, 0, 0, 0, 0, 0, 0, 0, 83, 0, 0, 0, 97, 0, 0, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 117, 110, 100, 97, 121, 0, 0, 77, 111, 110, 100, 97, 121, 0, 0, 84, 117, 101, 115, 100, 97, 121, 0, 87, 101, 100, 110, 101, 115, 100, 97, 121, 0, 0, 0, 0, 0, 0, 0, 84, 104, 117, 114, 115, 100, 97, 121, 0, 0, 0, 0, 0, 0, 0, 0, 70, 114, 105, 100, 97, 121, 0, 0, 83, 97, 116, 117, 114, 100, 97, 121, 0, 0, 0, 0, 0, 0, 0, 0, 83, 117, 110, 0, 0, 0, 0, 0, 77, 111, 110, 0, 0, 0, 0, 0, 84, 117, 101, 0, 0, 0, 0, 0, 87, 101, 100, 0, 0, 0, 0, 0, 84, 104, 117, 0, 0, 0, 0, 0, 70, 114, 105, 0, 0, 0, 0, 0, 83, 97, 116, 0, 0, 0, 0, 0, 2, 0, 0, 192, 3, 0, 0, 192, 4, 0, 0, 192, 5, 0, 0, 192, 6, 0, 0, 192, 7, 0, 0, 192, 8, 0, 0, 192, 9, 0, 0, 192, 10, 0, 0, 192, 11, 0, 0, 192, 12, 0, 0, 192, 13, 0, 0, 192, 14, 0, 0, 192, 15, 0, 0, 192, 16, 0, 0, 192, 17, 0, 0, 192, 18, 0, 0, 192, 19, 0, 0, 192, 20, 0, 0, 192, 21, 0, 0, 192, 22, 0, 0, 192, 23, 0, 0, 192, 24, 0, 0, 192, 25, 0, 0, 192, 26, 0, 0, 192, 27, 0, 0, 192, 28, 0, 0, 192, 29, 0, 0, 192, 30, 0, 0, 192, 31, 0, 0, 192, 0, 0, 0, 179, 1, 0, 0, 195, 2, 0, 0, 195, 3, 0, 0, 195, 4, 0, 0, 195, 5, 0, 0, 195, 6, 0, 0, 195, 7, 0, 0, 195, 8, 0, 0, 195, 9, 0, 0, 195, 10, 0, 0, 195, 11, 0, 0, 195, 12, 0, 0, 195, 13, 0, 0, 211, 14, 0, 0, 195, 15, 0, 0, 195, 0, 0, 12, 187, 1, 0, 12, 195, 2, 0, 12, 195, 3, 0, 12, 195, 4, 0, 12, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 160, 59, 0, 0, 101, 0, 0, 0, 102, 0, 0, 0, 62, 0, 0, 0, 0, 0, 0, 0, 115, 116, 100, 58, 58, 98, 97, 100, 95, 99, 97, 115, 116, 0, 0, 0, 83, 116, 57, 116, 121, 112, 101, 95, 105, 110, 102, 111, 0, 0, 0, 0, 40, 60, 0, 0, 120, 59, 0, 0, 83, 116, 56, 98, 97, 100, 95, 99, 97, 115, 116, 0, 0, 0, 0, 0, 80, 60, 0, 0, 144, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 78, 49, 48, 95, 95, 99, 120, 120, 97, 98, 105, 118, 49, 49, 54, 95, 95, 115, 104, 105, 109, 95, 116, 121, 112, 101, 95, 105, 110, 102, 111, 69, 0, 0, 0, 0, 0, 0, 0, 0, 80, 60, 0, 0, 176, 59, 0, 0, 136, 59, 0, 0, 0, 0, 0, 0, 78, 49, 48, 95, 95, 99, 120, 120, 97, 98, 105, 118, 49, 49, 55, 95, 95, 99, 108, 97, 115, 115, 95, 116, 121, 112, 101, 95, 105, 110, 102, 111, 69, 0, 0, 0, 0, 0, 0, 0, 80, 60, 0, 0, 232, 59, 0, 0, 216, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 60, 0, 0, 103, 0, 0, 0, 104, 0, 0, 0, 105, 0, 0, 0, 106, 0, 0, 0, 22, 0, 0, 0, 13, 0, 0, 0, 1, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 152, 60, 0, 0, 103, 0, 0, 0, 107, 0, 0, 0, 105, 0, 0, 0, 106, 0, 0, 0, 22, 0, 0, 0, 14, 0, 0, 0, 2, 0, 0, 0, 6, 0, 0, 0, 78, 49, 48, 95, 95, 99, 120, 120, 97, 98, 105, 118, 49, 50, 48, 95, 95, 115, 105, 95, 99, 108, 97, 115, 115, 95, 116, 121, 112, 101, 95, 105, 110, 102, 111, 69, 0, 0, 0, 0, 80, 60, 0, 0, 112, 60, 0, 0, 16, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248, 60, 0, 0, 103, 0, 0, 0, 108, 0, 0, 0, 105, 0, 0, 0, 106, 0, 0, 0, 22, 0, 0, 0, 15, 0, 0, 0, 3, 0, 0, 0, 7, 0, 0, 0, 78, 49, 48, 95, 95, 99, 120, 120, 97, 98, 105, 118, 49, 50, 49, 95, 95, 118, 109, 105, 95, 99, 108, 97, 115, 115, 95, 116, 121, 112, 101, 95, 105, 110, 102, 111, 69, 0, 0, 0, 80, 60, 0, 0, 208, 60, 0, 0, 16, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 63, 0, 0, 109, 0, 0, 0, 110, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 115, 116, 100, 58, 58, 98, 97, 100, 95, 97, 108, 108, 111, 99, 0, 0, 83, 116, 57, 98, 97, 100, 95, 97, 108, 108, 111, 99, 0, 0, 0, 0, 80, 60, 0, 0, 40, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 105, 110, 102, 105, 110, 105, 116, 121, 0, 0, 0, 0, 0, 0, 0, 0, 110, 97, 110, 0, 0, 0, 0, 0, 95, 112, 137, 0, 255, 9, 47, 15, 10, 0, 0, 0, 100, 0, 0, 0, 232, 3, 0, 0, 16, 39, 0, 0, 160, 134, 1, 0, 64, 66, 15, 0, 128, 150, 152, 0, 0, 225, 245, 5], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE + 13888);




var tempDoublePtr = Runtime.alignMemory(allocate(12, "i8", ALLOC_STATIC), 8);

assert(tempDoublePtr % 8 == 0);

function copyTempFloat(ptr) { // functions, because inlining this code increases code size too much

    HEAP8[tempDoublePtr] = HEAP8[ptr];

    HEAP8[tempDoublePtr + 1] = HEAP8[ptr + 1];

    HEAP8[tempDoublePtr + 2] = HEAP8[ptr + 2];

    HEAP8[tempDoublePtr + 3] = HEAP8[ptr + 3];

}

function copyTempDouble(ptr) {

    HEAP8[tempDoublePtr] = HEAP8[ptr];

    HEAP8[tempDoublePtr + 1] = HEAP8[ptr + 1];

    HEAP8[tempDoublePtr + 2] = HEAP8[ptr + 2];

    HEAP8[tempDoublePtr + 3] = HEAP8[ptr + 3];

    HEAP8[tempDoublePtr + 4] = HEAP8[ptr + 4];

    HEAP8[tempDoublePtr + 5] = HEAP8[ptr + 5];

    HEAP8[tempDoublePtr + 6] = HEAP8[ptr + 6];

    HEAP8[tempDoublePtr + 7] = HEAP8[ptr + 7];

}



function _atexit(func, arg) {
    __ATEXIT__.unshift({
        func: func,
        arg: arg
    });
}
var ___cxa_atexit = _atexit;

function _llvm_lifetime_end() {}



Module["_memset"] = _memset;
var _llvm_memset_p0i8_i32 = _memset;


Module["_i64Subtract"] = _i64Subtract;


Module["_i64Add"] = _i64Add;


function __ZSt18uncaught_exceptionv() { // std::uncaught_exception()
    return !!__ZSt18uncaught_exceptionv.uncaught_exception;
}



function ___cxa_is_number_type(type) {
    var isNumber = false;
    try {
        if (type == __ZTIi) isNumber = true
    } catch (e) {}
    try {
        if (type == __ZTIj) isNumber = true
    } catch (e) {}
    try {
        if (type == __ZTIl) isNumber = true
    } catch (e) {}
    try {
        if (type == __ZTIm) isNumber = true
    } catch (e) {}
    try {
        if (type == __ZTIx) isNumber = true
    } catch (e) {}
    try {
        if (type == __ZTIy) isNumber = true
    } catch (e) {}
    try {
        if (type == __ZTIf) isNumber = true
    } catch (e) {}
    try {
        if (type == __ZTId) isNumber = true
    } catch (e) {}
    try {
        if (type == __ZTIe) isNumber = true
    } catch (e) {}
    try {
        if (type == __ZTIc) isNumber = true
    } catch (e) {}
    try {
        if (type == __ZTIa) isNumber = true
    } catch (e) {}
    try {
        if (type == __ZTIh) isNumber = true
    } catch (e) {}
    try {
        if (type == __ZTIs) isNumber = true
    } catch (e) {}
    try {
        if (type == __ZTIt) isNumber = true
    } catch (e) {}
    return isNumber;
}

function ___cxa_does_inherit(definiteType, possibilityType, possibility) {
    if (possibility == 0) return false;
    if (possibilityType == 0 || possibilityType == definiteType)
        return true;
    var possibility_type_info;
    if (___cxa_is_number_type(possibilityType)) {
        possibility_type_info = possibilityType;
    } else {
        var possibility_type_infoAddr = HEAP32[((possibilityType) >> 2)] - 8;
        possibility_type_info = HEAP32[((possibility_type_infoAddr) >> 2)];
    }
    switch (possibility_type_info) {
    case 0: // possibility is a pointer
        // See if definite type is a pointer
        var definite_type_infoAddr = HEAP32[((definiteType) >> 2)] - 8;
        var definite_type_info = HEAP32[((definite_type_infoAddr) >> 2)];
        if (definite_type_info == 0) {
            // Also a pointer; compare base types of pointers
            var defPointerBaseAddr = definiteType + 8;
            var defPointerBaseType = HEAP32[((defPointerBaseAddr) >> 2)];
            var possPointerBaseAddr = possibilityType + 8;
            var possPointerBaseType = HEAP32[((possPointerBaseAddr) >> 2)];
            return ___cxa_does_inherit(defPointerBaseType, possPointerBaseType, possibility);
        } else
            return false; // one pointer and one non-pointer
    case 1: // class with no base class
        return false;
    case 2: // class with base class
        var parentTypeAddr = possibilityType + 8;
        var parentType = HEAP32[((parentTypeAddr) >> 2)];
        return ___cxa_does_inherit(definiteType, parentType, possibility);
    default:
        return false; // some unencountered type
    }
}



var ___cxa_last_thrown_exception = 0;

function ___resumeException(ptr) {
    if (!___cxa_last_thrown_exception) {
        ___cxa_last_thrown_exception = ptr;
    }
    throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";
}

var ___cxa_exception_header_size = 8;

function ___cxa_find_matching_catch(thrown, throwntype) {
    if (thrown == -1) thrown = ___cxa_last_thrown_exception;
    header = thrown - ___cxa_exception_header_size;
    if (throwntype == -1) throwntype = HEAP32[((header) >> 2)];
    var typeArray = Array.prototype.slice.call(arguments, 2);

    // If throwntype is a pointer, this means a pointer has been
    // thrown. When a pointer is thrown, actually what's thrown
    // is a pointer to the pointer. We'll dereference it.
    if (throwntype != 0 && !___cxa_is_number_type(throwntype)) {
        var throwntypeInfoAddr = HEAP32[((throwntype) >> 2)] - 8;
        var throwntypeInfo = HEAP32[((throwntypeInfoAddr) >> 2)];
        if (throwntypeInfo == 0)
            thrown = HEAP32[((thrown) >> 2)];
    }
    // The different catch blocks are denoted by different types.
    // Due to inheritance, those types may not precisely match the
    // type of the thrown object. Find one which matches, and
    // return the type of the catch block which should be called.
    for (var i = 0; i < typeArray.length; i++) {
        if (___cxa_does_inherit(typeArray[i], throwntype, thrown))
            return ((asm["setTempRet0"](typeArray[i]), thrown) | 0);
    }
    // Shouldn't happen unless we have bogus data in typeArray
    // or encounter a type for which emscripten doesn't have suitable
    // typeinfo defined. Best-efforts match just in case.
    return ((asm["setTempRet0"](throwntype), thrown) | 0);
}

function ___cxa_throw(ptr, type, destructor) {
    if (!___cxa_throw.initialized) {
        try {
            HEAP32[((__ZTVN10__cxxabiv119__pointer_type_infoE) >> 2)] = 0; // Workaround for libcxxabi integration bug
        } catch (e) {}
        try {
            HEAP32[((__ZTVN10__cxxabiv117__class_type_infoE) >> 2)] = 1; // Workaround for libcxxabi integration bug
        } catch (e) {}
        try {
            HEAP32[((__ZTVN10__cxxabiv120__si_class_type_infoE) >> 2)] = 2; // Workaround for libcxxabi integration bug
        } catch (e) {}
        ___cxa_throw.initialized = true;
    }
    var header = ptr - ___cxa_exception_header_size;
    HEAP32[((header) >> 2)] = type;
    HEAP32[(((header) + (4)) >> 2)] = destructor;
    ___cxa_last_thrown_exception = ptr;
    if (!("uncaught_exception" in __ZSt18uncaught_exceptionv)) {
        __ZSt18uncaught_exceptionv.uncaught_exception = 1;
    } else {
        __ZSt18uncaught_exceptionv.uncaught_exception++;
    }
    throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";
}

function _pthread_mutex_lock() {}



var ERRNO_CODES = {
    EPERM: 1,
    ENOENT: 2,
    ESRCH: 3,
    EINTR: 4,
    EIO: 5,
    ENXIO: 6,
    E2BIG: 7,
    ENOEXEC: 8,
    EBADF: 9,
    ECHILD: 10,
    EAGAIN: 11,
    EWOULDBLOCK: 11,
    ENOMEM: 12,
    EACCES: 13,
    EFAULT: 14,
    ENOTBLK: 15,
    EBUSY: 16,
    EEXIST: 17,
    EXDEV: 18,
    ENODEV: 19,
    ENOTDIR: 20,
    EISDIR: 21,
    EINVAL: 22,
    ENFILE: 23,
    EMFILE: 24,
    ENOTTY: 25,
    ETXTBSY: 26,
    EFBIG: 27,
    ENOSPC: 28,
    ESPIPE: 29,
    EROFS: 30,
    EMLINK: 31,
    EPIPE: 32,
    EDOM: 33,
    ERANGE: 34,
    ENOMSG: 42,
    EIDRM: 43,
    ECHRNG: 44,
    EL2NSYNC: 45,
    EL3HLT: 46,
    EL3RST: 47,
    ELNRNG: 48,
    EUNATCH: 49,
    ENOCSI: 50,
    EL2HLT: 51,
    EDEADLK: 35,
    ENOLCK: 37,
    EBADE: 52,
    EBADR: 53,
    EXFULL: 54,
    ENOANO: 55,
    EBADRQC: 56,
    EBADSLT: 57,
    EDEADLOCK: 35,
    EBFONT: 59,
    ENOSTR: 60,
    ENODATA: 61,
    ETIME: 62,
    ENOSR: 63,
    ENONET: 64,
    ENOPKG: 65,
    EREMOTE: 66,
    ENOLINK: 67,
    EADV: 68,
    ESRMNT: 69,
    ECOMM: 70,
    EPROTO: 71,
    EMULTIHOP: 72,
    EDOTDOT: 73,
    EBADMSG: 74,
    ENOTUNIQ: 76,
    EBADFD: 77,
    EREMCHG: 78,
    ELIBACC: 79,
    ELIBBAD: 80,
    ELIBSCN: 81,
    ELIBMAX: 82,
    ELIBEXEC: 83,
    ENOSYS: 38,
    ENOTEMPTY: 39,
    ENAMETOOLONG: 36,
    ELOOP: 40,
    EOPNOTSUPP: 95,
    EPFNOSUPPORT: 96,
    ECONNRESET: 104,
    ENOBUFS: 105,
    EAFNOSUPPORT: 97,
    EPROTOTYPE: 91,
    ENOTSOCK: 88,
    ENOPROTOOPT: 92,
    ESHUTDOWN: 108,
    ECONNREFUSED: 111,
    EADDRINUSE: 98,
    ECONNABORTED: 103,
    ENETUNREACH: 101,
    ENETDOWN: 100,
    ETIMEDOUT: 110,
    EHOSTDOWN: 112,
    EHOSTUNREACH: 113,
    EINPROGRESS: 115,
    EALREADY: 114,
    EDESTADDRREQ: 89,
    EMSGSIZE: 90,
    EPROTONOSUPPORT: 93,
    ESOCKTNOSUPPORT: 94,
    EADDRNOTAVAIL: 99,
    ENETRESET: 102,
    EISCONN: 106,
    ENOTCONN: 107,
    ETOOMANYREFS: 109,
    EUSERS: 87,
    EDQUOT: 122,
    ESTALE: 116,
    ENOTSUP: 95,
    ENOMEDIUM: 123,
    EILSEQ: 84,
    EOVERFLOW: 75,
    ECANCELED: 125,
    ENOTRECOVERABLE: 131,
    EOWNERDEAD: 130,
    ESTRPIPE: 86
};

var ERRNO_MESSAGES = {
    0: "Success",
    1: "Not super-user",
    2: "No such file or directory",
    3: "No such process",
    4: "Interrupted system call",
    5: "I/O error",
    6: "No such device or address",
    7: "Arg list too long",
    8: "Exec format error",
    9: "Bad file number",
    10: "No children",
    11: "No more processes",
    12: "Not enough core",
    13: "Permission denied",
    14: "Bad address",
    15: "Block device required",
    16: "Mount device busy",
    17: "File exists",
    18: "Cross-device link",
    19: "No such device",
    20: "Not a directory",
    21: "Is a directory",
    22: "Invalid argument",
    23: "Too many open files in system",
    24: "Too many open files",
    25: "Not a typewriter",
    26: "Text file busy",
    27: "File too large",
    28: "No space left on device",
    29: "Illegal seek",
    30: "Read only file system",
    31: "Too many links",
    32: "Broken pipe",
    33: "Math arg out of domain of func",
    34: "Math result not representable",
    35: "File locking deadlock error",
    36: "File or path name too long",
    37: "No record locks available",
    38: "Function not implemented",
    39: "Directory not empty",
    40: "Too many symbolic links",
    42: "No message of desired type",
    43: "Identifier removed",
    44: "Channel number out of range",
    45: "Level 2 not synchronized",
    46: "Level 3 halted",
    47: "Level 3 reset",
    48: "Link number out of range",
    49: "Protocol driver not attached",
    50: "No CSI structure available",
    51: "Level 2 halted",
    52: "Invalid exchange",
    53: "Invalid request descriptor",
    54: "Exchange full",
    55: "No anode",
    56: "Invalid request code",
    57: "Invalid slot",
    59: "Bad font file fmt",
    60: "Device not a stream",
    61: "No data (for no delay io)",
    62: "Timer expired",
    63: "Out of streams resources",
    64: "Machine is not on the network",
    65: "Package not installed",
    66: "The object is remote",
    67: "The link has been severed",
    68: "Advertise error",
    69: "Srmount error",
    70: "Communication error on send",
    71: "Protocol error",
    72: "Multihop attempted",
    73: "Cross mount point (not really error)",
    74: "Trying to read unreadable message",
    75: "Value too large for defined data type",
    76: "Given log. name not unique",
    77: "f.d. invalid for this operation",
    78: "Remote address changed",
    79: "Can   access a needed shared lib",
    80: "Accessing a corrupted shared lib",
    81: ".lib section in a.out corrupted",
    82: "Attempting to link in too many libs",
    83: "Attempting to exec a shared library",
    84: "Illegal byte sequence",
    86: "Streams pipe error",
    87: "Too many users",
    88: "Socket operation on non-socket",
    89: "Destination address required",
    90: "Message too long",
    91: "Protocol wrong type for socket",
    92: "Protocol not available",
    93: "Unknown protocol",
    94: "Socket type not supported",
    95: "Not supported",
    96: "Protocol family not supported",
    97: "Address family not supported by protocol family",
    98: "Address already in use",
    99: "Address not available",
    100: "Network interface is not configured",
    101: "Network is unreachable",
    102: "Connection reset by network",
    103: "Connection aborted",
    104: "Connection reset by peer",
    105: "No buffer space available",
    106: "Socket is already connected",
    107: "Socket is not connected",
    108: "Can't send after socket shutdown",
    109: "Too many references",
    110: "Connection timed out",
    111: "Connection refused",
    112: "Host is down",
    113: "Host is unreachable",
    114: "Socket already connected",
    115: "Connection already in progress",
    116: "Stale file handle",
    122: "Quota exceeded",
    123: "No medium (in tape drive)",
    125: "Operation canceled",
    130: "Previous owner died",
    131: "State not recoverable"
};


var ___errno_state = 0;

function ___setErrNo(value) {
    // For convenient setting and returning of errno.
    HEAP32[((___errno_state) >> 2)] = value;
    return value;
}

var PATH = {
    splitPath: function (filename) {
        var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
        return splitPathRe.exec(filename).slice(1);
    },
    normalizeArray: function (parts, allowAboveRoot) {
        // if the path tries to go above the root, `up` ends up > 0
        var up = 0;
        for (var i = parts.length - 1; i >= 0; i--) {
            var last = parts[i];
            if (last === '.') {
                parts.splice(i, 1);
            } else if (last === '..') {
                parts.splice(i, 1);
                up++;
            } else if (up) {
                parts.splice(i, 1);
                up--;
            }
        }
        // if the path is allowed to go above the root, restore leading ..s
        if (allowAboveRoot) {
            for (; up--; up) {
                parts.unshift('..');
            }
        }
        return parts;
    },
    normalize: function (path) {
        var isAbsolute = path.charAt(0) === '/',
            trailingSlash = path.substr(-1) === '/';
        // Normalize the path
        path = PATH.normalizeArray(path.split('/').filter(function (p) {
            return !!p;
        }), !isAbsolute).join('/');
        if (!path && !isAbsolute) {
            path = '.';
        }
        if (path && trailingSlash) {
            path += '/';
        }
        return (isAbsolute ? '/' : '') + path;
    },
    dirname: function (path) {
        var result = PATH.splitPath(path),
            root = result[0],
            dir = result[1];
        if (!root && !dir) {
            // No dirname whatsoever
            return '.';
        }
        if (dir) {
            // It has a dirname, strip trailing slash
            dir = dir.substr(0, dir.length - 1);
        }
        return root + dir;
    },
    basename: function (path) {
        // EMSCRIPTEN return '/'' for '/', not an empty string
        if (path === '/') return '/';
        var lastSlash = path.lastIndexOf('/');
        if (lastSlash === -1) return path;
        return path.substr(lastSlash + 1);
    },
    extname: function (path) {
        return PATH.splitPath(path)[3];
    },
    join: function () {
        var paths = Array.prototype.slice.call(arguments, 0);
        return PATH.normalize(paths.join('/'));
    },
    join2: function (l, r) {
        return PATH.normalize(l + '/' + r);
    },
    resolve: function () {
        var resolvedPath = '',
            resolvedAbsolute = false;
        for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
            var path = (i >= 0) ? arguments[i] : FS.cwd();
            // Skip empty and invalid entries
            if (typeof path !== 'string') {
                throw new TypeError('Arguments to path.resolve must be strings');
            } else if (!path) {
                continue;
            }
            resolvedPath = path + '/' + resolvedPath;
            resolvedAbsolute = path.charAt(0) === '/';
        }
        // At this point the path should be resolved to a full absolute path, but
        // handle relative paths to be safe (might happen when process.cwd() fails)
        resolvedPath = PATH.normalizeArray(resolvedPath.split('/').filter(function (p) {
            return !!p;
        }), !resolvedAbsolute).join('/');
        return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
    },
    relative: function (from, to) {
        from = PATH.resolve(from).substr(1);
        to = PATH.resolve(to).substr(1);

        function trim(arr) {
            var start = 0;
            for (; start < arr.length; start++) {
                if (arr[start] !== '') break;
            }
            var end = arr.length - 1;
            for (; end >= 0; end--) {
                if (arr[end] !== '') break;
            }
            if (start > end) return [];
            return arr.slice(start, end - start + 1);
        }
        var fromParts = trim(from.split('/'));
        var toParts = trim(to.split('/'));
        var length = Math.min(fromParts.length, toParts.length);
        var samePartsLength = length;
        for (var i = 0; i < length; i++) {
            if (fromParts[i] !== toParts[i]) {
                samePartsLength = i;
                break;
            }
        }
        var outputParts = [];
        for (var i = samePartsLength; i < fromParts.length; i++) {
            outputParts.push('..');
        }
        outputParts = outputParts.concat(toParts.slice(samePartsLength));
        return outputParts.join('/');
    }
};

var TTY = {
    ttys: [],
    init: function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // currently, FS.init does not distinguish if process.stdin is a file or TTY
        //   // device, it always assumes it's a TTY device. because of this, we're forcing
        //   // process.stdin to UTF8 encoding to at least make stdin reading compatible
        //   // with text files until FS.init can be refactored.
        //   process['stdin']['setEncoding']('utf8');
        // }
    },
    shutdown: function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // inolen: any idea as to why node -e 'process.stdin.read()' wouldn't exit immediately (with process.stdin being a tty)?
        //   // isaacs: because now it's reading from the stream, you've expressed interest in it, so that read() kicks off a _read() which creates a ReadReq operation
        //   // inolen: I thought read() in that case was a synchronous operation that just grabbed some amount of buffered data if it exists?
        //   // isaacs: it is. but it also triggers a _read() call, which calls readStart() on the handle
        //   // isaacs: do process.stdin.pause() and i'd think it'd probably close the pending call
        //   process['stdin']['pause']();
        // }
    },
    register: function (dev, ops) {
        TTY.ttys[dev] = {
            input: [],
            output: [],
            ops: ops
        };
        FS.registerDevice(dev, TTY.stream_ops);
    },
    stream_ops: {
        open: function (stream) {
            var tty = TTY.ttys[stream.node.rdev];
            if (!tty) {
                throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
            }
            stream.tty = tty;
            stream.seekable = false;
        },
        close: function (stream) {
            // flush any pending line data
            if (stream.tty.output.length) {
                stream.tty.ops.put_char(stream.tty, 10);
            }
        },
        read: function (stream, buffer, offset, length, pos /* ignored */ ) {
            if (!stream.tty || !stream.tty.ops.get_char) {
                throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
            }
            var bytesRead = 0;
            for (var i = 0; i < length; i++) {
                var result;
                try {
                    result = stream.tty.ops.get_char(stream.tty);
                } catch (e) {
                    throw new FS.ErrnoError(ERRNO_CODES.EIO);
                }
                if (result === undefined && bytesRead === 0) {
                    throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
                }
                if (result === null || result === undefined) break;
                bytesRead++;
                buffer[offset + i] = result;
            }
            if (bytesRead) {
                stream.node.timestamp = Date.now();
            }
            return bytesRead;
        },
        write: function (stream, buffer, offset, length, pos) {
            if (!stream.tty || !stream.tty.ops.put_char) {
                throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
            }
            for (var i = 0; i < length; i++) {
                try {
                    stream.tty.ops.put_char(stream.tty, buffer[offset + i]);
                } catch (e) {
                    throw new FS.ErrnoError(ERRNO_CODES.EIO);
                }
            }
            if (length) {
                stream.node.timestamp = Date.now();
            }
            return i;
        }
    },
    default_tty_ops: {
        get_char: function (tty) {
            if (!tty.input.length) {
                var result = null;
                if (ENVIRONMENT_IS_NODE) {
                    result = process['stdin']['read']();
                    if (!result) {
                        if (process['stdin']['_readableState'] && process['stdin']['_readableState']['ended']) {
                            return null; // EOF
                        }
                        return undefined; // no data available
                    }
                } else if (typeof window != 'undefined' &&
                    typeof window.prompt == 'function') {
                    // Browser.
                    result = window.prompt('Input: '); // returns null on cancel
                    if (result !== null) {
                        result += '\n';
                    }
                } else if (typeof readline == 'function') {
                    // Command line.
                    result = readline();
                    if (result !== null) {
                        result += '\n';
                    }
                }
                if (!result) {
                    return null;
                }
                tty.input = intArrayFromString(result, true);
            }
            return tty.input.shift();
        },
        put_char: function (tty, val) {
            if (val === null || val === 10) {
                Module['print'](tty.output.join(''));
                tty.output = [];
            } else {
                tty.output.push(TTY.utf8.processCChar(val));
            }
        }
    },
    default_tty1_ops: {
        put_char: function (tty, val) {
            if (val === null || val === 10) {
                Module['printErr'](tty.output.join(''));
                tty.output = [];
            } else {
                tty.output.push(TTY.utf8.processCChar(val));
            }
        }
    }
};

var MEMFS = {
    ops_table: null,
    CONTENT_OWNING: 1,
    CONTENT_FLEXIBLE: 2,
    CONTENT_FIXED: 3,
    mount: function (mount) {
        return MEMFS.createNode(null, '/', 16384 | 511 /* 0777 */ , 0);
    },
    createNode: function (parent, name, mode, dev) {
        if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
            // no supported
            throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (!MEMFS.ops_table) {
            MEMFS.ops_table = {
                dir: {
                    node: {
                        getattr: MEMFS.node_ops.getattr,
                        setattr: MEMFS.node_ops.setattr,
                        lookup: MEMFS.node_ops.lookup,
                        mknod: MEMFS.node_ops.mknod,
                        rename: MEMFS.node_ops.rename,
                        unlink: MEMFS.node_ops.unlink,
                        rmdir: MEMFS.node_ops.rmdir,
                        readdir: MEMFS.node_ops.readdir,
                        symlink: MEMFS.node_ops.symlink
                    },
                    stream: {
                        llseek: MEMFS.stream_ops.llseek
                    }
                },
                file: {
                    node: {
                        getattr: MEMFS.node_ops.getattr,
                        setattr: MEMFS.node_ops.setattr
                    },
                    stream: {
                        llseek: MEMFS.stream_ops.llseek,
                        read: MEMFS.stream_ops.read,
                        write: MEMFS.stream_ops.write,
                        allocate: MEMFS.stream_ops.allocate,
                        mmap: MEMFS.stream_ops.mmap
                    }
                },
                link: {
                    node: {
                        getattr: MEMFS.node_ops.getattr,
                        setattr: MEMFS.node_ops.setattr,
                        readlink: MEMFS.node_ops.readlink
                    },
                    stream: {}
                },
                chrdev: {
                    node: {
                        getattr: MEMFS.node_ops.getattr,
                        setattr: MEMFS.node_ops.setattr
                    },
                    stream: FS.chrdev_stream_ops
                },
            };
        }
        var node = FS.createNode(parent, name, mode, dev);
        if (FS.isDir(node.mode)) {
            node.node_ops = MEMFS.ops_table.dir.node;
            node.stream_ops = MEMFS.ops_table.dir.stream;
            node.contents = {};
        } else if (FS.isFile(node.mode)) {
            node.node_ops = MEMFS.ops_table.file.node;
            node.stream_ops = MEMFS.ops_table.file.stream;
            node.contents = [];
            node.contentMode = MEMFS.CONTENT_FLEXIBLE;
        } else if (FS.isLink(node.mode)) {
            node.node_ops = MEMFS.ops_table.link.node;
            node.stream_ops = MEMFS.ops_table.link.stream;
        } else if (FS.isChrdev(node.mode)) {
            node.node_ops = MEMFS.ops_table.chrdev.node;
            node.stream_ops = MEMFS.ops_table.chrdev.stream;
        }
        node.timestamp = Date.now();
        // add the new node to the parent
        if (parent) {
            parent.contents[name] = node;
        }
        return node;
    },
    ensureFlexible: function (node) {
        if (node.contentMode !== MEMFS.CONTENT_FLEXIBLE) {
            var contents = node.contents;
            node.contents = Array.prototype.slice.call(contents);
            node.contentMode = MEMFS.CONTENT_FLEXIBLE;
        }
    },
    node_ops: {
        getattr: function (node) {
            var attr = {};
            // device numbers reuse inode numbers.
            attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
            attr.ino = node.id;
            attr.mode = node.mode;
            attr.nlink = 1;
            attr.uid = 0;
            attr.gid = 0;
            attr.rdev = node.rdev;
            if (FS.isDir(node.mode)) {
                attr.size = 4096;
            } else if (FS.isFile(node.mode)) {
                attr.size = node.contents.length;
            } else if (FS.isLink(node.mode)) {
                attr.size = node.link.length;
            } else {
                attr.size = 0;
            }
            attr.atime = new Date(node.timestamp);
            attr.mtime = new Date(node.timestamp);
            attr.ctime = new Date(node.timestamp);
            // NOTE: In our implementation, st_blocks = Math.ceil(st_size/st_blksize),
            //       but this is not required by the standard.
            attr.blksize = 4096;
            attr.blocks = Math.ceil(attr.size / attr.blksize);
            return attr;
        },
        setattr: function (node, attr) {
            if (attr.mode !== undefined) {
                node.mode = attr.mode;
            }
            if (attr.timestamp !== undefined) {
                node.timestamp = attr.timestamp;
            }
            if (attr.size !== undefined) {
                MEMFS.ensureFlexible(node);
                var contents = node.contents;
                if (attr.size < contents.length) contents.length = attr.size;
                else
                    while (attr.size > contents.length) contents.push(0);
            }
        },
        lookup: function (parent, name) {
            throw FS.genericErrors[ERRNO_CODES.ENOENT];
        },
        mknod: function (parent, name, mode, dev) {
            return MEMFS.createNode(parent, name, mode, dev);
        },
        rename: function (old_node, new_dir, new_name) {
            // if we're overwriting a directory at new_name, make sure it's empty.
            if (FS.isDir(old_node.mode)) {
                var new_node;
                try {
                    new_node = FS.lookupNode(new_dir, new_name);
                } catch (e) {}
                if (new_node) {
                    for (var i in new_node.contents) {
                        throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
                    }
                }
            }
            // do the internal rewiring
            delete old_node.parent.contents[old_node.name];
            old_node.name = new_name;
            new_dir.contents[new_name] = old_node;
            old_node.parent = new_dir;
        },
        unlink: function (parent, name) {
            delete parent.contents[name];
        },
        rmdir: function (parent, name) {
            var node = FS.lookupNode(parent, name);
            for (var i in node.contents) {
                throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
            }
            delete parent.contents[name];
        },
        readdir: function (node) {
            var entries = ['.', '..']
            for (var key in node.contents) {
                if (!node.contents.hasOwnProperty(key)) {
                    continue;
                }
                entries.push(key);
            }
            return entries;
        },
        symlink: function (parent, newname, oldpath) {
            var node = MEMFS.createNode(parent, newname, 511 /* 0777 */ | 40960, 0);
            node.link = oldpath;
            return node;
        },
        readlink: function (node) {
            if (!FS.isLink(node.mode)) {
                throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
            }
            return node.link;
        }
    },
    stream_ops: {
        read: function (stream, buffer, offset, length, position) {
            var contents = stream.node.contents;
            if (position >= contents.length)
                return 0;
            var size = Math.min(contents.length - position, length);
            assert(size >= 0);
            if (size > 8 && contents.subarray) { // non-trivial, and typed array
                buffer.set(contents.subarray(position, position + size), offset);
            } else {
                for (var i = 0; i < size; i++) {
                    buffer[offset + i] = contents[position + i];
                }
            }
            return size;
        },
        write: function (stream, buffer, offset, length, position, canOwn) {
            var node = stream.node;
            node.timestamp = Date.now();
            var contents = node.contents;
            if (length && contents.length === 0 && position === 0 && buffer.subarray) {
                // just replace it with the new data
                if (canOwn && offset === 0) {
                    node.contents = buffer; // this could be a subarray of Emscripten HEAP, or allocated from some other source.
                    node.contentMode = (buffer.buffer === HEAP8.buffer) ? MEMFS.CONTENT_OWNING : MEMFS.CONTENT_FIXED;
                } else {
                    node.contents = new Uint8Array(buffer.subarray(offset, offset + length));
                    node.contentMode = MEMFS.CONTENT_FIXED;
                }
                return length;
            }
            MEMFS.ensureFlexible(node);
            var contents = node.contents;
            while (contents.length < position) contents.push(0);
            for (var i = 0; i < length; i++) {
                contents[position + i] = buffer[offset + i];
            }
            return length;
        },
        llseek: function (stream, offset, whence) {
            var position = offset;
            if (whence === 1) { // SEEK_CUR.
                position += stream.position;
            } else if (whence === 2) { // SEEK_END.
                if (FS.isFile(stream.node.mode)) {
                    position += stream.node.contents.length;
                }
            }
            if (position < 0) {
                throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
            }
            stream.ungotten = [];
            stream.position = position;
            return position;
        },
        allocate: function (stream, offset, length) {
            MEMFS.ensureFlexible(stream.node);
            var contents = stream.node.contents;
            var limit = offset + length;
            while (limit > contents.length) contents.push(0);
        },
        mmap: function (stream, buffer, offset, length, position, prot, flags) {
            if (!FS.isFile(stream.node.mode)) {
                throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
            }
            var ptr;
            var allocated;
            var contents = stream.node.contents;
            // Only make a new copy when MAP_PRIVATE is specified.
            if (!(flags & 2) &&
                (contents.buffer === buffer || contents.buffer === buffer.buffer)) {
                // We can't emulate MAP_SHARED when the file is not backed by the buffer
                // we're mapping to (e.g. the HEAP buffer).
                allocated = false;
                ptr = contents.byteOffset;
            } else {
                // Try to avoid unnecessary slices.
                if (position > 0 || position + length < contents.length) {
                    if (contents.subarray) {
                        contents = contents.subarray(position, position + length);
                    } else {
                        contents = Array.prototype.slice.call(contents, position, position + length);
                    }
                }
                allocated = true;
                ptr = _malloc(length);
                if (!ptr) {
                    throw new FS.ErrnoError(ERRNO_CODES.ENOMEM);
                }
                buffer.set(contents, ptr);
            }
            return {
                ptr: ptr,
                allocated: allocated
            };
        }
    }
};

var IDBFS = {
    dbs: {},
    indexedDB: function () {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
    },
    DB_VERSION: 21,
    DB_STORE_NAME: "FILE_DATA",
    mount: function (mount) {
        // reuse all of the core MEMFS functionality
        return MEMFS.mount.apply(null, arguments);
    },
    syncfs: function (mount, populate, callback) {
        IDBFS.getLocalSet(mount, function (err, local) {
            if (err) return callback(err);

            IDBFS.getRemoteSet(mount, function (err, remote) {
                if (err) return callback(err);

                var src = populate ? remote : local;
                var dst = populate ? local : remote;

                IDBFS.reconcile(src, dst, callback);
            });
        });
    },
    getDB: function (name, callback) {
        // check the cache first
        var db = IDBFS.dbs[name];
        if (db) {
            return callback(null, db);
        }

        var req;
        try {
            req = IDBFS.indexedDB().open(name, IDBFS.DB_VERSION);
        } catch (e) {
            return callback(e);
        }
        req.onupgradeneeded = function (e) {
            var db = e.target.result;
            var transaction = e.target.transaction;

            var fileStore;

            if (db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)) {
                fileStore = transaction.objectStore(IDBFS.DB_STORE_NAME);
            } else {
                fileStore = db.createObjectStore(IDBFS.DB_STORE_NAME);
            }

            fileStore.createIndex('timestamp', 'timestamp', {
                unique: false
            });
        };
        req.onsuccess = function () {
            db = req.result;

            // add to the cache
            IDBFS.dbs[name] = db;
            callback(null, db);
        };
        req.onerror = function () {
            callback(this.error);
        };
    },
    getLocalSet: function (mount, callback) {
        var entries = {};

        function isRealDir(p) {
            return p !== '.' && p !== '..';
        };

        function toAbsolute(root) {
            return function (p) {
                return PATH.join2(root, p);
            }
        };

        var check = FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));

        while (check.length) {
            var path = check.pop();
            var stat;

            try {
                stat = FS.stat(path);
            } catch (e) {
                return callback(e);
            }

            if (FS.isDir(stat.mode)) {
                check.push.apply(check, FS.readdir(path).filter(isRealDir).map(toAbsolute(path)));
            }

            entries[path] = {
                timestamp: stat.mtime
            };
        }

        return callback(null, {
            type: 'local',
            entries: entries
        });
    },
    getRemoteSet: function (mount, callback) {
        var entries = {};

        IDBFS.getDB(mount.mountpoint, function (err, db) {
            if (err) return callback(err);

            var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readonly');
            transaction.onerror = function () {
                callback(this.error);
            };

            var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
            var index = store.index('timestamp');

            index.openKeyCursor().onsuccess = function (event) {
                var cursor = event.target.result;

                if (!cursor) {
                    return callback(null, {
                        type: 'remote',
                        db: db,
                        entries: entries
                    });
                }

                entries[cursor.primaryKey] = {
                    timestamp: cursor.key
                };

                cursor.continue();
            };
        });
    },
    loadLocalEntry: function (path, callback) {
        var stat, node;

        try {
            var lookup = FS.lookupPath(path);
            node = lookup.node;
            stat = FS.stat(path);
        } catch (e) {
            return callback(e);
        }

        if (FS.isDir(stat.mode)) {
            return callback(null, {
                timestamp: stat.mtime,
                mode: stat.mode
            });
        } else if (FS.isFile(stat.mode)) {
            return callback(null, {
                timestamp: stat.mtime,
                mode: stat.mode,
                contents: node.contents
            });
        } else {
            return callback(new Error('node type not supported'));
        }
    },
    storeLocalEntry: function (path, entry, callback) {
        try {
            if (FS.isDir(entry.mode)) {
                FS.mkdir(path, entry.mode);
            } else if (FS.isFile(entry.mode)) {
                FS.writeFile(path, entry.contents, {
                    encoding: 'binary',
                    canOwn: true
                });
            } else {
                return callback(new Error('node type not supported'));
            }

            FS.utime(path, entry.timestamp, entry.timestamp);
        } catch (e) {
            return callback(e);
        }

        callback(null);
    },
    removeLocalEntry: function (path, callback) {
        try {
            var lookup = FS.lookupPath(path);
            var stat = FS.stat(path);

            if (FS.isDir(stat.mode)) {
                FS.rmdir(path);
            } else if (FS.isFile(stat.mode)) {
                FS.unlink(path);
            }
        } catch (e) {
            return callback(e);
        }

        callback(null);
    },
    loadRemoteEntry: function (store, path, callback) {
        var req = store.get(path);
        req.onsuccess = function (event) {
            callback(null, event.target.result);
        };
        req.onerror = function () {
            callback(this.error);
        };
    },
    storeRemoteEntry: function (store, path, entry, callback) {
        var req = store.put(entry, path);
        req.onsuccess = function () {
            callback(null);
        };
        req.onerror = function () {
            callback(this.error);
        };
    },
    removeRemoteEntry: function (store, path, callback) {
        var req = store.delete(path);
        req.onsuccess = function () {
            callback(null);
        };
        req.onerror = function () {
            callback(this.error);
        };
    },
    reconcile: function (src, dst, callback) {
        var total = 0;

        var create = [];
        Object.keys(src.entries).forEach(function (key) {
            var e = src.entries[key];
            var e2 = dst.entries[key];
            if (!e2 || e.timestamp > e2.timestamp) {
                create.push(key);
                total++;
            }
        });

        var remove = [];
        Object.keys(dst.entries).forEach(function (key) {
            var e = dst.entries[key];
            var e2 = src.entries[key];
            if (!e2) {
                remove.push(key);
                total++;
            }
        });

        if (!total) {
            return callback(null);
        }

        var errored = false;
        var completed = 0;
        var db = src.type === 'remote' ? src.db : dst.db;
        var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readwrite');
        var store = transaction.objectStore(IDBFS.DB_STORE_NAME);

        function done(err) {
            if (err) {
                if (!done.errored) {
                    done.errored = true;
                    return callback(err);
                }
                return;
            }
            if (++completed >= total) {
                return callback(null);
            }
        };

        transaction.onerror = function () {
            done(this.error);
        };

        // sort paths in ascending order so directory entries are created
        // before the files inside them
        create.sort().forEach(function (path) {
            if (dst.type === 'local') {
                IDBFS.loadRemoteEntry(store, path, function (err, entry) {
                    if (err) return done(err);
                    IDBFS.storeLocalEntry(path, entry, done);
                });
            } else {
                IDBFS.loadLocalEntry(path, function (err, entry) {
                    if (err) return done(err);
                    IDBFS.storeRemoteEntry(store, path, entry, done);
                });
            }
        });

        // sort paths in descending order so files are deleted before their
        // parent directories
        remove.sort().reverse().forEach(function (path) {
            if (dst.type === 'local') {
                IDBFS.removeLocalEntry(path, done);
            } else {
                IDBFS.removeRemoteEntry(store, path, done);
            }
        });
    }
};

var NODEFS = {
    isWindows: false,
    staticInit: function () {
        NODEFS.isWindows = !!process.platform.match(/^win/);
    },
    mount: function (mount) {
        assert(ENVIRONMENT_IS_NODE);
        return NODEFS.createNode(null, '/', NODEFS.getMode(mount.opts.root), 0);
    },
    createNode: function (parent, name, mode, dev) {
        if (!FS.isDir(mode) && !FS.isFile(mode) && !FS.isLink(mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node = FS.createNode(parent, name, mode);
        node.node_ops = NODEFS.node_ops;
        node.stream_ops = NODEFS.stream_ops;
        return node;
    },
    getMode: function (path) {
        var stat;
        try {
            stat = fs.lstatSync(path);
            if (NODEFS.isWindows) {
                // On Windows, directories return permission bits 'rw-rw-rw-', even though they have 'rwxrwxrwx', so 
                // propagate write bits to execute bits.
                stat.mode = stat.mode | ((stat.mode & 146) >> 1);
            }
        } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
        }
        return stat.mode;
    },
    realPath: function (node) {
        var parts = [];
        while (node.parent !== node) {
            parts.push(node.name);
            node = node.parent;
        }
        parts.push(node.mount.opts.root);
        parts.reverse();
        return PATH.join.apply(null, parts);
    },
    flagsToPermissionStringMap: {
        0: "r",
        1: "r+",
        2: "r+",
        64: "r",
        65: "r+",
        66: "r+",
        129: "rx+",
        193: "rx+",
        514: "w+",
        577: "w",
        578: "w+",
        705: "wx",
        706: "wx+",
        1024: "a",
        1025: "a",
        1026: "a+",
        1089: "a",
        1090: "a+",
        1153: "ax",
        1154: "ax+",
        1217: "ax",
        1218: "ax+",
        4096: "rs",
        4098: "rs+"
    },
    flagsToPermissionString: function (flags) {
        if (flags in NODEFS.flagsToPermissionStringMap) {
            return NODEFS.flagsToPermissionStringMap[flags];
        } else {
            return flags;
        }
    },
    node_ops: {
        getattr: function (node) {
            var path = NODEFS.realPath(node);
            var stat;
            try {
                stat = fs.lstatSync(path);
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
            }
            // node.js v0.10.20 doesn't report blksize and blocks on Windows. Fake them with default blksize of 4096.
            // See http://support.microsoft.com/kb/140365
            if (NODEFS.isWindows && !stat.blksize) {
                stat.blksize = 4096;
            }
            if (NODEFS.isWindows && !stat.blocks) {
                stat.blocks = (stat.size + stat.blksize - 1) / stat.blksize | 0;
            }
            return {
                dev: stat.dev,
                ino: stat.ino,
                mode: stat.mode,
                nlink: stat.nlink,
                uid: stat.uid,
                gid: stat.gid,
                rdev: stat.rdev,
                size: stat.size,
                atime: stat.atime,
                mtime: stat.mtime,
                ctime: stat.ctime,
                blksize: stat.blksize,
                blocks: stat.blocks
            };
        },
        setattr: function (node, attr) {
            var path = NODEFS.realPath(node);
            try {
                if (attr.mode !== undefined) {
                    fs.chmodSync(path, attr.mode);
                    // update the common node structure mode as well
                    node.mode = attr.mode;
                }
                if (attr.timestamp !== undefined) {
                    var date = new Date(attr.timestamp);
                    fs.utimesSync(path, date, date);
                }
                if (attr.size !== undefined) {
                    fs.truncateSync(path, attr.size);
                }
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
            }
        },
        lookup: function (parent, name) {
            var path = PATH.join2(NODEFS.realPath(parent), name);
            var mode = NODEFS.getMode(path);
            return NODEFS.createNode(parent, name, mode);
        },
        mknod: function (parent, name, mode, dev) {
            var node = NODEFS.createNode(parent, name, mode, dev);
            // create the backing node for this in the fs root as well
            var path = NODEFS.realPath(node);
            try {
                if (FS.isDir(node.mode)) {
                    fs.mkdirSync(path, node.mode);
                } else {
                    fs.writeFileSync(path, '', {
                        mode: node.mode
                    });
                }
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
            }
            return node;
        },
        rename: function (oldNode, newDir, newName) {
            var oldPath = NODEFS.realPath(oldNode);
            var newPath = PATH.join2(NODEFS.realPath(newDir), newName);
            try {
                fs.renameSync(oldPath, newPath);
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
            }
        },
        unlink: function (parent, name) {
            var path = PATH.join2(NODEFS.realPath(parent), name);
            try {
                fs.unlinkSync(path);
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
            }
        },
        rmdir: function (parent, name) {
            var path = PATH.join2(NODEFS.realPath(parent), name);
            try {
                fs.rmdirSync(path);
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
            }
        },
        readdir: function (node) {
            var path = NODEFS.realPath(node);
            try {
                return fs.readdirSync(path);
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
            }
        },
        symlink: function (parent, newName, oldPath) {
            var newPath = PATH.join2(NODEFS.realPath(parent), newName);
            try {
                fs.symlinkSync(oldPath, newPath);
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
            }
        },
        readlink: function (node) {
            var path = NODEFS.realPath(node);
            try {
                return fs.readlinkSync(path);
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
            }
        }
    },
    stream_ops: {
        open: function (stream) {
            var path = NODEFS.realPath(stream.node);
            try {
                if (FS.isFile(stream.node.mode)) {
                    stream.nfd = fs.openSync(path, NODEFS.flagsToPermissionString(stream.flags));
                }
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
            }
        },
        close: function (stream) {
            try {
                if (FS.isFile(stream.node.mode) && stream.nfd) {
                    fs.closeSync(stream.nfd);
                }
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
            }
        },
        read: function (stream, buffer, offset, length, position) {
            // FIXME this is terrible.
            var nbuffer = new Buffer(length);
            var res;
            try {
                res = fs.readSync(stream.nfd, nbuffer, 0, length, position);
            } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
            }
            if (res > 0) {
                for (var i = 0; i < res; i++) {
                    buffer[offset + i] = nbuffer[i];
                }
            }
            return res;
        },
        write: function (stream, buffer, offset, length, position) {
            // FIXME this is terrible.
            var nbuffer = new Buffer(buffer.subarray(offset, offset + length));
            var res;
            try {
                res = fs.writeSync(stream.nfd, nbuffer, 0, length, position);
            } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
            }
            return res;
        },
        llseek: function (stream, offset, whence) {
            var position = offset;
            if (whence === 1) { // SEEK_CUR.
                position += stream.position;
            } else if (whence === 2) { // SEEK_END.
                if (FS.isFile(stream.node.mode)) {
                    try {
                        var stat = fs.fstatSync(stream.nfd);
                        position += stat.size;
                    } catch (e) {
                        throw new FS.ErrnoError(ERRNO_CODES[e.code]);
                    }
                }
            }

            if (position < 0) {
                throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
            }

            stream.position = position;
            return position;
        }
    }
};

var _stdin = allocate(1, "i32*", ALLOC_STATIC);

var _stdout = allocate(1, "i32*", ALLOC_STATIC);

var _stderr = allocate(1, "i32*", ALLOC_STATIC);
var FS = {
    root: null,
    mounts: [],
    devices: [null],
    streams: [],
    nextInode: 1,
    nameTable: null,
    currentPath: "/",
    initialized: false,
    ignorePermissions: true,
    ErrnoError: null,
    genericErrors: {},
    handleFSError: function (e) {
        if (!(e instanceof FS.ErrnoError)) throw e + ' : ' + stackTrace();
        return ___setErrNo(e.errno);
    },
    lookupPath: function (path, opts) {
        path = PATH.resolve(FS.cwd(), path);
        opts = opts || {};

        var defaults = {
            follow_mount: true,
            recurse_count: 0
        };
        for (var key in defaults) {
            if (opts[key] === undefined) {
                opts[key] = defaults[key];
            }
        }

        if (opts.recurse_count > 8) { // max recursive lookup of 8
            throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
        }

        // split the path
        var parts = PATH.normalizeArray(path.split('/').filter(function (p) {
            return !!p;
        }), false);

        // start at the root
        var current = FS.root;
        var current_path = '/';

        for (var i = 0; i < parts.length; i++) {
            var islast = (i === parts.length - 1);
            if (islast && opts.parent) {
                // stop resolving
                break;
            }

            current = FS.lookupNode(current, parts[i]);
            current_path = PATH.join2(current_path, parts[i]);

            // jump to the mount's root node if this is a mountpoint
            if (FS.isMountpoint(current)) {
                if (!islast || (islast && opts.follow_mount)) {
                    current = current.mounted.root;
                }
            }

            // by default, lookupPath will not follow a symlink if it is the final path component.
            // setting opts.follow = true will override this behavior.
            if (!islast || opts.follow) {
                var count = 0;
                while (FS.isLink(current.mode)) {
                    var link = FS.readlink(current_path);
                    current_path = PATH.resolve(PATH.dirname(current_path), link);

                    var lookup = FS.lookupPath(current_path, {
                        recurse_count: opts.recurse_count
                    });
                    current = lookup.node;

                    if (count++ > 40) { // limit max consecutive symlinks to 40 (SYMLOOP_MAX).
                        throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
                    }
                }
            }
        }

        return {
            path: current_path,
            node: current
        };
    },
    getPath: function (node) {
        var path;
        while (true) {
            if (FS.isRoot(node)) {
                var mount = node.mount.mountpoint;
                if (!path) return mount;
                return mount[mount.length - 1] !== '/' ? mount + '/' + path : mount + path;
            }
            path = path ? node.name + '/' + path : node.name;
            node = node.parent;
        }
    },
    hashName: function (parentid, name) {
        var hash = 0;


        for (var i = 0; i < name.length; i++) {
            hash = ((hash << 5) - hash + name.charCodeAt(i)) | 0;
        }
        return ((parentid + hash) >>> 0) % FS.nameTable.length;
    },
    hashAddNode: function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        node.name_next = FS.nameTable[hash];
        FS.nameTable[hash] = node;
    },
    hashRemoveNode: function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        if (FS.nameTable[hash] === node) {
            FS.nameTable[hash] = node.name_next;
        } else {
            var current = FS.nameTable[hash];
            while (current) {
                if (current.name_next === node) {
                    current.name_next = node.name_next;
                    break;
                }
                current = current.name_next;
            }
        }
    },
    lookupNode: function (parent, name) {
        var err = FS.mayLookup(parent);
        if (err) {
            throw new FS.ErrnoError(err);
        }
        var hash = FS.hashName(parent.id, name);
        for (var node = FS.nameTable[hash]; node; node = node.name_next) {
            var nodeName = node.name;
            if (node.parent.id === parent.id && nodeName === name) {
                return node;
            }
        }
        // if we failed to find it in the cache, call into the VFS
        return FS.lookup(parent, name);
    },
    createNode: function (parent, name, mode, rdev) {
        if (!FS.FSNode) {
            FS.FSNode = function (parent, name, mode, rdev) {
                if (!parent) {
                    parent = this; // root node sets parent to itself
                }
                this.parent = parent;
                this.mount = parent.mount;
                this.mounted = null;
                this.id = FS.nextInode++;
                this.name = name;
                this.mode = mode;
                this.node_ops = {};
                this.stream_ops = {};
                this.rdev = rdev;
            };

            FS.FSNode.prototype = {};

            // compatibility
            var readMode = 292 | 73;
            var writeMode = 146;

            // NOTE we must use Object.defineProperties instead of individual calls to
            // Object.defineProperty in order to make closure compiler happy
            Object.defineProperties(FS.FSNode.prototype, {
                read: {
                    get: function () {
                        return (this.mode & readMode) === readMode;
                    },
                    set: function (val) {
                        val ? this.mode |= readMode : this.mode &= ~readMode;
                    }
                },
                write: {
                    get: function () {
                        return (this.mode & writeMode) === writeMode;
                    },
                    set: function (val) {
                        val ? this.mode |= writeMode : this.mode &= ~writeMode;
                    }
                },
                isFolder: {
                    get: function () {
                        return FS.isDir(this.mode);
                    },
                },
                isDevice: {
                    get: function () {
                        return FS.isChrdev(this.mode);
                    },
                },
            });
        }

        var node = new FS.FSNode(parent, name, mode, rdev);

        FS.hashAddNode(node);

        return node;
    },
    destroyNode: function (node) {
        FS.hashRemoveNode(node);
    },
    isRoot: function (node) {
        return node === node.parent;
    },
    isMountpoint: function (node) {
        return !!node.mounted;
    },
    isFile: function (mode) {
        return (mode & 61440) === 32768;
    },
    isDir: function (mode) {
        return (mode & 61440) === 16384;
    },
    isLink: function (mode) {
        return (mode & 61440) === 40960;
    },
    isChrdev: function (mode) {
        return (mode & 61440) === 8192;
    },
    isBlkdev: function (mode) {
        return (mode & 61440) === 24576;
    },
    isFIFO: function (mode) {
        return (mode & 61440) === 4096;
    },
    isSocket: function (mode) {
        return (mode & 49152) === 49152;
    },
    flagModes: {
        "r": 0,
        "rs": 1052672,
        "r+": 2,
        "w": 577,
        "wx": 705,
        "xw": 705,
        "w+": 578,
        "wx+": 706,
        "xw+": 706,
        "a": 1089,
        "ax": 1217,
        "xa": 1217,
        "a+": 1090,
        "ax+": 1218,
        "xa+": 1218
    },
    modeStringToFlags: function (str) {
        var flags = FS.flagModes[str];
        if (typeof flags === 'undefined') {
            throw new Error('Unknown file open mode: ' + str);
        }
        return flags;
    },
    flagsToPermissionString: function (flag) {
        var accmode = flag & 2097155;
        var perms = ['r', 'w', 'rw'][accmode];
        if ((flag & 512)) {
            perms += 'w';
        }
        return perms;
    },
    nodePermissions: function (node, perms) {
        if (FS.ignorePermissions) {
            return 0;
        }
        // return 0 if any user, group or owner bits are set.
        if (perms.indexOf('r') !== -1 && !(node.mode & 292)) {
            return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('w') !== -1 && !(node.mode & 146)) {
            return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('x') !== -1 && !(node.mode & 73)) {
            return ERRNO_CODES.EACCES;
        }
        return 0;
    },
    mayLookup: function (dir) {
        return FS.nodePermissions(dir, 'x');
    },
    mayCreate: function (dir, name) {
        try {
            var node = FS.lookupNode(dir, name);
            return ERRNO_CODES.EEXIST;
        } catch (e) {}
        return FS.nodePermissions(dir, 'wx');
    },
    mayDelete: function (dir, name, isdir) {
        var node;
        try {
            node = FS.lookupNode(dir, name);
        } catch (e) {
            return e.errno;
        }
        var err = FS.nodePermissions(dir, 'wx');
        if (err) {
            return err;
        }
        if (isdir) {
            if (!FS.isDir(node.mode)) {
                return ERRNO_CODES.ENOTDIR;
            }
            if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
                return ERRNO_CODES.EBUSY;
            }
        } else {
            if (FS.isDir(node.mode)) {
                return ERRNO_CODES.EISDIR;
            }
        }
        return 0;
    },
    mayOpen: function (node, flags) {
        if (!node) {
            return ERRNO_CODES.ENOENT;
        }
        if (FS.isLink(node.mode)) {
            return ERRNO_CODES.ELOOP;
        } else if (FS.isDir(node.mode)) {
            if ((flags & 2097155) !== 0 || // opening for write
                (flags & 512)) {
                return ERRNO_CODES.EISDIR;
            }
        }
        return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
    },
    MAX_OPEN_FDS: 4096,
    nextfd: function (fd_start, fd_end) {
        fd_start = fd_start || 0;
        fd_end = fd_end || FS.MAX_OPEN_FDS;
        for (var fd = fd_start; fd <= fd_end; fd++) {
            if (!FS.streams[fd]) {
                return fd;
            }
        }
        throw new FS.ErrnoError(ERRNO_CODES.EMFILE);
    },
    getStream: function (fd) {
        return FS.streams[fd];
    },
    createStream: function (stream, fd_start, fd_end) {
        if (!FS.FSStream) {
            FS.FSStream = function () {};
            FS.FSStream.prototype = {};
            // compatibility
            Object.defineProperties(FS.FSStream.prototype, {
                object: {
                    get: function () {
                        return this.node;
                    },
                    set: function (val) {
                        this.node = val;
                    }
                },
                isRead: {
                    get: function () {
                        return (this.flags & 2097155) !== 1;
                    }
                },
                isWrite: {
                    get: function () {
                        return (this.flags & 2097155) !== 0;
                    }
                },
                isAppend: {
                    get: function () {
                        return (this.flags & 1024);
                    }
                }
            });
        }
        if (stream.__proto__) {
            // reuse the object
            stream.__proto__ = FS.FSStream.prototype;
        } else {
            var newStream = new FS.FSStream();
            for (var p in stream) {
                newStream[p] = stream[p];
            }
            stream = newStream;
        }
        var fd = FS.nextfd(fd_start, fd_end);
        stream.fd = fd;
        FS.streams[fd] = stream;
        return stream;
    },
    closeStream: function (fd) {
        FS.streams[fd] = null;
    },
    getStreamFromPtr: function (ptr) {
        return FS.streams[ptr - 1];
    },
    getPtrForStream: function (stream) {
        return stream ? stream.fd + 1 : 0;
    },
    chrdev_stream_ops: {
        open: function (stream) {
            var device = FS.getDevice(stream.node.rdev);
            // override node's stream ops with the device's
            stream.stream_ops = device.stream_ops;
            // forward the open call
            if (stream.stream_ops.open) {
                stream.stream_ops.open(stream);
            }
        },
        llseek: function () {
            throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
    },
    major: function (dev) {
        return ((dev) >> 8);
    },
    minor: function (dev) {
        return ((dev) & 0xff);
    },
    makedev: function (ma, mi) {
        return ((ma) << 8 | (mi));
    },
    registerDevice: function (dev, ops) {
        FS.devices[dev] = {
            stream_ops: ops
        };
    },
    getDevice: function (dev) {
        return FS.devices[dev];
    },
    getMounts: function (mount) {
        var mounts = [];
        var check = [mount];

        while (check.length) {
            var m = check.pop();

            mounts.push(m);

            check.push.apply(check, m.mounts);
        }

        return mounts;
    },
    syncfs: function (populate, callback) {
        if (typeof (populate) === 'function') {
            callback = populate;
            populate = false;
        }

        var mounts = FS.getMounts(FS.root.mount);
        var completed = 0;

        function done(err) {
            if (err) {
                if (!done.errored) {
                    done.errored = true;
                    return callback(err);
                }
                return;
            }
            if (++completed >= mounts.length) {
                callback(null);
            }
        };

        // sync all mounts
        mounts.forEach(function (mount) {
            if (!mount.type.syncfs) {
                return done(null);
            }
            mount.type.syncfs(mount, populate, done);
        });
    },
    mount: function (type, opts, mountpoint) {
        var root = mountpoint === '/';
        var pseudo = !mountpoint;
        var node;

        if (root && FS.root) {
            throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        } else if (!root && !pseudo) {
            var lookup = FS.lookupPath(mountpoint, {
                follow_mount: false
            });

            mountpoint = lookup.path; // use the absolute path
            node = lookup.node;

            if (FS.isMountpoint(node)) {
                throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
            }

            if (!FS.isDir(node.mode)) {
                throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
            }
        }

        var mount = {
            type: type,
            opts: opts,
            mountpoint: mountpoint,
            mounts: []
        };

        // create a root node for the fs
        var mountRoot = type.mount(mount);
        mountRoot.mount = mount;
        mount.root = mountRoot;

        if (root) {
            FS.root = mountRoot;
        } else if (node) {
            // set as a mountpoint
            node.mounted = mount;

            // add the new mount to the current mount's children
            if (node.mount) {
                node.mount.mounts.push(mount);
            }
        }

        return mountRoot;
    },
    unmount: function (mountpoint) {
        var lookup = FS.lookupPath(mountpoint, {
            follow_mount: false
        });

        if (!FS.isMountpoint(lookup.node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }

        // destroy the nodes for this mount, and all its child mounts
        var node = lookup.node;
        var mount = node.mounted;
        var mounts = FS.getMounts(mount);

        Object.keys(FS.nameTable).forEach(function (hash) {
            var current = FS.nameTable[hash];

            while (current) {
                var next = current.name_next;

                if (mounts.indexOf(current.mount) !== -1) {
                    FS.destroyNode(current);
                }

                current = next;
            }
        });

        // no longer a mountpoint
        node.mounted = null;

        // remove this mount from the child mounts
        var idx = node.mount.mounts.indexOf(mount);
        assert(idx !== -1);
        node.mount.mounts.splice(idx, 1);
    },
    lookup: function (parent, name) {
        return parent.node_ops.lookup(parent, name);
    },
    mknod: function (path, mode, dev) {
        var lookup = FS.lookupPath(path, {
            parent: true
        });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var err = FS.mayCreate(parent, name);
        if (err) {
            throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.mknod) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.mknod(parent, name, mode, dev);
    },
    create: function (path, mode) {
        mode = mode !== undefined ? mode : 438 /* 0666 */ ;
        mode &= 4095;
        mode |= 32768;
        return FS.mknod(path, mode, 0);
    },
    mkdir: function (path, mode) {
        mode = mode !== undefined ? mode : 511 /* 0777 */ ;
        mode &= 511 | 512;
        mode |= 16384;
        return FS.mknod(path, mode, 0);
    },
    mkdev: function (path, mode, dev) {
        if (typeof (dev) === 'undefined') {
            dev = mode;
            mode = 438 /* 0666 */ ;
        }
        mode |= 8192;
        return FS.mknod(path, mode, dev);
    },
    symlink: function (oldpath, newpath) {
        var lookup = FS.lookupPath(newpath, {
            parent: true
        });
        var parent = lookup.node;
        var newname = PATH.basename(newpath);
        var err = FS.mayCreate(parent, newname);
        if (err) {
            throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.symlink) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.symlink(parent, newname, oldpath);
    },
    rename: function (old_path, new_path) {
        var old_dirname = PATH.dirname(old_path);
        var new_dirname = PATH.dirname(new_path);
        var old_name = PATH.basename(old_path);
        var new_name = PATH.basename(new_path);
        // parents must exist
        var lookup, old_dir, new_dir;
        try {
            lookup = FS.lookupPath(old_path, {
                parent: true
            });
            old_dir = lookup.node;
            lookup = FS.lookupPath(new_path, {
                parent: true
            });
            new_dir = lookup.node;
        } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // need to be part of the same mount
        if (old_dir.mount !== new_dir.mount) {
            throw new FS.ErrnoError(ERRNO_CODES.EXDEV);
        }
        // source must exist
        var old_node = FS.lookupNode(old_dir, old_name);
        // old path should not be an ancestor of the new path
        var relative = PATH.relative(old_path, new_dirname);
        if (relative.charAt(0) !== '.') {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        // new path should not be an ancestor of the old path
        relative = PATH.relative(new_path, old_dirname);
        if (relative.charAt(0) !== '.') {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
        }
        // see if the new path already exists
        var new_node;
        try {
            new_node = FS.lookupNode(new_dir, new_name);
        } catch (e) {
            // not fatal
        }
        // early out if nothing needs to change
        if (old_node === new_node) {
            return;
        }
        // we'll need to delete the old entry
        var isdir = FS.isDir(old_node.mode);
        var err = FS.mayDelete(old_dir, old_name, isdir);
        if (err) {
            throw new FS.ErrnoError(err);
        }
        // need delete permissions if we'll be overwriting.
        // need create permissions if new doesn't already exist.
        err = new_node ?
            FS.mayDelete(new_dir, new_name, isdir) :
            FS.mayCreate(new_dir, new_name);
        if (err) {
            throw new FS.ErrnoError(err);
        }
        if (!old_dir.node_ops.rename) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(old_node) || (new_node && FS.isMountpoint(new_node))) {
            throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // if we are going to change the parent, check write permissions
        if (new_dir !== old_dir) {
            err = FS.nodePermissions(old_dir, 'w');
            if (err) {
                throw new FS.ErrnoError(err);
            }
        }
        // remove the node from the lookup hash
        FS.hashRemoveNode(old_node);
        // do the underlying fs rename
        try {
            old_dir.node_ops.rename(old_node, new_dir, new_name);
        } catch (e) {
            throw e;
        } finally {
            // add the node back to the hash (in case node_ops.rename
            // changed its name)
            FS.hashAddNode(old_node);
        }
    },
    rmdir: function (path) {
        var lookup = FS.lookupPath(path, {
            parent: true
        });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, true);
        if (err) {
            throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.rmdir) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        parent.node_ops.rmdir(parent, name);
        FS.destroyNode(node);
    },
    readdir: function (path) {
        var lookup = FS.lookupPath(path, {
            follow: true
        });
        var node = lookup.node;
        if (!node.node_ops.readdir) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        return node.node_ops.readdir(node);
    },
    unlink: function (path) {
        var lookup = FS.lookupPath(path, {
            parent: true
        });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, false);
        if (err) {
            // POSIX says unlink should set EPERM, not EISDIR
            if (err === ERRNO_CODES.EISDIR) err = ERRNO_CODES.EPERM;
            throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.unlink) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        parent.node_ops.unlink(parent, name);
        FS.destroyNode(node);
    },
    readlink: function (path) {
        var lookup = FS.lookupPath(path);
        var link = lookup.node;
        if (!link.node_ops.readlink) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        return link.node_ops.readlink(link);
    },
    stat: function (path, dontFollow) {
        var lookup = FS.lookupPath(path, {
            follow: !dontFollow
        });
        var node = lookup.node;
        if (!node.node_ops.getattr) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return node.node_ops.getattr(node);
    },
    lstat: function (path) {
        return FS.stat(path, true);
    },
    chmod: function (path, mode, dontFollow) {
        var node;
        if (typeof path === 'string') {
            var lookup = FS.lookupPath(path, {
                follow: !dontFollow
            });
            node = lookup.node;
        } else {
            node = path;
        }
        if (!node.node_ops.setattr) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
            mode: (mode & 4095) | (node.mode & ~4095),
            timestamp: Date.now()
        });
    },
    lchmod: function (path, mode) {
        FS.chmod(path, mode, true);
    },
    fchmod: function (fd, mode) {
        var stream = FS.getStream(fd);
        if (!stream) {
            throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chmod(stream.node, mode);
    },
    chown: function (path, uid, gid, dontFollow) {
        var node;
        if (typeof path === 'string') {
            var lookup = FS.lookupPath(path, {
                follow: !dontFollow
            });
            node = lookup.node;
        } else {
            node = path;
        }
        if (!node.node_ops.setattr) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
            timestamp: Date.now()
            // we ignore the uid / gid for now
        });
    },
    lchown: function (path, uid, gid) {
        FS.chown(path, uid, gid, true);
    },
    fchown: function (fd, uid, gid) {
        var stream = FS.getStream(fd);
        if (!stream) {
            throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chown(stream.node, uid, gid);
    },
    truncate: function (path, len) {
        if (len < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node;
        if (typeof path === 'string') {
            var lookup = FS.lookupPath(path, {
                follow: true
            });
            node = lookup.node;
        } else {
            node = path;
        }
        if (!node.node_ops.setattr) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isDir(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!FS.isFile(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var err = FS.nodePermissions(node, 'w');
        if (err) {
            throw new FS.ErrnoError(err);
        }
        node.node_ops.setattr(node, {
            size: len,
            timestamp: Date.now()
        });
    },
    ftruncate: function (fd, len) {
        var stream = FS.getStream(fd);
        if (!stream) {
            throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if ((stream.flags & 2097155) === 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        FS.truncate(stream.node, len);
    },
    utime: function (path, atime, mtime) {
        var lookup = FS.lookupPath(path, {
            follow: true
        });
        var node = lookup.node;
        node.node_ops.setattr(node, {
            timestamp: Math.max(atime, mtime)
        });
    },
    open: function (path, flags, mode, fd_start, fd_end) {
        flags = typeof flags === 'string' ? FS.modeStringToFlags(flags) : flags;
        mode = typeof mode === 'undefined' ? 438 /* 0666 */ : mode;
        if ((flags & 64)) {
            mode = (mode & 4095) | 32768;
        } else {
            mode = 0;
        }
        var node;
        if (typeof path === 'object') {
            node = path;
        } else {
            path = PATH.normalize(path);
            try {
                var lookup = FS.lookupPath(path, {
                    follow: !(flags & 131072)
                });
                node = lookup.node;
            } catch (e) {
                // ignore
            }
        }
        // perhaps we need to create the node
        if ((flags & 64)) {
            if (node) {
                // if O_CREAT and O_EXCL are set, error out if the node already exists
                if ((flags & 128)) {
                    throw new FS.ErrnoError(ERRNO_CODES.EEXIST);
                }
            } else {
                // node doesn't exist, try to create it
                node = FS.mknod(path, mode, 0);
            }
        }
        if (!node) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        // can't truncate a device
        if (FS.isChrdev(node.mode)) {
            flags &= ~512;
        }
        // check permissions
        var err = FS.mayOpen(node, flags);
        if (err) {
            throw new FS.ErrnoError(err);
        }
        // do truncation if necessary
        if ((flags & 512)) {
            FS.truncate(node, 0);
        }
        // we've already handled these, don't pass down to the underlying vfs
        flags &= ~(128 | 512);

        // register the stream with the filesystem
        var stream = FS.createStream({
            node: node,
            path: FS.getPath(node), // we want the absolute path to the node
            flags: flags,
            seekable: true,
            position: 0,
            stream_ops: node.stream_ops,
            // used by the file family libc calls (fopen, fwrite, ferror, etc.)
            ungotten: [],
            error: false
        }, fd_start, fd_end);
        // call the new stream's open function
        if (stream.stream_ops.open) {
            stream.stream_ops.open(stream);
        }
        if (Module['logReadFiles'] && !(flags & 1)) {
            if (!FS.readFiles) FS.readFiles = {};
            if (!(path in FS.readFiles)) {
                FS.readFiles[path] = 1;
                Module['printErr']('read file: ' + path);
            }
        }
        return stream;
    },
    close: function (stream) {
        try {
            if (stream.stream_ops.close) {
                stream.stream_ops.close(stream);
            }
        } catch (e) {
            throw e;
        } finally {
            FS.closeStream(stream.fd);
        }
    },
    llseek: function (stream, offset, whence) {
        if (!stream.seekable || !stream.stream_ops.llseek) {
            throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        return stream.stream_ops.llseek(stream, offset, whence);
    },
    read: function (stream, buffer, offset, length, position) {
        if (length < 0 || position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 1) {
            throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.read) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
            position = stream.position;
            seeking = false;
        } else if (!stream.seekable) {
            throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
        if (!seeking) stream.position += bytesRead;
        return bytesRead;
    },
    write: function (stream, buffer, offset, length, position, canOwn) {
        if (length < 0 || position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.write) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
            position = stream.position;
            seeking = false;
        } else if (!stream.seekable) {
            throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        if (stream.flags & 1024) {
            // seek to the end before writing in append mode
            FS.llseek(stream, 0, 2);
        }
        var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
        if (!seeking) stream.position += bytesWritten;
        return bytesWritten;
    },
    allocate: function (stream, offset, length) {
        if (offset < 0 || length <= 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (!FS.isFile(stream.node.mode) && !FS.isDir(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        if (!stream.stream_ops.allocate) {
            throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
        }
        stream.stream_ops.allocate(stream, offset, length);
    },
    mmap: function (stream, buffer, offset, length, position, prot, flags) {
        // TODO if PROT is PROT_WRITE, make sure we have write access
        if ((stream.flags & 2097155) === 1) {
            throw new FS.ErrnoError(ERRNO_CODES.EACCES);
        }
        if (!stream.stream_ops.mmap) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        return stream.stream_ops.mmap(stream, buffer, offset, length, position, prot, flags);
    },
    ioctl: function (stream, cmd, arg) {
        if (!stream.stream_ops.ioctl) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTTY);
        }
        return stream.stream_ops.ioctl(stream, cmd, arg);
    },
    readFile: function (path, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'r';
        opts.encoding = opts.encoding || 'binary';
        if (opts.encoding !== 'utf8' && opts.encoding !== 'binary') {
            throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        var ret;
        var stream = FS.open(path, opts.flags);
        var stat = FS.stat(path);
        var length = stat.size;
        var buf = new Uint8Array(length);
        FS.read(stream, buf, 0, length, 0);
        if (opts.encoding === 'utf8') {
            ret = '';
            var utf8 = new Runtime.UTF8Processor();
            for (var i = 0; i < length; i++) {
                ret += utf8.processCChar(buf[i]);
            }
        } else if (opts.encoding === 'binary') {
            ret = buf;
        }
        FS.close(stream);
        return ret;
    },
    writeFile: function (path, data, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'w';
        opts.encoding = opts.encoding || 'utf8';
        if (opts.encoding !== 'utf8' && opts.encoding !== 'binary') {
            throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        var stream = FS.open(path, opts.flags, opts.mode);
        if (opts.encoding === 'utf8') {
            var utf8 = new Runtime.UTF8Processor();
            var buf = new Uint8Array(utf8.processJSString(data));
            FS.write(stream, buf, 0, buf.length, 0, opts.canOwn);
        } else if (opts.encoding === 'binary') {
            FS.write(stream, data, 0, data.length, 0, opts.canOwn);
        }
        FS.close(stream);
    },
    cwd: function () {
        return FS.currentPath;
    },
    chdir: function (path) {
        var lookup = FS.lookupPath(path, {
            follow: true
        });
        if (!FS.isDir(lookup.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        var err = FS.nodePermissions(lookup.node, 'x');
        if (err) {
            throw new FS.ErrnoError(err);
        }
        FS.currentPath = lookup.path;
    },
    createDefaultDirectories: function () {
        FS.mkdir('/tmp');
    },
    createDefaultDevices: function () {
        // create /dev
        FS.mkdir('/dev');
        // setup /dev/null
        FS.registerDevice(FS.makedev(1, 3), {
            read: function () {
                return 0;
            },
            write: function () {
                return 0;
            }
        });
        FS.mkdev('/dev/null', FS.makedev(1, 3));
        // setup /dev/tty and /dev/tty1
        // stderr needs to print output using Module['printErr']
        // so we register a second tty just for it.
        TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
        TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
        FS.mkdev('/dev/tty', FS.makedev(5, 0));
        FS.mkdev('/dev/tty1', FS.makedev(6, 0));
        // we're not going to emulate the actual shm device,
        // just create the tmp dirs that reside in it commonly
        FS.mkdir('/dev/shm');
        FS.mkdir('/dev/shm/tmp');
    },
    createStandardStreams: function () {
        // TODO deprecate the old functionality of a single
        // input / output callback and that utilizes FS.createDevice
        // and instead require a unique set of stream ops

        // by default, we symlink the standard streams to the
        // default tty devices. however, if the standard streams
        // have been overwritten we create a unique device for
        // them instead.
        if (Module['stdin']) {
            FS.createDevice('/dev', 'stdin', Module['stdin']);
        } else {
            FS.symlink('/dev/tty', '/dev/stdin');
        }
        if (Module['stdout']) {
            FS.createDevice('/dev', 'stdout', null, Module['stdout']);
        } else {
            FS.symlink('/dev/tty', '/dev/stdout');
        }
        if (Module['stderr']) {
            FS.createDevice('/dev', 'stderr', null, Module['stderr']);
        } else {
            FS.symlink('/dev/tty1', '/dev/stderr');
        }

        // open default streams for the stdin, stdout and stderr devices
        var stdin = FS.open('/dev/stdin', 'r');
        HEAP32[((_stdin) >> 2)] = FS.getPtrForStream(stdin);
        assert(stdin.fd === 0, 'invalid handle for stdin (' + stdin.fd + ')');

        var stdout = FS.open('/dev/stdout', 'w');
        HEAP32[((_stdout) >> 2)] = FS.getPtrForStream(stdout);
        assert(stdout.fd === 1, 'invalid handle for stdout (' + stdout.fd + ')');

        var stderr = FS.open('/dev/stderr', 'w');
        HEAP32[((_stderr) >> 2)] = FS.getPtrForStream(stderr);
        assert(stderr.fd === 2, 'invalid handle for stderr (' + stderr.fd + ')');
    },
    ensureErrnoError: function () {
        if (FS.ErrnoError) return;
        FS.ErrnoError = function ErrnoError(errno) {
            this.errno = errno;
            for (var key in ERRNO_CODES) {
                if (ERRNO_CODES[key] === errno) {
                    this.code = key;
                    break;
                }
            }
            this.message = ERRNO_MESSAGES[errno];
        };
        FS.ErrnoError.prototype = new Error();
        FS.ErrnoError.prototype.constructor = FS.ErrnoError;
        // Some errors may happen quite a bit, to avoid overhead we reuse them (and suffer a lack of stack info)
        [ERRNO_CODES.ENOENT].forEach(function (code) {
            FS.genericErrors[code] = new FS.ErrnoError(code);
            FS.genericErrors[code].stack = '<generic error, no stack>';
        });
    },
    staticInit: function () {
        FS.ensureErrnoError();

        FS.nameTable = new Array(4096);

        FS.mount(MEMFS, {}, '/');

        FS.createDefaultDirectories();
        FS.createDefaultDevices();
    },
    init: function (input, output, error) {
        assert(!FS.init.initialized, 'FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)');
        FS.init.initialized = true;

        FS.ensureErrnoError();

        // Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
        Module['stdin'] = input || Module['stdin'];
        Module['stdout'] = output || Module['stdout'];
        Module['stderr'] = error || Module['stderr'];

        FS.createStandardStreams();
    },
    quit: function () {
        FS.init.initialized = false;
        for (var i = 0; i < FS.streams.length; i++) {
            var stream = FS.streams[i];
            if (!stream) {
                continue;
            }
            FS.close(stream);
        }
    },
    getMode: function (canRead, canWrite) {
        var mode = 0;
        if (canRead) mode |= 292 | 73;
        if (canWrite) mode |= 146;
        return mode;
    },
    joinPath: function (parts, forceRelative) {
        var path = PATH.join.apply(null, parts);
        if (forceRelative && path[0] == '/') path = path.substr(1);
        return path;
    },
    absolutePath: function (relative, base) {
        return PATH.resolve(base, relative);
    },
    standardizePath: function (path) {
        return PATH.normalize(path);
    },
    findObject: function (path, dontResolveLastLink) {
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
            return ret.object;
        } else {
            ___setErrNo(ret.error);
            return null;
        }
    },
    analyzePath: function (path, dontResolveLastLink) {
        // operate from within the context of the symlink's target
        try {
            var lookup = FS.lookupPath(path, {
                follow: !dontResolveLastLink
            });
            path = lookup.path;
        } catch (e) {}
        var ret = {
            isRoot: false,
            exists: false,
            error: 0,
            name: null,
            path: null,
            object: null,
            parentExists: false,
            parentPath: null,
            parentObject: null
        };
        try {
            var lookup = FS.lookupPath(path, {
                parent: true
            });
            ret.parentExists = true;
            ret.parentPath = lookup.path;
            ret.parentObject = lookup.node;
            ret.name = PATH.basename(path);
            lookup = FS.lookupPath(path, {
                follow: !dontResolveLastLink
            });
            ret.exists = true;
            ret.path = lookup.path;
            ret.object = lookup.node;
            ret.name = lookup.node.name;
            ret.isRoot = lookup.path === '/';
        } catch (e) {
            ret.error = e.errno;
        };
        return ret;
    },
    createFolder: function (parent, name, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.mkdir(path, mode);
    },
    createPath: function (parent, path, canRead, canWrite) {
        parent = typeof parent === 'string' ? parent : FS.getPath(parent);
        var parts = path.split('/').reverse();
        while (parts.length) {
            var part = parts.pop();
            if (!part) continue;
            var current = PATH.join2(parent, part);
            try {
                FS.mkdir(current);
            } catch (e) {
                // ignore EEXIST
            }
            parent = current;
        }
        return current;
    },
    createFile: function (parent, name, properties, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.create(path, mode);
    },
    createDataFile: function (parent, name, data, canRead, canWrite, canOwn) {
        var path = name ? PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name) : parent;
        var mode = FS.getMode(canRead, canWrite);
        var node = FS.create(path, mode);
        if (data) {
            if (typeof data === 'string') {
                var arr = new Array(data.length);
                for (var i = 0, len = data.length; i < len; ++i) arr[i] = data.charCodeAt(i);
                data = arr;
            }
            // make sure we can write to the file
            FS.chmod(node, mode | 146);
            var stream = FS.open(node, 'w');
            FS.write(stream, data, 0, data.length, 0, canOwn);
            FS.close(stream);
            FS.chmod(node, mode);
        }
        return node;
    },
    createDevice: function (parent, name, input, output) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(!!input, !!output);
        if (!FS.createDevice.major) FS.createDevice.major = 64;
        var dev = FS.makedev(FS.createDevice.major++, 0);
        // Create a fake device that a set of stream ops to emulate
        // the old behavior.
        FS.registerDevice(dev, {
            open: function (stream) {
                stream.seekable = false;
            },
            close: function (stream) {
                // flush any pending line data
                if (output && output.buffer && output.buffer.length) {
                    output(10);
                }
            },
            read: function (stream, buffer, offset, length, pos /* ignored */ ) {
                var bytesRead = 0;
                for (var i = 0; i < length; i++) {
                    var result;
                    try {
                        result = input();
                    } catch (e) {
                        throw new FS.ErrnoError(ERRNO_CODES.EIO);
                    }
                    if (result === undefined && bytesRead === 0) {
                        throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
                    }
                    if (result === null || result === undefined) break;
                    bytesRead++;
                    buffer[offset + i] = result;
                }
                if (bytesRead) {
                    stream.node.timestamp = Date.now();
                }
                return bytesRead;
            },
            write: function (stream, buffer, offset, length, pos) {
                for (var i = 0; i < length; i++) {
                    try {
                        output(buffer[offset + i]);
                    } catch (e) {
                        throw new FS.ErrnoError(ERRNO_CODES.EIO);
                    }
                }
                if (length) {
                    stream.node.timestamp = Date.now();
                }
                return i;
            }
        });
        return FS.mkdev(path, mode, dev);
    },
    createLink: function (parent, name, target, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        return FS.symlink(target, path);
    },
    forceLoadFile: function (obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        var success = true;
        if (typeof XMLHttpRequest !== 'undefined') {
            throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
        } else if (Module['read']) {
            // Command-line.
            try {
                // WARNING: Can't read binary files in V8's d8 or tracemonkey's js, as
                //          read() will try to parse UTF8.
                obj.contents = intArrayFromString(Module['read'](obj.url), true);
            } catch (e) {
                success = false;
            }
        } else {
            throw new Error('Cannot load without read() or XMLHttpRequest.');
        }
        if (!success) ___setErrNo(ERRNO_CODES.EIO);
        return success;
    },
    createLazyFile: function (parent, name, url, canRead, canWrite) {
        if (typeof XMLHttpRequest !== 'undefined') {
            if (!ENVIRONMENT_IS_WORKER) throw 'Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc';
            // Lazy chunked Uint8Array (implements get and length from Uint8Array). Actual getting is abstracted away for eventual reuse.
            function LazyUint8Array() {
                this.lengthKnown = false;
                this.chunks = []; // Loaded chunks. Index is the chunk number
            }
            LazyUint8Array.prototype.get = function LazyUint8Array_get(idx) {
                if (idx > this.length - 1 || idx < 0) {
                    return undefined;
                }
                var chunkOffset = idx % this.chunkSize;
                var chunkNum = Math.floor(idx / this.chunkSize);
                return this.getter(chunkNum)[chunkOffset];
            }
            LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(getter) {
                this.getter = getter;
            }
            LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
                // Find length
                var xhr = new XMLHttpRequest();
                xhr.open('HEAD', url, false);
                xhr.send(null);
                if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
                var datalength = Number(xhr.getResponseHeader("Content-length"));
                var header;
                var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
                var chunkSize = 1024 * 1024; // Chunk size in bytes

                if (!hasByteServing) chunkSize = datalength;

                // Function to get a range from the remote URL.
                var doXHR = (function (from, to) {
                    if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
                    if (to > datalength - 1) throw new Error("only " + datalength + " bytes available! programmer error!");

                    // TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
                    var xhr = new XMLHttpRequest();
                    xhr.open('GET', url, false);
                    if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);

                    // Some hints to the browser that we want binary data.
                    if (typeof Uint8Array != 'undefined') xhr.responseType = 'arraybuffer';
                    if (xhr.overrideMimeType) {
                        xhr.overrideMimeType('text/plain; charset=x-user-defined');
                    }

                    xhr.send(null);
                    if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
                    if (xhr.response !== undefined) {
                        return new Uint8Array(xhr.response || []);
                    } else {
                        return intArrayFromString(xhr.responseText || '', true);
                    }
                });
                var lazyArray = this;
                lazyArray.setDataGetter(function (chunkNum) {
                    var start = chunkNum * chunkSize;
                    var end = (chunkNum + 1) * chunkSize - 1; // including this byte
                    end = Math.min(end, datalength - 1); // if datalength-1 is selected, this is the last block
                    if (typeof (lazyArray.chunks[chunkNum]) === "undefined") {
                        lazyArray.chunks[chunkNum] = doXHR(start, end);
                    }
                    if (typeof (lazyArray.chunks[chunkNum]) === "undefined") throw new Error("doXHR failed!");
                    return lazyArray.chunks[chunkNum];
                });

                this._length = datalength;
                this._chunkSize = chunkSize;
                this.lengthKnown = true;
            }

            var lazyArray = new LazyUint8Array();
            Object.defineProperty(lazyArray, "length", {
                get: function () {
                    if (!this.lengthKnown) {
                        this.cacheLength();
                    }
                    return this._length;
                }
            });
            Object.defineProperty(lazyArray, "chunkSize", {
                get: function () {
                    if (!this.lengthKnown) {
                        this.cacheLength();
                    }
                    return this._chunkSize;
                }
            });

            var properties = {
                isDevice: false,
                contents: lazyArray
            };
        } else {
            var properties = {
                isDevice: false,
                url: url
            };
        }

        var node = FS.createFile(parent, name, properties, canRead, canWrite);
        // This is a total hack, but I want to get this lazy file code out of the
        // core of MEMFS. If we want to keep this lazy file concept I feel it should
        // be its own thin LAZYFS proxying calls to MEMFS.
        if (properties.contents) {
            node.contents = properties.contents;
        } else if (properties.url) {
            node.contents = null;
            node.url = properties.url;
        }
        // override each stream op with one that tries to force load the lazy file first
        var stream_ops = {};
        var keys = Object.keys(node.stream_ops);
        keys.forEach(function (key) {
            var fn = node.stream_ops[key];
            stream_ops[key] = function forceLoadLazyFile() {
                if (!FS.forceLoadFile(node)) {
                    throw new FS.ErrnoError(ERRNO_CODES.EIO);
                }
                return fn.apply(null, arguments);
            };
        });
        // use a custom read function
        stream_ops.read = function stream_ops_read(stream, buffer, offset, length, position) {
            if (!FS.forceLoadFile(node)) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            var contents = stream.node.contents;
            if (position >= contents.length)
                return 0;
            var size = Math.min(contents.length - position, length);
            assert(size >= 0);
            if (contents.slice) { // normal array
                for (var i = 0; i < size; i++) {
                    buffer[offset + i] = contents[position + i];
                }
            } else {
                for (var i = 0; i < size; i++) { // LazyUint8Array from sync binary XHR
                    buffer[offset + i] = contents.get(position + i);
                }
            }
            return size;
        };
        node.stream_ops = stream_ops;
        return node;
    },
    createPreloadedFile: function (parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn) {
        Browser.init();
        // TODO we should allow people to just pass in a complete filename instead
        // of parent and name being that we just join them anyways
        var fullname = name ? PATH.resolve(PATH.join2(parent, name)) : parent;

        function processData(byteArray) {
            function finish(byteArray) {
                if (!dontCreateFile) {
                    FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn);
                }
                if (onload) onload();
                removeRunDependency('cp ' + fullname);
            }
            var handled = false;
            Module['preloadPlugins'].forEach(function (plugin) {
                if (handled) return;
                if (plugin['canHandle'](fullname)) {
                    plugin['handle'](byteArray, fullname, finish, function () {
                        if (onerror) onerror();
                        removeRunDependency('cp ' + fullname);
                    });
                    handled = true;
                }
            });
            if (!handled) finish(byteArray);
        }
        addRunDependency('cp ' + fullname);
        if (typeof url == 'string') {
            Browser.asyncLoad(url, function (byteArray) {
                processData(byteArray);
            }, onerror);
        } else {
            processData(url);
        }
    },
    indexedDB: function () {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
    },
    DB_NAME: function () {
        return 'EM_FS_' + window.location.pathname;
    },
    DB_VERSION: 20,
    DB_STORE_NAME: "FILE_DATA",
    saveFilesToDB: function (paths, onload, onerror) {
        onload = onload || function () {};
        onerror = onerror || function () {};
        var indexedDB = FS.indexedDB();
        try {
            var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
            return onerror(e);
        }
        openRequest.onupgradeneeded = function openRequest_onupgradeneeded() {
            console.log('creating db');
            var db = openRequest.result;
            db.createObjectStore(FS.DB_STORE_NAME);
        };
        openRequest.onsuccess = function openRequest_onsuccess() {
            var db = openRequest.result;
            var transaction = db.transaction([FS.DB_STORE_NAME], 'readwrite');
            var files = transaction.objectStore(FS.DB_STORE_NAME);
            var ok = 0,
                fail = 0,
                total = paths.length;

            function finish() {
                if (fail == 0) onload();
                else onerror();
            }
            paths.forEach(function (path) {
                var putRequest = files.put(FS.analyzePath(path).object.contents, path);
                putRequest.onsuccess = function putRequest_onsuccess() {
                    ok++;
                    if (ok + fail == total) finish()
                };
                putRequest.onerror = function putRequest_onerror() {
                    fail++;
                    if (ok + fail == total) finish()
                };
            });
            transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
    },
    loadFilesFromDB: function (paths, onload, onerror) {
        onload = onload || function () {};
        onerror = onerror || function () {};
        var indexedDB = FS.indexedDB();
        try {
            var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
            return onerror(e);
        }
        openRequest.onupgradeneeded = onerror; // no database to load from
        openRequest.onsuccess = function openRequest_onsuccess() {
            var db = openRequest.result;
            try {
                var transaction = db.transaction([FS.DB_STORE_NAME], 'readonly');
            } catch (e) {
                onerror(e);
                return;
            }
            var files = transaction.objectStore(FS.DB_STORE_NAME);
            var ok = 0,
                fail = 0,
                total = paths.length;

            function finish() {
                if (fail == 0) onload();
                else onerror();
            }
            paths.forEach(function (path) {
                var getRequest = files.get(path);
                getRequest.onsuccess = function getRequest_onsuccess() {
                    if (FS.analyzePath(path).exists) {
                        FS.unlink(path);
                    }
                    FS.createDataFile(PATH.dirname(path), PATH.basename(path), getRequest.result, true, true, true);
                    ok++;
                    if (ok + fail == total) finish();
                };
                getRequest.onerror = function getRequest_onerror() {
                    fail++;
                    if (ok + fail == total) finish()
                };
            });
            transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
    }
};

function _fflush(stream) {
    // int fflush(FILE *stream);
    // http://pubs.opengroup.org/onlinepubs/000095399/functions/fflush.html
    // we don't currently perform any user-space buffering of data
}




function _isspace(chr) {
    return (chr == 32) || (chr >= 9 && chr <= 13);
}

function __parseInt64(str, endptr, base, min, max, unsign) {
    var isNegative = false;
    // Skip space.
    while (_isspace(HEAP8[(str)])) str++;

    // Check for a plus/minus sign.
    if (HEAP8[(str)] == 45) {
        str++;
        isNegative = true;
    } else if (HEAP8[(str)] == 43) {
        str++;
    }

    // Find base.
    var ok = false;
    var finalBase = base;
    if (!finalBase) {
        if (HEAP8[(str)] == 48) {
            if (HEAP8[((str + 1) | 0)] == 120 ||
                HEAP8[((str + 1) | 0)] == 88) {
                finalBase = 16;
                str += 2;
            } else {
                finalBase = 8;
                ok = true; // we saw an initial zero, perhaps the entire thing is just "0"
            }
        }
    } else if (finalBase == 16) {
        if (HEAP8[(str)] == 48) {
            if (HEAP8[((str + 1) | 0)] == 120 ||
                HEAP8[((str + 1) | 0)] == 88) {
                str += 2;
            }
        }
    }
    if (!finalBase) finalBase = 10;
    var start = str;

    // Get digits.
    var chr;
    while ((chr = HEAP8[(str)]) != 0) {
        var digit = parseInt(String.fromCharCode(chr), finalBase);
        if (isNaN(digit)) {
            break;
        } else {
            str++;
            ok = true;
        }
    }

    if (!ok) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return ((asm["setTempRet0"](0), 0) | 0);
    }

    // Set end pointer.
    if (endptr) {
        HEAP32[((endptr) >> 2)] = str;
    }

    try {
        var numberString = isNegative ? '-' + Pointer_stringify(start, str - start) : Pointer_stringify(start, str - start);
        i64Math.fromString(numberString, finalBase, min, max, unsign);
    } catch (e) {
        ___setErrNo(ERRNO_CODES.ERANGE); // not quite correct
    }

    return ((asm["setTempRet0"](((HEAP32[(((tempDoublePtr) + (4)) >> 2)]) | 0)), ((HEAP32[((tempDoublePtr) >> 2)]) | 0)) | 0);
}

function _strtoull(str, endptr, base) {
    return __parseInt64(str, endptr, base, 0, '18446744073709551615', true); // ULONG_MAX.
}

function _strtoull_l(str, endptr, base) {
    return _strtoull(str, endptr, base); // no locale support yet
}

var _log = Math_log;




function _mkport() {
    throw 'TODO'
}
var SOCKFS = {
    mount: function (mount) {
        return FS.createNode(null, '/', 16384 | 511 /* 0777 */ , 0);
    },
    createSocket: function (family, type, protocol) {
        var streaming = type == 1;
        if (protocol) {
            assert(streaming == (protocol == 6)); // if SOCK_STREAM, must be tcp
        }

        // create our internal socket structure
        var sock = {
            family: family,
            type: type,
            protocol: protocol,
            server: null,
            peers: {},
            pending: [],
            recv_queue: [],
            sock_ops: SOCKFS.websocket_sock_ops
        };

        // create the filesystem node to store the socket structure
        var name = SOCKFS.nextname();
        var node = FS.createNode(SOCKFS.root, name, 49152, 0);
        node.sock = sock;

        // and the wrapping stream that enables library functions such
        // as read and write to indirectly interact with the socket
        var stream = FS.createStream({
            path: name,
            node: node,
            flags: FS.modeStringToFlags('r+'),
            seekable: false,
            stream_ops: SOCKFS.stream_ops
        });

        // map the new stream to the socket structure (sockets have a 1:1
        // relationship with a stream)
        sock.stream = stream;

        return sock;
    },
    getSocket: function (fd) {
        var stream = FS.getStream(fd);
        if (!stream || !FS.isSocket(stream.node.mode)) {
            return null;
        }
        return stream.node.sock;
    },
    stream_ops: {
        poll: function (stream) {
            var sock = stream.node.sock;
            return sock.sock_ops.poll(sock);
        },
        ioctl: function (stream, request, varargs) {
            var sock = stream.node.sock;
            return sock.sock_ops.ioctl(sock, request, varargs);
        },
        read: function (stream, buffer, offset, length, position /* ignored */ ) {
            var sock = stream.node.sock;
            var msg = sock.sock_ops.recvmsg(sock, length);
            if (!msg) {
                // socket is closed
                return 0;
            }
            buffer.set(msg.buffer, offset);
            return msg.buffer.length;
        },
        write: function (stream, buffer, offset, length, position /* ignored */ ) {
            var sock = stream.node.sock;
            return sock.sock_ops.sendmsg(sock, buffer, offset, length);
        },
        close: function (stream) {
            var sock = stream.node.sock;
            sock.sock_ops.close(sock);
        }
    },
    nextname: function () {
        if (!SOCKFS.nextname.current) {
            SOCKFS.nextname.current = 0;
        }
        return 'socket[' + (SOCKFS.nextname.current++) + ']';
    },
    websocket_sock_ops: {
        createPeer: function (sock, addr, port) {
            var ws;

            if (typeof addr === 'object') {
                ws = addr;
                addr = null;
                port = null;
            }

            if (ws) {
                // for sockets that've already connected (e.g. we're the server)
                // we can inspect the _socket property for the address
                if (ws._socket) {
                    addr = ws._socket.remoteAddress;
                    port = ws._socket.remotePort;
                }
                // if we're just now initializing a connection to the remote,
                // inspect the url property
                else {
                    var result = /ws[s]?:\/\/([^:]+):(\d+)/.exec(ws.url);
                    if (!result) {
                        throw new Error('WebSocket URL must be in the format ws(s)://address:port');
                    }
                    addr = result[1];
                    port = parseInt(result[2], 10);
                }
            } else {
                // create the actual websocket object and connect
                try {
                    var url = 'ws://' + addr + ':' + port;
                    // the node ws library API is slightly different than the browser's
                    var opts = ENVIRONMENT_IS_NODE ? {
                        headers: {
                            'websocket-protocol': ['binary']
                        }
                    } : ['binary'];
                    // If node we use the ws library.
                    var WebSocket = ENVIRONMENT_IS_NODE ? require('ws') : window['WebSocket'];
                    ws = new WebSocket(url, opts);
                    ws.binaryType = 'arraybuffer';
                } catch (e) {
                    throw new FS.ErrnoError(ERRNO_CODES.EHOSTUNREACH);
                }
            }


            var peer = {
                addr: addr,
                port: port,
                socket: ws,
                dgram_send_queue: []
            };

            SOCKFS.websocket_sock_ops.addPeer(sock, peer);
            SOCKFS.websocket_sock_ops.handlePeerEvents(sock, peer);

            // if this is a bound dgram socket, send the port number first to allow
            // us to override the ephemeral port reported to us by remotePort on the
            // remote end.
            if (sock.type === 2 && typeof sock.sport !== 'undefined') {
                peer.dgram_send_queue.push(new Uint8Array([
                    255, 255, 255, 255,
                    'p'.charCodeAt(0), 'o'.charCodeAt(0), 'r'.charCodeAt(0), 't'.charCodeAt(0), ((sock.sport & 0xff00) >> 8), (sock.sport & 0xff)
                ]));
            }

            return peer;
        },
        getPeer: function (sock, addr, port) {
            return sock.peers[addr + ':' + port];
        },
        addPeer: function (sock, peer) {
            sock.peers[peer.addr + ':' + peer.port] = peer;
        },
        removePeer: function (sock, peer) {
            delete sock.peers[peer.addr + ':' + peer.port];
        },
        handlePeerEvents: function (sock, peer) {
            var first = true;

            var handleOpen = function () {
                try {
                    var queued = peer.dgram_send_queue.shift();
                    while (queued) {
                        peer.socket.send(queued);
                        queued = peer.dgram_send_queue.shift();
                    }
                } catch (e) {
                    // not much we can do here in the way of proper error handling as we've already
                    // lied and said this data was sent. shut it down.
                    peer.socket.close();
                }
            };

            function handleMessage(data) {
                assert(typeof data !== 'string' && data.byteLength !== undefined); // must receive an ArrayBuffer
                data = new Uint8Array(data); // make a typed array view on the array buffer


                // if this is the port message, override the peer's port with it
                var wasfirst = first;
                first = false;
                if (wasfirst &&
                    data.length === 10 &&
                    data[0] === 255 && data[1] === 255 && data[2] === 255 && data[3] === 255 &&
                    data[4] === 'p'.charCodeAt(0) && data[5] === 'o'.charCodeAt(0) && data[6] === 'r'.charCodeAt(0) && data[7] === 't'.charCodeAt(0)) {
                    // update the peer's port and it's key in the peer map
                    var newport = ((data[8] << 8) | data[9]);
                    SOCKFS.websocket_sock_ops.removePeer(sock, peer);
                    peer.port = newport;
                    SOCKFS.websocket_sock_ops.addPeer(sock, peer);
                    return;
                }

                sock.recv_queue.push({
                    addr: peer.addr,
                    port: peer.port,
                    data: data
                });
            };

            if (ENVIRONMENT_IS_NODE) {
                peer.socket.on('open', handleOpen);
                peer.socket.on('message', function (data, flags) {
                    if (!flags.binary) {
                        return;
                    }
                    handleMessage((new Uint8Array(data)).buffer); // copy from node Buffer -> ArrayBuffer
                });
                peer.socket.on('error', function () {
                    // don't throw
                });
            } else {
                peer.socket.onopen = handleOpen;
                peer.socket.onmessage = function peer_socket_onmessage(event) {
                    handleMessage(event.data);
                };
            }
        },
        poll: function (sock) {
            if (sock.type === 1 && sock.server) {
                // listen sockets should only say they're available for reading
                // if there are pending clients.
                return sock.pending.length ? (64 | 1) : 0;
            }

            var mask = 0;
            var dest = sock.type === 1 ? // we only care about the socket state for connection-based sockets
                SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport) :
                null;

            if (sock.recv_queue.length ||
                !dest || // connection-less sockets are always ready to read
                (dest && dest.socket.readyState === dest.socket.CLOSING) ||
                (dest && dest.socket.readyState === dest.socket.CLOSED)) { // let recv return 0 once closed
                mask |= (64 | 1);
            }

            if (!dest || // connection-less sockets are always ready to write
                (dest && dest.socket.readyState === dest.socket.OPEN)) {
                mask |= 4;
            }

            if ((dest && dest.socket.readyState === dest.socket.CLOSING) ||
                (dest && dest.socket.readyState === dest.socket.CLOSED)) {
                mask |= 16;
            }

            return mask;
        },
        ioctl: function (sock, request, arg) {
            switch (request) {
            case 21531:
                var bytes = 0;
                if (sock.recv_queue.length) {
                    bytes = sock.recv_queue[0].data.length;
                }
                HEAP32[((arg) >> 2)] = bytes;
                return 0;
            default:
                return ERRNO_CODES.EINVAL;
            }
        },
        close: function (sock) {
            // if we've spawned a listen server, close it
            if (sock.server) {
                try {
                    sock.server.close();
                } catch (e) {}
                sock.server = null;
            }
            // close any peer connections
            var peers = Object.keys(sock.peers);
            for (var i = 0; i < peers.length; i++) {
                var peer = sock.peers[peers[i]];
                try {
                    peer.socket.close();
                } catch (e) {}
                SOCKFS.websocket_sock_ops.removePeer(sock, peer);
            }
            return 0;
        },
        bind: function (sock, addr, port) {
            if (typeof sock.saddr !== 'undefined' || typeof sock.sport !== 'undefined') {
                throw new FS.ErrnoError(ERRNO_CODES.EINVAL); // already bound
            }
            sock.saddr = addr;
            sock.sport = port || _mkport();
            // in order to emulate dgram sockets, we need to launch a listen server when
            // binding on a connection-less socket
            // note: this is only required on the server side
            if (sock.type === 2) {
                // close the existing server if it exists
                if (sock.server) {
                    sock.server.close();
                    sock.server = null;
                }
                // swallow error operation not supported error that occurs when binding in the
                // browser where this isn't supported
                try {
                    sock.sock_ops.listen(sock, 0);
                } catch (e) {
                    if (!(e instanceof FS.ErrnoError)) throw e;
                    if (e.errno !== ERRNO_CODES.EOPNOTSUPP) throw e;
                }
            }
        },
        connect: function (sock, addr, port) {
            if (sock.server) {
                throw new FS.ErrnoError(ERRNO_CODS.EOPNOTSUPP);
            }

            // TODO autobind
            // if (!sock.addr && sock.type == 2) {
            // }

            // early out if we're already connected / in the middle of connecting
            if (typeof sock.daddr !== 'undefined' && typeof sock.dport !== 'undefined') {
                var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
                if (dest) {
                    if (dest.socket.readyState === dest.socket.CONNECTING) {
                        throw new FS.ErrnoError(ERRNO_CODES.EALREADY);
                    } else {
                        throw new FS.ErrnoError(ERRNO_CODES.EISCONN);
                    }
                }
            }

            // add the socket to our peer list and set our
            // destination address / port to match
            var peer = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
            sock.daddr = peer.addr;
            sock.dport = peer.port;

            // always "fail" in non-blocking mode
            throw new FS.ErrnoError(ERRNO_CODES.EINPROGRESS);
        },
        listen: function (sock, backlog) {
            if (!ENVIRONMENT_IS_NODE) {
                throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
            }
            if (sock.server) {
                throw new FS.ErrnoError(ERRNO_CODES.EINVAL); // already listening
            }
            var WebSocketServer = require('ws').Server;
            var host = sock.saddr;
            sock.server = new WebSocketServer({
                host: host,
                port: sock.sport
                // TODO support backlog
            });

            sock.server.on('connection', function (ws) {
                if (sock.type === 1) {
                    var newsock = SOCKFS.createSocket(sock.family, sock.type, sock.protocol);

                    // create a peer on the new socket
                    var peer = SOCKFS.websocket_sock_ops.createPeer(newsock, ws);
                    newsock.daddr = peer.addr;
                    newsock.dport = peer.port;

                    // push to queue for accept to pick up
                    sock.pending.push(newsock);
                } else {
                    // create a peer on the listen socket so calling sendto
                    // with the listen socket and an address will resolve
                    // to the correct client
                    SOCKFS.websocket_sock_ops.createPeer(sock, ws);
                }
            });
            sock.server.on('closed', function () {
                sock.server = null;
            });
            sock.server.on('error', function () {
                // don't throw
            });
        },
        accept: function (listensock) {
            if (!listensock.server) {
                throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
            }
            var newsock = listensock.pending.shift();
            newsock.stream.flags = listensock.stream.flags;
            return newsock;
        },
        getname: function (sock, peer) {
            var addr, port;
            if (peer) {
                if (sock.daddr === undefined || sock.dport === undefined) {
                    throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
                }
                addr = sock.daddr;
                port = sock.dport;
            } else {
                // TODO saddr and sport will be set for bind()'d UDP sockets, but what
                // should we be returning for TCP sockets that've been connect()'d?
                addr = sock.saddr || 0;
                port = sock.sport || 0;
            }
            return {
                addr: addr,
                port: port
            };
        },
        sendmsg: function (sock, buffer, offset, length, addr, port) {
            if (sock.type === 2) {
                // connection-less sockets will honor the message address,
                // and otherwise fall back to the bound destination address
                if (addr === undefined || port === undefined) {
                    addr = sock.daddr;
                    port = sock.dport;
                }
                // if there was no address to fall back to, error out
                if (addr === undefined || port === undefined) {
                    throw new FS.ErrnoError(ERRNO_CODES.EDESTADDRREQ);
                }
            } else {
                // connection-based sockets will only use the bound
                addr = sock.daddr;
                port = sock.dport;
            }

            // find the peer for the destination address
            var dest = SOCKFS.websocket_sock_ops.getPeer(sock, addr, port);

            // early out if not connected with a connection-based socket
            if (sock.type === 1) {
                if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                    throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
                } else if (dest.socket.readyState === dest.socket.CONNECTING) {
                    throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
                }
            }

            // create a copy of the incoming data to send, as the WebSocket API
            // doesn't work entirely with an ArrayBufferView, it'll just send
            // the entire underlying buffer
            var data;
            if (buffer instanceof Array || buffer instanceof ArrayBuffer) {
                data = buffer.slice(offset, offset + length);
            } else { // ArrayBufferView
                data = buffer.buffer.slice(buffer.byteOffset + offset, buffer.byteOffset + offset + length);
            }

            // if we're emulating a connection-less dgram socket and don't have
            // a cached connection, queue the buffer to send upon connect and
            // lie, saying the data was sent now.
            if (sock.type === 2) {
                if (!dest || dest.socket.readyState !== dest.socket.OPEN) {
                    // if we're not connected, open a new connection
                    if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                        dest = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
                    }
                    dest.dgram_send_queue.push(data);
                    return length;
                }
            }

            try {
                // send the actual data
                dest.socket.send(data);
                return length;
            } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
            }
        },
        recvmsg: function (sock, length) {
            // http://pubs.opengroup.org/onlinepubs/7908799/xns/recvmsg.html
            if (sock.type === 1 && sock.server) {
                // tcp servers should not be recv()'ing on the listen socket
                throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
            }

            var queued = sock.recv_queue.shift();
            if (!queued) {
                if (sock.type === 1) {
                    var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);

                    if (!dest) {
                        // if we have a destination address but are not connected, error out
                        throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
                    } else if (dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                        // return null if the socket has closed
                        return null;
                    } else {
                        // else, our socket is in a valid state but truly has nothing available
                        throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
                    }
                } else {
                    throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
                }
            }

            // queued.data will be an ArrayBuffer if it's unadulterated, but if it's
            // requeued TCP data it'll be an ArrayBufferView
            var queuedLength = queued.data.byteLength || queued.data.length;
            var queuedOffset = queued.data.byteOffset || 0;
            var queuedBuffer = queued.data.buffer || queued.data;
            var bytesRead = Math.min(length, queuedLength);
            var res = {
                buffer: new Uint8Array(queuedBuffer, queuedOffset, bytesRead),
                addr: queued.addr,
                port: queued.port
            };


            // push back any unread data for TCP connections
            if (sock.type === 1 && bytesRead < queuedLength) {
                var bytesRemaining = queuedLength - bytesRead;
                queued.data = new Uint8Array(queuedBuffer, queuedOffset + bytesRead, bytesRemaining);
                sock.recv_queue.unshift(queued);
            }

            return res;
        }
    }
};

function _send(fd, buf, len, flags) {
    var sock = SOCKFS.getSocket(fd);
    if (!sock) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
    }
    // TODO honor flags
    return _write(fd, buf, len);
}

function _pwrite(fildes, buf, nbyte, offset) {
    // ssize_t pwrite(int fildes, const void *buf, size_t nbyte, off_t offset);
    // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
    var stream = FS.getStream(fildes);
    if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
    }
    try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte, offset);
    } catch (e) {
        FS.handleFSError(e);
        return -1;
    }
}

function _write(fildes, buf, nbyte) {
    // ssize_t write(int fildes, const void *buf, size_t nbyte);
    // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
    var stream = FS.getStream(fildes);
    if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
    }


    try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte);
    } catch (e) {
        FS.handleFSError(e);
        return -1;
    }
}

function _fileno(stream) {
    // int fileno(FILE *stream);
    // http://pubs.opengroup.org/onlinepubs/000095399/functions/fileno.html
    stream = FS.getStreamFromPtr(stream);
    if (!stream) return -1;
    return stream.fd;
}

function _fwrite(ptr, size, nitems, stream) {
    // size_t fwrite(const void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
    // http://pubs.opengroup.org/onlinepubs/000095399/functions/fwrite.html
    var bytesToWrite = nitems * size;
    if (bytesToWrite == 0) return 0;
    var fd = _fileno(stream);
    var bytesWritten = _write(fd, ptr, bytesToWrite);
    if (bytesWritten == -1) {
        var streamObj = FS.getStreamFromPtr(stream);
        if (streamObj) streamObj.error = true;
        return 0;
    } else {
        return Math.floor(bytesWritten / size);
    }
}


function _strtoll(str, endptr, base) {
    return __parseInt64(str, endptr, base, '-9223372036854775808', '9223372036854775807'); // LLONG_MIN, LLONG_MAX.
}

function _strtoll_l(str, endptr, base) {
    return _strtoll(str, endptr, base); // no locale support yet
}


function _sysconf(name) {
    // long sysconf(int name);
    // http://pubs.opengroup.org/onlinepubs/009695399/functions/sysconf.html
    switch (name) {
    case 30:
        return PAGE_SIZE;
    case 132:
    case 133:
    case 12:
    case 137:
    case 138:
    case 15:
    case 235:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 149:
    case 13:
    case 10:
    case 236:
    case 153:
    case 9:
    case 21:
    case 22:
    case 159:
    case 154:
    case 14:
    case 77:
    case 78:
    case 139:
    case 80:
    case 81:
    case 79:
    case 82:
    case 68:
    case 67:
    case 164:
    case 11:
    case 29:
    case 47:
    case 48:
    case 95:
    case 52:
    case 51:
    case 46:
        return 200809;
    case 27:
    case 246:
    case 127:
    case 128:
    case 23:
    case 24:
    case 160:
    case 161:
    case 181:
    case 182:
    case 242:
    case 183:
    case 184:
    case 243:
    case 244:
    case 245:
    case 165:
    case 178:
    case 179:
    case 49:
    case 50:
    case 168:
    case 169:
    case 175:
    case 170:
    case 171:
    case 172:
    case 97:
    case 76:
    case 32:
    case 173:
    case 35:
        return -1;
    case 176:
    case 177:
    case 7:
    case 155:
    case 8:
    case 157:
    case 125:
    case 126:
    case 92:
    case 93:
    case 129:
    case 130:
    case 131:
    case 94:
    case 91:
        return 1;
    case 74:
    case 60:
    case 69:
    case 70:
    case 4:
        return 1024;
    case 31:
    case 42:
    case 72:
        return 32;
    case 87:
    case 26:
    case 33:
        return 2147483647;
    case 34:
    case 1:
        return 47839;
    case 38:
    case 36:
        return 99;
    case 43:
    case 37:
        return 2048;
    case 0:
        return 2097152;
    case 3:
        return 65536;
    case 28:
        return 32768;
    case 44:
        return 32767;
    case 75:
        return 16384;
    case 39:
        return 1000;
    case 89:
        return 700;
    case 71:
        return 256;
    case 40:
        return 255;
    case 2:
        return 100;
    case 180:
        return 64;
    case 25:
        return 20;
    case 5:
        return 16;
    case 6:
        return 6;
    case 73:
        return 4;
    case 84:
        return 1;
    }
    ___setErrNo(ERRNO_CODES.EINVAL);
    return -1;
}


function _pthread_cond_broadcast() {
    return 0;
}



function __exit(status) {
    // void _exit(int status);
    // http://pubs.opengroup.org/onlinepubs/000095399/functions/exit.html
    Module['exit'](status);
}

function _exit(status) {
    __exit(status);
}

function __ZSt9terminatev() {
    _exit(-1234);
}

function _pthread_mutex_unlock() {}


function _isxdigit(chr) {
    return (chr >= 48 && chr <= 57) ||
        (chr >= 97 && chr <= 102) ||
        (chr >= 65 && chr <= 70);
}

function _isxdigit_l(chr) {
    return _isxdigit(chr); // no locale support yet
}


function _emscripten_memcpy_big(dest, src, num) {
    HEAPU8.set(HEAPU8.subarray(src, src + num), dest);
    return dest;
}
Module["_memcpy"] = _memcpy;

function _sbrk(bytes) {
    // Implement a Linux-like 'memory area' for our 'process'.
    // Changes the size of the memory area by |bytes|; returns the
    // address of the previous top ('break') of the memory area
    // We control the "dynamic" memory - DYNAMIC_BASE to DYNAMICTOP
    var self = _sbrk;
    if (!self.called) {
        DYNAMICTOP = alignMemoryPage(DYNAMICTOP); // make sure we start out aligned
        self.called = true;
        assert(Runtime.dynamicAlloc);
        self.alloc = Runtime.dynamicAlloc;
        Runtime.dynamicAlloc = function () {
            abort('cannot dynamically allocate, sbrk now has control')
        };
    }
    var ret = DYNAMICTOP;
    if (bytes != 0) self.alloc(bytes);
    return ret; // Previous break location.
}



function _malloc(bytes) {
    /* Over-allocate to make sure it is byte-aligned by 8.
     * This will leak memory, but this is only the dummy
     * implementation (replaced by dlmalloc normally) so
     * not an issue.
     */
    var ptr = Runtime.dynamicAlloc(bytes + 8);
    return (ptr + 8) & 0xFFFFFFF8;
}
Module["_malloc"] = _malloc;

function _newlocale(mask, locale, base) {
    return _malloc(4);
}


Module["_memmove"] = _memmove;

function ___errno_location() {
    return ___errno_state;
}

var _BItoD = true;

function _catclose(catd) {
    // int catclose (nl_catd catd)
    return 0;
}

function _llvm_lifetime_start() {}

function _abort() {
    Module['abort']();
}

function _fmod(x, y) {
    return x % y;
}

function ___cxa_guard_release() {}

function _ungetc(c, stream) {
    // int ungetc(int c, FILE *stream);
    // http://pubs.opengroup.org/onlinepubs/000095399/functions/ungetc.html
    stream = FS.getStreamFromPtr(stream);
    if (!stream) {
        return -1;
    }
    if (c === -1) {
        // do nothing for EOF character
        return c;
    }
    c = unSign(c & 0xFF);
    stream.ungotten.push(c);
    stream.eof = false;
    return c;
}

function _uselocale(locale) {
    return 0;
}




Module["_strlen"] = _strlen;

function __reallyNegative(x) {
    return x < 0 || (x === 0 && (1 / x) === -Infinity);
}

function __formatString(format, varargs) {
    var textIndex = format;
    var argIndex = 0;

    function getNextArg(type) {
        // NOTE: Explicitly ignoring type safety. Otherwise this fails:
        //       int x = 4; printf("%c\n", (char)x);
        var ret;
        if (type === 'double') {
            ret = (HEAP32[((tempDoublePtr) >> 2)] = HEAP32[(((varargs) + (argIndex)) >> 2)], HEAP32[(((tempDoublePtr) + (4)) >> 2)] = HEAP32[(((varargs) + ((argIndex) + (4))) >> 2)], (+(HEAPF64[(tempDoublePtr) >> 3])));
        } else if (type == 'i64') {
            ret = [HEAP32[(((varargs) + (argIndex)) >> 2)],
                HEAP32[(((varargs) + (argIndex + 4)) >> 2)]
            ];

        } else {
            type = 'i32'; // varargs are always i32, i64, or double
            ret = HEAP32[(((varargs) + (argIndex)) >> 2)];
        }
        argIndex += Runtime.getNativeFieldSize(type);
        return ret;
    }

    var ret = [];
    var curr, next, currArg;
    while (1) {
        var startTextIndex = textIndex;
        curr = HEAP8[(textIndex)];
        if (curr === 0) break;
        next = HEAP8[((textIndex + 1) | 0)];
        if (curr == 37) {
            // Handle flags.
            var flagAlwaysSigned = false;
            var flagLeftAlign = false;
            var flagAlternative = false;
            var flagZeroPad = false;
            var flagPadSign = false;
            flagsLoop: while (1) {
                switch (next) {
                case 43:
                    flagAlwaysSigned = true;
                    break;
                case 45:
                    flagLeftAlign = true;
                    break;
                case 35:
                    flagAlternative = true;
                    break;
                case 48:
                    if (flagZeroPad) {
                        break flagsLoop;
                    } else {
                        flagZeroPad = true;
                        break;
                    }
                case 32:
                    flagPadSign = true;
                    break;
                default:
                    break flagsLoop;
                }
                textIndex++;
                next = HEAP8[((textIndex + 1) | 0)];
            }

            // Handle width.
            var width = 0;
            if (next == 42) {
                width = getNextArg('i32');
                textIndex++;
                next = HEAP8[((textIndex + 1) | 0)];
            } else {
                while (next >= 48 && next <= 57) {
                    width = width * 10 + (next - 48);
                    textIndex++;
                    next = HEAP8[((textIndex + 1) | 0)];
                }
            }

            // Handle precision.
            var precisionSet = false,
                precision = -1;
            if (next == 46) {
                precision = 0;
                precisionSet = true;
                textIndex++;
                next = HEAP8[((textIndex + 1) | 0)];
                if (next == 42) {
                    precision = getNextArg('i32');
                    textIndex++;
                } else {
                    while (1) {
                        var precisionChr = HEAP8[((textIndex + 1) | 0)];
                        if (precisionChr < 48 ||
                            precisionChr > 57) break;
                        precision = precision * 10 + (precisionChr - 48);
                        textIndex++;
                    }
                }
                next = HEAP8[((textIndex + 1) | 0)];
            }
            if (precision < 0) {
                precision = 6; // Standard default.
                precisionSet = false;
            }

            // Handle integer sizes. WARNING: These assume a 32-bit architecture!
            var argSize;
            switch (String.fromCharCode(next)) {
            case 'h':
                var nextNext = HEAP8[((textIndex + 2) | 0)];
                if (nextNext == 104) {
                    textIndex++;
                    argSize = 1; // char (actually i32 in varargs)
                } else {
                    argSize = 2; // short (actually i32 in varargs)
                }
                break;
            case 'l':
                var nextNext = HEAP8[((textIndex + 2) | 0)];
                if (nextNext == 108) {
                    textIndex++;
                    argSize = 8; // long long
                } else {
                    argSize = 4; // long
                }
                break;
            case 'L': // long long
            case 'q': // int64_t
            case 'j': // intmax_t
                argSize = 8;
                break;
            case 'z': // size_t
            case 't': // ptrdiff_t
            case 'I': // signed ptrdiff_t or unsigned size_t
                argSize = 4;
                break;
            default:
                argSize = null;
            }
            if (argSize) textIndex++;
            next = HEAP8[((textIndex + 1) | 0)];

            // Handle type specifier.
            switch (String.fromCharCode(next)) {
            case 'd':
            case 'i':
            case 'u':
            case 'o':
            case 'x':
            case 'X':
            case 'p':
                {
                    // Integer.
                    var signed = next == 100 || next == 105;
                    argSize = argSize || 4;
                    var currArg = getNextArg('i' + (argSize * 8));
                    var origArg = currArg;
                    var argText;
                    // Flatten i64-1 [low, high] into a (slightly rounded) double
                    if (argSize == 8) {
                        currArg = Runtime.makeBigInt(currArg[0], currArg[1], next == 117);
                    }
                    // Truncate to requested size.
                    if (argSize <= 4) {
                        var limit = Math.pow(256, argSize) - 1;
                        currArg = (signed ? reSign : unSign)(currArg & limit, argSize * 8);
                    }
                    // Format the number.
                    var currAbsArg = Math.abs(currArg);
                    var prefix = '';
                    if (next == 100 || next == 105) {
                        if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], null);
                        else
                            argText = reSign(currArg, 8 * argSize, 1).toString(10);
                    } else if (next == 117) {
                        if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], true);
                        else
                            argText = unSign(currArg, 8 * argSize, 1).toString(10);
                        currArg = Math.abs(currArg);
                    } else if (next == 111) {
                        argText = (flagAlternative ? '0' : '') + currAbsArg.toString(8);
                    } else if (next == 120 || next == 88) {
                        prefix = (flagAlternative && currArg != 0) ? '0x' : '';
                        if (argSize == 8 && i64Math) {
                            if (origArg[1]) {
                                argText = (origArg[1] >>> 0).toString(16);
                                var lower = (origArg[0] >>> 0).toString(16);
                                while (lower.length < 8) lower = '0' + lower;
                                argText += lower;
                            } else {
                                argText = (origArg[0] >>> 0).toString(16);
                            }
                        } else
                        if (currArg < 0) {
                            // Represent negative numbers in hex as 2's complement.
                            currArg = -currArg;
                            argText = (currAbsArg - 1).toString(16);
                            var buffer = [];
                            for (var i = 0; i < argText.length; i++) {
                                buffer.push((0xF - parseInt(argText[i], 16)).toString(16));
                            }
                            argText = buffer.join('');
                            while (argText.length < argSize * 2) argText = 'f' + argText;
                        } else {
                            argText = currAbsArg.toString(16);
                        }
                        if (next == 88) {
                            prefix = prefix.toUpperCase();
                            argText = argText.toUpperCase();
                        }
                    } else if (next == 112) {
                        if (currAbsArg === 0) {
                            argText = '(nil)';
                        } else {
                            prefix = '0x';
                            argText = currAbsArg.toString(16);
                        }
                    }
                    if (precisionSet) {
                        while (argText.length < precision) {
                            argText = '0' + argText;
                        }
                    }

                    // Add sign if needed
                    if (currArg >= 0) {
                        if (flagAlwaysSigned) {
                            prefix = '+' + prefix;
                        } else if (flagPadSign) {
                            prefix = ' ' + prefix;
                        }
                    }

                    // Move sign to prefix so we zero-pad after the sign
                    if (argText.charAt(0) == '-') {
                        prefix = '-' + prefix;
                        argText = argText.substr(1);
                    }

                    // Add padding.
                    while (prefix.length + argText.length < width) {
                        if (flagLeftAlign) {
                            argText += ' ';
                        } else {
                            if (flagZeroPad) {
                                argText = '0' + argText;
                            } else {
                                prefix = ' ' + prefix;
                            }
                        }
                    }

                    // Insert the result into the buffer.
                    argText = prefix + argText;
                    argText.split('').forEach(function (chr) {
                        ret.push(chr.charCodeAt(0));
                    });
                    break;
                }
            case 'f':
            case 'F':
            case 'e':
            case 'E':
            case 'g':
            case 'G':
                {
                    // Float.
                    var currArg = getNextArg('double');
                    var argText;
                    if (isNaN(currArg)) {
                        argText = 'nan';
                        flagZeroPad = false;
                    } else if (!isFinite(currArg)) {
                        argText = (currArg < 0 ? '-' : '') + 'inf';
                        flagZeroPad = false;
                    } else {
                        var isGeneral = false;
                        var effectivePrecision = Math.min(precision, 20);

                        // Convert g/G to f/F or e/E, as per:
                        // http://pubs.opengroup.org/onlinepubs/9699919799/functions/printf.html
                        if (next == 103 || next == 71) {
                            isGeneral = true;
                            precision = precision || 1;
                            var exponent = parseInt(currArg.toExponential(effectivePrecision).split('e')[1], 10);
                            if (precision > exponent && exponent >= -4) {
                                next = ((next == 103) ? 'f' : 'F').charCodeAt(0);
                                precision -= exponent + 1;
                            } else {
                                next = ((next == 103) ? 'e' : 'E').charCodeAt(0);
                                precision--;
                            }
                            effectivePrecision = Math.min(precision, 20);
                        }

                        if (next == 101 || next == 69) {
                            argText = currArg.toExponential(effectivePrecision);
                            // Make sure the exponent has at least 2 digits.
                            if (/[eE][-+]\d$/.test(argText)) {
                                argText = argText.slice(0, -1) + '0' + argText.slice(-1);
                            }
                        } else if (next == 102 || next == 70) {
                            argText = currArg.toFixed(effectivePrecision);
                            if (currArg === 0 && __reallyNegative(currArg)) {
                                argText = '-' + argText;
                            }
                        }

                        var parts = argText.split('e');
                        if (isGeneral && !flagAlternative) {
                            // Discard trailing zeros and periods.
                            while (parts[0].length > 1 && parts[0].indexOf('.') != -1 &&
                                (parts[0].slice(-1) == '0' || parts[0].slice(-1) == '.')) {
                                parts[0] = parts[0].slice(0, -1);
                            }
                        } else {
                            // Make sure we have a period in alternative mode.
                            if (flagAlternative && argText.indexOf('.') == -1) parts[0] += '.';
                            // Zero pad until required precision.
                            while (precision > effectivePrecision++) parts[0] += '0';
                        }
                        argText = parts[0] + (parts.length > 1 ? 'e' + parts[1] : '');

                        // Capitalize 'E' if needed.
                        if (next == 69) argText = argText.toUpperCase();

                        // Add sign.
                        if (currArg >= 0) {
                            if (flagAlwaysSigned) {
                                argText = '+' + argText;
                            } else if (flagPadSign) {
                                argText = ' ' + argText;
                            }
                        }
                    }

                    // Add padding.
                    while (argText.length < width) {
                        if (flagLeftAlign) {
                            argText += ' ';
                        } else {
                            if (flagZeroPad && (argText[0] == '-' || argText[0] == '+')) {
                                argText = argText[0] + '0' + argText.slice(1);
                            } else {
                                argText = (flagZeroPad ? '0' : ' ') + argText;
                            }
                        }
                    }

                    // Adjust case.
                    if (next < 97) argText = argText.toUpperCase();

                    // Insert the result into the buffer.
                    argText.split('').forEach(function (chr) {
                        ret.push(chr.charCodeAt(0));
                    });
                    break;
                }
            case 's':
                {
                    // String.
                    var arg = getNextArg('i8*');
                    var argLength = arg ? _strlen(arg) : '(null)'.length;
                    if (precisionSet) argLength = Math.min(argLength, precision);
                    if (!flagLeftAlign) {
                        while (argLength < width--) {
                            ret.push(32);
                        }
                    }
                    if (arg) {
                        for (var i = 0; i < argLength; i++) {
                            ret.push(HEAPU8[((arg++) | 0)]);
                        }
                    } else {
                        ret = ret.concat(intArrayFromString('(null)'.substr(0, argLength), true));
                    }
                    if (flagLeftAlign) {
                        while (argLength < width--) {
                            ret.push(32);
                        }
                    }
                    break;
                }
            case 'c':
                {
                    // Character.
                    if (flagLeftAlign) ret.push(getNextArg('i8'));
                    while (--width > 0) {
                        ret.push(32);
                    }
                    if (!flagLeftAlign) ret.push(getNextArg('i8'));
                    break;
                }
            case 'n':
                {
                    // Write the length written so far to the next parameter.
                    var ptr = getNextArg('i32*');
                    HEAP32[((ptr) >> 2)] = ret.length;
                    break;
                }
            case '%':
                {
                    // Literal percent sign.
                    ret.push(curr);
                    break;
                }
            default:
                {
                    // Unknown specifiers remain untouched.
                    for (var i = startTextIndex; i < textIndex + 2; i++) {
                        ret.push(HEAP8[(i)]);
                    }
                }
            }
            textIndex += 2;
            // TODO: Support a/A (hex float) and m (last error) specifiers.
            // TODO: Support %1${specifier} for arg selection.
        } else {
            ret.push(curr);
            textIndex += 1;
        }
    }
    return ret;
}

function _snprintf(s, n, format, varargs) {
    // int snprintf(char *restrict s, size_t n, const char *restrict format, ...);
    // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
    var result = __formatString(format, varargs);
    var limit = (n === undefined) ? result.length : Math.min(result.length, Math.max(n - 1, 0));
    if (s < 0) {
        s = -s;
        var buf = _malloc(limit + 1);
        HEAP32[((s) >> 2)] = buf;
        s = buf;
    }
    for (var i = 0; i < limit; i++) {
        HEAP8[(((s) + (i)) | 0)] = result[i];
    }
    if (limit < n || (n === undefined)) HEAP8[(((s) + (i)) | 0)] = 0;
    return result.length;
}

function _vsnprintf(s, n, format, va_arg) {
    return _snprintf(s, n, format, HEAP32[((va_arg) >> 2)]);
}




function __getFloat(text) {
    return /^[+-]?[0-9]*\.?[0-9]+([eE][+-]?[0-9]+)?/.exec(text);
}

function __scanString(format, get, unget, varargs) {
    if (!__scanString.whiteSpace) {
        __scanString.whiteSpace = {};
        __scanString.whiteSpace[32] = 1;
        __scanString.whiteSpace[9] = 1;
        __scanString.whiteSpace[10] = 1;
        __scanString.whiteSpace[11] = 1;
        __scanString.whiteSpace[12] = 1;
        __scanString.whiteSpace[13] = 1;
    }
    // Supports %x, %4x, %d.%d, %lld, %s, %f, %lf.
    // TODO: Support all format specifiers.
    format = Pointer_stringify(format);
    var soFar = 0;
    if (format.indexOf('%n') >= 0) {
        // need to track soFar
        var _get = get;
        get = function get() {
            soFar++;
            return _get();
        }
        var _unget = unget;
        unget = function unget() {
            soFar--;
            return _unget();
        }
    }
    var formatIndex = 0;
    var argsi = 0;
    var fields = 0;
    var argIndex = 0;
    var next;

    mainLoop: for (var formatIndex = 0; formatIndex < format.length;) {
        if (format[formatIndex] === '%' && format[formatIndex + 1] == 'n') {
            var argPtr = HEAP32[(((varargs) + (argIndex)) >> 2)];
            argIndex += Runtime.getAlignSize('void*', null, true);
            HEAP32[((argPtr) >> 2)] = soFar;
            formatIndex += 2;
            continue;
        }

        if (format[formatIndex] === '%') {
            var nextC = format.indexOf('c', formatIndex + 1);
            if (nextC > 0) {
                var maxx = 1;
                if (nextC > formatIndex + 1) {
                    var sub = format.substring(formatIndex + 1, nextC);
                    maxx = parseInt(sub);
                    if (maxx != sub) maxx = 0;
                }
                if (maxx) {
                    var argPtr = HEAP32[(((varargs) + (argIndex)) >> 2)];
                    argIndex += Runtime.getAlignSize('void*', null, true);
                    fields++;
                    for (var i = 0; i < maxx; i++) {
                        next = get();
                        HEAP8[((argPtr++) | 0)] = next;
                        if (next === 0) return i > 0 ? fields : fields - 1; // we failed to read the full length of this field
                    }
                    formatIndex += nextC - formatIndex + 1;
                    continue;
                }
            }
        }

        // handle %[...]
        if (format[formatIndex] === '%' && format.indexOf('[', formatIndex + 1) > 0) {
            var match = /\%([0-9]*)\[(\^)?(\]?[^\]]*)\]/.exec(format.substring(formatIndex));
            if (match) {
                var maxNumCharacters = parseInt(match[1]) || Infinity;
                var negateScanList = (match[2] === '^');
                var scanList = match[3];

                // expand "middle" dashs into character sets
                var middleDashMatch;
                while ((middleDashMatch = /([^\-])\-([^\-])/.exec(scanList))) {
                    var rangeStartCharCode = middleDashMatch[1].charCodeAt(0);
                    var rangeEndCharCode = middleDashMatch[2].charCodeAt(0);
                    for (var expanded = ''; rangeStartCharCode <= rangeEndCharCode; expanded += String.fromCharCode(rangeStartCharCode++));
                    scanList = scanList.replace(middleDashMatch[1] + '-' + middleDashMatch[2], expanded);
                }

                var argPtr = HEAP32[(((varargs) + (argIndex)) >> 2)];
                argIndex += Runtime.getAlignSize('void*', null, true);
                fields++;

                for (var i = 0; i < maxNumCharacters; i++) {
                    next = get();
                    if (negateScanList) {
                        if (scanList.indexOf(String.fromCharCode(next)) < 0) {
                            HEAP8[((argPtr++) | 0)] = next;
                        } else {
                            unget();
                            break;
                        }
                    } else {
                        if (scanList.indexOf(String.fromCharCode(next)) >= 0) {
                            HEAP8[((argPtr++) | 0)] = next;
                        } else {
                            unget();
                            break;
                        }
                    }
                }

                // write out null-terminating character
                HEAP8[((argPtr++) | 0)] = 0;
                formatIndex += match[0].length;

                continue;
            }
        }
        // remove whitespace
        while (1) {
            next = get();
            if (next == 0) return fields;
            if (!(next in __scanString.whiteSpace)) break;
        }
        unget();

        if (format[formatIndex] === '%') {
            formatIndex++;
            var suppressAssignment = false;
            if (format[formatIndex] == '*') {
                suppressAssignment = true;
                formatIndex++;
            }
            var maxSpecifierStart = formatIndex;
            while (format[formatIndex].charCodeAt(0) >= 48 &&
                format[formatIndex].charCodeAt(0) <= 57) {
                formatIndex++;
            }
            var max_;
            if (formatIndex != maxSpecifierStart) {
                max_ = parseInt(format.slice(maxSpecifierStart, formatIndex), 10);
            }
            var long_ = false;
            var half = false;
            var longLong = false;
            if (format[formatIndex] == 'l') {
                long_ = true;
                formatIndex++;
                if (format[formatIndex] == 'l') {
                    longLong = true;
                    formatIndex++;
                }
            } else if (format[formatIndex] == 'h') {
                half = true;
                formatIndex++;
            }
            var type = format[formatIndex];
            formatIndex++;
            var curr = 0;
            var buffer = [];
            // Read characters according to the format. floats are trickier, they may be in an unfloat state in the middle, then be a valid float later
            if (type == 'f' || type == 'e' || type == 'g' ||
                type == 'F' || type == 'E' || type == 'G') {
                next = get();
                while (next > 0 && (!(next in __scanString.whiteSpace))) {
                    buffer.push(String.fromCharCode(next));
                    next = get();
                }
                var m = __getFloat(buffer.join(''));
                var last = m ? m[0].length : 0;
                for (var i = 0; i < buffer.length - last + 1; i++) {
                    unget();
                }
                buffer.length = last;
            } else {
                next = get();
                var first = true;

                // Strip the optional 0x prefix for %x.
                if ((type == 'x' || type == 'X') && (next == 48)) {
                    var peek = get();
                    if (peek == 120 || peek == 88) {
                        next = get();
                    } else {
                        unget();
                    }
                }

                while ((curr < max_ || isNaN(max_)) && next > 0) {
                    if (!(next in __scanString.whiteSpace) && // stop on whitespace
                        (type == 's' ||
                            ((type === 'd' || type == 'u' || type == 'i') && ((next >= 48 && next <= 57) ||
                                (first && next == 45))) ||
                            ((type === 'x' || type === 'X') && (next >= 48 && next <= 57 ||
                                next >= 97 && next <= 102 ||
                                next >= 65 && next <= 70))) &&
                        (formatIndex >= format.length || next !== format[formatIndex].charCodeAt(0))) { // Stop when we read something that is coming up
                        buffer.push(String.fromCharCode(next));
                        next = get();
                        curr++;
                        first = false;
                    } else {
                        break;
                    }
                }
                unget();
            }
            if (buffer.length === 0) return 0; // Failure.
            if (suppressAssignment) continue;

            var text = buffer.join('');
            var argPtr = HEAP32[(((varargs) + (argIndex)) >> 2)];
            argIndex += Runtime.getAlignSize('void*', null, true);
            switch (type) {
            case 'd':
            case 'u':
            case 'i':
                if (half) {
                    HEAP16[((argPtr) >> 1)] = parseInt(text, 10);
                } else if (longLong) {
                    (tempI64 = [parseInt(text, 10) >>> 0, (tempDouble = parseInt(text, 10), (+(Math_abs(tempDouble))) >= (+1) ? (tempDouble > (+0) ? ((Math_min((+(Math_floor((tempDouble) / (+4294967296)))), (+4294967295))) | 0) >>> 0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble))) >>> 0)) / (+4294967296)))))) >>> 0) : 0)], HEAP32[((argPtr) >> 2)] = tempI64[0], HEAP32[(((argPtr) + (4)) >> 2)] = tempI64[1]);
                } else {
                    HEAP32[((argPtr) >> 2)] = parseInt(text, 10);
                }
                break;
            case 'X':
            case 'x':
                HEAP32[((argPtr) >> 2)] = parseInt(text, 16);
                break;
            case 'F':
            case 'f':
            case 'E':
            case 'e':
            case 'G':
            case 'g':
            case 'E':
                // fallthrough intended
                if (long_) {
                    HEAPF64[((argPtr) >> 3)] = parseFloat(text);
                } else {
                    HEAPF32[((argPtr) >> 2)] = parseFloat(text);
                }
                break;
            case 's':
                var array = intArrayFromString(text);
                for (var j = 0; j < array.length; j++) {
                    HEAP8[(((argPtr) + (j)) | 0)] = array[j];
                }
                break;
            }
            fields++;
        } else if (format[formatIndex].charCodeAt(0) in __scanString.whiteSpace) {
            next = get();
            while (next in __scanString.whiteSpace) {
                if (next <= 0) break mainLoop; // End of input.
                next = get();
            }
            unget(next);
            formatIndex++;
        } else {
            // Not a specifier.
            next = get();
            if (format[formatIndex].charCodeAt(0) !== next) {
                unget(next);
                break mainLoop;
            }
            formatIndex++;
        }
    }
    return fields;
}

function _sscanf(s, format, varargs) {
    // int sscanf(const char *restrict s, const char *restrict format, ... );
    // http://pubs.opengroup.org/onlinepubs/000095399/functions/scanf.html
    var index = 0;

    function get() {
        return HEAP8[(((s) + (index++)) | 0)];
    };

    function unget() {
        index--;
    };
    return __scanString(format, get, unget, varargs);
}

function _vsscanf(s, format, va_arg) {
    return _sscanf(s, format, HEAP32[((va_arg) >> 2)]);
}




function _recv(fd, buf, len, flags) {
    var sock = SOCKFS.getSocket(fd);
    if (!sock) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
    }
    // TODO honor flags
    return _read(fd, buf, len);
}

function _pread(fildes, buf, nbyte, offset) {
    // ssize_t pread(int fildes, void *buf, size_t nbyte, off_t offset);
    // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
    var stream = FS.getStream(fildes);
    if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
    }
    try {
        var slab = HEAP8;
        return FS.read(stream, slab, buf, nbyte, offset);
    } catch (e) {
        FS.handleFSError(e);
        return -1;
    }
}

function _read(fildes, buf, nbyte) {
    // ssize_t read(int fildes, void *buf, size_t nbyte);
    // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
    var stream = FS.getStream(fildes);
    if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
    }


    try {
        var slab = HEAP8;
        return FS.read(stream, slab, buf, nbyte);
    } catch (e) {
        FS.handleFSError(e);
        return -1;
    }
}

function _fread(ptr, size, nitems, stream) {
    // size_t fread(void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
    // http://pubs.opengroup.org/onlinepubs/000095399/functions/fread.html
    var bytesToRead = nitems * size;
    if (bytesToRead == 0) {
        return 0;
    }
    var bytesRead = 0;
    var streamObj = FS.getStreamFromPtr(stream);
    if (!streamObj) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return 0;
    }
    while (streamObj.ungotten.length && bytesToRead > 0) {
        HEAP8[((ptr++) | 0)] = streamObj.ungotten.pop();
        bytesToRead--;
        bytesRead++;
    }
    var err = _read(streamObj.fd, ptr, bytesToRead);
    if (err == -1) {
        if (streamObj) streamObj.error = true;
        return 0;
    }
    bytesRead += err;
    if (bytesRead < bytesToRead) streamObj.eof = true;
    return Math.floor(bytesRead / size);
}

function _fgetc(stream) {
    // int fgetc(FILE *stream);
    // http://pubs.opengroup.org/onlinepubs/000095399/functions/fgetc.html
    var streamObj = FS.getStreamFromPtr(stream);
    if (!streamObj) return -1;
    if (streamObj.eof || streamObj.error) return -1;
    var ret = _fread(_fgetc.ret, 1, 1, stream);
    if (ret == 0) {
        return -1;
    } else if (ret == -1) {
        streamObj.error = true;
        return -1;
    } else {
        return HEAPU8[((_fgetc.ret) | 0)];
    }
}

var _llvm_memmove_p0i8_p0i8_i32 = _memmove;


function _strerror_r(errnum, strerrbuf, buflen) {
    if (errnum in ERRNO_MESSAGES) {
        if (ERRNO_MESSAGES[errnum].length > buflen - 1) {
            return ___setErrNo(ERRNO_CODES.ERANGE);
        } else {
            var msg = ERRNO_MESSAGES[errnum];
            writeAsciiToMemory(msg, strerrbuf);
            return 0;
        }
    } else {
        return ___setErrNo(ERRNO_CODES.EINVAL);
    }
}

function _strerror(errnum) {
    if (!_strerror.buffer) _strerror.buffer = _malloc(256);
    _strerror_r(errnum, _strerror.buffer, 256);
    return _strerror.buffer;
}



function __isLeapYear(year) {
    return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
}

function __arraySum(array, index) {
    var sum = 0;
    for (var i = 0; i <= index; sum += array[i++]);
    return sum;
}


var __MONTH_DAYS_LEAP = [31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];

var __MONTH_DAYS_REGULAR = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];

function __addDays(date, days) {
    var newDate = new Date(date.getTime());
    while (days > 0) {
        var leap = __isLeapYear(newDate.getFullYear());
        var currentMonth = newDate.getMonth();
        var daysInCurrentMonth = (leap ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR)[currentMonth];

        if (days > daysInCurrentMonth - newDate.getDate()) {
            // we spill over to next month
            days -= (daysInCurrentMonth - newDate.getDate() + 1);
            newDate.setDate(1);
            if (currentMonth < 11) {
                newDate.setMonth(currentMonth + 1)
            } else {
                newDate.setMonth(0);
                newDate.setFullYear(newDate.getFullYear() + 1);
            }
        } else {
            // we stay in current month 
            newDate.setDate(newDate.getDate() + days);
            return newDate;
        }
    }

    return newDate;
}

function _strftime(s, maxsize, format, tm) {
    // size_t strftime(char *restrict s, size_t maxsize, const char *restrict format, const struct tm *restrict timeptr);
    // http://pubs.opengroup.org/onlinepubs/009695399/functions/strftime.html

    var date = {
        tm_sec: HEAP32[((tm) >> 2)],
        tm_min: HEAP32[(((tm) + (4)) >> 2)],
        tm_hour: HEAP32[(((tm) + (8)) >> 2)],
        tm_mday: HEAP32[(((tm) + (12)) >> 2)],
        tm_mon: HEAP32[(((tm) + (16)) >> 2)],
        tm_year: HEAP32[(((tm) + (20)) >> 2)],
        tm_wday: HEAP32[(((tm) + (24)) >> 2)],
        tm_yday: HEAP32[(((tm) + (28)) >> 2)],
        tm_isdst: HEAP32[(((tm) + (32)) >> 2)]
    };

    var pattern = Pointer_stringify(format);

    // expand format
    var EXPANSION_RULES_1 = {
        '%c': '%a %b %d %H:%M:%S %Y', // Replaced by the locale's appropriate date and time representation - e.g., Mon Aug  3 14:02:01 2013
        '%D': '%m/%d/%y', // Equivalent to %m / %d / %y
        '%F': '%Y-%m-%d', // Equivalent to %Y - %m - %d
        '%h': '%b', // Equivalent to %b
        '%r': '%I:%M:%S %p', // Replaced by the time in a.m. and p.m. notation
        '%R': '%H:%M', // Replaced by the time in 24-hour notation
        '%T': '%H:%M:%S', // Replaced by the time
        '%x': '%m/%d/%y', // Replaced by the locale's appropriate date representation
        '%X': '%H:%M:%S', // Replaced by the locale's appropriate date representation
    };
    for (var rule in EXPANSION_RULES_1) {
        pattern = pattern.replace(new RegExp(rule, 'g'), EXPANSION_RULES_1[rule]);
    }

    var WEEKDAYS = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
    var MONTHS = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];

    function leadingSomething(value, digits, character) {
        var str = typeof value === 'number' ? value.toString() : (value || '');
        while (str.length < digits) {
            str = character[0] + str;
        }
        return str;
    };

    function leadingNulls(value, digits) {
        return leadingSomething(value, digits, '0');
    };

    function compareByDay(date1, date2) {
        function sgn(value) {
            return value < 0 ? -1 : (value > 0 ? 1 : 0);
        };

        var compare;
        if ((compare = sgn(date1.getFullYear() - date2.getFullYear())) === 0) {
            if ((compare = sgn(date1.getMonth() - date2.getMonth())) === 0) {
                compare = sgn(date1.getDate() - date2.getDate());
            }
        }
        return compare;
    };

    function getFirstWeekStartDate(janFourth) {
        switch (janFourth.getDay()) {
        case 0: // Sunday
            return new Date(janFourth.getFullYear() - 1, 11, 29);
        case 1: // Monday
            return janFourth;
        case 2: // Tuesday
            return new Date(janFourth.getFullYear(), 0, 3);
        case 3: // Wednesday
            return new Date(janFourth.getFullYear(), 0, 2);
        case 4: // Thursday
            return new Date(janFourth.getFullYear(), 0, 1);
        case 5: // Friday
            return new Date(janFourth.getFullYear() - 1, 11, 31);
        case 6: // Saturday
            return new Date(janFourth.getFullYear() - 1, 11, 30);
        }
    };

    function getWeekBasedYear(date) {
        var thisDate = __addDays(new Date(date.tm_year + 1900, 0, 1), date.tm_yday);

        var janFourthThisYear = new Date(thisDate.getFullYear(), 0, 4);
        var janFourthNextYear = new Date(thisDate.getFullYear() + 1, 0, 4);

        var firstWeekStartThisYear = getFirstWeekStartDate(janFourthThisYear);
        var firstWeekStartNextYear = getFirstWeekStartDate(janFourthNextYear);

        if (compareByDay(firstWeekStartThisYear, thisDate) <= 0) {
            // this date is after the start of the first week of this year
            if (compareByDay(firstWeekStartNextYear, thisDate) <= 0) {
                return thisDate.getFullYear() + 1;
            } else {
                return thisDate.getFullYear();
            }
        } else {
            return thisDate.getFullYear() - 1;
        }
    };

    var EXPANSION_RULES_2 = {
        '%a': function (date) {
            return WEEKDAYS[date.tm_wday].substring(0, 3);
        },
        '%A': function (date) {
            return WEEKDAYS[date.tm_wday];
        },
        '%b': function (date) {
            return MONTHS[date.tm_mon].substring(0, 3);
        },
        '%B': function (date) {
            return MONTHS[date.tm_mon];
        },
        '%C': function (date) {
            var year = date.tm_year + 1900;
            return leadingNulls(Math.floor(year / 100), 2);
        },
        '%d': function (date) {
            return leadingNulls(date.tm_mday, 2);
        },
        '%e': function (date) {
            return leadingSomething(date.tm_mday, 2, ' ');
        },
        '%g': function (date) {
            // %g, %G, and %V give values according to the ISO 8601:2000 standard week-based year. 
            // In this system, weeks begin on a Monday and week 1 of the year is the week that includes 
            // January 4th, which is also the week that includes the first Thursday of the year, and 
            // is also the first week that contains at least four days in the year. 
            // If the first Monday of January is the 2nd, 3rd, or 4th, the preceding days are part of 
            // the last week of the preceding year; thus, for Saturday 2nd January 1999, 
            // %G is replaced by 1998 and %V is replaced by 53. If December 29th, 30th, 
            // or 31st is a Monday, it and any following days are part of week 1 of the following year. 
            // Thus, for Tuesday 30th December 1997, %G is replaced by 1998 and %V is replaced by 01.

            return getWeekBasedYear(date).toString().substring(2);
        },
        '%G': function (date) {
            return getWeekBasedYear(date);
        },
        '%H': function (date) {
            return leadingNulls(date.tm_hour, 2);
        },
        '%I': function (date) {
            return leadingNulls(date.tm_hour < 13 ? date.tm_hour : date.tm_hour - 12, 2);
        },
        '%j': function (date) {
            // Day of the year (001-366)
            return leadingNulls(date.tm_mday + __arraySum(__isLeapYear(date.tm_year + 1900) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, date.tm_mon - 1), 3);
        },
        '%m': function (date) {
            return leadingNulls(date.tm_mon + 1, 2);
        },
        '%M': function (date) {
            return leadingNulls(date.tm_min, 2);
        },
        '%n': function () {
            return '\n';
        },
        '%p': function (date) {
            if (date.tm_hour > 0 && date.tm_hour < 13) {
                return 'AM';
            } else {
                return 'PM';
            }
        },
        '%S': function (date) {
            return leadingNulls(date.tm_sec, 2);
        },
        '%t': function () {
            return '\t';
        },
        '%u': function (date) {
            var day = new Date(date.tm_year + 1900, date.tm_mon + 1, date.tm_mday, 0, 0, 0, 0);
            return day.getDay() || 7;
        },
        '%U': function (date) {
            // Replaced by the week number of the year as a decimal number [00,53]. 
            // The first Sunday of January is the first day of week 1; 
            // days in the new year before this are in week 0. [ tm_year, tm_wday, tm_yday]
            var janFirst = new Date(date.tm_year + 1900, 0, 1);
            var firstSunday = janFirst.getDay() === 0 ? janFirst : __addDays(janFirst, 7 - janFirst.getDay());
            var endDate = new Date(date.tm_year + 1900, date.tm_mon, date.tm_mday);

            // is target date after the first Sunday?
            if (compareByDay(firstSunday, endDate) < 0) {
                // calculate difference in days between first Sunday and endDate
                var februaryFirstUntilEndMonth = __arraySum(__isLeapYear(endDate.getFullYear()) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, endDate.getMonth() - 1) - 31;
                var firstSundayUntilEndJanuary = 31 - firstSunday.getDate();
                var days = firstSundayUntilEndJanuary + februaryFirstUntilEndMonth + endDate.getDate();
                return leadingNulls(Math.ceil(days / 7), 2);
            }

            return compareByDay(firstSunday, janFirst) === 0 ? '01' : '00';
        },
        '%V': function (date) {
            // Replaced by the week number of the year (Monday as the first day of the week) 
            // as a decimal number [01,53]. If the week containing 1 January has four 
            // or more days in the new year, then it is considered week 1. 
            // Otherwise, it is the last week of the previous year, and the next week is week 1. 
            // Both January 4th and the first Thursday of January are always in week 1. [ tm_year, tm_wday, tm_yday]
            var janFourthThisYear = new Date(date.tm_year + 1900, 0, 4);
            var janFourthNextYear = new Date(date.tm_year + 1901, 0, 4);

            var firstWeekStartThisYear = getFirstWeekStartDate(janFourthThisYear);
            var firstWeekStartNextYear = getFirstWeekStartDate(janFourthNextYear);

            var endDate = __addDays(new Date(date.tm_year + 1900, 0, 1), date.tm_yday);

            if (compareByDay(endDate, firstWeekStartThisYear) < 0) {
                // if given date is before this years first week, then it belongs to the 53rd week of last year
                return '53';
            }

            if (compareByDay(firstWeekStartNextYear, endDate) <= 0) {
                // if given date is after next years first week, then it belongs to the 01th week of next year
                return '01';
            }

            // given date is in between CW 01..53 of this calendar year
            var daysDifference;
            if (firstWeekStartThisYear.getFullYear() < date.tm_year + 1900) {
                // first CW of this year starts last year
                daysDifference = date.tm_yday + 32 - firstWeekStartThisYear.getDate()
            } else {
                // first CW of this year starts this year
                daysDifference = date.tm_yday + 1 - firstWeekStartThisYear.getDate();
            }
            return leadingNulls(Math.ceil(daysDifference / 7), 2);
        },
        '%w': function (date) {
            var day = new Date(date.tm_year + 1900, date.tm_mon + 1, date.tm_mday, 0, 0, 0, 0);
            return day.getDay();
        },
        '%W': function (date) {
            // Replaced by the week number of the year as a decimal number [00,53]. 
            // The first Monday of January is the first day of week 1; 
            // days in the new year before this are in week 0. [ tm_year, tm_wday, tm_yday]
            var janFirst = new Date(date.tm_year, 0, 1);
            var firstMonday = janFirst.getDay() === 1 ? janFirst : __addDays(janFirst, janFirst.getDay() === 0 ? 1 : 7 - janFirst.getDay() + 1);
            var endDate = new Date(date.tm_year + 1900, date.tm_mon, date.tm_mday);

            // is target date after the first Monday?
            if (compareByDay(firstMonday, endDate) < 0) {
                var februaryFirstUntilEndMonth = __arraySum(__isLeapYear(endDate.getFullYear()) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, endDate.getMonth() - 1) - 31;
                var firstMondayUntilEndJanuary = 31 - firstMonday.getDate();
                var days = firstMondayUntilEndJanuary + februaryFirstUntilEndMonth + endDate.getDate();
                return leadingNulls(Math.ceil(days / 7), 2);
            }
            return compareByDay(firstMonday, janFirst) === 0 ? '01' : '00';
        },
        '%y': function (date) {
            // Replaced by the last two digits of the year as a decimal number [00,99]. [ tm_year]
            return (date.tm_year + 1900).toString().substring(2);
        },
        '%Y': function (date) {
            // Replaced by the year as a decimal number (for example, 1997). [ tm_year]
            return date.tm_year + 1900;
        },
        '%z': function (date) {
            // Replaced by the offset from UTC in the ISO 8601:2000 standard format ( +hhmm or -hhmm ),
            // or by no characters if no timezone is determinable. 
            // For example, "-0430" means 4 hours 30 minutes behind UTC (west of Greenwich). 
            // If tm_isdst is zero, the standard time offset is used. 
            // If tm_isdst is greater than zero, the daylight savings time offset is used. 
            // If tm_isdst is negative, no characters are returned. 
            // FIXME: we cannot determine time zone (or can we?)
            return '';
        },
        '%Z': function (date) {
            // Replaced by the timezone name or abbreviation, or by no bytes if no timezone information exists. [ tm_isdst]
            // FIXME: we cannot determine time zone (or can we?)
            return '';
        },
        '%%': function () {
            return '%';
        }
    };
    for (var rule in EXPANSION_RULES_2) {
        if (pattern.indexOf(rule) >= 0) {
            pattern = pattern.replace(new RegExp(rule, 'g'), EXPANSION_RULES_2[rule](date));
        }
    }

    var bytes = intArrayFromString(pattern, false);
    if (bytes.length > maxsize) {
        return 0;
    }

    writeArrayToMemory(bytes, s);
    return bytes.length - 1;
}

function _strftime_l(s, maxsize, format, tm) {
    return _strftime(s, maxsize, format, tm); // no locale support yet
}

var _llvm_memcpy_p0i8_p0i8_i32 = _memcpy;


function _pthread_cond_wait() {
    return 0;
}


function _isdigit(chr) {
    return chr >= 48 && chr <= 57;
}

function _isdigit_l(chr) {
    return _isdigit(chr); // no locale support yet
}

var _fabs = Math_abs;

var _floor = Math_floor;

var _getc = _fgetc;

var Browser = {
    mainLoop: {
        scheduler: null,
        method: "",
        shouldPause: false,
        paused: false,
        queue: [],
        pause: function () {
            Browser.mainLoop.shouldPause = true;
        },
        resume: function () {
            if (Browser.mainLoop.paused) {
                Browser.mainLoop.paused = false;
                Browser.mainLoop.scheduler();
            }
            Browser.mainLoop.shouldPause = false;
        },
        updateStatus: function () {
            if (Module['setStatus']) {
                var message = Module['statusMessage'] || 'Please wait...';
                var remaining = Browser.mainLoop.remainingBlockers;
                var expected = Browser.mainLoop.expectedBlockers;
                if (remaining) {
                    if (remaining < expected) {
                        Module['setStatus'](message + ' (' + (expected - remaining) + '/' + expected + ')');
                    } else {
                        Module['setStatus'](message);
                    }
                } else {
                    Module['setStatus']('');
                }
            }
        }
    },
    isFullScreen: false,
    pointerLock: false,
    moduleContextCreatedCallbacks: [],
    workers: [],
    init: function () {
        if (!Module["preloadPlugins"]) Module["preloadPlugins"] = []; // needs to exist even in workers

        if (Browser.initted || ENVIRONMENT_IS_WORKER) return;
        Browser.initted = true;

        try {
            new Blob();
            Browser.hasBlobConstructor = true;
        } catch (e) {
            Browser.hasBlobConstructor = false;
            console.log("warning: no blob constructor, cannot create blobs with mimetypes");
        }
        Browser.BlobBuilder = typeof MozBlobBuilder != "undefined" ? MozBlobBuilder : (typeof WebKitBlobBuilder != "undefined" ? WebKitBlobBuilder : (!Browser.hasBlobConstructor ? console.log("warning: no BlobBuilder") : null));
        Browser.URLObject = typeof window != "undefined" ? (window.URL ? window.URL : window.webkitURL) : undefined;
        if (!Module.noImageDecoding && typeof Browser.URLObject === 'undefined') {
            console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");
            Module.noImageDecoding = true;
        }

        // Support for plugins that can process preloaded files. You can add more of these to
        // your app by creating and appending to Module.preloadPlugins.
        //
        // Each plugin is asked if it can handle a file based on the file's name. If it can,
        // it is given the file's raw data. When it is done, it calls a callback with the file's
        // (possibly modified) data. For example, a plugin might decompress a file, or it
        // might create some side data structure for use later (like an Image element, etc.).

        var imagePlugin = {};
        imagePlugin['canHandle'] = function imagePlugin_canHandle(name) {
            return !Module.noImageDecoding && /\.(jpg|jpeg|png|bmp)$/i.test(name);
        };
        imagePlugin['handle'] = function imagePlugin_handle(byteArray, name, onload, onerror) {
            var b = null;
            if (Browser.hasBlobConstructor) {
                try {
                    b = new Blob([byteArray], {
                        type: Browser.getMimetype(name)
                    });
                    if (b.size !== byteArray.length) { // Safari bug #118630
                        // Safari's Blob can only take an ArrayBuffer
                        b = new Blob([(new Uint8Array(byteArray)).buffer], {
                            type: Browser.getMimetype(name)
                        });
                    }
                } catch (e) {
                    Runtime.warnOnce('Blob constructor present but fails: ' + e + '; falling back to blob builder');
                }
            }
            if (!b) {
                var bb = new Browser.BlobBuilder();
                bb.append((new Uint8Array(byteArray)).buffer); // we need to pass a buffer, and must copy the array to get the right data range
                b = bb.getBlob();
            }
            var url = Browser.URLObject.createObjectURL(b);
            var img = new Image();
            img.onload = function img_onload() {
                assert(img.complete, 'Image ' + name + ' could not be decoded');
                var canvas = document.createElement('canvas');
                canvas.width = img.width;
                canvas.height = img.height;
                var ctx = canvas.getContext('2d');
                ctx.drawImage(img, 0, 0);
                Module["preloadedImages"][name] = canvas;
                Browser.URLObject.revokeObjectURL(url);
                if (onload) onload(byteArray);
            };
            img.onerror = function img_onerror(event) {
                console.log('Image ' + url + ' could not be decoded');
                if (onerror) onerror();
            };
            img.src = url;
        };
        Module['preloadPlugins'].push(imagePlugin);

        var audioPlugin = {};
        audioPlugin['canHandle'] = function audioPlugin_canHandle(name) {
            return !Module.noAudioDecoding && name.substr(-4) in {
                '.ogg': 1,
                '.wav': 1,
                '.mp3': 1
            };
        };
        audioPlugin['handle'] = function audioPlugin_handle(byteArray, name, onload, onerror) {
            var done = false;

            function finish(audio) {
                if (done) return;
                done = true;
                Module["preloadedAudios"][name] = audio;
                if (onload) onload(byteArray);
            }

            function fail() {
                if (done) return;
                done = true;
                Module["preloadedAudios"][name] = new Audio(); // empty shim
                if (onerror) onerror();
            }
            if (Browser.hasBlobConstructor) {
                try {
                    var b = new Blob([byteArray], {
                        type: Browser.getMimetype(name)
                    });
                } catch (e) {
                    return fail();
                }
                var url = Browser.URLObject.createObjectURL(b); // XXX we never revoke this!
                var audio = new Audio();
                audio.addEventListener('canplaythrough', function () {
                    finish(audio)
                }, false); // use addEventListener due to chromium bug 124926
                audio.onerror = function audio_onerror(event) {
                    if (done) return;
                    console.log('warning: browser could not fully decode audio ' + name + ', trying slower base64 approach');

                    function encode64(data) {
                        var BASE = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
                        var PAD = '=';
                        var ret = '';
                        var leftchar = 0;
                        var leftbits = 0;
                        for (var i = 0; i < data.length; i++) {
                            leftchar = (leftchar << 8) | data[i];
                            leftbits += 8;
                            while (leftbits >= 6) {
                                var curr = (leftchar >> (leftbits - 6)) & 0x3f;
                                leftbits -= 6;
                                ret += BASE[curr];
                            }
                        }
                        if (leftbits == 2) {
                            ret += BASE[(leftchar & 3) << 4];
                            ret += PAD + PAD;
                        } else if (leftbits == 4) {
                            ret += BASE[(leftchar & 0xf) << 2];
                            ret += PAD;
                        }
                        return ret;
                    }
                    audio.src = 'data:audio/x-' + name.substr(-3) + ';base64,' + encode64(byteArray);
                    finish(audio); // we don't wait for confirmation this worked - but it's worth trying
                };
                audio.src = url;
                // workaround for chrome bug 124926 - we do not always get oncanplaythrough or onerror
                Browser.safeSetTimeout(function () {
                    finish(audio); // try to use it even though it is not necessarily ready to play
                }, 10000);
            } else {
                return fail();
            }
        };
        Module['preloadPlugins'].push(audioPlugin);

        // Canvas event setup

        var canvas = Module['canvas'];

        // forced aspect ratio can be enabled by defining 'forcedAspectRatio' on Module
        // Module['forcedAspectRatio'] = 4 / 3;

        canvas.requestPointerLock = canvas['requestPointerLock'] ||
            canvas['mozRequestPointerLock'] ||
            canvas['webkitRequestPointerLock'] ||
            canvas['msRequestPointerLock'] ||
            function () {};
        canvas.exitPointerLock = document['exitPointerLock'] ||
            document['mozExitPointerLock'] ||
            document['webkitExitPointerLock'] ||
            document['msExitPointerLock'] ||
            function () {}; // no-op if function does not exist
        canvas.exitPointerLock = canvas.exitPointerLock.bind(document);

        function pointerLockChange() {
            Browser.pointerLock = document['pointerLockElement'] === canvas ||
                document['mozPointerLockElement'] === canvas ||
                document['webkitPointerLockElement'] === canvas ||
                document['msPointerLockElement'] === canvas;
        }

        document.addEventListener('pointerlockchange', pointerLockChange, false);
        document.addEventListener('mozpointerlockchange', pointerLockChange, false);
        document.addEventListener('webkitpointerlockchange', pointerLockChange, false);
        document.addEventListener('mspointerlockchange', pointerLockChange, false);

        if (Module['elementPointerLock']) {
            canvas.addEventListener("click", function (ev) {
                if (!Browser.pointerLock && canvas.requestPointerLock) {
                    canvas.requestPointerLock();
                    ev.preventDefault();
                }
            }, false);
        }
    },
    createContext: function (canvas, useWebGL, setInModule, webGLContextAttributes) {
        var ctx;
        var errorInfo = '?';

        function onContextCreationError(event) {
            errorInfo = event.statusMessage || errorInfo;
        }
        try {
            if (useWebGL) {
                var contextAttributes = {
                    antialias: false,
                    alpha: false
                };

                if (webGLContextAttributes) {
                    for (var attribute in webGLContextAttributes) {
                        contextAttributes[attribute] = webGLContextAttributes[attribute];
                    }
                }


                canvas.addEventListener('webglcontextcreationerror', onContextCreationError, false);
                try {
                    ['experimental-webgl', 'webgl'].some(function (webglId) {
                        return ctx = canvas.getContext(webglId, contextAttributes);
                    });
                } finally {
                    canvas.removeEventListener('webglcontextcreationerror', onContextCreationError, false);
                }
            } else {
                ctx = canvas.getContext('2d');
            }
            if (!ctx) throw ':(';
        } catch (e) {
            Module.print('Could not create canvas: ' + [errorInfo, e]);
            return null;
        }
        if (useWebGL) {
            // Set the background of the WebGL canvas to black
            canvas.style.backgroundColor = "black";

            // Warn on context loss
            canvas.addEventListener('webglcontextlost', function (event) {
                alert('WebGL context lost. You will need to reload the page.');
            }, false);
        }
        if (setInModule) {
            GLctx = Module.ctx = ctx;
            Module.useWebGL = useWebGL;
            Browser.moduleContextCreatedCallbacks.forEach(function (callback) {
                callback()
            });
            Browser.init();
        }
        return ctx;
    },
    destroyContext: function (canvas, useWebGL, setInModule) {},
    fullScreenHandlersInstalled: false,
    lockPointer: undefined,
    resizeCanvas: undefined,
    requestFullScreen: function (lockPointer, resizeCanvas) {
        Browser.lockPointer = lockPointer;
        Browser.resizeCanvas = resizeCanvas;
        if (typeof Browser.lockPointer === 'undefined') Browser.lockPointer = true;
        if (typeof Browser.resizeCanvas === 'undefined') Browser.resizeCanvas = false;

        var canvas = Module['canvas'];
        var canvasContainer = canvas.parentNode;

        function fullScreenChange() {
            Browser.isFullScreen = false;
            if ((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
                document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
                document['fullScreenElement'] || document['fullscreenElement'] ||
                document['msFullScreenElement'] || document['msFullscreenElement'] ||
                document['webkitCurrentFullScreenElement']) === canvasContainer) {
                canvas.cancelFullScreen = document['cancelFullScreen'] ||
                    document['mozCancelFullScreen'] ||
                    document['webkitCancelFullScreen'] ||
                    document['msExitFullscreen'] ||
                    document['exitFullscreen'] ||
                    function () {};
                canvas.cancelFullScreen = canvas.cancelFullScreen.bind(document);
                if (Browser.lockPointer) canvas.requestPointerLock();
                Browser.isFullScreen = true;
                if (Browser.resizeCanvas) Browser.setFullScreenCanvasSize();
            } else {

                // remove the full screen specific parent of the canvas again to restore the HTML structure from before going full screen
                var canvasContainer = canvas.parentNode;
                canvasContainer.parentNode.insertBefore(canvas, canvasContainer);
                canvasContainer.parentNode.removeChild(canvasContainer);

                if (Browser.resizeCanvas) Browser.setWindowedCanvasSize();
            }
            if (Module['onFullScreen']) Module['onFullScreen'](Browser.isFullScreen);
            Browser.updateCanvasDimensions(canvas);
        }

        if (!Browser.fullScreenHandlersInstalled) {
            Browser.fullScreenHandlersInstalled = true;
            document.addEventListener('fullscreenchange', fullScreenChange, false);
            document.addEventListener('mozfullscreenchange', fullScreenChange, false);
            document.addEventListener('webkitfullscreenchange', fullScreenChange, false);
            document.addEventListener('MSFullscreenChange', fullScreenChange, false);
        }

        // create a new parent to ensure the canvas has no siblings. this allows browsers to optimize full screen performance when its parent is the full screen root
        var canvasContainer = document.createElement("div");
        canvas.parentNode.insertBefore(canvasContainer, canvas);
        canvasContainer.appendChild(canvas);

        // use parent of canvas as full screen root to allow aspect ratio correction (Firefox stretches the root to screen size)
        canvasContainer.requestFullScreen = canvasContainer['requestFullScreen'] ||
            canvasContainer['mozRequestFullScreen'] ||
            canvasContainer['msRequestFullscreen'] ||
            (canvasContainer['webkitRequestFullScreen'] ? function () {
            canvasContainer['webkitRequestFullScreen'](Element['ALLOW_KEYBOARD_INPUT'])
        } : null);
        canvasContainer.requestFullScreen();
    },
    requestAnimationFrame: function requestAnimationFrame(func) {
        if (typeof window === 'undefined') { // Provide fallback to setTimeout if window is undefined (e.g. in Node.js)
            setTimeout(func, 1000 / 60);
        } else {
            if (!window.requestAnimationFrame) {
                window.requestAnimationFrame = window['requestAnimationFrame'] ||
                    window['mozRequestAnimationFrame'] ||
                    window['webkitRequestAnimationFrame'] ||
                    window['msRequestAnimationFrame'] ||
                    window['oRequestAnimationFrame'] ||
                    window['setTimeout'];
            }
            window.requestAnimationFrame(func);
        }
    },
    safeCallback: function (func) {
        return function () {
            if (!ABORT) return func.apply(null, arguments);
        };
    },
    safeRequestAnimationFrame: function (func) {
        return Browser.requestAnimationFrame(function () {
            if (!ABORT) func();
        });
    },
    safeSetTimeout: function (func, timeout) {
        return setTimeout(function () {
            if (!ABORT) func();
        }, timeout);
    },
    safeSetInterval: function (func, timeout) {
        return setInterval(function () {
            if (!ABORT) func();
        }, timeout);
    },
    getMimetype: function (name) {
        return {
            'jpg': 'image/jpeg',
            'jpeg': 'image/jpeg',
            'png': 'image/png',
            'bmp': 'image/bmp',
            'ogg': 'audio/ogg',
            'wav': 'audio/wav',
            'mp3': 'audio/mpeg'
        }[name.substr(name.lastIndexOf('.') + 1)];
    },
    getUserMedia: function (func) {
        if (!window.getUserMedia) {
            window.getUserMedia = navigator['getUserMedia'] ||
                navigator['mozGetUserMedia'];
        }
        window.getUserMedia(func);
    },
    getMovementX: function (event) {
        return event['movementX'] ||
            event['mozMovementX'] ||
            event['webkitMovementX'] ||
            0;
    },
    getMovementY: function (event) {
        return event['movementY'] ||
            event['mozMovementY'] ||
            event['webkitMovementY'] ||
            0;
    },
    getMouseWheelDelta: function (event) {
        return Math.max(-1, Math.min(1, event.type === 'DOMMouseScroll' ? event.detail : -event.wheelDelta));
    },
    mouseX: 0,
    mouseY: 0,
    mouseMovementX: 0,
    mouseMovementY: 0,
    calculateMouseEvent: function (event) { // event should be mousemove, mousedown or mouseup
        if (Browser.pointerLock) {
            // When the pointer is locked, calculate the coordinates
            // based on the movement of the mouse.
            // Workaround for Firefox bug 764498
            if (event.type != 'mousemove' &&
                ('mozMovementX' in event)) {
                Browser.mouseMovementX = Browser.mouseMovementY = 0;
            } else {
                Browser.mouseMovementX = Browser.getMovementX(event);
                Browser.mouseMovementY = Browser.getMovementY(event);
            }

            // check if SDL is available
            if (typeof SDL != "undefined") {
                Browser.mouseX = SDL.mouseX + Browser.mouseMovementX;
                Browser.mouseY = SDL.mouseY + Browser.mouseMovementY;
            } else {
                // just add the mouse delta to the current absolut mouse position
                // FIXME: ideally this should be clamped against the canvas size and zero
                Browser.mouseX += Browser.mouseMovementX;
                Browser.mouseY += Browser.mouseMovementY;
            }
        } else {
            // Otherwise, calculate the movement based on the changes
            // in the coordinates.
            var rect = Module["canvas"].getBoundingClientRect();
            var x, y;

            // Neither .scrollX or .pageXOffset are defined in a spec, but
            // we prefer .scrollX because it is currently in a spec draft.
            // (see: http://www.w3.org/TR/2013/WD-cssom-view-20131217/)
            var scrollX = ((typeof window.scrollX !== 'undefined') ? window.scrollX : window.pageXOffset);
            var scrollY = ((typeof window.scrollY !== 'undefined') ? window.scrollY : window.pageYOffset);
            if (event.type == 'touchstart' ||
                event.type == 'touchend' ||
                event.type == 'touchmove') {
                var t = event.touches.item(0);
                if (t) {
                    x = t.pageX - (scrollX + rect.left);
                    y = t.pageY - (scrollY + rect.top);
                } else {
                    return;
                }
            } else {
                x = event.pageX - (scrollX + rect.left);
                y = event.pageY - (scrollY + rect.top);
            }

            // the canvas might be CSS-scaled compared to its backbuffer;
            // SDL-using content will want mouse coordinates in terms
            // of backbuffer units.
            var cw = Module["canvas"].width;
            var ch = Module["canvas"].height;
            x = x * (cw / rect.width);
            y = y * (ch / rect.height);

            Browser.mouseMovementX = x - Browser.mouseX;
            Browser.mouseMovementY = y - Browser.mouseY;
            Browser.mouseX = x;
            Browser.mouseY = y;
        }
    },
    xhrLoad: function (url, onload, onerror) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'arraybuffer';
        xhr.onload = function xhr_onload() {
            if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
                onload(xhr.response);
            } else {
                onerror();
            }
        };
        xhr.onerror = onerror;
        xhr.send(null);
    },
    asyncLoad: function (url, onload, onerror, noRunDep) {
        Browser.xhrLoad(url, function (arrayBuffer) {
            assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
            onload(new Uint8Array(arrayBuffer));
            if (!noRunDep) removeRunDependency('al ' + url);
        }, function (event) {
            if (onerror) {
                onerror();
            } else {
                throw 'Loading data file "' + url + '" failed.';
            }
        });
        if (!noRunDep) addRunDependency('al ' + url);
    },
    resizeListeners: [],
    updateResizeListeners: function () {
        var canvas = Module['canvas'];
        Browser.resizeListeners.forEach(function (listener) {
            listener(canvas.width, canvas.height);
        });
    },
    setCanvasSize: function (width, height, noUpdates) {
        var canvas = Module['canvas'];
        Browser.updateCanvasDimensions(canvas, width, height);
        if (!noUpdates) Browser.updateResizeListeners();
    },
    windowedWidth: 0,
    windowedHeight: 0,
    setFullScreenCanvasSize: function () {
        // check if SDL is available   
        if (typeof SDL != "undefined") {
            var flags = HEAPU32[((SDL.screen + Runtime.QUANTUM_SIZE * 0) >> 2)];
            flags = flags | 0x00800000; // set SDL_FULLSCREEN flag
            HEAP32[((SDL.screen + Runtime.QUANTUM_SIZE * 0) >> 2)] = flags
        }
        Browser.updateResizeListeners();
    },
    setWindowedCanvasSize: function () {
        // check if SDL is available       
        if (typeof SDL != "undefined") {
            var flags = HEAPU32[((SDL.screen + Runtime.QUANTUM_SIZE * 0) >> 2)];
            flags = flags & ~0x00800000; // clear SDL_FULLSCREEN flag
            HEAP32[((SDL.screen + Runtime.QUANTUM_SIZE * 0) >> 2)] = flags
        }
        Browser.updateResizeListeners();
    },
    updateCanvasDimensions: function (canvas, wNative, hNative) {
        if (wNative && hNative) {
            canvas.widthNative = wNative;
            canvas.heightNative = hNative;
        } else {
            wNative = canvas.widthNative;
            hNative = canvas.heightNative;
        }
        var w = wNative;
        var h = hNative;
        if (Module['forcedAspectRatio'] && Module['forcedAspectRatio'] > 0) {
            if (w / h < Module['forcedAspectRatio']) {
                w = Math.round(h * Module['forcedAspectRatio']);
            } else {
                h = Math.round(w / Module['forcedAspectRatio']);
            }
        }
        if (((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
            document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
            document['fullScreenElement'] || document['fullscreenElement'] ||
            document['msFullScreenElement'] || document['msFullscreenElement'] ||
            document['webkitCurrentFullScreenElement']) === canvas.parentNode) && (typeof screen != 'undefined')) {
            var factor = Math.min(screen.width / w, screen.height / h);
            w = Math.round(w * factor);
            h = Math.round(h * factor);
        }
        if (Browser.resizeCanvas) {
            if (canvas.width != w) canvas.width = w;
            if (canvas.height != h) canvas.height = h;
            if (typeof canvas.style != 'undefined') {
                canvas.style.removeProperty("width");
                canvas.style.removeProperty("height");
            }
        } else {
            if (canvas.width != wNative) canvas.width = wNative;
            if (canvas.height != hNative) canvas.height = hNative;
            if (typeof canvas.style != 'undefined') {
                if (w != wNative || h != hNative) {
                    canvas.style.setProperty("width", w + "px", "important");
                    canvas.style.setProperty("height", h + "px", "important");
                } else {
                    canvas.style.removeProperty("width");
                    canvas.style.removeProperty("height");
                }
            }
        }
    }
};

function ___ctype_b_loc() {
    // http://refspecs.freestandards.org/LSB_3.0.0/LSB-Core-generic/LSB-Core-generic/baselib---ctype-b-loc.html
    var me = ___ctype_b_loc;
    if (!me.ret) {
        var values = [
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8195, 8194, 8194, 8194, 8194, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 24577, 49156, 49156, 49156,
            49156, 49156, 49156, 49156, 49156, 49156, 49156, 49156, 49156, 49156, 49156, 49156, 55304, 55304, 55304, 55304, 55304, 55304, 55304, 55304,
            55304, 55304, 49156, 49156, 49156, 49156, 49156, 49156, 49156, 54536, 54536, 54536, 54536, 54536, 54536, 50440, 50440, 50440, 50440, 50440,
            50440, 50440, 50440, 50440, 50440, 50440, 50440, 50440, 50440, 50440, 50440, 50440, 50440, 50440, 50440, 49156, 49156, 49156, 49156, 49156,
            49156, 54792, 54792, 54792, 54792, 54792, 54792, 50696, 50696, 50696, 50696, 50696, 50696, 50696, 50696, 50696, 50696, 50696, 50696, 50696,
            50696, 50696, 50696, 50696, 50696, 50696, 50696, 49156, 49156, 49156, 49156, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        ];
        var i16size = 2;
        var arr = _malloc(values.length * i16size);
        for (var i = 0; i < values.length; i++) {
            HEAP16[(((arr) + (i * i16size)) >> 1)] = values[i];
        }
        me.ret = allocate([arr + 128 * i16size], 'i16*', ALLOC_NORMAL);
    }
    return me.ret;
}


function _free() {}
Module["_free"] = _free;

function _freelocale(locale) {
    _free(locale);
}

function ___cxa_allocate_exception(size) {
    var ptr = _malloc(size + ___cxa_exception_header_size);
    return ptr + ___cxa_exception_header_size;
}

var _fmodl = _fmod;

function _catopen(name, oflag) {
    // nl_catd catopen (const char *name, int oflag)
    return -1;
}

function _catgets(catd, set_id, msg_id, s) {
    // char *catgets (nl_catd catd, int set_id, int msg_id, const char *s)
    return s;
}



function _sprintf(s, format, varargs) {
    // int sprintf(char *restrict s, const char *restrict format, ...);
    // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
    return _snprintf(s, undefined, format, varargs);
}

function _asprintf(s, format, varargs) {
    return _sprintf(-s, format, varargs);
}

function _vasprintf(s, format, va_arg) {
    return _asprintf(s, format, HEAP32[((va_arg) >> 2)]);
}

var ctlz_i8 = allocate([8, 7, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], "i8", ALLOC_STATIC);
Module["_llvm_ctlz_i32"] = _llvm_ctlz_i32;

function _time(ptr) {
    var ret = Math.floor(Date.now() / 1000);
    if (ptr) {
        HEAP32[((ptr) >> 2)] = ret;
    }
    return ret;
}

function _copysign(a, b) {
    return __reallyNegative(a) === __reallyNegative(b) ? a : -a;
}

function ___ctype_toupper_loc() {
    // http://refspecs.freestandards.org/LSB_3.1.1/LSB-Core-generic/LSB-Core-generic/libutil---ctype-toupper-loc.html
    var me = ___ctype_toupper_loc;
    if (!me.ret) {
        var values = [
            128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157,
            158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187,
            188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217,
            218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247,
            248, 249, 250, 251, 252, 253, 254, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
            33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
            73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
            81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144,
            145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174,
            175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204,
            205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234,
            235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255
        ];
        var i32size = 4;
        var arr = _malloc(values.length * i32size);
        for (var i = 0; i < values.length; i++) {
            HEAP32[(((arr) + (i * i32size)) >> 2)] = values[i];
        }
        me.ret = allocate([arr + 128 * i32size], 'i32*', ALLOC_NORMAL);
    }
    return me.ret;
}

function ___cxa_guard_acquire(variable) {
    if (!HEAP8[(variable)]) { // ignore SAFE_HEAP stuff because llvm mixes i64 and i8 here
        HEAP8[(variable)] = 1;
        return 1;
    }
    return 0;
}

function ___ctype_tolower_loc() {
    // http://refspecs.freestandards.org/LSB_3.1.1/LSB-Core-generic/LSB-Core-generic/libutil---ctype-tolower-loc.html
    var me = ___ctype_tolower_loc;
    if (!me.ret) {
        var values = [
            128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157,
            158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187,
            188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217,
            218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247,
            248, 249, 250, 251, 252, 253, 254, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
            33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 97, 98, 99, 100, 101, 102, 103,
            104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103,
            104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133,
            134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163,
            164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193,
            194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
            224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253,
            254, 255
        ];
        var i32size = 4;
        var arr = _malloc(values.length * i32size);
        for (var i = 0; i < values.length; i++) {
            HEAP32[(((arr) + (i * i32size)) >> 2)] = values[i];
        }
        me.ret = allocate([arr + 128 * i32size], 'i32*', ALLOC_NORMAL);
    }
    return me.ret;
}


var ___cxa_caught_exceptions = [];

function ___cxa_begin_catch(ptr) {
    __ZSt18uncaught_exceptionv.uncaught_exception--;
    ___cxa_caught_exceptions.push(___cxa_last_thrown_exception);
    return ptr;
}


Module["_bitshift64Shl"] = _bitshift64Shl;


function __ZNSt9exceptionD2Ev() {}

var _copysignl = _copysign;

var __ZTISt9exception = allocate([allocate([1, 0, 0, 0, 0, 0, 0], "i8", ALLOC_STATIC) + 8, 0], "i32", ALLOC_STATIC);

var ___dso_handle = allocate(1, "i32*", ALLOC_STATIC);



FS.staticInit();
__ATINIT__.unshift({
    func: function () {
        if (!Module["noFSInit"] && !FS.init.initialized) FS.init()
    }
});
__ATMAIN__.push({
    func: function () {
        FS.ignorePermissions = false
    }
});
__ATEXIT__.push({
    func: function () {
        FS.quit()
    }
});
Module["FS_createFolder"] = FS.createFolder;
Module["FS_createPath"] = FS.createPath;
Module["FS_createDataFile"] = FS.createDataFile;
Module["FS_createPreloadedFile"] = FS.createPreloadedFile;
Module["FS_createLazyFile"] = FS.createLazyFile;
Module["FS_createLink"] = FS.createLink;
Module["FS_createDevice"] = FS.createDevice;
___errno_state = Runtime.staticAlloc(4);
HEAP32[((___errno_state) >> 2)] = 0;
__ATINIT__.unshift({
    func: function () {
        TTY.init()
    }
});
__ATEXIT__.push({
    func: function () {
        TTY.shutdown()
    }
});
TTY.utf8 = new Runtime.UTF8Processor();
if (ENVIRONMENT_IS_NODE) {
    var fs = require("fs");
    NODEFS.staticInit();
}
__ATINIT__.push({
    func: function () {
        SOCKFS.root = FS.mount(SOCKFS, {}, null);
    }
});
_fgetc.ret = allocate([0], "i8", ALLOC_STATIC);
Module["requestFullScreen"] = function Module_requestFullScreen(lockPointer, resizeCanvas) {
    Browser.requestFullScreen(lockPointer, resizeCanvas)
};
Module["requestAnimationFrame"] = function Module_requestAnimationFrame(func) {
    Browser.requestAnimationFrame(func)
};
Module["setCanvasSize"] = function Module_setCanvasSize(width, height, noUpdates) {
    Browser.setCanvasSize(width, height, noUpdates)
};
Module["pauseMainLoop"] = function Module_pauseMainLoop() {
    Browser.mainLoop.pause()
};
Module["resumeMainLoop"] = function Module_resumeMainLoop() {
    Browser.mainLoop.resume()
};
Module["getUserMedia"] = function Module_getUserMedia() {
    Browser.getUserMedia()
}
STACK_BASE = STACKTOP = Runtime.alignMemory(STATICTOP);

staticSealed = true; // seal the static portion of memory

STACK_MAX = STACK_BASE + 5242880;

DYNAMIC_BASE = DYNAMICTOP = Runtime.alignMemory(STACK_MAX);

assert(DYNAMIC_BASE < TOTAL_MEMORY, "TOTAL_MEMORY not big enough for stack");

var cttz_i8 = allocate([8, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0], "i8", ALLOC_DYNAMIC);

var Math_min = Math.min;

function invoke_iiii(index, a1, a2, a3) {
    try {
        return Module["dynCall_iiii"](index, a1, a2, a3);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function invoke_viiiiiii(index, a1, a2, a3, a4, a5, a6, a7) {
    try {
        Module["dynCall_viiiiiii"](index, a1, a2, a3, a4, a5, a6, a7);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function invoke_viiiii(index, a1, a2, a3, a4, a5) {
    try {
        Module["dynCall_viiiii"](index, a1, a2, a3, a4, a5);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function invoke_vi(index, a1) {
    try {
        Module["dynCall_vi"](index, a1);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function invoke_vii(index, a1, a2) {
    try {
        Module["dynCall_vii"](index, a1, a2);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function invoke_viiiiiiiii(index, a1, a2, a3, a4, a5, a6, a7, a8, a9) {
    try {
        Module["dynCall_viiiiiiiii"](index, a1, a2, a3, a4, a5, a6, a7, a8, a9);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function invoke_ii(index, a1) {
    try {
        return Module["dynCall_ii"](index, a1);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function invoke_viiiiiid(index, a1, a2, a3, a4, a5, a6, a7) {
    try {
        Module["dynCall_viiiiiid"](index, a1, a2, a3, a4, a5, a6, a7);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function invoke_viii(index, a1, a2, a3) {
    try {
        Module["dynCall_viii"](index, a1, a2, a3);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function invoke_viiiiid(index, a1, a2, a3, a4, a5, a6) {
    try {
        Module["dynCall_viiiiid"](index, a1, a2, a3, a4, a5, a6);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function invoke_v(index) {
    try {
        Module["dynCall_v"](index);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function invoke_iiiiiiiii(index, a1, a2, a3, a4, a5, a6, a7, a8) {
    try {
        return Module["dynCall_iiiiiiiii"](index, a1, a2, a3, a4, a5, a6, a7, a8);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function invoke_iiiii(index, a1, a2, a3, a4) {
    try {
        return Module["dynCall_iiiii"](index, a1, a2, a3, a4);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function invoke_viiiiiiii(index, a1, a2, a3, a4, a5, a6, a7, a8) {
    try {
        Module["dynCall_viiiiiiii"](index, a1, a2, a3, a4, a5, a6, a7, a8);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function invoke_viiiiii(index, a1, a2, a3, a4, a5, a6) {
    try {
        Module["dynCall_viiiiii"](index, a1, a2, a3, a4, a5, a6);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function invoke_iii(index, a1, a2) {
    try {
        return Module["dynCall_iii"](index, a1, a2);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function invoke_iiiiii(index, a1, a2, a3, a4, a5) {
    try {
        return Module["dynCall_iiiiii"](index, a1, a2, a3, a4, a5);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function invoke_viiii(index, a1, a2, a3, a4) {
    try {
        Module["dynCall_viiii"](index, a1, a2, a3, a4);
    } catch (e) {
        if (typeof e !== 'number' && e !== 'longjmp') throw e;
        asm["setThrew"](1, 0);
    }
}

function asmPrintInt(x, y) {
    Module.print('int ' + x + ',' + y); // + ' ' + new Error().stack);
}

function asmPrintFloat(x, y) {
    Module.print('float ' + x + ',' + y); // + ' ' + new Error().stack);
}
// EMSCRIPTEN_START_ASM
var asm = (function (global, env, buffer) {
    "use asm";
    var a = new global.Int8Array(buffer);
    var b = new global.Int16Array(buffer);
    var c = new global.Int32Array(buffer);
    var d = new global.Uint8Array(buffer);
    var e = new global.Uint16Array(buffer);
    var f = new global.Uint32Array(buffer);
    var g = new global.Float32Array(buffer);
    var h = new global.Float64Array(buffer);
    var i = env.STACKTOP | 0;
    var j = env.STACK_MAX | 0;
    var k = env.tempDoublePtr | 0;
    var l = env.ABORT | 0;
    var m = env.cttz_i8 | 0;
    var n = env.ctlz_i8 | 0;
    var o = env.__ZTISt9exception | 0;
    var p = env.___dso_handle | 0;
    var q = env._stderr | 0;
    var r = env._stdin | 0;
    var s = env._stdout | 0;
    var t = 0;
    var u = 0;
    var v = 0;
    var w = 0;
    var x = +env.NaN,
        y = +env.Infinity;
    var z = 0,
        A = 0,
        B = 0,
        C = 0,
        D = 0.0,
        E = 0,
        F = 0,
        G = 0,
        H = 0.0;
    var I = 0;
    var J = 0;
    var K = 0;
    var L = 0;
    var M = 0;
    var N = 0;
    var O = 0;
    var P = 0;
    var Q = 0;
    var R = 0;
    var S = global.Math.floor;
    var T = global.Math.abs;
    var U = global.Math.sqrt;
    var V = global.Math.pow;
    var W = global.Math.cos;
    var X = global.Math.sin;
    var Y = global.Math.tan;
    var Z = global.Math.acos;
    var _ = global.Math.asin;
    var $ = global.Math.atan;
    var aa = global.Math.atan2;
    var ba = global.Math.exp;
    var ca = global.Math.log;
    var da = global.Math.ceil;
    var ea = global.Math.imul;
    var fa = env.abort;
    var ga = env.assert;
    var ha = env.asmPrintInt;
    var ia = env.asmPrintFloat;
    var ja = env.min;
    var ka = env.invoke_iiii;
    var la = env.invoke_viiiiiii;
    var ma = env.invoke_viiiii;
    var na = env.invoke_vi;
    var oa = env.invoke_vii;
    var pa = env.invoke_viiiiiiiii;
    var qa = env.invoke_ii;
    var ra = env.invoke_viiiiiid;
    var sa = env.invoke_viii;
    var ta = env.invoke_viiiiid;
    var ua = env.invoke_v;
    var va = env.invoke_iiiiiiiii;
    var wa = env.invoke_iiiii;
    var xa = env.invoke_viiiiiiii;
    var ya = env.invoke_viiiiii;
    var za = env.invoke_iii;
    var Aa = env.invoke_iiiiii;
    var Ba = env.invoke_viiii;
    var Ca = env._fabs;
    var Da = env._pthread_cond_wait;
    var Ea = env._llvm_lifetime_start;
    var Fa = env._sprintf;
    var Ga = env._send;
    var Ha = env._strtoll_l;
    var Ia = env._vsscanf;
    var Ja = env.___ctype_b_loc;
    var Ka = env.__ZSt9terminatev;
    var La = env._fmod;
    var Ma = env.___cxa_guard_acquire;
    var Na = env._isspace;
    var Oa = env.__reallyNegative;
    var Pa = env.___cxa_is_number_type;
    var Qa = env._ungetc;
    var Ra = env._fread;
    var Sa = env.__getFloat;
    var Ta = env.___cxa_allocate_exception;
    var Ua = env.__ZSt18uncaught_exceptionv;
    var Va = env._floor;
    var Wa = env._isxdigit_l;
    var Xa = env._strtoll;
    var Ya = env._fflush;
    var Za = env.___cxa_guard_release;
    var _a = env.__addDays;
    var $a = env._pwrite;
    var ab = env._strerror_r;
    var bb = env._strftime_l;
    var cb = env._pthread_mutex_lock;
    var db = env._sscanf;
    var eb = env._sbrk;
    var fb = env._uselocale;
    var gb = env._catgets;
    var hb = env._newlocale;
    var ib = env._snprintf;
    var jb = env.___cxa_begin_catch;
    var kb = env._emscripten_memcpy_big;
    var lb = env._asprintf;
    var mb = env.__scanString;
    var nb = env.___resumeException;
    var ob = env.___cxa_find_matching_catch;
    var pb = env.__exit;
    var qb = env._strtoull;
    var rb = env._strftime;
    var sb = env._strtoull_l;
    var tb = env._freelocale;
    var ub = env.__arraySum;
    var vb = env.__formatString;
    var wb = env.___ctype_tolower_loc;
    var xb = env._isdigit_l;
    var yb = env._fileno;
    var zb = env._pthread_mutex_unlock;
    var Ab = env._pread;
    var Bb = env._isxdigit;
    var Cb = env.___ctype_toupper_loc;
    var Db = env._log;
    var Eb = env._vasprintf;
    var Fb = env._write;
    var Gb = env.__isLeapYear;
    var Hb = env.___errno_location;
    var Ib = env._recv;
    var Jb = env._vsnprintf;
    var Kb = env.__ZNSt9exceptionD2Ev;
    var Lb = env._copysign;
    var Mb = env._fgetc;
    var Nb = env._mkport;
    var Ob = env.___cxa_does_inherit;
    var Pb = env._sysconf;
    var Qb = env._pthread_cond_broadcast;
    var Rb = env.__parseInt64;
    var Sb = env._abort;
    var Tb = env._catclose;
    var Ub = env._fwrite;
    var Vb = env.___cxa_throw;
    var Wb = env._isdigit;
    var Xb = env._strerror;
    var Yb = env._llvm_lifetime_end;
    var Zb = env._atexit;
    var _b = env._catopen;
    var $b = env._exit;
    var ac = env._time;
    var bc = env._read;
    var cc = env.___setErrNo;
    var dc = 0.0;
    // EMSCRIPTEN_START_FUNCS
    function wc(a) {
        a = a | 0;
        var b = 0;
        b = i;
        i = i + a | 0;
        i = i + 7 & -8;
        return b | 0
    }

    function xc() {
        return i | 0
    }

    function yc(a) {
        a = a | 0;
        i = a
    }

    function zc(a, b) {
        a = a | 0;
        b = b | 0;
        if ((t | 0) == 0) {
            t = a;
            u = b
        }
    }

    function Ac(b) {
        b = b | 0;
        a[k] = a[b];
        a[k + 1 | 0] = a[b + 1 | 0];
        a[k + 2 | 0] = a[b + 2 | 0];
        a[k + 3 | 0] = a[b + 3 | 0]
    }

    function Bc(b) {
        b = b | 0;
        a[k] = a[b];
        a[k + 1 | 0] = a[b + 1 | 0];
        a[k + 2 | 0] = a[b + 2 | 0];
        a[k + 3 | 0] = a[b + 3 | 0];
        a[k + 4 | 0] = a[b + 4 | 0];
        a[k + 5 | 0] = a[b + 5 | 0];
        a[k + 6 | 0] = a[b + 6 | 0];
        a[k + 7 | 0] = a[b + 7 | 0]
    }

    function Cc(a) {
        a = a | 0;
        I = a
    }

    function Dc(a) {
        a = a | 0;
        J = a
    }

    function Ec(a) {
        a = a | 0;
        K = a
    }

    function Fc(a) {
        a = a | 0;
        L = a
    }

    function Gc(a) {
        a = a | 0;
        M = a
    }

    function Hc(a) {
        a = a | 0;
        N = a
    }

    function Ic(a) {
        a = a | 0;
        O = a
    }

    function Jc(a) {
        a = a | 0;
        P = a
    }

    function Kc(a) {
        a = a | 0;
        Q = a
    }

    function Lc(a) {
        a = a | 0;
        R = a
    }

    function Mc(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0;
        b = i;
        d = c[a >> 2] | 0;
        if ((d | 0) == 0) {
            i = b;
            return
        }
        e = a + 4 | 0;
        a = c[e >> 2] | 0;
        if ((a | 0) != (d | 0)) {
            c[e >> 2] = a + (~((a + -8 + (0 - d) | 0) >>> 3) << 3)
        }
        Om(d);
        i = b;
        return
    }

    function Nc(a, b, c) {
        a = a | 0;
        b = b | 0;
        c = c | 0;
        var d = 0,
            e = 0,
            f = 0,
            g = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0.0;
        c = i;
        i = i + 8 | 0;
        d = c;
        e = a;
        f = b - e | 0;
        g = f >> 3;
        do {
            if ((g | 0) == 0) {
                j = 0;
                k = 0
            } else {
                if (g >>> 0 > 536870911) {
                    Oj(0)
                }
                l = Mm(f) | 0;
                if ((a | 0) == (b | 0)) {
                    j = l;
                    k = l;
                    break
                }
                m = b + -8 + (0 - e) | 0;
                n = a;
                o = l;
                while (1) {
                    if ((o | 0) != 0) {
                        h[o >> 3] = +h[n >> 3]
                    }
                    p = n + 8 | 0;
                    if ((p | 0) == (b | 0)) {
                        break
                    } else {
                        n = p;
                        o = o + 8 | 0
                    }
                }
                j = l + ((m >>> 3) + 1 << 3) | 0;
                k = l
            }
        } while (0);
        md(k, j, d);
        a: do {
            if ((k | 0) != (j | 0)) {
                d = k;
                while (1) {
                    b = d + 8 | 0;
                    if ((b | 0) == (j | 0)) {
                        break a
                    }
                    if (+h[d >> 3] == +h[b >> 3]) {
                        break
                    } else {
                        d = b
                    }
                }
                if ((d | 0) == (j | 0)) {
                    break
                }
                l = d;
                m = d + 8 | 0;
                while (1) {
                    b = m;
                    do {
                        b = b + 8 | 0;
                        if ((b | 0) == (j | 0)) {
                            break a
                        }
                        q = +h[b >> 3];
                    } while (+h[l >> 3] == q);
                    a = l + 8 | 0;
                    h[a >> 3] = q;
                    l = a;
                    m = b
                }
            }
        } while (0);
        if ((k | 0) == 0) {
            i = c;
            return
        }
        Om(k);
        i = c;
        return
    }

    function Oc(a) {
        a = a | 0;
        jb(a | 0) | 0;
        Ka()
    }

    function Pc(a, b, c) {
        a = a | 0;
        b = b | 0;
        c = c | 0;
        var d = 0,
            e = 0,
            f = 0,
            g = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0.0,
            r = 0.0,
            s = 0.0,
            t = 0;
        c = i;
        i = i + 8 | 0;
        d = c;
        e = a;
        f = b - e | 0;
        g = f >> 3;
        do {
            if ((g | 0) == 0) {
                j = 0;
                k = 0
            } else {
                if (g >>> 0 > 536870911) {
                    Oj(0)
                }
                l = Mm(f) | 0;
                if ((a | 0) == (b | 0)) {
                    j = l;
                    k = l;
                    break
                }
                m = b + -8 + (0 - e) | 0;
                n = a;
                o = l;
                while (1) {
                    if ((o | 0) != 0) {
                        h[o >> 3] = +h[n >> 3]
                    }
                    p = n + 8 | 0;
                    if ((p | 0) == (b | 0)) {
                        break
                    } else {
                        n = p;
                        o = o + 8 | 0
                    }
                }
                j = l;
                k = l + ((m >>> 3) + 1 << 3) | 0
            }
        } while (0);
        md(j, k, d);
        a: do {
            if ((j | 0) != (k | 0)) {
                d = j + 8 | 0;
                if ((d | 0) == (k | 0)) {
                    break
                }
                q = +h[j >> 3];
                b = j;
                a = d;
                while (1) {
                    r = +h[a >> 3];
                    if (q == r) {
                        break
                    }
                    d = a + 8 | 0;
                    if ((d | 0) == (k | 0)) {
                        break a
                    } else {
                        e = a;
                        a = d;
                        b = e;
                        q = r
                    }
                }
                if ((b | 0) == (k | 0)) {
                    break
                }
                a = b + 16 | 0;
                if ((a | 0) == (k | 0)) {
                    break
                }
                q = +h[b >> 3];
                m = b;
                l = a;
                while (1) {
                    r = +h[l >> 3];
                    if (q == r) {
                        s = q;
                        t = m
                    } else {
                        a = m + 8 | 0;
                        h[a >> 3] = r;
                        s = r;
                        t = a
                    }
                    a = l + 8 | 0;
                    if ((a | 0) == (k | 0)) {
                        break
                    } else {
                        q = s;
                        m = t;
                        l = a
                    }
                }
            }
        } while (0);
        if ((j | 0) == 0) {
            i = c;
            return
        }
        Om(j);
        i = c;
        return
    }

    function Qc(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0,
            V = 0,
            W = 0,
            X = 0,
            Y = 0,
            Z = 0,
            _ = 0,
            $ = 0,
            aa = 0,
            ba = 0,
            ca = 0,
            da = 0,
            ea = 0,
            fa = 0,
            ga = 0,
            ha = 0,
            ia = 0,
            ja = 0,
            ka = 0,
            la = 0,
            ma = 0,
            na = 0,
            oa = 0,
            pa = 0,
            qa = 0,
            ra = 0,
            sa = 0,
            ta = 0,
            ua = 0,
            va = 0,
            wa = 0,
            xa = 0,
            ya = 0,
            za = 0,
            Aa = 0,
            Ba = 0,
            Ca = 0,
            Da = 0,
            Ea = 0,
            Fa = 0,
            Ga = 0,
            Ha = 0,
            Ia = 0,
            Ja = 0,
            Ka = 0,
            La = 0,
            Ma = 0;
        e = i;
        i = i + 120 | 0;
        f = e;
        g = e + 8 | 0;
        j = e + 16 | 0;
        k = e + 24 | 0;
        l = e + 32 | 0;
        m = e + 40 | 0;
        n = e + 48 | 0;
        o = e + 56 | 0;
        p = e + 64 | 0;
        q = e + 72 | 0;
        r = e + 80 | 0;
        s = e + 88 | 0;
        t = e + 112 | 0;
        u = d;
        v = u - b >> 3;
        w = s;
        x = s;
        c[x + 0 >> 2] = 0;
        c[x + 4 >> 2] = 0;
        c[x + 8 >> 2] = 0;
        c[x + 12 >> 2] = 0;
        c[x + 16 >> 2] = 0;
        c[x + 20 >> 2] = 0;
        do {
            if ((v | 0) == 0) {
                y = s + 16 | 0;
                z = s + 8 | 0;
                A = s + 4 | 0;
                B = 0;
                C = 0;
                D = 0;
                E = 0;
                F = 0
            } else {
                x = s + 8 | 0;
                G = s + 4 | 0;
                H = s + 16 | 0;
                I = s + 20 | 0;
                hd(s, v);
                J = c[I >> 2] | 0;
                K = c[H >> 2] | 0;
                L = c[G >> 2] | 0;
                M = c[x >> 2] | 0;
                N = J + K | 0;
                O = L + (N >>> 9 << 2) | 0;
                if ((M | 0) == (L | 0)) {
                    P = v;
                    Q = O;
                    R = 0
                } else {
                    P = v;
                    Q = O;
                    R = (c[O >> 2] | 0) + ((N & 511) << 3) | 0
                }
                while (1) {
                    if ((R | 0) != 0) {
                        h[R >> 3] = 0.0
                    }
                    N = P + -1 | 0;
                    O = R + 8 | 0;
                    if ((O - (c[Q >> 2] | 0) | 0) == 4096) {
                        S = Q + 4 | 0;
                        T = c[S >> 2] | 0;
                        U = S
                    } else {
                        T = O;
                        U = Q
                    } if ((N | 0) == 0) {
                        break
                    } else {
                        P = N;
                        Q = U;
                        R = T
                    }
                }
                c[I >> 2] = J + v;
                N = L + (K >>> 9 << 2) | 0;
                if ((M | 0) == (L | 0)) {
                    y = H;
                    z = x;
                    A = G;
                    B = N;
                    C = K;
                    D = L;
                    E = M;
                    F = 0;
                    break
                }
                y = H;
                z = x;
                A = G;
                B = N;
                C = K;
                D = L;
                E = M;
                F = (c[N >> 2] | 0) + ((K & 511) << 3) | 0
            }
        } while (0);
        if ((b | 0) == (d | 0)) {
            V = E;
            W = D;
            X = C
        } else {
            C = b;
            b = F;
            D = B;
            B = F;
            while (1) {
                F = (c[D >> 2] | 0) + 4096 - B >> 3;
                E = C;
                v = u - E >> 3;
                if ((v | 0) > (F | 0)) {
                    Y = C + (F << 3) | 0;
                    Z = F
                } else {
                    Y = d;
                    Z = v
                }
                gn(B | 0, C | 0, Y - E | 0) | 0;
                do {
                    if ((Z | 0) == 0) {
                        _ = b;
                        $ = D;
                        aa = B
                    } else {
                        E = (b - (c[D >> 2] | 0) >> 3) + Z | 0;
                        if ((E | 0) > 0) {
                            v = D + (((E | 0) / 512 | 0) << 2) | 0;
                            F = (c[v >> 2] | 0) + (((E | 0) % 512 | 0) << 3) | 0;
                            _ = F;
                            $ = v;
                            aa = F;
                            break
                        } else {
                            F = 511 - E | 0;
                            E = D + (((F | 0) / -512 | 0) << 2) | 0;
                            v = (c[E >> 2] | 0) + (511 - ((F | 0) % 512 | 0) << 3) | 0;
                            _ = v;
                            $ = E;
                            aa = v;
                            break
                        }
                    }
                } while (0);
                if ((Y | 0) == (d | 0)) {
                    break
                } else {
                    C = Y;
                    b = _;
                    D = $;
                    B = aa
                }
            }
            V = c[z >> 2] | 0;
            W = c[A >> 2] | 0;
            X = c[y >> 2] | 0
        }
        aa = W + (X >>> 9 << 2) | 0;
        if ((V | 0) == (W | 0)) {
            ba = 0;
            ca = 0
        } else {
            ba = 0;
            ca = (c[aa >> 2] | 0) + ((X & 511) << 3) | 0
        }
        B = s + 20 | 0;
        s = X + (c[B >> 2] | 0) | 0;
        X = W + (s >>> 9 << 2) | 0;
        if ((V | 0) == (W | 0)) {
            da = 0;
            ea = 0
        } else {
            da = 0;
            ea = (c[X >> 2] | 0) + ((s & 511) << 3) | 0
        }
        s = n;
        W = m;
        c[W >> 2] = ba | aa;
        c[W + 4 >> 2] = ca;
        ca = n;
        c[ca >> 2] = da | X;
        c[ca + 4 >> 2] = ea;
        ea = l;
        ca = m;
        c[ea + 0 >> 2] = c[ca + 0 >> 2];
        c[ea + 4 >> 2] = c[ca + 4 >> 2];
        ca = k;
        ea = s;
        c[ca + 0 >> 2] = c[ea + 0 >> 2];
        c[ca + 4 >> 2] = c[ea + 4 >> 2];
        cd(l, k, o);
        o = c[A >> 2] | 0;
        A = c[y >> 2] | 0;
        y = o + (A >>> 9 << 2) | 0;
        if ((c[z >> 2] | 0) == (o | 0)) {
            fa = o + ((A + (c[B >> 2] | 0) | 0) >>> 9 << 2) | 0;
            ga = 0;
            ha = 0;
            ia = 0;
            ja = 0;
            ka = p;
            la = q;
            ma = r;
            na = p;
            oa = q;
            pa = y;
            qa = ga | pa;
            ra = p;
            sa = ra;
            c[sa >> 2] = qa;
            ta = ra + 4 | 0;
            ua = ta;
            c[ua >> 2] = ha;
            va = fa;
            wa = ia | va;
            xa = q;
            ya = xa;
            c[ya >> 2] = wa;
            za = xa + 4 | 0;
            Aa = za;
            c[Aa >> 2] = ja;
            Ba = j;
            Ca = j;
            Da = na;
            c[Ca + 0 >> 2] = c[Da + 0 >> 2];
            c[Ca + 4 >> 2] = c[Da + 4 >> 2];
            Ea = g;
            Fa = g;
            Ga = oa;
            c[Fa + 0 >> 2] = c[Ga + 0 >> 2];
            c[Fa + 4 >> 2] = c[Ga + 4 >> 2];
            Ha = f;
            Ia = f;
            Ja = r;
            a[Ia + 0 | 0] = a[Ja + 0 | 0] | 0;
            bd(t, j, g, f);
            Ka = f;
            La = g;
            Ma = j;
            gd(w);
            i = e;
            return
        } else {
            z = A + (c[B >> 2] | 0) | 0;
            B = o + (z >>> 9 << 2) | 0;
            fa = B;
            ga = 0;
            ha = (c[y >> 2] | 0) + ((A & 511) << 3) | 0;
            ia = 0;
            ja = (c[B >> 2] | 0) + ((z & 511) << 3) | 0;
            ka = p;
            la = q;
            ma = r;
            na = p;
            oa = q;
            pa = y;
            qa = ga | pa;
            ra = p;
            sa = ra;
            c[sa >> 2] = qa;
            ta = ra + 4 | 0;
            ua = ta;
            c[ua >> 2] = ha;
            va = fa;
            wa = ia | va;
            xa = q;
            ya = xa;
            c[ya >> 2] = wa;
            za = xa + 4 | 0;
            Aa = za;
            c[Aa >> 2] = ja;
            Ba = j;
            Ca = j;
            Da = na;
            c[Ca + 0 >> 2] = c[Da + 0 >> 2];
            c[Ca + 4 >> 2] = c[Da + 4 >> 2];
            Ea = g;
            Fa = g;
            Ga = oa;
            c[Fa + 0 >> 2] = c[Ga + 0 >> 2];
            c[Fa + 4 >> 2] = c[Ga + 4 >> 2];
            Ha = f;
            Ia = f;
            Ja = r;
            a[Ia + 0 | 0] = a[Ja + 0 | 0] | 0;
            bd(t, j, g, f);
            Ka = f;
            La = g;
            Ma = j;
            gd(w);
            i = e;
            return
        }
    }

    function Rc(a, b, d) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0.0,
            z = 0,
            A = 0;
        d = i;
        i = i + 64 | 0;
        e = d;
        f = d + 8 | 0;
        g = d + 16 | 0;
        j = d + 24 | 0;
        k = d + 32 | 0;
        l = d + 40 | 0;
        m = d + 48 | 0;
        n = m;
        o = m;
        c[n >> 2] = o;
        p = m + 4 | 0;
        c[p >> 2] = o;
        q = m + 8 | 0;
        c[q >> 2] = 0;
        if ((a | 0) == (b | 0)) {
            r = 0;
            s = o
        } else {
            m = a;
            a = 0;
            t = o;
            while (1) {
                u = Mm(16) | 0;
                v = u;
                h[u + 8 >> 3] = +h[m >> 3];
                c[t + 4 >> 2] = v;
                c[u >> 2] = c[n >> 2];
                c[n >> 2] = v;
                c[u + 4 >> 2] = o;
                w = a + 1 | 0;
                c[q >> 2] = w;
                u = m + 8 | 0;
                if ((u | 0) == (b | 0)) {
                    break
                } else {
                    t = v;
                    a = w;
                    m = u
                }
            }
            r = w;
            s = c[p >> 2] | 0
        }
        c[g >> 2] = s;
        c[j >> 2] = o;
        s = f;
        w = g;
        c[s + 0 >> 2] = c[w + 0 >> 2];
        w = e;
        s = j;
        c[w + 0 >> 2] = c[s + 0 >> 2];
        ad(k, f, e, r, l);
        l = c[p >> 2] | 0;
        if ((l | 0) != (o | 0)) {
            r = l;
            while (1) {
                l = c[r + 4 >> 2] | 0;
                a: do {
                    if ((l | 0) == (o | 0)) {
                        x = o
                    } else {
                        y = +h[r + 8 >> 3];
                        e = l;
                        while (1) {
                            if (!(y == +h[e + 8 >> 3])) {
                                x = e;
                                break a
                            }
                            f = c[e + 4 >> 2] | 0;
                            if ((f | 0) == (o | 0)) {
                                x = o;
                                break
                            } else {
                                e = f
                            }
                        }
                    }
                } while (0);
                if ((l | 0) == (x | 0)) {
                    z = l
                } else {
                    e = (c[x >> 2] | 0) + 4 | 0;
                    f = l;
                    c[(c[f >> 2] | 0) + 4 >> 2] = c[e >> 2];
                    c[c[e >> 2] >> 2] = c[f >> 2];
                    f = l;
                    while (1) {
                        e = c[f + 4 >> 2] | 0;
                        c[q >> 2] = (c[q >> 2] | 0) + -1;
                        Om(f);
                        if ((e | 0) == (x | 0)) {
                            z = x;
                            break
                        } else {
                            f = e
                        }
                    }
                } if ((z | 0) == (o | 0)) {
                    break
                } else {
                    r = z
                }
            }
        }
        if ((c[q >> 2] | 0) == 0) {
            i = d;
            return
        }
        z = c[p >> 2] | 0;
        p = (c[n >> 2] | 0) + 4 | 0;
        n = z;
        c[(c[n >> 2] | 0) + 4 >> 2] = c[p >> 2];
        c[c[p >> 2] >> 2] = c[n >> 2];
        c[q >> 2] = 0;
        if ((z | 0) == (o | 0)) {
            i = d;
            return
        } else {
            A = z
        }
        while (1) {
            z = c[A + 4 >> 2] | 0;
            Om(A);
            if ((z | 0) == (o | 0)) {
                break
            } else {
                A = z
            }
        }
        i = d;
        return
    }

    function Sc(a, b, d) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0;
        d = i;
        i = i + 40 | 0;
        e = d;
        f = d + 8 | 0;
        g = d + 16 | 0;
        j = d + 24 | 0;
        k = j;
        l = j + 4 | 0;
        c[l >> 2] = 0;
        m = j + 8 | 0;
        c[m >> 2] = 0;
        n = j + 4 | 0;
        o = j;
        c[o >> 2] = n;
        if ((a | 0) == (b | 0)) {
            p = 0;
            Yc(k, p);
            i = d;
            return
        }
        j = g;
        q = a;
        do {
            c[j >> 2] = n;
            a = e;
            r = g;
            c[a + 0 >> 2] = c[r + 0 >> 2];
            r = $c(k, e, f, q) | 0;
            if ((c[r >> 2] | 0) == 0) {
                a = Mm(24) | 0;
                h[a + 16 >> 3] = +h[q >> 3];
                s = c[f >> 2] | 0;
                t = a;
                c[a >> 2] = 0;
                c[a + 4 >> 2] = 0;
                c[a + 8 >> 2] = s;
                c[r >> 2] = t;
                s = c[c[o >> 2] >> 2] | 0;
                if ((s | 0) == 0) {
                    u = t
                } else {
                    c[o >> 2] = s;
                    u = c[r >> 2] | 0
                }
                _c(c[l >> 2] | 0, u);
                c[m >> 2] = (c[m >> 2] | 0) + 1
            }
            q = q + 8 | 0;
        } while ((q | 0) != (b | 0));
        p = c[l >> 2] | 0;
        Yc(k, p);
        i = d;
        return
    }

    function Tc(a, b, d) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0;
        d = i;
        i = i + 40 | 0;
        e = d;
        f = d + 8 | 0;
        g = d + 16 | 0;
        j = d + 24 | 0;
        k = j;
        l = j + 4 | 0;
        c[l >> 2] = 0;
        m = j + 8 | 0;
        c[m >> 2] = 0;
        n = j + 4 | 0;
        o = n;
        p = j;
        c[p >> 2] = o;
        if ((a | 0) == (b | 0)) {
            q = c[l >> 2] | 0;
            r = q;
            Yc(k, r);
            i = d;
            return
        }
        j = g;
        s = a;
        do {
            c[j >> 2] = o;
            a = e;
            t = g;
            c[a + 0 >> 2] = c[t + 0 >> 2];
            t = Zc(k, e, f, s) | 0;
            a = Mm(24) | 0;
            h[a + 16 >> 3] = +h[s >> 3];
            u = c[f >> 2] | 0;
            v = a;
            c[a >> 2] = 0;
            c[a + 4 >> 2] = 0;
            c[a + 8 >> 2] = u;
            c[t >> 2] = v;
            u = c[c[p >> 2] >> 2] | 0;
            if ((u | 0) == 0) {
                w = v
            } else {
                c[p >> 2] = u;
                w = c[t >> 2] | 0
            }
            _c(c[l >> 2] | 0, w);
            c[m >> 2] = (c[m >> 2] | 0) + 1;
            s = s + 8 | 0;
        } while ((s | 0) != (b | 0));
        b = c[p >> 2] | 0;
        if ((b | 0) == (o | 0)) {
            q = c[l >> 2] | 0;
            r = q;
            Yc(k, r);
            i = d;
            return
        }
        o = n;
        n = b;
        a: while (1) {
            b = n + 4 | 0;
            s = n;
            w = n + 16 | 0;
            while (1) {
                x = c[b >> 2] | 0;
                if ((x | 0) == 0) {
                    f = s;
                    while (1) {
                        e = c[f + 8 >> 2] | 0;
                        if ((c[e >> 2] | 0) == (f | 0)) {
                            y = e;
                            break
                        } else {
                            f = e
                        }
                    }
                } else {
                    f = x;
                    while (1) {
                        e = c[f >> 2] | 0;
                        if ((e | 0) == 0) {
                            y = f;
                            break
                        } else {
                            f = e
                        }
                    }
                }
                f = y;
                if ((y | 0) == (o | 0)) {
                    z = 24;
                    break a
                }
                if (!(+h[w >> 3] == +h[y + 16 >> 3])) {
                    break
                }
                e = c[y + 4 >> 2] | 0;
                if ((e | 0) == 0) {
                    g = y;
                    while (1) {
                        j = c[g + 8 >> 2] | 0;
                        if ((c[j >> 2] | 0) == (g | 0)) {
                            A = j;
                            break
                        } else {
                            g = j
                        }
                    }
                } else {
                    g = e;
                    while (1) {
                        j = c[g >> 2] | 0;
                        if ((j | 0) == 0) {
                            A = g;
                            break
                        } else {
                            g = j
                        }
                    }
                } if ((c[p >> 2] | 0) == (f | 0)) {
                    c[p >> 2] = A
                }
                c[m >> 2] = (c[m >> 2] | 0) + -1;
                Xc(c[l >> 2] | 0, y);
                Om(y)
            }
            if ((x | 0) == 0) {
                w = s;
                while (1) {
                    b = c[w + 8 >> 2] | 0;
                    if ((c[b >> 2] | 0) == (w | 0)) {
                        B = b;
                        break
                    } else {
                        w = b
                    }
                }
            } else {
                w = x;
                while (1) {
                    s = c[w >> 2] | 0;
                    if ((s | 0) == 0) {
                        B = w;
                        break
                    } else {
                        w = s
                    }
                }
            } if ((B | 0) == (o | 0)) {
                z = 24;
                break
            } else {
                n = B
            }
        }
        if ((z | 0) == 24) {
            q = c[l >> 2] | 0;
            r = q;
            Yc(k, r);
            i = d;
            return
        }
    }

    function Uc(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0.0,
            f = 0,
            g = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0.0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0.0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0;
        b = i;
        i = i + 8 | 0;
        d = b;
        e = +(a | 0);
        f = ~~+S(+(19931568.569324173 / (e * (+ca(+e) / .6931471805599453))));
        g = a << 1;
        j = c[2] | 0;
        k = c[12 >> 2] | 0;
        if ((k | 0) != (j | 0)) {
            c[12 >> 2] = k + (~((k + -8 + (0 - j) | 0) >>> 3) << 3)
        }
        j = (a | 0) == 0;
        do {
            if (j) {
                l = 0 + (a << 3) | 0;
                m = 0 + (g << 3) | 0;
                n = 0
            } else {
                if (g >>> 0 > 536870911) {
                    Oj(0)
                }
                k = Mm(a << 4) | 0;
                o = g;
                p = k;
                while (1) {
                    if ((p | 0) != 0) {
                        h[p >> 3] = 0.0
                    }
                    q = o + -1 | 0;
                    if ((q | 0) == 0) {
                        break
                    } else {
                        o = q;
                        p = p + 8 | 0
                    }
                }
                p = k + (g << 3) | 0;
                o = k + (a << 3) | 0;
                if (j) {
                    l = o;
                    m = p;
                    n = k;
                    break
                } else {
                    r = k;
                    s = 0.0
                }
                while (1) {
                    q = r + 8 | 0;
                    h[r >> 3] = s;
                    if ((q | 0) == (o | 0)) {
                        l = o;
                        m = p;
                        n = k;
                        break
                    } else {
                        s = s + 1.0;
                        r = q
                    }
                }
            }
        } while (0);
        if ((g | 0) != (a | 0)) {
            g = l;
            s = 0.0;
            while (1) {
                l = g + 8 | 0;
                h[g >> 3] = s;
                if ((l | 0) == (m | 0)) {
                    break
                } else {
                    s = s + 1.0;
                    g = l
                }
            }
        }
        Vc(n, m);
        if ((f | 0) > 0) {
            g = a << 4;
            a = g >> 3;
            l = a >>> 0 > 536870911 ? -1 : a << 3;
            r = n;
            j = f;
            while (1) {
                k = j + -1 | 0;
                p = Nm(l) | 0;
                o = p;
                fn(p | 0, r | 0, g | 0) | 0;
                q = o + (a << 3) | 0;
                md(o, q, d);
                a: do {
                    if ((o | 0) == (q | 0)) {
                        t = o;
                        u = 20
                    } else {
                        v = o;
                        while (1) {
                            w = v + 8 | 0;
                            if ((w | 0) == (q | 0)) {
                                break a
                            }
                            if (+h[v >> 3] == +h[w >> 3]) {
                                t = v;
                                u = 20;
                                break
                            } else {
                                v = w
                            }
                        }
                    }
                } while (0);
                b: do {
                    if ((u | 0) == 20) {
                        u = 0;
                        if ((t | 0) == (q | 0)) {
                            break
                        }
                        o = t;
                        v = t + 8 | 0;
                        while (1) {
                            w = v;
                            do {
                                w = w + 8 | 0;
                                if ((w | 0) == (q | 0)) {
                                    break b
                                }
                                x = +h[w >> 3];
                            } while (+h[o >> 3] == x);
                            y = o + 8 | 0;
                            h[y >> 3] = x;
                            o = y;
                            v = w
                        }
                    }
                } while (0);
                if ((p | 0) != 0) {
                    Pm(p)
                }
                if ((k | 0) > 0) {
                    j = k
                } else {
                    z = f;
                    break
                }
            }
            while (1) {
                j = z + -1 | 0;
                Nc(n, m, j);
                if ((j | 0) > 0) {
                    z = j
                } else {
                    A = f;
                    break
                }
            }
            while (1) {
                z = A + -1 | 0;
                Pc(n, m, z);
                if ((z | 0) > 0) {
                    A = z
                } else {
                    B = f;
                    break
                }
            }
            while (1) {
                A = B + -1 | 0;
                Qc(n, m, A);
                if ((A | 0) > 0) {
                    B = A
                } else {
                    C = f;
                    break
                }
            }
            while (1) {
                B = C + -1 | 0;
                Rc(n, m, B);
                if ((B | 0) > 0) {
                    C = B
                } else {
                    D = f;
                    break
                }
            }
            while (1) {
                C = D + -1 | 0;
                Sc(n, m, C);
                if ((C | 0) > 0) {
                    D = C
                } else {
                    E = f;
                    break
                }
            }
            do {
                E = E + -1 | 0;
                Tc(n, m, E);
            } while ((E | 0) > 0)
        }
        if ((n | 0) == 0) {
            i = b;
            return
        }
        Om(n);
        i = b;
        return
    }

    function Vc(a, b) {
        a = a | 0;
        b = b | 0;
        var c = 0,
            d = 0,
            e = 0,
            f = 0,
            g = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0.0;
        c = i;
        i = i + 8 | 0;
        d = c;
        e = b - a | 0;
        if ((e | 0) <= 8) {
            i = c;
            return
        }
        qd(d);
        f = b + -8 | 0;
        if (f >>> 0 > a >>> 0) {
            b = a;
            a = e >> 3;
            while (1) {
                e = a + -1 | 0;
                do {
                    if ((e | 0) != 0) {
                        if ((a | 0) == 0) {
                            g = pd(d) | 0
                        } else {
                            j = 32 - (jn(a | 0) | 0) | 0;
                            k = (((-1 >>> (33 - j | 0) & a | 0) == 0) << 31 >> 31) + j | 0;
                            j = (k >>> 0) / ((((k & 31 | 0) != 0) + (k >>> 5) | 0) >>> 0) | 0;
                            if ((j | 0) == 0) {
                                l = 0
                            } else {
                                l = -1 >>> (32 - j | 0)
                            }
                            while (1) {
                                j = (pd(d) | 0) & l;
                                if (j >>> 0 < a >>> 0) {
                                    g = j;
                                    break
                                }
                            }
                        } if ((g | 0) == 0) {
                            break
                        }
                        j = b + (g << 3) | 0;
                        m = +h[b >> 3];
                        h[b >> 3] = +h[j >> 3];
                        h[j >> 3] = m
                    }
                } while (0);
                j = b + 8 | 0;
                if (j >>> 0 < f >>> 0) {
                    b = j;
                    a = e
                } else {
                    break
                }
            }
        }
        od(d);
        i = c;
        return
    }

    function Wc() {
        var a = 0;
        a = i;
        Uc(1e5);
        i = a;
        return 0
    }

    function Xc(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0;
        e = i;
        f = d;
        g = c[f >> 2] | 0;
        do {
            if ((g | 0) == 0) {
                h = 0;
                j = d
            } else {
                k = c[d + 4 >> 2] | 0;
                if ((k | 0) == 0) {
                    h = g;
                    j = d;
                    break
                } else {
                    l = k
                }
                while (1) {
                    k = c[l >> 2] | 0;
                    if ((k | 0) == 0) {
                        h = 0;
                        j = l;
                        break
                    } else {
                        l = k
                    }
                }
            }
        } while (0);
        l = j;
        g = j + 4 | 0;
        k = c[((h | 0) == 0 ? g : l) >> 2] | 0;
        h = (k | 0) == 0;
        m = j + 8 | 0;
        if (!h) {
            c[k + 8 >> 2] = c[m >> 2]
        }
        n = c[m >> 2] | 0;
        o = n;
        do {
            if ((c[o >> 2] | 0) == (j | 0)) {
                c[o >> 2] = k;
                if ((j | 0) == (b | 0)) {
                    p = k;
                    q = 0;
                    break
                }
                p = b;
                q = c[(c[m >> 2] | 0) + 4 >> 2] | 0
            } else {
                c[n + 4 >> 2] = k;
                p = b;
                q = c[c[m >> 2] >> 2] | 0
            }
        } while (0);
        b = j + 12 | 0;
        n = (a[b] | 0) == 0;
        if ((j | 0) == (d | 0)) {
            r = p
        } else {
            o = d + 8 | 0;
            s = c[o >> 2] | 0;
            c[m >> 2] = s;
            if ((c[c[o >> 2] >> 2] | 0) == (d | 0)) {
                c[s >> 2] = j
            } else {
                c[s + 4 >> 2] = j
            }
            s = c[f >> 2] | 0;
            c[l >> 2] = s;
            c[s + 8 >> 2] = j;
            s = c[d + 4 >> 2] | 0;
            c[g >> 2] = s;
            if ((s | 0) != 0) {
                c[s + 8 >> 2] = j
            }
            a[b] = a[d + 12 | 0] | 0;
            r = (p | 0) == (d | 0) ? j : p
        } if (n | (r | 0) == 0) {
            i = e;
            return
        }
        if (h) {
            t = r;
            u = q
        } else {
            a[k + 12 | 0] = 1;
            i = e;
            return
        }
        while (1) {
            k = u + 8 | 0;
            q = c[k >> 2] | 0;
            r = q;
            h = u + 12 | 0;
            n = (a[h] | 0) != 0;
            if ((c[r >> 2] | 0) == (u | 0)) {
                if (n) {
                    v = t;
                    w = u
                } else {
                    a[h] = 1;
                    a[q + 12 | 0] = 0;
                    p = u + 4 | 0;
                    j = c[p >> 2] | 0;
                    c[r >> 2] = j;
                    if ((j | 0) != 0) {
                        c[j + 8 >> 2] = q
                    }
                    j = q + 8 | 0;
                    c[k >> 2] = c[j >> 2];
                    k = c[j >> 2] | 0;
                    r = k;
                    if ((c[r >> 2] | 0) == (q | 0)) {
                        c[r >> 2] = u
                    } else {
                        c[k + 4 >> 2] = u
                    }
                    c[p >> 2] = q;
                    c[j >> 2] = u;
                    j = c[p >> 2] | 0;
                    v = (t | 0) == (j | 0) ? u : t;
                    w = c[j >> 2] | 0
                }
                x = c[w >> 2] | 0;
                y = (x | 0) == 0;
                if (!y) {
                    if ((a[x + 12 | 0] | 0) == 0) {
                        z = 66;
                        break
                    }
                }
                j = c[w + 4 >> 2] | 0;
                if ((j | 0) != 0) {
                    if ((a[j + 12 | 0] | 0) == 0) {
                        z = 65;
                        break
                    }
                }
                a[w + 12 | 0] = 0;
                j = c[w + 8 >> 2] | 0;
                A = j + 12 | 0;
                if ((a[A] | 0) == 0 | (j | 0) == (v | 0)) {
                    z = 62;
                    break
                }
                p = c[j + 8 >> 2] | 0;
                k = p;
                B = v;
                C = (c[k >> 2] | 0) == (j | 0) ? p + 4 | 0 : k
            } else {
                if (n) {
                    D = t;
                    E = u
                } else {
                    a[h] = 1;
                    a[q + 12 | 0] = 0;
                    h = q + 4 | 0;
                    n = c[h >> 2] | 0;
                    k = n;
                    p = c[k >> 2] | 0;
                    c[h >> 2] = p;
                    if ((p | 0) != 0) {
                        c[p + 8 >> 2] = q
                    }
                    p = q + 8 | 0;
                    c[n + 8 >> 2] = c[p >> 2];
                    h = c[p >> 2] | 0;
                    j = h;
                    if ((c[j >> 2] | 0) == (q | 0)) {
                        c[j >> 2] = n
                    } else {
                        c[h + 4 >> 2] = n
                    }
                    c[k >> 2] = q;
                    c[p >> 2] = n;
                    n = c[u >> 2] | 0;
                    D = (t | 0) == (n | 0) ? u : t;
                    E = c[n + 4 >> 2] | 0
                }
                F = E;
                G = c[F >> 2] | 0;
                if ((G | 0) != 0) {
                    if ((a[G + 12 | 0] | 0) == 0) {
                        z = 36;
                        break
                    }
                }
                n = c[E + 4 >> 2] | 0;
                if ((n | 0) != 0) {
                    if ((a[n + 12 | 0] | 0) == 0) {
                        H = n;
                        z = 37;
                        break
                    }
                }
                a[E + 12 | 0] = 0;
                n = c[E + 8 >> 2] | 0;
                if ((n | 0) == (D | 0)) {
                    I = D;
                    z = 34;
                    break
                }
                if ((a[n + 12 | 0] | 0) == 0) {
                    I = n;
                    z = 34;
                    break
                }
                p = c[n + 8 >> 2] | 0;
                q = p;
                B = D;
                C = (c[q >> 2] | 0) == (n | 0) ? p + 4 | 0 : q
            }
            t = B;
            u = c[C >> 2] | 0
        }
        if ((z | 0) == 34) {
            a[I + 12 | 0] = 1;
            i = e;
            return
        } else if ((z | 0) == 36) {
            I = c[E + 4 >> 2] | 0;
            if ((I | 0) == 0) {
                z = 38
            } else {
                H = I;
                z = 37
            }
        } else if ((z | 0) == 62) {
            a[A] = 1;
            i = e;
            return
        } else if ((z | 0) == 65) {
            if (y) {
                z = 67
            } else {
                z = 66
            }
        }
        if ((z | 0) == 37) {
            if ((a[H + 12 | 0] | 0) == 0) {
                J = H;
                K = E;
                z = 44
            } else {
                z = 38
            }
        } else if ((z | 0) == 66) {
            if ((a[x + 12 | 0] | 0) == 0) {
                L = x;
                M = w;
                z = 73
            } else {
                z = 67
            }
        }
        if ((z | 0) == 38) {
            a[G + 12 | 0] = 1;
            a[E + 12 | 0] = 0;
            x = G + 4 | 0;
            H = c[x >> 2] | 0;
            c[F >> 2] = H;
            if ((H | 0) != 0) {
                c[H + 8 >> 2] = E
            }
            H = E + 8 | 0;
            c[G + 8 >> 2] = c[H >> 2];
            F = c[H >> 2] | 0;
            y = F;
            if ((c[y >> 2] | 0) == (E | 0)) {
                c[y >> 2] = G
            } else {
                c[F + 4 >> 2] = G
            }
            c[x >> 2] = E;
            c[H >> 2] = G;
            J = c[x >> 2] | 0;
            K = G;
            z = 44
        } else if ((z | 0) == 67) {
            G = w + 4 | 0;
            x = c[G >> 2] | 0;
            a[x + 12 | 0] = 1;
            a[w + 12 | 0] = 0;
            H = x;
            E = c[H >> 2] | 0;
            c[G >> 2] = E;
            if ((E | 0) != 0) {
                c[E + 8 >> 2] = w
            }
            E = w + 8 | 0;
            c[x + 8 >> 2] = c[E >> 2];
            G = c[E >> 2] | 0;
            F = G;
            if ((c[F >> 2] | 0) == (w | 0)) {
                c[F >> 2] = x
            } else {
                c[G + 4 >> 2] = x
            }
            c[H >> 2] = w;
            c[E >> 2] = x;
            L = c[H >> 2] | 0;
            M = x;
            z = 73
        }
        if ((z | 0) == 44) {
            x = c[K + 8 >> 2] | 0;
            H = x + 12 | 0;
            a[K + 12 | 0] = a[H] | 0;
            a[H] = 1;
            a[J + 12 | 0] = 1;
            J = x + 4 | 0;
            H = c[J >> 2] | 0;
            K = H;
            E = c[K >> 2] | 0;
            c[J >> 2] = E;
            if ((E | 0) != 0) {
                c[E + 8 >> 2] = x
            }
            E = x + 8 | 0;
            c[H + 8 >> 2] = c[E >> 2];
            J = c[E >> 2] | 0;
            w = J;
            if ((c[w >> 2] | 0) == (x | 0)) {
                c[w >> 2] = H
            } else {
                c[J + 4 >> 2] = H
            }
            c[K >> 2] = x;
            c[E >> 2] = H;
            i = e;
            return
        } else if ((z | 0) == 73) {
            z = c[M + 8 >> 2] | 0;
            H = z + 12 | 0;
            a[M + 12 | 0] = a[H] | 0;
            a[H] = 1;
            a[L + 12 | 0] = 1;
            L = z;
            H = c[L >> 2] | 0;
            M = H + 4 | 0;
            E = c[M >> 2] | 0;
            c[L >> 2] = E;
            if ((E | 0) != 0) {
                c[E + 8 >> 2] = z
            }
            E = z + 8 | 0;
            c[H + 8 >> 2] = c[E >> 2];
            L = c[E >> 2] | 0;
            x = L;
            if ((c[x >> 2] | 0) == (z | 0)) {
                c[x >> 2] = H
            } else {
                c[L + 4 >> 2] = H
            }
            c[M >> 2] = z;
            c[E >> 2] = H;
            i = e;
            return
        }
    }

    function Yc(a, b) {
        a = a | 0;
        b = b | 0;
        var d = 0;
        d = i;
        if ((b | 0) == 0) {
            i = d;
            return
        } else {
            Yc(a, c[b >> 2] | 0);
            Yc(a, c[b + 4 >> 2] | 0);
            Om(b);
            i = d;
            return
        }
    }

    function Zc(a, b, d, e) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            j = 0,
            k = 0.0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0;
        f = i;
        g = a + 4 | 0;
        j = c[b >> 2] | 0;
        do {
            if ((j | 0) != (g | 0)) {
                k = +h[e >> 3];
                if (!(+h[j + 16 >> 3] < k)) {
                    break
                }
                b = c[a + 4 >> 2] | 0;
                if ((b | 0) == 0) {
                    c[d >> 2] = g;
                    l = g;
                    i = f;
                    return l | 0
                } else {
                    m = b
                }
                while (1) {
                    if (+h[m + 16 >> 3] < k) {
                        n = m + 4 | 0;
                        b = c[n >> 2] | 0;
                        if ((b | 0) == 0) {
                            o = 22;
                            break
                        } else {
                            m = b;
                            continue
                        }
                    } else {
                        p = m;
                        b = c[p >> 2] | 0;
                        if ((b | 0) == 0) {
                            o = 24;
                            break
                        } else {
                            m = b;
                            continue
                        }
                    }
                }
                if ((o | 0) == 22) {
                    c[d >> 2] = m;
                    l = n;
                    i = f;
                    return l | 0
                } else if ((o | 0) == 24) {
                    c[d >> 2] = m;
                    l = p;
                    i = f;
                    return l | 0
                }
            }
        } while (0);
        p = c[j >> 2] | 0;
        do {
            if ((j | 0) == (c[a >> 2] | 0)) {
                q = j
            } else {
                if ((p | 0) == 0) {
                    m = j;
                    while (1) {
                        n = c[m + 8 >> 2] | 0;
                        if ((c[n >> 2] | 0) == (m | 0)) {
                            m = n
                        } else {
                            r = n;
                            break
                        }
                    }
                } else {
                    m = p;
                    while (1) {
                        n = c[m + 4 >> 2] | 0;
                        if ((n | 0) == 0) {
                            r = m;
                            break
                        } else {
                            m = n
                        }
                    }
                }
                k = +h[e >> 3];
                if (!(k < +h[r + 16 >> 3])) {
                    q = r;
                    break
                }
                m = c[a + 4 >> 2] | 0;
                if ((m | 0) == 0) {
                    c[d >> 2] = g;
                    l = g;
                    i = f;
                    return l | 0
                } else {
                    s = m
                }
                while (1) {
                    if (k < +h[s + 16 >> 3]) {
                        t = s;
                        m = c[t >> 2] | 0;
                        if ((m | 0) == 0) {
                            o = 15;
                            break
                        } else {
                            s = m;
                            continue
                        }
                    } else {
                        u = s + 4 | 0;
                        m = c[u >> 2] | 0;
                        if ((m | 0) == 0) {
                            o = 17;
                            break
                        } else {
                            s = m;
                            continue
                        }
                    }
                }
                if ((o | 0) == 15) {
                    c[d >> 2] = s;
                    l = t;
                    i = f;
                    return l | 0
                } else if ((o | 0) == 17) {
                    c[d >> 2] = s;
                    l = u;
                    i = f;
                    return l | 0
                }
            }
        } while (0);
        if ((p | 0) == 0) {
            c[d >> 2] = j;
            l = j;
            i = f;
            return l | 0
        } else {
            c[d >> 2] = q;
            l = q + 4 | 0;
            i = f;
            return l | 0
        }
        return 0
    }

    function _c(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0;
        e = i;
        f = (d | 0) == (b | 0);
        a[d + 12 | 0] = f & 1;
        if (f) {
            i = e;
            return
        } else {
            g = d
        }
        while (1) {
            h = g + 8 | 0;
            j = c[h >> 2] | 0;
            d = j + 12 | 0;
            if ((a[d] | 0) != 0) {
                k = 37;
                break
            }
            l = j + 8 | 0;
            m = c[l >> 2] | 0;
            f = c[m >> 2] | 0;
            if ((f | 0) == (j | 0)) {
                n = c[m + 4 >> 2] | 0;
                if ((n | 0) == 0) {
                    k = 7;
                    break
                }
                o = n + 12 | 0;
                if ((a[o] | 0) != 0) {
                    k = 7;
                    break
                }
                a[d] = 1;
                a[m + 12 | 0] = (m | 0) == (b | 0) | 0;
                a[o] = 1
            } else {
                if ((f | 0) == 0) {
                    k = 24;
                    break
                }
                o = f + 12 | 0;
                if ((a[o] | 0) != 0) {
                    k = 24;
                    break
                }
                a[d] = 1;
                a[m + 12 | 0] = (m | 0) == (b | 0) | 0;
                a[o] = 1
            } if ((m | 0) == (b | 0)) {
                k = 37;
                break
            } else {
                g = m
            }
        }
        if ((k | 0) == 7) {
            if ((c[j >> 2] | 0) == (g | 0)) {
                p = j;
                q = m;
                r = j
            } else {
                b = j + 4 | 0;
                o = c[b >> 2] | 0;
                d = o;
                f = c[d >> 2] | 0;
                c[b >> 2] = f;
                if ((f | 0) == 0) {
                    s = m
                } else {
                    c[f + 8 >> 2] = j;
                    s = c[l >> 2] | 0
                }
                f = o + 8 | 0;
                c[f >> 2] = s;
                s = c[l >> 2] | 0;
                b = s;
                if ((c[b >> 2] | 0) == (j | 0)) {
                    c[b >> 2] = o
                } else {
                    c[s + 4 >> 2] = o
                }
                c[d >> 2] = j;
                c[l >> 2] = o;
                d = c[f >> 2] | 0;
                p = c[d >> 2] | 0;
                q = d;
                r = o
            }
            a[r + 12 | 0] = 1;
            a[q + 12 | 0] = 0;
            r = p + 4 | 0;
            o = c[r >> 2] | 0;
            c[q >> 2] = o;
            if ((o | 0) != 0) {
                c[o + 8 >> 2] = q
            }
            o = q + 8 | 0;
            c[p + 8 >> 2] = c[o >> 2];
            d = c[o >> 2] | 0;
            f = d;
            if ((c[f >> 2] | 0) == (q | 0)) {
                c[f >> 2] = p
            } else {
                c[d + 4 >> 2] = p
            }
            c[r >> 2] = q;
            c[o >> 2] = p;
            i = e;
            return
        } else if ((k | 0) == 24) {
            p = j;
            if ((c[p >> 2] | 0) == (g | 0)) {
                o = g + 4 | 0;
                q = c[o >> 2] | 0;
                c[p >> 2] = q;
                if ((q | 0) == 0) {
                    t = m
                } else {
                    c[q + 8 >> 2] = j;
                    t = c[l >> 2] | 0
                }
                c[h >> 2] = t;
                t = c[l >> 2] | 0;
                q = t;
                if ((c[q >> 2] | 0) == (j | 0)) {
                    c[q >> 2] = g
                } else {
                    c[t + 4 >> 2] = g
                }
                c[o >> 2] = j;
                c[l >> 2] = g;
                u = c[h >> 2] | 0;
                v = g
            } else {
                u = m;
                v = j
            }
            a[v + 12 | 0] = 1;
            a[u + 12 | 0] = 0;
            v = u + 4 | 0;
            j = c[v >> 2] | 0;
            m = j;
            g = c[m >> 2] | 0;
            c[v >> 2] = g;
            if ((g | 0) != 0) {
                c[g + 8 >> 2] = u
            }
            g = u + 8 | 0;
            c[j + 8 >> 2] = c[g >> 2];
            v = c[g >> 2] | 0;
            h = v;
            if ((c[h >> 2] | 0) == (u | 0)) {
                c[h >> 2] = j
            } else {
                c[v + 4 >> 2] = j
            }
            c[m >> 2] = u;
            c[g >> 2] = j;
            i = e;
            return
        } else if ((k | 0) == 37) {
            i = e;
            return
        }
    }

    function $c(a, b, d, e) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            j = 0,
            k = 0.0,
            l = 0.0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0;
        f = i;
        g = a + 4 | 0;
        j = c[b >> 2] | 0;
        do {
            if ((j | 0) != (g | 0)) {
                k = +h[e >> 3];
                l = +h[j + 16 >> 3];
                if (k < l) {
                    break
                }
                if (!(l < k)) {
                    c[d >> 2] = j;
                    m = d;
                    i = f;
                    return m | 0
                }
                b = j + 4 | 0;
                n = c[b >> 2] | 0;
                o = (n | 0) == 0;
                if (o) {
                    p = j;
                    while (1) {
                        q = c[p + 8 >> 2] | 0;
                        if ((c[q >> 2] | 0) == (p | 0)) {
                            r = q;
                            break
                        } else {
                            p = q
                        }
                    }
                } else {
                    p = n;
                    while (1) {
                        q = c[p >> 2] | 0;
                        if ((q | 0) == 0) {
                            r = p;
                            break
                        } else {
                            p = q
                        }
                    }
                }
                p = g;
                do {
                    if ((r | 0) != (p | 0)) {
                        if (k < +h[r + 16 >> 3]) {
                            break
                        }
                        n = c[a + 4 >> 2] | 0;
                        if ((n | 0) == 0) {
                            c[d >> 2] = p;
                            m = g;
                            i = f;
                            return m | 0
                        } else {
                            s = n
                        }
                        while (1) {
                            l = +h[s + 16 >> 3];
                            if (k < l) {
                                t = s;
                                n = c[t >> 2] | 0;
                                if ((n | 0) == 0) {
                                    u = 34;
                                    break
                                } else {
                                    s = n;
                                    continue
                                }
                            }
                            if (!(l < k)) {
                                u = 38;
                                break
                            }
                            v = s + 4 | 0;
                            n = c[v >> 2] | 0;
                            if ((n | 0) == 0) {
                                u = 37;
                                break
                            } else {
                                s = n
                            }
                        }
                        if ((u | 0) == 34) {
                            c[d >> 2] = s;
                            m = t;
                            i = f;
                            return m | 0
                        } else if ((u | 0) == 37) {
                            c[d >> 2] = s;
                            m = v;
                            i = f;
                            return m | 0
                        } else if ((u | 0) == 38) {
                            c[d >> 2] = s;
                            m = d;
                            i = f;
                            return m | 0
                        }
                    }
                } while (0);
                if (o) {
                    c[d >> 2] = j;
                    m = b;
                    i = f;
                    return m | 0
                } else {
                    c[d >> 2] = r;
                    m = r;
                    i = f;
                    return m | 0
                }
            }
        } while (0);
        r = c[j >> 2] | 0;
        do {
            if ((j | 0) == (c[a >> 2] | 0)) {
                w = j
            } else {
                if ((r | 0) == 0) {
                    s = j;
                    while (1) {
                        v = c[s + 8 >> 2] | 0;
                        if ((c[v >> 2] | 0) == (s | 0)) {
                            s = v
                        } else {
                            x = v;
                            break
                        }
                    }
                } else {
                    s = r;
                    while (1) {
                        b = c[s + 4 >> 2] | 0;
                        if ((b | 0) == 0) {
                            x = s;
                            break
                        } else {
                            s = b
                        }
                    }
                }
                k = +h[e >> 3];
                if (+h[x + 16 >> 3] < k) {
                    w = x;
                    break
                }
                s = c[a + 4 >> 2] | 0;
                if ((s | 0) == 0) {
                    c[d >> 2] = g;
                    m = g;
                    i = f;
                    return m | 0
                } else {
                    y = s
                }
                while (1) {
                    l = +h[y + 16 >> 3];
                    if (k < l) {
                        z = y;
                        s = c[z >> 2] | 0;
                        if ((s | 0) == 0) {
                            u = 15;
                            break
                        } else {
                            y = s;
                            continue
                        }
                    }
                    if (!(l < k)) {
                        u = 19;
                        break
                    }
                    A = y + 4 | 0;
                    s = c[A >> 2] | 0;
                    if ((s | 0) == 0) {
                        u = 18;
                        break
                    } else {
                        y = s
                    }
                }
                if ((u | 0) == 15) {
                    c[d >> 2] = y;
                    m = z;
                    i = f;
                    return m | 0
                } else if ((u | 0) == 18) {
                    c[d >> 2] = y;
                    m = A;
                    i = f;
                    return m | 0
                } else if ((u | 0) == 19) {
                    c[d >> 2] = y;
                    m = d;
                    i = f;
                    return m | 0
                }
            }
        } while (0);
        if ((r | 0) == 0) {
            c[d >> 2] = j;
            m = j;
            i = f;
            return m | 0
        } else {
            c[d >> 2] = w;
            m = w + 4 | 0;
            i = f;
            return m | 0
        }
        return 0
    }

    function ad(a, b, d, e, f) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        var g = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0.0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0.0,
            H = 0;
        g = i;
        i = i + 80 | 0;
        j = g;
        k = g + 8 | 0;
        l = g + 16 | 0;
        m = g + 24 | 0;
        n = g + 32 | 0;
        o = g + 40 | 0;
        p = g + 48 | 0;
        q = g + 56 | 0;
        r = g + 64 | 0;
        s = g + 72 | 0;
        if ((e | 0) == 2) {
            t = d;
            u = c[c[t >> 2] >> 2] | 0;
            c[t >> 2] = u;
            t = c[b >> 2] | 0;
            if (+h[u + 8 >> 3] < +h[t + 8 >> 3]) {
                v = u + 4 | 0;
                w = u;
                c[(c[w >> 2] | 0) + 4 >> 2] = c[v >> 2];
                c[c[v >> 2] >> 2] = c[w >> 2];
                x = t;
                c[(c[x >> 2] | 0) + 4 >> 2] = u;
                c[w >> 2] = c[x >> 2];
                c[x >> 2] = u;
                c[v >> 2] = t;
                c[a >> 2] = u;
                i = g;
                return
            } else {
                c[a >> 2] = t;
                i = g;
                return
            }
        } else if ((e | 0) == 1 | (e | 0) == 0) {
            c[a >> 2] = c[b >> 2];
            i = g;
            return
        } else {
            t = e >>> 1;
            u = b;
            b = c[u >> 2] | 0;
            if ((t | 0) == 0) {
                y = b
            } else {
                v = t;
                x = b;
                while (1) {
                    w = c[x + 4 >> 2] | 0;
                    z = v + -1 | 0;
                    if ((z | 0) > 0) {
                        x = w;
                        v = z
                    } else {
                        y = w;
                        break
                    }
                }
            }
            c[o >> 2] = b;
            c[p >> 2] = y;
            b = m;
            v = o;
            c[b + 0 >> 2] = c[v + 0 >> 2];
            v = l;
            b = p;
            c[v + 0 >> 2] = c[b + 0 >> 2];
            ad(n, m, l, t, f);
            l = c[n >> 2] | 0;
            c[u >> 2] = l;
            c[r >> 2] = y;
            y = d;
            d = c[y >> 2] | 0;
            c[s >> 2] = d;
            n = e - t | 0;
            t = k;
            e = r;
            c[t + 0 >> 2] = c[e + 0 >> 2];
            e = j;
            t = s;
            c[e + 0 >> 2] = c[t + 0 >> 2];
            ad(q, k, j, n, f);
            f = c[q >> 2] | 0;
            A = +h[l + 8 >> 3];
            if (+h[f + 8 >> 3] < A) {
                q = c[f + 4 >> 2] | 0;
                a: do {
                    if ((q | 0) == (d | 0)) {
                        B = d
                    } else {
                        n = q;
                        while (1) {
                            if (!(+h[n + 8 >> 3] < A)) {
                                B = n;
                                break a
                            }
                            j = c[n + 4 >> 2] | 0;
                            if ((j | 0) == (d | 0)) {
                                B = d;
                                break
                            } else {
                                n = j
                            }
                        }
                    }
                } while (0);
                q = c[B >> 2] | 0;
                n = q + 4 | 0;
                j = f;
                c[(c[j >> 2] | 0) + 4 >> 2] = c[n >> 2];
                c[c[n >> 2] >> 2] = c[j >> 2];
                k = c[l + 4 >> 2] | 0;
                t = l;
                c[(c[t >> 2] | 0) + 4 >> 2] = f;
                c[j >> 2] = c[t >> 2];
                c[t >> 2] = q;
                c[n >> 2] = l;
                C = B;
                D = f;
                E = k
            } else {
                C = f;
                D = l;
                E = c[l + 4 >> 2] | 0
            }
            c[u >> 2] = E;
            b: do {
                if ((E | 0) != (C | 0)) {
                    l = C;
                    f = C;
                    k = d;
                    B = E;
                    while (1) {
                        n = f + 8 | 0;
                        if ((f | 0) == (k | 0)) {
                            break b
                        } else {
                            F = B
                        }
                        while (1) {
                            G = +h[F + 8 >> 3];
                            if (+h[n >> 3] < G) {
                                break
                            }
                            q = c[F + 4 >> 2] | 0;
                            c[u >> 2] = q;
                            if ((q | 0) == (l | 0)) {
                                break b
                            } else {
                                F = q
                            }
                        }
                        n = c[f + 4 >> 2] | 0;
                        c: do {
                            if ((n | 0) == (k | 0)) {
                                H = k
                            } else {
                                q = n;
                                while (1) {
                                    if (!(+h[q + 8 >> 3] < G)) {
                                        H = q;
                                        break c
                                    }
                                    t = c[q + 4 >> 2] | 0;
                                    if ((t | 0) == (k | 0)) {
                                        H = k;
                                        break
                                    } else {
                                        q = t
                                    }
                                }
                            }
                        } while (0);
                        n = c[H >> 2] | 0;
                        q = n + 4 | 0;
                        t = f;
                        c[(c[t >> 2] | 0) + 4 >> 2] = c[q >> 2];
                        c[c[q >> 2] >> 2] = c[t >> 2];
                        j = c[F + 4 >> 2] | 0;
                        e = (l | 0) == (f | 0) ? H : l;
                        s = F;
                        c[(c[s >> 2] | 0) + 4 >> 2] = f;
                        c[t >> 2] = c[s >> 2];
                        c[s >> 2] = n;
                        c[q >> 2] = F;
                        c[u >> 2] = j;
                        if ((j | 0) == (e | 0)) {
                            break b
                        }
                        l = e;
                        f = H;
                        k = c[y >> 2] | 0;
                        B = j
                    }
                }
            } while (0);
            c[a >> 2] = D;
            i = g;
            return
        }
    }

    function bd(a, b, d, e) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0.0,
            I = 0,
            J = 0;
        e = i;
        f = b;
        g = f;
        j = c[g >> 2] | 0;
        k = c[g + 4 >> 2] | 0;
        g = d;
        l = c[g >> 2] | 0;
        m = c[g + 4 >> 2] | 0;
        g = k;
        n = m;
        a: do {
            if ((g | 0) == (n | 0)) {
                o = l;
                p = m
            } else {
                q = j;
                r = c[q >> 2] | 0;
                s = j;
                t = k;
                u = g;
                v = q;
                while (1) {
                    q = u + 8 | 0;
                    if ((q - r | 0) == 4096) {
                        w = v + 4 | 0;
                        x = c[w >> 2] | 0;
                        y = x;
                        z = x;
                        A = w
                    } else {
                        y = r;
                        z = q;
                        A = v
                    } if ((z | 0) == (n | 0)) {
                        o = l;
                        p = m;
                        break a
                    }
                    if (+h[u >> 3] == +h[z >> 3]) {
                        o = s;
                        p = t;
                        break a
                    }
                    r = y;
                    s = A;
                    t = z;
                    u = z;
                    v = A
                }
            }
        } while (0);
        A = f;
        c[A >> 2] = o;
        c[A + 4 >> 2] = p;
        A = b + 4 | 0;
        z = p;
        p = c[d + 4 >> 2] | 0;
        d = o;
        do {
            if ((z | 0) != (p | 0)) {
                o = z + 8 | 0;
                y = c[d >> 2] | 0;
                if ((o - y | 0) == 4096) {
                    m = d + 4 | 0;
                    l = c[m >> 2] | 0;
                    B = l;
                    C = m;
                    D = l
                } else {
                    B = o;
                    C = d;
                    D = y
                }
                y = b;
                o = d;
                l = d;
                m = z;
                n = D;
                g = B;
                k = C;
                while (1) {
                    j = g + 8 | 0;
                    if ((j - n | 0) == 4096) {
                        v = k + 4 | 0;
                        u = c[v >> 2] | 0;
                        E = u;
                        F = u;
                        G = v
                    } else {
                        E = n;
                        F = j;
                        G = k
                    } if ((F | 0) == (p | 0)) {
                        break
                    }
                    H = +h[F >> 3];
                    if (+h[m >> 3] == H) {
                        n = E;
                        g = F;
                        k = G;
                        m = m;
                        l = l;
                        o = o;
                        continue
                    }
                    j = m + 8 | 0;
                    c[A >> 2] = j;
                    if ((j - (c[o >> 2] | 0) | 0) == 4096) {
                        v = o + 4 | 0;
                        c[y >> 2] = v;
                        u = c[v >> 2] | 0;
                        c[A >> 2] = u;
                        I = u;
                        J = v
                    } else {
                        I = j;
                        J = o
                    }
                    h[I >> 3] = H;
                    o = J;
                    l = J;
                    m = I;
                    n = c[G >> 2] | 0;
                    g = F;
                    k = G
                }
                k = m + 8 | 0;
                c[A >> 2] = k;
                if ((k - (c[l >> 2] | 0) | 0) != 4096) {
                    break
                }
                k = l + 4 | 0;
                c[y >> 2] = k;
                c[A >> 2] = c[k >> 2]
            }
        } while (0);
        A = f;
        f = c[A + 4 >> 2] | 0;
        G = a;
        c[G >> 2] = c[A >> 2];
        c[G + 4 >> 2] = f;
        i = e;
        return
    }

    function cd(a, b, d) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0,
            V = 0,
            W = 0,
            X = 0,
            Y = 0,
            Z = 0,
            _ = 0,
            $ = 0,
            aa = 0,
            ba = 0,
            ca = 0,
            da = 0,
            ea = 0,
            fa = 0,
            ga = 0,
            ha = 0,
            ia = 0,
            ja = 0,
            ka = 0,
            la = 0,
            ma = 0,
            na = 0,
            oa = 0,
            pa = 0,
            qa = 0,
            ra = 0,
            sa = 0,
            ta = 0,
            ua = 0,
            va = 0,
            wa = 0,
            xa = 0,
            ya = 0,
            za = 0,
            Aa = 0,
            Ba = 0,
            Ca = 0,
            Da = 0,
            Ea = 0,
            Fa = 0,
            Ga = 0,
            Ha = 0,
            Ia = 0,
            Ja = 0,
            Ka = 0,
            La = 0,
            Ma = 0,
            Na = 0,
            Oa = 0,
            Pa = 0,
            Qa = 0,
            Ra = 0,
            Sa = 0,
            Ta = 0,
            Ua = 0,
            Va = 0,
            Wa = 0,
            Xa = 0,
            Ya = 0,
            Za = 0,
            _a = 0,
            $a = 0.0,
            ab = 0.0,
            bb = 0.0,
            cb = 0.0,
            db = 0.0,
            eb = 0,
            fb = 0,
            gb = 0,
            hb = 0,
            ib = 0,
            jb = 0,
            kb = 0,
            lb = 0.0,
            mb = 0,
            nb = 0,
            ob = 0,
            pb = 0,
            qb = 0,
            rb = 0,
            sb = 0,
            tb = 0,
            ub = 0,
            vb = 0.0,
            wb = 0,
            xb = 0,
            yb = 0,
            zb = 0,
            Ab = 0,
            Bb = 0,
            Cb = 0,
            Db = 0.0,
            Eb = 0,
            Fb = 0,
            Gb = 0,
            Hb = 0,
            Ib = 0,
            Jb = 0,
            Kb = 0,
            Lb = 0,
            Mb = 0,
            Nb = 0,
            Ob = 0,
            Pb = 0,
            Qb = 0.0,
            Rb = 0,
            Sb = 0,
            Tb = 0,
            Ub = 0,
            Vb = 0,
            Wb = 0,
            Xb = 0,
            Yb = 0,
            Zb = 0,
            _b = 0,
            $b = 0,
            ac = 0,
            bc = 0,
            cc = 0,
            dc = 0,
            ec = 0,
            fc = 0,
            gc = 0,
            hc = 0,
            ic = 0,
            jc = 0,
            kc = 0,
            lc = 0,
            mc = 0,
            nc = 0.0,
            oc = 0,
            pc = 0,
            qc = 0,
            rc = 0,
            sc = 0.0,
            tc = 0,
            uc = 0,
            vc = 0,
            wc = 0,
            xc = 0,
            yc = 0,
            zc = 0,
            Ac = 0,
            Bc = 0,
            Cc = 0,
            Dc = 0,
            Ec = 0,
            Fc = 0,
            Gc = 0,
            Hc = 0,
            Ic = 0,
            Jc = 0,
            Kc = 0.0,
            Lc = 0,
            Mc = 0,
            Nc = 0,
            Oc = 0;
        e = i;
        i = i + 168 | 0;
        f = e;
        g = e + 8 | 0;
        j = e + 16 | 0;
        k = e + 24 | 0;
        l = e + 32 | 0;
        m = e + 40 | 0;
        n = e + 48 | 0;
        o = e + 56 | 0;
        p = e + 64 | 0;
        q = e + 72 | 0;
        r = e + 80 | 0;
        s = e + 88 | 0;
        t = e + 96 | 0;
        u = e + 104 | 0;
        v = e + 112 | 0;
        w = e + 120 | 0;
        x = e + 128 | 0;
        y = e + 136 | 0;
        z = e + 144 | 0;
        A = e + 152 | 0;
        B = e + 160 | 0;
        C = B;
        D = i;
        i = i + 8 | 0;
        E = D;
        F = i;
        i = i + 8 | 0;
        G = F;
        H = i;
        i = i + 8 | 0;
        I = H;
        J = i;
        i = i + 8 | 0;
        K = J;
        L = i;
        i = i + 8 | 0;
        M = L;
        N = i;
        i = i + 8 | 0;
        O = N;
        P = i;
        i = i + 8 | 0;
        Q = P;
        R = i;
        i = i + 8 | 0;
        S = R;
        T = i;
        i = i + 8 | 0;
        U = T;
        V = i;
        i = i + 8 | 0;
        W = V;
        X = i;
        i = i + 8 | 0;
        Y = X;
        Z = i;
        i = i + 8 | 0;
        _ = Z;
        $ = i;
        i = i + 8 | 0;
        aa = $;
        ba = i;
        i = i + 8 | 0;
        ca = ba;
        da = i;
        i = i + 8 | 0;
        ea = da;
        fa = i;
        i = i + 8 | 0;
        ga = fa;
        ha = i;
        i = i + 8 | 0;
        ia = ha;
        ja = i;
        i = i + 8 | 0;
        ka = ja;
        la = i;
        i = i + 8 | 0;
        ma = la;
        na = b + 4 | 0;
        oa = c[na >> 2] | 0;
        pa = c[a + 4 >> 2] | 0;
        if ((oa | 0) == (pa | 0)) {
            i = e;
            return
        }
        qa = b;
        ra = a;
        sa = b;
        b = W + 4 | 0;
        ta = V;
        ua = S + 4 | 0;
        va = R;
        wa = ca + 4 | 0;
        xa = ba;
        ya = ka + 4 | 0;
        za = ja;
        Aa = c[qa >> 2] | 0;
        Ba = oa;
        Ca = oa;
        Da = oa;
        Ea = pa;
        Fa = oa;
        Ga = c[a >> 2] | 0;
        a = pa;
        pa = oa;
        a: while (1) {
            oa = pa;
            Ha = a;
            Ia = (oa - (c[Aa >> 2] | 0) >> 3) + (Aa - Ga << 7) - (Ha - (c[Ga >> 2] | 0) >> 3) | 0;
            switch (Ia | 0) {
            case 2:
                {
                    Ja = 4;
                    break a;
                    break
                };
            case 3:
                {
                    Ja = 8;
                    break a;
                    break
                };
            case 4:
                {
                    Ja = 21;
                    break a;
                    break
                };
            case 5:
                {
                    Ja = 41;
                    break a;
                    break
                };
            case 1:
            case 0:
                {
                    Ja = 155;
                    break a;
                    break
                };
            default:
                {}
            }
            Ka = ra;
            La = c[Ka >> 2] | 0;
            Ma = c[Ka + 4 >> 2] | 0;
            if ((Ia | 0) < 31) {
                Ja = 54;
                break
            }
            Ka = La;
            Na = Ma;
            Oa = sa;
            Pa = c[Oa >> 2] | 0;
            Qa = c[Oa + 4 >> 2] | 0;
            if ((Qa | 0) == (c[Pa >> 2] | 0)) {
                Oa = Pa + -4 | 0;
                Ra = Oa;
                Sa = (c[Oa >> 2] | 0) + 4096 | 0
            } else {
                Ra = Pa;
                Sa = Qa
            }
            Qa = Sa + -8 | 0;
            Oa = (Ia | 0) > 999;
            do {
                if ((Ia + 1 | 0) >>> 0 < 3) {
                    Ta = Na;
                    Ua = Ka
                } else {
                    Va = (Ma - (c[Ka >> 2] | 0) >> 3) + ((Ia | 0) / 2 | 0) | 0;
                    if ((Va | 0) > 0) {
                        Wa = Ka + (((Va | 0) / 512 | 0) << 2) | 0;
                        Ta = (c[Wa >> 2] | 0) + (((Va | 0) % 512 | 0) << 3) | 0;
                        Ua = Wa;
                        break
                    } else {
                        Wa = 511 - Va | 0;
                        Va = Ka + (((Wa | 0) / -512 | 0) << 2) | 0;
                        Ta = (c[Va >> 2] | 0) + (511 - ((Wa | 0) % 512 | 0) << 3) | 0;
                        Ua = Va;
                        break
                    }
                }
            } while (0);
            do {
                if (Oa) {
                    Va = (Ia | 0) / 4 | 0;
                    Wa = P;
                    c[Wa >> 2] = La;
                    c[Wa + 4 >> 2] = Ma;
                    Wa = R;
                    c[Wa >> 2] = La;
                    c[Wa + 4 >> 2] = Ma;
                    Wa = (Ia + 3 | 0) >>> 0 < 7;
                    do {
                        if (!Wa) {
                            Xa = (Ma - (c[Ka >> 2] | 0) >> 3) + Va | 0;
                            if ((Xa | 0) > 0) {
                                Ya = Ka + (((Xa | 0) / 512 | 0) << 2) | 0;
                                c[va >> 2] = Ya;
                                c[ua >> 2] = (c[Ya >> 2] | 0) + (((Xa | 0) % 512 | 0) << 3);
                                break
                            } else {
                                Ya = 511 - Xa | 0;
                                Xa = Ka + (((Ya | 0) / -512 | 0) << 2) | 0;
                                c[va >> 2] = Xa;
                                c[ua >> 2] = (c[Xa >> 2] | 0) + (511 - ((Ya | 0) % 512 | 0) << 3);
                                break
                            }
                        }
                    } while (0);
                    Ya = Ua;
                    Xa = Ta;
                    Za = T;
                    c[Za >> 2] = Ya;
                    c[Za + 4 >> 2] = Xa;
                    Za = V;
                    c[Za >> 2] = Ya;
                    c[Za + 4 >> 2] = Xa;
                    do {
                        if (!Wa) {
                            Za = (Xa - (c[Ua >> 2] | 0) >> 3) + Va | 0;
                            if ((Za | 0) > 0) {
                                Ya = Ua + (((Za | 0) / 512 | 0) << 2) | 0;
                                c[ta >> 2] = Ya;
                                c[b >> 2] = (c[Ya >> 2] | 0) + (((Za | 0) % 512 | 0) << 3);
                                break
                            } else {
                                Ya = 511 - Za | 0;
                                Za = Ua + (((Ya | 0) / -512 | 0) << 2) | 0;
                                c[ta >> 2] = Za;
                                c[b >> 2] = (c[Za >> 2] | 0) + (511 - ((Ya | 0) % 512 | 0) << 3);
                                break
                            }
                        }
                    } while (0);
                    Va = X;
                    c[Va >> 2] = Ra;
                    c[Va + 4 >> 2] = Qa;
                    Va = t;
                    Xa = Q;
                    c[Va + 0 >> 2] = c[Xa + 0 >> 2];
                    c[Va + 4 >> 2] = c[Xa + 4 >> 2];
                    Xa = s;
                    Va = S;
                    c[Xa + 0 >> 2] = c[Va + 0 >> 2];
                    c[Xa + 4 >> 2] = c[Va + 4 >> 2];
                    Va = r;
                    Xa = U;
                    c[Va + 0 >> 2] = c[Xa + 0 >> 2];
                    c[Va + 4 >> 2] = c[Xa + 4 >> 2];
                    Xa = q;
                    Va = W;
                    c[Xa + 0 >> 2] = c[Va + 0 >> 2];
                    c[Xa + 4 >> 2] = c[Va + 4 >> 2];
                    Va = p;
                    Xa = Y;
                    c[Va + 0 >> 2] = c[Xa + 0 >> 2];
                    c[Va + 4 >> 2] = c[Xa + 4 >> 2];
                    Xa = dd(t, s, r, q, p, 0) | 0;
                    _a = Xa
                } else {
                    $a = +h[Ta >> 3];
                    ab = +h[Na >> 3];
                    bb = +h[Qa >> 3];
                    Xa = bb < $a;
                    if (!($a < ab)) {
                        if (!Xa) {
                            _a = 0;
                            break
                        }
                        h[Ta >> 3] = bb;
                        h[Qa >> 3] = $a;
                        cb = +h[Ta >> 3];
                        db = +h[Na >> 3];
                        if (!(cb < db)) {
                            _a = 1;
                            break
                        }
                        h[Na >> 3] = cb;
                        h[Ta >> 3] = db;
                        _a = 2;
                        break
                    }
                    if (Xa) {
                        h[Na >> 3] = bb;
                        h[Qa >> 3] = ab;
                        _a = 1;
                        break
                    }
                    h[Na >> 3] = $a;
                    h[Ta >> 3] = ab;
                    $a = +h[Qa >> 3];
                    if (!($a < ab)) {
                        _a = 1;
                        break
                    }
                    h[Ta >> 3] = $a;
                    h[Qa >> 3] = ab;
                    _a = 2
                }
            } while (0);
            Na = ra;
            Ka = c[Na >> 2] | 0;
            Ia = c[Na + 4 >> 2] | 0;
            ab = +h[Ia >> 3];
            $a = +h[Ta >> 3];
            do {
                if (ab < $a) {
                    eb = Qa;
                    fb = Ra;
                    gb = _a;
                    Ja = 112
                } else {
                    Na = c[Ra >> 2] | 0;
                    Oa = Qa;
                    Xa = Ra;
                    while (1) {
                        if ((Oa | 0) == (Na | 0)) {
                            Va = Xa + -4 | 0;
                            Wa = c[Va >> 2] | 0;
                            hb = Wa;
                            ib = Va;
                            jb = Wa + 4096 | 0
                        } else {
                            hb = Na;
                            ib = Xa;
                            jb = Oa
                        }
                        kb = jb + -8 | 0;
                        if ((Ia | 0) == (kb | 0)) {
                            break
                        }
                        lb = +h[kb >> 3];
                        if (lb < $a) {
                            Ja = 111;
                            break
                        } else {
                            Na = hb;
                            Oa = kb;
                            Xa = ib
                        }
                    }
                    if ((Ja | 0) == 111) {
                        Ja = 0;
                        h[Ia >> 3] = lb;
                        h[kb >> 3] = ab;
                        eb = kb;
                        fb = ib;
                        gb = _a + 1 | 0;
                        Ja = 112;
                        break
                    }
                    Xa = Ia + 8 | 0;
                    Oa = c[Ka >> 2] | 0;
                    if ((Xa - Oa | 0) == 4096) {
                        Na = Ka + 4 | 0;
                        Wa = c[Na >> 2] | 0;
                        mb = Wa;
                        nb = Wa;
                        ob = Na
                    } else {
                        mb = Oa;
                        nb = Xa;
                        ob = Ka
                    }
                    Xa = sa;
                    Oa = c[Xa >> 2] | 0;
                    Na = c[Xa + 4 >> 2] | 0;
                    Xa = c[Oa >> 2] | 0;
                    if ((Na | 0) == (Xa | 0)) {
                        Wa = Oa + -4 | 0;
                        Va = c[Wa >> 2] | 0;
                        pb = Va;
                        qb = Wa;
                        rb = Va + 4096 | 0
                    } else {
                        pb = Xa;
                        qb = Oa;
                        rb = Na
                    }
                    Na = rb + -8 | 0;
                    bb = +h[a >> 3];
                    db = +h[Na >> 3];
                    do {
                        if (bb < db) {
                            sb = nb;
                            tb = ob
                        } else {
                            Xa = nb;
                            Va = ob;
                            Wa = mb;
                            b: while (1) {
                                ub = Xa;
                                while (1) {
                                    if ((ub | 0) == (Na | 0)) {
                                        Ja = 155;
                                        break a
                                    }
                                    vb = +h[ub >> 3];
                                    if (bb < vb) {
                                        break b
                                    }
                                    Ya = ub + 8 | 0;
                                    if ((Ya - Wa | 0) == 4096) {
                                        break
                                    } else {
                                        ub = Ya
                                    }
                                }
                                Ya = Va + 4 | 0;
                                Za = c[Ya >> 2] | 0;
                                Xa = Za;
                                Va = Ya;
                                Wa = Za
                            }
                            h[ub >> 3] = db;
                            h[Na >> 3] = vb;
                            Xa = ub + 8 | 0;
                            if ((Xa - Wa | 0) != 4096) {
                                sb = Xa;
                                tb = Va;
                                break
                            }
                            Xa = Va + 4 | 0;
                            sb = c[Xa >> 2] | 0;
                            tb = Xa
                        }
                    } while (0);
                    if ((sb | 0) == (Na | 0)) {
                        Ja = 155;
                        break a
                    } else {
                        wb = sb;
                        xb = tb;
                        yb = Na;
                        zb = qb;
                        Ab = pb
                    }
                    c: while (1) {
                        Xa = wb;
                        Za = yb;
                        Ya = zb;
                        Bb = Ab;
                        d: while (1) {
                            db = +h[a >> 3];
                            Cb = Xa;
                            while (1) {
                                Db = +h[Cb >> 3];
                                if (db < Db) {
                                    Eb = Bb;
                                    Fb = Za;
                                    Gb = Ya;
                                    break
                                }
                                Hb = Cb + 8 | 0;
                                if ((Hb - (c[xb >> 2] | 0) | 0) == 4096) {
                                    Ib = Za;
                                    Jb = Ya;
                                    Kb = Bb;
                                    break d
                                } else {
                                    Cb = Hb
                                }
                            }
                            while (1) {
                                if ((Fb | 0) == (Eb | 0)) {
                                    Hb = Gb + -4 | 0;
                                    Lb = c[Hb >> 2] | 0;
                                    Mb = Lb;
                                    Nb = Hb;
                                    Ob = Lb + 4096 | 0
                                } else {
                                    Mb = Eb;
                                    Nb = Gb;
                                    Ob = Fb
                                }
                                Pb = Ob + -8 | 0;
                                Qb = +h[Pb >> 3];
                                if (db < Qb) {
                                    Eb = Mb;
                                    Fb = Pb;
                                    Gb = Nb
                                } else {
                                    break
                                }
                            }
                            if (!(xb >>> 0 < Nb >>> 0)) {
                                if ((xb | 0) != (Nb | 0) | Cb >>> 0 >= Pb >>> 0) {
                                    break c
                                }
                            }
                            h[Cb >> 3] = Qb;
                            h[Pb >> 3] = Db;
                            Lb = Cb + 8 | 0;
                            if ((Lb - (c[xb >> 2] | 0) | 0) == 4096) {
                                Ib = Pb;
                                Jb = Nb;
                                Kb = Mb;
                                break
                            } else {
                                Xa = Lb;
                                Za = Pb;
                                Ya = Nb;
                                Bb = Mb
                            }
                        }
                        Bb = xb + 4 | 0;
                        wb = c[Bb >> 2] | 0;
                        xb = Bb;
                        yb = Ib;
                        zb = Jb;
                        Ab = Kb
                    }
                    Na = ra;
                    c[Na >> 2] = xb;
                    c[Na + 4 >> 2] = Cb;
                    Rb = Oa;
                    Sb = Ba;
                    Tb = Ca;
                    Ub = Da;
                    Vb = Cb;
                    Wb = Fa;
                    Xb = Cb;
                    Yb = pa;
                    Zb = xb
                }
            } while (0);
            e: do {
                if ((Ja | 0) == 112) {
                    Ja = 0;
                    Qa = Ia + 8 | 0;
                    Na = c[Ka >> 2] | 0;
                    if ((Qa - Na | 0) == 4096) {
                        Bb = Ka + 4 | 0;
                        Ya = c[Bb >> 2] | 0;
                        _b = Ya;
                        $b = Ya;
                        ac = Bb
                    } else {
                        _b = Na;
                        $b = Qa;
                        ac = Ka
                    } if (ac >>> 0 < fb >>> 0) {
                        bc = Ta;
                        cc = $b;
                        dc = ac;
                        ec = eb;
                        fc = fb;
                        gc = _b;
                        hc = gb;
                        Ja = 116
                    } else {
                        if ((ac | 0) == (fb | 0) & $b >>> 0 < eb >>> 0) {
                            bc = Ta;
                            cc = $b;
                            dc = ac;
                            ec = eb;
                            fc = fb;
                            gc = _b;
                            hc = gb;
                            Ja = 116
                        } else {
                            ic = Ta;
                            jc = $b;
                            kc = ac;
                            lc = gb
                        }
                    }
                    f: do {
                        if ((Ja | 0) == 116) {
                            while (1) {
                                Ja = 0;
                                ab = +h[bc >> 3];
                                Qa = cc;
                                Na = dc;
                                Bb = gc;
                                g: while (1) {
                                    mc = Qa;
                                    while (1) {
                                        nc = +h[mc >> 3];
                                        if (!(nc < ab)) {
                                            break g
                                        }
                                        Ya = mc + 8 | 0;
                                        if ((Ya - Bb | 0) == 4096) {
                                            break
                                        } else {
                                            mc = Ya
                                        }
                                    }
                                    Ya = Na + 4 | 0;
                                    Za = c[Ya >> 2] | 0;
                                    Qa = Za;
                                    Na = Ya;
                                    Bb = Za
                                }
                                Qa = c[fc >> 2] | 0;
                                Za = ec;
                                Ya = fc;
                                while (1) {
                                    if ((Za | 0) == (Qa | 0)) {
                                        Xa = Ya + -4 | 0;
                                        Va = c[Xa >> 2] | 0;
                                        oc = Va;
                                        pc = Xa;
                                        qc = Va + 4096 | 0
                                    } else {
                                        oc = Qa;
                                        pc = Ya;
                                        qc = Za
                                    }
                                    rc = qc + -8 | 0;
                                    sc = +h[rc >> 3];
                                    if (sc < ab) {
                                        break
                                    } else {
                                        Qa = oc;
                                        Za = rc;
                                        Ya = pc
                                    }
                                }
                                if (pc >>> 0 < Na >>> 0) {
                                    ic = bc;
                                    jc = mc;
                                    kc = Na;
                                    lc = hc;
                                    break f
                                }
                                if ((pc | 0) == (Na | 0) & rc >>> 0 < mc >>> 0) {
                                    ic = bc;
                                    jc = mc;
                                    kc = Na;
                                    lc = hc;
                                    break f
                                }
                                h[mc >> 3] = sc;
                                h[rc >> 3] = nc;
                                Ya = hc + 1 | 0;
                                Za = (bc | 0) == (mc | 0) ? rc : bc;
                                Qa = mc + 8 | 0;
                                if ((Qa - Bb | 0) != 4096) {
                                    bc = Za;
                                    cc = Qa;
                                    dc = Na;
                                    ec = rc;
                                    fc = pc;
                                    gc = Bb;
                                    hc = Ya;
                                    Ja = 116;
                                    continue
                                }
                                Qa = Na + 4 | 0;
                                Va = c[Qa >> 2] | 0;
                                bc = Za;
                                cc = Va;
                                dc = Qa;
                                ec = rc;
                                fc = pc;
                                gc = Va;
                                hc = Ya;
                                Ja = 116
                            }
                        }
                    } while (0);
                    do {
                        if ((jc | 0) == (ic | 0)) {
                            tc = lc
                        } else {
                            ab = +h[ic >> 3];
                            $a = +h[jc >> 3];
                            if (!(ab < $a)) {
                                tc = lc;
                                break
                            }
                            h[jc >> 3] = ab;
                            h[ic >> 3] = $a;
                            tc = lc + 1 | 0
                        }
                    } while (0);
                    do {
                        if ((tc | 0) == 0) {
                            Oa = ra;
                            Ya = c[Oa >> 2] | 0;
                            Va = c[Oa + 4 >> 2] | 0;
                            Oa = Z;
                            c[Oa >> 2] = Ya;
                            c[Oa + 4 >> 2] = Va;
                            Va = kc;
                            Oa = jc;
                            Qa = $;
                            c[Qa >> 2] = Va;
                            c[Qa + 4 >> 2] = Oa;
                            Qa = o;
                            Za = _;
                            c[Qa + 0 >> 2] = c[Za + 0 >> 2];
                            c[Qa + 4 >> 2] = c[Za + 4 >> 2];
                            Za = n;
                            Qa = aa;
                            c[Za + 0 >> 2] = c[Qa + 0 >> 2];
                            c[Za + 4 >> 2] = c[Qa + 4 >> 2];
                            Qa = fd(o, n, 0) | 0;
                            Za = ba;
                            c[Za >> 2] = Va;
                            c[Za + 4 >> 2] = Oa;
                            Za = Oa - (c[kc >> 2] | 0) | 0;
                            Xa = Za >> 3;
                            Wa = Xa + 1 | 0;
                            Lb = Ya;
                            if ((Za | 0) > -8) {
                                Za = kc + (((Wa | 0) / 512 | 0) << 2) | 0;
                                c[xa >> 2] = Za;
                                uc = (c[Za >> 2] | 0) + (((Wa | 0) % 512 | 0) << 3) | 0
                            } else {
                                Wa = 510 - Xa | 0;
                                Xa = kc + (((Wa | 0) / -512 | 0) << 2) | 0;
                                c[xa >> 2] = Xa;
                                uc = (c[Xa >> 2] | 0) + (511 - ((Wa | 0) % 512 | 0) << 3) | 0
                            }
                            c[wa >> 2] = uc;
                            Wa = sa;
                            Xa = c[Wa >> 2] | 0;
                            Za = c[Wa + 4 >> 2] | 0;
                            Wa = da;
                            c[Wa >> 2] = Xa;
                            c[Wa + 4 >> 2] = Za;
                            Za = m;
                            Wa = ca;
                            c[Za + 0 >> 2] = c[Wa + 0 >> 2];
                            c[Za + 4 >> 2] = c[Wa + 4 >> 2];
                            Wa = l;
                            Za = ea;
                            c[Wa + 0 >> 2] = c[Za + 0 >> 2];
                            c[Wa + 4 >> 2] = c[Za + 4 >> 2];
                            Za = fd(m, l, 0) | 0;
                            Wa = Xa;
                            if (Za) {
                                if (Qa) {
                                    Ja = 155;
                                    break a
                                }
                                Za = sa;
                                c[Za >> 2] = Va;
                                c[Za + 4 >> 2] = Oa;
                                Rb = kc;
                                Sb = jc;
                                Tb = jc;
                                Ub = jc;
                                Vb = Ea;
                                Wb = jc;
                                Xb = a;
                                Yb = jc;
                                Zb = Lb;
                                break e
                            }
                            if (!Qa) {
                                vc = Wa;
                                wc = Lb;
                                break
                            }
                            Lb = jc + 8 | 0;
                            if ((Lb - (c[kc >> 2] | 0) | 0) == 4096) {
                                Qa = kc + 4 | 0;
                                xc = c[Qa >> 2] | 0;
                                yc = Qa
                            } else {
                                xc = Lb;
                                yc = kc
                            }
                            Lb = ra;
                            c[Lb >> 2] = yc;
                            c[Lb + 4 >> 2] = xc;
                            Rb = Wa;
                            Sb = Ba;
                            Tb = Ca;
                            Ub = Da;
                            Vb = xc;
                            Wb = Fa;
                            Xb = xc;
                            Yb = pa;
                            Zb = yc;
                            break e
                        } else {
                            vc = Pa;
                            wc = Ka
                        }
                    } while (0);
                    if ((jc | 0) == (a | 0)) {
                        zc = 0
                    } else {
                        zc = (jc - (c[kc >> 2] | 0) >> 3) + (kc - wc << 7) - (Ha - (c[wc >> 2] | 0) >> 3) | 0
                    } if ((pa | 0) == (jc | 0)) {
                        Ac = 0
                    } else {
                        Ac = (oa - (c[vc >> 2] | 0) >> 3) + (vc - kc << 7) - (jc - (c[kc >> 2] | 0) >> 3) | 0
                    } if ((zc | 0) < (Ac | 0)) {
                        Wa = ra;
                        Lb = c[Wa + 4 >> 2] | 0;
                        Qa = fa;
                        c[Qa >> 2] = c[Wa >> 2];
                        c[Qa + 4 >> 2] = Lb;
                        Lb = ha;
                        c[Lb >> 2] = kc;
                        c[Lb + 4 >> 2] = jc;
                        Lb = k;
                        Qa = ga;
                        c[Lb + 0 >> 2] = c[Qa + 0 >> 2];
                        c[Lb + 4 >> 2] = c[Qa + 4 >> 2];
                        Qa = j;
                        Lb = ia;
                        c[Qa + 0 >> 2] = c[Lb + 0 >> 2];
                        c[Qa + 4 >> 2] = c[Lb + 4 >> 2];
                        cd(k, j, d);
                        Lb = jc + 8 | 0;
                        if ((Lb - (c[kc >> 2] | 0) | 0) == 4096) {
                            Qa = kc + 4 | 0;
                            Bc = c[Qa >> 2] | 0;
                            Cc = Qa
                        } else {
                            Bc = Lb;
                            Cc = kc
                        }
                        Lb = ra;
                        c[Lb >> 2] = Cc;
                        c[Lb + 4 >> 2] = Bc;
                        Rb = vc;
                        Sb = Ba;
                        Tb = Ca;
                        Ub = Da;
                        Vb = Bc;
                        Wb = Fa;
                        Xb = Bc;
                        Yb = pa;
                        Zb = Cc;
                        break
                    }
                    Lb = kc;
                    Qa = jc;
                    Wa = ja;
                    c[Wa >> 2] = Lb;
                    c[Wa + 4 >> 2] = Qa;
                    Wa = Qa - (c[kc >> 2] | 0) | 0;
                    Oa = Wa >> 3;
                    Za = Oa + 1 | 0;
                    if ((Wa | 0) > -8) {
                        Wa = kc + (((Za | 0) / 512 | 0) << 2) | 0;
                        c[za >> 2] = Wa;
                        Dc = (c[Wa >> 2] | 0) + (((Za | 0) % 512 | 0) << 3) | 0
                    } else {
                        Za = 510 - Oa | 0;
                        Oa = kc + (((Za | 0) / -512 | 0) << 2) | 0;
                        c[za >> 2] = Oa;
                        Dc = (c[Oa >> 2] | 0) + (511 - ((Za | 0) % 512 | 0) << 3) | 0
                    }
                    c[ya >> 2] = Dc;
                    Za = sa;
                    Oa = c[Za + 4 >> 2] | 0;
                    Wa = la;
                    c[Wa >> 2] = c[Za >> 2];
                    c[Wa + 4 >> 2] = Oa;
                    Oa = g;
                    Wa = ka;
                    c[Oa + 0 >> 2] = c[Wa + 0 >> 2];
                    c[Oa + 4 >> 2] = c[Wa + 4 >> 2];
                    Wa = f;
                    Oa = ma;
                    c[Wa + 0 >> 2] = c[Oa + 0 >> 2];
                    c[Wa + 4 >> 2] = c[Oa + 4 >> 2];
                    cd(g, f, d);
                    Oa = sa;
                    c[Oa >> 2] = Lb;
                    c[Oa + 4 >> 2] = Qa;
                    Rb = kc;
                    Sb = jc;
                    Tb = jc;
                    Ub = jc;
                    Vb = Ea;
                    Wb = jc;
                    Xb = a;
                    Yb = jc;
                    Zb = wc
                }
            } while (0);
            if ((Yb | 0) == (Xb | 0)) {
                Ja = 155;
                break
            } else {
                Aa = Rb;
                Ba = Sb;
                Ca = Tb;
                Da = Ub;
                Ea = Vb;
                Fa = Wb;
                Ga = Zb;
                a = Xb;
                pa = Yb
            }
        }
        if ((Ja | 0) == 4) {
            if ((Fa | 0) == (c[Aa >> 2] | 0)) {
                Yb = Aa + -4 | 0;
                c[qa >> 2] = Yb;
                pa = (c[Yb >> 2] | 0) + 4096 | 0;
                c[na >> 2] = pa;
                Ec = pa
            } else {
                Ec = Fa
            }
            Fa = Ec + -8 | 0;
            c[na >> 2] = Fa;
            nc = +h[Fa >> 3];
            sc = +h[Ea >> 3];
            if (!(nc < sc)) {
                i = e;
                return
            }
            h[Ea >> 3] = nc;
            h[Fa >> 3] = sc;
            i = e;
            return
        } else if ((Ja | 0) == 8) {
            Fa = ra;
            Ea = c[Fa + 4 >> 2] | 0;
            Ec = c[Fa >> 2] | 0;
            Fa = Ea - (c[Ec >> 2] | 0) | 0;
            pa = Fa >> 3;
            Yb = pa + 1 | 0;
            if ((Fa | 0) > -8) {
                Fc = (c[Ec + (((Yb | 0) / 512 | 0) << 2) >> 2] | 0) + (((Yb | 0) % 512 | 0) << 3) | 0
            } else {
                Yb = 510 - pa | 0;
                Fc = (c[Ec + (((Yb | 0) / -512 | 0) << 2) >> 2] | 0) + (511 - ((Yb | 0) % 512 | 0) << 3) | 0
            } if ((Da | 0) == (c[Aa >> 2] | 0)) {
                Yb = Aa + -4 | 0;
                c[qa >> 2] = Yb;
                Ec = (c[Yb >> 2] | 0) + 4096 | 0;
                c[na >> 2] = Ec;
                Gc = Ec
            } else {
                Gc = Da
            }
            c[na >> 2] = Gc + -8;
            Gc = Ea;
            Ea = c[sa + 4 >> 2] | 0;
            sc = +h[Fc >> 3];
            nc = +h[Gc >> 3];
            Db = +h[Ea >> 3];
            Da = Db < sc;
            if (!(sc < nc)) {
                if (!Da) {
                    i = e;
                    return
                }
                h[Fc >> 3] = Db;
                h[Ea >> 3] = sc;
                Qb = +h[Fc >> 3];
                vb = +h[Gc >> 3];
                if (!(Qb < vb)) {
                    i = e;
                    return
                }
                h[Gc >> 3] = Qb;
                h[Fc >> 3] = vb;
                i = e;
                return
            }
            if (Da) {
                h[Gc >> 3] = Db;
                h[Ea >> 3] = nc;
                i = e;
                return
            }
            h[Gc >> 3] = sc;
            h[Fc >> 3] = nc;
            sc = +h[Ea >> 3];
            if (!(sc < nc)) {
                i = e;
                return
            }
            h[Fc >> 3] = sc;
            h[Ea >> 3] = nc;
            i = e;
            return
        } else if ((Ja | 0) == 21) {
            Ea = ra;
            Fc = c[Ea + 4 >> 2] | 0;
            Gc = c[Ea >> 2] | 0;
            Ea = Fc - (c[Gc >> 2] | 0) | 0;
            Da = Ea >> 3;
            Ec = Da + 1 | 0;
            if ((Ea | 0) > -8) {
                Hc = (c[Gc + (((Ec | 0) / 512 | 0) << 2) >> 2] | 0) + (((Ec | 0) % 512 | 0) << 3) | 0
            } else {
                Ec = 510 - Da | 0;
                Hc = (c[Gc + (((Ec | 0) / -512 | 0) << 2) >> 2] | 0) + (511 - ((Ec | 0) % 512 | 0) << 3) | 0
            }
            Ec = Da + 2 | 0;
            if ((Ec | 0) > 0) {
                Ic = (c[Gc + (((Ec | 0) / 512 | 0) << 2) >> 2] | 0) + (((Ec | 0) % 512 | 0) << 3) | 0
            } else {
                Ec = 509 - Da | 0;
                Ic = (c[Gc + (((Ec | 0) / -512 | 0) << 2) >> 2] | 0) + (511 - ((Ec | 0) % 512 | 0) << 3) | 0
            } if ((Ca | 0) == (c[Aa >> 2] | 0)) {
                Ec = Aa + -4 | 0;
                c[qa >> 2] = Ec;
                Gc = (c[Ec >> 2] | 0) + 4096 | 0;
                c[na >> 2] = Gc;
                Jc = Gc
            } else {
                Jc = Ca
            }
            c[na >> 2] = Jc + -8;
            Jc = Fc;
            Fc = c[sa + 4 >> 2] | 0;
            nc = +h[Hc >> 3];
            sc = +h[Jc >> 3];
            Db = +h[Ic >> 3];
            Ca = Db < nc;
            do {
                if (nc < sc) {
                    if (Ca) {
                        h[Jc >> 3] = Db;
                        h[Ic >> 3] = sc;
                        Kc = sc;
                        break
                    }
                    h[Jc >> 3] = nc;
                    h[Hc >> 3] = sc;
                    vb = +h[Ic >> 3];
                    if (!(vb < sc)) {
                        Kc = vb;
                        break
                    }
                    h[Hc >> 3] = vb;
                    h[Ic >> 3] = sc;
                    Kc = sc
                } else {
                    if (!Ca) {
                        Kc = Db;
                        break
                    }
                    h[Hc >> 3] = Db;
                    h[Ic >> 3] = nc;
                    vb = +h[Hc >> 3];
                    Qb = +h[Jc >> 3];
                    if (!(vb < Qb)) {
                        Kc = nc;
                        break
                    }
                    h[Jc >> 3] = vb;
                    h[Hc >> 3] = Qb;
                    Kc = +h[Ic >> 3]
                }
            } while (0);
            nc = +h[Fc >> 3];
            if (!(nc < Kc)) {
                i = e;
                return
            }
            h[Ic >> 3] = nc;
            h[Fc >> 3] = Kc;
            Kc = +h[Ic >> 3];
            nc = +h[Hc >> 3];
            if (!(Kc < nc)) {
                i = e;
                return
            }
            h[Hc >> 3] = Kc;
            h[Ic >> 3] = nc;
            nc = +h[Hc >> 3];
            Kc = +h[Jc >> 3];
            if (!(nc < Kc)) {
                i = e;
                return
            }
            h[Jc >> 3] = nc;
            h[Hc >> 3] = Kc;
            i = e;
            return
        } else if ((Ja | 0) == 41) {
            Hc = ra;
            ra = c[Hc >> 2] | 0;
            Jc = c[Hc + 4 >> 2] | 0;
            Hc = B;
            c[Hc >> 2] = ra;
            c[Hc + 4 >> 2] = Jc;
            Hc = D;
            c[Hc >> 2] = ra;
            c[Hc + 4 >> 2] = Jc;
            Hc = ra;
            B = D;
            D = Jc - (c[Hc >> 2] | 0) | 0;
            Ic = D >> 3;
            Fc = Ic + 1 | 0;
            if ((D | 0) > -8) {
                D = Hc + (((Fc | 0) / 512 | 0) << 2) | 0;
                c[B >> 2] = D;
                Lc = (c[D >> 2] | 0) + (((Fc | 0) % 512 | 0) << 3) | 0
            } else {
                Fc = 510 - Ic | 0;
                Ic = Hc + (((Fc | 0) / -512 | 0) << 2) | 0;
                c[B >> 2] = Ic;
                Lc = (c[Ic >> 2] | 0) + (511 - ((Fc | 0) % 512 | 0) << 3) | 0
            }
            c[E + 4 >> 2] = Lc;
            Lc = F;
            c[Lc >> 2] = ra;
            c[Lc + 4 >> 2] = Jc;
            Lc = F;
            F = Jc - (c[Hc >> 2] | 0) >> 3;
            Fc = F + 2 | 0;
            if ((Fc | 0) > 0) {
                Ic = Hc + (((Fc | 0) / 512 | 0) << 2) | 0;
                c[Lc >> 2] = Ic;
                Mc = (c[Ic >> 2] | 0) + (((Fc | 0) % 512 | 0) << 3) | 0
            } else {
                Fc = 509 - F | 0;
                F = Hc + (((Fc | 0) / -512 | 0) << 2) | 0;
                c[Lc >> 2] = F;
                Mc = (c[F >> 2] | 0) + (511 - ((Fc | 0) % 512 | 0) << 3) | 0
            }
            c[G + 4 >> 2] = Mc;
            Mc = H;
            c[Mc >> 2] = ra;
            c[Mc + 4 >> 2] = Jc;
            Mc = H;
            H = Jc - (c[Hc >> 2] | 0) >> 3;
            Jc = H + 3 | 0;
            if ((Jc | 0) > 0) {
                ra = Hc + (((Jc | 0) / 512 | 0) << 2) | 0;
                c[Mc >> 2] = ra;
                Nc = (c[ra >> 2] | 0) + (((Jc | 0) % 512 | 0) << 3) | 0
            } else {
                Jc = 508 - H | 0;
                H = Hc + (((Jc | 0) / -512 | 0) << 2) | 0;
                c[Mc >> 2] = H;
                Nc = (c[H >> 2] | 0) + (511 - ((Jc | 0) % 512 | 0) << 3) | 0
            }
            c[I + 4 >> 2] = Nc;
            if ((Ba | 0) == (c[Aa >> 2] | 0)) {
                Nc = Aa + -4 | 0;
                c[qa >> 2] = Nc;
                qa = (c[Nc >> 2] | 0) + 4096 | 0;
                c[na >> 2] = qa;
                Oc = qa
            } else {
                Oc = Ba
            }
            c[na >> 2] = Oc + -8;
            Oc = sa;
            na = c[Oc + 4 >> 2] | 0;
            Ba = J;
            c[Ba >> 2] = c[Oc >> 2];
            c[Ba + 4 >> 2] = na;
            na = A;
            Ba = C;
            c[na + 0 >> 2] = c[Ba + 0 >> 2];
            c[na + 4 >> 2] = c[Ba + 4 >> 2];
            Ba = z;
            na = E;
            c[Ba + 0 >> 2] = c[na + 0 >> 2];
            c[Ba + 4 >> 2] = c[na + 4 >> 2];
            na = y;
            Ba = G;
            c[na + 0 >> 2] = c[Ba + 0 >> 2];
            c[na + 4 >> 2] = c[Ba + 4 >> 2];
            Ba = x;
            na = I;
            c[Ba + 0 >> 2] = c[na + 0 >> 2];
            c[Ba + 4 >> 2] = c[na + 4 >> 2];
            na = w;
            Ba = K;
            c[na + 0 >> 2] = c[Ba + 0 >> 2];
            c[na + 4 >> 2] = c[Ba + 4 >> 2];
            dd(A, z, y, x, w, 0) | 0;
            i = e;
            return
        } else if ((Ja | 0) == 54) {
            w = L;
            c[w >> 2] = La;
            c[w + 4 >> 2] = Ma;
            Ma = sa;
            sa = c[Ma + 4 >> 2] | 0;
            w = N;
            c[w >> 2] = c[Ma >> 2];
            c[w + 4 >> 2] = sa;
            sa = v;
            w = M;
            c[sa + 0 >> 2] = c[w + 0 >> 2];
            c[sa + 4 >> 2] = c[w + 4 >> 2];
            w = u;
            sa = O;
            c[w + 0 >> 2] = c[sa + 0 >> 2];
            c[w + 4 >> 2] = c[sa + 4 >> 2];
            ed(v, u, 0);
            i = e;
            return
        } else if ((Ja | 0) == 155) {
            i = e;
            return
        }
    }

    function dd(a, b, d, e, f, g) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        var j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0.0,
            o = 0.0,
            p = 0.0,
            q = 0,
            r = 0,
            s = 0.0,
            t = 0.0,
            u = 0.0,
            v = 0,
            w = 0;
        g = i;
        j = c[a + 4 >> 2] | 0;
        k = c[b + 4 >> 2] | 0;
        l = c[d + 4 >> 2] | 0;
        m = c[e + 4 >> 2] | 0;
        n = +h[k >> 3];
        o = +h[j >> 3];
        p = +h[l >> 3];
        q = p < n;
        do {
            if (n < o) {
                if (q) {
                    h[j >> 3] = p;
                    h[l >> 3] = o;
                    r = 1;
                    s = o;
                    break
                }
                h[j >> 3] = n;
                h[k >> 3] = o;
                t = +h[l >> 3];
                if (!(t < o)) {
                    r = 1;
                    s = t;
                    break
                }
                h[k >> 3] = t;
                h[l >> 3] = o;
                r = 2;
                s = o
            } else {
                if (!q) {
                    r = 0;
                    s = p;
                    break
                }
                h[k >> 3] = p;
                h[l >> 3] = n;
                t = +h[k >> 3];
                u = +h[j >> 3];
                if (!(t < u)) {
                    r = 1;
                    s = n;
                    break
                }
                h[j >> 3] = t;
                h[k >> 3] = u;
                r = 2;
                s = +h[l >> 3]
            }
        } while (0);
        n = +h[m >> 3];
        do {
            if (n < s) {
                h[l >> 3] = n;
                h[m >> 3] = s;
                p = +h[l >> 3];
                o = +h[k >> 3];
                if (!(p < o)) {
                    v = r + 1 | 0;
                    break
                }
                h[k >> 3] = p;
                h[l >> 3] = o;
                o = +h[k >> 3];
                p = +h[j >> 3];
                if (!(o < p)) {
                    v = r + 2 | 0;
                    break
                }
                h[j >> 3] = o;
                h[k >> 3] = p;
                v = r + 3 | 0
            } else {
                v = r
            }
        } while (0);
        r = c[f + 4 >> 2] | 0;
        f = c[e + 4 >> 2] | 0;
        s = +h[r >> 3];
        n = +h[f >> 3];
        if (!(s < n)) {
            w = v;
            i = g;
            return w | 0
        }
        h[f >> 3] = s;
        h[r >> 3] = n;
        r = c[d + 4 >> 2] | 0;
        n = +h[f >> 3];
        s = +h[r >> 3];
        if (!(n < s)) {
            w = v + 1 | 0;
            i = g;
            return w | 0
        }
        h[r >> 3] = n;
        h[f >> 3] = s;
        f = c[b + 4 >> 2] | 0;
        s = +h[r >> 3];
        n = +h[f >> 3];
        if (!(s < n)) {
            w = v + 2 | 0;
            i = g;
            return w | 0
        }
        h[f >> 3] = s;
        h[r >> 3] = n;
        r = c[a + 4 >> 2] | 0;
        n = +h[f >> 3];
        s = +h[r >> 3];
        if (!(n < s)) {
            w = v + 3 | 0;
            i = g;
            return w | 0
        }
        h[r >> 3] = n;
        h[f >> 3] = s;
        w = v + 4 | 0;
        i = g;
        return w | 0
    }

    function ed(a, b, d) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0.0,
            s = 0.0,
            t = 0.0,
            u = 0.0,
            v = 0.0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0;
        d = i;
        e = a;
        f = c[e + 4 >> 2] | 0;
        g = c[e >> 2] | 0;
        e = f - (c[g >> 2] | 0) | 0;
        j = e >> 3;
        k = j + 2 | 0;
        if ((k | 0) > 0) {
            l = g + (((k | 0) / 512 | 0) << 2) | 0;
            m = c[l >> 2] | 0;
            n = m;
            o = m + (((k | 0) % 512 | 0) << 3) | 0;
            p = l
        } else {
            l = 509 - j | 0;
            k = g + (((l | 0) / -512 | 0) << 2) | 0;
            m = c[k >> 2] | 0;
            n = m;
            o = m + (511 - ((l | 0) % 512 | 0) << 3) | 0;
            p = k
        }
        k = j + 1 | 0;
        if ((e | 0) > -8) {
            q = (c[g + (((k | 0) / 512 | 0) << 2) >> 2] | 0) + (((k | 0) % 512 | 0) << 3) | 0
        } else {
            k = 510 - j | 0;
            q = (c[g + (((k | 0) / -512 | 0) << 2) >> 2] | 0) + (511 - ((k | 0) % 512 | 0) << 3) | 0
        }
        k = o;
        g = f;
        r = +h[q >> 3];
        s = +h[g >> 3];
        t = +h[o >> 3];
        f = t < r;
        do {
            if (r < s) {
                if (f) {
                    h[g >> 3] = t;
                    h[o >> 3] = s;
                    break
                }
                h[g >> 3] = r;
                h[q >> 3] = s;
                u = +h[o >> 3];
                if (!(u < s)) {
                    break
                }
                h[q >> 3] = u;
                h[o >> 3] = s
            } else {
                if (!f) {
                    break
                }
                h[q >> 3] = t;
                h[o >> 3] = r;
                u = +h[q >> 3];
                v = +h[g >> 3];
                if (!(u < v)) {
                    break
                }
                h[g >> 3] = u;
                h[q >> 3] = v
            }
        } while (0);
        q = k - n | 0;
        n = q >> 3;
        k = n + 1 | 0;
        if ((q | 0) > -8) {
            q = p + (((k | 0) / 512 | 0) << 2) | 0;
            g = c[q >> 2] | 0;
            w = g + (((k | 0) % 512 | 0) << 3) | 0;
            x = q;
            y = g
        } else {
            g = 510 - n | 0;
            n = p + (((g | 0) / -512 | 0) << 2) | 0;
            q = c[n >> 2] | 0;
            w = q + (511 - ((g | 0) % 512 | 0) << 3) | 0;
            x = n;
            y = q
        }
        q = c[b + 4 >> 2] | 0;
        b = c[a + 4 >> 2] | 0;
        a = o;
        o = p;
        p = w;
        w = x;
        x = y;
        a: while (1) {
            y = a;
            n = o;
            g = p;
            while (1) {
                if ((g | 0) == (q | 0)) {
                    break a
                }
                r = +h[g >> 3];
                t = +h[y >> 3];
                if (r < t) {
                    s = t;
                    k = g;
                    f = y;
                    j = n;
                    while (1) {
                        h[k >> 3] = s;
                        if ((f | 0) == (b | 0)) {
                            z = b;
                            break
                        }
                        if ((f | 0) == (c[j >> 2] | 0)) {
                            e = j + -4 | 0;
                            A = e;
                            B = (c[e >> 2] | 0) + 4096 | 0
                        } else {
                            A = j;
                            B = f
                        }
                        e = B + -8 | 0;
                        t = +h[e >> 3];
                        if (r < t) {
                            l = f;
                            s = t;
                            f = e;
                            j = A;
                            k = l
                        } else {
                            z = f;
                            break
                        }
                    }
                    h[z >> 3] = r
                }
                f = g + 8 | 0;
                if ((f - x | 0) == 4096) {
                    break
                } else {
                    k = g;
                    n = w;
                    g = f;
                    y = k
                }
            }
            y = w + 4 | 0;
            n = c[y >> 2] | 0;
            k = w;
            a = g;
            p = n;
            w = y;
            x = n;
            o = k
        }
        i = d;
        return
    }

    function fd(a, b, d) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0.0,
            J = 0.0,
            K = 0.0,
            L = 0.0,
            M = 0.0,
            N = 0.0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0,
            V = 0,
            W = 0,
            X = 0,
            Y = 0,
            Z = 0,
            _ = 0,
            $ = 0,
            aa = 0,
            ba = 0,
            ca = 0,
            da = 0,
            ea = 0,
            fa = 0,
            ga = 0,
            ha = 0,
            ia = 0,
            ja = 0;
        d = i;
        i = i + 56 | 0;
        e = d;
        f = d + 8 | 0;
        g = d + 16 | 0;
        j = d + 24 | 0;
        k = d + 32 | 0;
        l = d + 40 | 0;
        m = d + 48 | 0;
        n = m;
        o = i;
        i = i + 8 | 0;
        p = o;
        q = i;
        i = i + 8 | 0;
        r = q;
        s = i;
        i = i + 8 | 0;
        t = b + 4 | 0;
        u = c[t >> 2] | 0;
        v = c[a + 4 >> 2] | 0;
        if ((u | 0) == (v | 0)) {
            w = 1;
            i = d;
            return w | 0
        }
        x = b;
        y = c[x >> 2] | 0;
        z = c[a >> 2] | 0;
        A = c[y >> 2] | 0;
        switch ((u - A >> 3) + (y - z << 7) - (v - (c[z >> 2] | 0) >> 3) | 0) {
        case 4:
            {
                z = a;
                B = c[z + 4 >> 2] | 0;
                C = c[z >> 2] | 0;
                z = B - (c[C >> 2] | 0) | 0;
                D = z >> 3;
                E = D + 1 | 0;
                if ((z | 0) > -8) {
                    F = (c[C + (((E | 0) / 512 | 0) << 2) >> 2] | 0) + (((E | 0) % 512 | 0) << 3) | 0
                } else {
                    E = 510 - D | 0;
                    F = (c[C + (((E | 0) / -512 | 0) << 2) >> 2] | 0) + (511 - ((E | 0) % 512 | 0) << 3) | 0
                }
                E = D + 2 | 0;
                if ((E | 0) > 0) {
                    G = (c[C + (((E | 0) / 512 | 0) << 2) >> 2] | 0) + (((E | 0) % 512 | 0) << 3) | 0
                } else {
                    E = 509 - D | 0;
                    G = (c[C + (((E | 0) / -512 | 0) << 2) >> 2] | 0) + (511 - ((E | 0) % 512 | 0) << 3) | 0
                } if ((u | 0) == (A | 0)) {
                    E = y + -4 | 0;
                    c[x >> 2] = E;
                    C = (c[E >> 2] | 0) + 4096 | 0;
                    c[t >> 2] = C;
                    H = C
                } else {
                    H = u
                }
                c[t >> 2] = H + -8;
                H = B;
                B = c[b + 4 >> 2] | 0;
                I = +h[F >> 3];
                J = +h[H >> 3];
                K = +h[G >> 3];
                C = K < I;
                do {
                    if (I < J) {
                        if (C) {
                            h[H >> 3] = K;
                            h[G >> 3] = J;
                            L = J;
                            break
                        }
                        h[H >> 3] = I;
                        h[F >> 3] = J;
                        M = +h[G >> 3];
                        if (!(M < J)) {
                            L = M;
                            break
                        }
                        h[F >> 3] = M;
                        h[G >> 3] = J;
                        L = J
                    } else {
                        if (!C) {
                            L = K;
                            break
                        }
                        h[F >> 3] = K;
                        h[G >> 3] = I;
                        M = +h[F >> 3];
                        N = +h[H >> 3];
                        if (!(M < N)) {
                            L = I;
                            break
                        }
                        h[H >> 3] = M;
                        h[F >> 3] = N;
                        L = +h[G >> 3]
                    }
                } while (0);
                I = +h[B >> 3];
                if (!(I < L)) {
                    w = 1;
                    i = d;
                    return w | 0
                }
                h[G >> 3] = I;
                h[B >> 3] = L;
                L = +h[G >> 3];
                I = +h[F >> 3];
                if (!(L < I)) {
                    w = 1;
                    i = d;
                    return w | 0
                }
                h[F >> 3] = L;
                h[G >> 3] = I;
                I = +h[F >> 3];
                L = +h[H >> 3];
                if (!(I < L)) {
                    w = 1;
                    i = d;
                    return w | 0
                }
                h[H >> 3] = I;
                h[F >> 3] = L;
                w = 1;
                i = d;
                return w | 0
            };
        case 2:
            {
                if ((u | 0) == (A | 0)) {
                    F = y + -4 | 0;
                    c[x >> 2] = F;
                    H = (c[F >> 2] | 0) + 4096 | 0;
                    c[t >> 2] = H;
                    O = H
                } else {
                    O = u
                }
                H = O + -8 | 0;
                c[t >> 2] = H;
                L = +h[H >> 3];
                I = +h[v >> 3];
                if (!(L < I)) {
                    w = 1;
                    i = d;
                    return w | 0
                }
                h[v >> 3] = L;
                h[H >> 3] = I;
                w = 1;
                i = d;
                return w | 0
            };
        case 3:
            {
                H = a;
                O = c[H + 4 >> 2] | 0;
                F = c[H >> 2] | 0;
                H = O - (c[F >> 2] | 0) | 0;
                G = H >> 3;
                B = G + 1 | 0;
                if ((H | 0) > -8) {
                    P = (c[F + (((B | 0) / 512 | 0) << 2) >> 2] | 0) + (((B | 0) % 512 | 0) << 3) | 0
                } else {
                    B = 510 - G | 0;
                    P = (c[F + (((B | 0) / -512 | 0) << 2) >> 2] | 0) + (511 - ((B | 0) % 512 | 0) << 3) | 0
                } if ((u | 0) == (A | 0)) {
                    B = y + -4 | 0;
                    c[x >> 2] = B;
                    F = (c[B >> 2] | 0) + 4096 | 0;
                    c[t >> 2] = F;
                    Q = F
                } else {
                    Q = u
                }
                c[t >> 2] = Q + -8;
                Q = O;
                O = c[b + 4 >> 2] | 0;
                I = +h[P >> 3];
                L = +h[Q >> 3];
                K = +h[O >> 3];
                F = K < I;
                if (!(I < L)) {
                    if (!F) {
                        w = 1;
                        i = d;
                        return w | 0
                    }
                    h[P >> 3] = K;
                    h[O >> 3] = I;
                    J = +h[P >> 3];
                    N = +h[Q >> 3];
                    if (!(J < N)) {
                        w = 1;
                        i = d;
                        return w | 0
                    }
                    h[Q >> 3] = J;
                    h[P >> 3] = N;
                    w = 1;
                    i = d;
                    return w | 0
                }
                if (F) {
                    h[Q >> 3] = K;
                    h[O >> 3] = L;
                    w = 1;
                    i = d;
                    return w | 0
                }
                h[Q >> 3] = I;
                h[P >> 3] = L;
                I = +h[O >> 3];
                if (!(I < L)) {
                    w = 1;
                    i = d;
                    return w | 0
                }
                h[P >> 3] = I;
                h[O >> 3] = L;
                w = 1;
                i = d;
                return w | 0
            };
        case 1:
        case 0:
            {
                w = 1;
                i = d;
                return w | 0
            };
        case 5:
            {
                O = a;
                P = c[O >> 2] | 0;
                Q = c[O + 4 >> 2] | 0;
                O = l;
                c[O >> 2] = P;
                c[O + 4 >> 2] = Q;
                O = m;
                c[O >> 2] = P;
                c[O + 4 >> 2] = Q;
                O = P;
                F = m;
                m = Q - (c[O >> 2] | 0) | 0;
                B = m >> 3;
                G = B + 1 | 0;
                if ((m | 0) > -8) {
                    m = O + (((G | 0) / 512 | 0) << 2) | 0;
                    c[F >> 2] = m;
                    R = (c[m >> 2] | 0) + (((G | 0) % 512 | 0) << 3) | 0
                } else {
                    G = 510 - B | 0;
                    B = O + (((G | 0) / -512 | 0) << 2) | 0;
                    c[F >> 2] = B;
                    R = (c[B >> 2] | 0) + (511 - ((G | 0) % 512 | 0) << 3) | 0
                }
                c[n + 4 >> 2] = R;
                R = o;
                c[R >> 2] = P;
                c[R + 4 >> 2] = Q;
                R = o;
                o = Q - (c[O >> 2] | 0) >> 3;
                G = o + 2 | 0;
                if ((G | 0) > 0) {
                    B = O + (((G | 0) / 512 | 0) << 2) | 0;
                    c[R >> 2] = B;
                    S = (c[B >> 2] | 0) + (((G | 0) % 512 | 0) << 3) | 0
                } else {
                    G = 509 - o | 0;
                    o = O + (((G | 0) / -512 | 0) << 2) | 0;
                    c[R >> 2] = o;
                    S = (c[o >> 2] | 0) + (511 - ((G | 0) % 512 | 0) << 3) | 0
                }
                c[p + 4 >> 2] = S;
                S = q;
                c[S >> 2] = P;
                c[S + 4 >> 2] = Q;
                S = q;
                q = Q - (c[O >> 2] | 0) >> 3;
                Q = q + 3 | 0;
                if ((Q | 0) > 0) {
                    P = O + (((Q | 0) / 512 | 0) << 2) | 0;
                    c[S >> 2] = P;
                    T = (c[P >> 2] | 0) + (((Q | 0) % 512 | 0) << 3) | 0
                } else {
                    Q = 508 - q | 0;
                    q = O + (((Q | 0) / -512 | 0) << 2) | 0;
                    c[S >> 2] = q;
                    T = (c[q >> 2] | 0) + (511 - ((Q | 0) % 512 | 0) << 3) | 0
                }
                c[r + 4 >> 2] = T;
                if ((u | 0) == (A | 0)) {
                    A = y + -4 | 0;
                    c[x >> 2] = A;
                    x = (c[A >> 2] | 0) + 4096 | 0;
                    c[t >> 2] = x;
                    U = x
                } else {
                    U = u
                }
                c[t >> 2] = U + -8;
                U = b;
                b = c[U + 4 >> 2] | 0;
                t = s;
                c[t >> 2] = c[U >> 2];
                c[t + 4 >> 2] = b;
                b = k;
                t = l;
                c[b + 0 >> 2] = c[t + 0 >> 2];
                c[b + 4 >> 2] = c[t + 4 >> 2];
                t = j;
                b = n;
                c[t + 0 >> 2] = c[b + 0 >> 2];
                c[t + 4 >> 2] = c[b + 4 >> 2];
                b = g;
                t = p;
                c[b + 0 >> 2] = c[t + 0 >> 2];
                c[b + 4 >> 2] = c[t + 4 >> 2];
                t = f;
                b = r;
                c[t + 0 >> 2] = c[b + 0 >> 2];
                c[t + 4 >> 2] = c[b + 4 >> 2];
                b = e;
                t = s;
                c[b + 0 >> 2] = c[t + 0 >> 2];
                c[b + 4 >> 2] = c[t + 4 >> 2];
                dd(k, j, g, f, e, 0) | 0;
                w = 1;
                i = d;
                return w | 0
            };
        default:
            {
                e = a;
                a = c[e + 4 >> 2] | 0;
                f = c[e >> 2] | 0;
                e = a - (c[f >> 2] | 0) | 0;
                g = e >> 3;
                j = g + 2 | 0;
                if ((j | 0) > 0) {
                    k = f + (((j | 0) / 512 | 0) << 2) | 0;
                    t = c[k >> 2] | 0;
                    V = t;
                    W = t + (((j | 0) % 512 | 0) << 3) | 0;
                    X = k
                } else {
                    k = 509 - g | 0;
                    j = f + (((k | 0) / -512 | 0) << 2) | 0;
                    t = c[j >> 2] | 0;
                    V = t;
                    W = t + (511 - ((k | 0) % 512 | 0) << 3) | 0;
                    X = j
                }
                j = g + 1 | 0;
                if ((e | 0) > -8) {
                    Y = (c[f + (((j | 0) / 512 | 0) << 2) >> 2] | 0) + (((j | 0) % 512 | 0) << 3) | 0
                } else {
                    j = 510 - g | 0;
                    Y = (c[f + (((j | 0) / -512 | 0) << 2) >> 2] | 0) + (511 - ((j | 0) % 512 | 0) << 3) | 0
                }
                j = W;
                f = a;
                L = +h[Y >> 3];
                I = +h[f >> 3];
                K = +h[W >> 3];
                a = K < L;
                do {
                    if (L < I) {
                        if (a) {
                            h[f >> 3] = K;
                            h[W >> 3] = I;
                            break
                        }
                        h[f >> 3] = L;
                        h[Y >> 3] = I;
                        N = +h[W >> 3];
                        if (!(N < I)) {
                            break
                        }
                        h[Y >> 3] = N;
                        h[W >> 3] = I
                    } else {
                        if (!a) {
                            break
                        }
                        h[Y >> 3] = K;
                        h[W >> 3] = L;
                        N = +h[Y >> 3];
                        J = +h[f >> 3];
                        if (!(N < J)) {
                            break
                        }
                        h[f >> 3] = N;
                        h[Y >> 3] = J
                    }
                } while (0);
                Y = j - V | 0;
                V = Y >> 3;
                j = V + 1 | 0;
                if ((Y | 0) > -8) {
                    Y = X + (((j | 0) / 512 | 0) << 2) | 0;
                    f = c[Y >> 2] | 0;
                    Z = W;
                    _ = X;
                    $ = f + (((j | 0) % 512 | 0) << 3) | 0;
                    aa = Y;
                    ba = f;
                    ca = 0
                } else {
                    f = 510 - V | 0;
                    V = X + (((f | 0) / -512 | 0) << 2) | 0;
                    Y = c[V >> 2] | 0;
                    Z = W;
                    _ = X;
                    $ = Y + (511 - ((f | 0) % 512 | 0) << 3) | 0;
                    aa = V;
                    ba = Y;
                    ca = 0
                }
                a: while (1) {
                    Y = Z;
                    V = _;
                    da = $;
                    f = ca;
                    while (1) {
                        if ((da | 0) == (u | 0)) {
                            w = 1;
                            ea = 82;
                            break a
                        }
                        L = +h[da >> 3];
                        K = +h[Y >> 3];
                        if (L < K) {
                            I = K;
                            X = da;
                            W = Y;
                            j = V;
                            while (1) {
                                h[X >> 3] = I;
                                if ((W | 0) == (v | 0)) {
                                    fa = v;
                                    break
                                }
                                if ((W | 0) == (c[j >> 2] | 0)) {
                                    a = j + -4 | 0;
                                    ga = a;
                                    ha = (c[a >> 2] | 0) + 4096 | 0
                                } else {
                                    ga = j;
                                    ha = W
                                }
                                a = ha + -8 | 0;
                                K = +h[a >> 3];
                                if (L < K) {
                                    g = W;
                                    I = K;
                                    W = a;
                                    j = ga;
                                    X = g
                                } else {
                                    fa = W;
                                    break
                                }
                            }
                            h[fa >> 3] = L;
                            W = f + 1 | 0;
                            if ((W | 0) == 8) {
                                break a
                            } else {
                                ia = W
                            }
                        } else {
                            ia = f
                        }
                        W = da + 8 | 0;
                        if ((W - ba | 0) == 4096) {
                            break
                        } else {
                            X = da;
                            V = aa;
                            da = W;
                            f = ia;
                            Y = X
                        }
                    }
                    Y = aa + 4 | 0;
                    f = c[Y >> 2] | 0;
                    V = aa;
                    Z = da;
                    $ = f;
                    aa = Y;
                    ba = f;
                    ca = ia;
                    _ = V
                }
                if ((ea | 0) == 82) {
                    i = d;
                    return w | 0
                }
                ea = da + 8 | 0;
                if ((ea - ba | 0) == 4096) {
                    ja = c[aa + 4 >> 2] | 0
                } else {
                    ja = ea
                }
                w = (ja | 0) == (u | 0);
                i = d;
                return w | 0
            }
        }
        return 0
    }

    function gd(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0;
        b = i;
        d = a + 4 | 0;
        e = c[d >> 2] | 0;
        f = a + 16 | 0;
        g = c[f >> 2] | 0;
        h = e + (g >>> 9 << 2) | 0;
        j = a + 8 | 0;
        k = c[j >> 2] | 0;
        if ((k | 0) == (e | 0)) {
            l = a + 20 | 0;
            m = 0;
            n = 0
        } else {
            o = a + 20 | 0;
            p = (c[o >> 2] | 0) + g | 0;
            l = o;
            m = (c[h >> 2] | 0) + ((g & 511) << 3) | 0;
            n = (c[e + (p >>> 9 << 2) >> 2] | 0) + ((p & 511) << 3) | 0
        }
        p = m;
        m = h;
        a: while (1) {
            h = p;
            do {
                if ((h | 0) == (n | 0)) {
                    break a
                }
                h = h + 8 | 0;
            } while ((h - (c[m >> 2] | 0) | 0) != 4096);
            h = m + 4 | 0;
            p = c[h >> 2] | 0;
            m = h
        }
        c[l >> 2] = 0;
        l = k - e >> 2;
        if (l >>> 0 > 2) {
            k = e;
            while (1) {
                Om(c[k >> 2] | 0);
                e = (c[d >> 2] | 0) + 4 | 0;
                c[d >> 2] = e;
                m = (c[j >> 2] | 0) - e >> 2;
                if (m >>> 0 > 2) {
                    k = e
                } else {
                    q = m;
                    break
                }
            }
        } else {
            q = l
        } if ((q | 0) == 1) {
            c[f >> 2] = 256
        } else if ((q | 0) == 2) {
            c[f >> 2] = 512
        }
        f = c[d >> 2] | 0;
        q = c[j >> 2] | 0;
        do {
            if ((f | 0) != (q | 0)) {
                l = f;
                do {
                    Om(c[l >> 2] | 0);
                    l = l + 4 | 0;
                } while ((l | 0) != (q | 0));
                l = c[d >> 2] | 0;
                k = c[j >> 2] | 0;
                if ((k | 0) == (l | 0)) {
                    break
                }
                c[j >> 2] = k + (~((k + -4 + (0 - l) | 0) >>> 2) << 2)
            }
        } while (0);
        j = c[a >> 2] | 0;
        if ((j | 0) == 0) {
            i = b;
            return
        }
        Om(j);
        i = b;
        return
    }

    function hd(a, b) {
        a = a | 0;
        b = b | 0;
        var d = 0,
            e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0,
            V = 0,
            W = 0,
            X = 0,
            Y = 0,
            Z = 0,
            _ = 0,
            $ = 0,
            aa = 0,
            ba = 0,
            ca = 0,
            da = 0,
            ea = 0,
            fa = 0,
            ga = 0,
            ha = 0;
        d = i;
        i = i + 32 | 0;
        e = d;
        f = d + 8 | 0;
        g = a;
        h = a + 8 | 0;
        j = c[h >> 2] | 0;
        k = a + 4 | 0;
        l = c[k >> 2] | 0;
        m = ((j | 0) == (l | 0)) + b | 0;
        b = ((m & 511 | 0) != 0) + (m >>> 9) | 0;
        m = a + 16 | 0;
        n = c[m >> 2] | 0;
        o = n >>> 9;
        p = b >>> 0 < o >>> 0 ? b : o;
        q = b - p | 0;
        if ((b | 0) == (p | 0)) {
            c[m >> 2] = n - (b << 9);
            if ((b | 0) == 0) {
                i = d;
                return
            }
            n = a + 12 | 0;
            r = a;
            s = l;
            t = j;
            u = b;
            while (1) {
                v = c[s >> 2] | 0;
                w = s + 4 | 0;
                c[k >> 2] = w;
                do {
                    if ((t | 0) == (c[n >> 2] | 0)) {
                        x = c[r >> 2] | 0;
                        if (w >>> 0 > x >>> 0) {
                            y = w;
                            z = ((y - x >> 2) + 1 | 0) / -2 | 0;
                            A = t - y | 0;
                            gn(s + (z + 1 << 2) | 0, w | 0, A | 0) | 0;
                            y = s + ((A >> 2) + 1 + z << 2) | 0;
                            c[h >> 2] = y;
                            c[k >> 2] = (c[k >> 2] | 0) + (z << 2);
                            B = y;
                            C = 15;
                            break
                        }
                        y = t - x >> 1;
                        z = (y | 0) == 0 ? 1 : y;
                        y = Mm(z << 2) | 0;
                        A = y + (z >>> 2 << 2) | 0;
                        D = y + (z << 2) | 0;
                        if ((w | 0) == (t | 0)) {
                            E = x;
                            F = A
                        } else {
                            x = A;
                            z = w;
                            do {
                                if ((x | 0) == 0) {
                                    G = 0
                                } else {
                                    c[x >> 2] = c[z >> 2];
                                    G = x
                                }
                                x = G + 4 | 0;
                                z = z + 4 | 0;
                            } while ((z | 0) != (t | 0));
                            E = c[r >> 2] | 0;
                            F = x
                        }
                        c[r >> 2] = y;
                        c[k >> 2] = A;
                        c[h >> 2] = F;
                        c[n >> 2] = D;
                        if ((E | 0) == 0) {
                            H = F;
                            C = 14;
                            break
                        }
                        Om(E);
                        H = c[h >> 2] | 0;
                        C = 14
                    } else {
                        H = t;
                        C = 14
                    }
                } while (0);
                if ((C | 0) == 14) {
                    C = 0;
                    if ((H | 0) == 0) {
                        I = 0
                    } else {
                        B = H;
                        C = 15
                    }
                }
                if ((C | 0) == 15) {
                    C = 0;
                    c[B >> 2] = v;
                    I = c[h >> 2] | 0
                }
                w = I + 4 | 0;
                c[h >> 2] = w;
                z = u + -1 | 0;
                if ((z | 0) == 0) {
                    break
                }
                s = c[k >> 2] | 0;
                t = w;
                u = z
            }
            i = d;
            return
        }
        u = a + 12 | 0;
        t = c[u >> 2] | 0;
        s = a;
        I = t - (c[s >> 2] | 0) | 0;
        B = j - l >> 2;
        if (!(q >>> 0 > ((I >> 2) - B | 0) >>> 0)) {
            l = t;
            t = j;
            j = q;
            while (1) {
                if ((l | 0) == (t | 0)) {
                    C = 19;
                    break
                }
                H = Mm(4096) | 0;
                if ((t | 0) == 0) {
                    J = 0
                } else {
                    c[t >> 2] = H;
                    J = c[h >> 2] | 0
                }
                H = J + 4 | 0;
                c[h >> 2] = H;
                E = j + -1 | 0;
                if ((E | 0) == 0) {
                    K = H;
                    C = 20;
                    break
                }
                l = c[u >> 2] | 0;
                t = H;
                j = E
            }
            do {
                if ((C | 0) == 19) {
                    if ((j | 0) == 0) {
                        K = l;
                        C = 20;
                        break
                    }
                    t = ~o;
                    J = ~b;
                    E = t >>> 0 > J >>> 0 ? t : J;
                    J = j;
                    do {
                        c[e >> 2] = Mm(4096) | 0;
                        id(g, e);
                        J = J + -1 | 0;
                        L = c[h >> 2] | 0;
                        M = (c[m >> 2] | 0) + 512 + (((L - (c[k >> 2] | 0) | 0) == 4) << 31 >> 31) | 0;
                        c[m >> 2] = M;
                    } while ((J | 0) != 0);
                    N = j + -1 - E | 0;
                    O = M;
                    P = L
                }
            } while (0);
            if ((C | 0) == 20) {
                N = p;
                O = c[m >> 2] | 0;
                P = K
            }
            c[m >> 2] = O - (N << 9);
            if ((N | 0) == 0) {
                i = d;
                return
            } else {
                Q = P;
                R = N
            }
            do {
                N = c[k >> 2] | 0;
                P = c[N >> 2] | 0;
                O = N + 4 | 0;
                c[k >> 2] = O;
                do {
                    if ((Q | 0) == (c[u >> 2] | 0)) {
                        K = c[s >> 2] | 0;
                        if (O >>> 0 > K >>> 0) {
                            L = O;
                            M = ((L - K >> 2) + 1 | 0) / -2 | 0;
                            j = Q - L | 0;
                            gn(N + (M + 1 << 2) | 0, O | 0, j | 0) | 0;
                            L = N + ((j >> 2) + 1 + M << 2) | 0;
                            c[h >> 2] = L;
                            c[k >> 2] = (c[k >> 2] | 0) + (M << 2);
                            S = L;
                            C = 41;
                            break
                        }
                        L = Q - K >> 1;
                        M = (L | 0) == 0 ? 1 : L;
                        L = Mm(M << 2) | 0;
                        j = L + (M >>> 2 << 2) | 0;
                        e = L + (M << 2) | 0;
                        if ((O | 0) == (Q | 0)) {
                            T = K;
                            U = j
                        } else {
                            K = j;
                            M = O;
                            do {
                                if ((K | 0) == 0) {
                                    V = 0
                                } else {
                                    c[K >> 2] = c[M >> 2];
                                    V = K
                                }
                                K = V + 4 | 0;
                                M = M + 4 | 0;
                            } while ((M | 0) != (Q | 0));
                            T = c[s >> 2] | 0;
                            U = K
                        }
                        c[s >> 2] = L;
                        c[k >> 2] = j;
                        c[h >> 2] = U;
                        c[u >> 2] = e;
                        if ((T | 0) == 0) {
                            W = U;
                            C = 40;
                            break
                        }
                        Om(T);
                        W = c[h >> 2] | 0;
                        C = 40
                    } else {
                        W = Q;
                        C = 40
                    }
                } while (0);
                if ((C | 0) == 40) {
                    C = 0;
                    if ((W | 0) == 0) {
                        X = 0
                    } else {
                        S = W;
                        C = 41
                    }
                }
                if ((C | 0) == 41) {
                    C = 0;
                    c[S >> 2] = P;
                    X = c[h >> 2] | 0
                }
                Q = X + 4 | 0;
                c[h >> 2] = Q;
                R = R + -1 | 0;
            } while ((R | 0) != 0);
            i = d;
            return
        }
        R = p << 9;
        Q = I >> 1;
        I = q + B | 0;
        X = Q >>> 0 < I >>> 0 ? I : Q;
        Q = f + 12 | 0;
        c[Q >> 2] = 0;
        c[f + 16 >> 2] = a + 12;
        if ((X | 0) == 0) {
            Y = 0
        } else {
            Y = Mm(X << 2) | 0
        }
        a = f;
        c[a >> 2] = Y;
        I = Y + (B - p << 2) | 0;
        B = f + 8 | 0;
        c[B >> 2] = I;
        S = f + 4 | 0;
        c[S >> 2] = I;
        c[Q >> 2] = Y + (X << 2);
        X = I;
        I = q;
        do {
            q = Mm(4096) | 0;
            do {
                if ((X | 0) == (c[Q >> 2] | 0)) {
                    Y = c[S >> 2] | 0;
                    W = c[a >> 2] | 0;
                    if (Y >>> 0 > W >>> 0) {
                        T = Y;
                        U = ((T - W >> 2) + 1 | 0) / -2 | 0;
                        V = Y + (U << 2) | 0;
                        O = X - T | 0;
                        gn(V | 0, Y | 0, O | 0) | 0;
                        T = Y + (U + (O >> 2) << 2) | 0;
                        c[B >> 2] = T;
                        c[S >> 2] = V;
                        Z = T;
                        break
                    }
                    T = X - W >> 1;
                    V = (T | 0) == 0 ? 1 : T;
                    T = Mm(V << 2) | 0;
                    O = T + (V >>> 2 << 2) | 0;
                    U = T + (V << 2) | 0;
                    if ((Y | 0) == (X | 0)) {
                        _ = O;
                        $ = W
                    } else {
                        W = O;
                        V = Y;
                        do {
                            if ((W | 0) == 0) {
                                aa = 0
                            } else {
                                c[W >> 2] = c[V >> 2];
                                aa = W
                            }
                            W = aa + 4 | 0;
                            V = V + 4 | 0;
                        } while ((V | 0) != (X | 0));
                        _ = W;
                        $ = c[a >> 2] | 0
                    }
                    c[a >> 2] = T;
                    c[S >> 2] = O;
                    c[B >> 2] = _;
                    c[Q >> 2] = U;
                    if (($ | 0) == 0) {
                        Z = _;
                        break
                    }
                    Om($);
                    Z = _
                } else {
                    Z = X
                }
            } while (0);
            if ((Z | 0) == 0) {
                ba = 0
            } else {
                c[Z >> 2] = q;
                ba = c[B >> 2] | 0
            }
            X = ba + 4 | 0;
            c[B >> 2] = X;
            I = I + -1 | 0;
        } while ((I | 0) != 0);
        if ((p | 0) != 0) {
            I = X;
            X = c[k >> 2] | 0;
            ba = p;
            do {
                if ((I | 0) == (c[Q >> 2] | 0)) {
                    p = c[S >> 2] | 0;
                    Z = c[a >> 2] | 0;
                    do {
                        if (p >>> 0 > Z >>> 0) {
                            _ = p;
                            $ = ((_ - Z >> 2) + 1 | 0) / -2 | 0;
                            aa = p + ($ << 2) | 0;
                            P = I - _ | 0;
                            gn(aa | 0, p | 0, P | 0) | 0;
                            _ = p + ($ + (P >> 2) << 2) | 0;
                            c[B >> 2] = _;
                            c[S >> 2] = aa;
                            ca = _
                        } else {
                            _ = I - Z >> 1;
                            aa = (_ | 0) == 0 ? 1 : _;
                            _ = Mm(aa << 2) | 0;
                            P = _ + (aa >>> 2 << 2) | 0;
                            $ = _ + (aa << 2) | 0;
                            if ((p | 0) == (I | 0)) {
                                da = P;
                                ea = Z
                            } else {
                                aa = P;
                                V = p;
                                do {
                                    if ((aa | 0) == 0) {
                                        fa = 0
                                    } else {
                                        c[aa >> 2] = c[V >> 2];
                                        fa = aa
                                    }
                                    aa = fa + 4 | 0;
                                    V = V + 4 | 0;
                                } while ((V | 0) != (I | 0));
                                da = aa;
                                ea = c[a >> 2] | 0
                            }
                            c[a >> 2] = _;
                            c[S >> 2] = P;
                            c[B >> 2] = da;
                            c[Q >> 2] = $;
                            if ((ea | 0) == 0) {
                                ca = da;
                                break
                            }
                            Om(ea);
                            ca = da
                        }
                    } while (0);
                    if ((ca | 0) == 0) {
                        ga = 0
                    } else {
                        ha = ca;
                        C = 72
                    }
                } else {
                    ha = I;
                    C = 72
                } if ((C | 0) == 72) {
                    C = 0;
                    c[ha >> 2] = c[X >> 2];
                    ga = c[B >> 2] | 0
                }
                I = ga + 4 | 0;
                c[B >> 2] = I;
                X = (c[k >> 2] | 0) + 4 | 0;
                c[k >> 2] = X;
                ba = ba + -1 | 0;
            } while ((ba | 0) != 0)
        }
        ba = c[h >> 2] | 0;
        while (1) {
            if ((ba | 0) == (c[k >> 2] | 0)) {
                break
            }
            X = ba + -4 | 0;
            jd(f, X);
            ba = X
        }
        f = c[s >> 2] | 0;
        c[s >> 2] = c[a >> 2];
        c[a >> 2] = f;
        c[k >> 2] = c[S >> 2];
        c[S >> 2] = ba;
        S = c[h >> 2] | 0;
        c[h >> 2] = c[B >> 2];
        c[B >> 2] = S;
        h = c[u >> 2] | 0;
        c[u >> 2] = c[Q >> 2];
        c[Q >> 2] = h;
        c[m >> 2] = (c[m >> 2] | 0) - R;
        if ((S | 0) != (ba | 0)) {
            c[B >> 2] = S + (~((S + -4 + (0 - ba) | 0) >>> 2) << 2)
        }
        if ((f | 0) == 0) {
            i = d;
            return
        }
        Om(f);
        i = d;
        return
    }

    function id(a, b) {
        a = a | 0;
        b = b | 0;
        var d = 0,
            e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0;
        d = i;
        e = a + 4 | 0;
        f = c[e >> 2] | 0;
        g = a;
        do {
            if ((f | 0) == (c[g >> 2] | 0)) {
                h = a + 8 | 0;
                j = c[h >> 2] | 0;
                k = a + 12 | 0;
                l = c[k >> 2] | 0;
                m = l;
                if (j >>> 0 < l >>> 0) {
                    l = j;
                    n = ((m - l >> 2) + 1 | 0) / 2 | 0;
                    o = l - f | 0;
                    l = j + (n - (o >> 2) << 2) | 0;
                    gn(l | 0, f | 0, o | 0) | 0;
                    c[e >> 2] = l;
                    c[h >> 2] = (c[h >> 2] | 0) + (n << 2);
                    p = l;
                    break
                }
                l = m - f >> 1;
                m = (l | 0) == 0 ? 1 : l;
                l = Mm(m << 2) | 0;
                n = l + ((m + 3 | 0) >>> 2 << 2) | 0;
                o = l + (m << 2) | 0;
                if ((f | 0) == (j | 0)) {
                    q = f;
                    r = n
                } else {
                    m = n;
                    s = f;
                    do {
                        if ((m | 0) == 0) {
                            t = 0
                        } else {
                            c[m >> 2] = c[s >> 2];
                            t = m
                        }
                        m = t + 4 | 0;
                        s = s + 4 | 0;
                    } while ((s | 0) != (j | 0));
                    q = c[g >> 2] | 0;
                    r = m
                }
                c[g >> 2] = l;
                c[e >> 2] = n;
                c[h >> 2] = r;
                c[k >> 2] = o;
                if ((q | 0) == 0) {
                    p = n;
                    break
                }
                Om(q);
                p = c[e >> 2] | 0
            } else {
                p = f
            }
        } while (0);
        c[p + -4 >> 2] = c[b >> 2];
        c[e >> 2] = (c[e >> 2] | 0) + -4;
        i = d;
        return
    }

    function jd(a, b) {
        a = a | 0;
        b = b | 0;
        var d = 0,
            e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0;
        d = i;
        e = a + 4 | 0;
        f = c[e >> 2] | 0;
        g = a;
        do {
            if ((f | 0) == (c[g >> 2] | 0)) {
                h = a + 8 | 0;
                j = c[h >> 2] | 0;
                k = a + 12 | 0;
                l = c[k >> 2] | 0;
                m = l;
                if (j >>> 0 < l >>> 0) {
                    l = j;
                    n = ((m - l >> 2) + 1 | 0) / 2 | 0;
                    o = l - f | 0;
                    l = j + (n - (o >> 2) << 2) | 0;
                    gn(l | 0, f | 0, o | 0) | 0;
                    c[e >> 2] = l;
                    c[h >> 2] = (c[h >> 2] | 0) + (n << 2);
                    p = l;
                    break
                }
                l = m - f >> 1;
                m = (l | 0) == 0 ? 1 : l;
                l = Mm(m << 2) | 0;
                n = l + ((m + 3 | 0) >>> 2 << 2) | 0;
                o = l + (m << 2) | 0;
                if ((f | 0) == (j | 0)) {
                    q = f;
                    r = n
                } else {
                    m = n;
                    s = f;
                    do {
                        if ((m | 0) == 0) {
                            t = 0
                        } else {
                            c[m >> 2] = c[s >> 2];
                            t = m
                        }
                        m = t + 4 | 0;
                        s = s + 4 | 0;
                    } while ((s | 0) != (j | 0));
                    q = c[g >> 2] | 0;
                    r = m
                }
                c[g >> 2] = l;
                c[e >> 2] = n;
                c[h >> 2] = r;
                c[k >> 2] = o;
                if ((q | 0) == 0) {
                    p = n;
                    break
                }
                Om(q);
                p = c[e >> 2] | 0
            } else {
                p = f
            }
        } while (0);
        c[p + -4 >> 2] = c[b >> 2];
        c[e >> 2] = (c[e >> 2] | 0) + -4;
        i = d;
        return
    }

    function kd(a, b, c, d, e, f) {
        a = a | 0;
        b = b | 0;
        c = c | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        var g = 0.0,
            j = 0.0,
            k = 0.0,
            l = 0,
            m = 0,
            n = 0.0,
            o = 0.0,
            p = 0.0,
            q = 0,
            r = 0;
        f = i;
        g = +h[b >> 3];
        j = +h[a >> 3];
        k = +h[c >> 3];
        l = k < g;
        do {
            if (g < j) {
                if (l) {
                    h[a >> 3] = k;
                    h[c >> 3] = j;
                    m = 1;
                    n = j;
                    break
                }
                h[a >> 3] = g;
                h[b >> 3] = j;
                o = +h[c >> 3];
                if (!(o < j)) {
                    m = 1;
                    n = o;
                    break
                }
                h[b >> 3] = o;
                h[c >> 3] = j;
                m = 2;
                n = j
            } else {
                if (!l) {
                    m = 0;
                    n = k;
                    break
                }
                h[b >> 3] = k;
                h[c >> 3] = g;
                o = +h[b >> 3];
                p = +h[a >> 3];
                if (!(o < p)) {
                    m = 1;
                    n = g;
                    break
                }
                h[a >> 3] = o;
                h[b >> 3] = p;
                m = 2;
                n = +h[c >> 3]
            }
        } while (0);
        g = +h[d >> 3];
        do {
            if (g < n) {
                h[c >> 3] = g;
                h[d >> 3] = n;
                k = +h[c >> 3];
                j = +h[b >> 3];
                if (!(k < j)) {
                    q = m + 1 | 0;
                    break
                }
                h[b >> 3] = k;
                h[c >> 3] = j;
                j = +h[b >> 3];
                k = +h[a >> 3];
                if (j < k) {
                    h[a >> 3] = j;
                    h[b >> 3] = k;
                    q = m + 3 | 0;
                    break
                } else {
                    q = m + 2 | 0;
                    break
                }
            } else {
                q = m
            }
        } while (0);
        n = +h[e >> 3];
        g = +h[d >> 3];
        if (!(n < g)) {
            r = q;
            i = f;
            return r | 0
        }
        h[d >> 3] = n;
        h[e >> 3] = g;
        g = +h[d >> 3];
        n = +h[c >> 3];
        if (!(g < n)) {
            r = q + 1 | 0;
            i = f;
            return r | 0
        }
        h[c >> 3] = g;
        h[d >> 3] = n;
        n = +h[c >> 3];
        g = +h[b >> 3];
        if (!(n < g)) {
            r = q + 2 | 0;
            i = f;
            return r | 0
        }
        h[b >> 3] = n;
        h[c >> 3] = g;
        g = +h[b >> 3];
        n = +h[a >> 3];
        if (!(g < n)) {
            r = q + 3 | 0;
            i = f;
            return r | 0
        }
        h[a >> 3] = g;
        h[b >> 3] = n;
        r = q + 4 | 0;
        i = f;
        return r | 0
    }

    function ld() {
        var a = 0;
        a = i;
        c[2] = 0;
        c[12 >> 2] = 0;
        c[16 >> 2] = 0;
        Zb(111, 8, p | 0) | 0;
        i = a;
        return
    }

    function md(a, b, c) {
        a = a | 0;
        b = b | 0;
        c = c | 0;
        var d = 0,
            e = 0,
            f = 0,
            g = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0.0,
            s = 0.0,
            t = 0.0,
            u = 0.0,
            v = 0.0,
            w = 0,
            x = 0,
            y = 0,
            z = 0.0,
            A = 0,
            B = 0,
            C = 0.0,
            D = 0,
            E = 0,
            F = 0,
            G = 0.0,
            H = 0,
            I = 0,
            J = 0.0,
            K = 0,
            L = 0,
            M = 0,
            N = 0.0,
            O = 0,
            P = 0,
            Q = 0.0,
            R = 0,
            S = 0,
            T = 0,
            U = 0,
            V = 0,
            W = 0.0,
            X = 0.0,
            Y = 0.0,
            Z = 0,
            _ = 0,
            $ = 0;
        d = i;
        e = a;
        a = b;
        a: while (1) {
            b = a;
            f = a + -8 | 0;
            g = e;
            b: while (1) {
                j = g;
                k = b - j | 0;
                l = k >> 3;
                switch (l | 0) {
                case 5:
                    {
                        m = 26;
                        break a;
                        break
                    };
                case 3:
                    {
                        m = 6;
                        break a;
                        break
                    };
                case 1:
                case 0:
                    {
                        m = 84;
                        break a;
                        break
                    };
                case 2:
                    {
                        m = 4;
                        break a;
                        break
                    };
                case 4:
                    {
                        m = 14;
                        break a;
                        break
                    };
                default:
                    {}
                }
                if ((k | 0) < 248) {
                    m = 28;
                    break a
                }
                n = (l | 0) / 2 | 0;
                o = g + (n << 3) | 0;
                do {
                    if ((k | 0) > 7992) {
                        p = (l | 0) / 4 | 0;
                        q = kd(g, g + (p << 3) | 0, o, g + (p + n << 3) | 0, f, 0) | 0
                    } else {
                        r = +h[o >> 3];
                        s = +h[g >> 3];
                        t = +h[f >> 3];
                        p = t < r;
                        if (!(r < s)) {
                            if (!p) {
                                q = 0;
                                break
                            }
                            h[o >> 3] = t;
                            h[f >> 3] = r;
                            u = +h[o >> 3];
                            v = +h[g >> 3];
                            if (!(u < v)) {
                                q = 1;
                                break
                            }
                            h[g >> 3] = u;
                            h[o >> 3] = v;
                            q = 2;
                            break
                        }
                        if (p) {
                            h[g >> 3] = t;
                            h[f >> 3] = s;
                            q = 1;
                            break
                        }
                        h[g >> 3] = r;
                        h[o >> 3] = s;
                        r = +h[f >> 3];
                        if (!(r < s)) {
                            q = 1;
                            break
                        }
                        h[o >> 3] = r;
                        h[f >> 3] = s;
                        q = 2
                    }
                } while (0);
                s = +h[g >> 3];
                r = +h[o >> 3];
                do {
                    if (s < r) {
                        w = f;
                        x = q
                    } else {
                        n = f;
                        while (1) {
                            y = n + -8 | 0;
                            if ((g | 0) == (y | 0)) {
                                break
                            }
                            z = +h[y >> 3];
                            if (z < r) {
                                m = 67;
                                break
                            } else {
                                n = y
                            }
                        }
                        if ((m | 0) == 67) {
                            m = 0;
                            h[g >> 3] = z;
                            h[y >> 3] = s;
                            w = y;
                            x = q + 1 | 0;
                            break
                        }
                        n = g + 8 | 0;
                        t = +h[f >> 3];
                        if (s < t) {
                            A = n
                        } else {
                            if ((n | 0) == (f | 0)) {
                                m = 84;
                                break a
                            } else {
                                B = n
                            }
                            while (1) {
                                C = +h[B >> 3];
                                D = B + 8 | 0;
                                if (s < C) {
                                    break
                                }
                                if ((D | 0) == (f | 0)) {
                                    m = 84;
                                    break a
                                } else {
                                    B = D
                                }
                            }
                            h[B >> 3] = t;
                            h[f >> 3] = C;
                            A = D
                        } if ((A | 0) == (f | 0)) {
                            m = 84;
                            break a
                        } else {
                            E = A;
                            F = f
                        }
                        while (1) {
                            v = +h[g >> 3];
                            n = E;
                            while (1) {
                                G = +h[n >> 3];
                                H = n + 8 | 0;
                                if (v < G) {
                                    I = F;
                                    break
                                } else {
                                    n = H
                                }
                            }
                            do {
                                I = I + -8 | 0;
                                J = +h[I >> 3];
                            } while (v < J);
                            if (!(n >>> 0 < I >>> 0)) {
                                g = n;
                                continue b
                            }
                            h[n >> 3] = J;
                            h[I >> 3] = G;
                            E = H;
                            F = I
                        }
                    }
                } while (0);
                l = g + 8 | 0;
                c: do {
                    if (l >>> 0 < w >>> 0) {
                        k = l;
                        p = w;
                        K = o;
                        L = x;
                        while (1) {
                            s = +h[K >> 3];
                            M = k;
                            while (1) {
                                N = +h[M >> 3];
                                O = M + 8 | 0;
                                if (N < s) {
                                    M = O
                                } else {
                                    P = p;
                                    break
                                }
                            }
                            do {
                                P = P + -8 | 0;
                                Q = +h[P >> 3];
                            } while (!(Q < s));
                            if (M >>> 0 > P >>> 0) {
                                R = M;
                                S = K;
                                T = L;
                                break c
                            }
                            h[M >> 3] = Q;
                            h[P >> 3] = N;
                            k = O;
                            p = P;
                            K = (K | 0) == (M | 0) ? P : K;
                            L = L + 1 | 0
                        }
                    } else {
                        R = l;
                        S = o;
                        T = x
                    }
                } while (0);
                do {
                    if ((R | 0) == (S | 0)) {
                        U = T
                    } else {
                        s = +h[S >> 3];
                        r = +h[R >> 3];
                        if (!(s < r)) {
                            U = T;
                            break
                        }
                        h[R >> 3] = s;
                        h[S >> 3] = r;
                        U = T + 1 | 0
                    }
                } while (0);
                if ((U | 0) == 0) {
                    V = nd(g, R, 0) | 0;
                    o = R + 8 | 0;
                    if (nd(o, a, 0) | 0) {
                        m = 79;
                        break
                    }
                    if (V) {
                        g = o;
                        continue
                    }
                }
                o = R;
                if ((o - j | 0) >= (b - o | 0)) {
                    m = 83;
                    break
                }
                md(g, R, c);
                g = R + 8 | 0
            }
            if ((m | 0) == 79) {
                m = 0;
                if (V) {
                    m = 84;
                    break
                } else {
                    e = g;
                    a = R;
                    continue
                }
            } else if ((m | 0) == 83) {
                m = 0;
                md(R + 8 | 0, a, c);
                e = g;
                a = R;
                continue
            }
        }
        if ((m | 0) == 4) {
            N = +h[f >> 3];
            Q = +h[g >> 3];
            if (!(N < Q)) {
                i = d;
                return
            }
            h[g >> 3] = N;
            h[f >> 3] = Q;
            i = d;
            return
        } else if ((m | 0) == 6) {
            R = g + 8 | 0;
            Q = +h[R >> 3];
            N = +h[g >> 3];
            G = +h[f >> 3];
            e = G < Q;
            if (!(Q < N)) {
                if (!e) {
                    i = d;
                    return
                }
                h[R >> 3] = G;
                h[f >> 3] = Q;
                J = +h[R >> 3];
                C = +h[g >> 3];
                if (!(J < C)) {
                    i = d;
                    return
                }
                h[g >> 3] = J;
                h[R >> 3] = C;
                i = d;
                return
            }
            if (e) {
                h[g >> 3] = G;
                h[f >> 3] = N;
                i = d;
                return
            }
            h[g >> 3] = Q;
            h[R >> 3] = N;
            Q = +h[f >> 3];
            if (!(Q < N)) {
                i = d;
                return
            }
            h[R >> 3] = Q;
            h[f >> 3] = N;
            i = d;
            return
        } else if ((m | 0) == 14) {
            R = g + 8 | 0;
            e = g + 16 | 0;
            N = +h[R >> 3];
            Q = +h[g >> 3];
            G = +h[e >> 3];
            c = G < N;
            do {
                if (N < Q) {
                    if (c) {
                        h[g >> 3] = G;
                        h[e >> 3] = Q;
                        W = Q;
                        break
                    }
                    h[g >> 3] = N;
                    h[R >> 3] = Q;
                    if (!(G < Q)) {
                        W = G;
                        break
                    }
                    h[R >> 3] = G;
                    h[e >> 3] = Q;
                    W = Q
                } else {
                    if (!c) {
                        W = G;
                        break
                    }
                    h[R >> 3] = G;
                    h[e >> 3] = N;
                    if (!(G < Q)) {
                        W = N;
                        break
                    }
                    h[g >> 3] = G;
                    h[R >> 3] = Q;
                    W = N
                }
            } while (0);
            N = +h[f >> 3];
            if (!(N < W)) {
                i = d;
                return
            }
            h[e >> 3] = N;
            h[f >> 3] = W;
            W = +h[e >> 3];
            N = +h[R >> 3];
            if (!(W < N)) {
                i = d;
                return
            }
            h[R >> 3] = W;
            h[e >> 3] = N;
            N = +h[g >> 3];
            if (!(W < N)) {
                i = d;
                return
            }
            h[g >> 3] = W;
            h[R >> 3] = N;
            i = d;
            return
        } else if ((m | 0) == 26) {
            kd(g, g + 8 | 0, g + 16 | 0, g + 24 | 0, f, 0) | 0;
            i = d;
            return
        } else if ((m | 0) == 28) {
            f = g + 16 | 0;
            R = g + 8 | 0;
            N = +h[R >> 3];
            W = +h[g >> 3];
            Q = +h[f >> 3];
            e = Q < N;
            do {
                if (N < W) {
                    if (e) {
                        h[g >> 3] = Q;
                        h[f >> 3] = W;
                        X = W;
                        break
                    }
                    h[g >> 3] = N;
                    h[R >> 3] = W;
                    if (!(Q < W)) {
                        X = Q;
                        break
                    }
                    h[R >> 3] = Q;
                    h[f >> 3] = W;
                    X = W
                } else {
                    if (!e) {
                        X = Q;
                        break
                    }
                    h[R >> 3] = Q;
                    h[f >> 3] = N;
                    if (!(Q < W)) {
                        X = N;
                        break
                    }
                    h[g >> 3] = Q;
                    h[R >> 3] = W;
                    X = N
                }
            } while (0);
            R = g + 24 | 0;
            if ((R | 0) == (a | 0)) {
                i = d;
                return
            } else {
                Y = X;
                Z = R;
                _ = f
            }
            while (1) {
                X = +h[Z >> 3];
                if (X < Y) {
                    N = Y;
                    f = Z;
                    R = _;
                    while (1) {
                        h[f >> 3] = N;
                        if ((R | 0) == (g | 0)) {
                            $ = g;
                            break
                        }
                        e = R + -8 | 0;
                        W = +h[e >> 3];
                        if (X < W) {
                            c = R;
                            N = W;
                            R = e;
                            f = c
                        } else {
                            $ = R;
                            break
                        }
                    }
                    h[$ >> 3] = X
                }
                R = Z + 8 | 0;
                if ((R | 0) == (a | 0)) {
                    break
                }
                f = Z;
                Y = +h[Z >> 3];
                Z = R;
                _ = f
            }
            i = d;
            return
        } else if ((m | 0) == 84) {
            i = d;
            return
        }
    }

    function nd(a, b, c) {
        a = a | 0;
        b = b | 0;
        c = c | 0;
        var d = 0,
            e = 0.0,
            f = 0.0,
            g = 0,
            j = 0,
            k = 0.0,
            l = 0,
            m = 0.0,
            n = 0.0,
            o = 0,
            p = 0.0,
            q = 0.0,
            r = 0.0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0;
        c = i;
        switch (b - a >> 3 | 0) {
        case 2:
            {
                d = b + -8 | 0;
                e = +h[d >> 3];
                f = +h[a >> 3];
                if (!(e < f)) {
                    g = 1;
                    i = c;
                    return g | 0
                }
                h[a >> 3] = e;
                h[d >> 3] = f;
                g = 1;
                i = c;
                return g | 0
            };
        case 3:
            {
                d = a + 8 | 0;
                j = b + -8 | 0;
                f = +h[d >> 3];
                e = +h[a >> 3];
                k = +h[j >> 3];
                l = k < f;
                if (!(f < e)) {
                    if (!l) {
                        g = 1;
                        i = c;
                        return g | 0
                    }
                    h[d >> 3] = k;
                    h[j >> 3] = f;
                    m = +h[d >> 3];
                    n = +h[a >> 3];
                    if (!(m < n)) {
                        g = 1;
                        i = c;
                        return g | 0
                    }
                    h[a >> 3] = m;
                    h[d >> 3] = n;
                    g = 1;
                    i = c;
                    return g | 0
                }
                if (l) {
                    h[a >> 3] = k;
                    h[j >> 3] = e;
                    g = 1;
                    i = c;
                    return g | 0
                }
                h[a >> 3] = f;
                h[d >> 3] = e;
                f = +h[j >> 3];
                if (!(f < e)) {
                    g = 1;
                    i = c;
                    return g | 0
                }
                h[d >> 3] = f;
                h[j >> 3] = e;
                g = 1;
                i = c;
                return g | 0
            };
        case 4:
            {
                j = a + 8 | 0;
                d = a + 16 | 0;
                l = b + -8 | 0;
                e = +h[j >> 3];
                f = +h[a >> 3];
                k = +h[d >> 3];
                o = k < e;
                do {
                    if (e < f) {
                        if (o) {
                            h[a >> 3] = k;
                            h[d >> 3] = f;
                            p = f;
                            break
                        }
                        h[a >> 3] = e;
                        h[j >> 3] = f;
                        if (!(k < f)) {
                            p = k;
                            break
                        }
                        h[j >> 3] = k;
                        h[d >> 3] = f;
                        p = f
                    } else {
                        if (!o) {
                            p = k;
                            break
                        }
                        h[j >> 3] = k;
                        h[d >> 3] = e;
                        if (!(k < f)) {
                            p = e;
                            break
                        }
                        h[a >> 3] = k;
                        h[j >> 3] = f;
                        p = e
                    }
                } while (0);
                e = +h[l >> 3];
                if (!(e < p)) {
                    g = 1;
                    i = c;
                    return g | 0
                }
                h[d >> 3] = e;
                h[l >> 3] = p;
                p = +h[d >> 3];
                e = +h[j >> 3];
                if (!(p < e)) {
                    g = 1;
                    i = c;
                    return g | 0
                }
                h[j >> 3] = p;
                h[d >> 3] = e;
                e = +h[a >> 3];
                if (!(p < e)) {
                    g = 1;
                    i = c;
                    return g | 0
                }
                h[a >> 3] = p;
                h[j >> 3] = e;
                g = 1;
                i = c;
                return g | 0
            };
        case 5:
            {
                kd(a, a + 8 | 0, a + 16 | 0, a + 24 | 0, b + -8 | 0, 0) | 0;
                g = 1;
                i = c;
                return g | 0
            };
        case 1:
        case 0:
            {
                g = 1;
                i = c;
                return g | 0
            };
        default:
            {
                j = a + 16 | 0;
                d = a + 8 | 0;
                e = +h[d >> 3];
                p = +h[a >> 3];
                f = +h[j >> 3];
                l = f < e;
                do {
                    if (e < p) {
                        if (l) {
                            h[a >> 3] = f;
                            h[j >> 3] = p;
                            q = p;
                            break
                        }
                        h[a >> 3] = e;
                        h[d >> 3] = p;
                        if (!(f < p)) {
                            q = f;
                            break
                        }
                        h[d >> 3] = f;
                        h[j >> 3] = p;
                        q = p
                    } else {
                        if (!l) {
                            q = f;
                            break
                        }
                        h[d >> 3] = f;
                        h[j >> 3] = e;
                        if (!(f < p)) {
                            q = e;
                            break
                        }
                        h[a >> 3] = f;
                        h[d >> 3] = p;
                        q = e
                    }
                } while (0);
                d = a + 24 | 0;
                if ((d | 0) == (b | 0)) {
                    g = 1;
                    i = c;
                    return g | 0
                } else {
                    r = q;
                    s = 0;
                    t = d;
                    u = j
                }
                while (1) {
                    q = +h[t >> 3];
                    if (q < r) {
                        e = r;
                        j = t;
                        d = u;
                        while (1) {
                            h[j >> 3] = e;
                            if ((d | 0) == (a | 0)) {
                                v = a;
                                break
                            }
                            l = d + -8 | 0;
                            p = +h[l >> 3];
                            if (q < p) {
                                o = d;
                                e = p;
                                d = l;
                                j = o
                            } else {
                                v = d;
                                break
                            }
                        }
                        h[v >> 3] = q;
                        d = s + 1 | 0;
                        if ((d | 0) == 8) {
                            break
                        } else {
                            w = d
                        }
                    } else {
                        w = s
                    }
                    d = t + 8 | 0;
                    if ((d | 0) == (b | 0)) {
                        g = 1;
                        x = 41;
                        break
                    }
                    j = t;
                    r = +h[t >> 3];
                    s = w;
                    t = d;
                    u = j
                }
                if ((x | 0) == 41) {
                    i = c;
                    return g | 0
                }
                g = (t + 8 | 0) == (b | 0);
                i = c;
                return g | 0
            }
        }
        return 0
    }

    function od(a) {
        a = a | 0;
        var b = 0;
        a = i;
        b = (c[6] | 0) + -1 | 0;
        c[6] = b;
        if ((b | 0) != 0) {
            i = a;
            return
        }
        zb(32) | 0;
        i = a;
        return
    }

    function pd(b) {
        b = b | 0;
        var d = 0,
            e = 0,
            f = 0,
            g = 0;
        b = i;
        do {
            if ((a[2560] | 0) == 0) {
                if ((Ma(2560) | 0) == 0) {
                    break
                }
                c[14] = 5489;
                d = 5489;
                e = 1;
                do {
                    d = (ea(d >>> 30 ^ d, 1812433253) | 0) + e | 0;
                    c[56 + (e << 2) >> 2] = d;
                    e = e + 1 | 0;
                } while ((e | 0) != 624);
                c[2552 >> 2] = 0;
                Za(2560)
            }
        } while (0);
        e = c[2552 >> 2] | 0;
        d = ((e + 1 | 0) >>> 0) % 624 | 0;
        f = 56 + (e << 2) | 0;
        g = c[56 + (d << 2) >> 2] | 0;
        c[f >> 2] = 0 - (g & 1) & -1727483681 ^ c[56 + ((((e + 397 | 0) >>> 0) % 624 | 0) << 2) >> 2] ^ (g & 2147483646 | c[f >> 2] & -2147483648) >>> 1;
        f = c[56 + (c[2552 >> 2] << 2) >> 2] | 0;
        g = f >>> 11 ^ f;
        c[2552 >> 2] = d;
        d = g << 7 & -1658038656 ^ g;
        g = d << 15 & -272236544 ^ d;
        i = b;
        return g >>> 18 ^ g | 0
    }

    function qd(a) {
        a = a | 0;
        a = i;
        cb(32) | 0;
        c[6] = 1;
        i = a;
        return
    }

    function rd(b) {
        b = b | 0;
        var d = 0,
            e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0;
        b = i;
        i = i + 32 | 0;
        d = b;
        e = b + 8 | 0;
        f = b + 16 | 0;
        g = b + 24 | 0;
        h = c[r >> 2] | 0;
        Nd(3280, h, 3336);
        c[642] = 4708;
        c[2576 >> 2] = 4728;
        c[2572 >> 2] = 0;
        Qe(2576 | 0, 3280);
        c[2648 >> 2] = 0;
        c[2652 >> 2] = -1;
        j = c[s >> 2] | 0;
        c[846] = 4576;
        Uj(3388 | 0);
        c[3392 >> 2] = 0;
        c[3396 >> 2] = 0;
        c[3400 >> 2] = 0;
        c[3404 >> 2] = 0;
        c[3408 >> 2] = 0;
        c[3412 >> 2] = 0;
        c[846] = 3896;
        c[3416 >> 2] = j;
        Vj(g, 3388 | 0);
        k = Xj(g, 7368) | 0;
        l = k;
        Wj(g);
        c[3420 >> 2] = l;
        c[3424 >> 2] = 3344;
        a[3428 | 0] = (kc[c[(c[k >> 2] | 0) + 28 >> 2] & 63](l) | 0) & 1;
        c[664] = 4788;
        c[2660 >> 2] = 4808;
        Qe(2660 | 0, 3384);
        c[2732 >> 2] = 0;
        c[2736 >> 2] = -1;
        l = c[q >> 2] | 0;
        c[858] = 4576;
        Uj(3436 | 0);
        c[3440 >> 2] = 0;
        c[3444 >> 2] = 0;
        c[3448 >> 2] = 0;
        c[3452 >> 2] = 0;
        c[3456 >> 2] = 0;
        c[3460 >> 2] = 0;
        c[858] = 3896;
        c[3464 >> 2] = l;
        Vj(f, 3436 | 0);
        k = Xj(f, 7368) | 0;
        g = k;
        Wj(f);
        c[3468 >> 2] = g;
        c[3472 >> 2] = 3352;
        a[3476 | 0] = (kc[c[(c[k >> 2] | 0) + 28 >> 2] & 63](g) | 0) & 1;
        c[686] = 4788;
        c[2748 >> 2] = 4808;
        Qe(2748 | 0, 3432);
        c[2820 >> 2] = 0;
        c[2824 >> 2] = -1;
        g = c[(c[(c[686] | 0) + -12 >> 2] | 0) + 2768 >> 2] | 0;
        c[708] = 4788;
        c[2836 >> 2] = 4808;
        Qe(2836 | 0, g);
        c[2908 >> 2] = 0;
        c[2912 >> 2] = -1;
        c[(c[(c[642] | 0) + -12 >> 2] | 0) + 2640 >> 2] = 2656;
        g = (c[(c[686] | 0) + -12 >> 2] | 0) + 2748 | 0;
        c[g >> 2] = c[g >> 2] | 8192;
        c[(c[(c[686] | 0) + -12 >> 2] | 0) + 2816 >> 2] = 2656;
        zd(3480, h, 3360 | 0);
        c[730] = 4748;
        c[2928 >> 2] = 4768;
        c[2924 >> 2] = 0;
        Qe(2928 | 0, 3480);
        c[3e3 >> 2] = 0;
        c[3004 >> 2] = -1;
        c[884] = 4640;
        Uj(3540 | 0);
        c[3544 >> 2] = 0;
        c[3548 >> 2] = 0;
        c[3552 >> 2] = 0;
        c[3556 >> 2] = 0;
        c[3560 >> 2] = 0;
        c[3564 >> 2] = 0;
        c[884] = 3640;
        c[3568 >> 2] = j;
        Vj(e, 3540 | 0);
        j = Xj(e, 7376) | 0;
        h = j;
        Wj(e);
        c[3572 >> 2] = h;
        c[3576 >> 2] = 3368;
        a[3580 | 0] = (kc[c[(c[j >> 2] | 0) + 28 >> 2] & 63](h) | 0) & 1;
        c[752] = 4828;
        c[3012 >> 2] = 4848;
        Qe(3012 | 0, 3536);
        c[3084 >> 2] = 0;
        c[3088 >> 2] = -1;
        c[896] = 4640;
        Uj(3588 | 0);
        c[3592 >> 2] = 0;
        c[3596 >> 2] = 0;
        c[3600 >> 2] = 0;
        c[3604 >> 2] = 0;
        c[3608 >> 2] = 0;
        c[3612 >> 2] = 0;
        c[896] = 3640;
        c[3616 >> 2] = l;
        Vj(d, 3588 | 0);
        l = Xj(d, 7376) | 0;
        h = l;
        Wj(d);
        c[3620 >> 2] = h;
        c[3624 >> 2] = 3376;
        a[3628 | 0] = (kc[c[(c[l >> 2] | 0) + 28 >> 2] & 63](h) | 0) & 1;
        c[774] = 4828;
        c[3100 >> 2] = 4848;
        Qe(3100 | 0, 3584);
        c[3172 >> 2] = 0;
        c[3176 >> 2] = -1;
        h = c[(c[(c[774] | 0) + -12 >> 2] | 0) + 3120 >> 2] | 0;
        c[796] = 4828;
        c[3188 >> 2] = 4848;
        Qe(3188 | 0, h);
        c[3260 >> 2] = 0;
        c[3264 >> 2] = -1;
        c[(c[(c[730] | 0) + -12 >> 2] | 0) + 2992 >> 2] = 3008;
        h = (c[(c[774] | 0) + -12 >> 2] | 0) + 3100 | 0;
        c[h >> 2] = c[h >> 2] | 8192;
        c[(c[(c[774] | 0) + -12 >> 2] | 0) + 3168 >> 2] = 3008;
        i = b;
        return
    }

    function sd(a) {
        a = a | 0;
        a = i;
        wf(2656) | 0;
        wf(2832) | 0;
        Bf(3008) | 0;
        Bf(3184) | 0;
        i = a;
        return
    }

    function td(a) {
        a = a | 0;
        var b = 0;
        b = i;
        c[a >> 2] = 4640;
        Wj(a + 4 | 0);
        i = b;
        return
    }

    function ud(a) {
        a = a | 0;
        var b = 0;
        b = i;
        c[a >> 2] = 4640;
        Wj(a + 4 | 0);
        Om(a);
        i = b;
        return
    }

    function vd(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0;
        e = i;
        kc[c[(c[b >> 2] | 0) + 24 >> 2] & 63](b) | 0;
        f = Xj(d, 7376) | 0;
        d = f;
        c[b + 36 >> 2] = d;
        a[b + 44 | 0] = (kc[c[(c[f >> 2] | 0) + 28 >> 2] & 63](d) | 0) & 1;
        i = e;
        return
    }

    function wd(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0;
        b = i;
        i = i + 16 | 0;
        d = b;
        e = b + 8 | 0;
        f = a + 36 | 0;
        g = a + 40 | 0;
        h = d;
        j = d + 8 | 0;
        k = d;
        d = a + 32 | 0;
        while (1) {
            a = c[f >> 2] | 0;
            l = uc[c[(c[a >> 2] | 0) + 20 >> 2] & 15](a, c[g >> 2] | 0, h, j, e) | 0;
            a = (c[e >> 2] | 0) - k | 0;
            if ((Ub(h | 0, 1, a | 0, c[d >> 2] | 0) | 0) != (a | 0)) {
                m = -1;
                n = 5;
                break
            }
            if ((l | 0) == 2) {
                m = -1;
                n = 5;
                break
            } else if ((l | 0) != 1) {
                n = 4;
                break
            }
        }
        if ((n | 0) == 4) {
            m = ((Ya(c[d >> 2] | 0) | 0) != 0) << 31 >> 31;
            i = b;
            return m | 0
        } else if ((n | 0) == 5) {
            i = b;
            return m | 0
        }
        return 0
    }

    function xd(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0;
        f = i;
        if ((a[b + 44 | 0] | 0) != 0) {
            g = Ub(d | 0, 4, e | 0, c[b + 32 >> 2] | 0) | 0;
            i = f;
            return g | 0
        }
        h = b;
        if ((e | 0) > 0) {
            j = d;
            k = 0
        } else {
            g = 0;
            i = f;
            return g | 0
        }
        while (1) {
            if ((tc[c[(c[h >> 2] | 0) + 52 >> 2] & 15](b, c[j >> 2] | 0) | 0) == -1) {
                g = k;
                l = 6;
                break
            }
            d = k + 1 | 0;
            if ((d | 0) < (e | 0)) {
                j = j + 4 | 0;
                k = d
            } else {
                g = d;
                l = 6;
                break
            }
        }
        if ((l | 0) == 6) {
            i = f;
            return g | 0
        }
        return 0
    }

    function yd(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0;
        e = i;
        i = i + 32 | 0;
        f = e;
        g = e + 8 | 0;
        h = e + 16 | 0;
        j = e + 24 | 0;
        k = (d | 0) == -1;
        a: do {
            if (!k) {
                c[g >> 2] = d;
                if ((a[b + 44 | 0] | 0) != 0) {
                    if ((Ub(g | 0, 4, 1, c[b + 32 >> 2] | 0) | 0) == 1) {
                        break
                    } else {
                        l = -1
                    }
                    i = e;
                    return l | 0
                }
                m = f;
                c[h >> 2] = m;
                n = g + 4 | 0;
                o = b + 36 | 0;
                p = b + 40 | 0;
                q = f + 8 | 0;
                r = f;
                s = b + 32 | 0;
                t = g;
                while (1) {
                    u = c[o >> 2] | 0;
                    v = pc[c[(c[u >> 2] | 0) + 12 >> 2] & 15](u, c[p >> 2] | 0, t, n, j, m, q, h) | 0;
                    if ((c[j >> 2] | 0) == (t | 0)) {
                        l = -1;
                        w = 12;
                        break
                    }
                    if ((v | 0) == 3) {
                        w = 7;
                        break
                    }
                    u = (v | 0) == 1;
                    if (!(v >>> 0 < 2)) {
                        l = -1;
                        w = 12;
                        break
                    }
                    v = (c[h >> 2] | 0) - r | 0;
                    if ((Ub(m | 0, 1, v | 0, c[s >> 2] | 0) | 0) != (v | 0)) {
                        l = -1;
                        w = 12;
                        break
                    }
                    if (u) {
                        t = u ? c[j >> 2] | 0 : t
                    } else {
                        break a
                    }
                }
                if ((w | 0) == 7) {
                    if ((Ub(t | 0, 1, 1, c[s >> 2] | 0) | 0) == 1) {
                        break
                    } else {
                        l = -1
                    }
                    i = e;
                    return l | 0
                } else if ((w | 0) == 12) {
                    i = e;
                    return l | 0
                }
            }
        } while (0);
        l = k ? 0 : d;
        i = e;
        return l | 0
    }

    function zd(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0;
        f = i;
        i = i + 8 | 0;
        g = f;
        h = b;
        c[h >> 2] = 4640;
        j = b + 4 | 0;
        Uj(j);
        k = b + 8 | 0;
        c[k + 0 >> 2] = 0;
        c[k + 4 >> 2] = 0;
        c[k + 8 >> 2] = 0;
        c[k + 12 >> 2] = 0;
        c[k + 16 >> 2] = 0;
        c[k + 20 >> 2] = 0;
        c[h >> 2] = 3752;
        c[b + 32 >> 2] = d;
        c[b + 40 >> 2] = e;
        c[b + 48 >> 2] = -1;
        a[b + 52 | 0] = 0;
        Vj(g, j);
        j = Xj(g, 7376) | 0;
        e = j;
        d = b + 36 | 0;
        c[d >> 2] = e;
        h = b + 44 | 0;
        c[h >> 2] = kc[c[(c[j >> 2] | 0) + 24 >> 2] & 63](e) | 0;
        e = c[d >> 2] | 0;
        a[b + 53 | 0] = (kc[c[(c[e >> 2] | 0) + 28 >> 2] & 63](e) | 0) & 1;
        if ((c[h >> 2] | 0) > 8) {
            fj(3848)
        } else {
            Wj(g);
            i = f;
            return
        }
    }

    function Ad(a) {
        a = a | 0;
        var b = 0;
        b = i;
        c[a >> 2] = 4640;
        Wj(a + 4 | 0);
        i = b;
        return
    }

    function Bd(a) {
        a = a | 0;
        var b = 0;
        b = i;
        c[a >> 2] = 4640;
        Wj(a + 4 | 0);
        Om(a);
        i = b;
        return
    }

    function Cd(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0;
        e = i;
        f = Xj(d, 7376) | 0;
        d = f;
        g = b + 36 | 0;
        c[g >> 2] = d;
        h = b + 44 | 0;
        c[h >> 2] = kc[c[(c[f >> 2] | 0) + 24 >> 2] & 63](d) | 0;
        d = c[g >> 2] | 0;
        a[b + 53 | 0] = (kc[c[(c[d >> 2] | 0) + 28 >> 2] & 63](d) | 0) & 1;
        if ((c[h >> 2] | 0) > 8) {
            fj(3848)
        } else {
            i = e;
            return
        }
    }

    function Dd(a) {
        a = a | 0;
        var b = 0,
            c = 0;
        b = i;
        c = Gd(a, 0) | 0;
        i = b;
        return c | 0
    }

    function Ed(a) {
        a = a | 0;
        var b = 0,
            c = 0;
        b = i;
        c = Gd(a, 1) | 0;
        i = b;
        return c | 0
    }

    function Fd(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0;
        e = i;
        i = i + 32 | 0;
        f = e;
        g = e + 8 | 0;
        h = e + 16 | 0;
        j = e + 24 | 0;
        k = b + 52 | 0;
        l = (a[k] | 0) != 0;
        if ((d | 0) == -1) {
            if (l) {
                m = -1;
                i = e;
                return m | 0
            }
            n = c[b + 48 >> 2] | 0;
            a[k] = (n | 0) != -1 | 0;
            m = n;
            i = e;
            return m | 0
        }
        n = b + 48 | 0;
        a: do {
            if (l) {
                c[h >> 2] = c[n >> 2];
                o = c[b + 36 >> 2] | 0;
                p = f;
                q = pc[c[(c[o >> 2] | 0) + 12 >> 2] & 15](o, c[b + 40 >> 2] | 0, h, h + 4 | 0, j, p, f + 8 | 0, g) | 0;
                if ((q | 0) == 3) {
                    a[p] = c[n >> 2];
                    c[g >> 2] = f + 1
                } else if ((q | 0) == 1 | (q | 0) == 2) {
                    m = -1;
                    i = e;
                    return m | 0
                }
                q = b + 32 | 0;
                while (1) {
                    o = c[g >> 2] | 0;
                    if (!(o >>> 0 > p >>> 0)) {
                        break a
                    }
                    r = o + -1 | 0;
                    c[g >> 2] = r;
                    if ((Qa(a[r] | 0, c[q >> 2] | 0) | 0) == -1) {
                        m = -1;
                        break
                    }
                }
                i = e;
                return m | 0
            }
        } while (0);
        c[n >> 2] = d;
        a[k] = 1;
        m = d;
        i = e;
        return m | 0
    }

    function Gd(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0;
        e = i;
        i = i + 32 | 0;
        f = e;
        g = e + 8 | 0;
        h = e + 16 | 0;
        j = e + 24 | 0;
        k = b + 52 | 0;
        if ((a[k] | 0) != 0) {
            l = b + 48 | 0;
            m = c[l >> 2] | 0;
            if (!d) {
                n = m;
                i = e;
                return n | 0
            }
            c[l >> 2] = -1;
            a[k] = 0;
            n = m;
            i = e;
            return n | 0
        }
        m = c[b + 44 >> 2] | 0;
        k = (m | 0) > 1 ? m : 1;
        a: do {
            if ((k | 0) > 0) {
                m = b + 32 | 0;
                l = 0;
                while (1) {
                    o = Mb(c[m >> 2] | 0) | 0;
                    if ((o | 0) == -1) {
                        n = -1;
                        break
                    }
                    a[f + l | 0] = o;
                    l = l + 1 | 0;
                    if ((l | 0) >= (k | 0)) {
                        break a
                    }
                }
                i = e;
                return n | 0
            }
        } while (0);
        b: do {
            if ((a[b + 53 | 0] | 0) == 0) {
                l = b + 40 | 0;
                m = b + 36 | 0;
                o = f;
                p = g + 4 | 0;
                q = b + 32 | 0;
                r = k;
                while (1) {
                    s = c[l >> 2] | 0;
                    t = s;
                    u = c[t >> 2] | 0;
                    v = c[t + 4 >> 2] | 0;
                    t = c[m >> 2] | 0;
                    w = f + r | 0;
                    x = pc[c[(c[t >> 2] | 0) + 16 >> 2] & 15](t, s, o, w, h, g, p, j) | 0;
                    if ((x | 0) == 2) {
                        n = -1;
                        y = 22;
                        break
                    } else if ((x | 0) == 3) {
                        y = 14;
                        break
                    } else if ((x | 0) != 1) {
                        z = r;
                        break b
                    }
                    x = c[l >> 2] | 0;
                    c[x >> 2] = u;
                    c[x + 4 >> 2] = v;
                    if ((r | 0) == 8) {
                        n = -1;
                        y = 22;
                        break
                    }
                    v = Mb(c[q >> 2] | 0) | 0;
                    if ((v | 0) == -1) {
                        n = -1;
                        y = 22;
                        break
                    }
                    a[w] = v;
                    r = r + 1 | 0
                }
                if ((y | 0) == 14) {
                    c[g >> 2] = a[o] | 0;
                    z = r;
                    break
                } else if ((y | 0) == 22) {
                    i = e;
                    return n | 0
                }
            } else {
                c[g >> 2] = a[f] | 0;
                z = k
            }
        } while (0);
        if (d) {
            d = c[g >> 2] | 0;
            c[b + 48 >> 2] = d;
            n = d;
            i = e;
            return n | 0
        }
        d = b + 32 | 0;
        b = z;
        while (1) {
            if ((b | 0) <= 0) {
                break
            }
            z = b + -1 | 0;
            if ((Qa(a[f + z | 0] | 0, c[d >> 2] | 0) | 0) == -1) {
                n = -1;
                y = 22;
                break
            } else {
                b = z
            }
        }
        if ((y | 0) == 22) {
            i = e;
            return n | 0
        }
        n = c[g >> 2] | 0;
        i = e;
        return n | 0
    }

    function Hd(a) {
        a = a | 0;
        var b = 0;
        b = i;
        c[a >> 2] = 4576;
        Wj(a + 4 | 0);
        i = b;
        return
    }

    function Id(a) {
        a = a | 0;
        var b = 0;
        b = i;
        c[a >> 2] = 4576;
        Wj(a + 4 | 0);
        Om(a);
        i = b;
        return
    }

    function Jd(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0;
        e = i;
        kc[c[(c[b >> 2] | 0) + 24 >> 2] & 63](b) | 0;
        f = Xj(d, 7368) | 0;
        d = f;
        c[b + 36 >> 2] = d;
        a[b + 44 | 0] = (kc[c[(c[f >> 2] | 0) + 28 >> 2] & 63](d) | 0) & 1;
        i = e;
        return
    }

    function Kd(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0;
        b = i;
        i = i + 16 | 0;
        d = b;
        e = b + 8 | 0;
        f = a + 36 | 0;
        g = a + 40 | 0;
        h = d;
        j = d + 8 | 0;
        k = d;
        d = a + 32 | 0;
        while (1) {
            a = c[f >> 2] | 0;
            l = uc[c[(c[a >> 2] | 0) + 20 >> 2] & 15](a, c[g >> 2] | 0, h, j, e) | 0;
            a = (c[e >> 2] | 0) - k | 0;
            if ((Ub(h | 0, 1, a | 0, c[d >> 2] | 0) | 0) != (a | 0)) {
                m = -1;
                n = 5;
                break
            }
            if ((l | 0) == 2) {
                m = -1;
                n = 5;
                break
            } else if ((l | 0) != 1) {
                n = 4;
                break
            }
        }
        if ((n | 0) == 4) {
            m = ((Ya(c[d >> 2] | 0) | 0) != 0) << 31 >> 31;
            i = b;
            return m | 0
        } else if ((n | 0) == 5) {
            i = b;
            return m | 0
        }
        return 0
    }

    function Ld(b, e, f) {
        b = b | 0;
        e = e | 0;
        f = f | 0;
        var g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0;
        g = i;
        if ((a[b + 44 | 0] | 0) != 0) {
            h = Ub(e | 0, 1, f | 0, c[b + 32 >> 2] | 0) | 0;
            i = g;
            return h | 0
        }
        j = b;
        if ((f | 0) > 0) {
            k = e;
            l = 0
        } else {
            h = 0;
            i = g;
            return h | 0
        }
        while (1) {
            if ((tc[c[(c[j >> 2] | 0) + 52 >> 2] & 15](b, d[k] | 0) | 0) == -1) {
                h = l;
                m = 6;
                break
            }
            e = l + 1 | 0;
            if ((e | 0) < (f | 0)) {
                k = k + 1 | 0;
                l = e
            } else {
                h = e;
                m = 6;
                break
            }
        }
        if ((m | 0) == 6) {
            i = g;
            return h | 0
        }
        return 0
    }

    function Md(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0;
        e = i;
        i = i + 32 | 0;
        f = e;
        g = e + 8 | 0;
        h = e + 16 | 0;
        j = e + 24 | 0;
        k = (d | 0) == -1;
        a: do {
            if (!k) {
                a[g] = d;
                if ((a[b + 44 | 0] | 0) != 0) {
                    if ((Ub(g | 0, 1, 1, c[b + 32 >> 2] | 0) | 0) == 1) {
                        break
                    } else {
                        l = -1
                    }
                    i = e;
                    return l | 0
                }
                m = f;
                c[h >> 2] = m;
                n = g + 1 | 0;
                o = b + 36 | 0;
                p = b + 40 | 0;
                q = f + 8 | 0;
                r = f;
                s = b + 32 | 0;
                t = g;
                while (1) {
                    u = c[o >> 2] | 0;
                    v = pc[c[(c[u >> 2] | 0) + 12 >> 2] & 15](u, c[p >> 2] | 0, t, n, j, m, q, h) | 0;
                    if ((c[j >> 2] | 0) == (t | 0)) {
                        l = -1;
                        w = 12;
                        break
                    }
                    if ((v | 0) == 3) {
                        w = 7;
                        break
                    }
                    u = (v | 0) == 1;
                    if (!(v >>> 0 < 2)) {
                        l = -1;
                        w = 12;
                        break
                    }
                    v = (c[h >> 2] | 0) - r | 0;
                    if ((Ub(m | 0, 1, v | 0, c[s >> 2] | 0) | 0) != (v | 0)) {
                        l = -1;
                        w = 12;
                        break
                    }
                    if (u) {
                        t = u ? c[j >> 2] | 0 : t
                    } else {
                        break a
                    }
                }
                if ((w | 0) == 7) {
                    if ((Ub(t | 0, 1, 1, c[s >> 2] | 0) | 0) == 1) {
                        break
                    } else {
                        l = -1
                    }
                    i = e;
                    return l | 0
                } else if ((w | 0) == 12) {
                    i = e;
                    return l | 0
                }
            }
        } while (0);
        l = k ? 0 : d;
        i = e;
        return l | 0
    }

    function Nd(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0;
        f = i;
        i = i + 8 | 0;
        g = f;
        h = b;
        c[h >> 2] = 4576;
        j = b + 4 | 0;
        Uj(j);
        k = b + 8 | 0;
        c[k + 0 >> 2] = 0;
        c[k + 4 >> 2] = 0;
        c[k + 8 >> 2] = 0;
        c[k + 12 >> 2] = 0;
        c[k + 16 >> 2] = 0;
        c[k + 20 >> 2] = 0;
        c[h >> 2] = 4008;
        c[b + 32 >> 2] = d;
        c[b + 40 >> 2] = e;
        c[b + 48 >> 2] = -1;
        a[b + 52 | 0] = 0;
        Vj(g, j);
        j = Xj(g, 7368) | 0;
        e = j;
        d = b + 36 | 0;
        c[d >> 2] = e;
        h = b + 44 | 0;
        c[h >> 2] = kc[c[(c[j >> 2] | 0) + 24 >> 2] & 63](e) | 0;
        e = c[d >> 2] | 0;
        a[b + 53 | 0] = (kc[c[(c[e >> 2] | 0) + 28 >> 2] & 63](e) | 0) & 1;
        if ((c[h >> 2] | 0) > 8) {
            fj(3848)
        } else {
            Wj(g);
            i = f;
            return
        }
    }

    function Od(a) {
        a = a | 0;
        var b = 0;
        b = i;
        c[a >> 2] = 4576;
        Wj(a + 4 | 0);
        i = b;
        return
    }

    function Pd(a) {
        a = a | 0;
        var b = 0;
        b = i;
        c[a >> 2] = 4576;
        Wj(a + 4 | 0);
        Om(a);
        i = b;
        return
    }

    function Qd(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0;
        e = i;
        f = Xj(d, 7368) | 0;
        d = f;
        g = b + 36 | 0;
        c[g >> 2] = d;
        h = b + 44 | 0;
        c[h >> 2] = kc[c[(c[f >> 2] | 0) + 24 >> 2] & 63](d) | 0;
        d = c[g >> 2] | 0;
        a[b + 53 | 0] = (kc[c[(c[d >> 2] | 0) + 28 >> 2] & 63](d) | 0) & 1;
        if ((c[h >> 2] | 0) > 8) {
            fj(3848)
        } else {
            i = e;
            return
        }
    }

    function Rd(a) {
        a = a | 0;
        var b = 0,
            c = 0;
        b = i;
        c = Ud(a, 0) | 0;
        i = b;
        return c | 0
    }

    function Sd(a) {
        a = a | 0;
        var b = 0,
            c = 0;
        b = i;
        c = Ud(a, 1) | 0;
        i = b;
        return c | 0
    }

    function Td(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0;
        e = i;
        i = i + 32 | 0;
        f = e;
        g = e + 8 | 0;
        h = e + 16 | 0;
        j = e + 24 | 0;
        k = b + 52 | 0;
        l = (a[k] | 0) != 0;
        if ((d | 0) == -1) {
            if (l) {
                m = -1;
                i = e;
                return m | 0
            }
            n = c[b + 48 >> 2] | 0;
            a[k] = (n | 0) != -1 | 0;
            m = n;
            i = e;
            return m | 0
        }
        n = b + 48 | 0;
        a: do {
            if (l) {
                a[h] = c[n >> 2];
                o = c[b + 36 >> 2] | 0;
                p = f;
                q = pc[c[(c[o >> 2] | 0) + 12 >> 2] & 15](o, c[b + 40 >> 2] | 0, h, h + 1 | 0, j, p, f + 8 | 0, g) | 0;
                if ((q | 0) == 3) {
                    a[p] = c[n >> 2];
                    c[g >> 2] = f + 1
                } else if ((q | 0) == 1 | (q | 0) == 2) {
                    m = -1;
                    i = e;
                    return m | 0
                }
                q = b + 32 | 0;
                while (1) {
                    o = c[g >> 2] | 0;
                    if (!(o >>> 0 > p >>> 0)) {
                        break a
                    }
                    r = o + -1 | 0;
                    c[g >> 2] = r;
                    if ((Qa(a[r] | 0, c[q >> 2] | 0) | 0) == -1) {
                        m = -1;
                        break
                    }
                }
                i = e;
                return m | 0
            }
        } while (0);
        c[n >> 2] = d;
        a[k] = 1;
        m = d;
        i = e;
        return m | 0
    }

    function Ud(b, e) {
        b = b | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0;
        f = i;
        i = i + 32 | 0;
        g = f;
        h = f + 8 | 0;
        j = f + 16 | 0;
        k = f + 24 | 0;
        l = b + 52 | 0;
        if ((a[l] | 0) != 0) {
            m = b + 48 | 0;
            n = c[m >> 2] | 0;
            if (!e) {
                o = n;
                i = f;
                return o | 0
            }
            c[m >> 2] = -1;
            a[l] = 0;
            o = n;
            i = f;
            return o | 0
        }
        n = c[b + 44 >> 2] | 0;
        l = (n | 0) > 1 ? n : 1;
        a: do {
            if ((l | 0) > 0) {
                n = b + 32 | 0;
                m = 0;
                while (1) {
                    p = Mb(c[n >> 2] | 0) | 0;
                    if ((p | 0) == -1) {
                        o = -1;
                        break
                    }
                    a[g + m | 0] = p;
                    m = m + 1 | 0;
                    if ((m | 0) >= (l | 0)) {
                        break a
                    }
                }
                i = f;
                return o | 0
            }
        } while (0);
        b: do {
            if ((a[b + 53 | 0] | 0) == 0) {
                m = b + 40 | 0;
                n = b + 36 | 0;
                p = g;
                q = h + 1 | 0;
                r = b + 32 | 0;
                s = l;
                while (1) {
                    t = c[m >> 2] | 0;
                    u = t;
                    v = c[u >> 2] | 0;
                    w = c[u + 4 >> 2] | 0;
                    u = c[n >> 2] | 0;
                    x = g + s | 0;
                    y = pc[c[(c[u >> 2] | 0) + 16 >> 2] & 15](u, t, p, x, j, h, q, k) | 0;
                    if ((y | 0) == 3) {
                        z = 14;
                        break
                    } else if ((y | 0) == 2) {
                        o = -1;
                        z = 23;
                        break
                    } else if ((y | 0) != 1) {
                        A = s;
                        break b
                    }
                    y = c[m >> 2] | 0;
                    c[y >> 2] = v;
                    c[y + 4 >> 2] = w;
                    if ((s | 0) == 8) {
                        o = -1;
                        z = 23;
                        break
                    }
                    w = Mb(c[r >> 2] | 0) | 0;
                    if ((w | 0) == -1) {
                        o = -1;
                        z = 23;
                        break
                    }
                    a[x] = w;
                    s = s + 1 | 0
                }
                if ((z | 0) == 14) {
                    a[h] = a[p] | 0;
                    A = s;
                    break
                } else if ((z | 0) == 23) {
                    i = f;
                    return o | 0
                }
            } else {
                a[h] = a[g] | 0;
                A = l
            }
        } while (0);
        do {
            if (e) {
                l = a[h] | 0;
                c[b + 48 >> 2] = l & 255;
                B = l
            } else {
                l = b + 32 | 0;
                k = A;
                while (1) {
                    if ((k | 0) <= 0) {
                        z = 21;
                        break
                    }
                    j = k + -1 | 0;
                    if ((Qa(d[g + j | 0] | 0, c[l >> 2] | 0) | 0) == -1) {
                        o = -1;
                        z = 23;
                        break
                    } else {
                        k = j
                    }
                }
                if ((z | 0) == 21) {
                    B = a[h] | 0;
                    break
                } else if ((z | 0) == 23) {
                    i = f;
                    return o | 0
                }
            }
        } while (0);
        o = B & 255;
        i = f;
        return o | 0
    }

    function Vd() {
        var a = 0;
        a = i;
        rd(0);
        Zb(112, 3272, p | 0) | 0;
        i = a;
        return
    }

    function Wd(a) {
        a = a | 0;
        i = i;
        return
    }

    function Xd(a) {
        a = a | 0;
        var b = 0;
        b = a + 4 | 0;
        c[b >> 2] = (c[b >> 2] | 0) + 1;
        i = i;
        return
    }

    function Yd(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0,
            f = 0;
        b = i;
        d = a + 4 | 0;
        e = c[d >> 2] | 0;
        c[d >> 2] = e + -1;
        if ((e | 0) != 0) {
            f = 0;
            i = b;
            return f | 0
        }
        hc[c[(c[a >> 2] | 0) + 8 >> 2] & 127](a);
        f = 1;
        i = b;
        return f | 0
    }

    function Zd(a, b) {
        a = a | 0;
        b = b | 0;
        var d = 0,
            e = 0,
            f = 0,
            g = 0;
        d = i;
        c[a >> 2] = 4152;
        e = hn(b | 0) | 0;
        f = Nm(e + 13 | 0) | 0;
        c[f + 4 >> 2] = e;
        c[f >> 2] = e;
        g = f + 12 | 0;
        c[a + 4 >> 2] = g;
        c[f + 8 >> 2] = 0;
        fn(g | 0, b | 0, e + 1 | 0) | 0;
        i = d;
        return
    }

    function _d(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0,
            f = 0;
        b = i;
        c[a >> 2] = 4152;
        d = a + 4 | 0;
        e = (c[d >> 2] | 0) + -4 | 0;
        f = c[e >> 2] | 0;
        c[e >> 2] = f + -1;
        if ((f + -1 | 0) < 0) {
            Pm((c[d >> 2] | 0) + -12 | 0)
        }
        Kb(a | 0);
        Om(a);
        i = b;
        return
    }

    function $d(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0,
            f = 0,
            g = 0;
        b = i;
        c[a >> 2] = 4152;
        d = a + 4 | 0;
        e = (c[d >> 2] | 0) + -4 | 0;
        f = c[e >> 2] | 0;
        c[e >> 2] = f + -1;
        if ((f + -1 | 0) >= 0) {
            g = a;
            Kb(g | 0);
            i = b;
            return
        }
        Pm((c[d >> 2] | 0) + -12 | 0);
        g = a;
        Kb(g | 0);
        i = b;
        return
    }

    function ae(a) {
        a = a | 0;
        i = i;
        return c[a + 4 >> 2] | 0
    }

    function be(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0;
        e = i;
        c[b >> 2] = 4176;
        if ((a[d] & 1) == 0) {
            f = d + 1 | 0
        } else {
            f = c[d + 8 >> 2] | 0
        }
        d = hn(f | 0) | 0;
        g = Nm(d + 13 | 0) | 0;
        c[g + 4 >> 2] = d;
        c[g >> 2] = d;
        h = g + 12 | 0;
        c[b + 4 >> 2] = h;
        c[g + 8 >> 2] = 0;
        fn(h | 0, f | 0, d + 1 | 0) | 0;
        i = e;
        return
    }

    function ce(a, b) {
        a = a | 0;
        b = b | 0;
        var d = 0,
            e = 0,
            f = 0,
            g = 0;
        d = i;
        c[a >> 2] = 4176;
        e = hn(b | 0) | 0;
        f = Nm(e + 13 | 0) | 0;
        c[f + 4 >> 2] = e;
        c[f >> 2] = e;
        g = f + 12 | 0;
        c[a + 4 >> 2] = g;
        c[f + 8 >> 2] = 0;
        fn(g | 0, b | 0, e + 1 | 0) | 0;
        i = d;
        return
    }

    function de(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0,
            f = 0;
        b = i;
        c[a >> 2] = 4176;
        d = a + 4 | 0;
        e = (c[d >> 2] | 0) + -4 | 0;
        f = c[e >> 2] | 0;
        c[e >> 2] = f + -1;
        if ((f + -1 | 0) < 0) {
            Pm((c[d >> 2] | 0) + -12 | 0)
        }
        Kb(a | 0);
        Om(a);
        i = b;
        return
    }

    function ee(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0,
            f = 0,
            g = 0;
        b = i;
        c[a >> 2] = 4176;
        d = a + 4 | 0;
        e = (c[d >> 2] | 0) + -4 | 0;
        f = c[e >> 2] | 0;
        c[e >> 2] = f + -1;
        if ((f + -1 | 0) >= 0) {
            g = a;
            Kb(g | 0);
            i = b;
            return
        }
        Pm((c[d >> 2] | 0) + -12 | 0);
        g = a;
        Kb(g | 0);
        i = b;
        return
    }

    function fe(a) {
        a = a | 0;
        i = i;
        return c[a + 4 >> 2] | 0
    }

    function ge(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0,
            f = 0;
        b = i;
        c[a >> 2] = 4152;
        d = a + 4 | 0;
        e = (c[d >> 2] | 0) + -4 | 0;
        f = c[e >> 2] | 0;
        c[e >> 2] = f + -1;
        if ((f + -1 | 0) < 0) {
            Pm((c[d >> 2] | 0) + -12 | 0)
        }
        Kb(a | 0);
        Om(a);
        i = b;
        return
    }

    function he(a) {
        a = a | 0;
        i = i;
        return
    }

    function ie(a, b, d) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        c[a >> 2] = d;
        c[a + 4 >> 2] = b;
        i = i;
        return
    }

    function je(a, b, d) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0;
        e = i;
        i = i + 8 | 0;
        f = e;
        mc[c[(c[a >> 2] | 0) + 12 >> 2] & 3](f, a, b);
        if ((c[f + 4 >> 2] | 0) != (c[d + 4 >> 2] | 0)) {
            g = 0;
            i = e;
            return g | 0
        }
        g = (c[f >> 2] | 0) == (c[d >> 2] | 0);
        i = e;
        return g | 0
    }

    function ke(a, b, d) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0;
        e = i;
        if ((c[b + 4 >> 2] | 0) != (a | 0)) {
            f = 0;
            i = e;
            return f | 0
        }
        f = (c[b >> 2] | 0) == (d | 0);
        i = e;
        return f | 0
    }

    function le(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0;
        d = i;
        f = Xb(e | 0) | 0;
        e = hn(f | 0) | 0;
        if (e >>> 0 > 4294967279) {
            re(0)
        }
        if (e >>> 0 < 11) {
            a[b] = e << 1;
            g = b + 1 | 0;
            fn(g | 0, f | 0, e | 0) | 0;
            h = g + e | 0;
            a[h] = 0;
            i = d;
            return
        } else {
            j = e + 16 & -16;
            k = Mm(j) | 0;
            c[b + 8 >> 2] = k;
            c[b >> 2] = j | 1;
            c[b + 4 >> 2] = e;
            g = k;
            fn(g | 0, f | 0, e | 0) | 0;
            h = g + e | 0;
            a[h] = 0;
            i = d;
            return
        }
    }

    function me(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0;
        f = i;
        i = i + 16 | 0;
        g = f;
        h = d;
        j = c[h >> 2] | 0;
        k = e;
        do {
            if ((j | 0) != 0) {
                l = a[k] | 0;
                if ((l & 1) == 0) {
                    m = (l & 255) >>> 1
                } else {
                    m = c[e + 4 >> 2] | 0
                } if ((m | 0) == 0) {
                    n = j
                } else {
                    Be(e, 4328, 2) | 0;
                    n = c[h >> 2] | 0
                }
                l = c[d + 4 >> 2] | 0;
                mc[c[(c[l >> 2] | 0) + 24 >> 2] & 3](g, l, n);
                l = g;
                o = a[l] | 0;
                if ((o & 1) == 0) {
                    p = g + 1 | 0;
                    q = (o & 255) >>> 1
                } else {
                    p = c[g + 8 >> 2] | 0;
                    q = c[g + 4 >> 2] | 0
                }
                Be(e, p, q) | 0;
                if ((a[l] & 1) == 0) {
                    break
                }
                Om(c[g + 8 >> 2] | 0)
            }
        } while (0);
        g = b;
        c[g + 0 >> 2] = c[k + 0 >> 2];
        c[g + 4 >> 2] = c[k + 4 >> 2];
        c[g + 8 >> 2] = c[k + 8 >> 2];
        c[k + 0 >> 2] = 0;
        c[k + 4 >> 2] = 0;
        c[k + 8 >> 2] = 0;
        i = f;
        return
    }

    function ne(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0;
        f = i;
        i = i + 32 | 0;
        g = f;
        h = f + 16 | 0;
        j = hn(e | 0) | 0;
        if (j >>> 0 > 4294967279) {
            re(0)
        }
        if (j >>> 0 < 11) {
            a[h] = j << 1;
            k = h + 1 | 0
        } else {
            l = j + 16 & -16;
            m = Mm(l) | 0;
            c[h + 8 >> 2] = m;
            c[h >> 2] = l | 1;
            c[h + 4 >> 2] = j;
            k = m
        }
        fn(k | 0, e | 0, j | 0) | 0;
        a[k + j | 0] = 0;
        me(g, d, h);
        be(b, g);
        if (!((a[g] & 1) == 0)) {
            Om(c[g + 8 >> 2] | 0)
        }
        if (!((a[h] & 1) == 0)) {
            Om(c[h + 8 >> 2] | 0)
        }
        c[b >> 2] = 4344;
        h = d;
        d = c[h + 4 >> 2] | 0;
        g = b + 8 | 0;
        c[g >> 2] = c[h >> 2];
        c[g + 4 >> 2] = d;
        i = f;
        return
    }

    function oe(a) {
        a = a | 0;
        var b = 0;
        b = i;
        ee(a);
        Om(a);
        i = b;
        return
    }

    function pe(a) {
        a = a | 0;
        var b = 0;
        b = i;
        ee(a);
        i = b;
        return
    }

    function qe(a, b, d) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        var e = 0;
        e = i;
        cb(4480) | 0;
        if ((c[a >> 2] | 0) == 1) {
            do {
                Da(4504, 4480) | 0;
            } while ((c[a >> 2] | 0) == 1)
        }
        if ((c[a >> 2] | 0) == 0) {
            c[a >> 2] = 1;
            zb(4480) | 0;
            hc[d & 127](b);
            cb(4480) | 0;
            c[a >> 2] = -1;
            zb(4480) | 0;
            Qb(4504) | 0;
            i = e;
            return
        } else {
            zb(4480) | 0;
            i = e;
            return
        }
    }

    function re(a) {
        a = a | 0;
        a = Ta(8) | 0;
        Zd(a, 4552);
        c[a >> 2] = 4232;
        Vb(a | 0, 4272, 9)
    }

    function se(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0;
        e = i;
        f = d;
        if ((a[f] & 1) == 0) {
            g = b;
            c[g + 0 >> 2] = c[f + 0 >> 2];
            c[g + 4 >> 2] = c[f + 4 >> 2];
            c[g + 8 >> 2] = c[f + 8 >> 2];
            i = e;
            return
        }
        f = c[d + 8 >> 2] | 0;
        g = c[d + 4 >> 2] | 0;
        if (g >>> 0 > 4294967279) {
            re(0)
        }
        if (g >>> 0 < 11) {
            a[b] = g << 1;
            h = b + 1 | 0
        } else {
            d = g + 16 & -16;
            j = Mm(d) | 0;
            c[b + 8 >> 2] = j;
            c[b >> 2] = d | 1;
            c[b + 4 >> 2] = g;
            h = j
        }
        fn(h | 0, f | 0, g | 0) | 0;
        a[h + g | 0] = 0;
        i = e;
        return
    }

    function te(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0;
        f = i;
        if (e >>> 0 > 4294967279) {
            re(0)
        }
        if (e >>> 0 < 11) {
            a[b] = e << 1;
            g = b + 1 | 0
        } else {
            h = e + 16 & -16;
            j = Mm(h) | 0;
            c[b + 8 >> 2] = j;
            c[b >> 2] = h | 1;
            c[b + 4 >> 2] = e;
            g = j
        }
        fn(g | 0, d | 0, e | 0) | 0;
        a[g + e | 0] = 0;
        i = f;
        return
    }

    function ue(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0;
        f = i;
        if (d >>> 0 > 4294967279) {
            re(0)
        }
        if (d >>> 0 < 11) {
            a[b] = d << 1;
            g = b + 1 | 0
        } else {
            h = d + 16 & -16;
            j = Mm(h) | 0;
            c[b + 8 >> 2] = j;
            c[b >> 2] = h | 1;
            c[b + 4 >> 2] = d;
            g = j
        }
        cn(g | 0, e | 0, d | 0) | 0;
        a[g + d | 0] = 0;
        i = f;
        return
    }

    function ve(b) {
        b = b | 0;
        var d = 0;
        d = i;
        if ((a[b] & 1) == 0) {
            i = d;
            return
        }
        Om(c[b + 8 >> 2] | 0);
        i = d;
        return
    }

    function we(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0;
        e = i;
        f = hn(d | 0) | 0;
        g = b;
        h = a[g] | 0;
        if ((h & 1) == 0) {
            j = h;
            k = 10
        } else {
            h = c[b >> 2] | 0;
            j = h & 255;
            k = (h & -2) + -1 | 0
        }
        h = (j & 1) == 0;
        if (k >>> 0 < f >>> 0) {
            if (h) {
                l = (j & 255) >>> 1
            } else {
                l = c[b + 4 >> 2] | 0
            }
            Ce(b, k, f - k | 0, l, 0, l, f, d);
            i = e;
            return b | 0
        }
        if (h) {
            m = b + 1 | 0
        } else {
            m = c[b + 8 >> 2] | 0
        }
        gn(m | 0, d | 0, f | 0) | 0;
        a[m + f | 0] = 0;
        if ((a[g] & 1) == 0) {
            a[g] = f << 1;
            i = e;
            return b | 0
        } else {
            c[b + 4 >> 2] = f;
            i = e;
            return b | 0
        }
        return 0
    }

    function xe(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0;
        f = i;
        g = b;
        h = a[g] | 0;
        j = (h & 1) == 0;
        if (j) {
            k = (h & 255) >>> 1
        } else {
            k = c[b + 4 >> 2] | 0
        } if (k >>> 0 < d >>> 0) {
            ye(b, d - k | 0, e) | 0;
            i = f;
            return
        }
        if (j) {
            a[b + d + 1 | 0] = 0;
            a[g] = d << 1;
            i = f;
            return
        } else {
            a[(c[b + 8 >> 2] | 0) + d | 0] = 0;
            c[b + 4 >> 2] = d;
            i = f;
            return
        }
    }

    function ye(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0;
        f = i;
        if ((d | 0) == 0) {
            i = f;
            return b | 0
        }
        g = b;
        h = a[g] | 0;
        if ((h & 1) == 0) {
            j = h;
            k = 10
        } else {
            h = c[b >> 2] | 0;
            j = h & 255;
            k = (h & -2) + -1 | 0
        } if ((j & 1) == 0) {
            l = (j & 255) >>> 1
        } else {
            l = c[b + 4 >> 2] | 0
        } if ((k - l | 0) >>> 0 < d >>> 0) {
            De(b, k, d - k + l | 0, l, l, 0, 0);
            m = a[g] | 0
        } else {
            m = j
        } if ((m & 1) == 0) {
            n = b + 1 | 0
        } else {
            n = c[b + 8 >> 2] | 0
        }
        cn(n + l | 0, e | 0, d | 0) | 0;
        e = l + d | 0;
        if ((a[g] & 1) == 0) {
            a[g] = e << 1
        } else {
            c[b + 4 >> 2] = e
        }
        a[n + e | 0] = 0;
        i = f;
        return b | 0
    }

    function ze(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0;
        e = i;
        if (d >>> 0 > 4294967279) {
            re(0)
        }
        f = b;
        g = a[f] | 0;
        if ((g & 1) == 0) {
            h = g;
            j = 10
        } else {
            g = c[b >> 2] | 0;
            h = g & 255;
            j = (g & -2) + -1 | 0
        } if ((h & 1) == 0) {
            k = (h & 255) >>> 1
        } else {
            k = c[b + 4 >> 2] | 0
        }
        g = k >>> 0 > d >>> 0 ? k : d;
        if (g >>> 0 < 11) {
            l = 10
        } else {
            l = (g + 16 & -16) + -1 | 0
        } if ((l | 0) == (j | 0)) {
            i = e;
            return
        }
        do {
            if ((l | 0) == 10) {
                m = b + 1 | 0;
                n = 0;
                o = c[b + 8 >> 2] | 0;
                p = 1
            } else {
                g = l + 1 | 0;
                if (l >>> 0 > j >>> 0) {
                    q = Mm(g) | 0
                } else {
                    q = Mm(g) | 0
                } if ((h & 1) == 0) {
                    m = q;
                    n = 1;
                    o = b + 1 | 0;
                    p = 0;
                    break
                } else {
                    m = q;
                    n = 1;
                    o = c[b + 8 >> 2] | 0;
                    p = 1;
                    break
                }
            }
        } while (0);
        if ((h & 1) == 0) {
            r = (h & 255) >>> 1
        } else {
            r = c[b + 4 >> 2] | 0
        }
        fn(m | 0, o | 0, r + 1 | 0) | 0;
        if (p) {
            Om(o)
        }
        if (n) {
            c[b >> 2] = l + 1 | 1;
            c[b + 4 >> 2] = k;
            c[b + 8 >> 2] = m;
            i = e;
            return
        } else {
            a[f] = k << 1;
            i = e;
            return
        }
    }

    function Ae(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0;
        e = i;
        f = b;
        g = a[f] | 0;
        h = (g & 1) != 0;
        if (h) {
            j = (c[b >> 2] & -2) + -1 | 0;
            k = c[b + 4 >> 2] | 0
        } else {
            j = 10;
            k = (g & 255) >>> 1
        } if ((k | 0) == (j | 0)) {
            De(b, j, 1, j, j, 0, 0);
            if ((a[f] & 1) == 0) {
                l = 7
            } else {
                l = 8
            }
        } else {
            if (h) {
                l = 8
            } else {
                l = 7
            }
        } if ((l | 0) == 7) {
            a[f] = (k << 1) + 2;
            m = b + 1 | 0;
            n = k + 1 | 0;
            o = m + k | 0;
            a[o] = d;
            p = m + n | 0;
            a[p] = 0;
            i = e;
            return
        } else if ((l | 0) == 8) {
            l = c[b + 8 >> 2] | 0;
            f = k + 1 | 0;
            c[b + 4 >> 2] = f;
            m = l;
            n = f;
            o = m + k | 0;
            a[o] = d;
            p = m + n | 0;
            a[p] = 0;
            i = e;
            return
        }
    }

    function Be(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0;
        f = i;
        g = b;
        h = a[g] | 0;
        if ((h & 1) == 0) {
            j = 10;
            k = h
        } else {
            h = c[b >> 2] | 0;
            j = (h & -2) + -1 | 0;
            k = h & 255
        } if ((k & 1) == 0) {
            l = (k & 255) >>> 1
        } else {
            l = c[b + 4 >> 2] | 0
        } if ((j - l | 0) >>> 0 < e >>> 0) {
            Ce(b, j, e - j + l | 0, l, l, 0, e, d);
            i = f;
            return b | 0
        }
        if ((e | 0) == 0) {
            i = f;
            return b | 0
        }
        if ((k & 1) == 0) {
            m = b + 1 | 0
        } else {
            m = c[b + 8 >> 2] | 0
        }
        fn(m + l | 0, d | 0, e | 0) | 0;
        d = l + e | 0;
        if ((a[g] & 1) == 0) {
            a[g] = d << 1
        } else {
            c[b + 4 >> 2] = d
        }
        a[m + d | 0] = 0;
        i = f;
        return b | 0
    }

    function Ce(b, d, e, f, g, h, j, k) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        var l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0;
        l = i;
        if ((-18 - d | 0) >>> 0 < e >>> 0) {
            re(0)
        }
        if ((a[b] & 1) == 0) {
            m = b + 1 | 0
        } else {
            m = c[b + 8 >> 2] | 0
        }
        do {
            if (d >>> 0 < 2147483623) {
                n = e + d | 0;
                o = d << 1;
                p = n >>> 0 < o >>> 0 ? o : n;
                if (p >>> 0 < 11) {
                    q = 11;
                    break
                }
                q = p + 16 & -16
            } else {
                q = -17
            }
        } while (0);
        e = Mm(q) | 0;
        if ((g | 0) != 0) {
            fn(e | 0, m | 0, g | 0) | 0
        }
        if ((j | 0) != 0) {
            fn(e + g | 0, k | 0, j | 0) | 0
        }
        k = f - h | 0;
        if ((k | 0) != (g | 0)) {
            fn(e + (j + g) | 0, m + (h + g) | 0, k - g | 0) | 0
        }
        if ((d | 0) == 10) {
            r = b + 8 | 0;
            c[r >> 2] = e;
            s = q | 1;
            t = b;
            c[t >> 2] = s;
            u = k + j | 0;
            v = b + 4 | 0;
            c[v >> 2] = u;
            w = e + u | 0;
            a[w] = 0;
            i = l;
            return
        }
        Om(m);
        r = b + 8 | 0;
        c[r >> 2] = e;
        s = q | 1;
        t = b;
        c[t >> 2] = s;
        u = k + j | 0;
        v = b + 4 | 0;
        c[v >> 2] = u;
        w = e + u | 0;
        a[w] = 0;
        i = l;
        return
    }

    function De(b, d, e, f, g, h, j) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        var k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0;
        k = i;
        if ((-17 - d | 0) >>> 0 < e >>> 0) {
            re(0)
        }
        if ((a[b] & 1) == 0) {
            l = b + 1 | 0
        } else {
            l = c[b + 8 >> 2] | 0
        }
        do {
            if (d >>> 0 < 2147483623) {
                m = e + d | 0;
                n = d << 1;
                o = m >>> 0 < n >>> 0 ? n : m;
                if (o >>> 0 < 11) {
                    p = 11;
                    break
                }
                p = o + 16 & -16
            } else {
                p = -17
            }
        } while (0);
        e = Mm(p) | 0;
        if ((g | 0) != 0) {
            fn(e | 0, l | 0, g | 0) | 0
        }
        o = f - h | 0;
        if ((o | 0) != (g | 0)) {
            fn(e + (j + g) | 0, l + (h + g) | 0, o - g | 0) | 0
        }
        if ((d | 0) == 10) {
            q = b + 8 | 0;
            c[q >> 2] = e;
            r = p | 1;
            s = b;
            c[s >> 2] = r;
            i = k;
            return
        }
        Om(l);
        q = b + 8 | 0;
        c[q >> 2] = e;
        r = p | 1;
        s = b;
        c[s >> 2] = r;
        i = k;
        return
    }

    function Ee(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0;
        f = i;
        if (e >>> 0 > 1073741807) {
            re(0)
        }
        if (e >>> 0 < 2) {
            a[b] = e << 1;
            g = b + 4 | 0;
            im(g, d, e) | 0;
            h = g + (e << 2) | 0;
            c[h >> 2] = 0;
            i = f;
            return
        } else {
            j = e + 4 & -4;
            k = Mm(j << 2) | 0;
            c[b + 8 >> 2] = k;
            c[b >> 2] = j | 1;
            c[b + 4 >> 2] = e;
            g = k;
            im(g, d, e) | 0;
            h = g + (e << 2) | 0;
            c[h >> 2] = 0;
            i = f;
            return
        }
    }

    function Fe(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0;
        f = i;
        if (d >>> 0 > 1073741807) {
            re(0)
        }
        if (d >>> 0 < 2) {
            a[b] = d << 1;
            g = b + 4 | 0;
            km(g, e, d) | 0;
            h = g + (d << 2) | 0;
            c[h >> 2] = 0;
            i = f;
            return
        } else {
            j = d + 4 & -4;
            k = Mm(j << 2) | 0;
            c[b + 8 >> 2] = k;
            c[b >> 2] = j | 1;
            c[b + 4 >> 2] = d;
            g = k;
            km(g, e, d) | 0;
            h = g + (d << 2) | 0;
            c[h >> 2] = 0;
            i = f;
            return
        }
    }

    function Ge(b) {
        b = b | 0;
        var d = 0;
        d = i;
        if ((a[b] & 1) == 0) {
            i = d;
            return
        }
        Om(c[b + 8 >> 2] | 0);
        i = d;
        return
    }

    function He(a, b) {
        a = a | 0;
        b = b | 0;
        var c = 0,
            d = 0;
        c = i;
        d = Ie(a, b, hm(b) | 0) | 0;
        i = c;
        return d | 0
    }

    function Ie(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0;
        f = i;
        g = b;
        h = a[g] | 0;
        if ((h & 1) == 0) {
            j = 1;
            k = h
        } else {
            h = c[b >> 2] | 0;
            j = (h & -2) + -1 | 0;
            k = h & 255
        }
        h = (k & 1) == 0;
        if (j >>> 0 < e >>> 0) {
            if (h) {
                l = (k & 255) >>> 1
            } else {
                l = c[b + 4 >> 2] | 0
            }
            Le(b, j, e - j | 0, l, 0, l, e, d);
            i = f;
            return b | 0
        }
        if (h) {
            m = b + 4 | 0
        } else {
            m = c[b + 8 >> 2] | 0
        }
        jm(m, d, e) | 0;
        c[m + (e << 2) >> 2] = 0;
        if ((a[g] & 1) == 0) {
            a[g] = e << 1;
            i = f;
            return b | 0
        } else {
            c[b + 4 >> 2] = e;
            i = f;
            return b | 0
        }
        return 0
    }

    function Je(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0;
        e = i;
        if (d >>> 0 > 1073741807) {
            re(0)
        }
        f = b;
        g = a[f] | 0;
        if ((g & 1) == 0) {
            h = g;
            j = 1
        } else {
            g = c[b >> 2] | 0;
            h = g & 255;
            j = (g & -2) + -1 | 0
        } if ((h & 1) == 0) {
            k = (h & 255) >>> 1
        } else {
            k = c[b + 4 >> 2] | 0
        }
        g = k >>> 0 > d >>> 0 ? k : d;
        if (g >>> 0 < 2) {
            l = 1
        } else {
            l = (g + 4 & -4) + -1 | 0
        } if ((l | 0) == (j | 0)) {
            i = e;
            return
        }
        do {
            if ((l | 0) == 1) {
                m = b + 4 | 0;
                n = 0;
                o = c[b + 8 >> 2] | 0;
                p = 1
            } else {
                g = (l << 2) + 4 | 0;
                if (l >>> 0 > j >>> 0) {
                    q = Mm(g) | 0
                } else {
                    q = Mm(g) | 0
                }
                g = q;
                if ((h & 1) == 0) {
                    m = g;
                    n = 1;
                    o = b + 4 | 0;
                    p = 0;
                    break
                } else {
                    m = g;
                    n = 1;
                    o = c[b + 8 >> 2] | 0;
                    p = 1;
                    break
                }
            }
        } while (0);
        if ((h & 1) == 0) {
            r = (h & 255) >>> 1
        } else {
            r = c[b + 4 >> 2] | 0
        }
        im(m, o, r + 1 | 0) | 0;
        if (p) {
            Om(o)
        }
        if (n) {
            c[b >> 2] = l + 1 | 1;
            c[b + 4 >> 2] = k;
            c[b + 8 >> 2] = m;
            i = e;
            return
        } else {
            a[f] = k << 1;
            i = e;
            return
        }
    }

    function Ke(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0;
        e = i;
        f = b;
        g = a[f] | 0;
        h = (g & 1) != 0;
        if (h) {
            j = (c[b >> 2] & -2) + -1 | 0;
            k = c[b + 4 >> 2] | 0
        } else {
            j = 1;
            k = (g & 255) >>> 1
        } if ((k | 0) == (j | 0)) {
            Me(b, j, 1, j, j, 0, 0);
            if ((a[f] & 1) == 0) {
                l = 7
            } else {
                l = 8
            }
        } else {
            if (h) {
                l = 8
            } else {
                l = 7
            }
        } if ((l | 0) == 7) {
            a[f] = (k << 1) + 2;
            m = b + 4 | 0;
            n = k + 1 | 0;
            o = m + (k << 2) | 0;
            c[o >> 2] = d;
            p = m + (n << 2) | 0;
            c[p >> 2] = 0;
            i = e;
            return
        } else if ((l | 0) == 8) {
            l = c[b + 8 >> 2] | 0;
            f = k + 1 | 0;
            c[b + 4 >> 2] = f;
            m = l;
            n = f;
            o = m + (k << 2) | 0;
            c[o >> 2] = d;
            p = m + (n << 2) | 0;
            c[p >> 2] = 0;
            i = e;
            return
        }
    }

    function Le(b, d, e, f, g, h, j, k) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        var l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0;
        l = i;
        if ((1073741806 - d | 0) >>> 0 < e >>> 0) {
            re(0)
        }
        if ((a[b] & 1) == 0) {
            m = b + 4 | 0
        } else {
            m = c[b + 8 >> 2] | 0
        }
        do {
            if (d >>> 0 < 536870887) {
                n = e + d | 0;
                o = d << 1;
                p = n >>> 0 < o >>> 0 ? o : n;
                if (p >>> 0 < 2) {
                    q = 2;
                    break
                }
                q = p + 4 & -4
            } else {
                q = 1073741807
            }
        } while (0);
        e = Mm(q << 2) | 0;
        if ((g | 0) != 0) {
            im(e, m, g) | 0
        }
        if ((j | 0) != 0) {
            im(e + (g << 2) | 0, k, j) | 0
        }
        k = f - h | 0;
        if ((k | 0) != (g | 0)) {
            im(e + (j + g << 2) | 0, m + (h + g << 2) | 0, k - g | 0) | 0
        }
        if ((d | 0) == 1) {
            r = b + 8 | 0;
            c[r >> 2] = e;
            s = q | 1;
            t = b;
            c[t >> 2] = s;
            u = k + j | 0;
            v = b + 4 | 0;
            c[v >> 2] = u;
            w = e + (u << 2) | 0;
            c[w >> 2] = 0;
            i = l;
            return
        }
        Om(m);
        r = b + 8 | 0;
        c[r >> 2] = e;
        s = q | 1;
        t = b;
        c[t >> 2] = s;
        u = k + j | 0;
        v = b + 4 | 0;
        c[v >> 2] = u;
        w = e + (u << 2) | 0;
        c[w >> 2] = 0;
        i = l;
        return
    }

    function Me(b, d, e, f, g, h, j) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        var k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0;
        k = i;
        if ((1073741807 - d | 0) >>> 0 < e >>> 0) {
            re(0)
        }
        if ((a[b] & 1) == 0) {
            l = b + 4 | 0
        } else {
            l = c[b + 8 >> 2] | 0
        }
        do {
            if (d >>> 0 < 536870887) {
                m = e + d | 0;
                n = d << 1;
                o = m >>> 0 < n >>> 0 ? n : m;
                if (o >>> 0 < 2) {
                    p = 2;
                    break
                }
                p = o + 4 & -4
            } else {
                p = 1073741807
            }
        } while (0);
        e = Mm(p << 2) | 0;
        if ((g | 0) != 0) {
            im(e, l, g) | 0
        }
        o = f - h | 0;
        if ((o | 0) != (g | 0)) {
            im(e + (j + g << 2) | 0, l + (h + g << 2) | 0, o - g | 0) | 0
        }
        if ((d | 0) == 1) {
            q = b + 8 | 0;
            c[q >> 2] = e;
            r = p | 1;
            s = b;
            c[s >> 2] = r;
            i = k;
            return
        }
        Om(l);
        q = b + 8 | 0;
        c[q >> 2] = e;
        r = p | 1;
        s = b;
        c[s >> 2] = r;
        i = k;
        return
    }

    function Ne(b, d) {
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0;
        e = i;
        i = i + 16 | 0;
        f = e;
        g = e + 8 | 0;
        h = (c[b + 24 >> 2] | 0) == 0;
        if (h) {
            c[b + 16 >> 2] = d | 1
        } else {
            c[b + 16 >> 2] = d
        } if (((h & 1 | d) & c[b + 20 >> 2] | 0) == 0) {
            i = e;
            return
        }
        e = Ta(16) | 0;
        do {
            if ((a[4920] | 0) == 0) {
                if ((Ma(4920) | 0) == 0) {
                    break
                }
                c[1228] = 5616;
                Zb(40, 4912, p | 0) | 0;
                Za(4920)
            }
        } while (0);
        b = e;
        d = g;
        c[d >> 2] = 1;
        c[d + 4 >> 2] = 4912;
        d = f;
        h = g;
        c[d + 0 >> 2] = c[h + 0 >> 2];
        c[d + 4 >> 2] = c[h + 4 >> 2];
        ne(b, f, 4968);
        c[e >> 2] = 4936;
        Vb(e | 0, 5016, 36)
    }

    function Oe(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0,
            f = 0,
            g = 0;
        b = i;
        c[a >> 2] = 4960;
        d = c[a + 40 >> 2] | 0;
        e = a + 32 | 0;
        f = a + 36 | 0;
        if ((d | 0) != 0) {
            g = d;
            do {
                g = g + -1 | 0;
                mc[c[(c[e >> 2] | 0) + (g << 2) >> 2] & 3](0, a, c[(c[f >> 2] | 0) + (g << 2) >> 2] | 0);
            } while ((g | 0) != 0)
        }
        Wj(a + 28 | 0);
        Im(c[e >> 2] | 0);
        Im(c[f >> 2] | 0);
        Im(c[a + 48 >> 2] | 0);
        Im(c[a + 60 >> 2] | 0);
        i = b;
        return
    }

    function Pe(a, b) {
        a = a | 0;
        b = b | 0;
        var c = 0;
        c = i;
        Vj(a, b + 28 | 0);
        i = c;
        return
    }

    function Qe(a, b) {
        a = a | 0;
        b = b | 0;
        var d = 0,
            e = 0;
        d = i;
        c[a + 24 >> 2] = b;
        c[a + 16 >> 2] = (b | 0) == 0;
        c[a + 20 >> 2] = 0;
        c[a + 4 >> 2] = 4098;
        c[a + 12 >> 2] = 0;
        c[a + 8 >> 2] = 6;
        b = a + 28 | 0;
        e = a + 32 | 0;
        a = e + 40 | 0;
        do {
            c[e >> 2] = 0;
            e = e + 4 | 0
        } while ((e | 0) < (a | 0));
        Uj(b);
        i = d;
        return
    }

    function Re(a) {
        a = a | 0;
        var b = 0;
        b = i;
        c[a >> 2] = 4576;
        Wj(a + 4 | 0);
        Om(a);
        i = b;
        return
    }

    function Se(a) {
        a = a | 0;
        var b = 0;
        b = i;
        c[a >> 2] = 4576;
        Wj(a + 4 | 0);
        i = b;
        return
    }

    function Te(a, b) {
        a = a | 0;
        b = b | 0;
        i = i;
        return
    }

    function Ue(a, b, c) {
        a = a | 0;
        b = b | 0;
        c = c | 0;
        i = i;
        return a | 0
    }

    function Ve(a, b, d, e, f, g) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        g = a;
        c[g >> 2] = 0;
        c[g + 4 >> 2] = 0;
        g = a + 8 | 0;
        c[g >> 2] = -1;
        c[g + 4 >> 2] = -1;
        i = i;
        return
    }

    function We(a, b, d, e) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        e = a;
        c[e >> 2] = 0;
        c[e + 4 >> 2] = 0;
        e = a + 8 | 0;
        c[e >> 2] = -1;
        c[e + 4 >> 2] = -1;
        i = i;
        return
    }

    function Xe(a) {
        a = a | 0;
        i = i;
        return 0
    }

    function Ye(a) {
        a = a | 0;
        i = i;
        return 0
    }

    function Ze(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0;
        f = i;
        g = b;
        if ((e | 0) <= 0) {
            h = 0;
            i = f;
            return h | 0
        }
        j = b + 12 | 0;
        k = b + 16 | 0;
        l = d;
        d = 0;
        while (1) {
            m = c[j >> 2] | 0;
            if (m >>> 0 < (c[k >> 2] | 0) >>> 0) {
                c[j >> 2] = m + 1;
                n = a[m] | 0
            } else {
                m = kc[c[(c[g >> 2] | 0) + 40 >> 2] & 63](b) | 0;
                if ((m | 0) == -1) {
                    h = d;
                    o = 8;
                    break
                }
                n = m & 255
            }
            a[l] = n;
            m = d + 1 | 0;
            if ((m | 0) < (e | 0)) {
                l = l + 1 | 0;
                d = m
            } else {
                h = m;
                o = 8;
                break
            }
        }
        if ((o | 0) == 8) {
            i = f;
            return h | 0
        }
        return 0
    }

    function _e(a) {
        a = a | 0;
        i = i;
        return -1
    }

    function $e(a) {
        a = a | 0;
        var b = 0,
            e = 0,
            f = 0;
        b = i;
        if ((kc[c[(c[a >> 2] | 0) + 36 >> 2] & 63](a) | 0) == -1) {
            e = -1;
            i = b;
            return e | 0
        }
        f = a + 12 | 0;
        a = c[f >> 2] | 0;
        c[f >> 2] = a + 1;
        e = d[a] | 0;
        i = b;
        return e | 0
    }

    function af(a, b) {
        a = a | 0;
        b = b | 0;
        i = i;
        return -1
    }

    function bf(b, e, f) {
        b = b | 0;
        e = e | 0;
        f = f | 0;
        var g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0;
        g = i;
        h = b;
        if ((f | 0) <= 0) {
            j = 0;
            i = g;
            return j | 0
        }
        k = b + 24 | 0;
        l = b + 28 | 0;
        m = e;
        e = 0;
        while (1) {
            n = c[k >> 2] | 0;
            if (n >>> 0 < (c[l >> 2] | 0) >>> 0) {
                o = a[m] | 0;
                c[k >> 2] = n + 1;
                a[n] = o
            } else {
                if ((tc[c[(c[h >> 2] | 0) + 52 >> 2] & 15](b, d[m] | 0) | 0) == -1) {
                    j = e;
                    p = 7;
                    break
                }
            }
            o = e + 1 | 0;
            if ((o | 0) < (f | 0)) {
                m = m + 1 | 0;
                e = o
            } else {
                j = o;
                p = 7;
                break
            }
        }
        if ((p | 0) == 7) {
            i = g;
            return j | 0
        }
        return 0
    }

    function cf(a, b) {
        a = a | 0;
        b = b | 0;
        i = i;
        return -1
    }

    function df(a) {
        a = a | 0;
        var b = 0;
        b = i;
        c[a >> 2] = 4640;
        Wj(a + 4 | 0);
        Om(a);
        i = b;
        return
    }

    function ef(a) {
        a = a | 0;
        var b = 0;
        b = i;
        c[a >> 2] = 4640;
        Wj(a + 4 | 0);
        i = b;
        return
    }

    function ff(a, b) {
        a = a | 0;
        b = b | 0;
        i = i;
        return
    }

    function gf(a, b, c) {
        a = a | 0;
        b = b | 0;
        c = c | 0;
        i = i;
        return a | 0
    }

    function hf(a, b, d, e, f, g) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        g = a;
        c[g >> 2] = 0;
        c[g + 4 >> 2] = 0;
        g = a + 8 | 0;
        c[g >> 2] = -1;
        c[g + 4 >> 2] = -1;
        i = i;
        return
    }

    function jf(a, b, d, e) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        e = a;
        c[e >> 2] = 0;
        c[e + 4 >> 2] = 0;
        e = a + 8 | 0;
        c[e >> 2] = -1;
        c[e + 4 >> 2] = -1;
        i = i;
        return
    }

    function kf(a) {
        a = a | 0;
        i = i;
        return 0
    }

    function lf(a) {
        a = a | 0;
        i = i;
        return 0
    }

    function mf(a, b, d) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0;
        e = i;
        f = a;
        if ((d | 0) <= 0) {
            g = 0;
            i = e;
            return g | 0
        }
        h = a + 12 | 0;
        j = a + 16 | 0;
        k = b;
        b = 0;
        while (1) {
            l = c[h >> 2] | 0;
            if (l >>> 0 < (c[j >> 2] | 0) >>> 0) {
                c[h >> 2] = l + 4;
                m = c[l >> 2] | 0
            } else {
                l = kc[c[(c[f >> 2] | 0) + 40 >> 2] & 63](a) | 0;
                if ((l | 0) == -1) {
                    g = b;
                    n = 8;
                    break
                } else {
                    m = l
                }
            }
            c[k >> 2] = m;
            l = b + 1 | 0;
            if ((l | 0) >= (d | 0)) {
                g = l;
                n = 8;
                break
            }
            k = k + 4 | 0;
            b = l
        }
        if ((n | 0) == 8) {
            i = e;
            return g | 0
        }
        return 0
    }

    function nf(a) {
        a = a | 0;
        i = i;
        return -1
    }

    function of(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0;
        b = i;
        if ((kc[c[(c[a >> 2] | 0) + 36 >> 2] & 63](a) | 0) == -1) {
            d = -1;
            i = b;
            return d | 0
        }
        e = a + 12 | 0;
        a = c[e >> 2] | 0;
        c[e >> 2] = a + 4;
        d = c[a >> 2] | 0;
        i = b;
        return d | 0
    }

    function pf(a, b) {
        a = a | 0;
        b = b | 0;
        i = i;
        return -1
    }

    function qf(a, b, d) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0;
        e = i;
        f = a;
        if ((d | 0) <= 0) {
            g = 0;
            i = e;
            return g | 0
        }
        h = a + 24 | 0;
        j = a + 28 | 0;
        k = b;
        b = 0;
        while (1) {
            l = c[h >> 2] | 0;
            if (l >>> 0 < (c[j >> 2] | 0) >>> 0) {
                m = c[k >> 2] | 0;
                c[h >> 2] = l + 4;
                c[l >> 2] = m
            } else {
                if ((tc[c[(c[f >> 2] | 0) + 52 >> 2] & 15](a, c[k >> 2] | 0) | 0) == -1) {
                    g = b;
                    n = 8;
                    break
                }
            }
            m = b + 1 | 0;
            if ((m | 0) >= (d | 0)) {
                g = m;
                n = 8;
                break
            }
            k = k + 4 | 0;
            b = m
        }
        if ((n | 0) == 8) {
            i = e;
            return g | 0
        }
        return 0
    }

    function rf(a, b) {
        a = a | 0;
        b = b | 0;
        i = i;
        return -1
    }

    function sf(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Oe(a + 8 | 0);
        Om(a);
        i = b;
        return
    }

    function tf(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Oe(a + 8 | 0);
        i = b;
        return
    }

    function uf(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0;
        b = i;
        d = a;
        e = c[(c[a >> 2] | 0) + -12 >> 2] | 0;
        Oe(d + (e + 8) | 0);
        Om(d + e | 0);
        i = b;
        return
    }

    function vf(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Oe(a + ((c[(c[a >> 2] | 0) + -12 >> 2] | 0) + 8) | 0);
        i = b;
        return
    }

    function wf(b) {
        b = b | 0;
        var d = 0,
            e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0;
        d = i;
        i = i + 8 | 0;
        e = d;
        f = b;
        g = c[(c[f >> 2] | 0) + -12 >> 2] | 0;
        h = b;
        if ((c[h + (g + 24) >> 2] | 0) == 0) {
            i = d;
            return b | 0
        }
        j = e;
        a[j] = 0;
        c[e + 4 >> 2] = b;
        do {
            if ((c[h + (g + 16) >> 2] | 0) == 0) {
                k = c[h + (g + 72) >> 2] | 0;
                if ((k | 0) == 0) {
                    l = g
                } else {
                    wf(k) | 0;
                    l = c[(c[f >> 2] | 0) + -12 >> 2] | 0
                }
                a[j] = 1;
                k = c[h + (l + 24) >> 2] | 0;
                if (!((kc[c[(c[k >> 2] | 0) + 24 >> 2] & 63](k) | 0) == -1)) {
                    break
                }
                k = c[(c[f >> 2] | 0) + -12 >> 2] | 0;
                Ne(h + k | 0, c[h + (k + 16) >> 2] | 1)
            }
        } while (0);
        Gf(e);
        i = d;
        return b | 0
    }

    function xf(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Oe(a + 8 | 0);
        Om(a);
        i = b;
        return
    }

    function yf(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Oe(a + 8 | 0);
        i = b;
        return
    }

    function zf(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0;
        b = i;
        d = a;
        e = c[(c[a >> 2] | 0) + -12 >> 2] | 0;
        Oe(d + (e + 8) | 0);
        Om(d + e | 0);
        i = b;
        return
    }

    function Af(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Oe(a + ((c[(c[a >> 2] | 0) + -12 >> 2] | 0) + 8) | 0);
        i = b;
        return
    }

    function Bf(b) {
        b = b | 0;
        var d = 0,
            e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0;
        d = i;
        i = i + 8 | 0;
        e = d;
        f = b;
        g = c[(c[f >> 2] | 0) + -12 >> 2] | 0;
        h = b;
        if ((c[h + (g + 24) >> 2] | 0) == 0) {
            i = d;
            return b | 0
        }
        j = e;
        a[j] = 0;
        c[e + 4 >> 2] = b;
        do {
            if ((c[h + (g + 16) >> 2] | 0) == 0) {
                k = c[h + (g + 72) >> 2] | 0;
                if ((k | 0) == 0) {
                    l = g
                } else {
                    Bf(k) | 0;
                    l = c[(c[f >> 2] | 0) + -12 >> 2] | 0
                }
                a[j] = 1;
                k = c[h + (l + 24) >> 2] | 0;
                if (!((kc[c[(c[k >> 2] | 0) + 24 >> 2] & 63](k) | 0) == -1)) {
                    break
                }
                k = c[(c[f >> 2] | 0) + -12 >> 2] | 0;
                Ne(h + k | 0, c[h + (k + 16) >> 2] | 1)
            }
        } while (0);
        Lf(e);
        i = d;
        return b | 0
    }

    function Cf(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Oe(a + 4 | 0);
        Om(a);
        i = b;
        return
    }

    function Df(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Oe(a + 4 | 0);
        i = b;
        return
    }

    function Ef(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0;
        b = i;
        d = a;
        e = c[(c[a >> 2] | 0) + -12 >> 2] | 0;
        Oe(d + (e + 4) | 0);
        Om(d + e | 0);
        i = b;
        return
    }

    function Ff(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Oe(a + ((c[(c[a >> 2] | 0) + -12 >> 2] | 0) + 4) | 0);
        i = b;
        return
    }

    function Gf(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0,
            f = 0;
        b = i;
        d = a + 4 | 0;
        a = c[d >> 2] | 0;
        e = c[(c[a >> 2] | 0) + -12 >> 2] | 0;
        f = a;
        if ((c[f + (e + 24) >> 2] | 0) == 0) {
            i = b;
            return
        }
        if ((c[f + (e + 16) >> 2] | 0) != 0) {
            i = b;
            return
        }
        if ((c[f + (e + 4) >> 2] & 8192 | 0) == 0) {
            i = b;
            return
        }
        if (Ua() | 0) {
            i = b;
            return
        }
        e = c[d >> 2] | 0;
        f = c[e + ((c[(c[e >> 2] | 0) + -12 >> 2] | 0) + 24) >> 2] | 0;
        if (!((kc[c[(c[f >> 2] | 0) + 24 >> 2] & 63](f) | 0) == -1)) {
            i = b;
            return
        }
        f = c[d >> 2] | 0;
        d = c[(c[f >> 2] | 0) + -12 >> 2] | 0;
        e = f;
        Ne(e + d | 0, c[e + (d + 16) >> 2] | 1);
        i = b;
        return
    }

    function Hf(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Oe(a + 4 | 0);
        Om(a);
        i = b;
        return
    }

    function If(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Oe(a + 4 | 0);
        i = b;
        return
    }

    function Jf(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0;
        b = i;
        d = a;
        e = c[(c[a >> 2] | 0) + -12 >> 2] | 0;
        Oe(d + (e + 4) | 0);
        Om(d + e | 0);
        i = b;
        return
    }

    function Kf(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Oe(a + ((c[(c[a >> 2] | 0) + -12 >> 2] | 0) + 4) | 0);
        i = b;
        return
    }

    function Lf(a) {
        a = a | 0;
        var b = 0,
            d = 0,
            e = 0,
            f = 0;
        b = i;
        d = a + 4 | 0;
        a = c[d >> 2] | 0;
        e = c[(c[a >> 2] | 0) + -12 >> 2] | 0;
        f = a;
        if ((c[f + (e + 24) >> 2] | 0) == 0) {
            i = b;
            return
        }
        if ((c[f + (e + 16) >> 2] | 0) != 0) {
            i = b;
            return
        }
        if ((c[f + (e + 4) >> 2] & 8192 | 0) == 0) {
            i = b;
            return
        }
        if (Ua() | 0) {
            i = b;
            return
        }
        e = c[d >> 2] | 0;
        f = c[e + ((c[(c[e >> 2] | 0) + -12 >> 2] | 0) + 24) >> 2] | 0;
        if (!((kc[c[(c[f >> 2] | 0) + 24 >> 2] & 63](f) | 0) == -1)) {
            i = b;
            return
        }
        f = c[d >> 2] | 0;
        d = c[(c[f >> 2] | 0) + -12 >> 2] | 0;
        e = f;
        Ne(e + d | 0, c[e + (d + 16) >> 2] | 1);
        i = b;
        return
    }

    function Mf(a) {
        a = a | 0;
        i = i;
        return 4856
    }

    function Nf(a, b, c) {
        a = a | 0;
        b = b | 0;
        c = c | 0;
        var d = 0;
        d = i;
        if ((c | 0) == 1) {
            te(a, 4872, 35);
            i = d;
            return
        } else {
            le(a, b, c);
            i = d;
            return
        }
    }

    function Of(a) {
        a = a | 0;
        i = i;
        return
    }

    function Pf(a) {
        a = a | 0;
        var b = 0;
        b = i;
        pe(a);
        Om(a);
        i = b;
        return
    }

    function Qf(a) {
        a = a | 0;
        var b = 0;
        b = i;
        pe(a);
        i = b;
        return
    }

    function Rf(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Oe(a);
        Om(a);
        i = b;
        return
    }

    function Sf(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Om(a);
        i = b;
        return
    }

    function Tf(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Om(a);
        i = b;
        return
    }

    function Uf(a) {
        a = a | 0;
        i = i;
        return
    }

    function Vf(a) {
        a = a | 0;
        i = i;
        return
    }

    function Wf(b, c, d, e, f) {
        b = b | 0;
        c = c | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        var g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0;
        b = i;
        a: do {
            if ((e | 0) == (f | 0)) {
                g = c;
                h = 6
            } else {
                j = e;
                k = c;
                while (1) {
                    if ((k | 0) == (d | 0)) {
                        l = -1;
                        break a
                    }
                    m = a[k] | 0;
                    n = a[j] | 0;
                    if (m << 24 >> 24 < n << 24 >> 24) {
                        l = -1;
                        break a
                    }
                    if (n << 24 >> 24 < m << 24 >> 24) {
                        l = 1;
                        break a
                    }
                    m = k + 1 | 0;
                    n = j + 1 | 0;
                    if ((n | 0) == (f | 0)) {
                        g = m;
                        h = 6;
                        break
                    } else {
                        j = n;
                        k = m
                    }
                }
            }
        } while (0);
        if ((h | 0) == 6) {
            l = (g | 0) != (d | 0) | 0
        }
        i = b;
        return l | 0
    }

    function Xf(b, d, e, f) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        var g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0;
        d = i;
        g = e;
        h = f - g | 0;
        if (h >>> 0 > 4294967279) {
            re(b)
        }
        if (h >>> 0 < 11) {
            a[b] = h << 1;
            j = b + 1 | 0
        } else {
            k = h + 16 & -16;
            l = Mm(k) | 0;
            c[b + 8 >> 2] = l;
            c[b >> 2] = k | 1;
            c[b + 4 >> 2] = h;
            j = l
        } if ((e | 0) == (f | 0)) {
            m = j;
            a[m] = 0;
            i = d;
            return
        } else {
            n = e;
            o = j
        }
        while (1) {
            a[o] = a[n] | 0;
            e = n + 1 | 0;
            if ((e | 0) == (f | 0)) {
                break
            } else {
                o = o + 1 | 0;
                n = e
            }
        }
        m = j + (f + (0 - g)) | 0;
        a[m] = 0;
        i = d;
        return
    }

    function Yf(b, c, d) {
        b = b | 0;
        c = c | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0;
        b = i;
        if ((c | 0) == (d | 0)) {
            e = 0;
            i = b;
            return e | 0
        } else {
            f = 0;
            g = c
        }
        while (1) {
            c = (a[g] | 0) + (f << 4) | 0;
            h = c & -268435456;
            j = (h >>> 24 | h) ^ c;
            c = g + 1 | 0;
            if ((c | 0) == (d | 0)) {
                e = j;
                break
            } else {
                g = c;
                f = j
            }
        }
        i = b;
        return e | 0
    }

    function Zf(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Om(a);
        i = b;
        return
    }

    function _f(a) {
        a = a | 0;
        i = i;
        return
    }

    function $f(a, b, d, e, f) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        var g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0;
        a = i;
        a: do {
            if ((e | 0) == (f | 0)) {
                g = b;
                h = 6
            } else {
                j = e;
                k = b;
                while (1) {
                    if ((k | 0) == (d | 0)) {
                        l = -1;
                        break a
                    }
                    m = c[k >> 2] | 0;
                    n = c[j >> 2] | 0;
                    if ((m | 0) < (n | 0)) {
                        l = -1;
                        break a
                    }
                    if ((n | 0) < (m | 0)) {
                        l = 1;
                        break a
                    }
                    m = k + 4 | 0;
                    n = j + 4 | 0;
                    if ((n | 0) == (f | 0)) {
                        g = m;
                        h = 6;
                        break
                    } else {
                        j = n;
                        k = m
                    }
                }
            }
        } while (0);
        if ((h | 0) == 6) {
            l = (g | 0) != (d | 0) | 0
        }
        i = a;
        return l | 0
    }

    function ag(b, d, e, f) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        var g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0;
        d = i;
        g = e;
        h = f - g | 0;
        j = h >> 2;
        if (j >>> 0 > 1073741807) {
            re(b)
        }
        if (j >>> 0 < 2) {
            a[b] = h >>> 1;
            k = b + 4 | 0
        } else {
            h = j + 4 & -4;
            l = Mm(h << 2) | 0;
            c[b + 8 >> 2] = l;
            c[b >> 2] = h | 1;
            c[b + 4 >> 2] = j;
            k = l
        } if ((e | 0) == (f | 0)) {
            m = k;
            c[m >> 2] = 0;
            i = d;
            return
        }
        l = f + -4 + (0 - g) | 0;
        g = e;
        e = k;
        while (1) {
            c[e >> 2] = c[g >> 2];
            j = g + 4 | 0;
            if ((j | 0) == (f | 0)) {
                break
            } else {
                e = e + 4 | 0;
                g = j
            }
        }
        m = k + ((l >>> 2) + 1 << 2) | 0;
        c[m >> 2] = 0;
        i = d;
        return
    }

    function bg(a, b, d) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        var e = 0,
            f = 0,
            g = 0,
            h = 0,
            j = 0;
        a = i;
        if ((b | 0) == (d | 0)) {
            e = 0;
            i = a;
            return e | 0
        } else {
            f = 0;
            g = b
        }
        while (1) {
            b = (c[g >> 2] | 0) + (f << 4) | 0;
            h = b & -268435456;
            j = (h >>> 24 | h) ^ b;
            b = g + 4 | 0;
            if ((b | 0) == (d | 0)) {
                e = j;
                break
            } else {
                g = b;
                f = j
            }
        }
        i = a;
        return e | 0
    }

    function cg(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Om(a);
        i = b;
        return
    }

    function dg(a) {
        a = a | 0;
        i = i;
        return
    }

    function eg(b, d, e, f, g, h, j) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        var k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0;
        k = i;
        i = i + 136 | 0;
        l = k;
        m = k + 8 | 0;
        n = k + 16 | 0;
        o = k + 24 | 0;
        p = k + 40 | 0;
        q = k + 56 | 0;
        r = k + 64 | 0;
        s = k + 72 | 0;
        t = k + 80 | 0;
        u = k + 88 | 0;
        v = k + 96 | 0;
        w = k + 104 | 0;
        x = k + 128 | 0;
        if ((c[g + 4 >> 2] & 1 | 0) == 0) {
            c[q >> 2] = -1;
            y = c[(c[d >> 2] | 0) + 16 >> 2] | 0;
            z = e;
            c[s >> 2] = c[z >> 2];
            c[t >> 2] = c[f >> 2];
            A = n;
            B = s;
            c[A + 0 >> 2] = c[B + 0 >> 2];
            B = m;
            A = t;
            c[B + 0 >> 2] = c[A + 0 >> 2];
            fc[y & 63](r, d, n, m, g, h, q);
            m = c[r >> 2] | 0;
            c[z >> 2] = m;
            z = c[q >> 2] | 0;
            if ((z | 0) == 0) {
                a[j] = 0
            } else if ((z | 0) == 1) {
                a[j] = 1
            } else {
                a[j] = 1;
                c[h >> 2] = 4
            }
            c[b >> 2] = m;
            i = k;
            return
        }
        Pe(u, g);
        m = u;
        u = c[m >> 2] | 0;
        if (!((c[1826] | 0) == -1)) {
            c[p >> 2] = 7304;
            c[p + 4 >> 2] = 113;
            c[p + 8 >> 2] = 0;
            qe(7304, p, 114)
        }
        p = (c[7308 >> 2] | 0) + -1 | 0;
        z = c[u + 8 >> 2] | 0;
        if (!((c[u + 12 >> 2] | 0) - z >> 2 >>> 0 > p >>> 0)) {
            C = Ta(4) | 0;
            D = C;
            mm(D);
            Vb(C | 0, 15264, 101)
        }
        u = c[z + (p << 2) >> 2] | 0;
        if ((u | 0) == 0) {
            C = Ta(4) | 0;
            D = C;
            mm(D);
            Vb(C | 0, 15264, 101)
        }
        C = u;
        Yd(c[m >> 2] | 0) | 0;
        Pe(v, g);
        g = v;
        v = c[g >> 2] | 0;
        if (!((c[1862] | 0) == -1)) {
            c[o >> 2] = 7448;
            c[o + 4 >> 2] = 113;
            c[o + 8 >> 2] = 0;
            qe(7448, o, 114)
        }
        o = (c[7452 >> 2] | 0) + -1 | 0;
        m = c[v + 8 >> 2] | 0;
        if (!((c[v + 12 >> 2] | 0) - m >> 2 >>> 0 > o >>> 0)) {
            E = Ta(4) | 0;
            F = E;
            mm(F);
            Vb(E | 0, 15264, 101)
        }
        v = c[m + (o << 2) >> 2] | 0;
        if ((v | 0) == 0) {
            E = Ta(4) | 0;
            F = E;
            mm(F);
            Vb(E | 0, 15264, 101)
        }
        E = v;
        Yd(c[g >> 2] | 0) | 0;
        g = w;
        F = v;
        ic[c[(c[F >> 2] | 0) + 24 >> 2] & 63](g, E);
        ic[c[(c[F >> 2] | 0) + 28 >> 2] & 63](w + 12 | 0, E);
        c[x >> 2] = c[f >> 2];
        f = w + 24 | 0;
        E = l;
        F = x;
        c[E + 0 >> 2] = c[F + 0 >> 2];
        F = fg(e, l, g, f, C, h, 1) | 0;
        a[j] = (F | 0) == (g | 0) | 0;
        c[b >> 2] = c[e >> 2];
        ve(w + 12 | 0);
        ve(w);
        i = k;
        return
    }

    function fg(b, e, f, g, h, j, k) {
        b = b | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        var l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0,
            V = 0,
            W = 0,
            X = 0,
            Y = 0,
            Z = 0,
            _ = 0,
            $ = 0,
            aa = 0,
            ba = 0,
            ca = 0;
        l = i;
        i = i + 104 | 0;
        m = (g - f | 0) / 12 | 0;
        n = l;
        do {
            if (m >>> 0 > 100) {
                o = Hm(m) | 0;
                if ((o | 0) != 0) {
                    p = o;
                    q = o;
                    break
                }
                Tm()
            } else {
                p = 0;
                q = n
            }
        } while (0);
        n = (f | 0) == (g | 0);
        if (n) {
            r = 0;
            s = m
        } else {
            o = f;
            t = 0;
            u = m;
            m = q;
            while (1) {
                v = a[o] | 0;
                if ((v & 1) == 0) {
                    w = (v & 255) >>> 1
                } else {
                    w = c[o + 4 >> 2] | 0
                } if ((w | 0) == 0) {
                    a[m] = 2;
                    x = t + 1 | 0;
                    y = u + -1 | 0
                } else {
                    a[m] = 1;
                    x = t;
                    y = u
                }
                v = o + 12 | 0;
                if ((v | 0) == (g | 0)) {
                    r = x;
                    s = y;
                    break
                } else {
                    o = v;
                    t = x;
                    u = y;
                    m = m + 1 | 0
                }
            }
        }
        m = b;
        b = e;
        e = h;
        y = 0;
        u = r;
        r = s;
        a: while (1) {
            s = c[m >> 2] | 0;
            do {
                if ((s | 0) == 0) {
                    z = 0
                } else {
                    if ((c[s + 12 >> 2] | 0) != (c[s + 16 >> 2] | 0)) {
                        z = s;
                        break
                    }
                    if ((kc[c[(c[s >> 2] | 0) + 36 >> 2] & 63](s) | 0) == -1) {
                        c[m >> 2] = 0;
                        z = 0;
                        break
                    } else {
                        z = c[m >> 2] | 0;
                        break
                    }
                }
            } while (0);
            s = (z | 0) == 0;
            x = c[b >> 2] | 0;
            do {
                if ((x | 0) == 0) {
                    A = 0
                } else {
                    if ((c[x + 12 >> 2] | 0) != (c[x + 16 >> 2] | 0)) {
                        A = x;
                        break
                    }
                    if (!((kc[c[(c[x >> 2] | 0) + 36 >> 2] & 63](x) | 0) == -1)) {
                        A = x;
                        break
                    }
                    c[b >> 2] = 0;
                    A = 0
                }
            } while (0);
            B = (A | 0) == 0;
            C = c[m >> 2] | 0;
            if (!((s ^ B) & (r | 0) != 0)) {
                break
            }
            x = c[C + 12 >> 2] | 0;
            if ((x | 0) == (c[C + 16 >> 2] | 0)) {
                D = kc[c[(c[C >> 2] | 0) + 36 >> 2] & 63](C) | 0
            } else {
                D = d[x] | 0
            }
            x = D & 255;
            if (k) {
                E = x
            } else {
                E = tc[c[(c[e >> 2] | 0) + 12 >> 2] & 15](h, x) | 0
            }
            x = y + 1 | 0;
            if (n) {
                y = x;
                r = r;
                u = u;
                continue
            }
            b: do {
                if (k) {
                    t = 0;
                    o = f;
                    w = u;
                    v = r;
                    F = q;
                    while (1) {
                        do {
                            if ((a[F] | 0) == 1) {
                                G = a[o] | 0;
                                H = (G & 1) == 0;
                                if (H) {
                                    I = o + 1 | 0
                                } else {
                                    I = c[o + 8 >> 2] | 0
                                } if (!(E << 24 >> 24 == (a[I + y | 0] | 0))) {
                                    a[F] = 0;
                                    J = t;
                                    K = w;
                                    L = v + -1 | 0;
                                    break
                                }
                                if (H) {
                                    M = (G & 255) >>> 1
                                } else {
                                    M = c[o + 4 >> 2] | 0
                                } if ((M | 0) != (x | 0)) {
                                    J = 1;
                                    K = w;
                                    L = v;
                                    break
                                }
                                a[F] = 2;
                                J = 1;
                                K = w + 1 | 0;
                                L = v + -1 | 0
                            } else {
                                J = t;
                                K = w;
                                L = v
                            }
                        } while (0);
                        G = o + 12 | 0;
                        if ((G | 0) == (g | 0)) {
                            N = J;
                            O = K;
                            P = L;
                            break b
                        }
                        t = J;
                        o = G;
                        w = K;
                        v = L;
                        F = F + 1 | 0
                    }
                } else {
                    F = 0;
                    v = f;
                    w = u;
                    o = r;
                    t = q;
                    while (1) {
                        do {
                            if ((a[t] | 0) == 1) {
                                G = v;
                                if ((a[G] & 1) == 0) {
                                    Q = v + 1 | 0
                                } else {
                                    Q = c[v + 8 >> 2] | 0
                                } if (!(E << 24 >> 24 == (tc[c[(c[e >> 2] | 0) + 12 >> 2] & 15](h, a[Q + y | 0] | 0) | 0) << 24 >> 24)) {
                                    a[t] = 0;
                                    R = F;
                                    S = w;
                                    T = o + -1 | 0;
                                    break
                                }
                                H = a[G] | 0;
                                if ((H & 1) == 0) {
                                    U = (H & 255) >>> 1
                                } else {
                                    U = c[v + 4 >> 2] | 0
                                } if ((U | 0) != (x | 0)) {
                                    R = 1;
                                    S = w;
                                    T = o;
                                    break
                                }
                                a[t] = 2;
                                R = 1;
                                S = w + 1 | 0;
                                T = o + -1 | 0
                            } else {
                                R = F;
                                S = w;
                                T = o
                            }
                        } while (0);
                        H = v + 12 | 0;
                        if ((H | 0) == (g | 0)) {
                            N = R;
                            O = S;
                            P = T;
                            break b
                        }
                        F = R;
                        v = H;
                        w = S;
                        o = T;
                        t = t + 1 | 0
                    }
                }
            } while (0);
            if (!N) {
                y = x;
                u = O;
                r = P;
                continue
            }
            s = c[m >> 2] | 0;
            t = s + 12 | 0;
            o = c[t >> 2] | 0;
            if ((o | 0) == (c[s + 16 >> 2] | 0)) {
                kc[c[(c[s >> 2] | 0) + 40 >> 2] & 63](s) | 0
            } else {
                c[t >> 2] = o + 1
            } if ((P + O | 0) >>> 0 < 2) {
                y = x;
                u = O;
                r = P;
                continue
            } else {
                V = f;
                W = O;
                X = q
            }
            while (1) {
                do {
                    if ((a[X] | 0) == 2) {
                        o = a[V] | 0;
                        if ((o & 1) == 0) {
                            Y = (o & 255) >>> 1
                        } else {
                            Y = c[V + 4 >> 2] | 0
                        } if ((Y | 0) == (x | 0)) {
                            Z = W;
                            break
                        }
                        a[X] = 0;
                        Z = W + -1 | 0
                    } else {
                        Z = W
                    }
                } while (0);
                o = V + 12 | 0;
                if ((o | 0) == (g | 0)) {
                    y = x;
                    u = Z;
                    r = P;
                    continue a
                } else {
                    V = o;
                    W = Z;
                    X = X + 1 | 0
                }
            }
        }
        do {
            if ((C | 0) == 0) {
                _ = 0
            } else {
                if ((c[C + 12 >> 2] | 0) != (c[C + 16 >> 2] | 0)) {
                    _ = C;
                    break
                }
                if ((kc[c[(c[C >> 2] | 0) + 36 >> 2] & 63](C) | 0) == -1) {
                    c[m >> 2] = 0;
                    _ = 0;
                    break
                } else {
                    _ = c[m >> 2] | 0;
                    break
                }
            }
        } while (0);
        m = (_ | 0) == 0;
        do {
            if (B) {
                $ = 78
            } else {
                if ((c[A + 12 >> 2] | 0) != (c[A + 16 >> 2] | 0)) {
                    if (m) {
                        break
                    } else {
                        $ = 80;
                        break
                    }
                }
                if ((kc[c[(c[A >> 2] | 0) + 36 >> 2] & 63](A) | 0) == -1) {
                    c[b >> 2] = 0;
                    $ = 78;
                    break
                } else {
                    if (m) {
                        break
                    } else {
                        $ = 80;
                        break
                    }
                }
            }
        } while (0);
        if (($ | 0) == 78) {
            if (m) {
                $ = 80
            }
        }
        if (($ | 0) == 80) {
            c[j >> 2] = c[j >> 2] | 2
        }
        c: do {
            if (n) {
                $ = 85
            } else {
                if ((a[q] | 0) == 2) {
                    aa = f;
                    break
                } else {
                    ba = f;
                    ca = q
                }
                while (1) {
                    m = ba + 12 | 0;
                    b = ca + 1 | 0;
                    if ((m | 0) == (g | 0)) {
                        $ = 85;
                        break c
                    }
                    if ((a[b] | 0) == 2) {
                        aa = m;
                        break
                    } else {
                        ca = b;
                        ba = m
                    }
                }
            }
        } while (0);
        if (($ | 0) == 85) {
            c[j >> 2] = c[j >> 2] | 4;
            aa = g
        }
        if ((p | 0) == 0) {
            i = l;
            return aa | 0
        }
        Im(p);
        i = l;
        return aa | 0
    }

    function gg(a, b, d, e, f, g, h) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        var j = 0,
            k = 0,
            l = 0,
            m = 0;
        b = i;
        i = i + 32 | 0;
        j = b;
        k = b + 8 | 0;
        l = b + 16 | 0;
        m = b + 24 | 0;
        c[l >> 2] = c[d >> 2];
        c[m >> 2] = c[e >> 2];
        e = k;
        d = l;
        c[e + 0 >> 2] = c[d + 0 >> 2];
        d = j;
        e = m;
        c[d + 0 >> 2] = c[e + 0 >> 2];
        hg(a, 0, k, j, f, g, h);
        i = b;
        return
    }

    function hg(b, e, f, g, h, j, k) {
        b = b | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        var l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0;
        e = i;
        i = i + 256 | 0;
        l = e;
        m = e + 32 | 0;
        n = e + 40 | 0;
        o = e + 56 | 0;
        p = e + 72 | 0;
        q = e + 80 | 0;
        r = e + 240 | 0;
        s = e + 248 | 0;
        t = c[h + 4 >> 2] & 74;
        if ((t | 0) == 8) {
            u = 16
        } else if ((t | 0) == 0) {
            u = 0
        } else if ((t | 0) == 64) {
            u = 8
        } else {
            u = 10
        }
        t = l;
        Zg(n, h, t, m);
        h = o;
        c[h + 0 >> 2] = 0;
        c[h + 4 >> 2] = 0;
        c[h + 8 >> 2] = 0;
        xe(o, 10, 0);
        if ((a[h] & 1) == 0) {
            l = o + 1 | 0;
            v = l;
            w = o + 8 | 0;
            x = l
        } else {
            l = o + 8 | 0;
            v = o + 1 | 0;
            w = l;
            x = c[l >> 2] | 0
        }
        c[p >> 2] = x;
        l = q;
        c[r >> 2] = l;
        c[s >> 2] = 0;
        y = f;
        f = g;
        g = o;
        z = o + 4 | 0;
        A = a[m] | 0;
        m = c[y >> 2] | 0;
        B = x;
        a: while (1) {
            do {
                if ((m | 0) == 0) {
                    C = 0
                } else {
                    if ((c[m + 12 >> 2] | 0) != (c[m + 16 >> 2] | 0)) {
                        C = m;
                        break
                    }
                    if (!((kc[c[(c[m >> 2] | 0) + 36 >> 2] & 63](m) | 0) == -1)) {
                        C = m;
                        break
                    }
                    c[y >> 2] = 0;
                    C = 0
                }
            } while (0);
            x = (C | 0) == 0;
            D = c[f >> 2] | 0;
            do {
                if ((D | 0) == 0) {
                    E = 18
                } else {
                    if ((c[D + 12 >> 2] | 0) != (c[D + 16 >> 2] | 0)) {
                        if (x) {
                            F = D;
                            break
                        } else {
                            G = D;
                            H = B;
                            break a
                        }
                    }
                    if ((kc[c[(c[D >> 2] | 0) + 36 >> 2] & 63](D) | 0) == -1) {
                        c[f >> 2] = 0;
                        E = 18;
                        break
                    } else {
                        if (x) {
                            F = D;
                            break
                        } else {
                            G = D;
                            H = B;
                            break a
                        }
                    }
                }
            } while (0);
            if ((E | 0) == 18) {
                E = 0;
                if (x) {
                    G = 0;
                    H = B;
                    break
                } else {
                    F = 0
                }
            }
            D = a[h] | 0;
            I = (D & 1) == 0;
            if (I) {
                J = (D & 255) >>> 1
            } else {
                J = c[z >> 2] | 0
            } if (((c[p >> 2] | 0) - B | 0) == (J | 0)) {
                if (I) {
                    K = (D & 255) >>> 1;
                    L = (D & 255) >>> 1
                } else {
                    D = c[z >> 2] | 0;
                    K = D;
                    L = D
                }
                xe(o, L << 1, 0);
                if ((a[h] & 1) == 0) {
                    M = 10
                } else {
                    M = (c[g >> 2] & -2) + -1 | 0
                }
                xe(o, M, 0);
                if ((a[h] & 1) == 0) {
                    N = v
                } else {
                    N = c[w >> 2] | 0
                }
                c[p >> 2] = N + K;
                O = N
            } else {
                O = B
            }
            D = C + 12 | 0;
            I = c[D >> 2] | 0;
            P = C + 16 | 0;
            if ((I | 0) == (c[P >> 2] | 0)) {
                Q = kc[c[(c[C >> 2] | 0) + 36 >> 2] & 63](C) | 0
            } else {
                Q = d[I] | 0
            } if ((zg(Q & 255, u, O, p, s, A, n, l, r, t) | 0) != 0) {
                G = F;
                H = O;
                break
            }
            I = c[D >> 2] | 0;
            if ((I | 0) == (c[P >> 2] | 0)) {
                kc[c[(c[C >> 2] | 0) + 40 >> 2] & 63](C) | 0;
                m = C;
                B = O;
                continue
            } else {
                c[D >> 2] = I + 1;
                m = C;
                B = O;
                continue
            }
        }
        O = a[n] | 0;
        if ((O & 1) == 0) {
            R = (O & 255) >>> 1
        } else {
            R = c[n + 4 >> 2] | 0
        }
        do {
            if ((R | 0) != 0) {
                O = c[r >> 2] | 0;
                if ((O - q | 0) >= 160) {
                    break
                }
                B = c[s >> 2] | 0;
                c[r >> 2] = O + 4;
                c[O >> 2] = B
            }
        } while (0);
        c[k >> 2] = Sl(H, c[p >> 2] | 0, j, u) | 0;
        jj(n, l, c[r >> 2] | 0, j);
        do {
            if ((C | 0) == 0) {
                S = 0
            } else {
                if ((c[C + 12 >> 2] | 0) != (c[C + 16 >> 2] | 0)) {
                    S = C;
                    break
                }
                if (!((kc[c[(c[C >> 2] | 0) + 36 >> 2] & 63](C) | 0) == -1)) {
                    S = C;
                    break
                }
                c[y >> 2] = 0;
                S = 0
            }
        } while (0);
        y = (S | 0) == 0;
        do {
            if ((G | 0) == 0) {
                E = 54
            } else {
                if ((c[G + 12 >> 2] | 0) != (c[G + 16 >> 2] | 0)) {
                    if (!y) {
                        break
                    }
                    T = b;
                    c[T >> 2] = S;
                    ve(o);
                    ve(n);
                    i = e;
                    return
                }
                if ((kc[c[(c[G >> 2] | 0) + 36 >> 2] & 63](G) | 0) == -1) {
                    c[f >> 2] = 0;
                    E = 54;
                    break
                }
                if (!(y ^ (G | 0) == 0)) {
                    break
                }
                T = b;
                c[T >> 2] = S;
                ve(o);
                ve(n);
                i = e;
                return
            }
        } while (0);
        do {
            if ((E | 0) == 54) {
                if (y) {
                    break
                }
                T = b;
                c[T >> 2] = S;
                ve(o);
                ve(n);
                i = e;
                return
            }
        } while (0);
        c[j >> 2] = c[j >> 2] | 2;
        T = b;
        c[T >> 2] = S;
        ve(o);
        ve(n);
        i = e;
        return
    }

    function ig(a, b, d, e, f, g, h) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        var j = 0,
            k = 0,
            l = 0,
            m = 0;
        b = i;
        i = i + 32 | 0;
        j = b;
        k = b + 8 | 0;
        l = b + 16 | 0;
        m = b + 24 | 0;
        c[l >> 2] = c[d >> 2];
        c[m >> 2] = c[e >> 2];
        e = k;
        d = l;
        c[e + 0 >> 2] = c[d + 0 >> 2];
        d = j;
        e = m;
        c[d + 0 >> 2] = c[e + 0 >> 2];
        jg(a, 0, k, j, f, g, h);
        i = b;
        return
    }

    function jg(b, e, f, g, h, j, k) {
        b = b | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        var l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0;
        e = i;
        i = i + 256 | 0;
        l = e;
        m = e + 32 | 0;
        n = e + 40 | 0;
        o = e + 56 | 0;
        p = e + 72 | 0;
        q = e + 80 | 0;
        r = e + 240 | 0;
        s = e + 248 | 0;
        t = c[h + 4 >> 2] & 74;
        if ((t | 0) == 64) {
            u = 8
        } else if ((t | 0) == 0) {
            u = 0
        } else if ((t | 0) == 8) {
            u = 16
        } else {
            u = 10
        }
        t = l;
        Zg(n, h, t, m);
        h = o;
        c[h + 0 >> 2] = 0;
        c[h + 4 >> 2] = 0;
        c[h + 8 >> 2] = 0;
        xe(o, 10, 0);
        if ((a[h] & 1) == 0) {
            l = o + 1 | 0;
            v = l;
            w = o + 8 | 0;
            x = l
        } else {
            l = o + 8 | 0;
            v = o + 1 | 0;
            w = l;
            x = c[l >> 2] | 0
        }
        c[p >> 2] = x;
        l = q;
        c[r >> 2] = l;
        c[s >> 2] = 0;
        y = f;
        f = g;
        g = o;
        z = o + 4 | 0;
        A = a[m] | 0;
        m = c[y >> 2] | 0;
        B = x;
        a: while (1) {
            do {
                if ((m | 0) == 0) {
                    C = 0
                } else {
                    if ((c[m + 12 >> 2] | 0) != (c[m + 16 >> 2] | 0)) {
                        C = m;
                        break
                    }
                    if (!((kc[c[(c[m >> 2] | 0) + 36 >> 2] & 63](m) | 0) == -1)) {
                        C = m;
                        break
                    }
                    c[y >> 2] = 0;
                    C = 0
                }
            } while (0);
            x = (C | 0) == 0;
            D = c[f >> 2] | 0;
            do {
                if ((D | 0) == 0) {
                    E = 18
                } else {
                    if ((c[D + 12 >> 2] | 0) != (c[D + 16 >> 2] | 0)) {
                        if (x) {
                            F = D;
                            break
                        } else {
                            G = D;
                            H = B;
                            break a
                        }
                    }
                    if ((kc[c[(c[D >> 2] | 0) + 36 >> 2] & 63](D) | 0) == -1) {
                        c[f >> 2] = 0;
                        E = 18;
                        break
                    } else {
                        if (x) {
                            F = D;
                            break
                        } else {
                            G = D;
                            H = B;
                            break a
                        }
                    }
                }
            } while (0);
            if ((E | 0) == 18) {
                E = 0;
                if (x) {
                    G = 0;
                    H = B;
                    break
                } else {
                    F = 0
                }
            }
            D = a[h] | 0;
            J = (D & 1) == 0;
            if (J) {
                K = (D & 255) >>> 1
            } else {
                K = c[z >> 2] | 0
            } if (((c[p >> 2] | 0) - B | 0) == (K | 0)) {
                if (J) {
                    L = (D & 255) >>> 1;
                    M = (D & 255) >>> 1
                } else {
                    D = c[z >> 2] | 0;
                    L = D;
                    M = D
                }
                xe(o, M << 1, 0);
                if ((a[h] & 1) == 0) {
                    N = 10
                } else {
                    N = (c[g >> 2] & -2) + -1 | 0
                }
                xe(o, N, 0);
                if ((a[h] & 1) == 0) {
                    O = v
                } else {
                    O = c[w >> 2] | 0
                }
                c[p >> 2] = O + L;
                P = O
            } else {
                P = B
            }
            D = C + 12 | 0;
            J = c[D >> 2] | 0;
            Q = C + 16 | 0;
            if ((J | 0) == (c[Q >> 2] | 0)) {
                R = kc[c[(c[C >> 2] | 0) + 36 >> 2] & 63](C) | 0
            } else {
                R = d[J] | 0
            } if ((zg(R & 255, u, P, p, s, A, n, l, r, t) | 0) != 0) {
                G = F;
                H = P;
                break
            }
            J = c[D >> 2] | 0;
            if ((J | 0) == (c[Q >> 2] | 0)) {
                kc[c[(c[C >> 2] | 0) + 40 >> 2] & 63](C) | 0;
                m = C;
                B = P;
                continue
            } else {
                c[D >> 2] = J + 1;
                m = C;
                B = P;
                continue
            }
        }
        P = a[n] | 0;
        if ((P & 1) == 0) {
            S = (P & 255) >>> 1
        } else {
            S = c[n + 4 >> 2] | 0
        }
        do {
            if ((S | 0) != 0) {
                P = c[r >> 2] | 0;
                if ((P - q | 0) >= 160) {
                    break
                }
                B = c[s >> 2] | 0;
                c[r >> 2] = P + 4;
                c[P >> 2] = B
            }
        } while (0);
        s = Rl(H, c[p >> 2] | 0, j, u) | 0;
        u = k;
        c[u >> 2] = s;
        c[u + 4 >> 2] = I;
        jj(n, l, c[r >> 2] | 0, j);
        do {
            if ((C | 0) == 0) {
                T = 0
            } else {
                if ((c[C + 12 >> 2] | 0) != (c[C + 16 >> 2] | 0)) {
                    T = C;
                    break
                }
                if (!((kc[c[(c[C >> 2] | 0) + 36 >> 2] & 63](C) | 0) == -1)) {
                    T = C;
                    break
                }
                c[y >> 2] = 0;
                T = 0
            }
        } while (0);
        y = (T | 0) == 0;
        do {
            if ((G | 0) == 0) {
                E = 54
            } else {
                if ((c[G + 12 >> 2] | 0) != (c[G + 16 >> 2] | 0)) {
                    if (!y) {
                        break
                    }
                    U = b;
                    c[U >> 2] = T;
                    ve(o);
                    ve(n);
                    i = e;
                    return
                }
                if ((kc[c[(c[G >> 2] | 0) + 36 >> 2] & 63](G) | 0) == -1) {
                    c[f >> 2] = 0;
                    E = 54;
                    break
                }
                if (!(y ^ (G | 0) == 0)) {
                    break
                }
                U = b;
                c[U >> 2] = T;
                ve(o);
                ve(n);
                i = e;
                return
            }
        } while (0);
        do {
            if ((E | 0) == 54) {
                if (y) {
                    break
                }
                U = b;
                c[U >> 2] = T;
                ve(o);
                ve(n);
                i = e;
                return
            }
        } while (0);
        c[j >> 2] = c[j >> 2] | 2;
        U = b;
        c[U >> 2] = T;
        ve(o);
        ve(n);
        i = e;
        return
    }

    function kg(a, b, d, e, f, g, h) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        var j = 0,
            k = 0,
            l = 0,
            m = 0;
        b = i;
        i = i + 32 | 0;
        j = b;
        k = b + 8 | 0;
        l = b + 16 | 0;
        m = b + 24 | 0;
        c[l >> 2] = c[d >> 2];
        c[m >> 2] = c[e >> 2];
        e = k;
        d = l;
        c[e + 0 >> 2] = c[d + 0 >> 2];
        d = j;
        e = m;
        c[d + 0 >> 2] = c[e + 0 >> 2];
        lg(a, 0, k, j, f, g, h);
        i = b;
        return
    }

    function lg(e, f, g, h, j, k, l) {
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        l = l | 0;
        var m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0;
        f = i;
        i = i + 256 | 0;
        m = f;
        n = f + 32 | 0;
        o = f + 40 | 0;
        p = f + 56 | 0;
        q = f + 72 | 0;
        r = f + 80 | 0;
        s = f + 240 | 0;
        t = f + 248 | 0;
        u = c[j + 4 >> 2] & 74;
        if ((u | 0) == 64) {
            v = 8
        } else if ((u | 0) == 8) {
            v = 16
        } else if ((u | 0) == 0) {
            v = 0
        } else {
            v = 10
        }
        u = m;
        Zg(o, j, u, n);
        j = p;
        c[j + 0 >> 2] = 0;
        c[j + 4 >> 2] = 0;
        c[j + 8 >> 2] = 0;
        xe(p, 10, 0);
        if ((a[j] & 1) == 0) {
            m = p + 1 | 0;
            w = m;
            x = p + 8 | 0;
            y = m
        } else {
            m = p + 8 | 0;
            w = p + 1 | 0;
            x = m;
            y = c[m >> 2] | 0
        }
        c[q >> 2] = y;
        m = r;
        c[s >> 2] = m;
        c[t >> 2] = 0;
        z = g;
        g = h;
        h = p;
        A = p + 4 | 0;
        B = a[n] | 0;
        n = c[z >> 2] | 0;
        C = y;
        a: while (1) {
            do {
                if ((n | 0) == 0) {
                    D = 0
                } else {
                    if ((c[n + 12 >> 2] | 0) != (c[n + 16 >> 2] | 0)) {
                        D = n;
                        break
                    }
                    if (!((kc[c[(c[n >> 2] | 0) + 36 >> 2] & 63](n) | 0) == -1)) {
                        D = n;
                        break
                    }
                    c[z >> 2] = 0;
                    D = 0
                }
            } while (0);
            y = (D | 0) == 0;
            E = c[g >> 2] | 0;
            do {
                if ((E | 0) == 0) {
                    F = 18
                } else {
                    if ((c[E + 12 >> 2] | 0) != (c[E + 16 >> 2] | 0)) {
                        if (y) {
                            G = E;
                            break
                        } else {
                            H = E;
                            I = C;
                            break a
                        }
                    }
                    if ((kc[c[(c[E >> 2] | 0) + 36 >> 2] & 63](E) | 0) == -1) {
                        c[g >> 2] = 0;
                        F = 18;
                        break
                    } else {
                        if (y) {
                            G = E;
                            break
                        } else {
                            H = E;
                            I = C;
                            break a
                        }
                    }
                }
            } while (0);
            if ((F | 0) == 18) {
                F = 0;
                if (y) {
                    H = 0;
                    I = C;
                    break
                } else {
                    G = 0
                }
            }
            E = a[j] | 0;
            J = (E & 1) == 0;
            if (J) {
                K = (E & 255) >>> 1
            } else {
                K = c[A >> 2] | 0
            } if (((c[q >> 2] | 0) - C | 0) == (K | 0)) {
                if (J) {
                    L = (E & 255) >>> 1;
                    M = (E & 255) >>> 1
                } else {
                    E = c[A >> 2] | 0;
                    L = E;
                    M = E
                }
                xe(p, M << 1, 0);
                if ((a[j] & 1) == 0) {
                    N = 10
                } else {
                    N = (c[h >> 2] & -2) + -1 | 0
                }
                xe(p, N, 0);
                if ((a[j] & 1) == 0) {
                    O = w
                } else {
                    O = c[x >> 2] | 0
                }
                c[q >> 2] = O + L;
                P = O
            } else {
                P = C
            }
            E = D + 12 | 0;
            J = c[E >> 2] | 0;
            Q = D + 16 | 0;
            if ((J | 0) == (c[Q >> 2] | 0)) {
                R = kc[c[(c[D >> 2] | 0) + 36 >> 2] & 63](D) | 0
            } else {
                R = d[J] | 0
            } if ((zg(R & 255, v, P, q, t, B, o, m, s, u) | 0) != 0) {
                H = G;
                I = P;
                break
            }
            J = c[E >> 2] | 0;
            if ((J | 0) == (c[Q >> 2] | 0)) {
                kc[c[(c[D >> 2] | 0) + 40 >> 2] & 63](D) | 0;
                n = D;
                C = P;
                continue
            } else {
                c[E >> 2] = J + 1;
                n = D;
                C = P;
                continue
            }
        }
        P = a[o] | 0;
        if ((P & 1) == 0) {
            S = (P & 255) >>> 1
        } else {
            S = c[o + 4 >> 2] | 0
        }
        do {
            if ((S | 0) != 0) {
                P = c[s >> 2] | 0;
                if ((P - r | 0) >= 160) {
                    break
                }
                C = c[t >> 2] | 0;
                c[s >> 2] = P + 4;
                c[P >> 2] = C
            }
        } while (0);
        b[l >> 1] = Ql(I, c[q >> 2] | 0, k, v) | 0;
        jj(o, m, c[s >> 2] | 0, k);
        do {
            if ((D | 0) == 0) {
                T = 0
            } else {
                if ((c[D + 12 >> 2] | 0) != (c[D + 16 >> 2] | 0)) {
                    T = D;
                    break
                }
                if (!((kc[c[(c[D >> 2] | 0) + 36 >> 2] & 63](D) | 0) == -1)) {
                    T = D;
                    break
                }
                c[z >> 2] = 0;
                T = 0
            }
        } while (0);
        z = (T | 0) == 0;
        do {
            if ((H | 0) == 0) {
                F = 54
            } else {
                if ((c[H + 12 >> 2] | 0) != (c[H + 16 >> 2] | 0)) {
                    if (!z) {
                        break
                    }
                    U = e;
                    c[U >> 2] = T;
                    ve(p);
                    ve(o);
                    i = f;
                    return
                }
                if ((kc[c[(c[H >> 2] | 0) + 36 >> 2] & 63](H) | 0) == -1) {
                    c[g >> 2] = 0;
                    F = 54;
                    break
                }
                if (!(z ^ (H | 0) == 0)) {
                    break
                }
                U = e;
                c[U >> 2] = T;
                ve(p);
                ve(o);
                i = f;
                return
            }
        } while (0);
        do {
            if ((F | 0) == 54) {
                if (z) {
                    break
                }
                U = e;
                c[U >> 2] = T;
                ve(p);
                ve(o);
                i = f;
                return
            }
        } while (0);
        c[k >> 2] = c[k >> 2] | 2;
        U = e;
        c[U >> 2] = T;
        ve(p);
        ve(o);
        i = f;
        return
    }

    function mg(a, b, d, e, f, g, h) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        var j = 0,
            k = 0,
            l = 0,
            m = 0;
        b = i;
        i = i + 32 | 0;
        j = b;
        k = b + 8 | 0;
        l = b + 16 | 0;
        m = b + 24 | 0;
        c[l >> 2] = c[d >> 2];
        c[m >> 2] = c[e >> 2];
        e = k;
        d = l;
        c[e + 0 >> 2] = c[d + 0 >> 2];
        d = j;
        e = m;
        c[d + 0 >> 2] = c[e + 0 >> 2];
        ng(a, 0, k, j, f, g, h);
        i = b;
        return
    }

    function ng(b, e, f, g, h, j, k) {
        b = b | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        var l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0;
        e = i;
        i = i + 256 | 0;
        l = e;
        m = e + 32 | 0;
        n = e + 40 | 0;
        o = e + 56 | 0;
        p = e + 72 | 0;
        q = e + 80 | 0;
        r = e + 240 | 0;
        s = e + 248 | 0;
        t = c[h + 4 >> 2] & 74;
        if ((t | 0) == 8) {
            u = 16
        } else if ((t | 0) == 64) {
            u = 8
        } else if ((t | 0) == 0) {
            u = 0
        } else {
            u = 10
        }
        t = l;
        Zg(n, h, t, m);
        h = o;
        c[h + 0 >> 2] = 0;
        c[h + 4 >> 2] = 0;
        c[h + 8 >> 2] = 0;
        xe(o, 10, 0);
        if ((a[h] & 1) == 0) {
            l = o + 1 | 0;
            v = l;
            w = o + 8 | 0;
            x = l
        } else {
            l = o + 8 | 0;
            v = o + 1 | 0;
            w = l;
            x = c[l >> 2] | 0
        }
        c[p >> 2] = x;
        l = q;
        c[r >> 2] = l;
        c[s >> 2] = 0;
        y = f;
        f = g;
        g = o;
        z = o + 4 | 0;
        A = a[m] | 0;
        m = c[y >> 2] | 0;
        B = x;
        a: while (1) {
            do {
                if ((m | 0) == 0) {
                    C = 0
                } else {
                    if ((c[m + 12 >> 2] | 0) != (c[m + 16 >> 2] | 0)) {
                        C = m;
                        break
                    }
                    if (!((kc[c[(c[m >> 2] | 0) + 36 >> 2] & 63](m) | 0) == -1)) {
                        C = m;
                        break
                    }
                    c[y >> 2] = 0;
                    C = 0
                }
            } while (0);
            x = (C | 0) == 0;
            D = c[f >> 2] | 0;
            do {
                if ((D | 0) == 0) {
                    E = 18
                } else {
                    if ((c[D + 12 >> 2] | 0) != (c[D + 16 >> 2] | 0)) {
                        if (x) {
                            F = D;
                            break
                        } else {
                            G = D;
                            H = B;
                            break a
                        }
                    }
                    if ((kc[c[(c[D >> 2] | 0) + 36 >> 2] & 63](D) | 0) == -1) {
                        c[f >> 2] = 0;
                        E = 18;
                        break
                    } else {
                        if (x) {
                            F = D;
                            break
                        } else {
                            G = D;
                            H = B;
                            break a
                        }
                    }
                }
            } while (0);
            if ((E | 0) == 18) {
                E = 0;
                if (x) {
                    G = 0;
                    H = B;
                    break
                } else {
                    F = 0
                }
            }
            D = a[h] | 0;
            I = (D & 1) == 0;
            if (I) {
                J = (D & 255) >>> 1
            } else {
                J = c[z >> 2] | 0
            } if (((c[p >> 2] | 0) - B | 0) == (J | 0)) {
                if (I) {
                    K = (D & 255) >>> 1;
                    L = (D & 255) >>> 1
                } else {
                    D = c[z >> 2] | 0;
                    K = D;
                    L = D
                }
                xe(o, L << 1, 0);
                if ((a[h] & 1) == 0) {
                    M = 10
                } else {
                    M = (c[g >> 2] & -2) + -1 | 0
                }
                xe(o, M, 0);
                if ((a[h] & 1) == 0) {
                    N = v
                } else {
                    N = c[w >> 2] | 0
                }
                c[p >> 2] = N + K;
                O = N
            } else {
                O = B
            }
            D = C + 12 | 0;
            I = c[D >> 2] | 0;
            P = C + 16 | 0;
            if ((I | 0) == (c[P >> 2] | 0)) {
                Q = kc[c[(c[C >> 2] | 0) + 36 >> 2] & 63](C) | 0
            } else {
                Q = d[I] | 0
            } if ((zg(Q & 255, u, O, p, s, A, n, l, r, t) | 0) != 0) {
                G = F;
                H = O;
                break
            }
            I = c[D >> 2] | 0;
            if ((I | 0) == (c[P >> 2] | 0)) {
                kc[c[(c[C >> 2] | 0) + 40 >> 2] & 63](C) | 0;
                m = C;
                B = O;
                continue
            } else {
                c[D >> 2] = I + 1;
                m = C;
                B = O;
                continue
            }
        }
        O = a[n] | 0;
        if ((O & 1) == 0) {
            R = (O & 255) >>> 1
        } else {
            R = c[n + 4 >> 2] | 0
        }
        do {
            if ((R | 0) != 0) {
                O = c[r >> 2] | 0;
                if ((O - q | 0) >= 160) {
                    break
                }
                B = c[s >> 2] | 0;
                c[r >> 2] = O + 4;
                c[O >> 2] = B
            }
        } while (0);
        c[k >> 2] = Pl(H, c[p >> 2] | 0, j, u) | 0;
        jj(n, l, c[r >> 2] | 0, j);
        do {
            if ((C | 0) == 0) {
                S = 0
            } else {
                if ((c[C + 12 >> 2] | 0) != (c[C + 16 >> 2] | 0)) {
                    S = C;
                    break
                }
                if (!((kc[c[(c[C >> 2] | 0) + 36 >> 2] & 63](C) | 0) == -1)) {
                    S = C;
                    break
                }
                c[y >> 2] = 0;
                S = 0
            }
        } while (0);
        y = (S | 0) == 0;
        do {
            if ((G | 0) == 0) {
                E = 54
            } else {
                if ((c[G + 12 >> 2] | 0) != (c[G + 16 >> 2] | 0)) {
                    if (!y) {
                        break
                    }
                    T = b;
                    c[T >> 2] = S;
                    ve(o);
                    ve(n);
                    i = e;
                    return
                }
                if ((kc[c[(c[G >> 2] | 0) + 36 >> 2] & 63](G) | 0) == -1) {
                    c[f >> 2] = 0;
                    E = 54;
                    break
                }
                if (!(y ^ (G | 0) == 0)) {
                    break
                }
                T = b;
                c[T >> 2] = S;
                ve(o);
                ve(n);
                i = e;
                return
            }
        } while (0);
        do {
            if ((E | 0) == 54) {
                if (y) {
                    break
                }
                T = b;
                c[T >> 2] = S;
                ve(o);
                ve(n);
                i = e;
                return
            }
        } while (0);
        c[j >> 2] = c[j >> 2] | 2;
        T = b;
        c[T >> 2] = S;
        ve(o);
        ve(n);
        i = e;
        return
    }

    function og(a, b, d, e, f, g, h) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        var j = 0,
            k = 0,
            l = 0,
            m = 0;
        b = i;
        i = i + 32 | 0;
        j = b;
        k = b + 8 | 0;
        l = b + 16 | 0;
        m = b + 24 | 0;
        c[l >> 2] = c[d >> 2];
        c[m >> 2] = c[e >> 2];
        e = k;
        d = l;
        c[e + 0 >> 2] = c[d + 0 >> 2];
        d = j;
        e = m;
        c[d + 0 >> 2] = c[e + 0 >> 2];
        pg(a, 0, k, j, f, g, h);
        i = b;
        return
    }

    function pg(b, e, f, g, h, j, k) {
        b = b | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        var l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0;
        e = i;
        i = i + 256 | 0;
        l = e;
        m = e + 32 | 0;
        n = e + 40 | 0;
        o = e + 56 | 0;
        p = e + 72 | 0;
        q = e + 80 | 0;
        r = e + 240 | 0;
        s = e + 248 | 0;
        t = c[h + 4 >> 2] & 74;
        if ((t | 0) == 64) {
            u = 8
        } else if ((t | 0) == 8) {
            u = 16
        } else if ((t | 0) == 0) {
            u = 0
        } else {
            u = 10
        }
        t = l;
        Zg(n, h, t, m);
        h = o;
        c[h + 0 >> 2] = 0;
        c[h + 4 >> 2] = 0;
        c[h + 8 >> 2] = 0;
        xe(o, 10, 0);
        if ((a[h] & 1) == 0) {
            l = o + 1 | 0;
            v = l;
            w = o + 8 | 0;
            x = l
        } else {
            l = o + 8 | 0;
            v = o + 1 | 0;
            w = l;
            x = c[l >> 2] | 0
        }
        c[p >> 2] = x;
        l = q;
        c[r >> 2] = l;
        c[s >> 2] = 0;
        y = f;
        f = g;
        g = o;
        z = o + 4 | 0;
        A = a[m] | 0;
        m = c[y >> 2] | 0;
        B = x;
        a: while (1) {
            do {
                if ((m | 0) == 0) {
                    C = 0
                } else {
                    if ((c[m + 12 >> 2] | 0) != (c[m + 16 >> 2] | 0)) {
                        C = m;
                        break
                    }
                    if (!((kc[c[(c[m >> 2] | 0) + 36 >> 2] & 63](m) | 0) == -1)) {
                        C = m;
                        break
                    }
                    c[y >> 2] = 0;
                    C = 0
                }
            } while (0);
            x = (C | 0) == 0;
            D = c[f >> 2] | 0;
            do {
                if ((D | 0) == 0) {
                    E = 18
                } else {
                    if ((c[D + 12 >> 2] | 0) != (c[D + 16 >> 2] | 0)) {
                        if (x) {
                            F = D;
                            break
                        } else {
                            G = D;
                            H = B;
                            break a
                        }
                    }
                    if ((kc[c[(c[D >> 2] | 0) + 36 >> 2] & 63](D) | 0) == -1) {
                        c[f >> 2] = 0;
                        E = 18;
                        break
                    } else {
                        if (x) {
                            F = D;
                            break
                        } else {
                            G = D;
                            H = B;
                            break a
                        }
                    }
                }
            } while (0);
            if ((E | 0) == 18) {
                E = 0;
                if (x) {
                    G = 0;
                    H = B;
                    break
                } else {
                    F = 0
                }
            }
            D = a[h] | 0;
            I = (D & 1) == 0;
            if (I) {
                J = (D & 255) >>> 1
            } else {
                J = c[z >> 2] | 0
            } if (((c[p >> 2] | 0) - B | 0) == (J | 0)) {
                if (I) {
                    K = (D & 255) >>> 1;
                    L = (D & 255) >>> 1
                } else {
                    D = c[z >> 2] | 0;
                    K = D;
                    L = D
                }
                xe(o, L << 1, 0);
                if ((a[h] & 1) == 0) {
                    M = 10
                } else {
                    M = (c[g >> 2] & -2) + -1 | 0
                }
                xe(o, M, 0);
                if ((a[h] & 1) == 0) {
                    N = v
                } else {
                    N = c[w >> 2] | 0
                }
                c[p >> 2] = N + K;
                O = N
            } else {
                O = B
            }
            D = C + 12 | 0;
            I = c[D >> 2] | 0;
            P = C + 16 | 0;
            if ((I | 0) == (c[P >> 2] | 0)) {
                Q = kc[c[(c[C >> 2] | 0) + 36 >> 2] & 63](C) | 0
            } else {
                Q = d[I] | 0
            } if ((zg(Q & 255, u, O, p, s, A, n, l, r, t) | 0) != 0) {
                G = F;
                H = O;
                break
            }
            I = c[D >> 2] | 0;
            if ((I | 0) == (c[P >> 2] | 0)) {
                kc[c[(c[C >> 2] | 0) + 40 >> 2] & 63](C) | 0;
                m = C;
                B = O;
                continue
            } else {
                c[D >> 2] = I + 1;
                m = C;
                B = O;
                continue
            }
        }
        O = a[n] | 0;
        if ((O & 1) == 0) {
            R = (O & 255) >>> 1
        } else {
            R = c[n + 4 >> 2] | 0
        }
        do {
            if ((R | 0) != 0) {
                O = c[r >> 2] | 0;
                if ((O - q | 0) >= 160) {
                    break
                }
                B = c[s >> 2] | 0;
                c[r >> 2] = O + 4;
                c[O >> 2] = B
            }
        } while (0);
        c[k >> 2] = Ol(H, c[p >> 2] | 0, j, u) | 0;
        jj(n, l, c[r >> 2] | 0, j);
        do {
            if ((C | 0) == 0) {
                S = 0
            } else {
                if ((c[C + 12 >> 2] | 0) != (c[C + 16 >> 2] | 0)) {
                    S = C;
                    break
                }
                if (!((kc[c[(c[C >> 2] | 0) + 36 >> 2] & 63](C) | 0) == -1)) {
                    S = C;
                    break
                }
                c[y >> 2] = 0;
                S = 0
            }
        } while (0);
        y = (S | 0) == 0;
        do {
            if ((G | 0) == 0) {
                E = 54
            } else {
                if ((c[G + 12 >> 2] | 0) != (c[G + 16 >> 2] | 0)) {
                    if (!y) {
                        break
                    }
                    T = b;
                    c[T >> 2] = S;
                    ve(o);
                    ve(n);
                    i = e;
                    return
                }
                if ((kc[c[(c[G >> 2] | 0) + 36 >> 2] & 63](G) | 0) == -1) {
                    c[f >> 2] = 0;
                    E = 54;
                    break
                }
                if (!(y ^ (G | 0) == 0)) {
                    break
                }
                T = b;
                c[T >> 2] = S;
                ve(o);
                ve(n);
                i = e;
                return
            }
        } while (0);
        do {
            if ((E | 0) == 54) {
                if (y) {
                    break
                }
                T = b;
                c[T >> 2] = S;
                ve(o);
                ve(n);
                i = e;
                return
            }
        } while (0);
        c[j >> 2] = c[j >> 2] | 2;
        T = b;
        c[T >> 2] = S;
        ve(o);
        ve(n);
        i = e;
        return
    }

    function qg(a, b, d, e, f, g, h) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        var j = 0,
            k = 0,
            l = 0,
            m = 0;
        b = i;
        i = i + 32 | 0;
        j = b;
        k = b + 8 | 0;
        l = b + 16 | 0;
        m = b + 24 | 0;
        c[l >> 2] = c[d >> 2];
        c[m >> 2] = c[e >> 2];
        e = k;
        d = l;
        c[e + 0 >> 2] = c[d + 0 >> 2];
        d = j;
        e = m;
        c[d + 0 >> 2] = c[e + 0 >> 2];
        rg(a, 0, k, j, f, g, h);
        i = b;
        return
    }

    function rg(b, e, f, g, h, j, k) {
        b = b | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        var l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0;
        e = i;
        i = i + 256 | 0;
        l = e;
        m = e + 32 | 0;
        n = e + 40 | 0;
        o = e + 56 | 0;
        p = e + 72 | 0;
        q = e + 80 | 0;
        r = e + 240 | 0;
        s = e + 248 | 0;
        t = c[h + 4 >> 2] & 74;
        if ((t | 0) == 64) {
            u = 8
        } else if ((t | 0) == 0) {
            u = 0
        } else if ((t | 0) == 8) {
            u = 16
        } else {
            u = 10
        }
        t = l;
        Zg(n, h, t, m);
        h = o;
        c[h + 0 >> 2] = 0;
        c[h + 4 >> 2] = 0;
        c[h + 8 >> 2] = 0;
        xe(o, 10, 0);
        if ((a[h] & 1) == 0) {
            l = o + 1 | 0;
            v = l;
            w = o + 8 | 0;
            x = l
        } else {
            l = o + 8 | 0;
            v = o + 1 | 0;
            w = l;
            x = c[l >> 2] | 0
        }
        c[p >> 2] = x;
        l = q;
        c[r >> 2] = l;
        c[s >> 2] = 0;
        y = f;
        f = g;
        g = o;
        z = o + 4 | 0;
        A = a[m] | 0;
        m = c[y >> 2] | 0;
        B = x;
        a: while (1) {
            do {
                if ((m | 0) == 0) {
                    C = 0
                } else {
                    if ((c[m + 12 >> 2] | 0) != (c[m + 16 >> 2] | 0)) {
                        C = m;
                        break
                    }
                    if (!((kc[c[(c[m >> 2] | 0) + 36 >> 2] & 63](m) | 0) == -1)) {
                        C = m;
                        break
                    }
                    c[y >> 2] = 0;
                    C = 0
                }
            } while (0);
            x = (C | 0) == 0;
            D = c[f >> 2] | 0;
            do {
                if ((D | 0) == 0) {
                    E = 18
                } else {
                    if ((c[D + 12 >> 2] | 0) != (c[D + 16 >> 2] | 0)) {
                        if (x) {
                            F = D;
                            break
                        } else {
                            G = D;
                            H = B;
                            break a
                        }
                    }
                    if ((kc[c[(c[D >> 2] | 0) + 36 >> 2] & 63](D) | 0) == -1) {
                        c[f >> 2] = 0;
                        E = 18;
                        break
                    } else {
                        if (x) {
                            F = D;
                            break
                        } else {
                            G = D;
                            H = B;
                            break a
                        }
                    }
                }
            } while (0);
            if ((E | 0) == 18) {
                E = 0;
                if (x) {
                    G = 0;
                    H = B;
                    break
                } else {
                    F = 0
                }
            }
            D = a[h] | 0;
            J = (D & 1) == 0;
            if (J) {
                K = (D & 255) >>> 1
            } else {
                K = c[z >> 2] | 0
            } if (((c[p >> 2] | 0) - B | 0) == (K | 0)) {
                if (J) {
                    L = (D & 255) >>> 1;
                    M = (D & 255) >>> 1
                } else {
                    D = c[z >> 2] | 0;
                    L = D;
                    M = D
                }
                xe(o, M << 1, 0);
                if ((a[h] & 1) == 0) {
                    N = 10
                } else {
                    N = (c[g >> 2] & -2) + -1 | 0
                }
                xe(o, N, 0);
                if ((a[h] & 1) == 0) {
                    O = v
                } else {
                    O = c[w >> 2] | 0
                }
                c[p >> 2] = O + L;
                P = O
            } else {
                P = B
            }
            D = C + 12 | 0;
            J = c[D >> 2] | 0;
            Q = C + 16 | 0;
            if ((J | 0) == (c[Q >> 2] | 0)) {
                R = kc[c[(c[C >> 2] | 0) + 36 >> 2] & 63](C) | 0
            } else {
                R = d[J] | 0
            } if ((zg(R & 255, u, P, p, s, A, n, l, r, t) | 0) != 0) {
                G = F;
                H = P;
                break
            }
            J = c[D >> 2] | 0;
            if ((J | 0) == (c[Q >> 2] | 0)) {
                kc[c[(c[C >> 2] | 0) + 40 >> 2] & 63](C) | 0;
                m = C;
                B = P;
                continue
            } else {
                c[D >> 2] = J + 1;
                m = C;
                B = P;
                continue
            }
        }
        P = a[n] | 0;
        if ((P & 1) == 0) {
            S = (P & 255) >>> 1
        } else {
            S = c[n + 4 >> 2] | 0
        }
        do {
            if ((S | 0) != 0) {
                P = c[r >> 2] | 0;
                if ((P - q | 0) >= 160) {
                    break
                }
                B = c[s >> 2] | 0;
                c[r >> 2] = P + 4;
                c[P >> 2] = B
            }
        } while (0);
        s = Nl(H, c[p >> 2] | 0, j, u) | 0;
        u = k;
        c[u >> 2] = s;
        c[u + 4 >> 2] = I;
        jj(n, l, c[r >> 2] | 0, j);
        do {
            if ((C | 0) == 0) {
                T = 0
            } else {
                if ((c[C + 12 >> 2] | 0) != (c[C + 16 >> 2] | 0)) {
                    T = C;
                    break
                }
                if (!((kc[c[(c[C >> 2] | 0) + 36 >> 2] & 63](C) | 0) == -1)) {
                    T = C;
                    break
                }
                c[y >> 2] = 0;
                T = 0
            }
        } while (0);
        y = (T | 0) == 0;
        do {
            if ((G | 0) == 0) {
                E = 54
            } else {
                if ((c[G + 12 >> 2] | 0) != (c[G + 16 >> 2] | 0)) {
                    if (!y) {
                        break
                    }
                    U = b;
                    c[U >> 2] = T;
                    ve(o);
                    ve(n);
                    i = e;
                    return
                }
                if ((kc[c[(c[G >> 2] | 0) + 36 >> 2] & 63](G) | 0) == -1) {
                    c[f >> 2] = 0;
                    E = 54;
                    break
                }
                if (!(y ^ (G | 0) == 0)) {
                    break
                }
                U = b;
                c[U >> 2] = T;
                ve(o);
                ve(n);
                i = e;
                return
            }
        } while (0);
        do {
            if ((E | 0) == 54) {
                if (y) {
                    break
                }
                U = b;
                c[U >> 2] = T;
                ve(o);
                ve(n);
                i = e;
                return
            }
        } while (0);
        c[j >> 2] = c[j >> 2] | 2;
        U = b;
        c[U >> 2] = T;
        ve(o);
        ve(n);
        i = e;
        return
    }

    function sg(a, b, d, e, f, g, h) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        var j = 0,
            k = 0,
            l = 0,
            m = 0;
        b = i;
        i = i + 32 | 0;
        j = b;
        k = b + 8 | 0;
        l = b + 16 | 0;
        m = b + 24 | 0;
        c[l >> 2] = c[d >> 2];
        c[m >> 2] = c[e >> 2];
        e = k;
        d = l;
        c[e + 0 >> 2] = c[d + 0 >> 2];
        d = j;
        e = m;
        c[d + 0 >> 2] = c[e + 0 >> 2];
        tg(a, 0, k, j, f, g, h);
        i = b;
        return
    }

    function tg(b, e, f, h, j, k, l) {
        b = b | 0;
        e = e | 0;
        f = f | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        l = l | 0;
        var m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0,
            V = 0,
            W = 0;
        e = i;
        i = i + 280 | 0;
        m = e + 32 | 0;
        n = e + 40 | 0;
        o = e + 48 | 0;
        p = e + 64 | 0;
        q = e + 80 | 0;
        r = e + 88 | 0;
        s = e + 248 | 0;
        t = e + 256 | 0;
        u = e + 264 | 0;
        v = e + 272 | 0;
        w = e;
        _g(o, j, w, m, n);
        j = p;
        c[j + 0 >> 2] = 0;
        c[j + 4 >> 2] = 0;
        c[j + 8 >> 2] = 0;
        xe(p, 10, 0);
        if ((a[j] & 1) == 0) {
            x = p + 1 | 0;
            y = x;
            z = p + 8 | 0;
            A = x
        } else {
            x = p + 8 | 0;
            y = p + 1 | 0;
            z = x;
            A = c[x >> 2] | 0
        }
        c[q >> 2] = A;
        x = r;
        c[s >> 2] = x;
        c[t >> 2] = 0;
        a[u] = 1;
        a[v] = 69;
        B = f;
        f = h;
        h = p;
        C = p + 4 | 0;
        D = a[m] | 0;
        m = a[n] | 0;
        n = c[B >> 2] | 0;
        E = A;
        a: while (1) {
            do {
                if ((n | 0) == 0) {
                    F = 0
                } else {
                    if ((c[n + 12 >> 2] | 0) != (c[n + 16 >> 2] | 0)) {
                        F = n;
                        break
                    }
                    if (!((kc[c[(c[n >> 2] | 0) + 36 >> 2] & 63](n) | 0) == -1)) {
                        F = n;
                        break
                    }
                    c[B >> 2] = 0;
                    F = 0
                }
            } while (0);
            A = (F | 0) == 0;
            G = c[f >> 2] | 0;
            do {
                if ((G | 0) == 0) {
                    H = 14
                } else {
                    if ((c[G + 12 >> 2] | 0) != (c[G + 16 >> 2] | 0)) {
                        if (A) {
                            I = G;
                            break
                        } else {
                            J = G;
                            K = E;
                            break a
                        }
                    }
                    if ((kc[c[(c[G >> 2] | 0) + 36 >> 2] & 63](G) | 0) == -1) {
                        c[f >> 2] = 0;
                        H = 14;
                        break
                    } else {
                        if (A) {
                            I = G;
                            break
                        } else {
                            J = G;
                            K = E;
                            break a
                        }
                    }
                }
            } while (0);
            if ((H | 0) == 14) {
                H = 0;
                if (A) {
                    J = 0;
                    K = E;
                    break
                } else {
                    I = 0
                }
            }
            G = a[j] | 0;
            L = (G & 1) == 0;
            if (L) {
                M = (G & 255) >>> 1
            } else {
                M = c[C >> 2] | 0
            } if (((c[q >> 2] | 0) - E | 0) == (M | 0)) {
                if (L) {
                    N = (G & 255) >>> 1;
                    O = (G & 255) >>> 1
                } else {
                    G = c[C >> 2] | 0;
                    N = G;
                    O = G
                }
                xe(p, O << 1, 0);
                if ((a[j] & 1) == 0) {
                    P = 10
                } else {
                    P = (c[h >> 2] & -2) + -1 | 0
                }
                xe(p, P, 0);
                if ((a[j] & 1) == 0) {
                    Q = y
                } else {
                    Q = c[z >> 2] | 0
                }
                c[q >> 2] = Q + N;
                R = Q
            } else {
                R = E
            }
            G = F + 12 | 0;
            L = c[G >> 2] | 0;
            S = F + 16 | 0;
            if ((L | 0) == (c[S >> 2] | 0)) {
                T = kc[c[(c[F >> 2] | 0) + 36 >> 2] & 63](F) | 0
            } else {
                T = d[L] | 0
            } if (($g(T & 255, u, v, R, q, D, m, o, x, s, t, w) | 0) != 0) {
                J = I;
                K = R;
                break
            }
            L = c[G >> 2] | 0;
            if ((L | 0) == (c[S >> 2] | 0)) {
                kc[c[(c[F >> 2] | 0) + 40 >> 2] & 63](F) | 0;
                n = F;
                E = R;
                continue
            } else {
                c[G >> 2] = L + 1;
                n = F;
                E = R;
                continue
            }
        }
        R = a[o] | 0;
        if ((R & 1) == 0) {
            U = (R & 255) >>> 1
        } else {
            U = c[o + 4 >> 2] | 0
        }
        do {
            if ((U | 0) != 0) {
                if ((a[u] | 0) == 0) {
                    break
                }
                R = c[s >> 2] | 0;
                if ((R - r | 0) >= 160) {
                    break
                }
                E = c[t >> 2] | 0;
                c[s >> 2] = R + 4;
                c[R >> 2] = E
            }
        } while (0);
        g[l >> 2] = +Ml(K, c[q >> 2] | 0, k);
        jj(o, x, c[s >> 2] | 0, k);
        do {
            if ((F | 0) == 0) {
                V = 0
            } else {
                if ((c[F + 12 >> 2] | 0) != (c[F + 16 >> 2] | 0)) {
                    V = F;
                    break
                }
                if (!((kc[c[(c[F >> 2] | 0) + 36 >> 2] & 63](F) | 0) == -1)) {
                    V = F;
                    break
                }
                c[B >> 2] = 0;
                V = 0
            }
        } while (0);
        B = (V | 0) == 0;
        do {
            if ((J | 0) == 0) {
                H = 51
            } else {
                if ((c[J + 12 >> 2] | 0) != (c[J + 16 >> 2] | 0)) {
                    if (!B) {
                        break
                    }
                    W = b;
                    c[W >> 2] = V;
                    ve(p);
                    ve(o);
                    i = e;
                    return
                }
                if ((kc[c[(c[J >> 2] | 0) + 36 >> 2] & 63](J) | 0) == -1) {
                    c[f >> 2] = 0;
                    H = 51;
                    break
                }
                if (!(B ^ (J | 0) == 0)) {
                    break
                }
                W = b;
                c[W >> 2] = V;
                ve(p);
                ve(o);
                i = e;
                return
            }
        } while (0);
        do {
            if ((H | 0) == 51) {
                if (B) {
                    break
                }
                W = b;
                c[W >> 2] = V;
                ve(p);
                ve(o);
                i = e;
                return
            }
        } while (0);
        c[k >> 2] = c[k >> 2] | 2;
        W = b;
        c[W >> 2] = V;
        ve(p);
        ve(o);
        i = e;
        return
    }

    function ug(a, b, d, e, f, g, h) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        var j = 0,
            k = 0,
            l = 0,
            m = 0;
        b = i;
        i = i + 32 | 0;
        j = b;
        k = b + 8 | 0;
        l = b + 16 | 0;
        m = b + 24 | 0;
        c[l >> 2] = c[d >> 2];
        c[m >> 2] = c[e >> 2];
        e = k;
        d = l;
        c[e + 0 >> 2] = c[d + 0 >> 2];
        d = j;
        e = m;
        c[d + 0 >> 2] = c[e + 0 >> 2];
        vg(a, 0, k, j, f, g, h);
        i = b;
        return
    }

    function vg(b, e, f, g, j, k, l) {
        b = b | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        j = j | 0;
        k = k | 0;
        l = l | 0;
        var m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0,
            V = 0,
            W = 0;
        e = i;
        i = i + 280 | 0;
        m = e + 32 | 0;
        n = e + 40 | 0;
        o = e + 48 | 0;
        p = e + 64 | 0;
        q = e + 80 | 0;
        r = e + 88 | 0;
        s = e + 248 | 0;
        t = e + 256 | 0;
        u = e + 264 | 0;
        v = e + 272 | 0;
        w = e;
        _g(o, j, w, m, n);
        j = p;
        c[j + 0 >> 2] = 0;
        c[j + 4 >> 2] = 0;
        c[j + 8 >> 2] = 0;
        xe(p, 10, 0);
        if ((a[j] & 1) == 0) {
            x = p + 1 | 0;
            y = x;
            z = p + 8 | 0;
            A = x
        } else {
            x = p + 8 | 0;
            y = p + 1 | 0;
            z = x;
            A = c[x >> 2] | 0
        }
        c[q >> 2] = A;
        x = r;
        c[s >> 2] = x;
        c[t >> 2] = 0;
        a[u] = 1;
        a[v] = 69;
        B = f;
        f = g;
        g = p;
        C = p + 4 | 0;
        D = a[m] | 0;
        m = a[n] | 0;
        n = c[B >> 2] | 0;
        E = A;
        a: while (1) {
            do {
                if ((n | 0) == 0) {
                    F = 0
                } else {
                    if ((c[n + 12 >> 2] | 0) != (c[n + 16 >> 2] | 0)) {
                        F = n;
                        break
                    }
                    if (!((kc[c[(c[n >> 2] | 0) + 36 >> 2] & 63](n) | 0) == -1)) {
                        F = n;
                        break
                    }
                    c[B >> 2] = 0;
                    F = 0
                }
            } while (0);
            A = (F | 0) == 0;
            G = c[f >> 2] | 0;
            do {
                if ((G | 0) == 0) {
                    H = 14
                } else {
                    if ((c[G + 12 >> 2] | 0) != (c[G + 16 >> 2] | 0)) {
                        if (A) {
                            I = G;
                            break
                        } else {
                            J = G;
                            K = E;
                            break a
                        }
                    }
                    if ((kc[c[(c[G >> 2] | 0) + 36 >> 2] & 63](G) | 0) == -1) {
                        c[f >> 2] = 0;
                        H = 14;
                        break
                    } else {
                        if (A) {
                            I = G;
                            break
                        } else {
                            J = G;
                            K = E;
                            break a
                        }
                    }
                }
            } while (0);
            if ((H | 0) == 14) {
                H = 0;
                if (A) {
                    J = 0;
                    K = E;
                    break
                } else {
                    I = 0
                }
            }
            G = a[j] | 0;
            L = (G & 1) == 0;
            if (L) {
                M = (G & 255) >>> 1
            } else {
                M = c[C >> 2] | 0
            } if (((c[q >> 2] | 0) - E | 0) == (M | 0)) {
                if (L) {
                    N = (G & 255) >>> 1;
                    O = (G & 255) >>> 1
                } else {
                    G = c[C >> 2] | 0;
                    N = G;
                    O = G
                }
                xe(p, O << 1, 0);
                if ((a[j] & 1) == 0) {
                    P = 10
                } else {
                    P = (c[g >> 2] & -2) + -1 | 0
                }
                xe(p, P, 0);
                if ((a[j] & 1) == 0) {
                    Q = y
                } else {
                    Q = c[z >> 2] | 0
                }
                c[q >> 2] = Q + N;
                R = Q
            } else {
                R = E
            }
            G = F + 12 | 0;
            L = c[G >> 2] | 0;
            S = F + 16 | 0;
            if ((L | 0) == (c[S >> 2] | 0)) {
                T = kc[c[(c[F >> 2] | 0) + 36 >> 2] & 63](F) | 0
            } else {
                T = d[L] | 0
            } if (($g(T & 255, u, v, R, q, D, m, o, x, s, t, w) | 0) != 0) {
                J = I;
                K = R;
                break
            }
            L = c[G >> 2] | 0;
            if ((L | 0) == (c[S >> 2] | 0)) {
                kc[c[(c[F >> 2] | 0) + 40 >> 2] & 63](F) | 0;
                n = F;
                E = R;
                continue
            } else {
                c[G >> 2] = L + 1;
                n = F;
                E = R;
                continue
            }
        }
        R = a[o] | 0;
        if ((R & 1) == 0) {
            U = (R & 255) >>> 1
        } else {
            U = c[o + 4 >> 2] | 0
        }
        do {
            if ((U | 0) != 0) {
                if ((a[u] | 0) == 0) {
                    break
                }
                R = c[s >> 2] | 0;
                if ((R - r | 0) >= 160) {
                    break
                }
                E = c[t >> 2] | 0;
                c[s >> 2] = R + 4;
                c[R >> 2] = E
            }
        } while (0);
        h[l >> 3] = +Ll(K, c[q >> 2] | 0, k);
        jj(o, x, c[s >> 2] | 0, k);
        do {
            if ((F | 0) == 0) {
                V = 0
            } else {
                if ((c[F + 12 >> 2] | 0) != (c[F + 16 >> 2] | 0)) {
                    V = F;
                    break
                }
                if (!((kc[c[(c[F >> 2] | 0) + 36 >> 2] & 63](F) | 0) == -1)) {
                    V = F;
                    break
                }
                c[B >> 2] = 0;
                V = 0
            }
        } while (0);
        B = (V | 0) == 0;
        do {
            if ((J | 0) == 0) {
                H = 51
            } else {
                if ((c[J + 12 >> 2] | 0) != (c[J + 16 >> 2] | 0)) {
                    if (!B) {
                        break
                    }
                    W = b;
                    c[W >> 2] = V;
                    ve(p);
                    ve(o);
                    i = e;
                    return
                }
                if ((kc[c[(c[J >> 2] | 0) + 36 >> 2] & 63](J) | 0) == -1) {
                    c[f >> 2] = 0;
                    H = 51;
                    break
                }
                if (!(B ^ (J | 0) == 0)) {
                    break
                }
                W = b;
                c[W >> 2] = V;
                ve(p);
                ve(o);
                i = e;
                return
            }
        } while (0);
        do {
            if ((H | 0) == 51) {
                if (B) {
                    break
                }
                W = b;
                c[W >> 2] = V;
                ve(p);
                ve(o);
                i = e;
                return
            }
        } while (0);
        c[k >> 2] = c[k >> 2] | 2;
        W = b;
        c[W >> 2] = V;
        ve(p);
        ve(o);
        i = e;
        return
    }

    function wg(a, b, d, e, f, g, h) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        var j = 0,
            k = 0,
            l = 0,
            m = 0;
        b = i;
        i = i + 32 | 0;
        j = b;
        k = b + 8 | 0;
        l = b + 16 | 0;
        m = b + 24 | 0;
        c[l >> 2] = c[d >> 2];
        c[m >> 2] = c[e >> 2];
        e = k;
        d = l;
        c[e + 0 >> 2] = c[d + 0 >> 2];
        d = j;
        e = m;
        c[d + 0 >> 2] = c[e + 0 >> 2];
        xg(a, 0, k, j, f, g, h);
        i = b;
        return
    }

    function xg(b, e, f, g, j, k, l) {
        b = b | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        j = j | 0;
        k = k | 0;
        l = l | 0;
        var m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0,
            V = 0,
            W = 0;
        e = i;
        i = i + 280 | 0;
        m = e + 32 | 0;
        n = e + 40 | 0;
        o = e + 48 | 0;
        p = e + 64 | 0;
        q = e + 80 | 0;
        r = e + 88 | 0;
        s = e + 248 | 0;
        t = e + 256 | 0;
        u = e + 264 | 0;
        v = e + 272 | 0;
        w = e;
        _g(o, j, w, m, n);
        j = p;
        c[j + 0 >> 2] = 0;
        c[j + 4 >> 2] = 0;
        c[j + 8 >> 2] = 0;
        xe(p, 10, 0);
        if ((a[j] & 1) == 0) {
            x = p + 1 | 0;
            y = x;
            z = p + 8 | 0;
            A = x
        } else {
            x = p + 8 | 0;
            y = p + 1 | 0;
            z = x;
            A = c[x >> 2] | 0
        }
        c[q >> 2] = A;
        x = r;
        c[s >> 2] = x;
        c[t >> 2] = 0;
        a[u] = 1;
        a[v] = 69;
        B = f;
        f = g;
        g = p;
        C = p + 4 | 0;
        D = a[m] | 0;
        m = a[n] | 0;
        n = c[B >> 2] | 0;
        E = A;
        a: while (1) {
            do {
                if ((n | 0) == 0) {
                    F = 0
                } else {
                    if ((c[n + 12 >> 2] | 0) != (c[n + 16 >> 2] | 0)) {
                        F = n;
                        break
                    }
                    if (!((kc[c[(c[n >> 2] | 0) + 36 >> 2] & 63](n) | 0) == -1)) {
                        F = n;
                        break
                    }
                    c[B >> 2] = 0;
                    F = 0
                }
            } while (0);
            A = (F | 0) == 0;
            G = c[f >> 2] | 0;
            do {
                if ((G | 0) == 0) {
                    H = 14
                } else {
                    if ((c[G + 12 >> 2] | 0) != (c[G + 16 >> 2] | 0)) {
                        if (A) {
                            I = G;
                            break
                        } else {
                            J = G;
                            K = E;
                            break a
                        }
                    }
                    if ((kc[c[(c[G >> 2] | 0) + 36 >> 2] & 63](G) | 0) == -1) {
                        c[f >> 2] = 0;
                        H = 14;
                        break
                    } else {
                        if (A) {
                            I = G;
                            break
                        } else {
                            J = G;
                            K = E;
                            break a
                        }
                    }
                }
            } while (0);
            if ((H | 0) == 14) {
                H = 0;
                if (A) {
                    J = 0;
                    K = E;
                    break
                } else {
                    I = 0
                }
            }
            G = a[j] | 0;
            L = (G & 1) == 0;
            if (L) {
                M = (G & 255) >>> 1
            } else {
                M = c[C >> 2] | 0
            } if (((c[q >> 2] | 0) - E | 0) == (M | 0)) {
                if (L) {
                    N = (G & 255) >>> 1;
                    O = (G & 255) >>> 1
                } else {
                    G = c[C >> 2] | 0;
                    N = G;
                    O = G
                }
                xe(p, O << 1, 0);
                if ((a[j] & 1) == 0) {
                    P = 10
                } else {
                    P = (c[g >> 2] & -2) + -1 | 0
                }
                xe(p, P, 0);
                if ((a[j] & 1) == 0) {
                    Q = y
                } else {
                    Q = c[z >> 2] | 0
                }
                c[q >> 2] = Q + N;
                R = Q
            } else {
                R = E
            }
            G = F + 12 | 0;
            L = c[G >> 2] | 0;
            S = F + 16 | 0;
            if ((L | 0) == (c[S >> 2] | 0)) {
                T = kc[c[(c[F >> 2] | 0) + 36 >> 2] & 63](F) | 0
            } else {
                T = d[L] | 0
            } if (($g(T & 255, u, v, R, q, D, m, o, x, s, t, w) | 0) != 0) {
                J = I;
                K = R;
                break
            }
            L = c[G >> 2] | 0;
            if ((L | 0) == (c[S >> 2] | 0)) {
                kc[c[(c[F >> 2] | 0) + 40 >> 2] & 63](F) | 0;
                n = F;
                E = R;
                continue
            } else {
                c[G >> 2] = L + 1;
                n = F;
                E = R;
                continue
            }
        }
        R = a[o] | 0;
        if ((R & 1) == 0) {
            U = (R & 255) >>> 1
        } else {
            U = c[o + 4 >> 2] | 0
        }
        do {
            if ((U | 0) != 0) {
                if ((a[u] | 0) == 0) {
                    break
                }
                R = c[s >> 2] | 0;
                if ((R - r | 0) >= 160) {
                    break
                }
                E = c[t >> 2] | 0;
                c[s >> 2] = R + 4;
                c[R >> 2] = E
            }
        } while (0);
        h[l >> 3] = +Kl(K, c[q >> 2] | 0, k);
        jj(o, x, c[s >> 2] | 0, k);
        do {
            if ((F | 0) == 0) {
                V = 0
            } else {
                if ((c[F + 12 >> 2] | 0) != (c[F + 16 >> 2] | 0)) {
                    V = F;
                    break
                }
                if (!((kc[c[(c[F >> 2] | 0) + 36 >> 2] & 63](F) | 0) == -1)) {
                    V = F;
                    break
                }
                c[B >> 2] = 0;
                V = 0
            }
        } while (0);
        B = (V | 0) == 0;
        do {
            if ((J | 0) == 0) {
                H = 51
            } else {
                if ((c[J + 12 >> 2] | 0) != (c[J + 16 >> 2] | 0)) {
                    if (!B) {
                        break
                    }
                    W = b;
                    c[W >> 2] = V;
                    ve(p);
                    ve(o);
                    i = e;
                    return
                }
                if ((kc[c[(c[J >> 2] | 0) + 36 >> 2] & 63](J) | 0) == -1) {
                    c[f >> 2] = 0;
                    H = 51;
                    break
                }
                if (!(B ^ (J | 0) == 0)) {
                    break
                }
                W = b;
                c[W >> 2] = V;
                ve(p);
                ve(o);
                i = e;
                return
            }
        } while (0);
        do {
            if ((H | 0) == 51) {
                if (B) {
                    break
                }
                W = b;
                c[W >> 2] = V;
                ve(p);
                ve(o);
                i = e;
                return
            }
        } while (0);
        c[k >> 2] = c[k >> 2] | 2;
        W = b;
        c[W >> 2] = V;
        ve(p);
        ve(o);
        i = e;
        return
    }

    function yg(b, e, f, g, h, j, k) {
        b = b | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        var l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0,
            V = 0,
            W = 0,
            X = 0,
            Y = 0,
            Z = 0,
            _ = 0,
            $ = 0;
        e = i;
        i = i + 8 | 0;
        l = e;
        m = i;
        i = i + 16 | 0;
        n = i;
        i = i + 32 | 0;
        o = i;
        i = i + 16 | 0;
        p = i;
        i = i + 8 | 0;
        q = i;
        i = i + 16 | 0;
        r = i;
        i = i + 160 | 0;
        s = o;
        c[s + 0 >> 2] = 0;
        c[s + 4 >> 2] = 0;
        c[s + 8 >> 2] = 0;
        Pe(p, h);
        h = p;
        p = c[h >> 2] | 0;
        if (!((c[1826] | 0) == -1)) {
            c[m >> 2] = 7304;
            c[m + 4 >> 2] = 113;
            c[m + 8 >> 2] = 0;
            qe(7304, m, 114)
        }
        m = (c[7308 >> 2] | 0) + -1 | 0;
        t = c[p + 8 >> 2] | 0;
        if (!((c[p + 12 >> 2] | 0) - t >> 2 >>> 0 > m >>> 0)) {
            u = Ta(4) | 0;
            v = u;
            mm(v);
            Vb(u | 0, 15264, 101)
        }
        p = c[t + (m << 2) >> 2] | 0;
        if ((p | 0) == 0) {
            u = Ta(4) | 0;
            v = u;
            mm(v);
            Vb(u | 0, 15264, 101)
        }
        u = n;
        qc[c[(c[p >> 2] | 0) + 32 >> 2] & 7](p, 5848, 5874 | 0, u) | 0;
        Yd(c[h >> 2] | 0) | 0;
        h = q;
        c[h + 0 >> 2] = 0;
        c[h + 4 >> 2] = 0;
        c[h + 8 >> 2] = 0;
        xe(q, 10, 0);
        if ((a[h] & 1) == 0) {
            p = q + 1 | 0;
            w = p;
            x = q + 8 | 0;
            y = p
        } else {
            p = q + 8 | 0;
            w = q + 1 | 0;
            x = p;
            y = c[p >> 2] | 0
        }
        p = f;
        f = g;
        g = q;
        v = q + 4 | 0;
        m = n + 24 | 0;
        t = n + 25 | 0;
        z = r;
        A = n + 26 | 0;
        B = n;
        n = o + 4 | 0;
        C = c[p >> 2] | 0;
        D = y;
        E = r;
        r = 0;
        F = y;
        a: while (1) {
            do {
                if ((C | 0) == 0) {
                    G = 0
                } else {
                    if ((c[C + 12 >> 2] | 0) != (c[C + 16 >> 2] | 0)) {
                        G = C;
                        break
                    }
                    if (!((kc[c[(c[C >> 2] | 0) + 36 >> 2] & 63](C) | 0) == -1)) {
                        G = C;
                        break
                    }
                    c[p >> 2] = 0;
                    G = 0
                }
            } while (0);
            y = (G | 0) == 0;
            H = c[f >> 2] | 0;
            do {
                if ((H | 0) == 0) {
                    I = 19
                } else {
                    if ((c[H + 12 >> 2] | 0) != (c[H + 16 >> 2] | 0)) {
                        if (y) {
                            break
                        } else {
                            J = F;
                            break a
                        }
                    }
                    if ((kc[c[(c[H >> 2] | 0) + 36 >> 2] & 63](H) | 0) == -1) {
                        c[f >> 2] = 0;
                        I = 19;
                        break
                    } else {
                        if (y) {
                            break
                        } else {
                            J = F;
                            break a
                        }
                    }
                }
            } while (0);
            if ((I | 0) == 19) {
                I = 0;
                if (y) {
                    J = F;
                    break
                }
            }
            H = a[h] | 0;
            K = (H & 1) == 0;
            if (K) {
                L = (H & 255) >>> 1
            } else {
                L = c[v >> 2] | 0
            } if ((D - F | 0) == (L | 0)) {
                if (K) {
                    M = (H & 255) >>> 1;
                    N = (H & 255) >>> 1
                } else {
                    H = c[v >> 2] | 0;
                    M = H;
                    N = H
                }
                xe(q, N << 1, 0);
                if ((a[h] & 1) == 0) {
                    O = 10
                } else {
                    O = (c[g >> 2] & -2) + -1 | 0
                }
                xe(q, O, 0);
                if ((a[h] & 1) == 0) {
                    P = w
                } else {
                    P = c[x >> 2] | 0
                }
                Q = P + M | 0;
                R = P
            } else {
                Q = D;
                R = F
            }
            H = c[G + 12 >> 2] | 0;
            if ((H | 0) == (c[G + 16 >> 2] | 0)) {
                S = kc[c[(c[G >> 2] | 0) + 36 >> 2] & 63](G) | 0
            } else {
                S = d[H] | 0
            }
            H = S & 255;
            K = (Q | 0) == (R | 0);
            do {
                if (K) {
                    T = (a[m] | 0) == H << 24 >> 24;
                    if (!T) {
                        if (!((a[t] | 0) == H << 24 >> 24)) {
                            I = 40;
                            break
                        }
                    }
                    a[Q] = T ? 43 : 45;
                    U = Q + 1 | 0;
                    V = E;
                    W = 0
                } else {
                    I = 40
                }
            } while (0);
            do {
                if ((I | 0) == 40) {
                    I = 0;
                    y = a[s] | 0;
                    if ((y & 1) == 0) {
                        X = (y & 255) >>> 1
                    } else {
                        X = c[n >> 2] | 0
                    } if ((X | 0) != 0 & H << 24 >> 24 == 0) {
                        if ((E - z | 0) >= 160) {
                            U = Q;
                            V = E;
                            W = r;
                            break
                        }
                        c[E >> 2] = r;
                        U = Q;
                        V = E + 4 | 0;
                        W = 0;
                        break
                    } else {
                        Y = u
                    }
                    while (1) {
                        y = Y + 1 | 0;
                        if ((a[Y] | 0) == H << 24 >> 24) {
                            Z = Y;
                            break
                        }
                        if ((y | 0) == (A | 0)) {
                            Z = A;
                            break
                        } else {
                            Y = y
                        }
                    }
                    y = Z - B | 0;
                    if ((y | 0) > 23) {
                        J = R;
                        break a
                    }
                    if ((y | 0) < 22) {
                        a[Q] = a[5848 + y | 0] | 0;
                        U = Q + 1 | 0;
                        V = E;
                        W = r + 1 | 0;
                        break
                    }
                    if (K) {
                        J = Q;
                        break a
                    }
                    if ((Q - R | 0) >= 3) {
                        J = R;
                        break a
                    }
                    if ((a[Q + -1 | 0] | 0) != 48) {
                        J = R;
                        break a
                    }
                    a[Q] = a[5848 + y | 0] | 0;
                    U = Q + 1 | 0;
                    V = E;
                    W = 0
                }
            } while (0);
            K = c[p >> 2] | 0;
            H = K + 12 | 0;
            y = c[H >> 2] | 0;
            if ((y | 0) == (c[K + 16 >> 2] | 0)) {
                kc[c[(c[K >> 2] | 0) + 40 >> 2] & 63](K) | 0;
                C = K;
                D = U;
                E = V;
                r = W;
                F = R;
                continue
            } else {
                c[H >> 2] = y + 1;
                C = K;
                D = U;
                E = V;
                r = W;
                F = R;
                continue
            }
        }
        a[J + 3 | 0] = 0;
        do {
            if ((a[7200] | 0) == 0) {
                if ((Ma(7200) | 0) == 0) {
                    break
                }
                c[1798] = hb(2147483647, 7208, 0) | 0;
                Za(7200)
            }
        } while (0);
        R = c[1798] | 0;
        c[l >> 2] = k;
        if ((Ag(J, R, 5888, l) | 0) != 1) {
            c[j >> 2] = 4
        }
        l = c[p >> 2] | 0;
        do {
            if ((l | 0) == 0) {
                _ = 0
            } else {
                if ((c[l + 12 >> 2] | 0) != (c[l + 16 >> 2] | 0)) {
                    _ = l;
                    break
                }
                if (!((kc[c[(c[l >> 2] | 0) + 36 >> 2] & 63](l) | 0) == -1)) {
                    _ = l;
                    break
                }
                c[p >> 2] = 0;
                _ = 0
            }
        } while (0);
        p = (_ | 0) == 0;
        l = c[f >> 2] | 0;
        do {
            if ((l | 0) == 0) {
                I = 72
            } else {
                if ((c[l + 12 >> 2] | 0) != (c[l + 16 >> 2] | 0)) {
                    if (!p) {
                        break
                    }
                    $ = b;
                    c[$ >> 2] = _;
                    ve(q);
                    ve(o);
                    i = e;
                    return
                }
                if ((kc[c[(c[l >> 2] | 0) + 36 >> 2] & 63](l) | 0) == -1) {
                    c[f >> 2] = 0;
                    I = 72;
                    break
                }
                if (!(p ^ (l | 0) == 0)) {
                    break
                }
                $ = b;
                c[$ >> 2] = _;
                ve(q);
                ve(o);
                i = e;
                return
            }
        } while (0);
        do {
            if ((I | 0) == 72) {
                if (p) {
                    break
                }
                $ = b;
                c[$ >> 2] = _;
                ve(q);
                ve(o);
                i = e;
                return
            }
        } while (0);
        c[j >> 2] = c[j >> 2] | 2;
        $ = b;
        c[$ >> 2] = _;
        ve(q);
        ve(o);
        i = e;
        return
    }

    function zg(b, d, e, f, g, h, j, k, l, m) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        l = l | 0;
        m = m | 0;
        var n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0;
        n = i;
        o = c[f >> 2] | 0;
        p = (o | 0) == (e | 0);
        do {
            if (p) {
                q = (a[m + 24 | 0] | 0) == b << 24 >> 24;
                if (!q) {
                    if (!((a[m + 25 | 0] | 0) == b << 24 >> 24)) {
                        break
                    }
                }
                c[f >> 2] = e + 1;
                a[e] = q ? 43 : 45;
                c[g >> 2] = 0;
                r = 0;
                i = n;
                return r | 0
            }
        } while (0);
        q = a[j] | 0;
        if ((q & 1) == 0) {
            s = (q & 255) >>> 1
        } else {
            s = c[j + 4 >> 2] | 0
        } if ((s | 0) != 0 & b << 24 >> 24 == h << 24 >> 24) {
            h = c[l >> 2] | 0;
            if ((h - k | 0) >= 160) {
                r = 0;
                i = n;
                return r | 0
            }
            k = c[g >> 2] | 0;
            c[l >> 2] = h + 4;
            c[h >> 2] = k;
            c[g >> 2] = 0;
            r = 0;
            i = n;
            return r | 0
        }
        k = m + 26 | 0;
        h = m;
        while (1) {
            l = h + 1 | 0;
            if ((a[h] | 0) == b << 24 >> 24) {
                t = h;
                break
            }
            if ((l | 0) == (k | 0)) {
                t = k;
                break
            } else {
                h = l
            }
        }
        h = t - m | 0;
        if ((h | 0) > 23) {
            r = -1;
            i = n;
            return r | 0
        }
        do {
            if ((d | 0) == 10 | (d | 0) == 8) {
                if ((h | 0) < (d | 0)) {
                    break
                } else {
                    r = -1
                }
                i = n;
                return r | 0
            } else if ((d | 0) == 16) {
                if ((h | 0) < 22) {
                    break
                }
                if (p) {
                    r = -1;
                    i = n;
                    return r | 0
                }
                if ((o - e | 0) >= 3) {
                    r = -1;
                    i = n;
                    return r | 0
                }
                if ((a[o + -1 | 0] | 0) != 48) {
                    r = -1;
                    i = n;
                    return r | 0
                }
                c[g >> 2] = 0;
                m = a[5848 + h | 0] | 0;
                c[f >> 2] = o + 1;
                a[o] = m;
                r = 0;
                i = n;
                return r | 0
            }
        } while (0);
        e = a[5848 + h | 0] | 0;
        c[f >> 2] = o + 1;
        a[o] = e;
        c[g >> 2] = (c[g >> 2] | 0) + 1;
        r = 0;
        i = n;
        return r | 0
    }

    function Ag(a, b, d, e) {
        a = a | 0;
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0;
        f = i;
        i = i + 16 | 0;
        g = f;
        c[g >> 2] = e;
        e = fb(b | 0) | 0;
        b = Ia(a | 0, d | 0, g | 0) | 0;
        if ((e | 0) == 0) {
            i = f;
            return b | 0
        }
        fb(e | 0) | 0;
        i = f;
        return b | 0
    }

    function Bg(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Om(a);
        i = b;
        return
    }

    function Cg(a) {
        a = a | 0;
        i = i;
        return
    }

    function Dg(b, d, e, f, g, h, j) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        var k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0;
        k = i;
        i = i + 136 | 0;
        l = k;
        m = k + 8 | 0;
        n = k + 16 | 0;
        o = k + 24 | 0;
        p = k + 40 | 0;
        q = k + 56 | 0;
        r = k + 64 | 0;
        s = k + 72 | 0;
        t = k + 80 | 0;
        u = k + 88 | 0;
        v = k + 96 | 0;
        w = k + 104 | 0;
        x = k + 128 | 0;
        if ((c[g + 4 >> 2] & 1 | 0) == 0) {
            c[q >> 2] = -1;
            y = c[(c[d >> 2] | 0) + 16 >> 2] | 0;
            z = e;
            c[s >> 2] = c[z >> 2];
            c[t >> 2] = c[f >> 2];
            A = n;
            B = s;
            c[A + 0 >> 2] = c[B + 0 >> 2];
            B = m;
            A = t;
            c[B + 0 >> 2] = c[A + 0 >> 2];
            fc[y & 63](r, d, n, m, g, h, q);
            m = c[r >> 2] | 0;
            c[z >> 2] = m;
            z = c[q >> 2] | 0;
            if ((z | 0) == 1) {
                a[j] = 1
            } else if ((z | 0) == 0) {
                a[j] = 0
            } else {
                a[j] = 1;
                c[h >> 2] = 4
            }
            c[b >> 2] = m;
            i = k;
            return
        }
        Pe(u, g);
        m = u;
        u = c[m >> 2] | 0;
        if (!((c[1824] | 0) == -1)) {
            c[p >> 2] = 7296;
            c[p + 4 >> 2] = 113;
            c[p + 8 >> 2] = 0;
            qe(7296, p, 114)
        }
        p = (c[7300 >> 2] | 0) + -1 | 0;
        z = c[u + 8 >> 2] | 0;
        if (!((c[u + 12 >> 2] | 0) - z >> 2 >>> 0 > p >>> 0)) {
            C = Ta(4) | 0;
            D = C;
            mm(D);
            Vb(C | 0, 15264, 101)
        }
        u = c[z + (p << 2) >> 2] | 0;
        if ((u | 0) == 0) {
            C = Ta(4) | 0;
            D = C;
            mm(D);
            Vb(C | 0, 15264, 101)
        }
        C = u;
        Yd(c[m >> 2] | 0) | 0;
        Pe(v, g);
        g = v;
        v = c[g >> 2] | 0;
        if (!((c[1864] | 0) == -1)) {
            c[o >> 2] = 7456;
            c[o + 4 >> 2] = 113;
            c[o + 8 >> 2] = 0;
            qe(7456, o, 114)
        }
        o = (c[7460 >> 2] | 0) + -1 | 0;
        m = c[v + 8 >> 2] | 0;
        if (!((c[v + 12 >> 2] | 0) - m >> 2 >>> 0 > o >>> 0)) {
            E = Ta(4) | 0;
            F = E;
            mm(F);
            Vb(E | 0, 15264, 101)
        }
        v = c[m + (o << 2) >> 2] | 0;
        if ((v | 0) == 0) {
            E = Ta(4) | 0;
            F = E;
            mm(F);
            Vb(E | 0, 15264, 101)
        }
        E = v;
        Yd(c[g >> 2] | 0) | 0;
        g = w;
        F = v;
        ic[c[(c[F >> 2] | 0) + 24 >> 2] & 63](g, E);
        ic[c[(c[F >> 2] | 0) + 28 >> 2] & 63](w + 12 | 0, E);
        c[x >> 2] = c[f >> 2];
        f = w + 24 | 0;
        E = l;
        F = x;
        c[E + 0 >> 2] = c[F + 0 >> 2];
        F = Eg(e, l, g, f, C, h, 1) | 0;
        a[j] = (F | 0) == (g | 0) | 0;
        c[b >> 2] = c[e >> 2];
        Ge(w + 12 | 0);
        Ge(w);
        i = k;
        return
    }



    function ej(e, f, g, h, j, k, l, m, n, o, p) {
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        l = l | 0;
        m = m | 0;
        n = n | 0;
        o = o | 0;
        p = p | 0;
        var q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0,
            V = 0,
            W = 0,
            X = 0,
            Y = 0,
            Z = 0,
            _ = 0,
            $ = 0,
            aa = 0,
            ba = 0,
            ca = 0,
            da = 0,
            ea = 0,
            fa = 0,
            ga = 0,
            ha = 0,
            ia = 0,
            ja = 0,
            ka = 0,
            la = 0,
            ma = 0,
            na = 0,
            oa = 0,
            pa = 0,
            qa = 0,
            ra = 0,
            sa = 0,
            ta = 0,
            ua = 0,
            va = 0,
            wa = 0,
            xa = 0,
            ya = 0,
            za = 0,
            Aa = 0,
            Ba = 0,
            Ca = 0,
            Da = 0,
            Ea = 0,
            Fa = 0,
            Ga = 0,
            Ha = 0,
            Ia = 0,
            Ja = 0,
            Ka = 0,
            La = 0,
            Ma = 0,
            Na = 0,
            Oa = 0,
            Pa = 0,
            Qa = 0,
            Ra = 0,
            Sa = 0,
            Ta = 0,
            Ua = 0,
            Va = 0,
            Wa = 0,
            Xa = 0,
            Ya = 0,
            Za = 0,
            _a = 0,
            $a = 0,
            ab = 0,
            bb = 0,
            cb = 0,
            db = 0,
            eb = 0,
            fb = 0,
            gb = 0,
            hb = 0,
            ib = 0,
            jb = 0,
            kb = 0,
            lb = 0,
            mb = 0,
            nb = 0,
            ob = 0,
            pb = 0,
            qb = 0,
            rb = 0,
            sb = 0,
            tb = 0,
            ub = 0,
            vb = 0,
            wb = 0,
            xb = 0,
            yb = 0,
            zb = 0,
            Ab = 0,
            Bb = 0,
            Cb = 0,
            Db = 0,
            Eb = 0,
            Fb = 0,
            Gb = 0,
            Hb = 0,
            Ib = 0,
            Jb = 0,
            Kb = 0,
            Lb = 0,
            Mb = 0,
            Nb = 0,
            Ob = 0,
            Pb = 0,
            Qb = 0,
            Rb = 0,
            Sb = 0,
            Tb = 0,
            Ub = 0,
            Vb = 0,
            Wb = 0,
            Xb = 0,
            Yb = 0,
            Zb = 0,
            _b = 0,
            $b = 0,
            ac = 0,
            bc = 0,
            cc = 0,
            dc = 0,
            ec = 0,
            fc = 0,
            gc = 0,
            ic = 0,
            jc = 0,
            lc = 0,
            mc = 0,
            nc = 0,
            oc = 0,
            pc = 0,
            qc = 0,
            rc = 0,
            sc = 0,
            tc = 0,
            uc = 0,
            vc = 0,
            wc = 0;
        q = i;
        i = i + 408 | 0;
        r = q;
        s = q + 400 | 0;
        t = s;
        u = i;
        i = i + 8 | 0;
        v = i;
        i = i + 8 | 0;
        w = i;
        i = i + 16 | 0;
        x = i;
        i = i + 16 | 0;
        y = i;
        i = i + 16 | 0;
        z = i;
        i = i + 16 | 0;
        A = i;
        i = i + 16 | 0;
        B = i;
        i = i + 8 | 0;
        C = i;
        i = i + 8 | 0;
        D = r;
        c[s >> 2] = 0;
        E = w;
        c[E + 0 >> 2] = 0;
        c[E + 4 >> 2] = 0;
        c[E + 8 >> 2] = 0;
        F = x;
        c[F + 0 >> 2] = 0;
        c[F + 4 >> 2] = 0;
        c[F + 8 >> 2] = 0;
        G = y;
        c[G + 0 >> 2] = 0;
        c[G + 4 >> 2] = 0;
        c[G + 8 >> 2] = 0;
        H = z;
        c[H + 0 >> 2] = 0;
        c[H + 4 >> 2] = 0;
        c[H + 8 >> 2] = 0;
        I = A;
        c[I + 0 >> 2] = 0;
        c[I + 4 >> 2] = 0;
        c[I + 8 >> 2] = 0;
        ij(g, h, t, u, v, w, x, y, z, B);
        t = n;
        c[o >> 2] = c[t >> 2];
        h = e;
        e = f;
        f = s;
        s = m + 8 | 0;
        m = z + 1 | 0;
        g = z + 4 | 0;
        J = z + 8 | 0;
        K = y + 1 | 0;
        L = y + 4 | 0;
        M = y + 8 | 0;
        N = (j & 512 | 0) != 0;
        j = x + 1 | 0;
        O = x + 8 | 0;
        P = x + 4 | 0;
        Q = A;
        R = Q + 1 | 0;
        S = A + 8 | 0;
        T = A + 4 | 0;
        U = f + 3 | 0;
        V = n + 4 | 0;
        n = w + 4 | 0;
        W = r + 400 | 0;
        r = D;
        X = D;
        D = p;
        p = 0;
        Y = 0;
        Z = 115;
        a: while (1) {
            _ = c[h >> 2] | 0;
            do {
                if ((_ | 0) == 0) {
                    $ = 0
                } else {
                    if ((c[_ + 12 >> 2] | 0) != (c[_ + 16 >> 2] | 0)) {
                        $ = _;
                        break
                    }
                    if ((kc[c[(c[_ >> 2] | 0) + 36 >> 2] & 63](_) | 0) == -1) {
                        c[h >> 2] = 0;
                        $ = 0;
                        break
                    } else {
                        $ = c[h >> 2] | 0;
                        break
                    }
                }
            } while (0);
            _ = ($ | 0) == 0;
            aa = c[e >> 2] | 0;
            do {
                if ((aa | 0) == 0) {
                    ba = 12
                } else {
                    if ((c[aa + 12 >> 2] | 0) != (c[aa + 16 >> 2] | 0)) {
                        if (_) {
                            ca = aa;
                            break
                        } else {
                            da = X;
                            ea = r;
                            fa = Y;
                            ga = Z;
                            ba = 269;
                            break a
                        }
                    }
                    if ((kc[c[(c[aa >> 2] | 0) + 36 >> 2] & 63](aa) | 0) == -1) {
                        c[e >> 2] = 0;
                        ba = 12;
                        break
                    } else {
                        if (_) {
                            ca = aa;
                            break
                        } else {
                            da = X;
                            ea = r;
                            fa = Y;
                            ga = Z;
                            ba = 269;
                            break a
                        }
                    }
                }
            } while (0);
            if ((ba | 0) == 12) {
                ba = 0;
                if (_) {
                    da = X;
                    ea = r;
                    fa = Y;
                    ga = Z;
                    ba = 269;
                    break
                } else {
                    ca = 0
                }
            }
            b: do {
                switch (a[f + p | 0] | 0) {
                case 4:
                    {
                        aa = D;
                        ha = X;
                        ia = r;
                        ja = W;
                        ka = 0;
                        la = Z;
                        c: while (1) {
                            ma = c[h >> 2] | 0;
                            do {
                                if ((ma | 0) == 0) {
                                    na = 0
                                } else {
                                    if ((c[ma + 12 >> 2] | 0) != (c[ma + 16 >> 2] | 0)) {
                                        na = ma;
                                        break
                                    }
                                    if ((kc[c[(c[ma >> 2] | 0) + 36 >> 2] & 63](ma) | 0) == -1) {
                                        c[h >> 2] = 0;
                                        na = 0;
                                        break
                                    } else {
                                        na = c[h >> 2] | 0;
                                        break
                                    }
                                }
                            } while (0);
                            ma = (na | 0) == 0;
                            oa = c[e >> 2] | 0;
                            do {
                                if ((oa | 0) == 0) {
                                    ba = 173
                                } else {
                                    if ((c[oa + 12 >> 2] | 0) != (c[oa + 16 >> 2] | 0)) {
                                        if (ma) {
                                            break
                                        } else {
                                            break c
                                        }
                                    }
                                    if ((kc[c[(c[oa >> 2] | 0) + 36 >> 2] & 63](oa) | 0) == -1) {
                                        c[e >> 2] = 0;
                                        ba = 173;
                                        break
                                    } else {
                                        if (ma) {
                                            break
                                        } else {
                                            break c
                                        }
                                    }
                                }
                            } while (0);
                            if ((ba | 0) == 173) {
                                ba = 0;
                                if (ma) {
                                    break
                                }
                            }
                            oa = c[h >> 2] | 0;
                            pa = c[oa + 12 >> 2] | 0;
                            if ((pa | 0) == (c[oa + 16 >> 2] | 0)) {
                                qa = kc[c[(c[oa >> 2] | 0) + 36 >> 2] & 63](oa) | 0
                            } else {
                                qa = d[pa] | 0
                            }
                            pa = qa & 255;
                            do {
                                if (pa << 24 >> 24 > -1) {
                                    if ((b[(c[s >> 2] | 0) + (qa << 24 >> 24 << 1) >> 1] & 2048) == 0) {
                                        ba = 189;
                                        break
                                    }
                                    oa = c[o >> 2] | 0;
                                    if ((oa | 0) == (aa | 0)) {
                                        ra = (c[V >> 2] | 0) != 115;
                                        sa = c[t >> 2] | 0;
                                        ta = aa - sa | 0;
                                        ua = ta >>> 0 < 2147483647 ? ta << 1 : -1;
                                        va = Jm(ra ? sa : 0, ua) | 0;
                                        if ((va | 0) == 0) {
                                            ba = 182;
                                            break a
                                        }
                                        do {
                                            if (ra) {
                                                c[t >> 2] = va;
                                                wa = va
                                            } else {
                                                sa = c[t >> 2] | 0;
                                                c[t >> 2] = va;
                                                if ((sa | 0) == 0) {
                                                    wa = va;
                                                    break
                                                }
                                                hc[c[V >> 2] & 127](sa);
                                                wa = c[t >> 2] | 0
                                            }
                                        } while (0);
                                        c[V >> 2] = 116;
                                        va = wa + ta | 0;
                                        c[o >> 2] = va;
                                        xa = va;
                                        ya = (c[t >> 2] | 0) + ua | 0
                                    } else {
                                        xa = oa;
                                        ya = aa
                                    }
                                    c[o >> 2] = xa + 1;
                                    a[xa] = pa;
                                    za = ya;
                                    Aa = ha;
                                    Ba = ia;
                                    Ca = ja;
                                    Da = ka + 1 | 0;
                                    Ea = la
                                } else {
                                    ba = 189
                                }
                            } while (0);
                            if ((ba | 0) == 189) {
                                ba = 0;
                                ma = a[E] | 0;
                                if ((ma & 1) == 0) {
                                    Fa = (ma & 255) >>> 1
                                } else {
                                    Fa = c[n >> 2] | 0
                                } if ((Fa | 0) == 0 | (ka | 0) == 0) {
                                    break
                                }
                                if (!(pa << 24 >> 24 == (a[v] | 0))) {
                                    break
                                }
                                if ((ia | 0) == (ja | 0)) {
                                    ma = ia - ha | 0;
                                    va = ma >>> 0 < 2147483647 ? ma << 1 : -1;
                                    if ((la | 0) == 115) {
                                        Ga = 0
                                    } else {
                                        Ga = ha
                                    }
                                    ra = Jm(Ga, va) | 0;
                                    sa = ra;
                                    if ((ra | 0) == 0) {
                                        ba = 198;
                                        break a
                                    }
                                    Ha = sa;
                                    Ia = sa + (ma >> 2 << 2) | 0;
                                    Ja = sa + (va >>> 2 << 2) | 0;
                                    Ka = 116
                                } else {
                                    Ha = ha;
                                    Ia = ia;
                                    Ja = ja;
                                    Ka = la
                                }
                                c[Ia >> 2] = ka;
                                za = aa;
                                Aa = Ha;
                                Ba = Ia + 4 | 0;
                                Ca = Ja;
                                Da = 0;
                                Ea = Ka
                            }
                            va = c[h >> 2] | 0;
                            sa = va + 12 | 0;
                            ma = c[sa >> 2] | 0;
                            if ((ma | 0) == (c[va + 16 >> 2] | 0)) {
                                kc[c[(c[va >> 2] | 0) + 40 >> 2] & 63](va) | 0;
                                aa = za;
                                ha = Aa;
                                ia = Ba;
                                ja = Ca;
                                ka = Da;
                                la = Ea;
                                continue
                            } else {
                                c[sa >> 2] = ma + 1;
                                aa = za;
                                ha = Aa;
                                ia = Ba;
                                ja = Ca;
                                ka = Da;
                                la = Ea;
                                continue
                            }
                        }
                        if ((ha | 0) == (ia | 0) | (ka | 0) == 0) {
                            La = ha;
                            Ma = ia;
                            Na = ja;
                            Oa = la
                        } else {
                            if ((ia | 0) == (ja | 0)) {
                                ma = ia - ha | 0;
                                sa = ma >>> 0 < 2147483647 ? ma << 1 : -1;
                                if ((la | 0) == 115) {
                                    Pa = 0
                                } else {
                                    Pa = ha
                                }
                                va = Jm(Pa, sa) | 0;
                                ra = va;
                                if ((va | 0) == 0) {
                                    ba = 209;
                                    break a
                                }
                                Qa = ra;
                                Ra = ra + (ma >> 2 << 2) | 0;
                                Sa = ra + (sa >>> 2 << 2) | 0;
                                Ta = 116
                            } else {
                                Qa = ha;
                                Ra = ia;
                                Sa = ja;
                                Ta = la
                            }
                            c[Ra >> 2] = ka;
                            La = Qa;
                            Ma = Ra + 4 | 0;
                            Na = Sa;
                            Oa = Ta
                        }
                        sa = c[B >> 2] | 0;
                        if ((sa | 0) > 0) {
                            ra = c[h >> 2] | 0;
                            do {
                                if ((ra | 0) == 0) {
                                    Ua = 0
                                } else {
                                    if ((c[ra + 12 >> 2] | 0) != (c[ra + 16 >> 2] | 0)) {
                                        Ua = ra;
                                        break
                                    }
                                    if ((kc[c[(c[ra >> 2] | 0) + 36 >> 2] & 63](ra) | 0) == -1) {
                                        c[h >> 2] = 0;
                                        Ua = 0;
                                        break
                                    } else {
                                        Ua = c[h >> 2] | 0;
                                        break
                                    }
                                }
                            } while (0);
                            ra = (Ua | 0) == 0;
                            ka = c[e >> 2] | 0;
                            do {
                                if ((ka | 0) == 0) {
                                    ba = 223
                                } else {
                                    if ((c[ka + 12 >> 2] | 0) != (c[ka + 16 >> 2] | 0)) {
                                        if (ra) {
                                            Va = ka;
                                            break
                                        } else {
                                            ba = 229;
                                            break a
                                        }
                                    }
                                    if ((kc[c[(c[ka >> 2] | 0) + 36 >> 2] & 63](ka) | 0) == -1) {
                                        c[e >> 2] = 0;
                                        ba = 223;
                                        break
                                    } else {
                                        if (ra) {
                                            Va = ka;
                                            break
                                        } else {
                                            ba = 229;
                                            break a
                                        }
                                    }
                                }
                            } while (0);
                            if ((ba | 0) == 223) {
                                ba = 0;
                                if (ra) {
                                    ba = 229;
                                    break a
                                } else {
                                    Va = 0
                                }
                            }
                            ka = c[h >> 2] | 0;
                            la = c[ka + 12 >> 2] | 0;
                            if ((la | 0) == (c[ka + 16 >> 2] | 0)) {
                                Wa = kc[c[(c[ka >> 2] | 0) + 36 >> 2] & 63](ka) | 0
                            } else {
                                Wa = d[la] | 0
                            } if (!((Wa & 255) << 24 >> 24 == (a[u] | 0))) {
                                ba = 229;
                                break a
                            }
                            la = c[h >> 2] | 0;
                            ka = la + 12 | 0;
                            ja = c[ka >> 2] | 0;
                            if ((ja | 0) == (c[la + 16 >> 2] | 0)) {
                                kc[c[(c[la >> 2] | 0) + 40 >> 2] & 63](la) | 0;
                                Xa = Va;
                                Ya = sa;
                                Za = Va;
                                _a = aa
                            } else {
                                c[ka >> 2] = ja + 1;
                                Xa = Va;
                                Ya = sa;
                                Za = Va;
                                _a = aa
                            }
                            while (1) {
                                ja = c[h >> 2] | 0;
                                do {
                                    if ((ja | 0) == 0) {
                                        $a = 0
                                    } else {
                                        if ((c[ja + 12 >> 2] | 0) != (c[ja + 16 >> 2] | 0)) {
                                            $a = ja;
                                            break
                                        }
                                        if ((kc[c[(c[ja >> 2] | 0) + 36 >> 2] & 63](ja) | 0) == -1) {
                                            c[h >> 2] = 0;
                                            $a = 0;
                                            break
                                        } else {
                                            $a = c[h >> 2] | 0;
                                            break
                                        }
                                    }
                                } while (0);
                                ja = ($a | 0) == 0;
                                do {
                                    if ((Za | 0) == 0) {
                                        ab = Xa;
                                        ba = 243
                                    } else {
                                        if ((c[Za + 12 >> 2] | 0) != (c[Za + 16 >> 2] | 0)) {
                                            if (ja) {
                                                bb = Xa;
                                                cb = Za;
                                                break
                                            } else {
                                                ba = 250;
                                                break a
                                            }
                                        }
                                        if ((kc[c[(c[Za >> 2] | 0) + 36 >> 2] & 63](Za) | 0) == -1) {
                                            c[e >> 2] = 0;
                                            ab = 0;
                                            ba = 243;
                                            break
                                        } else {
                                            if (ja ^ (Xa | 0) == 0) {
                                                bb = Xa;
                                                cb = Xa;
                                                break
                                            } else {
                                                ba = 250;
                                                break a
                                            }
                                        }
                                    }
                                } while (0);
                                if ((ba | 0) == 243) {
                                    ba = 0;
                                    if (ja) {
                                        ba = 250;
                                        break a
                                    } else {
                                        bb = ab;
                                        cb = 0
                                    }
                                }
                                pa = c[h >> 2] | 0;
                                ka = c[pa + 12 >> 2] | 0;
                                if ((ka | 0) == (c[pa + 16 >> 2] | 0)) {
                                    db = kc[c[(c[pa >> 2] | 0) + 36 >> 2] & 63](pa) | 0
                                } else {
                                    db = d[ka] | 0
                                } if (!((db & 255) << 24 >> 24 > -1)) {
                                    ba = 250;
                                    break a
                                }
                                if ((b[(c[s >> 2] | 0) + (db << 24 >> 24 << 1) >> 1] & 2048) == 0) {
                                    ba = 250;
                                    break a
                                }
                                ka = c[o >> 2] | 0;
                                if ((ka | 0) == (_a | 0)) {
                                    pa = (c[V >> 2] | 0) != 115;
                                    la = c[t >> 2] | 0;
                                    ia = _a - la | 0;
                                    ha = ia >>> 0 < 2147483647 ? ia << 1 : -1;
                                    ma = Jm(pa ? la : 0, ha) | 0;
                                    if ((ma | 0) == 0) {
                                        ba = 253;
                                        break a
                                    }
                                    do {
                                        if (pa) {
                                            c[t >> 2] = ma;
                                            eb = ma
                                        } else {
                                            la = c[t >> 2] | 0;
                                            c[t >> 2] = ma;
                                            if ((la | 0) == 0) {
                                                eb = ma;
                                                break
                                            }
                                            hc[c[V >> 2] & 127](la);
                                            eb = c[t >> 2] | 0
                                        }
                                    } while (0);
                                    c[V >> 2] = 116;
                                    ma = eb + ia | 0;
                                    c[o >> 2] = ma;
                                    fb = ma;
                                    gb = (c[t >> 2] | 0) + ha | 0
                                } else {
                                    fb = ka;
                                    gb = _a
                                }
                                ma = c[h >> 2] | 0;
                                pa = c[ma + 12 >> 2] | 0;
                                if ((pa | 0) == (c[ma + 16 >> 2] | 0)) {
                                    ja = kc[c[(c[ma >> 2] | 0) + 36 >> 2] & 63](ma) | 0;
                                    hb = ja;
                                    ib = c[o >> 2] | 0
                                } else {
                                    hb = d[pa] | 0;
                                    ib = fb
                                }
                                c[o >> 2] = ib + 1;
                                a[ib] = hb;
                                pa = Ya + -1 | 0;
                                c[B >> 2] = pa;
                                ja = c[h >> 2] | 0;
                                ma = ja + 12 | 0;
                                la = c[ma >> 2] | 0;
                                if ((la | 0) == (c[ja + 16 >> 2] | 0)) {
                                    kc[c[(c[ja >> 2] | 0) + 40 >> 2] & 63](ja) | 0
                                } else {
                                    c[ma >> 2] = la + 1
                                } if ((pa | 0) > 0) {
                                    Xa = bb;
                                    Ya = pa;
                                    Za = cb;
                                    _a = gb
                                } else {
                                    jb = gb;
                                    break
                                }
                            }
                        } else {
                            jb = aa
                        } if ((c[o >> 2] | 0) == (c[t >> 2] | 0)) {
                            ba = 267;
                            break a
                        } else {
                            kb = jb;
                            lb = La;
                            mb = Ma;
                            nb = Na;
                            ob = Y;
                            pb = Oa
                        }
                        break
                    };
                case 1:
                    {
                        if ((p | 0) == 3) {
                            da = X;
                            ea = r;
                            fa = Y;
                            ga = Z;
                            ba = 269;
                            break a
                        }
                        sa = c[h >> 2] | 0;
                        ra = c[sa + 12 >> 2] | 0;
                        if ((ra | 0) == (c[sa + 16 >> 2] | 0)) {
                            qb = kc[c[(c[sa >> 2] | 0) + 36 >> 2] & 63](sa) | 0
                        } else {
                            qb = d[ra] | 0
                        } if (!((qb & 255) << 24 >> 24 > -1)) {
                            ba = 25;
                            break a
                        }
                        if ((b[(c[s >> 2] | 0) + (qb << 24 >> 24 << 1) >> 1] & 8192) == 0) {
                            ba = 25;
                            break a
                        }
                        ra = c[h >> 2] | 0;
                        sa = ra + 12 | 0;
                        pa = c[sa >> 2] | 0;
                        if ((pa | 0) == (c[ra + 16 >> 2] | 0)) {
                            rb = kc[c[(c[ra >> 2] | 0) + 40 >> 2] & 63](ra) | 0
                        } else {
                            c[sa >> 2] = pa + 1;
                            rb = d[pa] | 0
                        }
                        Ae(A, rb & 255);
                        ba = 26;
                        break
                    };
                case 3:
                    {
                        pa = a[G] | 0;
                        sa = (pa & 1) == 0;
                        if (sa) {
                            sb = (pa & 255) >>> 1
                        } else {
                            sb = c[L >> 2] | 0
                        }
                        ra = a[H] | 0;
                        la = (ra & 1) == 0;
                        if (la) {
                            tb = (ra & 255) >>> 1
                        } else {
                            tb = c[g >> 2] | 0
                        } if ((sb | 0) == (0 - tb | 0)) {
                            kb = D;
                            lb = X;
                            mb = r;
                            nb = W;
                            ob = Y;
                            pb = Z;
                            break b
                        }
                        if (sa) {
                            ub = (pa & 255) >>> 1
                        } else {
                            ub = c[L >> 2] | 0
                        }
                        do {
                            if ((ub | 0) != 0) {
                                if (la) {
                                    vb = (ra & 255) >>> 1
                                } else {
                                    vb = c[g >> 2] | 0
                                } if ((vb | 0) == 0) {
                                    break
                                }
                                ma = c[h >> 2] | 0;
                                ja = c[ma + 12 >> 2] | 0;
                                va = c[ma + 16 >> 2] | 0;
                                if ((ja | 0) == (va | 0)) {
                                    wb = kc[c[(c[ma >> 2] | 0) + 36 >> 2] & 63](ma) | 0;
                                    xb = c[h >> 2] | 0;
                                    yb = wb;
                                    zb = c[xb + 16 >> 2] | 0;
                                    Ab = c[xb + 12 >> 2] | 0;
                                    Bb = xb;
                                    Cb = a[G] | 0
                                } else {
                                    yb = d[ja] | 0;
                                    zb = va;
                                    Ab = ja;
                                    Bb = ma;
                                    Cb = pa
                                }
                                ma = Bb + 12 | 0;
                                ja = (Ab | 0) == (zb | 0);
                                if ((yb & 255) << 24 >> 24 == (a[(Cb & 1) == 0 ? K : c[M >> 2] | 0] | 0)) {
                                    if (ja) {
                                        kc[c[(c[Bb >> 2] | 0) + 40 >> 2] & 63](Bb) | 0
                                    } else {
                                        c[ma >> 2] = Ab + 1
                                    }
                                    ma = a[G] | 0;
                                    if ((ma & 1) == 0) {
                                        Db = (ma & 255) >>> 1
                                    } else {
                                        Db = c[L >> 2] | 0
                                    }
                                    kb = D;
                                    lb = X;
                                    mb = r;
                                    nb = W;
                                    ob = Db >>> 0 > 1 ? y : Y;
                                    pb = Z;
                                    break b
                                }
                                if (ja) {
                                    Eb = kc[c[(c[Bb >> 2] | 0) + 36 >> 2] & 63](Bb) | 0
                                } else {
                                    Eb = d[Ab] | 0
                                } if (!((Eb & 255) << 24 >> 24 == (a[(a[H] & 1) == 0 ? m : c[J >> 2] | 0] | 0))) {
                                    ba = 112;
                                    break a
                                }
                                ja = c[h >> 2] | 0;
                                ma = ja + 12 | 0;
                                va = c[ma >> 2] | 0;
                                if ((va | 0) == (c[ja + 16 >> 2] | 0)) {
                                    kc[c[(c[ja >> 2] | 0) + 40 >> 2] & 63](ja) | 0
                                } else {
                                    c[ma >> 2] = va + 1
                                }
                                a[l] = 1;
                                va = a[H] | 0;
                                if ((va & 1) == 0) {
                                    Fb = (va & 255) >>> 1
                                } else {
                                    Fb = c[g >> 2] | 0
                                }
                                kb = D;
                                lb = X;
                                mb = r;
                                nb = W;
                                ob = Fb >>> 0 > 1 ? z : Y;
                                pb = Z;
                                break b
                            }
                        } while (0);
                        if (sa) {
                            Gb = (pa & 255) >>> 1
                        } else {
                            Gb = c[L >> 2] | 0
                        }
                        la = c[h >> 2] | 0;
                        aa = c[la + 12 >> 2] | 0;
                        va = (aa | 0) == (c[la + 16 >> 2] | 0);
                        if ((Gb | 0) == 0) {
                            if (va) {
                                ma = kc[c[(c[la >> 2] | 0) + 36 >> 2] & 63](la) | 0;
                                Hb = ma;
                                Ib = a[H] | 0
                            } else {
                                Hb = d[aa] | 0;
                                Ib = ra
                            } if (!((Hb & 255) << 24 >> 24 == (a[(Ib & 1) == 0 ? m : c[J >> 2] | 0] | 0))) {
                                kb = D;
                                lb = X;
                                mb = r;
                                nb = W;
                                ob = Y;
                                pb = Z;
                                break b
                            }
                            ma = c[h >> 2] | 0;
                            ja = ma + 12 | 0;
                            xb = c[ja >> 2] | 0;
                            if ((xb | 0) == (c[ma + 16 >> 2] | 0)) {
                                kc[c[(c[ma >> 2] | 0) + 40 >> 2] & 63](ma) | 0
                            } else {
                                c[ja >> 2] = xb + 1
                            }
                            a[l] = 1;
                            xb = a[H] | 0;
                            if ((xb & 1) == 0) {
                                Jb = (xb & 255) >>> 1
                            } else {
                                Jb = c[g >> 2] | 0
                            }
                            kb = D;
                            lb = X;
                            mb = r;
                            nb = W;
                            ob = Jb >>> 0 > 1 ? z : Y;
                            pb = Z;
                            break b
                        }
                        if (va) {
                            va = kc[c[(c[la >> 2] | 0) + 36 >> 2] & 63](la) | 0;
                            Kb = va;
                            Lb = a[G] | 0
                        } else {
                            Kb = d[aa] | 0;
                            Lb = pa
                        } if (!((Kb & 255) << 24 >> 24 == (a[(Lb & 1) == 0 ? K : c[M >> 2] | 0] | 0))) {
                            a[l] = 1;
                            kb = D;
                            lb = X;
                            mb = r;
                            nb = W;
                            ob = Y;
                            pb = Z;
                            break b
                        }
                        aa = c[h >> 2] | 0;
                        va = aa + 12 | 0;
                        la = c[va >> 2] | 0;
                        if ((la | 0) == (c[aa + 16 >> 2] | 0)) {
                            kc[c[(c[aa >> 2] | 0) + 40 >> 2] & 63](aa) | 0
                        } else {
                            c[va >> 2] = la + 1
                        }
                        la = a[G] | 0;
                        if ((la & 1) == 0) {
                            Mb = (la & 255) >>> 1
                        } else {
                            Mb = c[L >> 2] | 0
                        }
                        kb = D;
                        lb = X;
                        mb = r;
                        nb = W;
                        ob = Mb >>> 0 > 1 ? y : Y;
                        pb = Z;
                        break
                    };
                case 2:
                    {
                        if (!((Y | 0) != 0 | p >>> 0 < 2)) {
                            if ((p | 0) == 2) {
                                Nb = (a[U] | 0) != 0
                            } else {
                                Nb = 0
                            } if (!(N | Nb)) {
                                kb = D;
                                lb = X;
                                mb = r;
                                nb = W;
                                ob = 0;
                                pb = Z;
                                break b
                            }
                        }
                        la = a[F] | 0;
                        va = (la & 1) == 0;
                        aa = va ? j : c[O >> 2] | 0;
                        d: do {
                            if ((p | 0) == 0) {
                                Ob = ca;
                                Pb = ca;
                                Qb = la;
                                Rb = aa
                            } else {
                                if ((d[f + (p + -1) | 0] | 0) >= 2) {
                                    Ob = ca;
                                    Pb = ca;
                                    Qb = la;
                                    Rb = aa;
                                    break
                                }
                                xb = aa + (va ? (la & 255) >>> 1 : c[P >> 2] | 0) | 0;
                                ja = aa;
                                while (1) {
                                    if ((ja | 0) == (xb | 0)) {
                                        Sb = xb;
                                        break
                                    }
                                    ma = a[ja] | 0;
                                    if (!(ma << 24 >> 24 > -1)) {
                                        Sb = ja;
                                        break
                                    }
                                    if ((b[(c[s >> 2] | 0) + (ma << 24 >> 24 << 1) >> 1] & 8192) == 0) {
                                        Sb = ja;
                                        break
                                    } else {
                                        ja = ja + 1 | 0
                                    }
                                }
                                ja = Sb - aa | 0;
                                xb = a[I] | 0;
                                ka = (xb & 1) == 0;
                                if (ka) {
                                    Tb = (xb & 255) >>> 1
                                } else {
                                    Tb = c[T >> 2] | 0
                                } if (ja >>> 0 > Tb >>> 0) {
                                    Ob = ca;
                                    Pb = ca;
                                    Qb = la;
                                    Rb = aa;
                                    break
                                }
                                if (ka) {
                                    ka = (xb & 255) >>> 1;
                                    Ub = Q + (ka - ja) + 1 | 0;
                                    Vb = R;
                                    Wb = ka
                                } else {
                                    ka = c[S >> 2] | 0;
                                    xb = c[T >> 2] | 0;
                                    Ub = ka + (xb - ja) | 0;
                                    Vb = ka;
                                    Wb = xb
                                }
                                xb = Vb + Wb | 0;
                                if ((Ub | 0) == (xb | 0)) {
                                    Ob = ca;
                                    Pb = ca;
                                    Qb = la;
                                    Rb = Sb;
                                    break
                                } else {
                                    Xb = aa;
                                    Yb = Ub
                                }
                                while (1) {
                                    if ((a[Yb] | 0) != (a[Xb] | 0)) {
                                        Ob = ca;
                                        Pb = ca;
                                        Qb = la;
                                        Rb = aa;
                                        break d
                                    }
                                    ka = Yb + 1 | 0;
                                    if ((ka | 0) == (xb | 0)) {
                                        Ob = ca;
                                        Pb = ca;
                                        Qb = la;
                                        Rb = Sb;
                                        break
                                    } else {
                                        Xb = Xb + 1 | 0;
                                        Yb = ka
                                    }
                                }
                            }
                        } while (0);
                        e: while (1) {
                            if ((Qb & 1) == 0) {
                                Zb = j;
                                _b = (Qb & 255) >>> 1
                            } else {
                                Zb = c[O >> 2] | 0;
                                _b = c[P >> 2] | 0
                            } if ((Rb | 0) == (Zb + _b | 0)) {
                                break
                            }
                            la = c[h >> 2] | 0;
                            do {
                                if ((la | 0) == 0) {
                                    $b = 0
                                } else {
                                    if ((c[la + 12 >> 2] | 0) != (c[la + 16 >> 2] | 0)) {
                                        $b = la;
                                        break
                                    }
                                    if ((kc[c[(c[la >> 2] | 0) + 36 >> 2] & 63](la) | 0) == -1) {
                                        c[h >> 2] = 0;
                                        $b = 0;
                                        break
                                    } else {
                                        $b = c[h >> 2] | 0;
                                        break
                                    }
                                }
                            } while (0);
                            la = ($b | 0) == 0;
                            do {
                                if ((Pb | 0) == 0) {
                                    ac = Ob;
                                    ba = 147
                                } else {
                                    if ((c[Pb + 12 >> 2] | 0) != (c[Pb + 16 >> 2] | 0)) {
                                        if (la) {
                                            bc = Ob;
                                            cc = Pb;
                                            break
                                        } else {
                                            break e
                                        }
                                    }
                                    if ((kc[c[(c[Pb >> 2] | 0) + 36 >> 2] & 63](Pb) | 0) == -1) {
                                        c[e >> 2] = 0;
                                        ac = 0;
                                        ba = 147;
                                        break
                                    } else {
                                        if (la ^ (Ob | 0) == 0) {
                                            bc = Ob;
                                            cc = Ob;
                                            break
                                        } else {
                                            break e
                                        }
                                    }
                                }
                            } while (0);
                            if ((ba | 0) == 147) {
                                ba = 0;
                                if (la) {
                                    break
                                } else {
                                    bc = ac;
                                    cc = 0
                                }
                            }
                            aa = c[h >> 2] | 0;
                            va = c[aa + 12 >> 2] | 0;
                            if ((va | 0) == (c[aa + 16 >> 2] | 0)) {
                                dc = kc[c[(c[aa >> 2] | 0) + 36 >> 2] & 63](aa) | 0
                            } else {
                                dc = d[va] | 0
                            } if (!((dc & 255) << 24 >> 24 == (a[Rb] | 0))) {
                                break
                            }
                            va = c[h >> 2] | 0;
                            aa = va + 12 | 0;
                            pa = c[aa >> 2] | 0;
                            if ((pa | 0) == (c[va + 16 >> 2] | 0)) {
                                kc[c[(c[va >> 2] | 0) + 40 >> 2] & 63](va) | 0
                            } else {
                                c[aa >> 2] = pa + 1
                            }
                            Ob = bc;
                            Pb = cc;
                            Qb = a[F] | 0;
                            Rb = Rb + 1 | 0
                        }
                        if (!N) {
                            kb = D;
                            lb = X;
                            mb = r;
                            nb = W;
                            ob = Y;
                            pb = Z;
                            break b
                        }
                        pa = a[F] | 0;
                        if ((pa & 1) == 0) {
                            ec = j;
                            fc = (pa & 255) >>> 1
                        } else {
                            ec = c[O >> 2] | 0;
                            fc = c[P >> 2] | 0
                        } if ((Rb | 0) == (ec + fc | 0)) {
                            kb = D;
                            lb = X;
                            mb = r;
                            nb = W;
                            ob = Y;
                            pb = Z
                        } else {
                            ba = 162;
                            break a
                        }
                        break
                    };
                case 0:
                    {
                        ba = 26;
                        break
                    };
                default:
                    {
                        kb = D;
                        lb = X;
                        mb = r;
                        nb = W;
                        ob = Y;
                        pb = Z
                    }
                }
            } while (0);
            f: do {
                if ((ba | 0) == 26) {
                    ba = 0;
                    if ((p | 0) == 3) {
                        da = X;
                        ea = r;
                        fa = Y;
                        ga = Z;
                        ba = 269;
                        break a
                    } else {
                        gc = ca;
                        ic = ca
                    }
                    while (1) {
                        _ = c[h >> 2] | 0;
                        do {
                            if ((_ | 0) == 0) {
                                jc = 0
                            } else {
                                if ((c[_ + 12 >> 2] | 0) != (c[_ + 16 >> 2] | 0)) {
                                    jc = _;
                                    break
                                }
                                if ((kc[c[(c[_ >> 2] | 0) + 36 >> 2] & 63](_) | 0) == -1) {
                                    c[h >> 2] = 0;
                                    jc = 0;
                                    break
                                } else {
                                    jc = c[h >> 2] | 0;
                                    break
                                }
                            }
                        } while (0);
                        _ = (jc | 0) == 0;
                        do {
                            if ((ic | 0) == 0) {
                                lc = gc;
                                ba = 37
                            } else {
                                if ((c[ic + 12 >> 2] | 0) != (c[ic + 16 >> 2] | 0)) {
                                    if (_) {
                                        mc = gc;
                                        nc = ic;
                                        break
                                    } else {
                                        kb = D;
                                        lb = X;
                                        mb = r;
                                        nb = W;
                                        ob = Y;
                                        pb = Z;
                                        break f
                                    }
                                }
                                if ((kc[c[(c[ic >> 2] | 0) + 36 >> 2] & 63](ic) | 0) == -1) {
                                    c[e >> 2] = 0;
                                    lc = 0;
                                    ba = 37;
                                    break
                                } else {
                                    if (_ ^ (gc | 0) == 0) {
                                        mc = gc;
                                        nc = gc;
                                        break
                                    } else {
                                        kb = D;
                                        lb = X;
                                        mb = r;
                                        nb = W;
                                        ob = Y;
                                        pb = Z;
                                        break f
                                    }
                                }
                            }
                        } while (0);
                        if ((ba | 0) == 37) {
                            ba = 0;
                            if (_) {
                                kb = D;
                                lb = X;
                                mb = r;
                                nb = W;
                                ob = Y;
                                pb = Z;
                                break f
                            } else {
                                mc = lc;
                                nc = 0
                            }
                        }
                        la = c[h >> 2] | 0;
                        pa = c[la + 12 >> 2] | 0;
                        if ((pa | 0) == (c[la + 16 >> 2] | 0)) {
                            oc = kc[c[(c[la >> 2] | 0) + 36 >> 2] & 63](la) | 0
                        } else {
                            oc = d[pa] | 0
                        } if (!((oc & 255) << 24 >> 24 > -1)) {
                            kb = D;
                            lb = X;
                            mb = r;
                            nb = W;
                            ob = Y;
                            pb = Z;
                            break f
                        }
                        if ((b[(c[s >> 2] | 0) + (oc << 24 >> 24 << 1) >> 1] & 8192) == 0) {
                            kb = D;
                            lb = X;
                            mb = r;
                            nb = W;
                            ob = Y;
                            pb = Z;
                            break f
                        }
                        pa = c[h >> 2] | 0;
                        la = pa + 12 | 0;
                        aa = c[la >> 2] | 0;
                        if ((aa | 0) == (c[pa + 16 >> 2] | 0)) {
                            pc = kc[c[(c[pa >> 2] | 0) + 40 >> 2] & 63](pa) | 0
                        } else {
                            c[la >> 2] = aa + 1;
                            pc = d[aa] | 0
                        }
                        Ae(A, pc & 255);
                        gc = mc;
                        ic = nc
                    }
                }
            } while (0);
            aa = p + 1 | 0;
            if (aa >>> 0 < 4) {
                W = nb;
                r = mb;
                X = lb;
                D = kb;
                p = aa;
                Y = ob;
                Z = pb
            } else {
                da = lb;
                ea = mb;
                fa = ob;
                ga = pb;
                ba = 269;
                break
            }
        }
        g: do {
            if ((ba | 0) == 25) {
                c[k >> 2] = c[k >> 2] | 4;
                qc = 0;
                rc = X;
                sc = Z
            } else if ((ba | 0) == 112) {
                c[k >> 2] = c[k >> 2] | 4;
                qc = 0;
                rc = X;
                sc = Z
            } else if ((ba | 0) == 162) {
                c[k >> 2] = c[k >> 2] | 4;
                qc = 0;
                rc = X;
                sc = Z
            } else if ((ba | 0) == 182) {
                Tm()
            } else if ((ba | 0) == 198) {
                Tm()
            } else if ((ba | 0) == 209) {
                Tm()
            } else if ((ba | 0) == 229) {
                c[k >> 2] = c[k >> 2] | 4;
                qc = 0;
                rc = La;
                sc = Oa
            } else if ((ba | 0) == 250) {
                c[k >> 2] = c[k >> 2] | 4;
                qc = 0;
                rc = La;
                sc = Oa
            } else if ((ba | 0) == 253) {
                Tm()
            } else if ((ba | 0) == 267) {
                c[k >> 2] = c[k >> 2] | 4;
                qc = 0;
                rc = La;
                sc = Oa
            } else if ((ba | 0) == 269) {
                h: do {
                    if ((fa | 0) != 0) {
                        pb = fa;
                        ob = fa + 1 | 0;
                        mb = fa + 8 | 0;
                        lb = fa + 4 | 0;
                        Y = 1;
                        i: while (1) {
                            p = a[pb] | 0;
                            if ((p & 1) == 0) {
                                tc = (p & 255) >>> 1
                            } else {
                                tc = c[lb >> 2] | 0
                            } if (!(Y >>> 0 < tc >>> 0)) {
                                break h
                            }
                            p = c[h >> 2] | 0;
                            do {
                                if ((p | 0) == 0) {
                                    uc = 0
                                } else {
                                    if ((c[p + 12 >> 2] | 0) != (c[p + 16 >> 2] | 0)) {
                                        uc = p;
                                        break
                                    }
                                    if ((kc[c[(c[p >> 2] | 0) + 36 >> 2] & 63](p) | 0) == -1) {
                                        c[h >> 2] = 0;
                                        uc = 0;
                                        break
                                    } else {
                                        uc = c[h >> 2] | 0;
                                        break
                                    }
                                }
                            } while (0);
                            p = (uc | 0) == 0;
                            _ = c[e >> 2] | 0;
                            do {
                                if ((_ | 0) == 0) {
                                    ba = 285
                                } else {
                                    if ((c[_ + 12 >> 2] | 0) != (c[_ + 16 >> 2] | 0)) {
                                        if (p) {
                                            break
                                        } else {
                                            break i
                                        }
                                    }
                                    if ((kc[c[(c[_ >> 2] | 0) + 36 >> 2] & 63](_) | 0) == -1) {
                                        c[e >> 2] = 0;
                                        ba = 285;
                                        break
                                    } else {
                                        if (p) {
                                            break
                                        } else {
                                            break i
                                        }
                                    }
                                }
                            } while (0);
                            if ((ba | 0) == 285) {
                                ba = 0;
                                if (p) {
                                    break
                                }
                            }
                            _ = c[h >> 2] | 0;
                            kb = c[_ + 12 >> 2] | 0;
                            if ((kb | 0) == (c[_ + 16 >> 2] | 0)) {
                                vc = kc[c[(c[_ >> 2] | 0) + 36 >> 2] & 63](_) | 0
                            } else {
                                vc = d[kb] | 0
                            } if ((a[pb] & 1) == 0) {
                                wc = ob
                            } else {
                                wc = c[mb >> 2] | 0
                            } if (!((vc & 255) << 24 >> 24 == (a[wc + Y | 0] | 0))) {
                                break
                            }
                            kb = Y + 1 | 0;
                            _ = c[h >> 2] | 0;
                            D = _ + 12 | 0;
                            r = c[D >> 2] | 0;
                            if ((r | 0) == (c[_ + 16 >> 2] | 0)) {
                                kc[c[(c[_ >> 2] | 0) + 40 >> 2] & 63](_) | 0;
                                Y = kb;
                                continue
                            } else {
                                c[D >> 2] = r + 1;
                                Y = kb;
                                continue
                            }
                        }
                        c[k >> 2] = c[k >> 2] | 4;
                        qc = 0;
                        rc = da;
                        sc = ga;
                        break g
                    }
                } while (0);
                if ((da | 0) == (ea | 0)) {
                    qc = 1;
                    rc = ea;
                    sc = ga;
                    break
                }
                c[C >> 2] = 0;
                jj(w, da, ea, C);
                if ((c[C >> 2] | 0) == 0) {
                    qc = 1;
                    rc = da;
                    sc = ga;
                    break
                }
                c[k >> 2] = c[k >> 2] | 4;
                qc = 0;
                rc = da;
                sc = ga
            }
        } while (0);
        ve(A);
        ve(z);
        ve(y);
        ve(x);
        ve(w);
        if ((rc | 0) == 0) {
            i = q;
            return qc | 0
        }
        hc[sc & 127](rc);
        i = q;
        return qc | 0
    }

    function fj(a) {
        a = a | 0;
        var b = 0;
        b = Ta(8) | 0;
        ce(b, a);
        Vb(b | 0, 4312, 11)
    }

    function gj(b, d, e, f, g, h, j, k) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        var l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0;
        d = i;
        i = i + 168 | 0;
        l = d;
        m = d + 8 | 0;
        n = d + 24 | 0;
        o = d + 128 | 0;
        p = d + 136 | 0;
        q = d + 144 | 0;
        r = d + 152 | 0;
        s = d + 160 | 0;
        t = o;
        c[t >> 2] = n;
        u = o + 4 | 0;
        c[u >> 2] = 115;
        v = n + 100 | 0;
        Pe(q, h);
        n = q;
        w = c[n >> 2] | 0;
        if (!((c[1826] | 0) == -1)) {
            c[m >> 2] = 7304;
            c[m + 4 >> 2] = 113;
            c[m + 8 >> 2] = 0;
            qe(7304, m, 114)
        }
        m = (c[7308 >> 2] | 0) + -1 | 0;
        x = c[w + 8 >> 2] | 0;
        if (!((c[w + 12 >> 2] | 0) - x >> 2 >>> 0 > m >>> 0)) {
            y = Ta(4) | 0;
            z = y;
            mm(z);
            Vb(y | 0, 15264, 101)
        }
        w = c[x + (m << 2) >> 2] | 0;
        if ((w | 0) == 0) {
            y = Ta(4) | 0;
            z = y;
            mm(z);
            Vb(y | 0, 15264, 101)
        }
        y = w;
        a[r] = 0;
        z = f;
        f = c[z >> 2] | 0;
        c[s >> 2] = f;
        m = c[h + 4 >> 2] | 0;
        h = l;
        x = s;
        c[h + 0 >> 2] = c[x + 0 >> 2];
        x = ej(e, l, g, q, m, j, r, y, o, p, v) | 0;
        if (x) {
            x = k;
            if ((a[x] & 1) == 0) {
                a[k + 1 | 0] = 0;
                a[x] = 0
            } else {
                a[c[k + 8 >> 2] | 0] = 0;
                c[k + 4 >> 2] = 0
            }
            x = w;
            if ((a[r] | 0) != 0) {
                Ae(k, tc[c[(c[x >> 2] | 0) + 28 >> 2] & 15](y, 45) | 0)
            }
            r = tc[c[(c[x >> 2] | 0) + 28 >> 2] & 15](y, 48) | 0;
            y = c[t >> 2] | 0;
            x = c[p >> 2] | 0;
            p = x + -1 | 0;
            a: do {
                if (y >>> 0 < p >>> 0) {
                    w = y;
                    while (1) {
                        v = w + 1 | 0;
                        if (!((a[w] | 0) == r << 24 >> 24)) {
                            A = w;
                            break a
                        }
                        if (v >>> 0 < p >>> 0) {
                            w = v
                        } else {
                            A = v;
                            break
                        }
                    }
                } else {
                    A = y
                }
            } while (0);
            hj(k, A, x) | 0
        }
        x = e;
        e = c[x >> 2] | 0;
        do {
            if ((e | 0) == 0) {
                B = 0
            } else {
                if ((c[e + 12 >> 2] | 0) != (c[e + 16 >> 2] | 0)) {
                    B = e;
                    break
                }
                if (!((kc[c[(c[e >> 2] | 0) + 36 >> 2] & 63](e) | 0) == -1)) {
                    B = e;
                    break
                }
                c[x >> 2] = 0;
                B = 0
            }
        } while (0);
        x = (B | 0) == 0;
        do {
            if ((f | 0) == 0) {
                C = 25
            } else {
                if ((c[f + 12 >> 2] | 0) != (c[f + 16 >> 2] | 0)) {
                    if (x) {
                        break
                    } else {
                        C = 27;
                        break
                    }
                }
                if ((kc[c[(c[f >> 2] | 0) + 36 >> 2] & 63](f) | 0) == -1) {
                    c[z >> 2] = 0;
                    C = 25;
                    break
                } else {
                    if (x ^ (f | 0) == 0) {
                        break
                    } else {
                        C = 27;
                        break
                    }
                }
            }
        } while (0);
        if ((C | 0) == 25) {
            if (x) {
                C = 27
            }
        }
        if ((C | 0) == 27) {
            c[j >> 2] = c[j >> 2] | 2
        }
        c[b >> 2] = B;
        Yd(c[n >> 2] | 0) | 0;
        n = c[t >> 2] | 0;
        c[t >> 2] = 0;
        if ((n | 0) == 0) {
            i = d;
            return
        }
        hc[c[u >> 2] & 127](n);
        i = d;
        return
    }

    function hj(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0;
        f = i;
        g = b;
        h = d;
        j = a[g] | 0;
        if ((j & 1) == 0) {
            k = (j & 255) >>> 1;
            l = j;
            m = 10
        } else {
            j = c[b >> 2] | 0;
            k = c[b + 4 >> 2] | 0;
            l = j & 255;
            m = (j & -2) + -1 | 0
        }
        j = e - h | 0;
        if ((e | 0) == (d | 0)) {
            i = f;
            return b | 0
        }
        if ((m - k | 0) >>> 0 < j >>> 0) {
            De(b, m, k + j - m | 0, k, k, 0, 0);
            n = a[g] | 0
        } else {
            n = l
        } if ((n & 1) == 0) {
            o = b + 1 | 0
        } else {
            o = c[b + 8 >> 2] | 0
        }
        n = e + (k - h) | 0;
        h = d;
        d = o + k | 0;
        while (1) {
            a[d] = a[h] | 0;
            l = h + 1 | 0;
            if ((l | 0) == (e | 0)) {
                break
            } else {
                d = d + 1 | 0;
                h = l
            }
        }
        a[o + n | 0] = 0;
        n = k + j | 0;
        if ((a[g] & 1) == 0) {
            a[g] = n << 1;
            i = f;
            return b | 0
        } else {
            c[b + 4 >> 2] = n;
            i = f;
            return b | 0
        }
        return 0
    }

    function ij(b, d, e, f, g, h, j, k, l, m) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        l = l | 0;
        m = m | 0;
        var n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0;
        n = i;
        i = i + 176 | 0;
        o = n;
        p = n + 16 | 0;
        q = n + 32 | 0;
        r = n + 40 | 0;
        s = n + 56 | 0;
        t = n + 72 | 0;
        u = n + 88 | 0;
        v = n + 104 | 0;
        w = n + 112 | 0;
        x = n + 128 | 0;
        y = n + 144 | 0;
        z = n + 160 | 0;
        if (b) {
            b = c[d >> 2] | 0;
            if (!((c[1686] | 0) == -1)) {
                c[p >> 2] = 6744;
                c[p + 4 >> 2] = 113;
                c[p + 8 >> 2] = 0;
                qe(6744, p, 114)
            }
            p = (c[6748 >> 2] | 0) + -1 | 0;
            A = c[b + 8 >> 2] | 0;
            if (!((c[b + 12 >> 2] | 0) - A >> 2 >>> 0 > p >>> 0)) {
                B = Ta(4) | 0;
                C = B;
                mm(C);
                Vb(B | 0, 15264, 101)
            }
            b = c[A + (p << 2) >> 2] | 0;
            if ((b | 0) == 0) {
                B = Ta(4) | 0;
                C = B;
                mm(C);
                Vb(B | 0, 15264, 101)
            }
            B = b;
            ic[c[(c[b >> 2] | 0) + 44 >> 2] & 63](q, B);
            C = e;
            p = c[q >> 2] | 0;
            a[C] = p;
            a[C + 1 | 0] = p >> 8;
            a[C + 2 | 0] = p >> 16;
            a[C + 3 | 0] = p >> 24;
            p = b;
            ic[c[(c[p >> 2] | 0) + 32 >> 2] & 63](r, B);
            C = l;
            if ((a[C] & 1) == 0) {
                a[l + 1 | 0] = 0;
                a[C] = 0
            } else {
                a[c[l + 8 >> 2] | 0] = 0;
                c[l + 4 >> 2] = 0
            }
            ze(l, 0);
            q = r;
            c[C + 0 >> 2] = c[q + 0 >> 2];
            c[C + 4 >> 2] = c[q + 4 >> 2];
            c[C + 8 >> 2] = c[q + 8 >> 2];
            c[q + 0 >> 2] = 0;
            c[q + 4 >> 2] = 0;
            c[q + 8 >> 2] = 0;
            ve(r);
            ic[c[(c[p >> 2] | 0) + 28 >> 2] & 63](s, B);
            r = k;
            if ((a[r] & 1) == 0) {
                a[k + 1 | 0] = 0;
                a[r] = 0
            } else {
                a[c[k + 8 >> 2] | 0] = 0;
                c[k + 4 >> 2] = 0
            }
            ze(k, 0);
            q = s;
            c[r + 0 >> 2] = c[q + 0 >> 2];
            c[r + 4 >> 2] = c[q + 4 >> 2];
            c[r + 8 >> 2] = c[q + 8 >> 2];
            c[q + 0 >> 2] = 0;
            c[q + 4 >> 2] = 0;
            c[q + 8 >> 2] = 0;
            ve(s);
            s = b;
            a[f] = kc[c[(c[s >> 2] | 0) + 12 >> 2] & 63](B) | 0;
            a[g] = kc[c[(c[s >> 2] | 0) + 16 >> 2] & 63](B) | 0;
            ic[c[(c[p >> 2] | 0) + 20 >> 2] & 63](t, B);
            s = h;
            if ((a[s] & 1) == 0) {
                a[h + 1 | 0] = 0;
                a[s] = 0
            } else {
                a[c[h + 8 >> 2] | 0] = 0;
                c[h + 4 >> 2] = 0
            }
            ze(h, 0);
            q = t;
            c[s + 0 >> 2] = c[q + 0 >> 2];
            c[s + 4 >> 2] = c[q + 4 >> 2];
            c[s + 8 >> 2] = c[q + 8 >> 2];
            c[q + 0 >> 2] = 0;
            c[q + 4 >> 2] = 0;
            c[q + 8 >> 2] = 0;
            ve(t);
            ic[c[(c[p >> 2] | 0) + 24 >> 2] & 63](u, B);
            p = j;
            if ((a[p] & 1) == 0) {
                a[j + 1 | 0] = 0;
                a[p] = 0
            } else {
                a[c[j + 8 >> 2] | 0] = 0;
                c[j + 4 >> 2] = 0
            }
            ze(j, 0);
            t = u;
            c[p + 0 >> 2] = c[t + 0 >> 2];
            c[p + 4 >> 2] = c[t + 4 >> 2];
            c[p + 8 >> 2] = c[t + 8 >> 2];
            c[t + 0 >> 2] = 0;
            c[t + 4 >> 2] = 0;
            c[t + 8 >> 2] = 0;
            ve(u);
            D = kc[c[(c[b >> 2] | 0) + 36 >> 2] & 63](B) | 0;
            c[m >> 2] = D;
            i = n;
            return
        } else {
            B = c[d >> 2] | 0;
            if (!((c[1670] | 0) == -1)) {
                c[o >> 2] = 6680;
                c[o + 4 >> 2] = 113;
                c[o + 8 >> 2] = 0;
                qe(6680, o, 114)
            }
            o = (c[6684 >> 2] | 0) + -1 | 0;
            d = c[B + 8 >> 2] | 0;
            if (!((c[B + 12 >> 2] | 0) - d >> 2 >>> 0 > o >>> 0)) {
                E = Ta(4) | 0;
                F = E;
                mm(F);
                Vb(E | 0, 15264, 101)
            }
            B = c[d + (o << 2) >> 2] | 0;
            if ((B | 0) == 0) {
                E = Ta(4) | 0;
                F = E;
                mm(F);
                Vb(E | 0, 15264, 101)
            }
            E = B;
            ic[c[(c[B >> 2] | 0) + 44 >> 2] & 63](v, E);
            F = e;
            e = c[v >> 2] | 0;
            a[F] = e;
            a[F + 1 | 0] = e >> 8;
            a[F + 2 | 0] = e >> 16;
            a[F + 3 | 0] = e >> 24;
            e = B;
            ic[c[(c[e >> 2] | 0) + 32 >> 2] & 63](w, E);
            F = l;
            if ((a[F] & 1) == 0) {
                a[l + 1 | 0] = 0;
                a[F] = 0
            } else {
                a[c[l + 8 >> 2] | 0] = 0;
                c[l + 4 >> 2] = 0
            }
            ze(l, 0);
            l = w;
            c[F + 0 >> 2] = c[l + 0 >> 2];
            c[F + 4 >> 2] = c[l + 4 >> 2];
            c[F + 8 >> 2] = c[l + 8 >> 2];
            c[l + 0 >> 2] = 0;
            c[l + 4 >> 2] = 0;
            c[l + 8 >> 2] = 0;
            ve(w);
            ic[c[(c[e >> 2] | 0) + 28 >> 2] & 63](x, E);
            w = k;
            if ((a[w] & 1) == 0) {
                a[k + 1 | 0] = 0;
                a[w] = 0
            } else {
                a[c[k + 8 >> 2] | 0] = 0;
                c[k + 4 >> 2] = 0
            }
            ze(k, 0);
            k = x;
            c[w + 0 >> 2] = c[k + 0 >> 2];
            c[w + 4 >> 2] = c[k + 4 >> 2];
            c[w + 8 >> 2] = c[k + 8 >> 2];
            c[k + 0 >> 2] = 0;
            c[k + 4 >> 2] = 0;
            c[k + 8 >> 2] = 0;
            ve(x);
            x = B;
            a[f] = kc[c[(c[x >> 2] | 0) + 12 >> 2] & 63](E) | 0;
            a[g] = kc[c[(c[x >> 2] | 0) + 16 >> 2] & 63](E) | 0;
            ic[c[(c[e >> 2] | 0) + 20 >> 2] & 63](y, E);
            x = h;
            if ((a[x] & 1) == 0) {
                a[h + 1 | 0] = 0;
                a[x] = 0
            } else {
                a[c[h + 8 >> 2] | 0] = 0;
                c[h + 4 >> 2] = 0
            }
            ze(h, 0);
            h = y;
            c[x + 0 >> 2] = c[h + 0 >> 2];
            c[x + 4 >> 2] = c[h + 4 >> 2];
            c[x + 8 >> 2] = c[h + 8 >> 2];
            c[h + 0 >> 2] = 0;
            c[h + 4 >> 2] = 0;
            c[h + 8 >> 2] = 0;
            ve(y);
            ic[c[(c[e >> 2] | 0) + 24 >> 2] & 63](z, E);
            e = j;
            if ((a[e] & 1) == 0) {
                a[j + 1 | 0] = 0;
                a[e] = 0
            } else {
                a[c[j + 8 >> 2] | 0] = 0;
                c[j + 4 >> 2] = 0
            }
            ze(j, 0);
            j = z;
            c[e + 0 >> 2] = c[j + 0 >> 2];
            c[e + 4 >> 2] = c[j + 4 >> 2];
            c[e + 8 >> 2] = c[j + 8 >> 2];
            c[j + 0 >> 2] = 0;
            c[j + 4 >> 2] = 0;
            c[j + 8 >> 2] = 0;
            ve(z);
            D = kc[c[(c[B >> 2] | 0) + 36 >> 2] & 63](E) | 0;
            c[m >> 2] = D;
            i = n;
            return
        }
    }

    function jj(b, d, e, f) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        var g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0;
        g = i;
        h = b;
        j = a[h] | 0;
        if ((j & 1) == 0) {
            k = (j & 255) >>> 1
        } else {
            k = c[b + 4 >> 2] | 0
        } if ((k | 0) == 0) {
            i = g;
            return
        }
        do {
            if ((d | 0) == (e | 0)) {
                l = j
            } else {
                k = e + -4 | 0;
                if (k >>> 0 > d >>> 0) {
                    m = d;
                    n = k
                } else {
                    l = j;
                    break
                }
                do {
                    k = c[m >> 2] | 0;
                    c[m >> 2] = c[n >> 2];
                    c[n >> 2] = k;
                    m = m + 4 | 0;
                    n = n + -4 | 0;
                } while (m >>> 0 < n >>> 0);
                l = a[h] | 0
            }
        } while (0);
        if ((l & 1) == 0) {
            o = b + 1 | 0;
            p = (l & 255) >>> 1
        } else {
            o = c[b + 8 >> 2] | 0;
            p = c[b + 4 >> 2] | 0
        }
        b = e + -4 | 0;
        e = a[o] | 0;
        l = e << 24 >> 24 < 1 | e << 24 >> 24 == 127;
        a: do {
            if (b >>> 0 > d >>> 0) {
                h = o + p | 0;
                n = e;
                m = o;
                j = d;
                k = l;
                while (1) {
                    if (!k) {
                        if ((n << 24 >> 24 | 0) != (c[j >> 2] | 0)) {
                            break
                        }
                    }
                    q = (h - m | 0) > 1 ? m + 1 | 0 : m;
                    r = j + 4 | 0;
                    s = a[q] | 0;
                    t = s << 24 >> 24 < 1 | s << 24 >> 24 == 127;
                    if (r >>> 0 < b >>> 0) {
                        n = s;
                        m = q;
                        j = r;
                        k = t
                    } else {
                        u = s;
                        v = t;
                        break a
                    }
                }
                c[f >> 2] = 4;
                i = g;
                return
            } else {
                u = e;
                v = l
            }
        } while (0);
        if (v) {
            i = g;
            return
        }
        v = c[b >> 2] | 0;
        if (!(u << 24 >> 24 >>> 0 < v >>> 0 | (v | 0) == 0)) {
            i = g;
            return
        }
        c[f >> 2] = 4;
        i = g;
        return
    }

    function kj(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Om(a);
        i = b;
        return
    }

    function lj(a) {
        a = a | 0;
        i = i;
        return
    }

    function mj(b, d, e, f, g, h, j, k) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        var l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0;
        d = i;
        i = i + 16 | 0;
        l = d;
        m = d + 8 | 0;
        n = i;
        i = i + 16 | 0;
        o = i;
        i = i + 400 | 0;
        p = i;
        i = i + 8 | 0;
        q = i;
        i = i + 8 | 0;
        r = i;
        i = i + 8 | 0;
        s = i;
        i = i + 8 | 0;
        t = i;
        i = i + 8 | 0;
        u = i;
        i = i + 40 | 0;
        v = i;
        i = i + 104 | 0;
        w = p;
        c[w >> 2] = o;
        x = p + 4 | 0;
        c[x >> 2] = 115;
        y = o + 400 | 0;
        Pe(r, h);
        o = r;
        z = c[o >> 2] | 0;
        if (!((c[1824] | 0) == -1)) {
            c[n >> 2] = 7296;
            c[n + 4 >> 2] = 113;
            c[n + 8 >> 2] = 0;
            qe(7296, n, 114)
        }
        n = (c[7300 >> 2] | 0) + -1 | 0;
        A = c[z + 8 >> 2] | 0;
        if (!((c[z + 12 >> 2] | 0) - A >> 2 >>> 0 > n >>> 0)) {
            B = Ta(4) | 0;
            C = B;
            mm(C);
            Vb(B | 0, 15264, 101)
        }
        z = c[A + (n << 2) >> 2] | 0;
        if ((z | 0) == 0) {
            B = Ta(4) | 0;
            C = B;
            mm(C);
            Vb(B | 0, 15264, 101)
        }
        B = z;
        a[s] = 0;
        C = f;
        c[t >> 2] = c[C >> 2];
        f = c[h + 4 >> 2] | 0;
        h = l;
        n = t;
        c[h + 0 >> 2] = c[n + 0 >> 2];
        n = nj(e, l, g, r, f, j, s, B, p, q, y) | 0;
        do {
            if (n) {
                y = u;
                qc[c[(c[z >> 2] | 0) + 48 >> 2] & 7](B, 7e3, 7010 | 0, y) | 0;
                p = v;
                f = c[q >> 2] | 0;
                r = c[w >> 2] | 0;
                g = f - r | 0;
                do {
                    if ((g | 0) > 392) {
                        l = Hm((g >> 2) + 2 | 0) | 0;
                        if ((l | 0) != 0) {
                            D = l;
                            E = l;
                            break
                        }
                        Tm()
                    } else {
                        D = 0;
                        E = p
                    }
                } while (0);
                if ((a[s] | 0) == 0) {
                    F = E
                } else {
                    a[E] = 45;
                    F = E + 1 | 0
                } if (r >>> 0 < f >>> 0) {
                    g = u + 40 | 0;
                    l = u;
                    h = F;
                    t = r;
                    while (1) {
                        A = c[t >> 2] | 0;
                        G = y;
                        while (1) {
                            H = G + 4 | 0;
                            if ((c[G >> 2] | 0) == (A | 0)) {
                                I = G;
                                break
                            }
                            if ((H | 0) == (g | 0)) {
                                I = g;
                                break
                            } else {
                                G = H
                            }
                        }
                        a[h] = a[7e3 + (I - l >> 2) | 0] | 0;
                        G = t + 4 | 0;
                        A = h + 1 | 0;
                        if (G >>> 0 < (c[q >> 2] | 0) >>> 0) {
                            h = A;
                            t = G
                        } else {
                            J = A;
                            break
                        }
                    }
                } else {
                    J = F
                }
                a[J] = 0;
                c[m >> 2] = k;
                if ((db(p | 0, 6936, m | 0) | 0) != 1) {
                    t = Ta(8) | 0;
                    ce(t, 6944);
                    Vb(t | 0, 4312, 11)
                }
                if ((D | 0) == 0) {
                    break
                }
                Im(D)
            }
        } while (0);
        D = e;
        e = c[D >> 2] | 0;
        do {
            if ((e | 0) == 0) {
                K = 1
            } else {
                m = c[e + 12 >> 2] | 0;
                if ((m | 0) == (c[e + 16 >> 2] | 0)) {
                    L = kc[c[(c[e >> 2] | 0) + 36 >> 2] & 63](e) | 0
                } else {
                    L = c[m >> 2] | 0
                } if ((L | 0) == -1) {
                    c[D >> 2] = 0;
                    K = 1;
                    break
                } else {
                    K = (c[D >> 2] | 0) == 0;
                    break
                }
            }
        } while (0);
        L = c[C >> 2] | 0;
        do {
            if ((L | 0) == 0) {
                M = 35
            } else {
                e = c[L + 12 >> 2] | 0;
                if ((e | 0) == (c[L + 16 >> 2] | 0)) {
                    N = kc[c[(c[L >> 2] | 0) + 36 >> 2] & 63](L) | 0
                } else {
                    N = c[e >> 2] | 0
                } if ((N | 0) == -1) {
                    c[C >> 2] = 0;
                    M = 35;
                    break
                } else {
                    if (K) {
                        break
                    } else {
                        M = 37;
                        break
                    }
                }
            }
        } while (0);
        if ((M | 0) == 35) {
            if (K) {
                M = 37
            }
        }
        if ((M | 0) == 37) {
            c[j >> 2] = c[j >> 2] | 2
        }
        c[b >> 2] = c[D >> 2];
        Yd(c[o >> 2] | 0) | 0;
        o = c[w >> 2] | 0;
        c[w >> 2] = 0;
        if ((o | 0) == 0) {
            i = d;
            return
        }
        hc[c[x >> 2] & 127](o);
        i = d;
        return
    }

    function nj(b, e, f, g, h, j, k, l, m, n, o) {
        b = b | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        l = l | 0;
        m = m | 0;
        n = n | 0;
        o = o | 0;
        var p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0,
            V = 0,
            W = 0,
            X = 0,
            Y = 0,
            Z = 0,
            _ = 0,
            $ = 0,
            aa = 0,
            ba = 0,
            ca = 0,
            da = 0,
            ea = 0,
            fa = 0,
            ga = 0,
            ha = 0,
            ia = 0,
            ja = 0,
            ka = 0,
            la = 0,
            ma = 0,
            na = 0,
            oa = 0,
            pa = 0,
            qa = 0,
            ra = 0,
            sa = 0,
            ta = 0,
            ua = 0,
            va = 0,
            wa = 0,
            xa = 0,
            ya = 0,
            za = 0,
            Aa = 0,
            Ba = 0,
            Ca = 0,
            Da = 0,
            Ea = 0,
            Fa = 0,
            Ga = 0,
            Ha = 0,
            Ia = 0,
            Ja = 0,
            Ka = 0,
            La = 0,
            Ma = 0,
            Na = 0,
            Oa = 0,
            Pa = 0,
            Qa = 0,
            Ra = 0,
            Sa = 0,
            Ta = 0,
            Ua = 0,
            Va = 0,
            Wa = 0,
            Xa = 0,
            Ya = 0,
            Za = 0,
            _a = 0,
            $a = 0,
            ab = 0,
            bb = 0,
            cb = 0,
            db = 0,
            eb = 0,
            fb = 0,
            gb = 0,
            hb = 0,
            ib = 0,
            jb = 0,
            kb = 0,
            lb = 0,
            mb = 0,
            nb = 0,
            ob = 0,
            pb = 0,
            qb = 0,
            rb = 0,
            sb = 0,
            tb = 0,
            ub = 0,
            vb = 0,
            wb = 0,
            xb = 0,
            yb = 0,
            zb = 0,
            Ab = 0,
            Bb = 0,
            Cb = 0,
            Db = 0,
            Eb = 0,
            Fb = 0,
            Gb = 0,
            Hb = 0,
            Ib = 0,
            Jb = 0,
            Kb = 0,
            Lb = 0,
            Mb = 0,
            Nb = 0,
            Ob = 0,
            Pb = 0,
            Qb = 0,
            Rb = 0,
            Sb = 0,
            Tb = 0,
            Ub = 0,
            Vb = 0,
            Wb = 0,
            Xb = 0,
            Yb = 0,
            Zb = 0,
            _b = 0,
            $b = 0,
            ac = 0,
            bc = 0,
            cc = 0,
            dc = 0,
            fc = 0,
            gc = 0,
            ic = 0,
            jc = 0,
            lc = 0,
            mc = 0,
            nc = 0,
            oc = 0,
            pc = 0,
            qc = 0,
            rc = 0,
            sc = 0,
            tc = 0,
            uc = 0,
            vc = 0,
            wc = 0,
            xc = 0,
            yc = 0,
            zc = 0,
            Ac = 0,
            Bc = 0,
            Cc = 0,
            Dc = 0,
            Ec = 0,
            Fc = 0;
        p = i;
        i = i + 408 | 0;
        q = p;
        r = p + 400 | 0;
        s = r;
        t = i;
        i = i + 8 | 0;
        u = i;
        i = i + 8 | 0;
        v = i;
        i = i + 16 | 0;
        w = i;
        i = i + 16 | 0;
        x = i;
        i = i + 16 | 0;
        y = i;
        i = i + 16 | 0;
        z = i;
        i = i + 16 | 0;
        A = i;
        i = i + 8 | 0;
        B = i;
        i = i + 8 | 0;
        C = q;
        c[r >> 2] = 0;
        D = v;
        c[D + 0 >> 2] = 0;
        c[D + 4 >> 2] = 0;
        c[D + 8 >> 2] = 0;
        E = w;
        c[E + 0 >> 2] = 0;
        c[E + 4 >> 2] = 0;
        c[E + 8 >> 2] = 0;
        F = x;
        c[F + 0 >> 2] = 0;
        c[F + 4 >> 2] = 0;
        c[F + 8 >> 2] = 0;
        G = y;
        c[G + 0 >> 2] = 0;
        c[G + 4 >> 2] = 0;
        c[G + 8 >> 2] = 0;
        H = z;
        c[H + 0 >> 2] = 0;
        c[H + 4 >> 2] = 0;
        c[H + 8 >> 2] = 0;
        qj(f, g, s, t, u, v, w, x, y, A);
        s = m;
        c[n >> 2] = c[s >> 2];
        g = b;
        b = e;
        e = r;
        r = l;
        f = y + 4 | 0;
        I = y + 8 | 0;
        J = x + 4 | 0;
        K = x + 8 | 0;
        L = (h & 512 | 0) != 0;
        h = w + 4 | 0;
        M = w + 8 | 0;
        N = z + 4 | 0;
        O = z + 8 | 0;
        P = e + 3 | 0;
        Q = m + 4 | 0;
        m = v + 4 | 0;
        R = q + 400 | 0;
        q = C;
        S = C;
        C = o;
        o = 0;
        T = 0;
        U = 115;
        a: while (1) {
            V = c[g >> 2] | 0;
            do {
                if ((V | 0) == 0) {
                    W = 1
                } else {
                    X = c[V + 12 >> 2] | 0;
                    if ((X | 0) == (c[V + 16 >> 2] | 0)) {
                        Y = kc[c[(c[V >> 2] | 0) + 36 >> 2] & 63](V) | 0
                    } else {
                        Y = c[X >> 2] | 0
                    } if ((Y | 0) == -1) {
                        c[g >> 2] = 0;
                        W = 1;
                        break
                    } else {
                        W = (c[g >> 2] | 0) == 0;
                        break
                    }
                }
            } while (0);
            V = c[b >> 2] | 0;
            do {
                if ((V | 0) == 0) {
                    Z = 15
                } else {
                    X = c[V + 12 >> 2] | 0;
                    if ((X | 0) == (c[V + 16 >> 2] | 0)) {
                        _ = kc[c[(c[V >> 2] | 0) + 36 >> 2] & 63](V) | 0
                    } else {
                        _ = c[X >> 2] | 0
                    } if ((_ | 0) == -1) {
                        c[b >> 2] = 0;
                        Z = 15;
                        break
                    } else {
                        if (W) {
                            $ = V;
                            break
                        } else {
                            aa = S;
                            ba = q;
                            ca = T;
                            da = U;
                            Z = 292;
                            break a
                        }
                    }
                }
            } while (0);
            if ((Z | 0) == 15) {
                Z = 0;
                if (W) {
                    aa = S;
                    ba = q;
                    ca = T;
                    da = U;
                    Z = 292;
                    break
                } else {
                    $ = 0
                }
            }
            b: do {
                switch (a[e + o | 0] | 0) {
                case 0:
                    {
                        Z = 28;
                        break
                    };
                case 4:
                    {
                        V = C;
                        X = S;
                        ea = q;
                        fa = R;
                        ga = 0;
                        ha = U;
                        c: while (1) {
                            ia = c[g >> 2] | 0;
                            do {
                                if ((ia | 0) == 0) {
                                    ja = 1
                                } else {
                                    ka = c[ia + 12 >> 2] | 0;
                                    if ((ka | 0) == (c[ia + 16 >> 2] | 0)) {
                                        la = kc[c[(c[ia >> 2] | 0) + 36 >> 2] & 63](ia) | 0
                                    } else {
                                        la = c[ka >> 2] | 0
                                    } if ((la | 0) == -1) {
                                        c[g >> 2] = 0;
                                        ja = 1;
                                        break
                                    } else {
                                        ja = (c[g >> 2] | 0) == 0;
                                        break
                                    }
                                }
                            } while (0);
                            ia = c[b >> 2] | 0;
                            do {
                                if ((ia | 0) == 0) {
                                    Z = 188
                                } else {
                                    ka = c[ia + 12 >> 2] | 0;
                                    if ((ka | 0) == (c[ia + 16 >> 2] | 0)) {
                                        ma = kc[c[(c[ia >> 2] | 0) + 36 >> 2] & 63](ia) | 0
                                    } else {
                                        ma = c[ka >> 2] | 0
                                    } if ((ma | 0) == -1) {
                                        c[b >> 2] = 0;
                                        Z = 188;
                                        break
                                    } else {
                                        if (ja) {
                                            break
                                        } else {
                                            break c
                                        }
                                    }
                                }
                            } while (0);
                            if ((Z | 0) == 188) {
                                Z = 0;
                                if (ja) {
                                    break
                                }
                            }
                            ia = c[g >> 2] | 0;
                            ka = c[ia + 12 >> 2] | 0;
                            if ((ka | 0) == (c[ia + 16 >> 2] | 0)) {
                                na = kc[c[(c[ia >> 2] | 0) + 36 >> 2] & 63](ia) | 0
                            } else {
                                na = c[ka >> 2] | 0
                            } if (ec[c[(c[r >> 2] | 0) + 12 >> 2] & 31](l, 2048, na) | 0) {
                                ka = c[n >> 2] | 0;
                                if ((ka | 0) == (V | 0)) {
                                    ia = (c[Q >> 2] | 0) != 115;
                                    oa = c[s >> 2] | 0;
                                    pa = V - oa | 0;
                                    qa = pa >>> 0 < 2147483647 ? pa << 1 : -1;
                                    ra = pa >> 2;
                                    if (ia) {
                                        sa = oa
                                    } else {
                                        sa = 0
                                    }
                                    oa = Jm(sa, qa) | 0;
                                    pa = oa;
                                    if ((oa | 0) == 0) {
                                        Z = 198;
                                        break a
                                    }
                                    do {
                                        if (ia) {
                                            c[s >> 2] = pa;
                                            ta = pa
                                        } else {
                                            oa = c[s >> 2] | 0;
                                            c[s >> 2] = pa;
                                            if ((oa | 0) == 0) {
                                                ta = pa;
                                                break
                                            }
                                            hc[c[Q >> 2] & 127](oa);
                                            ta = c[s >> 2] | 0
                                        }
                                    } while (0);
                                    c[Q >> 2] = 116;
                                    pa = ta + (ra << 2) | 0;
                                    c[n >> 2] = pa;
                                    ua = pa;
                                    va = (c[s >> 2] | 0) + (qa >>> 2 << 2) | 0
                                } else {
                                    ua = ka;
                                    va = V
                                }
                                c[n >> 2] = ua + 4;
                                c[ua >> 2] = na;
                                wa = va;
                                xa = X;
                                ya = ea;
                                za = fa;
                                Aa = ga + 1 | 0;
                                Ba = ha
                            } else {
                                pa = a[D] | 0;
                                if ((pa & 1) == 0) {
                                    Ca = (pa & 255) >>> 1
                                } else {
                                    Ca = c[m >> 2] | 0
                                } if ((Ca | 0) == 0 | (ga | 0) == 0) {
                                    break
                                }
                                if ((na | 0) != (c[u >> 2] | 0)) {
                                    break
                                }
                                if ((ea | 0) == (fa | 0)) {
                                    pa = ea - X | 0;
                                    ia = pa >>> 0 < 2147483647 ? pa << 1 : -1;
                                    if ((ha | 0) != 115) {
                                        Da = X
                                    } else {
                                        Da = 0
                                    }
                                    oa = Jm(Da, ia) | 0;
                                    Ea = oa;
                                    if ((oa | 0) == 0) {
                                        Z = 214;
                                        break a
                                    }
                                    Fa = Ea;
                                    Ga = Ea + (pa >> 2 << 2) | 0;
                                    Ha = Ea + (ia >>> 2 << 2) | 0;
                                    Ia = 116
                                } else {
                                    Fa = X;
                                    Ga = ea;
                                    Ha = fa;
                                    Ia = ha
                                }
                                c[Ga >> 2] = ga;
                                wa = V;
                                xa = Fa;
                                ya = Ga + 4 | 0;
                                za = Ha;
                                Aa = 0;
                                Ba = Ia
                            }
                            ia = c[g >> 2] | 0;
                            Ea = ia + 12 | 0;
                            pa = c[Ea >> 2] | 0;
                            if ((pa | 0) == (c[ia + 16 >> 2] | 0)) {
                                kc[c[(c[ia >> 2] | 0) + 40 >> 2] & 63](ia) | 0;
                                V = wa;
                                X = xa;
                                ea = ya;
                                fa = za;
                                ga = Aa;
                                ha = Ba;
                                continue
                            } else {
                                c[Ea >> 2] = pa + 4;
                                V = wa;
                                X = xa;
                                ea = ya;
                                fa = za;
                                ga = Aa;
                                ha = Ba;
                                continue
                            }
                        }
                        if ((X | 0) == (ea | 0) | (ga | 0) == 0) {
                            Ja = X;
                            Ka = ea;
                            La = fa;
                            Ma = ha
                        } else {
                            if ((ea | 0) == (fa | 0)) {
                                pa = ea - X | 0;
                                Ea = pa >>> 0 < 2147483647 ? pa << 1 : -1;
                                if ((ha | 0) != 115) {
                                    Na = X
                                } else {
                                    Na = 0
                                }
                                ia = Jm(Na, Ea) | 0;
                                oa = ia;
                                if ((ia | 0) == 0) {
                                    Z = 225;
                                    break a
                                }
                                Oa = oa;
                                Pa = oa + (pa >> 2 << 2) | 0;
                                Qa = oa + (Ea >>> 2 << 2) | 0;
                                Ra = 116
                            } else {
                                Oa = X;
                                Pa = ea;
                                Qa = fa;
                                Ra = ha
                            }
                            c[Pa >> 2] = ga;
                            Ja = Oa;
                            Ka = Pa + 4 | 0;
                            La = Qa;
                            Ma = Ra
                        }
                        Ea = c[A >> 2] | 0;
                        if ((Ea | 0) > 0) {
                            oa = c[g >> 2] | 0;
                            do {
                                if ((oa | 0) == 0) {
                                    Sa = 1
                                } else {
                                    pa = c[oa + 12 >> 2] | 0;
                                    if ((pa | 0) == (c[oa + 16 >> 2] | 0)) {
                                        Ta = kc[c[(c[oa >> 2] | 0) + 36 >> 2] & 63](oa) | 0
                                    } else {
                                        Ta = c[pa >> 2] | 0
                                    } if ((Ta | 0) == -1) {
                                        c[g >> 2] = 0;
                                        Sa = 1;
                                        break
                                    } else {
                                        Sa = (c[g >> 2] | 0) == 0;
                                        break
                                    }
                                }
                            } while (0);
                            oa = c[b >> 2] | 0;
                            do {
                                if ((oa | 0) == 0) {
                                    Z = 242
                                } else {
                                    ga = c[oa + 12 >> 2] | 0;
                                    if ((ga | 0) == (c[oa + 16 >> 2] | 0)) {
                                        Ua = kc[c[(c[oa >> 2] | 0) + 36 >> 2] & 63](oa) | 0
                                    } else {
                                        Ua = c[ga >> 2] | 0
                                    } if ((Ua | 0) == -1) {
                                        c[b >> 2] = 0;
                                        Z = 242;
                                        break
                                    } else {
                                        if (Sa) {
                                            Va = oa;
                                            break
                                        } else {
                                            Z = 248;
                                            break a
                                        }
                                    }
                                }
                            } while (0);
                            if ((Z | 0) == 242) {
                                Z = 0;
                                if (Sa) {
                                    Z = 248;
                                    break a
                                } else {
                                    Va = 0
                                }
                            }
                            oa = c[g >> 2] | 0;
                            ga = c[oa + 12 >> 2] | 0;
                            if ((ga | 0) == (c[oa + 16 >> 2] | 0)) {
                                Wa = kc[c[(c[oa >> 2] | 0) + 36 >> 2] & 63](oa) | 0
                            } else {
                                Wa = c[ga >> 2] | 0
                            } if ((Wa | 0) != (c[t >> 2] | 0)) {
                                Z = 248;
                                break a
                            }
                            ga = c[g >> 2] | 0;
                            oa = ga + 12 | 0;
                            ha = c[oa >> 2] | 0;
                            if ((ha | 0) == (c[ga + 16 >> 2] | 0)) {
                                kc[c[(c[ga >> 2] | 0) + 40 >> 2] & 63](ga) | 0;
                                Xa = Va;
                                Ya = Ea;
                                Za = Va;
                                _a = V
                            } else {
                                c[oa >> 2] = ha + 4;
                                Xa = Va;
                                Ya = Ea;
                                Za = Va;
                                _a = V
                            }
                            while (1) {
                                ha = c[g >> 2] | 0;
                                do {
                                    if ((ha | 0) == 0) {
                                        $a = 1
                                    } else {
                                        oa = c[ha + 12 >> 2] | 0;
                                        if ((oa | 0) == (c[ha + 16 >> 2] | 0)) {
                                            ab = kc[c[(c[ha >> 2] | 0) + 36 >> 2] & 63](ha) | 0
                                        } else {
                                            ab = c[oa >> 2] | 0
                                        } if ((ab | 0) == -1) {
                                            c[g >> 2] = 0;
                                            $a = 1;
                                            break
                                        } else {
                                            $a = (c[g >> 2] | 0) == 0;
                                            break
                                        }
                                    }
                                } while (0);
                                do {
                                    if ((Za | 0) == 0) {
                                        bb = Xa;
                                        Z = 265
                                    } else {
                                        ha = c[Za + 12 >> 2] | 0;
                                        if ((ha | 0) == (c[Za + 16 >> 2] | 0)) {
                                            cb = kc[c[(c[Za >> 2] | 0) + 36 >> 2] & 63](Za) | 0
                                        } else {
                                            cb = c[ha >> 2] | 0
                                        } if ((cb | 0) == -1) {
                                            c[b >> 2] = 0;
                                            bb = 0;
                                            Z = 265;
                                            break
                                        } else {
                                            if ($a ^ (Xa | 0) == 0) {
                                                db = Xa;
                                                eb = Xa;
                                                break
                                            } else {
                                                Z = 271;
                                                break a
                                            }
                                        }
                                    }
                                } while (0);
                                if ((Z | 0) == 265) {
                                    Z = 0;
                                    if ($a) {
                                        Z = 271;
                                        break a
                                    } else {
                                        db = bb;
                                        eb = 0
                                    }
                                }
                                ha = c[g >> 2] | 0;
                                ka = c[ha + 12 >> 2] | 0;
                                if ((ka | 0) == (c[ha + 16 >> 2] | 0)) {
                                    fb = kc[c[(c[ha >> 2] | 0) + 36 >> 2] & 63](ha) | 0
                                } else {
                                    fb = c[ka >> 2] | 0
                                } if (!(ec[c[(c[r >> 2] | 0) + 12 >> 2] & 31](l, 2048, fb) | 0)) {
                                    Z = 271;
                                    break a
                                }
                                ka = c[n >> 2] | 0;
                                if ((ka | 0) == (_a | 0)) {
                                    ha = (c[Q >> 2] | 0) != 115;
                                    qa = c[s >> 2] | 0;
                                    ra = _a - qa | 0;
                                    oa = ra >>> 0 < 2147483647 ? ra << 1 : -1;
                                    ga = ra >> 2;
                                    if (ha) {
                                        gb = qa
                                    } else {
                                        gb = 0
                                    }
                                    qa = Jm(gb, oa) | 0;
                                    ra = qa;
                                    if ((qa | 0) == 0) {
                                        Z = 276;
                                        break a
                                    }
                                    do {
                                        if (ha) {
                                            c[s >> 2] = ra;
                                            hb = ra
                                        } else {
                                            qa = c[s >> 2] | 0;
                                            c[s >> 2] = ra;
                                            if ((qa | 0) == 0) {
                                                hb = ra;
                                                break
                                            }
                                            hc[c[Q >> 2] & 127](qa);
                                            hb = c[s >> 2] | 0
                                        }
                                    } while (0);
                                    c[Q >> 2] = 116;
                                    ra = hb + (ga << 2) | 0;
                                    c[n >> 2] = ra;
                                    ib = ra;
                                    jb = (c[s >> 2] | 0) + (oa >>> 2 << 2) | 0
                                } else {
                                    ib = ka;
                                    jb = _a
                                }
                                ra = c[g >> 2] | 0;
                                ha = c[ra + 12 >> 2] | 0;
                                if ((ha | 0) == (c[ra + 16 >> 2] | 0)) {
                                    qa = kc[c[(c[ra >> 2] | 0) + 36 >> 2] & 63](ra) | 0;
                                    kb = qa;
                                    lb = c[n >> 2] | 0
                                } else {
                                    kb = c[ha >> 2] | 0;
                                    lb = ib
                                }
                                c[n >> 2] = lb + 4;
                                c[lb >> 2] = kb;
                                ha = Ya + -1 | 0;
                                c[A >> 2] = ha;
                                qa = c[g >> 2] | 0;
                                ra = qa + 12 | 0;
                                fa = c[ra >> 2] | 0;
                                if ((fa | 0) == (c[qa + 16 >> 2] | 0)) {
                                    kc[c[(c[qa >> 2] | 0) + 40 >> 2] & 63](qa) | 0
                                } else {
                                    c[ra >> 2] = fa + 4
                                } if ((ha | 0) > 0) {
                                    Xa = db;
                                    Ya = ha;
                                    Za = eb;
                                    _a = jb
                                } else {
                                    mb = jb;
                                    break
                                }
                            }
                        } else {
                            mb = V
                        } if ((c[n >> 2] | 0) == (c[s >> 2] | 0)) {
                            Z = 290;
                            break a
                        } else {
                            nb = mb;
                            ob = Ja;
                            pb = Ka;
                            qb = La;
                            rb = T;
                            sb = Ma
                        }
                        break
                    };
                case 1:
                    {
                        if ((o | 0) == 3) {
                            aa = S;
                            ba = q;
                            ca = T;
                            da = U;
                            Z = 292;
                            break a
                        }
                        Ea = c[g >> 2] | 0;
                        ha = c[Ea + 12 >> 2] | 0;
                        if ((ha | 0) == (c[Ea + 16 >> 2] | 0)) {
                            tb = kc[c[(c[Ea >> 2] | 0) + 36 >> 2] & 63](Ea) | 0
                        } else {
                            tb = c[ha >> 2] | 0
                        } if (!(ec[c[(c[r >> 2] | 0) + 12 >> 2] & 31](l, 8192, tb) | 0)) {
                            Z = 27;
                            break a
                        }
                        ha = c[g >> 2] | 0;
                        Ea = ha + 12 | 0;
                        fa = c[Ea >> 2] | 0;
                        if ((fa | 0) == (c[ha + 16 >> 2] | 0)) {
                            ub = kc[c[(c[ha >> 2] | 0) + 40 >> 2] & 63](ha) | 0
                        } else {
                            c[Ea >> 2] = fa + 4;
                            ub = c[fa >> 2] | 0
                        }
                        Ke(z, ub);
                        Z = 28;
                        break
                    };
                case 3:
                    {
                        fa = a[F] | 0;
                        Ea = (fa & 1) == 0;
                        if (Ea) {
                            vb = (fa & 255) >>> 1
                        } else {
                            vb = c[J >> 2] | 0
                        }
                        ha = a[G] | 0;
                        ra = (ha & 1) == 0;
                        if (ra) {
                            wb = (ha & 255) >>> 1
                        } else {
                            wb = c[f >> 2] | 0
                        } if ((vb | 0) == (0 - wb | 0)) {
                            nb = C;
                            ob = S;
                            pb = q;
                            qb = R;
                            rb = T;
                            sb = U;
                            break b
                        }
                        if (Ea) {
                            xb = (fa & 255) >>> 1
                        } else {
                            xb = c[J >> 2] | 0
                        }
                        do {
                            if ((xb | 0) != 0) {
                                if (ra) {
                                    yb = (ha & 255) >>> 1
                                } else {
                                    yb = c[f >> 2] | 0
                                } if ((yb | 0) == 0) {
                                    break
                                }
                                qa = c[g >> 2] | 0;
                                ea = c[qa + 12 >> 2] | 0;
                                if ((ea | 0) == (c[qa + 16 >> 2] | 0)) {
                                    X = kc[c[(c[qa >> 2] | 0) + 36 >> 2] & 63](qa) | 0;
                                    zb = X;
                                    Ab = a[F] | 0
                                } else {
                                    zb = c[ea >> 2] | 0;
                                    Ab = fa
                                }
                                ea = c[g >> 2] | 0;
                                X = ea + 12 | 0;
                                qa = c[X >> 2] | 0;
                                pa = (qa | 0) == (c[ea + 16 >> 2] | 0);
                                if ((zb | 0) == (c[((Ab & 1) == 0 ? J : c[K >> 2] | 0) >> 2] | 0)) {
                                    if (pa) {
                                        kc[c[(c[ea >> 2] | 0) + 40 >> 2] & 63](ea) | 0
                                    } else {
                                        c[X >> 2] = qa + 4
                                    }
                                    X = a[F] | 0;
                                    if ((X & 1) == 0) {
                                        Bb = (X & 255) >>> 1
                                    } else {
                                        Bb = c[J >> 2] | 0
                                    }
                                    nb = C;
                                    ob = S;
                                    pb = q;
                                    qb = R;
                                    rb = Bb >>> 0 > 1 ? x : T;
                                    sb = U;
                                    break b
                                }
                                if (pa) {
                                    Cb = kc[c[(c[ea >> 2] | 0) + 36 >> 2] & 63](ea) | 0
                                } else {
                                    Cb = c[qa >> 2] | 0
                                } if ((Cb | 0) != (c[((a[G] & 1) == 0 ? f : c[I >> 2] | 0) >> 2] | 0)) {
                                    Z = 116;
                                    break a
                                }
                                qa = c[g >> 2] | 0;
                                ea = qa + 12 | 0;
                                pa = c[ea >> 2] | 0;
                                if ((pa | 0) == (c[qa + 16 >> 2] | 0)) {
                                    kc[c[(c[qa >> 2] | 0) + 40 >> 2] & 63](qa) | 0
                                } else {
                                    c[ea >> 2] = pa + 4
                                }
                                a[k] = 1;
                                pa = a[G] | 0;
                                if ((pa & 1) == 0) {
                                    Db = (pa & 255) >>> 1
                                } else {
                                    Db = c[f >> 2] | 0
                                }
                                nb = C;
                                ob = S;
                                pb = q;
                                qb = R;
                                rb = Db >>> 0 > 1 ? y : T;
                                sb = U;
                                break b
                            }
                        } while (0);
                        if (Ea) {
                            Eb = (fa & 255) >>> 1
                        } else {
                            Eb = c[J >> 2] | 0
                        }
                        ra = c[g >> 2] | 0;
                        V = c[ra + 12 >> 2] | 0;
                        pa = (V | 0) == (c[ra + 16 >> 2] | 0);
                        if ((Eb | 0) == 0) {
                            if (pa) {
                                ea = kc[c[(c[ra >> 2] | 0) + 36 >> 2] & 63](ra) | 0;
                                Fb = ea;
                                Gb = a[G] | 0
                            } else {
                                Fb = c[V >> 2] | 0;
                                Gb = ha
                            } if ((Fb | 0) != (c[((Gb & 1) == 0 ? f : c[I >> 2] | 0) >> 2] | 0)) {
                                nb = C;
                                ob = S;
                                pb = q;
                                qb = R;
                                rb = T;
                                sb = U;
                                break b
                            }
                            ea = c[g >> 2] | 0;
                            qa = ea + 12 | 0;
                            X = c[qa >> 2] | 0;
                            if ((X | 0) == (c[ea + 16 >> 2] | 0)) {
                                kc[c[(c[ea >> 2] | 0) + 40 >> 2] & 63](ea) | 0
                            } else {
                                c[qa >> 2] = X + 4
                            }
                            a[k] = 1;
                            X = a[G] | 0;
                            if ((X & 1) == 0) {
                                Hb = (X & 255) >>> 1
                            } else {
                                Hb = c[f >> 2] | 0
                            }
                            nb = C;
                            ob = S;
                            pb = q;
                            qb = R;
                            rb = Hb >>> 0 > 1 ? y : T;
                            sb = U;
                            break b
                        }
                        if (pa) {
                            pa = kc[c[(c[ra >> 2] | 0) + 36 >> 2] & 63](ra) | 0;
                            Ib = pa;
                            Jb = a[F] | 0
                        } else {
                            Ib = c[V >> 2] | 0;
                            Jb = fa
                        } if ((Ib | 0) != (c[((Jb & 1) == 0 ? J : c[K >> 2] | 0) >> 2] | 0)) {
                            a[k] = 1;
                            nb = C;
                            ob = S;
                            pb = q;
                            qb = R;
                            rb = T;
                            sb = U;
                            break b
                        }
                        V = c[g >> 2] | 0;
                        pa = V + 12 | 0;
                        ra = c[pa >> 2] | 0;
                        if ((ra | 0) == (c[V + 16 >> 2] | 0)) {
                            kc[c[(c[V >> 2] | 0) + 40 >> 2] & 63](V) | 0
                        } else {
                            c[pa >> 2] = ra + 4
                        }
                        ra = a[F] | 0;
                        if ((ra & 1) == 0) {
                            Kb = (ra & 255) >>> 1
                        } else {
                            Kb = c[J >> 2] | 0
                        }
                        nb = C;
                        ob = S;
                        pb = q;
                        qb = R;
                        rb = Kb >>> 0 > 1 ? x : T;
                        sb = U;
                        break
                    };
                case 2:
                    {
                        if (!((T | 0) != 0 | o >>> 0 < 2)) {
                            if ((o | 0) == 2) {
                                Lb = (a[P] | 0) != 0
                            } else {
                                Lb = 0
                            } if (!(L | Lb)) {
                                nb = C;
                                ob = S;
                                pb = q;
                                qb = R;
                                rb = 0;
                                sb = U;
                                break b
                            }
                        }
                        ra = a[E] | 0;
                        pa = (ra & 1) == 0 ? h : c[M >> 2] | 0;
                        d: do {
                            if ((o | 0) == 0) {
                                Mb = $;
                                Nb = $;
                                Ob = ra;
                                Pb = pa
                            } else {
                                if ((d[e + (o + -1) | 0] | 0) < 2) {
                                    Qb = ra;
                                    Rb = pa
                                } else {
                                    Mb = $;
                                    Nb = $;
                                    Ob = ra;
                                    Pb = pa;
                                    break
                                }
                                while (1) {
                                    if ((Qb & 1) == 0) {
                                        Sb = h;
                                        Tb = (Qb & 255) >>> 1
                                    } else {
                                        Sb = c[M >> 2] | 0;
                                        Tb = c[h >> 2] | 0
                                    } if ((Rb | 0) == (Sb + (Tb << 2) | 0)) {
                                        Ub = Qb;
                                        break
                                    }
                                    if (!(ec[c[(c[r >> 2] | 0) + 12 >> 2] & 31](l, 8192, c[Rb >> 2] | 0) | 0)) {
                                        Z = 129;
                                        break
                                    }
                                    Qb = a[E] | 0;
                                    Rb = Rb + 4 | 0
                                }
                                if ((Z | 0) == 129) {
                                    Z = 0;
                                    Ub = a[E] | 0
                                }
                                ka = (Ub & 1) == 0;
                                oa = Rb - (ka ? h : c[M >> 2] | 0) >> 2;
                                ga = a[H] | 0;
                                V = (ga & 1) == 0;
                                if (V) {
                                    Vb = (ga & 255) >>> 1
                                } else {
                                    Vb = c[N >> 2] | 0
                                }
                                e: do {
                                    if (!(oa >>> 0 > Vb >>> 0)) {
                                        if (V) {
                                            Wb = N + (((ga & 255) >>> 1) - oa << 2) | 0;
                                            Xb = N;
                                            Yb = (ga & 255) >>> 1
                                        } else {
                                            X = c[O >> 2] | 0;
                                            qa = c[N >> 2] | 0;
                                            Wb = X + (qa - oa << 2) | 0;
                                            Xb = X;
                                            Yb = qa
                                        }
                                        qa = Xb + (Yb << 2) | 0;
                                        if ((Wb | 0) == (qa | 0)) {
                                            Mb = $;
                                            Nb = $;
                                            Ob = Ub;
                                            Pb = Rb;
                                            break d
                                        } else {
                                            Zb = ka ? h : c[M >> 2] | 0;
                                            _b = Wb
                                        }
                                        while (1) {
                                            if ((c[_b >> 2] | 0) != (c[Zb >> 2] | 0)) {
                                                break e
                                            }
                                            X = _b + 4 | 0;
                                            if ((X | 0) == (qa | 0)) {
                                                Mb = $;
                                                Nb = $;
                                                Ob = Ub;
                                                Pb = Rb;
                                                break d
                                            }
                                            Zb = Zb + 4 | 0;
                                            _b = X
                                        }
                                    }
                                } while (0);
                                Mb = $;
                                Nb = $;
                                Ob = Ub;
                                Pb = ka ? h : c[M >> 2] | 0
                            }
                        } while (0);
                        f: while (1) {
                            if ((Ob & 1) == 0) {
                                $b = h;
                                ac = (Ob & 255) >>> 1
                            } else {
                                $b = c[M >> 2] | 0;
                                ac = c[h >> 2] | 0
                            } if ((Pb | 0) == ($b + (ac << 2) | 0)) {
                                break
                            }
                            pa = c[g >> 2] | 0;
                            do {
                                if ((pa | 0) == 0) {
                                    bc = 1
                                } else {
                                    ra = c[pa + 12 >> 2] | 0;
                                    if ((ra | 0) == (c[pa + 16 >> 2] | 0)) {
                                        cc = kc[c[(c[pa >> 2] | 0) + 36 >> 2] & 63](pa) | 0
                                    } else {
                                        cc = c[ra >> 2] | 0
                                    } if ((cc | 0) == -1) {
                                        c[g >> 2] = 0;
                                        bc = 1;
                                        break
                                    } else {
                                        bc = (c[g >> 2] | 0) == 0;
                                        break
                                    }
                                }
                            } while (0);
                            do {
                                if ((Nb | 0) == 0) {
                                    dc = Mb;
                                    Z = 159
                                } else {
                                    pa = c[Nb + 12 >> 2] | 0;
                                    if ((pa | 0) == (c[Nb + 16 >> 2] | 0)) {
                                        fc = kc[c[(c[Nb >> 2] | 0) + 36 >> 2] & 63](Nb) | 0
                                    } else {
                                        fc = c[pa >> 2] | 0
                                    } if ((fc | 0) == -1) {
                                        c[b >> 2] = 0;
                                        dc = 0;
                                        Z = 159;
                                        break
                                    } else {
                                        if (bc ^ (Mb | 0) == 0) {
                                            gc = Mb;
                                            ic = Mb;
                                            break
                                        } else {
                                            break f
                                        }
                                    }
                                }
                            } while (0);
                            if ((Z | 0) == 159) {
                                Z = 0;
                                if (bc) {
                                    break
                                } else {
                                    gc = dc;
                                    ic = 0
                                }
                            }
                            pa = c[g >> 2] | 0;
                            ka = c[pa + 12 >> 2] | 0;
                            if ((ka | 0) == (c[pa + 16 >> 2] | 0)) {
                                jc = kc[c[(c[pa >> 2] | 0) + 36 >> 2] & 63](pa) | 0
                            } else {
                                jc = c[ka >> 2] | 0
                            } if ((jc | 0) != (c[Pb >> 2] | 0)) {
                                break
                            }
                            ka = c[g >> 2] | 0;
                            pa = ka + 12 | 0;
                            ra = c[pa >> 2] | 0;
                            if ((ra | 0) == (c[ka + 16 >> 2] | 0)) {
                                kc[c[(c[ka >> 2] | 0) + 40 >> 2] & 63](ka) | 0
                            } else {
                                c[pa >> 2] = ra + 4
                            }
                            Mb = gc;
                            Nb = ic;
                            Ob = a[E] | 0;
                            Pb = Pb + 4 | 0
                        }
                        if (!L) {
                            nb = C;
                            ob = S;
                            pb = q;
                            qb = R;
                            rb = T;
                            sb = U;
                            break b
                        }
                        ra = a[E] | 0;
                        if ((ra & 1) == 0) {
                            lc = h;
                            mc = (ra & 255) >>> 1
                        } else {
                            lc = c[M >> 2] | 0;
                            mc = c[h >> 2] | 0
                        } if ((Pb | 0) == (lc + (mc << 2) | 0)) {
                            nb = C;
                            ob = S;
                            pb = q;
                            qb = R;
                            rb = T;
                            sb = U
                        } else {
                            Z = 174;
                            break a
                        }
                        break
                    };
                default:
                    {
                        nb = C;
                        ob = S;
                        pb = q;
                        qb = R;
                        rb = T;
                        sb = U
                    }
                }
            } while (0);
            g: do {
                if ((Z | 0) == 28) {
                    Z = 0;
                    if ((o | 0) == 3) {
                        aa = S;
                        ba = q;
                        ca = T;
                        da = U;
                        Z = 292;
                        break a
                    } else {
                        nc = $;
                        oc = $
                    }
                    while (1) {
                        ra = c[g >> 2] | 0;
                        do {
                            if ((ra | 0) == 0) {
                                pc = 1
                            } else {
                                pa = c[ra + 12 >> 2] | 0;
                                if ((pa | 0) == (c[ra + 16 >> 2] | 0)) {
                                    qc = kc[c[(c[ra >> 2] | 0) + 36 >> 2] & 63](ra) | 0
                                } else {
                                    qc = c[pa >> 2] | 0
                                } if ((qc | 0) == -1) {
                                    c[g >> 2] = 0;
                                    pc = 1;
                                    break
                                } else {
                                    pc = (c[g >> 2] | 0) == 0;
                                    break
                                }
                            }
                        } while (0);
                        do {
                            if ((oc | 0) == 0) {
                                rc = nc;
                                Z = 42
                            } else {
                                ra = c[oc + 12 >> 2] | 0;
                                if ((ra | 0) == (c[oc + 16 >> 2] | 0)) {
                                    sc = kc[c[(c[oc >> 2] | 0) + 36 >> 2] & 63](oc) | 0
                                } else {
                                    sc = c[ra >> 2] | 0
                                } if ((sc | 0) == -1) {
                                    c[b >> 2] = 0;
                                    rc = 0;
                                    Z = 42;
                                    break
                                } else {
                                    if (pc ^ (nc | 0) == 0) {
                                        tc = nc;
                                        uc = nc;
                                        break
                                    } else {
                                        nb = C;
                                        ob = S;
                                        pb = q;
                                        qb = R;
                                        rb = T;
                                        sb = U;
                                        break g
                                    }
                                }
                            }
                        } while (0);
                        if ((Z | 0) == 42) {
                            Z = 0;
                            if (pc) {
                                nb = C;
                                ob = S;
                                pb = q;
                                qb = R;
                                rb = T;
                                sb = U;
                                break g
                            } else {
                                tc = rc;
                                uc = 0
                            }
                        }
                        ra = c[g >> 2] | 0;
                        pa = c[ra + 12 >> 2] | 0;
                        if ((pa | 0) == (c[ra + 16 >> 2] | 0)) {
                            vc = kc[c[(c[ra >> 2] | 0) + 36 >> 2] & 63](ra) | 0
                        } else {
                            vc = c[pa >> 2] | 0
                        } if (!(ec[c[(c[r >> 2] | 0) + 12 >> 2] & 31](l, 8192, vc) | 0)) {
                            nb = C;
                            ob = S;
                            pb = q;
                            qb = R;
                            rb = T;
                            sb = U;
                            break g
                        }
                        pa = c[g >> 2] | 0;
                        ra = pa + 12 | 0;
                        ka = c[ra >> 2] | 0;
                        if ((ka | 0) == (c[pa + 16 >> 2] | 0)) {
                            wc = kc[c[(c[pa >> 2] | 0) + 40 >> 2] & 63](pa) | 0
                        } else {
                            c[ra >> 2] = ka + 4;
                            wc = c[ka >> 2] | 0
                        }
                        Ke(z, wc);
                        nc = tc;
                        oc = uc
                    }
                }
            } while (0);
            ka = o + 1 | 0;
            if (ka >>> 0 < 4) {
                R = qb;
                q = pb;
                S = ob;
                C = nb;
                o = ka;
                T = rb;
                U = sb
            } else {
                aa = ob;
                ba = pb;
                ca = rb;
                da = sb;
                Z = 292;
                break
            }
        }
        h: do {
            if ((Z | 0) == 27) {
                c[j >> 2] = c[j >> 2] | 4;
                xc = 0;
                yc = S;
                zc = U
            } else if ((Z | 0) == 116) {
                c[j >> 2] = c[j >> 2] | 4;
                xc = 0;
                yc = S;
                zc = U
            } else if ((Z | 0) == 174) {
                c[j >> 2] = c[j >> 2] | 4;
                xc = 0;
                yc = S;
                zc = U
            } else if ((Z | 0) == 198) {
                Tm()
            } else if ((Z | 0) == 214) {
                Tm()
            } else if ((Z | 0) == 225) {
                Tm()
            } else if ((Z | 0) == 248) {
                c[j >> 2] = c[j >> 2] | 4;
                xc = 0;
                yc = Ja;
                zc = Ma
            } else if ((Z | 0) == 271) {
                c[j >> 2] = c[j >> 2] | 4;
                xc = 0;
                yc = Ja;
                zc = Ma
            } else if ((Z | 0) == 276) {
                Tm()
            } else if ((Z | 0) == 290) {
                c[j >> 2] = c[j >> 2] | 4;
                xc = 0;
                yc = Ja;
                zc = Ma
            } else if ((Z | 0) == 292) {
                i: do {
                    if ((ca | 0) != 0) {
                        sb = ca;
                        rb = ca + 4 | 0;
                        pb = ca + 8 | 0;
                        ob = 1;
                        j: while (1) {
                            T = a[sb] | 0;
                            if ((T & 1) == 0) {
                                Ac = (T & 255) >>> 1
                            } else {
                                Ac = c[rb >> 2] | 0
                            } if (!(ob >>> 0 < Ac >>> 0)) {
                                break i
                            }
                            T = c[g >> 2] | 0;
                            do {
                                if ((T | 0) == 0) {
                                    Bc = 1
                                } else {
                                    o = c[T + 12 >> 2] | 0;
                                    if ((o | 0) == (c[T + 16 >> 2] | 0)) {
                                        Cc = kc[c[(c[T >> 2] | 0) + 36 >> 2] & 63](T) | 0
                                    } else {
                                        Cc = c[o >> 2] | 0
                                    } if ((Cc | 0) == -1) {
                                        c[g >> 2] = 0;
                                        Bc = 1;
                                        break
                                    } else {
                                        Bc = (c[g >> 2] | 0) == 0;
                                        break
                                    }
                                }
                            } while (0);
                            T = c[b >> 2] | 0;
                            do {
                                if ((T | 0) == 0) {
                                    Z = 311
                                } else {
                                    o = c[T + 12 >> 2] | 0;
                                    if ((o | 0) == (c[T + 16 >> 2] | 0)) {
                                        Dc = kc[c[(c[T >> 2] | 0) + 36 >> 2] & 63](T) | 0
                                    } else {
                                        Dc = c[o >> 2] | 0
                                    } if ((Dc | 0) == -1) {
                                        c[b >> 2] = 0;
                                        Z = 311;
                                        break
                                    } else {
                                        if (Bc) {
                                            break
                                        } else {
                                            break j
                                        }
                                    }
                                }
                            } while (0);
                            if ((Z | 0) == 311) {
                                Z = 0;
                                if (Bc) {
                                    break
                                }
                            }
                            T = c[g >> 2] | 0;
                            o = c[T + 12 >> 2] | 0;
                            if ((o | 0) == (c[T + 16 >> 2] | 0)) {
                                Ec = kc[c[(c[T >> 2] | 0) + 36 >> 2] & 63](T) | 0
                            } else {
                                Ec = c[o >> 2] | 0
                            } if ((a[sb] & 1) == 0) {
                                Fc = rb
                            } else {
                                Fc = c[pb >> 2] | 0
                            } if ((Ec | 0) != (c[Fc + (ob << 2) >> 2] | 0)) {
                                break
                            }
                            o = ob + 1 | 0;
                            T = c[g >> 2] | 0;
                            nb = T + 12 | 0;
                            C = c[nb >> 2] | 0;
                            if ((C | 0) == (c[T + 16 >> 2] | 0)) {
                                kc[c[(c[T >> 2] | 0) + 40 >> 2] & 63](T) | 0;
                                ob = o;
                                continue
                            } else {
                                c[nb >> 2] = C + 4;
                                ob = o;
                                continue
                            }
                        }
                        c[j >> 2] = c[j >> 2] | 4;
                        xc = 0;
                        yc = aa;
                        zc = da;
                        break h
                    }
                } while (0);
                if ((aa | 0) == (ba | 0)) {
                    xc = 1;
                    yc = ba;
                    zc = da;
                    break
                }
                c[B >> 2] = 0;
                jj(v, aa, ba, B);
                if ((c[B >> 2] | 0) == 0) {
                    xc = 1;
                    yc = aa;
                    zc = da;
                    break
                }
                c[j >> 2] = c[j >> 2] | 4;
                xc = 0;
                yc = aa;
                zc = da
            }
        } while (0);
        Ge(z);
        Ge(y);
        Ge(x);
        Ge(w);
        ve(v);
        if ((yc | 0) == 0) {
            i = p;
            return xc | 0
        }
        hc[zc & 127](yc);
        i = p;
        return xc | 0
    }

    function oj(b, d, e, f, g, h, j, k) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        var l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0;
        d = i;
        i = i + 464 | 0;
        l = d;
        m = d + 8 | 0;
        n = d + 24 | 0;
        o = d + 424 | 0;
        p = d + 432 | 0;
        q = d + 440 | 0;
        r = d + 448 | 0;
        s = d + 456 | 0;
        t = o;
        c[t >> 2] = n;
        u = o + 4 | 0;
        c[u >> 2] = 115;
        v = n + 400 | 0;
        Pe(q, h);
        n = q;
        w = c[n >> 2] | 0;
        if (!((c[1824] | 0) == -1)) {
            c[m >> 2] = 7296;
            c[m + 4 >> 2] = 113;
            c[m + 8 >> 2] = 0;
            qe(7296, m, 114)
        }
        m = (c[7300 >> 2] | 0) + -1 | 0;
        x = c[w + 8 >> 2] | 0;
        if (!((c[w + 12 >> 2] | 0) - x >> 2 >>> 0 > m >>> 0)) {
            y = Ta(4) | 0;
            z = y;
            mm(z);
            Vb(y | 0, 15264, 101)
        }
        w = c[x + (m << 2) >> 2] | 0;
        if ((w | 0) == 0) {
            y = Ta(4) | 0;
            z = y;
            mm(z);
            Vb(y | 0, 15264, 101)
        }
        y = w;
        a[r] = 0;
        z = f;
        f = c[z >> 2] | 0;
        c[s >> 2] = f;
        m = c[h + 4 >> 2] | 0;
        h = l;
        x = s;
        c[h + 0 >> 2] = c[x + 0 >> 2];
        x = nj(e, l, g, q, m, j, r, y, o, p, v) | 0;
        if (x) {
            x = k;
            if ((a[x] & 1) == 0) {
                c[k + 4 >> 2] = 0;
                a[x] = 0
            } else {
                c[c[k + 8 >> 2] >> 2] = 0;
                c[k + 4 >> 2] = 0
            }
            x = w;
            if ((a[r] | 0) != 0) {
                Ke(k, tc[c[(c[x >> 2] | 0) + 44 >> 2] & 15](y, 45) | 0)
            }
            r = tc[c[(c[x >> 2] | 0) + 44 >> 2] & 15](y, 48) | 0;
            y = c[t >> 2] | 0;
            x = c[p >> 2] | 0;
            p = x + -4 | 0;
            a: do {
                if (y >>> 0 < p >>> 0) {
                    w = y;
                    while (1) {
                        v = w + 4 | 0;
                        if ((c[w >> 2] | 0) != (r | 0)) {
                            A = w;
                            break a
                        }
                        if (v >>> 0 < p >>> 0) {
                            w = v
                        } else {
                            A = v;
                            break
                        }
                    }
                } else {
                    A = y
                }
            } while (0);
            pj(k, A, x) | 0
        }
        x = e;
        e = c[x >> 2] | 0;
        do {
            if ((e | 0) == 0) {
                B = 1
            } else {
                A = c[e + 12 >> 2] | 0;
                if ((A | 0) == (c[e + 16 >> 2] | 0)) {
                    C = kc[c[(c[e >> 2] | 0) + 36 >> 2] & 63](e) | 0
                } else {
                    C = c[A >> 2] | 0
                } if ((C | 0) == -1) {
                    c[x >> 2] = 0;
                    B = 1;
                    break
                } else {
                    B = (c[x >> 2] | 0) == 0;
                    break
                }
            }
        } while (0);
        do {
            if ((f | 0) == 0) {
                D = 29
            } else {
                C = c[f + 12 >> 2] | 0;
                if ((C | 0) == (c[f + 16 >> 2] | 0)) {
                    E = kc[c[(c[f >> 2] | 0) + 36 >> 2] & 63](f) | 0
                } else {
                    E = c[C >> 2] | 0
                } if ((E | 0) == -1) {
                    c[z >> 2] = 0;
                    D = 29;
                    break
                } else {
                    if (B) {
                        break
                    } else {
                        D = 31;
                        break
                    }
                }
            }
        } while (0);
        if ((D | 0) == 29) {
            if (B) {
                D = 31
            }
        }
        if ((D | 0) == 31) {
            c[j >> 2] = c[j >> 2] | 2
        }
        c[b >> 2] = c[x >> 2];
        Yd(c[n >> 2] | 0) | 0;
        n = c[t >> 2] | 0;
        c[t >> 2] = 0;
        if ((n | 0) == 0) {
            i = d;
            return
        }
        hc[c[u >> 2] & 127](n);
        i = d;
        return
    }

    function pj(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0,
            g = 0,
            h = 0,
            j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0;
        f = i;
        g = b;
        h = d;
        j = a[g] | 0;
        if ((j & 1) == 0) {
            k = (j & 255) >>> 1;
            l = j;
            m = 1
        } else {
            j = c[b >> 2] | 0;
            k = c[b + 4 >> 2] | 0;
            l = j & 255;
            m = (j & -2) + -1 | 0
        }
        j = e - h >> 2;
        if ((j | 0) == 0) {
            i = f;
            return b | 0
        }
        if ((m - k | 0) >>> 0 < j >>> 0) {
            Me(b, m, k + j - m | 0, k, k, 0, 0);
            n = a[g] | 0
        } else {
            n = l
        } if ((n & 1) == 0) {
            o = b + 4 | 0
        } else {
            o = c[b + 8 >> 2] | 0
        }
        n = o + (k << 2) | 0;
        if ((d | 0) == (e | 0)) {
            p = n
        } else {
            l = k + ((e + -4 + (0 - h) | 0) >>> 2) + 1 | 0;
            h = d;
            d = n;
            while (1) {
                c[d >> 2] = c[h >> 2];
                n = h + 4 | 0;
                if ((n | 0) == (e | 0)) {
                    break
                } else {
                    d = d + 4 | 0;
                    h = n
                }
            }
            p = o + (l << 2) | 0
        }
        c[p >> 2] = 0;
        p = k + j | 0;
        if ((a[g] & 1) == 0) {
            a[g] = p << 1;
            i = f;
            return b | 0
        } else {
            c[b + 4 >> 2] = p;
            i = f;
            return b | 0
        }
        return 0
    }

    function qj(b, d, e, f, g, h, j, k, l, m) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        l = l | 0;
        m = m | 0;
        var n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0;
        n = i;
        i = i + 176 | 0;
        o = n;
        p = n + 16 | 0;
        q = n + 32 | 0;
        r = n + 40 | 0;
        s = n + 56 | 0;
        t = n + 72 | 0;
        u = n + 88 | 0;
        v = n + 104 | 0;
        w = n + 112 | 0;
        x = n + 128 | 0;
        y = n + 144 | 0;
        z = n + 160 | 0;
        if (b) {
            b = c[d >> 2] | 0;
            if (!((c[1718] | 0) == -1)) {
                c[p >> 2] = 6872;
                c[p + 4 >> 2] = 113;
                c[p + 8 >> 2] = 0;
                qe(6872, p, 114)
            }
            p = (c[6876 >> 2] | 0) + -1 | 0;
            A = c[b + 8 >> 2] | 0;
            if (!((c[b + 12 >> 2] | 0) - A >> 2 >>> 0 > p >>> 0)) {
                B = Ta(4) | 0;
                C = B;
                mm(C);
                Vb(B | 0, 15264, 101)
            }
            b = c[A + (p << 2) >> 2] | 0;
            if ((b | 0) == 0) {
                B = Ta(4) | 0;
                C = B;
                mm(C);
                Vb(B | 0, 15264, 101)
            }
            B = b;
            ic[c[(c[b >> 2] | 0) + 44 >> 2] & 63](q, B);
            C = e;
            p = c[q >> 2] | 0;
            a[C] = p;
            a[C + 1 | 0] = p >> 8;
            a[C + 2 | 0] = p >> 16;
            a[C + 3 | 0] = p >> 24;
            p = b;
            ic[c[(c[p >> 2] | 0) + 32 >> 2] & 63](r, B);
            C = l;
            if ((a[C] & 1) == 0) {
                c[l + 4 >> 2] = 0;
                a[C] = 0
            } else {
                c[c[l + 8 >> 2] >> 2] = 0;
                c[l + 4 >> 2] = 0
            }
            Je(l, 0);
            q = r;
            c[C + 0 >> 2] = c[q + 0 >> 2];
            c[C + 4 >> 2] = c[q + 4 >> 2];
            c[C + 8 >> 2] = c[q + 8 >> 2];
            c[q + 0 >> 2] = 0;
            c[q + 4 >> 2] = 0;
            c[q + 8 >> 2] = 0;
            Ge(r);
            ic[c[(c[p >> 2] | 0) + 28 >> 2] & 63](s, B);
            r = k;
            if ((a[r] & 1) == 0) {
                c[k + 4 >> 2] = 0;
                a[r] = 0
            } else {
                c[c[k + 8 >> 2] >> 2] = 0;
                c[k + 4 >> 2] = 0
            }
            Je(k, 0);
            q = s;
            c[r + 0 >> 2] = c[q + 0 >> 2];
            c[r + 4 >> 2] = c[q + 4 >> 2];
            c[r + 8 >> 2] = c[q + 8 >> 2];
            c[q + 0 >> 2] = 0;
            c[q + 4 >> 2] = 0;
            c[q + 8 >> 2] = 0;
            Ge(s);
            s = b;
            c[f >> 2] = kc[c[(c[s >> 2] | 0) + 12 >> 2] & 63](B) | 0;
            c[g >> 2] = kc[c[(c[s >> 2] | 0) + 16 >> 2] & 63](B) | 0;
            ic[c[(c[b >> 2] | 0) + 20 >> 2] & 63](t, B);
            b = h;
            if ((a[b] & 1) == 0) {
                a[h + 1 | 0] = 0;
                a[b] = 0
            } else {
                a[c[h + 8 >> 2] | 0] = 0;
                c[h + 4 >> 2] = 0
            }
            ze(h, 0);
            q = t;
            c[b + 0 >> 2] = c[q + 0 >> 2];
            c[b + 4 >> 2] = c[q + 4 >> 2];
            c[b + 8 >> 2] = c[q + 8 >> 2];
            c[q + 0 >> 2] = 0;
            c[q + 4 >> 2] = 0;
            c[q + 8 >> 2] = 0;
            ve(t);
            ic[c[(c[p >> 2] | 0) + 24 >> 2] & 63](u, B);
            p = j;
            if ((a[p] & 1) == 0) {
                c[j + 4 >> 2] = 0;
                a[p] = 0
            } else {
                c[c[j + 8 >> 2] >> 2] = 0;
                c[j + 4 >> 2] = 0
            }
            Je(j, 0);
            t = u;
            c[p + 0 >> 2] = c[t + 0 >> 2];
            c[p + 4 >> 2] = c[t + 4 >> 2];
            c[p + 8 >> 2] = c[t + 8 >> 2];
            c[t + 0 >> 2] = 0;
            c[t + 4 >> 2] = 0;
            c[t + 8 >> 2] = 0;
            Ge(u);
            D = kc[c[(c[s >> 2] | 0) + 36 >> 2] & 63](B) | 0;
            c[m >> 2] = D;
            i = n;
            return
        } else {
            B = c[d >> 2] | 0;
            if (!((c[1702] | 0) == -1)) {
                c[o >> 2] = 6808;
                c[o + 4 >> 2] = 113;
                c[o + 8 >> 2] = 0;
                qe(6808, o, 114)
            }
            o = (c[6812 >> 2] | 0) + -1 | 0;
            d = c[B + 8 >> 2] | 0;
            if (!((c[B + 12 >> 2] | 0) - d >> 2 >>> 0 > o >>> 0)) {
                E = Ta(4) | 0;
                F = E;
                mm(F);
                Vb(E | 0, 15264, 101)
            }
            B = c[d + (o << 2) >> 2] | 0;
            if ((B | 0) == 0) {
                E = Ta(4) | 0;
                F = E;
                mm(F);
                Vb(E | 0, 15264, 101)
            }
            E = B;
            ic[c[(c[B >> 2] | 0) + 44 >> 2] & 63](v, E);
            F = e;
            e = c[v >> 2] | 0;
            a[F] = e;
            a[F + 1 | 0] = e >> 8;
            a[F + 2 | 0] = e >> 16;
            a[F + 3 | 0] = e >> 24;
            e = B;
            ic[c[(c[e >> 2] | 0) + 32 >> 2] & 63](w, E);
            F = l;
            if ((a[F] & 1) == 0) {
                c[l + 4 >> 2] = 0;
                a[F] = 0
            } else {
                c[c[l + 8 >> 2] >> 2] = 0;
                c[l + 4 >> 2] = 0
            }
            Je(l, 0);
            l = w;
            c[F + 0 >> 2] = c[l + 0 >> 2];
            c[F + 4 >> 2] = c[l + 4 >> 2];
            c[F + 8 >> 2] = c[l + 8 >> 2];
            c[l + 0 >> 2] = 0;
            c[l + 4 >> 2] = 0;
            c[l + 8 >> 2] = 0;
            Ge(w);
            ic[c[(c[e >> 2] | 0) + 28 >> 2] & 63](x, E);
            w = k;
            if ((a[w] & 1) == 0) {
                c[k + 4 >> 2] = 0;
                a[w] = 0
            } else {
                c[c[k + 8 >> 2] >> 2] = 0;
                c[k + 4 >> 2] = 0
            }
            Je(k, 0);
            k = x;
            c[w + 0 >> 2] = c[k + 0 >> 2];
            c[w + 4 >> 2] = c[k + 4 >> 2];
            c[w + 8 >> 2] = c[k + 8 >> 2];
            c[k + 0 >> 2] = 0;
            c[k + 4 >> 2] = 0;
            c[k + 8 >> 2] = 0;
            Ge(x);
            x = B;
            c[f >> 2] = kc[c[(c[x >> 2] | 0) + 12 >> 2] & 63](E) | 0;
            c[g >> 2] = kc[c[(c[x >> 2] | 0) + 16 >> 2] & 63](E) | 0;
            ic[c[(c[B >> 2] | 0) + 20 >> 2] & 63](y, E);
            B = h;
            if ((a[B] & 1) == 0) {
                a[h + 1 | 0] = 0;
                a[B] = 0
            } else {
                a[c[h + 8 >> 2] | 0] = 0;
                c[h + 4 >> 2] = 0
            }
            ze(h, 0);
            h = y;
            c[B + 0 >> 2] = c[h + 0 >> 2];
            c[B + 4 >> 2] = c[h + 4 >> 2];
            c[B + 8 >> 2] = c[h + 8 >> 2];
            c[h + 0 >> 2] = 0;
            c[h + 4 >> 2] = 0;
            c[h + 8 >> 2] = 0;
            ve(y);
            ic[c[(c[e >> 2] | 0) + 24 >> 2] & 63](z, E);
            e = j;
            if ((a[e] & 1) == 0) {
                c[j + 4 >> 2] = 0;
                a[e] = 0
            } else {
                c[c[j + 8 >> 2] >> 2] = 0;
                c[j + 4 >> 2] = 0
            }
            Je(j, 0);
            j = z;
            c[e + 0 >> 2] = c[j + 0 >> 2];
            c[e + 4 >> 2] = c[j + 4 >> 2];
            c[e + 8 >> 2] = c[j + 8 >> 2];
            c[j + 0 >> 2] = 0;
            c[j + 4 >> 2] = 0;
            c[j + 8 >> 2] = 0;
            Ge(z);
            D = kc[c[(c[x >> 2] | 0) + 36 >> 2] & 63](E) | 0;
            c[m >> 2] = D;
            i = n;
            return
        }
    }

    function rj(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Om(a);
        i = b;
        return
    }

    function sj(a) {
        a = a | 0;
        i = i;
        return
    }

    function tj(b, d, e, f, g, j, l) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        j = j | 0;
        l = +l;
        var m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0,
            V = 0;
        d = i;
        i = i + 16 | 0;
        m = d;
        n = d + 8 | 0;
        o = i;
        i = i + 8 | 0;
        p = i;
        i = i + 16 | 0;
        q = i;
        i = i + 104 | 0;
        r = i;
        i = i + 8 | 0;
        s = i;
        i = i + 104 | 0;
        t = i;
        i = i + 8 | 0;
        u = i;
        i = i + 8 | 0;
        v = u;
        w = i;
        i = i + 8 | 0;
        x = i;
        i = i + 8 | 0;
        y = i;
        i = i + 16 | 0;
        z = i;
        i = i + 16 | 0;
        A = i;
        i = i + 16 | 0;
        B = i;
        i = i + 8 | 0;
        C = i;
        i = i + 104 | 0;
        D = i;
        i = i + 8 | 0;
        E = i;
        i = i + 8 | 0;
        F = i;
        i = i + 8 | 0;
        G = q;
        c[r >> 2] = G;
        q = s;
        s = o;
        h[k >> 3] = l;
        c[s >> 2] = c[k >> 2];
        c[s + 4 >> 2] = c[k + 4 >> 2];
        s = ib(G | 0, 100, 7056, o | 0) | 0;
        do {
            if (s >>> 0 > 99) {
                do {
                    if ((a[7200] | 0) == 0) {
                        if ((Ma(7200) | 0) == 0) {
                            break
                        }
                        c[1798] = hb(2147483647, 7208, 0) | 0;
                        Za(7200)
                    }
                } while (0);
                o = c[1798] | 0;
                G = n;
                h[k >> 3] = l;
                c[G >> 2] = c[k >> 2];
                c[G + 4 >> 2] = c[k + 4 >> 2];
                G = oh(r, o, 7056, n) | 0;
                o = c[r >> 2] | 0;
                if ((o | 0) == 0) {
                    Tm()
                }
                H = Hm(G) | 0;
                if ((H | 0) != 0) {
                    I = o;
                    J = H;
                    K = H;
                    L = G;
                    break
                }
                Tm()
            } else {
                I = 0;
                J = 0;
                K = q;
                L = s
            }
        } while (0);
        Pe(t, g);
        s = t;
        q = c[s >> 2] | 0;
        if (!((c[1826] | 0) == -1)) {
            c[p >> 2] = 7304;
            c[p + 4 >> 2] = 113;
            c[p + 8 >> 2] = 0;
            qe(7304, p, 114)
        }
        p = (c[7308 >> 2] | 0) + -1 | 0;
        n = c[q + 8 >> 2] | 0;
        if (!((c[q + 12 >> 2] | 0) - n >> 2 >>> 0 > p >>> 0)) {
            M = Ta(4) | 0;
            N = M;
            mm(N);
            Vb(M | 0, 15264, 101)
        }
        q = c[n + (p << 2) >> 2] | 0;
        if ((q | 0) == 0) {
            M = Ta(4) | 0;
            N = M;
            mm(N);
            Vb(M | 0, 15264, 101)
        }
        M = q;
        N = c[r >> 2] | 0;
        qc[c[(c[q >> 2] | 0) + 32 >> 2] & 7](M, N, N + L | 0, K) | 0;
        if ((L | 0) == 0) {
            O = 0
        } else {
            O = (a[c[r >> 2] | 0] | 0) == 45
        }
        c[u >> 2] = 0;
        u = y;
        c[u + 0 >> 2] = 0;
        c[u + 4 >> 2] = 0;
        c[u + 8 >> 2] = 0;
        u = z;
        c[u + 0 >> 2] = 0;
        c[u + 4 >> 2] = 0;
        c[u + 8 >> 2] = 0;
        r = A;
        c[r + 0 >> 2] = 0;
        c[r + 4 >> 2] = 0;
        c[r + 8 >> 2] = 0;
        uj(f, O, t, v, w, x, y, z, A, B);
        t = C;
        C = c[B >> 2] | 0;
        if ((L | 0) > (C | 0)) {
            B = a[r] | 0;
            if ((B & 1) == 0) {
                P = (B & 255) >>> 1
            } else {
                P = c[A + 4 >> 2] | 0
            }
            B = a[u] | 0;
            if ((B & 1) == 0) {
                Q = (B & 255) >>> 1
            } else {
                Q = c[z + 4 >> 2] | 0
            }
            R = P + (L - C << 1 | 1) + Q | 0
        } else {
            Q = a[r] | 0;
            if ((Q & 1) == 0) {
                S = (Q & 255) >>> 1
            } else {
                S = c[A + 4 >> 2] | 0
            }
            Q = a[u] | 0;
            if ((Q & 1) == 0) {
                T = (Q & 255) >>> 1
            } else {
                T = c[z + 4 >> 2] | 0
            }
            R = S + 2 + T | 0
        }
        T = R + C | 0;
        do {
            if (T >>> 0 > 100) {
                R = Hm(T) | 0;
                if ((R | 0) != 0) {
                    U = R;
                    V = R;
                    break
                }
                Tm()
            } else {
                U = 0;
                V = t
            }
        } while (0);
        vj(V, D, E, c[g + 4 >> 2] | 0, K, K + L | 0, M, O, v, a[w] | 0, a[x] | 0, y, z, A, C);
        c[F >> 2] = c[e >> 2];
        e = c[D >> 2] | 0;
        D = c[E >> 2] | 0;
        E = m;
        C = F;
        c[E + 0 >> 2] = c[C + 0 >> 2];
        jh(b, m, V, e, D, g, j);
        if ((U | 0) != 0) {
            Im(U)
        }
        ve(A);
        ve(z);
        ve(y);
        Yd(c[s >> 2] | 0) | 0;
        if ((J | 0) != 0) {
            Im(J)
        }
        if ((I | 0) == 0) {
            i = d;
            return
        }
        Im(I);
        i = d;
        return
    }

    function uj(b, d, e, f, g, h, j, k, l, m) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        l = l | 0;
        m = m | 0;
        var n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0;
        n = i;
        i = i + 40 | 0;
        o = n;
        p = n + 16 | 0;
        q = n + 32 | 0;
        r = q;
        s = i;
        i = i + 16 | 0;
        t = i;
        i = i + 8 | 0;
        u = t;
        v = i;
        i = i + 16 | 0;
        w = i;
        i = i + 16 | 0;
        x = i;
        i = i + 16 | 0;
        y = i;
        i = i + 8 | 0;
        z = y;
        A = i;
        i = i + 16 | 0;
        B = i;
        i = i + 8 | 0;
        C = B;
        D = i;
        i = i + 16 | 0;
        E = i;
        i = i + 16 | 0;
        F = i;
        i = i + 16 | 0;
        G = c[e >> 2] | 0;
        if (b) {
            if (!((c[1686] | 0) == -1)) {
                c[p >> 2] = 6744;
                c[p + 4 >> 2] = 113;
                c[p + 8 >> 2] = 0;
                qe(6744, p, 114)
            }
            p = (c[6748 >> 2] | 0) + -1 | 0;
            b = c[G + 8 >> 2] | 0;
            if (!((c[G + 12 >> 2] | 0) - b >> 2 >>> 0 > p >>> 0)) {
                H = Ta(4) | 0;
                I = H;
                mm(I);
                Vb(H | 0, 15264, 101)
            }
            e = c[b + (p << 2) >> 2] | 0;
            if ((e | 0) == 0) {
                H = Ta(4) | 0;
                I = H;
                mm(I);
                Vb(H | 0, 15264, 101)
            }
            H = e;
            I = c[e >> 2] | 0;
            if (d) {
                ic[c[I + 44 >> 2] & 63](r, H);
                r = f;
                p = c[q >> 2] | 0;
                a[r] = p;
                a[r + 1 | 0] = p >> 8;
                a[r + 2 | 0] = p >> 16;
                a[r + 3 | 0] = p >> 24;
                ic[c[(c[e >> 2] | 0) + 32 >> 2] & 63](s, H);
                p = l;
                if ((a[p] & 1) == 0) {
                    a[l + 1 | 0] = 0;
                    a[p] = 0
                } else {
                    a[c[l + 8 >> 2] | 0] = 0;
                    c[l + 4 >> 2] = 0
                }
                ze(l, 0);
                r = s;
                c[p + 0 >> 2] = c[r + 0 >> 2];
                c[p + 4 >> 2] = c[r + 4 >> 2];
                c[p + 8 >> 2] = c[r + 8 >> 2];
                c[r + 0 >> 2] = 0;
                c[r + 4 >> 2] = 0;
                c[r + 8 >> 2] = 0;
                ve(s)
            } else {
                ic[c[I + 40 >> 2] & 63](u, H);
                u = f;
                I = c[t >> 2] | 0;
                a[u] = I;
                a[u + 1 | 0] = I >> 8;
                a[u + 2 | 0] = I >> 16;
                a[u + 3 | 0] = I >> 24;
                ic[c[(c[e >> 2] | 0) + 28 >> 2] & 63](v, H);
                I = l;
                if ((a[I] & 1) == 0) {
                    a[l + 1 | 0] = 0;
                    a[I] = 0
                } else {
                    a[c[l + 8 >> 2] | 0] = 0;
                    c[l + 4 >> 2] = 0
                }
                ze(l, 0);
                u = v;
                c[I + 0 >> 2] = c[u + 0 >> 2];
                c[I + 4 >> 2] = c[u + 4 >> 2];
                c[I + 8 >> 2] = c[u + 8 >> 2];
                c[u + 0 >> 2] = 0;
                c[u + 4 >> 2] = 0;
                c[u + 8 >> 2] = 0;
                ve(v)
            }
            v = e;
            a[g] = kc[c[(c[v >> 2] | 0) + 12 >> 2] & 63](H) | 0;
            a[h] = kc[c[(c[v >> 2] | 0) + 16 >> 2] & 63](H) | 0;
            v = e;
            ic[c[(c[v >> 2] | 0) + 20 >> 2] & 63](w, H);
            u = j;
            if ((a[u] & 1) == 0) {
                a[j + 1 | 0] = 0;
                a[u] = 0
            } else {
                a[c[j + 8 >> 2] | 0] = 0;
                c[j + 4 >> 2] = 0
            }
            ze(j, 0);
            I = w;
            c[u + 0 >> 2] = c[I + 0 >> 2];
            c[u + 4 >> 2] = c[I + 4 >> 2];
            c[u + 8 >> 2] = c[I + 8 >> 2];
            c[I + 0 >> 2] = 0;
            c[I + 4 >> 2] = 0;
            c[I + 8 >> 2] = 0;
            ve(w);
            ic[c[(c[v >> 2] | 0) + 24 >> 2] & 63](x, H);
            v = k;
            if ((a[v] & 1) == 0) {
                a[k + 1 | 0] = 0;
                a[v] = 0
            } else {
                a[c[k + 8 >> 2] | 0] = 0;
                c[k + 4 >> 2] = 0
            }
            ze(k, 0);
            w = x;
            c[v + 0 >> 2] = c[w + 0 >> 2];
            c[v + 4 >> 2] = c[w + 4 >> 2];
            c[v + 8 >> 2] = c[w + 8 >> 2];
            c[w + 0 >> 2] = 0;
            c[w + 4 >> 2] = 0;
            c[w + 8 >> 2] = 0;
            ve(x);
            J = kc[c[(c[e >> 2] | 0) + 36 >> 2] & 63](H) | 0;
            c[m >> 2] = J;
            i = n;
            return
        } else {
            if (!((c[1670] | 0) == -1)) {
                c[o >> 2] = 6680;
                c[o + 4 >> 2] = 113;
                c[o + 8 >> 2] = 0;
                qe(6680, o, 114)
            }
            o = (c[6684 >> 2] | 0) + -1 | 0;
            H = c[G + 8 >> 2] | 0;
            if (!((c[G + 12 >> 2] | 0) - H >> 2 >>> 0 > o >>> 0)) {
                K = Ta(4) | 0;
                L = K;
                mm(L);
                Vb(K | 0, 15264, 101)
            }
            G = c[H + (o << 2) >> 2] | 0;
            if ((G | 0) == 0) {
                K = Ta(4) | 0;
                L = K;
                mm(L);
                Vb(K | 0, 15264, 101)
            }
            K = G;
            L = c[G >> 2] | 0;
            if (d) {
                ic[c[L + 44 >> 2] & 63](z, K);
                z = f;
                d = c[y >> 2] | 0;
                a[z] = d;
                a[z + 1 | 0] = d >> 8;
                a[z + 2 | 0] = d >> 16;
                a[z + 3 | 0] = d >> 24;
                ic[c[(c[G >> 2] | 0) + 32 >> 2] & 63](A, K);
                d = l;
                if ((a[d] & 1) == 0) {
                    a[l + 1 | 0] = 0;
                    a[d] = 0
                } else {
                    a[c[l + 8 >> 2] | 0] = 0;
                    c[l + 4 >> 2] = 0
                }
                ze(l, 0);
                z = A;
                c[d + 0 >> 2] = c[z + 0 >> 2];
                c[d + 4 >> 2] = c[z + 4 >> 2];
                c[d + 8 >> 2] = c[z + 8 >> 2];
                c[z + 0 >> 2] = 0;
                c[z + 4 >> 2] = 0;
                c[z + 8 >> 2] = 0;
                ve(A)
            } else {
                ic[c[L + 40 >> 2] & 63](C, K);
                C = f;
                f = c[B >> 2] | 0;
                a[C] = f;
                a[C + 1 | 0] = f >> 8;
                a[C + 2 | 0] = f >> 16;
                a[C + 3 | 0] = f >> 24;
                ic[c[(c[G >> 2] | 0) + 28 >> 2] & 63](D, K);
                f = l;
                if ((a[f] & 1) == 0) {
                    a[l + 1 | 0] = 0;
                    a[f] = 0
                } else {
                    a[c[l + 8 >> 2] | 0] = 0;
                    c[l + 4 >> 2] = 0
                }
                ze(l, 0);
                l = D;
                c[f + 0 >> 2] = c[l + 0 >> 2];
                c[f + 4 >> 2] = c[l + 4 >> 2];
                c[f + 8 >> 2] = c[l + 8 >> 2];
                c[l + 0 >> 2] = 0;
                c[l + 4 >> 2] = 0;
                c[l + 8 >> 2] = 0;
                ve(D)
            }
            D = G;
            a[g] = kc[c[(c[D >> 2] | 0) + 12 >> 2] & 63](K) | 0;
            a[h] = kc[c[(c[D >> 2] | 0) + 16 >> 2] & 63](K) | 0;
            D = G;
            ic[c[(c[D >> 2] | 0) + 20 >> 2] & 63](E, K);
            h = j;
            if ((a[h] & 1) == 0) {
                a[j + 1 | 0] = 0;
                a[h] = 0
            } else {
                a[c[j + 8 >> 2] | 0] = 0;
                c[j + 4 >> 2] = 0
            }
            ze(j, 0);
            j = E;
            c[h + 0 >> 2] = c[j + 0 >> 2];
            c[h + 4 >> 2] = c[j + 4 >> 2];
            c[h + 8 >> 2] = c[j + 8 >> 2];
            c[j + 0 >> 2] = 0;
            c[j + 4 >> 2] = 0;
            c[j + 8 >> 2] = 0;
            ve(E);
            ic[c[(c[D >> 2] | 0) + 24 >> 2] & 63](F, K);
            D = k;
            if ((a[D] & 1) == 0) {
                a[k + 1 | 0] = 0;
                a[D] = 0
            } else {
                a[c[k + 8 >> 2] | 0] = 0;
                c[k + 4 >> 2] = 0
            }
            ze(k, 0);
            k = F;
            c[D + 0 >> 2] = c[k + 0 >> 2];
            c[D + 4 >> 2] = c[k + 4 >> 2];
            c[D + 8 >> 2] = c[k + 8 >> 2];
            c[k + 0 >> 2] = 0;
            c[k + 4 >> 2] = 0;
            c[k + 8 >> 2] = 0;
            ve(F);
            J = kc[c[(c[G >> 2] | 0) + 36 >> 2] & 63](K) | 0;
            c[m >> 2] = J;
            i = n;
            return
        }
    }

    function vj(d, e, f, g, h, j, k, l, m, n, o, p, q, r, s) {
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        l = l | 0;
        m = m | 0;
        n = n | 0;
        o = o | 0;
        p = p | 0;
        q = q | 0;
        r = r | 0;
        s = s | 0;
        var t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0,
            V = 0,
            W = 0,
            X = 0,
            Y = 0,
            Z = 0,
            _ = 0,
            $ = 0,
            aa = 0,
            ba = 0,
            ca = 0,
            da = 0,
            ea = 0,
            fa = 0,
            ga = 0,
            ha = 0,
            ia = 0,
            ja = 0,
            ka = 0,
            la = 0,
            ma = 0,
            na = 0,
            oa = 0,
            pa = 0,
            qa = 0,
            ra = 0,
            sa = 0,
            ta = 0,
            ua = 0,
            va = 0,
            wa = 0,
            xa = 0,
            ya = 0;
        t = i;
        c[f >> 2] = d;
        u = k;
        v = r;
        w = r + 1 | 0;
        x = r + 8 | 0;
        y = r + 4 | 0;
        r = q;
        z = (g & 512 | 0) == 0;
        A = q + 1 | 0;
        B = q + 8 | 0;
        C = q + 4 | 0;
        q = (s | 0) > 0;
        D = p;
        E = p + 1 | 0;
        F = p + 8 | 0;
        G = p + 4 | 0;
        p = k + 8 | 0;
        H = 0 - s | 0;
        I = h;
        h = 0;
        while (1) {
            a: do {
                switch (a[m + h | 0] | 0) {
                case 0:
                    {
                        c[e >> 2] = c[f >> 2];
                        J = I;
                        break
                    };
                case 4:
                    {
                        K = c[f >> 2] | 0;
                        L = l ? I + 1 | 0 : I;
                        b: do {
                            if (L >>> 0 < j >>> 0) {
                                M = L;
                                while (1) {
                                    N = a[M] | 0;
                                    if (!(N << 24 >> 24 > -1)) {
                                        O = M;
                                        break b
                                    }
                                    P = M + 1 | 0;
                                    if ((b[(c[p >> 2] | 0) + (N << 24 >> 24 << 1) >> 1] & 2048) == 0) {
                                        O = M;
                                        break b
                                    }
                                    if (P >>> 0 < j >>> 0) {
                                        M = P
                                    } else {
                                        O = P;
                                        break
                                    }
                                }
                            } else {
                                O = L
                            }
                        } while (0);
                        M = O;
                        if (q) {
                            if (O >>> 0 > L >>> 0) {
                                P = L + (0 - M) | 0;
                                M = P >>> 0 < H >>> 0 ? H : P;
                                P = M + s | 0;
                                N = K;
                                Q = O;
                                R = s;
                                while (1) {
                                    S = Q + -1 | 0;
                                    T = a[S] | 0;
                                    c[f >> 2] = N + 1;
                                    a[N] = T;
                                    T = R + -1 | 0;
                                    U = (T | 0) > 0;
                                    if (!(S >>> 0 > L >>> 0 & U)) {
                                        break
                                    }
                                    N = c[f >> 2] | 0;
                                    R = T;
                                    Q = S
                                }
                                Q = O + M | 0;
                                if (U) {
                                    V = Q;
                                    W = P;
                                    X = 32
                                } else {
                                    Y = 0;
                                    Z = Q;
                                    _ = P
                                }
                            } else {
                                V = O;
                                W = s;
                                X = 32
                            } if ((X | 0) == 32) {
                                X = 0;
                                Y = tc[c[(c[u >> 2] | 0) + 28 >> 2] & 15](k, 48) | 0;
                                Z = V;
                                _ = W
                            }
                            Q = c[f >> 2] | 0;
                            c[f >> 2] = Q + 1;
                            if ((_ | 0) > 0) {
                                R = Q;
                                N = _;
                                while (1) {
                                    a[R] = Y;
                                    S = N + -1 | 0;
                                    T = c[f >> 2] | 0;
                                    c[f >> 2] = T + 1;
                                    if ((S | 0) > 0) {
                                        N = S;
                                        R = T
                                    } else {
                                        $ = T;
                                        break
                                    }
                                }
                            } else {
                                $ = Q
                            }
                            a[$] = n;
                            aa = Z
                        } else {
                            aa = O
                        } if ((aa | 0) == (L | 0)) {
                            R = tc[c[(c[u >> 2] | 0) + 28 >> 2] & 15](k, 48) | 0;
                            N = c[f >> 2] | 0;
                            c[f >> 2] = N + 1;
                            a[N] = R
                        } else {
                            R = a[D] | 0;
                            N = (R & 1) == 0;
                            if (N) {
                                ba = (R & 255) >>> 1
                            } else {
                                ba = c[G >> 2] | 0
                            } if ((ba | 0) == 0) {
                                ca = aa;
                                da = -1;
                                ea = 0;
                                fa = 0
                            } else {
                                if (N) {
                                    ga = E
                                } else {
                                    ga = c[F >> 2] | 0
                                }
                                ca = aa;
                                da = a[ga] | 0;
                                ea = 0;
                                fa = 0
                            }
                            while (1) {
                                do {
                                    if ((fa | 0) == (da | 0)) {
                                        N = c[f >> 2] | 0;
                                        c[f >> 2] = N + 1;
                                        a[N] = o;
                                        N = ea + 1 | 0;
                                        R = a[D] | 0;
                                        P = (R & 1) == 0;
                                        if (P) {
                                            ha = (R & 255) >>> 1
                                        } else {
                                            ha = c[G >> 2] | 0
                                        } if (!(N >>> 0 < ha >>> 0)) {
                                            ia = da;
                                            ja = N;
                                            ka = 0;
                                            break
                                        }
                                        if (P) {
                                            la = E
                                        } else {
                                            la = c[F >> 2] | 0
                                        } if ((a[la + N | 0] | 0) == 127) {
                                            ia = -1;
                                            ja = N;
                                            ka = 0;
                                            break
                                        }
                                        if (P) {
                                            ma = E
                                        } else {
                                            ma = c[F >> 2] | 0
                                        }
                                        ia = a[ma + N | 0] | 0;
                                        ja = N;
                                        ka = 0
                                    } else {
                                        ia = da;
                                        ja = ea;
                                        ka = fa
                                    }
                                } while (0);
                                N = ca + -1 | 0;
                                P = a[N] | 0;
                                R = c[f >> 2] | 0;
                                c[f >> 2] = R + 1;
                                a[R] = P;
                                if ((N | 0) == (L | 0)) {
                                    break
                                } else {
                                    ca = N;
                                    da = ia;
                                    ea = ja;
                                    fa = ka + 1 | 0
                                }
                            }
                        }
                        Q = c[f >> 2] | 0;
                        if ((K | 0) == (Q | 0)) {
                            J = L;
                            break a
                        }
                        N = Q + -1 | 0;
                        if (N >>> 0 > K >>> 0) {
                            na = K;
                            oa = N
                        } else {
                            J = L;
                            break a
                        }
                        while (1) {
                            N = a[na] | 0;
                            a[na] = a[oa] | 0;
                            a[oa] = N;
                            N = na + 1 | 0;
                            Q = oa + -1 | 0;
                            if (N >>> 0 < Q >>> 0) {
                                oa = Q;
                                na = N
                            } else {
                                J = L;
                                break
                            }
                        }
                        break
                    };
                case 2:
                    {
                        L = a[r] | 0;
                        K = (L & 1) == 0;
                        if (K) {
                            pa = (L & 255) >>> 1
                        } else {
                            pa = c[C >> 2] | 0
                        } if ((pa | 0) == 0 | z) {
                            J = I;
                            break a
                        }
                        if (K) {
                            qa = A;
                            ra = (L & 255) >>> 1
                        } else {
                            qa = c[B >> 2] | 0;
                            ra = c[C >> 2] | 0
                        }
                        L = qa + ra | 0;
                        K = c[f >> 2] | 0;
                        if ((qa | 0) == (L | 0)) {
                            sa = K
                        } else {
                            N = K;
                            K = qa;
                            while (1) {
                                a[N] = a[K] | 0;
                                Q = K + 1 | 0;
                                P = N + 1 | 0;
                                if ((Q | 0) == (L | 0)) {
                                    sa = P;
                                    break
                                } else {
                                    K = Q;
                                    N = P
                                }
                            }
                        }
                        c[f >> 2] = sa;
                        J = I;
                        break
                    };
                case 3:
                    {
                        N = a[v] | 0;
                        K = (N & 1) == 0;
                        if (K) {
                            ta = (N & 255) >>> 1
                        } else {
                            ta = c[y >> 2] | 0
                        } if ((ta | 0) == 0) {
                            J = I;
                            break a
                        }
                        if (K) {
                            ua = w
                        } else {
                            ua = c[x >> 2] | 0
                        }
                        K = a[ua] | 0;
                        N = c[f >> 2] | 0;
                        c[f >> 2] = N + 1;
                        a[N] = K;
                        J = I;
                        break
                    };
                case 1:
                    {
                        c[e >> 2] = c[f >> 2];
                        K = tc[c[(c[u >> 2] | 0) + 28 >> 2] & 15](k, 32) | 0;
                        N = c[f >> 2] | 0;
                        c[f >> 2] = N + 1;
                        a[N] = K;
                        J = I;
                        break
                    };
                default:
                    {
                        J = I
                    }
                }
            } while (0);
            K = h + 1 | 0;
            if ((K | 0) == 4) {
                break
            } else {
                I = J;
                h = K
            }
        }
        h = a[v] | 0;
        v = (h & 1) == 0;
        if (v) {
            va = (h & 255) >>> 1
        } else {
            va = c[y >> 2] | 0
        } if (va >>> 0 > 1) {
            if (v) {
                wa = w;
                xa = (h & 255) >>> 1
            } else {
                wa = c[x >> 2] | 0;
                xa = c[y >> 2] | 0
            }
            y = wa + 1 | 0;
            x = wa + xa | 0;
            xa = c[f >> 2] | 0;
            if ((y | 0) == (x | 0)) {
                ya = xa
            } else {
                wa = xa;
                xa = y;
                while (1) {
                    a[wa] = a[xa] | 0;
                    y = xa + 1 | 0;
                    h = wa + 1 | 0;
                    if ((y | 0) == (x | 0)) {
                        ya = h;
                        break
                    } else {
                        xa = y;
                        wa = h
                    }
                }
            }
            c[f >> 2] = ya
        }
        ya = g & 176;
        if ((ya | 0) == 32) {
            c[e >> 2] = c[f >> 2];
            i = t;
            return
        } else if ((ya | 0) == 16) {
            i = t;
            return
        } else {
            c[e >> 2] = d;
            i = t;
            return
        }
    }

    function wj(b, d, e, f, g, h, j) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        var k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0;
        d = i;
        i = i + 40 | 0;
        k = d;
        l = d + 8 | 0;
        m = d + 24 | 0;
        n = d + 32 | 0;
        o = n;
        p = i;
        i = i + 8 | 0;
        q = i;
        i = i + 8 | 0;
        r = i;
        i = i + 16 | 0;
        s = i;
        i = i + 16 | 0;
        t = i;
        i = i + 16 | 0;
        u = i;
        i = i + 8 | 0;
        v = i;
        i = i + 104 | 0;
        w = i;
        i = i + 8 | 0;
        x = i;
        i = i + 8 | 0;
        y = i;
        i = i + 8 | 0;
        Pe(m, g);
        z = m;
        A = c[z >> 2] | 0;
        if (!((c[1826] | 0) == -1)) {
            c[l >> 2] = 7304;
            c[l + 4 >> 2] = 113;
            c[l + 8 >> 2] = 0;
            qe(7304, l, 114)
        }
        l = (c[7308 >> 2] | 0) + -1 | 0;
        B = c[A + 8 >> 2] | 0;
        if (!((c[A + 12 >> 2] | 0) - B >> 2 >>> 0 > l >>> 0)) {
            C = Ta(4) | 0;
            D = C;
            mm(D);
            Vb(C | 0, 15264, 101)
        }
        A = c[B + (l << 2) >> 2] | 0;
        if ((A | 0) == 0) {
            C = Ta(4) | 0;
            D = C;
            mm(D);
            Vb(C | 0, 15264, 101)
        }
        C = A;
        D = j;
        l = a[D] | 0;
        B = (l & 1) == 0;
        if (B) {
            E = (l & 255) >>> 1
        } else {
            E = c[j + 4 >> 2] | 0
        } if ((E | 0) == 0) {
            F = 0
        } else {
            if (B) {
                G = j + 1 | 0
            } else {
                G = c[j + 8 >> 2] | 0
            }
            B = a[G] | 0;
            F = B << 24 >> 24 == (tc[c[(c[A >> 2] | 0) + 28 >> 2] & 15](C, 45) | 0) << 24 >> 24
        }
        c[n >> 2] = 0;
        n = r;
        c[n + 0 >> 2] = 0;
        c[n + 4 >> 2] = 0;
        c[n + 8 >> 2] = 0;
        n = s;
        c[n + 0 >> 2] = 0;
        c[n + 4 >> 2] = 0;
        c[n + 8 >> 2] = 0;
        A = t;
        c[A + 0 >> 2] = 0;
        c[A + 4 >> 2] = 0;
        c[A + 8 >> 2] = 0;
        uj(f, F, m, o, p, q, r, s, t, u);
        m = v;
        v = a[D] | 0;
        D = (v & 1) == 0;
        if (D) {
            H = (v & 255) >>> 1
        } else {
            H = c[j + 4 >> 2] | 0
        }
        f = c[u >> 2] | 0;
        if ((H | 0) > (f | 0)) {
            if (D) {
                I = (v & 255) >>> 1
            } else {
                I = c[j + 4 >> 2] | 0
            }
            D = a[A] | 0;
            if ((D & 1) == 0) {
                J = (D & 255) >>> 1
            } else {
                J = c[t + 4 >> 2] | 0
            }
            D = a[n] | 0;
            if ((D & 1) == 0) {
                K = (D & 255) >>> 1
            } else {
                K = c[s + 4 >> 2] | 0
            }
            L = J + (I - f << 1 | 1) + K | 0
        } else {
            K = a[A] | 0;
            if ((K & 1) == 0) {
                M = (K & 255) >>> 1
            } else {
                M = c[t + 4 >> 2] | 0
            }
            K = a[n] | 0;
            if ((K & 1) == 0) {
                N = (K & 255) >>> 1
            } else {
                N = c[s + 4 >> 2] | 0
            }
            L = M + 2 + N | 0
        }
        N = L + f | 0;
        do {
            if (N >>> 0 > 100) {
                L = Hm(N) | 0;
                if ((L | 0) != 0) {
                    O = L;
                    P = L;
                    break
                }
                Tm()
            } else {
                O = 0;
                P = m
            }
        } while (0);
        if ((v & 1) == 0) {
            Q = j + 1 | 0;
            R = (v & 255) >>> 1
        } else {
            Q = c[j + 8 >> 2] | 0;
            R = c[j + 4 >> 2] | 0
        }
        vj(P, w, x, c[g + 4 >> 2] | 0, Q, Q + R | 0, C, F, o, a[p] | 0, a[q] | 0, r, s, t, f);
        c[y >> 2] = c[e >> 2];
        e = c[w >> 2] | 0;
        w = c[x >> 2] | 0;
        x = k;
        f = y;
        c[x + 0 >> 2] = c[f + 0 >> 2];
        jh(b, k, P, e, w, g, h);
        if ((O | 0) == 0) {
            ve(t);
            ve(s);
            ve(r);
            S = c[z >> 2] | 0;
            T = S;
            Yd(T) | 0;
            i = d;
            return
        }
        Im(O);
        ve(t);
        ve(s);
        ve(r);
        S = c[z >> 2] | 0;
        T = S;
        Yd(T) | 0;
        i = d;
        return
    }

    function xj(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Om(a);
        i = b;
        return
    }

    function yj(a) {
        a = a | 0;
        i = i;
        return
    }

    function zj(b, d, e, f, g, j, l) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        j = j | 0;
        l = +l;
        var m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0,
            V = 0,
            W = 0;
        d = i;
        i = i + 16 | 0;
        m = d;
        n = d + 8 | 0;
        o = i;
        i = i + 8 | 0;
        p = i;
        i = i + 16 | 0;
        q = i;
        i = i + 104 | 0;
        r = i;
        i = i + 8 | 0;
        s = i;
        i = i + 400 | 0;
        t = i;
        i = i + 8 | 0;
        u = i;
        i = i + 8 | 0;
        v = u;
        w = i;
        i = i + 8 | 0;
        x = i;
        i = i + 8 | 0;
        y = i;
        i = i + 16 | 0;
        z = i;
        i = i + 16 | 0;
        A = i;
        i = i + 16 | 0;
        B = i;
        i = i + 8 | 0;
        C = i;
        i = i + 400 | 0;
        D = i;
        i = i + 8 | 0;
        E = i;
        i = i + 8 | 0;
        F = i;
        i = i + 8 | 0;
        G = q;
        c[r >> 2] = G;
        q = s;
        s = o;
        h[k >> 3] = l;
        c[s >> 2] = c[k >> 2];
        c[s + 4 >> 2] = c[k + 4 >> 2];
        s = ib(G | 0, 100, 7056, o | 0) | 0;
        do {
            if (s >>> 0 > 99) {
                do {
                    if ((a[7200] | 0) == 0) {
                        if ((Ma(7200) | 0) == 0) {
                            break
                        }
                        c[1798] = hb(2147483647, 7208, 0) | 0;
                        Za(7200)
                    }
                } while (0);
                o = c[1798] | 0;
                G = n;
                h[k >> 3] = l;
                c[G >> 2] = c[k >> 2];
                c[G + 4 >> 2] = c[k + 4 >> 2];
                G = oh(r, o, 7056, n) | 0;
                o = c[r >> 2] | 0;
                if ((o | 0) == 0) {
                    Tm()
                }
                H = Hm(G << 2) | 0;
                I = H;
                if ((H | 0) != 0) {
                    J = o;
                    K = I;
                    L = I;
                    M = G;
                    break
                }
                Tm()
            } else {
                J = 0;
                K = 0;
                L = q;
                M = s
            }
        } while (0);
        Pe(t, g);
        s = t;
        q = c[s >> 2] | 0;
        if (!((c[1824] | 0) == -1)) {
            c[p >> 2] = 7296;
            c[p + 4 >> 2] = 113;
            c[p + 8 >> 2] = 0;
            qe(7296, p, 114)
        }
        p = (c[7300 >> 2] | 0) + -1 | 0;
        n = c[q + 8 >> 2] | 0;
        if (!((c[q + 12 >> 2] | 0) - n >> 2 >>> 0 > p >>> 0)) {
            N = Ta(4) | 0;
            O = N;
            mm(O);
            Vb(N | 0, 15264, 101)
        }
        q = c[n + (p << 2) >> 2] | 0;
        if ((q | 0) == 0) {
            N = Ta(4) | 0;
            O = N;
            mm(O);
            Vb(N | 0, 15264, 101)
        }
        N = q;
        O = c[r >> 2] | 0;
        qc[c[(c[q >> 2] | 0) + 48 >> 2] & 7](N, O, O + M | 0, L) | 0;
        if ((M | 0) == 0) {
            P = 0
        } else {
            P = (a[c[r >> 2] | 0] | 0) == 45
        }
        c[u >> 2] = 0;
        u = y;
        c[u + 0 >> 2] = 0;
        c[u + 4 >> 2] = 0;
        c[u + 8 >> 2] = 0;
        u = z;
        c[u + 0 >> 2] = 0;
        c[u + 4 >> 2] = 0;
        c[u + 8 >> 2] = 0;
        r = A;
        c[r + 0 >> 2] = 0;
        c[r + 4 >> 2] = 0;
        c[r + 8 >> 2] = 0;
        Aj(f, P, t, v, w, x, y, z, A, B);
        t = C;
        C = c[B >> 2] | 0;
        if ((M | 0) > (C | 0)) {
            B = a[r] | 0;
            if ((B & 1) == 0) {
                Q = (B & 255) >>> 1
            } else {
                Q = c[A + 4 >> 2] | 0
            }
            B = a[u] | 0;
            if ((B & 1) == 0) {
                R = (B & 255) >>> 1
            } else {
                R = c[z + 4 >> 2] | 0
            }
            S = Q + (M - C << 1 | 1) + R | 0
        } else {
            R = a[r] | 0;
            if ((R & 1) == 0) {
                T = (R & 255) >>> 1
            } else {
                T = c[A + 4 >> 2] | 0
            }
            R = a[u] | 0;
            if ((R & 1) == 0) {
                U = (R & 255) >>> 1
            } else {
                U = c[z + 4 >> 2] | 0
            }
            S = T + 2 + U | 0
        }
        U = S + C | 0;
        do {
            if (U >>> 0 > 100) {
                S = Hm(U << 2) | 0;
                T = S;
                if ((S | 0) != 0) {
                    V = T;
                    W = T;
                    break
                }
                Tm()
            } else {
                V = 0;
                W = t
            }
        } while (0);
        Bj(W, D, E, c[g + 4 >> 2] | 0, L, L + (M << 2) | 0, N, P, v, c[w >> 2] | 0, c[x >> 2] | 0, y, z, A, C);
        c[F >> 2] = c[e >> 2];
        e = c[D >> 2] | 0;
        D = c[E >> 2] | 0;
        E = m;
        C = F;
        c[E + 0 >> 2] = c[C + 0 >> 2];
        xh(b, m, W, e, D, g, j);
        if ((V | 0) != 0) {
            Im(V)
        }
        Ge(A);
        Ge(z);
        ve(y);
        Yd(c[s >> 2] | 0) | 0;
        if ((K | 0) != 0) {
            Im(K)
        }
        if ((J | 0) == 0) {
            i = d;
            return
        }
        Im(J);
        i = d;
        return
    }

    function Aj(b, d, e, f, g, h, j, k, l, m) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        l = l | 0;
        m = m | 0;
        var n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0;
        n = i;
        i = i + 40 | 0;
        o = n;
        p = n + 16 | 0;
        q = n + 32 | 0;
        r = q;
        s = i;
        i = i + 16 | 0;
        t = i;
        i = i + 8 | 0;
        u = t;
        v = i;
        i = i + 16 | 0;
        w = i;
        i = i + 16 | 0;
        x = i;
        i = i + 16 | 0;
        y = i;
        i = i + 8 | 0;
        z = y;
        A = i;
        i = i + 16 | 0;
        B = i;
        i = i + 8 | 0;
        C = B;
        D = i;
        i = i + 16 | 0;
        E = i;
        i = i + 16 | 0;
        F = i;
        i = i + 16 | 0;
        G = c[e >> 2] | 0;
        if (b) {
            if (!((c[1718] | 0) == -1)) {
                c[p >> 2] = 6872;
                c[p + 4 >> 2] = 113;
                c[p + 8 >> 2] = 0;
                qe(6872, p, 114)
            }
            p = (c[6876 >> 2] | 0) + -1 | 0;
            b = c[G + 8 >> 2] | 0;
            if (!((c[G + 12 >> 2] | 0) - b >> 2 >>> 0 > p >>> 0)) {
                H = Ta(4) | 0;
                I = H;
                mm(I);
                Vb(H | 0, 15264, 101)
            }
            e = c[b + (p << 2) >> 2] | 0;
            if ((e | 0) == 0) {
                H = Ta(4) | 0;
                I = H;
                mm(I);
                Vb(H | 0, 15264, 101)
            }
            H = e;
            I = c[e >> 2] | 0;
            if (d) {
                ic[c[I + 44 >> 2] & 63](r, H);
                r = f;
                p = c[q >> 2] | 0;
                a[r] = p;
                a[r + 1 | 0] = p >> 8;
                a[r + 2 | 0] = p >> 16;
                a[r + 3 | 0] = p >> 24;
                ic[c[(c[e >> 2] | 0) + 32 >> 2] & 63](s, H);
                p = l;
                if ((a[p] & 1) == 0) {
                    c[l + 4 >> 2] = 0;
                    a[p] = 0
                } else {
                    c[c[l + 8 >> 2] >> 2] = 0;
                    c[l + 4 >> 2] = 0
                }
                Je(l, 0);
                r = s;
                c[p + 0 >> 2] = c[r + 0 >> 2];
                c[p + 4 >> 2] = c[r + 4 >> 2];
                c[p + 8 >> 2] = c[r + 8 >> 2];
                c[r + 0 >> 2] = 0;
                c[r + 4 >> 2] = 0;
                c[r + 8 >> 2] = 0;
                Ge(s)
            } else {
                ic[c[I + 40 >> 2] & 63](u, H);
                u = f;
                I = c[t >> 2] | 0;
                a[u] = I;
                a[u + 1 | 0] = I >> 8;
                a[u + 2 | 0] = I >> 16;
                a[u + 3 | 0] = I >> 24;
                ic[c[(c[e >> 2] | 0) + 28 >> 2] & 63](v, H);
                I = l;
                if ((a[I] & 1) == 0) {
                    c[l + 4 >> 2] = 0;
                    a[I] = 0
                } else {
                    c[c[l + 8 >> 2] >> 2] = 0;
                    c[l + 4 >> 2] = 0
                }
                Je(l, 0);
                u = v;
                c[I + 0 >> 2] = c[u + 0 >> 2];
                c[I + 4 >> 2] = c[u + 4 >> 2];
                c[I + 8 >> 2] = c[u + 8 >> 2];
                c[u + 0 >> 2] = 0;
                c[u + 4 >> 2] = 0;
                c[u + 8 >> 2] = 0;
                Ge(v)
            }
            v = e;
            c[g >> 2] = kc[c[(c[v >> 2] | 0) + 12 >> 2] & 63](H) | 0;
            c[h >> 2] = kc[c[(c[v >> 2] | 0) + 16 >> 2] & 63](H) | 0;
            ic[c[(c[e >> 2] | 0) + 20 >> 2] & 63](w, H);
            u = j;
            if ((a[u] & 1) == 0) {
                a[j + 1 | 0] = 0;
                a[u] = 0
            } else {
                a[c[j + 8 >> 2] | 0] = 0;
                c[j + 4 >> 2] = 0
            }
            ze(j, 0);
            I = w;
            c[u + 0 >> 2] = c[I + 0 >> 2];
            c[u + 4 >> 2] = c[I + 4 >> 2];
            c[u + 8 >> 2] = c[I + 8 >> 2];
            c[I + 0 >> 2] = 0;
            c[I + 4 >> 2] = 0;
            c[I + 8 >> 2] = 0;
            ve(w);
            ic[c[(c[e >> 2] | 0) + 24 >> 2] & 63](x, H);
            e = k;
            if ((a[e] & 1) == 0) {
                c[k + 4 >> 2] = 0;
                a[e] = 0
            } else {
                c[c[k + 8 >> 2] >> 2] = 0;
                c[k + 4 >> 2] = 0
            }
            Je(k, 0);
            w = x;
            c[e + 0 >> 2] = c[w + 0 >> 2];
            c[e + 4 >> 2] = c[w + 4 >> 2];
            c[e + 8 >> 2] = c[w + 8 >> 2];
            c[w + 0 >> 2] = 0;
            c[w + 4 >> 2] = 0;
            c[w + 8 >> 2] = 0;
            Ge(x);
            J = kc[c[(c[v >> 2] | 0) + 36 >> 2] & 63](H) | 0;
            c[m >> 2] = J;
            i = n;
            return
        } else {
            if (!((c[1702] | 0) == -1)) {
                c[o >> 2] = 6808;
                c[o + 4 >> 2] = 113;
                c[o + 8 >> 2] = 0;
                qe(6808, o, 114)
            }
            o = (c[6812 >> 2] | 0) + -1 | 0;
            H = c[G + 8 >> 2] | 0;
            if (!((c[G + 12 >> 2] | 0) - H >> 2 >>> 0 > o >>> 0)) {
                K = Ta(4) | 0;
                L = K;
                mm(L);
                Vb(K | 0, 15264, 101)
            }
            G = c[H + (o << 2) >> 2] | 0;
            if ((G | 0) == 0) {
                K = Ta(4) | 0;
                L = K;
                mm(L);
                Vb(K | 0, 15264, 101)
            }
            K = G;
            L = c[G >> 2] | 0;
            if (d) {
                ic[c[L + 44 >> 2] & 63](z, K);
                z = f;
                d = c[y >> 2] | 0;
                a[z] = d;
                a[z + 1 | 0] = d >> 8;
                a[z + 2 | 0] = d >> 16;
                a[z + 3 | 0] = d >> 24;
                ic[c[(c[G >> 2] | 0) + 32 >> 2] & 63](A, K);
                d = l;
                if ((a[d] & 1) == 0) {
                    c[l + 4 >> 2] = 0;
                    a[d] = 0
                } else {
                    c[c[l + 8 >> 2] >> 2] = 0;
                    c[l + 4 >> 2] = 0
                }
                Je(l, 0);
                z = A;
                c[d + 0 >> 2] = c[z + 0 >> 2];
                c[d + 4 >> 2] = c[z + 4 >> 2];
                c[d + 8 >> 2] = c[z + 8 >> 2];
                c[z + 0 >> 2] = 0;
                c[z + 4 >> 2] = 0;
                c[z + 8 >> 2] = 0;
                Ge(A)
            } else {
                ic[c[L + 40 >> 2] & 63](C, K);
                C = f;
                f = c[B >> 2] | 0;
                a[C] = f;
                a[C + 1 | 0] = f >> 8;
                a[C + 2 | 0] = f >> 16;
                a[C + 3 | 0] = f >> 24;
                ic[c[(c[G >> 2] | 0) + 28 >> 2] & 63](D, K);
                f = l;
                if ((a[f] & 1) == 0) {
                    c[l + 4 >> 2] = 0;
                    a[f] = 0
                } else {
                    c[c[l + 8 >> 2] >> 2] = 0;
                    c[l + 4 >> 2] = 0
                }
                Je(l, 0);
                l = D;
                c[f + 0 >> 2] = c[l + 0 >> 2];
                c[f + 4 >> 2] = c[l + 4 >> 2];
                c[f + 8 >> 2] = c[l + 8 >> 2];
                c[l + 0 >> 2] = 0;
                c[l + 4 >> 2] = 0;
                c[l + 8 >> 2] = 0;
                Ge(D)
            }
            D = G;
            c[g >> 2] = kc[c[(c[D >> 2] | 0) + 12 >> 2] & 63](K) | 0;
            c[h >> 2] = kc[c[(c[D >> 2] | 0) + 16 >> 2] & 63](K) | 0;
            ic[c[(c[G >> 2] | 0) + 20 >> 2] & 63](E, K);
            h = j;
            if ((a[h] & 1) == 0) {
                a[j + 1 | 0] = 0;
                a[h] = 0
            } else {
                a[c[j + 8 >> 2] | 0] = 0;
                c[j + 4 >> 2] = 0
            }
            ze(j, 0);
            j = E;
            c[h + 0 >> 2] = c[j + 0 >> 2];
            c[h + 4 >> 2] = c[j + 4 >> 2];
            c[h + 8 >> 2] = c[j + 8 >> 2];
            c[j + 0 >> 2] = 0;
            c[j + 4 >> 2] = 0;
            c[j + 8 >> 2] = 0;
            ve(E);
            ic[c[(c[G >> 2] | 0) + 24 >> 2] & 63](F, K);
            G = k;
            if ((a[G] & 1) == 0) {
                c[k + 4 >> 2] = 0;
                a[G] = 0
            } else {
                c[c[k + 8 >> 2] >> 2] = 0;
                c[k + 4 >> 2] = 0
            }
            Je(k, 0);
            k = F;
            c[G + 0 >> 2] = c[k + 0 >> 2];
            c[G + 4 >> 2] = c[k + 4 >> 2];
            c[G + 8 >> 2] = c[k + 8 >> 2];
            c[k + 0 >> 2] = 0;
            c[k + 4 >> 2] = 0;
            c[k + 8 >> 2] = 0;
            Ge(F);
            J = kc[c[(c[D >> 2] | 0) + 36 >> 2] & 63](K) | 0;
            c[m >> 2] = J;
            i = n;
            return
        }
    }

    function Bj(b, d, e, f, g, h, j, k, l, m, n, o, p, q, r) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        k = k | 0;
        l = l | 0;
        m = m | 0;
        n = n | 0;
        o = o | 0;
        p = p | 0;
        q = q | 0;
        r = r | 0;
        var s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0,
            U = 0,
            V = 0,
            W = 0,
            X = 0,
            Y = 0,
            Z = 0,
            _ = 0,
            $ = 0,
            aa = 0,
            ba = 0,
            ca = 0,
            da = 0,
            ea = 0,
            fa = 0,
            ga = 0,
            ha = 0,
            ia = 0,
            ja = 0,
            ka = 0,
            la = 0,
            ma = 0,
            na = 0,
            oa = 0,
            pa = 0,
            qa = 0,
            ra = 0,
            sa = 0,
            ta = 0,
            ua = 0,
            va = 0,
            wa = 0,
            xa = 0,
            ya = 0,
            za = 0;
        s = i;
        c[e >> 2] = b;
        t = j;
        u = q;
        v = q + 4 | 0;
        w = q + 8 | 0;
        q = p;
        x = (f & 512 | 0) == 0;
        y = p + 4 | 0;
        z = p + 8 | 0;
        p = (r | 0) > 0;
        A = o;
        B = o + 1 | 0;
        C = o + 8 | 0;
        D = o + 4 | 0;
        o = j;
        E = g;
        g = 0;
        while (1) {
            a: do {
                switch (a[l + g | 0] | 0) {
                case 1:
                    {
                        c[d >> 2] = c[e >> 2];
                        F = tc[c[(c[t >> 2] | 0) + 44 >> 2] & 15](j, 32) | 0;
                        G = c[e >> 2] | 0;
                        c[e >> 2] = G + 4;
                        c[G >> 2] = F;
                        H = E;
                        break
                    };
                case 4:
                    {
                        F = c[e >> 2] | 0;
                        G = k ? E + 4 | 0 : E;
                        b: do {
                            if (G >>> 0 < h >>> 0) {
                                I = G;
                                while (1) {
                                    J = I + 4 | 0;
                                    if (!(ec[c[(c[o >> 2] | 0) + 12 >> 2] & 31](j, 2048, c[I >> 2] | 0) | 0)) {
                                        K = I;
                                        break b
                                    }
                                    if (J >>> 0 < h >>> 0) {
                                        I = J
                                    } else {
                                        K = J;
                                        break
                                    }
                                }
                            } else {
                                K = G
                            }
                        } while (0);
                        if (p) {
                            do {
                                if (K >>> 0 > G >>> 0) {
                                    I = c[e >> 2] | 0;
                                    J = K;
                                    L = r;
                                    while (1) {
                                        M = J + -4 | 0;
                                        N = I + 4 | 0;
                                        c[I >> 2] = c[M >> 2];
                                        O = L + -1 | 0;
                                        P = (O | 0) > 0;
                                        if (M >>> 0 > G >>> 0 & P) {
                                            L = O;
                                            J = M;
                                            I = N
                                        } else {
                                            break
                                        }
                                    }
                                    c[e >> 2] = N;
                                    if (P) {
                                        Q = M;
                                        R = O;
                                        S = 34;
                                        break
                                    }
                                    I = c[e >> 2] | 0;
                                    c[e >> 2] = I + 4;
                                    T = I;
                                    U = M
                                } else {
                                    Q = K;
                                    R = r;
                                    S = 34
                                }
                            } while (0);
                            do {
                                if ((S | 0) == 34) {
                                    S = 0;
                                    I = tc[c[(c[t >> 2] | 0) + 44 >> 2] & 15](j, 48) | 0;
                                    J = c[e >> 2] | 0;
                                    L = J + 4 | 0;
                                    c[e >> 2] = L;
                                    if ((R | 0) > 0) {
                                        V = L;
                                        W = J;
                                        X = R
                                    } else {
                                        T = J;
                                        U = Q;
                                        break
                                    }
                                    while (1) {
                                        c[W >> 2] = I;
                                        L = X + -1 | 0;
                                        if ((L | 0) > 0) {
                                            X = L;
                                            W = V;
                                            V = V + 4 | 0
                                        } else {
                                            break
                                        }
                                    }
                                    c[e >> 2] = J + (R + 1 << 2);
                                    T = J + (R << 2) | 0;
                                    U = Q
                                }
                            } while (0);
                            c[T >> 2] = m;
                            Y = U
                        } else {
                            Y = K
                        } if ((Y | 0) == (G | 0)) {
                            I = tc[c[(c[t >> 2] | 0) + 44 >> 2] & 15](j, 48) | 0;
                            L = c[e >> 2] | 0;
                            Z = L + 4 | 0;
                            c[e >> 2] = Z;
                            c[L >> 2] = I;
                            _ = Z
                        } else {
                            Z = a[A] | 0;
                            I = (Z & 1) == 0;
                            if (I) {
                                $ = (Z & 255) >>> 1
                            } else {
                                $ = c[D >> 2] | 0
                            } if (($ | 0) == 0) {
                                aa = Y;
                                ba = -1;
                                ca = 0;
                                da = 0
                            } else {
                                if (I) {
                                    ea = B
                                } else {
                                    ea = c[C >> 2] | 0
                                }
                                aa = Y;
                                ba = a[ea] | 0;
                                ca = 0;
                                da = 0
                            }
                            while (1) {
                                I = c[e >> 2] | 0;
                                do {
                                    if ((da | 0) == (ba | 0)) {
                                        Z = I + 4 | 0;
                                        c[e >> 2] = Z;
                                        c[I >> 2] = n;
                                        L = ca + 1 | 0;
                                        fa = a[A] | 0;
                                        ga = (fa & 1) == 0;
                                        if (ga) {
                                            ha = (fa & 255) >>> 1
                                        } else {
                                            ha = c[D >> 2] | 0
                                        } if (!(L >>> 0 < ha >>> 0)) {
                                            ia = Z;
                                            ja = ba;
                                            ka = L;
                                            la = 0;
                                            break
                                        }
                                        if (ga) {
                                            ma = B
                                        } else {
                                            ma = c[C >> 2] | 0
                                        } if ((a[ma + L | 0] | 0) == 127) {
                                            ia = Z;
                                            ja = -1;
                                            ka = L;
                                            la = 0;
                                            break
                                        }
                                        if (ga) {
                                            na = B
                                        } else {
                                            na = c[C >> 2] | 0
                                        }
                                        ia = Z;
                                        ja = a[na + L | 0] | 0;
                                        ka = L;
                                        la = 0
                                    } else {
                                        ia = I;
                                        ja = ba;
                                        ka = ca;
                                        la = da
                                    }
                                } while (0);
                                I = aa + -4 | 0;
                                J = c[I >> 2] | 0;
                                L = ia + 4 | 0;
                                c[e >> 2] = L;
                                c[ia >> 2] = J;
                                if ((I | 0) == (G | 0)) {
                                    _ = L;
                                    break
                                } else {
                                    aa = I;
                                    ba = ja;
                                    ca = ka;
                                    da = la + 1 | 0
                                }
                            }
                        } if ((F | 0) == (_ | 0)) {
                            H = G;
                            break a
                        }
                        I = _ + -4 | 0;
                        if (I >>> 0 > F >>> 0) {
                            oa = F;
                            pa = I
                        } else {
                            H = G;
                            break a
                        }
                        while (1) {
                            I = c[oa >> 2] | 0;
                            c[oa >> 2] = c[pa >> 2];
                            c[pa >> 2] = I;
                            I = oa + 4 | 0;
                            L = pa + -4 | 0;
                            if (I >>> 0 < L >>> 0) {
                                pa = L;
                                oa = I
                            } else {
                                H = G;
                                break
                            }
                        }
                        break
                    };
                case 2:
                    {
                        G = a[q] | 0;
                        F = (G & 1) == 0;
                        if (F) {
                            qa = (G & 255) >>> 1
                        } else {
                            qa = c[y >> 2] | 0
                        } if ((qa | 0) == 0 | x) {
                            H = E;
                            break a
                        }
                        if (F) {
                            ra = y;
                            sa = (G & 255) >>> 1
                        } else {
                            ra = c[z >> 2] | 0;
                            sa = c[y >> 2] | 0
                        }
                        G = ra + (sa << 2) | 0;
                        F = c[e >> 2] | 0;
                        if ((ra | 0) == (G | 0)) {
                            ta = F
                        } else {
                            I = (ra + (sa + -1 << 2) + (0 - ra) | 0) >>> 2;
                            L = F;
                            J = ra;
                            while (1) {
                                c[L >> 2] = c[J >> 2];
                                Z = J + 4 | 0;
                                if ((Z | 0) == (G | 0)) {
                                    break
                                }
                                L = L + 4 | 0;
                                J = Z
                            }
                            ta = F + (I + 1 << 2) | 0
                        }
                        c[e >> 2] = ta;
                        H = E;
                        break
                    };
                case 3:
                    {
                        J = a[u] | 0;
                        L = (J & 1) == 0;
                        if (L) {
                            ua = (J & 255) >>> 1
                        } else {
                            ua = c[v >> 2] | 0
                        } if ((ua | 0) == 0) {
                            H = E;
                            break a
                        }
                        if (L) {
                            va = v
                        } else {
                            va = c[w >> 2] | 0
                        }
                        L = c[va >> 2] | 0;
                        J = c[e >> 2] | 0;
                        c[e >> 2] = J + 4;
                        c[J >> 2] = L;
                        H = E;
                        break
                    };
                case 0:
                    {
                        c[d >> 2] = c[e >> 2];
                        H = E;
                        break
                    };
                default:
                    {
                        H = E
                    }
                }
            } while (0);
            L = g + 1 | 0;
            if ((L | 0) == 4) {
                break
            } else {
                E = H;
                g = L
            }
        }
        g = a[u] | 0;
        u = (g & 1) == 0;
        if (u) {
            wa = (g & 255) >>> 1
        } else {
            wa = c[v >> 2] | 0
        } if (wa >>> 0 > 1) {
            if (u) {
                xa = v;
                ya = (g & 255) >>> 1
            } else {
                xa = c[w >> 2] | 0;
                ya = c[v >> 2] | 0
            }
            v = xa + 4 | 0;
            w = xa + (ya << 2) | 0;
            g = c[e >> 2] | 0;
            if ((v | 0) == (w | 0)) {
                za = g
            } else {
                u = (xa + (ya + -1 << 2) + (0 - v) | 0) >>> 2;
                ya = g;
                xa = v;
                while (1) {
                    c[ya >> 2] = c[xa >> 2];
                    v = xa + 4 | 0;
                    if ((v | 0) == (w | 0)) {
                        break
                    } else {
                        xa = v;
                        ya = ya + 4 | 0
                    }
                }
                za = g + (u + 1 << 2) | 0
            }
            c[e >> 2] = za
        }
        za = f & 176;
        if ((za | 0) == 32) {
            c[d >> 2] = c[e >> 2];
            i = s;
            return
        } else if ((za | 0) == 16) {
            i = s;
            return
        } else {
            c[d >> 2] = b;
            i = s;
            return
        }
    }

    function Cj(b, d, e, f, g, h, j) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        j = j | 0;
        var k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0,
            I = 0,
            J = 0,
            K = 0,
            L = 0,
            M = 0,
            N = 0,
            O = 0,
            P = 0,
            Q = 0,
            R = 0,
            S = 0,
            T = 0;
        d = i;
        i = i + 40 | 0;
        k = d;
        l = d + 8 | 0;
        m = d + 24 | 0;
        n = d + 32 | 0;
        o = n;
        p = i;
        i = i + 8 | 0;
        q = i;
        i = i + 8 | 0;
        r = i;
        i = i + 16 | 0;
        s = i;
        i = i + 16 | 0;
        t = i;
        i = i + 16 | 0;
        u = i;
        i = i + 8 | 0;
        v = i;
        i = i + 400 | 0;
        w = i;
        i = i + 8 | 0;
        x = i;
        i = i + 8 | 0;
        y = i;
        i = i + 8 | 0;
        Pe(m, g);
        z = m;
        A = c[z >> 2] | 0;
        if (!((c[1824] | 0) == -1)) {
            c[l >> 2] = 7296;
            c[l + 4 >> 2] = 113;
            c[l + 8 >> 2] = 0;
            qe(7296, l, 114)
        }
        l = (c[7300 >> 2] | 0) + -1 | 0;
        B = c[A + 8 >> 2] | 0;
        if (!((c[A + 12 >> 2] | 0) - B >> 2 >>> 0 > l >>> 0)) {
            C = Ta(4) | 0;
            D = C;
            mm(D);
            Vb(C | 0, 15264, 101)
        }
        A = c[B + (l << 2) >> 2] | 0;
        if ((A | 0) == 0) {
            C = Ta(4) | 0;
            D = C;
            mm(D);
            Vb(C | 0, 15264, 101)
        }
        C = A;
        D = j;
        l = a[D] | 0;
        B = (l & 1) == 0;
        if (B) {
            E = (l & 255) >>> 1
        } else {
            E = c[j + 4 >> 2] | 0
        } if ((E | 0) == 0) {
            F = 0
        } else {
            if (B) {
                G = j + 4 | 0
            } else {
                G = c[j + 8 >> 2] | 0
            }
            B = c[G >> 2] | 0;
            F = (B | 0) == (tc[c[(c[A >> 2] | 0) + 44 >> 2] & 15](C, 45) | 0)
        }
        c[n >> 2] = 0;
        n = r;
        c[n + 0 >> 2] = 0;
        c[n + 4 >> 2] = 0;
        c[n + 8 >> 2] = 0;
        n = s;
        c[n + 0 >> 2] = 0;
        c[n + 4 >> 2] = 0;
        c[n + 8 >> 2] = 0;
        A = t;
        c[A + 0 >> 2] = 0;
        c[A + 4 >> 2] = 0;
        c[A + 8 >> 2] = 0;
        Aj(f, F, m, o, p, q, r, s, t, u);
        m = v;
        v = a[D] | 0;
        D = (v & 1) == 0;
        if (D) {
            H = (v & 255) >>> 1
        } else {
            H = c[j + 4 >> 2] | 0
        }
        f = c[u >> 2] | 0;
        if ((H | 0) > (f | 0)) {
            if (D) {
                I = (v & 255) >>> 1
            } else {
                I = c[j + 4 >> 2] | 0
            }
            D = a[A] | 0;
            if ((D & 1) == 0) {
                J = (D & 255) >>> 1
            } else {
                J = c[t + 4 >> 2] | 0
            }
            D = a[n] | 0;
            if ((D & 1) == 0) {
                K = (D & 255) >>> 1
            } else {
                K = c[s + 4 >> 2] | 0
            }
            L = J + (I - f << 1 | 1) + K | 0
        } else {
            K = a[A] | 0;
            if ((K & 1) == 0) {
                M = (K & 255) >>> 1
            } else {
                M = c[t + 4 >> 2] | 0
            }
            K = a[n] | 0;
            if ((K & 1) == 0) {
                N = (K & 255) >>> 1
            } else {
                N = c[s + 4 >> 2] | 0
            }
            L = M + 2 + N | 0
        }
        N = L + f | 0;
        do {
            if (N >>> 0 > 100) {
                L = Hm(N << 2) | 0;
                M = L;
                if ((L | 0) != 0) {
                    O = M;
                    P = M;
                    break
                }
                Tm()
            } else {
                O = 0;
                P = m
            }
        } while (0);
        if ((v & 1) == 0) {
            Q = j + 4 | 0;
            R = (v & 255) >>> 1
        } else {
            Q = c[j + 8 >> 2] | 0;
            R = c[j + 4 >> 2] | 0
        }
        Bj(P, w, x, c[g + 4 >> 2] | 0, Q, Q + (R << 2) | 0, C, F, o, c[p >> 2] | 0, c[q >> 2] | 0, r, s, t, f);
        c[y >> 2] = c[e >> 2];
        e = c[w >> 2] | 0;
        w = c[x >> 2] | 0;
        x = k;
        f = y;
        c[x + 0 >> 2] = c[f + 0 >> 2];
        xh(b, k, P, e, w, g, h);
        if ((O | 0) == 0) {
            Ge(t);
            Ge(s);
            ve(r);
            S = c[z >> 2] | 0;
            T = S;
            Yd(T) | 0;
            i = d;
            return
        }
        Im(O);
        Ge(t);
        Ge(s);
        ve(r);
        S = c[z >> 2] | 0;
        T = S;
        Yd(T) | 0;
        i = d;
        return
    }

    function Dj(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Om(a);
        i = b;
        return
    }

    function Ej(a) {
        a = a | 0;
        i = i;
        return
    }

    function Fj(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0;
        e = i;
        if ((a[d] & 1) == 0) {
            f = d + 1 | 0
        } else {
            f = c[d + 8 >> 2] | 0
        }
        d = _b(f | 0, 1) | 0;
        i = e;
        return d >>> ((d | 0) != (-1 | 0) | 0) | 0
    }

    function Gj(b, d, e, f, g, h) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        var j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0;
        d = i;
        i = i + 16 | 0;
        j = d;
        k = j;
        c[k + 0 >> 2] = 0;
        c[k + 4 >> 2] = 0;
        c[k + 8 >> 2] = 0;
        l = a[h] | 0;
        if ((l & 1) == 0) {
            m = h + 1 | 0;
            n = h + 1 | 0;
            o = (l & 255) >>> 1
        } else {
            l = c[h + 8 >> 2] | 0;
            m = l;
            n = l;
            o = c[h + 4 >> 2] | 0
        }
        h = m + o | 0;
        do {
            if (n >>> 0 < h >>> 0) {
                o = n;
                do {
                    Ae(j, a[o] | 0);
                    o = o + 1 | 0;
                } while ((o | 0) != (h | 0));
                o = (e | 0) == -1 ? -1 : e << 1;
                if ((a[k] & 1) == 0) {
                    p = o;
                    q = 9;
                    break
                }
                r = o;
                s = c[j + 8 >> 2] | 0
            } else {
                p = (e | 0) == -1 ? -1 : e << 1;
                q = 9
            }
        } while (0);
        if ((q | 0) == 9) {
            r = p;
            s = j + 1 | 0
        }
        p = gb(r | 0, f | 0, g | 0, s | 0) | 0;
        s = b;
        c[s + 0 >> 2] = 0;
        c[s + 4 >> 2] = 0;
        c[s + 8 >> 2] = 0;
        s = hn(p | 0) | 0;
        g = p + s | 0;
        if ((s | 0) > 0) {
            t = p
        } else {
            ve(j);
            i = d;
            return
        }
        do {
            Ae(b, a[t] | 0);
            t = t + 1 | 0;
        } while ((t | 0) != (g | 0));
        ve(j);
        i = d;
        return
    }

    function Hj(a, b) {
        a = a | 0;
        b = b | 0;
        a = i;
        Tb(((b | 0) == -1 ? -1 : b << 1) | 0) | 0;
        i = a;
        return
    }

    function Ij(a) {
        a = a | 0;
        var b = 0;
        b = i;
        Om(a);
        i = b;
        return
    }

    function Jj(a) {
        a = a | 0;
        i = i;
        return
    }

    function Kj(b, d, e) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        var f = 0;
        e = i;
        if ((a[d] & 1) == 0) {
            f = d + 1 | 0
        } else {
            f = c[d + 8 >> 2] | 0
        }
        d = _b(f | 0, 1) | 0;
        i = e;
        return d >>> ((d | 0) != (-1 | 0) | 0) | 0
    }

    function Lj(b, d, e, f, g, h) {
        b = b | 0;
        d = d | 0;
        e = e | 0;
        f = f | 0;
        g = g | 0;
        h = h | 0;
        var j = 0,
            k = 0,
            l = 0,
            m = 0,
            n = 0,
            o = 0,
            p = 0,
            q = 0,
            r = 0,
            s = 0,
            t = 0,
            u = 0,
            v = 0,
            w = 0,
            x = 0,
            y = 0,
            z = 0,
            A = 0,
            B = 0,
            C = 0,
            D = 0,
            E = 0,
            F = 0,
            G = 0,
            H = 0;
        d = i;
        i = i + 240 | 0;
        j = d;
        k = d + 8 | 0;
        l = d + 40 | 0;
        m = d + 48 | 0;
        n = d + 56 | 0;
        o = d + 64 | 0;
        p = d + 192 | 0;
        q = d + 200 | 0;
        r = d + 208 | 0;
        s = d + 224 | 0;
        t = d + 232 | 0;
        u = r;
        c[u + 0 >> 2] = 0;
        c[u + 4 >> 2] = 0;
        c[u + 8 >> 2] = 0;
        c[s + 4 >> 2] = 0;
        c[s >> 2] = 8960;
        v = a[h] | 0;
        if ((v & 1) == 0) {
            w = h + 4 | 0;
            x = h + 4 | 0;
            y = (v & 255) >>> 1
        } else {
            v = c[h + 8 >> 2] | 0;
            w = v;
            x = v;
            y = c[h + 4 >> 2] | 0
        }
        h = w + (y << 2) | 0;
        y = k;
        w = j;
        v = j;
        c[v >> 2] = 0;
        c[v + 4 >> 2] = 0;
        a: do {
            if (x >>> 0 < h >>> 0) {
                v = s;
                j = s;
                z = k + 32 | 0;
                A = x;
                B = 8960 | 0;
                while (1) {
                    c[m >> 2] = A;
                    C = (pc[c[B + 12 >> 2] & 15](v, w, A, h, m, y, z, l) | 0) == 2;
                    D = c[m >> 2] | 0;
                    if (C | (D | 0) == (A | 0)) {
                        break
                    }
                    if (y >>> 0 < (c[l >> 2] | 0) >>> 0) {
                        C = y;
                        do {
                            Ae(r, a[C] | 0);
                            C = C + 1 | 0;
                        } while (C >>> 0 < (c[l >> 2] | 0) >>> 0);
                        E = c[m >> 2] | 0
                    } else {
                        E = D
                    } if (!(E >>> 0 < h >>> 0)) {
                        break a
                    }
                    A = E;
                    B = c[j >> 2] | 0
                }
                fj(8184)
            }
        } while (0);
        if ((a[u] & 1) == 0) {
            F = r + 1 | 0
        } else {
            F = c[r + 8 >> 2] | 0
        }
        u = gb(((e | 0) == -1 ? -1 : e << 1) | 0, f | 0, g | 0, F | 0) | 0;
        F = b;
        c[F + 0 >> 2] = 0;
        c[F + 4 >> 2] = 0;
        c[F + 8 >> 2] = 0;
        c[t + 4 >> 2] = 0;
        c[t >> 2] = 9064;
        F = hn(u | 0) | 0;
        g = u + F | 0;
        f = n;
        e = n;
        c[e >> 2] = 0;
        c[e + 4 >> 2] = 0;
        if ((F | 0) <= 0) {
            ve(r);
            i = d;
            return
        }
        F = t;
        e = t;
        t = g;
        n = o;
        E = o + 128 | 0;
        o = u;
        u = 9064 | 0;
        while (1) {
            c[q >> 2] = o;
            h = (pc[c[u + 16 >> 2] & 15](F, f, o, (t - o | 0) > 32 ? o + 32 | 0 : g, q, n, E, p) | 0) == 2;
            m = c[q >> 2] | 0;
            if (h | (m | 0) == (o | 0)) {
                G = 20;
                break
            }
            if (n >>> 0 < (c[p >> 2] | 0) >>> 0) {
                h = n;
                do {
                    Ke(b, c[h >> 2] | 0);
                    h = h + 4 | 0;
                } while (h >>> 0 < (c[p >> 2] | 0) >>> 0);
                H = c[q >> 2] | 0
            } else {
                H = m
            } if (!(H >>> 0 < g >>> 0)) {
                G = 25;
                break
            }
            o = H;
            u = c[e >> 2] 