// Copyright 2021 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `RGI_Emoji_ZWJ_Sequence` (property of strings)
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v14.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes, regexp-v-flag]
includes: [regExpUtils.js]
---*/

testPropertyOfStrings({
  regExp: /^\p{RGI_Emoji_ZWJ_Sequence}+$/v,
  expression: "\\p{RGI_Emoji_ZWJ_Sequence}",
  matchStrings: [
    "\u{1F468}\u200D\u2764\uFE0F\u200D\u{1F468}",
    "\u{1F468}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}",
    "\u{1F468}\u200D\u{1F466}",
    "\u{1F468}\u200D\u{1F466}\u200D\u{1F466}",
    "\u{1F468}\u200D\u{1F467}",
    "\u{1F468}\u200D\u{1F467}\u200D\u{1F466}",
    "\u{1F468}\u200D\u{1F467}\u200D\u{1F467}",
    "\u{1F468}\u200D\u{1F468}\u200D\u{1F466}",
    "\u{1F468}\u200D\u{1F468}\u200D\u{1F466}\u200D\u{1F466}",
    "\u{1F468}\u200D\u{1F468}\u200D\u{1F467}",
    "\u{1F468}\u200D\u{1F468}\u200D\u{1F467}\u200D\u{1F466}",
    "\u{1F468}\u200D\u{1F468}\u200D\u{1F467}\u200D\u{1F467}",
    "\u{1F468}\u200D\u{1F469}\u200D\u{1F466}",
    "\u{1F468}\u200D\u{1F469}\u200D\u{1F466}\u200D\u{1F466}",
    "\u{1F468}\u200D\u{1F469}\u200D\u{1F467}",
    "\u{1F468}\u200D\u{1F469}\u200D\u{1F467}\u200D\u{1F466}",
    "\u{1F468}\u200D\u{1F469}\u200D\u{1F467}\u200D\u{1F467}",
    "\u{1F468}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FB}",
    "\u{1F468}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FC}",
    "\u{1F468}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FD}",
    "\u{1F468}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FE}",
    "\u{1F468}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FF}",
    "\u{1F468}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F468}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F468}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F468}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F468}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F468}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FB}",
    "\u{1F468}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FC}",
    "\u{1F468}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FD}",
    "\u{1F468}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FE}",
    "\u{1F468}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FF}",
    "\u{1F468}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F468}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F468}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F468}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F468}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F468}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FB}",
    "\u{1F468}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FC}",
    "\u{1F468}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FD}",
    "\u{1F468}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FE}",
    "\u{1F468}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FF}",
    "\u{1F468}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F468}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F468}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F468}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F468}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F468}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FB}",
    "\u{1F468}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FC}",
    "\u{1F468}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FD}",
    "\u{1F468}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FE}",
    "\u{1F468}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FF}",
    "\u{1F468}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F468}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F468}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F468}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F468}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F468}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FB}",
    "\u{1F468}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FC}",
    "\u{1F468}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FD}",
    "\u{1F468}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FE}",
    "\u{1F468}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FF}",
    "\u{1F468}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F468}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F468}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F468}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F468}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F469}\u200D\u2764\uFE0F\u200D\u{1F468}",
    "\u{1F469}\u200D\u2764\uFE0F\u200D\u{1F469}",
    "\u{1F469}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}",
    "\u{1F469}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}",
    "\u{1F469}\u200D\u{1F466}",
    "\u{1F469}\u200D\u{1F466}\u200D\u{1F466}",
    "\u{1F469}\u200D\u{1F467}",
    "\u{1F469}\u200D\u{1F467}\u200D\u{1F466}",
    "\u{1F469}\u200D\u{1F467}\u200D\u{1F467}",
    "\u{1F469}\u200D\u{1F469}\u200D\u{1F466}",
    "\u{1F469}\u200D\u{1F469}\u200D\u{1F466}\u200D\u{1F466}",
    "\u{1F469}\u200D\u{1F469}\u200D\u{1F467}",
    "\u{1F469}\u200D\u{1F469}\u200D\u{1F467}\u200D\u{1F466}",
    "\u{1F469}\u200D\u{1F469}\u200D\u{1F467}\u200D\u{1F467}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FB}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FC}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FD}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FE}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FF}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FB}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FC}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FD}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FE}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FF}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FB}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FC}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FD}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FE}",
    "\u{1F469}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FF}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FC}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FD}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FE}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FF}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FB}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FC}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FD}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FE}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FF}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FB}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FC}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FD}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FE}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FF}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FB}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FC}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FD}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FE}",
    "\u{1F469}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FF}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FB}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FD}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FE}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FF}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FB}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FC}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FD}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FE}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FF}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FB}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FC}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FD}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FE}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FF}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FB}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FC}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FD}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FE}",
    "\u{1F469}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FF}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FB}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FC}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FE}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FF}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FB}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FC}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FD}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FE}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FF}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FB}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FC}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FD}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FE}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FF}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FB}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FC}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FD}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FE}",
    "\u{1F469}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FF}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FB}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FC}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FD}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FF}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FB}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FC}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FD}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FE}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F468}\u{1F3FF}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FB}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FC}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FD}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FE}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F469}\u{1F3FF}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FB}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FC}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FD}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FE}",
    "\u{1F469}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F469}\u{1F3FF}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F91D}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FB}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FC}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FD}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F91D}\u200D\u{1F469}\u{1F3FE}",
    "\u{1F9D1}\u200D\u{1F91D}\u200D\u{1F9D1}",
    "\u{1F9D1}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FC}",
    "\u{1F9D1}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FD}",
    "\u{1F9D1}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FE}",
    "\u{1F9D1}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FF}",
    "\u{1F9D1}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FC}",
    "\u{1F9D1}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FD}",
    "\u{1F9D1}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FE}",
    "\u{1F9D1}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FF}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F384}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FB}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FC}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FD}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FE}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FF}",
    "\u{1F9D1}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FB}",
    "\u{1F9D1}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FD}",
    "\u{1F9D1}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FE}",
    "\u{1F9D1}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FF}",
    "\u{1F9D1}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FB}",
    "\u{1F9D1}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FD}",
    "\u{1F9D1}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FE}",
    "\u{1F9D1}\u{1F3FC}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FF}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F384}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FB}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FC}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FD}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FE}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FF}",
    "\u{1F9D1}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FB}",
    "\u{1F9D1}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FC}",
    "\u{1F9D1}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FE}",
    "\u{1F9D1}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FF}",
    "\u{1F9D1}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FB}",
    "\u{1F9D1}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FC}",
    "\u{1F9D1}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FE}",
    "\u{1F9D1}\u{1F3FD}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FF}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F384}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FB}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FC}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FD}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FE}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FF}",
    "\u{1F9D1}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FB}",
    "\u{1F9D1}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FC}",
    "\u{1F9D1}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FD}",
    "\u{1F9D1}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FF}",
    "\u{1F9D1}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FB}",
    "\u{1F9D1}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FC}",
    "\u{1F9D1}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FD}",
    "\u{1F9D1}\u{1F3FE}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FF}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F384}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FB}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FC}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FD}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FE}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FF}",
    "\u{1F9D1}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FB}",
    "\u{1F9D1}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FC}",
    "\u{1F9D1}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FD}",
    "\u{1F9D1}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F9D1}\u{1F3FE}",
    "\u{1F9D1}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FB}",
    "\u{1F9D1}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FC}",
    "\u{1F9D1}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FD}",
    "\u{1F9D1}\u{1F3FF}\u200D\u2764\uFE0F\u200D\u{1F9D1}\u{1F3FE}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F384}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FB}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FC}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FD}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FE}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F91D}\u200D\u{1F9D1}\u{1F3FF}",
    "\u{1FAF1}\u{1F3FB}\u200D\u{1FAF2}\u{1F3FC}",
    "\u{1FAF1}\u{1F3FB}\u200D\u{1FAF2}\u{1F3FD}",
    "\u{1FAF1}\u{1F3FB}\u200D\u{1FAF2}\u{1F3FE}",
    "\u{1FAF1}\u{1F3FB}\u200D\u{1FAF2}\u{1F3FF}",
    "\u{1FAF1}\u{1F3FC}\u200D\u{1FAF2}\u{1F3FB}",
    "\u{1FAF1}\u{1F3FC}\u200D\u{1FAF2}\u{1F3FD}",
    "\u{1FAF1}\u{1F3FC}\u200D\u{1FAF2}\u{1F3FE}",
    "\u{1FAF1}\u{1F3FC}\u200D\u{1FAF2}\u{1F3FF}",
    "\u{1FAF1}\u{1F3FD}\u200D\u{1FAF2}\u{1F3FB}",
    "\u{1FAF1}\u{1F3FD}\u200D\u{1FAF2}\u{1F3FC}",
    "\u{1FAF1}\u{1F3FD}\u200D\u{1FAF2}\u{1F3FE}",
    "\u{1FAF1}\u{1F3FD}\u200D\u{1FAF2}\u{1F3FF}",
    "\u{1FAF1}\u{1F3FE}\u200D\u{1FAF2}\u{1F3FB}",
    "\u{1FAF1}\u{1F3FE}\u200D\u{1FAF2}\u{1F3FC}",
    "\u{1FAF1}\u{1F3FE}\u200D\u{1FAF2}\u{1F3FD}",
    "\u{1FAF1}\u{1F3FE}\u200D\u{1FAF2}\u{1F3FF}",
    "\u{1FAF1}\u{1F3FF}\u200D\u{1FAF2}\u{1F3FB}",
    "\u{1FAF1}\u{1F3FF}\u200D\u{1FAF2}\u{1F3FC}",
    "\u{1FAF1}\u{1F3FF}\u200D\u{1FAF2}\u{1F3FD}",
    "\u{1FAF1}\u{1F3FF}\u200D\u{1FAF2}\u{1F3FE}",
    "\u{1F468}\u200D\u2695\uFE0F",
    "\u{1F468}\u200D\u2696\uFE0F",
    "\u{1F468}\u200D\u2708\uFE0F",
    "\u{1F468}\u200D\u{1F33E}",
    "\u{1F468}\u200D\u{1F373}",
    "\u{1F468}\u200D\u{1F37C}",
    "\u{1F468}\u200D\u{1F393}",
    "\u{1F468}\u200D\u{1F3A4}",
    "\u{1F468}\u200D\u{1F3A8}",
    "\u{1F468}\u200D\u{1F3EB}",
    "\u{1F468}\u200D\u{1F3ED}",
    "\u{1F468}\u200D\u{1F4BB}",
    "\u{1F468}\u200D\u{1F4BC}",
    "\u{1F468}\u200D\u{1F527}",
    "\u{1F468}\u200D\u{1F52C}",
    "\u{1F468}\u200D\u{1F680}",
    "\u{1F468}\u200D\u{1F692}",
    "\u{1F468}\u200D\u{1F9AF}",
    "\u{1F468}\u200D\u{1F9BC}",
    "\u{1F468}\u200D\u{1F9BD}",
    "\u{1F468}\u{1F3FB}\u200D\u2695\uFE0F",
    "\u{1F468}\u{1F3FB}\u200D\u2696\uFE0F",
    "\u{1F468}\u{1F3FB}\u200D\u2708\uFE0F",
    "\u{1F468}\u{1F3FB}\u200D\u{1F33E}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F373}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F37C}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F393}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F3A4}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F3A8}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F3EB}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F3ED}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F4BB}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F4BC}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F527}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F52C}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F680}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F692}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F9AF}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F9BC}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F9BD}",
    "\u{1F468}\u{1F3FC}\u200D\u2695\uFE0F",
    "\u{1F468}\u{1F3FC}\u200D\u2696\uFE0F",
    "\u{1F468}\u{1F3FC}\u200D\u2708\uFE0F",
    "\u{1F468}\u{1F3FC}\u200D\u{1F33E}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F373}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F37C}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F393}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F3A4}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F3A8}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F3EB}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F3ED}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F4BB}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F4BC}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F527}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F52C}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F680}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F692}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F9AF}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F9BC}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F9BD}",
    "\u{1F468}\u{1F3FD}\u200D\u2695\uFE0F",
    "\u{1F468}\u{1F3FD}\u200D\u2696\uFE0F",
    "\u{1F468}\u{1F3FD}\u200D\u2708\uFE0F",
    "\u{1F468}\u{1F3FD}\u200D\u{1F33E}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F373}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F37C}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F393}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F3A4}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F3A8}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F3EB}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F3ED}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F4BB}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F4BC}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F527}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F52C}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F680}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F692}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F9AF}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F9BC}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F9BD}",
    "\u{1F468}\u{1F3FE}\u200D\u2695\uFE0F",
    "\u{1F468}\u{1F3FE}\u200D\u2696\uFE0F",
    "\u{1F468}\u{1F3FE}\u200D\u2708\uFE0F",
    "\u{1F468}\u{1F3FE}\u200D\u{1F33E}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F373}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F37C}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F393}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F3A4}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F3A8}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F3EB}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F3ED}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F4BB}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F4BC}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F527}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F52C}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F680}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F692}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F9AF}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F9BC}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F9BD}",
    "\u{1F468}\u{1F3FF}\u200D\u2695\uFE0F",
    "\u{1F468}\u{1F3FF}\u200D\u2696\uFE0F",
    "\u{1F468}\u{1F3FF}\u200D\u2708\uFE0F",
    "\u{1F468}\u{1F3FF}\u200D\u{1F33E}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F373}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F37C}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F393}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F3A4}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F3A8}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F3EB}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F3ED}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F4BB}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F4BC}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F527}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F52C}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F680}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F692}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F9AF}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F9BC}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F9BD}",
    "\u{1F469}\u200D\u2695\uFE0F",
    "\u{1F469}\u200D\u2696\uFE0F",
    "\u{1F469}\u200D\u2708\uFE0F",
    "\u{1F469}\u200D\u{1F33E}",
    "\u{1F469}\u200D\u{1F373}",
    "\u{1F469}\u200D\u{1F37C}",
    "\u{1F469}\u200D\u{1F393}",
    "\u{1F469}\u200D\u{1F3A4}",
    "\u{1F469}\u200D\u{1F3A8}",
    "\u{1F469}\u200D\u{1F3EB}",
    "\u{1F469}\u200D\u{1F3ED}",
    "\u{1F469}\u200D\u{1F4BB}",
    "\u{1F469}\u200D\u{1F4BC}",
    "\u{1F469}\u200D\u{1F527}",
    "\u{1F469}\u200D\u{1F52C}",
    "\u{1F469}\u200D\u{1F680}",
    "\u{1F469}\u200D\u{1F692}",
    "\u{1F469}\u200D\u{1F9AF}",
    "\u{1F469}\u200D\u{1F9BC}",
    "\u{1F469}\u200D\u{1F9BD}",
    "\u{1F469}\u{1F3FB}\u200D\u2695\uFE0F",
    "\u{1F469}\u{1F3FB}\u200D\u2696\uFE0F",
    "\u{1F469}\u{1F3FB}\u200D\u2708\uFE0F",
    "\u{1F469}\u{1F3FB}\u200D\u{1F33E}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F373}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F37C}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F393}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F3A4}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F3A8}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F3EB}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F3ED}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F4BB}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F4BC}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F527}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F52C}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F680}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F692}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F9AF}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F9BC}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F9BD}",
    "\u{1F469}\u{1F3FC}\u200D\u2695\uFE0F",
    "\u{1F469}\u{1F3FC}\u200D\u2696\uFE0F",
    "\u{1F469}\u{1F3FC}\u200D\u2708\uFE0F",
    "\u{1F469}\u{1F3FC}\u200D\u{1F33E}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F373}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F37C}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F393}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F3A4}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F3A8}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F3EB}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F3ED}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F4BB}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F4BC}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F527}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F52C}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F680}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F692}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F9AF}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F9BC}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F9BD}",
    "\u{1F469}\u{1F3FD}\u200D\u2695\uFE0F",
    "\u{1F469}\u{1F3FD}\u200D\u2696\uFE0F",
    "\u{1F469}\u{1F3FD}\u200D\u2708\uFE0F",
    "\u{1F469}\u{1F3FD}\u200D\u{1F33E}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F373}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F37C}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F393}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F3A4}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F3A8}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F3EB}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F3ED}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F4BB}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F4BC}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F527}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F52C}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F680}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F692}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F9AF}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F9BC}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F9BD}",
    "\u{1F469}\u{1F3FE}\u200D\u2695\uFE0F",
    "\u{1F469}\u{1F3FE}\u200D\u2696\uFE0F",
    "\u{1F469}\u{1F3FE}\u200D\u2708\uFE0F",
    "\u{1F469}\u{1F3FE}\u200D\u{1F33E}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F373}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F37C}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F393}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F3A4}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F3A8}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F3EB}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F3ED}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F4BB}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F4BC}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F527}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F52C}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F680}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F692}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F9AF}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F9BC}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F9BD}",
    "\u{1F469}\u{1F3FF}\u200D\u2695\uFE0F",
    "\u{1F469}\u{1F3FF}\u200D\u2696\uFE0F",
    "\u{1F469}\u{1F3FF}\u200D\u2708\uFE0F",
    "\u{1F469}\u{1F3FF}\u200D\u{1F33E}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F373}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F37C}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F393}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F3A4}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F3A8}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F3EB}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F3ED}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F4BB}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F4BC}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F527}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F52C}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F680}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F692}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F9AF}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F9BC}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F9BD}",
    "\u{1F9D1}\u200D\u2695\uFE0F",
    "\u{1F9D1}\u200D\u2696\uFE0F",
    "\u{1F9D1}\u200D\u2708\uFE0F",
    "\u{1F9D1}\u200D\u{1F33E}",
    "\u{1F9D1}\u200D\u{1F373}",
    "\u{1F9D1}\u200D\u{1F37C}",
    "\u{1F9D1}\u200D\u{1F393}",
    "\u{1F9D1}\u200D\u{1F3A4}",
    "\u{1F9D1}\u200D\u{1F3A8}",
    "\u{1F9D1}\u200D\u{1F3EB}",
    "\u{1F9D1}\u200D\u{1F3ED}",
    "\u{1F9D1}\u200D\u{1F4BB}",
    "\u{1F9D1}\u200D\u{1F4BC}",
    "\u{1F9D1}\u200D\u{1F527}",
    "\u{1F9D1}\u200D\u{1F52C}",
    "\u{1F9D1}\u200D\u{1F680}",
    "\u{1F9D1}\u200D\u{1F692}",
    "\u{1F9D1}\u200D\u{1F9AF}",
    "\u{1F9D1}\u200D\u{1F9BC}",
    "\u{1F9D1}\u200D\u{1F9BD}",
    "\u{1F9D1}\u{1F3FB}\u200D\u2695\uFE0F",
    "\u{1F9D1}\u{1F3FB}\u200D\u2696\uFE0F",
    "\u{1F9D1}\u{1F3FB}\u200D\u2708\uFE0F",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F33E}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F373}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F37C}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F393}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F3A4}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F3A8}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F3EB}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F3ED}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F4BB}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F4BC}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F527}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F52C}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F680}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F692}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F9AF}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F9BC}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F9BD}",
    "\u{1F9D1}\u{1F3FC}\u200D\u2695\uFE0F",
    "\u{1F9D1}\u{1F3FC}\u200D\u2696\uFE0F",
    "\u{1F9D1}\u{1F3FC}\u200D\u2708\uFE0F",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F33E}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F373}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F37C}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F393}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F3A4}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F3A8}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F3EB}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F3ED}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F4BB}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F4BC}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F527}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F52C}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F680}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F692}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F9AF}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F9BC}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F9BD}",
    "\u{1F9D1}\u{1F3FD}\u200D\u2695\uFE0F",
    "\u{1F9D1}\u{1F3FD}\u200D\u2696\uFE0F",
    "\u{1F9D1}\u{1F3FD}\u200D\u2708\uFE0F",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F33E}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F373}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F37C}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F393}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F3A4}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F3A8}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F3EB}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F3ED}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F4BB}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F4BC}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F527}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F52C}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F680}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F692}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F9AF}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F9BC}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F9BD}",
    "\u{1F9D1}\u{1F3FE}\u200D\u2695\uFE0F",
    "\u{1F9D1}\u{1F3FE}\u200D\u2696\uFE0F",
    "\u{1F9D1}\u{1F3FE}\u200D\u2708\uFE0F",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F33E}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F373}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F37C}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F393}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F3A4}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F3A8}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F3EB}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F3ED}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F4BB}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F4BC}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F527}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F52C}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F680}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F692}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F9AF}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F9BC}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F9BD}",
    "\u{1F9D1}\u{1F3FF}\u200D\u2695\uFE0F",
    "\u{1F9D1}\u{1F3FF}\u200D\u2696\uFE0F",
    "\u{1F9D1}\u{1F3FF}\u200D\u2708\uFE0F",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F33E}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F373}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F37C}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F393}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F3A4}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F3A8}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F3EB}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F3ED}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F4BB}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F4BC}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F527}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F52C}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F680}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F692}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F9AF}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F9BC}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F9BD}",
    "\u26F9\u{1F3FB}\u200D\u2640\uFE0F",
    "\u26F9\u{1F3FB}\u200D\u2642\uFE0F",
    "\u26F9\u{1F3FC}\u200D\u2640\uFE0F",
    "\u26F9\u{1F3FC}\u200D\u2642\uFE0F",
    "\u26F9\u{1F3FD}\u200D\u2640\uFE0F",
    "\u26F9\u{1F3FD}\u200D\u2642\uFE0F",
    "\u26F9\u{1F3FE}\u200D\u2640\uFE0F",
    "\u26F9\u{1F3FE}\u200D\u2642\uFE0F",
    "\u26F9\u{1F3FF}\u200D\u2640\uFE0F",
    "\u26F9\u{1F3FF}\u200D\u2642\uFE0F",
    "\u26F9\uFE0F\u200D\u2640\uFE0F",
    "\u26F9\uFE0F\u200D\u2642\uFE0F",
    "\u{1F3C3}\u200D\u2640\uFE0F",
    "\u{1F3C3}\u200D\u2642\uFE0F",
    "\u{1F3C3}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F3C3}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F3C3}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F3C3}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F3C3}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F3C3}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F3C3}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F3C3}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F3C3}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F3C3}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F3C4}\u200D\u2640\uFE0F",
    "\u{1F3C4}\u200D\u2642\uFE0F",
    "\u{1F3C4}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F3C4}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F3C4}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F3C4}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F3C4}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F3C4}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F3C4}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F3C4}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F3C4}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F3C4}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F3CA}\u200D\u2640\uFE0F",
    "\u{1F3CA}\u200D\u2642\uFE0F",
    "\u{1F3CA}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F3CA}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F3CA}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F3CA}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F3CA}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F3CA}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F3CA}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F3CA}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F3CA}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F3CA}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F3CB}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F3CB}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F3CB}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F3CB}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F3CB}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F3CB}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F3CB}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F3CB}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F3CB}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F3CB}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F3CB}\uFE0F\u200D\u2640\uFE0F",
    "\u{1F3CB}\uFE0F\u200D\u2642\uFE0F",
    "\u{1F3CC}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F3CC}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F3CC}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F3CC}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F3CC}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F3CC}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F3CC}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F3CC}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F3CC}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F3CC}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F3CC}\uFE0F\u200D\u2640\uFE0F",
    "\u{1F3CC}\uFE0F\u200D\u2642\uFE0F",
    "\u{1F46E}\u200D\u2640\uFE0F",
    "\u{1F46E}\u200D\u2642\uFE0F",
    "\u{1F46E}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F46E}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F46E}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F46E}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F46E}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F46E}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F46E}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F46E}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F46E}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F46E}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F46F}\u200D\u2640\uFE0F",
    "\u{1F46F}\u200D\u2642\uFE0F",
    "\u{1F470}\u200D\u2640\uFE0F",
    "\u{1F470}\u200D\u2642\uFE0F",
    "\u{1F470}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F470}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F470}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F470}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F470}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F470}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F470}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F470}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F470}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F470}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F471}\u200D\u2640\uFE0F",
    "\u{1F471}\u200D\u2642\uFE0F",
    "\u{1F471}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F471}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F471}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F471}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F471}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F471}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F471}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F471}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F471}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F471}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F473}\u200D\u2640\uFE0F",
    "\u{1F473}\u200D\u2642\uFE0F",
    "\u{1F473}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F473}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F473}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F473}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F473}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F473}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F473}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F473}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F473}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F473}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F477}\u200D\u2640\uFE0F",
    "\u{1F477}\u200D\u2642\uFE0F",
    "\u{1F477}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F477}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F477}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F477}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F477}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F477}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F477}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F477}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F477}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F477}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F481}\u200D\u2640\uFE0F",
    "\u{1F481}\u200D\u2642\uFE0F",
    "\u{1F481}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F481}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F481}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F481}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F481}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F481}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F481}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F481}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F481}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F481}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F482}\u200D\u2640\uFE0F",
    "\u{1F482}\u200D\u2642\uFE0F",
    "\u{1F482}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F482}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F482}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F482}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F482}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F482}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F482}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F482}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F482}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F482}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F486}\u200D\u2640\uFE0F",
    "\u{1F486}\u200D\u2642\uFE0F",
    "\u{1F486}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F486}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F486}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F486}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F486}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F486}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F486}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F486}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F486}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F486}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F487}\u200D\u2640\uFE0F",
    "\u{1F487}\u200D\u2642\uFE0F",
    "\u{1F487}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F487}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F487}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F487}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F487}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F487}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F487}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F487}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F487}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F487}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F575}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F575}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F575}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F575}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F575}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F575}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F575}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F575}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F575}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F575}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F575}\uFE0F\u200D\u2640\uFE0F",
    "\u{1F575}\uFE0F\u200D\u2642\uFE0F",
    "\u{1F645}\u200D\u2640\uFE0F",
    "\u{1F645}\u200D\u2642\uFE0F",
    "\u{1F645}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F645}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F645}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F645}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F645}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F645}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F645}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F645}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F645}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F645}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F646}\u200D\u2640\uFE0F",
    "\u{1F646}\u200D\u2642\uFE0F",
    "\u{1F646}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F646}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F646}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F646}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F646}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F646}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F646}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F646}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F646}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F646}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F647}\u200D\u2640\uFE0F",
    "\u{1F647}\u200D\u2642\uFE0F",
    "\u{1F647}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F647}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F647}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F647}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F647}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F647}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F647}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F647}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F647}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F647}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F64B}\u200D\u2640\uFE0F",
    "\u{1F64B}\u200D\u2642\uFE0F",
    "\u{1F64B}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F64B}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F64B}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F64B}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F64B}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F64B}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F64B}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F64B}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F64B}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F64B}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F64D}\u200D\u2640\uFE0F",
    "\u{1F64D}\u200D\u2642\uFE0F",
    "\u{1F64D}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F64D}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F64D}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F64D}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F64D}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F64D}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F64D}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F64D}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F64D}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F64D}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F64E}\u200D\u2640\uFE0F",
    "\u{1F64E}\u200D\u2642\uFE0F",
    "\u{1F64E}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F64E}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F64E}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F64E}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F64E}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F64E}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F64E}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F64E}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F64E}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F64E}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F6A3}\u200D\u2640\uFE0F",
    "\u{1F6A3}\u200D\u2642\uFE0F",
    "\u{1F6A3}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F6A3}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F6A3}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F6A3}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F6A3}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F6A3}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F6A3}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F6A3}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F6A3}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F6A3}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F6B4}\u200D\u2640\uFE0F",
    "\u{1F6B4}\u200D\u2642\uFE0F",
    "\u{1F6B4}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F6B4}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F6B4}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F6B4}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F6B4}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F6B4}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F6B4}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F6B4}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F6B4}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F6B4}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F6B5}\u200D\u2640\uFE0F",
    "\u{1F6B5}\u200D\u2642\uFE0F",
    "\u{1F6B5}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F6B5}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F6B5}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F6B5}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F6B5}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F6B5}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F6B5}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F6B5}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F6B5}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F6B5}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F6B6}\u200D\u2640\uFE0F",
    "\u{1F6B6}\u200D\u2642\uFE0F",
    "\u{1F6B6}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F6B6}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F6B6}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F6B6}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F6B6}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F6B6}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F6B6}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F6B6}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F6B6}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F6B6}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F926}\u200D\u2640\uFE0F",
    "\u{1F926}\u200D\u2642\uFE0F",
    "\u{1F926}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F926}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F926}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F926}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F926}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F926}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F926}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F926}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F926}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F926}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F935}\u200D\u2640\uFE0F",
    "\u{1F935}\u200D\u2642\uFE0F",
    "\u{1F935}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F935}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F935}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F935}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F935}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F935}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F935}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F935}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F935}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F935}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F937}\u200D\u2640\uFE0F",
    "\u{1F937}\u200D\u2642\uFE0F",
    "\u{1F937}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F937}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F937}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F937}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F937}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F937}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F937}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F937}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F937}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F937}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F938}\u200D\u2640\uFE0F",
    "\u{1F938}\u200D\u2642\uFE0F",
    "\u{1F938}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F938}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F938}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F938}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F938}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F938}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F938}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F938}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F938}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F938}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F939}\u200D\u2640\uFE0F",
    "\u{1F939}\u200D\u2642\uFE0F",
    "\u{1F939}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F939}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F939}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F939}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F939}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F939}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F939}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F939}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F939}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F939}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F93C}\u200D\u2640\uFE0F",
    "\u{1F93C}\u200D\u2642\uFE0F",
    "\u{1F93D}\u200D\u2640\uFE0F",
    "\u{1F93D}\u200D\u2642\uFE0F",
    "\u{1F93D}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F93D}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F93D}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F93D}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F93D}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F93D}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F93D}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F93D}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F93D}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F93D}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F93E}\u200D\u2640\uFE0F",
    "\u{1F93E}\u200D\u2642\uFE0F",
    "\u{1F93E}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F93E}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F93E}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F93E}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F93E}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F93E}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F93E}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F93E}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F93E}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F93E}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F9B8}\u200D\u2640\uFE0F",
    "\u{1F9B8}\u200D\u2642\uFE0F",
    "\u{1F9B8}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F9B8}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F9B8}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F9B8}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F9B8}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F9B8}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F9B8}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F9B8}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F9B8}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F9B8}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F9B9}\u200D\u2640\uFE0F",
    "\u{1F9B9}\u200D\u2642\uFE0F",
    "\u{1F9B9}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F9B9}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F9B9}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F9B9}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F9B9}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F9B9}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F9B9}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F9B9}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F9B9}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F9B9}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F9CD}\u200D\u2640\uFE0F",
    "\u{1F9CD}\u200D\u2642\uFE0F",
    "\u{1F9CD}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F9CD}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F9CD}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F9CD}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F9CD}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F9CD}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F9CD}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F9CD}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F9CD}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F9CD}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F9CE}\u200D\u2640\uFE0F",
    "\u{1F9CE}\u200D\u2642\uFE0F",
    "\u{1F9CE}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F9CE}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F9CE}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F9CE}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F9CE}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F9CE}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F9CE}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F9CE}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F9CE}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F9CE}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F9CF}\u200D\u2640\uFE0F",
    "\u{1F9CF}\u200D\u2642\uFE0F",
    "\u{1F9CF}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F9CF}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F9CF}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F9CF}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F9CF}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F9CF}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F9CF}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F9CF}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F9CF}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F9CF}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F9D4}\u200D\u2640\uFE0F",
    "\u{1F9D4}\u200D\u2642\uFE0F",
    "\u{1F9D4}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F9D4}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F9D4}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F9D4}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F9D4}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F9D4}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F9D4}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F9D4}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F9D4}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F9D4}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F9D6}\u200D\u2640\uFE0F",
    "\u{1F9D6}\u200D\u2642\uFE0F",
    "\u{1F9D6}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F9D6}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F9D6}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F9D6}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F9D6}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F9D6}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F9D6}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F9D6}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F9D6}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F9D6}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F9D7}\u200D\u2640\uFE0F",
    "\u{1F9D7}\u200D\u2642\uFE0F",
    "\u{1F9D7}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F9D7}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F9D7}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F9D7}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F9D7}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F9D7}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F9D7}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F9D7}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F9D7}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F9D7}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F9D8}\u200D\u2640\uFE0F",
    "\u{1F9D8}\u200D\u2642\uFE0F",
    "\u{1F9D8}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F9D8}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F9D8}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F9D8}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F9D8}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F9D8}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F9D8}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F9D8}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F9D8}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F9D8}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F9D9}\u200D\u2640\uFE0F",
    "\u{1F9D9}\u200D\u2642\uFE0F",
    "\u{1F9D9}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F9D9}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F9D9}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F9D9}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F9D9}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F9D9}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F9D9}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F9D9}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F9D9}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F9D9}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F9DA}\u200D\u2640\uFE0F",
    "\u{1F9DA}\u200D\u2642\uFE0F",
    "\u{1F9DA}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F9DA}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F9DA}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F9DA}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F9DA}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F9DA}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F9DA}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F9DA}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F9DA}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F9DA}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F9DB}\u200D\u2640\uFE0F",
    "\u{1F9DB}\u200D\u2642\uFE0F",
    "\u{1F9DB}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F9DB}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F9DB}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F9DB}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F9DB}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F9DB}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F9DB}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F9DB}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F9DB}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F9DB}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F9DC}\u200D\u2640\uFE0F",
    "\u{1F9DC}\u200D\u2642\uFE0F",
    "\u{1F9DC}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F9DC}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F9DC}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F9DC}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F9DC}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F9DC}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F9DC}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F9DC}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F9DC}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F9DC}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F9DD}\u200D\u2640\uFE0F",
    "\u{1F9DD}\u200D\u2642\uFE0F",
    "\u{1F9DD}\u{1F3FB}\u200D\u2640\uFE0F",
    "\u{1F9DD}\u{1F3FB}\u200D\u2642\uFE0F",
    "\u{1F9DD}\u{1F3FC}\u200D\u2640\uFE0F",
    "\u{1F9DD}\u{1F3FC}\u200D\u2642\uFE0F",
    "\u{1F9DD}\u{1F3FD}\u200D\u2640\uFE0F",
    "\u{1F9DD}\u{1F3FD}\u200D\u2642\uFE0F",
    "\u{1F9DD}\u{1F3FE}\u200D\u2640\uFE0F",
    "\u{1F9DD}\u{1F3FE}\u200D\u2642\uFE0F",
    "\u{1F9DD}\u{1F3FF}\u200D\u2640\uFE0F",
    "\u{1F9DD}\u{1F3FF}\u200D\u2642\uFE0F",
    "\u{1F9DE}\u200D\u2640\uFE0F",
    "\u{1F9DE}\u200D\u2642\uFE0F",
    "\u{1F9DF}\u200D\u2640\uFE0F",
    "\u{1F9DF}\u200D\u2642\uFE0F",
    "\u{1F468}\u200D\u{1F9B0}",
    "\u{1F468}\u200D\u{1F9B1}",
    "\u{1F468}\u200D\u{1F9B2}",
    "\u{1F468}\u200D\u{1F9B3}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F9B0}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F9B1}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F9B2}",
    "\u{1F468}\u{1F3FB}\u200D\u{1F9B3}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F9B0}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F9B1}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F9B2}",
    "\u{1F468}\u{1F3FC}\u200D\u{1F9B3}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F9B0}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F9B1}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F9B2}",
    "\u{1F468}\u{1F3FD}\u200D\u{1F9B3}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F9B0}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F9B1}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F9B2}",
    "\u{1F468}\u{1F3FE}\u200D\u{1F9B3}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F9B0}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F9B1}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F9B2}",
    "\u{1F468}\u{1F3FF}\u200D\u{1F9B3}",
    "\u{1F469}\u200D\u{1F9B0}",
    "\u{1F469}\u200D\u{1F9B1}",
    "\u{1F469}\u200D\u{1F9B2}",
    "\u{1F469}\u200D\u{1F9B3}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F9B0}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F9B1}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F9B2}",
    "\u{1F469}\u{1F3FB}\u200D\u{1F9B3}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F9B0}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F9B1}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F9B2}",
    "\u{1F469}\u{1F3FC}\u200D\u{1F9B3}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F9B0}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F9B1}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F9B2}",
    "\u{1F469}\u{1F3FD}\u200D\u{1F9B3}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F9B0}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F9B1}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F9B2}",
    "\u{1F469}\u{1F3FE}\u200D\u{1F9B3}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F9B0}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F9B1}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F9B2}",
    "\u{1F469}\u{1F3FF}\u200D\u{1F9B3}",
    "\u{1F9D1}\u200D\u{1F9B0}",
    "\u{1F9D1}\u200D\u{1F9B1}",
    "\u{1F9D1}\u200D\u{1F9B2}",
    "\u{1F9D1}\u200D\u{1F9B3}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F9B0}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F9B1}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F9B2}",
    "\u{1F9D1}\u{1F3FB}\u200D\u{1F9B3}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F9B0}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F9B1}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F9B2}",
    "\u{1F9D1}\u{1F3FC}\u200D\u{1F9B3}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F9B0}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F9B1}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F9B2}",
    "\u{1F9D1}\u{1F3FD}\u200D\u{1F9B3}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F9B0}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F9B1}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F9B2}",
    "\u{1F9D1}\u{1F3FE}\u200D\u{1F9B3}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F9B0}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F9B1}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F9B2}",
    "\u{1F9D1}\u{1F3FF}\u200D\u{1F9B3}",
    "\u2764\uFE0F\u200D\u{1F525}",
    "\u2764\uFE0F\u200D\u{1FA79}",
    "\u{1F3F3}\uFE0F\u200D\u26A7\uFE0F",
    "\u{1F3F3}\uFE0F\u200D\u{1F308}",
    "\u{1F3F4}\u200D\u2620\uFE0F",
    "\u{1F408}\u200D\u2B1B",
    "\u{1F415}\u200D\u{1F9BA}",
    "\u{1F43B}\u200D\u2744\uFE0F",
    "\u{1F441}\uFE0F\u200D\u{1F5E8}\uFE0F",
    "\u{1F62E}\u200D\u{1F4A8}",
    "\u{1F635}\u200D\u{1F4AB}",
    "\u{1F636}\u200D\u{1F32B}\uFE0F",
    "\u{1F9D1}\u200D\u{1F384}"
  ],
  nonMatchStrings: [
    "\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F468}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}",
    "\u{1F468}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FB}",
    "\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F468}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}",
    "\u{1F468}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FC}",
    "\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F468}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}",
    "\u{1F468}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FD}",
    "\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F468}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}",
    "\u{1F468}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FE}",
    "\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FF}",
    "\u{1F468}\u{1F3FB}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}",
    "\u{1F468}\u200D\u2764\uFE0F\u200D\u{1F48B}\u200D\u{1F468}\u{1F3FF}"
  ],
});
