#include "webpluginfactoryprototype.h"

#include <QPainter>
#include <QStyleOptionGraphicsItem>
#include <QDebug>

//https://sites.google.com/a/borovkov.com/qtwebplugin/

WebPluginFactoryPrototype::WebPluginFactoryPrototype(QObject *parent) :
    QWebPluginFactory(parent)
{
    qDebug() << "creating plugin factory";
}

QObject *WebPluginFactoryPrototype::create(const QString &mimeType, const QUrl &, const QStringList &argumentNames, const QStringList &argumentValues) const
{
    qDebug() << "mimeType = " << mimeType;

    if (!mimeType.compare("application/xre-hole-puncher", Qt::CaseInsensitive))
    {
        return new XREHolePuncherPlugin();
    }

    //QWidget based: not going to be supported
//    if (!mimeType.compare("application/xre-media-player", Qt::CaseInsensitive))
//    {
//        return new XREMediaPlayerPlugin();
//    }

    return NULL;
}

QList<QWebPluginFactory::Plugin> WebPluginFactoryPrototype::plugins() const
{
    QList<Plugin> list;

    Plugin newPlugin;
    newPlugin.name = "XRE HOLE PUNCHER";
    newPlugin.description = "Punches a hole to see what's behind UI plane";

    MimeType mimeType;
    mimeType.name = "application/xre-hole-puncher";

    newPlugin.mimeTypes.append(mimeType);
    list.append(newPlugin);


    Plugin newPlugin2;
    newPlugin2.name = "XRE MEDIA PLAYER";
    newPlugin2.description = "Plays media. Surprize!";

    MimeType mimeType2;
    mimeType2.name = "application/xre-hole-puncher";

    newPlugin2.mimeTypes.append(mimeType2);
    list.append(newPlugin2);

    return list;
}



// XREMediaPlayerPlugin

XREMediaPlayerPlugin::XREMediaPlayerPlugin(QWidget *parent)
{
    qDebug() << "creating media player plugin";

    setAutoFillBackground(true);
}

void XREMediaPlayerPlugin::paintEvent(QPaintEvent *event)
{
    qDebug() << "media player PAINT EVENT";

    QPainter painter(this);
    painter.fillRect(event->rect(),Qt::red);
}


