#!/bin/sh
Apparmor_blocklist="/opt/secure/Apparmor_blocklist"
PROFILES_DIR="/etc/apparmor.d/"
PARSER="/sbin/apparmor_parser"
SYSFS_AA_PATH="/sys/kernel/security/apparmor/profiles"
RDKLOGS="/rdklogs/logs/Consolelog.txt.0"
Apparmor_defaults="/etc/apparmor/apparmor_defaults"
FR_Flag="/nvram/apparmor_factory_reset"
PIN_FR=0
source /etc/log_timestamp.sh
if [ -f /etc/device.properties ];then
     source /etc/device.properties
fi
if [ -f /lib/rdk/t2Shared_api.sh ]; then
    source /lib/rdk/t2Shared_api.sh
fi
if [ ! -f $Apparmor_blocklist ]; then
     touch $Apparmor_blocklist
fi
if [ "$BOX_TYPE" = "HUB4" ]; then
      if [ `cat /data/HFRES_UTOPIA` -eq 1 ]; then
            PIN_FR=1
      fi
fi
if [ "$BOX_TYPE" = "SR213" ]; then
      if [ `cat /data/HFRES_UTOPIA` -eq 1 ]; then
            PIN_FR=1
      fi
fi
if [ "$MODEL_NUM" = "TG3482G" ]; then
      if [ -s /sys/bus/acpi/devices/INT34DB:00/reset_btn_dur ]; then
           PIN_FR=`cat /sys/bus/acpi/devices/INT34DB:00/reset_btn_dur`
      fi
fi
if [ "$MODEL_NUM" = "TG4482A" ]; then
      if [ -f /nvram/WPS_Factory_Reset ]; then
           PIN_FR=1
      fi
fi
if [ -f $FR_Flag ]; then
     PIN_FR=1
     rm -f $FR_Flag
fi
if [ "$PIN_FR" -eq "0" ]; then
     while read line; do
        mode=`echo $line | cut -d ":" -f 2`
        process=`echo $line | cut -d ":" -f 1`
        profile=`ls -ltr $PROFILES_DIR | grep -w $process | awk '{print $9}'`
        if [ ! -z $profile ]; then
               blocklist_process=`grep -w $process $Apparmor_blocklist`
               blocklist_mode=`echo $blocklist_process | awk -F ":" '{print $2}'`
                          if [ "$mode" == "enforce" ] && [ "$blocklist_mode" != "disable" ]; then
                                $PARSER -rW $PROFILES_DIR/$profile
                          elif [ "$BUILD_TYPE" != "prod" ]; then
                                  if [ "$mode" == "complain" ] && [ "$blocklist_mode" != "disable" ]; then
                                        $PARSER -rWC $PROFILES_DIR/$profile
                                  fi
                          elif [ "$process" == "global" ]  && [ "$mode" == "complain" ]  && [ "$blocklist_mode" != "disable" ]; then
                                  $PARSER -rWC $PROFILES_DIR/$profile
                          fi
        fi
     done<$Apparmor_defaults
fi
list=`cat $SYSFS_AA_PATH | grep complain | awk '{print $1}' | tr '\n' ','`
cnt=`cat $SYSFS_AA_PATH | grep complain | wc -l`
if [ ! -z "$list" ]; then
     echo_t "List of profiles in Apparmor-complain mode:$cnt,$list" >> $RDKLOGS
     t2ValNotify "APPARMOR_C_split" "$cnt,$list"
fi
list=`cat $SYSFS_AA_PATH | grep enforce | awk '{print $1}' | tr '\n' ','`
cnt=`cat $SYSFS_AA_PATH | grep enforce | wc -l`
if [ ! -z "$list" ]; then
     echo_t "List of profiles in Apparmor-enforce mode:$cnt,$list" >> $RDKLOGS
     t2ValNotify "APPARMOR_E_split" "$cnt,$list"
fi
if [ -f /etc/apparmor/aar_telemetry.sh ]; then
        /etc/apparmor/aar_telemetry.sh &
fi
