DESCRIPTION = "QCA639X ax wifi drivers binaries"
SECTION = "wifi"
LICENSE = "BSD|GPL"

inherit systemd

FILESEXTRAPATHS_prepend := "${THISDIR}/files/wifi:"

QCA6390_WIFI_TAR = "qca6390"
QCA6390_WIFI_TAR_append_dunfell = "-dunfell"

SRCREV = "${AUTOREV}"
ARTIFACTVER = "2.36"
SRC_URI = "\
        ${RDK_ARTIFACTS_BASE_URL}/sky_realtek_xione/components/wifi/${QCA6390_WIFI_TAR}/${ARTIFACTVER}/${QCA6390_WIFI_TAR}-${ARTIFACTVER}.tar.gz;name=${QCA6390_WIFI_TAR} \
        "
SRC_URI_append = "\
            file://qca-overrides \
           "
SRC_URI[qca6390.sha256sum] = "a3e69bb280ff0ef019352de4e2a3362972d0226df737201e4b445c1a9a133704"
SRC_URI[qca6390-dunfell.sha256sum] = "0e2e77737f5ca493c5721e931a8c9ccb78c38dc1b7ef1f25faaec7efb9c18d67"

#EXTERNALSRC_BUILD = "${EXTERNALSRC}"
S = "${WORKDIR}"
KERNEL_VERSION = "4.9.119"

BUILD_REGION := "${@oe.utils.conditional('SKY_VARIANT', 'true', 'EU', 'US', d)}"

include ${@oe.utils.conditional('ENV_BUILD_TYPE','xione-hwtest','${PN}-xione-wifitest.inc', '${PN}-unknown.inc',d)}
include ${@oe.utils.conditional('ENV_WIFI_TEST_TYPE','xione-wtstest','${PN}-xione-wtstest.inc', '${PN}-unknown.inc',d)}

INHIBIT_PACKAGE_DEBUG_SPLIT = "1"
EXCLUDE_FROM_SHLIBS = "1"
INHIBIT_PACKAGE_STRIP = "1"

INSANE_SKIP_${PN} = "${ERROR_QA} ${WARN_QA}"
INSANE_SKIP_${PN}-dev = "${ERROR_QA} ${WARN_QA}"

# Skip the unwanted steps
do_configure[noexec] = "1"
do_compile[noexec] = "1"
do_populate_sysroot[noexec] = "1"
do_populate_lic[noexec] = "1"

do_install() {
    install -d ${D}/lib/modules/${KERNEL_VERSION}/extra/
    install -d ${D}/lib/firmware
    install -d ${D}/lib/firmware/qca
    install -d ${D}/lib/firmware/wlan
    install -d ${D}/lib/rdk
    install -d ${D}/sbin

    if ${@bb.utils.contains_any('DISTRO_FEATURES', 'flex2_rdk firebolt_rdk_certify', 'true','false',d)}; then
        BUILD_REGION="US"
    fi

    cp -r ${S}/qca6390/lib/modules/${BUILD_REGION}/* ${D}/lib/modules/${KERNEL_VERSION}/extra/
    cp -r ${S}/qca6390/lib/firmware/* ${D}/lib/firmware/
    cp -r ${S}/qca-overrides/wlan/${BUILD_REGION}/* ${D}/lib/firmware/
    cp -r ${S}/qca-overrides/bluetooth/${BUILD_REGION}/htnv20.bin ${D}/lib/firmware/qca/hst_nvm.bin
    cp -r ${S}/qca-overrides/bluetooth/${BUILD_REGION}/htbtfw20.tlv ${D}/lib/firmware/qca/hst_rampatch.bin

    # Modify Wi-Fi Driver INI file qcom_cfg.ini to include twt_congestion_timeout=0. This is to resolve TWT issues (XIONE-4146)
    sed -i -- '0,/END/{s/END/\#QCM recommended setting to resolve a packet loss or latency issues when using TWT see XIONE-4146\ntwt_congestion_timeout=0\n\nEND/}' ${D}/lib/firmware/wlan/qcom_cfg.ini

    #INI file modification to enable Wake on WLAN in UK variants
    if [ "${@oe.utils.conditional("ENABLE_WOL_WOWLAN", "true", "true", "false", d)}" = "true" ]; then
        sed -i 's/# gEnableWoW=0/gEnableWoW=1/g' ${D}/lib/firmware/wlan/qcom_cfg.ini
    fi
    if ${@bb.utils.contains_any('DISTRO_FEATURES', 'flex2_rdk firebolt_rdk_certify', 'true','false',d)}; then
        sed -i 's/# gEnableWoW=0/gEnableWoW=1/g' ${D}/lib/firmware/wlan/qcom_cfg.ini
    fi

    install -d ${D}${systemd_unitdir}/system
    install -m 0644 ${S}/qca-overrides/wifi.service ${D}${systemd_unitdir}/system/wifi.service
    install -D -m 0777 ${S}/qca-overrides/load-qca-wifi-drivers.sh ${D}/lib/rdk/
}

FILES_${PN} = "/"
SYSTEMD_SERVICE_${PN} += "wifi.service"
