// Copyright (c) 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// THIS FILE IS AUTOGENERATED.
// If you need change something in this file, please see
// protocol.json and browser_protocol.json

#include "content/browser/devtools/devtools_protocol_constants.h"

namespace content {
namespace devtools {

const char kResult[] = "result";

namespace DOM {
  const char kName[] = "DOM";

  namespace Rect {
    const char kParamHeight[] = "height";
    const char kParamWidth[] = "width";
    const char kParamX[] = "x";
    const char kParamY[] = "y";
  } // Rect

  namespace setFileInputFiles {
    const char kName[] = "DOM.setFileInputFiles";
    const char kParamFiles[] = "files";
    const char kParamNodeId[] = "nodeId";
  } // setFileInputFiles
} // DOM

namespace Input {
  const char kName[] = "Input";

  namespace dispatchGestureEvent {
    const char kName[] = "Input.dispatchGestureEvent";
    const char kParamDeltaX[] = "deltaX";
    const char kParamDeltaY[] = "deltaY";
    const char kParamPinchScale[] = "pinchScale";
    const char kParamTimestamp[] = "timestamp";
    const char kParamType[] = "type";
    const char kParamX[] = "x";
    const char kParamY[] = "y";

    namespace Type {
      const char kEnumPinchBegin[] = "pinchBegin";
      const char kEnumPinchEnd[] = "pinchEnd";
      const char kEnumPinchUpdate[] = "pinchUpdate";
      const char kEnumScrollBegin[] = "scrollBegin";
      const char kEnumScrollEnd[] = "scrollEnd";
      const char kEnumScrollUpdate[] = "scrollUpdate";
      const char kEnumTap[] = "tap";
      const char kEnumTapDown[] = "tapDown";
    } // Type
  } // dispatchGestureEvent

  namespace dispatchMouseEvent {
    const char kName[] = "Input.dispatchMouseEvent";
    const char kParamButton[] = "button";
    const char kParamClickCount[] = "clickCount";
    const char kParamDeviceSpace[] = "deviceSpace";
    const char kParamModifiers[] = "modifiers";
    const char kParamTimestamp[] = "timestamp";
    const char kParamType[] = "type";
    const char kParamX[] = "x";
    const char kParamY[] = "y";

    namespace Button {
      const char kEnumLeft[] = "left";
      const char kEnumMiddle[] = "middle";
      const char kEnumNone[] = "none";
      const char kEnumRight[] = "right";
    } // Button

    namespace Type {
      const char kEnumMouseMoved[] = "mouseMoved";
      const char kEnumMousePressed[] = "mousePressed";
      const char kEnumMouseReleased[] = "mouseReleased";
    } // Type
  } // dispatchMouseEvent
} // Input

namespace Inspector {
  const char kName[] = "Inspector";

  namespace detached {
    const char kName[] = "Inspector.detached";
    const char kParamReason[] = "reason";
  } // detached

  namespace targetCrashed {
    const char kName[] = "Inspector.targetCrashed";
  } // targetCrashed
} // Inspector

namespace Page {
  const char kName[] = "Page";

  namespace NavigationEntry {
    const char kParamId[] = "id";
    const char kParamTitle[] = "title";
    const char kParamUrl[] = "url";
  } // NavigationEntry

  namespace Quota {
    const char kParamPersistent[] = "persistent";
    const char kParamTemporary[] = "temporary";
  } // Quota

  namespace ScreencastFrameMetadata {
    const char kParamDeviceScaleFactor[] = "deviceScaleFactor";
    const char kParamOffsetBottom[] = "offsetBottom";
    const char kParamOffsetTop[] = "offsetTop";
    const char kParamPageScaleFactor[] = "pageScaleFactor";
    const char kParamPageScaleFactorMax[] = "pageScaleFactorMax";
    const char kParamPageScaleFactorMin[] = "pageScaleFactorMin";
    const char kParamViewport[] = "viewport";
  } // ScreencastFrameMetadata

  namespace Usage {
    const char kParamPersistent[] = "persistent";
    const char kParamSyncable[] = "syncable";
    const char kParamTemporary[] = "temporary";
  } // Usage

  namespace UsageItem {
    const char kParamId[] = "id";
    const char kParamValue[] = "value";

    namespace Id {
      const char kEnumAppcache[] = "appcache";
      const char kEnumDatabase[] = "database";
      const char kEnumFilesystem[] = "filesystem";
      const char kEnumIndexeddatabase[] = "indexeddatabase";
    } // Id
  } // UsageItem

  namespace canScreencast {
    const char kName[] = "Page.canScreencast";
    const char kResponseResult[] = "result";
  } // canScreencast

  namespace captureScreenshot {
    const char kName[] = "Page.captureScreenshot";
    const char kParamFormat[] = "format";
    const char kParamMaxHeight[] = "maxHeight";
    const char kParamMaxWidth[] = "maxWidth";
    const char kParamQuality[] = "quality";
    const char kResponseData[] = "data";
    const char kResponseMetadata[] = "metadata";

    namespace Format {
      const char kEnumJpeg[] = "jpeg";
      const char kEnumPng[] = "png";
    } // Format
  } // captureScreenshot

  namespace disable {
    const char kName[] = "Page.disable";
  } // disable

  namespace getNavigationHistory {
    const char kName[] = "Page.getNavigationHistory";
    const char kResponseCurrentIndex[] = "currentIndex";
    const char kResponseEntries[] = "entries";
  } // getNavigationHistory

  namespace handleJavaScriptDialog {
    const char kName[] = "Page.handleJavaScriptDialog";
    const char kParamAccept[] = "accept";
    const char kParamPromptText[] = "promptText";
  } // handleJavaScriptDialog

  namespace navigate {
    const char kName[] = "Page.navigate";
    const char kParamUrl[] = "url";
  } // navigate

  namespace navigateToHistoryEntry {
    const char kName[] = "Page.navigateToHistoryEntry";
    const char kParamEntryId[] = "entryId";
  } // navigateToHistoryEntry

  namespace queryUsageAndQuota {
    const char kName[] = "Page.queryUsageAndQuota";
    const char kParamSecurityOrigin[] = "securityOrigin";
    const char kResponseQuota[] = "quota";
    const char kResponseUsage[] = "usage";
  } // queryUsageAndQuota

  namespace reload {
    const char kName[] = "Page.reload";
    const char kParamIgnoreCache[] = "ignoreCache";
    const char kParamScriptPreprocessor[] = "scriptPreprocessor";
    const char kParamScriptToEvaluateOnLoad[] = "scriptToEvaluateOnLoad";
  } // reload

  namespace screencastFrame {
    const char kName[] = "Page.screencastFrame";
    const char kParamData[] = "data";
    const char kParamMetadata[] = "metadata";
  } // screencastFrame

  namespace screencastVisibilityChanged {
    const char kName[] = "Page.screencastVisibilityChanged";
    const char kParamVisible[] = "visible";
  } // screencastVisibilityChanged

  namespace startScreencast {
    const char kName[] = "Page.startScreencast";
    const char kParamFormat[] = "format";
    const char kParamMaxHeight[] = "maxHeight";
    const char kParamMaxWidth[] = "maxWidth";
    const char kParamQuality[] = "quality";

    namespace Format {
      const char kEnumJpeg[] = "jpeg";
      const char kEnumPng[] = "png";
    } // Format
  } // startScreencast

  namespace stopScreencast {
    const char kName[] = "Page.stopScreencast";
  } // stopScreencast
} // Page

namespace SystemInfo {
  const char kName[] = "SystemInfo";

  namespace GPUDevice {
    const char kParamDeviceId[] = "deviceId";
    const char kParamDeviceString[] = "deviceString";
    const char kParamVendorId[] = "vendorId";
    const char kParamVendorString[] = "vendorString";
  } // GPUDevice

  namespace GPUInfo {
    const char kParamAuxAttributes[] = "auxAttributes";
    const char kParamDevices[] = "devices";
    const char kParamFeatureStatus[] = "featureStatus";
  } // GPUInfo

  namespace SystemInfo {
    const char kParamGpu[] = "gpu";
    const char kParamModelName[] = "modelName";
  } // SystemInfo

  namespace getInfo {
    const char kName[] = "SystemInfo.getInfo";
    const char kResponseInfo[] = "info";
  } // getInfo
} // SystemInfo

namespace Tracing {
  const char kName[] = "Tracing";

  namespace dataCollected {
    const char kName[] = "Tracing.dataCollected";
    const char kParamValue[] = "value";
  } // dataCollected

  namespace end {
    const char kName[] = "Tracing.end";
  } // end

  namespace start {
    const char kName[] = "Tracing.start";
    const char kParamCategories[] = "categories";
    const char kParamOptions[] = "options";
  } // start

  namespace tracingComplete {
    const char kName[] = "Tracing.tracingComplete";
  } // tracingComplete
} // Tracing

namespace Worker {
  const char kName[] = "Worker";

  namespace disconnectFromWorker {
    const char kName[] = "Worker.disconnectFromWorker";
    const char kParamWorkerId[] = "workerId";
  } // disconnectFromWorker

  namespace disconnectedFromWorker {
    const char kName[] = "Worker.disconnectedFromWorker";
  } // disconnectedFromWorker
} // Worker


}  // devtools
}  // content
