#COMCAST MODIFICATION BEGIN
import collections
import os
import gyp
import gyp.common
import gyp.msvs_emulation
import json
import sys
import re

generator_supports_multiple_toolsets = False

generator_wants_static_library_dependencies_adjusted = False

generator_wants_sorted_dependencies = True

generator_default_variables = {
  'EXECUTABLE_PREFIX': '',
  'EXECUTABLE_SUFFIX': '',
  'STATIC_LIB_PREFIX': 'lib',
  'SHARED_LIB_PREFIX': 'lib',
  'STATIC_LIB_SUFFIX': '.a',
  'INTERMEDIATE_DIR': '$(obj).$(TOOLSET)/$(TARGET)/geni',
  'SHARED_INTERMEDIATE_DIR': '$!PRODUCT_DIR/gen',
  'PRODUCT_DIR': '$!PRODUCT_DIR',
  'RULE_INPUT_ROOT': '%(INPUT_ROOT)s',  # This gets expanded by Python.
  'RULE_INPUT_DIRNAME': '%(INPUT_DIRNAME)s',  # This gets expanded by Python.
  'RULE_INPUT_PATH': '$(abspath $<)',
  'RULE_INPUT_EXT': '$(suffix $<)',
  'RULE_INPUT_NAME': '$(notdir $<)',
  'CONFIGURATION_NAME': '$(BUILDTYPE)',
}

def CalculateVariables(default_variables, params):
  generator_flags = params.get('generator_flags', {})
  for key, val in generator_flags.items():
    default_variables.setdefault(key, val)
  default_variables.setdefault('OS', gyp.common.GetFlavor(params))
  default_variables.setdefault('SHARED_LIB_SUFFIX', '.so')
  default_variables.setdefault('SHARED_LIB_DIR','$(builddir)/lib.$(TOOLSET)')
  default_variables.setdefault('LIB_DIR', '$(obj).$(TOOLSET)')

def CalculateGeneratorInputInfo(params):
  """Calculate the generator specific info that gets fed to input (called by
  gyp)."""
  generator_flags = params.get('generator_flags', {})
  if generator_flags.get('adjust_static_libraries', False):
    global generator_wants_static_library_dependencies_adjusted
    generator_wants_static_library_dependencies_adjusted = True
  output_dir = params['options'].generator_output or \
               params['options'].toplevel_dir
  builddir_name = generator_flags.get('output_dir', 'out')
  qualified_out_dir = os.path.normpath(os.path.join(
    output_dir, builddir_name, 'Debug'))
  global generator_filelist_paths
  generator_filelist_paths = {
    'toplevel': params['options'].toplevel_dir,
    'qualified_out_dir': qualified_out_dir,
  }

def EscapeCppDefine(s):
  s = s.replace("'", "'\\''")
  s = s.replace("\"", "\\\"")
  return s #"\\'" + s + "\\'"

def ExpandSpecial(path):
  global generator_filelist_paths
  product_dir=generator_filelist_paths['qualified_out_dir']
  PRODUCT_DIR = '$!PRODUCT_DIR'
  if PRODUCT_DIR in path:
    if product_dir:
      path = path.replace(PRODUCT_DIR, product_dir)
    else:
      path = path.replace(PRODUCT_DIR + '/', '')
      path = path.replace(PRODUCT_DIR + '\\', '')
      path = path.replace(PRODUCT_DIR, '.')
  return path

def ResolvePath(targetdir, val):
  return os.path.normpath(os.path.join(targetdir, ExpandSpecial(val)))

def GenerateOutput(target_list, target_dicts, data, params):
  # Map of target -> list of targets it depends on.
  build_map = {}
  build_order = []

  # Queue of targets to visit.
  targets_to_visit = target_list[:]

  # Output names
  gyp_dump_pro = "a_gyp_dump"
  output_dir = "a_gyp_dump_qmake"

  if not os.path.exists(output_dir):
    os.makedirs(output_dir)

  while len(targets_to_visit) > 0:
    target = targets_to_visit.pop()
    if target in build_map:
      continue

    target_dict  = target_dicts[target]
    target_type  = target_dict.get("type")
    cfg          = target_dict.get('configurations', []).get('Debug', [])
    src          = target_dict.get('sources', [])
    cflags       = cfg.get('cflags', [])
    cflags_cc    = cfg.get('cflags_cc', [])
    ldflags      = cfg.get('ldflags', [])
    include_dirs = cfg.get('include_dirs', [])
    defines      = cfg.get('defines', [])
    cflags_cc    = cflags_cc + [ el for el in cflags if el not in cflags_cc ]
    libraries    = target_dict.get('libraries', [])

    target_dump = {}

    if "static_library" == target_type:
      target_dump['TEMPLATE'] = ["lib"]
      target_dump['CONFIG'] = ["staticlib"]
    elif "shared_library" == target_type or "loadable_module" == target_type:
      target_dump['TEMPLATE'] = ["lib"]
    elif "executable" == target_type:
      target_dump['TEMPLATE'] = ["app"]
    else:
      print "skip '%s' of type: '%s'" % (target,target_type)
      continue

    target_dump['SOURCES']        = [ el for el in src if not el.endswith('h') ]
    target_dump['HEADERS']        = [ el for el in src if el.endswith('h') ]
    target_dump['QMAKE_CFLAGS']   = cflags
    target_dump['QMAKE_CXXFLAGS'] = cflags_cc
    target_dump['QMAKE_LFLAGS']   = ldflags
    target_dump['LIBS']           = libraries
    target_dump['INCLUDEPATH']    = include_dirs
    target_dump['DEFINES']        = defines

    build_map[target] = target_dump
    build_order = [target] + build_order

    for dep in target_dict.get('dependencies', []):
      targets_to_visit.append(dep)

  sections_needs_path_resolve = ['SOURCES', 'HEADERS', 'INCLUDEPATH']

  # write target pro file
  for e in build_order:
    targetname = e[ e.index(':') + 1 : e.index('#') ]
    if "#host" in e:
      targetname += "_host"
    targetdir = os.path.relpath(os.path.dirname(e[0:e.index(':')]), output_dir)
    f = open(os.path.join(output_dir, targetname) + ".pro", 'w')
    f.write("QT =\n")
    f.write("CONFIG -= qt\n")
    f.write("TARGET = " + targetname + "\n")
    f.write("OBJECTS_DIR = $${TARGET}_obj\n")
    cfg = build_map[e]
    for key in cfg:
      if key == "TEMPLATE":
        f.write("\n" + key + " = \\\n")
      else:
        f.write("\n" + key + " += \\\n")
      for val in cfg[key]:
        if key == "DEFINES":
          f.write("  " + EscapeCppDefine(val) + " \\\n")
        elif key in sections_needs_path_resolve:
          resolved_path = ResolvePath(targetdir, val)
          f.write("  " + resolved_path + " \\\n")
        else:
          f.write("  " + val + " \\\n")
      f.write("\n")
    f.close()
    print 'Wrote %s.pro' % targetname

  # write subdirs pro file
  f = open(gyp_dump_pro + ".pro", 'w')
  f.write("TEMPLATE = subdirs\n")
  f.write("CONFIG  += ordered\n\n")
  for e in build_order:
    targetname = e[e.index(':')+1:e.index('#')]
    if "#host" in e:
      targetname += "_host"
    f.write("SUBDIRS += " + targetname +"\n")
    f.write(targetname + ".file = " + output_dir + "/" + targetname +".pro\n\n")
  f.close()
  print 'Wrote %s.pro' % gyp_dump_pro

  # # write all pro file
  # f = open(os.path.join(output_dir, "all.pro"), 'w')
  # for e in build_order:
  #   targetname = e[ e.index(':') + 1 : e.index('#') ]
  #   if "#host" in e:
  #     targetname += "_host"
  #   targetdir = os.path.relpath(os.path.dirname(e[0:e.index(':')]), output_dir)
  #   f.write("\n#################### " + targetname + " ####################\n")
  #   cfg = build_map[e]
  #   for key in cfg:
  #     if not cfg[key]:
  #       continue
  #     f.write("\n" + key + " *= \\\n")
  #     for val in cfg[key]:
  #       if key == "DEFINES":
  #         f.write("  " + EscapeCppDefine(val) + " \\\n")
  #       elif key in sections_needs_path_resolve:
  #         resolved_path = ResolvePath(targetdir, val)
  #         f.write("  " + resolved_path + " \\\n")
  #       else:
  #         f.write("  " + val + " \\\n")
  #     f.write("\n")
  # f.close()

  # filename = 'dump.json'
  # f = open(os.path.join(output_dir, filename), 'w')
  # json.dump(target_dicts, f, indent=2, sort_keys=True)
  # f.close()
  # print 'Wrote json to %s.' % filename
#COMCAST MODIFICATION END
