DESCRIPTION = "Qualcomm Bluetooth UART Attach Service"
SECTION = "bluetooth"
LICENSE = "BSD|GPL"

FILESEXTRAPATHS_prepend := "${THISDIR}/files/:"

inherit systemd

RDEPENDS_qca-hciattach_dunfell += " bash"

SRC_URI_append = " \
				file://qca-hciattach.service \
				file://start_qca-hciattach.sh \
				"

# Skip the unwanted steps
do_configure[noexec] = "1"
do_compile[noexec] = "1"
do_populate_sysroot[noexec] = "1"
do_populate_lic[noexec] = "1"

S = "${WORKDIR}"

do_install() {

	install -d ${D}${systemd_unitdir}/system
	install -d ${D}/lib/rdk/

	install -m 0644 ${S}/qca-hciattach.service ${D}${systemd_unitdir}/system/qca-hciattach.service
	install -D -m 0777  ${S}/start_qca-hciattach.sh ${D}/lib/rdk/start_qca-hciattach.sh

}

FILES_${PN} += "/lib/rdk/start_qca-hciattach.sh"

SYSTEMD_SERVICE_${PN} += "qca-hciattach.service"
