/*
 * If not stated otherwise in this file or this component's Licenses.txt file the
 * following copyright and licenses apply:
 *
 * Copyright 2016 RDK Management
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <string.h>
#include <stdio.h>
#include <assert.h>
#include <sys/time.h>
#include <dlfcn.h>
#include <unistd.h>
#include <sys/socket.h>
#include <semaphore.h>

#include "westeros-sink.h"
#include "wayland-egl.h"

/* #define V1SINK_DUMP_FRAME */
#ifdef V1SINK_DUMP_FRAME
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gst/gst.h>
#include <gst/video/video.h>
#include <gst/video/gstvideosink.h>
#include <stdlib.h>
#include "SeAPI.h"
#if defined(ENABLE_TEE_DRM_FLOW)
#include <gstrtksecurememory.h>
#endif //defined(ENABLE_TEE_DRM_FLOW)

#define DEFAULT_PROP_ZOOM       1
#define DEFAULT_PROP_ZOOM_MODE       (0)  //0:full
#define DEFAULT_PROP_ZOOM_MODE_MAX       (8)
#define DEFAULT_PROP_FORCE_ASPECT_RATIO FALSE
#define DEFAULT_HWAVSYNC_FD     0
#define DEFAULT_ENABLE_HWAVSYNC TRUE
#define DEFAULT_FULL_RANGE_MODE FALSE
#define DEFAULT_LOW_DELAY_MODE  LOW_DELAY_DISPLAY_ORDER
#define DEFAULT_DELAY_DEPTH     1
#define DEFAULT_FW_SPEED        (1.0)
#define DEFAULT_RTK_SPEED_1X    256
#define DEFAULT_PLAYBACK_DISCARD_GAP  (47722000000)  //us
#define DEFAULT_CLOCK_RESET_GAP  (30000000)  //us
#define DEFAULT_LIVE_DISCARD_GAP      (3000000)  //us
#define DEFAULT_LATE_THRESHOLD        (5000000)   //us

#define RTK_V1_SINK_MAX_WIDTH   1920
#define RTK_V1_SINK_MAX_HEIGHT  1080
#define RTK_USE_FW_KEEP_FRAME   1
#define RTK_USE_BUFLOCK         1
#define RTK_KEEP_LAST_FRAME_CROSS_PIPELINE 0
#define RTK_UNDERFLOW_MULTIPLE  10  // Over Framerate x 10 = underflow
#define RTK_UNDERFLOW_TOLERANCE_FRAME  10  // don't emit underflow if frame count less than this value since last underflow signal (or changing to playing state)
#define AUDIO_MIN_SPEED 0.5

#define CLOCK_BASE 9LL
#define PLOCK_STATUS_INIT 0
#define PLOCK_STATUS_QPEND 1
#define PLOCK_STATUS_LOCK  2
#define PLOCK_STATUS_UNLOCK 3

#define WAIT_AUDIO_INTERVAL 2000
#define WAIT_VIDEO_MAX_CNT 500
#define WAIT_AUDIO_MAX_CNT 150
#define WAIT_AUDIO_MASTER_MAX_CNT 40
#define WAIT_SEM_MAX_CNT 2
#define DEFAULT_MASTER MASTER_MODE_IPTV
#define DEFAULT_FREERUN_THRESHOLD_MIN (3)
#define DEFAULT_FREERUN_THRESHOLD_MAX (30)
#define DEFAULT_FREERUN_THRESHOLD (5)
#define VIDEO_POLL_INTERVAL 8000
#define DEFAULT_USAGE (EssRMgrVidUse_fullResolution|EssRMgrVidUse_fullQuality|EssRMgrVidUse_fullPerformance)
#define VOUT_SEMAPHORE_NAME "/vo_semaphore"

typedef enum {
  AUTOMASTER_NOT_MASTER,
  AUTOMASTER_IS_MASTER
} AUTOMASTER_STATE;

typedef enum _AvSync_MODE {
  VIDEO_MASTER = 0,
  FREE_RUN,
  PCR_MASTER,
  AUDIO_MASTER,
  AUDIO_MASTER_SKIP,
  AUDIO_MASTER_NOSKIP,
  MASTER_MODE_MAX
} AvSync_MODE;

const char* avsync_mode_type_str[MASTER_MODE_MAX] =
{
  {"VIDEO_MASTER\0"},
  {"FREE_RUN\0"},
  {"PCR_MASTER\0"},
  {"AUDIO_MASTER\0"},
  {"AUDIO_MASTER_SKIP\0"},
  {"AUDIO_MASTER_NOSKIP\0"}
};

#define GST_TYPE_PLANE (gst_plane_get_type ())
#define GST_TYPE_TV_MODE (gst_tv_mode_get_type ())
#define GST_TYPE_OSD_MODE (gst_osd_mode ())
#define GST_TYPE_BTF_MODE (gst_btf_mode ())

#define PREROLL_OFFSET (0LL)

GST_DEBUG_CATEGORY_EXTERN (gst_westeros_sink_debug);
#define GST_CAT_DEFAULT gst_westeros_sink_debug
#define ENABLE_V2_PLANE

#define SET_POSITION_START_PTS
#define DROP_TOO_OLD_FRAME
#define USE_ABSOLUTE_POSITION
enum
{
  SIGNAL_FIRSTFRAME,
  SIGNAL_UNDERFLOW,
  SIGNAL_PTSERROR,
  SIGNAL_TIMECODE,
  MAX_SIGNAL
};

enum
{
  PROP_100 = PROP_SOC_BASE,
  PROP_TV_MODE,
  PROP_PLANE,
  PROP_RECTANGLE,
  PROP_FLUSH_REPEAT_FRAME,
  PROP_CURRENT_PTS,
  PROP_INTER_FRAME_DELAY,
  PROP_SLOW_MODE_RATE,
  PROP_CONTENT_FRAME_RATE,
  PROP_STEPFRAME,
  PROP_MUTE,
  PROP_ZOOM,
  PROP_HWAVSYNC_FD,
  PROP_ENABLE_HWAVSYNC,
  PROP_FULL_RANGE_MODE,
  PROP_BRING_TO_FRONT,
  PROP_ENABLE_OSD,
  PROP_VIDEO_DECODE,
  PROP_WINDOW_SHOW,
  PROP_ZOOM_MODE,
  PROP_MASTER,
  PROP_FRAME_STEP_ON_PREROLL,
  PROP_FORCE_ASPECT_RATIO,
  PROP_FREERUN_THRESHOLD,
  PROP_RTK_RES_USAGE,
  PROP_IMMEDIATE_OUTPUT,
  PROP_STATS,
  PROP_LAST
};

static GType gst_tv_mode_get_type (void)
{
  static GType gtype_tvmode = 0;

  if (gtype_tvmode == 0) {
    static const GEnumValue values_tvmode[] = {
      {VO_WRAP_RES_NTSC_M, "NTSC", "NTSC"},
      {VO_WRAP_RES_480P60, "480P@60", "480P@60"},
      {VO_WRAP_RES_PAL_M, "PAL", "PAL"},
      {VO_WRAP_RES_PAL_BGH, "PAL BGH", "PAL BGH"},
      {VO_WRAP_RES_720P60, "720P@60", "720P@60"},
      {VO_WRAP_RES_720P50, "720P@50", "720P@50"},
      {VO_WRAP_RES_1080P24, "1080P@24", "1080P@24"},
      {VO_WRAP_RES_1080P30, "1080P@30", "1080P@30"},
      {VO_WRAP_RES_1080I60, "1080I@60", "1080I@60"},
      {VO_WRAP_RES_1080I50, "1080I@50", "1080I@50"},
      {VO_WRAP_RES_1080P60, "1080P@60", "1080P@60"},
      {VO_WRAP_RES_1080P50, "1080P@50", "1080P@50"},
      {VO_WRAP_RES_2160P24, "2160P@24", "2160P@24"},
      {VO_WRAP_RES_2160P25, "2160P@25", "2160P@25"},
      {VO_WRAP_RES_2160P30, "2160P@30", "2160P@30"},
      {VO_WRAP_RES_2160P50, "2160P@50", "2160P@50"},
      {VO_WRAP_RES_2160P60, "2160P@60", "2160P@60"},
      {VO_WRAP_RES_4096_2160P24, "2160P@24", "2160P@24"},
      {VO_WRAP_RES_4096_2160P25, "2160P@25", "2160P@25"},
      {VO_WRAP_RES_4096_2160P30, "2160P@30", "2160P@30"},
      {VO_WRAP_RES_4096_2160P50, "2160P@50", "2160P@50"},
      {VO_WRAP_RES_4096_2160P60, "2160P@60", "2160P@60"},
      {0, NULL, NULL}
    };

    gtype_tvmode = g_enum_register_static ("GstWesterosSinkTvMode", values_tvmode);
  }
  return gtype_tvmode;
}

static guint g_signals[MAX_SIGNAL]= {0};

static void transitionToRenderer( GstWesterosSink *sink);
static bool setupEGL( GstWesterosSink *sink );
static void termEGL( GstWesterosSink *sink );
static GLuint createShader(GstWesterosSink *sink, GLenum shaderType, const char *shaderSource );
static bool setupGfx( GstWesterosSink *sink );
static void termGfx( GstWesterosSink *sink );
static void createImage( GstWesterosSink *sink );
static void destroyImage( GstWesterosSink *sink );
static void drawImage( GstWesterosSink *sink );
static void processFrame( GstWesterosSink *sink, GstBuffer *buffer );
static gpointer captureThread(gpointer data);
static void sinkSocStopVideo( GstWesterosSink *sink );

static int gst_rtk_v1_sink_convertToVoutWrapPlane(GstWesterosSinkPlane vop);
static void gst_rtk_v1_sink_flush_and_alias_frame(GstWesterosSink *sink);
static void gst_rtk_v1_sink_property_set_bring_to_front(GstWesterosSink *sink);
static void gst_rtk_v1_sink_property_set_enable_osd(GstWesterosSink *sink);
static void gst_rtk_v1_sink_property_set_output_rectangle(GstWesterosSink *sink, int x, int y, int w, int h);
static void gst_rtk_v1_sink_property_set_output_plane(GstWesterosSink * sink, GstWesterosSinkPlane plane);
static void gst_rtk_v1_sink_set_avsync_mode(GstWesterosSink *sink, int mode);
static void gst_rtk_v1_sink_reset_initial_value(GstWesterosSink *sink);
static void gst_rtk_v1_sink_inital_vo_resource(GstWesterosSink *sink);
static void gst_rtk_v1_sink_check_hdr_info(GstWesterosSink *sink, GstBuffer *buffer);
static int gst_rtk_video_plane_init(GstWesterosSink *sink, VO_WRAP_VIDEO_PLANE voplane);
static int sinkAcquireVideo( GstWesterosSink *sink );
static void sinkReleaseVideo( GstWesterosSink *sink );
static GstStructure *wstSinkGetStats( GstWesterosSink * sink );
static gboolean processEventSinkSoc(GstWesterosSink *sink, GstPad *pad, GstEvent *event, gboolean *passToDefault);

static GstFlowReturn gst_westeros_sink_soc_preroll(GstBaseSink *base_sink, GstBuffer *buffer);

static gboolean (*queryOrg)(GstElement *element, GstQuery *query)= 0;

static void sbFormat(void *data, struct wl_sb *wl_sb, uint32_t format)
{
   WESTEROS_UNUSED(wl_sb);
   GstWesterosSink *sink= (GstWesterosSink*)data;
   WESTEROS_UNUSED(sink);
   GST_DEBUG_OBJECT(sink,"westeros-sink-soc: registry: sbFormat: %X", format);
}

static const struct wl_sb_listener sbListener = {
    sbFormat
};

static GType gst_plane_get_type (void)
{
  static GType gtype_plane = 0;

  if (gtype_plane == 0) {
    static const GEnumValue values_plane[] = {
      {PLANE_V1, "PLANE_V1", "video plane 1"},
#if defined(ENABLE_V2_PLANE)
      {PLANE_V2, "PLANE_V2", "video plane 2"},
#endif
      {PLANE_WIN1, "PLANE_WIN1", "mixer plane 1"},
      {PLANE_WIN2, "PLANE_WIN2", "mixer plane 2"},
      {0, NULL, NULL}
    };

    gtype_plane = g_enum_register_static ("GstWesterosSinkPlane", values_plane);
  }
  return gtype_plane;
}

static GType gst_osd_mode(void)
{
  static GType gtype_osd_mode = 0;

  if (gtype_osd_mode == 0) {
    static const GEnumValue osd_mode[] = {
      {OSDMODE_FEATURE_DISABLE, "OSDMODE_FEATURE_DISABLE", "Do not control OSD 1." },
      {OSDMODE_ENABLE,          "OSDMODE_ENABLE",          "Enable OSD 1 during playback."  },
      {OSDMODE_DISABLE,         "OSDMODE_DISABLE",         "Disable OSD1 during playback."  },
      {0,                       NULL,                      NULL}
    };

    gtype_osd_mode = g_enum_register_static ("GstWesterosSinkOSDMode", osd_mode);
  }
  return gtype_osd_mode;
}

static GType gst_btf_mode(void)
{
  static GType gtype_btf_mode = 0;

  if (gtype_btf_mode == 0) {
    static const GEnumValue btf_mode[] = {
      {BTF_FEATURE_DISABLE, "BTF_FEATURE_DISABLE", "Feature not enabled." },
      {BTF_ENABLE,          "BTF_ENABLE",          "Bring V1 to front."  },
      {BTF_DISABLE,         "BTF_DISABLE",         "Keep original V1 order."  },
      {0,                       NULL,                      NULL}
    };

    gtype_btf_mode = g_enum_register_static ("GstWesterosSinkBTF", btf_mode);
  }
  return gtype_btf_mode;
}

#if (RTK_USE_FW_KEEP_FRAME && defined(ENABLE_TEE_DRM_FLOW))
void gst_rtk_v1_svp_keep_frame(GstWesterosSinkSoc* socsink, int last_frame_index)
{
    VO_WRAP_KEEP_CURPIC_SVP* tmp = NULL;
    VO_WRAP_KEEP_CURPIC_SVP* lastpic = NULL;
    VO_WRAP_KEEP_CURPIC_SVP* getpic = NULL;

    if(socsink->v1_vobuf[last_frame_index].meta_type == METADATA_PRIVATE_RTK_DATA) {
      private_rtk_data *p = (private_rtk_data*) SystemMemory_GetVirAddr(socsink->v1_vobuf[last_frame_index].meta_handle);

      tmp = (VO_WRAP_KEEP_CURPIC_SVP *)calloc(1, sizeof(VO_WRAP_KEEP_CURPIC_SVP));
      if (tmp == NULL)  {
        GST_ERROR("Get tmp picture fail...");
        return;
      }

      lastpic = vo_wrap_set_VO_SVPKeepLastFrame(socsink->m_voplane, tmp, ENUM_VO_WRAP_KEEP_CUR_SVP_TYPE_GET_FW_MALLOC_SVP_BUFFER);
      if (lastpic == NULL) {
        GST_ERROR("Get fw malloc picture fail...");
        free(tmp);
        return;
      }

      getpic = vo_wrap_set_VO_SVPKeepLastFrame(socsink->m_voplane, lastpic, ENUM_VO_WRAP_KEEP_CUR_SVP_TYPE_GET_CUR);
      if (getpic == NULL) {
        GST_WARNING("Get last picture fail...");
        free(lastpic);
        free(tmp);
        return;
      }

      if ((getpic->Ysize > 0) && (getpic->Yaddr != 0)) {
        TEE_API_memcpy(&(socsink->sess), &(socsink->rtk_sess), lastpic->Yaddr, getpic->Yaddr, getpic->Ysize);
      }

      if ((getpic->Csize > 0) && (getpic->Caddr != 0)) {
        TEE_API_memcpy(&(socsink->sess), &(socsink->rtk_sess), lastpic->Caddr, getpic->Caddr, getpic->Csize);
      }

      if (p->lumaOffTblAddr != 0xffffffff) {
        if (lastpic->offsetTable_yaddr !=0 && getpic->offsetTable_yaddr != 0) {
          TEE_API_memcpy(&(socsink->sess), &(socsink->rtk_sess), lastpic->offsetTable_yaddr, getpic->offsetTable_yaddr, RTK_VO_COPY_LAST_FRAME_SIZEY);
        }

        if (lastpic->offsetTable_caddr !=0 && getpic->offsetTable_caddr != 0) {
          TEE_API_memcpy(&(socsink->sess), &(socsink->rtk_sess), lastpic->offsetTable_caddr, getpic->offsetTable_caddr, RTK_VO_COPY_LAST_FRAME_SIZEC);
        }
      } else {
        lastpic->offsetTable_yaddr = 0;
        lastpic->offsetTable_caddr = 0;
      }
    } else if (socsink->v1_vobuf[last_frame_index].meta_type == METADATA_VRPC_DVO_INFO ) {
#if RTK_USE_BUFLOCK
        /*Already lock in gst_rtk_v1_sink_flush_and_alias_frame()*/
       return;
#endif//RTK_USE_BUFLOCK

      vrpc_dvo_info_t *p = (vrpc_dvo_info_t*) SystemMemory_GetVirAddr(socsink->v1_vobuf[last_frame_index].meta_handle);

      tmp = (VO_WRAP_KEEP_CURPIC_SVP *)calloc(1, sizeof(VO_WRAP_KEEP_CURPIC_SVP));
      if (tmp == NULL)  {
        GST_ERROR("Get tmp picture fail...");
        return;
      }

      lastpic = vo_wrap_set_VO_SVPKeepLastFrame(socsink->m_voplane, tmp, ENUM_VO_WRAP_KEEP_CUR_SVP_TYPE_GET_FW_MALLOC_SVP_BUFFER);
      if (lastpic == NULL) {
        GST_ERROR("Get fw malloc picture fail...");
        free(tmp);
        return;
      }

      getpic = vo_wrap_set_VO_SVPKeepLastFrame(socsink->m_voplane, lastpic, ENUM_VO_WRAP_KEEP_CUR_SVP_TYPE_GET_CUR);
      if (getpic == NULL) {
        GST_WARNING("Get last picture fail...");
        free(lastpic);
        free(tmp);
        return;
      }

      if ((getpic->Ysize > 0) && (getpic->Yaddr != 0)) {
        TEE_API_memcpy(&(socsink->sess), &(socsink->rtk_sess), lastpic->Yaddr, getpic->Yaddr, getpic->Ysize);
      }

      if ((getpic->Csize > 0) && (getpic->Caddr != 0)) {
        TEE_API_memcpy(&(socsink->sess), &(socsink->rtk_sess), lastpic->Caddr, getpic->Caddr, getpic->Csize);
      }

      if (p->pic_cmprs_mode) {
        if (lastpic->offsetTable_yaddr !=0 && p->pic_cmprs_hdr_y != 0) {
            TEE_API_memcpy(&(socsink->sess), &(socsink->rtk_sess), lastpic->offsetTable_yaddr, p->pic_cmprs_hdr_y, RTK_VO_COPY_LAST_FRAME_SIZEY);
        }

        if (lastpic->offsetTable_caddr !=0 && p->pic_cmprs_hdr_c != 0) {
          TEE_API_memcpy(&(socsink->sess), &(socsink->rtk_sess), lastpic->offsetTable_caddr, p->pic_cmprs_hdr_c, RTK_VO_COPY_LAST_FRAME_SIZEC);
        }
      } else {
        lastpic->offsetTable_yaddr = 0;
        lastpic->offsetTable_caddr = 0;
      }
    } else {
      lastpic->offsetTable_yaddr = 0;
      lastpic->offsetTable_caddr = 0;
    }

    vo_wrap_set_VO_SVPKeepLastFrame(socsink->m_voplane, lastpic, ENUM_VO_WRAP_KEEP_CUR_SVP_TYPE_SET_CUR); // 1 for set pic to VO.

    free(getpic);
    free(lastpic);
    free(tmp);
}
#endif

static void rtk_av_diagnostic(GstWesterosSink *sink, long long* first_pts_, long long vpts, long long apts, uint32_t* log_print_cnt_)
{
  GstWesterosSinkSoc *socsink = &sink->soc;
  bool av_back_to_sync = FALSE;
  long long first_pts = *first_pts_;
  uint32_t log_print_cnt = *log_print_cnt_;
  int vo_queue_cnt = socsink->v1_QueueIndexW - socsink->v1_QueueIndexR;
  vo_queue_cnt = (vo_queue_cnt < 0) ? (vo_queue_cnt + VO_BUF_NUM) : vo_queue_cnt;

  log_print_cnt++;

  if (vpts > 0 && apts > 0 && abs(vpts-apts) < 6000 && !socsink->av_in_sync) {
    socsink->av_in_sync = TRUE;
    av_back_to_sync = TRUE;
  }

  if (vpts != -1 && first_pts == -1) {
    first_pts = vpts;
  } else if (vpts == -1 && first_pts != -1){
    first_pts = -1;
  }
  if (first_pts != -1 && apts != -1 && ((vpts - first_pts) <= 90000) && !(log_print_cnt % 200)) {
    RTK_LOG_INFO(sink,"[VSINK] %sFirst_valid_PTS:%lld vpts:%lld apts:%lld VsinkFrame_cnt:%d vo_queue_cnt:%d%s",
                       (av_back_to_sync)?"[AV back to sync] ":"",first_pts, vpts, apts, socsink->frameCountW,
                       vo_queue_cnt, (vo_queue_cnt <= 3)?"(too low)":"");
    log_print_cnt = 0;
  } else if (socsink->hasAudio && abs(vpts-apts) > 90000 && socsink->av_in_sync) {
    if (vpts > 0 && apts >0) {
      socsink->av_in_sync =  FALSE;
      RTK_LOG_INFO(sink,"[VSINK] [AV out of sync] vpts:%lld apts:%lld VsinkFrame_cnt:%d vo_queue_cnt:%d%s",
                         vpts, apts, socsink->frameCountW, vo_queue_cnt,
                         (socsink->useImmediateOutput)?"":(vo_queue_cnt <= 3)?"(too low)":"");
      if (socsink->master_mode == MASTER_MODE_PCR) {
        if (vo_queue_cnt > 1 && abs(vpts - apts) > (DEFAULT_CLOCK_RESET_GAP * 9 / 100))
          gst_rtk_v1_sink_flush_and_alias_frame(sink);
      }
      log_print_cnt = 0;
    }
  } else if (!(log_print_cnt % 2000)) {
    RTK_LOG_INFO(sink,"[VSINK] %svpts:%lld apts:%lld VsinkFrame_cnt:%d vo_queue_cnt:%d%s",
                       (av_back_to_sync)?"[AV back to sync] ":"",vpts, apts, socsink->frameCountW,
                       vo_queue_cnt, (vo_queue_cnt <= 3)?"(too low)":"");
    log_print_cnt = 0;
  } else if (av_back_to_sync){
    RTK_LOG_INFO(sink,"[VSINK] [AV back to sync]First_valid_PTS:%lld vpts:%lld apts:%lld VsinkFrame_cnt:%d vo_queue_cnt:%d%s",
                       first_pts, vpts, apts, socsink->frameCountW, vo_queue_cnt,
                       (socsink->useImmediateOutput)?"":(vo_queue_cnt <= 3)?"(too low)":"");
  }

  *first_pts_ = first_pts;
  *log_print_cnt_ = log_print_cnt;

  return;
}

static void *vo_queue_loop(GstWesterosSink *sink)
{
    GstWesterosSinkSoc *socsink = &sink->soc;
    int hasVideo = 0;
    gint64 prev_pts = -1;
    long long vpts = 0;
    long long apts = 0;
    long long first_pts = -1;
    uint32_t log_print_cnt = 0;
    RTK_LOG_INFO(sink, "### START ###", __FILE__, __FUNCTION__, __LINE__);
    socsink->v1_QueueRunning = 1;
    while(1)
    {
        usleep(1000);

        rvsd_vo_getPlaybackPts(socsink->m_voplane, &vpts, &apts);
        rtk_av_diagnostic(sink, &first_pts, vpts, apts, &log_print_cnt);

        if (socsink->startplay == 1)
        {
            if (socsink->frameCountW > 0 && socsink->need_signal_firstframe && vpts != -1)
            {
                socsink->startplay = 0;
                socsink->eos = false;
                g_signal_emit (G_OBJECT (sink), g_signals[SIGNAL_FIRSTFRAME], 0, 2, NULL);
                RTK_LOG_INFO(sink, "[realtek] Send first-video-frame signal");
                socsink->need_signal_firstframe = false;
            }
        }
        if (sink->soc.needHdrNotify && socsink->HdrMetaYype != -1) {
            GST_INFO_OBJECT(sink, "notify hdmi HDR type:%d", socsink->HdrMetaYype);
            vo_wrap_notify_hdr_pb(socsink->HdrMetaYype);
            sink->soc.needHdrNotify = FALSE;
        }

        pthread_mutex_lock(&socsink->frame_mutex);
        //GST_DEBUG_OBJECT(sink, "[FrameMutex][+][%s]", __FUNCTION__);
        if (socsink->v1_QueueIndexR != socsink->v1_QueueIndexW)
        {
            GST_LOG_OBJECT(sink, "[socsink] R/W=%d/%d", socsink->v1_QueueIndexR, socsink->v1_QueueIndexW);
            if (socsink->hwavsync == TRUE && socsink->video_playing)
            {
                gint64 curr_pos = 0;
                gint64 curr_us = -1;
                rvsd_vo_getPlaybackPts(socsink->m_voplane, &vpts, &apts);
                curr_us = vpts * 100 / 9;
                if (curr_us >= 0) {
                  pthread_mutex_lock(&socsink->mute_mutex);
                  if (socsink->pts_share_mem != NULL) {
                      long long ref_pts = (vpts * 100)/9;
                      *((long long *)socsink->pts_share_mem) = ref_pts;
                  }

                  pthread_mutex_unlock(&socsink->mute_mutex);
                  LOCK(sink);
#ifndef USE_ABSOLUTE_POSITION
                  if (socsink->update_time != GST_CLOCK_TIME_NONE && socsink->first_time != GST_CLOCK_TIME_NONE)
                    sink->position = socsink->update_time - socsink->first_time;
                  else
                    sink->position = 0;
#else
                  if (socsink->update_time != GST_CLOCK_TIME_NONE)
                     sink->position = socsink->update_time;
#endif //#ifndef USE_ABSOLUTE_POSITION
                  sink->currentPTS = (curr_us * 1000LL) / (GST_SECOND / 90000LL);  // nanosecond to 90 Khz PTS
                  UNLOCK(sink);
                }
            }

            int status = vo_wrap_PLockGetStatus(socsink->m_voplane, socsink->v1_QueueIndexR);
            if (status == PLOCK_STATUS_UNLOCK)
            {
                gint64 tmp_diff = 0;

                if(socsink->v1_vobuf[socsink->v1_QueueIndexR].alias_frame == 0) {
                    gst_buffer_unref(socsink->v1_Buf[socsink->v1_QueueIndexR]);
                    socsink->v1_Buf[socsink->v1_QueueIndexR] = NULL;
                } else {
                    GST_INFO_OBJECT(sink, "[socsink] try to free alias frame with index: %d, v1_wIndex:%d",
                        socsink->v1_QueueIndexR, socsink->v1_vobuf[socsink->v1_QueueIndexR].v1_wIndex);

                    //free alias frame
                    if (socsink->v1_vobuf[socsink->v1_QueueIndexR].phys_addr != 0) {
                        vo_wrap_free_mem(socsink->m_voplane, &socsink->v1_vobuf[socsink->v1_QueueIndexR]);
                    }
                    memset(&(socsink->v1_vobuf[socsink->v1_QueueIndexR]), 0, sizeof(VOUT_BUFFER));

                    // to prevent free twice
                    if (socsink->aliasFrameBuf.v1_wIndex == socsink->v1_QueueIndexR) {
                        memset(&socsink->aliasFrameBuf, 0, sizeof(VOUT_BUFFER));
                    }
                }
                unsigned long long unlocked_pts = 0;
                socsink->v1_vobuf[socsink->v1_QueueIndexR];
                if(socsink->v1_vobuf[socsink->v1_QueueIndexR].meta_type == METADATA_PRIVATE_RTK_DATA) {
                    private_rtk_data *p = (private_rtk_data*) SystemMemory_GetVirAddr(socsink->v1_vobuf[socsink->v1_QueueIndexR].meta_handle);
                    unlocked_pts = p->pts[0];
                } else if (socsink->v1_vobuf[socsink->v1_QueueIndexR].meta_type == METADATA_VRPC_DVO_INFO) {
                    unlocked_pts = socsink->v1_vobuf[socsink->v1_QueueIndexR].pts;
                }

                if (socsink->underflowTolerance < RTK_UNDERFLOW_TOLERANCE_FRAME && socsink->underflowPTS != unlocked_pts)
                {
                    socsink->underflowPTS = unlocked_pts;
                    socsink->underflowTolerance++;
                    socsink->underflow_cnt = 0;
                }
                vo_wrap_PLockSetStatus(socsink->m_voplane, socsink->v1_QueueIndexR, PLOCK_STATUS_INIT);
                socsink->v1_QueueIndexR = (socsink->v1_QueueIndexR + 1) % VO_BUF_NUM;
                socsink->underflow_cnt = 0;
                socsink->frameCountR ++;
#ifdef RTK_USE_BUFLOCK
                if (socsink->frameCountW > RTK_MIN_FRAME_COUNT) {
                    for (int i = 0; i < MAX_BUFLOCKS; i++) {
                        if (socsink->Blid[i] != -1) {
                            GST_INFO_OBJECT(sink, "release locked buf blid:%d", socsink->Blid[i]);
                            buflock_Free(socsink->Buflock[i], socsink->Blid[i]);
                            socsink->Blid[i] = -1;
                        }
                    }
                }
#endif//RTK_USE_BUFLOCK

#if 1
                long long vrpts, arpts;
                vo_wrap_getAVpts(socsink->m_voplane, &vpts, &apts, &vrpts, &arpts);
                if(vpts != -1){
                    socsink->update_time = gst_util_uint64_scale(vpts, GST_MSECOND/10, CLOCK_BASE);
                    if(socsink->first_time == (gint64)GST_CLOCK_TIME_NONE)
                        socsink->first_time = socsink->update_time;
                }
                //printf("### videoSystemPTS : %lld (%f)   audioSystemPTS : %lld (%f) gst_time %lld\n",
                //        vpts, (float)vpts/90000.0f, apts, (float)apts/90000.0f, socsink->update_time);
#endif

                pthread_mutex_unlock(&socsink->frame_mutex);
                //emit signal should not inside frame_mutex or it will cause a deadlock
                if (socsink->startplay == 1)
                {
                    if (socsink->frameCountW > RTK_MIN_FRAME_COUNT)
                    {
                        socsink->startplay = 0;
                        socsink->eos = false;
                        g_signal_emit (G_OBJECT (sink), g_signals[SIGNAL_FIRSTFRAME], 0, 2, NULL);

                        RTK_LOG_INFO(sink, "[realtek] Send first-video-frame signal");
                    }
                }
                pthread_mutex_lock(&socsink->frame_mutex);

                if (socsink->frameCountR >= RTK_MIN_FRAME_COUNT)
                {
                    tmp_diff = vpts - socsink->pts_list[(socsink->frameCountR - 1) % RTK_MIN_FRAME_COUNT];

                    if(socsink->avg_diff_us && abs(tmp_diff) > socsink->avg_diff_us * 2)
                        socsink->underflowTolerance = 0; //pts jump case, restarting without EOS

                    for (int i = 1; i < RTK_MIN_FRAME_COUNT; i++)
                    {
                        int pos = socsink->frameCountR - i;
                        tmp_diff += (socsink->pts_list[pos % RTK_MIN_FRAME_COUNT] - socsink->pts_list[(pos - 1) % RTK_MIN_FRAME_COUNT]);
                    }
                }

                socsink->avg_diff_us = tmp_diff / RTK_MIN_FRAME_COUNT;
                socsink->pts_list[socsink->frameCountR % RTK_MIN_FRAME_COUNT] = vpts;

            }
        }
        //GST_DEBUG_OBJECT(sink, "[FrameMutex][-][%s]", __FUNCTION__);
        pthread_mutex_unlock(&socsink->frame_mutex);

        if (prev_pts != sink->currentPTS && socsink->frameCountW > 0 && socsink->v1_QueueRunning)
        {
            LOCK(sink);
            if (sink->timeCodePresent && sink->enableTimeCodeSignal)
                sink->timeCodePresent(sink, sink->position, g_signals[SIGNAL_TIMECODE]);
            prev_pts = sink->currentPTS;
            UNLOCK(sink);
        }

        //emit SIGNAL_UNDERFLOW signal should not inside frame_mutex or it will cause a deadlock
        if (socsink->flush != TRUE && !sink->flushStarted && socsink->video_playing && socsink->eos == FALSE && socsink->needDefaultMaster == FALSE)
        {
            socsink->underflow_cnt++;
            long long vpts = 0;
            long long apts = 0;
            rvsd_vo_getPlaybackPts(socsink->m_voplane, &vpts, &apts);

            if(socsink->frameCountR > RTK_UNDERFLOW_TOLERANCE_FRAME && socsink->v1_QueueIndexR == socsink->v1_QueueIndexW - 1)
            {
                if (socsink->avg_diff_us && (socsink->underflow_cnt > (42 * RTK_UNDERFLOW_MULTIPLE)))  // ms, 42 is for 24 fps, not using avg_diff_us for avoid pts error
                {

                    if((vpts > 0) && (socsink->underflowPTS > 0) && (socsink->underflowPTS != vpts))
                    {
                        g_signal_emit (G_OBJECT(sink), g_signals[SIGNAL_UNDERFLOW], 0, 0, 0);
                        RTK_LOG_WARNING(sink, "[socsink] SIGNAL_UNDERFLOW, underflow_cnt=%d, frameCountW=%d, frameCountR=%d, avg_diff_us=%lld",
                            socsink->underflow_cnt, socsink->frameCountW, socsink->frameCountR, socsink->avg_diff_us);

                        socsink->underflowPTS = vpts;
                        socsink->underflowTolerance = 0;
                    }
                    socsink->underflow_cnt = 0;
                }
            }
            else if(socsink->frameCountR < RTK_UNDERFLOW_TOLERANCE_FRAME && socsink->frameCountR != 0)
            {   //emit SIGNAL_UNDERFLOW signal, when app layer do not feed data more than 1 second on initial phase.
                if((socsink->underflow_cnt > 1000))
                {
                    g_signal_emit (G_OBJECT(sink), g_signals[SIGNAL_UNDERFLOW], 0, 0, 0);
                    RTK_LOG_WARNING(sink, "[socsink] SIGNAL_UNDERFLOW_2, underflow_cnt=%d, frameCountW=%d, frameCountR=%d, avg_diff_us=%lld",
                        socsink->underflow_cnt, socsink->frameCountW, socsink->frameCountR, socsink->avg_diff_us);

                    socsink->underflowPTS = vpts;
                    socsink->underflowTolerance = 0;
                    socsink->underflow_cnt = 0;
                }
            }
        }


        if (socsink->v1_QueueRunning == 0)
        {
            break;
        }
    }

    RTK_LOG_INFO(sink, "### END ###\n", __FILE__, __FUNCTION__, __LINE__);
    RTK_LOG_INFO(sink, "### [fr_%d] R/W=%d/%d ###", socsink->frameCountW, socsink->v1_QueueIndexR, socsink->v1_QueueIndexW);
    return 0;
}

/*
 * Get the hdmi output resolution
 */
static void
gst_rtk_v1_sink_get_output_window(ST_RECTANGLE *pRect)
{
    vo_wrap_get_mixer_window(pRect);

    if (pRect->width == 0 || pRect->height == 0) {
        pRect->width = RTK_V1_SINK_MAX_WIDTH;
        pRect->height = RTK_V1_SINK_MAX_HEIGHT;
    }
}

void gst_westeros_sink_soc_class_init(GstWesterosSinkClass *klass)
{
   //GstElementClass *gobject_class= (GstElementClass *) klass;
   GObjectClass *gobject_class= (GObjectClass *) klass;
   GstBaseSinkClass *gstbasesink_class= (GstBaseSinkClass *) klass;

   gstbasesink_class->preroll= GST_DEBUG_FUNCPTR(gst_westeros_sink_soc_preroll);

   g_object_class_install_property (gobject_class, PROP_TV_MODE,
       g_param_spec_enum ("tvmode", "TV mode",
           "The television mode",
           GST_TYPE_TV_MODE, VO_WRAP_RES_720P60,
           G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

   g_object_class_install_property (gobject_class, PROP_PLANE,
       g_param_spec_enum ("plane", "Plane",
           "The Pixel Plane to be used",
           GST_TYPE_PLANE, PLANE_V1,
           G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

#ifdef RTK_SINK_RECTANGLE
   g_object_class_install_property (gobject_class, PROP_RECTANGLE,
       g_param_spec_string ("rectangle", "Rectangle",
           "A string for video rectangle within \"x,y,width,height\" format",
           NULL,
           G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
#endif


   g_object_class_install_property (gobject_class, PROP_FLUSH_REPEAT_FRAME,
       g_param_spec_boolean ("flush-repeat-frame", "flush-repeat-frame",
           "Keep displaying the last frame rather than a black one whilst flushing",
           FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

   g_object_class_install_property (gobject_class, PROP_CURRENT_PTS,
       g_param_spec_int64 ("currentPTS", "current PTS",
           "current PTS",
           -1, G_MAXINT64, -1,
           G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

   g_object_class_install_property (gobject_class, PROP_HWAVSYNC_FD,
       g_param_spec_int ("hwavsync-fd", "hwavsync-fd",
           "get HW AVsync fd", 0, G_MAXINT, DEFAULT_HWAVSYNC_FD,
           G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

   g_object_class_install_property (gobject_class, PROP_ENABLE_HWAVSYNC,
       g_param_spec_boolean ("hwavsync", "hwavsync",
           "Just Hack flag let gst-launch to enter HW avsync mode. It isn't really control HW avsync flow by your gst AP.",
           DEFAULT_ENABLE_HWAVSYNC, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

   g_object_class_install_property (gobject_class, PROP_INTER_FRAME_DELAY,
       g_param_spec_boolean ("inter-frame-delay", "inter-frame-delay",
           "Enables fixed frame rate mode",
           FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

   g_object_class_install_property (gobject_class, PROP_SLOW_MODE_RATE,
       g_param_spec_int ("slow-mode-rate", "slow-mode-rate",
           "slow mode rate in normalised form(-20000 < 0 <=20000)",
           -20000, 20000, 0,
           G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

   g_object_class_install_property (gobject_class, PROP_CONTENT_FRAME_RATE,
       g_param_spec_float ("contentframerate", "content frame rate",
           "content frame rate",
           G_MINFLOAT, G_MAXFLOAT, 30.0,
           G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

   g_object_class_install_property (gobject_class, PROP_STEPFRAME,
       g_param_spec_boolean ("stepframe", "Frame step",
           "Step forward/backward one frame at a time. In case of backward frame step, stream will be provided GOP reversed",
           FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

   g_object_class_install_property (gobject_class, PROP_FRAME_STEP_ON_PREROLL,
     g_param_spec_boolean ("frame-step-on-preroll",
                           "frame step on preroll",
                           "allow frame stepping on preroll into pause", FALSE, G_PARAM_READWRITE));

   g_object_class_install_property (gobject_class, PROP_MUTE,
       g_param_spec_boolean ("Mute", "Mute",
           "Mute",
           FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

   g_object_class_install_property (gobject_class, PROP_WINDOW_SHOW,
       g_param_spec_boolean ("show-video-window",
                           "make video window visible",
                           "true: visible, false: hidden", TRUE, G_PARAM_WRITABLE));

   g_object_class_install_property (gobject_class, PROP_FULL_RANGE_MODE,
       g_param_spec_boolean ("full-range", "Full Range Mode",
           "Set full-range mode to video output",
           DEFAULT_FULL_RANGE_MODE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

   g_object_class_install_property (gobject_class, PROP_FORCE_ASPECT_RATIO,
     g_param_spec_boolean ("force-aspect-ratio",
                           "force aspect ratio",
                           "When enabled scaling respects source aspect ratio",
                           DEFAULT_PROP_FORCE_ASPECT_RATIO, G_PARAM_READWRITE));

   g_object_class_install_property (gobject_class, PROP_ZOOM,
     g_param_spec_uint ("zoom","zoom","zoom",0 , 1, DEFAULT_PROP_ZOOM,
       (GParamFlags)(G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS )));

   g_object_class_install_property (gobject_class, PROP_ZOOM_MODE,
     g_param_spec_uint ("zoom-mode",
                       "zoom-mode",
                       "Set zoom mode",
                       0 , DEFAULT_PROP_ZOOM_MODE_MAX, DEFAULT_PROP_ZOOM_MODE, G_PARAM_READWRITE));

   g_object_class_install_property (gobject_class, PROP_BRING_TO_FRONT,
     g_param_spec_enum ("bring-to-front", "Bring V1 to front.", "Whether to bring V1 to front during playback.",
       GST_TYPE_BTF_MODE, BTF_FEATURE_DISABLE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

   g_object_class_install_property (gobject_class, PROP_ENABLE_OSD,
     g_param_spec_enum ("enable-osd", "Enable OSD 1", "Whether to enable OSD 1 during playback.",
       GST_TYPE_OSD_MODE, OSDMODE_FEATURE_DISABLE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

   g_object_class_install_property (gobject_class, PROP_VIDEO_DECODE,
     g_param_spec_pointer ("videodecoder","video decode instance","Video decoder instance in use",G_PARAM_READABLE));

   g_object_class_install_property (gobject_class, PROP_MASTER,
     g_param_spec_string ("avsync-master", "Master Mode", "master mode for av sync (pcr|iptv)",
       NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

   g_object_class_install_property (gobject_class, PROP_FREERUN_THRESHOLD,
     g_param_spec_uint ("freerun-threshold", "Freerun threshold", "if a/v pts diff bigger than threshold, a/v will be free-run",
        DEFAULT_FREERUN_THRESHOLD_MIN, DEFAULT_FREERUN_THRESHOLD_MAX, DEFAULT_FREERUN_THRESHOLD, G_PARAM_READWRITE));

#if GST_CHECK_VERSION(1, 18, 0)
   g_object_class_override_property (gobject_class, PROP_STATS, "stats");
#else
   g_object_class_install_property (gobject_class, PROP_STATS,
     g_param_spec_boxed ("stats", "Statistics",
       "Sink Statistics", GST_TYPE_STRUCTURE,
        (GParamFlags)(G_PARAM_READABLE | G_PARAM_STATIC_STRINGS)));
#endif

   klass->canUseResMgr= 0;
   {
#ifdef USE_WESTEROS_SOC_ERM
     const char *env= getenv("WESTEROS_SINK_USE_ESSRMGR");
     if ( env && (atoi(env) != 0) )
     {
       klass->canUseResMgr= 1;
     }
#endif
     if (klass->canUseResMgr == 0)
     {
       g_object_class_install_property (gobject_class, PROP_RTK_RES_USAGE,
         g_param_spec_uint ("res-usage",
                            "rtk res-usage",
                            "using this property for res-usage setting when WESTEROS_SINK_USE_ESSRMGR is false",
                            0, DEFAULT_USAGE, DEFAULT_USAGE,
                            (GParamFlags)(G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS)));
     }
   }
   fprintf(stderr, "gst_rtk_westerossink: enabling Essos RMgr: %d\n", klass->canUseResMgr);

   g_signals[SIGNAL_FIRSTFRAME]= g_signal_new( "first-video-frame-callback",
                                               G_TYPE_FROM_CLASS(GST_ELEMENT_CLASS(klass)),
                                               (GSignalFlags) (G_SIGNAL_RUN_LAST),
                                               0,    // class offset
                                               NULL, // accumulator
                                               NULL, // accu data
                                               g_cclosure_marshal_VOID__UINT_POINTER,
                                               G_TYPE_NONE,
                                               2,
                                               G_TYPE_UINT,
                                               G_TYPE_POINTER );
   g_signals[SIGNAL_PTSERROR]= g_signal_new( "pts-error-callback",
                                              G_TYPE_FROM_CLASS(GST_ELEMENT_CLASS(klass)),
                                              (GSignalFlags) (G_SIGNAL_RUN_LAST),
                                              0,    // class offset
                                              NULL, // accumulator
                                              NULL, // accu data
                                              g_cclosure_marshal_VOID__UINT_POINTER,
                                              G_TYPE_NONE,
                                              2,
                                              G_TYPE_UINT,
                                              G_TYPE_POINTER );
   g_signals[SIGNAL_UNDERFLOW]= g_signal_new( "buffer-underflow-callback",
                                              G_TYPE_FROM_CLASS(GST_ELEMENT_CLASS(klass)),
                                              (GSignalFlags) (G_SIGNAL_RUN_LAST),
                                              0,    // class offset
                                              NULL, // accumulator
                                              NULL, // accu data
                                              g_cclosure_marshal_VOID__UINT_POINTER,
                                              G_TYPE_NONE,
                                              2,
                                              G_TYPE_UINT,
                                              G_TYPE_POINTER );
   //g_signal_new("first-video-frame", G_TYPE_FROM_CLASS(klass), G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
#ifdef USE_GST_VIDEO
   g_signals[SIGNAL_TIMECODE]= g_signal_new( "timecode-callback",
                                              G_TYPE_FROM_CLASS(GST_ELEMENT_CLASS(klass)),
                                              (GSignalFlags) (G_SIGNAL_RUN_LAST),
                                              0,    /* class offset */
                                              NULL, /* accumulator */
                                              NULL, /* accu data */
                                              NULL,
                                              G_TYPE_NONE,
                                              3,
                                              G_TYPE_UINT, /* hours */
                                              G_TYPE_UINT, /* minutes */
                                              G_TYPE_UINT  /* seconds */
                                             );
#endif

   g_object_class_install_property (gobject_class, PROP_IMMEDIATE_OUTPUT,
     g_param_spec_boolean ("immediate-output",
                           "immediate output mode",
                           "Decoded frames are output with minimum delay. B frames are dropped.", FALSE, G_PARAM_READWRITE));
}

gboolean gst_westeros_sink_soc_init( GstWesterosSink *sink )
{
    RTK_LOG_DEBUG(sink, "gst_rtk_westerossink_init");
    gst_rtk_v1_sink_reset_initial_value(sink);

    sink->processPadEvent= processEventSinkSoc;
    sink->acquireResources= sinkAcquireVideo;
    sink->releaseResources= sinkReleaseVideo;
    return TRUE;
}

void gst_westeros_sink_soc_term( GstWesterosSink *sink )
{
    GstWesterosSinkSoc *socsink = &sink->soc;
  #ifndef GST_DISABLE_GST_DEBUG
    RTK_LOG_DEBUG(sink, "finalize");
  #endif /* GST_DISABLE_GST_DEBUG */

  #ifdef V1SINK_DUMP_FRAME
    close (fd_dump);
  #endif
    if (socsink->vo_resource_init) {
    /* clean up object here */
        vo_wrap_close (socsink->m_voplane);

        if (socsink->pts_share_mem != NULL) {
            munmap(socsink->pts_share_mem, 8);
            socsink->pts_share_mem = NULL;
        }

        if (socsink->pts_share_fd >= 0) {
            close(socsink->pts_share_fd);
           socsink->pts_share_fd = -1;
       }
#if RTK_USE_BUFLOCK
       for (int i = 0; i < MAX_BUFLOCKS; i++) {
         buflock_destroy(socsink->Buflock[i]);
       }
#endif//RTK_USE_BUFLOCK
    //G_OBJECT_CLASS (gst_rtk_v1_sink_parent_class)->finalize (object);

#if defined(ENABLE_TEE_DRM_FLOW)
      TEE_API_Finalize(&(socsink->ctx), &(socsink->sess), &(socsink->rtk_sess));
#endif //defined(ENABLE_TEE_DRM_FLOW)
   }
   socsink->vo_resource_init = FALSE;
}

void gst_westeros_sink_soc_set_property(GObject *object, guint prop_id, const GValue *value, GParamSpec *pspec)
{
    GstWesterosSink *sink = GST_WESTEROS_SINK(object);
    GstWesterosSinkSoc *socsink = &sink->soc;

    GST_DEBUG_OBJECT (sink, "set_property");

    switch (prop_id) {
      case PROP_TV_MODE:
      {
        GstWesterosSinkTvMode tvmode = g_value_get_enum(value);
        if (tvmode != socsink->tv_mode) {
          //change output resolution
          socsink->tv_mode = tvmode;
          GST_DEBUG_OBJECT (sink, "tvmode: %d", tvmode);
          vo_wrap_set_tv_resolution(tvmode);
        }
        break;
      }
      case PROP_PLANE:
        gst_rtk_v1_sink_property_set_output_plane(sink, g_value_get_enum(value));
        break;
#ifdef RTK_SINK_RECTANGLE
      case PROP_RECTANGLE:
      {
        gint x, y, w, h;
        gchar **params;
        guint len = 0;
        const gchar *s = g_value_get_string(value);
        if ((s == NULL) || (strlen(s) == 0)) {
          return;
        }
        params = g_strsplit (s, ",", -1);
        len = g_strv_length (params);
        GST_LOG_OBJECT(sink, "we get %d params\n", len);

        if (len < 4) {
          GST_WARNING_OBJECT(sink, "rectangle params not enough!\n");
          g_strfreev (params);
          return;
        }
        //get x/y/w/h
        GST_LOG_OBJECT(sink, "params[0]: %s\n", params[0]);
        x = atoi(params[0]);
        GST_LOG_OBJECT(sink, "params[1]: %s\n", params[1]);
        y = atoi(params[1]);
        GST_LOG_OBJECT(sink, "params[2]: %s\n", params[2]);
        w = atoi(params[2]);
        GST_LOG_OBJECT(sink, "params[3]: %s\n", params[3]);
        h = atoi(params[3]);

        g_strfreev (params);
        gst_rtk_v1_sink_property_set_output_rectangle(sink, x, y, w, h);
        break;
      }
#endif
      case PROP_FLUSH_REPEAT_FRAME:
      {
        gboolean keeplastframe = g_value_get_boolean (value);
        GST_LOG_OBJECT (sink, "set_keeping_last_frame=0x%x", keeplastframe);
        socsink->keep_last_frame = keeplastframe;
        break;
      }
  //    case PROP_CURRENT_PTS:
      case PROP_INTER_FRAME_DELAY:
      {
        gboolean enableFixedframe = g_value_get_boolean (value);
        GST_LOG_OBJECT (sink, "set_fixed_frame_rate");
        if (enableFixedframe != socsink->fixed_frame_rate) {
          //TODO: implement if fixedframe value different.
          socsink->fixed_frame_rate = enableFixedframe;
        }
        break;
      }
      case PROP_SLOW_MODE_RATE:
        //not require so far.
        break;
  //    case PROP_CONTENT_FRAME_RATE:
      case PROP_STEPFRAME:
      {
        gboolean enableStepframe = g_value_get_boolean (value);
        GST_LOG_OBJECT (sink, "set_stepframe");
        if (enableStepframe != socsink->stepframe) {
          //TODO: implement if stepframe value different.
          socsink->stepframe = enableStepframe;
        }
        break;
      }
      case PROP_FRAME_STEP_ON_PREROLL:
      {
        gboolean enableStepframe = g_value_get_boolean (value);
        long long vpts = 0;
        long long apts = 0;
        gboolean video_ready = FALSE;
        int wait_video_cnt = 0;
        GST_LOG_OBJECT (sink, "set_stepframe_on_preroll:%d",enableStepframe?1:0);
        if (enableStepframe != socsink->frameStepOnPreroll) {
          if(enableStepframe == TRUE && socsink->frameStepOnPreroll == FALSE)
          {
            gst_buffer_ref(socsink->prerollBuffer);
            gst_westeros_sink_soc_render( sink, socsink->prerollBuffer);
            gst_buffer_unref(socsink->prerollBuffer);
            socsink->prerollBuffer = NULL;
            socsink->alwaysPreroll = TRUE;
            LOCK(sink);
            while(!video_ready) {
              rvsd_vo_getPlaybackPts(socsink->m_voplane, &vpts, &apts);
              if (vpts < 0) {
                wait_video_cnt++;
                if(socsink->master_mode!=MASTER_MODE_PCR) {
                  gst_rtk_v1_sink_set_avsync_mode( sink, VIDEO_MASTER);
                  GST_INFO_OBJECT(sink, "step:video master");
                }
                usleep(WAIT_AUDIO_INTERVAL);
                if (wait_video_cnt % 500 == 0)
                  GST_DEBUG_OBJECT(sink, "step, waiting video: video=%lld, audio=%lld, wait_cnt=%u", vpts, apts, wait_video_cnt);
                if (wait_video_cnt < WAIT_AUDIO_MAX_CNT)
                  continue;
                else {
                  GST_WARNING_OBJECT(sink, "step, wait video(%lld) start timeout",vpts);
                  video_ready = TRUE;
                }
              } else
                video_ready = TRUE;
            }

            if (!socsink->video_playing)
            {
              vo_wrap_set_VO_Pause(sink->soc.m_voplane);
              if (socsink->master_mode!=MASTER_MODE_PCR)
              {
                GST_INFO_OBJECT(sink, "Set Master mode to video master");
                gst_rtk_v1_sink_set_avsync_mode( sink, VIDEO_MASTER);
              }
            }
            UNLOCK(sink);
          }
          socsink->frameStepOnPreroll = enableStepframe;
        }
        break;
      }
      case PROP_MUTE:
      {
        gboolean mute = g_value_get_boolean (value);
        GST_LOG_OBJECT (sink, "set_mute %d", mute);
        RTK_DEF_LOG("[westerossink] set_mute %d", mute);

        pthread_mutex_lock(&socsink->mute_mutex);
        if (mute != socsink->mute) {
          int res = 0;
          if (mute) {
            res = vo_wrap_v1_hide(socsink->m_voplane);
          } else {
            res = vo_wrap_v1_show(socsink->m_voplane);
#if RTK_USE_FW_KEEP_FRAME
            if(socsink->needSetVORun) {
                vo_wrap_set_VO_Run(socsink->m_voplane);
                socsink->needSetVORun = 0;
            }
#endif
          }
          if (res == 0) {
              socsink->mute = mute;
          }
        }
        pthread_mutex_unlock(&socsink->mute_mutex);
        break;
      }
      case PROP_WINDOW_SHOW:
      {
        gboolean mute = !g_value_get_boolean (value);
        GST_LOG_OBJECT (sink, "window show %d", !mute);
        RTK_DEF_LOG("[westerossink] window show %d, %d", !mute, socsink->mute);

        pthread_mutex_lock(&socsink->mute_mutex);
        if (mute != socsink->mute) {
          int res = 0;
          if (mute) {
            res = vo_wrap_v1_hide(socsink->m_voplane);
          } else {
            res = vo_wrap_v1_show(socsink->m_voplane);
#if RTK_USE_FW_KEEP_FRAME
            if(socsink->needSetVORun) {
                vo_wrap_set_VO_Run(socsink->m_voplane);
                socsink->needSetVORun = 0;
            }
#endif
          }
          if (res == 0) {
              socsink->mute = mute;
          }
        }
        pthread_mutex_unlock(&socsink->mute_mutex);
        break;
      }
      case PROP_ZOOM:
      {
        VO_WRAP_RESCALE_MODE rescale = VO_WRAP_RESCALE_MODE_FULL_SCALE;

        socsink->zoom = g_value_get_uint (value);
        GST_INFO_OBJECT (sink, "set_zoom :%u (force-aspect-ratio?%s)"
            ,socsink->zoom,(socsink->forceAspectRatio == TRUE)?"TRUE":"FALSE");

        if (0 == socsink->zoom) {
          rescale = VO_WRAP_RESCALE_MODE_KEEP_AR_AUTO;
        } else if ( 1 == socsink->zoom) {
          rescale = VO_WRAP_RESCALE_MODE_FULL_SCALE;
        }
        if (socsink->forceAspectRatio)
            rescale = VO_WRAP_RESCALE_MODE_KEEP_AR_AUTO;

        GST_INFO_OBJECT (sink, "[PROP_ZOOM] zoom: %u , rescale: %d", socsink->zoom, rescale);
        vo_wrap_v1_set_rescale(socsink->m_voplane, rescale);
        break;
      }
      case PROP_ZOOM_MODE:
      {
        VO_WRAP_RESCALE_MODE rescale = VO_WRAP_RESCALE_MODE_FULL_SCALE;
        guint zoom_mode = 0;

        zoom_mode = g_value_get_uint (value);
        GST_INFO_OBJECT (sink, "set zoom mode :%u (force-aspect-ratio?%s)"
            ,zoom_mode,(socsink->forceAspectRatio == TRUE)?"TRUE":"FALSE");

        if (0 == zoom_mode) {
          rescale = VO_WRAP_RESCALE_MODE_FULL_SCALE;
          socsink->zoom = 1;
        } else if ( 1 == zoom_mode) {
          rescale = VO_WRAP_RESCALE_MODE_KEEP_AR_AUTO;
          socsink->zoom = 0;
        }
        if (socsink->forceAspectRatio)
            rescale = VO_WRAP_RESCALE_MODE_KEEP_AR_AUTO;

        GST_INFO_OBJECT (sink, "[PROP_ZOOM_MODE] zoom: %u , rescale: %d", socsink->zoom, rescale);
        vo_wrap_v1_set_rescale(socsink->m_voplane, rescale);
        break;
      }
      case PROP_FORCE_ASPECT_RATIO:
        socsink->forceAspectRatio = g_value_get_boolean(value);
        GST_INFO_OBJECT(sink,"set force-aspect-ratio : %s",(socsink->forceAspectRatio == TRUE)?"TRUE":"FALSE");
        if ( socsink->forceAspectRatio )
         vo_wrap_v1_set_rescale(socsink->m_voplane, VO_WRAP_RESCALE_MODE_KEEP_AR_AUTO);
       break;
      case PROP_HWAVSYNC_FD:
        break;
      case PROP_ENABLE_HWAVSYNC:
        socsink->hwavsync = g_value_get_boolean (value);
        break;
      case PROP_FULL_RANGE_MODE:
        socsink->full_range = g_value_get_boolean (value);
        break;
      case PROP_BRING_TO_FRONT:
        socsink->bring_to_front = g_value_get_enum (value);
        break;
      case PROP_ENABLE_OSD:
        socsink->enable_osd = g_value_get_enum (value);
        break;
      case PROP_MASTER:
      {
        const gchar *s = g_value_get_string (value) ;
        GST_INFO_OBJECT(sink, "PROP_MASTER: %s\n", s);
        if( g_strcmp0 (s, "pcr") == 0 )
          socsink->master_mode = MASTER_MODE_PCR;
        else if( g_strcmp0 (s, "iptv") == 0 )
          socsink->master_mode = MASTER_MODE_IPTV;
        else
          socsink->master_mode = DEFAULT_MASTER;
        break;
      }
      case PROP_FREERUN_THRESHOLD:
      {
        socsink->videoFreeRunThreshold = g_value_get_uint(value);
        GST_INFO_OBJECT(sink, "videoFreeRunThreshold: %d\n", socsink->videoFreeRunThreshold);
        vo_wrap_set_videoFreeRunThreshold(socsink->m_voplane, socsink->videoFreeRunThreshold*90000); //1 sec =90K
        break;
      }
      case PROP_RTK_RES_USAGE:
      {
        sink->resUsage = g_value_get_uint(value);
        RTK_LOG_INFO(sink, "res-usage set %d", sink->resUsage);
        break;
      }
      case PROP_IMMEDIATE_OUTPUT:
      {
        sink->soc.useImmediateOutput = g_value_get_boolean(value);
        RTK_DEF_LOG("[westerossink] useImmediateOutput: %d", sink->soc.useImmediateOutput);
        break;
      }
      default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
        break;
    }
}

void gst_westeros_sink_soc_get_property(GObject *object, guint prop_id, GValue *value, GParamSpec *pspec)
{
   GstWesterosSink *sink = GST_WESTEROS_SINK(object);
   GstWesterosSinkSoc *socsink = &sink->soc;

   GST_DEBUG_OBJECT (sink, "get_property");

   switch (prop_id) {
     case PROP_TV_MODE:
       socsink->tv_mode = vo_wrap_get_tv_resolution();
       g_value_set_enum(value, socsink->tv_mode);
       break;
     case PROP_PLANE:
       g_value_set_enum(value, socsink->vo_plane);
       break;
#ifdef RTK_SINK_RECTANGLE
     case PROP_RECTANGLE:
     {
       gchar *str = g_strdup_printf("%d,%d,%d,%d", socsink->x, socsink->y, socsink->width, socsink->height);
       g_value_set_string (value, str);
       g_free(str);
     }
       break;
#endif
     case PROP_FLUSH_REPEAT_FRAME:
       g_value_set_boolean(value, socsink->keep_last_frame);
       break;
     case PROP_CURRENT_PTS:
       g_value_set_int64(value, vo_wrap_get_current_pts(socsink->m_voplane));
       break;
     case PROP_INTER_FRAME_DELAY:
       g_value_set_boolean(value, socsink->fixed_frame_rate);
       break;
     case PROP_SLOW_MODE_RATE:
       //not require so far.
       break;
     case PROP_CONTENT_FRAME_RATE:
       g_value_set_float(value, socsink->fps);
       break;
     case PROP_STEPFRAME:
     break;
     case PROP_FRAME_STEP_ON_PREROLL:
       g_value_set_boolean(value, socsink->frameStepOnPreroll);
       break;
     case PROP_MUTE:
       g_value_set_boolean(value, socsink->mute);
       break;
     case PROP_WINDOW_SHOW:
       g_value_set_boolean(value, !socsink->mute);
       break;
     case PROP_ZOOM:
     case PROP_ZOOM_MODE:
       //not require so far.
       break;
     case PROP_HWAVSYNC_FD:
         socsink->hw_avsync_fd = vo_wrap_get_hw_avsync_ionSharedFd(socsink->m_voplane);
       RTK_DEF_LOG("[realtek] got HW AVSync FD %d @@@@@@@", socsink->hw_avsync_fd);
       g_value_set_int(value, socsink->hw_avsync_fd);
       break;
     case PROP_ENABLE_HWAVSYNC:
       g_value_set_boolean(value, socsink->hwavsync);
       break;
     case PROP_FULL_RANGE_MODE:
       g_value_set_boolean(value, socsink->full_range);
       break;
     case PROP_BRING_TO_FRONT:
       socsink->bring_to_front = g_value_get_enum(value);
       break;
     case PROP_ENABLE_OSD:
       socsink->enable_osd = g_value_get_enum(value);
       break;
     case PROP_VIDEO_DECODE:
       g_value_set_pointer(value, sink);
       break;
     case PROP_MASTER:
      switch(socsink->master_mode)
      {
        case MASTER_MODE_PCR:
          g_value_set_string (value, "pcr");
          break;
        case MASTER_MODE_IPTV:
          g_value_set_string (value, "iptv");
          break;
        default:
          break;
      }
      break;
      case PROP_FREERUN_THRESHOLD:
        g_value_set_int(value, socsink->videoFreeRunThreshold);
        break;
      case PROP_RTK_RES_USAGE:
        break;
     case PROP_IMMEDIATE_OUTPUT:
       g_value_set_boolean(value, sink->soc.useImmediateOutput);
       break;
     case PROP_STATS:
     {
       LOCK(sink);
       g_value_take_boxed( value, wstSinkGetStats(sink) );
       UNLOCK(sink);
     }
       break;
     default:
       G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
       break;
   }
}

void gst_westeros_sink_soc_registryHandleGlobal( GstWesterosSink *sink,
                                 struct wl_registry *registry, uint32_t id,
		                           const char *interface, uint32_t version)
{
   WESTEROS_UNUSED(version);
   int len;

   len= strlen(interface);

   if ((len==5) && (strncmp(interface, "wl_sb", len) == 0))
   {
      sink->soc.sb= (struct wl_sb*)wl_registry_bind(registry, id, &wl_sb_interface, 1);
      GST_DEBUG_OBJECT(sink, "westeros-sink-soc: registry: sb %p", (void*)sink->soc.sb);
      wl_proxy_set_queue((struct wl_proxy*)sink->soc.sb, sink->queue);
      wl_sb_add_listener(sink->soc.sb, &sbListener, sink);
      GST_DEBUG_OBJECT(sink, "westeros-sink-soc: registry: done add sb listener");
   }
}

void gst_westeros_sink_soc_registryHandleGlobalRemove( GstWesterosSink *sink,
                                 struct wl_registry *registry,
			                        uint32_t name)
{
   WESTEROS_UNUSED(sink);
   WESTEROS_UNUSED(registry);
   WESTEROS_UNUSED(name);
}

gboolean gst_westeros_sink_soc_null_to_ready( GstWesterosSink *sink, gboolean *passToDefault )
{
    WESTEROS_UNUSED(passToDefault);
#if defined(ENABLE_V2_PLANE)
    if (sink->resUsage == 0)
      gst_rtk_v1_sink_property_set_output_plane(sink, PLANE_V2);
    else
#endif
    {
      if (gst_rtk_video_plane_init(sink, sink->soc.m_voplane) == 0){
        for (int i=0; i<VO_BUF_NUM; i++)
        {
          vo_wrap_PLockSetStatus(sink->soc.m_voplane, i, PLOCK_STATUS_INIT);
        }
      }
      sink->soc.handle = vo_wrap_get_handle();
    }
    gst_rtk_v1_sink_inital_vo_resource(sink);
    RTK_LOG_DEBUG(sink, "-");
    return TRUE;
}

gboolean gst_westeros_sink_soc_ready_to_paused( GstWesterosSink *sink, gboolean *passToDefault )
{
    WESTEROS_UNUSED(passToDefault);

    GstWesterosSinkSoc *socsink = &sink->soc;
    LOCK( sink );
    if (!sink->videoStarted )
    {
        if (!gst_westeros_sink_soc_start_video( sink ))
        {
            GST_ERROR("gst_westeros_sink_soc_ready_to_paused: gst_westeros_sink_soc_start_video failed");
        }
    }

    vo_wrap_set_pb_avstate(socsink->m_voplane, VO_WRAP_PB_SET_VIDEO, 1);
    if (!socsink->hasAudio)
        vo_wrap_get_pb_avstate(socsink->m_voplane, NULL, &socsink->hasAudio);
    GST_INFO_OBJECT(sink, "GST_STATE_CHANGE_READY_TO_PAUSED set pipeline has video true hasAudio?%s",(socsink->hasAudio==1)?"true":"false");
    if (socsink->hwavsync == TRUE && socsink->master_mode!=MASTER_MODE_PCR)
    {
        GST_INFO_OBJECT(sink, "Set Master mode to video master");
        gst_rtk_v1_sink_set_avsync_mode( sink, VIDEO_MASTER);
    }
    UNLOCK( sink );
    RTK_LOG_DEBUG(sink, "-");
    return TRUE;
}

gboolean gst_westeros_sink_soc_paused_to_playing( GstWesterosSink *sink, gboolean *passToDefault )
{
    WESTEROS_UNUSED(passToDefault);
    LOCK(sink);
#if RTK_USE_FW_KEEP_FRAME
    pthread_mutex_lock(&sink->soc.mute_mutex);
    vo_wrap_set_VO_Run(sink->soc.m_voplane);
    if(sink->soc.mute) {
      vo_wrap_v1_hide(sink->soc.m_voplane);
      sink->soc.needSetVORun = 1;
    }
    pthread_mutex_unlock(&sink->soc.mute_mutex);
#endif
    sink->soc.video_playing = TRUE;
    sink->soc.underflowTolerance = 0;
    if (sink->soc.hwavsync) {
        vo_wrap_set_VO_Run(sink->soc.m_voplane);

        sink->soc.needDefaultMaster = TRUE;

        if(sink->soc.alwaysPreroll == FALSE)
            sink->soc.skipPreroll = TRUE;
    }

    UNLOCK(sink);
    RTK_LOG_DEBUG(sink, "-");
    return TRUE;
}

gboolean gst_westeros_sink_soc_playing_to_paused( GstWesterosSink *sink, gboolean *passToDefault )
{
    int retry = WAIT_AUDIO_MAX_CNT+10;
    LOCK(sink);
    sink->soc.video_playing = FALSE;
    if (sink->soc.hwavsync && !sink->soc.resource_released)
      vo_wrap_set_VO_Pause(sink->soc.m_voplane);
    UNLOCK(sink);

    if (gst_base_sink_is_async_enabled(GST_BASE_SINK(sink)))
    {
      // as the pipeline is operating without syncronizing by the clock, all the buffers might have been already consumed by the sink.
      // But to complete transition to paused state in async_enabled mode, we need a preroll buffer pushed to the pad;
      // This is a workaround to avoid the need for preroll buffer.
      if (sink->soc.hwavsync) {
        GstBaseSink *basesink;
        basesink = GST_BASE_SINK(sink);
        GST_DEBUG_OBJECT(sink, "alwaysPreroll=0x%x, skipPreroll=0x%x, have_preroll=0x%x",
                sink->soc.alwaysPreroll, sink->soc.skipPreroll, basesink->have_preroll);
        while (!GST_BASE_SINK_PREROLL_TRYLOCK (basesink)) {
          usleep(WAIT_AUDIO_INTERVAL);
          retry--;
          if (retry < 0)
              break;
        }

        if (retry >= 0) {
          basesink->have_preroll = 1;
          GST_BASE_SINK_PREROLL_UNLOCK (basesink);
          GST_INFO_OBJECT(sink, "GST_BASE_SINK_PREROLL_TRYLOCK retry=%d", retry);
        }
        else {
          GST_INFO_OBJECT(sink, "GST_BASE_SINK_PREROLL_TRYLOCK return FALSE!");
        }
        sink->soc.needDefaultMaster = FALSE;
      }

      *passToDefault = TRUE;
    }
    else
    {
      *passToDefault = FALSE;
    }
    RTK_LOG_DEBUG(sink, "-");
    return TRUE;
}

gboolean gst_westeros_sink_soc_paused_to_ready( GstWesterosSink *sink, gboolean *passToDefault )
{
    GstWesterosSinkSoc *socsink = &sink->soc;
    gboolean bHaveStarted = FALSE;
    GST_INFO_OBJECT(sink, "GST_STATE_CHANGE_PAUSED_TO_READY set pipeline has video to false");
    if (!sink->soc.resource_released)
    vo_wrap_set_pb_avstate(sink->soc.m_voplane, VO_WRAP_PB_SET_VIDEO, 0);

    LOCK( sink );
    if (sink->videoStarted) {
#if RTK_KEEP_LAST_FRAME_CROSS_PIPELINE
        if (!socsink->keep_last_frame)
#endif
        {
          if (!sink->soc.resource_released) {
              GST_DEBUG_OBJECT(sink, "Hide video plane");
              vo_wrap_v1_hide(socsink->m_voplane);
          }
        }
        sink->videoStarted = FALSE;
        bHaveStarted = TRUE;
    }
    else
        GST_INFO_OBJECT(sink, "render loop did not start");
    UNLOCK( sink );

    sink->soc.flush_done = 0;
    sink->soc.flush = TRUE;

    if (!sink->soc.resource_released)
      gst_rtk_v1_sink_flush_and_alias_frame(sink);

    sink->soc.flush_done = 1;

    sink->soc.flush = FALSE;

    sinkSocStopVideo( sink );

    LOCK( sink );
    if (bHaveStarted) {
        socsink->v1_QueueRunning = 0;
        pthread_join (socsink->v1_QueueThread, NULL);
        pthread_mutex_destroy(&socsink->frame_mutex);
        pthread_mutex_destroy(&socsink->mute_mutex);
    }
    else
      GST_INFO_OBJECT(sink, "render loop did not start");
    UNLOCK( sink );
    RTK_LOG_DEBUG(sink, "-");

    return TRUE;
}

gboolean gst_westeros_sink_soc_ready_to_null( GstWesterosSink *sink, gboolean *passToDefault )
{
    GstWesterosSinkSoc *socsink = &sink->soc;
    GstVideoSink *videosink;
    ST_RECTANGLE osd1_rect;

    sinkSocStopVideo( sink );

    LOCK( sink );

    GST_INFO_OBJECT (sink, "stop - keep_last_frame=%d", socsink->keep_last_frame);

#if RTK_KEEP_LAST_FRAME_CROSS_PIPELINE
    if (socsink->keep_last_frame) {
    #if !(RTK_USE_FW_KEEP_FRAME)
      GST_ERROR_OBJECT(sink, "FIXME: Keep last frame disabled, v1 will show green screen.");
    #endif
      vo_wrap_v1_show(socsink->m_voplane);
    } else
#endif//RTK_KEEP_LAST_FRAME_CROSS_PIPELINE
    {
    #if RTK_USE_FW_KEEP_FRAME
      VO_WRAP_KEEP_CURPIC* lastpic = NULL;
      lastpic = (VO_WRAP_KEEP_CURPIC *)calloc(1, sizeof(VO_WRAP_KEEP_CURPIC));
      if (lastpic) {
        lastpic->is_destroy = 1;
        vo_wrap_set_VO_KeepLastFrame(socsink->m_voplane, lastpic);
        free(lastpic);
      }
      else {
        GST_ERROR_OBJECT(sink, "VO_WRAP_KEEP_CURPIC calloc failed.");
      }
    #if RTK_USE_BUFLOCK
      for (int i = 0; i < MAX_BUFLOCKS; i++) {
        if (socsink->Blid[i] != -1) {
          buflock_Free(socsink->Buflock[i], socsink->Blid[i]);
          socsink->Blid[i] = -1;
        }
      }
    #endif//RTK_USE_BUFLOCK
    #endif
    }

    //TODO:
    // shall we unref v1_Buf and free alias frames in v1_vobuf at this position? before VO stop or after VO stop ?
    int i;
    for (i = 0; i < VO_BUF_NUM; i++){
      if (socsink->v1_Buf[i] != NULL) {
          GST_WARNING_OBJECT(sink, "v1_Buf[%d] is not empty, unref it!", i);
          gst_buffer_unref(socsink->v1_Buf[i]);
          vo_wrap_PLockSetStatus(socsink->m_voplane, i, PLOCK_STATUS_INIT);
          socsink->v1_Buf[i] = NULL;
      }
      if (socsink->v1_vobuf[i].alias_frame != 0) {
          GST_WARNING_OBJECT(sink, "v1_vobuf[%d] is an alias frame, free it!", i);
          if (socsink->v1_vobuf[i].phys_addr != 0) {
              vo_wrap_free_mem(socsink->m_voplane, &socsink->v1_vobuf[i]);
          }
          socsink->v1_vobuf[i].alias_frame = 0;
      }
    }

    if (socsink->bring_to_front != BTF_FEATURE_DISABLE) {
      vo_wrap_configure_z_order(&socsink->order);
    }

    if (socsink->enable_osd != OSDMODE_FEATURE_DISABLE) {
      // restore OSD 1 size to the one before playback
      vo_wrap_query_display_window(VO_WRAP_VIDEO_PLANE_OSD1, &osd1_rect);
      if (osd1_rect.width != socsink->osd1_rect.width || osd1_rect.width != socsink->osd1_rect.width) {
          vo_wrap_set_display_window(VO_WRAP_VIDEO_PLANE_OSD1, 0, 0, socsink->osd1_rect.width, socsink->osd1_rect.height);
      }
    }

    if (socsink->vout_buf.phys_addr != 0)
      vo_wrap_free_nv12_buffer (socsink->m_voplane, &socsink->vout_buf);

    //  if (socsink->aliasFrameBuf.phys_addr != 0) {
    //    vo_wrap_free_mem(socsink->m_voplane, &socsink->aliasFrameBuf);
    //    memset(&socsink->aliasFrameBuf, 0, sizeof(VOUT_BUFFER))
    //  }

    if (GST_IS_VIDEO_SINK (GST_BASE_SINK(sink))) {
      videosink = GST_VIDEO_SINK (GST_BASE_SINK(sink));
      videosink->width = 0;
      videosink->height = 0;
    }

    socsink->width = -1; //-1 means not initialize
    socsink->height = -1;//-1 means not initialize
    socsink->x = 0;
    socsink->y = 0;
    socsink->fps = 0;

    gst_westeros_sink_soc_term(sink);
    gst_rtk_v1_sink_reset_initial_value(sink);
#if 0
    termGfx( sink );
#endif
    if ( sink->soc.sb )
    {
        GST_DEBUG_OBJECT(sink, "wl_sb_destroy sb %p\n", (void*)sink->soc.sb);
        wl_sb_destroy( sink->soc.sb );
        sink->soc.sb= 0;
    }
    UNLOCK( sink );
    RTK_LOG_DEBUG(sink, "-");

    return TRUE;
}

gboolean gst_westeros_sink_soc_accept_caps( GstWesterosSink *sink, GstCaps *caps )
{
    WESTEROS_UNUSED(sink);
    WESTEROS_UNUSED(caps);
    return TRUE;
}

void gst_westeros_sink_soc_set_startPTS( GstWesterosSink *sink, gint64 pts )
{
#ifndef SET_POSITION_START_PTS
    WESTEROS_UNUSED(pts);
#endif
    GstWesterosSinkSoc *socsink = &sink->soc;
    RTK_LOG_INFO(sink, "[realtek] socsink GST_EVENT_SEGMENT pts:%ld\n", pts);
    socsink->newseg = TRUE;
    gst_rtk_v1_sink_set_avsync_mode(sink, AUDIO_MASTER_NOSKIP);

    struct timespec tv;
    clock_gettime(CLOCK_MONOTONIC, &tv);
    socsink->tv_start = tv.tv_sec + (float)tv.tv_nsec/1E9;
    socsink->startplay = 1;
    socsink->underflow_cnt = 0;
    socsink->frameCountW = 0;
    socsink->frameCountR = 0;
    socsink->avg_diff_us = 0;
    socsink->first_time = GST_CLOCK_TIME_NONE;
#ifndef SET_POSITION_START_PTS
    sink->position = 0;
#else
    sink->position = gst_util_uint64_scale(pts, GST_MSECOND/10, CLOCK_BASE);
    GST_INFO_OBJECT(sink, "sink->position = %lld, pts=%lld\n", sink->position, pts);
#endif //#ifndef SET_POSITION_START_PTS
    if (socsink->hwavsync == TRUE && socsink->master_mode != MASTER_MODE_PCR)
      vo_wrap_set_MasterState(socsink->m_voplane, AUTOMASTER_NOT_MASTER);
}

void gst_westeros_sink_soc_render( GstWesterosSink *sink, GstBuffer *buffer )
{
    GstWesterosSinkSoc *socsink = &sink->soc;
    GstMemory *mem = gst_buffer_get_memory (buffer, 0);
    VOUT_BUFFER *vb;
    gboolean regression = FALSE;
    GstClock *clock = GST_ELEMENT_CLOCK (GST_BASE_SINK(sink));
    gint64 curr_us = -1;
    gint64 buff_us = GST_TIME_AS_USECONDS(GST_BUFFER_TIMESTAMP (buffer));
    int loop_cnt = 0;

    if (clock != NULL) {
      GstClockTime now = gst_clock_get_time (GST_ELEMENT_CLOCK (GST_BASE_SINK(sink)));
      GstClockTime base_time = GST_ELEMENT_CAST (GST_BASE_SINK(sink))->base_time;
      curr_us = GST_TIME_AS_USECONDS(now - base_time);
    }

    if (socsink->flush == TRUE || sink->flushStarted) {
      GST_WARNING_OBJECT(sink, "[realtek] don't render frame in flushing");
      gst_memory_unref(mem);
      //gst_buffer_unref(buffer);//why should we unref buf?
      return;
    }

    LOCK(sink);
    if (!sink->videoStarted) {
      GST_WARNING_OBJECT(sink, "[realtek] don't render frame when videoStarted flag is false!!");
      gst_memory_unref (mem);
      UNLOCK(sink);
      return;
    }
    UNLOCK(sink);

    if (G_LIKELY (gst_memory_is_type (mem, GST_OMX_MEMORY_TYPE))) {
      GST_LOG_OBJECT (sink, "Got omx_memory");
      vb = &((GstOMXMemory*)mem)->vbuf;
      if (!vo_wrap_is_vout_buffer (vb))
        regression = TRUE;
    } else {
      regression = TRUE;
    }

    if (G_UNLIKELY (regression)) {
      GST_WARNING_OBJECT(sink, "non-GstOMXMemory buffer coming, just unref it. buf:%p, mem:%p", buffer, mem);
      gst_memory_unref(mem);
      //gst_buffer_unref(buffer);//why should we unref buf?
      return;
    }
#ifdef DROP_TOO_OLD_FRAME
    if (socsink->master_mode != MASTER_MODE_PCR && sink->position > buff_us * 1000LL) {
      GST_WARNING_OBJECT(sink, "buff_us * 1000 = %lld too small (sink->position = %lld), drop it.", (buff_us * 1000LL), sink->position);
      gst_memory_unref(mem);
      return;
    }
#endif
    socsink->render = 1;
    if (socsink->frameCountW == 0) {
      vo_wrap_set_VO_Run(socsink->m_voplane);
      if (socsink->hwavsync == TRUE && socsink->master_mode!=MASTER_MODE_PCR)
      {
          long long vpts = 0;
          long long apts = 0;
          rvsd_vo_getPlaybackPts(socsink->m_voplane, &vpts, &apts);
          if (vpts <= -1) {
              GST_INFO_OBJECT(sink, "Get 1st frame set Master mode to video master");
              gst_rtk_v1_sink_set_avsync_mode( sink, VIDEO_MASTER);
          }
      }
      socsink->startplay = 1;
    }

    if (socsink->hwavsync == TRUE && socsink->frameCountW == 1)
    {
        if (!socsink->hasAudio)
        {
            vo_wrap_get_pb_avstate(socsink->m_voplane, NULL, &socsink->hasAudio);
        }
        if(!socsink->hasAudio && socsink->master_mode!=MASTER_MODE_PCR)
        {
            GST_DEBUG_OBJECT(sink, "avsyncmode:video master, Get 1st frame and video only, set Master mode to video master");
            gst_rtk_v1_sink_set_avsync_mode( sink, VIDEO_MASTER);
        }
    }

    if(socsink->frameCountW <= 30)
    {
        GST_DEBUG_OBJECT(sink, "avsyncmode,socsink->hwavsync=%s, socsink->frameCount=%d, socsink->hasAudio=%s",
            (socsink->hwavsync?"TRUE":"FALSE"), socsink->frameCountW, (socsink->hasAudio?"TRUE":"FALSE"));
    }

    while (socsink->hwavsync == TRUE && (socsink->frameCountW == 1 || (socsink->needDefaultMaster && socsink->frameCountW != 0 ))) {
      long long vpts = 0;
      long long apts = 0;
      unsigned short wait_video_cnt = 0;
      unsigned short wait_audio_cnt = 0;
      unsigned short wait_audio_master_cnt = 0;
      int videomode = 0;
      int audiomode = 0;
      int systemmode = 0;
      int state = 0;
      gboolean video_ready = FALSE;
      gboolean audio_ready = FALSE;
      if (!socsink->hasAudio)
      {
          vo_wrap_get_pb_avstate(socsink->m_voplane, NULL, &socsink->hasAudio);
      }

      while(socsink->v1_QueueRunning) {
          LOCK(sink);
          gboolean isVideoPlaying = socsink->video_playing;
          UNLOCK(sink);
          if(video_ready && !isVideoPlaying) //If pipeline state was changed to PAUSE, skip AV master mode detection
            break;

          rvsd_vo_getPlaybackPts(socsink->m_voplane, &vpts, &apts);

          if (socsink->flush_during_render) {
              gst_memory_unref(mem);
              socsink->render = 0;
              socsink->flush_during_render = 0;
              return;
          }

          if (!video_ready) {
              if (vpts < 0 || vpts < socsink->firstFramePTS) {
                  wait_video_cnt++;
                  if(socsink->master_mode!=MASTER_MODE_PCR) {
                    gst_rtk_v1_sink_set_avsync_mode( sink, VIDEO_MASTER);
                    GST_INFO_OBJECT(sink, "avsyncmode:video master");
                  }
                  usleep(WAIT_AUDIO_INTERVAL);
                  if (wait_video_cnt % 15 == 0)
                      GST_DEBUG_OBJECT(sink, "avsyncmode,waiting video: video=%lld, audio=%lld, wait_cnt=%u", vpts, apts, wait_video_cnt);
                  if (wait_video_cnt < WAIT_AUDIO_MAX_CNT)
                      continue;
                  else {
                      GST_WARNING_OBJECT(sink, "avsyncmode, wait video(%lld) start timeout @@", vpts);
                      video_ready = TRUE;
                  }
              } else {
                  if (socsink->useImmediateOutput) {
                      GST_INFO_OBJECT(sink, "avsyncmode:useImmediateOutput(set), video(%lld) ready!!",vpts);
                      gst_rtk_v1_sink_set_avsync_mode( sink, FREE_RUN);
                  }
                  else if (socsink->master_mode!=MASTER_MODE_PCR) {
                      vo_wrap_get_MasterMode(socsink->m_voplane, &systemmode, &videomode, &audiomode, &state);
                      if (systemmode!=AVSYNC_FORCED_SLAVE || videomode!=AVSYNC_AUTO_SLAVE || audiomode!=AVSYNC_AUTO_MASTER_NO_SKIP) {
                          GST_DEBUG_OBJECT(sink, "avsyncmode:default(set), video(%lld) ready!!",vpts);
                          gst_rtk_v1_sink_set_avsync_mode( sink, AUDIO_MASTER_NOSKIP);
                      }
                  }
                  video_ready = TRUE;
                  GST_INFO_OBJECT(sink, "avsyncmode:default, video(%lld) ready!!",vpts);
              }
              if (socsink->startplay == 1)
              {
                  if (socsink->frameCountW > 0 && socsink->need_signal_firstframe && vpts != -1)
                  {
                      gst_rtk_v1_sink_set_avsync_mode(sink, AUDIO_MASTER_NOSKIP);
                      socsink->startplay = 0;
                      socsink->eos = false;
                      g_signal_emit (G_OBJECT (sink), g_signals[SIGNAL_FIRSTFRAME], 0, 2, NULL);
                      RTK_LOG_INFO(sink, "[realtek] Send first-video-frame signal");
                      socsink->need_signal_firstframe = false;
                  }
              }
              pthread_mutex_lock(&socsink->mute_mutex);
              if(socsink->mute) {
                  vo_wrap_v1_hide(socsink->m_voplane);
              } else {
                  vo_wrap_v1_show(socsink->m_voplane);
                  if (socsink->useImmediateOutput) {
                      vo_wrap_ConfigLowDelayMode(socsink->m_voplane, LOW_DELAY_AVSYNC);
                  }
              }
              pthread_mutex_unlock(&socsink->mute_mutex);
          }

          if(socsink->master_mode == MASTER_MODE_PCR || !socsink->hasAudio || socsink->useImmediateOutput)
          {
              GST_DEBUG_OBJECT(sink, "avsyncmode,%s! Skip checking audio state...",(socsink->master_mode == MASTER_MODE_PCR)?"In PCR mode":"No audio");
              socsink->needDefaultMaster = FALSE;
              break;
          }

          if (isVideoPlaying) {
              if (!audio_ready) {
                  if (apts == -1) {
                      wait_audio_cnt++;
                      if (wait_audio_cnt % 15 == 0)
                          GST_DEBUG_OBJECT(sink, "waiting audio: video=%lld, audio=%lld, wait_cnt=%u", vpts, apts, wait_audio_cnt);
                      if (wait_audio_cnt < WAIT_AUDIO_MAX_CNT) {
                          usleep(WAIT_AUDIO_INTERVAL);
                          continue;
                      }
                      GST_WARNING_OBJECT(sink, "wait audio timeout: video=%lld, audio=%lld, wait_cnt=%u", vpts, apts, wait_audio_cnt);
                  }else{
                    audio_ready = true;
                  }
              }
              vo_wrap_get_MasterMode(socsink->m_voplane, &systemmode, &videomode, &audiomode, &state);
              if (!((state == AUTOMASTER_IS_MASTER) && (audiomode == AVSYNC_AUTO_MASTER_NO_SKIP || audiomode == AVSYNC_AUTO_MASTER) && (videomode == AVSYNC_AUTO_SLAVE))) {
                  wait_audio_master_cnt++;
                  if (((audiomode != AVSYNC_AUTO_MASTER_NO_SKIP && audiomode != AVSYNC_AUTO_MASTER) || videomode != AVSYNC_AUTO_SLAVE) && (socsink->master_mode!=MASTER_MODE_PCR) )
                  {
                      gst_rtk_v1_sink_set_avsync_mode( sink, AUDIO_MASTER_NOSKIP);
                      GST_DEBUG_OBJECT(sink, "Set av sync mode into expect mode again(%u)",wait_audio_master_cnt);
                  }
                  if (wait_audio_master_cnt < WAIT_AUDIO_MASTER_MAX_CNT) {
                     usleep(WAIT_AUDIO_INTERVAL);
                     GST_LOG_OBJECT(sink, "wait audio master cnt=%d", wait_audio_master_cnt);
                     continue;
                  }
                  GST_WARNING_OBJECT(sink, "wait audio master timeout: video=%lld, audio=%lld, wait_cnt=%u", vpts, apts, wait_audio_master_cnt);
              } else {
                  GST_INFO_OBJECT(sink, "isMasterBeMaster=%d, cnt=%d", (state == AUTOMASTER_IS_MASTER), wait_audio_master_cnt);
              }
          } else {
            GST_WARNING_OBJECT(sink,"Not in playing state so skip the audio ready waiting");
          }
          if (socsink->needDefaultMaster) {
            GST_WARNING_OBJECT(sink, "avsyncmod setting, break while caused by needDefaultMaster");
            socsink->needDefaultMaster = FALSE;
          } else
              GST_INFO_OBJECT(sink, "avsyncmode,break while (socsink->hwavsync == TRUE && socsink->frameCount == 1)");
          break;
        }
        LOCK(sink);
        if ( sink->soc.video_playing == FALSE) {
          GST_WARNING_OBJECT(sink,"Is not playing so pause VO");
          vo_wrap_set_VO_Pause(sink->soc.m_voplane);
        }
        UNLOCK(sink);
        break;
    }

    if (socsink->fw_speed != socsink->target_fw_speed && socsink->frameCountW > 0) {
      if (socsink->target_fw_speed < AUDIO_MIN_SPEED) {
        unsigned long speed = (unsigned long)(socsink->target_fw_speed * DEFAULT_RTK_SPEED_1X);
        int ret = vo_wrap_setspeed(socsink->m_voplane, speed);
        if (ret == 0) {
          GST_INFO_OBJECT (sink, "set VO speed to %f", socsink->target_fw_speed);
          socsink->fw_speed = socsink->target_fw_speed;
        } else {
          GST_ERROR_OBJECT (sink, "set_speed return %d", ret);
        }
      } else if (!socsink->useImmediateOutput) {
          GST_INFO_OBJECT (sink, "set mastership to AudioMasterNoSkip");
          gst_rtk_v1_sink_set_avsync_mode( sink, AUDIO_MASTER_NOSKIP);
          socsink->fw_speed = socsink->target_fw_speed;
      }
      else {
          //FIXME: set master mode for useImmediateOutput?
      }
    }
    else if (socsink->fw_speed < AUDIO_MIN_SPEED && socsink->frameCountW > 0) {
      int videomode = 0;
      int audiomode = 0;
      int systemmode = 0;
      int state = 0;
      vo_wrap_get_MasterMode(socsink->m_voplane, &systemmode, &videomode, &audiomode, &state);
      if (audiomode != AVSYNC_FORCED_SLAVE || videomode != AVSYNC_FORCED_MASTER) {
        GST_INFO_OBJECT (sink, "set mastership to VideoMaster because it is 0.25x playing");
        gst_rtk_v1_sink_set_avsync_mode( sink, VIDEO_MASTER);
      }
    }

    LOCK(sink);
    socsink->underflow_cnt = 0;
    socsink->frameCountW++;
    UNLOCK(sink);

    if (socsink->master_mode == MASTER_MODE_PCR) {
        if (vb->meta_type == METADATA_PRIVATE_RTK_DATA) {
            private_rtk_data *p = (private_rtk_data*) SystemMemory_GetVirAddr(vb->meta_handle);
            buff_us = p->pts[0] * 100 / 9;
        }
        else if (vb->meta_type == METADATA_VRPC_DVO_INFO) {
            buff_us = vb->pts * 100 / 9;
        }
    }

    if (socsink->hwavsync == TRUE)
    {
        long long vpts = 0;
        long long apts = 0;
        int videomode = 0;
        int audiomode = 0;
        int systemmode = 0;
        int state = 0;
        rvsd_vo_getPlaybackPts(socsink->m_voplane, &vpts, &apts);
        vo_wrap_get_MasterMode(socsink->m_voplane, &systemmode, &videomode, &audiomode, &state);
        GST_DEBUG_OBJECT(sink, "buf pts: %lld, curr pts: %lld, vpts=%lld, apts=%lld, masterState=%d",
                buff_us, curr_us, vpts, apts, state);
        curr_us = vpts * 100 / 9;
    }

    GST_INFO_OBJECT(sink, "curr_us: %lld, buf_us: %lld, diff0=%lld, diff1=%lld",
            curr_us, buff_us, (buff_us - curr_us), (curr_us - buff_us));
    if (socsink->startplay == 0 && curr_us >= 0)
    {
        if (clock && ((curr_us - buff_us > DEFAULT_LATE_THRESHOLD) || (buff_us - curr_us  > DEFAULT_CLOCK_RESET_GAP)))
        {
            if((curr_us - buff_us > DEFAULT_LATE_THRESHOLD) || (buff_us - curr_us  > DEFAULT_PLAYBACK_DISCARD_GAP))
            {
                g_signal_emit (G_OBJECT(sink), g_signals[SIGNAL_PTSERROR], 0, curr_us*9/100, NULL);
                GST_WARNING_OBJECT(sink, "[socsink] SIGNAL_PTSERROR");
            }

            if (socsink->master_mode != MASTER_MODE_PCR) {
                vo_wrap_reset_clock(socsink->m_voplane);
                GST_WARNING_OBJECT(sink, "[socsink] Large PTS gap, reset clock!! curr pts=%lld, frame pts=%lld, diff=%lld (ns)", curr_us, buff_us, (buff_us - curr_us));
            }
        }
    }

    if (socsink->useImmediateOutput)
    {
        int vo_queue_cnt = socsink->v1_QueueIndexW - socsink->v1_QueueIndexR;
        vo_queue_cnt = (vo_queue_cnt < 0) ? (vo_queue_cnt + VO_BUF_NUM) : vo_queue_cnt;
        if (vo_queue_cnt > 5 && socsink->frameCountW % RTK_UNDERFLOW_TOLERANCE_FRAME == 0) {
            GST_WARNING_OBJECT(sink, "[fr_%d] vo_queue_cnt=%d, reset ImmediateOutput mode again", socsink->frameCountW, vo_queue_cnt);
              if (socsink->mute) {
                  vo_wrap_v1_hide(socsink->m_voplane);
              } else {
                  vo_wrap_v1_show(socsink->m_voplane);
              }
            vo_wrap_ConfigLowDelayMode(socsink->m_voplane, LOW_DELAY_AVSYNC);
        }
    }

    pthread_mutex_lock(&socsink->frame_mutex);

    while (socsink->v1_QueueRunning) //sam.wu waiting vo frame status is changed to PLOCK_STATUS_INIT
    {
      if ((socsink->v1_QueueIndexR != (socsink->v1_QueueIndexW+1)%VO_BUF_NUM) &&
          (vo_wrap_PLockGetStatus(socsink->m_voplane, socsink->v1_QueueIndexW) == PLOCK_STATUS_INIT))
      {
        break;
      }

      if (sink->soc.video_playing == FALSE)
        break;

      loop_cnt++;
      if (loop_cnt % 100 == 0)
        GST_DEBUG_OBJECT (sink, "Ring buffer is almost full or frame status with write index is incorrect. v1_QueueIndex R:%d, W:%d",
                socsink->v1_QueueIndexR, socsink->v1_QueueIndexW);
      pthread_mutex_unlock(&socsink->frame_mutex);
      usleep(1000);
      pthread_mutex_lock(&socsink->frame_mutex);
    }

    if (socsink->flush_during_render) //After VO flush we can't render the old frame or the old PTS make VO conflict
    {
        socsink->render = 0;
        socsink->flush_during_render = 0;
        pthread_mutex_unlock(&socsink->frame_mutex);
        gst_memory_unref (mem);
        return;
    }

    //GST_DEBUG_OBJECT(sink, "[FrameMutex][+][%s]", __FUNCTION__);
    gst_buffer_ref(buffer);
    socsink->v1_Buf[socsink->v1_QueueIndexW] = buffer;
    vb->v1_wIndex = socsink->v1_QueueIndexW;

    memcpy(&socsink->v1_vobuf[socsink->v1_QueueIndexW], vb, sizeof(VOUT_BUFFER));

    if (socsink->newseg == TRUE)
    {
      socsink->newseg = FALSE;
  #if defined(ENABLE_TEE_DRM_FLOW)
      {
          GstRtkSecureMeta *rtkmeta = NULL;
          rtkmeta = gst_buffer_get_rtk_secure_meta(buffer);
          GST_DEBUG_OBJECT(sink, "Get Rtk secure meta(%p) from GstBuffer.", rtkmeta);
          if (rtkmeta) {
              GST_DEBUG_OBJECT(sink, "Rtk secure type: %d", rtkmeta->type);
              if (rtkmeta->type == RTKMEM_VIDEO) {
                  socsink->is_secure_path = TRUE;
              }
          }
      }
  #endif //defined(ENABLE_TEE_DRM_FLOW)
    }

    if(vb->meta_type == METADATA_PRIVATE_RTK_DATA) {
        private_rtk_data *p = (private_rtk_data*) SystemMemory_GetVirAddr(vb->meta_handle);
        p->video_full_range_flag = socsink->full_range;
        p->delay_mode = DEFAULT_LOW_DELAY_MODE;

        if (socsink->hwavsync == TRUE)
        {
          p->delay_mode = socsink->useImmediateOutput ? LOW_DELAY_AVSYNC : LOW_DELAY_OFF;
        }
        GST_INFO_OBJECT (sink, "[fr_%d] addr=0x%08x, pts=%lld w/r:(%d/%d)",
                socsink->frameCountW, (unsigned int)vb->virt_addr, p->pts[0],
                (socsink->v1_QueueIndexW + 1) % VO_BUF_NUM, socsink->v1_QueueIndexR);
        if (socsink->frameCountW == 1) {
            socsink->firstFramePTS = p->pts[0];
            RTK_LOG_INFO(sink, "westeros-sink: received first decoded frame PTS:%lld\n",socsink->firstFramePTS);
        }
    } else if (vb->meta_type == METADATA_VRPC_DVO_INFO) {
        GST_INFO_OBJECT (sink, "[fr_%d] addr=0x%08x, pts=%lld w/r:(%d/%d)",
                socsink->frameCountW, (unsigned int)vb->virt_addr, vb->pts,
                (socsink->v1_QueueIndexW + 1) % VO_BUF_NUM, socsink->v1_QueueIndexR);
        if (socsink->frameCountW == 1) {
            socsink->firstFramePTS = vb->pts;
            RTK_LOG_INFO(sink, "westeros-sink: received first decoded frame PTS:%lld\n",socsink->firstFramePTS);
        }
    }

#if defined(ENABLE_TEE_DRM_FLOW)
    vb->is_secure = socsink->is_secure_path;
#endif
    vo_wrap_render (socsink->m_voplane, vb);

    if (socsink->flushed) {
        if ( socsink->frameCountW > 1) {
            if (socsink->video_playing) {
                RTK_LOG_INFO(sink, "[fr_%d] Release the VO keeped last frame.(Is_muted?%s)", socsink->frameCountW, socsink->mute?"true":"false");
                vo_wrap_set_VO_Run(socsink->m_voplane);
                if (socsink->mute) {
                    socsink->needSetVORun = 1;
                } else {
                    vo_wrap_v1_show(socsink->m_voplane);
                }
            }
        }
        socsink->flushed = FALSE;
    }
    socsink->v1_QueueIndexW = (socsink->v1_QueueIndexW + 1) % VO_BUF_NUM;
    GST_DEBUG_OBJECT(sink, "[socsink] update W to %d", socsink->v1_QueueIndexW);

    //GST_DEBUG_OBJECT(sink, "[FrameMutex][-][%s]", __FUNCTION__);
    pthread_mutex_unlock(&socsink->frame_mutex);

    processFrame( sink, buffer );

    gst_memory_unref (mem);

    if( (socsink->frameCountW > 0) && (socsink->frameCountW % 60 == 0) )
    {
        unsigned int drop_cnt = 0;
        long long vpts = 0;
        long long apts = 0;
        rvsd_vo_getPlaybackPts(socsink->m_voplane, &vpts, &apts);

        vo_wrap_getDropInfo(socsink->m_voplane, &drop_cnt);
        socsink->drop_cnt = drop_cnt;

        GST_DEBUG_OBJECT(sink, "frameCount:%d, drop_cnt:%u", socsink->frameCountW, socsink->drop_cnt);

        GstMessage *qos_msg= gst_message_new_qos( GST_OBJECT_CAST(sink), FALSE, socsink->first_time, socsink->first_time,
                                                  (((vpts * 1000) / 90LL) * GST_USECOND) , GST_CLOCK_TIME_NONE );
        if ( qos_msg )
        {
            gst_message_set_qos_stats( qos_msg, GST_FORMAT_BUFFERS, socsink->frameCountW, socsink->drop_cnt );
            if ( !gst_element_post_message( GST_ELEMENT(sink), qos_msg ) )
            {
                GST_WARNING("unable to post QoS");
                gst_message_unref( qos_msg );
            }
        }
    }

    socsink->render = 0;
    socsink->flush_during_render = 0;
    return;
}

void gst_westeros_sink_soc_flush( GstWesterosSink *sink )
{
    GstWesterosSinkSoc *socsink = &sink->soc;
    sink->soc.flush_done = 0;
    sink->soc.flush = TRUE;
    sink->position = 0;

    gst_rtk_v1_sink_flush_and_alias_frame(sink);


    if (sink->soc.hwavsync) {
      GST_INFO_OBJECT(sink, "reset refclock");
      LOCK(sink);
      vo_wrap_reset_clock(sink->soc.m_voplane);
      sink->position = 0;
      sink->currentPTS = 0;
      sink->soc.first_time = GST_CLOCK_TIME_NONE;
      sink->soc.update_time = GST_CLOCK_TIME_NONE;
      UNLOCK(sink);
    }

    sink->soc.flush_done = 1;
    // flush stop
    sink->soc.flush = FALSE;
    sink->soc.flushed = TRUE;
}

static GstFlowReturn gst_westeros_sink_soc_preroll(GstBaseSink *base_sink, GstBuffer *buffer)
{
  GstWesterosSink *sink= GST_WESTEROS_SINK(base_sink);
  GstWesterosSinkSoc *socsink = &sink->soc;

  if (buffer && socsink->prerollBuffer != buffer)
  {
    GST_DEBUG_OBJECT(sink, "frameStepOnPreroll:%d, timestamp:%lld", socsink->frameStepOnPreroll, GST_BUFFER_PTS(buffer));
    socsink->prerollBuffer = buffer;
    gst_rtk_v1_sink_check_hdr_info(sink, buffer);
  }

  if(socsink->hwavsync == TRUE && socsink->skipPreroll == TRUE) {
    vo_wrap_set_VO_Pause(socsink->m_voplane);
    GST_BASE_SINK(sink)->need_preroll= FALSE;
    GST_BASE_SINK(sink)->have_preroll= TRUE;
  }

  return GST_FLOW_OK;
}

gboolean gst_westeros_sink_soc_start_video( GstWesterosSink *sink )
{
  GstWesterosSinkSoc *socsink = &sink->soc;
#ifndef GST_DISABLE_GST_DEBUG
  GST_DEBUG_OBJECT (sink, "start");
#endif /* GST_DISABLE_GST_DEBUG */

  socsink->handle = vo_wrap_get_handle();

  if (socsink->enable_osd != OSDMODE_FEATURE_DISABLE) {
    gst_rtk_v1_sink_property_set_enable_osd(sink);
  }

  if (socsink->bring_to_front != BTF_FEATURE_DISABLE) {
    gst_rtk_v1_sink_property_set_bring_to_front(sink);
  }

  pthread_attr_t attr;
  pthread_attr_init (&attr);
  socsink->v1_QueueIndexW = 0;
  socsink->v1_QueueIndexR = 0;
  pthread_mutex_init(&socsink->frame_mutex, NULL);
  pthread_mutex_init(&socsink->mute_mutex, NULL);
  pthread_create (&socsink->v1_QueueThread, &attr, (void *(*)(void *)) vo_queue_loop, sink);

  socsink->newseg = TRUE;

  struct timespec tv;
  clock_gettime(CLOCK_MONOTONIC, &tv);
  socsink->tv_start = tv.tv_sec + (float)tv.tv_nsec/1E9;
  socsink->startplay = 1;

  if (socsink->hwavsync == TRUE) {
    vo_wrap_ConfigLowDelayMode(socsink->m_voplane, (socsink->useImmediateOutput ? LOW_DELAY_AVSYNC : LOW_DELAY_OFF));
    gst_base_sink_set_sync(GST_BASE_SINK_CAST(sink), FALSE);
  } else {
    vo_wrap_ConfigLowDelay(socsink->m_voplane, DEFAULT_LOW_DELAY_MODE, DEFAULT_DELAY_DEPTH, TRUE);
    gst_base_sink_set_sync(GST_BASE_SINK_CAST(sink), TRUE);
  }
#ifdef V1SINK_DUMP_FRAME
  fd_dump = open (DUMP_FILE_NAME, O_CREAT|O_TRUNC|O_WRONLY);
#endif

  vo_wrap_set_videoFreeRunThreshold(socsink->m_voplane, socsink->videoFreeRunThreshold*90000);
  if (!sink->soc.captureThread)
  {
    sink->soc.quitCaptureThread= FALSE;
    if (sink->soc.captureThread == NULL)
    {
       GST_DEBUG_OBJECT(sink, "starting westeros_sink_capture thread");
       sink->soc.captureThread = g_thread_new("westeros_sink_capture", captureThread, sink);
    }
  }
  sink->videoStarted= TRUE;

  int i = 0;
  for ( i = socsink->v1_QueueIndexW; i < VO_BUF_NUM; i++) {
    int pLockStatus = vo_wrap_PLockGetStatus(socsink->m_voplane, i);
    if (pLockStatus == PLOCK_STATUS_INIT) {
      if (i != 0) {
        RTK_LOG_WARNING(sink, "Update the start index to %d. Since default index is not in initial state.", i);
      }
      break;
    }
  }
  if (i == VO_BUF_NUM) {
    RTK_LOG_WARNING(sink, "Force reset all VO_BUF index since all index are not in initial state.");
    for (i=0; i<VO_BUF_NUM; i++)
    {
      vo_wrap_PLockSetStatus(socsink->m_voplane, i, PLOCK_STATUS_INIT);
    }
  } else {
    socsink->v1_QueueIndexW = socsink->v1_QueueIndexR = i;
  }
  return TRUE;
}

void gst_westeros_sink_soc_eos_event( GstWesterosSink *sink )
{
   GstWesterosSinkSoc *socsink = &sink->soc;

    socsink->eos = TRUE;
    socsink->underflowTolerance = 0;
    gst_westeros_sink_eos_detected(sink);
}

void gst_westeros_sink_soc_set_video_path( GstWesterosSink *sink, bool useGfxPath )
{
   WESTEROS_UNUSED(sink);
   WESTEROS_UNUSED(useGfxPath);
   bool oldUseGfxPath;

   oldUseGfxPath= sink->soc.useGfxPath;

   sink->soc.useGfxPath= useGfxPath;
   printf("gst_westeros_sink_soc_set_video_path old=%d, new=%d\n", oldUseGfxPath, useGfxPath);

   if ( useGfxPath && !oldUseGfxPath )
   {
      struct wl_buffer *buff;

      if ( sink->soc.frameWidth && sink->soc.frameHeight )
      {
         transitionToRenderer( sink );
      }

      buff= wl_sb_create_buffer( sink->soc.sb,
                                 0,
                                 sink->windowWidth,
                                 sink->windowHeight,
                                 sink->windowWidth*4,
                                 WL_SB_FORMAT_ARGB8888 );
      wl_surface_attach( sink->surface, buff, sink->windowX, sink->windowY );
      wl_surface_damage( sink->surface, 0, 0, sink->windowWidth, sink->windowHeight );
      wl_surface_commit( sink->surface );
      wl_display_flush(sink->display);
      wl_display_dispatch_queue_pending(sink->display, sink->queue);
   }
   else if ( !useGfxPath && oldUseGfxPath )
   {
      transitionToRenderer( sink );

      gst_westeros_sink_soc_update_video_position( sink );

      wl_surface_attach( sink->surface, 0, sink->windowX, sink->windowY );
      wl_surface_damage( sink->surface, 0, 0, sink->windowWidth, sink->windowHeight );
      wl_surface_commit( sink->surface );
      wl_display_flush(sink->display);
      wl_display_dispatch_queue_pending(sink->display, sink->queue);
   }
}

void gst_westeros_sink_soc_update_video_position( GstWesterosSink *sink )
{
   OMX_ERRORTYPE omxerr;
   int wx, wy, ww, wh;
   int vx, vy, vw, vh;

   wx= sink->windowX;
   wy= sink->windowY;
   ww= sink->windowWidth;
   wh= sink->windowHeight;
   sink->windowChange= false;
   GST_DEBUG_OBJECT(sink, "useGfxPath=%d, (outputWidth %d outputHeight %d)\n", sink->soc.useGfxPath, sink->outputWidth, sink->outputHeight);
   GST_DEBUG_OBJECT (sink, "soc_update_video_position: (x %d y %d w %d h %d), scale(xn %d xd %d, yn %d yd %d), trans(x %d y %d), override=%x\n",
           wx, wy, ww, wh, sink->scaleXNum, sink->scaleXDenom, sink->scaleYNum, sink->scaleYDenom, sink->transX, sink->transY, sink->windowSizeOverride);

    if (sink->windowSizeOverride) {
        vx = ((wx*sink->scaleXNum)/sink->scaleXDenom) + sink->transX;
        vy = ((wy*sink->scaleYNum)/sink->scaleYDenom) + sink->transY;
        vw = ((ww)*sink->scaleXNum)/sink->scaleXDenom;
        vh = ((wh)*sink->scaleYNum)/sink->scaleYDenom;
    }
    else {
        vx = sink->transX;
        vy = sink->transY;
        vw = (sink->outputWidth*sink->scaleXNum)/sink->scaleXDenom;
        vh = (sink->outputHeight*sink->scaleYNum)/sink->scaleYDenom;
    }

   gst_rtk_v1_sink_property_set_output_rectangle(sink, vx, vy, vw, vh);

   if ( !sink->soc.useGfxPath )
   {
      // Send a buffer to compositor to update hole punch geometry
      if ( sink->soc.sb )
      {
         wl_surface_attach( sink->surface, 0, sink->windowX, sink->windowY );
         wl_surface_damage( sink->surface, 0, 0, sink->windowWidth, sink->windowHeight );
         wl_surface_commit( sink->surface );
      }
   }
}

void transitionToRenderer( GstWesterosSink *sink )
{
   OMX_ERRORTYPE omxerr;
   OMX_STATETYPE state;
   //bool toGfx= (rend == &sink->soc.eglRend);

   LOCK(sink);
   if ( /*toGfx &&*/ !sink->soc.captureThread )
   {
      sink->soc.quitCaptureThread= FALSE;
      if ( sink->soc.captureThread == NULL )
      {
         GST_DEBUG_OBJECT(sink, "transitionToRenderer: starting westeros_sink_capture thread");
         sink->soc.captureThread= g_thread_new("westeros_sink_capture", captureThread, sink);
      }
   }

   //if ( sink->soc.rend != rend )
   {
       //TODO realtek
   }

exit:
   UNLOCK(sink);
   return;
}

#define RED_SIZE (8)
#define GREEN_SIZE (8)
#define BLUE_SIZE (8)
#define ALPHA_SIZE (8)
#define DEPTH_SIZE (0)

static bool setupEGL( GstWesterosSink *sink )
{
   bool result= false;
   int i;
   EGLBoolean b;
   EGLint major, minor;
   EGLint configCount;
   EGLConfig *eglConfigs= 0;
   #ifdef USE_GLES2
   EGLint ctxAttrib[3];
   #endif
   EGLint attr[24];
   EGLint redSize, greenSize, blueSize, alphaSize, depthSize;

   if ( !sink->soc.eglSetup )
   {
      sink->soc.eglDisplay= eglGetDisplay( sink->display );
      if ( sink->soc.eglDisplay == EGL_NO_DISPLAY )
      {
         GST_ERROR( "no EGL display available" );
         goto exit;
      }

      b= eglInitialize( sink->soc.eglDisplay, &major, &minor );
      if ( !b )
      {
         GST_ERROR( "unable to initialize EGL display" );
         goto exit;
      }

      b= eglGetConfigs( sink->soc.eglDisplay, NULL, 0, &configCount );
      if ( !b )
      {
         GST_ERROR("unable to get count of EGL configurations: %X", eglGetError());
         goto exit;
      }

      eglConfigs= (EGLConfig*)malloc( configCount*sizeof(EGLConfig) );
      if ( !eglConfigs )
      {
         GST_ERROR("unable to allocate memory for EGL configurations");
         goto exit;
      }

      i= 0;
      attr[i++]= EGL_RED_SIZE;
      attr[i++]= RED_SIZE;
      attr[i++]= EGL_GREEN_SIZE;
      attr[i++]= GREEN_SIZE;
      attr[i++]= EGL_BLUE_SIZE;
      attr[i++]= BLUE_SIZE;
      attr[i++]= EGL_ALPHA_SIZE;
      attr[i++]= ALPHA_SIZE;
      attr[i++]= EGL_DEPTH_SIZE;
      attr[i++]= DEPTH_SIZE;
      attr[i++]= EGL_SURFACE_TYPE;
      attr[i++]= EGL_WINDOW_BIT;
      #ifdef USE_GLES2
      attr[i++]= EGL_STENCIL_SIZE;
      attr[i++]= 0;
      attr[i++]= EGL_RENDERABLE_TYPE;
      attr[i++]= EGL_OPENGL_ES2_BIT;
      #endif
      attr[i++]= EGL_NONE;

      b= eglChooseConfig( sink->soc.eglDisplay,
                          attr,
                          eglConfigs,
                          configCount,
                          &configCount );
      if ( !b )
      {
         GST_ERROR("eglChooseConfig failed: %X", eglGetError());
         goto exit;
      }

      for( i= 0; i < configCount; ++i )
      {
         eglGetConfigAttrib( sink->soc.eglDisplay, eglConfigs[i], EGL_RED_SIZE, &redSize );
         eglGetConfigAttrib( sink->soc.eglDisplay, eglConfigs[i], EGL_GREEN_SIZE, &greenSize );
         eglGetConfigAttrib( sink->soc.eglDisplay, eglConfigs[i], EGL_BLUE_SIZE, &blueSize );
         eglGetConfigAttrib( sink->soc.eglDisplay, eglConfigs[i], EGL_ALPHA_SIZE, &alphaSize );
         eglGetConfigAttrib( sink->soc.eglDisplay, eglConfigs[i], EGL_DEPTH_SIZE, &depthSize );

         GST_DEBUG("setupEGL: config %d: red: %d green: %d blue: %d alpha: %d depth: %d\n",
                 i, redSize, greenSize, blueSize, alphaSize, depthSize );
         if ( (redSize == RED_SIZE) &&
              (greenSize == GREEN_SIZE) &&
              (blueSize == BLUE_SIZE) &&
              (alphaSize == ALPHA_SIZE) &&
              (depthSize >= DEPTH_SIZE) )
         {
            GST_DEBUG( "setupEGL: choosing config %d\n", i);
            break;
         }
      }

      if ( i == configCount )
      {
         GST_ERROR("no suitable configuration available\n");
         goto exit;
      }
      sink->soc.eglConfig= eglConfigs[i];

      #ifdef USE_GLES2
      ctxAttrib[0]= EGL_CONTEXT_CLIENT_VERSION;
      ctxAttrib[1]= 2;
      ctxAttrib[2]= EGL_NONE;
      #endif

      sink->soc.eglContext= eglCreateContext( sink->soc.eglDisplay,
                                              sink->soc.eglConfig,
                                              EGL_NO_CONTEXT,
                                              #ifdef USE_GLES2
                                              ctxAttrib
                                              #else
                                              NULL
                                              #endif
                                            );
      if ( sink->soc.eglContext == EGL_NO_CONTEXT )
      {
         GST_ERROR("eglCreateContext failed: %X", eglGetError());
         goto exit;
      }
      GST_INFO("setupEGL: eglContext: %p\n", sink->soc.eglContext);

      sink->soc.eglSetup= true;
   }

exit:

   result= (sink->soc.eglSetup == true);

   if ( eglConfigs )
   {
      free( eglConfigs );
   }

   if ( !result )
   {
      termEGL( sink );
   }

   return result;
}

static void termEGL( GstWesterosSink *sink )
{
   if ( sink->soc.eglDisplay != EGL_NO_DISPLAY )
   {
      eglMakeCurrent( sink->soc.eglDisplay, EGL_NO_SURFACE, EGL_NO_SURFACE, EGL_NO_CONTEXT );
      eglDestroyContext( sink->soc.eglDisplay, sink->soc.eglContext );
      sink->soc.eglContext= EGL_NO_CONTEXT;

      if ( !sink->soc.sharedWLDisplay )
      {
         eglTerminate( sink->soc.eglDisplay );
         sink->soc.eglDisplay= EGL_NO_DISPLAY;
         eglReleaseThread();
      }
   }
   sink->soc.eglSetup= false;
}

#ifdef USE_GLES2
static const char *fragShaderText =
  "#ifdef GL_ES\n"
  "precision mediump float;\n"
  "#endif\n"
  "uniform sampler2D s_texture;\n"
  "uniform float u_alpha;\n"
  "varying vec2 v_uv;\n"
  "void main()\n"
  "{\n"
  "  gl_FragColor = texture2D(s_texture, v_uv) * u_alpha;\n"
  "}\n";

static const char *vertexShaderText =
  "uniform vec2 u_resolution;\n"
  "uniform mat4 amymatrix;\n"
  "attribute vec2 pos;\n"
  "attribute vec2 uv;\n"
  "varying vec2 v_uv;\n"
  "void main()\n"
  "{\n"
  "  vec4 p = amymatrix * vec4(pos, 0, 1);\n"
  "  vec4 zeroToOne = p / vec4(u_resolution, u_resolution.x, 1);\n"
  "  vec4 zeroToTwo = zeroToOne * vec4(2.0, 2.0, 1, 1);\n"
  "  vec4 clipSpace = zeroToTwo - vec4(1.0, 1.0, 0, 0);\n"
  "  clipSpace.w = 1.0+clipSpace.z;\n"
  "  gl_Position =  clipSpace * vec4(1, -1, 1, 1);\n"
  "  v_uv = uv;\n"
  "}\n";

static GLuint createShader(GstWesterosSink *sink, GLenum shaderType, const char *shaderSource )
{
   GLuint shader= 0;
   GLint shaderStatus;
   GLsizei length;
   char logText[1000];

   shader= glCreateShader( shaderType );
   if ( shader )
   {
      glShaderSource( shader, 1, (const char **)&shaderSource, NULL );
      glCompileShader( shader );
      glGetShaderiv( shader, GL_COMPILE_STATUS, &shaderStatus );
      if ( !shaderStatus )
      {
         glGetShaderInfoLog( shader, sizeof(logText), &length, logText );
         GST_ERROR("Error compiling %s shader: %*s\n",
                   ((shaderType == GL_VERTEX_SHADER) ? "vertex" : "fragment"),
                   length,
                   logText );
      }
   }

   return shader;
}
#endif

static bool setupGfx( GstWesterosSink *sink )
{
   bool result= false;

   if ( !sink->soc.gfxSetup )
   {
      EGLBoolean b;
      GLint statusShader;

      setupEGL( sink );

      sink->soc.wlEGLWindow= wl_egl_window_create( sink->surface, sink->windowWidth, sink->windowHeight );

      sink->soc.eglSurface= eglCreateWindowSurface( sink->soc.eglDisplay,
                                                    sink->soc.eglConfig,
                                                    (EGLNativeWindowType)sink->soc.wlEGLWindow,
                                                    NULL );
      GST_DEBUG("setupGfx: eglSurface %p\n", sink->soc.eglSurface );
      if ( sink->soc.eglSurface == EGL_NO_SURFACE )
      {
         GST_ERROR("eglCreateWindowSurface failed: %X", eglGetError());
         goto exit;
      }

      b= eglMakeCurrent( sink->soc.eglDisplay, sink->soc.eglSurface, sink->soc.eglSurface, sink->soc.eglContext );
      if ( !b )
      {
         GST_ERROR("eglMakeCurrent failed: %X", eglGetError());
         goto exit;
      }

      sink->soc.eglCreateImageKHR= (PFNEGLCREATEIMAGEKHRPROC)eglGetProcAddress("eglCreateImageKHR");
      GST_DEBUG("setupGfx: eglCreateImageKHR %p\n", sink->soc.eglCreateImageKHR );

      sink->soc.eglDestroyImageKHR= (PFNEGLDESTROYIMAGEKHRPROC)eglGetProcAddress("eglDestroyImageKHR");
      GST_DEBUG("setupGfx: eglDestroyImageKHR %p\n", sink->soc.eglDestroyImageKHR );

      glGetError();
      createImage( sink );

      #ifdef USE_GLES2
      sink->soc.vertId= createShader(sink, GL_VERTEX_SHADER, vertexShaderText);
      sink->soc.fragId= createShader(sink, GL_FRAGMENT_SHADER, fragShaderText);
      sink->soc.progId= glCreateProgram();
      glAttachShader(sink->soc.progId, sink->soc.vertId);
      glAttachShader(sink->soc.progId, sink->soc.fragId);
      glBindAttribLocation(sink->soc.progId, sink->soc.posLoc, "pos");
      glBindAttribLocation(sink->soc.progId, sink->soc.uvLoc, "uv");
      glLinkProgram(sink->soc.progId);
      glGetProgramiv(sink->soc.progId, GL_LINK_STATUS, &statusShader);
      if (!statusShader)
      {
         char log[1000];
         GLsizei len;
         glGetProgramInfoLog(sink->soc.progId, 1000, &len, log);
         GST_ERROR("Error: linking:\n%*s\n", len, log);
      }
      sink->soc.resLoc= glGetUniformLocation(sink->soc.progId,"u_resolution");
      sink->soc.matrixLoc= glGetUniformLocation(sink->soc.progId,"amymatrix");
      sink->soc.alphaLoc= glGetUniformLocation(sink->soc.progId,"u_alpha");
      sink->soc.textureLoc= glGetUniformLocation(sink->soc.progId,"s_texture");
      #else
      glHint( GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST );
      #endif

      //sink->soc.rend= &sink->soc.eglRend;

      sink->soc.gfxSetup= true;
   }

exit:

   result= (sink->soc.gfxSetup == true);

   return result;
}

static void termGfx( GstWesterosSink *sink )
{
   destroyImage( sink );
   #ifdef USE_GLES2
   if ( sink->soc.vertId )
   {
      glDeleteShader( sink->soc.vertId );
      sink->soc.vertId= 0;
   }
   if ( sink->soc.fragId )
   {
      glDeleteShader( sink->soc.fragId );
      sink->soc.fragId= 0;
   }
   if ( sink->soc.progId )
   {
      glDeleteProgram( sink->soc.progId );
      sink->soc.progId= 0;
   }
   #endif
   if ( sink->soc.eglSurface != EGL_NO_SURFACE )
   {
      eglDestroySurface( sink->soc.eglDisplay, sink->soc.eglSurface );
      sink->soc.eglSurface= EGL_NO_SURFACE;
   }
   if ( sink->soc.wlEGLWindow )
   {
      wl_egl_window_destroy( sink->soc.wlEGLWindow );
      sink->soc.wlEGLWindow= 0;
   }
   termEGL(sink);
   sink->soc.gfxSetup= false;
}

static void createImage( GstWesterosSink *sink )
{
   destroyImage( sink );

   glGenTextures( 1, &sink->soc.textureId );

   glBindTexture(GL_TEXTURE_2D, sink->soc.textureId);

   glTexImage2D( GL_TEXTURE_2D,
                 0,
                 GL_RGBA,
                 sink->soc.frameWidth,
                 sink->soc.frameHeight,
                 0,
                 GL_RGBA,
                 GL_UNSIGNED_BYTE,
                 NULL );

   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);

   sink->soc.eglImage= sink->soc.eglCreateImageKHR( sink->soc.eglDisplay,
                                                    sink->soc.eglContext,
                                                    EGL_GL_TEXTURE_2D_KHR,
                                                    (EGLClientBuffer)sink->soc.textureId,
                                                    NULL );

   sink->soc.textureWidth= sink->soc.frameWidth;
   sink->soc.textureHeight= sink->soc.frameHeight;
}

static void destroyImage( GstWesterosSink *sink )
{
   if ( sink->soc.textureId )
   {
      glDeleteTextures( 1, &sink->soc.textureId );
      sink->soc.textureId= 0;
   }
   if ( sink->soc.eglImage )
   {
      sink->soc.eglDestroyImageKHR( sink->soc.eglDisplay, sink->soc.eglImage );
      sink->soc.eglImage= 0;
   }
   sink->soc.textureWidth= 0;
   sink->soc.textureHeight= 0;
}

static void drawImage ( GstWesterosSink *sink )
{
   float x, y, w, h;

   x= 0;
   y= 0;
   w= sink->windowWidth;
   h= sink->windowHeight;

   const float verts[4][2] =
   {
      { x, y },
      { x+w, y },
      { x,  y+h },
      { x+w, y+h }
   };

   const float uv[4][2] =
   {
      #ifdef USE_GLES2
      { 0,  0 },
      { 1,  0 },
      { 0,  1 },
      { 1,  1 }
      #else
      { 0,  1 },
      { 1,  1 },
      { 0,  0 },
      { 1,  0 }
      #endif
   };

   #ifdef USE_GLES2
   glViewport( 0, 0, w, h );
   glClearColor( 0.0f, 1.0f, 0.0f, 1.0f );
   glClear( GL_COLOR_BUFFER_BIT );
   glEnable(GL_BLEND);

   glBlendFuncSeparate( GL_ONE, GL_ONE_MINUS_SRC_ALPHA, GL_ONE, GL_ONE );
   glUseProgram(sink->soc.progId);
   glUniform2f(sink->soc.resLoc, w, h);
   glUniformMatrix4fv(sink->soc.matrixLoc, 1, GL_FALSE, (GLfloat*)sink->soc.matrix);
   glUniform1f(sink->soc.alphaLoc, 1.0f);

   glActiveTexture(GL_TEXTURE0);
   glBindTexture(GL_TEXTURE_2D, sink->soc.textureId);
   glUniform1i(sink->soc.textureLoc, 0);
   glVertexAttribPointer(sink->soc.posLoc, 2, GL_FLOAT, GL_FALSE, 0, verts);
   glVertexAttribPointer(sink->soc.uvLoc, 2, GL_FLOAT, GL_FALSE, 0, uv);
   glEnableVertexAttribArray(sink->soc.posLoc);
   glEnableVertexAttribArray(sink->soc.uvLoc);
   glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
   glDisableVertexAttribArray(sink->soc.posLoc);
   glDisableVertexAttribArray(sink->soc.uvLoc);
   #else
   glViewport( 0, 0, w, h );
   glClearColor( 0.0f, 1.0f, 0.0f, 1.0f );
   glClear( GL_COLOR_BUFFER_BIT );
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glOrthof( 0.0f, sink->windowWidth, 0.0f, sink->windowHeight, 0.0f, 1.0f );
   glEnableClientState( GL_VERTEX_ARRAY );
   glVertexPointer( 2, GL_FLOAT, 0, verts );
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glTexCoordPointer(2, GL_FLOAT, 0, uv);
   glEnableClientState(GL_TEXTURE_COORD_ARRAY);
   glEnable(GL_TEXTURE_2D);
   glBindTexture(GL_TEXTURE_2D, sink->soc.textureId);
   glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
   #endif

   glFlush();
   glFinish();

   eglSwapBuffers( sink->soc.eglDisplay, sink->soc.eglSurface );

   wl_display_flush(sink->display);
   wl_display_dispatch_queue_pending(sink->display, sink->queue);
}

static void processFrame( GstWesterosSink *sink, GstBuffer *buffer )
{
   int rc;
   OMX_ERRORTYPE omxerr;
   OMX_BUFFERHEADERTYPE *buff= 0;
   #ifdef USE_GST1
   GstMapInfo map;
   #endif
   int inSize, avail, copylen, filledlen;
   unsigned char *inData;
   bool windowChange;
   gint64 nanoTime;

   if ( sink->soc.flush_done && !sink->flushStarted )
   {
      #ifdef USE_GST1
      gst_buffer_map(buffer, &map, (GstMapFlags)GST_MAP_READ);
      inSize= map.size;
      inData= map.data;
      #else
      inSize= (int)GST_BUFFER_SIZE(buffer);
      inData= GST_BUFFER_DATA(buffer);
      #endif

      GST_LOG("processFrame: buffer %p, len %d timestamp: %lld", buffer, inSize, GST_BUFFER_PTS(buffer) );

      nanoTime= GST_BUFFER_PTS(buffer);

      if (sink->soc.hwavsync == FALSE)
      {
        LOCK(sink);
        sink->position= nanoTime;
        sink->currentPTS= ((sink->position * 90000LL)/GST_SECOND);
        UNLOCK(sink);
      }

      while ( inSize )
      {
          //TODO: realtek copy frame?
          break;
      }

      #ifdef USE_GST1
      gst_buffer_unmap( buffer, &map);
      #endif
   }

exit:
   return;
}

static gpointer captureThread(gpointer data)
{
   GstWesterosSink *sink= (GstWesterosSink*)data;

   GST_DEBUG_OBJECT(sink, "captureThread: enter");

#if 0
   setupGfx( sink );
#endif

   while( !sink->soc.quitCaptureThread )
   {
#if 0
      waitForNewFrame( sink );
      if ( sink->soc.useGfxPath && sink->soc.newFrame )
      {
         sink->soc.newFrame= false;
         drawImage( sink );
      }
#endif
      LOCK( sink );
      //gboolean videoPlaying = sink->soc.video_playing;
      gboolean eosDetected = sink->eosDetected;
      if (sink->windowChange && sink->display && sink->queue && sink->registry && sink->vpcSurface)
      {
         sink->windowChange= false;
         gst_westeros_sink_soc_update_video_position( sink );
      }
      UNLOCK( sink );

      if (sink->display && sink->surface && wl_display_dispatch_queue_pending(sink->display, sink->queue) == 0)
      {
         wl_display_flush(sink->display);
         if ( !eosDetected )
         {
            wl_display_roundtrip_queue(sink->display,sink->queue);
         }
      }

      usleep(VIDEO_POLL_INTERVAL);
   }

   GST_DEBUG_OBJECT(sink, "captureThread: ending");

   GST_DEBUG_OBJECT(sink, "captureThread: exit");

   g_thread_exit(NULL);

   return NULL;
}

// For soc specfic pad query
gboolean gst_westeros_sink_soc_query( GstWesterosSink *sink, GstQuery *query )
{
    GstWesterosSinkSoc *socsink = &sink->soc;
    gboolean result = FALSE;
    GstFormat format;
    GstStructure *structure = NULL;
    gchar* sstr = NULL;
    GST_DEBUG_OBJECT (sink, "name: %s (0x%x)", gst_query_type_get_name( GST_QUERY_TYPE(query)), GST_QUERY_TYPE(query));

    switch (GST_QUERY_TYPE (query)) {
        case GST_QUERY_POSITION:
            gst_query_parse_position (query, &format, NULL);
            if (format == GST_FORMAT_TIME) {
                if (socsink->update_time != -1)
                    gst_query_set_position(query, format, socsink->update_time - socsink->first_time);
                else
                    gst_query_set_position(query, format, 0);
            }
            result = TRUE;
            break;
        case GST_QUERY_DRAIN:
            GST_INFO_OBJECT(sink, "Drain +");
            socsink->flush = TRUE;
            socsink->is_draining = TRUE;

            gst_rtk_v1_sink_flush_and_alias_frame(sink);

            socsink->is_draining = FALSE;
            socsink->flush = FALSE;
            socsink->flushed = TRUE;
            //result = GST_BASE_SINK_CLASS (parent_class)->query (GST_BASE_SINK (sink), query);
            RTK_LOG_INFO(sink, "Drain -");
            break;
        case GST_QUERY_CUSTOM:
            structure = gst_query_get_structure (query);
            sstr = gst_structure_to_string (structure);
            GST_INFO_OBJECT (sink, "GST_QUERY_CUSTOM: %s", sstr);
            if (gst_structure_has_field (structure, "is-v2-plane"))
            {
                gst_structure_set (structure, "is-v2-plane", G_TYPE_BOOLEAN, (sink->soc.vo_plane == PLANE_V2), NULL);
                result = TRUE;
            }
            g_free (sstr);
            break;
        default:
            //result = GST_BASE_SINK_CLASS (parent_class)->query (GST_BASE_SINK (sink), query);
            break;
    }

    return result;
}

void gst_westeros_sink_soc_set_speed( GstWesterosSink * sink, const GValue * value )
{
    GstWesterosSinkSoc *socsink = &sink->soc;
    gdouble rate = g_value_get_double (value);
    GST_INFO_OBJECT(sink, "Set playback rate %f", rate);
    socsink->target_fw_speed = rate;
}

// For soc specific element query
static gboolean gst_westeros_sink_soc_query_element( GstElement *element, GstQuery *query )
{
   gboolean result = FALSE;
   GstWesterosSink *sink= GST_WESTEROS_SINK(element);

   switch (GST_QUERY_TYPE(query))
   {
      case GST_QUERY_POSITION:
         //TODO realtek query fw clock? brcm didn't have this func
         break;
       default:
         break;
   }
   if ( queryOrg )
   {
      result= queryOrg( element, query );
   }
   return result;
}

static void
gst_rtk_v1_sink_flush_and_alias_frame(GstWesterosSink *sink)
{
    GstWesterosSinkSoc *socsink = &sink->soc;
    int i;
    int status;
    int last_frame_index = -1;
    int latest_lock_index = 2 * VO_BUF_NUM;
    int bNeedRender = 0;
    int videomode = 0;
    int audiomode = 0;
    int systemmode = 0;
    int state = 0;
    if (socsink->flushed) {
        if (!socsink->is_draining) {
            socsink->frameCountW = 0;
            socsink->frameCountR = 0;
        }
        RTK_LOG_INFO(sink,"Already flushed. Skip!!\n");
        return;
    }

    if (sink->soc.hwavsync == TRUE && socsink->master_mode!=MASTER_MODE_PCR){
        vo_wrap_get_MasterMode(socsink->m_voplane, &systemmode, &videomode, &audiomode, &state);
        gst_rtk_v1_sink_set_avsync_mode( sink, FREE_RUN);
    }

#if RTK_USE_FW_KEEP_FRAME
    int wait_cnt = 60;
    int diff = 0;
    if (socsink->avg_diff_us && socsink->video_playing && socsink->is_draining) {
        int vo_queue_cnt = socsink->v1_QueueIndexW - socsink->v1_QueueIndexR;
        if (vo_queue_cnt < 0) {
            vo_queue_cnt += VO_BUF_NUM;
        }
        wait_cnt = (socsink->avg_diff_us/90) * vo_queue_cnt;
        GST_INFO_OBJECT(sink, "Index status:(R:%d/W:%d) avg_diff_us:%lld wait_cnt:%d", socsink->v1_QueueIndexR, socsink->v1_QueueIndexW, socsink->avg_diff_us, wait_cnt);
    }
    while (1)
    {
        pthread_mutex_lock(&socsink->frame_mutex);
        diff = socsink->v1_QueueIndexW - socsink->v1_QueueIndexR;
        pthread_mutex_unlock(&socsink->frame_mutex);
        if (diff < 0) diff += VO_BUF_NUM;
        if (diff <= 1 || wait_cnt <= 0)
            break;

        wait_cnt--;
        usleep(1000);
    }

    pthread_mutex_lock(&socsink->frame_mutex);
    if (sink->soc.frameCountW > 0) {
#if defined(ENABLE_TEE_DRM_FLOW)
      if(socsink->is_secure_path == TRUE) {
        last_frame_index = socsink->v1_QueueIndexW-1;
        if (last_frame_index < 0) {
          last_frame_index = VO_BUF_NUM - 1;
        }
      } else
#endif
      {
        GST_INFO_OBJECT(sink, "keep@IndexR=%d IndexW=%d", socsink->v1_QueueIndexR, socsink->v1_QueueIndexW);
        vo_wrap_set_VO_MallocKeepCurFrame(socsink->m_voplane);
      }
    }
#endif

    GST_DEBUG_OBJECT(sink, "[FrameMutex][+][%s]", __FUNCTION__);
    GST_DEBUG_OBJECT(sink, "[socsink] R/W=%d/%d", socsink->v1_QueueIndexR, socsink->v1_QueueIndexW);

    //print debug info
    for (i = 0; i < VO_BUF_NUM; i++) {
        status = vo_wrap_PLockGetStatus(socsink->m_voplane, i);
        GST_DEBUG_OBJECT(sink, "[bf] VO flush, i:%d, st:%d, y:0x%08x", i, status, socsink->v1_vobuf[i].phys_addr);
    }

    //call VO flush
    vo_wrap_set_VO_FLUSH(socsink->m_voplane);
    if (!socsink->is_draining) {
        socsink->frameCountW = 0;
        socsink->frameCountR = 0;
    }
    socsink->avg_diff_us = 0;
    socsink->firstFramePTS = -1;
    socsink->flush_during_render = (socsink->render == 1)?1:0;

    int lock_count = 0; // for testing
    gboolean bhasOutOfIntervalLocked = FALSE;
    gboolean bReleaseOldLocked = FALSE;
    //print debug info
    for (i = 0; i < VO_BUF_NUM; i++) {
        status = vo_wrap_PLockGetStatus(socsink->m_voplane, i);
        GST_DEBUG_OBJECT(sink, "[af] VO flush, i:%d, st:%d, y:0x%08x", i, status, socsink->v1_vobuf[i].phys_addr);
        if (status != PLOCK_STATUS_INIT) {
            lock_count++;
            if (status == PLOCK_STATUS_LOCK) {
                if (latest_lock_index == 2*VO_BUF_NUM)
                    latest_lock_index = i;
                if (socsink->v1_QueueIndexR > socsink->v1_QueueIndexW) {
                    if (!bhasOutOfIntervalLocked && i < socsink->v1_QueueIndexW)
                        latest_lock_index = ((i + VO_BUF_NUM) > latest_lock_index)? (i + VO_BUF_NUM) : latest_lock_index;
                    if (!bhasOutOfIntervalLocked && i > socsink->v1_QueueIndexR)
                        latest_lock_index = (i > latest_lock_index)? i : latest_lock_index;
                    if (socsink->v1_QueueIndexW < i && i < socsink->v1_QueueIndexR) {// Current index is out of R/W interval
                        latest_lock_index = i;
                        bhasOutOfIntervalLocked = TRUE;
                        lock_count --;
                    }
                } else {
                    if (!bhasOutOfIntervalLocked && i > latest_lock_index)
                        latest_lock_index = i;
                    if (i < socsink->v1_QueueIndexR || socsink->v1_QueueIndexW < i) {// Current index is out of R/W interval
                        latest_lock_index = i;
                        bhasOutOfIntervalLocked = TRUE;
                        lock_count --;
                    }
                }
#if RTK_USE_BUFLOCK
                if (!bhasOutOfIntervalLocked && !bReleaseOldLocked) {
                    // The locked frame is in the R/W interval.
                    for (int i = 0; i < MAX_BUFLOCKS; i++) {
                        if (socsink->Blid[i] != -1) {
                            GST_INFO_OBJECT(sink, "release old locked buf blid:%d", socsink->Blid[i]);
                            buflock_Free(socsink->Buflock[i], socsink->Blid[i]);
                            socsink->Blid[i] = -1;
                        }
                    }
                    bReleaseOldLocked = TRUE;
                }
                VOUT_BUFFER *vb = &socsink->v1_vobuf[i];
                if (vb->meta_type == METADATA_VRPC_DVO_INFO && !bhasOutOfIntervalLocked) {
                    vrpc_dvo_info_t *p = (vrpc_dvo_info_t*) SystemMemory_GetVirAddr(socsink->v1_vobuf[i].meta_handle);
                    if (p) {
                        int j = 0;
                        while (j < MAX_BUFLOCKS) {
                            if (socsink->Blid[j] == -1)
                                break;
                            j++;
                        }
                        if (j < MAX_BUFLOCKS) {
                            socsink->Blid[j] = p->blid;
                            if (socsink->Blid[j] != -1) {
                                buflock_Import(socsink->Buflock[j], socsink->Blid[j]);
                                GST_INFO_OBJECT(sink, "locked buf blid:%d", socsink->Blid[j]);
                            }
                            else {
                                GST_ERROR_OBJECT(sink,"Invalid blid:%d ...", socsink->Blid[j]);
                            }
                        } else {
                            GST_WARNING_OBJECT(sink,"Frame lock_cnt:%d is more then MAX_BUFLOCKS cnt:%d", lock_count, MAX_BUFLOCKS);
                        }
                    }
                }
#endif//RTK_USE_BUFLOCK
            }
        }
    }

    if (latest_lock_index != 2*VO_BUF_NUM) {
        if (latest_lock_index >= VO_BUF_NUM) {
            latest_lock_index -= VO_BUF_NUM;
        }
        if (socsink->v1_QueueIndexR > socsink->v1_QueueIndexW) {
            if (socsink->v1_QueueIndexW < latest_lock_index && latest_lock_index < socsink->v1_QueueIndexR) {// Index is out of R/W interval
                GST_DEBUG_OBJECT(sink, "latest_lock_index(%d) is out of R/W(%d/%d) interval", latest_lock_index, socsink->v1_QueueIndexR, socsink->v1_QueueIndexW);
                latest_lock_index = -1;
            }
        } else {
            if (latest_lock_index < socsink->v1_QueueIndexR || socsink->v1_QueueIndexW < latest_lock_index) {// Index is out of R/W interval
                GST_DEBUG_OBJECT(sink, "latest_lock_index(%d) is out of R/W(%d/%d) interval", latest_lock_index, socsink->v1_QueueIndexR, socsink->v1_QueueIndexW);
                latest_lock_index = -1;
            }
        }
        if (last_frame_index != -1 && last_frame_index != latest_lock_index) {
            GST_INFO_OBJECT(sink, "last_frame_index(%d) latest_lock_index(%d) are different", last_frame_index, latest_lock_index);
            last_frame_index = latest_lock_index;
        }
    }

    if (last_frame_index != -1 && !socsink->mute && socsink->is_secure_path) {
        GST_INFO_OBJECT(sink, "SVP_keep@Index:%d IndexR/IndexW(%d/%d)", last_frame_index, socsink->v1_QueueIndexR, socsink->v1_QueueIndexW);
        gst_rtk_v1_svp_keep_frame(socsink, last_frame_index);
    }

    if (lock_count > 1) {
        GST_WARNING_OBJECT(sink, "More than one frame buffer locked after VO flush.");
    }
    GST_DEBUG_OBJECT(sink, "[xxx]after VO flush, v1_QueueIndexR:%d, v1_QueueIndexW:%d", socsink->v1_QueueIndexR, socsink->v1_QueueIndexW);

#if RTK_USE_FW_KEEP_FRAME
    while (lock_count > 0) {
        if (socsink->v1_Buf[socsink->v1_QueueIndexR]) {
            gst_buffer_unref(socsink->v1_Buf[socsink->v1_QueueIndexR]);
            socsink->v1_Buf[socsink->v1_QueueIndexR] = NULL;
            vo_wrap_PLockSetStatus(socsink->m_voplane, socsink->v1_QueueIndexR, PLOCK_STATUS_INIT);
            socsink->v1_QueueIndexR = (socsink->v1_QueueIndexR + 1) % VO_BUF_NUM;
        } else
            GST_WARNING_OBJECT(sink, "indexR:%d v1_buf is null",socsink->v1_QueueIndexR);
        lock_count--;
    }

    pthread_mutex_unlock(&socsink->frame_mutex);

    if (sink->soc.hwavsync == TRUE && socsink->master_mode!=MASTER_MODE_PCR) {
        vo_wrap_set_MasterMode(socsink->m_voplane,
            systemmode,  /* system */
            videomode, /* video */
            audiomode   /* audio */);
    }

    return;
#else
    // prepare an alias frame
    if (socsink->v1_QueueIndexR != socsink->v1_QueueIndexW) {
        last_frame_index = socsink->v1_QueueIndexW - 1;
        if (last_frame_index < 0) {
            last_frame_index = VO_BUF_NUM - 1;
        }

        GST_DEBUG_OBJECT(sink, "[realtek] last frame index:%d, last frame v1_wIndex:%d, v1_QueueIndexR:%d, v1_QueueIndexW:%d @@",
            last_frame_index, socsink->v1_vobuf[last_frame_index].v1_wIndex, socsink->v1_QueueIndexR, socsink->v1_QueueIndexW);

        status = vo_wrap_PLockGetStatus(socsink->m_voplane, last_frame_index);
        if (status != PLOCK_STATUS_LOCK || socsink->v1_vobuf[socsink->v1_QueueIndexR].alias_frame != 1) {
            if (socsink->aliasFrameBuf.phys_addr !=0) {
                GST_INFO_OBJECT(sink, "aliasFrameBuf with v1_wIndex(%d) is not empty!", socsink->aliasFrameBuf.v1_wIndex);
            }

            //Copy alias frame
            memset(&socsink->aliasFrameBuf, 0, sizeof(VOUT_BUFFER));
            socsink->aliasFrameBuf.meta_type = socsink->v1_vobuf[last_frame_index].meta_type;
#if defined(ENABLE_TEE_DRM_FLOW)
            vo_wrap_alloc_size(socsink->m_voplane, &socsink->aliasFrameBuf, socsink->v1_vobuf[last_frame_index].alloc_size, socsink->is_secure_path);
#else
            vo_wrap_alloc_size(socsink->m_voplane, &socsink->aliasFrameBuf, socsink->v1_vobuf[last_frame_index].alloc_size, FALSE);
#endif //!defined(ENABLE_TEE_DRM_FLOW)
            if (socsink->aliasFrameBuf.phys_addr != 0) {
                bNeedRender = 1;
                gst_rtk_v1_cpy_alias_frame(socsink, &socsink->v1_vobuf[last_frame_index], &socsink->aliasFrameBuf);
            }

        }
    }

    // free/unref frame buffer
    int count = socsink->v1_QueueIndexW - socsink->v1_QueueIndexR;
    if (count < 0) count += VO_BUF_NUM;
    GST_INFO_OBJECT(sink, "frame count: %d, R/W=%d/%d", count, socsink->v1_QueueIndexR, socsink->v1_QueueIndexW);
    while (count > 0) {
        status = vo_wrap_PLockGetStatus(socsink->m_voplane, socsink->v1_QueueIndexR);
        if (status == PLOCK_STATUS_UNLOCK) {
            if (socsink->v1_vobuf[socsink->v1_QueueIndexR].alias_frame == 0) {
                //unreference gstbuffer
                gst_buffer_unref(socsink->v1_Buf[socsink->v1_QueueIndexR]);
                socsink->v1_Buf[socsink->v1_QueueIndexR] = NULL;
            } else {
                //free alias frame
                if (socsink->v1_vobuf[socsink->v1_QueueIndexR].phys_addr != 0) {
                    vo_wrap_free_mem(socsink->m_voplane, &socsink->v1_vobuf[socsink->v1_QueueIndexR]);
                }
                memset(&(socsink->v1_vobuf[socsink->v1_QueueIndexR]), 0, sizeof(VOUT_BUFFER));
            }
            vo_wrap_PLockSetStatus(socsink->m_voplane, socsink->v1_QueueIndexR, PLOCK_STATUS_INIT);
            socsink->v1_QueueIndexR = (socsink->v1_QueueIndexR + 1) % VO_BUF_NUM;
            GST_DEBUG_OBJECT(sink, "[socsink] update R to %d", socsink->v1_QueueIndexR);
        } else if (status == PLOCK_STATUS_LOCK || status == PLOCK_STATUS_QPEND) {
            GST_WARNING_OBJECT(sink, "frame(R idx:%d) status: %d, (v1_QueueIndexW:%d), SHOULD check R/W index to see if only keep one frame?",
                socsink->v1_QueueIndexR, status, socsink->v1_QueueIndexW);
            break;
        }
        count--;
    }
    GST_INFO_OBJECT(sink, "@@@ frame count be kept: %d, bNeedRender:%d", count, bNeedRender);
#endif  //#if RTK_USE_FW_KEEP_FRAME

    //render
    if (bNeedRender == 1) {
        //render
        socsink->aliasFrameBuf.v1_wIndex = socsink->v1_QueueIndexW;
        memcpy(&socsink->v1_vobuf[socsink->v1_QueueIndexW], &socsink->aliasFrameBuf, sizeof(VOUT_BUFFER));
        socsink->v1_Buf[socsink->v1_QueueIndexW] = NULL;

        vo_wrap_render (socsink->m_voplane, &socsink->aliasFrameBuf);
        GST_INFO_OBJECT(sink, "[xxx] render alias frame with v1_wIndex:%d", socsink->aliasFrameBuf.v1_wIndex);
        last_frame_index = socsink->v1_QueueIndexW;
        socsink->v1_QueueIndexW = (socsink->v1_QueueIndexW + 1) % VO_BUF_NUM;
        GST_LOG_OBJECT(sink, "[socsink] update W to %d", socsink->v1_QueueIndexW);
    }

    GST_DEBUG_OBJECT(sink, "[FrameMutex][-][%s]", __FUNCTION__);
    pthread_mutex_unlock(&socsink->frame_mutex);

    //wait until alias frame displaying
    if (bNeedRender == 1) {
        int waitingCount = 0;
        while (last_frame_index != socsink->v1_QueueIndexR) {
            GST_DEBUG_OBJECT(sink, "$$$  IndexR=%d IndexW=%d last_frame_index:%d",
                socsink->v1_QueueIndexR, socsink->v1_QueueIndexW, last_frame_index);
            usleep(1000);
            waitingCount++;
            if (waitingCount >= 1000) {
                GST_WARNING_OBJECT(sink, "Waiting 1000 times for last frame displaying, but IndexR can't move in vo_queue_loop()");
                break;
            }
        }
    }

    if (sink->soc.hwavsync == TRUE && socsink->master_mode!=MASTER_MODE_PCR) {
        vo_wrap_set_MasterMode(socsink->m_voplane,
            systemmode,  /* system */
            videomode, /* video */
            audiomode   /* audio */);
    }
}

static void
gst_rtk_v1_sink_property_set_bring_to_front(GstWesterosSink * sink)
{
    GstWesterosSinkSoc *socsink = &sink->soc;
    VO_WRAP_MIXER_ORDER _order;
    GST_LOG_OBJECT (sink, "socsink->bring_to_front=%d", socsink->bring_to_front);
    socsink->order = vo_wrap_get_z_order(); // store original order

    if (socsink->bring_to_front) {
    GST_LOG_OBJECT (sink, "order->v1=%d, order->osd1=%d", socsink->order.v1, socsink->order.osd1);

    // In the case of ubuntu rootfs, we only care about order of osd1 and v1. If there is other case, please add more checks
    if (socsink->order.osd1 > socsink->order.v1) {
      _order = socsink->order;
      _order.v1 = socsink->order.osd1;
      _order.osd1 = socsink->order.v1;
      vo_wrap_configure_z_order(&_order);
    } else {
      // v1 is already on top of osd1.
    }
    }
}

static void
gst_rtk_v1_sink_property_set_enable_osd(GstWesterosSink * sink)
{
    GstWesterosSinkSoc *socsink = &sink->soc;
    vo_wrap_query_display_window(VO_WRAP_VIDEO_PLANE_OSD1, &socsink->osd1_rect); // store size of OSD 1
    GST_LOG_OBJECT (sink, "osd1_rect.width=%d, osd1_rect.height=%d", socsink->osd1_rect.width, socsink->osd1_rect.height);
    if (socsink->enable_osd == OSDMODE_ENABLE) {
    if (socsink->osd1_rect.width && socsink->osd1_rect.height) {
      GST_LOG_OBJECT (sink, "keep original size");
    } else {
      GST_LOG_OBJECT (sink, "vo_osd1_enable()-> set the size to mix1 win");
      vo_osd1_enable();
    }
    } else {
    GST_LOG_OBJECT (sink, "vo_osd1_disable()");
    vo_osd1_disable();
    }
}

static void
gst_rtk_v1_sink_property_set_output_rectangle(GstWesterosSink * sink, int x, int y, int w, int h)
{
  GstWesterosSinkSoc *socsink = &sink->soc;
  GST_DEBUG_OBJECT (sink, "set_output_rectangle");

  if (sink->soc.resource_released) {
      RTK_LOG_INFO(sink, "Skip output plane setting since resource already been released");
  }

  socsink->tv_mode = vo_wrap_get_tv_resolution();
  GST_INFO_OBJECT (sink, "rectangle: old(x %d y %d w %d h %d), new(x %d y %d w %d h %d)\n",
          socsink->x, socsink->y, socsink->width, socsink->height,
    x, y, w, h);

  if (x != socsink->x || y != socsink->y || w != socsink->width || h != socsink->height) {

#if defined(MODE_1080P)
      switch(socsink->tv_mode){
          case VO_WRAP_RES_NTSC_M:
          case VO_WRAP_RES_480P60:
              x *= 3; x /= 8;
              y *= 4; y /= 9;
              w *= 3; w /= 8;
              h *= 4; h /= 9;
              break;
          case VO_WRAP_RES_PAL_M:
          case VO_WRAP_RES_PAL_BGH:
              x *= 3; x /= 8;
              y *= 8; y /= 15;
              w *= 3; w /= 8;
              h *= 8; h /= 15;
              break;
          case VO_WRAP_RES_720P60:
          case VO_WRAP_RES_720P50:
              //printf("[realtek] seting 720: x %d y %d w %d h %d\n", x, y, w, h);
              x *= 2; x /= 3;
              y *= 2; y /= 3;
              w *= 2; w /= 3;
              h *= 2; h /= 3;
              break;
          case VO_WRAP_RES_1080P24:
          case VO_WRAP_RES_1080P30:
          case VO_WRAP_RES_1080P60:
          case VO_WRAP_RES_1080P50:
          case VO_WRAP_RES_1080I60:
          case VO_WRAP_RES_1080I50:
              //base is 1080P, so do nothing.
              //printf("[realtek] seting 1080: x %d y %d w %d h %d\n", x, y, w, h);
              break;
          case VO_WRAP_RES_2160P24:
          case VO_WRAP_RES_2160P25:
          case VO_WRAP_RES_2160P30:
          case VO_WRAP_RES_2160P50:
          case VO_WRAP_RES_2160P60:
          case VO_WRAP_RES_4096_2160P24:
          case VO_WRAP_RES_4096_2160P25:
          case VO_WRAP_RES_4096_2160P30:
          case VO_WRAP_RES_4096_2160P50:
          case VO_WRAP_RES_4096_2160P60:
              x *= 2;
              y *= 2;
              w *= 2;
              h *= 2;
              //printf("[realtek] seting 4K: x %d y %d w %d h %d\n", x, y, w, h);
              break;
          default:
              break;
      }
      w *= socsink->virtualWidthFactor;
      h *= socsink->virtualHeightFactor;
#else  // default 720p
    switch(socsink->tv_mode){
       case VO_WRAP_RES_NTSC_M:
       case VO_WRAP_RES_480P60:
               x *= 9; x /= 16;
               y *= 2; y /= 3;
               w *= 9; w /= 16;
               h *= 2; h /= 3;
               break;
       case VO_WRAP_RES_PAL_M:
       case VO_WRAP_RES_PAL_BGH:
               x *= 9; x /= 16;
               y *= 4; y /= 5;
               w *= 9; w /= 16;
               h *= 4; h /= 5;
               break;
       case VO_WRAP_RES_720P60:
       case VO_WRAP_RES_720P50:
               //printf("[realtek] seting 720: x %d y %d w %d h %d\n", x, y, w, h);
               break;
       case VO_WRAP_RES_1080P24:
       case VO_WRAP_RES_1080P30:
       case VO_WRAP_RES_1080P60:
       case VO_WRAP_RES_1080P50:
       case VO_WRAP_RES_1080I60:
       case VO_WRAP_RES_1080I50:
               x *= 1.5;
               y *= 1.5;
               w *= 1.5;
               h *= 1.5;
               //printf("[realtek] seting 1080: x %d y %d w %d h %d\n", x, y, w, h);
               break;
       case VO_WRAP_RES_2160P24:
       case VO_WRAP_RES_2160P25:
       case VO_WRAP_RES_2160P30:
       case VO_WRAP_RES_2160P50:
       case VO_WRAP_RES_2160P60:
       case VO_WRAP_RES_4096_2160P24:
       case VO_WRAP_RES_4096_2160P25:
       case VO_WRAP_RES_4096_2160P30:
       case VO_WRAP_RES_4096_2160P50:
       case VO_WRAP_RES_4096_2160P60:
              x *= 3;
              y *= 3;
              w *= 3;
              h *= 3;
              //printf("[realtek] seting 4K: x %d y %d w %d h %d\n", x, y, w, h);
              break;
       default:
               break;
    }
#endif //end of defined check

    RTK_LOG_INFO(sink, "set display window: x(%d) y(%d) w(%d) h(%d) zoom:%u force-aspect-ratio:%s", x, y, w, h,
                            socsink->zoom,(socsink->forceAspectRatio == TRUE)?"TRUE":"FALSE");

    //config display window
    vo_wrap_set_display_window(socsink->m_voplane, x, y, w, h);

    if (socsink->forceAspectRatio) {
      vo_wrap_v1_set_rescale(socsink->m_voplane, VO_WRAP_RESCALE_MODE_KEEP_AR_AUTO);
    } else if(socsink->zoom){
      vo_wrap_v1_set_rescale(socsink->m_voplane, VO_WRAP_RESCALE_MODE_FULL_SCALE);
    }else{
      vo_wrap_v1_set_rescale(socsink->m_voplane, VO_WRAP_RESCALE_MODE_KEEP_AR_AUTO);
    }
    socsink->x = x;
    socsink->y = y;
    socsink->width = w;
    socsink->height = h;
  }
}

static int
gst_rtk_v1_sink_convertToVoutWrapPlane(GstWesterosSinkPlane vop)
{
    int ret_vo;
    switch(vop) {
    case PLANE_WIN1:
        ret_vo = VO_WRAP_VIDEO_PLANE_WIN1;
        break;
    case PLANE_WIN2:
        ret_vo = VO_WRAP_VIDEO_PLANE_WIN2;
        break;
#if defined(ENABLE_V2_PLANE)
    case PLANE_V2:
        ret_vo = VO_WRAP_VIDEO_PLANE_V2;
        break;
#endif
    case PLANE_V1:
    default:
        ret_vo = VO_WRAP_VIDEO_PLANE_V1;
        break;
    }
    return ret_vo;
}

static void
gst_rtk_v1_sink_property_set_output_plane(GstWesterosSink * sink, GstWesterosSinkPlane plane)
{
    GstWesterosSinkSoc *socsink = &sink->soc;
    GST_DEBUG_OBJECT (sink, "set_output_plane");

#if defined(ENABLE_V2_PLANE)
    // only support V1, V2, WIN1, WIN2
    if (plane != PLANE_V1 && plane != PLANE_V2 && plane != PLANE_WIN1 && plane != PLANE_WIN2) {
        return;
    }
#else
    // only support V1, WIN1, WIN2
    if (plane != PLANE_V1 && plane != PLANE_WIN1 && plane != PLANE_WIN2) {
        return;
    }
#endif

    if (sink->soc.resource_released) {
        RTK_LOG_INFO(sink, "Skip output plane setting since resource already been released");
    }

    if (plane != socsink->vo_plane) {
        GST_DEBUG_OBJECT(sink, "change vo plane from %d to %d", socsink->vo_plane, plane);
        VO_WRAP_VIDEO_PLANE voplane = gst_rtk_v1_sink_convertToVoutWrapPlane(plane);
        if (gst_rtk_video_plane_init(sink, voplane) == 0){
            int i;
            for (i=0; i<VO_BUF_NUM; i++)
            {
                vo_wrap_PLockSetStatus(voplane, i, PLOCK_STATUS_INIT);
            }
        }
        socsink->handle = vo_wrap_get_handle();

        if (plane == PLANE_WIN1 || plane == PLANE_WIN2) {
            ST_RECTANGLE stRect = {0, 0};
            //config plane mixer
            vo_wrap_config_mixer_window();
            //config V1 to full screen
            gst_rtk_v1_sink_get_output_window(&stRect);
            vo_wrap_set_display_window(VO_WRAP_VIDEO_PLANE_V1, 0, 0, (int)stRect.width, (int)stRect.height);
        } else if (plane == PLANE_V1) {
            //disable plane mixer
            vo_wrap_disable_mixer_window();
        }

        //config display window of new plane
        if (socsink->width != -1 && socsink->height != -1) {
            vo_wrap_set_display_window(voplane,
                    socsink->x, socsink->y, socsink->width, socsink->height);
        }

        //change VO display to new plane
        vo_wrap_change_displaying_vidoe_plane(voplane);

        if (plane == PLANE_WIN1 || plane == PLANE_WIN2) {
            //need to clear v1 vout
            vo_wrap_close(socsink->m_voplane);
        }

        //finally, keep value
        socsink->vo_plane = plane;
        socsink->m_voplane = voplane;
    }
    return;
}

static void gst_rtk_v1_sink_set_avsync_mode(GstWesterosSink *sink, int mode)
{
  GstWesterosSinkSoc *socsink = &sink->soc;

  if (!socsink->hasAudio)
    vo_wrap_get_pb_avstate(socsink->m_voplane, NULL, &socsink->hasAudio);

  if (!socsink->hasAudio || socsink->hwavsync == FALSE) {
      vo_wrap_reset_clock(socsink->m_voplane);
      if(socsink->master_mode!=MASTER_MODE_PCR) {
        vo_wrap_set_MasterMode(socsink->m_voplane,
           AVSYNC_FORCED_SLAVE, /* system */
           AVSYNC_FORCED_MASTER, /* video */
           AVSYNC_FORCED_MASTER /* audio */ );
        GST_INFO_OBJECT(sink,"avsyncmode:s(fs),v(fm),a(fm)");
      }
  } else if (socsink->master_mode != MASTER_MODE_PCR){
      int ori_videomode = 0, ori_audiomode = 0, ori_systemmode = 0, ori_state = 0;
      int videoMode = 0, audioMode = 0, systemMode = 0;
      int masterState = AUTOMASTER_NOT_MASTER;

      switch (mode)
      {
          case FREE_RUN:
          {
              systemMode  = AVSYNC_FORCED_SLAVE;
              videoMode   = AVSYNC_FORCED_MASTER;
              audioMode   = AVSYNC_FORCED_MASTER;
              break;
          }
          case VIDEO_MASTER:
          {
              systemMode  = AVSYNC_FORCED_SLAVE;
              videoMode   = AVSYNC_FORCED_MASTER;
              audioMode   = AVSYNC_FORCED_SLAVE;
              break;
          }
          case AUDIO_MASTER:
          {
              systemMode  = AVSYNC_FORCED_SLAVE;
              videoMode   = AVSYNC_FORCED_SLAVE;
              audioMode   = AVSYNC_FORCED_MASTER;
              break;
          }
          case AUDIO_MASTER_SKIP:
          {
              systemMode  = AVSYNC_FORCED_SLAVE;
              audioMode   = AVSYNC_AUTO_MASTER;
              videoMode   = AVSYNC_AUTO_SLAVE;
              break;
          }
          case AUDIO_MASTER_NOSKIP:
          default:
          {
              systemMode  = AVSYNC_FORCED_SLAVE;
              audioMode   = AVSYNC_AUTO_MASTER_NO_SKIP;
              videoMode   = AVSYNC_AUTO_SLAVE;
              break;
          }
      }

      vo_wrap_get_MasterMode(socsink->m_voplane, &ori_systemmode, &ori_videomode, &ori_audiomode, &ori_state);

      if ( (audioMode == ori_audiomode) && (videoMode == ori_videomode)) {
          GST_DEBUG_OBJECT(sink," AV sync mode have already in target %s. Skipped!!", avsync_mode_type_str[mode]);
          return;
      }

      GST_INFO_OBJECT(sink, "[socsink] avsyncmode, set to %s mode\n", avsync_mode_type_str[mode]);
      vo_wrap_set_MasterMode(socsink->m_voplane, systemMode, videoMode, audioMode);

      if (mode == AUDIO_MASTER_NOSKIP || mode == AUDIO_MASTER_SKIP) {
          GST_INFO_OBJECT(sink, "Reset RCD value after set to default master!");
          vo_wrap_set_RCD(socsink->m_voplane, -1, 0);
          vo_wrap_set_MasterState(socsink->m_voplane, AUTOMASTER_NOT_MASTER);
      }
  }

#ifndef GST_DISABLE_GST_DEBUG
  int systemMode=-1, videoMode=-1, audioMode=-1, state=-1;
  vo_wrap_get_MasterMode(socsink->m_voplane, &systemMode, &videoMode, &audioMode, &state);
  GST_DEBUG_OBJECT(sink, "[socsink] avsyncmode: s(%d),v(%d),a(%d),st(%d)",
                 systemMode, videoMode, audioMode, state);
#endif /* GST_DISABLE_GST_DEBUG */

  return;
}

static void gst_rtk_v1_sink_reset_initial_value(GstWesterosSink *sink)
{
    GstWesterosSinkSoc *socsink = &sink->soc;
    // VOUT_BUFFER initialization
    memset (&socsink->vout_buf, 0, sizeof (VOUT_BUFFER));

    memset (&socsink->aliasFrameBuf, 0, sizeof(VOUT_BUFFER));

    socsink->width = -1; //-1 means vout never initialize
    socsink->height = -1;//-1 means vout never initialize
    socsink->x = 0;
    socsink->y = 0;
    socsink->fps = 0;
    socsink->keep_last_frame = FALSE;
    socsink->fixed_frame_rate = FALSE;
    socsink->stepframe = FALSE;
    socsink->frameStepOnPreroll = FALSE;
    socsink->skipPreroll = FALSE;
    socsink->alwaysPreroll = FALSE;
    socsink->prerollBuffer = NULL;
    socsink->mute = FALSE;
    socsink->vo_plane = PLANE_V1;
    socsink->m_voplane = gst_rtk_v1_sink_convertToVoutWrapPlane(socsink->vo_plane);
    socsink->hw_avsync_fd = DEFAULT_HWAVSYNC_FD;
    socsink->hwavsync = DEFAULT_ENABLE_HWAVSYNC;
    socsink->full_range = DEFAULT_FULL_RANGE_MODE;
    socsink->first_time = GST_CLOCK_TIME_NONE;
    socsink->update_time = GST_CLOCK_TIME_NONE;
    socsink->mSeHandle = 0;
    socsink->bring_to_front = BTF_FEATURE_DISABLE;
    socsink->enable_osd = OSDMODE_FEATURE_DISABLE;
    socsink->flush_done = 1;
    socsink->startplay = 0;
    socsink->need_signal_firstframe = TRUE;
    socsink->forceAspectRatio = DEFAULT_PROP_FORCE_ASPECT_RATIO;
    socsink->fw_speed = DEFAULT_FW_SPEED;
    socsink->target_fw_speed = DEFAULT_FW_SPEED;

    socsink->underflow_cnt = 0;
    socsink->video_playing = FALSE;
    socsink->frameCountW = 0;
    socsink->frameCountR = 0;
	socsink->avg_diff_us = 0;
    socsink->underflowPTS = 0;
    socsink->underflowTolerance = 0;
    socsink->hasAudio = 0;
    socsink->drop_cnt = 0;
    socsink->eos = FALSE;
#if RTK_USE_FW_KEEP_FRAME
    socsink->needSetVORun = 0;
#endif
    socsink->render = 0;
    socsink->flush_during_render = 0;
    socsink->master_mode = DEFAULT_MASTER;
    socsink->videoFreeRunThreshold = DEFAULT_FREERUN_THRESHOLD;

    // From rpi
    sink->soc.useGfxPath= false;
    //sink->soc.rend= &sink->soc.vidRend;
    sink->soc.sb= 0;
    sink->soc.quitCaptureThread= TRUE;
    sink->soc.captureThread= NULL;
    //sink->soc.buffCurrent= 0;
    sink->soc.sharedWLDisplay= false;
    sink->soc.eglSetup= false;
    sink->soc.eglDisplay= EGL_NO_DISPLAY;
    sink->soc.eglContext= EGL_NO_CONTEXT;
    sink->soc.eglSurface= EGL_NO_SURFACE;
    sink->soc.wlEGLWindow= 0;
    sink->soc.gfxSetup= false;
    sink->soc.eglCreateImageKHR= 0;
    sink->soc.eglDestroyImageKHR= 0;
    sink->soc.pEGLBufferHeader= 0;
    sink->soc.textureId= 0;
    sink->soc.eglImage= 0;
    sink->soc.textureWidth= 0;
    sink->soc.textureHeight= 0;
    sink->soc.newFrame= false;
    sink->soc.videoOutputChanged= true;
    sink->soc.frameWidth= 0;
    sink->soc.frameHeight= 0;
    sink->soc.firstFramePTS = -1;

    sink->soc.pts_share_fd = -1;
    sink->soc.pts_share_mem = NULL;

#ifdef USE_GLES2
    sink->soc.progId= 0;
    sink->soc.vertId= 0;
    sink->soc.fragId= 0;
    sink->soc.posLoc= 0;
    sink->soc.uvLoc= 1;

    memset( sink->soc.matrix, 0, sizeof(sink->soc.matrix));
    sink->soc.matrix[0]= 1.0f;
    sink->soc.matrix[5]= 1.0f;
    sink->soc.matrix[10]= 1.0f;
    sink->soc.matrix[15]= 1.0f;
#endif
#if defined(VIRTUAL_RESOLUTION)
    if(getenv("WESTEROS_SINK_VIRTUAL_WIDTH") && getenv("WESTEROS_SINK_VIRTUAL_HEIGHT")) {
      socsink->virtualWidthFactor = (float)DEFAULT_WINDOW_WIDTH / strtoul(getenv("WESTEROS_SINK_VIRTUAL_WIDTH"), NULL, 0);
      socsink->virtualHeightFactor = (float)DEFAULT_WINDOW_HEIGHT / strtoul(getenv("WESTEROS_SINK_VIRTUAL_HEIGHT"), NULL, 0);
    } else {
      socsink->virtualWidthFactor = 1.0;
      socsink->virtualHeightFactor = 1.0;
    }
#endif

    GST_OBJECT_FLAG_SET (GST_OBJECT (sink), GST_ELEMENT_FLAG_SINK);
  #if defined(ENABLE_TEE_DRM_FLOW)
    socsink->is_secure_path = FALSE;
  #endif //defined(ENABLE_TEE_DRM_FLOW)

    socsink->is_draining = FALSE;

    socsink->vo_resource_init = FALSE;
    socsink->flushed = TRUE;
    socsink->av_in_sync = FALSE;
    socsink->resource_released = FALSE;
    gst_base_sink_set_sync(GST_BASE_SINK(sink), TRUE);
    gst_base_sink_set_async_enabled(GST_BASE_SINK(sink), TRUE);

    gst_base_sink_set_max_lateness (GST_BASE_SINK (sink), -1);
    gst_base_sink_set_throttle_time (GST_BASE_SINK (sink), 0);
    gst_base_sink_set_qos_enabled (GST_BASE_SINK (sink), false);
    gst_base_sink_set_last_sample_enabled (GST_BASE_SINK (sink), false);
}

static void gst_rtk_v1_sink_check_hdr_info(GstWesterosSink *sink, GstBuffer *buffer) {
  GstWesterosSinkSoc *socsink = &sink->soc;
  GstMemory *mem = gst_buffer_get_memory (buffer, 0);
  VOUT_BUFFER *vb;
  if (socsink->HdrMetaYype != -1)
    return;
  if (G_LIKELY (gst_memory_is_type (mem, GST_OMX_MEMORY_TYPE))) {
    GST_LOG_OBJECT (sink, "Got omx_memory");
    vb = &((GstOMXMemory*)mem)->vbuf;
    gst_memory_unref (mem);
    if (!vo_wrap_is_vout_buffer (vb)) {
      GST_WARNING_OBJECT (sink, "Not vout buffer!!");
      return;
    }
  } else {
    return;
  }
  socsink->HdrMetaYype = vo_wrap_get_hdr_type(socsink->m_voplane, vb);
  GST_INFO_OBJECT(sink, "Get HDR type:%d",socsink->HdrMetaYype);
  RTK_LOG_INFO(sink, "Video content format: %s",
    (0 == socsink->HdrMetaYype)?"SDR":(1 == socsink->HdrMetaYype)?"DV":(2 == socsink->HdrMetaYype)?"HDR 10":(3 == socsink->HdrMetaYype)?"HLG":"UNKNOWN");
}

static int gst_rtk_video_plane_init(GstWesterosSink *sink, VO_WRAP_VIDEO_PLANE voplane)
{
    int ret = 0;
    sem_t * sema = SEM_FAILED;
    int retry_cnt = 0;

    while (sema == SEM_FAILED && retry_cnt < WAIT_SEM_MAX_CNT) {
        sema = sem_open(VOUT_SEMAPHORE_NAME, O_CREAT | O_EXCL, 0666, 1);
        RTK_LOG_INFO(sink, "sem_open=%p retry_cnt=%d \n", sema, retry_cnt);
        if (sema == SEM_FAILED) {
            int err1 = errno;
            GST_WARNING_OBJECT(sink, "sem_open() failed.  errno:%d", err1);
            if (EEXIST == err1) {
                GST_WARNING_OBJECT(sink, "EEXIST : Both O_CREAT and O_EXCL were specified in oflag, but a semaphore with this name already exists.");
                sema = sem_open(VOUT_SEMAPHORE_NAME, 0);
            }
            retry_cnt++;
            usleep(1000);
        }
    }
    sem_unlink(VOUT_SEMAPHORE_NAME);
    if (sema == SEM_FAILED) {
        usleep(1000);
        ret = vo_wrap_init_s(voplane);
        RTK_LOG_INFO(sink, "sem_open fail direct run vo_init ret=%d \n", ret);
        return ret;
    }

    retry_cnt = 0;

    while (sem_trywait(sema) != 0) {
        if (retry_cnt >= WAIT_VIDEO_MAX_CNT) {
            GST_ERROR_OBJECT(sink, "trywait over count limit.");
            break;
        }

        retry_cnt++;
        usleep(1000);
    }

    GST_INFO_OBJECT(sink, "trywait count=%d", retry_cnt);

    retry_cnt = 0;
    do {
        ret = vo_wrap_init_s(voplane);
        if (ret >= 0)
            break;

        retry_cnt++;
        usleep(2000);
    }
    while (ret < 0 && retry_cnt < 5);
    GST_INFO_OBJECT(sink, "vo_wrap_init_s ret=%d, retry_cnt=%d", ret, retry_cnt);

    sem_post(sema);
    sem_close(sema);
    RTK_LOG_INFO(sink, "vo_wrap_init_s ret=%d\n",ret);

    return ret;
}

static void gst_rtk_v1_sink_inital_vo_resource(GstWesterosSink *sink) {
    GstWesterosSinkSoc *socsink = &sink->soc;
    int i = 0;
    if (socsink->vo_resource_init == FALSE) {
#if defined(ENABLE_TEE_DRM_FLOW)
        if (TEE_API_Initialize(&(socsink->ctx), &(socsink->sess), &(socsink->rtk_sess)) != TA_SUCCESS) {
            GST_ERROR_OBJECT(sink, "TEE_API_Initialize failed!!!");
        }
#endif //defined(ENABLE_TEE_DRM_FLOW)

#if RTK_USE_BUFLOCK
        for (int i = 0; i < MAX_BUFLOCKS; i++) {
            socsink->Blid[i] = -1;
            socsink->Buflock[i] = buflock_create();
        }
#endif//RTK_USE_BUFLOCK

        sink->soc.pts_share_fd = shm_open("shmem", O_CREAT | O_RDWR, 0777);
        if (sink->soc.pts_share_fd >= 0) {
            ftruncate(sink->soc.pts_share_fd, 8);

            sink->soc.pts_share_mem = mmap(NULL, 8, PROT_READ|PROT_WRITE, MAP_SHARED, sink->soc.pts_share_fd, 0);
            if (!sink->soc.pts_share_mem)
                close(sink->soc.pts_share_fd);
        }
        socsink->needHdrNotify = TRUE;
        socsink->HdrMetaYype = -1;
    }
    socsink->vo_resource_init = TRUE;
}

static gboolean processEventSinkSoc(GstWesterosSink *sink, GstPad *pad, GstEvent *event, gboolean *passToDefault)
{
  gboolean result= FALSE;
  switch (GST_EVENT_TYPE(event))
  {
     case GST_EVENT_CUSTOM_DOWNSTREAM_OOB:
     {
       const GstStructure *s = gst_event_get_structure(event);
       if (gst_structure_has_name(s, "custom-instant-rate-change")) {
         const GValue *setRate = gst_structure_get_value(s, "rate");
         gst_westeros_sink_soc_set_speed(sink, setRate);
       } else if (gst_structure_has_field (s, "resouce-release"))
       {
           gboolean resource_release = FALSE;
           gst_structure_get_boolean (s, "resouce-release", &resource_release);
           sink->soc.resource_released = resource_release;
           RTK_LOG_INFO (sink, "resource-release: %s", (sink->soc.resource_released)?"true":"false");
       }
       *passToDefault= FALSE;
       result= true;
     }
     break;
  }

  return result;
}

static void sinkSocStopVideo( GstWesterosSink *sink )
{
   LOCK( sink );
   if ( sink->soc.captureThread )
   {
      sink->soc.quitCaptureThread= TRUE;
      if ( sink->display )
      {
         int fd= wl_display_get_fd( sink->display );
         if ( fd >= 0 )
         {
            shutdown( fd, SHUT_RDWR );
         }
      }
      UNLOCK( sink );
      g_thread_join( sink->soc.captureThread );
      LOCK( sink );
      sink->soc.captureThread= NULL;
   }
#if 0
   if ( sink->soc.sb )
   {
      wl_sb_destroy( sink->soc.sb );
      sink->soc.sb= 0;
   }
#endif
   UNLOCK( sink );
}

static int sinkAcquireVideo( GstWesterosSink *sink )
{
    GST_INFO("sinkAcquireVideo");
}

static void sinkReleaseVideo( GstWesterosSink *sink )
{
    GST_INFO("sinkReleaseVideo");
    sink->eosEventSeen = TRUE;
    gst_westeros_sink_eos_detected(sink);
}

static GstStructure *wstSinkGetStats( GstWesterosSink * sink )
{
   g_return_val_if_fail (sink != NULL, NULL);
   return gst_structure_new ("application/x-gst-base-sink-stats",
      "dropped", G_TYPE_UINT64, (guint64)sink->soc.drop_cnt,
      "rendered", G_TYPE_UINT64, (guint64)sink->soc.frameCountW, NULL);
}
