#ifndef BROWSER2_H
#define BROWSER2_H

#include <QObject>
#include <QUrl>
#include <QGraphicsRectItem>
#include <QtWebEngineWidgets>

class QGraphicsTextItem;

class Browser2 : public QObject
{
Q_OBJECT
public:
    Browser2(QGraphicsScene& scene,
             const QString& initial_url,
             bool is_video,
             bool enable_gui,
             bool enable_tiled_backing_store,
             const QString& user_agent,
             bool ignore_ssl_errors);

    virtual ~Browser2();

private slots:
    void onUrlChanged(QUrl);
    void onFeaturePermissionRequested(const QUrl, const QWebEnginePage::Feature);

private:
    Browser2() {};
    QGraphicsTextItem* mLblItem;
    QWebEngineView* mWebEngineView;
};

#endif // BROWSER2_H
