// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_AX_ROLES_H_
#define UI_ACCESSIBILITY_AX_ROLES_H_

// These should be kept in sync with third_party/WebKit/public/web/WebAXEnums.h
// until the Chromium and Blink trees are merged.
enum AXRole {
  AX_ROLE_ALERT_DIALOG = 1,
  AX_ROLE_ALERT,
  AX_ROLE_ANNOTATION,
  AX_ROLE_APPLICATION,
  AX_ROLE_ARTICLE,
  AX_ROLE_BANNER,
  AX_ROLE_BROWSER,
  AX_ROLE_BUSY_INDICATOR,
  AX_ROLE_BUTTON,
  AX_ROLE_CANVAS,
  AX_ROLE_CELL,
  AX_ROLE_CHECK_BOX,
  AX_ROLE_COLOR_WELL,
  AX_ROLE_COLUMN_HEADER,
  AX_ROLE_COLUMN,
  AX_ROLE_COMBO_BOX,
  AX_ROLE_COMPLEMENTARY,
  AX_ROLE_CONTENT_INFO,
  AX_ROLE_DEFINITION,
  AX_ROLE_DESCRIPTION_LIST_DETAIL,
  AX_ROLE_DESCRIPTION_LIST_TERM,
  AX_ROLE_DIALOG,
  AX_ROLE_DIRECTORY,
  AX_ROLE_DISCLOSURE_TRIANGLE,
  AX_ROLE_DIV,
  AX_ROLE_DOCUMENT,
  AX_ROLE_DRAWER,
  AX_ROLE_EDITABLE_TEXT,
  AX_ROLE_FOOTER,
  AX_ROLE_FORM,
  AX_ROLE_GRID,
  AX_ROLE_GROUP,
  AX_ROLE_GROW_AREA,
  AX_ROLE_HEADING,
  AX_ROLE_HELP_TAG,
  AX_ROLE_HORIZONTAL_RULE,
  AX_ROLE_IGNORED,
  AX_ROLE_IMAGE_MAP_LINK,
  AX_ROLE_IMAGE_MAP,
  AX_ROLE_IMAGE,
  AX_ROLE_INCREMENTOR,
  AX_ROLE_INLINE_TEXT_BOX,
  AX_ROLE_LABEL,
  AX_ROLE_LEGEND,
  AX_ROLE_LINK,
  AX_ROLE_LIST_BOX_OPTION,
  AX_ROLE_LIST_BOX,
  AX_ROLE_LIST_ITEM,
  AX_ROLE_LIST_MARKER,
  AX_ROLE_LIST,
  AX_ROLE_LOG,
  AX_ROLE_MAIN,
  AX_ROLE_MARQUEE,
  AX_ROLE_MATH_ELEMENT,
  AX_ROLE_MATH,
  AX_ROLE_MATTE,
  AX_ROLE_MENU_BAR,
  AX_ROLE_MENU_BUTTON,
  AX_ROLE_MENU_ITEM,
  AX_ROLE_MENU_LIST_OPTION,
  AX_ROLE_MENU_LIST_POPUP,
  AX_ROLE_MENU,
  AX_ROLE_NAVIGATION,
  AX_ROLE_NOTE,
  AX_ROLE_OUTLINE,
  AX_ROLE_PARAGRAPH,
  AX_ROLE_POP_UP_BUTTON,
  AX_ROLE_PRESENTATIONAL,
  AX_ROLE_PROGRESS_INDICATOR,
  AX_ROLE_RADIO_BUTTON,
  AX_ROLE_RADIO_GROUP,
  AX_ROLE_REGION,
  AX_ROLE_ROOT_WEB_AREA,
  AX_ROLE_ROW_HEADER,
  AX_ROLE_ROW,
  AX_ROLE_RULER_MARKER,
  AX_ROLE_RULER,
  AX_ROLE_SVG_ROOT,
  AX_ROLE_SCROLL_AREA,
  AX_ROLE_SCROLL_BAR,
  AX_ROLE_SEAMLESS_WEB_AREA,
  AX_ROLE_SEARCH,
  AX_ROLE_SHEET,
  AX_ROLE_SLIDER,
  AX_ROLE_SLIDER_THUMB,
  AX_ROLE_SPIN_BUTTON_PART,
  AX_ROLE_SPIN_BUTTON,
  AX_ROLE_SPLIT_GROUP,
  AX_ROLE_SPLITTER,
  AX_ROLE_STATIC_TEXT,
  AX_ROLE_STATUS,
  AX_ROLE_SYSTEM_WIDE,
  AX_ROLE_TAB_GROUP,
  AX_ROLE_TAB_LIST,
  AX_ROLE_TAB_PANEL,
  AX_ROLE_TAB,
  AX_ROLE_TABLE_HEADER_CONTAINER,
  AX_ROLE_TABLE,
  AX_ROLE_TEXT_AREA,
  AX_ROLE_TEXT_FIELD,
  AX_ROLE_TIMER,
  AX_ROLE_TOGGLE_BUTTON,
  AX_ROLE_TOOLBAR,
  AX_ROLE_TREE_GRID,
  AX_ROLE_TREE_ITEM,
  AX_ROLE_TREE,
  AX_ROLE_UNKNOWN,
  AX_ROLE_USER_INTERFACE_TOOLTIP,
  AX_ROLE_VALUE_INDICATOR,
  AX_ROLE_WEB_AREA,
  AX_ROLE_WINDOW
};

#endif  // UI_ACCESSIBILITY_AX_ROLES_H_
