#!/bin/bash
set -ex
COMBINED_ROOT=$RDK_PROJECT_ROOT_PATH

[[ ! -n "$COMBINED_ROOT" ]] && export COMBINED_ROOT=$(cd .. && pwd)
[[ ! -n "$TOOLCHAIN_DIR" ]] && export TOOLCHAIN_DIR=$COMBINED_ROOT/sdk/toolchain/i686-linux-elf

function findQt()
{
    QT_PREFIX=$QT_SRC_ROOT/stage/usr/local/Qt
    if [ -e $QT_PREFIX/bin/qmake ]; then
        export QT_PREFIX
        return
    fi
    QT_PREFIX=$FSROOT/usr/local/Qt
    if [ -e $QT_PREFIX/bin/qmake ]; then
        export QT_PREFIX
        return
    fi
    unset QT_PREFIX
    echo "Cannot find qt"
    exit -1
}


function set_qmakespec()
{
    # find qt installatin and export QT_PREFIX
    findQt
    export QMAKESPEC=$QT_PREFIX/mkspecs/default
}



function configureProject()
{
    local project_file=${1}; shift
    local project_config=${@}
    set_qmakespec
    $QT_PREFIX/bin/qmake ${project_file} ${project_config[@]}
    unset QT_PREFIX
}

function nextFd()
{
    local fd=3
    local fd_MAX=$(ulimit -n)
    while [[ $fd -le $fd_MAX && -e /proc/$$/fd/$fd ]]; do
        ((++fd))
    done
    if [ $fd -gt $fd_MAX ]; then
        echo "Could not find available file descriptor" >&2
        echo "-1"
    else
        echo "$fd"
    fi
}

function redirectStdOutAndStdErr()
{
    local logFile=$1

    [[ -n "$logFile" ]] || { echo "Cannot redirect std{out/err}"; return; }

    echo "Please see the status of build at $logFile"

    # clear log file
    cat /dev/null > $logFile

    # save trace fd if it points to stdout or stderr
    if [[ $TRACEFD -le 2 ]]; then
        local fd=$(nextFd)
        if ! eval "exec $fd>&$TRACEFD"; then
            exit -1
        fi
        export TRACEFD=$fd
        export BASH_XTRACEFD=$TRACEFD
    fi

    # redirect std output
    exec 1>>$logFile 2>>$logFile
}

function handleScriptOptions()
{
    if [[ "$JOBS_NUM" -le "0" ]] ; then
        JOBS_NUM=$((`grep -c ^processor /proc/cpuinfo` + 1))
    fi
    # TODO: uploading and dumping of debug symbols for crash portal
    #       should be separated
    if [[ "$UPLOAD" -eq "1" ]] ; then
        export UPLOAD_FLAG=1
        export QT_BREAKPAD_ROOT_PATH=$QT_SRC_ROOT
    fi
    if [[ "$DEBUG" -eq "1" ]] ; then
        PROJECT_CONFIG+=("CONFIG+=debug")
    else
        echo "Suppressing Silent"
        #PROJECT_CONFIG+=("CONFIG+=silent")
    fi
}

function trap_exit()
{
    exit_code=$?
    if [ $exit_code -ne 0 ]; then
        echo "Build failed" >&$TRACEFD
    fi
    trap - INT TERM EXIT
    exit $exit_code
}
trap 'trap_exit' INT TERM EXIT
set -e
# set -x

# this to be used to print messages for console output on jenkins
export TRACEFD=2

# set fd for output generated when set -x is enabled
export BASH_XTRACEFD=$TRACEFD
