#include "browser2.h"

#include <QGraphicsScene>
#include <QDebug>

// FIXME: determine screen size
extern unsigned sDisplayWidth;
extern unsigned sDisplayHeight;

//Browser built on top of QWebEngine
Browser2::Browser2(QGraphicsScene &scene,
                   const QString &initial_url,
                   bool is_video,
                   bool enable_gui,
                   bool enable_tiled_backing_store,
                   const QString &user_agent,
                   bool ignore_ssl_errors)
    : mLblItem (NULL)
    , mWebEngineView(NULL)
{
    Q_UNUSED(is_video);
    Q_UNUSED(enable_gui);
    Q_UNUSED(enable_tiled_backing_store);
    Q_UNUSED(user_agent);
    Q_UNUSED(ignore_ssl_errors);

    qDebug() << "created Browser2";

    int page_x = 0;
    int page_y = 0;
    int page_w = sDisplayWidth;
    int page_h = sDisplayHeight;

    if (enable_gui)
    {
        const int WIDGET_PAD = 10;
        const int WIDGET_H = 30;

        page_w = sDisplayWidth - 2*WIDGET_PAD;
        page_h = sDisplayHeight - 3*WIDGET_PAD - WIDGET_H;
        page_x = WIDGET_PAD;
        page_y = 2*WIDGET_PAD + WIDGET_H;

        // Create the "URL: " label.
        mLblItem = scene.addText(initial_url);
        mLblItem->setPos(WIDGET_PAD, WIDGET_PAD);
    }

    mWebEngineView = new QWebEngineView();
    QObject::connect(mWebEngineView,SIGNAL(urlChanged(QUrl)),this,SLOT(onUrlChanged(QUrl)));
    QObject::connect(mWebEngineView->page(),SIGNAL(featurePermissionRequested(const QUrl&,QWebEnginePage::Feature)),
                     this,SLOT(onFeaturePermissionRequested(const QUrl&, QWebEnginePage::Feature)));

    QGraphicsProxyWidget* proxy_webengine = scene.addWidget(mWebEngineView);
    if (!proxy_webengine)
    {
        qFatal("Failed to create a proxy object");
        return;
    }
    proxy_webengine->setGeometry(QRectF(page_x, page_y, page_w, page_h));

    QFileInfo fi(initial_url);
    QUrl url = fi.exists()
        ? QUrl::fromLocalFile(fi.absoluteFilePath())
        : QUrl::fromUserInput(initial_url);
    qDebug() << "Load: " << url;
    mWebEngineView->load(url);
}

Browser2::~Browser2()
{
    delete mWebEngineView;
    mWebEngineView = NULL;
}

void Browser2::onUrlChanged(QUrl url)
{
    if (mLblItem)
        mLblItem->setPlainText(url.toString());
    qDebug() << "url changed:" << url;
}

void Browser2::onFeaturePermissionRequested(const QUrl securityOrigin, const QWebEnginePage::Feature requestedFeature)
{
    qDebug() << "FeaturePermissionRequested: " << requestedFeature
             << " for : " << securityOrigin;
    mWebEngineView->page()->setFeaturePermission(securityOrigin, requestedFeature, QWebEnginePage::PermissionGrantedByUser);
}
