#!/bin/sh

enable=0
AA_DEFAULT=/etc/apparmor/apparmor_defaults
AAR_ENTRY_CNT=/tmp/aar_marker.txt
AAR_MESG_LOG=/tmp/apparmor_messages
ACTIVE_PROFILES=$(cat /sys/kernel/security/apparmor/profiles)
loop_time=3600

if [ -n "$ACTIVE_PROFILES" ]; then
     enable=1
fi

while [ "$enable" -eq 1 ]
do
    # copytruncate original log file
    cp "$AAR_MESG_LOG" "$AAR_MESG_LOG".1
    : > "$AAR_MESG_LOG"
    while read line; do
        profile=$(echo "$line" | cut -d : -f1)
        [ -z "$profile" ] && continue
        count=$(grep -c "profile=\"$profile" "$AAR_MESG_LOG".1)
        [ -z "$count" ] && count=0
        if [ "$profile" = "global" ]; then
            line=:$count
        else
            line=,$count
        fi
        echo -n "$line" >> $AAR_ENTRY_CNT
    done  < $AA_DEFAULT
    echo -n -e "$(date "+%Y-%m-%dT%T.%3NZ") APPARMOR_ENTRY_COUNT$(cat $AAR_ENTRY_CNT)\n" >> /var/log/messages
    rm -f "$AAR_MESG_LOG".1
    rm -f "$AAR_ENTRY_CNT"
    sleep $loop_time
done

