DESCRIPTION = "QCA639X ax wifi drivers binaries"
SECTION = "wifi"
LICENSE = "BSD|GPL"

inherit systemd

FILESEXTRAPATHS_prepend := "${THISDIR}/files/wifi:"

QCA6390_WIFI_TAR = "qca6390"
QCA6390_WIFI_TAR_append = "-${DISTRO_CODENAME}"

SRCREV = "${AUTOREV}"
ARTIFACTVER = "${@bb.utils.contains('DISTRO_FEATURES', 'kirkstone', '2.46', '2.44', d)}"
ARTIFACTVER_64bit = "${@bb.utils.contains('DISTRO_FEATURES', 'kirkstone', '4.2', '3.9', d)}"

QCA6390_WIFI_TAR_append = "${DISTRO_PKG_KM_SUFFIX}"

SRC_URI = "\
        ${RDK_ARTIFACTS_BASE_URL}/sky_realtek_xione/components/wifi/${QCA6390_WIFI_TAR}/${ARTIFACTVER}/${QCA6390_WIFI_TAR}-${ARTIFACTVER}.tar.gz;name=${QCA6390_WIFI_TAR} \
        "
SRC_URI_append = "\
            file://qca-overrides \
           "
SRC_URI[qca6390.sha256sum] = "a3e69bb280ff0ef019352de4e2a3362972d0226df737201e4b445c1a9a133704"
SRC_URI[qca6390-dunfell.sha256sum] = "1f831e75c35c2fe1ce44391f092cd48df29ff0af26aa744b6f5427409e63f3c9"
SRC_URI[qca6390-kirkstone.sha256sum] = "9d474a5c8597e7453f0afb2dcbf6d2b0450aff9c2d49c72c99059382d90217ca"
SRC_URI[qca6390-dunfell-5_10-aarch64.sha256sum] = "dc508e4b2a93705a346387225f401a9344ed58e8eca66812456d365c2c793a82"
SRC_URI[qca6390-kirkstone-5_10-aarch64.sha256sum] = "84fe92e4643197e0777325ce9adb27de14512f69112f8459363998551accb20b"


#EXTERNALSRC_BUILD = "${EXTERNALSRC}"
S = "${WORKDIR}"


include ${@oe.utils.conditional('ENV_BUILD_TYPE','xione-hwtest','${PN}-xione-wifitest.inc', '${PN}-unknown.inc',d)}
include ${@oe.utils.conditional('ENV_WIFI_TEST_TYPE','xione-wtstest','${PN}-xione-wtstest.inc', '${PN}-unknown.inc',d)}

INHIBIT_PACKAGE_DEBUG_SPLIT = "1"
EXCLUDE_FROM_SHLIBS = "1"
INHIBIT_PACKAGE_STRIP = "1"

INSANE_SKIP_${PN} = "${ERROR_QA} ${WARN_QA}"
INSANE_SKIP_${PN}-dev = "${ERROR_QA} ${WARN_QA}"

# Skip the unwanted steps
do_configure[noexec] = "1"
do_compile[noexec] = "1"
do_populate_sysroot[noexec] = "1"
do_populate_lic[noexec] = "1"

do_install() {
    install -d ${D}/lib/modules/${KERNEL_VERSION}/extra/
    install -d ${D}/lib/firmware
    install -d ${D}/lib/firmware/qca
    install -d ${D}/lib/firmware/wlan
    install -d ${D}/lib/rdk
    install -d ${D}/sbin

    BUILD_REGION="${@oe.utils.conditional('SKY_VARIANT', 'true', 'EU', 'US', d)}"
    if ${@bb.utils.contains_any('DISTRO_FEATURES', 'flex2_rdk firebolt_rdk_certify', 'true','false',d)}; then
        BUILD_REGION="US"
    fi
    BUILD_REGION_WIFI_BD_FILES=${BUILD_REGION}

    # For the Foxtell variant, we have customised board data file in the "AUS" directory:
    if ${@bb.utils.contains_any('ENV_PRODUCT', 'skyxione-alpaca-foxtel', 'true','false',d)}; then
        BUILD_REGION_WIFI_BD_FILES="AUS"
    fi

    cp -r ${S}/qca6390/lib/modules/${BUILD_REGION}/* ${D}/lib/modules/${KERNEL_VERSION}/extra/
    cp -r ${S}/qca6390/lib/firmware/* ${D}/lib/firmware/
    cp -r ${S}/qca-overrides/wlan/${BUILD_REGION_WIFI_BD_FILES}/* ${D}/lib/firmware/

    if ${@bb.utils.contains('BT_QCA_OLD_DRV', 'true', 'true', 'false', d)}; then
        cp -r ${S}/qca-overrides/bluetooth/${BUILD_REGION}/htnv20.bin ${D}/lib/firmware/qca/hst_nvm.bin
        cp -r ${S}/qca-overrides/bluetooth/${BUILD_REGION}/htbtfw20.tlv ${D}/lib/firmware/qca/hst_rampatch.bin
    else
        cp -r ${S}/qca-overrides/bluetooth/${BUILD_REGION}/htnv20.bin ${D}/lib/firmware/qca/htnv20.bin
        cp -r ${S}/qca-overrides/bluetooth/${BUILD_REGION}/htbtfw20.tlv ${D}/lib/firmware/qca/htbtfw20.tlv
    fi

    # Modify Wi-Fi Driver INI file qcom_cfg.ini to include twt_congestion_timeout=0. This is to resolve TWT issues (XIONE-4146)
    sed -i -- '0,/END/{s/END/\#QCM recommended setting to resolve a packet loss or latency issues when using TWT see XIONE-4146\ntwt_congestion_timeout=0\n\nEND/}' ${D}/lib/firmware/wlan/qcom_cfg.ini

    #INI file modification to enable Wake on WLAN in UK variants
    if [ "${@oe.utils.conditional("ENABLE_WOL_WOWLAN", "true", "true", "false", d)}" = "true" ]; then
        sed -i 's/# gEnableWoW=0/gEnableWoW=1/g' ${D}/lib/firmware/wlan/qcom_cfg.ini
    fi
    if ${@bb.utils.contains_any('DISTRO_FEATURES', 'flex2_rdk firebolt_rdk_certify', 'true','false',d)}; then
        sed -i 's/# gEnableWoW=0/gEnableWoW=1/g' ${D}/lib/firmware/wlan/qcom_cfg.ini
    fi

    install -d ${D}${systemd_unitdir}/system
    install -m 0644 ${S}/qca-overrides/wifi.service ${D}${systemd_unitdir}/system/wifi.service
    install -D -m 0777 ${S}/qca-overrides/load-qca-wifi-drivers.sh ${D}/lib/rdk/
}

SYSTEMD_SERVICE_${PN} += "wifi.service"

FILES_${PN} += "/lib/firmware/"
FILES_${PN} += "/lib/modules/${KERNEL_VERSION}/extra/"
FILES_${PN} += "/lib/rdk/"
FILES_${PN} += "/lib/systemd/"
FILES_${PN} += "/sbin/"

RPROVIDES_${PN} += "kernel-module-${PN}-${KERNEL_VERSION}"
