#! /bin/bash
# /lib/rdk/start_qca-hciattach.sh
# Updated 04/11/2022

if [ -e /lib/modules/`uname -r`/kernel/drivers/bluetooth/btqca.ko ] ; then
	new_drivers="true"
fi

read version patch sublevel <<<$(uname -r|cut -d '.' -f 1-3 | cut -d '-' -f 1|awk -F '.' '{print $1, $2, $3}')
if [[ "${new_drivers}" == "true" ]] || [[ $version -gt 5 ]] || [[ $version -eq 5 && $patch -gt 4 ]] || [[ $version -eq 5 &&  $patch -eq 4 &&  $sublevel -ge 186 ]]; then
	# For Kernel version >= 5.4.108, use rfkill
	insmod /lib/modules/`uname -r`/kernel/drivers/bluetooth/btqca.ko
	insmod /lib/modules/`uname -r`/kernel/drivers/bluetooth/hci_uart.ko
	hciconfig -a hci0 up
	hciconfig -a hci0 down
else
	echo "Toggling the BT_EN pin before performing hciattach"
	echo 43 > /sys/class/gpio/export
	echo "out" > /sys/class/gpio/gpio43/direction
	echo 0 > /sys/class/gpio/gpio43/value
	sleep 1
	echo 1 > /sys/class/gpio/gpio43/value
	echo 43 > /sys/class/gpio/unexport

	echo "Starting Qualcomm hciattach"
	stty -F /dev/ttyS1 -parenb
	hciattach /dev/ttyS1 qualcomm 3000000 flow

	sleep 4
	hciconfig -a hci0 up
	sleep 1
	hciconfig -a hci0 reset
	sleep 1
	hciconfig -a hci0 down
	sleep 1
fi
