/*
 * If not stated otherwise in this file or this component's Licenses.txt file the
 * following copyright and licenses apply:
 *
 * Copyright 2016 RDK Management
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef __WESTEROS_SINK_SOC_H__
#define __WESTEROS_SINK_SOC_H__

#define USE_GLES2

#include <stdlib.h>
#include <semaphore.h>

#include <EGL/egl.h>
#include <EGL/eglext.h>

#ifdef USE_GLES2
#include <GLES2/gl2.h>
#include <GLES2/gl2ext.h>
#else
#include <GLES/gl.h>
#endif

#include "simplebuffer-client-protocol.h"
#include "westeros-gl.h"

//#include "IL/OMX_Core.h"
//#include "IL/OMX_Broadcom.h"
#include <gst/video/video.h>
#include <gst/video/gstvideosink.h>
#include "rtk_vdec.h"
#include "vout_wrapper.h"
#include "gstomxbufferpool.h"
#include "buflock.h"
#if defined(ENABLE_TEE_DRM_FLOW)
#include "tee_client_api.h"
#include "tee_api.h"
#endif //defined(ENABLE_TEE_DRM_FLOW)

#define WESTEROS_SINK_CAPS                        \
        "video/x-raw, "                                             \
        "format = (string) " "NV12" ", "                                \
        "width = " "(int) [ 16, 4096 ]" ", "                            \
        "height = " "(int) [ 16, 4096 ]" ", "                           \
        "framerate = " GST_VIDEO_FPS_RANGE

#define VO_BUF_NUM 32
#define RTK_MIN_FRAME_COUNT 3
#define MAX_BUFLOCKS 5

typedef struct _GstWesterosSink GstWesterosSink;
typedef struct _GstWesterosSinkClass GstWesterosSinkClass;

typedef VO_WRAP_TV_RESOLUTION_MODE GstWesterosSinkTvMode;

typedef enum
{
  PLANE_V1 = 0,
  PLANE_V2 = 1,
  PLANE_WIN1 = 2,
  PLANE_WIN2 = 3,
  NUM_PLANE
} GstWesterosSinkPlane;

typedef enum
{
  OSDMODE_FEATURE_DISABLE = 0,
  OSDMODE_ENABLE = 1,
  OSDMODE_DISABLE = 2
} GstWesterosSinkOSDMode;

typedef enum
{
  BTF_FEATURE_DISABLE = 0,
  BTF_ENABLE = 1,
  BTF_DISABLE = 2
} GstWesterosSinkBTF; // BTF, short of bring-to-front

typedef enum _AVSyncMode{
  AVSYNC_FORCED_SLAVE,
  AVSYNC_FORCED_MASTER,
  AVSYNC_AUTO_SLAVE,
  AVSYNC_AUTO_MASTER,
  AVSYNC_AUTO_MASTER_NO_SKIP,
  AVSYNC_AUTO_MASTER_CONSTANT_DELAY,   /* after getback mastership, it become force master */
  AVSYNC_EXTREME_LOW_DELAY,
  AVSYNC_AUTO_MASTER_NO_SKIP_TIMEOUT /* hold on mastership if RCD = -1 and TIMEOUT is not expired */
} AVSYNC_MODE;

typedef struct _GstWesterosSinkSoc
{
    gint width, height;
    guint zoom;
    gboolean forceAspectRatio;
    int handle;
    gint64 current_time;
    gint64 tempTime;
    gfloat fw_speed;
    gfloat target_fw_speed;
    gint64 timeDiff;
    gboolean m_isPaused;
    VOUT_BUFFER vout_buf;
    gint x; //output windows position x
    gint y; //output windows position y
    gfloat fps;
    GstWesterosSinkTvMode tv_mode;
    GstWesterosSinkPlane vo_plane;
    VO_WRAP_VIDEO_PLANE m_voplane;
    int fps_d, fps_n;
    gboolean keep_last_frame;
    gboolean fixed_frame_rate;
    gboolean stepframe;
    gboolean frameStepOnPreroll;
    gboolean alwaysPreroll;
    gboolean skipPreroll;
    GstBuffer *prerollBuffer;
    gboolean mute;
    GstBuffer *v1_Buf[VO_BUF_NUM];
    VOUT_BUFFER v1_vobuf[VO_BUF_NUM];
    pthread_t v1_QueueThread;
    pthread_mutex_t frame_mutex; // for frame R/W control
    int v1_QueueRunning;
    int v1_QueueIndexR;
    int v1_QueueIndexW;
    int startplay;
    float tv_start;
    int flush_done;
    unsigned long mSeHandle;
    gboolean flush;
    gboolean newseg;
    gint hw_avsync_fd;
    gboolean hwavsync;
    gboolean full_range;
    gboolean eos;
    gint64 first_time;
    gint64 update_time;
    VOUT_BUFFER aliasFrameBuf;
    GstWesterosSinkBTF bring_to_front;
    VO_WRAP_MIXER_ORDER order;
    GstWesterosSinkOSDMode enable_osd;
    ST_RECTANGLE osd1_rect;
  #if defined(ENABLE_TEE_DRM_FLOW)
    gboolean is_secure_path;
    TEEC_Context        ctx;
    TEEC_Session        sess;
    RTK_TEEC_Session    rtk_sess;
  #endif //defined(ENABLE_TEE_DRM_FLOW)
    gint underflow_cnt;
    gboolean video_playing;
    gint hasAudio;
    guint32 drop_cnt;
    guint32 gst_drop_cnt;

    // From rpi
    struct wl_sb *sb;
    int activeBuffers;
    bool sharedWLDisplay;
    struct wl_egl_window *wlEGLWindow;

    bool eglSetup;
    EGLDisplay eglDisplay;
    EGLConfig eglConfig;
    EGLContext eglContext;
    EGLSurface eglSurface;

    bool gfxSetup;
    GLuint textureId;
    EGLImageKHR eglImage;
    int textureWidth;
    int textureHeight;
    PFNEGLCREATEIMAGEKHRPROC eglCreateImageKHR;
    PFNEGLDESTROYIMAGEKHRPROC eglDestroyImageKHR;
    OMX_BUFFERHEADERTYPE *pEGLBufferHeader;
    bool newFrame;
    bool videoOutputChanged;
    int frameWidth;
    int frameHeight;
    guint frameCountW;
    guint frameCountR;
    bool needDefaultMaster;
    long long underflowPTS;
    guint underflowTolerance;
    bool useGfxPath;
    gboolean quitCaptureThread;
    GThread *captureThread;
    gint64 pts_list[RTK_MIN_FRAME_COUNT];
    gint64 avg_diff_us;
    #ifdef USE_GLES2
    float matrix[16];
    GLuint vertId;
    GLuint fragId;
    GLuint progId;
    GLint posLoc;
    GLint uvLoc;
    GLint resLoc;
    GLint matrixLoc;
    GLint alphaLoc;
    GLint textureLoc;
    #endif
    #if defined(VIRTUAL_RESOLUTION)
    float virtualWidthFactor;
    float virtualHeightFactor;
    #endif
    gboolean needSetVORun;
    pthread_mutex_t mute_mutex;
    void *Buflock[MAX_BUFLOCKS];
    int Blid[MAX_BUFLOCKS];
    int pts_share_fd;
    char *pts_share_mem;
    gboolean render;
    gboolean flush_during_render;
    MASTER_MODE master_mode;
    gboolean vo_resource_init;
    int videoFreeRunThreshold;
    gboolean is_draining;
    int HdrMetaYype;
    gboolean needHdrNotify;
    bool isCompositorLocked;
    gboolean flushed;
    long long firstFramePTS;
    gboolean useImmediateOutput;
    gboolean av_in_sync;
    gboolean resource_released;
    gboolean isTargetPlaneUsing;
    void *metrics_viraddr;
    int   metrics_slot;
} GstWesterosSinkSoc;

void gst_westeros_sink_soc_class_init(GstWesterosSinkClass *klass);
gboolean gst_westeros_sink_soc_init( GstWesterosSink *sink );
void gst_westeros_sink_soc_term( GstWesterosSink *sink );
void gst_westeros_sink_soc_set_property(GObject *object, guint prop_id, const GValue *value, GParamSpec *pspec);
void gst_westeros_sink_soc_get_property(GObject *object, guint prop_id, GValue *value, GParamSpec *pspec);
gboolean gst_westeros_sink_soc_null_to_ready( GstWesterosSink *sink, gboolean *passToDefault );
gboolean gst_westeros_sink_soc_ready_to_paused( GstWesterosSink *sink, gboolean *passToDefault );
gboolean gst_westeros_sink_soc_paused_to_playing( GstWesterosSink *sink, gboolean *passToDefault );
gboolean gst_westeros_sink_soc_playing_to_paused( GstWesterosSink *sink, gboolean *passToDefault );
gboolean gst_westeros_sink_soc_paused_to_ready( GstWesterosSink *sink, gboolean *passToDefault );
gboolean gst_westeros_sink_soc_ready_to_null( GstWesterosSink *sink, gboolean *passToDefault );
void gst_westeros_sink_soc_registryHandleGlobal( GstWesterosSink *sink,
                                 struct wl_registry *registry, uint32_t id,
		                           const char *interface, uint32_t version);
void gst_westeros_sink_soc_registryHandleGlobalRemove(GstWesterosSink *sink,
                                 struct wl_registry *registry,
			                        uint32_t name);
gboolean gst_westeros_sink_soc_accept_caps( GstWesterosSink *sink, GstCaps *caps );
void gst_westeros_sink_soc_set_startPTS( GstWesterosSink *sink, gint64 pts );
void gst_westeros_sink_soc_render( GstWesterosSink *sink, GstBuffer *buffer );
void gst_westeros_sink_soc_flush( GstWesterosSink *sink );
gboolean gst_westeros_sink_soc_start_video( GstWesterosSink *sink );
void gst_westeros_sink_soc_eos_event( GstWesterosSink *sink );
void gst_westeros_sink_soc_set_video_path( GstWesterosSink *sink, bool useGfxPath );
void gst_westeros_sink_soc_update_video_position( GstWesterosSink *sink );
gboolean gst_westeros_sink_soc_query( GstWesterosSink *sink, GstQuery *query );
void gst_westeros_sink_soc_set_compositor_lock(GstWesterosSink *sink, bool lock);
void gst_westeros_sink_soc_set_speed( GstWesterosSink *sink, const GValue *value );

#endif
