//@ skip if $memoryLimited
//@ skip if $buildType == "debug"
//@ runDefault

let regExps = [
    /* $regExp$0 */ /\D/g,
    /* $regExp$1 */ /^[^{]+\{\s*\[native \w/,
    /* $regExp$2 */ /[^\x20\t\r\n\f]+/g,
    /* $regExp$3 */ /^margin/,
    /* $regExp$4 */ /\w+/g,
    /* $regExp$5 */ /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,
    /* $regExp$6 */ /[\d_.]/g,
    /* $regExp$7 */ /[a-z][A-Z]/g,
    /* $regExp$8 */ /^(www|m|secure)\./,
    /* $regExp$9 */ /\.(com|info|net|org|edu|gov)$/,
    /* $regExp$10 */ /\s+/g,
    /* $regExp$11 */ /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,
    /* $regExp$12 */ /^([^.]*)(?:\.(.+)|)/,
    /* $regExp$13 */ /=[\x20\t\r\n\f]*([^\]'"]*?)[\x20\t\r\n\f]*\]/g,
    /* $regExp$14 */ /^[\x20\t\r\n\f]*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\([\x20\t\r\n\f]*((?:-\d)?\d*)[\x20\t\r\n\f]*\)|)(?=[^-]|$)/i,
    /* $regExp$15 */ /^-ms-/,
    /* $regExp$16 */ /-([a-z])/g,
    /* $regExp$17 */ /^\//,
    /* $regExp$18 */ /\:|\*/,
    /* $regExp$19 */ /\\d|\\w/,
    /* $regExp$20 */ /[^\w\d\- %@&]*\*[^\w\d\- %@&]*/,
    /* $regExp$21 */ /:([^\/]+)/gi,
    /* $regExp$22 */ /.*#/,
    /* $regExp$23 */ /\?.*/,
    /* $regExp$24 */ /^\/([._a-zA-Z0-9-%()]+)/,
    /* $regExp$25 */ /^(?:[^\x00]*?(?=(\{\{)))/,
    /* $regExp$26 */ /(?:\r\n?|\n).*/g,
    /* $regExp$27 */ /\r?\n?/,
    /* $regExp$28 */ /^(?:\()/,
    /* $regExp$29 */ /^(?:\))/,
    /* $regExp$30 */ /^(?:\{\{\{\{)/,
    /* $regExp$31 */ /^(?:\}\}\}\})/,
    /* $regExp$32 */ /^(?:\{\{(~)?>)/,
    /* $regExp$33 */ /^(?:\{\{(~)?#>)/,
    /* $regExp$34 */ /^(?:\{\{(~)?#\*?)/,
    /* $regExp$35 */ /^(?:\{\{(~)?\/)/,
    /* $regExp$36 */ /^(?:\{\{(~)?\^\s*(~)?\}\})/,
    /* $regExp$37 */ /^(?:\{\{(~)?\s*else\s*(~)?\}\})/,
    /* $regExp$38 */ /^(?:\{\{(~)?\^)/,
    /* $regExp$39 */ /^(?:\{\{(~)?\s*else\b)/,
    /* $regExp$40 */ /^(?:\{\{(~)?\{)/,
    /* $regExp$41 */ /^(?:\{\{(~)?&)/,
    /* $regExp$42 */ /^(?:\{\{(~)?!--)/,
    /* $regExp$43 */ /^(?:\{\{(~)?![\s\S]*?\}\})/,
    /* $regExp$44 */ /^(?:\{\{(~)?\*?)/,
    /* $regExp$45 */ /^(?:=)/,
    /* $regExp$46 */ /^(?:\.\.)/,
    /* $regExp$47 */ /^(?:\.(?=([=~}\s\/.)|])))/,
    /* $regExp$48 */ /^(?:[\/.])/,
    /* $regExp$49 */ /^(?:\s+)/,
    /* $regExp$50 */ /^(?:\}(~)?\}\})/,
    /* $regExp$51 */ /^(?:(~)?\}\})/,
    /* $regExp$52 */ /^(?:"(\\["]|[^"])*")/,
    /* $regExp$53 */ /^(?:'(\\[']|[^'])*')/,
    /* $regExp$54 */ /^(?:@)/,
    /* $regExp$55 */ /^(?:true(?=([~}\s)])))/,
    /* $regExp$56 */ /^(?:false(?=([~}\s)])))/,
    /* $regExp$57 */ /^(?:undefined(?=([~}\s)])))/,
    /* $regExp$58 */ /^(?:null(?=([~}\s)])))/,
    /* $regExp$59 */ /^(?:-?[0-9]+(?:\.[0-9]+)?(?=([~}\s)])))/,
    /* $regExp$60 */ /^(?:as\s+\|)/,
    /* $regExp$61 */ /^(?:\|)/,
    /* $regExp$62 */ /^(?:([^\s!"#%-,\.\/;->@\[-\^`\{-~]+(?=([=~}\s\/.)|]))))/,
    /* $regExp$63 */ /^\[.*\]$/,
    /* $regExp$64 */ /\*/,
    /* $regExp$65 */ /^(?:[^\x00]+)/,
    /* $regExp$66 */ /^(?:$)/,
    /* $regExp$67 */ /^\s*?\r?\n/,
    /* $regExp$68 */ /\r?\n\s*?$/,
    /* $regExp$69 */ /(^|\r?\n)\s*?$/,
    /* $regExp$70 */ /^\s*?(\r?\n|$)/,
    /* $regExp$71 */ /^[ \t]*\r?\n?/,
    /* $regExp$72 */ /[ \t]+$/,
    /* $regExp$73 */ /^\.|this\b/,
    /* $regExp$74 */ /\\/g,
    /* $regExp$75 */ /"/g,
    /* $regExp$76 */ /\n/g,
    /* $regExp$77 */ /\r/g,
    /* $regExp$78 */ /\u2028/g,
    /* $regExp$79 */ /\u2029/g,
    /* $regExp$80 */ /^[a-zA-Z_$][0-9a-zA-Z_$]*$/,
    /* $regExp$81 */ /<script|<style|<link/i,
    /* $regExp$82 */ /<([a-z][^\/\0>\x20\t\r\n\f]+)/i,
    /* $regExp$83 */ /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi,
    /* $regExp$84 */ /\\'/g,
    /* $regExp$85 */ /[&<>"'`=]/,
    /* $regExp$86 */ /^(?:focusinfocus|focusoutblur)$/,
    /* $regExp$87 */ /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,
    /* $regExp$88 */ /.*\.apple\.com\.?$/,
    /* $regExp$89 */ /^(.+\.)?buzzfeed\.com\.?$/,
    /* $regExp$90 */ /^(.+\.)?mashable\.com\.?$/,
    /* $regExp$91 */ /^(.+\.)?cnet\.com\.?$/,
    /* $regExp$92 */ /^(.+\.)?engadget\.com\.?$/,
    /* $regExp$93 */ /^(.*\.)?m\.wikipedia\.org\.?$/,
    /* $regExp$94 */ /^(.*\.)?theintercept\.com\.?$/,
    /* $regExp$95 */ /^(.*\.)?tools\.ietf\.org\.?$/,
    /* $regExp$96 */ /^(.+\.)?meteoinfo\.ru\.?$/,
    /* $regExp$97 */ /^(.*\.)?tmd\.go\.th\.?$/,
    /* $regExp$98 */ /instapaper_body/,
    /* $regExp$99 */ /\S/,
    /* $regExp$100 */ /(?:(?:^|\s)(?:(post|hentry|entry)[-_]{0,2}(?:content|text|body)?|article[-_]{0,2}(?:content|text|body|page|copy)?)(?:\s|$))/i,
    /* $regExp$101 */ /[Cc]omment|meta|footer|footnote|talkback/,
    /* $regExp$102 */ /carousel/i,
    /* $regExp$103 */ /^[\x20\t\r\n\f]+|((?:^|[^\\])(?:\\.)*)[\x20\t\r\n\f]+$/g,
    /* $regExp$104 */ /^[\x20\t\r\n\f]*([>+~]|[\x20\t\r\n\f])[\x20\t\r\n\f]*/,
    /* $regExp$105 */ /^((?:\\.|[\w-]|[^\0-\xa0])+|[*])/,
    /* $regExp$106 */ /^\.((?:\\.|[\w-]|[^\0-\xa0])+)/,
    /* $regExp$107 */ /^\[[\x20\t\r\n\f]*((?:\\.|[\w-]|[^\0-\xa0])+)(?:[\x20\t\r\n\f]*([*^$|!~]?=)[\x20\t\r\n\f]*(?:'((?:\\.|[^\\'])*)'|"((?:\\.|[^\\"])*)"|((?:\\.|[\w-]|[^\0-\xa0])+))|)[\x20\t\r\n\f]*\]/,
    /* $regExp$108 */ /^:(only|first|last|nth|nth-last)-(child|of-type)(?:\([\x20\t\r\n\f]*(even|odd|(([+-]|)(\d*)n|)[\x20\t\r\n\f]*(?:([+-]|)[\x20\t\r\n\f]*(\d+)|))[\x20\t\r\n\f]*\)|)/i,
    /* $regExp$109 */ /^:((?:\\.|[\w-]|[^\0-\xa0])+)(?:\((('((?:\\.|[^\\'])*)'|"((?:\\.|[^\\"])*)")|((?:\\.|[^\\()[\]]|\[[\x20\t\r\n\f]*((?:\\.|[\w-]|[^\0-\xa0])+)(?:[\x20\t\r\n\f]*([*^$|!~]?=)[\x20\t\r\n\f]*(?:'((?:\\.|[^\\'])*)'|"((?:\\.|[^\\"])*)"|((?:\\.|[\w-]|[^\0-\xa0])+))|)[\x20\t\r\n\f]*\])*)|.*)\)|)/,
    /* $regExp$110 */ /^#((?:\\.|[\w-]|[^\0-\xa0])+)/,
    /* $regExp$111 */ /[+~]/,
    /* $regExp$112 */ /(^|[\x20\t\r\n\f])destroy([\x20\t\r\n\f]|$)/,
    /* $regExp$113 */ /(^|[\x20\t\r\n\f])toggle([\x20\t\r\n\f]|$)/,
    /* $regExp$114 */ /[A-Z]/g,
    /* $regExp$115 */ /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,
];
let strings = [
    /* string$0 */ "3.1.10.384002007129735",
    /* string$1 */ "function getElementsByClassName() {\n    [native code]\n}",
    /* string$2 */ "function querySelectorAll() {\n    [native code]\n}",
    /* string$3 */ "function matches() {\n    [native code]\n}",
    /* string$4 */ "function compareDocumentPosition() {\n    [native code]\n}",
    /* string$5 */ "memory",
    /* string$6 */ "once memory",
    /* string$7 */ "margin",
    /* string$8 */ "padding",
    /* string$9 */ "border",
    /* string$10 */ "^(?:checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped)$",
    /* string$11 */ "http:",
    /* string$12 */ "*",
    /* string$13 */ "script",
    /* string$14 */ "json jsonp",
    /* string$15 */ "toggle-all",
    /* string$16 */ "0.0.0.0:5000",
    /* string$17 */ "jQuery • TodoMVC",
    /* string$18 */ "new-todo",
    /* string$19 */ "todos\n",
    /* string$20 */ "todos\nDouble-click to edit a todo\n\nCreated by Sindre Sorhus\n\nPart of TodoMVC",
    /* string$21 */ "#todo-template",
    /* string$22 */ "#footer-template",
    /* string$23 */ "#new-todo",
    /* string$24 */ "keyup",
    /* string$25 */ "#toggle-all",
    /* string$26 */ "change",
    /* string$27 */ "#footer",
    /* string$28 */ "#clear-completed",
    /* string$29 */ "click",
    /* string$30 */ "#todo-list",
    /* string$31 */ ".toggle",
    /* string$32 */ "label",
    /* string$33 */ "dblclick",
    /* string$34 */ ".edit",
    /* string$35 */ "focusout",
    /* string$36 */ ".destroy",
    /* string$37 */ "/:filter",
    /* string$38 */ ":filter",
    /* string$39 */ "http://0.0.0.0:5000/resources/todomvc/architecture-examples/jquery/index.html#/all",
    /* string$40 */ "/all",
    /* string$41 */ "\n            {{#this}}\n            <li {{#if completed}}class=\"completed\"{{/if}} data-id=\"{{id}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$42 */ "\n            ",
    /* string$43 */ "{{#this}}\n            <li {{#if completed}}class=\"completed\"{{/if}} data-id=\"{{id}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$44 */ "{{#",
    /* string$45 */ "this}}\n            <li {{#if completed}}class=\"completed\"{{/if}} data-id=\"{{id}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$46 */ "this",
    /* string$47 */ "}}\n            <li {{#if completed}}class=\"completed\"{{/if}} data-id=\"{{id}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$48 */ "}}",
    /* string$49 */ "\n            <li {{#if completed}}class=\"completed\"{{/if}} data-id=\"{{id}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$50 */ "\n            <li ",
    /* string$51 */ "{{#if completed}}class=\"completed\"{{/if}} data-id=\"{{id}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$52 */ "if completed}}class=\"completed\"{{/if}} data-id=\"{{id}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$53 */ "if",
    /* string$54 */ " completed}}class=\"completed\"{{/if}} data-id=\"{{id}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$55 */ " ",
    /* string$56 */ "completed}}class=\"completed\"{{/if}} data-id=\"{{id}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$57 */ "completed",
    /* string$58 */ "}}class=\"completed\"{{/if}} data-id=\"{{id}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$59 */ "class=\"completed\"{{/if}} data-id=\"{{id}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$60 */ "class=\"completed\"",
    /* string$61 */ "{{/if}} data-id=\"{{id}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$62 */ "{{/",
    /* string$63 */ "if}} data-id=\"{{id}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$64 */ "}} data-id=\"{{id}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$65 */ " data-id=\"{{id}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$66 */ " data-id=\"",
    /* string$67 */ "{{id}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$68 */ "{{",
    /* string$69 */ "id}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$70 */ "id",
    /* string$71 */ "}}\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$72 */ "\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" {{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$73 */ "\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" ",
    /* string$74 */ "\n                    <input class=\"toggle\" type=\"checkbox\" ",
    /* string$75 */ "{{#if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$76 */ "if completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$77 */ " completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$78 */ "completed}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$79 */ "}}checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$80 */ "checked{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$81 */ "checked",
    /* string$82 */ "{{/if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$83 */ "if}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$84 */ "}}>\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$85 */ ">\n                    <label>{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$86 */ ">\n                    <label>",
    /* string$87 */ "\n                    <label>",
    /* string$88 */ "{{title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$89 */ "title}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$90 */ "title",
    /* string$91 */ "}}</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$92 */ "</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$93 */ "</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"",
    /* string$94 */ "\n                <input class=\"edit\" value=\"",
    /* string$95 */ "{{title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$96 */ "title}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$97 */ "}}\">\n            </li>\n        {{/this}}\n        ",
    /* string$98 */ "\">\n            </li>\n        {{/this}}\n        ",
    /* string$99 */ "\">\n            </li>\n        ",
    /* string$100 */ "\n        ",
    /* string$101 */ "{{/this}}\n        ",
    /* string$102 */ "this}}\n        ",
    /* string$103 */ "}}\n        ",
    /* string$104 */ "",
    /* string$105 */ "class=\\\"completed\\\"",
    /* string$106 */ "name",
    /* string$107 */ "hash",
    /* string$108 */ "fn",
    /* string$109 */ "inverse",
    /* string$110 */ "data",
    /* string$111 */ "            <li ",
    /* string$112 */ " data-id=\\\"",
    /* string$113 */ "\\\">\n                <div class=\\\"view\\\">\n                    <input class=\\\"toggle\\\" type=\\\"checkbox\\\" ",
    /* string$114 */ "\\\">\\n                <div class=\\\"view\\\">\\n                    <input class=\\\"toggle\\\" type=\\\"checkbox\\\" ",
    /* string$115 */ ">\\n                    <label>",
    /* string$116 */ "</label>\n                    <button class=\\\"destroy\\\"></button>\n                </div>\n                <input class=\\\"edit\\\" value=\\\"",
    /* string$117 */ "</label>\\n                    <button class=\\\"destroy\\\"></button>\\n                </div>\\n                <input class=\\\"edit\\\" value=\\\"",
    /* string$118 */ "\">\n            </li>\n",
    /* string$119 */ "\\\">\n            </li>\n",
    /* string$120 */ "\\\">\\n            </li>\\n",
    /* string$121 */ "\n",
    /* string$122 */ "\\n",
    /* string$123 */ "        ",
    /* string$124 */ "#main",
    /* string$125 */ "display",
    /* string$126 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>{{activeTodoCount}}</strong> {{activeTodoWord}} left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a {{#eq filter 'all'}}class=\"selected\"{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$127 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>",
    /* string$128 */ "{{activeTodoCount}}</strong> {{activeTodoWord}} left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a {{#eq filter 'all'}}class=\"selected\"{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$129 */ "activeTodoCount}}</strong> {{activeTodoWord}} left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a {{#eq filter 'all'}}class=\"selected\"{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$130 */ "activeTodoCount",
    /* string$131 */ "}}</strong> {{activeTodoWord}} left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a {{#eq filter 'all'}}class=\"selected\"{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$132 */ "</strong> {{activeTodoWord}} left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a {{#eq filter 'all'}}class=\"selected\"{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$133 */ "</strong> ",
    /* string$134 */ "{{activeTodoWord}} left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a {{#eq filter 'all'}}class=\"selected\"{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$135 */ "activeTodoWord}} left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a {{#eq filter 'all'}}class=\"selected\"{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$136 */ "activeTodoWord",
    /* string$137 */ "}} left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a {{#eq filter 'all'}}class=\"selected\"{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$138 */ " left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a {{#eq filter 'all'}}class=\"selected\"{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$139 */ " left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a ",
    /* string$140 */ "\n                    <a ",
    /* string$141 */ "{{#eq filter 'all'}}class=\"selected\"{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$142 */ "eq filter 'all'}}class=\"selected\"{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$143 */ "eq",
    /* string$144 */ " filter 'all'}}class=\"selected\"{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$145 */ "filter 'all'}}class=\"selected\"{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$146 */ "filter",
    /* string$147 */ " 'all'}}class=\"selected\"{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$148 */ "'all'}}class=\"selected\"{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$149 */ "'all'",
    /* string$150 */ "all",
    /* string$151 */ "}}class=\"selected\"{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$152 */ "class=\"selected\"{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$153 */ "class=\"selected\"",
    /* string$154 */ "{{/eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$155 */ "eq}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$156 */ "}} href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$157 */ " href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$158 */ " href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a ",
    /* string$159 */ "{{#eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$160 */ "eq filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$161 */ " filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$162 */ "filter 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$163 */ " 'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$164 */ "'active'}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$165 */ "'active'",
    /* string$166 */ "active",
    /* string$167 */ "}}class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$168 */ "class=\"selected\"{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$169 */ "{{/eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$170 */ "eq}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$171 */ "}}href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$172 */ "href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a {{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$173 */ "href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a ",
    /* string$174 */ "{{#eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$175 */ "eq filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$176 */ " filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$177 */ "filter 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$178 */ " 'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$179 */ "'completed'}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$180 */ "'completed'",
    /* string$181 */ "}}class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$182 */ "class=\"selected\"{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$183 */ "{{/eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$184 */ "eq}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$185 */ "}}href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$186 */ "href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            {{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$187 */ "href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            ",
    /* string$188 */ "{{#if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$189 */ "if completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$190 */ " completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$191 */ "completedTodos}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$192 */ "completedTodos",
    /* string$193 */ "}}<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$194 */ "<button id=\"clear-completed\">Clear completed</button>{{/if}}\n        ",
    /* string$195 */ "<button id=\"clear-completed\">Clear completed</button>",
    /* string$196 */ "{{/if}}\n        ",
    /* string$197 */ "if}}\n        ",
    /* string$198 */ "class=\\\"selected\\\"",
    /* string$199 */ "<button id=\\\"clear-completed\\\">Clear completed</button>",
    /* string$200 */ "\n            <span id=\\\"todo-count\\\" class=\\\"todo-count\\\"><strong>",
    /* string$201 */ "\\n            <span id=\\\"todo-count\\\" class=\\\"todo-count\\\"><strong>",
    /* string$202 */ " left</span>\n            <ul id=\\\"filters\\\" class=\\\"filters\\\">\n                <li>\n                    <a ",
    /* string$203 */ " left</span>\\n            <ul id=\\\"filters\\\" class=\\\"filters\\\">\\n                <li>\\n                    <a ",
    /* string$204 */ " href=\\\"#/all\\\">All</a>\n                </li>\n                <li>\n                    <a ",
    /* string$205 */ " href=\\\"#/all\\\">All</a>\\n                </li>\\n                <li>\\n                    <a ",
    /* string$206 */ "href=\\\"#/active\\\">Active</a>\n                </li>\n                <li>\n                    <a ",
    /* string$207 */ "href=\\\"#/active\\\">Active</a>\\n                </li>\\n                <li>\\n                    <a ",
    /* string$208 */ "href=\\\"#/completed\\\">Completed</a>\n                </li>\n            </ul>\n            ",
    /* string$209 */ "href=\\\"#/completed\\\">Completed</a>\\n                </li>\\n            </ul>\\n            ",
    /* string$210 */ "\\n        ",
    /* string$211 */ "items",
    /* string$212 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>0</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$213 */ "focusundefined",
    /* string$214 */ "focusinfocus",
    /* string$215 */ "events",
    /* string$216 */ "Something to do 0",
    /* string$217 */ "dab6d3d6-5f12-4668-9142-871745498fde",
    /* string$218 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n        ",
    /* string$219 */ "1",
    /* string$220 */ "item",
    /* string$221 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>1</strong> item left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$222 */ "Something to do 1",
    /* string$223 */ "63704342-720c-4685-895e-e6fac1f383ef",
    /* string$224 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n        ",
    /* string$225 */ "2",
    /* string$226 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>2</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$227 */ "Something to do 2",
    /* string$228 */ "35e341dd-85f4-4d01-9a01-40b331c7132a",
    /* string$229 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n        ",
    /* string$230 */ "3",
    /* string$231 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>3</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$232 */ "Something to do 3",
    /* string$233 */ "a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74",
    /* string$234 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n        ",
    /* string$235 */ "4",
    /* string$236 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>4</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$237 */ "Something to do 4",
    /* string$238 */ "2b263105-8cbe-4f8a-a195-d2eddd49ab6e",
    /* string$239 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n        ",
    /* string$240 */ "5",
    /* string$241 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>5</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$242 */ "Something to do 5",
    /* string$243 */ "d79efb5f-4476-4138-8a1e-16a7b0b85cb8",
    /* string$244 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n        ",
    /* string$245 */ "6",
    /* string$246 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>6</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$247 */ "Something to do 6",
    /* string$248 */ "c60668e2-31ac-4ffa-9451-b0cd213cfe0f",
    /* string$249 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n        ",
    /* string$250 */ "7",
    /* string$251 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>7</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$252 */ "Something to do 7",
    /* string$253 */ "64351b5e-b59f-4f02-beb8-a948f91d6a7c",
    /* string$254 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n        ",
    /* string$255 */ "8",
    /* string$256 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>8</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$257 */ "Something to do 8",
    /* string$258 */ "eefef126-628a-43dd-9365-abd05b2bb8bf",
    /* string$259 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n        ",
    /* string$260 */ "9",
    /* string$261 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>9</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$262 */ "Something to do 9",
    /* string$263 */ "2c76c9d1-5352-4316-a2d0-409b0c8c81ef",
    /* string$264 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n        ",
    /* string$265 */ "10",
    /* string$266 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>10</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$267 */ "Something to do 10",
    /* string$268 */ "a4a532e4-99bd-42dd-918f-6cfe273bb3c4",
    /* string$269 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n        ",
    /* string$270 */ "11",
    /* string$271 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>11</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$272 */ "Something to do 11",
    /* string$273 */ "bd44b3b4-87b5-4660-80f5-aa5e26c7573e",
    /* string$274 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n        ",
    /* string$275 */ "12",
    /* string$276 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>12</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$277 */ "Something to do 12",
    /* string$278 */ "60275786-c394-4953-b416-7c443c8ba235",
    /* string$279 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n        ",
    /* string$280 */ "13",
    /* string$281 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>13</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$282 */ "Something to do 13",
    /* string$283 */ "09a53c42-a386-4f95-8116-6c0a3c322de8",
    /* string$284 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n        ",
    /* string$285 */ "14",
    /* string$286 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>14</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$287 */ "Something to do 14",
    /* string$288 */ "3466274f-7ab8-4455-89ef-de6ccb3a1251",
    /* string$289 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n        ",
    /* string$290 */ "15",
    /* string$291 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>15</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$292 */ "Something to do 15",
    /* string$293 */ "562c5ac1-565f-4af8-b97c-98711ea3d666",
    /* string$294 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n        ",
    /* string$295 */ "16",
    /* string$296 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>16</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$297 */ "Something to do 16",
    /* string$298 */ "27c44961-be75-4b83-b529-d76224860d3f",
    /* string$299 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n        ",
    /* string$300 */ "17",
    /* string$301 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>17</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$302 */ "Something to do 17",
    /* string$303 */ "94c80434-b8b7-435d-a7c5-da68c963e92f",
    /* string$304 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n        ",
    /* string$305 */ "18",
    /* string$306 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>18</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$307 */ "Something to do 18",
    /* string$308 */ "7e6f3a13-7718-4444-8021-4b816424450e",
    /* string$309 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n        ",
    /* string$310 */ "19",
    /* string$311 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>19</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$312 */ "Something to do 19",
    /* string$313 */ "5b8aae1b-dba6-48a4-becd-9236ba73cd12",
    /* string$314 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n        ",
    /* string$315 */ "20",
    /* string$316 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>20</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$317 */ "Something to do 20",
    /* string$318 */ "190bc3f2-b555-4e33-9fff-f8950b7fe4e5",
    /* string$319 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n        ",
    /* string$320 */ "21",
    /* string$321 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>21</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$322 */ "Something to do 21",
    /* string$323 */ "f08840c2-02fd-4b8f-9665-7630daf4ff17",
    /* string$324 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n        ",
    /* string$325 */ "22",
    /* string$326 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>22</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$327 */ "Something to do 22",
    /* string$328 */ "510fddfe-7b7a-4df0-b0ad-90f2a6311d72",
    /* string$329 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n        ",
    /* string$330 */ "23",
    /* string$331 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>23</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$332 */ "Something to do 23",
    /* string$333 */ "039952d3-3314-469c-bfe2-5f1f87853ed5",
    /* string$334 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n        ",
    /* string$335 */ "24",
    /* string$336 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>24</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$337 */ "Something to do 24",
    /* string$338 */ "70417806-a92d-4c33-8454-b07ae4196b18",
    /* string$339 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n        ",
    /* string$340 */ "25",
    /* string$341 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>25</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$342 */ "Something to do 25",
    /* string$343 */ "ed9fe5b5-cfd7-4236-991b-280d18a4381e",
    /* string$344 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n        ",
    /* string$345 */ "26",
    /* string$346 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>26</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$347 */ "Something to do 26",
    /* string$348 */ "d0552c21-204a-4fd7-8cf4-c0d11cdd301a",
    /* string$349 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n        ",
    /* string$350 */ "27",
    /* string$351 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>27</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$352 */ "Something to do 27",
    /* string$353 */ "fb181d90-a7ae-400a-b192-6c2e9e8969d3",
    /* string$354 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n        ",
    /* string$355 */ "28",
    /* string$356 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>28</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$357 */ "Something to do 28",
    /* string$358 */ "80923452-cb65-4312-874b-b188cd55f3ae",
    /* string$359 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n        ",
    /* string$360 */ "29",
    /* string$361 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>29</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$362 */ "Something to do 29",
    /* string$363 */ "89d53a53-481b-4915-9b5f-521c3dee773f",
    /* string$364 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n        ",
    /* string$365 */ "30",
    /* string$366 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>30</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$367 */ "Something to do 30",
    /* string$368 */ "1c18cc01-d1ec-4342-921f-30b1722a925c",
    /* string$369 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n        ",
    /* string$370 */ "31",
    /* string$371 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>31</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$372 */ "Something to do 31",
    /* string$373 */ "a27a1ffc-5f55-4ad5-b4de-4288ff029d96",
    /* string$374 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n        ",
    /* string$375 */ "32",
    /* string$376 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>32</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$377 */ "Something to do 32",
    /* string$378 */ "af6e38e6-0763-4284-a3ae-4e6393b933a7",
    /* string$379 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n        ",
    /* string$380 */ "33",
    /* string$381 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>33</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$382 */ "Something to do 33",
    /* string$383 */ "e17b9929-5508-466c-8659-0860cad1a6de",
    /* string$384 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n        ",
    /* string$385 */ "34",
    /* string$386 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>34</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$387 */ "Something to do 34",
    /* string$388 */ "e9e55080-4f0e-4729-aa2b-12c14ddeeb4b",
    /* string$389 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n        ",
    /* string$390 */ "35",
    /* string$391 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>35</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$392 */ "Something to do 35",
    /* string$393 */ "226c9f3b-f15e-4fb8-b515-05b750df2b93",
    /* string$394 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n        ",
    /* string$395 */ "36",
    /* string$396 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>36</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$397 */ "Something to do 36",
    /* string$398 */ "28fc2d55-90e3-49fa-b7f5-80aa90c61f47",
    /* string$399 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n        ",
    /* string$400 */ "37",
    /* string$401 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>37</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$402 */ "Something to do 37",
    /* string$403 */ "0180c66b-e2f1-473f-89a8-3e139562bf26",
    /* string$404 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n        ",
    /* string$405 */ "38",
    /* string$406 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>38</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$407 */ "Something to do 38",
    /* string$408 */ "efcd234e-f533-4f92-92a5-68c1a9844356",
    /* string$409 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n        ",
    /* string$410 */ "39",
    /* string$411 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>39</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$412 */ "Something to do 39",
    /* string$413 */ "3ae470fd-ae1b-409f-a066-37386d9b2367",
    /* string$414 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n        ",
    /* string$415 */ "40",
    /* string$416 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>40</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$417 */ "Something to do 40",
    /* string$418 */ "6d1ec432-e55b-4812-b8f4-225b960c4506",
    /* string$419 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n        ",
    /* string$420 */ "41",
    /* string$421 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>41</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$422 */ "Something to do 41",
    /* string$423 */ "24f5fea5-7686-419a-b38d-e80942381044",
    /* string$424 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n        ",
    /* string$425 */ "42",
    /* string$426 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>42</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$427 */ "Something to do 42",
    /* string$428 */ "5b2816c0-1bd5-4ae9-8d80-77323c9da0cb",
    /* string$429 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n        ",
    /* string$430 */ "43",
    /* string$431 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>43</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$432 */ "Something to do 43",
    /* string$433 */ "e69d041c-38d0-418f-afa3-476dcebc955f",
    /* string$434 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n        ",
    /* string$435 */ "44",
    /* string$436 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>44</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$437 */ "Something to do 44",
    /* string$438 */ "476ae928-dd4d-4edd-82fb-64feba5d43b3",
    /* string$439 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n        ",
    /* string$440 */ "45",
    /* string$441 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>45</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$442 */ "Something to do 45",
    /* string$443 */ "761c94bd-a5e0-4703-abb0-9cb0bb0cffd6",
    /* string$444 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n        ",
    /* string$445 */ "46",
    /* string$446 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>46</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$447 */ "Something to do 46",
    /* string$448 */ "762aaec2-06a1-4702-b39a-11e934ee6391",
    /* string$449 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n        ",
    /* string$450 */ "47",
    /* string$451 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>47</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$452 */ "Something to do 47",
    /* string$453 */ "9a891906-baad-410a-8187-11c95ff2678e",
    /* string$454 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n        ",
    /* string$455 */ "48",
    /* string$456 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>48</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$457 */ "Something to do 48",
    /* string$458 */ "e15f1a81-5664-4204-8c34-189cd32b1216",
    /* string$459 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n        ",
    /* string$460 */ "49",
    /* string$461 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>49</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$462 */ "Something to do 49",
    /* string$463 */ "f54c2420-9a10-475b-bef1-29e0988df208",
    /* string$464 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n        ",
    /* string$465 */ "50",
    /* string$466 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>50</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$467 */ "Something to do 50",
    /* string$468 */ "5170b656-4e5c-45cb-be5d-8df42333dc87",
    /* string$469 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n            <li  data-id=\"5170b656-4e5c-45cb-be5d-8df42333dc87\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 50</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 50\">\n            </li>\n        ",
    /* string$470 */ "51",
    /* string$471 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>51</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$472 */ "Something to do 51",
    /* string$473 */ "c5dea0e7-240e-4877-992d-9affc77a260e",
    /* string$474 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n            <li  data-id=\"5170b656-4e5c-45cb-be5d-8df42333dc87\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 50</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 50\">\n            </li>\n            <li  data-id=\"c5dea0e7-240e-4877-992d-9affc77a260e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 51</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 51\">\n            </li>\n        ",
    /* string$475 */ "52",
    /* string$476 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>52</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$477 */ "Something to do 52",
    /* string$478 */ "d39dedca-1b74-4c72-8afe-16de5ae9fe03",
    /* string$479 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n            <li  data-id=\"5170b656-4e5c-45cb-be5d-8df42333dc87\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 50</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 50\">\n            </li>\n            <li  data-id=\"c5dea0e7-240e-4877-992d-9affc77a260e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 51</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 51\">\n            </li>\n            <li  data-id=\"d39dedca-1b74-4c72-8afe-16de5ae9fe03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 52</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 52\">\n            </li>\n        ",
    /* string$480 */ "53",
    /* string$481 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>53</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$482 */ "Something to do 53",
    /* string$483 */ "2448d193-d323-4ba5-8af8-f28f10f28724",
    /* string$484 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n            <li  data-id=\"5170b656-4e5c-45cb-be5d-8df42333dc87\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 50</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 50\">\n            </li>\n            <li  data-id=\"c5dea0e7-240e-4877-992d-9affc77a260e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 51</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 51\">\n            </li>\n            <li  data-id=\"d39dedca-1b74-4c72-8afe-16de5ae9fe03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 52</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 52\">\n            </li>\n            <li  data-id=\"2448d193-d323-4ba5-8af8-f28f10f28724\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 53</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 53\">\n            </li>\n        ",
    /* string$485 */ "54",
    /* string$486 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>54</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$487 */ "Something to do 54",
    /* string$488 */ "5fb28e93-9429-4060-9f58-834090f36de1",
    /* string$489 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n            <li  data-id=\"5170b656-4e5c-45cb-be5d-8df42333dc87\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 50</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 50\">\n            </li>\n            <li  data-id=\"c5dea0e7-240e-4877-992d-9affc77a260e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 51</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 51\">\n            </li>\n            <li  data-id=\"d39dedca-1b74-4c72-8afe-16de5ae9fe03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 52</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 52\">\n            </li>\n            <li  data-id=\"2448d193-d323-4ba5-8af8-f28f10f28724\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 53</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 53\">\n            </li>\n            <li  data-id=\"5fb28e93-9429-4060-9f58-834090f36de1\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 54</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 54\">\n            </li>\n        ",
    /* string$490 */ "55",
    /* string$491 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>55</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$492 */ "Something to do 55",
    /* string$493 */ "7b18bcf3-7366-466f-b4fb-8ec3c053b148",
    /* string$494 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n            <li  data-id=\"5170b656-4e5c-45cb-be5d-8df42333dc87\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 50</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 50\">\n            </li>\n            <li  data-id=\"c5dea0e7-240e-4877-992d-9affc77a260e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 51</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 51\">\n            </li>\n            <li  data-id=\"d39dedca-1b74-4c72-8afe-16de5ae9fe03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 52</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 52\">\n            </li>\n            <li  data-id=\"2448d193-d323-4ba5-8af8-f28f10f28724\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 53</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 53\">\n            </li>\n            <li  data-id=\"5fb28e93-9429-4060-9f58-834090f36de1\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 54</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 54\">\n            </li>\n            <li  data-id=\"7b18bcf3-7366-466f-b4fb-8ec3c053b148\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 55</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 55\">\n            </li>\n        ",
    /* string$495 */ "56",
    /* string$496 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>56</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$497 */ "Something to do 56",
    /* string$498 */ "a76b891f-719e-4be5-a321-906acd4c732d",
    /* string$499 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n            <li  data-id=\"5170b656-4e5c-45cb-be5d-8df42333dc87\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 50</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 50\">\n            </li>\n            <li  data-id=\"c5dea0e7-240e-4877-992d-9affc77a260e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 51</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 51\">\n            </li>\n            <li  data-id=\"d39dedca-1b74-4c72-8afe-16de5ae9fe03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 52</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 52\">\n            </li>\n            <li  data-id=\"2448d193-d323-4ba5-8af8-f28f10f28724\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 53</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 53\">\n            </li>\n            <li  data-id=\"5fb28e93-9429-4060-9f58-834090f36de1\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 54</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 54\">\n            </li>\n            <li  data-id=\"7b18bcf3-7366-466f-b4fb-8ec3c053b148\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 55</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 55\">\n            </li>\n            <li  data-id=\"a76b891f-719e-4be5-a321-906acd4c732d\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 56</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 56\">\n            </li>\n        ",
    /* string$500 */ "57",
    /* string$501 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>57</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$502 */ "Something to do 57",
    /* string$503 */ "be5ef175-72df-476a-a581-16ca990d0feb",
    /* string$504 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n            <li  data-id=\"5170b656-4e5c-45cb-be5d-8df42333dc87\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 50</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 50\">\n            </li>\n            <li  data-id=\"c5dea0e7-240e-4877-992d-9affc77a260e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 51</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 51\">\n            </li>\n            <li  data-id=\"d39dedca-1b74-4c72-8afe-16de5ae9fe03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 52</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 52\">\n            </li>\n            <li  data-id=\"2448d193-d323-4ba5-8af8-f28f10f28724\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 53</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 53\">\n            </li>\n            <li  data-id=\"5fb28e93-9429-4060-9f58-834090f36de1\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 54</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 54\">\n            </li>\n            <li  data-id=\"7b18bcf3-7366-466f-b4fb-8ec3c053b148\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 55</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 55\">\n            </li>\n            <li  data-id=\"a76b891f-719e-4be5-a321-906acd4c732d\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 56</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 56\">\n            </li>\n            <li  data-id=\"be5ef175-72df-476a-a581-16ca990d0feb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 57</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 57\">\n            </li>\n        ",
    /* string$505 */ "58",
    /* string$506 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>58</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$507 */ "Something to do 58",
    /* string$508 */ "6427257e-7cdf-411b-930c-e5ca702034c9",
    /* string$509 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n            <li  data-id=\"5170b656-4e5c-45cb-be5d-8df42333dc87\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 50</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 50\">\n            </li>\n            <li  data-id=\"c5dea0e7-240e-4877-992d-9affc77a260e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 51</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 51\">\n            </li>\n            <li  data-id=\"d39dedca-1b74-4c72-8afe-16de5ae9fe03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 52</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 52\">\n            </li>\n            <li  data-id=\"2448d193-d323-4ba5-8af8-f28f10f28724\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 53</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 53\">\n            </li>\n            <li  data-id=\"5fb28e93-9429-4060-9f58-834090f36de1\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 54</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 54\">\n            </li>\n            <li  data-id=\"7b18bcf3-7366-466f-b4fb-8ec3c053b148\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 55</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 55\">\n            </li>\n            <li  data-id=\"a76b891f-719e-4be5-a321-906acd4c732d\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 56</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 56\">\n            </li>\n            <li  data-id=\"be5ef175-72df-476a-a581-16ca990d0feb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 57</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 57\">\n            </li>\n            <li  data-id=\"6427257e-7cdf-411b-930c-e5ca702034c9\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 58</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 58\">\n            </li>\n        ",
    /* string$510 */ "59",
    /* string$511 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>59</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$512 */ "Something to do 59",
    /* string$513 */ "2a8371b5-d2c0-4105-86f8-94d8a390c884",
    /* string$514 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n            <li  data-id=\"5170b656-4e5c-45cb-be5d-8df42333dc87\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 50</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 50\">\n            </li>\n            <li  data-id=\"c5dea0e7-240e-4877-992d-9affc77a260e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 51</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 51\">\n            </li>\n            <li  data-id=\"d39dedca-1b74-4c72-8afe-16de5ae9fe03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 52</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 52\">\n            </li>\n            <li  data-id=\"2448d193-d323-4ba5-8af8-f28f10f28724\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 53</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 53\">\n            </li>\n            <li  data-id=\"5fb28e93-9429-4060-9f58-834090f36de1\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 54</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 54\">\n            </li>\n            <li  data-id=\"7b18bcf3-7366-466f-b4fb-8ec3c053b148\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 55</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 55\">\n            </li>\n            <li  data-id=\"a76b891f-719e-4be5-a321-906acd4c732d\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 56</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 56\">\n            </li>\n            <li  data-id=\"be5ef175-72df-476a-a581-16ca990d0feb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 57</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 57\">\n            </li>\n            <li  data-id=\"6427257e-7cdf-411b-930c-e5ca702034c9\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 58</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 58\">\n            </li>\n            <li  data-id=\"2a8371b5-d2c0-4105-86f8-94d8a390c884\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 59</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 59\">\n            </li>\n        ",
    /* string$515 */ "60",
    /* string$516 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>60</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$517 */ "Something to do 60",
    /* string$518 */ "2ed14749-e3f6-415f-860d-93db9b97ce03",
    /* string$519 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n            <li  data-id=\"5170b656-4e5c-45cb-be5d-8df42333dc87\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 50</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 50\">\n            </li>\n            <li  data-id=\"c5dea0e7-240e-4877-992d-9affc77a260e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 51</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 51\">\n            </li>\n            <li  data-id=\"d39dedca-1b74-4c72-8afe-16de5ae9fe03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 52</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 52\">\n            </li>\n            <li  data-id=\"2448d193-d323-4ba5-8af8-f28f10f28724\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 53</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 53\">\n            </li>\n            <li  data-id=\"5fb28e93-9429-4060-9f58-834090f36de1\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 54</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 54\">\n            </li>\n            <li  data-id=\"7b18bcf3-7366-466f-b4fb-8ec3c053b148\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 55</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 55\">\n            </li>\n            <li  data-id=\"a76b891f-719e-4be5-a321-906acd4c732d\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 56</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 56\">\n            </li>\n            <li  data-id=\"be5ef175-72df-476a-a581-16ca990d0feb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 57</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 57\">\n            </li>\n            <li  data-id=\"6427257e-7cdf-411b-930c-e5ca702034c9\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 58</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 58\">\n            </li>\n            <li  data-id=\"2a8371b5-d2c0-4105-86f8-94d8a390c884\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 59</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 59\">\n            </li>\n            <li  data-id=\"2ed14749-e3f6-415f-860d-93db9b97ce03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 60</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 60\">\n            </li>\n        ",
    /* string$520 */ "61",
    /* string$521 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>61</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$522 */ "Something to do 61",
    /* string$523 */ "ab175a2c-60fd-4979-af3c-5f63deae70a7",
    /* string$524 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n            <li  data-id=\"5170b656-4e5c-45cb-be5d-8df42333dc87\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 50</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 50\">\n            </li>\n            <li  data-id=\"c5dea0e7-240e-4877-992d-9affc77a260e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 51</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 51\">\n            </li>\n            <li  data-id=\"d39dedca-1b74-4c72-8afe-16de5ae9fe03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 52</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 52\">\n            </li>\n            <li  data-id=\"2448d193-d323-4ba5-8af8-f28f10f28724\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 53</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 53\">\n            </li>\n            <li  data-id=\"5fb28e93-9429-4060-9f58-834090f36de1\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 54</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 54\">\n            </li>\n            <li  data-id=\"7b18bcf3-7366-466f-b4fb-8ec3c053b148\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 55</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 55\">\n            </li>\n            <li  data-id=\"a76b891f-719e-4be5-a321-906acd4c732d\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 56</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 56\">\n            </li>\n            <li  data-id=\"be5ef175-72df-476a-a581-16ca990d0feb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 57</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 57\">\n            </li>\n            <li  data-id=\"6427257e-7cdf-411b-930c-e5ca702034c9\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 58</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 58\">\n            </li>\n            <li  data-id=\"2a8371b5-d2c0-4105-86f8-94d8a390c884\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 59</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 59\">\n            </li>\n            <li  data-id=\"2ed14749-e3f6-415f-860d-93db9b97ce03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 60</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 60\">\n            </li>\n            <li  data-id=\"ab175a2c-60fd-4979-af3c-5f63deae70a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 61</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 61\">\n            </li>\n        ",
    /* string$525 */ "62",
    /* string$526 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>62</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$527 */ "Something to do 62",
    /* string$528 */ "2f931481-78b0-4180-862b-a6890dbf18e9",
    /* string$529 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n            <li  data-id=\"5170b656-4e5c-45cb-be5d-8df42333dc87\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 50</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 50\">\n            </li>\n            <li  data-id=\"c5dea0e7-240e-4877-992d-9affc77a260e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 51</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 51\">\n            </li>\n            <li  data-id=\"d39dedca-1b74-4c72-8afe-16de5ae9fe03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 52</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 52\">\n            </li>\n            <li  data-id=\"2448d193-d323-4ba5-8af8-f28f10f28724\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 53</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 53\">\n            </li>\n            <li  data-id=\"5fb28e93-9429-4060-9f58-834090f36de1\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 54</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 54\">\n            </li>\n            <li  data-id=\"7b18bcf3-7366-466f-b4fb-8ec3c053b148\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 55</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 55\">\n            </li>\n            <li  data-id=\"a76b891f-719e-4be5-a321-906acd4c732d\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 56</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 56\">\n            </li>\n            <li  data-id=\"be5ef175-72df-476a-a581-16ca990d0feb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 57</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 57\">\n            </li>\n            <li  data-id=\"6427257e-7cdf-411b-930c-e5ca702034c9\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 58</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 58\">\n            </li>\n            <li  data-id=\"2a8371b5-d2c0-4105-86f8-94d8a390c884\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 59</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 59\">\n            </li>\n            <li  data-id=\"2ed14749-e3f6-415f-860d-93db9b97ce03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 60</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 60\">\n            </li>\n            <li  data-id=\"ab175a2c-60fd-4979-af3c-5f63deae70a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 61</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 61\">\n            </li>\n            <li  data-id=\"2f931481-78b0-4180-862b-a6890dbf18e9\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 62</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 62\">\n            </li>\n        ",
    /* string$530 */ "63",
    /* string$531 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>63</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$532 */ "Something to do 63",
    /* string$533 */ "9ffa2f51-de1c-40e2-b8e4-d699dbc2095a",
    /* string$534 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n            <li  data-id=\"5170b656-4e5c-45cb-be5d-8df42333dc87\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 50</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 50\">\n            </li>\n            <li  data-id=\"c5dea0e7-240e-4877-992d-9affc77a260e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 51</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 51\">\n            </li>\n            <li  data-id=\"d39dedca-1b74-4c72-8afe-16de5ae9fe03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 52</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 52\">\n            </li>\n            <li  data-id=\"2448d193-d323-4ba5-8af8-f28f10f28724\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 53</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 53\">\n            </li>\n            <li  data-id=\"5fb28e93-9429-4060-9f58-834090f36de1\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 54</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 54\">\n            </li>\n            <li  data-id=\"7b18bcf3-7366-466f-b4fb-8ec3c053b148\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 55</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 55\">\n            </li>\n            <li  data-id=\"a76b891f-719e-4be5-a321-906acd4c732d\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 56</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 56\">\n            </li>\n            <li  data-id=\"be5ef175-72df-476a-a581-16ca990d0feb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 57</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 57\">\n            </li>\n            <li  data-id=\"6427257e-7cdf-411b-930c-e5ca702034c9\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 58</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 58\">\n            </li>\n            <li  data-id=\"2a8371b5-d2c0-4105-86f8-94d8a390c884\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 59</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 59\">\n            </li>\n            <li  data-id=\"2ed14749-e3f6-415f-860d-93db9b97ce03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 60</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 60\">\n            </li>\n            <li  data-id=\"ab175a2c-60fd-4979-af3c-5f63deae70a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 61</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 61\">\n            </li>\n            <li  data-id=\"2f931481-78b0-4180-862b-a6890dbf18e9\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 62</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 62\">\n            </li>\n            <li  data-id=\"9ffa2f51-de1c-40e2-b8e4-d699dbc2095a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 63</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 63\">\n            </li>\n        ",
    /* string$535 */ "64",
    /* string$536 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>64</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$537 */ "Something to do 64",
    /* string$538 */ "e6384826-d648-4ac9-9ea3-ac1deaf49001",
    /* string$539 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n            <li  data-id=\"5170b656-4e5c-45cb-be5d-8df42333dc87\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 50</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 50\">\n            </li>\n            <li  data-id=\"c5dea0e7-240e-4877-992d-9affc77a260e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 51</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 51\">\n            </li>\n            <li  data-id=\"d39dedca-1b74-4c72-8afe-16de5ae9fe03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 52</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 52\">\n            </li>\n            <li  data-id=\"2448d193-d323-4ba5-8af8-f28f10f28724\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 53</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 53\">\n            </li>\n            <li  data-id=\"5fb28e93-9429-4060-9f58-834090f36de1\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 54</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 54\">\n            </li>\n            <li  data-id=\"7b18bcf3-7366-466f-b4fb-8ec3c053b148\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 55</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 55\">\n            </li>\n            <li  data-id=\"a76b891f-719e-4be5-a321-906acd4c732d\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 56</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 56\">\n            </li>\n            <li  data-id=\"be5ef175-72df-476a-a581-16ca990d0feb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 57</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 57\">\n            </li>\n            <li  data-id=\"6427257e-7cdf-411b-930c-e5ca702034c9\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 58</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 58\">\n            </li>\n            <li  data-id=\"2a8371b5-d2c0-4105-86f8-94d8a390c884\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 59</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 59\">\n            </li>\n            <li  data-id=\"2ed14749-e3f6-415f-860d-93db9b97ce03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 60</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 60\">\n            </li>\n            <li  data-id=\"ab175a2c-60fd-4979-af3c-5f63deae70a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 61</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 61\">\n            </li>\n            <li  data-id=\"2f931481-78b0-4180-862b-a6890dbf18e9\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 62</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 62\">\n            </li>\n            <li  data-id=\"9ffa2f51-de1c-40e2-b8e4-d699dbc2095a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 63</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 63\">\n            </li>\n            <li  data-id=\"e6384826-d648-4ac9-9ea3-ac1deaf49001\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 64</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 64\">\n            </li>\n        ",
    /* string$540 */ "65",
    /* string$541 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>65</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$542 */ "Something to do 65",
    /* string$543 */ "a94279c4-e619-43cf-8ff8-22f4d4cbf93b",
    /* string$544 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n            <li  data-id=\"5170b656-4e5c-45cb-be5d-8df42333dc87\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 50</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 50\">\n            </li>\n            <li  data-id=\"c5dea0e7-240e-4877-992d-9affc77a260e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 51</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 51\">\n            </li>\n            <li  data-id=\"d39dedca-1b74-4c72-8afe-16de5ae9fe03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 52</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 52\">\n            </li>\n            <li  data-id=\"2448d193-d323-4ba5-8af8-f28f10f28724\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 53</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 53\">\n            </li>\n            <li  data-id=\"5fb28e93-9429-4060-9f58-834090f36de1\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 54</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 54\">\n            </li>\n            <li  data-id=\"7b18bcf3-7366-466f-b4fb-8ec3c053b148\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 55</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 55\">\n            </li>\n            <li  data-id=\"a76b891f-719e-4be5-a321-906acd4c732d\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 56</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 56\">\n            </li>\n            <li  data-id=\"be5ef175-72df-476a-a581-16ca990d0feb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 57</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 57\">\n            </li>\n            <li  data-id=\"6427257e-7cdf-411b-930c-e5ca702034c9\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 58</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 58\">\n            </li>\n            <li  data-id=\"2a8371b5-d2c0-4105-86f8-94d8a390c884\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 59</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 59\">\n            </li>\n            <li  data-id=\"2ed14749-e3f6-415f-860d-93db9b97ce03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 60</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 60\">\n            </li>\n            <li  data-id=\"ab175a2c-60fd-4979-af3c-5f63deae70a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 61</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 61\">\n            </li>\n            <li  data-id=\"2f931481-78b0-4180-862b-a6890dbf18e9\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 62</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 62\">\n            </li>\n            <li  data-id=\"9ffa2f51-de1c-40e2-b8e4-d699dbc2095a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 63</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 63\">\n            </li>\n            <li  data-id=\"e6384826-d648-4ac9-9ea3-ac1deaf49001\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 64</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 64\">\n            </li>\n            <li  data-id=\"a94279c4-e619-43cf-8ff8-22f4d4cbf93b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 65</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 65\">\n            </li>\n        ",
    /* string$545 */ "66",
    /* string$546 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>66</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$547 */ "Something to do 66",
    /* string$548 */ "4d0ea590-ddc3-4934-afcc-324d3fa8a920",
    /* string$549 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 21</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 21\">\n            </li>\n            <li  data-id=\"510fddfe-7b7a-4df0-b0ad-90f2a6311d72\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 22</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 22\">\n            </li>\n            <li  data-id=\"039952d3-3314-469c-bfe2-5f1f87853ed5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 23</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 23\">\n            </li>\n            <li  data-id=\"70417806-a92d-4c33-8454-b07ae4196b18\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 24</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 24\">\n            </li>\n            <li  data-id=\"ed9fe5b5-cfd7-4236-991b-280d18a4381e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 25</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 25\">\n            </li>\n            <li  data-id=\"d0552c21-204a-4fd7-8cf4-c0d11cdd301a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 26</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 26\">\n            </li>\n            <li  data-id=\"fb181d90-a7ae-400a-b192-6c2e9e8969d3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 27</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 27\">\n            </li>\n            <li  data-id=\"80923452-cb65-4312-874b-b188cd55f3ae\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 28</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 28\">\n            </li>\n            <li  data-id=\"89d53a53-481b-4915-9b5f-521c3dee773f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 29</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 29\">\n            </li>\n            <li  data-id=\"1c18cc01-d1ec-4342-921f-30b1722a925c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 30</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 30\">\n            </li>\n            <li  data-id=\"a27a1ffc-5f55-4ad5-b4de-4288ff029d96\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 31</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 31\">\n            </li>\n            <li  data-id=\"af6e38e6-0763-4284-a3ae-4e6393b933a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 32</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 32\">\n            </li>\n            <li  data-id=\"e17b9929-5508-466c-8659-0860cad1a6de\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 33</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 33\">\n            </li>\n            <li  data-id=\"e9e55080-4f0e-4729-aa2b-12c14ddeeb4b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 34</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 34\">\n            </li>\n            <li  data-id=\"226c9f3b-f15e-4fb8-b515-05b750df2b93\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 35</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 35\">\n            </li>\n            <li  data-id=\"28fc2d55-90e3-49fa-b7f5-80aa90c61f47\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 36</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 36\">\n            </li>\n            <li  data-id=\"0180c66b-e2f1-473f-89a8-3e139562bf26\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 37</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 37\">\n            </li>\n            <li  data-id=\"efcd234e-f533-4f92-92a5-68c1a9844356\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 38</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 38\">\n            </li>\n            <li  data-id=\"3ae470fd-ae1b-409f-a066-37386d9b2367\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 39</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 39\">\n            </li>\n            <li  data-id=\"6d1ec432-e55b-4812-b8f4-225b960c4506\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 40</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 40\">\n            </li>\n            <li  data-id=\"24f5fea5-7686-419a-b38d-e80942381044\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 41</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 41\">\n            </li>\n            <li  data-id=\"5b2816c0-1bd5-4ae9-8d80-77323c9da0cb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 42</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 42\">\n            </li>\n            <li  data-id=\"e69d041c-38d0-418f-afa3-476dcebc955f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 43</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 43\">\n            </li>\n            <li  data-id=\"476ae928-dd4d-4edd-82fb-64feba5d43b3\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 44</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 44\">\n            </li>\n            <li  data-id=\"761c94bd-a5e0-4703-abb0-9cb0bb0cffd6\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 45</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 45\">\n            </li>\n            <li  data-id=\"762aaec2-06a1-4702-b39a-11e934ee6391\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 46</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 46\">\n            </li>\n            <li  data-id=\"9a891906-baad-410a-8187-11c95ff2678e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 47</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 47\">\n            </li>\n            <li  data-id=\"e15f1a81-5664-4204-8c34-189cd32b1216\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 48</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 48\">\n            </li>\n            <li  data-id=\"f54c2420-9a10-475b-bef1-29e0988df208\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 49</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 49\">\n            </li>\n            <li  data-id=\"5170b656-4e5c-45cb-be5d-8df42333dc87\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 50</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 50\">\n            </li>\n            <li  data-id=\"c5dea0e7-240e-4877-992d-9affc77a260e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 51</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 51\">\n            </li>\n            <li  data-id=\"d39dedca-1b74-4c72-8afe-16de5ae9fe03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 52</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 52\">\n            </li>\n            <li  data-id=\"2448d193-d323-4ba5-8af8-f28f10f28724\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 53</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 53\">\n            </li>\n            <li  data-id=\"5fb28e93-9429-4060-9f58-834090f36de1\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 54</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 54\">\n            </li>\n            <li  data-id=\"7b18bcf3-7366-466f-b4fb-8ec3c053b148\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 55</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 55\">\n            </li>\n            <li  data-id=\"a76b891f-719e-4be5-a321-906acd4c732d\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 56</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 56\">\n            </li>\n            <li  data-id=\"be5ef175-72df-476a-a581-16ca990d0feb\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 57</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 57\">\n            </li>\n            <li  data-id=\"6427257e-7cdf-411b-930c-e5ca702034c9\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 58</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 58\">\n            </li>\n            <li  data-id=\"2a8371b5-d2c0-4105-86f8-94d8a390c884\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 59</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 59\">\n            </li>\n            <li  data-id=\"2ed14749-e3f6-415f-860d-93db9b97ce03\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 60</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 60\">\n            </li>\n            <li  data-id=\"ab175a2c-60fd-4979-af3c-5f63deae70a7\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 61</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 61\">\n            </li>\n            <li  data-id=\"2f931481-78b0-4180-862b-a6890dbf18e9\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 62</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 62\">\n            </li>\n            <li  data-id=\"9ffa2f51-de1c-40e2-b8e4-d699dbc2095a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 63</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 63\">\n            </li>\n            <li  data-id=\"e6384826-d648-4ac9-9ea3-ac1deaf49001\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 64</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 64\">\n            </li>\n            <li  data-id=\"a94279c4-e619-43cf-8ff8-22f4d4cbf93b\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 65</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 65\">\n            </li>\n            <li  data-id=\"4d0ea590-ddc3-4934-afcc-324d3fa8a920\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 66</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 66\">\n            </li>\n        ",
    /* string$550 */ "67",
    /* string$551 */ "\n            <span id=\"todo-count\" class=\"todo-count\"><strong>67</strong> items left</span>\n            <ul id=\"filters\" class=\"filters\">\n                <li>\n                    <a class=\"selected\" href=\"#/all\">All</a>\n                </li>\n                <li>\n                    <a href=\"#/active\">Active</a>\n                </li>\n                <li>\n                    <a href=\"#/completed\">Completed</a>\n                </li>\n            </ul>\n            \n        ",
    /* string$552 */ "Something to do 67",
    /* string$553 */ "bd5cda00-d4d3-407a-80fb-d54f52175281",
    /* string$554 */ "\n            <li  data-id=\"dab6d3d6-5f12-4668-9142-871745498fde\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 0</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 0\">\n            </li>\n            <li  data-id=\"63704342-720c-4685-895e-e6fac1f383ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 1</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 1\">\n            </li>\n            <li  data-id=\"35e341dd-85f4-4d01-9a01-40b331c7132a\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 2</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 2\">\n            </li>\n            <li  data-id=\"a0c3be4e-ca2c-4735-b3f1-fad50f1e8b74\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 3</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 3\">\n            </li>\n            <li  data-id=\"2b263105-8cbe-4f8a-a195-d2eddd49ab6e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 4</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 4\">\n            </li>\n            <li  data-id=\"d79efb5f-4476-4138-8a1e-16a7b0b85cb8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 5</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 5\">\n            </li>\n            <li  data-id=\"c60668e2-31ac-4ffa-9451-b0cd213cfe0f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 6</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 6\">\n            </li>\n            <li  data-id=\"64351b5e-b59f-4f02-beb8-a948f91d6a7c\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 7</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 7\">\n            </li>\n            <li  data-id=\"eefef126-628a-43dd-9365-abd05b2bb8bf\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 8</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 8\">\n            </li>\n            <li  data-id=\"2c76c9d1-5352-4316-a2d0-409b0c8c81ef\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 9</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 9\">\n            </li>\n            <li  data-id=\"a4a532e4-99bd-42dd-918f-6cfe273bb3c4\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 10</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 10\">\n            </li>\n            <li  data-id=\"bd44b3b4-87b5-4660-80f5-aa5e26c7573e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 11</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 11\">\n            </li>\n            <li  data-id=\"60275786-c394-4953-b416-7c443c8ba235\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 12</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 12\">\n            </li>\n            <li  data-id=\"09a53c42-a386-4f95-8116-6c0a3c322de8\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 13</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 13\">\n            </li>\n            <li  data-id=\"3466274f-7ab8-4455-89ef-de6ccb3a1251\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 14</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 14\">\n            </li>\n            <li  data-id=\"562c5ac1-565f-4af8-b97c-98711ea3d666\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 15</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 15\">\n            </li>\n            <li  data-id=\"27c44961-be75-4b83-b529-d76224860d3f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 16</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 16\">\n            </li>\n            <li  data-id=\"94c80434-b8b7-435d-a7c5-da68c963e92f\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 17</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 17\">\n            </li>\n            <li  data-id=\"7e6f3a13-7718-4444-8021-4b816424450e\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 18</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 18\">\n            </li>\n            <li  data-id=\"5b8aae1b-dba6-48a4-becd-9236ba73cd12\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 19</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 19\">\n            </li>\n            <li  data-id=\"190bc3f2-b555-4e33-9fff-f8950b7fe4e5\">\n                <div class=\"view\">\n                    <input class=\"toggle\" type=\"checkbox\" >\n                    <label>Something to do 20</label>\n                    <button class=\"destroy\"></button>\n                </div>\n                <input class=\"edit\" value=\"Something to do 20\">\n            </li>\n            <li  data-id=\"f08840c2-02fd-4b8f-9665-7630daf4ff17\">\n                <div class=\"view\">\n          