// Copyright 2017, the V8 project authors. All rights reserved.
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
//     * Neither the name of Google Inc. nor the names of its
//       contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Generated by tools/bigint-tester.py.

var data = [{
  a: 0x1a5f667aa2bb7882009be6149d43bd3af6fd7f9a695facef1dd3ac378f4b7n,
  b: 0x8n,
  r: 0x1a5f667aa2bb7882009be6149d43bd3af6fd7f9a695facef1dd3ac378f4b700n
}, {
  a: 0x9b2007fan,
  b: 0n,
  r: 0x9b2007fan
}, {
  a: 0xb13ec97d9985bfac6380b96b4dbfb0213851675090862cn,
  b: 0n,
  r: 0xb13ec97d9985bfac6380b96b4dbfb0213851675090862cn
}, {
  a: 0x422f02d7068525b282bad6e393461c2e02de359c9b44159027d8f60ecn,
  b: 0xbn,
  r: 0x2117816b834292d9415d6b71c9a30e17016f1ace4da20ac813ec7b076000n
}, {
  a: -0x627e3f59bd591aa46b19d507fb065871c3780n,
  b: 0x40n,
  r: -0x627e3f59bd591aa46b19d507fb065871c37800000000000000000n
}, {
  a: 0x5720b0e3c8b141e2f9dn,
  b: -0xfn,
  r: 0xae4161c7916283cn
}, {
  a: 0x38c53n,
  b: -0x91en,
  r: 0n
}, {
  a: -0xb438831f3b5f646e825c3eefdd13ac145a95f28e9b94abd5004bfaf0cd0c76f10abn,
  b: 0x1n,
  r: -0x16871063e76bec8dd04b87ddfba275828b52be51d372957aa0097f5e19a18ede2156n
}, {
  a: 0xa62360ded1e7772e5865c4n,
  b: 0n,
  r: 0xa62360ded1e7772e5865c4n
}, {
  a: -0x64fbb337n,
  b: -0x9bn,
  r: -0x1n
}, {
  a: -0xf7ea84498f74n,
  b: -0xbn,
  r: -0x1efd508932n
}, {
  a: 0x6eb570ced45c2920f0c421260e9c3e936d501202d954n,
  b: -0x1fn,
  r: 0xdd6ae19da8b85241e188424c1d387d26daa0n
}, {
  a: 0x51023b9e2e7d767950cb1b46n,
  b: -0xdn,
  r: 0x28811dcf173ebb3ca8658n
}, {
  a: -0x7ef2b90f081d59a84587f92e94ab8fe7b124b2fn,
  b: -0x68n,
  r: -0x7ef2b90f081d6n
}, {
  a: 0xd18540f68e966202b8ed4357e82ccff4n,
  b: 0x8an,
  r: 0x3461503da3a59880ae3b50d5fa0b33fd00000000000000000000000000000000000n
}, {
  a: -0xca2a1e8ada749df11aef2f22f1b10e473e18154a7510bcn,
  b: 0x7bn,
  r: -0x65150f456d3a4ef88d77979178d887239f0c0aa53a885e0000000000000000000000000000000n
}, {
  a: -0xc5a069f7b0f918ec65af78d96ff6ec958673d419n,
  b: 0xccn,
  r: -0xc5a069f7b0f918ec65af78d96ff6ec958673d419000000000000000000000000000000000000000000000000000n
}, {
  a: 0xf08ff2c809a2326f8159b01475e5bdcce688n,
  b: 0x19n,
  r: 0x1e11fe590134464df02b36028ebcb7b99cd10000000n
}, {
  a: -0x89aafc5a23df976ccb7913c62e719d39c694cfb075293ea00bn,
  b: 0x93n,
  r: -0x44d57e2d11efcbb665bc89e31738ce9ce34a67d83a949f50058000000000000000000000000000000000000n
}, {
  a: -0x208f2b184cffn,
  b: 0x34n,
  r: -0x208f2b184cff0000000000000n
}, {
  a: 0xfd76e67a33001b9a7649f4db4a2860011a1cd55407e60e78e5f0d8bn,
  b: 0n,
  r: 0xfd76e67a33001b9a7649f4db4a2860011a1cd55407e60e78e5f0d8bn
}, {
  a: 0x75118a2e0d07191340e87bab0a1302756708can,
  b: 0x19n,
  r: 0xea23145c1a0e322681d0f756142604eace1194000000n
}, {
  a: -0x59acb919350ebb303n,
  b: 0xd2n,
  r: -0x166b2e464d43aecc0c0000000000000000000000000000000000000000000000000000n
}, {
  a: 0xc1120ba43b06cf04845edb44d00454cfc4f8e3ba7daa4n,
  b: 0n,
  r: 0xc1120ba43b06cf04845edb44d00454cfc4f8e3ba7daa4n
}, {
  a: -0x8a39026b6af137bd3fb21eac87316b7156242164033465c3b5145597d0645n,
  b: 0xen,
  r: -0x228e409adabc4def4fec87ab21cc5adc5589085900cd1970ed451565f41914000n
}, {
  a: 0xea7bn,
  b: 0xc7n,
  r: 0x753d80000000000000000000000000000000000000000000000000n
}, {
  a: -0x59dee1f92632446b964efa9aea19n,
  b: -0x8n,
  r: -0x59dee1f92632446b964efa9aebn
}, {
  a: 0x9e32aa490035d06c94fe3a56b388ad9ba49f3e31b4f6f5dbcd960f0f57n,
  b: -0xa6n,
  r: 0x278caa92400d741b2n
}, {
  a: -0x116f27551n,
  b: -0x128n,
  r: -0x1n
}, {
  a: 0x66204eed0758490aa8912fb01888331043c2ab1d50a0c694n,
  b: 0n,
  r: 0x66204eed0758490aa8912fb01888331043c2ab1d50a0c694n
}, {
  a: 0x28c4fe61372c7a26ea9cb46b3475ce8ab626303aaca5315c790ab1cda39n,
  b: 0x9n,
  r: 0x5189fcc26e58f44dd53968d668eb9d156c4c6075594a62b8f215639b47200n
}, {
  a: 0xfbd4ee0e5d8f5be70a40336n,
  b: 0x9dn,
  r: 0x1f7a9dc1cbb1eb7ce148066c000000000000000000000000000000000000000n
}, {
  a: -0x82fc5c1638264521aff2bc0n,
  b: -0x8n,
  r: -0x82fc5c1638264521aff2cn
}, {
  a: -0xb87990942ad09bae26e18n,
  b: -0xc24n,
  r: -0x1n
}, {
  a: -0xb235808e2611adb5872195483bc36f693c603a264446b25n,
  b: -0x89n,
  r: -0x591ac0471308en
}, {
  a: -0x3c6e384609ccd61b44n,
  b: 0x94n,
  r: -0x3c6e384609ccd61b440000000000000000000000000000000000000n
}, {
  a: -0x3e3b086526c8f6b19f995ed7909c501fe0324cd775fde0n,
  b: 0n,
  r: -0x3e3b086526c8f6b19f995ed7909c501fe0324cd775fde0n
}, {
  a: 0xc53397f8517f55fdaf358f46de60517daaa6e35dn,
  b: 0x8dn,
  r: 0x18a672ff0a2feabfb5e6b1e8dbcc0a2fb554dc6ba00000000000000000000000000000000000n
}, {
  a: -0xe4f1ec05d11115fd0d4984656n,
  b: 0xf4n,
  r: -0xe4f1ec05d11115fd0d49846560000000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0x1288fe2n,
  b: 0x1fn,
  r: 0x9447f100000000n
}, {
  a: 0xd615b34231b52494c7f1f1an,
  b: 0xe2n,
  r: 0x35856cd08c6d492531fc7c6800000000000000000000000000000000000000000000000000000000n
}, {
  a: -0x51b4a456a81dfc70aacbec2d93ae7378n,
  b: -0x1bn,
  r: -0xa36948ad503bf8e15597d85b3n
}, {
  a: -0xcc9275f15db3n,
  b: -0xff3n,
  r: -0x1n
}, {
  a: -0x81c4f1ed13d4a5b4dan,
  b: -0x2n,
  r: -0x20713c7b44f5296d37n
}, {
  a: -0xb443a585d4c99ecff628e8c250e2fcacec0ecdf64175f970680af338c7946a2c711n,
  b: 0x9n,
  r: -0x168874b0ba9933d9fec51d184a1c5f959d81d9bec82ebf2e0d015e6718f28d458e2200n
}, {
  a: -0x5a9n,
  b: 0x4cn,
  r: -0x5a90000000000000000000n
}, {
  a: -0x34n,
  b: -0x4n,
  r: -0x4n
}, {
  a: -0x1b4201707fce664ba3e2f933fe4f084fad92b35ffae9db472c2ef6009f3986aee8n,
  b: -0xdfn,
  r: -0x368402e100n
}, {
  a: -0xb7fb21b437af9b0b5134163396ae601da63c5cfaa2548d14c7n,
  b: 0x60n,
  r: -0xb7fb21b437af9b0b5134163396ae601da63c5cfaa2548d14c7000000000000000000000000n
}, {
  a: -0x7f7205e9768041de8744971a702d419bace58n,
  b: 0n,
  r: -0x7f7205e9768041de8744971a702d419bace58n
}, {
  a: 0xd833a26ad24fdd6bfc878b6fa66397ceb1442f01663b7cb24867fn,
  b: -0x1n,
  r: 0x6c19d1356927eeb5fe43c5b7d331cbe758a21780b31dbe592433fn
}, {
  a: -0xd693abac241de5ffcn,
  b: 0xden,
  r: -0x35a4eaeb0907797ff00000000000000000000000000000000000000000000000000000000n
}, {
  a: 0xdc4bd1782c380047cecf5d1be9a6dbaf88a680072e4d2e40410f27d087927a63fcn,
  b: 0n,
  r: 0xdc4bd1782c380047cecf5d1be9a6dbaf88a680072e4d2e40410f27d087927a63fcn
}, {
  a: 0x4b1dbf0b84d1255fe61a33fd02a4029n,
  b: -0xc5n,
  r: 0n
}, {
  a: -0x6515031a21a1dcdbee2349d329a7d5a0250b10afaab4d4028caee13b6af9753f6n,
  b: 0x2n,
  r: -0x194540c688687736fb88d274ca69f5680942c42beaad3500a32bb84edabe5d4fd8n
}, {
  a: 0x4e29dn,
  b: -0x1c5n,
  r: 0n
}, {
  a: -0xbc57855172d7b0a945e63de5280396abee81e4402ef225c47994fn,
  b: 0xc0n,
  r: -0xbc57855172d7b0a945e63de5280396abee81e4402ef225c47994f000000000000000000000000000000000000000000000000n
}, {
  a: 0x7b50706083d914ef5dad2507188e9255011a60f2de0ddf9eee4c10b18398n,
  b: 0x8n,
  r: 0x7b50706083d914ef5dad2507188e9255011a60f2de0ddf9eee4c10b1839800n
}, {
  a: 0x94f6add2e8ff24564f3f9c9828411de17aa08a08d04af1e1f6f7dfn,
  b: -0xe6n,
  r: 0n
}, {
  a: -0x9157ad885a8914cf21dbn,
  b: -0x9n,
  r: -0x48abd6c42d448a6791n
}, {
  a: 0x3b9c700a817a7cf34e1727e1dn,
  b: -0x8n,
  r: 0x3b9c700a817a7cf34e1727en
}, {
  a: -0xaf1b3318cd2cf7d393a777n,
  b: -0xeefn,
  r: -0x1n
}, {
  a: -0xc516ee5144n,
  b: -0xb0fn,
  r: -0x1n
}, {
  a: -0x3n,
  b: 0xafn,
  r: -0x180000000000000000000000000000000000000000000n
}, {
  a: -0xac6dfcb4c3ded81f28df52fe9f410a4cc6n,
  b: 0xb7n,
  r: -0x5636fe5a61ef6c0f946fa97f4fa08526630000000000000000000000000000000000000000000000n
}, {
  a: 0x7884ff26596520e5dc4c2cc15b41f540cdfa15cabf461218cc58382fc56f29964d25bn,
  b: 0n,
  r: 0x7884ff26596520e5dc4c2cc15b41f540cdfa15cabf461218cc58382fc56f29964d25bn
}, {
  a: 0xab78bb40ceeee325dn,
  b: -0x2fen,
  r: 0n
}, {
  a: 0xee70a8165c1eb9366664a6b5a170a2fabab0648e6b130ad8ba5b641n,
  b: 0n,
  r: 0xee70a8165c1eb9366664a6b5a170a2fabab0648e6b130ad8ba5b641n
}, {
  a: -0x5edff80e44360c62ce5ee9bdb9dc68500b9275adaa55cn,
  b: 0xe3n,
  r: -0x2f6ffc07221b0631672f74dedcee342805c93ad6d52ae000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0xffe5ed8f40n,
  b: 0x11n,
  r: 0x1ffcbdb1e800000n
}, {
  a: -0xd6a9642cfd9ddb0a91ca82n,
  b: 0n,
  r: -0xd6a9642cfd9ddb0a91ca82n
}, {
  a: -0xedc670f7ccea81b64fd95258fdc541d3339b90611eb78eecd407a460c048n,
  b: 0xfn,
  r: -0x76e3387be67540db27eca92c7ee2a0e999cdc8308f5bc7766a03d23060240000n
}, {
  a: -0x7cbd8a8c191eddf34d115fb3dcfdn,
  b: 0xb9n,
  r: -0xf97b1518323dbbe69a22bf67b9fa0000000000000000000000000000000000000000000000n
}, {
  a: -0x71de4c027b5fc07a2f6360510dbdn,
  b: 0n,
  r: -0x71de4c027b5fc07a2f6360510dbdn
}, {
  a: -0xfa880e3158a1b19665ddefn,
  b: 0xf3n,
  r: -0x7d440718ac50d8cb32eef78000000000000000000000000000000000000000000000000000000000000n
}, {
  a: -0x75972410fef4292346c8e7313ea2dfc843c6520d91e697203168d369eb03b4e90n,
  b: 0x4n,
  r: -0x75972410fef4292346c8e7313ea2dfc843c6520d91e697203168d369eb03b4e900n
}, {
  a: -0xc6eb073f63119957284dec9191e01eebb5ac40dn,
  b: 0xf7n,
  r: -0x6375839fb188ccab9426f648c8f00f75dad620680000000000000000000000000000000000000000000000000000000000000n
}, {
  a: -0x4860e42c72bc251f974da59ee960ed5947977c0962ef2104c256107ba72453836en,
  b: 0x2n,
  r: -0x1218390b1caf0947e5d36967ba583b5651e5df0258bbc8413095841ee9c914e0db8n
}, {
  a: -0x9d6cf443d8b0d8ac7n,
  b: 0n,
  r: -0x9d6cf443d8b0d8ac7n
}, {
  a: 0xda0448504cddfbb9725d5c55ac1ba4d8b72c53bf1f1949a88844een,
  b: -0x82n,
  r: 0x3681121413377eee5c9757n
}, {
  a: -0x3d9e66724008f1ffa167n,
  b: 0n,
  r: -0x3d9e66724008f1ffa167n
}, {
  a: -0x399177dd81d21e946292bbn,
  b: 0n,
  r: -0x399177dd81d21e946292bbn
}, {
  a: -0x89e1b3ec9c5189e674c06c59939c02557d00ed20ed54e1f0816bbd4d6e74a4d96n,
  b: -0x4n,
  r: -0x89e1b3ec9c5189e674c06c59939c02557d00ed20ed54e1f0816bbd4d6e74a4dan
}, {
  a: -0xef08c0ad86b607ebd11990289fdf4efefb62en,
  b: -0x93an,
  r: -0x1n
}, {
  a: -0xaa2n,
  b: -0xe4n,
  r: -0x1n
}, {
  a: -0xae5ada06f21380591b67n,
  b: 0x53n,
  r: -0x572d6d037909c02c8db3800000000000000000000n
}, {
  a: 0xa75cc3f6e518edc1008324ed1cb05ffd737n,
  b: 0xd0n,
  r: 0xa75cc3f6e518edc1008324ed1cb05ffd7370000000000000000000000000000000000000000000000000000n
}, {
  a: 0x5934448fa68103b650f462cb21103441625b5576c4f7edd6644c099dn,
  b: 0x1n,
  r: 0xb268891f4d02076ca1e8c59642206882c4b6aaed89efdbacc898133an
}, {
  a: 0x7e01eb5df22c78c5fbaec8e4n,
  b: 0n,
  r: 0x7e01eb5df22c78c5fbaec8e4n
}, {
  a: -0x3fefabb29faaff8df92d3650f909eed71c47d4999ba90dc8f6a57f3an,
  b: -0xd7n,
  r: -0x80n
}, {
  a: 0x1cbb301d05bd85n,
  b: 0x6bn,
  r: 0xe5d980e82dec2800000000000000000000000000n
}, {
  a: -0xbb31416a0e7605319f90753d67d78faaddf27n,
  b: 0x96n,
  r: -0x2ecc505a839d814c67e41d4f59f5e3eab77c9c0000000000000000000000000000000000000n
}, {
  a: 0x55befn,
  b: -0x8dcn,
  r: 0n
}, {
  a: -0xe969aaf25e5e8747876708ff1d57d63e3a5d4d4f7fe947e4bn,
  b: -0x7n,
  r: -0x1d2d355e4bcbd0e8f0ece11fe3aafac7c74ba9a9effd28fdn
}, {
  a: 0xf7ef5324faf374e9a8edbe21b07326ebdf864179337ed8624d28fcn,
  b: 0x91n,
  r: 0x1efdea649f5e6e9d351db7c4360e64dd7bf0c82f266fdb0c49a51f8000000000000000000000000000000000000n
}, {
  a: 0x40d38de4d86281f63n,
  b: 0xbbn,
  r: 0x2069c6f26c3140fb180000000000000000000000000000000000000000000000n
}, {
  a: -0xfffe24b201958a4551n,
  b: -0xdn,
  r: -0x7fff125900cac53n
}, {
  a: 0x48b6ecd0e2743fa7b13db8a0b49544eec9eb846n,
  b: 0xa2n,
  r: 0x122dbb34389d0fe9ec4f6e282d25513bb27ae1180000000000000000000000000000000000000000n
}, {
  a: -0x6fd71c141de7445699833ba8e27bc11927a6ee6feen,
  b: -0xe7n,
  r: -0x1n
}, {
  a: -0xe19afe988d2b201c766483c92fn,
  b: 0x1an,
  r: -0x3866bfa6234ac8071d9920f24bc000000n
}, {
  a: -0xcb369c9c061e08f3cf398adbd917n,
  b: -0x93n,
  r: -0x1n
}, {
  a: 0xdcfbb539889cc4c126532cde1n,
  b: 0xd5n,
  r: 0x1b9f76a73113989824ca659bc200000000000000000000000000000000000000000000000000000n
}, {
  a: -0x5425d0c7b62e89beedd7f3e614755a61af7c1f4fdcd74ea14bfa2ba7aae06dd50n,
  b: 0x2n,
  r: -0x15097431ed8ba26fbb75fcf9851d56986bdf07d3f735d3a852fe8ae9eab81b7540n
}, {
  a: -0x3f0739bdd9fc0530587ee3f68063dba03cbdceb5n,
  b: -0x2n,
  r: -0xfc1ce6f767f014c161fb8fda018f6e80f2f73aen
}, {
  a: -0xcba68e2e5755d323cdcn,
  b: 0xb4n,
  r: -0xcba68e2e5755d323cdc000000000000000000000000000000000000000000000n
}, {
  a: 0x3de4bbc6cd1b0f7ce23dc088d72b4b20757bf789813bn,
  b: -0x5cn,
  r: 0x3de4bbc6cd1b0f7ce23dcn
}, {
  a: -0x7e566c32102c6855fa7b2n,
  b: 0x82n,
  r: -0x1f959b0c840b1a157e9ec800000000000000000000000000000000n
}, {
  a: -0x3453cc8a5d381e81ad42b2fc7f52b5072bf8d8b1fcfn,
  b: -0x8n,
  r: -0x3453cc8a5d381e81ad42b2fc7f52b5072bf8d8b20n
}, {
  a: 0xaf1193d6n,
  b: 0n,
  r: 0xaf1193d6n
}, {
  a: 0x8f2c7f3bc503266b4c302n,
  b: -0x23an,
  r: 0n
}, {
  a: -0xf7137534a5a82e9248b82e42a7fn,
  b: -0x7e9n,
  r: -0x1n
}, {
  a: 0xf40bfdc9a0d85ac07728fdf04c17e34aeef42c7n,
  b: 0x4en,
  r: 0x3d02ff72683616b01dca3f7c1305f8d2bbbd0b1c0000000000000000000n
}, {
  a: -0xf6ceceef5an,
  b: -0xe83n,
  r: -0x1n
}, {
  a: -0x4ebf3cefe6aec88n,
  b: 0x69n,
  r: -0x9d7e79dfcd5d91000000000000000000000000000n
}, {
  a: -0x2bbfea1e08fc05c77d70a20f150612e0n,
  b: 0x13n,
  r: -0x15dff50f047e02e3beb851078a83097000000n
}, {
  a: -0x59d775953513f7835469d39f0db12b9f5ba6db2c857be1b2cd4ca671fd5n,
  b: -0x7n,
  r: -0xb3aeeb2a6a27ef06a8d3a73e1b62573eb74db6590af7c3659a994ce40n
}, {
  a: -0x63f0d4ce568347ada31b11543105ff073010b7969e253n,
  b: 0xb1n,
  r: -0xc7e1a99cad068f5b463622a8620bfe0e60216f2d3c4a600000000000000000000000000000000000000000000n
}, {
  a: -0x8b48cbc6ca6ac3eaee0e74bde05e43508206f8d9590dn,
  b: 0x32n,
  r: -0x22d232f1b29ab0fabb839d2f781790d42081be3656434000000000000n
}, {
  a: -0x4a605f81b167fn,
  b: 0x95n,
  r: -0x94c0bf0362cfe0000000000000000000000000000000000000n
}, {
  a: -0x873c5d3d72518bfn,
  b: 0xa7n,
  r: -0x439e2e9eb928c5f800000000000000000000000000000000000000000n
}, {
  a: -0x792f95c1625cafn,
  b: 0x7cn,
  r: -0x792f95c1625caf0000000000000000000000000000000n
}, {
  a: -0x3a1fb5694n,
  b: 0x59n,
  r: -0x743f6ad280000000000000000000000n
}, {
  a: -0xb653926cc594f2420eb101cc0f781afad77136857d5c1690e5ff70edf4ce0f3e1n,
  b: 0x6n,
  r: -0x2d94e49b31653c9083ac407303de06beb5dc4da15f5705a4397fdc3b7d3383cf840n
}, {
  a: 0xb7ac1ea48c0497c80b5e6n,
  b: -0x30n,
  r: 0xb7ac1ea48n
}, {
  a: 0xcfbe988dfen,
  b: 0xb6n,
  r: 0x33efa6237f8000000000000000000000000000000000000000000000n
}, {
  a: -0xeb7bc50be04bec7f80d7cn,
  b: 0n,
  r: -0xeb7bc50be04bec7f80d7cn
}, {
  a: 0xa773f4fee2c0726e39ba7d2n,
  b: -0xdn,
  r: 0x53b9fa7f716039371cddn
}, {
  a: 0x8322f807728d948d4c7f91a50cf4abcde31f83771096c3a29n,
  b: 0x2dn,
  r: 0x10645f00ee51b291a98ff234a19e9579bc63f06ee212d8745200000000000n
}, {
  a: 0x982f61d47bbcf38f9deac1e317d4564n,
  b: -0xd3n,
  r: 0n
}, {
  a: 0x1f545f47e234d4an,
  b: 0n,
  r: 0x1f545f47e234d4an
}, {
  a: 0x186eb6e47a7ec6cb91b9a47114ad043fe140912545620fee87c6db4de42e0e383n,
  b: 0x8n,
  r: 0x186eb6e47a7ec6cb91b9a47114ad043fe140912545620fee87c6db4de42e0e38300n
}, {
  a: -0x80e98262434a8ad566761dd4f5082f1dd8c9844bea2c216c6696358538193348581f8n,
  b: -0x8b5n,
  r: -0x1n
}, {
  a: 0xc29d88e57a319a88c31e56n,
  b: -0xd79n,
  r: 0n
}, {
  a: -0x4839113dan,
  b: 0x9en,
  r: -0x120e444f68000000000000000000000000000000000000000n
}, {
  a: -0xfd00aefd3f10a14e8763cdfb0bd76a16cfaf538d94f31282bn,
  b: 0x24n,
  r: -0xfd00aefd3f10a14e8763cdfb0bd76a16cfaf538d94f31282b000000000n
}, {
  a: -0x2a3325cb0227f41a47d4af67223a13587d46d3570db66872aa014f761e0n,
  b: 0xan,
  r: -0xa8cc972c089fd0691f52bd9c88e84d61f51b4d5c36d9a1caa8053dd878000n
}, {
  a: 0x5bce7fd74133e066445e77fen,
  b: 0xdcn,
  r: 0x5bce7fd74133e066445e77fe0000000000000000000000000000000000000000000000000000000n
}, {
  a: 0x62f05c15787aebd4cb89a834a73n,
  b: 0xf4n,
  r: 0x62f05c15787aebd4cb89a834a730000000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0xcc69ead91fc76831d22608742fe683cc6c90129fa9ed91fbf5f94n,
  b: 0x63n,
  r: 0x6634f56c8fe3b418e913043a17f341e63648094fd4f6c8fdfafca0000000000000000000000000n
}, {
  a: 0x258c2ba7e212a3fce71bad96d52de7n,
  b: 0x43n,
  r: 0x12c615d3f10951fe738dd6cb6a96f380000000000000000n
}, {
  a: 0x709febf515e83a8ff1d44bf6b14a1463fbf268c4f7e3an,
  b: 0n,
  r: 0x709febf515e83a8ff1d44bf6b14a1463fbf268c4f7e3an
}, {
  a: -0xbd40d14df8dea703b7de1146bn,
  b: 0n,
  r: -0xbd40d14df8dea703b7de1146bn
}, {
  a: 0xff0b69b3e531311da74cc8n,
  b: -0x4a9n,
  r: 0n
}, {
  a: 0x431b1bcf5ad6dc863d1e98851c780a4ab841039fda26fd6f1487010n,
  b: 0n,
  r: 0x431b1bcf5ad6dc863d1e98851c780a4ab841039fda26fd6f1487010n
}, {
  a: -0x9da04564173bd2774a05d238500f7ab574bb6c4280422d7129670723cf081f5b840f1n,
  b: 0xfn,
  r: -0x4ed022b20b9de93ba502e91c2807bd5aba5db621402116b894b38391e7840fadc20788000n
}, {
  a: 0x3b1bfa243b48d629f536e209f407fc4cd625c19bc5940n,
  b: 0x64n,
  r: 0x3b1bfa243b48d629f536e209f407fc4cd625c19bc59400000000000000000000000000n
}, {
  a: 0x81f36de112e1n,
  b: 0xb3n,
  r: 0x40f9b6f08970800000000000000000000000000000000000000000000n
}, {
  a: 0x31909n,
  b: 0xddn,
  r: 0x632120000000000000000000000000000000000000000000000000000000n
}, {
  a: 0x748961e10278fb34c9c6e7332866a402bn,
  b: 0x67n,
  r: 0x3a44b0f0813c7d9a64e3739994335201580000000000000000000000000n
}, {
  a: 0x30db86bcdf4338ce8cacn,
  b: 0n,
  r: 0x30db86bcdf4338ce8cacn
}, {
  a: 0x92e5ac8234cf0bec2962d74e988107e2e45294n,
  b: 0x6fn,
  r: 0x4972d6411a6785f614b16ba74c4083f172294a0000000000000000000000000000n
}, {
  a: 0xbd263d51f01a6bced125289dd4n,
  b: -0x756n,
  r: 0n
}, {
  a: 0x113e8d442cea44c1b6cc983b2c9e4b2dddda0f19e1ff32d0a674d56020n,
  b: 0n,
  r: 0x113e8d442cea44c1b6cc983b2c9e4b2dddda0f19e1ff32d0a674d56020n
}, {
  a: -0xfe27776605700dfbcdb97aacb485e3b24cf4fa076an,
  b: 0x63n,
  r: -0x7f13bbb302b806fde6dcbd565a42f1d9267a7d03b50000000000000000000000000n
}, {
  a: 0x12831aea05n,
  b: 0n,
  r: 0x12831aea05n
}, {
  a: -0x5b2f3c3en,
  b: 0x8bn,
  r: -0x2d979e1f00000000000000000000000000000000000n
}, {
  a: 0x66459c065d3cn,
  b: -0x35n,
  r: 0n
}, {
  a: 0x644319659af198n,
  b: -0x4bn,
  r: 0n
}, {
  a: -0x6n,
  b: -0x9n,
  r: -0x1n
}, {
  a: -0x110ec27df46a0f0d2n,
  b: -0xan,
  r: -0x443b09f7d1a83dn
}, {
  a: 0x9ece5fc08addceccae3162d1fc68ee7f783879a41fb145cn,
  b: 0n,
  r: 0x9ece5fc08addceccae3162d1fc68ee7f783879a41fb145cn
}, {
  a: -0xfefbbfe9951bffa556n,
  b: 0xf1n,
  r: -0x1fdf77fd32a37ff4aac000000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0x76de084f1d800123fb50b9d76n,
  b: 0x64n,
  r: 0x76de084f1d800123fb50b9d760000000000000000000000000n
}, {
  a: -0x3fd2e0265399d9b786a8e130de0832bbfn,
  b: -0x8dn,
  r: -0x1n
}, {
  a: -0xacf91b56n,
  b: 0xa1n,
  r: -0x159f236ac0000000000000000000000000000000000000000n
}, {
  a: 0xfe89e1d5b1b142fac1a8c1ac57675a5d1672aaeb734ed4ca939f26ea2a6d06n,
  b: -0x1n,
  r: 0x7f44f0ead8d8a17d60d460d62bb3ad2e8b395575b9a76a6549cf9375153683n
}, {
  a: 0x4ac98a2e6926df12df7b7748n,
  b: 0x24n,
  r: 0x4ac98a2e6926df12df7b7748000000000n
}, {
  a: 0xc5dafab5806c9f21b36390f5a6591af312880an,
  b: -0xfn,
  r: 0x18bb5f56b00d93e4366c721eb4cb235e625n
}, {
  a: 0x5fd265a77c756a4ab062beaeed3df98966b09a39ac7ec1685552c1ef481fn,
  b: 0n,
  r: 0x5fd265a77c756a4ab062beaeed3df98966b09a39ac7ec1685552c1ef481fn
}, {
  a: -0x92fn,
  b: -0x38n,
  r: -0x1n
}, {
  a: 0x868f9be706923f5092c5b0af1n,
  b: 0n,
  r: 0x868f9be706923f5092c5b0af1n
}, {
  a: -0x9c88520410ae6dc60ba9c38239eebd5964e14n,
  b: -0xd4n,
  r: -0x1n
}, {
  a: -0x4ecae10b2c5f5f21835fe543b154a4ca647c1f8e22489115e097647a4708n,
  b: -0x23n,
  r: -0x9d95c21658bebe4306bfca8762a94994c8f83f1c4491222bc13n
}, {
  a: 0x4bae13fcd2dfeaba7ec6f6707e354153fbc18ef2b43b5373bc2a77ee0c5n,
  b: 0x4n,
  r: 0x4bae13fcd2dfeaba7ec6f6707e354153fbc18ef2b43b5373bc2a77ee0c50n
}, {
  a: 0xfe59ff1c88d08ad4fbcca0ec343eab4f2737cdbb2f75c4741bn,
  b: 0n,
  r: 0xfe59ff1c88d08ad4fbcca0ec343eab4f2737cdbb2f75c4741bn
}, {
  a: 0xa315ccf2d81e1339b83acfca38cca20f8b9f72f59329534d888a5d1an,
  b: 0xbn,
  r: 0x518ae6796c0f099cdc1d67e51c665107c5cfb97ac994a9a6c4452e8d000n
}, {
  a: -0x1ee2443150dc0eb20dc74fb7a967f30a1fbe8bba477d4fn,
  b: 0x2en,
  r: -0x7b8910c543703ac8371d3edea59fcc287efa2ee91df53c00000000000n
}, {
  a: 0x356501adban,
  b: 0x97n,
  r: 0x1ab280d6dd00000000000000000000000000000000000000n
}, {
  a: -0x51af4f0804c15cdde5cc7e390n,
  b: -0x8fn,
  r: -0x1n
}, {
  a: 0xc53078575940ab2163f4df2dc5f1ff24n,
  b: 0x1en,
  r: 0x314c1e15d6502ac858fd37cb717c7fc900000000n
}, {
  a: 0xd91451962809fe8a8b0e409150be1a8403bf831826n,
  b: -0x6dn,
  r: 0x6c8a28cb1404ff4n
}, {
  a: 0x24526fc4b789aeca74903f87d7688f32d3f2ca75e1bbd5715e24ce7ba7e34d6n,
  b: 0x7n,
  r: 0x122937e25bc4d7653a481fc3ebb4479969f9653af0ddeab8af12673dd3f1a6b00n
}, {
  a: 0n,
  b: -0x5bn,
  r: 0n
}, {
  a: 0x179f15ba4d4c4bb80a12773722a9ad094328cccaf952e502ab5d2ae620de88n,
  b: -0xfc0n,
  r: 0n
}, {
  a: -0xd76c7n,
  b: -0x1n,
  r: -0x6bb64n
}, {
  a: -0x9f5c76e553059dbc9b69d489c158b981cf9a9ed178c80fe52593n,
  b: 0x53n,
  r: -0x4fae3b72a982cede4db4ea44e0ac5cc0e7cd4f68bc6407f292c9800000000000000000000n
}, {
  a: 0x8beac068e91e70ca6fb7224abf02cn,
  b: 0x8bn,
  r: 0x45f56034748f386537db91255f81600000000000000000000000000000000000n
}, {
  a: -0x411995b038aaaff308c6b8c86339a25d357eda8688ae2beb022846aefcdn,
  b: -0xdn,
  r: -0x208ccad81c5557f984635c64319cd12e9abf6d43445715f581142358n
}, {
  a: 0x2fa1077c168a1b0522752f2c22an,
  b: 0x3en,
  r: 0xbe841df05a286c1489d4bcb08a8000000000000000n
}, {
  a: 0xa4bcff9915n,
  b: 0xe5n,
  r: 0x14979ff322a000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0x44cde3c998d4f4a2f2b62afe82f11869e32d4b2ffd5280ba237612a6n,
  b: 0xcn,
  r: 0x44cde3c998d4f4a2f2b62afe82f11869e32d4b2ffd5280ba237612a6000n
}, {
  a: 0x86668cn,
  b: 0xa3n,
  r: 0x43334600000000000000000000000000000000000000000n
}, {
  a: -0x3bd06158a9a09dba8519fd8a13a2e16de261b4d9197efec94e6f2ac31bf37ded192n,
  b: -0x66cn,
  r: -0x1n
}, {
  a: 0x52719766a1836c1a4cn,
  b: 0x51n,
  r: 0xa4e32ecd4306d8349800000000000000000000n
}, {
  a: -0xd7fbaa6e794c2b398n,
  b: 0n,
  r: -0xd7fbaa6e794c2b398n
}, {
  a: -0xb425a6cfde82d52f28d46458c11b75b09n,
  b: 0n,
  r: -0xb425a6cfde82d52f28d46458c11b75b09n
}, {
  a: -0x4a910374dbed51958c78a0b4ebcfd4eb0572e02f1b37252080f1a8ae6f1e5fbc8b3n,
  b: 0x3n,
  r: -0x254881ba6df6a8cac63c505a75e7ea7582b970178d9b92904078d457378f2fde4598n
}, {
  a: 0xbbb28e9ad817fn,
  b: -0x4e8n,
  r: 0n
}, {
  a: -0xf95d1e9241bdn,
  b: 0x3bn,
  r: -0x7cae8f4920de800000000000000n
}, {
  a: -0x292b979972d8cn,
  b: 0n,
  r: -0x292b979972d8cn
}, {
  a: -0x37a4b435db557491264n,
  b: -0xe6n,
  r: -0x1n
}, {
  a: -0xa4a54cdbb04a82372339744e202c618da1201f5n,
  b: -0x29n,
  r: -0x5252a66dd825411b919cba2710164n
}, {
  a: 0x78e5163619421n,
  b: 0n,
  r: 0x78e5163619421n
}, {
  a: -0xe7n,
  b: -0x7n,
  r: -0x2n
}, {
  a: -0x47da690bb6b6e42b7ec32e6185a08c2884e827n,
  b: 0x23n,
  r: -0x23ed3485db5b7215bf619730c2d04614427413800000000n
}, {
  a: 0x3499bb844b0712673f9b548a4faf594cfn,
  b: -0x3n,
  r: 0x69337708960e24ce7f36a9149f5eb299n
}, {
  a: 0xcabd64c9ef6519ccn,
  b: -0x2n,
  r: 0x32af59327bd94673n
}, {
  a: 0xcc15937207ee014c54bf3173bf6b7087a8b314f2b09b4ef3f2d573d44n,
  b: -0x341n,
  r: 0n
}, {
  a: 0xa99629b03fac28b0d3e3880a7e06e7f0a0866d45f3dcc4515dn,
  b: -0x33cn,
  r: 0n
}, {
  a: -0xd9e64b0429eb988373af08813b5b7855d57d36df42ada5ff6586892bd2ec191n,
  b: -0x2n,
  r: -0x367992c10a7ae620dcebc2204ed6de15755f4db7d0ab697fd961a24af4bb065n
}, {
  a: -0xdc68069949f69b29e213284c8b94e5dc6396e03n,
  b: -0xc5n,
  r: -0x1n
}, {
  a: -0x534d95deebf44ddbe4d697d51299a9d46e20c7c1a9e0d60d82d222af031ef38eafc5n,
  b: -0xea2n,
  r: -0x1n
}, {
  a: -0x8ab0426391f58e4cd8eae5f8b7ed13457b740bd3c5b73d1fdce4bd1021453e1e3d1n,
  b: 0x4n,
  r: -0x8ab0426391f58e4cd8eae5f8b7ed13457b740bd3c5b73d1fdce4bd1021453e1e3d10n
}, {
  a: 0xca35b16b1e20e477f2e83ed4bc6a2d10fa4516n,
  b: 0x52n,
  r: 0x328d6c5ac788391dfcba0fb52f1a8b443e9145800000000000000000000n
}, {
  a: -0xd65e0ead0f302733680fca1da6n,
  b: -0xe6n,
  r: -0x1n
}, {
  a: -0xb0476d50e00e79159d609bee83e3e1504599b67c712460fa3214fn,
  b: -0xa4n,
  r: -0xb0476d50e00fn
}, {
  a: -0x67cac718a4ef9863b10e8a025c7a81e9b412043b95920c577an,
  b: 0x3en,
  r: -0x19f2b1c6293be618ec43a280971ea07a6d04810ee5648315de8000000000000000n
}, {
  a: -0xf9ce241a37d87aac3dbd6e4c7639c9bfee7af4n,
  b: 0xe2n,
  r: -0x3e7389068df61eab0f6f5b931d8e726ffb9ebd000000000000000000000000000000000000000000000000000000000n
}, {
  a: -0x4ed82472a4cc41331710b222ab4f5120400n,
  b: 0x37n,
  r: -0x276c1239526620998b88591155a7a89020000000000000000n
}, {
  a: -0xad86c553f611ee58afb4bac0ccc01n,
  b: 0xe9n,
  r: -0x15b0d8aa7ec23dcb15f697581998020000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0x4215f68n,
  b: 0xf3n,
  r: 0x210afb40000000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0xd787e72a0093df8a659a650bfe3a09bc52ee238beaec5d846264309fbbe7e01f6a27fn,
  b: -0xef5n,
  r: 0n
}, {
  a: 0x5929fcd912d50b922685cc8d5226e842a26fn,
  b: 0x77n,
  r: 0x2c94fe6c896a85c91342e646a91374215137800000000000000000000000000000n
}, {
  a: 0xb16e53fb26d297c40c13c9n,
  b: 0x3fn,
  r: 0x58b729fd93694be20609e48000000000000000n
}, {
  a: -0x33693n,
  b: 0x4fn,
  r: -0x19b4980000000000000000000n
}, {
  a: -0x5d7381cfe8af12362d2dd8n,
  b: 0x69n,
  r: -0xbae7039fd15e246c5a5bb000000000000000000000000000n
}, {
  a: -0x327e2d38dce7dbe3ceceb64b38ec53d8e1b48b974eec0085n,
  b: 0n,
  r: -0x327e2d38dce7dbe3ceceb64b38ec53d8e1b48b974eec0085n
}, {
  a: -0x32n,
  b: -0xcaen,
  r: -0x1n
}, {
  a: -0xc4dd560bc6bn,
  b: 0x5en,
  r: -0x31375582f1ac00000000000000000000000n
}, {
  a: 0xc5c52c216n,
  b: 0n,
  r: 0xc5c52c216n
}, {
  a: 0x8b901n,
  b: -0xf8n,
  r: 0n
}, {
  a: -0x382e1f2fccn,
  b: -0xcn,
  r: -0x382e1f3n
}, {
  a: -0x5fb6bf6ee0972d705e3ff411f3e4fc16f867a58639e09a8e9ba01c36983c14n,
  b: 0x2n,
  r: -0x17edafdbb825cb5c178ffd047cf93f05be19e9618e7826a3a6e8070da60f050n
}, {
  a: 0x8c1c66a77aaf7c4028e40a8731f56e7189d3bc9n,
  b: 0x82n,
  r: 0x230719a9deabdf100a3902a1cc7d5b9c6274ef2400000000000000000000000000000000n
}, {
  a: -0x84839f192a6n,
  b: -0x1n,
  r: -0x4241cf8c953n
}, {
  a: -0xaa10336a7cd98992218c876d05d4a726b2d89b9127eb95d924n,
  b: -0x8n,
  r: -0xaa10336a7cd98992218c876d05d4a726b2d89b9127eb95dan
}, {
  a: 0x9f41a37a8ee8c4ce4840dd3eddeb85c1e8640264bf54dbca07n,
  b: 0x47n,
  r: 0x4fa0d1bd4774626724206e9f6ef5c2e0f43201325faa6de503800000000000000000n
}, {
  a: 0x252f63875b8eb2b8256f7ffeb888fc771a3b47001n,
  b: -0x125n,
  r: 0n
}, {
  a: 0xcd430089cf849aa535a146f2aa868c3n,
  b: -0x539n,
  r: 0n
}, {
  a: -0xe27aa75184dfb3ae2f2e6640092ace479bdf516c6d9a876f617n,
  b: 0x3an,
  r: -0x389ea9d46137eceb8bcb9990024ab391e6f7d45b1b66a1dbd85c00000000000000n
}, {
  a: 0x5b24af4b16763769842ce9d4e0de5d516d8a0ef6933def4n,
  b: 0x9an,
  r: 0x16c92bd2c59d8dda610b3a75383797545b6283bda4cf7bd000000000000000000000000000000000000000n
}, {
  a: 0n,
  b: -0x1a1n,
  r: 0n
}, {
  a: 0xa46e2a334f2c16f8928bd68850e5b52ad97fea78f27b688614724e12cefbn,
  b: -0x9n,
  r: 0x52371519a7960b7c4945eb442872da956cbff53c793db4430a39270967n
}, {
  a: -0x29ab8d8c8fd34d17b1ead7a8656450c39681340c0b35120bfc31f1f6cd0n,
  b: 0x7n,
  r: -0x14d5c6c647e9a68bd8f56bd432b22861cb409a06059a8905fe18f8fb66800n
}, {
  a: 0xfe61n,
  b: -0xfn,
  r: 0x1n
}, {
  a: 0xf0f150e9ac620c4a9e5240a4d3b8eb8778n,
  b: 0xf9n,
  r: 0x1e1e2a1d358c418953ca48149a771d70ef000000000000000000000000000000000000000000000000000000000000000n
}, {
  a: -0xfde05ea358ef93049c6d417160d02b5d5216a700491f1092d29885d8deen,
  b: 0x4n,
  r: -0xfde05ea358ef93049c6d417160d02b5d5216a700491f1092d29885d8dee0n
}, {
  a: -0xac8b210a1450527ba995n,
  b: -0xdb2n,
  r: -0x1n
}, {
  a: -0xfacbda940f4a64d414f2769216151da703c8ddc88a90d3b4fb08fdea1an,
  b: 0xan,
  r: -0x3eb2f6a503d29935053c9da485854769c0f2377222a434ed3ec23f7a86800n
}, {
  a: 0x1b6e7c5291dcbe97e1ee9b55d29c227n,
  b: -0xad4n,
  r: 0n
}, {
  a: 0xe8aa3efe6c0bebeb27ce847n,
  b: 0x52n,
  r: 0x3a2a8fbf9b02fafac9f3a11c00000000000000000000n
}, {
  a: 0xb4f1064fe58f8f2be60c54c15e19e2015fn,
  b: 0xc2n,
  r: 0x2d3c4193f963e3caf98315305786788057c000000000000000000000000000000000000000000000000n
}, {
  a: -0x97a30c6b32d4cfd5ab450b76dbca95fe27199a8ff4664797a3826b3671681dcen,
  b: 0x3n,
  r: -0x4bd18635996a67ead5a285bb6de54aff138ccd47fa3323cbd1c1359b38b40ee70n
}, {
  a: 0x36cc53a7069d26ea94926099b2a28b2b2ce91n,
  b: -0x66n,
  r: 0xdb314e9c1a7n
}, {
  a: 0x37d80c6254d28a705fdeb30752320b08dfc0d2a421fde6d6d728en,
  b: 0x38n,
  r: 0x37d80c6254d28a705fdeb30752320b08dfc0d2a421fde6d6d728e00000000000000n
}, {
  a: 0x4a2cc373b5n,
  b: -0x2n,
  r: 0x128b30dcedn
}, {
  a: 0xbed196d51514ce29873e668c6f2b872b4e768f8d99fd910n,
  b: -0x4en,
  r: 0x2fb465b54545338a61cf99a31bcan
}, {
  a: 0xba82ec66696b00cd4n,
  b: 0x82n,
  r: 0x2ea0bb199a5ac0335000000000000000000000000000000000n
}, {
  a: -0x2148d5b7ea6accn,
  b: -0x6n,
  r: -0x852356dfa9acn
}, {
  a: 0xf4a8a1f91a2a4d1cdf2a2d7f724a32202ffe922bf89n,
  b: -0x33n,
  r: 0x1e95143f234549a39be545afee49464n
}, {
  a: -0xb54fbc4d6322903b2005b32e40eeb5453f5104e28bbdbc3fec9b19c60a61en,
  b: 0x5n,
  r: -0x16a9f789ac6452076400b665c81dd6a8a7ea209c5177b787fd936338c14c3c0n
}, {
  a: -0x25f284a8e6665fd512f1n,
  b: 0n,
  r: -0x25f284a8e6665fd512f1n
}, {
  a: -0x7caf407n,
  b: -0x9n,
  r: -0x3e57bn
}, {
  a: 0x8514f75a4cn,
  b: -0x617n,
  r: 0n
}, {
  a: -0x40a5b27741bd5664c81623a4c0c30feffd308982aaf6c36c9bac4a42a8ed7ddd00en,
  b: -0x7an,
  r: -0x10296c9dd06f5599320588e93030c3fbff4c3n
}, {
  a: 0x547cbfb4c2840547cade9d16b96dff9330006e271782a8n,
  b: 0x4dn,
  r: 0xa8f97f6985080a8f95bd3a2d72dbff266000dc4e2f05500000000000000000000n
}, {
  a: 0x96abebn,
  b: -0x5n,
  r: 0x4b55fn
}, {
  a: 0xec8f2036d19bddb4e5211b69a9n,
  b: -0x44cn,
  r: 0n
}, {
  a: 0x61277f160072a49d140e96252dd778f3388e65847eaae2e210c94bae7758n,
  b: 0n,
  r: 0x61277f160072a49d140e96252dd778f3388e65847eaae2e210c94bae7758n
}, {
  a: 0x6153b47439n,
  b: 0x23n,
  r: 0x30a9da3a1c800000000n
}, {
  a: -0x4a61c515e23d1d5756c2c5295ef8e86fa325f0cdba7dcdn,
  b: 0x59n,
  r: -0x94c38a2bc47a3aaead858a52bdf1d0df464be19b74fb9a0000000000000000000000n
}, {
  a: -0x47c7941166cddd37e23980bc759898488e53efa27002638b734469b6affen,
  b: 0x7n,
  r: -0x23e3ca08b366ee9bf11cc05e3acc4c244729f7d1380131c5b9a234db57ff00n
}, {
  a: 0x15b2a14n,
  b: 0x35n,
  r: 0x2b654280000000000000n
}, {
  a: -0x3eef76982b7b3906a181c4dc70bc5238ffce580c63b837ab2403d09035b33en,
  b: 0x8n,
  r: -0x3eef76982b7b3906a181c4dc70bc5238ffce580c63b837ab2403d09035b33e00n
}, {
  a: 0x4aa521dd308126933dc2b0884d795cd35264ab4bd724bd7605006819823n,
  b: 0x9n,
  r: 0x954a43ba61024d267b8561109af2b9a6a4c95697ae497aec0a00d03304600n
}, {
  a: -0xfd3cf2714914en,
  b: -0xfn,
  r: -0x1fa79e4e2an
}, {
  a: 0x34102f047383d62be79046bd1f2ade7ec39bed2ed390eb56476e620eaec3266n,
  b: -0x40n,
  r: 0x34102f047383d62be79046bd1f2ade7ec39bed2ed390eb5n
}, {
  a: -0xbe343e4b8e93a61457f3406ba18baab27682450896c0a87013821n,
  b: -0x5n,
  r: -0x5f1a1f25c749d30a2bf9a035d0c5d5593b4122844b60543809c2n
}, {
  a: 0xb5c30497c5b47ae8a9322dn,
  b: 0x16n,
  r: 0x2d70c125f16d1eba2a4c8b400000n
}, {
  a: 0xfbe388c980af3a96e02n,
  b: 0n,
  r: 0xfbe388c980af3a96e02n
}, {
  a: 0xcdea0ffd50b559790193771a606c8bdb99ca50a3af58ef245d449ecc943650e82n,
  b: 0x6n,
  r: 0x337a83ff542d565e4064ddc6981b22f6e6729428ebd63bc9175127b3250d943a080n
}, {
  a: 0x9dadae25a18763a311091bcc820f4eba9b3a5b1cebe9ea71d3140n,
  b: 0x53n,
  r: 0x4ed6d712d0c3b1d188848de64107a75d4d9d2d8e75f4f538e98a0000000000000000000000n
}, {
  a: -0x731b754ceaaad7f2bebc4816bn,
  b: 0n,
  r: -0x731b754ceaaad7f2bebc4816bn
}, {
  a: -0xce26dc33b3f89a185988dafd5bebb1d1e736c08885cd56c183f5b5526cee3bb02a2n,
  b: -0xen,
  r: -0x3389b70cecfe2686166236bf56faec7479cdb022217355b060fd6d549b3b8eedn
}, {
  a: 0x48483e0a0ff59dbfefff820cd444d4f71a0f4598fd8a888bda2fe217a66202n,
  b: -0xcen,
  r: 0x12120f8283fn
}, {
  a: -0x6ce0e8ce73474f963f9f02be67346d56cde1e26f232d10e3ea4560f7n,
  b: -0x8n,
  r: -0x6ce0e8ce73474f963f9f02be67346d56cde1e26f232d10e3ea4561n
}, {
  a: -0x40b7bb8a0a30ff19be495c05ece3a10f9c7c739f9e7f4e8fan,
  b: -0x577n,
  r: -0x1n
}, {
  a: -0x4d89ed5f042n,
  b: 0n,
  r: -0x4d89ed5f042n
}, {
  a: 0x1beb8bf6479n,
  b: -0x27n,
  r: 0x3n
}, {
  a: -0x48e2436989831b2f3512bdd02n,
  b: -0x979n,
  r: -0x1n
}, {
  a: 0x721be42febc3e6316e0357f1d433be7066922c23d26ac92d472e2b3662088cn,
  b: -0x792n,
  r: 0n
}, {
  a: 0x4d826719b2ede6268323962bn,
  b: 0xc8n,
  r: 0x4d826719b2ede6268323962b00000000000000000000000000000000000000000000000000n
}, {
  a: 0n,
  b: 0xc3n,
  r: 0n
}, {
  a: 0x7945fc8fbab8c8972733436a940af6323d0fa7d8f03d680220bc0431n,
  b: -0x1n,
  r: 0x3ca2fe47dd5c644b9399a1b54a057b191e87d3ec781eb401105e0218n
}, {
  a: -0x33ee754c0bf1ab8fd992b5af521bn,
  b: -0x34n,
  r: -0x33ee754c0bf1ab9n
}, {
  a: 0xdf1d277696ecee84c26b6c2c9246c87665a97b1e5e6983d49cb96d19ab85e888c5fn,
  b: -0x6n,
  r: 0x37c749dda5bb3ba1309adb0b2491b21d996a5ec7979a60f5272e5b466ae17a2231n
}, {
  a: -0xe39bfb0eee5a17b9fab4fb8ban,
  b: 0n,
  r: -0xe39bfb0eee5a17b9fab4fb8ban
}, {
  a: 0x7502151b1196a23c8b8e36fdc628e9c9b8733d62e64a853db04d6bfacn,
  b: -0xc6n,
  r: 0x1d408546n
}, {
  a: 0x38b99ae707b5c5c9d6ba501af8afd7n,
  b: 0xb5n,
  r: 0x717335ce0f6b8b93ad74a035f15fae000000000000000000000000000000000000000000000n
}, {
  a: -0x23e802a895acn,
  b: 0x44n,
  r: -0x23e802a895ac00000000000000000n
}, {
  a: -0x4540eb5cc4464cf756afen,
  b: 0x67n,
  r: -0x22a075ae6223267bab57f00000000000000000000000000n
}, {
  a: -0x8d6d5da339bac6a598e5a2870a696ad7bdb8860440f6n,
  b: -0xb1n,
  r: -0x1n
}, {
  a: 0x641f618n,
  b: 0x90n,
  r: 0x641f618000000000000000000000000000000000000n
}, {
  a: -0xbf2a85ccc85671bb6bd43cca301a0f83ac889a1521056d8ffn,
  b: -0x3n,
  r: -0x17e550b9990ace376d7a8799460341f075911342a420adb20n
}, {
  a: -0x5e917fb22b7077n,
  b: -0xba3n,
  r: -0x1n
}, {
  a: -0x704d5dn,
  b: -0xbn,
  r: -0xe0an
}, {
  a: 0x3a2519e15aab433c55262f37152e3129d90cn,
  b: -0x7n,
  r: 0x744a33c2b5568678aa4c5e6e2a5c6253b2n
}, {
  a: 0xf2725aefdafd0bn,
  b: -0x9n,
  r: 0x79392d77ed7en
}, {
  a: -0x9e24ef46bfa47a529d5aec1d9010e18n,
  b: 0xean,
  r: -0x27893bd1afe91e94a756bb07640438600000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0x44b5d95d49ad2c744ee7e46af11n,
  b: 0n,
  r: 0x44b5d95d49ad2c744ee7e46af11n
}, {
  a: 0x179b928ca6178c35f9f86c426bfe4876b157786943926c4268b748193547623235fan,
  b: 0n,
  r: 0x179b928ca6178c35f9f86c426bfe4876b157786943926c4268b748193547623235fan
}, {
  a: 0x9a4bf2bb678f7d5796cn,
  b: -0xden,
  r: 0n
}, {
  a: -0x2d7156fd8228e036a81d096163b3cc6f6b12b439dd6079683440daee781e947n,
  b: -0xcan,
  r: -0xb5c55bf608a4n
}, {
  a: -0xb70113f27ab717a09b04ac68317b8208986a622fddc69f050e92n,
  b: -0xd5n,
  r: -0x1n
}, {
  a: 0xe379c0f85d4eb1acb8f6n,
  b: 0n,
  r: 0xe379c0f85d4eb1acb8f6n
}, {
  a: -0x771180bba964d111n,
  b: 0xc6n,
  r: -0x1dc4602eea59344440000000000000000000000000000000000000000000000000n
}, {
  a: -0x2629cfe7f3n,
  b: 0xb2n,
  r: -0x98a73f9fcc00000000000000000000000000000000000000000000n
}, {
  a: 0xb3fb39b4731151c21f59a0678cd51e24fdff923319n,
  b: 0x6cn,
  r: 0xb3fb39b4731151c21f59a0678cd51e24fdff923319000000000000000000000000000n
}, {
  a: -0xe5575eb1d3ba130fn,
  b: 0n,
  r: -0xe5575eb1d3ba130fn
}, {
  a: -0x4f58104c6b5bbfecd572154a99c17e701fc4n,
  b: -0x6n,
  r: -0x13d604131ad6effb355c8552a6705f9c080n
}, {
  a: -0xc8f7b42n,
  b: 0xa1n,
  r: -0x191ef6840000000000000000000000000000000000000000n
}, {
  a: 0xc266e320cn,
  b: 0n,
  r: 0xc266e320cn
}, {
  a: -0x7de8e6252dae086a7e6899ac3aa64288f0ffc4b2ae37e97aa40e75463cd0a65f1080n,
  b: 0x3n,
  r: -0x3ef4731296d704353f344cd61d532144787fe259571bf4bd52073aa31e68532f88400n
}, {
  a: -0x6fe78ec10224317ben,
  b: 0x77n,
  r: -0x37f3c760811218bdf000000000000000000000000000000n
}, {
  a: -0x72an,
  b: -0x2an,
  r: -0x1n
}, {
  a: 0x9n,
  b: 0xe6n,
  r: 0x24000000000000000000000000000000000000000000000000000000000n
}, {
  a: -0xbd213ea93322318c8459768c76fdan,
  b: 0x9bn,
  r: -0x5e909f54999118c6422cbb463b7ed000000000000000000000000000000000000000n
}, {
  a: 0xb4ad21d8e12baee74d237a366780f3ee4n,
  b: 0x49n,
  r: 0x1695a43b1c2575dce9a46f46ccf01e7dc8000000000000000000n
}, {
  a: -0xe7537a0d4506a9cfe2n,
  b: -0x9cn,
  r: -0x1n
}, {
  a: 0x8c9n,
  b: -0xd0fn,
  r: 0n
}, {
  a: -0xa769ca90efc7c8dn,
  b: -0xbcn,
  r: -0x1n
}, {
  a: 0x4c6be4e7a26b88en,
  b: 0x15n,
  r: 0x98d7c9cf44d711c00000n
}, {
  a: 0xc2f88db388c68de372c4n,
  b: 0x77n,
  r: 0x617c46d9c46346f1b962000000000000000000000000000000n
}, {
  a: 0x34c637037b7b4f74d3bb93f7d199b34ba2b9a405f6d27b13188b86cb51d4b1n,
  b: 0xfn,
  r: 0x1a631b81bdbda7ba69ddc9fbe8ccd9a5d15cd202fb693d898c45c365a8ea588000n
}, {
  a: -0x2015edc0c8811eb3bea77cn,
  b: 0x4dn,
  r: -0x402bdb8191023d677d4ef80000000000000000000n
}, {
  a: 0x7faa3637a045149bf7fde547b3a23n,
  b: 0xdfn,
  r: 0x3fd51b1bd0228a4dfbfef2a3d9d1180000000000000000000000000000000000000000000000000000000n
}, {
  a: 0xe53ce425973fd2f03940n,
  b: -0xbn,
  r: 0x1ca79c84b2e7fa5e07n
}, {
  a: 0x5906500c74474d3f64131a5e31045602b7n,
  b: -0x14n,
  r: 0x5906500c74474d3f64131a5e31045n
}, {
  a: -0xb3fe39d1041dfc314c87db9a5cdcd3234b3233d512f4474c822e4a372fe9d9n,
  b: 0x4n,
  r: -0xb3fe39d1041dfc314c87db9a5cdcd3234b3233d512f4474c822e4a372fe9d90n
}, {
  a: -0x28dc1a3a05bbbb3cdceb2d1n,
  b: -0x8n,
  r: -0x28dc1a3a05bbbb3cdceb3n
}, {
  a: -0x290a0635n,
  b: -0x5an,
  r: -0x1n
}, {
  a: 0xf7e92dc4db5c83d4ee5ac14241c50936747eeea1bde80cc3c9ab8ddn,
  b: 0x2n,
  r: 0x3dfa4b7136d720f53b96b0509071424d9d1fbba86f7a0330f26ae374n
}, {
  a: 0xa2e433df1a414ccf65364d5355782n,
  b: 0xa3n,
  r: 0x517219ef8d20a667b29b26a9aabc100000000000000000000000000000000000000000n
}, {
  a: 0x582cf3c6e217bf72f64bb652ffdd2f4d14de88a815785e6b43c44b32939292bcd4bn,
  b: -0x3n,
  r: 0xb059e78dc42f7ee5ec976ca5ffba5e9a29bd11502af0bcd68788966527252579a9n
}, {
  a: 0x7afc8d3901365f7b12650f30018f44e51001bb541cb16fn,
  b: -0xfn,
  r: 0xf5f91a72026cbef624ca1e60031e89ca200376a839n
}, {
  a: -0xb994dd1d13dc9da5ecf0baf360f73a6790c290a7e371689552a245cn,
  b: 0xcn,
  r: -0xb994dd1d13dc9da5ecf0baf360f73a6790c290a7e371689552a245c000n
}, {
  a: 0x99c656a4964e18324a2n,
  b: 0xc7n,
  r: 0x4ce32b524b270c1925100000000000000000000000000000000000000000000000000n
}, {
  a: -0x31da6de21n,
  b: 0xa2n,
  r: -0xc769b78840000000000000000000000000000000000000000n
}, {
  a: 0x73f82d22ab73b2f9c38bddcafn,
  b: 0x85n,
  r: 0xe7f05a4556e765f38717bb95e000000000000000000000000000000000n
}, {
  a: 0xe78567f8c68d9b6d42b224aa0c68a17fecd09c10966cf75e7988f084860f8a5n,
  b: -0x5c8n,
  r: 0n
}, {
  a: 0x8e49d990622161n,
  b: 0x34n,
  r: 0x8e49d9906221610000000000000n
}, {
  a: 0x585b22ee6a9033e71064ffcf6b8560aac42637bn,
  b: 0n,
  r: 0x585b22ee6a9033e71064ffcf6b8560aac42637bn
}, {
  a: -0x82569ba735ef11f4db3c214c13800b2e6a6n,
  b: -0xfn,
  r: -0x104ad374e6bde23e9b67842982700166n
}, {
  a: -0xbf33f71affc155a55abbf3fn,
  b: 0n,
  r: -0xbf33f71affc155a55abbf3fn
}, {
  a: -0x9efn,
  b: 0xa7n,
  r: -0x4f7800000000000000000000000000000000000000000n
}, {
  a: 0x501c7387105d7619n,
  b: 0x43n,
  r: 0x280e39c3882ebb0c80000000000000000n
}, {
  a: -0xdb9db75254a004c6aba4de9297af0d985cd67ef19f0922223686dd4n,
  b: 0x8n,
  r: -0xdb9db75254a004c6aba4de9297af0d985cd67ef19f0922223686dd400n
}, {
  a: 0xaba84937901869dd93be9f9f11b5585255cd3099e4fd8dn,
  b: -0xbn,
  r: 0x15750926f2030d3bb277d3f3e236ab0a4ab9a6133c9fn
}, {
  a: 0x13705e81n,
  b: -0xan,
  r: 0x4dc17n
}, {
  a: -0xf07e8135d64e36ffcd30c8fc7n,
  b: -0x74n,
  r: -0x1n
}, {
  a: -0x1bcc878e0d9238bd86fn,
  b: 0x9cn,
  r: -0x1bcc878e0d9238bd86f000000000000000000000000000000000000000n
}, {
  a: 0xbc34648n,
  b: 0x6dn,
  r: 0x17868c90000000000000000000000000000n
}, {
  a: -0xan,
  b: 0x76n,
  r: -0x2800000000000000000000000000000n
}, {
  a: 0xa89d049cb85826e44402cda8b4c6965bn,
  b: 0xban,
  r: 0x2a2741272e1609b91100b36a2d31a596c0000000000000000000000000000000000000000000000n
}, {
  a: 0xb1d571c43664a3d3fe7ebc1d27013b9e2217fbc5851c3c2ae2ca191b90fn,
  b: -0xee7n,
  r: 0n
}, {
  a: 0x5459d9b0fa5b17bc685879cb5b1b15fbe739c31n,
  b: -0x7dn,
  r: 0x2a2cecd8n
}, {
  a: 0x21cb4a3d2e02245b733515f3e305c1b1e7cb1e736d994b9cfb16e4n,
  b: 0xa2n,
  r: 0x872d28f4b808916dccd457cf8c1706c79f2c79cdb6652e73ec5b900000000000000000000000000000000000000000n
}, {
  a: -0xdc97512c620c3929cn,
  b: 0xb0n,
  r: -0xdc97512c620c3929c00000000000000000000000000000000000000000000n
}, {
  a: 0x9aa1f350a54d9f0883da980ea81d707694c962bdc2f782c75b6274e29d5502b1c59dn,
  b: 0xan,
  r: 0x26a87cd4295367c220f6a603aa075c1da53258af70bde0b1d6d89d38a75540ac7167400n
}, {
  a: 0xeacfdd65f64532257dcc19f1d9d620e68c38a7c3318ddebb9eed822d73an,
  b: 0x7n,
  r: 0x7567eeb2fb229912bee60cf8eceb1073461c53e198c6ef5dcf76c116b9d00n
}, {
  a: 0x149bbad62bb929856f83807dd46c40a03b8247b0fb5f1c6a8def1570eb28n,
  b: 0x3n,
  r: 0xa4ddd6b15dc94c2b7c1c03eea3620501dc123d87daf8e3546f78ab875940n
}, {
  a: -0x29c01f41b0f438d9c86f4b738201cdb714ddbfn,
  b: -0xdn,
  r: -0x14e00fa0d87a1c6ce437a5b9c100e6db8a7n
}, {
  a: 0x248f23115828e0a979e388993b0bddf995c59e8b8022576943c6n,
  b: 0x81n,
  r: 0x491e4622b051c152f3c711327617bbf32b8b3d170044aed2878c00000000000000000000000000000000n
}, {
  a: 0xf3c23c5414c6225eae55bcaf52dff4n,
  b: 0x34n,
  r: 0xf3c23c5414c6225eae55bcaf52dff40000000000000n
}, {
  a: -0x8d6519393a9dd5bdff6e708ad0afn,
  b: 0xf0n,
  r: -0x8d6519393a9dd5bdff6e708ad0af000000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0xd46850b722ccb5c3581a1f0888f4fc9b6d15015e0e3ddbc66b64n,
  b: 0xbcn,
  r: 0xd46850b722ccb5c3581a1f0888f4fc9b6d15015e0e3ddbc66b6400000000000000000000000000000000000000000000000n
}, {
  a: 0xefdaf553d71276687bf9ac06ba9be0c492aad5b4n,
  b: -0x1a9n,
  r: 0n
}, {
  a: -0x5e89096dc79fc0311e9808bb7d1eee11d113bd3244c61077fn,
  b: 0n,
  r: -0x5e89096dc79fc0311e9808bb7d1eee11d113bd3244c61077fn
}, {
  a: 0x73078f2be2792ebaa112f9709f0a5efe6bfd59a29n,
  b: -0x1n,
  r: 0x3983c795f13c975d50897cb84f852f7f35feacd14n
}, {
  a: 0x4be92a71f22c95ba72650f151d4ada4e5fa9f6c0a3d85eabadn,
  b: -0xb62n,
  r: 0n
}, {
  a: -0xb6d59n,
  b: 0x70n,
  r: -0xb6d590000000000000000000000000000n
}, {
  a: 0xd94e717b7f03deda9346232feccce8e0f079268c40d80c3c0n,
  b: -0x42an,
  r: 0n
}, {
  a: -0x55f5111ed7aen,
  b: 0n,
  r: -0x55f5111ed7aen
}, {
  a: 0x88afb1da85bbd3c4aed867ad1ebdb709845n,
  b: -0x2fn,
  r: 0x1115f63b50b77a7895db0cf5n
}, {
  a: 0xa32d6c6bb28474603279dbae4dac5fe29432d640f229f021f8a47ff7dfdn,
  b: -0xcn,
  r: 0xa32d6c6bb28474603279dbae4dac5fe29432d640f229f021f8a47ff7n
}, {
  a: 0xc4023n,
  b: -0x5n,
  r: 0x6201n
}, {
  a: 0xa0591e79a8a94652d5151928bd19c4f2c45f04c5e1beb8e0fa28c1d41222en,
  b: -0x8b0n,
  r: 0n
}, {
  a: -0x3e5b49020c5fd928f2ddb8b00535b4adf373c641a6068a57f9a2a020f292e11e9n,
  b: 0x4n,
  r: -0x3e5b49020c5fd928f2ddb8b00535b4adf373c641a6068a57f9a2a020f292e11e90n
}, {
  a: -0x6adc028610ed8151584e32fdba35da73b00b12e5fb671e7d1938b00d34de812n,
  b: -0x22n,
  r: -0x1ab700a1843b605456138cbf6e8d769cec02c4b97ed9c79f464e2c1n
}, {
  a: 0xad08726d940en,
  b: 0xb3n,
  r: 0x56843936ca07000000000000000000000000000000000000000000000n
}, {
  a: -0x5aba4cc53ae89edf04d2a218b6en,
  b: -0x4n,
  r: -0x5aba4cc53ae89edf04d2a218b7n
}, {
  a: -0x1c83bb1a9b387811330b498322fb4eaf8c1a608d58ba0b37d2afa983aebn,
  b: 0x6n,
  r: -0x720eec6a6ce1e044cc2d260c8bed3abe3069823562e82cdf4abea60ebac0n
}, {
  a: 0x1adf6a0563704c0e3662593e28008c190b818f876fen,
  b: 0x5bn,
  r: 0xd6fb502b1b826071b312c9f1400460c85c0c7c3b7f00000000000000000000000n
}, {
  a: 0xcc8815ec59fc21b4dd984e0985fe5c49bee70b593fn,
  b: 0xb8n,
  r: 0xcc8815ec59fc21b4dd984e0985fe5c49bee70b593f0000000000000000000000000000000000000000000000n
}, {
  a: -0xae097c0n,
  b: -0x1dn,
  r: -0x1n
}, {
  a: -0xace4c0f99f47e1b981e62d5e0aebae7a0230dea553f3e39bcd42n,
  b: -0xcn,
  r: -0xace4c0f99f47e1b981e62d5e0aebae7a0230dea553f3e39bdn
}, {
  a: -0x72aa8f4e619748b2747969180fd6f082db45fa87d3e25844d21ab1eae24n,
  b: -0x75n,
  r: -0x395547a730cba4593a3cb48c07eb79n
}, {
  a: 0xb1dd117c79b645c2c0270f3d99a38e48ff90271af1f110d2f837b0871n,
  b: 0xdn,
  r: 0x163ba22f8f36c8b85804e1e7b33471c91ff204e35e3e221a5f06f610e2000n
}, {
  a: -0x7n,
  b: 0n,
  r: -0x7n
}, {
  a: 0x7625c32ca832be35553f3de85f4144f4fc85e3f6bce5ab5784641b947ec1n,
  b: 0x2n,
  r: 0x1d8970cb2a0caf8d554fcf7a17d0513d3f2178fdaf396ad5e11906e51fb04n
}, {
  a: -0x9d82a207a7e36241d543c4eb8cb61ea06c900cc64fa7d8381c9fdn,
  b: -0xan,
  r: -0x2760a881e9f8d8907550f13ae32d87a81b24033193e9f60e073n
}, {
  a: 0x51856n,
  b: 0x23n,
  r: 0x28c2b000000000n
}, {
  a: -0xdb8f744f34b62884423cfe264a8den,
  b: -0x59n,
  r: -0x6dc7ba3n
}, {
  a: 0x4de96679045d1e006n,
  b: -0xbb6n,
  r: 0n
}, {
  a: 0x364d59ae2ff90b8165a04dc15003n,
  b: 0x42n,
  r: 0xd93566b8bfe42e0596813705400c0000000000000000n
}, {
  a: -0x10f2d43152bc9d1f741808b45cn,
  b: 0x82n,
  r: -0x43cb50c54af2747dd06022d17000000000000000000000000000000000n
}, {
  a: 0x5f767e11d51c2f9n,
  b: -0xf52n,
  r: 0n
}, {
  a: 0x241a29n,
  b: 0x35n,
  r: 0x4834520000000000000n
}, {
  a: -0xff4e21b82465c93fb9fdb7d3dn,
  b: 0n,
  r: -0xff4e21b82465c93fb9fdb7d3dn
}, {
  a: 0x6n,
  b: 0x28n,
  r: 0x60000000000n
}, {
  a: 0x27627911e7c7e0502da17n,
  b: -0x13n,
  r: 0x4ec4f223cf8fc0a0n
}, {
  a: -0xa5380n,
  b: -0xen,
  r: -0x2an
}, {
  a: 0xdca941af239fc8a8da9338d54d591fa2d462972cc675efd885n,
  b: 0n,
  r: 0xdca941af239fc8a8da9338d54d591fa2d462972cc675efd885n
}, {
  a: 0x755d05673a95fc5302f610ef14ecn,
  b: -0x3den,
  r: 0n
}, {
  a: -0x93eec11538e8b3f3ddf28f2cd1f7370f50783d682103957c4b8330dafn,
  b: 0x3n,
  r: -0x49f7608a9c7459f9eef9479668fb9b87a83c1eb41081cabe25c1986d78n
}, {
  a: -0xfcd3a22092effcn,
  b: 0n,
  r: -0xfcd3a22092effcn
}, {
  a: -0x9b1f16n,
  b: 0x16n,
  r: -0x26c7c5800000n
}, {
  a: -0x454c7601efe2de2f55e5e597n,
  b: 0n,
  r: -0x454c7601efe2de2f55e5e597n
}, {
  a: -0x7015d45c3a719e45e91da9561dn,
  b: -0xc3n,
  r: -0x1n
}, {
  a: 0xfea3d5edfe2f05b1f289b30b2c9bn,
  b: -0x262n,
  r: 0n
}, {
  a: 0x71882c47f20115301b86e41c189d89275063d5a0n,
  b: 0n,
  r: 0x71882c47f20115301b86e41c189d89275063d5a0n
}, {
  a: -0x5a46beb3d72156cc3a6288bfce084e54fa8385c6e0eb947526b173d430c8862n,
  b: -0x693n,
  r: -0x1n
}, {
  a: 0xdd48feeda2c53bdca6d5386f18e6ee7f40a870f22e1e87936a48059n,
  b: 0n,
  r: 0xdd48feeda2c53bdca6d5386f18e6ee7f40a870f22e1e87936a48059n
}, {
  a: 0xbe11c1fa4ed3616f8a67f037b2f6843bceaab4ba644a9d985f9b8bf2523aaf1adn,
  b: -0x15n,
  r: 0x5f08e0fd2769b0b7c533f81bd97b421de7555a5d32254ecc2fcdc5f9291dn
}, {
  a: -0xa19330ea9c29441e1e8e95d46269fc5772ea262b95e476eba1d6ac536c410n,
  b: 0x4n,
  r: -0xa19330ea9c29441e1e8e95d46269fc5772ea262b95e476eba1d6ac536c4100n
}, {
  a: -0x7337cf2b5b88b5fb6d686795cc914904b9d2627dc1b6d9a00ced06b822n,
  b: 0x8n,
  r: -0x7337cf2b5b88b5fb6d686795cc914904b9d2627dc1b6d9a00ced06b82200n
}, {
  a: 0xc2692f6c179d8db97c8ab2bf0ae3a39n,
  b: -0xfb8n,
  r: 0n
}, {
  a: -0x16b7c864c105445251f3f3139b9b8cdd2n,
  b: 0x8fn,
  r: -0xb5be4326082a22928f9f989cdcdc66e9000000000000000000000000000000000000n
}, {
  a: 0x4511346d1766960fe6354b1a88f4002b20085c18c503340761n,
  b: -0x29fn,
  r: 0n
}, {
  a: 0xbe2n,
  b: 0x6dn,
  r: 0x17c4000000000000000000000000000n
}, {
  a: 0x9738d25cb848211df3a362abf2045b0e90c5279a1cdb3d035457506c6c1d6cec3745n,
  b: 0x7n,
  r: 0x4b9c692e5c24108ef9d1b155f9022d87486293cd0e6d9e81aa2ba836360eb6761ba280n
}, {
  a: 0xf0abc1184680c488n,
  b: 0x16n,
  r: 0x3c2af04611a03122000000n
}, {
  a: 0x4a2b3cca289b68f2992649ba4n,
  b: 0x74n,
  r: 0x4a2b3cca289b68f2992649ba400000000000000000000000000000n
}, {
  a: 0xa4an,
  b: 0xean,
  r: 0x29280000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0x5f9a6754f1d03107b3533946157ee2f15dc6n,
  b: 0xe9n,
  r: 0xbf34cea9e3a0620f66a6728c2afdc5e2bb8c0000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0xcbb51d2473af8f4b7142c35dcd498493b1d6cb2b81b7e83119d5ea15n,
  b: -0x358n,
  r: 0n
}, {
  a: -0xe948e49d72337a196672fa84e8cf9n,
  b: -0x1n,
  r: -0x74a4724eb919bd0cb3397d427467dn
}, {
  a: -0xa15a559f63735ebd045d0fde805d5cbfab0674285698c1fe1e96869f49772afn,
  b: -0x7n,
  r: -0x142b4ab3ec6e6bd7a08ba1fbd00bab97f560ce850ad3183fc3d2d0d3e92ee6n
}, {
  a: 0xc0521af7e1092870252008e875039838dc143d4a843099n,
  b: -0x9n,
  r: 0x60290d7bf0849438129004743a81cc1c6e0a1ea54218n
}, {
  a: -0xb5ccd3b82b5458382eb7a4236d337ed3278n,
  b: -0xbn,
  r: -0x16b99a77056a8b0705d6f4846da66fda7n
}, {
  a: 0xc2f8436n,
  b: -0xf2n,
  r: 0n
}, {
  a: 0x22210d5a4be189fa01f731cd8fe203c7n,
  b: 0n,
  r: 0x22210d5a4be189fa01f731cd8fe203c7n
}, {
  a: 0xd8714f3695d4316dbbb3226db4c438c0ff81919b5e97a19b4a9n,
  b: 0xb6n,
  r: 0x361c53cda5750c5b6eecc89b6d310e303fe06466d7a5e866d2a4000000000000000000000000000000000000000000000n
}, {
  a: -0x6n,
  b: 0x6an,
  r: -0x1800000000000000000000000000n
}, {
  a: 0x950df1e386d145032875fbd566e1bdbb67798c6046n,
  b: 0xafn,
  r: 0x4a86f8f1c368a281943afdeab370deddb3bcc6302300000000000000000000000000000000000000000000n
}, {
  a: 0x64d60a4e87ba08d4c81a2cfef2298n,
  b: -0x85n,
  r: 0n
}, {
  a: 0x41df454b44e806d8eda99f00fbdf3ea797890461bb883ab0188c9293b89352e4c4n,
  b: -0x32n,
  r: 0x1077d152d13a01b63b6a67c03ef7cfa9e5e241186ee20eac062324n
}, {
  a: -0x7d289187fa4181409cd66faa93c083edd38a6173ba56n,
  b: 0xf5n,
  r: -0xfa51230ff483028139acdf55278107dba714c2e774ac0000000000000000000000000000000000000000000000000000000000000n
}, {
  a: -0x6712b3b56c26e63d67051a72fa8f352n,
  b: -0x65n,
  r: -0x33895an
}, {
  a: -0x97c9bbd81fb3370c81834n,
  b: 0x10n,
  r: -0x97c9bbd81fb3370c818340000n
}, {
  a: -0x9c02e9768c9a07a8d8a94bec8d54f673eec8d1b8e69e0a7n,
  b: 0x5an,
  r: -0x2700ba5da32681ea362a52fb23553d9cfbb2346e39a7829c0000000000000000000000n
}, {
  a: -0x170afn,
  b: 0xa1n,
  r: -0x2e15e0000000000000000000000000000000000000000n
}, {
  a: -0xe3aae0e1daac85b988bf53da371e84ed64629e4bfc12caa157408901419539n,
  b: 0x1n,
  r: -0x1c755c1c3b5590b73117ea7b46e3d09dac8c53c97f8259542ae811202832a72n
}, {
  a: 0x42a8dn,
  b: 0x91n,
  r: 0x8551a000000000000000000000000000000000000n
}, {
  a: -0xe8dbd18c332ba30bdf4e1631f4fb9d8100bc460c8ea8d402fb86846f0f78f705en,
  b: 0x2n,
  r: -0x3a36f4630ccae8c2f7d3858c7d3ee760402f118323aa3500bee1a11bc3de3dc178n
}, {
  a: 0x3fd8759b5ebf1be2ac4a88de06fb9n,
  b: -0x4n,
  r: 0x3fd8759b5ebf1be2ac4a88de06fbn
}, {
  a: 0xe0a631483d383095ce2a98fbeda598d001aeddfn,
  b: 0n,
  r: 0xe0a631483d383095ce2a98fbeda598d001aeddfn
}, {
  a: -0xead09105b9f7f5f0a74c8946n,
  b: 0xaen,
  r: -0x3ab424416e7dfd7c29d3225180000000000000000000000000000000000000000000n
}, {
  a: 0xe35446db4fbc70af57f5223fa9742e5db84cd31844eb19097703cn,
  b: 0xf1n,
  r: 0x1c6a88db69f78e15eafea447f52e85cbb7099a63089d63212ee078000000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0x65cf16cd43f7944ad2ba71536n,
  b: -0x81n,
  r: 0n
}, {
  a: -0xd3ba615cc7fa9b9f9d620b00162b29364ef4ba06a35cf7e7031n,
  b: 0xe5n,
  r: -0x1a774c2b98ff5373f3ac416002c56526c9de9740d46b9efce062000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0xc73dn,
  b: -0x28n,
  r: 0n
}, {
  a: -0x660b53ee5595b3n,
  b: 0xd3n,
  r: -0x3305a9f72acad980000000000000000000000000000000000000000000000000000n
}, {
  a: -0x8n,
  b: -0xa90n,
  r: -0x1n
}, {
  a: 0x3b917n,
  b: -0x2n,
  r: 0xee45n
}, {
  a: -0x2c558104e75b01f08b52d76c4beb1cb32a743c30ec2eec8c04ee85n,
  b: -0x545n,
  r: -0x1n
}, {
  a: -0x65803f5ab1428c07fe4df79a5641b3e82ef7fd0901f42352cc2137a8a730n,
  b: -0x8n,
  r: -0x65803f5ab1428c07fe4df79a5641b3e82ef7fd0901f42352cc2137a8a8n
}, {
  a: 0x61bad01230c801fefe12a1b1aada9ed6172a59559780208210225d1a4c21509b51n,
  b: -0x6n,
  r: 0x186eb4048c32007fbf84a86c6ab6a7b585ca965565e008208408974693085426dn
}, {
  a: -0xed1314d03891e71e3d73b2n,
  b: -0xbn,
  r: -0x1da2629a07123ce3c7afn
}, {
  a: 0xeecdbd52f38060c092bc1bf6910c73be2fe4c8445580884a66b476779391250c29542n,
  b: 0x7n,
  r: 0x7766dea979c03060495e0dfb488639df17f264222ac04425335a3b3bc9c8928614aa100n
}, {
  a: -0xf3b9f120191d38n,
  b: 0xdfn,
  r: -0x79dcf8900c8e9c00000000000000000000000000000000000000000000000000000000n
}, {
  a: 0x1eb1cb3a363106n,
  b: 0xd8n,
  r: 0x1eb1cb3a363106000000000000000000000000000000000000000000000000000000n
}, {
  a: -0x5385c966c1085162be6674ec248f3n,
  b: 0n,
  r: -0x5385c966c1085162be6674ec248f3n
}, {
  a: -0x6056ad19b885539989602bebbaa0c022ccdf54386eb408a6b1ecf46ab2703n,
  b: -0x37n,
  r: -0xc0ad5a33710aa73312c057d77541804599bea870dd68115n
}, {
  a: 0x45961aa2f8bc0c83d729ce494cf3ead81ee4de4db58f33c6cb2f3c6n,
  b: 0xcn,
  r: 0x45961aa2f8bc0c83d729ce494cf3ead81ee4de4db58f33c6cb2f3c6000n
}, {
  a: -0x51d4ea74bbaa97a10c7780ff0e400bbc93b4c052d9f202f321754n,
  b: 0n,
  r: -0x51d4ea74bbaa97a10c7780ff0e400bbc93b4c052d9f202f321754n
}, {
  a: -0xf2b3a0ac4e168b06aa78accb105dadd274bn,
  b: 0x96n,
  r: -0x3cace82b1385a2c1aa9e2b32c4176b749d2c0000000000000000000000000000000000000n
}, {
  a: 0x9c34487096b978b05b302071dbd49d1624be7092b1fbn,
  b: -0x9b3n,
  r: 0n
}, {
  a: 0xcc112e1f18f526n,
  b: 0x40n,
  r: 0xcc112e1f18f5260000000000000000n
}, {
  a: -0x906c925e3745a75a33a550fce809cc68d94cba1n,
  b: -0x929n,
  r: -0x1n
}, {
  a: 0x81904f283d5fac3a3d9abf10cc4e01a845n,
  b: 0x1dn,
  r: 0x103209e507abf58747b357e21989c03508a0000000n
}, {
  a: 0x514e1e34b4d21a82920f8c8532834c4296d75217617c951a3c9c091f02aa1n,
  b: -0xa4fn,
  r: 0n
}, {
  a: -0xa88e6c2387a1dcb84d71fc4fb6669086546acc3cdb963da2fd86a9abfa07e749d70n,
  b: 0x2n,
  r: -0x2a239b08e1e8772e135c7f13ed99a421951ab30f36e58f68bf61aa6afe81f9d275c0n
}, {
  a: -0x82dd28146ccd5f2dcd817953bd2c39d148a80321e0577n,
  b: -0x9en,
  r: -0x20b74bn
}, {
  a: 0x26cd8537b7d091fn,
  b: -0xe0n,
  r: 0n
}, {
  a: 0x925c242ea11d84f1b2005cc4bc1n,
  b: 0x8en,
  r: 0x2497090ba847613c6c8017312f0400000000000000000000000000000000000n
}, {
  a: 0x7n,
  b: -0xb6n,
  r: 0n
}, {
  a: 0xa82cbc0n,
  b: -0x9e4n,
  r: 0n
}, {
  a: 0xb66n,
  b: 0n,
  r: 0xb66n
}, {
  a: -0x9dee1746247e265cedd0f9c34b7463059c065ca29b764ban,
  b: -0xccn,
  r: -0x1n
}, {
  a: -0xe8a0b20e86636df714fdc4051820fbf605c696bcadd9ddbeebd2f90b48d8n,
  b: -0x619n,
  r: -0x1n
}, {
  a: 0x981ae616c4a265ac149039bebf6452b224e7c7cn,
  b: 0x8bn,
  r: 0x4c0d730b625132d60a481cdf5fb229591273e3e00000000000000000000000000000000000n
}, {
  a: -0x9b42c1624890222eb556a2a30adbb5cf4c88978e1ca835ff198b681a12dn,
  b: -0x62n,
  r: -0x26d0b0589224088bad55a8a8c2b6ed73d33n
}, {
  a: 0x213395499b7c8a3e7af42cfc40fb55bfbd3c1a0bb993356n,
  b: 0xe2n,
  r: 0x84ce55266df228f9ebd0b3f103ed56fef4f0682ee64cd5800000000000000000000000000000000000000000000000000000000n
}, {
  a: 0x31476f8dbdf81d28ee441a82659f7a81a8eb73n,
  b: 0x66n,
  r: 0xc51dbe36f7e074a3b9106a09967dea06a3adcc0000000000000000000000000n
}, {
  a: 0x250d2419e2ebaf54a1ca14e431dcbd4845ba1a7e055fb3248d1ce6c9f220ccn,
  b: 0xdn,
  r: 0x4a1a4833c5d75ea9439429c863b97a908b7434fc0abf66491a39cd93e44198000n
}, {
  a: -0xda37870ac007aa1e89919e4b6ba8df4c28n,
  b: 0x8dn,
  r: -0x1b46f0e15800f543d13233c96d751be985000000000000000000000000000000000000n
}, {
  a: 0x7b1db3fn,
  b: 0xe8n,
  r: 0x7b1db3f0000000000000000000000000000000000000000000000000000000000n
}, {
  a: -0x7a5cec89f9b1a9b6ce79092c4ac0534901731ac695a93n,
  b: 0xf9n,
  r: -0xf4b9d913f363536d9cf212589580a69202e6358d2b52600000000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0xd879bf644e4bfa9578051n,
  b: 0x70n,
  r: 0xd879bf644e4bfa95780510000000000000000000000000000n
}, {
  a: -0x5142d4b1b58950485c0371d7a8b170a8cbd98bc1d8a9598e42eb58a8deebb57e3n,
  b: 0x4n,
  r: -0x5142d4b1b58950485c0371d7a8b170a8cbd98bc1d8a9598e42eb58a8deebb57e30n
}, {
  a: -0xc6fe4bd0a3d8debe55337987655c436a538a47abc4da704e4369e57fd83a610n,
  b: 0x4n,
  r: -0xc6fe4bd0a3d8debe55337987655c436a538a47abc4da704e4369e57fd83a6100n
}, {
  a: 0x36d279a759553887c75n,
  b: -0xb1n,
  r: 0n
}, {
  a: 0x92325d1770184041725706c9eceaf60fb10ed17782f070dd5a6310e6df700b7fd7cn,
  b: -0x217n,
  r: 0n
}, {
  a: -0xca14e61af786c11e9badfa78087645b99d2cbdb71638e8fb924709d2n,
  b: -0x426n,
  r: -0x1n
}, {
  a: -0xa7da555d48d04e7cacn,
  b: 0xbfn,
  r: -0x53ed2aaea468273e56000000000000000000000000000000000000000000000000n
}, {
  a: -0xf892341443fc0f2b4d21f63b4ce9a7n,
  b: -0xc9n,
  r: -0x1n
}, {
  a: -0x46172e801a01e0n,
  b: 0x4bn,
  r: -0x230b97400d00f00000000000000000000n
}, {
  a: -0xfc130fbd13a785cf569c2624d0c690cf667ec94692en,
  b: -0xen,
  r: -0x3f04c3ef44e9e173d5a709893431a433d99fb252n
}, {
  a: 0x1f308n,
  b: -0xdn,
  r: 0xfn
}, {
  a: 0x83578388eb024cc1f01de842954e845d02b8f3f742dc6258eea6n,
  b: 0xacn,
  r: 0x83578388eb024cc1f01de842954e845d02b8f3f742dc6258eea60000000000000000000000000000000000000000000n
}, {
  a: -0x9f902174c589f559978ae7d8f5162d6ca336ee1f698cen,
  b: 0xf6n,
  r: -0x27e4085d31627d5665e2b9f63d458b5b28cdbb87da63380000000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0x5e0de3bn,
  b: -0x5en,
  r: 0n
}, {
  a: -0x44e237b8e6849b4f2e0f29d141cc2fa4f24ea4e7445fec4b880deaa01e12ddn,
  b: -0xdn,
  r: -0x22711bdc73424da7970794e8a0e617d279275273a22ff625c406f5500f1n
}, {
  a: 0x49116b4503ef90e65904c94c25ffca58d67a5n,
  b: 0x10n,
  r: 0x49116b4503ef90e65904c94c25ffca58d67a50000n
}, {
  a: -0xe06aa11b97d1bdff3b28aef2e2c26433ca5a6a2n,
  b: 0x59n,
  r: -0x1c0d542372fa37bfe76515de5c584c86794b4d440000000000000000000000n
}, {
  a: 0x5e0a021d6fe1037d53a072a2ef5376cce9n,
  b: -0xdn,
  r: 0x2f05010eb7f081bea9d0395177a9bb6n
}, {
  a: -0xf7a5a2b3c69e40ed5038513n,
  b: 0xbfn,
  r: -0x7bd2d159e34f2076a81c289800000000000000000000000000000000000000000000000n
}, {
  a: 0x9537f52b2e6faffdc0e251f8864689f6eff9f30ef913856dbba2515n,
  b: 0n,
  r: 0x9537f52b2e6faffdc0e251f8864689f6eff9f30ef913856dbba2515n
}, {
  a: -0x393d07b5e29ad0e8d384fdff0e926n,
  b: -0x17n,
  r: -0x727a0f6bc535a1d1a709fc0n
}, {
  a: 0xd082845451d1e8c78bd6cf8486101fe12acd49f02f0n,
  b: -0x1n,
  r: 0x6841422a28e8f463c5eb67c243080ff09566a4f8178n
}, {
  a: 0x9f59f3e548d8f2466d0ac7c79d8e6e12df95n,
  b: -0x113n,
  r: 0n
}, {
  a: -0x77a11an,
  b: -0x37n,
  r: -0x1n
}, {
  a: 0xeb7e381ee2aa33c84dc314ff74f39bb4400566113f88edn,
  b: 0x2bn,
  r: 0x75bf1c0f715519e426e18a7fba79cdda2002b3089fc47680000000000n
}, {
  a: 0x8716a946c1c2c445359f28e52d1f2433942a8abaccbb4b3dad93695e484c59cc6n,
  b: -0xeben,
  r: 0n
}, {
  a: -0x72fbc3e812ed238f331262dde8882e488aae331ce5d2797cbn,
  b: -0x4n,
  r: -0x72fbc3e812ed238f331262dde8882e488aae331ce5d2797dn
}, {
  a: 0xfdbbb7b43a977f078435c38an,
  b: 0n,
  r: 0xfdbbb7b43a977f078435c38an
}, {
  a: 0n,
  b: 0xdbn,
  r: 0n
}, {
  a: 0x9a78262892e9d5f7f6143b89b5afn,
  b: -0x6bn,
  r: 0x13n
}, {
  a: 0x63280144ce36a8170b9c1788f6262d1ac5f58d3fe9753694d444n,
  b: 0x3bn,
  r: 0x319400a2671b540b85ce0bc47b13168d62fac69ff4ba9b4a6a22000000000000000n
}, {
  a: -0x64bfdd6993e35840bebdc548cb752774725ad40c44ab165ff524d73n,
  b: 0xfn,
  r: -0x325feeb4c9f1ac205f5ee2a465ba93ba392d6a0622558b2ffa926b98000n
}, {
  a: 0xda1bb140b1ee9b3da78749n,
  b: 0n,
  r: 0xda1bb140b1ee9b3da78749n
}, {
  a: 0xd9870ac4ae42125d84fa956ef58e3dc7e8f5f2ace0n,
  b: 0x4dn,
  r: 0x1b30e15895c8424bb09f52addeb1c7b8fd1ebe559c00000000000000000000n
}, {
  a: -0x6df6644n,
  b: 0x2an,
  r: -0x1b7d99100000000000n
}, {
  a: -0xd7fn,
  b: -0x9n,
  r: -0x7n
}, {
  a: -0x34661173cd1fe329c1e9a03fc6e143ae27d919ac339en,
  b: 0xe6n,
  r: -0xd19845cf347f8ca707a680ff1b850eb89f6466b0ce78000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0x575e76bf989ddb6e7cea181c1f915f881c7e036612b713af59a1n,
  b: 0x43n,
  r: 0x2baf3b5fcc4eedb73e750c0e0fc8afc40e3f01b3095b89d7acd080000000000000000n
}, {
  a: 0x559n,
  b: 0x12n,
  r: 0x15640000n
}, {
  a: -0x1ef780cf5f9a12400cd269da32693593dbf5be0f297537224931d194cn,
  b: -0xb1n,
  r: -0xf7bc067afcd1n
}, {
  a: -0x2941c7ea66e71b3d77aaeb1efb60n,
  b: -0xb47n,
  r: -0x1n
}, {
  a: -0xe2a69d8e97b26b9304c567e91459b7bfc5b8575c3cfba5n,
  b: 0x1bn,
  r: -0x71534ec74bd935c98262b3f48a2cdbdfe2dc2bae1e7dd28000000n
}, {
  a: 0x8c3050731084faf6bed6104f1093cd3c49n,
  b: -0x3fn,
  r: 0x11860a0e62109f5ed7dn
}, {
  a: 0xa8b06d5fea456531a36e45b9572e618bf3100ec3cdcd1dc6n,
  b: 0xb6n,
  r: 0x2a2c1b57fa91594c68db916e55cb9862fcc403b0f37347718000000000000000000000000000000000000000000000n
}, {
  a: 0n,
  b: 0n,
  r: 0n
}, {
  a: 0x5d1a0127c028b120926c1c6106cdad0a22aa84652715f01b9396bn,
  b: 0x2fn,
  r: 0x2e8d0093e014589049360e308366d68511554232938af80dc9cb5800000000000n
}, {
  a: -0xe59a19f1c4db169abd6425ea218821n,
  b: 0x4dn,
  r: -0x1cb3433e389b62d357ac84bd44310420000000000000000000n
}, {
  a: -0x3af5a8c16d411d9937af2b11171d48a0fd63a0a1bn,
  b: 0x7bn,
  r: -0x1d7ad460b6a08ecc9bd795888b8ea4507eb1d050d8000000000000000000000000000000n
}, {
  a: -0xa2564fcdee30150a5b2a773374cn,
  b: -0x70n,
  r: -0x1n
}, {
  a: 0xa97c748690098a05a9f65cacdn,
  b: 0xfen,
  r: 0x2a5f1d21a40262816a7d972b34000000000000000000000000000000000000000000000000000000000000000n
}, {
  a: -0x60ffae1ffdf9bc1e5775dc50f255006e4a060c90887afc39d6n,
  b: 0x33n,
  r: -0x307fd70ffefcde0f2bbaee28792a803725030648443d7e1ceb0000000000000n
}, {
  a: -0x6213086c9bc6794a46d2fc03d1fn,
  b: 0x9bn,
  r: -0x310984364de33ca523697e01e8f800000000000000000000000000000000000000n
}, {
  a: -0x18b748f60df07bed2db3e1b7ab7b47f2f2cf3c4ac92004b7a6c21a2981f77b0n,
  b: 0n,
  r: -0x18b748f60df07bed2db3e1b7ab7b47f2f2cf3c4ac92004b7a6c21a2981f77b0n
}, {
  a: -0x41c55a5e1d7b69727n,
  b: -0x61cn,
  r: -0x1n
}, {
  a: -0xc17a7eab3bbbbd49b5be0746a6c404189a68adc006385274819b0eaf21n,
  b: -0xen,
  r: -0x305e9faaceeeef526d6f81d1a9b10106269a2b70018e149d2066c3bn
}, {
  a: -0x7ee4847b6a2353b15c0ed1433e2n,
  b: -0xf0n,
  r: -0x1n
}, {
  a: 0xc06ca625c1584d1c55eab5b3c1676658edf318072ea85en,
  b: 0n,
  r: 0xc06ca625c1584d1c55eab5b3c1676658edf318072ea85en
}, {
  a: 0xbc814bc1285a0de5d2ad13469d3f01b2e19n,
  b: 0n,
  r: 0xbc814bc1285a0de5d2ad13469d3f01b2e19n
}, {
  a: -0xe7c56n,
  b: 0x33n,
  r: -0x73e2b0000000000000n
}, {
  a: 0xcff0d14902d9cc250cec7dd86c29ed7d193ee5305fbca731d66d6c0ad6742n,
  b: -0xfen,
  r: 0n
}, {
  a: 0x974d9eabfe40820712b43n,
  b: 0x6en,
  r: 0x25d367aaff902081c4ad0c000000000000000000000000000n
}, {
  a: 0x3b9e40ba350edbdcdaa6e7838251eb2647b0860ed7edce645a6n,
  b: -0xan,
  r: 0xee7902e8d43b6f736a9b9e0e0947ac991ec2183b5fb73991n
}, {
  a: 0xdc3b26d0420769b66f5cad22dd3688388ef4e761cdba10d29f82a60ce32cbn,
  b: -0x61n,
  r: 0x6e1d93682103b4db37ae56916e9b441c477a7n
}, {
  a: 0xd7c6ab44an,
  b: 0x11n,
  r: 0x1af8d568940000n
}, {
  a: 0xd6b9d37n,
  b: -0xbn,
  r: 0x1ad73n
}, {
  a: -0x5b5aabcbf3784177c7d4f6b1936f6502d75cf2aba1adfn,
  b: -0x7n,
  r: -0xb6b55797e6f082ef8fa9ed6326deca05aeb9e557436n
}, {
  a: 0x958980a4ece2d50f8c3n,
  b: 0x61n,
  r: 0x12b130149d9c5aa1f186000000000000000000000000n
}, {
  a: -0xea6b7bedfb88296a16b2bd3n,
  b: 0x31n,
  r: -0x1d4d6f7dbf71052d42d657a6000000000000n
}, {
  a: -0x8b58485ae43fe0665504b4084485431cac5e35773851871a87a8fc434efefdd2f271n,
  b: 0x5n,
  r: -0x116b090b5c87fc0ccaa096810890a863958bc6aee70a30e350f51f8869dfdfba5e4e20n
}, {
  a: -0x1c8b81a66e35bf5775a532b7730n,
  b: 0xd6n,
  r: -0x722e0699b8d6fd5dd694caddcc000000000000000000000000000000000000000000000000000000n
}, {
  a: 0n,
  b: -0xd8n,
  r: 0n
}, {
  a: -0x9531ef09794e0daa957e0b7b2b592fcb2b242e46a107ecba4b0872n,
  b: 0n,
  r: -0x9531ef09794e0daa957e0b7b2b592fcb2b242e46a107ecba4b0872n
}, {
  a: -0x4f8fa0c9b00bd52c629e7ae960531048684aaen,
  b: -0x6n,
  r: -0x13e3e8326c02f54b18a79eba5814c4121a12bn
}, {
  a: -0xb0ee62577536eed39an,
  b: -0x3n,
  r: -0x161dcc4aeea6ddda74n
}, {
  a: -0xb4024437589b73ec580ca312a965f07afef94cf9dc750d5eafd70b42f11dada18dn,
  b: -0xd2n,
  r: -0x2d00910dd626ddn
}, {
  a: -0xb65c48f781606c1b9842e05bbf21aa7n,
  b: 0x1bn,
  r: -0x5b2e247bc0b0360dcc21702ddf90d538000000n
}, {
  a: -0xda9n,
  b: -0x29bn,
  r: -0x1n
}, {
  a: -0xf55867a06f09f4676an,
  b: 0n,
  r: -0xf55867a06f09f4676an
}, {
  a: -0x1bade608018f9567013cdb8f990fd704658734a13e119an,
  b: -0xcn,
  r: -0x1bade608018f9567013cdb8f990fd704658734a13e2n
}, {
  a: -0x8afb18594c3db23c12fbc30a255696bbf2126d2d675ea839c7a639c71bd540cc1e8n,
  b: 0x6n,
  r: -0x22bec616530f6c8f04bef0c28955a5aefc849b4b59d7aa0e71e98e71c6f5503307a00n
}, {
  a: -0x79cfd0f5770563305n,
  b: -0x3e0n,
  r: -0x1n
}, {
  a: -0x9ac3cb295619e52df4de4bd0en,
  b: 0n,
  r: -0x9ac3cb295619e52df4de4bd0en
}, {
  a: 0x3be6d7a20980ce700c2f5095f7c53c1a9c1eefn,
  b: 0x1an,
  r: 0xef9b5e88260339c030bd4257df14f06a707bbc000000n
}, {
  a: 0x1552d0ee8931182b5ec78e63ed94bbb12210df2ba2fee524d34d502b7a12fac3da68n,
  b: 0xbn,
  r: 0xaa9687744988c15af63c731f6ca5dd891086f95d17f729269a6a815bd097d61ed34000n
}, {
  a: -0x228f4ff8c6a76665d49131866ed3bn,
  b: -0xc2n,
  r: -0x1n
}, {
  a: 0xaa0c8b13ba0859ea81b9cfcbd7bb5a84c5b9en,
  b: -0x29n,
  r: 0x55064589dd042cf540dce7e5ebdn
}, {
  a: 0x5a14cd798cc7411d6d706b178afc15n,
  b: 0x6bn,
  r: 0x2d0a66bcc663a08eb6b8358bc57e0a800000000000000000000000000n
}, {
  a: 0x15e75de92475744683a3f4d4c84c31ac7714f88b8c4715d122700c788cf4n,
  b: 0x1n,
  r: 0x2bcebbd248eae88d0747e9a990986358ee29f117188e2ba244e018f119e8n
}, {
  a: 0xfd972ea2572e7ba93884e1fdcec4e2dd66ecba958a917e2ca912bc238f518848fa2n,
  b: 0x5n,
  r: 0x1fb2e5d44ae5cf7527109c3fb9d89c5bacdd9752b1522fc59522578471ea31091f440n
}, {
  a: 0xb11db5ac7e49591855aac85ead0a09ce4435c6f8e0ffb2ba80n,
  b: 0n,
  r: 0xb11db5ac7e49591855aac85ead0a09ce4435c6f8e0ffb2ba80n
}, {
  a: -0x8b6ec7982fe109e629bdc73a6e3732fa5e9f09b25fe234dbn,
  b: 0x15n,
  r: -0x116dd8f305fc213cc537b8e74dc6e65f4bd3e1364bfc469b600000n
}, {
  a: -0xd7b8b11c0696ec6d1e1b21add4fa5ebeabba2dn,
  b: 0xd1n,
  r: -0x1af7162380d2dd8da3c36435ba9f4bd7d57745a0000000000000000000000000000000000000000000000000000n
}, {
  a: -0xb5366n,
  b: -0xen,
  r: -0x2en
}, {
  a: -0xa96c7558a5a22ed7b28ca08c435b195cb0f220f94fed737590n,
  b: 0n,
  r: -0xa96c7558a5a22ed7b28ca08c435b195cb0f220f94fed737590n
}, {
  a: -0x40bb3a6c67185b9f44915e6b5bba676ebd09d13fc67ca89ece66556e5013dcd199n,
  b: 0xen,
  r: -0x102ece9b19c616e7d124579ad6ee99dbaf42744ff19f2a27b399955b9404f734664000n
}, {
  a: 0xc88a658b7ea4c0e304765ae0c1441n,
  b: 0n,
  r: 0xc88a658b7ea4c0e304765ae0c1441n
}, {
  a: 0x475f4079460c80n,
  b: -0xb4an,
  r: 0n
}, {
  a: -0x46338c8731227d4f0288caf7296aa8n,
  b: 0x52n,
  r: -0x118ce321cc489f53c0a232bdca5aaa000000000000000000000n
}, {
  a: 0x4b7b2957c46de96fd1d0bc12c7n,
  b: 0xa9n,
  r: 0x96f652af88dbd2dfa3a178258e000000000000000000000000000000000000000000n
}, {
  a: -0x49789cb927f34a2e33f8b7998e219bc3e54d3e2bb25b596c5afb1813d46e016f715n,
  b: 0xen,
  r: -0x125e272e49fcd28b8cfe2de6638866f0f9534f8aec96d65b16bec604f51b805bdc54000n
}, {
  a: 0xd500dd3n,
  b: 0xd2n,
  r: 0x3540374c0000000000000000000000000000000000000000000000000000n
}, {
  a: 0xa98706b4e47efe09d8f5865e75en,
  b: 0n,
  r: 0xa98706b4e47efe09d8f5865e75en
}, {
  a: 0xcba7bc304fa26d4a3n,
  b: -0x141n,
  r: 0n
}, {
  a: -0x417128f708987bfd8c869a449a0n,
  b: -0x3e5n,
  r: -0x1n
}, {
  a: -0xd224639494371dd15fbba857709b2n,
  b: 0n,
  r: -0xd224639494371dd15fbba857709b2n
}, {
  a: -0x8261b738afba5e9871b8a0e529b44bf45ab8b233f4fcn,
  b: 0xaan,
  r: -0x20986dce2bee97a61c6e28394a6d12fd16ae2c8cfd3f0000000000000000000000000000000000000000000n
}, {
  a: -0x59cfd0e2da83699b233085n,
  b: 0xe1n,
  r: -0xb39fa1c5b506d33646610a00000000000000000000000000000000000000000000000000000000n
}, {
  a: 0xef41a6aa11932a6ffab6cac84b54250bcf5d228b1388ca68e7c5af02n,
  b: 0n,
  r: 0xef41a6aa11932a6ffab6cac84b54250bcf5d228b1388ca68e7c5af02n
}, {
  a: 0xff98369299f4c05n,
  b: 0x3an,
  r: 0x3fe60da4a67d301400000000000000n
}, {
  a: -0x813434479333cf6830546286017b1e683578eb87074e9ebn,
  b: -0xban,
  r: -0x3n
}, {
  a: -0x677cf53f87ae91n,
  b: -0xcfen,
  r: -0x1n
}, {
  a: -0xe59b506dn,
  b: -0x8c0n,
  r: -0x1n
}, {
  a: 0x4004ed03a8261d9ded2d53c742c12n,
  b: 0x37n,
  r: 0x20027681d4130ecef696a9e3a160900000000000000n
}, {
  a: -0x579ff1613c8bb614f784ee14fa42e47a5b825d9df94c59057b4fe896f51b159n,
  b: -0x53n,
  r: -0xaf3fe2c279176c29ef09dc29f485c8f4b704bb3bf3n
}, {
  a: -0x64ffdd49f40884017bd2a46f2n,
  b: -0x2n,
  r: -0x193ff7527d0221005ef4a91bdn
}, {
  a: 0x6bac76b294n,
  b: 0n,
  r: 0x6bac76b294n
}, {
  a: -0xa60ffe0n,
  b: 0x27n,
  r: -0x5307ff00000000000n
}, {
  a: 0x6f5855c55f52badac79e4114en,
  b: -0x72n,
  r: 0n
}, {
  a: -0x21aean,
  b: 0xa3n,
  r: -0x10d7500000000000000000000000000000000000000000n
}, {
  a: -0x3d020ad95eb7f2a739e773b6d71eadbc362421d4d91c6n,
  b: 0xe2n,
  r: -0xf4082b657adfca9ce79dcedb5c7ab6f0d89087536471800000000000000000000000000000000000000000000000000000000n
}, {
  a: -0x501d07af03178dff2cff3742f674349e9fe4259774a6382611c168n,
  b: 0x91n,
  r: -0xa03a0f5e062f1bfe59fe6e85ece8693d3fc84b2ee94c704c2382d0000000000000000000000000000000000000n
}, {
  a: 0x84a62f2dca09dfc94a7c9ed6f9ab5eb32d04bn,
  b: 0x7bn,
  r: 0x42531796e504efe4a53e4f6b7cd5af59968258000000000000000000000000000000n
}, {
  a: -0x231f80ce96540dda10efd7e87d347a36bd297fn,
  b: 0n,
  r: -0x231f80ce96540dda10efd7e87d347a36bd297fn
}, {
  a: -0x29dn,
  b: -0x2dfn,
  r: -0x1n
}, {
  a: 0x22dfbe62396fn,
  b: 0x89n,
  r: 0x45bf7cc472de0000000000000000000000000000000000n
}, {
  a: 0x126c85d22d7bf399d73b34dfdd352f75n,
  b: -0x6an,
  r: 0x49b21n
}, {
  a: -0x136110f23928881499f21a7d48575b1n,
  b: 0n,
  r: -0x136110f23928881499f21a7d48575b1n
}, {
  a: -0xe5dc2n,
  b: 0x76n,
  r: -0x39770800000000000000000000000000000n
}, {
  a: 0xe38b0afb40cd60c082a09700fd14ae82f55cd6an,
  b: 0n,
  r: 0xe38b0afb40cd60c082a09700fd14ae82f55cd6an
}, {
  a: -0xf5e2d031e0c41887a8d3f6629n,
  b: -0x2n,
  r: -0x3d78b40c78310621ea34fd98bn
}, {
  a: 0xb000e65b11acfd9a39962aca4114e59dbb0ee37f7a206c2608a33669451ddn,
  b: 0xfn,
  r: 0x5800732d88d67ecd1ccb1565208a72cedd8771bfbd10361304519b34a28ee8000n
}, {
  a: 0x1ab9d80a4f637c5b3a46166n,
  b: 0x96n,
  r: 0x6ae760293d8df16ce9185980000000000000000000000000000000000000n
}, {
  a: 0xcbd41e96a0e2b2f2ac2c042288f9172e0dd172656d1267985beab61a071fd55fb4n,
  b: 0x7n,
  r: 0x65ea0f4b5071597956160211447c8b9706e8b932b68933cc2df55b0d038feaafda00n
}, {
  a: -0x9cf5c2744ea37038b280202aad18f5733e862031d672c17a66229n,
  b: 0x39n,
  r: -0x139eb84e89d46e071650040555a31eae67d0c4063ace582f4cc45200000000000000n
}, {
  a: 0xffd9b3d3af8671a3b59d7f2604be0a102de560dd3fde4fc3c0n,
  b: -0x4n,
  r: 0xffd9b3d3af8671a3b59d7f2604be0a102de560dd3fde4fc3cn
}, {
  a: 0x9a96be2f4ee94de8650306137da19cb0309e42eef2en,
  b: 0x36n,
  r: 0x26a5af8bd3ba537a1940c184df68672c0c2790bbbcb80000000000000n
}, {
  a: 0x5353667847909530741d6b7f0ba16feefbf76795n,
  b: 0x3bn,
  r: 0x29a9b33c23c84a983a0eb5bf85d0b7f77dfbb3ca800000000000000n
}, {
  a: 0xd47196649badb17e817dc2bf9fbda2f6713722610d19e15e4c8a9dce32411e7064n,
  b: 0xan,
  r: 0x351c659926eb6c5fa05f70afe7ef68bd9c4dc898434678579322a7738c90479c19000n
}, {
  a: 0xffe45bfcb533ff35cn,
  b: -0x4n,
  r: 0xffe45bfcb533ff35n
}, {
  a: -0x2a826f1cc3aa564f8a7278bbd63b06a51abfd5bfaa32c604099d4e4f8cn,
  b: -0x5n,
  r: -0x1541378e61d52b27c5393c5deb1d83528d5feadfd519630204cea727dn
}, {
  a: -0x488bdcn,
  b: 0xben,
  r: -0x1222f7000000000000000000000000000000000000000000000000n
}, {
  a: 0x28987d58cb4b07baf1cn,
  b: -0xbn,
  r: 0x5130fab196960f75n
}, {
  a: -0x2d692e7ca4044a86b58858d3d13a0912n,
  b: 0x3en,
  r: -0xb5a4b9f290112a1ad621634f44e82448000000000000000n
}, {
  a: -0x53n,
  b: 0n,
  r: -0x53n
}, {
  a: 0x61230a433a89b1a7ebc1ce8cdbb9067e11ad7cbfd7d37d2c934483n,
  b: -0x31fn,
  r: 0n
}, {
  a: 0x3f074f9a6c705f76982e6122e9cce4940aaacaaabc4b4005080ff22n,
  b: -0xfn,
  r: 0x7e0e9f34d8e0beed305cc245d399c928155595557896800a101n
}, {
  a: -0x82e661e86f00d4n,
  b: 0x13n,
  r: -0x417330f437806a00000n
}, {
  a: -0x2d9a9f473b19b6d6186n,
  b: 0n,
  r: -0x2d9a9f473b19b6d6186n
}, {
  a: 0xeae53b7c8e1312d624d0a1f8188200671afd6437fe7771f82400c016d555e32cb9n,
  b: 0xan,
  r: 0x3ab94edf2384c4b58934287e06208019c6bf590dff9ddc7e09003005b55578cb2e400n
}, {
  a: 0xd21ac456548b679fc0f465fad87b97n,
  b: 0x87n,
  r: 0x690d622b2a45b3cfe07a32fd6c3dcb8000000000000000000000000000000000n
}, {
  a: -0x1e672f2e22f85609162720b4c72a1eac2b243a89dc828b3132cc99286c286a139828en,
  b: -0x6n,
  r: -0x799cbcb88be15824589c82d31ca87ab0ac90ea27720a2cc4cb3264a1b0a1a84e60bn
}, {
  a: -0x9c8d3e89b6b79c472n,
  b: 0x66n,
  r: -0x27234fa26dade711c80000000000000000000000000n
}, {
  a: 0x5986320c9ccc8f2fd3a0fn,
  b: 0xabn,
  r: 0x2cc319064e664797e9d078000000000000000000000000000000000000000000n
}, {
  a: -0xed8b31461911fc5n,
  b: 0xcfn,
  r: -0x76c598a30c88fe28000000000000000000000000000000000000000000000000000n
}, {
  a: -0xba0d67aa4b9a62139073854eb6b2e8501eedf6n,
  b: 0x94n,
  r: -0xba0d67aa4b9a62139073854eb6b2e8501eedf60000000000000000000000000000000000000n
}, {
  a: -0x4243f55123aaf115886587bd90b4f3a004ba19e05a88n,
  b: -0xa5n,
  r: -0x213n
}, {
  a: -0x2dcf844dea8ff990b444c2a040d4e9998b4c14bad35d0ea58dd592e343ebc124e5n,
  b: -0x1e9n,
  r: -0x1n
}, {
  a: 0xd09279027050aff1af3e2f7581db817b93027b85271n,
  b: 0x13n,
  r: 0x68493c81382857f8d79f17bac0edc0bdc9813dc293880000n
}, {
  a: 0x918c8e0f83d3a088a57f5b25ben,
  b: -0xe3n,
  r: 0n
}, {
  a: 0xd1ac38f11a1cab6d78315ef4e1f494d96d69ecdcde025cn,
  b: 0x5en,
  r: 0x346b0e3c46872adb5e0c57bd387d25365b5a7b37378097000000000000000000000000n
}, {
  a: -0x5147041ae5e48a7162f511237850610934f5429f12118e1de76cc9n,
  b: -0x60n,
  r: -0x5147041ae5e48a7162f51123785062n
}, {
  a: 0x3ff5753ffa15f74cc89a8fcbd8n,
  b: -0xafn,
  r: 0n
}, {
  a: -0x2f67598032b5cad5c054d335790a6ab05ecb7000c07ca284c23476e69101ec8c82n,
  b: 0xfn,
  r: -0x17b3acc0195ae56ae02a699abc8535582f65b800603e5142611a3b734880f646410000n
}, {
  a: -0x5cec45b0a65dcec1n,
  b: -0xan,
  r: -0x173b116c299774n
}, {
  a: -0x8b0d5db4f5ad477deacf0642b711aa670d09d6fad922c1ef3b08a8066edd1d6e38b51n,
  b: 0x2n,
  r: -0x22c3576d3d6b51df7ab3c190adc46a99c34275beb648b07bcec22a019bb7475b8e2d44n
}, {
  a: 0x51d222b9a08b783b37065n,
  b: 0x85n,
  r: 0xa3a445734116f0766e0ca000000000000000000000000000000000n
}, {
  a: -0x9f714d92acaef1ab31e4a41f510ab00f9745fa486n,
  b: -0xe70n,
  r: -0x1n
}, {
  a: 0xf30286e8df6b76217n,
  b: -0x4n,
  r: 0xf30286e8df6b7621n
}, {
  a: 0n,
  b: -0x548n,
  r: 0n
}, {
  a: -0xfaaea902935ae792da65b2fda56d8a7e4f0606d5411b29dbd7b38355bfbac65n,
  b: -0x9d9n,
  r: -0x1n
}, {
  a: -0xb329n,
  b: 0n,
  r: -0xb329n
}, {
  a: -0xf1f7c5942642f1771c17847035d4a077792471eb01a1ca08bd6466n,
  b: -0x6n,
  r: -0x3c7df1650990bc5dc705e11c0d75281dde491c7ac06872822f592n
}, {
  a: -0xc848ea26204c972709c65d89a94753da390ad00f827f5d45aa3d3530382602e0c2n,
  b: -0x9n,
  r: -0x6424751310264b9384e32ec4d4a3a9ed1c856807c13faea2d51e9a981c130171n
}, {
  a: -0x7580b8c889307b4b5b02b35c0cb5757a40f2e2c77e157795fe33n,
  b: -0xb2n,
  r: -0x1d602e33n
}, {
  a: -0x343d9c94c189690b784f2n,
  b: -0xcen,
  r: -0x1n
}, {
  a: 0x6236c60c2efe393bc0c5e8b1b817cfd2ef001bbb6d14a4e60f6814d3cfn,
  b: -0xbn,
  r: 0xc46d8c185dfc7277818bd163702f9fa5de003776da2949cc1ed029an
}, {
  a: 0xc0a500f58f7bc03556826b1n,
  b: -0x4n,
  r: 0xc0a500f58f7bc03556826bn
}, {
  a: -0xdb047f4907a4b3b7200ce920fcee4a2304db1124585f9a43n,
  b: 0xc6n,
  r: -0x36c11fd241e92cedc8033a483f3b9288c136c4491617e690c0000000000000000000000000000000000000000000000000n
}, {
  a: 0xe032fc1946cc13998c02en,
  b: -0x144n,
  r: 0n
}, {
  a: 0x99ec4e4960941404163b95b7e225edf4n,
  b: -0x1n,
  r: 0x4cf62724b04a0a020b1dcadbf112f6fan
}, {
  a: 0x2321d87n,
  b: 0x62n,
  r: 0x8c8761c000000000000000000000000n
}, {
  a: 0x2b053d3n,
  b: -0x4n,
  r: 0x2b053dn
}, {
  a: 0x73en,
  b: -0xe66n,
  r: 0n
}, {
  a: 0x7bf15695a1n,
  b: -0xb97n,
  r: 0n
}, {
  a: -0x5c8488bb7f5cd930ad0e102f759991268982016df60507d9a1269462bffc13dn,
  b: -0x2dn,
  r: -0x2e42445dbfae6c9856870817baccc89344c100b6fb0283ecd094n
}, {
  a: -0x309753bd31772ecee857b2e2aba988c013e2f2b34680560d97588cf34d17n,
  b: 0x9n,
  r: -0x612ea77a62ee5d9dd0af65c55753118027c5e5668d00ac1b2eb119e69a2e00n
}, {
  a: 0xd0fd99c3efa9070cce2ab878a0356f42dn,
  b: 0x8fn,
  r: 0x687ecce1f7d4838667155c3c501ab7a16800000000000000000000000000000000000n
}, {
  a: -0x29a99436883efc43671e97fdc81c07234a3cf32341698e89349n,
  b: -0x7n,
  r: -0x5353286d107df886ce3d2ffb90380e469479e64682d31d127n
}, {
  a: 0n,
  b: -0xbfn,
  r: 0n
}, {
  a: 0x825a1285aa93cd654351611a9a9c8c52a2bd8c779c85fd6n,
  b: 0xdcn,
  r: 0x825a1285aa93cd654351611a9a9c8c52a2bd8c779c85fd60000000000000000000000000000000000000000000000000000000n
}, {
  a: -0xf898f81feb1011n,
  b: 0x19n,
  r: -0x1f131f03fd62022000000n
}, {
  a: -0x1f38e8aa467afe3c5a2c45726f4e6323a8fen,
  b: -0xeccn,
  r: -0x1n
}, {
  a: -0xfc85ca83669fce81b0943e7d8n,
  b: 0x8en,
  r: -0x3f2172a0d9a7f3a06c250f9f6000000000000000000000000000000000000n
}, {
  a: 0x6a1f3402ccef6e794n,
  b: 0x8en,
  r: 0x1a87cd00b33bdb9e5000000000000000000000000000000000000n
}, {
  a: -0x29f45d1f7a8b0ae39edd182f45c9021cd64b75e46ac49n,
  b: -0x4n,
  r: -0x29f45d1f7a8b0ae39edd182f45c9021cd64b75e46ac5n
}, {
  a: 0x3f4ff50ef871981dd07b30af476806c88d168cfbd863b2908dc5an,
  b: 0xebn,
  r: 0x1fa7fa877c38cc0ee83d9857a3b40364468b467dec31d94846e2d00000000000000000000000000000000000000000000000000000000000n
}, {
  a: -0x57f756e6ce508ead7329eb9f6ab65cb2f038e47831e807a158e65d514bd024n,
  b: -0x1fn,
  r: -0xafeeadcd9ca11d5ae653d73ed56cb965e071c8f063d00f42b1ccbbn
}, {
  a: -0x7e019085647deefdb1b31eafc2d32b85f631f8n,
  b: 0xf3n,
  r: -0x3f00c842b23ef77ed8d98f57e16995c2fb18fc0000000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0n,
  b: -0x31n,
  r: 0n
}, {
  a: 0x1e135c54f9ba49a18a15bf2be5990bfn,
  b: -0xan,
  r: 0x784d7153e6e926862856fcaf9664n
}, {
  a: 0x9b49bb9d923a2dffd12aca6e0af070700n,
  b: -0xdn,
  r: 0x4da4ddcec91d16ffe8956537057838n
}, {
  a: 0xddeed7714d31d257811f7dd7f5a4d56649db402n,
  b: 0x5dn,
  r: 0x1bbddaee29a63a4af023efbafeb49aacc93b680400000000000000000000000n
}, {
  a: 0x1583e4d01d0b5850ec09f9b43512cd0c934d42fb00ed27a900e32673e3f2f939334n,
  b: 0x2n,
  r: 0x560f9340742d6143b027e6d0d44b34324d350bec03b49ea4038c99cf8fcbe4e4cd0n
}, {
  a: -0x5072fb357an,
  b: 0x79n,
  r: -0xa0e5f66af4000000000000000000000000000000n
}, {
  a: -0x6b3df4963dd8972c99c0d65b81fd768473e9d76e0ec68ec37264477d6f4a5df8n,
  b: 0x1n,
  r: -0xd67be92c7bb12e593381acb703faed08e7d3aedc1d8d1d86e4c88efade94bbf0n
}, {
  a: -0x9c410eac1030412f950b62ff7e0cn,
  b: -0x1a9n,
  r: -0x1n
}, {
  a: 0xddbn,
  b: 0n,
  r: 0xddbn
}, {
  a: 0x5b2e2a84fn,
  b: 0n,
  r: 0x5b2e2a84fn
}, {
  a: -0xcb6669604344c80dc2190cc9fba6d6e54459261ca5e9an,
  b: 0x82n,
  r: -0x32d99a5810d13203708643327ee9b5b951164987297a6800000000000000000000000000000000n
}, {
  a: 0x8e3637fd2f25b68fcb0f357ebe31bba562e01fee8460ae00b532a172f14cc3f8fn,
  b: 0x5n,
  r: 0x11c6c6ffa5e4b6d1f961e6afd7c63774ac5c03fdd08c15c016a6542e5e29987f1e0n
}, {
  a: 0xa3146fed7fb1ad98d7381e1d33888b99fn,
  b: -0x717n,
  r: 0n
}, {
  a: -0xb3e783d788a555n,
  b: -0xdc9n,
  r: -0x1n
}, {
  a: 0x4bed0ed8d1ee146cf469083abded0b22b49f309c694c1cad1ac61e4e3633d740n,
  b: 0x2n,
  r: 0x12fb43b6347b851b3d1a420eaf7b42c8ad27cc271a53072b46b187938d8cf5d00n
}, {
  a: 0x24a8e28fb965e1b18d7a836072n,
  b: 0x2dn,
  r: 0x4951c51f72cbc3631af506c0e400000000000n
}, {
  a: -0xc46ac5fe0e9e2f3016cbc1d2f0a1ec3b08aen,
  b: 0x6an,
  r: -0x311ab17f83a78bcc05b2f074bc287b0ec22b800000000000000000000000000n
}, {
  a: -0xcf6a037cebc2a6cde6717f85d80e600d3b672435d87594fb781b6594eb797a6d258d9n,
  b: -0xen,
  r: -0x33da80df3af0a9b3799c5fe1760398034ed9c90d761d653ede06d9653ade5e9b4an
}, {
  a: 0x82cb44176268n,
  b: 0x54n,
  r: 0x82cb44176268000000000000000000000n
}, {
  a: 0x60c82ff5ef57cc7764f453945a152149335600dca0099d88fd12d1b2n,
  b: 0n,
  r: 0x60c82ff5ef57cc7764f453945a152149335600dca0099d88fd12d1b2n
}, {
  a: -0xf8fa6149fea5790e4n,
  b: 0x1fn,
  r: -0x7c7d30a4ff52bc87200000000n
}, {
  a: -0xb45552ec32e5208eeecf1a2ea01a64ec1ed773fd7fd95d03416db9b4fc9464b93ae9n,
  b: 0x6n,
  r: -0x2d1554bb0cb94823bbb3c68ba806993b07b5dcff5ff65740d05b6e6d3f25192e4eba40n
}, {
  a: 0xd0329a1654bacdf07e92d7c7008fc4079802n,
  b: 0xaen,
  r: 0x340ca685952eb37c1fa4b5f1c023f101e60080000000000000000000000000000000000000000000n
}, {
  a: 0x33052f75f1530a1c2269e04c86207e2922en,
  b: -0xe3n,
  r: 0n
}, {
  a: 0x72996826b439a034e5057f1909f9c386fc8790696a0341eb2cfa1f00n,
  b: 0x1n,
  r: 0xe532d04d68734069ca0afe3213f3870df90f20d2d40683d659f43e00n
}, {
  a: -0x633faf0172eac5913a8d556b35285e119ae100ffcb4b03bf9e70541fn,
  b: 0xcn,
  r: -0x633faf0172eac5913a8d556b35285e119ae100ffcb4b03bf9e70541f000n
}, {
  a: -0x4900795da8292022f82285ce91767b86a4c17f2faae8b5c19b606d3dd4636bdc19f16n,
  b: -0x3n,
  r: -0x9200f2bb50524045f0450b9d22ecf70d4982fe5f55d16b8336c0da7ba8c6d7b833e3n
}, {
  a: -0x3a522885c76f3dfn,
  b: -0xbn,
  r: -0x74a4510b8edfn
}, {
  a: 0x43288b2f00de9e3f2ad5417aa201b5c36ffc5ce572e92ccn,
  b: -0x67n,
  r: 0x8651165e01bd3c7e55aa8n
}, {
  a: 0xbb393c9855008ea038ea85d5523ce9177d6a5e1dc83a990748d8196e283fd62967n,
  b: -0xdn,
  r: 0x5d9c9e4c2a8047501c7542eaa91e748bbeb52f0ee41d4c83a46c0cb7141feb1n
}, {
  a: 0x171f99e319c605d85297ce801b303809fc89a0a2b554n,
  b: -0x6n,
  r: 0x5c7e678c671817614a5f3a006cc0e027f226828ad5n
}, {
  a: -0x54d19fbc3b240b210e81a38797c7543b6946f78ddf756274346ca00en,
  b: -0x1n,
  r: -0x2a68cfde1d9205908740d1c3cbe3aa1db4a37bc6efbab13a1a365007n
}, {
  a: 0x7fa63aa7f80f08eab552182273b9c5529c555982ef0f894n,
  b: 0x41n,
  r: 0xff4c754ff01e11d56aa43044e7738aa538aab305de1f1280000000000000000n
}, {
  a: -0xfd72dd1ec1d730bd93cefc7bee48bf632a5c998f06d6cbc896ecan,
  b: 0x6an,
  r: -0x3f5cb747b075cc2f64f3bf1efb922fd8ca972663c1b5b2f225bb2800000000000000000000000000n
}, {
  a: 0xa06b1ef232e82920f11ce070273d1b387ac2ae7b7b9b0dcdce7n,
  b: -0xd0en,
  r: 0n
}, {
  a: 0xecfa1n,
  b: -0x129n,
  r: 0n
}, {
  a: -0x549fb7dbd9951c8c76740cf9e84a13aff3n,
  b: -0xbn,
  r: -0xa93f6fb7b32a3918ece819f3d094276n
}, {
  a: 0x70d9f1b3efb74329cdbb3dbcbe764adbeac95e034f211f8b1n,
  b: 0x52n,
  r: 0x1c367c6cfbedd0ca736ecf6f2f9d92b6fab25780d3c847e2c400000000000000000000n
}, {
  a: -0x9ac805b0907d84560831a17e01fa7f3d330ceedbab9859bb0fcd32n,
  b: -0x5n,
  r: -0x4d6402d8483ec22b0418d0bf00fd3f9e9986776dd5cc2cdd87e6an
}, {
  a: -0xab23c5fdbfn,
  b: 0xb3n,
  r: -0x5591e2fedf800000000000000000000000000000000000000000000n
}, {
  a: 0xc9ddcbe1c8b2bb6b5d776c4514aae4c2dcbb4e52ac36b8293220n,
  b: 0n,
  r: 0xc9ddcbe1c8b2bb6b5d776c4514aae4c2dcbb4e52ac36b8293220n
}, {
  a: 0xcdd333edc5336a38baa6bce5n,
  b: 0xccn,
  r: 0xcdd333edc5336a38baa6bce5000000000000000000000000000000000000000000000000000n
}, {
  a: 0xfb010f9112aa385772cccfa68a0e6584d87ec7d649df6d6n,
  b: 0xe8n,
  r: 0xfb010f9112aa385772cccfa68a0e6584d87ec7d649df6d60000000000000000000000000000000000000000000000000000000000n
}, {
  a: -0xab2a6cn,
  b: 0xa5n,
  r: -0x15654d800000000000000000000000000000000000000000n
}, {
  a: -0x84cf8ec27c9535f90e21a45768f4fa82cc8403c81f4ea7n,
  b: -0xdc5n,
  r: -0x1n
}, {
  a: 0x4687b9afc1022d6aa6909aa7ac3dca550569aff79ca250868267n,
  b: 0x7cn,
  r: 0x4687b9afc1022d6aa6909aa7ac3dca550569aff79ca2508682670000000000000000000000000000000n
}, {
  a: -0x60f52766f4323f9f0d2b5e37f85c78b7b068c567e8a864b2bn,
  b: 0x77n,
  r: -0x307a93b37a191fcf8695af1bfc2e3c5bd83462b3f45432595800000000000000000000000000000n
}, {
  a: 0x2a83bca3294d291505c7841fc57e2fc4n,
  b: 0x88n,
  r: 0x2a83bca3294d291505c7841fc57e2fc40000000000000000000000000000000000n
}, {
  a: -0xcae09c7f7ed7an,
  b: 0xb7n,
  r: -0x65704e3fbf6bd0000000000000000000000000000000000000000000000n
}, {
  a: 0x862c77a0f20798d8febfn,
  b: 0n,
  r: 0x862c77a0f20798d8febfn
}, {
  a: 0x1a474a4121a3906d7526439f46e9e6bb936acc016cdae8cc471d9995042387n,
  b: 0xdn,
  r: 0x348e9482434720daea4c873e8dd3cd7726d59802d9b5d1988e3b332a08470e000n
}, {
  a: -0x6ed0958fcceb6n,
  b: -0x1dfn,
  r: -0x1n
}, {
  a: 0x300437f66efe26693bb0b12528551128f266b3ebccfade9537n,
  b: -0x22n,
  r: 0xc010dfd9bbf899a4eec2c494a15444a3c99acfaf3n
}, {
  a: 0x943b7c59642502447bc2f0311256ed9a3798fn,
  b: 0n,
  r: 0x943b7c59642502447bc2f0311256ed9a3798fn
}, {
  a: -0x2fc8996dff39b7bdc28ff81b0fe0c048b2515bcc5cn,
  b: 0x7en,
  r: -0xbf2265b7fce6def70a3fe06c3f830122c9456f31700000000000000000000000000000000n
}, {
  a: -0x2d4a510fd1026e605b9d5025902be75d4c292ec9cfadde772c06n,
  b: 0x85n,
  r: -0x5a94a21fa204dcc0b73aa04b2057ceba98525d939f5bbcee580c000000000000000000000000000000000n
}, {
  a: -0xd980de5272df1bd4f65b8ee9246f8538070a0f420e3fn,
  b: -0x4n,
  r: -0xd980de5272df1bd4f65b8ee9246f8538070a0f420e4n
}, {
  a: 0x7d0c66eb699e12e19f098946d3a220c949976c5761cdn,
  b: 0xb2n,
  r: 0x1f4319bada6784b867c26251b4e888325265db15d873400000000000000000000000000000000000000000000n
}, {
  a: -0x91d47513dc2846720e940n,
  b: 0x2bn,
  r: -0x48ea3a89ee142339074a000000000000n
}, {
  a: -0x7fb6d0bb14bfabbe728ccn,
  b: 0n,
  r: -0x7fb6d0bb14bfabbe728ccn
}, {
  a: -0xdfa3033c58495f190ef9303ed561c36161afd376578bfd660cb70322442dn,
  b: -0xb8n,
  r: -0xdfa3033c584960n
}, {
  a: -0xbb7d866b5263a5a7faa2ac473881371abd45fecc3fb6f37422d9087ff34cc1n,
  b: 0x2n,
  r: -0x2edf619ad498e969fea8ab11ce204dc6af517fb30fedbcdd08b6421ffcd3304n
}, {
  a: -0xfbd9098fef8c24926256ccn,
  b: 0n,
  r: -0xfbd9098fef8c24926256ccn
}, {
  a: -0xbdc84de65727a33bca8f248ba4bfn,
  b: -0x449n,
  r: -0x1n
}, {
  a: -0x45n,
  b: 0n,
  r: -0x45n
}, {
  a: 0x1bc0e1fbc78751d9b32c9d5af1f975d4adcad6ccf00fn,
  b: 0x42n,
  r: 0x6f0387ef1e1d4766ccb2756bc7e5d752b72b5b33c03c0000000000000000n
}, {
  a: 0x9044a959c34a3582n,
  b: -0xb3en,
  r: 0n
}, {
  a: 0x9a91c92ebc03e870d05f2dc7b3a6206934e73c117f65n,
  b: -0xf0n,
  r: 0n
}, {
  a: -0x56714edd5464b2215bb257de40a02a741d39bb4cb52465ed2ce6ac9481755e95cn,
  b: 0xdn,
  r: -0xace29dbaa8c96442b764afbc814054e83a7376996a48cbda59cd592902eabd2b8000n
}, {
  a: 0x155bf7e398e3ef2966ebde3de3a6300fe9bc8d2a9deaa5c92527a5dn,
  b: -0x3n,
  r: 0x2ab7efc731c7de52cdd7bc7bc74c601fd3791a553bd54b924a4f4bn
}, {
  a: -0x676a0n,
  b: 0n,
  r: -0x676a0n
}, {
  a: -0xec6291c3e59acfab6ac4a990360547d433df11d9405dd489b0b44960n,
  b: -0x16an,
  r: -0x1n
}, {
  a: -0x9aa516d6ed3b0625189e64d2056183n,
  b: 0n,
  r: -0x9aa516d6ed3b0625189e64d2056183n
}, {
  a: 0x14faed1e5c0edeb9421494c5cd95f9905219dbc3c67n,
  b: 0xf5n,
  r: 0x29f5da3cb81dbd728429298b9b2bf320a433b7878ce0000000000000000000000000000000000000000000000000000000000000n
}, {
  a: -0x83ace34730b12a9b96n,
  b: 0x72n,
  r: -0x20eb38d1cc2c4aa6e580000000000000000000000000000n
}, {
  a: 0xd5aa53be6467246d2d0n,
  b: 0n,
  r: 0xd5aa53be6467246d2d0n
}, {
  a: -0x8caa76fa94c96b19aa0a1ed49e1b19bf4be108c34ab67667n,
  b: 0x72n,
  r: -0x232a9dbea5325ac66a8287b52786c66fd2f84230d2ad9d99c0000000000000000000000000000n
}, {
  a: -0xe01244fecfb35cn,
  b: 0x31n,
  r: -0x1c02489fd9f66b8000000000000n
}, {
  a: -0x344faf7e3e2e4226aa79e5e60fd95d2n,
  b: -0x6n,
  r: -0xd13ebdf8f8b9089aa9e797983f658n
}, {
  a: -0x3b788ec1cf349516870ae1e3caf82an,
  b: 0xb1n,
  r: -0x76f11d839e692a2d0e15c3c795f05400000000000000000000000000000000000000000000n
}, {
  a: 0xfa5c39a1812c2b7n,
  b: -0x93fn,
  r: 0n
}, {
  a: -0x7372ff05e3ba2a00bfaa7a4e4780b3dcdda4b553be4f8c3a895595f2d8d15n,
  b: 0n,
  r: -0x7372ff05e3ba2a00bfaa7a4e4780b3dcdda4b553be4f8c3a895595f2d8d15n
}, {
  a: -0x9d1160c0ddc3cb5bf01b573a533c283a446b39d8828939df8e4efc89bc466f7e95ffbn,
  b: 0xan,
  r: -0x274458303770f2d6fc06d5ce94cf0a0e911ace7620a24e77e393bf226f119bdfa57fec00n
}, {
  a: 0x51e33ff8eb3bf79770133708197aa13be39214bn,
  b: -0xe35n,
  r: 0n
}, {
  a: -0xec96ad38a1e099c6144dcb9b27b88fdc57eb4e9c4n,
  b: 0n,
  r: -0xec96ad38a1e099c6144dcb9b27b88fdc57eb4e9c4n
}, {
  a: -0x7dd6ef66710447b2f5daf684a0a9161fd57be2n,
  b: 0x10n,
  r: -0x7dd6ef66710447b2f5daf684a0a9161fd57be20000n
}, {
  a: 0xbd6b934c18594dc5de5bcb11c41cd5b1528092f2623177914a45e58b083abeb4en,
  b: 0x8n,
  r: 0xbd6b934c18594dc5de5bcb11c41cd5b1528092f2623177914a45e58b083abeb4e00n
}, {
  a: 0x560a450n,
  b: 0x63n,
  r: 0x2b052280000000000000000000000000n
}, {
  a: -0xd2c57559dc3b4c7ffn,
  b: 0n,
  r: -0xd2c57559dc3b4c7ffn
}, {
  a: -0x387a09f6003fe0ce53da212b4f70205b569b9109ae8c1a0085441777abf3909n,
  b: 0x7n,
  r: -0x1c3d04fb001ff06729ed1095a7b8102dab4dc884d7460d0042a20bbbd5f9c8480n
}, {
  a: -0xf9ec4b296a589bb66807ee9490n,
  b: -0xf33n,
  r: -0x1n
}, {
  a: 0xb33683e5a5673739e6fe6e637aa5ed7f383e859040ea7ed1a62b8b7612f97dn,
  b: 0x4n,
  r: 0xb33683e5a5673739e6fe6e637aa5ed7f383e859040ea7ed1a62b8b7612f97d0n
}, {
  a: 0x92233dd8840d191984fdd912cbb7455a7f726a1039baf8010n,
  b: -0x2b5n,
  r: 0n
}, {
  a: 0x89915c6d6046d9c890d7faf70bd5d8eae26f382ced4306b3dff543728aa38dbn,
  b: 0x3n,
  r: 0x44c8ae36b0236ce4486bfd7b85eaec7571379c1676a18359effaa1b94551c6d8n
}, {
  a: -0xf22f4ac7e540e986d316ff8c530b30ebb74897e9811b4bc94bb7b28f9dcn,
  b: 0x8n,
  r: -0xf22f4ac7e540e986d316ff8c530b30ebb74897e9811b4bc94bb7b28f9dc00n
}, {
  a: -0x68b6cb9fe897018ea1234f57fn,
  b: 0xc9n,
  r: -0xd16d973fd12e031d42469eafe00000000000000000000000000000000000000000000000000n
}, {
  a: 0x8fn,
  b: 0x12n,
  r: 0x23c0000n
}, {
  a: -0xd3484n,
  b: 0n,
  r: -0xd3484n
}, {
  a: -0xf0e761b6f94496b9cc026c5bd559af4ab6376b093a8544d4a346287d8d6d045adn,
  b: -0x9n,
  r: -0x7873b0db7ca24b5ce601362deaacd7a55b1bb5849d42a26a51a3143ec6b6823n
}, {
  a: 0xf82n,
  b: 0xc0n,
  r: 0xf82000000000000000000000000000000000000000000000000n
}, {
  a: -0xe96f99119933d31e0c455a2554a474c337aa3de33269fb033c7ec985df51n,
  b: -0x9n,
  r: -0x74b7cc88cc99e98f0622ad12aa523a619bd51ef19934fd819e3f64c2f0n
}, {
  a: 0xc7cc6daf765bda00cfcd3a788e25efn,
  b: -0x1n,
  r: 0x63e636d7bb2ded0067e69d3c4712f7n
}, {
  a: 0xb159761c24a01905afd561f9d3b5cc22acde7d8f80n,
  b: 0x61n,
  r: 0x162b2ec384940320b5faac3f3a76b984559bcfb1f00000000000000000000000000n
}, {
  a: 0x9en,
  b: 0x63n,
  r: 0x4f0000000000000000000000000n
}, {
  a: 0x791fcf5306c78a0d8b461e97n,
  b: 0xf3n,
  r: 0x3c8fe7a98363c506c5a30f4b8000000000000000000000000000000000000000000000000000000000000n
}, {
  a: -0x5de7cae753n,
  b: -0x66n,
  r: -0x1n
}, {
  a: -0x13e1f878f6e3b4c74c49800ae31e0f5399e9f9cc16448ed93b70n,
  b: -0x2n,
  r: -0x4f87e1e3db8ed31d3126002b8c783d4e67a7e73059123b64edcn
}, {
  a: 0x4f11be7b4a5715d86f1690a5e0n,
  b: 0x1en,
  r: 0x13c46f9ed295c5761bc5a4297800000000n
}, {
  a: 0xc44d740ef28d032b7d48ec47ed1bae87245d228bfada10f0e3b124f08n,
  b: 0x1n,
  r: 0x1889ae81de51a0656fa91d88fda375d0e48ba4517f5b421e1c76249e10n
}, {
  a: -0x391d1e810dceeb7a8eb417a499561c04483d479a1ce5n,
  b: -0xc9en,
  r: -0x1n
}, {
  a: 0x59b7e0bae4405e74d72233028b959d1d6f20c4caea8ecaebf82d792bd6c5n,
  b: -0x58n,
  r: 0x59b7e0bae4405e74d72233028b959d1d6f20c4n
}, {
  a: -0x4ce19140916e2955f9f24e9efea0633d585cffb3baa021900ffn,
  b: 0n,
  r: -0x4ce19140916e2955f9f24e9efea0633d585cffb3baa021900ffn
}, {
  a: -0xc00bb8c3a0487a74b2b3e95cbfc162e183a46397161n,
  b: 0x4fn,
  r: -0x6005dc61d0243d3a5959f4ae5fe0b170c1d231cb8b080000000000000000000n
}, {
  a: -0xd1b8a405c2bc0d6afcbd9f1ce081b22c1aac567ddd68n,
  b: 0x41n,
  r: -0x1a371480b85781ad5f97b3e39c10364583558acfbbad00000000000000000n
}, {
  a: 0x2511c569b35ebb363bf9bf44320ab3870fe367111e4520778786fa809ccen,
  b: 0xan,
  r: 0x944715a6cd7aecd8efe6fd10c82ace1c3f8d9c44791481de1e1bea02733800n
}, {
  a: 0x8f3083d8f34c6eb6d31d2n,
  b: -0x33n,
  r: 0x11e6107b1n
}, {
  a: 0x426cdb9201676090f2401d16bc5ec872bd34cde3f85n,
  b: 0xb8n,
  r: 0x426cdb9201676090f2401d16bc5ec872bd34cde3f850000000000000000000000000000000000000000000000n
}, {
  a: 0xc58fd8ed347eb40b63ea5cd478aebf6d8a2e9e7fe336fn,
  b: 0x7dn,
  r: 0x18b1fb1da68fd6816c7d4b9a8f15d7edb145d3cffc66de0000000000000000000000000000000n
}, {
  a: 0x36cccc4b3b8d3e7132325f1fb81ffd76dab00efca3e6e35be183e43a84ae3ce60ee2n,
  b: -0xa8n,
  r: 0x36cccc4b3b8d3e7132325f1fb8n
}, {
  a: 0xd76205f9e4e2dn,
  b: 0xc5n,
  r: 0x1aec40bf3c9c5a0000000000000000000000000000000000000000000000000n
}, {
  a: 0xf934dbe9476456954n,
  b: 0x89n,
  r: 0x1f269b7d28ec8ad2a80000000000000000000000000000000000n
}, {
  a: 0xfb0985df4en,
  b: 0x44n,
  r: 0xfb0985df4e00000000000000000n
}, {
  a: 0xad7982a3022dd7n,
  b: 0n,
  r: 0xad7982a3022dd7n
}, {
  a: 0x4a67bc839186436cb61b244122c0910e25c5f3dc9c3052b7474f34a770226n,
  b: 0xcn,
  r: 0x4a67bc839186436cb61b244122c0910e25c5f3dc9c3052b7474f34a770226000n
}, {
  a: -0x651fc2a8bfn,
  b: -0xfan,
  r: -0x1n
}, {
  a: -0xd58711b161c21c500f594d5db19e74505n,
  b: 0x20n,
  r: -0xd58711b161c21c500f594d5db19e7450500000000n
}, {
  a: 0x8ff0778e6247be276f25896a7dn,
  b: 0xean,
  r: 0x23fc1de39891ef89dbc9625a9f40000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0n,
  b: 0x5bn,
  r: 0n
}, {
  a: 0x91e6a4d3c77aa6411872f64e8c71d1e8a09226e290d187fcf73bebafa3b5920f10cn,
  b: -0xc1n,
  r: 0x48f35269e3bd53208c3n
}, {
  a: 0x5e4f65a83b2adf0be3067c71e695b3d27df22480625a5f405b2193a3n,
  b: 0xan,
  r: 0x1793d96a0ecab7c2f8c19f1c79a56cf49f7c8920189697d016c864e8c00n
}, {
  a: 0xed5defe86b717969a3556f1d44ce9c5e3c8872182f9735a00n,
  b: 0x27n,
  r: 0x76aef7f435b8bcb4d1aab78ea2674e2f1e44390c17cb9ad000000000000n
}, {
  a: -0x5372749c718c5a3ed856c8eefa537a0n,
  b: 0n,
  r: -0x5372749c718c5a3ed856c8eefa537a0n
}, {
  a: -0xf505f8fda364af268f48d6e747c1e6afcd7f11f54729en,
  b: 0xd8n,
  r: -0xf505f8fda364af268f48d6e747c1e6afcd7f11f54729e000000000000000000000000000000000000000000000000000000n
}, {
  a: 0x9eec4f5n,
  b: -0x92n,
  r: 0n
}, {
  a: 0x862ab5494277b89fd87197e31ad0f74bc5n,
  b: -0xcfn,
  r: 0n
}, {
  a: -0xccf5fb01a17bd4bcd4a9fb2386bfcb406674333ed6n,
  b: -0xe9n,
  r: -0x1n
}, {
  a: -0xc904f562f200216a082ea895c2411dfd3b2983e03c737e4639b2a0n,
  b: 0xaan,
  r: -0x32413d58bc80085a820baa257090477f4eca60f80f1cdf918e6ca80000000000000000000000000000000000000000000n
}, {
  a: -0xc98e4c4a9208e510974n,
  b: 0n,
  r: -0xc98e4c4a9208e510974n
}, {
  a: 0xfdc34a1adf90c2acc7fb90e320cde6eb92f47cn,
  b: 0n,
  r: 0xfdc34a1adf90c2acc7fb90e320cde6eb92f47cn
}, {
  a: -0xc296cd876bn,
  b: -0x9n,
  r: -0x614b66c4n
}, {
  a: -0xd9bb89a3783ac8n,
  b: -0x2en,
  r: -0x367n
}, {
  a: 0xbc7bc1dcf693f35fcff1ef6444f05d3d2d2088e29ff1c613cd6ca0c3102251728a6n,
  b: 0n,
  r: 0xbc7bc1dcf693f35fcff1ef6444f05d3d2d2088e29ff1c613cd6ca0c3102251728a6n
}, {
  a: -0xb1a16cb947n,
  b: 0xd3n,
  r: -0x58d0b65ca380000000000000000000000000000000000000000000000000000n
}, {
  a: -0x667f3341a6968d51b7f3e2ff43ea8866eb42e5e0f72137c16aa42a1772c7b465c720n,
  b: -0xaf0n,
  r: -0x1n
}, {
  a: -0xe298e8ce2e6525806n,
  b: 0x5an,
  r: -0x38a63a338b994960180000000000000000000000n
}, {
  a: -0xa0cc09a03ba991e172c5681028cc92f7e25fc6a03f7ea6180134e407a1b0dn,
  b: 0x8n,
  r: -0xa0cc09a03ba991e172c5681028cc92f7e25fc6a03f7ea6180134e407a1b0d00n
}, {
  a: 0x760c70b30d6d7b2c68941bb06c4750fd753659908bdn,
  b: 0n,
  r: 0x760c70b30d6d7b2c68941bb06c4750fd753659908bdn
}, {
  a: -0x920cc0be5edn,
  b: -0x8en,
  r: -0x1n
}, {
  a: -0x8n,
  b: 0x76n,
  r: -0x2000000000000000000000000000000n
}, {
  a: 0x23029807e971a6f5a8734n,
  b: -0x1n,
  r: 0x11814c03f4b8d37ad439an
}, {
  a: 0xf7c5f2en,
  b: 0x91n,
  r: 0x1ef8be5c000000000000000000000000000000000000n
}, {
  a: 0xd1n,
  b: -0x40n,
  r: 0n
}, {
  a: -0x6aaa2bcc29040n,
  b: 0x8fn,
  r: -0x355515e614820000000000000000000000000000000000000n
}, {
  a: 0xa17bb1c03d7f6606c62e72c6eecd3182a60e8d39fd40f640f4203en,
  b: 0x7cn,
  r: 0xa17bb1c03d7f6606c62e72c6eecd3182a60e8d39fd40f640f4203e0000000000000000000000000000000n
}, {
  a: 0xab95256b91a814cefa36c5d23ac627dfb71789fd5542c5520f4fffa6f58be232aa4b9n,
  b: 0xen,
  r: 0x2ae5495ae46a0533be8db1748eb189f7edc5e27f5550b15483d3ffe9bd62f88caa92e4000n
}, {
  a: 0xdfea5e1e7ae6d120a37f105946141d72c61b9e38d5fa3b04d8ce8e805625251057ec0n,
  b: -0xdn,
  r: 0x6ff52f0f3d73689051bf882ca30a0eb9630dcf1c6afd1d826c6747402b1292882bn
}, {
  a: -0x37d2680bced6b7beb7d2n,
  b: 0n,
  r: -0x37d2680bced6b7beb7d2n
}, {
  a: 0x34038745ee4cf9245126115adfde5d2fed7bc44872n,
  b: 0xa4n,
  r: 0x34038745ee4cf9245126115adfde5d2fed7bc4487200000000000000000000000000000000000000000n
}, {
  a: -0x4f6a5d2aecde8da2e4c2f09e1b29e336202d153a81bf894cf32affd31fa477c3n,
  b: -0x9n,
  r: -0x27b52e95766f46d17261784f0d94f19b10168a9d40dfc4a679957fe98fd23cn
}, {
  a: -0xf49ccbd6672f0n,
  b: 0n,
  r: -0xf49ccbd6672f0n
}, {
  a: -0x10fc8de2a88de9677a21fe0n,
  b: 0x36n,
  r: -0x43f2378aa237a59de887f800000000000000n
}, {
  a: 0x2en,
  b: -0xd65n,
  r: 0n
}, {
  a: 0xb00a08de119f76c7n,
  b: -0x3dn,
  r: 0x5n
}, {
  a: -0xaf218a9eaee3f5d32625554b93ede88ba1281b30751792a3f9e66e1bfa31n,
  b: -0xcn,
  r: -0xaf218a9eaee3f5d32625554b93ede88ba1281b30751792a3f9e66e1c0n
}, {
  a: 0x13e0305f2cdfn,
  b: -0xb8n,
  r: 0n
}, {
  a: 0xa942dde3df3d46b3471b7a45384dcadfbbe0708be0375ea02a2110c5f08104bda4fn,
  b: -0xf73n,
  r: 0n
}, {
  a: -0x66f73ee0986an,
  b: 0xb1n,
  r: -0xcdee7dc130d400000000000000000000000000000000000000000000n
}, {
  a: -0x5e57e8de4cf031299edc3dab8ffa83fea4654043b7bbcdn,
  b: 0xa3n,
  r: -0x2f2bf46f26781894cf6e1ed5c7fd41ff5232a021dbdde680000000000000000000000000000000000000000n
}, {
  a: 0x5ff4582ab3583ef401aa4d212554e004416d9aad627952a3bfe8a582fn,
  b: -0x3n,
  r: 0xbfe8b05566b07de803549a424aa9c00882db355ac4f2a5477fd14b05n
}, {
  a: -0x4f7a95278daa69cf5dadefd5c43fb062bc6a37cebbc4855b99d567b7n,
  b: 0x2n,
  r: -0x13dea549e36a9a73d76b7bf5710fec18af1a8df3aef12156e67559edcn
}, {
  a: -0x449a7bc34e0543d8b965c3cf7n,
  b: 0n,
  r: -0x449a7bc34e0543d8b965c3cf7n
}, {
  a: 0x86d362377898892ca64c4c415982258bed453fn,
  b: -0xen,
  r: 0x21b4d88dde26224b2993131056608962fb5n
}, {
  a: 0xb927848674d337b0b918aa04c4b9b32360fc188d87ab85d78527233775n,
  b: 0xcn,
  r: 0xb927848674d337b0b918aa04c4b9b32360fc188d87ab85d78527233775000n
}, {
  a: 0x16387ce8eea1a704c211d69eea47e7cbf15cf938b247edc3013d0dd7616n,
  b: 0x2n,
  r: 0x58e1f3a3ba869c1308475a7ba91f9f2fc573e4e2c91fb70c04f4375d858n
}, {
  a: 0xff90n,
  b: -0x546n,
  r: 0n
}, {
  a: 0x5b69e449e758ae68e0318f57d448867b336203a177n,
  b: 0x93n,
  r: 0x2db4f224f3ac57347018c7abea24433d99b101d0bb8000000000000000000000000000000000000n
}, {
  a: -0xc3a9a2c4099ade39d041a3199c79d122ca6en,
  b: -0xb54n,
  r: -0x1n
}, {
  a: 0x55aa21d08bb66d741a9d71e9931285a9186de0f4n,
  b: 0xa0n,
  r: 0x55aa21d08bb66d741a9d71e9931285a9186de0f40000000000000000000000000000000000000000n
}, {
  a: 0x7d4c1041f9n,
  b: 0x5bn,
  r: 0x3ea60820fc80000000000000000000000n
}, {
  a: 0x358a6b2c776398ec09c5a5519c79c58n,
  b: 0xd0n,
  r: 0x358a6b2c776398ec09c5a5519c79c580000000000000000000000000000000000000000000000000000n
}, {
  a: -0x76bbc1bc8601eee3b49253582548fb4b65628c81bd3ca58f50af53d9d425d2f3n,
  b: -0x16n,
  r: -0x1daef06f21807bb8ed2494d609523ed2d958a3206f4f2963d42bd4f6751n
}, {
  a: 0xaaf499de8c15f213e8cfd2f76761aa69n,
  b: 0xf1n,
  r: 0x155e933bd182be427d19fa5eecec354d2000000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0xafbd73e1faf46244b1c33bd9232c4876f7bdb76n,
  b: -0x2n,
  r: 0x2bef5cf87ebd18912c70cef648cb121dbdef6ddn
}, {
  a: -0x5d1e6b8b6f7b329ade91dfbed446ab566092ca9n,
  b: 0n,
  r: -0x5d1e6b8b6f7b329ade91dfbed446ab566092ca9n
}, {
  a: -0xa859804f64aa54dben,
  b: 0xbdn,
  r: -0x150b3009ec954a9b7c00000000000000000000000000000000000000000000000n
}, {
  a: -0x5ab421b2fcec15n,
  b: 0x7an,
  r: -0x16ad086cbf3b054000000000000000000000000000000n
}, {
  a: 0x820dd896eab82d044cce966b3943cd556c7130776677c3a3772n,
  b: 0x2bn,
  r: 0x4106ec4b755c168226674b359ca1e6aab638983bb33be1d1bb900000000000n
}, {
  a: 0xce3938a0e177e45bafd69e47889e74a7595ac550888684a03a788eebde2n,
  b: -0x901n,
  r: 0n
}, {
  a: 0xdc7f56d72df78714a607905bfaff9487008358194a46f1102n,
  b: -0x64cn,
  r: 0n
}, {
  a: 0xa58933f9a7d54c43502008e6186a3ca02c458b9414e714d57dc80c44721n,
  b: 0xcn,
  r: 0xa58933f9a7d54c43502008e6186a3ca02c458b9414e714d57dc80c44721000n
}, {
  a: -0x5c08e4bd7cbbc6b1a52854ee5d570466e7ff31f0fb876a7f955a975an,
  b: 0xcn,
  r: -0x5c08e4bd7cbbc6b1a52854ee5d570466e7ff31f0fb876a7f955a975a000n
}, {
  a: -0xecacbbdda8b135f428f406a4n,
  b: 0xa3n,
  r: -0x76565deed4589afa147a035200000000000000000000000000000000000000000n
}, {
  a: 0xea025308e1bc8d6ba24fbd29fdcf9da6ca0n,
  b: 0xb7n,
  r: 0x7501298470de46b5d127de94fee7ced36500000000000000000000000000000000000000000000000n
}, {
  a: -0x42ea2ed36c1714cf1e6fcfe3eb7e15dc9b39e5d4c5710en,
  b: -0x927n,
  r: -0x1n
}, {
  a: -0x43acf4d826d19ae4435fd83293f1a2099ce9e3eec32168e873n,
  b: 0xb5n,
  r: -0x8759e9b04da335c886bfb06527e3441339d3c7dd8642d1d0e6000000000000000000000000000000000000000000000n
}, {
  a: 0xe204108d6e114f7c8191f9d2b2a6ab7e7e06524bn,
  b: -0xb0n,
  r: 0n
}, {
  a: -0x26029b1af6836ec6dabd0c93n,
  b: 0n,
  r: -0x26029b1af6836ec6dabd0c93n
}, {
  a: 0xe3f7d97625n,
  b: 0xeen,
  r: 0x38fdf65d89400000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0x3e806e76ee9f7be302f50bbd763c5e75546b7696248e1c4caca15bf866e45ac863bn,
  b: 0xbn,
  r: 0x1f40373b774fbdf1817a85debb1e2f3aaa35bb4b12470e265650adfc33722d6431d800n
}, {
  a: -0xdbef209002a6312c1e4a94178f005fdc57f0ab6b47e68e8f6809n,
  b: -0x9n,
  r: -0x6df79048015318960f254a0bc7802fee2bf855b5a3f34747b5n
}, {
  a: 0x799d54fae5803f293bdbe65ba75ea01135c1n,
  b: 0xd8n,
  r: 0x799d54fae5803f293bdbe65ba75ea01135c1000000000000000000000000000000000000000000000000000000n
}, {
  a: -0xen,
  b: 0n,
  r: -0xen
}, {
  a: 0x9a6131f38388e8308f9ea22a6fca8d25e1d4ec4a2677cn,
  b: 0n,
  r: 0x9a6131f38388e8308f9ea22a6fca8d25e1d4ec4a2677cn
}, {
  a: 0xf3e73eec12d8e769de0b0c8c4680abe81921059c3109464e404cd20dcb979ea1bn,
  b: 0xcn,
  r: 0xf3e73eec12d8e769de0b0c8c4680abe81921059c3109464e404cd20dcb979ea1b000n
}, {
  a: 0x5a3bf79bab4e9081706f157b705970eb6c8e69ca816a02dd0fc45ecn,
  b: 0x7n,
  r: 0x2d1dfbcdd5a74840b8378abdb82cb875b64734e540b5016e87e22f600n
}, {
  a: -0xfccf9ae47b7c9fb172f46b19e7ca7c4d1f84ec254ec5052637009bcc1n,
  b: 0xfn,
  r: -0x7e67cd723dbe4fd8b97a358cf3e53e268fc27612a76282931b804de608000n
}, {
  a: 0x8e44b3bc179da0df4d567c7ab5b6789f6e680ab164fe4eb12fb2f84bn,
  b: 0x7n,
  r: 0x472259de0bced06fa6ab3e3d5adb3c4fb7340558b27f275897d97c2580n
}, {
  a: 0xf00ea7dbb570c61cfdbb8f7cb88n,
  b: -0x41n,
  r: 0x780753eddabn
}, {
  a: -0x19907865fb1n,
  b: 0xb2n,
  r: -0x6641e197ec400000000000000000000000000000000000000000000n
}, {
  a: 0xcc1ce89ff0ffb7a979a8d8bc9c21253e4ff7633a79n,
  b: 0xabn,
  r: 0x660e744ff87fdbd4bcd46c5e4e10929f27fbb19d3c8000000000000000000000000000000000000000000n
}, {
  a: 0xb5493d0bf43ff9a171214b0c19663ef9927dn,
  b: -0xb7n,
  r: 0n
}, {
  a: 0x656716cdb9bcd2en,
  b: 0xban,
  r: 0x1959c5b36e6f34b80000000000000000000000000000000000000000000000n
}, {
  a: -0xa4103141830e2ad88cfbe9bf8b09bc245298e3a8c8da6e9614386811f76eec847f9n,
  b: 0n,
  r: -0xa4103141830e2ad88cfbe9bf8b09bc245298e3a8c8da6e9614386811f76eec847f9n
}, {
  a: -0xf12c1d48201e78df537342656a8185eab8n,
  b: 0x13n,
  r: -0x78960ea4100f3c6fa9b9a132b540c2f55c00000n
}, {
  a: -0x1bd5c596920bae0cc5e7cda0e75a7637664be7563d7356efb587cd30046n,
  b: -0x9a5n,
  r: -0x1n
}, {
  a: -0x8f5d443e4b1a6a3813ce6419900ecae748e1a14n,
  b: 0xe8n,
  r: -0x8f5d443e4b1a6a3813ce6419900ecae748e1a140000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0x1bc80fd028a5e6dedcfb78f9fe138cede585131afa1a834650821f7ab891n,
  b: 0n,
  r: 0x1bc80fd028a5e6dedcfb78f9fe138cede585131afa1a834650821f7ab891n
}, {
  a: -0xcb7ddcn,
  b: -0x44n,
  r: -0x1n
}, {
  a: 0x9f002f5c481d4c5dec480c67ab7f7c5f4d87663c14223bd903e5n,
  b: 0x10n,
  r: 0x9f002f5c481d4c5dec480c67ab7f7c5f4d87663c14223bd903e50000n
}, {
  a: 0x6b3996137bb574f8b0fbf6e21045bebdedd0f1c97da04bc230e4387706d3efbdabcn,
  b: 0x9n,
  r: 0xd6732c26f76ae9f161f7edc4208b7d7bdba1e392fb40978461c870ee0da7df7b57800n
}, {
  a: 0x6342bcc3d3b33961fa17b5a2abbb0cb5n,
  b: -0x76n,
  r: 0x18dn
}, {
  a: 0x10n,
  b: 0n,
  r: 0x10n
}, {
  a: 0x9ccb48d8en,
  b: 0n,
  r: 0x9ccb48d8en
}, {
  a: -0xd1d76f20dcad80n,
  b: 0x6en,
  r: -0x3475dbc8372b600000000000000000000000000000n
}, {
  a: -0x7f93319c504f5a8679ec11e5c9c61f1f03b3fd2a76a0dcn,
  b: 0xc8n,
  r: -0x7f93319c504f5a8679ec11e5c9c61f1f03b3fd2a76a0dc00000000000000000000000000000000000000000000000000n
}, {
  a: 0xb3174932de23bb1c611ec7f01a54d53n,
  b: 0x77n,
  r: 0x598ba4996f11dd8e308f63f80d2a6a9800000000000000000000000000000n
}, {
  a: 0xf25a2n,
  b: 0xc5n,
  r: 0x1e4b440000000000000000000000000000000000000000000000000n
}, {
  a: 0x451en,
  b: -0xe07n,
  r: 0n
}, {
  a: -0x213c88b5een,
  b: -0xen,
  r: -0x84f223n
}, {
  a: -0xc37ddadbe725ee615d0812261344045960f56328a3f1b7f7efc44534c7285e91an,
  b: 0xdn,
  r: -0x186fbb5b7ce4bdcc2ba10244c268808b2c1eac65147e36fefdf888a698e50bd234000n
}, {
  a: -0xa39aafeccb585400034df596b0f702b1c75bf6e6478e3f448c836698e65fe38n,
  b: 0n,
  r: -0xa39aafeccb585400034df596b0f702b1c75bf6e6478e3f448c836698e65fe38n
}, {
  a: -0x600517b13f2c447727aae29n,
  b: 0xe9n,
  r: -0xc00a2f627e5888ee4f55c520000000000000000000000000000000000000000000000000000000000n
}, {
  a: 0xca13908f5dad2a43e1725a33ca5fc728b968303e0c7d2212fa3e36n,
  b: -0x670n,
  r: 0n
}, {
  a: 0x78d2aed3d8ecea33e6dd0fba55fd49b85n,
  b: 0xcen,
  r: 0x1e34abb4f63b3a8cf9b743ee957f526e14000000000000000000000000000000000000000000000000000n
}, {
  a: 0xdf423042cb90ac99071bc3079190fc20eb7c2459877c8475428653826b8e1c4f79n,
  b: 0x7n,
  r: 0x6fa1182165c8564c838de183c8c87e1075be122cc3be423aa14329c135c70e27bc80n
}, {
  a: -0xc61b1240759e945515c1538030df383a2e4a546e2de5701b2bb4dc6n,
  b: 0n,
  r: -0xc61b1240759e945515c1538030df383a2e4a546e2de5701b2bb4dc6n
}, {
  a: -0x413c3690a064f6335b7634e49a19e1f3b3646aen,
  b: 0x92n,
  r: -0x104f0da428193d8cd6dd8d392686787cecd91ab8000000000000000000000000000000000000n
}, {
  a: -0xa0b2d33a6a5c81891e491e6db0e4da2f276n,
  b: -0xc5n,
  r: -0x1n
}, {
  a: -0xbb24b4163d97aa4d5b13b22d8n,
  b: -0xdn,
  r: -0x5d925a0b1ecbd526ad89dan
}, {
  a: 0xefd31474643b31ac1e0577cn,
  b: 0x27n,
  r: 0x77e98a3a321d98d60f02bbe0000000000n
}, {
  a: -0x9702c3d9590a17afac6a7e66ba1989f06c8ca42440d628209n,
  b: -0x13n,
  r: -0x12e0587b2b2142f5f58d4fccd743313e0d919484881adn
}, {
  a: 0x11195e6d957eecb26997n,
  b: -0xc6n,
  r: 0n
}, {
  a: 0n,
  b: 0n,
  r: 0n
}, {
  a: 0xc6f45c80273ec659e187dc5541918e1a36b3b8fbab141n,
  b: 0xb4n,
  r: 0xc6f45c80273ec659e187dc5541918e1a36b3b8fbab141000000000000000000000000000000000000000000000n
}, {
  a: 0xcb3e697651acacaa1247ab2ec75ca579n,
  b: 0x9dn,
  r: 0x1967cd2eca3595954248f565d8eb94af2000000000000000000000000000000000000000n
}, {
  a: -0xe964d251996e7d7b8851870a9776449f7092fn,
  b: 0x9cn,
  r: -0xe964d251996e7d7b8851870a9776449f7092f000000000000000000000000000000000000000n
}, {
  a: 0x88n,
  b: 0xban,
  r: 0x2200000000000000000000000000000000000000000000000n
}, {
  a: 0x78ceceac40n,
  b: -0x90n,
  r: 0n
}, {
  a: 0xc063c554e7925d6145dea7d7cc8cdad90dba5f5dd76824a10n,
  b: 0xe3n,
  r: 0x6031e2aa73c92eb0a2ef53ebe6466d6c86dd2faeebb412508000000000000000000000000000000000000000000000000000000000n
}, {
  a: -0x40cd9fc5bfd57d33d7f814b099990c97ceb9c549971479aa32792d113n,
  b: 0x7n,
  r: -0x2066cfe2dfeabe99ebfc0a584ccc864be75ce2a4cb8a3cd5193c9688980n
}, {
  a: -0x3c9431221c93n,
  b: 0n,
  r: -0x3c9431221c93n
}, {
  a: 0xe5238ec8a9606836dc72df8e29a0bf04d947aebea880601e17d2b7a3an,
  b: 0x1n,
  r: 0x1ca471d9152c0d06db8e5bf1c53417e09b28f5d7d5100c03c2fa56f474n
}, {
  a: 0xd4n,
  b: 0xdbn,
  r: 0x6a0000000000000000000000000000000000000000000000000000000n
}, {
  a: 0xe873b4e3ef48448862076668d09672045b7n,
  b: 0n,
  r: 0xe873b4e3ef48448862076668d09672045b7n
}, {
  a: 0x8ac1dd02ee0afaddc90909603249fbcc77149a28a449e6fbdc60e80aa83f2e6cdb03n,
  b: -0x82n,
  r: 0x22b07740bb82beb7724242580c927ef31dc5n
}, {
  a: -0x14b5n,
  b: -0x8c7n,
  r: -0x1n
}, {
  a: -0x42e26b28b5da0d43d45ceceb4d2f3a31n,
  b: 0x9bn,
  r: -0x217135945aed06a1ea2e7675a6979d18800000000000000000000000000000000000000n
}, {
  a: -0x7b4153634a2a1d0573d5669fab762104an,
  b: -0x50cn,
  r: -0x1n
}, {
  a: -0x16c915d1bc0b1df85ab4e0033f9f738bn,
  b: 0xdbn,
  r: -0xb648ae8de058efc2d5a70019fcfb9c58000000000000000000000000000000000000000000000000000000n
}, {
  a: -0x77c81a98f5482429a742b3c469eeb83710b358a33779f17d5ac3den,
  b: -0x22n,
  r: -0x1df206a63d52090a69d0acf11a7bae0dc42cd628cdde7dn
}, {
  a: -0xb05df49a967af5abe40fb6n,
  b: 0x26n,
  r: -0x2c177d26a59ebd6af903ed8000000000n
}, {
  a: 0x930740ba331d0d1b1834en,
  b: -0x2n,
  r: 0x24c1d02e8cc74346c60d3n
}, {
  a: -0x18bf8fcdf6abef14a5c4274ce00302991d863n,
  b: 0xc5n,
  r: -0x317f1f9bed57de294b884e99c00605323b0c60000000000000000000000000000000000000000000000000n
}, {
  a: 0xd76ffb3959ab49ac4bb469a438c1796b41d7cc8c4fae2011d3c63edbe29d83bdn,
  b: 0n,
  r: 0xd76ffb3959ab49ac4bb469a438c1796b41d7cc8c4fae2011d3c63edbe29d83bdn
}, {
  a: 0x39f4996640b64345cce12134d7n,
  b: 0n,
  r: 0x39f4996640b64345cce12134d7n
}, {
  a: -0x2629031ed6cfeac60771d6be4c1a43f33946f2f7fe09ab10acn,
  b: 0n,
  r: -0x2629031ed6cfeac60771d6be4c1a43f33946f2f7fe09ab10acn
}, {
  a: 0x4e4846d1bd4f85c3edn,
  b: 0x31n,
  r: 0x9c908da37a9f0b87da000000000000n
}, {
  a: -0xe7e78fb2919d48059031d29474ac3a22ce8e5c3f38a30354b7d544ec01a888n,
  b: -0x9f1n,
  r: -0x1n
}, {
  a: -0xbaa0c82cb3e177b1621efab2c7245de6078bf4328f2889n,
  b: 0xe2n,
  r: -0x2ea8320b2cf85dec5887beacb1c9177981e2fd0ca3ca22400000000000000000000000000000000000000000000000000000000n
}, {
  a: -0x92d769e46e21n,
  b: -0xaan,
  r: -0x1n
}, {
  a: 0xe8f80n,
  b: -0xdean,
  r: 0n
}, {
  a: -0xc3b85c799859e68f0ff2623ab3a3a5849815dd8n,
  b: 0x9dn,
  r: -0x18770b8f330b3cd1e1fe4c47567474b09302bbb0000000000000000000000000000000000000000n
}, {
  a: -0x734372f3d8an,
  b: -0xbbn,
  r: -0x1n
}, {
  a: 0xfaa37f432f18fe2f61c4a2n,
  b: -0x170n,
  r: 0n
}, {
  a: -0xf5c20ba3c6002f9c6n,
  b: 0x4cn,
  r: -0xf5c20ba3c6002f9c60000000000000000000n
}, {
  a: 0x29a169aa464aecb33b9a726ae5b68d7ddc3c688e1f8fcf48c8d8c06c41d857e07n,
  b: 0x7n,
  r: 0x14d0b4d5232576599dcd393572db46beee1e34470fc7e7a4646c603620ec2bf0380n
}, {
  a: 0xb2477135d2c816d0a954fca601en,
  b: -0xe6n,
  r: 0n
}, {
  a: -0xb9bcb23ca8cd1394880bd9d03eceb7b761n,
  b: 0xf8n,
  r: -0xb9bcb23ca8cd1394880bd9d03eceb7b76100000000000000000000000000000000000000000000000000000000000000n
}, {
  a: -0x317n,
  b: -0xben,
  r: -0x1n
}, {
  a: 0xf0885c3b299f7a38e3249fe000b4ea10084f58dcn,
  b: -0x1fn,
  r: 0x1e110b876533ef471c6493fc00169d420n
}, {
  a: -0x68c8860dc9c72e3263062bee533ae6976n,
  b: 0x71n,
  r: -0xd1910c1b938e5c64c60c57dca675cd2ec0000000000000000000000000000n
}, {
  a: 0x7b8bb4acc21193e00f3773e2d940ec9439b7a80ff8f1f329e50b7391n,
  b: 0x8n,
  r: 0x7b8bb4acc21193e00f3773e2d940ec9439b7a80ff8f1f329e50b739100n
}, {
  a: 0x74f5366be3fb99081ec994091ea4b2892cbfa4bb938e6db5c08a0n,
  b: 0x17n,
  r: 0x3a7a9b35f1fdcc840f64ca048f525944965fd25dc9c736dae0450000000n
}, {
  a: 0xa0487a56af29b896e6db74546e267bddcfn,
  b: -0x24n,
  r: 0xa0487a56af29b896e6db74546n
}, {
  a: 0xb89c4bde62387bc236a118203bf288e07c03133c2f5ffn,
  b: -0xabn,
  r: 0x171n
}, {
  a: -0x82878a26695107dfb245c31aa18359a5dbn,
  b: 0xd2n,
  r: -0x20a1e2899a5441f7ec9170c6a860d66976c0000000000000000000000000000000000000000000000000000n
}, {
  a: 0x3a3ec8d288n,
  b: -0xc13n,
  r: 0n
}, {
  a: -0xa60583377b64c45d10865545fea103cn,
  b: -0x57en,
  r: -0x1n
}, {
  a: 0xdb1408d57c90ecb7fa7619a11198edc6e246cc7e90n,
  b: -0xbn,
  r: 0x1b62811aaf921d96ff4ec33422331db8dc48d98fn
}, {
  a: -0xde175d47af9bcc46dc341f23b49004b81341901ac086cc136f93eacb1n,
  b: 0xfn,
  r: -0x6f0baea3d7cde6236e1a0f91da48025c09a0c80d60436609b7c9f56588000n
}, {
  a: 0xc10d06f23689ef9a7d85n,
  b: 0x16n,
  r: 0x304341bc8da27be69f61400000n
}, {
  a: 0xe2506b18d67638000e71d3de315f41263d131a93ffb8n,
  b: -0x3cn,
  r: 0xe2506b18d67638000e71d3de315f4n
}, {
  a: -0x4884989ed233397n,
  b: -0x344n,
  r: -0x1n
}, {
  a: -0x5e93b41883bb7daadac9dfn,
  b: 0x75n,
  r: -0xbd2768310776fb55b593be00000000000000000000000000000n
}, {
  a: 0xd8b8ef67373760bc4e5db2b946f27fe1a2b9dd51ae3n,
  b: 0x1bn,
  r: 0x6c5c77b39b9bb05e272ed95ca3793ff0d15ceea8d718000000n
}, {
  a: 0x9eb018203an,
  b: -0xbn,
  r: 0x13d60304n
}, {
  a: 0x3abc144e346479c7n,
  b: 0x48n,
  r: 0x3abc144e346479c7000000000000000000n
}, {
  a: 0x6b2a6760bd17be9c7f34bffc94497349fc338f92ffn,
  b: 0x49n,
  r: 0xd654cec17a2f7d38fe697ff92892e693f8671f25fe000000000000000000n
}, {
  a: -0x762a172n,
  b: 0x1dn,
  r: -0xec542e40000000n
}, {
  a: 0x2bf74c5b7an,
  b: -0x7d3n,
  r: 0n
}, {
  a: 0x23f8694136n,
  b: -0x3n,
  r: 0x47f0d2826n
}, {
  a: 0xdf4e5a59cfd40a9n,
  b: 0n,
  r: 0xdf4e5a59cfd40a9n
}, {
  a: -0xce8e247398946f83ab727ea7c86cde5bn,
  b: 0xa8n,
  r: -0xce8e247398946f83ab727ea7c86cde5b000000000000000000000000000000000000000000n
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var r = d.a << d.b;
  if (d.r !== r) {
    print("Input A:  " + d.a.toString(16));
    print("Input B:  " + d.b.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    print("Op: <<");
    error_count++;
  }
}
if (error_count !== 0)
  throw new Error("Finished with " + error_count + " errors.")

