FILESEXTRAPATHS_prepend := "${THISDIR}/files:${THISDIR}/backports:${THISDIR}/${BPN}:"

### TBD evaluate if needed for systemd243
SRC_URI += "file://systemd244-tmpfiles.patch \
            file://systemd244-forec-reboot-on-freeze.patch \
            file://0001-Added-code-to-cleanup-all-the-xisting-watches-on-pat.patch \
            file://0001-Added-decrement-of-notify-watchers-when-we-dont-need.patch \
            "

PACKAGECONFIG_append = " timesyncd"
#PACKAGECONFIG[timesyncd] = "--enable-timesyncd,--disable-timesyncd"


do_install_append() {
        install -d ${D}/media/tsb
	#Enable comcast ntp server in timesyncd.conf
	if [ -n "${@bb.utils.contains('PACKAGECONFIG', 'timesyncd', 'timesyncd', '', d)}" ]; then
	   sed -i -e 's/^#NTP=.*/NTP=ntp.ccp.xcal.tv/g' ${D}${sysconfdir}/systemd/timesyncd.conf
           #Patch for CISCOXI4-2785: remove ProtectSystem=full from systemd-timesyncd.service
           sed -i -e '/ProtectSystem=full/d' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e '/PrivateTmp=yes/d' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
	   sed -i -e 's/^#ShutdownWatchdogSec=.*$/ShutdownWatchdogSec=1min/g' ${D}${sysconfdir}/systemd/system.conf
       fi

}


do_install_append_hybrid() {
	#Enable comcast ntp server in timesyncd.conf
	if [ -n "${@bb.utils.contains('PACKAGECONFIG', 'timesyncd', 'timesyncd', '', d)}" ]; then
	   sed -i -e 's/ExecStart=\!\!\/lib\/systemd\/systemd-timesyncd/ExecStart=\!\!\/bin\/sh -c \/bin\/echo systemd-timesyncd not needed in gateways/' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e '/Restart=always/d' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e '/WatchdogSec=1min/d' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e '/PrivateDevices=yes/d' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e '/ProtectHome=yes/d' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e '/CapabilityBoundingSet=CAP_SYS_TIME CAP_SETUID CAP_SETGID CAP_SETPCAP CAP_CHOWN CAP_DAC_OVERRIDE CAP_FOWNER/d' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e '/Type=notify/d' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e '/RestartSec=0/d' ${D}${systemd_unitdir}/system/systemd-timesyncd.service

        fi
	#RDK-20332 : Further Analysis on Systemd Optimisation

        rm -rf ${D}${base_libdir}/systemd/systemd-reply-password
        rm -rf ${D}${base_libdir}/systemd/systemd-activate
}

FILES_${PN}_append_client = " /media/tsb"
FILES_${PN}_append_hybrid = " /media/tsb"
