/* valagobjectmodule.c generated by valac, the Vala compiler
 * generated from valagobjectmodule.vala, do not modify */

/* valagobjectmodule.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <glib.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))

struct _ValaGObjectModulePrivate {
	gint dynamic_property_id;
	gint signal_wrapper_id;
};

static gint ValaGObjectModule_private_offset;
static gpointer vala_gobject_module_parent_class = NULL;

static void vala_gobject_module_real_visit_class (ValaCodeVisitor* base,
                                           ValaClass* cl);
static gboolean vala_gobject_module_class_has_readable_properties (ValaGObjectModule* self,
                                                            ValaClass* cl);
static void vala_gobject_module_add_get_property_function (ValaGObjectModule* self,
                                                    ValaClass* cl);
static gboolean vala_gobject_module_class_has_writable_properties (ValaGObjectModule* self,
                                                            ValaClass* cl);
static void vala_gobject_module_add_set_property_function (ValaGObjectModule* self,
                                                    ValaClass* cl);
static void vala_gobject_module_real_generate_class_init (ValaGTypeModule* base,
                                                   ValaClass* cl);
static void vala_gobject_module_add_guarded_expression (ValaGObjectModule* self,
                                                 ValaSymbol* sym,
                                                 ValaCCodeExpression* expression);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaGLibValue, vala_target_value_unref)
static void vala_gobject_module_emit_invalid_property_id_warn (ValaGObjectModule* self);
static void vala_gobject_module_real_visit_constructor (ValaCodeVisitor* base,
                                                 ValaConstructor* c);
static gchar* vala_gobject_module_real_get_dynamic_property_getter_cname (ValaCCodeBaseModule* base,
                                                                   ValaDynamicProperty* prop);
static gchar* vala_gobject_module_real_get_dynamic_property_setter_cname (ValaCCodeBaseModule* base,
                                                                   ValaDynamicProperty* prop);
static gchar* vala_gobject_module_real_get_dynamic_signal_cname (ValaCCodeBaseModule* base,
                                                          ValaDynamicSignal* node);
static gchar* vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeBaseModule* base,
                                                                         ValaDynamicSignal* sig);
static void vala_gobject_module_generate_gobject_connect_wrapper (ValaGObjectModule* self,
                                                           ValaDynamicSignal* sig,
                                                           gboolean after);
static gchar* vala_gobject_module_real_get_dynamic_signal_connect_after_wrapper_name (ValaCCodeBaseModule* base,
                                                                               ValaDynamicSignal* sig);
static void vala_gobject_module_real_visit_property (ValaCodeVisitor* base,
                                              ValaProperty* prop);
static void vala_gobject_module_real_visit_method_call (ValaCodeVisitor* base,
                                                 ValaMethodCall* expr);
static void vala_gobject_module_finalize (ValaCodeVisitor * obj);

static inline gpointer
vala_gobject_module_get_instance_private (ValaGObjectModule* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGObjectModule_private_offset);
}

static void
vala_gobject_module_real_visit_class (ValaCodeVisitor* base,
                                      ValaClass* cl)
{
	ValaGObjectModule * self;
	ValaTypeSymbol* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (cl != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_class ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), cl);
	_tmp0_ = ((ValaCCodeBaseModule*) self)->gobject_type;
	if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, _tmp0_)) {
		return;
	}
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) cl);
	_tmp2_ = _tmp1_;
	vala_ccode_base_module_push_line ((ValaCCodeBaseModule*) self, _tmp2_);
	if (vala_gobject_module_class_has_readable_properties (self, cl)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) cl);
	}
	if (_tmp3_) {
		vala_gobject_module_add_get_property_function (self, cl);
	}
	if (vala_gobject_module_class_has_writable_properties (self, cl)) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) cl);
	}
	if (_tmp4_) {
		vala_gobject_module_add_set_property_function (self, cl);
	}
	vala_ccode_base_module_pop_line ((ValaCCodeBaseModule*) self);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally7:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_gobject_module_real_generate_class_init (ValaGTypeModule* base,
                                              ValaClass* cl)
{
	ValaGObjectModule * self;
	ValaTypeSymbol* _tmp0_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp20_ = FALSE;
	ValaConstructor* _tmp32_;
	ValaConstructor* _tmp33_;
	gboolean _tmp52_ = FALSE;
	ValaList* _tmp53_;
	ValaList* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	gboolean _tmp57_;
	ValaList* props = NULL;
	ValaList* _tmp225_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = ((ValaCCodeBaseModule*) self)->gobject_type;
	if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, _tmp0_)) {
		return;
	}
	_tmp1_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2_);
	_tmp4_ = _tmp3_;
	_vala_ccode_node_unref0 (_tmp2_);
	ccall = _tmp4_;
	_tmp5_ = ccall;
	_tmp6_ = vala_ccode_identifier_new ("klass");
	_tmp7_ = _tmp6_;
	vala_ccode_function_call_add_argument (_tmp5_, (ValaCCodeExpression*) _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	if (vala_gobject_module_class_has_readable_properties (self, cl)) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) cl);
	}
	if (_tmp8_) {
		ValaCCodeFunction* _tmp9_;
		ValaCCodeFunction* _tmp10_;
		ValaCCodeFunctionCall* _tmp11_;
		ValaCCodeMemberAccess* _tmp12_;
		ValaCCodeMemberAccess* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		ValaCCodeIdentifier* _tmp18_;
		ValaCCodeIdentifier* _tmp19_;
		_tmp9_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = ccall;
		_tmp12_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp11_, "get_property");
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("_vala_%s_get_property", _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_ccode_identifier_new (_tmp17_);
		_tmp19_ = _tmp18_;
		vala_ccode_function_add_assignment (_tmp10_, (ValaCCodeExpression*) _tmp13_, (ValaCCodeExpression*) _tmp19_);
		_vala_ccode_node_unref0 (_tmp19_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		_vala_ccode_node_unref0 (_tmp13_);
	}
	if (vala_gobject_module_class_has_writable_properties (self, cl)) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) cl);
	}
	if (_tmp20_) {
		ValaCCodeFunction* _tmp21_;
		ValaCCodeFunction* _tmp22_;
		ValaCCodeFunctionCall* _tmp23_;
		ValaCCodeMemberAccess* _tmp24_;
		ValaCCodeMemberAccess* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		ValaCCodeIdentifier* _tmp30_;
		ValaCCodeIdentifier* _tmp31_;
		_tmp21_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = ccall;
		_tmp24_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp23_, "set_property");
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf ("_vala_%s_set_property", _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_ccode_identifier_new (_tmp29_);
		_tmp31_ = _tmp30_;
		vala_ccode_function_add_assignment (_tmp22_, (ValaCCodeExpression*) _tmp25_, (ValaCCodeExpression*) _tmp31_);
		_vala_ccode_node_unref0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_vala_ccode_node_unref0 (_tmp25_);
	}
	_tmp32_ = vala_class_get_constructor (cl);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != NULL) {
		ValaCCodeFunctionCall* ccast = NULL;
		ValaCCodeIdentifier* _tmp34_;
		ValaCCodeIdentifier* _tmp35_;
		ValaCCodeFunctionCall* _tmp36_;
		ValaCCodeFunctionCall* _tmp37_;
		ValaCCodeFunctionCall* _tmp38_;
		ValaCCodeIdentifier* _tmp39_;
		ValaCCodeIdentifier* _tmp40_;
		ValaCCodeFunction* _tmp41_;
		ValaCCodeFunction* _tmp42_;
		ValaCCodeFunctionCall* _tmp43_;
		ValaCCodeMemberAccess* _tmp44_;
		ValaCCodeMemberAccess* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		ValaCCodeIdentifier* _tmp50_;
		ValaCCodeIdentifier* _tmp51_;
		_tmp34_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp35_);
		_tmp37_ = _tmp36_;
		_vala_ccode_node_unref0 (_tmp35_);
		ccast = _tmp37_;
		_tmp38_ = ccast;
		_tmp39_ = vala_ccode_identifier_new ("klass");
		_tmp40_ = _tmp39_;
		vala_ccode_function_call_add_argument (_tmp38_, (ValaCCodeExpression*) _tmp40_);
		_vala_ccode_node_unref0 (_tmp40_);
		_tmp41_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp42_ = _tmp41_;
		_tmp43_ = ccast;
		_tmp44_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp43_, "constructor");
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_strdup_printf ("%s_constructor", _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_ccode_identifier_new (_tmp49_);
		_tmp51_ = _tmp50_;
		vala_ccode_function_add_assignment (_tmp42_, (ValaCCodeExpression*) _tmp45_, (ValaCCodeExpression*) _tmp51_);
		_vala_ccode_node_unref0 (_tmp51_);
		_g_free0 (_tmp49_);
		_g_free0 (_tmp47_);
		_vala_ccode_node_unref0 (_tmp45_);
		_vala_ccode_node_unref0 (ccast);
	}
	_tmp53_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) cl);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_collection_get_size ((ValaCollection*) _tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = _tmp56_ > 0;
	_vala_iterable_unref0 (_tmp54_);
	if (_tmp57_) {
		_tmp52_ = TRUE;
	} else {
		ValaDestructor* _tmp58_;
		ValaDestructor* _tmp59_;
		_tmp58_ = vala_class_get_destructor (cl);
		_tmp59_ = _tmp58_;
		_tmp52_ = _tmp59_ != NULL;
	}
	if (_tmp52_) {
		ValaCCodeFunctionCall* ccast = NULL;
		ValaCCodeIdentifier* _tmp60_;
		ValaCCodeIdentifier* _tmp61_;
		ValaCCodeFunctionCall* _tmp62_;
		ValaCCodeFunctionCall* _tmp63_;
		ValaCCodeFunctionCall* _tmp64_;
		ValaCCodeIdentifier* _tmp65_;
		ValaCCodeIdentifier* _tmp66_;
		ValaCCodeFunction* _tmp67_;
		ValaCCodeFunction* _tmp68_;
		ValaCCodeFunctionCall* _tmp69_;
		ValaCCodeMemberAccess* _tmp70_;
		ValaCCodeMemberAccess* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		ValaCCodeIdentifier* _tmp76_;
		ValaCCodeIdentifier* _tmp77_;
		_tmp60_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp61_);
		_tmp63_ = _tmp62_;
		_vala_ccode_node_unref0 (_tmp61_);
		ccast = _tmp63_;
		_tmp64_ = ccast;
		_tmp65_ = vala_ccode_identifier_new ("klass");
		_tmp66_ = _tmp65_;
		vala_ccode_function_call_add_argument (_tmp64_, (ValaCCodeExpression*) _tmp66_);
		_vala_ccode_node_unref0 (_tmp66_);
		_tmp67_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp68_ = _tmp67_;
		_tmp69_ = ccast;
		_tmp70_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp69_, "finalize");
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
		_tmp73_ = _tmp72_;
		_tmp74_ = g_strdup_printf ("%s_finalize", _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_ccode_identifier_new (_tmp75_);
		_tmp77_ = _tmp76_;
		vala_ccode_function_add_assignment (_tmp68_, (ValaCCodeExpression*) _tmp71_, (ValaCCodeExpression*) _tmp77_);
		_vala_ccode_node_unref0 (_tmp77_);
		_g_free0 (_tmp75_);
		_g_free0 (_tmp73_);
		_vala_ccode_node_unref0 (_tmp71_);
		_vala_ccode_node_unref0 (ccast);
	}
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp78_;
		gint _type_param_size = 0;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _type_param_index = 0;
		_tmp78_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_type_param_list = _tmp78_;
		_tmp79_ = _type_param_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_type_param_size = _tmp81_;
		_type_param_index = -1;
		while (TRUE) {
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp82_;
			gpointer _tmp83_;
			gchar* func_name = NULL;
			gchar* enum_value = NULL;
			ValaCCodeConstant* func_name_constant = NULL;
			ValaCCodeFunctionCall* cinst = NULL;
			ValaCCodeFunctionCall* cspec = NULL;
			gchar* name_prefix = NULL;
			ValaTypeParameter* _tmp84_;
			const gchar* _tmp85_;
			const gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* canonical_prefix = NULL;
			const gchar* _tmp88_;
			gchar* _tmp89_;
			const gchar* _tmp90_;
			gchar* _tmp91_;
			const gchar* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			ValaCCodeConstant* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			const gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			ValaCCodeIdentifier* _tmp102_;
			ValaCCodeIdentifier* _tmp103_;
			ValaCCodeFunctionCall* _tmp104_;
			ValaCCodeFunctionCall* _tmp105_;
			ValaCCodeFunctionCall* _tmp106_;
			ValaCCodeFunctionCall* _tmp107_;
			const gchar* _tmp108_;
			ValaCCodeConstant* _tmp109_;
			ValaCCodeConstant* _tmp110_;
			ValaCCodeIdentifier* _tmp111_;
			ValaCCodeIdentifier* _tmp112_;
			ValaCCodeFunctionCall* _tmp113_;
			ValaCCodeFunctionCall* _tmp114_;
			ValaCCodeConstant* _tmp115_;
			ValaCCodeFunctionCall* _tmp116_;
			ValaCCodeConstant* _tmp117_;
			ValaCCodeConstant* _tmp118_;
			ValaCCodeFunctionCall* _tmp119_;
			ValaCCodeConstant* _tmp120_;
			ValaCCodeConstant* _tmp121_;
			ValaCCodeFunctionCall* _tmp122_;
			ValaCCodeIdentifier* _tmp123_;
			ValaCCodeIdentifier* _tmp124_;
			ValaCCodeFunctionCall* _tmp125_;
			ValaCCodeConstant* _tmp126_;
			ValaCCodeConstant* _tmp127_;
			ValaCCodeFunctionCall* _tmp128_;
			ValaCCodeFunctionCall* _tmp129_;
			ValaCCodeFunction* _tmp130_;
			ValaCCodeFunction* _tmp131_;
			ValaCCodeFunctionCall* _tmp132_;
			ValaCCodeEnum* _tmp133_;
			const gchar* _tmp134_;
			ValaCCodeEnumValue* _tmp135_;
			ValaCCodeEnumValue* _tmp136_;
			const gchar* _tmp137_;
			gchar* _tmp138_;
			const gchar* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			ValaCCodeConstant* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			const gchar* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			gchar* _tmp148_;
			ValaCCodeIdentifier* _tmp149_;
			ValaCCodeIdentifier* _tmp150_;
			ValaCCodeFunctionCall* _tmp151_;
			ValaCCodeFunctionCall* _tmp152_;
			ValaCCodeFunctionCall* _tmp153_;
			ValaCCodeFunctionCall* _tmp154_;
			const gchar* _tmp155_;
			ValaCCodeConstant* _tmp156_;
			ValaCCodeConstant* _tmp157_;
			ValaCCodeIdentifier* _tmp158_;
			ValaCCodeIdentifier* _tmp159_;
			ValaCCodeFunctionCall* _tmp160_;
			ValaCCodeFunctionCall* _tmp161_;
			ValaCCodeConstant* _tmp162_;
			ValaCCodeFunctionCall* _tmp163_;
			ValaCCodeConstant* _tmp164_;
			ValaCCodeConstant* _tmp165_;
			ValaCCodeFunctionCall* _tmp166_;
			ValaCCodeConstant* _tmp167_;
			ValaCCodeConstant* _tmp168_;
			ValaCCodeFunctionCall* _tmp169_;
			ValaCCodeConstant* _tmp170_;
			ValaCCodeConstant* _tmp171_;
			ValaCCodeFunctionCall* _tmp172_;
			ValaCCodeFunctionCall* _tmp173_;
			ValaCCodeFunction* _tmp174_;
			ValaCCodeFunction* _tmp175_;
			ValaCCodeFunctionCall* _tmp176_;
			ValaCCodeEnum* _tmp177_;
			const gchar* _tmp178_;
			ValaCCodeEnumValue* _tmp179_;
			ValaCCodeEnumValue* _tmp180_;
			const gchar* _tmp181_;
			gchar* _tmp182_;
			const gchar* _tmp183_;
			gchar* _tmp184_;
			gchar* _tmp185_;
			ValaCCodeConstant* _tmp186_;
			gchar* _tmp187_;
			gchar* _tmp188_;
			const gchar* _tmp189_;
			gchar* _tmp190_;
			gchar* _tmp191_;
			gchar* _tmp192_;
			ValaCCodeIdentifier* _tmp193_;
			ValaCCodeIdentifier* _tmp194_;
			ValaCCodeFunctionCall* _tmp195_;
			ValaCCodeFunctionCall* _tmp196_;
			ValaCCodeFunctionCall* _tmp197_;
			ValaCCodeFunctionCall* _tmp198_;
			const gchar* _tmp199_;
			ValaCCodeConstant* _tmp200_;
			ValaCCodeConstant* _tmp201_;
			ValaCCodeIdentifier* _tmp202_;
			ValaCCodeIdentifier* _tmp203_;
			ValaCCodeFunctionCall* _tmp204_;
			ValaCCodeFunctionCall* _tmp205_;
			ValaCCodeConstant* _tmp206_;
			ValaCCodeFunctionCall* _tmp207_;
			ValaCCodeConstant* _tmp208_;
			ValaCCodeConstant* _tmp209_;
			ValaCCodeFunctionCall* _tmp210_;
			ValaCCodeConstant* _tmp211_;
			ValaCCodeConstant* _tmp212_;
			ValaCCodeFunctionCall* _tmp213_;
			ValaCCodeConstant* _tmp214_;
			ValaCCodeConstant* _tmp215_;
			ValaCCodeFunctionCall* _tmp216_;
			ValaCCodeFunctionCall* _tmp217_;
			ValaCCodeFunction* _tmp218_;
			ValaCCodeFunction* _tmp219_;
			ValaCCodeFunctionCall* _tmp220_;
			ValaCCodeEnum* _tmp221_;
			const gchar* _tmp222_;
			ValaCCodeEnumValue* _tmp223_;
			ValaCCodeEnumValue* _tmp224_;
			_type_param_index = _type_param_index + 1;
			if (!(_type_param_index < _type_param_size)) {
				break;
			}
			_tmp82_ = _type_param_list;
			_tmp83_ = vala_list_get (_tmp82_, _type_param_index);
			type_param = (ValaTypeParameter*) _tmp83_;
			_tmp84_ = type_param;
			_tmp85_ = vala_symbol_get_name ((ValaSymbol*) _tmp84_);
			_tmp86_ = _tmp85_;
			_tmp87_ = g_utf8_strdown (_tmp86_, (gssize) -1);
			name_prefix = _tmp87_;
			_tmp88_ = name_prefix;
			_tmp89_ = string_replace (_tmp88_, "_", "-");
			canonical_prefix = _tmp89_;
			_tmp90_ = name_prefix;
			_tmp91_ = g_strdup_printf ("%s_type", _tmp90_);
			_g_free0 (func_name);
			func_name = _tmp91_;
			_tmp92_ = canonical_prefix;
			_tmp93_ = g_strdup_printf ("\"%s-type\"", _tmp92_);
			_tmp94_ = _tmp93_;
			_tmp95_ = vala_ccode_constant_new (_tmp94_);
			_vala_ccode_node_unref0 (func_name_constant);
			func_name_constant = _tmp95_;
			_g_free0 (_tmp94_);
			_tmp96_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp97_ = _tmp96_;
			_tmp98_ = func_name;
			_tmp99_ = g_strdup_printf ("%s_%s", _tmp97_, _tmp98_);
			_tmp100_ = _tmp99_;
			_tmp101_ = g_ascii_strup (_tmp100_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp101_;
			_g_free0 (_tmp100_);
			_g_free0 (_tmp97_);
			_tmp102_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp103_ = _tmp102_;
			_tmp104_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp103_);
			_vala_ccode_node_unref0 (cinst);
			cinst = _tmp104_;
			_vala_ccode_node_unref0 (_tmp103_);
			_tmp105_ = cinst;
			_tmp106_ = ccall;
			vala_ccode_function_call_add_argument (_tmp105_, (ValaCCodeExpression*) _tmp106_);
			_tmp107_ = cinst;
			_tmp108_ = enum_value;
			_tmp109_ = vala_ccode_constant_new (_tmp108_);
			_tmp110_ = _tmp109_;
			vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp110_);
			_vala_ccode_node_unref0 (_tmp110_);
			_tmp111_ = vala_ccode_identifier_new ("g_param_spec_gtype");
			_tmp112_ = _tmp111_;
			_tmp113_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp112_);
			_vala_ccode_node_unref0 (cspec);
			cspec = _tmp113_;
			_vala_ccode_node_unref0 (_tmp112_);
			_tmp114_ = cspec;
			_tmp115_ = func_name_constant;
			vala_ccode_function_call_add_argument (_tmp114_, (ValaCCodeExpression*) _tmp115_);
			_tmp116_ = cspec;
			_tmp117_ = vala_ccode_constant_new ("\"type\"");
			_tmp118_ = _tmp117_;
			vala_ccode_function_call_add_argument (_tmp116_, (ValaCCodeExpression*) _tmp118_);
			_vala_ccode_node_unref0 (_tmp118_);
			_tmp119_ = cspec;
			_tmp120_ = vala_ccode_constant_new ("\"type\"");
			_tmp121_ = _tmp120_;
			vala_ccode_function_call_add_argument (_tmp119_, (ValaCCodeExpression*) _tmp121_);
			_vala_ccode_node_unref0 (_tmp121_);
			_tmp122_ = cspec;
			_tmp123_ = vala_ccode_identifier_new ("G_TYPE_NONE");
			_tmp124_ = _tmp123_;
			vala_ccode_function_call_add_argument (_tmp122_, (ValaCCodeExpression*) _tmp124_);
			_vala_ccode_node_unref0 (_tmp124_);
			_tmp125_ = cspec;
			_tmp126_ = vala_ccode_constant_new ("G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY");
			_tmp127_ = _tmp126_;
			vala_ccode_function_call_add_argument (_tmp125_, (ValaCCodeExpression*) _tmp127_);
			_vala_ccode_node_unref0 (_tmp127_);
			_tmp128_ = cinst;
			_tmp129_ = cspec;
			vala_ccode_function_call_add_argument (_tmp128_, (ValaCCodeExpression*) _tmp129_);
			_tmp130_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp131_ = _tmp130_;
			_tmp132_ = cinst;
			vala_ccode_function_add_expression (_tmp131_, (ValaCCodeExpression*) _tmp132_);
			_tmp133_ = ((ValaCCodeBaseModule*) self)->prop_enum;
			_tmp134_ = enum_value;
			_tmp135_ = vala_ccode_enum_value_new (_tmp134_, NULL);
			_tmp136_ = _tmp135_;
			vala_ccode_enum_add_value (_tmp133_, _tmp136_);
			_vala_ccode_node_unref0 (_tmp136_);
			_tmp137_ = name_prefix;
			_tmp138_ = g_strdup_printf ("%s_dup_func", _tmp137_);
			_g_free0 (func_name);
			func_name = _tmp138_;
			_tmp139_ = canonical_prefix;
			_tmp140_ = g_strdup_printf ("\"%s-dup-func\"", _tmp139_);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_ccode_constant_new (_tmp141_);
			_vala_ccode_node_unref0 (func_name_constant);
			func_name_constant = _tmp142_;
			_g_free0 (_tmp141_);
			_tmp143_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp144_ = _tmp143_;
			_tmp145_ = func_name;
			_tmp146_ = g_strdup_printf ("%s_%s", _tmp144_, _tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = g_ascii_strup (_tmp147_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp148_;
			_g_free0 (_tmp147_);
			_g_free0 (_tmp144_);
			_tmp149_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp150_);
			_vala_ccode_node_unref0 (cinst);
			cinst = _tmp151_;
			_vala_ccode_node_unref0 (_tmp150_);
			_tmp152_ = cinst;
			_tmp153_ = ccall;
			vala_ccode_function_call_add_argument (_tmp152_, (ValaCCodeExpression*) _tmp153_);
			_tmp154_ = cinst;
			_tmp155_ = enum_value;
			_tmp156_ = vala_ccode_constant_new (_tmp155_);
			_tmp157_ = _tmp156_;
			vala_ccode_function_call_add_argument (_tmp154_, (ValaCCodeExpression*) _tmp157_);
			_vala_ccode_node_unref0 (_tmp157_);
			_tmp158_ = vala_ccode_identifier_new ("g_param_spec_pointer");
			_tmp159_ = _tmp158_;
			_tmp160_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp159_);
			_vala_ccode_node_unref0 (cspec);
			cspec = _tmp160_;
			_vala_ccode_node_unref0 (_tmp159_);
			_tmp161_ = cspec;
			_tmp162_ = func_name_constant;
			vala_ccode_function_call_add_argument (_tmp161_, (ValaCCodeExpression*) _tmp162_);
			_tmp163_ = cspec;
			_tmp164_ = vala_ccode_constant_new ("\"dup func\"");
			_tmp165_ = _tmp164_;
			vala_ccode_function_call_add_argument (_tmp163_, (ValaCCodeExpression*) _tmp165_);
			_vala_ccode_node_unref0 (_tmp165_);
			_tmp166_ = cspec;
			_tmp167_ = vala_ccode_constant_new ("\"dup func\"");
			_tmp168_ = _tmp167_;
			vala_ccode_function_call_add_argument (_tmp166_, (ValaCCodeExpression*) _tmp168_);
			_vala_ccode_node_unref0 (_tmp168_);
			_tmp169_ = cspec;
			_tmp170_ = vala_ccode_constant_new ("G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY");
			_tmp171_ = _tmp170_;
			vala_ccode_function_call_add_argument (_tmp169_, (ValaCCodeExpression*) _tmp171_);
			_vala_ccode_node_unref0 (_tmp171_);
			_tmp172_ = cinst;
			_tmp173_ = cspec;
			vala_ccode_function_call_add_argument (_tmp172_, (ValaCCodeExpression*) _tmp173_);
			_tmp174_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp175_ = _tmp174_;
			_tmp176_ = cinst;
			vala_ccode_function_add_expression (_tmp175_, (ValaCCodeExpression*) _tmp176_);
			_tmp177_ = ((ValaCCodeBaseModule*) self)->prop_enum;
			_tmp178_ = enum_value;
			_tmp179_ = vala_ccode_enum_value_new (_tmp178_, NULL);
			_tmp180_ = _tmp179_;
			vala_ccode_enum_add_value (_tmp177_, _tmp180_);
			_vala_ccode_node_unref0 (_tmp180_);
			_tmp181_ = name_prefix;
			_tmp182_ = g_strdup_printf ("%s_destroy_func", _tmp181_);
			_g_free0 (func_name);
			func_name = _tmp182_;
			_tmp183_ = canonical_prefix;
			_tmp184_ = g_strdup_printf ("\"%s-destroy-func\"", _tmp183_);
			_tmp185_ = _tmp184_;
			_tmp186_ = vala_ccode_constant_new (_tmp185_);
			_vala_ccode_node_unref0 (func_name_constant);
			func_name_constant = _tmp186_;
			_g_free0 (_tmp185_);
			_tmp187_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp188_ = _tmp187_;
			_tmp189_ = func_name;
			_tmp190_ = g_strdup_printf ("%s_%s", _tmp188_, _tmp189_);
			_tmp191_ = _tmp190_;
			_tmp192_ = g_ascii_strup (_tmp191_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp192_;
			_g_free0 (_tmp191_);
			_g_free0 (_tmp188_);
			_tmp193_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp194_ = _tmp193_;
			_tmp195_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp194_);
			_vala_ccode_node_unref0 (cinst);
			cinst = _tmp195_;
			_vala_ccode_node_unref0 (_tmp194_);
			_tmp196_ = cinst;
			_tmp197_ = ccall;
			vala_ccode_function_call_add_argument (_tmp196_, (ValaCCodeExpression*) _tmp197_);
			_tmp198_ = cinst;
			_tmp199_ = enum_value;
			_tmp200_ = vala_ccode_constant_new (_tmp199_);
			_tmp201_ = _tmp200_;
			vala_ccode_function_call_add_argument (_tmp198_, (ValaCCodeExpression*) _tmp201_);
			_vala_ccode_node_unref0 (_tmp201_);
			_tmp202_ = vala_ccode_identifier_new ("g_param_spec_pointer");
			_tmp203_ = _tmp202_;
			_tmp204_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp203_);
			_vala_ccode_node_unref0 (cspec);
			cspec = _tmp204_;
			_vala_ccode_node_unref0 (_tmp203_);
			_tmp205_ = cspec;
			_tmp206_ = func_name_constant;
			vala_ccode_function_call_add_argument (_tmp205_, (ValaCCodeExpression*) _tmp206_);
			_tmp207_ = cspec;
			_tmp208_ = vala_ccode_constant_new ("\"destroy func\"");
			_tmp209_ = _tmp208_;
			vala_ccode_function_call_add_argument (_tmp207_, (ValaCCodeExpression*) _tmp209_);
			_vala_ccode_node_unref0 (_tmp209_);
			_tmp210_ = cspec;
			_tmp211_ = vala_ccode_constant_new ("\"destroy func\"");
			_tmp212_ = _tmp211_;
			vala_ccode_function_call_add_argument (_tmp210_, (ValaCCodeExpression*) _tmp212_);
			_vala_ccode_node_unref0 (_tmp212_);
			_tmp213_ = cspec;
			_tmp214_ = vala_ccode_constant_new ("G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY");
			_tmp215_ = _tmp214_;
			vala_ccode_function_call_add_argument (_tmp213_, (ValaCCodeExpression*) _tmp215_);
			_vala_ccode_node_unref0 (_tmp215_);
			_tmp216_ = cinst;
			_tmp217_ = cspec;
			vala_ccode_function_call_add_argument (_tmp216_, (ValaCCodeExpression*) _tmp217_);
			_tmp218_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp219_ = _tmp218_;
			_tmp220_ = cinst;
			vala_ccode_function_add_expression (_tmp219_, (ValaCCodeExpression*) _tmp220_);
			_tmp221_ = ((ValaCCodeBaseModule*) self)->prop_enum;
			_tmp222_ = enum_value;
			_tmp223_ = vala_ccode_enum_value_new (_tmp222_, NULL);
			_tmp224_ = _tmp223_;
			vala_ccode_enum_add_value (_tmp221_, _tmp224_);
			_vala_ccode_node_unref0 (_tmp224_);
			_g_free0 (canonical_prefix);
			_g_free0 (name_prefix);
			_vala_ccode_node_unref0 (cspec);
			_vala_ccode_node_unref0 (cinst);
			_vala_ccode_node_unref0 (func_name_constant);
			_g_free0 (enum_value);
			_g_free0 (func_name);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	_tmp225_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	props = _tmp225_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp226_;
		ValaList* _tmp227_;
		gint _prop_size = 0;
		ValaList* _tmp228_;
		gint _tmp229_;
		gint _tmp230_;
		gint _prop_index = 0;
		_tmp226_ = props;
		_tmp227_ = _vala_iterable_ref0 (_tmp226_);
		_prop_list = _tmp227_;
		_tmp228_ = _prop_list;
		_tmp229_ = vala_collection_get_size ((ValaCollection*) _tmp228_);
		_tmp230_ = _tmp229_;
		_prop_size = _tmp230_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp231_;
			gpointer _tmp232_;
			ValaCodeContext* _tmp233_;
			ValaCodeContext* _tmp234_;
			ValaSemanticAnalyzer* _tmp235_;
			ValaSemanticAnalyzer* _tmp236_;
			ValaProperty* _tmp237_;
			ValaProperty* _tmp255_;
			ValaComment* _tmp256_;
			ValaComment* _tmp257_;
			ValaCCodeFunctionCall* cinst = NULL;
			ValaCCodeIdentifier* _tmp267_;
			ValaCCodeIdentifier* _tmp268_;
			ValaCCodeFunctionCall* _tmp269_;
			ValaCCodeFunctionCall* _tmp270_;
			ValaCCodeFunctionCall* _tmp271_;
			ValaCCodeFunctionCall* _tmp272_;
			ValaCCodeFunctionCall* _tmp273_;
			ValaProperty* _tmp274_;
			gchar* _tmp275_;
			gchar* _tmp276_;
			gchar* _tmp277_;
			gchar* _tmp278_;
			ValaCCodeConstant* _tmp279_;
			ValaCCodeConstant* _tmp280_;
			ValaCCodeFunctionCall* _tmp281_;
			ValaProperty* _tmp282_;
			ValaCCodeExpression* _tmp283_;
			ValaCCodeExpression* _tmp284_;
			ValaCCodeFunction* _tmp285_;
			ValaCCodeFunction* _tmp286_;
			ValaCCodeFunctionCall* _tmp287_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp231_ = _prop_list;
			_tmp232_ = vala_list_get (_tmp231_, _prop_index);
			prop = (ValaProperty*) _tmp232_;
			_tmp233_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp234_ = _tmp233_;
			_tmp235_ = vala_code_context_get_analyzer (_tmp234_);
			_tmp236_ = _tmp235_;
			_tmp237_ = prop;
			if (!vala_semantic_analyzer_is_gobject_property (_tmp236_, _tmp237_)) {
				ValaCodeContext* _tmp238_;
				ValaCodeContext* _tmp239_;
				ValaSemanticAnalyzer* _tmp240_;
				ValaSemanticAnalyzer* _tmp241_;
				ValaProperty* _tmp242_;
				ValaDataType* _tmp243_;
				ValaDataType* _tmp244_;
				_tmp238_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp239_ = _tmp238_;
				_tmp240_ = vala_code_context_get_analyzer (_tmp239_);
				_tmp241_ = _tmp240_;
				_tmp242_ = prop;
				_tmp243_ = vala_property_get_property_type (_tmp242_);
				_tmp244_ = _tmp243_;
				if (!vala_semantic_analyzer_is_gobject_property_type (_tmp241_, _tmp244_)) {
					ValaProperty* _tmp245_;
					ValaSourceReference* _tmp246_;
					ValaSourceReference* _tmp247_;
					ValaProperty* _tmp248_;
					ValaDataType* _tmp249_;
					ValaDataType* _tmp250_;
					gchar* _tmp251_;
					gchar* _tmp252_;
					gchar* _tmp253_;
					gchar* _tmp254_;
					_tmp245_ = prop;
					_tmp246_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp245_);
					_tmp247_ = _tmp246_;
					_tmp248_ = prop;
					_tmp249_ = vala_property_get_property_type (_tmp248_);
					_tmp250_ = _tmp249_;
					_tmp251_ = vala_data_type_to_qualified_string (_tmp250_, NULL);
					_tmp252_ = _tmp251_;
					_tmp253_ = g_strdup_printf ("Type `%s' can not be used for a GLib.Object property", _tmp252_);
					_tmp254_ = _tmp253_;
					vala_report_warning (_tmp247_, _tmp254_);
					_g_free0 (_tmp254_);
					_g_free0 (_tmp252_);
				}
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp255_ = prop;
			_tmp256_ = vala_symbol_get_comment ((ValaSymbol*) _tmp255_);
			_tmp257_ = _tmp256_;
			if (_tmp257_ != NULL) {
				ValaCCodeFunction* _tmp258_;
				ValaCCodeFunction* _tmp259_;
				ValaProperty* _tmp260_;
				ValaComment* _tmp261_;
				ValaComment* _tmp262_;
				const gchar* _tmp263_;
				const gchar* _tmp264_;
				ValaCCodeComment* _tmp265_;
				ValaCCodeComment* _tmp266_;
				_tmp258_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp259_ = _tmp258_;
				_tmp260_ = prop;
				_tmp261_ = vala_symbol_get_comment ((ValaSymbol*) _tmp260_);
				_tmp262_ = _tmp261_;
				_tmp263_ = vala_comment_get_content (_tmp262_);
				_tmp264_ = _tmp263_;
				_tmp265_ = vala_ccode_comment_new (_tmp264_);
				_tmp266_ = _tmp265_;
				vala_ccode_function_add_statement (_tmp259_, (ValaCCodeNode*) _tmp266_);
				_vala_ccode_node_unref0 (_tmp266_);
			}
			_tmp267_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp268_ = _tmp267_;
			_tmp269_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp268_);
			_tmp270_ = _tmp269_;
			_vala_ccode_node_unref0 (_tmp268_);
			cinst = _tmp270_;
			_tmp271_ = cinst;
			_tmp272_ = ccall;
			vala_ccode_function_call_add_argument (_tmp271_, (ValaCCodeExpression*) _tmp272_);
			_tmp273_ = cinst;
			_tmp274_ = prop;
			_tmp275_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp274_, NULL);
			_tmp276_ = _tmp275_;
			_tmp277_ = g_strdup_printf ("%s_PROPERTY", _tmp276_);
			_tmp278_ = _tmp277_;
			_tmp279_ = vala_ccode_constant_new (_tmp278_);
			_tmp280_ = _tmp279_;
			vala_ccode_function_call_add_argument (_tmp273_, (ValaCCodeExpression*) _tmp280_);
			_vala_ccode_node_unref0 (_tmp280_);
			_g_free0 (_tmp278_);
			_g_free0 (_tmp276_);
			_tmp281_ = cinst;
			_tmp282_ = prop;
			_tmp283_ = vala_ccode_base_module_get_param_spec ((ValaCCodeBaseModule*) self, _tmp282_);
			_tmp284_ = _tmp283_;
			vala_ccode_function_call_add_argument (_tmp281_, _tmp284_);
			_vala_ccode_node_unref0 (_tmp284_);
			_tmp285_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp286_ = _tmp285_;
			_tmp287_ = cinst;
			vala_ccode_function_add_expression (_tmp286_, (ValaCCodeExpression*) _tmp287_);
			_vala_ccode_node_unref0 (cinst);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_vala_iterable_unref0 (props);
	_vala_ccode_node_unref0 (ccall);
}

static gboolean
vala_gobject_module_class_has_readable_properties (ValaGObjectModule* self,
                                                   ValaClass* cl)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp0_;
		gint _prop_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prop_index = 0;
		_tmp0_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
		_prop_list = _tmp0_;
		_tmp1_ = _prop_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prop_size = _tmp3_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaProperty* _tmp6_;
			ValaPropertyAccessor* _tmp7_;
			ValaPropertyAccessor* _tmp8_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp4_ = _prop_list;
			_tmp5_ = vala_list_get (_tmp4_, _prop_index);
			prop = (ValaProperty*) _tmp5_;
			_tmp6_ = prop;
			_tmp7_ = vala_property_get_get_accessor (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_ != NULL) {
				result = TRUE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				return result;
			}
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	result = FALSE;
	return result;
}

static gboolean
vala_gobject_module_class_has_writable_properties (ValaGObjectModule* self,
                                                   ValaClass* cl)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp0_;
		gint _prop_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prop_index = 0;
		_tmp0_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
		_prop_list = _tmp0_;
		_tmp1_ = _prop_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prop_size = _tmp3_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaProperty* _tmp6_;
			ValaPropertyAccessor* _tmp7_;
			ValaPropertyAccessor* _tmp8_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp4_ = _prop_list;
			_tmp5_ = vala_list_get (_tmp4_, _prop_index);
			prop = (ValaProperty*) _tmp5_;
			_tmp6_ = prop;
			_tmp7_ = vala_property_get_set_accessor (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_ != NULL) {
				result = TRUE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				return result;
			}
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	result = FALSE;
	return result;
}

static void
vala_gobject_module_add_guarded_expression (ValaGObjectModule* self,
                                            ValaSymbol* sym,
                                            ValaCCodeExpression* expression)
{
	ValaVersionAttribute* _tmp0_;
	ValaVersionAttribute* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (expression != NULL);
	_tmp0_ = vala_symbol_get_version (sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_version_attribute_get_deprecated (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		ValaCCodeGGnucSection* guard = NULL;
		ValaCCodeGGnucSection* _tmp4_;
		ValaCCodeFunction* _tmp5_;
		ValaCCodeFunction* _tmp6_;
		ValaCCodeGGnucSection* _tmp7_;
		ValaCCodeGGnucSection* _tmp8_;
		ValaCCodeExpressionStatement* _tmp9_;
		ValaCCodeExpressionStatement* _tmp10_;
		_tmp4_ = vala_ccode_ggnuc_section_new (VALA_GGNUC_SECTION_TYPE_IGNORE_DEPRECATIONS);
		guard = _tmp4_;
		_tmp5_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = guard;
		vala_ccode_function_add_statement (_tmp6_, (ValaCCodeNode*) _tmp7_);
		_tmp8_ = guard;
		_tmp9_ = vala_ccode_expression_statement_new (expression);
		_tmp10_ = _tmp9_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp8_, (ValaCCodeNode*) _tmp10_);
		_vala_ccode_node_unref0 (_tmp10_);
		_vala_ccode_node_unref0 (guard);
	} else {
		ValaCCodeFunction* _tmp11_;
		ValaCCodeFunction* _tmp12_;
		_tmp11_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp12_ = _tmp11_;
		vala_ccode_function_add_expression (_tmp12_, expression);
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_gobject_module_add_get_property_function (ValaGObjectModule* self,
                                               ValaClass* cl)
{
	ValaCCodeFunction* get_prop = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeFunction* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeParameter* _tmp8_;
	ValaCCodeParameter* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeParameter* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeParameter* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeFunction* _tmp19_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeFunction* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeVariableDeclarator* _tmp31_;
	ValaCCodeVariableDeclarator* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeIdentifier* _tmp36_;
	ValaList* props = NULL;
	ValaList* _tmp37_;
	ValaCCodeFunction* _tmp411_;
	ValaCCodeFunction* _tmp412_;
	ValaCCodeFunction* _tmp413_;
	ValaCCodeFunction* _tmp414_;
	ValaCCodeFunction* _tmp415_;
	ValaCCodeFunction* _tmp416_;
	ValaCCodeFile* _tmp417_;
	ValaCCodeFunction* _tmp418_;
	ValaCCodeFile* _tmp419_;
	ValaCCodeFunction* _tmp420_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_vala_%s_get_property", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_new (_tmp3_, "void");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	get_prop = _tmp5_;
	_tmp6_ = get_prop;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp6_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp7_ = get_prop;
	_tmp8_ = vala_ccode_parameter_new ("object", "GObject *");
	_tmp9_ = _tmp8_;
	vala_ccode_function_add_parameter (_tmp7_, _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = get_prop;
	_tmp11_ = vala_ccode_parameter_new ("property_id", "guint");
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp10_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_tmp13_ = get_prop;
	_tmp14_ = vala_ccode_parameter_new ("value", "GValue *");
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_parameter (_tmp13_, _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = get_prop;
	_tmp17_ = vala_ccode_parameter_new ("pspec", "GParamSpec *");
	_tmp18_ = _tmp17_;
	vala_ccode_function_add_parameter (_tmp16_, _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = get_prop;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp19_);
	_tmp20_ = vala_ccode_identifier_new ("object");
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_base_module_generate_instance_cast ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) _tmp21_, (ValaTypeSymbol*) cl);
	_tmp23_ = _tmp22_;
	_vala_ccode_node_unref0 (_tmp21_);
	ccall = _tmp23_;
	_tmp24_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_get_ccode_name ((ValaCodeNode*) cl);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strdup_printf ("%s *", _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = ccall;
	_tmp31_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	vala_ccode_function_add_declaration (_tmp25_, _tmp29_, (ValaCCodeDeclarator*) _tmp32_, 0);
	_vala_ccode_node_unref0 (_tmp32_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_ccode_identifier_new ("property_id");
	_tmp36_ = _tmp35_;
	vala_ccode_function_open_switch (_tmp34_, (ValaCCodeExpression*) _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	_tmp37_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	props = _tmp37_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp38_;
		ValaList* _tmp39_;
		gint _prop_size = 0;
		ValaList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _prop_index = 0;
		_tmp38_ = props;
		_tmp39_ = _vala_iterable_ref0 (_tmp38_);
		_prop_list = _tmp39_;
		_tmp40_ = _prop_list;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_prop_size = _tmp42_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp43_;
			gpointer _tmp44_;
			gboolean _tmp45_ = FALSE;
			ValaProperty* _tmp46_;
			ValaPropertyAccessor* _tmp47_;
			ValaPropertyAccessor* _tmp48_;
			ValaCodeContext* _tmp52_;
			ValaCodeContext* _tmp53_;
			ValaSemanticAnalyzer* _tmp54_;
			ValaSemanticAnalyzer* _tmp55_;
			ValaProperty* _tmp56_;
			ValaProperty* base_prop = NULL;
			ValaProperty* _tmp57_;
			ValaProperty* _tmp58_;
			ValaCCodeExpression* cself = NULL;
			ValaCCodeIdentifier* _tmp59_;
			ValaProperty* _tmp60_;
			ValaProperty* _tmp61_;
			ValaProperty* _tmp62_;
			ValaCCodeExpression* cfunc = NULL;
			gboolean _tmp122_ = FALSE;
			ValaProperty* _tmp123_;
			ValaCCodeFunction* _tmp137_;
			ValaCCodeFunction* _tmp138_;
			ValaProperty* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			ValaCCodeIdentifier* _tmp144_;
			ValaCCodeIdentifier* _tmp145_;
			ValaProperty* _tmp146_;
			ValaDataType* _tmp147_;
			ValaDataType* _tmp148_;
			ValaCCodeFunction* _tmp295_;
			ValaCCodeFunction* _tmp296_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp43_ = _prop_list;
			_tmp44_ = vala_list_get (_tmp43_, _prop_index);
			prop = (ValaProperty*) _tmp44_;
			_tmp46_ = prop;
			_tmp47_ = vala_property_get_get_accessor (_tmp46_);
			_tmp48_ = _tmp47_;
			if (_tmp48_ == NULL) {
				_tmp45_ = TRUE;
			} else {
				ValaProperty* _tmp49_;
				gboolean _tmp50_;
				gboolean _tmp51_;
				_tmp49_ = prop;
				_tmp50_ = vala_property_get_is_abstract (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp45_ = _tmp51_;
			}
			if (_tmp45_) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp52_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_code_context_get_analyzer (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = prop;
			if (!vala_semantic_analyzer_is_gobject_property (_tmp55_, _tmp56_)) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp57_ = prop;
			_tmp58_ = _vala_code_node_ref0 (_tmp57_);
			base_prop = _tmp58_;
			_tmp59_ = vala_ccode_identifier_new ("self");
			cself = (ValaCCodeExpression*) _tmp59_;
			_tmp60_ = prop;
			_tmp61_ = vala_property_get_base_property (_tmp60_);
			_tmp62_ = _tmp61_;
			if (_tmp62_ != NULL) {
				ValaClass* base_type = NULL;
				ValaProperty* _tmp63_;
				ValaProperty* _tmp64_;
				ValaProperty* _tmp65_;
				ValaSymbol* _tmp66_;
				ValaSymbol* _tmp67_;
				ValaClass* _tmp68_;
				ValaProperty* _tmp69_;
				ValaProperty* _tmp70_;
				ValaProperty* _tmp71_;
				ValaProperty* _tmp72_;
				ValaObjectType* _tmp73_;
				ValaObjectType* _tmp74_;
				ValaCCodeExpression* _tmp75_;
				ValaGLibValue* _tmp76_;
				ValaGLibValue* _tmp77_;
				ValaClass* _tmp78_;
				ValaObjectType* _tmp79_;
				ValaObjectType* _tmp80_;
				ValaProperty* _tmp81_;
				ValaTargetValue* _tmp82_;
				ValaTargetValue* _tmp83_;
				ValaCCodeExpression* _tmp84_;
				ValaProperty* _tmp85_;
				ValaProperty* _tmp86_;
				ValaProperty* _tmp87_;
				ValaPropertyAccessor* _tmp88_;
				ValaPropertyAccessor* _tmp89_;
				ValaCCodeFile* _tmp90_;
				_tmp63_ = prop;
				_tmp64_ = vala_property_get_base_property (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_CLASS, ValaClass));
				base_type = _tmp68_;
				_tmp69_ = prop;
				_tmp70_ = vala_property_get_base_property (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = _vala_code_node_ref0 (_tmp71_);
				_vala_code_node_unref0 (base_prop);
				base_prop = _tmp72_;
				_tmp73_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
				_tmp74_ = _tmp73_;
				_tmp75_ = cself;
				_tmp76_ = vala_glib_value_new ((ValaDataType*) _tmp74_, _tmp75_, TRUE);
				_tmp77_ = _tmp76_;
				_tmp78_ = base_type;
				_tmp79_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = prop;
				_tmp82_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp77_, (ValaDataType*) _tmp80_, (ValaCodeNode*) _tmp81_);
				_tmp83_ = _tmp82_;
				_tmp84_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp83_);
				_vala_ccode_node_unref0 (cself);
				cself = _tmp84_;
				_vala_target_value_unref0 (_tmp83_);
				_vala_code_node_unref0 (_tmp80_);
				_vala_target_value_unref0 (_tmp77_);
				_vala_code_node_unref0 (_tmp74_);
				_tmp85_ = prop;
				_tmp86_ = vala_property_get_base_property (_tmp85_);
				_tmp87_ = _tmp86_;
				_tmp88_ = vala_property_get_get_accessor (_tmp87_);
				_tmp89_ = _tmp88_;
				_tmp90_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp89_, _tmp90_);
				_vala_code_node_unref0 (base_type);
			} else {
				ValaProperty* _tmp91_;
				ValaProperty* _tmp92_;
				ValaProperty* _tmp93_;
				_tmp91_ = prop;
				_tmp92_ = vala_property_get_base_interface_property (_tmp91_);
				_tmp93_ = _tmp92_;
				if (_tmp93_ != NULL) {
					ValaInterface* base_type = NULL;
					ValaProperty* _tmp94_;
					ValaProperty* _tmp95_;
					ValaProperty* _tmp96_;
					ValaSymbol* _tmp97_;
					ValaSymbol* _tmp98_;
					ValaInterface* _tmp99_;
					ValaProperty* _tmp100_;
					ValaProperty* _tmp101_;
					ValaProperty* _tmp102_;
					ValaProperty* _tmp103_;
					ValaObjectType* _tmp104_;
					ValaObjectType* _tmp105_;
					ValaCCodeExpression* _tmp106_;
					ValaGLibValue* _tmp107_;
					ValaGLibValue* _tmp108_;
					ValaInterface* _tmp109_;
					ValaObjectType* _tmp110_;
					ValaObjectType* _tmp111_;
					ValaProperty* _tmp112_;
					ValaTargetValue* _tmp113_;
					ValaTargetValue* _tmp114_;
					ValaCCodeExpression* _tmp115_;
					ValaProperty* _tmp116_;
					ValaProperty* _tmp117_;
					ValaProperty* _tmp118_;
					ValaPropertyAccessor* _tmp119_;
					ValaPropertyAccessor* _tmp120_;
					ValaCCodeFile* _tmp121_;
					_tmp94_ = prop;
					_tmp95_ = vala_property_get_base_interface_property (_tmp94_);
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp96_);
					_tmp98_ = _tmp97_;
					_tmp99_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_INTERFACE, ValaInterface));
					base_type = _tmp99_;
					_tmp100_ = prop;
					_tmp101_ = vala_property_get_base_interface_property (_tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = _vala_code_node_ref0 (_tmp102_);
					_vala_code_node_unref0 (base_prop);
					base_prop = _tmp103_;
					_tmp104_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
					_tmp105_ = _tmp104_;
					_tmp106_ = cself;
					_tmp107_ = vala_glib_value_new ((ValaDataType*) _tmp105_, _tmp106_, TRUE);
					_tmp108_ = _tmp107_;
					_tmp109_ = base_type;
					_tmp110_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = prop;
					_tmp113_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp108_, (ValaDataType*) _tmp111_, (ValaCodeNode*) _tmp112_);
					_tmp114_ = _tmp113_;
					_tmp115_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp114_);
					_vala_ccode_node_unref0 (cself);
					cself = _tmp115_;
					_vala_target_value_unref0 (_tmp114_);
					_vala_code_node_unref0 (_tmp111_);
					_vala_target_value_unref0 (_tmp108_);
					_vala_code_node_unref0 (_tmp105_);
					_tmp116_ = prop;
					_tmp117_ = vala_property_get_base_interface_property (_tmp116_);
					_tmp118_ = _tmp117_;
					_tmp119_ = vala_property_get_get_accessor (_tmp118_);
					_tmp120_ = _tmp119_;
					_tmp121_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp120_, _tmp121_);
					_vala_code_node_unref0 (base_type);
				}
			}
			_tmp123_ = base_prop;
			if (!vala_get_ccode_no_accessor_method (_tmp123_)) {
				ValaProperty* _tmp124_;
				_tmp124_ = base_prop;
				_tmp122_ = !vala_get_ccode_concrete_accessor (_tmp124_);
			} else {
				_tmp122_ = FALSE;
			}
			if (_tmp122_) {
				ValaProperty* _tmp125_;
				ValaPropertyAccessor* _tmp126_;
				ValaPropertyAccessor* _tmp127_;
				gchar* _tmp128_;
				gchar* _tmp129_;
				ValaCCodeIdentifier* _tmp130_;
				_tmp125_ = base_prop;
				_tmp126_ = vala_property_get_get_accessor (_tmp125_);
				_tmp127_ = _tmp126_;
				_tmp128_ = vala_get_ccode_name ((ValaCodeNode*) _tmp127_);
				_tmp129_ = _tmp128_;
				_tmp130_ = vala_ccode_identifier_new (_tmp129_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp130_;
				_g_free0 (_tmp129_);
			} else {
				ValaProperty* _tmp131_;
				ValaPropertyAccessor* _tmp132_;
				ValaPropertyAccessor* _tmp133_;
				gchar* _tmp134_;
				gchar* _tmp135_;
				ValaCCodeIdentifier* _tmp136_;
				_tmp131_ = prop;
				_tmp132_ = vala_property_get_get_accessor (_tmp131_);
				_tmp133_ = _tmp132_;
				_tmp134_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp133_);
				_tmp135_ = _tmp134_;
				_tmp136_ = vala_ccode_identifier_new (_tmp135_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp136_;
				_g_free0 (_tmp135_);
			}
			_tmp137_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp138_ = _tmp137_;
			_tmp139_ = prop;
			_tmp140_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp139_, NULL);
			_tmp141_ = _tmp140_;
			_tmp142_ = g_strdup_printf ("%s_PROPERTY", _tmp141_);
			_tmp143_ = _tmp142_;
			_tmp144_ = vala_ccode_identifier_new (_tmp143_);
			_tmp145_ = _tmp144_;
			vala_ccode_function_add_case (_tmp138_, (ValaCCodeExpression*) _tmp145_);
			_vala_ccode_node_unref0 (_tmp145_);
			_g_free0 (_tmp143_);
			_g_free0 (_tmp141_);
			_tmp146_ = prop;
			_tmp147_ = vala_property_get_property_type (_tmp146_);
			_tmp148_ = _tmp147_;
			if (vala_data_type_is_real_struct_type (_tmp148_)) {
				ValaCCodeFunction* _tmp149_;
				ValaCCodeFunction* _tmp150_;
				ValaCCodeFunction* _tmp151_;
				ValaCCodeFunction* _tmp152_;
				ValaProperty* _tmp153_;
				ValaDataType* _tmp154_;
				ValaDataType* _tmp155_;
				gchar* _tmp156_;
				gchar* _tmp157_;
				ValaCCodeVariableDeclarator* _tmp158_;
				ValaCCodeVariableDeclarator* _tmp159_;
				ValaCCodeExpression* _tmp160_;
				ValaCCodeFunctionCall* _tmp161_;
				ValaCCodeFunctionCall* _tmp162_;
				ValaCCodeExpression* _tmp163_;
				ValaProperty* _tmp164_;
				ValaDataType* _tmp165_;
				ValaDataType* _tmp166_;
				gboolean _tmp167_;
				gboolean _tmp168_;
				ValaCCodeFunctionCall* csetcall = NULL;
				ValaCCodeFunctionCall* _tmp182_;
				ValaCCodeFunctionCall* _tmp183_;
				ValaProperty* _tmp184_;
				ValaDataType* _tmp185_;
				ValaDataType* _tmp186_;
				ValaCCodeIdentifier* _tmp187_;
				ValaCCodeIdentifier* _tmp188_;
				ValaCCodeFunctionCall* _tmp189_;
				ValaCCodeIdentifier* _tmp190_;
				ValaCCodeIdentifier* _tmp191_;
				ValaProperty* _tmp192_;
				ValaDataType* _tmp193_;
				ValaDataType* _tmp194_;
				gboolean _tmp195_;
				gboolean _tmp196_;
				ValaProperty* _tmp205_;
				ValaCCodeFunctionCall* _tmp206_;
				ValaProperty* _tmp207_;
				ValaPropertyAccessor* _tmp208_;
				ValaPropertyAccessor* _tmp209_;
				ValaDataType* _tmp210_;
				ValaDataType* _tmp211_;
				ValaCCodeFunction* _tmp225_;
				ValaCCodeFunction* _tmp226_;
				_tmp149_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp150_ = _tmp149_;
				vala_ccode_function_open_block (_tmp150_);
				_tmp151_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp152_ = _tmp151_;
				_tmp153_ = prop;
				_tmp154_ = vala_property_get_property_type (_tmp153_);
				_tmp155_ = _tmp154_;
				_tmp156_ = vala_get_ccode_name ((ValaCodeNode*) _tmp155_);
				_tmp157_ = _tmp156_;
				_tmp158_ = vala_ccode_variable_declarator_new ("boxed", NULL, NULL);
				_tmp159_ = _tmp158_;
				vala_ccode_function_add_declaration (_tmp152_, _tmp157_, (ValaCCodeDeclarator*) _tmp159_, 0);
				_vala_ccode_node_unref0 (_tmp159_);
				_g_free0 (_tmp157_);
				_tmp160_ = cfunc;
				_tmp161_ = vala_ccode_function_call_new (_tmp160_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp161_;
				_tmp162_ = ccall;
				_tmp163_ = cself;
				vala_ccode_function_call_add_argument (_tmp162_, _tmp163_);
				_tmp164_ = prop;
				_tmp165_ = vala_property_get_property_type (_tmp164_);
				_tmp166_ = _tmp165_;
				_tmp167_ = vala_data_type_get_nullable (_tmp166_);
				_tmp168_ = _tmp167_;
				if (_tmp168_) {
					ValaCCodeFunction* _tmp169_;
					ValaCCodeFunction* _tmp170_;
					ValaCCodeIdentifier* _tmp171_;
					ValaCCodeIdentifier* _tmp172_;
					ValaCCodeFunctionCall* _tmp173_;
					_tmp169_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp170_ = _tmp169_;
					_tmp171_ = vala_ccode_identifier_new ("boxed");
					_tmp172_ = _tmp171_;
					_tmp173_ = ccall;
					vala_ccode_function_add_assignment (_tmp170_, (ValaCCodeExpression*) _tmp172_, (ValaCCodeExpression*) _tmp173_);
					_vala_ccode_node_unref0 (_tmp172_);
				} else {
					ValaCCodeFunctionCall* _tmp174_;
					ValaCCodeIdentifier* _tmp175_;
					ValaCCodeIdentifier* _tmp176_;
					ValaCCodeUnaryExpression* _tmp177_;
					ValaCCodeUnaryExpression* _tmp178_;
					ValaCCodeFunction* _tmp179_;
					ValaCCodeFunction* _tmp180_;
					ValaCCodeFunctionCall* _tmp181_;
					_tmp174_ = ccall;
					_tmp175_ = vala_ccode_identifier_new ("boxed");
					_tmp176_ = _tmp175_;
					_tmp177_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp176_);
					_tmp178_ = _tmp177_;
					vala_ccode_function_call_add_argument (_tmp174_, (ValaCCodeExpression*) _tmp178_);
					_vala_ccode_node_unref0 (_tmp178_);
					_vala_ccode_node_unref0 (_tmp176_);
					_tmp179_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp180_ = _tmp179_;
					_tmp181_ = ccall;
					vala_ccode_function_add_expression (_tmp180_, (ValaCCodeExpression*) _tmp181_);
				}
				_tmp182_ = vala_ccode_function_call_new (NULL);
				csetcall = _tmp182_;
				_tmp183_ = csetcall;
				_tmp184_ = prop;
				_tmp185_ = vala_property_get_property_type (_tmp184_);
				_tmp186_ = _tmp185_;
				_tmp187_ = vala_ccode_base_module_get_value_setter_function ((ValaCCodeBaseModule*) self, _tmp186_);
				_tmp188_ = _tmp187_;
				vala_ccode_function_call_set_call (_tmp183_, (ValaCCodeExpression*) _tmp188_);
				_vala_ccode_node_unref0 (_tmp188_);
				_tmp189_ = csetcall;
				_tmp190_ = vala_ccode_identifier_new ("value");
				_tmp191_ = _tmp190_;
				vala_ccode_function_call_add_argument (_tmp189_, (ValaCCodeExpression*) _tmp191_);
				_vala_ccode_node_unref0 (_tmp191_);
				_tmp192_ = prop;
				_tmp193_ = vala_property_get_property_type (_tmp192_);
				_tmp194_ = _tmp193_;
				_tmp195_ = vala_data_type_get_nullable (_tmp194_);
				_tmp196_ = _tmp195_;
				if (_tmp196_) {
					ValaCCodeFunctionCall* _tmp197_;
					ValaCCodeIdentifier* _tmp198_;
					ValaCCodeIdentifier* _tmp199_;
					_tmp197_ = csetcall;
					_tmp198_ = vala_ccode_identifier_new ("boxed");
					_tmp199_ = _tmp198_;
					vala_ccode_function_call_add_argument (_tmp197_, (ValaCCodeExpression*) _tmp199_);
					_vala_ccode_node_unref0 (_tmp199_);
				} else {
					ValaCCodeFunctionCall* _tmp200_;
					ValaCCodeIdentifier* _tmp201_;
					ValaCCodeIdentifier* _tmp202_;
					ValaCCodeUnaryExpression* _tmp203_;
					ValaCCodeUnaryExpression* _tmp204_;
					_tmp200_ = csetcall;
					_tmp201_ = vala_ccode_identifier_new ("boxed");
					_tmp202_ = _tmp201_;
					_tmp203_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp202_);
					_tmp204_ = _tmp203_;
					vala_ccode_function_call_add_argument (_tmp200_, (ValaCCodeExpression*) _tmp204_);
					_vala_ccode_node_unref0 (_tmp204_);
					_vala_ccode_node_unref0 (_tmp202_);
				}
				_tmp205_ = prop;
				_tmp206_ = csetcall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp205_, (ValaCCodeExpression*) _tmp206_);
				_tmp207_ = prop;
				_tmp208_ = vala_property_get_get_accessor (_tmp207_);
				_tmp209_ = _tmp208_;
				_tmp210_ = vala_property_accessor_get_value_type (_tmp209_);
				_tmp211_ = _tmp210_;
				if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp211_)) {
					ValaCCodeFunction* _tmp212_;
					ValaCCodeFunction* _tmp213_;
					ValaProperty* _tmp214_;
					ValaPropertyAccessor* _tmp215_;
					ValaPropertyAccessor* _tmp216_;
					ValaDataType* _tmp217_;
					ValaDataType* _tmp218_;
					ValaCCodeIdentifier* _tmp219_;
					ValaCCodeIdentifier* _tmp220_;
					ValaGLibValue* _tmp221_;
					ValaGLibValue* _tmp222_;
					ValaCCodeExpression* _tmp223_;
					ValaCCodeExpression* _tmp224_;
					_tmp212_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp213_ = _tmp212_;
					_tmp214_ = prop;
					_tmp215_ = vala_property_get_get_accessor (_tmp214_);
					_tmp216_ = _tmp215_;
					_tmp217_ = vala_property_accessor_get_value_type (_tmp216_);
					_tmp218_ = _tmp217_;
					_tmp219_ = vala_ccode_identifier_new ("boxed");
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_glib_value_new (_tmp218_, (ValaCCodeExpression*) _tmp220_, TRUE);
					_tmp222_ = _tmp221_;
					_tmp223_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp222_, FALSE);
					_tmp224_ = _tmp223_;
					vala_ccode_function_add_expression (_tmp213_, _tmp224_);
					_vala_ccode_node_unref0 (_tmp224_);
					_vala_target_value_unref0 (_tmp222_);
					_vala_ccode_node_unref0 (_tmp220_);
				}
				_tmp225_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp226_ = _tmp225_;
				vala_ccode_function_close (_tmp226_);
				_vala_ccode_node_unref0 (csetcall);
			} else {
				ValaCCodeExpression* _tmp227_;
				ValaCCodeFunctionCall* _tmp228_;
				ValaCCodeFunctionCall* _tmp229_;
				ValaCCodeExpression* _tmp230_;
				ValaArrayType* array_type = NULL;
				ValaProperty* _tmp231_;
				ValaDataType* _tmp232_;
				ValaDataType* _tmp233_;
				ValaArrayType* _tmp234_;
				gboolean _tmp235_ = FALSE;
				ValaArrayType* _tmp236_;
				ValaCCodeFunctionCall* csetcall = NULL;
				ValaCCodeFunctionCall* _tmp256_;
				ValaProperty* _tmp257_;
				ValaPropertyAccessor* _tmp258_;
				ValaPropertyAccessor* _tmp259_;
				ValaDataType* _tmp260_;
				ValaDataType* _tmp261_;
				gboolean _tmp262_;
				gboolean _tmp263_;
				ValaCCodeFunctionCall* _tmp276_;
				ValaCCodeIdentifier* _tmp277_;
				ValaCCodeIdentifier* _tmp278_;
				ValaCCodeFunctionCall* _tmp279_;
				ValaCCodeFunctionCall* _tmp280_;
				ValaProperty* _tmp281_;
				ValaCCodeFunctionCall* _tmp282_;
				gboolean _tmp283_ = FALSE;
				ValaArrayType* _tmp284_;
				_tmp227_ = cfunc;
				_tmp228_ = vala_ccode_function_call_new (_tmp227_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp228_;
				_tmp229_ = ccall;
				_tmp230_ = cself;
				vala_ccode_function_call_add_argument (_tmp229_, _tmp230_);
				_tmp231_ = prop;
				_tmp232_ = vala_property_get_property_type (_tmp231_);
				_tmp233_ = _tmp232_;
				_tmp234_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp233_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp233_) : NULL);
				array_type = _tmp234_;
				_tmp236_ = array_type;
				if (_tmp236_ != NULL) {
					ValaArrayType* _tmp237_;
					ValaDataType* _tmp238_;
					ValaDataType* _tmp239_;
					ValaTypeSymbol* _tmp240_;
					ValaTypeSymbol* _tmp241_;
					ValaDataType* _tmp242_;
					ValaTypeSymbol* _tmp243_;
					ValaTypeSymbol* _tmp244_;
					_tmp237_ = array_type;
					_tmp238_ = vala_array_type_get_element_type (_tmp237_);
					_tmp239_ = _tmp238_;
					_tmp240_ = vala_data_type_get_data_type (_tmp239_);
					_tmp241_ = _tmp240_;
					_tmp242_ = ((ValaCCodeBaseModule*) self)->string_type;
					_tmp243_ = vala_data_type_get_data_type (_tmp242_);
					_tmp244_ = _tmp243_;
					_tmp235_ = _tmp241_ == _tmp244_;
				} else {
					_tmp235_ = FALSE;
				}
				if (_tmp235_) {
					ValaCCodeFunction* _tmp245_;
					ValaCCodeFunction* _tmp246_;
					ValaCCodeFunction* _tmp247_;
					ValaCCodeFunction* _tmp248_;
					ValaCCodeVariableDeclarator* _tmp249_;
					ValaCCodeVariableDeclarator* _tmp250_;
					ValaCCodeFunctionCall* _tmp251_;
					ValaCCodeIdentifier* _tmp252_;
					ValaCCodeIdentifier* _tmp253_;
					ValaCCodeUnaryExpression* _tmp254_;
					ValaCCodeUnaryExpression* _tmp255_;
					_tmp245_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp246_ = _tmp245_;
					vala_ccode_function_open_block (_tmp246_);
					_tmp247_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp248_ = _tmp247_;
					_tmp249_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
					_tmp250_ = _tmp249_;
					vala_ccode_function_add_declaration (_tmp248_, "int", (ValaCCodeDeclarator*) _tmp250_, 0);
					_vala_ccode_node_unref0 (_tmp250_);
					_tmp251_ = ccall;
					_tmp252_ = vala_ccode_identifier_new ("length");
					_tmp253_ = _tmp252_;
					_tmp254_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp253_);
					_tmp255_ = _tmp254_;
					vala_ccode_function_call_add_argument (_tmp251_, (ValaCCodeExpression*) _tmp255_);
					_vala_ccode_node_unref0 (_tmp255_);
					_vala_ccode_node_unref0 (_tmp253_);
				}
				_tmp256_ = vala_ccode_function_call_new (NULL);
				csetcall = _tmp256_;
				_tmp257_ = prop;
				_tmp258_ = vala_property_get_get_accessor (_tmp257_);
				_tmp259_ = _tmp258_;
				_tmp260_ = vala_property_accessor_get_value_type (_tmp259_);
				_tmp261_ = _tmp260_;
				_tmp262_ = vala_data_type_get_value_owned (_tmp261_);
				_tmp263_ = _tmp262_;
				if (_tmp263_) {
					ValaCCodeFunctionCall* _tmp264_;
					ValaProperty* _tmp265_;
					ValaDataType* _tmp266_;
					ValaDataType* _tmp267_;
					ValaCCodeIdentifier* _tmp268_;
					ValaCCodeIdentifier* _tmp269_;
					_tmp264_ = csetcall;
					_tmp265_ = prop;
					_tmp266_ = vala_property_get_property_type (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp268_ = vala_ccode_base_module_get_value_taker_function ((ValaCCodeBaseModule*) self, _tmp267_);
					_tmp269_ = _tmp268_;
					vala_ccode_function_call_set_call (_tmp264_, (ValaCCodeExpression*) _tmp269_);
					_vala_ccode_node_unref0 (_tmp269_);
				} else {
					ValaCCodeFunctionCall* _tmp270_;
					ValaProperty* _tmp271_;
					ValaDataType* _tmp272_;
					ValaDataType* _tmp273_;
					ValaCCodeIdentifier* _tmp274_;
					ValaCCodeIdentifier* _tmp275_;
					_tmp270_ = csetcall;
					_tmp271_ = prop;
					_tmp272_ = vala_property_get_property_type (_tmp271_);
					_tmp273_ = _tmp272_;
					_tmp274_ = vala_ccode_base_module_get_value_setter_function ((ValaCCodeBaseModule*) self, _tmp273_);
					_tmp275_ = _tmp274_;
					vala_ccode_function_call_set_call (_tmp270_, (ValaCCodeExpression*) _tmp275_);
					_vala_ccode_node_unref0 (_tmp275_);
				}
				_tmp276_ = csetcall;
				_tmp277_ = vala_ccode_identifier_new ("value");
				_tmp278_ = _tmp277_;
				vala_ccode_function_call_add_argument (_tmp276_, (ValaCCodeExpression*) _tmp278_);
				_vala_ccode_node_unref0 (_tmp278_);
				_tmp279_ = csetcall;
				_tmp280_ = ccall;
				vala_ccode_function_call_add_argument (_tmp279_, (ValaCCodeExpression*) _tmp280_);
				_tmp281_ = prop;
				_tmp282_ = csetcall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp281_, (ValaCCodeExpression*) _tmp282_);
				_tmp284_ = array_type;
				if (_tmp284_ != NULL) {
					ValaArrayType* _tmp285_;
					ValaDataType* _tmp286_;
					ValaDataType* _tmp287_;
					ValaTypeSymbol* _tmp288_;
					ValaTypeSymbol* _tmp289_;
					ValaDataType* _tmp290_;
					ValaTypeSymbol* _tmp291_;
					ValaTypeSymbol* _tmp292_;
					_tmp285_ = array_type;
					_tmp286_ = vala_array_type_get_element_type (_tmp285_);
					_tmp287_ = _tmp286_;
					_tmp288_ = vala_data_type_get_data_type (_tmp287_);
					_tmp289_ = _tmp288_;
					_tmp290_ = ((ValaCCodeBaseModule*) self)->string_type;
					_tmp291_ = vala_data_type_get_data_type (_tmp290_);
					_tmp292_ = _tmp291_;
					_tmp283_ = _tmp289_ == _tmp292_;
				} else {
					_tmp283_ = FALSE;
				}
				if (_tmp283_) {
					ValaCCodeFunction* _tmp293_;
					ValaCCodeFunction* _tmp294_;
					_tmp293_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp294_ = _tmp293_;
					vala_ccode_function_close (_tmp294_);
				}
				_vala_ccode_node_unref0 (csetcall);
				_vala_code_node_unref0 (array_type);
			}
			_tmp295_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp296_ = _tmp295_;
			vala_ccode_function_add_break (_tmp296_);
			_vala_ccode_node_unref0 (cfunc);
			_vala_ccode_node_unref0 (cself);
			_vala_code_node_unref0 (base_prop);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp297_;
		gint _type_param_size = 0;
		ValaList* _tmp298_;
		gint _tmp299_;
		gint _tmp300_;
		gint _type_param_index = 0;
		_tmp297_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_type_param_list = _tmp297_;
		_tmp298_ = _type_param_list;
		_tmp299_ = vala_collection_get_size ((ValaCollection*) _tmp298_);
		_tmp300_ = _tmp299_;
		_type_param_size = _tmp300_;
		_type_param_index = -1;
		while (TRUE) {
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp301_;
			gpointer _tmp302_;
			gchar* func_name = NULL;
			gchar* enum_value = NULL;
			ValaCCodeMemberAccess* cfield = NULL;
			ValaCCodeFunctionCall* csetcall = NULL;
			ValaTypeParameter* _tmp303_;
			const gchar* _tmp304_;
			const gchar* _tmp305_;
			gchar* _tmp306_;
			gchar* _tmp307_;
			gchar* _tmp308_;
			gchar* _tmp309_;
			gchar* _tmp310_;
			const gchar* _tmp311_;
			gchar* _tmp312_;
			gchar* _tmp313_;
			gchar* _tmp314_;
			ValaCCodeFunction* _tmp315_;
			ValaCCodeFunction* _tmp316_;
			const gchar* _tmp317_;
			ValaCCodeIdentifier* _tmp318_;
			ValaCCodeIdentifier* _tmp319_;
			ValaCCodeIdentifier* _tmp320_;
			ValaCCodeIdentifier* _tmp321_;
			ValaCCodeMemberAccess* _tmp322_;
			ValaCCodeMemberAccess* _tmp323_;
			const gchar* _tmp324_;
			ValaCCodeMemberAccess* _tmp325_;
			ValaCCodeIdentifier* _tmp326_;
			ValaCCodeIdentifier* _tmp327_;
			ValaCCodeFunctionCall* _tmp328_;
			ValaCCodeFunctionCall* _tmp329_;
			ValaCCodeIdentifier* _tmp330_;
			ValaCCodeIdentifier* _tmp331_;
			ValaCCodeFunctionCall* _tmp332_;
			ValaCCodeMemberAccess* _tmp333_;
			ValaCCodeFunction* _tmp334_;
			ValaCCodeFunction* _tmp335_;
			ValaCCodeFunctionCall* _tmp336_;
			ValaCCodeFunction* _tmp337_;
			ValaCCodeFunction* _tmp338_;
			ValaTypeParameter* _tmp339_;
			const gchar* _tmp340_;
			const gchar* _tmp341_;
			gchar* _tmp342_;
			gchar* _tmp343_;
			gchar* _tmp344_;
			gchar* _tmp345_;
			gchar* _tmp346_;
			const gchar* _tmp347_;
			gchar* _tmp348_;
			gchar* _tmp349_;
			gchar* _tmp350_;
			ValaCCodeFunction* _tmp351_;
			ValaCCodeFunction* _tmp352_;
			const gchar* _tmp353_;
			ValaCCodeIdentifier* _tmp354_;
			ValaCCodeIdentifier* _tmp355_;
			ValaCCodeIdentifier* _tmp356_;
			ValaCCodeIdentifier* _tmp357_;
			ValaCCodeMemberAccess* _tmp358_;
			ValaCCodeMemberAccess* _tmp359_;
			const gchar* _tmp360_;
			ValaCCodeMemberAccess* _tmp361_;
			ValaCCodeIdentifier* _tmp362_;
			ValaCCodeIdentifier* _tmp363_;
			ValaCCodeFunctionCall* _tmp364_;
			ValaCCodeFunctionCall* _tmp365_;
			ValaCCodeIdentifier* _tmp366_;
			ValaCCodeIdentifier* _tmp367_;
			ValaCCodeFunctionCall* _tmp368_;
			ValaCCodeMemberAccess* _tmp369_;
			ValaCCodeFunction* _tmp370_;
			ValaCCodeFunction* _tmp371_;
			ValaCCodeFunctionCall* _tmp372_;
			ValaCCodeFunction* _tmp373_;
			ValaCCodeFunction* _tmp374_;
			ValaTypeParameter* _tmp375_;
			const gchar* _tmp376_;
			const gchar* _tmp377_;
			gchar* _tmp378_;
			gchar* _tmp379_;
			gchar* _tmp380_;
			gchar* _tmp381_;
			gchar* _tmp382_;
			const gchar* _tmp383_;
			gchar* _tmp384_;
			gchar* _tmp385_;
			gchar* _tmp386_;
			ValaCCodeFunction* _tmp387_;
			ValaCCodeFunction* _tmp388_;
			const gchar* _tmp389_;
			ValaCCodeIdentifier* _tmp390_;
			ValaCCodeIdentifier* _tmp391_;
			ValaCCodeIdentifier* _tmp392_;
			ValaCCodeIdentifier* _tmp393_;
			ValaCCodeMemberAccess* _tmp394_;
			ValaCCodeMemberAccess* _tmp395_;
			const gchar* _tmp396_;
			ValaCCodeMemberAccess* _tmp397_;
			ValaCCodeIdentifier* _tmp398_;
			ValaCCodeIdentifier* _tmp399_;
			ValaCCodeFunctionCall* _tmp400_;
			ValaCCodeFunctionCall* _tmp401_;
			ValaCCodeIdentifier* _tmp402_;
			ValaCCodeIdentifier* _tmp403_;
			ValaCCodeFunctionCall* _tmp404_;
			ValaCCodeMemberAccess* _tmp405_;
			ValaCCodeFunction* _tmp406_;
			ValaCCodeFunction* _tmp407_;
			ValaCCodeFunctionCall* _tmp408_;
			ValaCCodeFunction* _tmp409_;
			ValaCCodeFunction* _tmp410_;
			_type_param_index = _type_param_index + 1;
			if (!(_type_param_index < _type_param_size)) {
				break;
			}
			_tmp301_ = _type_param_list;
			_tmp302_ = vala_list_get (_tmp301_, _type_param_index);
			type_param = (ValaTypeParameter*) _tmp302_;
			_tmp303_ = type_param;
			_tmp304_ = vala_symbol_get_name ((ValaSymbol*) _tmp303_);
			_tmp305_ = _tmp304_;
			_tmp306_ = g_ascii_strdown (_tmp305_, (gssize) -1);
			_tmp307_ = _tmp306_;
			_tmp308_ = g_strdup_printf ("%s_type", _tmp307_);
			_g_free0 (func_name);
			func_name = _tmp308_;
			_g_free0 (_tmp307_);
			_tmp309_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp310_ = _tmp309_;
			_tmp311_ = func_name;
			_tmp312_ = g_strdup_printf ("%s_%s", _tmp310_, _tmp311_);
			_tmp313_ = _tmp312_;
			_tmp314_ = g_ascii_strup (_tmp313_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp314_;
			_g_free0 (_tmp313_);
			_g_free0 (_tmp310_);
			_tmp315_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp316_ = _tmp315_;
			_tmp317_ = enum_value;
			_tmp318_ = vala_ccode_identifier_new (_tmp317_);
			_tmp319_ = _tmp318_;
			vala_ccode_function_add_case (_tmp316_, (ValaCCodeExpression*) _tmp319_);
			_vala_ccode_node_unref0 (_tmp319_);
			_tmp320_ = vala_ccode_identifier_new ("self");
			_tmp321_ = _tmp320_;
			_tmp322_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp321_, "priv");
			_tmp323_ = _tmp322_;
			_tmp324_ = func_name;
			_tmp325_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp323_, _tmp324_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp325_;
			_vala_ccode_node_unref0 (_tmp323_);
			_vala_ccode_node_unref0 (_tmp321_);
			_tmp326_ = vala_ccode_identifier_new ("g_value_set_gtype");
			_tmp327_ = _tmp326_;
			_tmp328_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp327_);
			_vala_ccode_node_unref0 (csetcall);
			csetcall = _tmp328_;
			_vala_ccode_node_unref0 (_tmp327_);
			_tmp329_ = csetcall;
			_tmp330_ = vala_ccode_identifier_new ("value");
			_tmp331_ = _tmp330_;
			vala_ccode_function_call_add_argument (_tmp329_, (ValaCCodeExpression*) _tmp331_);
			_vala_ccode_node_unref0 (_tmp331_);
			_tmp332_ = csetcall;
			_tmp333_ = cfield;
			vala_ccode_function_call_add_argument (_tmp332_, (ValaCCodeExpression*) _tmp333_);
			_tmp334_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp335_ = _tmp334_;
			_tmp336_ = csetcall;
			vala_ccode_function_add_expression (_tmp335_, (ValaCCodeExpression*) _tmp336_);
			_tmp337_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp338_ = _tmp337_;
			vala_ccode_function_add_break (_tmp338_);
			_tmp339_ = type_param;
			_tmp340_ = vala_symbol_get_name ((ValaSymbol*) _tmp339_);
			_tmp341_ = _tmp340_;
			_tmp342_ = g_ascii_strdown (_tmp341_, (gssize) -1);
			_tmp343_ = _tmp342_;
			_tmp344_ = g_strdup_printf ("%s_dup_func", _tmp343_);
			_g_free0 (func_name);
			func_name = _tmp344_;
			_g_free0 (_tmp343_);
			_tmp345_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp346_ = _tmp345_;
			_tmp347_ = func_name;
			_tmp348_ = g_strdup_printf ("%s_%s", _tmp346_, _tmp347_);
			_tmp349_ = _tmp348_;
			_tmp350_ = g_ascii_strup (_tmp349_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp350_;
			_g_free0 (_tmp349_);
			_g_free0 (_tmp346_);
			_tmp351_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp352_ = _tmp351_;
			_tmp353_ = enum_value;
			_tmp354_ = vala_ccode_identifier_new (_tmp353_);
			_tmp355_ = _tmp354_;
			vala_ccode_function_add_case (_tmp352_, (ValaCCodeExpression*) _tmp355_);
			_vala_ccode_node_unref0 (_tmp355_);
			_tmp356_ = vala_ccode_identifier_new ("self");
			_tmp357_ = _tmp356_;
			_tmp358_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp357_, "priv");
			_tmp359_ = _tmp358_;
			_tmp360_ = func_name;
			_tmp361_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp359_, _tmp360_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp361_;
			_vala_ccode_node_unref0 (_tmp359_);
			_vala_ccode_node_unref0 (_tmp357_);
			_tmp362_ = vala_ccode_identifier_new ("g_value_set_pointer");
			_tmp363_ = _tmp362_;
			_tmp364_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp363_);
			_vala_ccode_node_unref0 (csetcall);
			csetcall = _tmp364_;
			_vala_ccode_node_unref0 (_tmp363_);
			_tmp365_ = csetcall;
			_tmp366_ = vala_ccode_identifier_new ("value");
			_tmp367_ = _tmp366_;
			vala_ccode_function_call_add_argument (_tmp365_, (ValaCCodeExpression*) _tmp367_);
			_vala_ccode_node_unref0 (_tmp367_);
			_tmp368_ = csetcall;
			_tmp369_ = cfield;
			vala_ccode_function_call_add_argument (_tmp368_, (ValaCCodeExpression*) _tmp369_);
			_tmp370_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp371_ = _tmp370_;
			_tmp372_ = csetcall;
			vala_ccode_function_add_expression (_tmp371_, (ValaCCodeExpression*) _tmp372_);
			_tmp373_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp374_ = _tmp373_;
			vala_ccode_function_add_break (_tmp374_);
			_tmp375_ = type_param;
			_tmp376_ = vala_symbol_get_name ((ValaSymbol*) _tmp375_);
			_tmp377_ = _tmp376_;
			_tmp378_ = g_ascii_strdown (_tmp377_, (gssize) -1);
			_tmp379_ = _tmp378_;
			_tmp380_ = g_strdup_printf ("%s_destroy_func", _tmp379_);
			_g_free0 (func_name);
			func_name = _tmp380_;
			_g_free0 (_tmp379_);
			_tmp381_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp382_ = _tmp381_;
			_tmp383_ = func_name;
			_tmp384_ = g_strdup_printf ("%s_%s", _tmp382_, _tmp383_);
			_tmp385_ = _tmp384_;
			_tmp386_ = g_ascii_strup (_tmp385_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp386_;
			_g_free0 (_tmp385_);
			_g_free0 (_tmp382_);
			_tmp387_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp388_ = _tmp387_;
			_tmp389_ = enum_value;
			_tmp390_ = vala_ccode_identifier_new (_tmp389_);
			_tmp391_ = _tmp390_;
			vala_ccode_function_add_case (_tmp388_, (ValaCCodeExpression*) _tmp391_);
			_vala_ccode_node_unref0 (_tmp391_);
			_tmp392_ = vala_ccode_identifier_new ("self");
			_tmp393_ = _tmp392_;
			_tmp394_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp393_, "priv");
			_tmp395_ = _tmp394_;
			_tmp396_ = func_name;
			_tmp397_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp395_, _tmp396_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp397_;
			_vala_ccode_node_unref0 (_tmp395_);
			_vala_ccode_node_unref0 (_tmp393_);
			_tmp398_ = vala_ccode_identifier_new ("g_value_set_pointer");
			_tmp399_ = _tmp398_;
			_tmp400_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp399_);
			_vala_ccode_node_unref0 (csetcall);
			csetcall = _tmp400_;
			_vala_ccode_node_unref0 (_tmp399_);
			_tmp401_ = csetcall;
			_tmp402_ = vala_ccode_identifier_new ("value");
			_tmp403_ = _tmp402_;
			vala_ccode_function_call_add_argument (_tmp401_, (ValaCCodeExpression*) _tmp403_);
			_vala_ccode_node_unref0 (_tmp403_);
			_tmp404_ = csetcall;
			_tmp405_ = cfield;
			vala_ccode_function_call_add_argument (_tmp404_, (ValaCCodeExpression*) _tmp405_);
			_tmp406_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp407_ = _tmp406_;
			_tmp408_ = csetcall;
			vala_ccode_function_add_expression (_tmp407_, (ValaCCodeExpression*) _tmp408_);
			_tmp409_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp410_ = _tmp409_;
			vala_ccode_function_add_break (_tmp410_);
			_vala_ccode_node_unref0 (csetcall);
			_vala_ccode_node_unref0 (cfield);
			_g_free0 (enum_value);
			_g_free0 (func_name);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	_tmp411_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp412_ = _tmp411_;
	vala_ccode_function_add_default (_tmp412_);
	vala_gobject_module_emit_invalid_property_id_warn (self);
	_tmp413_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp414_ = _tmp413_;
	vala_ccode_function_add_break (_tmp414_);
	_tmp415_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp416_ = _tmp415_;
	vala_ccode_function_close (_tmp416_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp417_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp418_ = get_prop;
	vala_ccode_file_add_function_declaration (_tmp417_, _tmp418_);
	_tmp419_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp420_ = get_prop;
	vala_ccode_file_add_function (_tmp419_, _tmp420_);
	_vala_iterable_unref0 (props);
	_vala_ccode_node_unref0 (ccall);
	_vala_ccode_node_unref0 (get_prop);
}

static void
vala_gobject_module_add_set_property_function (ValaGObjectModule* self,
                                               ValaClass* cl)
{
	ValaCCodeFunction* set_prop = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeFunction* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeParameter* _tmp8_;
	ValaCCodeParameter* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeParameter* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeParameter* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeFunction* _tmp19_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeFunction* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeVariableDeclarator* _tmp31_;
	ValaCCodeVariableDeclarator* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeIdentifier* _tmp36_;
	ValaList* props = NULL;
	ValaList* _tmp37_;
	ValaCCodeFunction* _tmp349_;
	ValaCCodeFunction* _tmp350_;
	ValaCCodeFunction* _tmp351_;
	ValaCCodeFunction* _tmp352_;
	ValaCCodeFunction* _tmp353_;
	ValaCCodeFunction* _tmp354_;
	ValaCCodeFile* _tmp355_;
	ValaCCodeFunction* _tmp356_;
	ValaCCodeFile* _tmp357_;
	ValaCCodeFunction* _tmp358_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_vala_%s_set_property", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_new (_tmp3_, "void");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	set_prop = _tmp5_;
	_tmp6_ = set_prop;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp6_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp7_ = set_prop;
	_tmp8_ = vala_ccode_parameter_new ("object", "GObject *");
	_tmp9_ = _tmp8_;
	vala_ccode_function_add_parameter (_tmp7_, _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = set_prop;
	_tmp11_ = vala_ccode_parameter_new ("property_id", "guint");
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp10_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_tmp13_ = set_prop;
	_tmp14_ = vala_ccode_parameter_new ("value", "const GValue *");
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_parameter (_tmp13_, _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = set_prop;
	_tmp17_ = vala_ccode_parameter_new ("pspec", "GParamSpec *");
	_tmp18_ = _tmp17_;
	vala_ccode_function_add_parameter (_tmp16_, _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = set_prop;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp19_);
	_tmp20_ = vala_ccode_identifier_new ("object");
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_base_module_generate_instance_cast ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) _tmp21_, (ValaTypeSymbol*) cl);
	_tmp23_ = _tmp22_;
	_vala_ccode_node_unref0 (_tmp21_);
	ccall = _tmp23_;
	_tmp24_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_get_ccode_name ((ValaCodeNode*) cl);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strdup_printf ("%s *", _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = ccall;
	_tmp31_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	vala_ccode_function_add_declaration (_tmp25_, _tmp29_, (ValaCCodeDeclarator*) _tmp32_, 0);
	_vala_ccode_node_unref0 (_tmp32_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_ccode_identifier_new ("property_id");
	_tmp36_ = _tmp35_;
	vala_ccode_function_open_switch (_tmp34_, (ValaCCodeExpression*) _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	_tmp37_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	props = _tmp37_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp38_;
		ValaList* _tmp39_;
		gint _prop_size = 0;
		ValaList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _prop_index = 0;
		_tmp38_ = props;
		_tmp39_ = _vala_iterable_ref0 (_tmp38_);
		_prop_list = _tmp39_;
		_tmp40_ = _prop_list;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_prop_size = _tmp42_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp43_;
			gpointer _tmp44_;
			gboolean _tmp45_ = FALSE;
			ValaProperty* _tmp46_;
			ValaPropertyAccessor* _tmp47_;
			ValaPropertyAccessor* _tmp48_;
			ValaCodeContext* _tmp52_;
			ValaCodeContext* _tmp53_;
			ValaSemanticAnalyzer* _tmp54_;
			ValaSemanticAnalyzer* _tmp55_;
			ValaProperty* _tmp56_;
			ValaProperty* base_prop = NULL;
			ValaProperty* _tmp57_;
			ValaProperty* _tmp58_;
			ValaCCodeExpression* cself = NULL;
			ValaCCodeIdentifier* _tmp59_;
			ValaProperty* _tmp60_;
			ValaProperty* _tmp61_;
			ValaProperty* _tmp62_;
			ValaCCodeExpression* cfunc = NULL;
			gboolean _tmp122_ = FALSE;
			ValaProperty* _tmp123_;
			ValaCCodeFunction* _tmp137_;
			ValaCCodeFunction* _tmp138_;
			ValaProperty* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			ValaCCodeIdentifier* _tmp144_;
			ValaCCodeIdentifier* _tmp145_;
			ValaCCodeExpression* _tmp146_;
			ValaCCodeFunctionCall* _tmp147_;
			ValaCCodeFunctionCall* _tmp148_;
			ValaCCodeExpression* _tmp149_;
			gboolean _tmp150_ = FALSE;
			ValaProperty* _tmp151_;
			ValaDataType* _tmp152_;
			ValaDataType* _tmp153_;
			ValaCCodeFunction* _tmp236_;
			ValaCCodeFunction* _tmp237_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp43_ = _prop_list;
			_tmp44_ = vala_list_get (_tmp43_, _prop_index);
			prop = (ValaProperty*) _tmp44_;
			_tmp46_ = prop;
			_tmp47_ = vala_property_get_set_accessor (_tmp46_);
			_tmp48_ = _tmp47_;
			if (_tmp48_ == NULL) {
				_tmp45_ = TRUE;
			} else {
				ValaProperty* _tmp49_;
				gboolean _tmp50_;
				gboolean _tmp51_;
				_tmp49_ = prop;
				_tmp50_ = vala_property_get_is_abstract (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp45_ = _tmp51_;
			}
			if (_tmp45_) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp52_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_code_context_get_analyzer (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = prop;
			if (!vala_semantic_analyzer_is_gobject_property (_tmp55_, _tmp56_)) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp57_ = prop;
			_tmp58_ = _vala_code_node_ref0 (_tmp57_);
			base_prop = _tmp58_;
			_tmp59_ = vala_ccode_identifier_new ("self");
			cself = (ValaCCodeExpression*) _tmp59_;
			_tmp60_ = prop;
			_tmp61_ = vala_property_get_base_property (_tmp60_);
			_tmp62_ = _tmp61_;
			if (_tmp62_ != NULL) {
				ValaClass* base_type = NULL;
				ValaProperty* _tmp63_;
				ValaProperty* _tmp64_;
				ValaProperty* _tmp65_;
				ValaSymbol* _tmp66_;
				ValaSymbol* _tmp67_;
				ValaClass* _tmp68_;
				ValaProperty* _tmp69_;
				ValaProperty* _tmp70_;
				ValaProperty* _tmp71_;
				ValaProperty* _tmp72_;
				ValaObjectType* _tmp73_;
				ValaObjectType* _tmp74_;
				ValaCCodeExpression* _tmp75_;
				ValaGLibValue* _tmp76_;
				ValaGLibValue* _tmp77_;
				ValaClass* _tmp78_;
				ValaObjectType* _tmp79_;
				ValaObjectType* _tmp80_;
				ValaProperty* _tmp81_;
				ValaTargetValue* _tmp82_;
				ValaTargetValue* _tmp83_;
				ValaCCodeExpression* _tmp84_;
				ValaProperty* _tmp85_;
				ValaProperty* _tmp86_;
				ValaProperty* _tmp87_;
				ValaPropertyAccessor* _tmp88_;
				ValaPropertyAccessor* _tmp89_;
				ValaCCodeFile* _tmp90_;
				_tmp63_ = prop;
				_tmp64_ = vala_property_get_base_property (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_CLASS, ValaClass));
				base_type = _tmp68_;
				_tmp69_ = prop;
				_tmp70_ = vala_property_get_base_property (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = _vala_code_node_ref0 (_tmp71_);
				_vala_code_node_unref0 (base_prop);
				base_prop = _tmp72_;
				_tmp73_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
				_tmp74_ = _tmp73_;
				_tmp75_ = cself;
				_tmp76_ = vala_glib_value_new ((ValaDataType*) _tmp74_, _tmp75_, TRUE);
				_tmp77_ = _tmp76_;
				_tmp78_ = base_type;
				_tmp79_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = prop;
				_tmp82_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp77_, (ValaDataType*) _tmp80_, (ValaCodeNode*) _tmp81_);
				_tmp83_ = _tmp82_;
				_tmp84_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp83_);
				_vala_ccode_node_unref0 (cself);
				cself = _tmp84_;
				_vala_target_value_unref0 (_tmp83_);
				_vala_code_node_unref0 (_tmp80_);
				_vala_target_value_unref0 (_tmp77_);
				_vala_code_node_unref0 (_tmp74_);
				_tmp85_ = prop;
				_tmp86_ = vala_property_get_base_property (_tmp85_);
				_tmp87_ = _tmp86_;
				_tmp88_ = vala_property_get_set_accessor (_tmp87_);
				_tmp89_ = _tmp88_;
				_tmp90_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp89_, _tmp90_);
				_vala_code_node_unref0 (base_type);
			} else {
				ValaProperty* _tmp91_;
				ValaProperty* _tmp92_;
				ValaProperty* _tmp93_;
				_tmp91_ = prop;
				_tmp92_ = vala_property_get_base_interface_property (_tmp91_);
				_tmp93_ = _tmp92_;
				if (_tmp93_ != NULL) {
					ValaInterface* base_type = NULL;
					ValaProperty* _tmp94_;
					ValaProperty* _tmp95_;
					ValaProperty* _tmp96_;
					ValaSymbol* _tmp97_;
					ValaSymbol* _tmp98_;
					ValaInterface* _tmp99_;
					ValaProperty* _tmp100_;
					ValaProperty* _tmp101_;
					ValaProperty* _tmp102_;
					ValaProperty* _tmp103_;
					ValaObjectType* _tmp104_;
					ValaObjectType* _tmp105_;
					ValaCCodeExpression* _tmp106_;
					ValaGLibValue* _tmp107_;
					ValaGLibValue* _tmp108_;
					ValaInterface* _tmp109_;
					ValaObjectType* _tmp110_;
					ValaObjectType* _tmp111_;
					ValaProperty* _tmp112_;
					ValaTargetValue* _tmp113_;
					ValaTargetValue* _tmp114_;
					ValaCCodeExpression* _tmp115_;
					ValaProperty* _tmp116_;
					ValaProperty* _tmp117_;
					ValaProperty* _tmp118_;
					ValaPropertyAccessor* _tmp119_;
					ValaPropertyAccessor* _tmp120_;
					ValaCCodeFile* _tmp121_;
					_tmp94_ = prop;
					_tmp95_ = vala_property_get_base_interface_property (_tmp94_);
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp96_);
					_tmp98_ = _tmp97_;
					_tmp99_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_INTERFACE, ValaInterface));
					base_type = _tmp99_;
					_tmp100_ = prop;
					_tmp101_ = vala_property_get_base_interface_property (_tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = _vala_code_node_ref0 (_tmp102_);
					_vala_code_node_unref0 (base_prop);
					base_prop = _tmp103_;
					_tmp104_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
					_tmp105_ = _tmp104_;
					_tmp106_ = cself;
					_tmp107_ = vala_glib_value_new ((ValaDataType*) _tmp105_, _tmp106_, TRUE);
					_tmp108_ = _tmp107_;
					_tmp109_ = base_type;
					_tmp110_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = prop;
					_tmp113_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp108_, (ValaDataType*) _tmp111_, (ValaCodeNode*) _tmp112_);
					_tmp114_ = _tmp113_;
					_tmp115_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp114_);
					_vala_ccode_node_unref0 (cself);
					cself = _tmp115_;
					_vala_target_value_unref0 (_tmp114_);
					_vala_code_node_unref0 (_tmp111_);
					_vala_target_value_unref0 (_tmp108_);
					_vala_code_node_unref0 (_tmp105_);
					_tmp116_ = prop;
					_tmp117_ = vala_property_get_base_interface_property (_tmp116_);
					_tmp118_ = _tmp117_;
					_tmp119_ = vala_property_get_set_accessor (_tmp118_);
					_tmp120_ = _tmp119_;
					_tmp121_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp120_, _tmp121_);
					_vala_code_node_unref0 (base_type);
				}
			}
			_tmp123_ = base_prop;
			if (!vala_get_ccode_no_accessor_method (_tmp123_)) {
				ValaProperty* _tmp124_;
				_tmp124_ = base_prop;
				_tmp122_ = !vala_get_ccode_concrete_accessor (_tmp124_);
			} else {
				_tmp122_ = FALSE;
			}
			if (_tmp122_) {
				ValaProperty* _tmp125_;
				ValaPropertyAccessor* _tmp126_;
				ValaPropertyAccessor* _tmp127_;
				gchar* _tmp128_;
				gchar* _tmp129_;
				ValaCCodeIdentifier* _tmp130_;
				_tmp125_ = base_prop;
				_tmp126_ = vala_property_get_set_accessor (_tmp125_);
				_tmp127_ = _tmp126_;
				_tmp128_ = vala_get_ccode_name ((ValaCodeNode*) _tmp127_);
				_tmp129_ = _tmp128_;
				_tmp130_ = vala_ccode_identifier_new (_tmp129_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp130_;
				_g_free0 (_tmp129_);
			} else {
				ValaProperty* _tmp131_;
				ValaPropertyAccessor* _tmp132_;
				ValaPropertyAccessor* _tmp133_;
				gchar* _tmp134_;
				gchar* _tmp135_;
				ValaCCodeIdentifier* _tmp136_;
				_tmp131_ = prop;
				_tmp132_ = vala_property_get_set_accessor (_tmp131_);
				_tmp133_ = _tmp132_;
				_tmp134_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp133_);
				_tmp135_ = _tmp134_;
				_tmp136_ = vala_ccode_identifier_new (_tmp135_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp136_;
				_g_free0 (_tmp135_);
			}
			_tmp137_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp138_ = _tmp137_;
			_tmp139_ = prop;
			_tmp140_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp139_, NULL);
			_tmp141_ = _tmp140_;
			_tmp142_ = g_strdup_printf ("%s_PROPERTY", _tmp141_);
			_tmp143_ = _tmp142_;
			_tmp144_ = vala_ccode_identifier_new (_tmp143_);
			_tmp145_ = _tmp144_;
			vala_ccode_function_add_case (_tmp138_, (ValaCCodeExpression*) _tmp145_);
			_vala_ccode_node_unref0 (_tmp145_);
			_g_free0 (_tmp143_);
			_g_free0 (_tmp141_);
			_tmp146_ = cfunc;
			_tmp147_ = vala_ccode_function_call_new (_tmp146_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp147_;
			_tmp148_ = ccall;
			_tmp149_ = cself;
			vala_ccode_function_call_add_argument (_tmp148_, _tmp149_);
			_tmp151_ = prop;
			_tmp152_ = vala_property_get_property_type (_tmp151_);
			_tmp153_ = _tmp152_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp153_, VALA_TYPE_ARRAY_TYPE)) {
				ValaProperty* _tmp154_;
				ValaDataType* _tmp155_;
				ValaDataType* _tmp156_;
				ValaDataType* _tmp157_;
				ValaDataType* _tmp158_;
				ValaTypeSymbol* _tmp159_;
				ValaTypeSymbol* _tmp160_;
				ValaDataType* _tmp161_;
				ValaTypeSymbol* _tmp162_;
				ValaTypeSymbol* _tmp163_;
				_tmp154_ = prop;
				_tmp155_ = vala_property_get_property_type (_tmp154_);
				_tmp156_ = _tmp155_;
				_tmp157_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp156_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp158_ = _tmp157_;
				_tmp159_ = vala_data_type_get_data_type (_tmp158_);
				_tmp160_ = _tmp159_;
				_tmp161_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp162_ = vala_data_type_get_data_type (_tmp161_);
				_tmp163_ = _tmp162_;
				_tmp150_ = _tmp160_ == _tmp163_;
			} else {
				_tmp150_ = FALSE;
			}
			if (_tmp150_) {
				ValaCCodeFunction* _tmp164_;
				ValaCCodeFunction* _tmp165_;
				ValaCCodeFunction* _tmp166_;
				ValaCCodeFunction* _tmp167_;
				ValaCCodeVariableDeclarator* _tmp168_;
				ValaCCodeVariableDeclarator* _tmp169_;
				ValaCCodeFunctionCall* cgetcall = NULL;
				ValaCCodeIdentifier* _tmp170_;
				ValaCCodeIdentifier* _tmp171_;
				ValaCCodeFunctionCall* _tmp172_;
				ValaCCodeFunctionCall* _tmp173_;
				ValaCCodeFunctionCall* _tmp174_;
				ValaCCodeIdentifier* _tmp175_;
				ValaCCodeIdentifier* _tmp176_;
				ValaCCodeFunction* _tmp177_;
				ValaCCodeFunction* _tmp178_;
				ValaCCodeIdentifier* _tmp179_;
				ValaCCodeIdentifier* _tmp180_;
				ValaCCodeFunctionCall* _tmp181_;
				ValaCCodeFunctionCall* _tmp182_;
				ValaCCodeIdentifier* _tmp183_;
				ValaCCodeIdentifier* _tmp184_;
				ValaCCodeBinaryExpression* cisnull = NULL;
				ValaCCodeIdentifier* _tmp185_;
				ValaCCodeIdentifier* _tmp186_;
				ValaCCodeConstant* _tmp187_;
				ValaCCodeConstant* _tmp188_;
				ValaCCodeBinaryExpression* _tmp189_;
				ValaCCodeBinaryExpression* _tmp190_;
				ValaCCodeFunctionCall* cstrvlen = NULL;
				ValaCCodeIdentifier* _tmp191_;
				ValaCCodeIdentifier* _tmp192_;
				ValaCCodeFunctionCall* _tmp193_;
				ValaCCodeFunctionCall* _tmp194_;
				ValaCCodeFunctionCall* _tmp195_;
				ValaCCodeIdentifier* _tmp196_;
				ValaCCodeIdentifier* _tmp197_;
				ValaCCodeConditionalExpression* ccond = NULL;
				ValaCCodeBinaryExpression* _tmp198_;
				ValaCCodeConstant* _tmp199_;
				ValaCCodeConstant* _tmp200_;
				ValaCCodeFunctionCall* _tmp201_;
				ValaCCodeConditionalExpression* _tmp202_;
				ValaCCodeConditionalExpression* _tmp203_;
				ValaCCodeFunctionCall* _tmp204_;
				ValaCCodeConditionalExpression* _tmp205_;
				ValaProperty* _tmp206_;
				ValaCCodeFunctionCall* _tmp207_;
				ValaCCodeFunction* _tmp208_;
				ValaCCodeFunction* _tmp209_;
				_tmp164_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp165_ = _tmp164_;
				vala_ccode_function_open_block (_tmp165_);
				_tmp166_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp167_ = _tmp166_;
				_tmp168_ = vala_ccode_variable_declarator_new ("boxed", NULL, NULL);
				_tmp169_ = _tmp168_;
				vala_ccode_function_add_declaration (_tmp167_, "gpointer", (ValaCCodeDeclarator*) _tmp169_, 0);
				_vala_ccode_node_unref0 (_tmp169_);
				_tmp170_ = vala_ccode_identifier_new ("g_value_get_boxed");
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp171_);
				_tmp173_ = _tmp172_;
				_vala_ccode_node_unref0 (_tmp171_);
				cgetcall = _tmp173_;
				_tmp174_ = cgetcall;
				_tmp175_ = vala_ccode_identifier_new ("value");
				_tmp176_ = _tmp175_;
				vala_ccode_function_call_add_argument (_tmp174_, (ValaCCodeExpression*) _tmp176_);
				_vala_ccode_node_unref0 (_tmp176_);
				_tmp177_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp178_ = _tmp177_;
				_tmp179_ = vala_ccode_identifier_new ("boxed");
				_tmp180_ = _tmp179_;
				_tmp181_ = cgetcall;
				vala_ccode_function_add_assignment (_tmp178_, (ValaCCodeExpression*) _tmp180_, (ValaCCodeExpression*) _tmp181_);
				_vala_ccode_node_unref0 (_tmp180_);
				_tmp182_ = ccall;
				_tmp183_ = vala_ccode_identifier_new ("boxed");
				_tmp184_ = _tmp183_;
				vala_ccode_function_call_add_argument (_tmp182_, (ValaCCodeExpression*) _tmp184_);
				_vala_ccode_node_unref0 (_tmp184_);
				_tmp185_ = vala_ccode_identifier_new ("boxed");
				_tmp186_ = _tmp185_;
				_tmp187_ = vala_ccode_constant_new ("NULL");
				_tmp188_ = _tmp187_;
				_tmp189_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp186_, (ValaCCodeExpression*) _tmp188_);
				_tmp190_ = _tmp189_;
				_vala_ccode_node_unref0 (_tmp188_);
				_vala_ccode_node_unref0 (_tmp186_);
				cisnull = _tmp190_;
				_tmp191_ = vala_ccode_identifier_new ("g_strv_length");
				_tmp192_ = _tmp191_;
				_tmp193_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp192_);
				_tmp194_ = _tmp193_;
				_vala_ccode_node_unref0 (_tmp192_);
				cstrvlen = _tmp194_;
				_tmp195_ = cstrvlen;
				_tmp196_ = vala_ccode_identifier_new ("boxed");
				_tmp197_ = _tmp196_;
				vala_ccode_function_call_add_argument (_tmp195_, (ValaCCodeExpression*) _tmp197_);
				_vala_ccode_node_unref0 (_tmp197_);
				_tmp198_ = cisnull;
				_tmp199_ = vala_ccode_constant_new ("0");
				_tmp200_ = _tmp199_;
				_tmp201_ = cstrvlen;
				_tmp202_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp198_, (ValaCCodeExpression*) _tmp200_, (ValaCCodeExpression*) _tmp201_);
				_tmp203_ = _tmp202_;
				_vala_ccode_node_unref0 (_tmp200_);
				ccond = _tmp203_;
				_tmp204_ = ccall;
				_tmp205_ = ccond;
				vala_ccode_function_call_add_argument (_tmp204_, (ValaCCodeExpression*) _tmp205_);
				_tmp206_ = prop;
				_tmp207_ = ccall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp206_, (ValaCCodeExpression*) _tmp207_);
				_tmp208_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp209_ = _tmp208_;
				vala_ccode_function_close (_tmp209_);
				_vala_ccode_node_unref0 (ccond);
				_vala_ccode_node_unref0 (cstrvlen);
				_vala_ccode_node_unref0 (cisnull);
				_vala_ccode_node_unref0 (cgetcall);
			} else {
				ValaCCodeFunctionCall* cgetcall = NULL;
				ValaCCodeFunctionCall* _tmp210_;
				ValaProperty* _tmp211_;
				ValaDataType* _tmp212_;
				ValaDataType* _tmp213_;
				ValaTypeSymbol* _tmp214_;
				ValaTypeSymbol* _tmp215_;
				ValaCCodeFunctionCall* _tmp229_;
				ValaCCodeIdentifier* _tmp230_;
				ValaCCodeIdentifier* _tmp231_;
				ValaCCodeFunctionCall* _tmp232_;
				ValaCCodeFunctionCall* _tmp233_;
				ValaProperty* _tmp234_;
				ValaCCodeFunctionCall* _tmp235_;
				_tmp210_ = vala_ccode_function_call_new (NULL);
				cgetcall = _tmp210_;
				_tmp211_ = prop;
				_tmp212_ = vala_property_get_property_type (_tmp211_);
				_tmp213_ = _tmp212_;
				_tmp214_ = vala_data_type_get_data_type (_tmp213_);
				_tmp215_ = _tmp214_;
				if (_tmp215_ != NULL) {
					ValaCCodeFunctionCall* _tmp216_;
					ValaProperty* _tmp217_;
					ValaDataType* _tmp218_;
					ValaDataType* _tmp219_;
					ValaTypeSymbol* _tmp220_;
					ValaTypeSymbol* _tmp221_;
					gchar* _tmp222_;
					gchar* _tmp223_;
					ValaCCodeIdentifier* _tmp224_;
					ValaCCodeIdentifier* _tmp225_;
					_tmp216_ = cgetcall;
					_tmp217_ = prop;
					_tmp218_ = vala_property_get_property_type (_tmp217_);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_data_type_get_data_type (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp221_);
					_tmp223_ = _tmp222_;
					_tmp224_ = vala_ccode_identifier_new (_tmp223_);
					_tmp225_ = _tmp224_;
					vala_ccode_function_call_set_call (_tmp216_, (ValaCCodeExpression*) _tmp225_);
					_vala_ccode_node_unref0 (_tmp225_);
					_g_free0 (_tmp223_);
				} else {
					ValaCCodeFunctionCall* _tmp226_;
					ValaCCodeIdentifier* _tmp227_;
					ValaCCodeIdentifier* _tmp228_;
					_tmp226_ = cgetcall;
					_tmp227_ = vala_ccode_identifier_new ("g_value_get_pointer");
					_tmp228_ = _tmp227_;
					vala_ccode_function_call_set_call (_tmp226_, (ValaCCodeExpression*) _tmp228_);
					_vala_ccode_node_unref0 (_tmp228_);
				}
				_tmp229_ = cgetcall;
				_tmp230_ = vala_ccode_identifier_new ("value");
				_tmp231_ = _tmp230_;
				vala_ccode_function_call_add_argument (_tmp229_, (ValaCCodeExpression*) _tmp231_);
				_vala_ccode_node_unref0 (_tmp231_);
				_tmp232_ = ccall;
				_tmp233_ = cgetcall;
				vala_ccode_function_call_add_argument (_tmp232_, (ValaCCodeExpression*) _tmp233_);
				_tmp234_ = prop;
				_tmp235_ = ccall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp234_, (ValaCCodeExpression*) _tmp235_);
				_vala_ccode_node_unref0 (cgetcall);
			}
			_tmp236_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp237_ = _tmp236_;
			vala_ccode_function_add_break (_tmp237_);
			_vala_ccode_node_unref0 (cfunc);
			_vala_ccode_node_unref0 (cself);
			_vala_code_node_unref0 (base_prop);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp238_;
		gint _type_param_size = 0;
		ValaList* _tmp239_;
		gint _tmp240_;
		gint _tmp241_;
		gint _type_param_index = 0;
		_tmp238_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_type_param_list = _tmp238_;
		_tmp239_ = _type_param_list;
		_tmp240_ = vala_collection_get_size ((ValaCollection*) _tmp239_);
		_tmp241_ = _tmp240_;
		_type_param_size = _tmp241_;
		_type_param_index = -1;
		while (TRUE) {
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp242_;
			gpointer _tmp243_;
			gchar* func_name = NULL;
			gchar* enum_value = NULL;
			ValaCCodeMemberAccess* cfield = NULL;
			ValaCCodeFunctionCall* cgetcall = NULL;
			ValaTypeParameter* _tmp244_;
			const gchar* _tmp245_;
			const gchar* _tmp246_;
			gchar* _tmp247_;
			gchar* _tmp248_;
			gchar* _tmp249_;
			gchar* _tmp250_;
			gchar* _tmp251_;
			const gchar* _tmp252_;
			gchar* _tmp253_;
			gchar* _tmp254_;
			gchar* _tmp255_;
			ValaCCodeFunction* _tmp256_;
			ValaCCodeFunction* _tmp257_;
			const gchar* _tmp258_;
			ValaCCodeIdentifier* _tmp259_;
			ValaCCodeIdentifier* _tmp260_;
			ValaCCodeIdentifier* _tmp261_;
			ValaCCodeIdentifier* _tmp262_;
			ValaCCodeMemberAccess* _tmp263_;
			ValaCCodeMemberAccess* _tmp264_;
			const gchar* _tmp265_;
			ValaCCodeMemberAccess* _tmp266_;
			ValaCCodeIdentifier* _tmp267_;
			ValaCCodeIdentifier* _tmp268_;
			ValaCCodeFunctionCall* _tmp269_;
			ValaCCodeFunctionCall* _tmp270_;
			ValaCCodeIdentifier* _tmp271_;
			ValaCCodeIdentifier* _tmp272_;
			ValaCCodeFunction* _tmp273_;
			ValaCCodeFunction* _tmp274_;
			ValaCCodeMemberAccess* _tmp275_;
			ValaCCodeFunctionCall* _tmp276_;
			ValaCCodeFunction* _tmp277_;
			ValaCCodeFunction* _tmp278_;
			ValaTypeParameter* _tmp279_;
			const gchar* _tmp280_;
			const gchar* _tmp281_;
			gchar* _tmp282_;
			gchar* _tmp283_;
			gchar* _tmp284_;
			gchar* _tmp285_;
			gchar* _tmp286_;
			const gchar* _tmp287_;
			gchar* _tmp288_;
			gchar* _tmp289_;
			gchar* _tmp290_;
			ValaCCodeFunction* _tmp291_;
			ValaCCodeFunction* _tmp292_;
			const gchar* _tmp293_;
			ValaCCodeIdentifier* _tmp294_;
			ValaCCodeIdentifier* _tmp295_;
			ValaCCodeIdentifier* _tmp296_;
			ValaCCodeIdentifier* _tmp297_;
			ValaCCodeMemberAccess* _tmp298_;
			ValaCCodeMemberAccess* _tmp299_;
			const gchar* _tmp300_;
			ValaCCodeMemberAccess* _tmp301_;
			ValaCCodeIdentifier* _tmp302_;
			ValaCCodeIdentifier* _tmp303_;
			ValaCCodeFunctionCall* _tmp304_;
			ValaCCodeFunctionCall* _tmp305_;
			ValaCCodeIdentifier* _tmp306_;
			ValaCCodeIdentifier* _tmp307_;
			ValaCCodeFunction* _tmp308_;
			ValaCCodeFunction* _tmp309_;
			ValaCCodeMemberAccess* _tmp310_;
			ValaCCodeFunctionCall* _tmp311_;
			ValaCCodeFunction* _tmp312_;
			ValaCCodeFunction* _tmp313_;
			ValaTypeParameter* _tmp314_;
			const gchar* _tmp315_;
			const gchar* _tmp316_;
			gchar* _tmp317_;
			gchar* _tmp318_;
			gchar* _tmp319_;
			gchar* _tmp320_;
			gchar* _tmp321_;
			const gchar* _tmp322_;
			gchar* _tmp323_;
			gchar* _tmp324_;
			gchar* _tmp325_;
			ValaCCodeFunction* _tmp326_;
			ValaCCodeFunction* _tmp327_;
			const gchar* _tmp328_;
			ValaCCodeIdentifier* _tmp329_;
			ValaCCodeIdentifier* _tmp330_;
			ValaCCodeIdentifier* _tmp331_;
			ValaCCodeIdentifier* _tmp332_;
			ValaCCodeMemberAccess* _tmp333_;
			ValaCCodeMemberAccess* _tmp334_;
			const gchar* _tmp335_;
			ValaCCodeMemberAccess* _tmp336_;
			ValaCCodeIdentifier* _tmp337_;
			ValaCCodeIdentifier* _tmp338_;
			ValaCCodeFunctionCall* _tmp339_;
			ValaCCodeFunctionCall* _tmp340_;
			ValaCCodeIdentifier* _tmp341_;
			ValaCCodeIdentifier* _tmp342_;
			ValaCCodeFunction* _tmp343_;
			ValaCCodeFunction* _tmp344_;
			ValaCCodeMemberAccess* _tmp345_;
			ValaCCodeFunctionCall* _tmp346_;
			ValaCCodeFunction* _tmp347_;
			ValaCCodeFunction* _tmp348_;
			_type_param_index = _type_param_index + 1;
			if (!(_type_param_index < _type_param_size)) {
				break;
			}
			_tmp242_ = _type_param_list;
			_tmp243_ = vala_list_get (_tmp242_, _type_param_index);
			type_param = (ValaTypeParameter*) _tmp243_;
			_tmp244_ = type_param;
			_tmp245_ = vala_symbol_get_name ((ValaSymbol*) _tmp244_);
			_tmp246_ = _tmp245_;
			_tmp247_ = g_ascii_strdown (_tmp246_, (gssize) -1);
			_tmp248_ = _tmp247_;
			_tmp249_ = g_strdup_printf ("%s_type", _tmp248_);
			_g_free0 (func_name);
			func_name = _tmp249_;
			_g_free0 (_tmp248_);
			_tmp250_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp251_ = _tmp250_;
			_tmp252_ = func_name;
			_tmp253_ = g_strdup_printf ("%s_%s", _tmp251_, _tmp252_);
			_tmp254_ = _tmp253_;
			_tmp255_ = g_ascii_strup (_tmp254_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp255_;
			_g_free0 (_tmp254_);
			_g_free0 (_tmp251_);
			_tmp256_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp257_ = _tmp256_;
			_tmp258_ = enum_value;
			_tmp259_ = vala_ccode_identifier_new (_tmp258_);
			_tmp260_ = _tmp259_;
			vala_ccode_function_add_case (_tmp257_, (ValaCCodeExpression*) _tmp260_);
			_vala_ccode_node_unref0 (_tmp260_);
			_tmp261_ = vala_ccode_identifier_new ("self");
			_tmp262_ = _tmp261_;
			_tmp263_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp262_, "priv");
			_tmp264_ = _tmp263_;
			_tmp265_ = func_name;
			_tmp266_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp264_, _tmp265_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp266_;
			_vala_ccode_node_unref0 (_tmp264_);
			_vala_ccode_node_unref0 (_tmp262_);
			_tmp267_ = vala_ccode_identifier_new ("g_value_get_gtype");
			_tmp268_ = _tmp267_;
			_tmp269_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp268_);
			_vala_ccode_node_unref0 (cgetcall);
			cgetcall = _tmp269_;
			_vala_ccode_node_unref0 (_tmp268_);
			_tmp270_ = cgetcall;
			_tmp271_ = vala_ccode_identifier_new ("value");
			_tmp272_ = _tmp271_;
			vala_ccode_function_call_add_argument (_tmp270_, (ValaCCodeExpression*) _tmp272_);
			_vala_ccode_node_unref0 (_tmp272_);
			_tmp273_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp274_ = _tmp273_;
			_tmp275_ = cfield;
			_tmp276_ = cgetcall;
			vala_ccode_function_add_assignment (_tmp274_, (ValaCCodeExpression*) _tmp275_, (ValaCCodeExpression*) _tmp276_);
			_tmp277_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp278_ = _tmp277_;
			vala_ccode_function_add_break (_tmp278_);
			_tmp279_ = type_param;
			_tmp280_ = vala_symbol_get_name ((ValaSymbol*) _tmp279_);
			_tmp281_ = _tmp280_;
			_tmp282_ = g_ascii_strdown (_tmp281_, (gssize) -1);
			_tmp283_ = _tmp282_;
			_tmp284_ = g_strdup_printf ("%s_dup_func", _tmp283_);
			_g_free0 (func_name);
			func_name = _tmp284_;
			_g_free0 (_tmp283_);
			_tmp285_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp286_ = _tmp285_;
			_tmp287_ = func_name;
			_tmp288_ = g_strdup_printf ("%s_%s", _tmp286_, _tmp287_);
			_tmp289_ = _tmp288_;
			_tmp290_ = g_ascii_strup (_tmp289_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp290_;
			_g_free0 (_tmp289_);
			_g_free0 (_tmp286_);
			_tmp291_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp292_ = _tmp291_;
			_tmp293_ = enum_value;
			_tmp294_ = vala_ccode_identifier_new (_tmp293_);
			_tmp295_ = _tmp294_;
			vala_ccode_function_add_case (_tmp292_, (ValaCCodeExpression*) _tmp295_);
			_vala_ccode_node_unref0 (_tmp295_);
			_tmp296_ = vala_ccode_identifier_new ("self");
			_tmp297_ = _tmp296_;
			_tmp298_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp297_, "priv");
			_tmp299_ = _tmp298_;
			_tmp300_ = func_name;
			_tmp301_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp299_, _tmp300_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp301_;
			_vala_ccode_node_unref0 (_tmp299_);
			_vala_ccode_node_unref0 (_tmp297_);
			_tmp302_ = vala_ccode_identifier_new ("g_value_get_pointer");
			_tmp303_ = _tmp302_;
			_tmp304_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp303_);
			_vala_ccode_node_unref0 (cgetcall);
			cgetcall = _tmp304_;
			_vala_ccode_node_unref0 (_tmp303_);
			_tmp305_ = cgetcall;
			_tmp306_ = vala_ccode_identifier_new ("value");
			_tmp307_ = _tmp306_;
			vala_ccode_function_call_add_argument (_tmp305_, (ValaCCodeExpression*) _tmp307_);
			_vala_ccode_node_unref0 (_tmp307_);
			_tmp308_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp309_ = _tmp308_;
			_tmp310_ = cfield;
			_tmp311_ = cgetcall;
			vala_ccode_function_add_assignment (_tmp309_, (ValaCCodeExpression*) _tmp310_, (ValaCCodeExpression*) _tmp311_);
			_tmp312_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp313_ = _tmp312_;
			vala_ccode_function_add_break (_tmp313_);
			_tmp314_ = type_param;
			_tmp315_ = vala_symbol_get_name ((ValaSymbol*) _tmp314_);
			_tmp316_ = _tmp315_;
			_tmp317_ = g_ascii_strdown (_tmp316_, (gssize) -1);
			_tmp318_ = _tmp317_;
			_tmp319_ = g_strdup_printf ("%s_destroy_func", _tmp318_);
			_g_free0 (func_name);
			func_name = _tmp319_;
			_g_free0 (_tmp318_);
			_tmp320_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp321_ = _tmp320_;
			_tmp322_ = func_name;
			_tmp323_ = g_strdup_printf ("%s_%s", _tmp321_, _tmp322_);
			_tmp324_ = _tmp323_;
			_tmp325_ = g_ascii_strup (_tmp324_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp325_;
			_g_free0 (_tmp324_);
			_g_free0 (_tmp321_);
			_tmp326_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp327_ = _tmp326_;
			_tmp328_ = enum_value;
			_tmp329_ = vala_ccode_identifier_new (_tmp328_);
			_tmp330_ = _tmp329_;
			vala_ccode_function_add_case (_tmp327_, (ValaCCodeExpression*) _tmp330_);
			_vala_ccode_node_unref0 (_tmp330_);
			_tmp331_ = vala_ccode_identifier_new ("self");
			_tmp332_ = _tmp331_;
			_tmp333_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp332_, "priv");
			_tmp334_ = _tmp333_;
			_tmp335_ = func_name;
			_tmp336_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp334_, _tmp335_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp336_;
			_vala_ccode_node_unref0 (_tmp334_);
			_vala_ccode_node_unref0 (_tmp332_);
			_tmp337_ = vala_ccode_identifier_new ("g_value_get_pointer");
			_tmp338_ = _tmp337_;
			_tmp339_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp338_);
			_vala_ccode_node_unref0 (cgetcall);
			cgetcall = _tmp339_;
			_vala_ccode_node_unref0 (_tmp338_);
			_tmp340_ = cgetcall;
			_tmp341_ = vala_ccode_identifier_new ("value");
			_tmp342_ = _tmp341_;
			vala_ccode_function_call_add_argument (_tmp340_, (ValaCCodeExpression*) _tmp342_);
			_vala_ccode_node_unref0 (_tmp342_);
			_tmp343_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp344_ = _tmp343_;
			_tmp345_ = cfield;
			_tmp346_ = cgetcall;
			vala_ccode_function_add_assignment (_tmp344_, (ValaCCodeExpression*) _tmp345_, (ValaCCodeExpression*) _tmp346_);
			_tmp347_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp348_ = _tmp347_;
			vala_ccode_function_add_break (_tmp348_);
			_vala_ccode_node_unref0 (cgetcall);
			_vala_ccode_node_unref0 (cfield);
			_g_free0 (enum_value);
			_g_free0 (func_name);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	_tmp349_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp350_ = _tmp349_;
	vala_ccode_function_add_default (_tmp350_);
	vala_gobject_module_emit_invalid_property_id_warn (self);
	_tmp351_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp352_ = _tmp351_;
	vala_ccode_function_add_break (_tmp352_);
	_tmp353_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp354_ = _tmp353_;
	vala_ccode_function_close (_tmp354_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp355_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp356_ = set_prop;
	vala_ccode_file_add_function_declaration (_tmp355_, _tmp356_);
	_tmp357_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp358_ = set_prop;
	vala_ccode_file_add_function (_tmp357_, _tmp358_);
	_vala_iterable_unref0 (props);
	_vala_ccode_node_unref0 (ccall);
	_vala_ccode_node_unref0 (set_prop);
}

static void
vala_gobject_module_emit_invalid_property_id_warn (ValaGObjectModule* self)
{
	ValaCCodeFunctionCall* cwarn = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_ccode_identifier_new ("G_OBJECT_WARN_INVALID_PROPERTY_ID");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	cwarn = _tmp3_;
	_tmp4_ = vala_ccode_identifier_new ("object");
	_tmp5_ = _tmp4_;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) _tmp5_);
	_vala_ccode_node_unref0 (_tmp5_);
	_tmp6_ = vala_ccode_identifier_new ("property_id");
	_tmp7_ = _tmp6_;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = vala_ccode_identifier_new ("pspec");
	_tmp9_ = _tmp8_;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp11_ = _tmp10_;
	vala_ccode_function_add_expression (_tmp11_, (ValaCCodeExpression*) cwarn);
	_vala_ccode_node_unref0 (cwarn);
}

static void
vala_gobject_module_real_visit_constructor (ValaCodeVisitor* base,
                                            ValaConstructor* c)
{
	ValaGObjectModule * self;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaClass* cl = NULL;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaClass* _tmp4_;
	ValaMemberBinding _tmp5_;
	ValaMemberBinding _tmp6_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
	_tmp1_ = _tmp0_;
	vala_ccode_base_module_push_line ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) c);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
	cl = _tmp4_;
	_tmp5_ = vala_constructor_get_binding (c);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaClass* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaCCodeBaseModuleEmitContext* _tmp11_;
		ValaCCodeBaseModuleEmitContext* _tmp12_;
		ValaCCodeFunction* function = NULL;
		ValaClass* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		ValaCCodeFunction* _tmp18_;
		ValaCCodeFunction* _tmp19_;
		ValaCCodeFunction* _tmp20_;
		ValaCCodeFunction* _tmp21_;
		ValaCCodeParameter* _tmp22_;
		ValaCCodeParameter* _tmp23_;
		ValaCCodeFunction* _tmp24_;
		ValaCCodeParameter* _tmp25_;
		ValaCCodeParameter* _tmp26_;
		ValaCCodeFunction* _tmp27_;
		ValaCCodeParameter* _tmp28_;
		ValaCCodeParameter* _tmp29_;
		ValaCCodeFile* _tmp30_;
		ValaCCodeFunction* _tmp31_;
		ValaCCodeFunction* _tmp32_;
		ValaCCodeFunction* _tmp33_;
		ValaCCodeFunction* _tmp34_;
		ValaCCodeVariableDeclarator* _tmp35_;
		ValaCCodeVariableDeclarator* _tmp36_;
		ValaCCodeFunction* _tmp37_;
		ValaCCodeFunction* _tmp38_;
		ValaCCodeVariableDeclarator* _tmp39_;
		ValaCCodeVariableDeclarator* _tmp40_;
		ValaClass* _tmp41_;
		gboolean _tmp42_;
		gboolean _tmp43_;
		ValaCCodeFunctionCall* ccast = NULL;
		ValaCCodeIdentifier* _tmp199_;
		ValaCCodeIdentifier* _tmp200_;
		ValaCCodeFunctionCall* _tmp201_;
		ValaCCodeFunctionCall* _tmp202_;
		ValaCCodeFunctionCall* _tmp203_;
		ValaClass* _tmp204_;
		gchar* _tmp205_;
		gchar* _tmp206_;
		gchar* _tmp207_;
		gchar* _tmp208_;
		ValaCCodeIdentifier* _tmp209_;
		ValaCCodeIdentifier* _tmp210_;
		ValaCCodeFunction* _tmp211_;
		ValaCCodeFunction* _tmp212_;
		ValaCCodeIdentifier* _tmp213_;
		ValaCCodeIdentifier* _tmp214_;
		ValaCCodeFunctionCall* _tmp215_;
		ValaCCodeFunctionCall* ccall = NULL;
		ValaCCodeIdentifier* _tmp216_;
		ValaCCodeIdentifier* _tmp217_;
		ValaCCodeMemberAccess* _tmp218_;
		ValaCCodeMemberAccess* _tmp219_;
		ValaCCodeFunctionCall* _tmp220_;
		ValaCCodeFunctionCall* _tmp221_;
		ValaCCodeFunctionCall* _tmp222_;
		ValaCCodeIdentifier* _tmp223_;
		ValaCCodeIdentifier* _tmp224_;
		ValaCCodeFunctionCall* _tmp225_;
		ValaCCodeIdentifier* _tmp226_;
		ValaCCodeIdentifier* _tmp227_;
		ValaCCodeFunctionCall* _tmp228_;
		ValaCCodeIdentifier* _tmp229_;
		ValaCCodeIdentifier* _tmp230_;
		ValaCCodeFunction* _tmp231_;
		ValaCCodeFunction* _tmp232_;
		ValaCCodeIdentifier* _tmp233_;
		ValaCCodeIdentifier* _tmp234_;
		ValaCCodeFunctionCall* _tmp235_;
		ValaCCodeIdentifier* _tmp236_;
		ValaCCodeIdentifier* _tmp237_;
		ValaClass* _tmp238_;
		ValaCCodeFunctionCall* _tmp239_;
		ValaCCodeFunction* _tmp240_;
		ValaCCodeFunction* _tmp241_;
		ValaClass* _tmp242_;
		gchar* _tmp243_;
		gchar* _tmp244_;
		gchar* _tmp245_;
		gchar* _tmp246_;
		ValaCCodeVariableDeclarator* _tmp247_;
		ValaCCodeVariableDeclarator* _tmp248_;
		ValaCCodeFunction* _tmp249_;
		ValaCCodeFunction* _tmp250_;
		ValaCCodeIdentifier* _tmp251_;
		ValaCCodeIdentifier* _tmp252_;
		ValaCCodeFunctionCall* _tmp253_;
		ValaBlock* _tmp254_;
		ValaBlock* _tmp255_;
		gboolean _tmp256_;
		gboolean _tmp257_;
		ValaClass* _tmp268_;
		gboolean _tmp269_;
		gboolean _tmp270_;
		ValaCCodeFunction* _tmp324_;
		ValaCCodeFunction* _tmp325_;
		ValaCCodeIdentifier* _tmp326_;
		ValaCCodeIdentifier* _tmp327_;
		ValaCCodeFile* _tmp328_;
		ValaCCodeFunction* _tmp329_;
		_tmp7_ = cl;
		_tmp8_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp7_, _tmp8_)) {
			ValaSourceReference* _tmp9_;
			ValaSourceReference* _tmp10_;
			_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
			_tmp10_ = _tmp9_;
			vala_report_error (_tmp10_, "construct blocks require GLib.Object");
			vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
			_vala_code_node_unref0 (cl);
			return;
		}
		_tmp11_ = vala_ccode_base_module_emit_context_new ((ValaSymbol*) c);
		_tmp12_ = _tmp11_;
		vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp12_);
		_vala_ccode_base_module_emit_context_unref0 (_tmp12_);
		_tmp13_ = cl;
		_tmp14_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("%s_constructor", _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_ccode_function_new (_tmp17_, "GObject *");
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		function = _tmp19_;
		_tmp20_ = function;
		vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp20_, VALA_CCODE_MODIFIERS_STATIC);
		_tmp21_ = function;
		_tmp22_ = vala_ccode_parameter_new ("type", "GType");
		_tmp23_ = _tmp22_;
		vala_ccode_function_add_parameter (_tmp21_, _tmp23_);
		_vala_ccode_node_unref0 (_tmp23_);
		_tmp24_ = function;
		_tmp25_ = vala_ccode_parameter_new ("n_construct_properties", "guint");
		_tmp26_ = _tmp25_;
		vala_ccode_function_add_parameter (_tmp24_, _tmp26_);
		_vala_ccode_node_unref0 (_tmp26_);
		_tmp27_ = function;
		_tmp28_ = vala_ccode_parameter_new ("construct_properties", "GObjectConstructParam *");
		_tmp29_ = _tmp28_;
		vala_ccode_function_add_parameter (_tmp27_, _tmp29_);
		_vala_ccode_node_unref0 (_tmp29_);
		_tmp30_ = ((ValaCCodeBaseModule*) self)->cfile;
		_tmp31_ = function;
		vala_ccode_file_add_function_declaration (_tmp30_, _tmp31_);
		_tmp32_ = function;
		vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp32_);
		_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_ccode_variable_declarator_new ("obj", NULL, NULL);
		_tmp36_ = _tmp35_;
		vala_ccode_function_add_declaration (_tmp34_, "GObject *", (ValaCCodeDeclarator*) _tmp36_, 0);
		_vala_ccode_node_unref0 (_tmp36_);
		_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_ccode_variable_declarator_new ("parent_class", NULL, NULL);
		_tmp40_ = _tmp39_;
		vala_ccode_function_add_declaration (_tmp38_, "GObjectClass *", (ValaCCodeDeclarator*) _tmp40_, 0);
		_vala_ccode_node_unref0 (_tmp40_);
		_tmp41_ = cl;
		_tmp42_ = vala_class_get_is_singleton (_tmp41_);
		_tmp43_ = _tmp42_;
		if (_tmp43_) {
			gchar* singleton_ref_name = NULL;
			ValaClass* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* singleton_lock_name = NULL;
			ValaClass* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* singleton_once_name = NULL;
			ValaClass* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			ValaCCodeDeclaration* singleton_ref = NULL;
			ValaCCodeDeclaration* _tmp59_;
			ValaCCodeDeclaration* _tmp60_;
			const gchar* _tmp61_;
			ValaCCodeConstant* _tmp62_;
			ValaCCodeConstant* _tmp63_;
			ValaCCodeVariableDeclarator* _tmp64_;
			ValaCCodeVariableDeclarator* _tmp65_;
			ValaCCodeDeclaration* _tmp66_;
			ValaCCodeFunction* _tmp67_;
			ValaCCodeFunction* _tmp68_;
			ValaCCodeDeclaration* _tmp69_;
			ValaCCodeDeclaration* mutex_lock = NULL;
			ValaCCodeDeclaration* _tmp70_;
			ValaCCodeDeclaration* _tmp71_;
			const gchar* _tmp72_;
			ValaCCodeVariableDeclarator* _tmp73_;
			ValaCCodeVariableDeclarator* _tmp74_;
			ValaCCodeDeclaration* _tmp75_;
			ValaCCodeFunction* _tmp76_;
			ValaCCodeFunction* _tmp77_;
			ValaCCodeDeclaration* _tmp78_;
			ValaCCodeDeclaration* once_lock = NULL;
			ValaCCodeDeclaration* _tmp79_;
			ValaCCodeDeclaration* _tmp80_;
			const gchar* _tmp81_;
			ValaCCodeConstant* _tmp82_;
			ValaCCodeConstant* _tmp83_;
			ValaCCodeVariableDeclarator* _tmp84_;
			ValaCCodeVariableDeclarator* _tmp85_;
			ValaCCodeDeclaration* _tmp86_;
			ValaCCodeFunction* _tmp87_;
			ValaCCodeFunction* _tmp88_;
			ValaCCodeDeclaration* _tmp89_;
			ValaCCodeFunctionCall* once_init = NULL;
			ValaCCodeIdentifier* _tmp90_;
			ValaCCodeIdentifier* _tmp91_;
			ValaCCodeFunctionCall* _tmp92_;
			ValaCCodeFunctionCall* _tmp93_;
			ValaCCodeFunctionCall* _tmp94_;
			const gchar* _tmp95_;
			ValaCCodeIdentifier* _tmp96_;
			ValaCCodeIdentifier* _tmp97_;
			ValaCCodeUnaryExpression* _tmp98_;
			ValaCCodeUnaryExpression* _tmp99_;
			ValaCCodeBlock* once_block = NULL;
			ValaCCodeBlock* _tmp100_;
			ValaCCodeFunctionCall* singleton_mutex_init = NULL;
			ValaCCodeIdentifier* _tmp101_;
			ValaCCodeIdentifier* _tmp102_;
			ValaCCodeFunctionCall* _tmp103_;
			ValaCCodeFunctionCall* _tmp104_;
			ValaCCodeFunctionCall* _tmp105_;
			const gchar* _tmp106_;
			ValaCCodeIdentifier* _tmp107_;
			ValaCCodeIdentifier* _tmp108_;
			ValaCCodeUnaryExpression* _tmp109_;
			ValaCCodeUnaryExpression* _tmp110_;
			ValaCCodeBlock* _tmp111_;
			ValaCCodeFunctionCall* _tmp112_;
			ValaCCodeExpressionStatement* _tmp113_;
			ValaCCodeExpressionStatement* _tmp114_;
			ValaCCodeFunctionCall* once_leave = NULL;
			ValaCCodeIdentifier* _tmp115_;
			ValaCCodeIdentifier* _tmp116_;
			ValaCCodeFunctionCall* _tmp117_;
			ValaCCodeFunctionCall* _tmp118_;
			ValaCCodeFunctionCall* _tmp119_;
			const gchar* _tmp120_;
			ValaCCodeIdentifier* _tmp121_;
			ValaCCodeIdentifier* _tmp122_;
			ValaCCodeUnaryExpression* _tmp123_;
			ValaCCodeUnaryExpression* _tmp124_;
			ValaCCodeFunctionCall* _tmp125_;
			ValaCCodeConstant* _tmp126_;
			ValaCCodeConstant* _tmp127_;
			ValaCCodeBlock* _tmp128_;
			ValaCCodeFunctionCall* _tmp129_;
			ValaCCodeExpressionStatement* _tmp130_;
			ValaCCodeExpressionStatement* _tmp131_;
			ValaCCodeIfStatement* if_once = NULL;
			ValaCCodeFunctionCall* _tmp132_;
			ValaCCodeBlock* _tmp133_;
			ValaCCodeIfStatement* _tmp134_;
			ValaCCodeFunction* _tmp135_;
			ValaCCodeFunction* _tmp136_;
			ValaCCodeIfStatement* _tmp137_;
			ValaCCodeFunctionCall* singleton_mutex_lock = NULL;
			ValaCCodeIdentifier* _tmp138_;
			ValaCCodeIdentifier* _tmp139_;
			ValaCCodeFunctionCall* _tmp140_;
			ValaCCodeFunctionCall* _tmp141_;
			ValaCCodeFunctionCall* _tmp142_;
			const gchar* _tmp143_;
			ValaCCodeIdentifier* _tmp144_;
			ValaCCodeIdentifier* _tmp145_;
			ValaCCodeUnaryExpression* _tmp146_;
			ValaCCodeUnaryExpression* _tmp147_;
			ValaCCodeFunction* _tmp148_;
			ValaCCodeFunction* _tmp149_;
			ValaCCodeFunctionCall* _tmp150_;
			ValaCCodeExpressionStatement* _tmp151_;
			ValaCCodeExpressionStatement* _tmp152_;
			ValaCCodeBinaryExpression* check_existance = NULL;
			const gchar* _tmp153_;
			ValaCCodeIdentifier* _tmp154_;
			ValaCCodeIdentifier* _tmp155_;
			ValaCCodeConstant* _tmp156_;
			ValaCCodeConstant* _tmp157_;
			ValaCCodeBinaryExpression* _tmp158_;
			ValaCCodeBinaryExpression* _tmp159_;
			ValaCCodeBlock* return_singleton = NULL;
			ValaCCodeBlock* _tmp160_;
			ValaCCodeFunctionCall* ref_object = NULL;
			ValaCCodeIdentifier* _tmp161_;
			ValaCCodeIdentifier* _tmp162_;
			ValaCCodeFunctionCall* _tmp163_;
			ValaCCodeFunctionCall* _tmp164_;
			ValaCCodeFunctionCall* _tmp165_;
			const gchar* _tmp166_;
			ValaCCodeIdentifier* _tmp167_;
			ValaCCodeIdentifier* _tmp168_;
			ValaCCodeBlock* _tmp169_;
			ValaCCodeFunctionCall* _tmp170_;
			ValaCCodeExpressionStatement* _tmp171_;
			ValaCCodeExpressionStatement* _tmp172_;
			ValaCCodeFunctionCall* singleton_mutex_unlock = NULL;
			ValaCCodeIdentifier* _tmp173_;
			ValaCCodeIdentifier* _tmp174_;
			ValaCCodeFunctionCall* _tmp175_;
			ValaCCodeFunctionCall* _tmp176_;
			ValaCCodeFunctionCall* _tmp177_;
			const gchar* _tmp178_;
			ValaCCodeIdentifier* _tmp179_;
			ValaCCodeIdentifier* _tmp180_;
			ValaCCodeUnaryExpression* _tmp181_;
			ValaCCodeUnaryExpression* _tmp182_;
			ValaCCodeBlock* _tmp183_;
			ValaCCodeFunctionCall* _tmp184_;
			ValaCCodeExpressionStatement* _tmp185_;
			ValaCCodeExpressionStatement* _tmp186_;
			ValaCCodeBlock* _tmp187_;
			const gchar* _tmp188_;
			ValaCCodeIdentifier* _tmp189_;
			ValaCCodeIdentifier* _tmp190_;
			ValaCCodeReturnStatement* _tmp191_;
			ValaCCodeReturnStatement* _tmp192_;
			ValaCCodeIfStatement* if_singleton_alive = NULL;
			ValaCCodeBinaryExpression* _tmp193_;
			ValaCCodeBlock* _tmp194_;
			ValaCCodeIfStatement* _tmp195_;
			ValaCCodeFunction* _tmp196_;
			ValaCCodeFunction* _tmp197_;
			ValaCCodeIfStatement* _tmp198_;
			_tmp44_ = cl;
			_tmp45_ = vala_get_ccode_name ((ValaCodeNode*) _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strdup_printf ("%s_singleton__ref", _tmp46_);
			_tmp48_ = _tmp47_;
			_g_free0 (_tmp46_);
			singleton_ref_name = _tmp48_;
			_tmp49_ = cl;
			_tmp50_ = vala_get_ccode_name ((ValaCodeNode*) _tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = g_strdup_printf ("%s_singleton__lock", _tmp51_);
			_tmp53_ = _tmp52_;
			_g_free0 (_tmp51_);
			singleton_lock_name = _tmp53_;
			_tmp54_ = cl;
			_tmp55_ = vala_get_ccode_name ((ValaCodeNode*) _tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strdup_printf ("%s_singleton__volatile", _tmp56_);
			_tmp58_ = _tmp57_;
			_g_free0 (_tmp56_);
			singleton_once_name = _tmp58_;
			_tmp59_ = vala_ccode_declaration_new ("GObject *");
			singleton_ref = _tmp59_;
			_tmp60_ = singleton_ref;
			_tmp61_ = singleton_ref_name;
			_tmp62_ = vala_ccode_constant_new ("NULL");
			_tmp63_ = _tmp62_;
			_tmp64_ = vala_ccode_variable_declarator_new (_tmp61_, (ValaCCodeExpression*) _tmp63_, NULL);
			_tmp65_ = _tmp64_;
			vala_ccode_declaration_add_declarator (_tmp60_, (ValaCCodeDeclarator*) _tmp65_);
			_vala_ccode_node_unref0 (_tmp65_);
			_vala_ccode_node_unref0 (_tmp63_);
			_tmp66_ = singleton_ref;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp66_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp67_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp68_ = _tmp67_;
			_tmp69_ = singleton_ref;
			vala_ccode_function_add_statement (_tmp68_, (ValaCCodeNode*) _tmp69_);
			_tmp70_ = vala_ccode_declaration_new ("GMutex");
			mutex_lock = _tmp70_;
			_tmp71_ = mutex_lock;
			_tmp72_ = singleton_lock_name;
			_tmp73_ = vala_ccode_variable_declarator_new (_tmp72_, NULL, NULL);
			_tmp74_ = _tmp73_;
			vala_ccode_declaration_add_declarator (_tmp71_, (ValaCCodeDeclarator*) _tmp74_);
			_vala_ccode_node_unref0 (_tmp74_);
			_tmp75_ = mutex_lock;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp75_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp76_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp77_ = _tmp76_;
			_tmp78_ = mutex_lock;
			vala_ccode_function_add_statement (_tmp77_, (ValaCCodeNode*) _tmp78_);
			_tmp79_ = vala_ccode_declaration_new ("gsize");
			once_lock = _tmp79_;
			_tmp80_ = once_lock;
			_tmp81_ = singleton_once_name;
			_tmp82_ = vala_ccode_constant_new ("0");
			_tmp83_ = _tmp82_;
			_tmp84_ = vala_ccode_variable_declarator_new (_tmp81_, (ValaCCodeExpression*) _tmp83_, NULL);
			_tmp85_ = _tmp84_;
			vala_ccode_declaration_add_declarator (_tmp80_, (ValaCCodeDeclarator*) _tmp85_);
			_vala_ccode_node_unref0 (_tmp85_);
			_vala_ccode_node_unref0 (_tmp83_);
			_tmp86_ = once_lock;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp86_, VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_VOLATILE);
			_tmp87_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp88_ = _tmp87_;
			_tmp89_ = once_lock;
			vala_ccode_function_add_statement (_tmp88_, (ValaCCodeNode*) _tmp89_);
			_tmp90_ = vala_ccode_identifier_new ("g_once_init_enter");
			_tmp91_ = _tmp90_;
			_tmp92_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp91_);
			_tmp93_ = _tmp92_;
			_vala_ccode_node_unref0 (_tmp91_);
			once_init = _tmp93_;
			_tmp94_ = once_init;
			_tmp95_ = singleton_once_name;
			_tmp96_ = vala_ccode_identifier_new (_tmp95_);
			_tmp97_ = _tmp96_;
			_tmp98_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp97_);
			_tmp99_ = _tmp98_;
			vala_ccode_function_call_add_argument (_tmp94_, (ValaCCodeExpression*) _tmp99_);
			_vala_ccode_node_unref0 (_tmp99_);
			_vala_ccode_node_unref0 (_tmp97_);
			_tmp100_ = vala_ccode_block_new ();
			once_block = _tmp100_;
			_tmp101_ = vala_ccode_identifier_new ("g_mutex_init");
			_tmp102_ = _tmp101_;
			_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
			_tmp104_ = _tmp103_;
			_vala_ccode_node_unref0 (_tmp102_);
			singleton_mutex_init = _tmp104_;
			_tmp105_ = singleton_mutex_init;
			_tmp106_ = singleton_lock_name;
			_tmp107_ = vala_ccode_identifier_new (_tmp106_);
			_tmp108_ = _tmp107_;
			_tmp109_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp108_);
			_tmp110_ = _tmp109_;
			vala_ccode_function_call_add_argument (_tmp105_, (ValaCCodeExpression*) _tmp110_);
			_vala_ccode_node_unref0 (_tmp110_);
			_vala_ccode_node_unref0 (_tmp108_);
			_tmp111_ = once_block;
			_tmp112_ = singleton_mutex_init;
			_tmp113_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp112_);
			_tmp114_ = _tmp113_;
			vala_ccode_block_add_statement (_tmp111_, (ValaCCodeNode*) _tmp114_);
			_vala_ccode_node_unref0 (_tmp114_);
			_tmp115_ = vala_ccode_identifier_new ("g_once_init_leave");
			_tmp116_ = _tmp115_;
			_tmp117_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp116_);
			_tmp118_ = _tmp117_;
			_vala_ccode_node_unref0 (_tmp116_);
			once_leave = _tmp118_;
			_tmp119_ = once_leave;
			_tmp120_ = singleton_once_name;
			_tmp121_ = vala_ccode_identifier_new (_tmp120_);
			_tmp122_ = _tmp121_;
			_tmp123_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp122_);
			_tmp124_ = _tmp123_;
			vala_ccode_function_call_add_argument (_tmp119_, (ValaCCodeExpression*) _tmp124_);
			_vala_ccode_node_unref0 (_tmp124_);
			_vala_ccode_node_unref0 (_tmp122_);
			_tmp125_ = once_leave;
			_tmp126_ = vala_ccode_constant_new ("42");
			_tmp127_ = _tmp126_;
			vala_ccode_function_call_add_argument (_tmp125_, (ValaCCodeExpression*) _tmp127_);
			_vala_ccode_node_unref0 (_tmp127_);
			_tmp128_ = once_block;
			_tmp129_ = once_leave;
			_tmp130_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp129_);
			_tmp131_ = _tmp130_;
			vala_ccode_block_add_statement (_tmp128_, (ValaCCodeNode*) _tmp131_);
			_vala_ccode_node_unref0 (_tmp131_);
			_tmp132_ = once_init;
			_tmp133_ = once_block;
			_tmp134_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) _tmp132_, (ValaCCodeStatement*) _tmp133_, NULL);
			if_once = _tmp134_;
			_tmp135_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp136_ = _tmp135_;
			_tmp137_ = if_once;
			vala_ccode_function_add_statement (_tmp136_, (ValaCCodeNode*) _tmp137_);
			_tmp138_ = vala_ccode_identifier_new ("g_mutex_lock");
			_tmp139_ = _tmp138_;
			_tmp140_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp139_);
			_tmp141_ = _tmp140_;
			_vala_ccode_node_unref0 (_tmp139_);
			singleton_mutex_lock = _tmp141_;
			_tmp142_ = singleton_mutex_lock;
			_tmp143_ = singleton_lock_name;
			_tmp144_ = vala_ccode_identifier_new (_tmp143_);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp145_);
			_tmp147_ = _tmp146_;
			vala_ccode_function_call_add_argument (_tmp142_, (ValaCCodeExpression*) _tmp147_);
			_vala_ccode_node_unref0 (_tmp147_);
			_vala_ccode_node_unref0 (_tmp145_);
			_tmp148_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp149_ = _tmp148_;
			_tmp150_ = singleton_mutex_lock;
			_tmp151_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp150_);
			_tmp152_ = _tmp151_;
			vala_ccode_function_add_statement (_tmp149_, (ValaCCodeNode*) _tmp152_);
			_vala_ccode_node_unref0 (_tmp152_);
			_tmp153_ = singleton_ref_name;
			_tmp154_ = vala_ccode_identifier_new (_tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = vala_ccode_constant_new ("NULL");
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp155_, (ValaCCodeExpression*) _tmp157_);
			_tmp159_ = _tmp158_;
			_vala_ccode_node_unref0 (_tmp157_);
			_vala_ccode_node_unref0 (_tmp155_);
			check_existance = _tmp159_;
			_tmp160_ = vala_ccode_block_new ();
			return_singleton = _tmp160_;
			_tmp161_ = vala_ccode_identifier_new ("g_object_ref");
			_tmp162_ = _tmp161_;
			_tmp163_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp162_);
			_tmp164_ = _tmp163_;
			_vala_ccode_node_unref0 (_tmp162_);
			ref_object = _tmp164_;
			_tmp165_ = ref_object;
			_tmp166_ = singleton_ref_name;
			_tmp167_ = vala_ccode_identifier_new (_tmp166_);
			_tmp168_ = _tmp167_;
			vala_ccode_function_call_add_argument (_tmp165_, (ValaCCodeExpression*) _tmp168_);
			_vala_ccode_node_unref0 (_tmp168_);
			_tmp169_ = return_singleton;
			_tmp170_ = ref_object;
			_tmp171_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp170_);
			_tmp172_ = _tmp171_;
			vala_ccode_block_add_statement (_tmp169_, (ValaCCodeNode*) _tmp172_);
			_vala_ccode_node_unref0 (_tmp172_);
			_tmp173_ = vala_ccode_identifier_new ("g_mutex_unlock");
			_tmp174_ = _tmp173_;
			_tmp175_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp174_);
			_tmp176_ = _tmp175_;
			_vala_ccode_node_unref0 (_tmp174_);
			singleton_mutex_unlock = _tmp176_;
			_tmp177_ = singleton_mutex_unlock;
			_tmp178_ = singleton_lock_name;
			_tmp179_ = vala_ccode_identifier_new (_tmp178_);
			_tmp180_ = _tmp179_;
			_tmp181_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp180_);
			_tmp182_ = _tmp181_;
			vala_ccode_function_call_add_argument (_tmp177_, (ValaCCodeExpression*) _tmp182_);
			_vala_ccode_node_unref0 (_tmp182_);
			_vala_ccode_node_unref0 (_tmp180_);
			_tmp183_ = return_singleton;
			_tmp184_ = singleton_mutex_unlock;
			_tmp185_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp184_);
			_tmp186_ = _tmp185_;
			vala_ccode_block_add_statement (_tmp183_, (ValaCCodeNode*) _tmp186_);
			_vala_ccode_node_unref0 (_tmp186_);
			_tmp187_ = return_singleton;
			_tmp188_ = singleton_ref_name;
			_tmp189_ = vala_ccode_identifier_new (_tmp188_);
			_tmp190_ = _tmp189_;
			_tmp191_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) _tmp190_);
			_tmp192_ = _tmp191_;
			vala_ccode_block_add_statement (_tmp187_, (ValaCCodeNode*) _tmp192_);
			_vala_ccode_node_unref0 (_tmp192_);
			_vala_ccode_node_unref0 (_tmp190_);
			_tmp193_ = check_existance;
			_tmp194_ = return_singleton;
			_tmp195_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) _tmp193_, (ValaCCodeStatement*) _tmp194_, NULL);
			if_singleton_alive = _tmp195_;
			_tmp196_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp197_ = _tmp196_;
			_tmp198_ = if_singleton_alive;
			vala_ccode_function_add_statement (_tmp197_, (ValaCCodeNode*) _tmp198_);
			_vala_ccode_node_unref0 (if_singleton_alive);
			_vala_ccode_node_unref0 (singleton_mutex_unlock);
			_vala_ccode_node_unref0 (ref_object);
			_vala_ccode_node_unref0 (return_singleton);
			_vala_ccode_node_unref0 (check_existance);
			_vala_ccode_node_unref0 (singleton_mutex_lock);
			_vala_ccode_node_unref0 (if_once);
			_vala_ccode_node_unref0 (once_leave);
			_vala_ccode_node_unref0 (singleton_mutex_init);
			_vala_ccode_node_unref0 (once_block);
			_vala_ccode_node_unref0 (once_init);
			_vala_ccode_node_unref0 (once_lock);
			_vala_ccode_node_unref0 (mutex_lock);
			_vala_ccode_node_unref0 (singleton_ref);
			_g_free0 (singleton_once_name);
			_g_free0 (singleton_lock_name);
			_g_free0 (singleton_ref_name);
		}
		_tmp199_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
		_tmp200_ = _tmp199_;
		_tmp201_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp200_);
		_tmp202_ = _tmp201_;
		_vala_ccode_node_unref0 (_tmp200_);
		ccast = _tmp202_;
		_tmp203_ = ccast;
		_tmp204_ = cl;
		_tmp205_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp204_, NULL);
		_tmp206_ = _tmp205_;
		_tmp207_ = g_strdup_printf ("%s_parent_class", _tmp206_);
		_tmp208_ = _tmp207_;
		_tmp209_ = vala_ccode_identifier_new (_tmp208_);
		_tmp210_ = _tmp209_;
		vala_ccode_function_call_add_argument (_tmp203_, (ValaCCodeExpression*) _tmp210_);
		_vala_ccode_node_unref0 (_tmp210_);
		_g_free0 (_tmp208_);
		_g_free0 (_tmp206_);
		_tmp211_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp212_ = _tmp211_;
		_tmp213_ = vala_ccode_identifier_new ("parent_class");
		_tmp214_ = _tmp213_;
		_tmp215_ = ccast;
		vala_ccode_function_add_assignment (_tmp212_, (ValaCCodeExpression*) _tmp214_, (ValaCCodeExpression*) _tmp215_);
		_vala_ccode_node_unref0 (_tmp214_);
		_tmp216_ = vala_ccode_identifier_new ("parent_class");
		_tmp217_ = _tmp216_;
		_tmp218_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp217_, "constructor");
		_tmp219_ = _tmp218_;
		_tmp220_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp219_);
		_tmp221_ = _tmp220_;
		_vala_ccode_node_unref0 (_tmp219_);
		_vala_ccode_node_unref0 (_tmp217_);
		ccall = _tmp221_;
		_tmp222_ = ccall;
		_tmp223_ = vala_ccode_identifier_new ("type");
		_tmp224_ = _tmp223_;
		vala_ccode_function_call_add_argument (_tmp222_, (ValaCCodeExpression*) _tmp224_);
		_vala_ccode_node_unref0 (_tmp224_);
		_tmp225_ = ccall;
		_tmp226_ = vala_ccode_identifier_new ("n_construct_properties");
		_tmp227_ = _tmp226_;
		vala_ccode_function_call_add_argument (_tmp225_, (ValaCCodeExpression*) _tmp227_);
		_vala_ccode_node_unref0 (_tmp227_);
		_tmp228_ = ccall;
		_tmp229_ = vala_ccode_identifier_new ("construct_properties");
		_tmp230_ = _tmp229_;
		vala_ccode_function_call_add_argument (_tmp228_, (ValaCCodeExpression*) _tmp230_);
		_vala_ccode_node_unref0 (_tmp230_);
		_tmp231_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp232_ = _tmp231_;
		_tmp233_ = vala_ccode_identifier_new ("obj");
		_tmp234_ = _tmp233_;
		_tmp235_ = ccall;
		vala_ccode_function_add_assignment (_tmp232_, (ValaCCodeExpression*) _tmp234_, (ValaCCodeExpression*) _tmp235_);
		_vala_ccode_node_unref0 (_tmp234_);
		_tmp236_ = vala_ccode_identifier_new ("obj");
		_tmp237_ = _tmp236_;
		_tmp238_ = cl;
		_tmp239_ = vala_ccode_base_module_generate_instance_cast ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) _tmp237_, (ValaTypeSymbol*) _tmp238_);
		_vala_ccode_node_unref0 (ccall);
		ccall = _tmp239_;
		_vala_ccode_node_unref0 (_tmp237_);
		_tmp240_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp241_ = _tmp240_;
		_tmp242_ = cl;
		_tmp243_ = vala_get_ccode_name ((ValaCodeNode*) _tmp242_);
		_tmp244_ = _tmp243_;
		_tmp245_ = g_strdup_printf ("%s *", _tmp244_);
		_tmp246_ = _tmp245_;
		_tmp247_ = vala_ccode_variable_declarator_new ("self", NULL, NULL);
		_tmp248_ = _tmp247_;
		vala_ccode_function_add_declaration (_tmp241_, _tmp246_, (ValaCCodeDeclarator*) _tmp248_, 0);
		_vala_ccode_node_unref0 (_tmp248_);
		_g_free0 (_tmp246_);
		_g_free0 (_tmp244_);
		_tmp249_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp250_ = _tmp249_;
		_tmp251_ = vala_ccode_identifier_new ("self");
		_tmp252_ = _tmp251_;
		_tmp253_ = ccall;
		vala_ccode_function_add_assignment (_tmp250_, (ValaCCodeExpression*) _tmp252_, (ValaCCodeExpression*) _tmp253_);
		_vala_ccode_node_unref0 (_tmp252_);
		_tmp254_ = vala_subroutine_get_body ((ValaSubroutine*) c);
		_tmp255_ = _tmp254_;
		vala_code_node_emit ((ValaCodeNode*) _tmp255_, (ValaCodeGenerator*) self);
		_tmp256_ = vala_ccode_base_module_get_current_method_inner_error ((ValaCCodeBaseModule*) self);
		_tmp257_ = _tmp256_;
		if (_tmp257_) {
			ValaCCodeFunction* _tmp258_;
			ValaCCodeFunction* _tmp259_;
			gint _tmp260_;
			gint _tmp261_;
			gchar* _tmp262_;
			gchar* _tmp263_;
			ValaCCodeConstant* _tmp264_;
			ValaCCodeConstant* _tmp265_;
			ValaCCodeVariableDeclarator* _tmp266_;
			ValaCCodeVariableDeclarator* _tmp267_;
			_tmp258_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp259_ = _tmp258_;
			_tmp260_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
			_tmp261_ = _tmp260_;
			_tmp262_ = g_strdup_printf ("_inner_error%d_", _tmp261_);
			_tmp263_ = _tmp262_;
			_tmp264_ = vala_ccode_constant_new ("NULL");
			_tmp265_ = _tmp264_;
			_tmp266_ = vala_ccode_variable_declarator_new_zero (_tmp263_, (ValaCCodeExpression*) _tmp265_, NULL);
			_tmp267_ = _tmp266_;
			vala_ccode_function_add_declaration (_tmp259_, "GError*", (ValaCCodeDeclarator*) _tmp267_, 0);
			_vala_ccode_node_unref0 (_tmp267_);
			_vala_ccode_node_unref0 (_tmp265_);
			_g_free0 (_tmp263_);
		}
		_tmp268_ = cl;
		_tmp269_ = vala_class_get_is_singleton (_tmp268_);
		_tmp270_ = _tmp269_;
		if (_tmp270_) {
			gchar* singleton_ref_name = NULL;
			ValaClass* _tmp271_;
			gchar* _tmp272_;
			gchar* _tmp273_;
			gchar* _tmp274_;
			gchar* _tmp275_;
			gchar* singleton_lock_name = NULL;
			ValaClass* _tmp276_;
			gchar* _tmp277_;
			gchar* _tmp278_;
			gchar* _tmp279_;
			gchar* _tmp280_;
			ValaCCodeFunction* _tmp281_;
			ValaCCodeFunction* _tmp282_;
			const gchar* _tmp283_;
			ValaCCodeIdentifier* _tmp284_;
			ValaCCodeIdentifier* _tmp285_;
			ValaCCodeIdentifier* _tmp286_;
			ValaCCodeIdentifier* _tmp287_;
			ValaCCodeFunctionCall* set_weak_ref_to_volatile = NULL;
			ValaCCodeIdentifier* _tmp288_;
			ValaCCodeIdentifier* _tmp289_;
			ValaCCodeFunctionCall* _tmp290_;
			ValaCCodeFunctionCall* _tmp291_;
			ValaCCodeFunctionCall* _tmp292_;
			const gchar* _tmp293_;
			ValaCCodeIdentifier* _tmp294_;
			ValaCCodeIdentifier* _tmp295_;
			ValaCCodeFunctionCall* _tmp296_;
			const gchar* _tmp297_;
			ValaCCodeIdentifier* _tmp298_;
			ValaCCodeIdentifier* _tmp299_;
			ValaCCodeUnaryExpression* _tmp300_;
			ValaCCodeUnaryExpression* _tmp301_;
			ValaCCodeCastExpression* _tmp302_;
			ValaCCodeCastExpression* _tmp303_;
			ValaCCodeFunction* _tmp304_;
			ValaCCodeFunction* _tmp305_;
			ValaCCodeFunctionCall* _tmp306_;
			ValaCCodeExpressionStatement* _tmp307_;
			ValaCCodeExpressionStatement* _tmp308_;
			ValaCCodeFunctionCall* final_singleton_mutex_unlock = NULL;
			ValaCCodeIdentifier* _tmp309_;
			ValaCCodeIdentifier* _tmp310_;
			ValaCCodeFunctionCall* _tmp311_;
			ValaCCodeFunctionCall* _tmp312_;
			ValaCCodeFunctionCall* _tmp313_;
			const gchar* _tmp314_;
			ValaCCodeIdentifier* _tmp315_;
			ValaCCodeIdentifier* _tmp316_;
			ValaCCodeUnaryExpression* _tmp317_;
			ValaCCodeUnaryExpression* _tmp318_;
			ValaCCodeFunction* _tmp319_;
			ValaCCodeFunction* _tmp320_;
			ValaCCodeFunctionCall* _tmp321_;
			ValaCCodeExpressionStatement* _tmp322_;
			ValaCCodeExpressionStatement* _tmp323_;
			_tmp271_ = cl;
			_tmp272_ = vala_get_ccode_name ((ValaCodeNode*) _tmp271_);
			_tmp273_ = _tmp272_;
			_tmp274_ = g_strdup_printf ("%s_singleton__ref", _tmp273_);
			_tmp275_ = _tmp274_;
			_g_free0 (_tmp273_);
			singleton_ref_name = _tmp275_;
			_tmp276_ = cl;
			_tmp277_ = vala_get_ccode_name ((ValaCodeNode*) _tmp276_);
			_tmp278_ = _tmp277_;
			_tmp279_ = g_strdup_printf ("%s_singleton__lock", _tmp278_);
			_tmp280_ = _tmp279_;
			_g_free0 (_tmp278_);
			singleton_lock_name = _tmp280_;
			_tmp281_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp282_ = _tmp281_;
			_tmp283_ = singleton_ref_name;
			_tmp284_ = vala_ccode_identifier_new (_tmp283_);
			_tmp285_ = _tmp284_;
			_tmp286_ = vala_ccode_identifier_new ("obj");
			_tmp287_ = _tmp286_;
			vala_ccode_function_add_assignment (_tmp282_, (ValaCCodeExpression*) _tmp285_, (ValaCCodeExpression*) _tmp287_);
			_vala_ccode_node_unref0 (_tmp287_);
			_vala_ccode_node_unref0 (_tmp285_);
			_tmp288_ = vala_ccode_identifier_new ("g_object_add_weak_pointer");
			_tmp289_ = _tmp288_;
			_tmp290_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp289_);
			_tmp291_ = _tmp290_;
			_vala_ccode_node_unref0 (_tmp289_);
			set_weak_ref_to_volatile = _tmp291_;
			_tmp292_ = set_weak_ref_to_volatile;
			_tmp293_ = singleton_ref_name;
			_tmp294_ = vala_ccode_identifier_new (_tmp293_);
			_tmp295_ = _tmp294_;
			vala_ccode_function_call_add_argument (_tmp292_, (ValaCCodeExpression*) _tmp295_);
			_vala_ccode_node_unref0 (_tmp295_);
			_tmp296_ = set_weak_ref_to_volatile;
			_tmp297_ = singleton_ref_name;
			_tmp298_ = vala_ccode_identifier_new (_tmp297_);
			_tmp299_ = _tmp298_;
			_tmp300_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp299_);
			_tmp301_ = _tmp300_;
			_tmp302_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp301_, "gpointer");
			_tmp303_ = _tmp302_;
			vala_ccode_function_call_add_argument (_tmp296_, (ValaCCodeExpression*) _tmp303_);
			_vala_ccode_node_unref0 (_tmp303_);
			_vala_ccode_node_unref0 (_tmp301_);
			_vala_ccode_node_unref0 (_tmp299_);
			_tmp304_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp305_ = _tmp304_;
			_tmp306_ = set_weak_ref_to_volatile;
			_tmp307_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp306_);
			_tmp308_ = _tmp307_;
			vala_ccode_function_add_statement (_tmp305_, (ValaCCodeNode*) _tmp308_);
			_vala_ccode_node_unref0 (_tmp308_);
			_tmp309_ = vala_ccode_identifier_new ("g_mutex_unlock");
			_tmp310_ = _tmp309_;
			_tmp311_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp310_);
			_tmp312_ = _tmp311_;
			_vala_ccode_node_unref0 (_tmp310_);
			final_singleton_mutex_unlock = _tmp312_;
			_tmp313_ = final_singleton_mutex_unlock;
			_tmp314_ = singleton_lock_name;
			_tmp315_ = vala_ccode_identifier_new (_tmp314_);
			_tmp316_ = _tmp315_;
			_tmp317_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp316_);
			_tmp318_ = _tmp317_;
			vala_ccode_function_call_add_argument (_tmp313_, (ValaCCodeExpression*) _tmp318_);
			_vala_ccode_node_unref0 (_tmp318_);
			_vala_ccode_node_unref0 (_tmp316_);
			_tmp319_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp320_ = _tmp319_;
			_tmp321_ = final_singleton_mutex_unlock;
			_tmp322_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp321_);
			_tmp323_ = _tmp322_;
			vala_ccode_function_add_statement (_tmp320_, (ValaCCodeNode*) _tmp323_);
			_vala_ccode_node_unref0 (_tmp323_);
			_vala_ccode_node_unref0 (final_singleton_mutex_unlock);
			_vala_ccode_node_unref0 (set_weak_ref_to_volatile);
			_g_free0 (singleton_lock_name);
			_g_free0 (singleton_ref_name);
		}
		_tmp324_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp325_ = _tmp324_;
		_tmp326_ = vala_ccode_identifier_new ("obj");
		_tmp327_ = _tmp326_;
		vala_ccode_function_add_return (_tmp325_, (ValaCCodeExpression*) _tmp327_);
		_vala_ccode_node_unref0 (_tmp327_);
		vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
		_tmp328_ = ((ValaCCodeBaseModule*) self)->cfile;
		_tmp329_ = function;
		vala_ccode_file_add_function (_tmp328_, _tmp329_);
		vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
		_vala_ccode_node_unref0 (ccall);
		_vala_ccode_node_unref0 (ccast);
		_vala_ccode_node_unref0 (function);
	} else {
		ValaMemberBinding _tmp330_;
		ValaMemberBinding _tmp331_;
		_tmp330_ = vala_constructor_get_binding (c);
		_tmp331_ = _tmp330_;
		if (_tmp331_ == VALA_MEMBER_BINDING_CLASS) {
			ValaClass* _tmp332_;
			gboolean _tmp333_;
			gboolean _tmp334_;
			ValaCCodeBaseModuleEmitContext* _tmp337_;
			ValaBlock* _tmp338_;
			ValaBlock* _tmp339_;
			gboolean _tmp340_;
			gboolean _tmp341_;
			_tmp332_ = cl;
			_tmp333_ = vala_class_get_is_compact (_tmp332_);
			_tmp334_ = _tmp333_;
			if (_tmp334_) {
				ValaSourceReference* _tmp335_;
				ValaSourceReference* _tmp336_;
				_tmp335_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp336_ = _tmp335_;
				vala_report_error (_tmp336_, "class constructors are not supported in compact classes");
				vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
				_vala_code_node_unref0 (cl);
				return;
			}
			_tmp337_ = ((ValaCCodeBaseModule*) self)->base_init_context;
			vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp337_);
			_tmp338_ = vala_subroutine_get_body ((ValaSubroutine*) c);
			_tmp339_ = _tmp338_;
			vala_code_node_emit ((ValaCodeNode*) _tmp339_, (ValaCodeGenerator*) self);
			_tmp340_ = vala_ccode_base_module_get_current_method_inner_error ((ValaCCodeBaseModule*) self);
			_tmp341_ = _tmp340_;
			if (_tmp341_) {
				ValaCCodeFunction* _tmp342_;
				ValaCCodeFunction* _tmp343_;
				gint _tmp344_;
				gint _tmp345_;
				gchar* _tmp346_;
				gchar* _tmp347_;
				ValaCCodeConstant* _tmp348_;
				ValaCCodeConstant* _tmp349_;
				ValaCCodeVariableDeclarator* _tmp350_;
				ValaCCodeVariableDeclarator* _tmp351_;
				_tmp342_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp343_ = _tmp342_;
				_tmp344_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
				_tmp345_ = _tmp344_;
				_tmp346_ = g_strdup_printf ("_inner_error%d_", _tmp345_);
				_tmp347_ = _tmp346_;
				_tmp348_ = vala_ccode_constant_new ("NULL");
				_tmp349_ = _tmp348_;
				_tmp350_ = vala_ccode_variable_declarator_new_zero (_tmp347_, (ValaCCodeExpression*) _tmp349_, NULL);
				_tmp351_ = _tmp350_;
				vala_ccode_function_add_declaration (_tmp343_, "GError*", (ValaCCodeDeclarator*) _tmp351_, 0);
				_vala_ccode_node_unref0 (_tmp351_);
				_vala_ccode_node_unref0 (_tmp349_);
				_g_free0 (_tmp347_);
			}
			vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
		} else {
			ValaMemberBinding _tmp352_;
			ValaMemberBinding _tmp353_;
			_tmp352_ = vala_constructor_get_binding (c);
			_tmp353_ = _tmp352_;
			if (_tmp353_ == VALA_MEMBER_BINDING_STATIC) {
				ValaClass* _tmp354_;
				gboolean _tmp355_;
				gboolean _tmp356_;
				ValaCCodeBaseModuleEmitContext* _tmp359_;
				ValaBlock* _tmp360_;
				ValaBlock* _tmp361_;
				gboolean _tmp362_;
				gboolean _tmp363_;
				_tmp354_ = cl;
				_tmp355_ = vala_class_get_is_compact (_tmp354_);
				_tmp356_ = _tmp355_;
				if (_tmp356_) {
					ValaSourceReference* _tmp357_;
					ValaSourceReference* _tmp358_;
					_tmp357_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
					_tmp358_ = _tmp357_;
					vala_report_error (_tmp358_, "static constructors are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
					_vala_code_node_unref0 (cl);
					return;
				}
				_tmp359_ = ((ValaCCodeBaseModule*) self)->class_init_context;
				vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp359_);
				_tmp360_ = vala_subroutine_get_body ((ValaSubroutine*) c);
				_tmp361_ = _tmp360_;
				vala_code_node_emit ((ValaCodeNode*) _tmp361_, (ValaCodeGenerator*) self);
				_tmp362_ = vala_ccode_base_module_get_current_method_inner_error ((ValaCCodeBaseModule*) self);
				_tmp363_ = _tmp362_;
				if (_tmp363_) {
					ValaCCodeFunction* _tmp364_;
					ValaCCodeFunction* _tmp365_;
					gint _tmp366_;
					gint _tmp367_;
					gchar* _tmp368_;
					gchar* _tmp369_;
					ValaCCodeConstant* _tmp370_;
					ValaCCodeConstant* _tmp371_;
					ValaCCodeVariableDeclarator* _tmp372_;
					ValaCCodeVariableDeclarator* _tmp373_;
					_tmp364_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp365_ = _tmp364_;
					_tmp366_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
					_tmp367_ = _tmp366_;
					_tmp368_ = g_strdup_printf ("_inner_error%d_", _tmp367_);
					_tmp369_ = _tmp368_;
					_tmp370_ = vala_ccode_constant_new ("NULL");
					_tmp371_ = _tmp370_;
					_tmp372_ = vala_ccode_variable_declarator_new_zero (_tmp369_, (ValaCCodeExpression*) _tmp371_, NULL);
					_tmp373_ = _tmp372_;
					vala_ccode_function_add_declaration (_tmp365_, "GError*", (ValaCCodeDeclarator*) _tmp373_, 0);
					_vala_ccode_node_unref0 (_tmp373_);
					_vala_ccode_node_unref0 (_tmp371_);
					_g_free0 (_tmp369_);
				}
				vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
			} else {
				ValaSourceReference* _tmp374_;
				ValaSourceReference* _tmp375_;
				_tmp374_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp375_ = _tmp374_;
				vala_report_error (_tmp375_, "internal error: constructors must have instance, class, or static bind" \
"ing");
			}
		}
	}
	vala_ccode_base_module_pop_line ((ValaCCodeBaseModule*) self);
	_vala_code_node_unref0 (cl);
}

static gchar*
vala_gobject_module_real_get_dynamic_property_getter_cname (ValaCCodeBaseModule* base,
                                                            ValaDynamicProperty* prop)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* getter_cname = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaDataType* _tmp16_;
	ValaDataType* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeFunction* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeModifiers _tmp24_;
	ValaCCodeModifiers _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	ValaCCodeParameter* _tmp31_;
	ValaCCodeParameter* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaDataType* _tmp36_;
	ValaDataType* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	ValaCCodeVariableDeclarator* _tmp40_;
	ValaCCodeVariableDeclarator* _tmp41_;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeIdentifier* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeUnaryExpression* _tmp55_;
	ValaCCodeUnaryExpression* _tmp56_;
	ValaCCodeFunctionCall* _tmp57_;
	ValaCCodeConstant* _tmp58_;
	ValaCCodeConstant* _tmp59_;
	ValaCCodeFunction* _tmp60_;
	ValaCCodeFunction* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeFunction* _tmp63_;
	ValaCCodeFunction* _tmp64_;
	ValaCCodeIdentifier* _tmp65_;
	ValaCCodeIdentifier* _tmp66_;
	ValaCCodeFile* _tmp67_;
	ValaCCodeFunction* _tmp68_;
	ValaCCodeFile* _tmp69_;
	ValaCCodeFunction* _tmp70_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp1_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_data_type (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_property_get_dynamic_type (prop);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_data_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_property_getter_cname ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), prop);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->dynamic_property_id;
	self->priv->dynamic_property_id = _tmp13_ + 1;
	_tmp14_ = g_strdup_printf ("_dynamic_get_%s%d", _tmp12_, _tmp13_);
	getter_cname = _tmp14_;
	_tmp15_ = getter_cname;
	_tmp16_ = vala_property_get_property_type ((ValaProperty*) prop);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_get_ccode_name ((ValaCodeNode*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_ccode_function_new (_tmp15_, _tmp19_);
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp19_);
	func = _tmp21_;
	_tmp22_ = func;
	_tmp23_ = func;
	_tmp24_ = vala_ccode_node_get_modifiers ((ValaCCodeNode*) _tmp23_);
	_tmp25_ = _tmp24_;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp23_, _tmp25_ | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp26_ = func;
	_tmp27_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_get_ccode_name ((ValaCodeNode*) _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_ccode_parameter_new ("obj", _tmp30_);
	_tmp32_ = _tmp31_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp32_);
	_vala_ccode_node_unref0 (_tmp32_);
	_g_free0 (_tmp30_);
	_tmp33_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_property_get_property_type ((ValaProperty*) prop);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_get_ccode_name ((ValaCodeNode*) _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp41_ = _tmp40_;
	vala_ccode_function_add_declaration (_tmp35_, _tmp39_, (ValaCCodeDeclarator*) _tmp41_, 0);
	_vala_ccode_node_unref0 (_tmp41_);
	_g_free0 (_tmp39_);
	_tmp42_ = vala_ccode_identifier_new ("g_object_get");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	call = _tmp45_;
	_tmp46_ = call;
	_tmp47_ = vala_ccode_identifier_new ("obj");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = call;
	_tmp50_ = vala_ccode_base_module_get_property_canonical_cconstant ((ValaCCodeBaseModule*) self, (ValaProperty*) prop);
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = call;
	_tmp53_ = vala_ccode_identifier_new ("result");
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp54_);
	_tmp56_ = _tmp55_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp56_);
	_vala_ccode_node_unref0 (_tmp56_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp57_ = call;
	_tmp58_ = vala_ccode_constant_new ("NULL");
	_tmp59_ = _tmp58_;
	vala_ccode_function_call_add_argument (_tmp57_, (ValaCCodeExpression*) _tmp59_);
	_vala_ccode_node_unref0 (_tmp59_);
	_tmp60_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp61_ = _tmp60_;
	_tmp62_ = call;
	vala_ccode_function_add_expression (_tmp61_, (ValaCCodeExpression*) _tmp62_);
	_tmp63_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_identifier_new ("result");
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_return (_tmp64_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp67_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp68_ = func;
	vala_ccode_file_add_function_declaration (_tmp67_, _tmp68_);
	_tmp69_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp70_ = func;
	vala_ccode_file_add_function (_tmp69_, _tmp70_);
	result = getter_cname;
	_vala_ccode_node_unref0 (call);
	_vala_ccode_node_unref0 (func);
	return result;
}

static gchar*
vala_gobject_module_real_get_dynamic_property_setter_cname (ValaCCodeBaseModule* base,
                                                            ValaDynamicProperty* prop)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* setter_cname = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeFunction* _tmp18_;
	ValaCCodeModifiers _tmp19_;
	ValaCCodeModifiers _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	ValaCCodeParameter* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeFunction* _tmp28_;
	ValaDataType* _tmp29_;
	ValaDataType* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	ValaCCodeParameter* _tmp33_;
	ValaCCodeParameter* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp36_;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeFunctionCall* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeIdentifier* _tmp41_;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeFunctionCall* _tmp43_;
	ValaCCodeConstant* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeIdentifier* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunction* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFunctionCall* _tmp54_;
	ValaCCodeFile* _tmp55_;
	ValaCCodeFunction* _tmp56_;
	ValaCCodeFile* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp1_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_data_type (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_property_get_dynamic_type (prop);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_data_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_property_setter_cname ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), prop);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->dynamic_property_id;
	self->priv->dynamic_property_id = _tmp13_ + 1;
	_tmp14_ = g_strdup_printf ("_dynamic_set_%s%d", _tmp12_, _tmp13_);
	setter_cname = _tmp14_;
	_tmp15_ = setter_cname;
	_tmp16_ = vala_ccode_function_new (_tmp15_, "void");
	func = _tmp16_;
	_tmp17_ = func;
	_tmp18_ = func;
	_tmp19_ = vala_ccode_node_get_modifiers ((ValaCCodeNode*) _tmp18_);
	_tmp20_ = _tmp19_;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp18_, _tmp20_ | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp21_ = func;
	_tmp22_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_get_ccode_name ((ValaCodeNode*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_parameter_new ("obj", _tmp25_);
	_tmp27_ = _tmp26_;
	vala_ccode_function_add_parameter (_tmp21_, _tmp27_);
	_vala_ccode_node_unref0 (_tmp27_);
	_g_free0 (_tmp25_);
	_tmp28_ = func;
	_tmp29_ = vala_property_get_property_type ((ValaProperty*) prop);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_get_ccode_name ((ValaCodeNode*) _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_ccode_parameter_new ("value", _tmp32_);
	_tmp34_ = _tmp33_;
	vala_ccode_function_add_parameter (_tmp28_, _tmp34_);
	_vala_ccode_node_unref0 (_tmp34_);
	_g_free0 (_tmp32_);
	_tmp35_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp35_);
	_tmp36_ = vala_ccode_identifier_new ("g_object_set");
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp37_);
	_tmp39_ = _tmp38_;
	_vala_ccode_node_unref0 (_tmp37_);
	call = _tmp39_;
	_tmp40_ = call;
	_tmp41_ = vala_ccode_identifier_new ("obj");
	_tmp42_ = _tmp41_;
	vala_ccode_function_call_add_argument (_tmp40_, (ValaCCodeExpression*) _tmp42_);
	_vala_ccode_node_unref0 (_tmp42_);
	_tmp43_ = call;
	_tmp44_ = vala_ccode_base_module_get_property_canonical_cconstant ((ValaCCodeBaseModule*) self, (ValaProperty*) prop);
	_tmp45_ = _tmp44_;
	vala_ccode_function_call_add_argument (_tmp43_, (ValaCCodeExpression*) _tmp45_);
	_vala_ccode_node_unref0 (_tmp45_);
	_tmp46_ = call;
	_tmp47_ = vala_ccode_identifier_new ("value");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = call;
	_tmp50_ = vala_ccode_constant_new ("NULL");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp53_ = _tmp52_;
	_tmp54_ = call;
	vala_ccode_function_add_expression (_tmp53_, (ValaCCodeExpression*) _tmp54_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp55_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp56_ = func;
	vala_ccode_file_add_function_declaration (_tmp55_, _tmp56_);
	_tmp57_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp58_ = func;
	vala_ccode_file_add_function (_tmp57_, _tmp58_);
	result = setter_cname;
	_vala_ccode_node_unref0 (call);
	_vala_ccode_node_unref0 (func);
	return result;
}

static gchar*
vala_gobject_module_real_get_dynamic_signal_cname (ValaCCodeBaseModule* base,
                                                   ValaDynamicSignal* node)
{
	ValaGObjectModule * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_symbol_get_name ((ValaSymbol*) node);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->signal_wrapper_id;
	self->priv->signal_wrapper_id = _tmp2_ + 1;
	_tmp3_ = g_strdup_printf ("dynamic_%s%d_", _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}

static gchar*
vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeBaseModule* base,
                                                                  ValaDynamicSignal* sig)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* connect_wrapper_name = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeParameter* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeParameter* _tmp24_;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFile* _tmp30_;
	ValaCCodeFunction* _tmp31_;
	ValaCCodeFile* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp1_ = vala_dynamic_signal_get_dynamic_type (sig);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_data_type (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_signal_get_dynamic_type (sig);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_data_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), sig);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_ccode_base_module_get_dynamic_signal_cname ((ValaCCodeBaseModule*) self, sig);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("_%sconnect", _tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	connect_wrapper_name = _tmp14_;
	_tmp15_ = connect_wrapper_name;
	_tmp16_ = vala_ccode_function_new (_tmp15_, "gulong");
	func = _tmp16_;
	_tmp17_ = func;
	_tmp18_ = vala_ccode_parameter_new ("obj", "gpointer");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp17_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = func;
	_tmp21_ = vala_ccode_parameter_new ("signal_name", "const char *");
	_tmp22_ = _tmp21_;
	vala_ccode_function_add_parameter (_tmp20_, _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = func;
	_tmp24_ = vala_ccode_parameter_new ("handler", "GCallback");
	_tmp25_ = _tmp24_;
	vala_ccode_function_add_parameter (_tmp23_, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = func;
	_tmp27_ = vala_ccode_parameter_new ("data", "gpointer");
	_tmp28_ = _tmp27_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp29_);
	vala_gobject_module_generate_gobject_connect_wrapper (self, sig, FALSE);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp30_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp31_ = func;
	vala_ccode_file_add_function_declaration (_tmp30_, _tmp31_);
	_tmp32_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp33_ = func;
	vala_ccode_file_add_function (_tmp32_, _tmp33_);
	result = connect_wrapper_name;
	_vala_ccode_node_unref0 (func);
	return result;
}

static gchar*
vala_gobject_module_real_get_dynamic_signal_connect_after_wrapper_name (ValaCCodeBaseModule* base,
                                                                        ValaDynamicSignal* sig)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* connect_wrapper_name = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeParameter* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeParameter* _tmp24_;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFile* _tmp30_;
	ValaCCodeFunction* _tmp31_;
	ValaCCodeFile* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp1_ = vala_dynamic_signal_get_dynamic_type (sig);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_data_type (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_signal_get_dynamic_type (sig);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_data_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), sig);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_ccode_base_module_get_dynamic_signal_cname ((ValaCCodeBaseModule*) self, sig);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("_%sconnect_after", _tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	connect_wrapper_name = _tmp14_;
	_tmp15_ = connect_wrapper_name;
	_tmp16_ = vala_ccode_function_new (_tmp15_, "gulong");
	func = _tmp16_;
	_tmp17_ = func;
	_tmp18_ = vala_ccode_parameter_new ("obj", "gpointer");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp17_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = func;
	_tmp21_ = vala_ccode_parameter_new ("signal_name", "const char *");
	_tmp22_ = _tmp21_;
	vala_ccode_function_add_parameter (_tmp20_, _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = func;
	_tmp24_ = vala_ccode_parameter_new ("handler", "GCallback");
	_tmp25_ = _tmp24_;
	vala_ccode_function_add_parameter (_tmp23_, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = func;
	_tmp27_ = vala_ccode_parameter_new ("data", "gpointer");
	_tmp28_ = _tmp27_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp29_);
	vala_gobject_module_generate_gobject_connect_wrapper (self, sig, TRUE);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp30_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp31_ = func;
	vala_ccode_file_add_function_declaration (_tmp30_, _tmp31_);
	_tmp32_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp33_ = func;
	vala_ccode_file_add_function (_tmp32_, _tmp33_);
	result = connect_wrapper_name;
	_vala_ccode_node_unref0 (func);
	return result;
}

static void
vala_gobject_module_generate_gobject_connect_wrapper (ValaGObjectModule* self,
                                                      ValaDynamicSignal* sig,
                                                      gboolean after)
{
	ValaMethod* m = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaMethod* _tmp4_;
	gchar* connect_func = NULL;
	gchar* _tmp5_;
	ValaMethod* _tmp6_;
	ValaMemberBinding _tmp7_;
	ValaMemberBinding _tmp8_;
	ValaCCodeFunctionCall* call = NULL;
	const gchar* _tmp11_;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeFunctionCall* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeIdentifier* _tmp17_;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeFunctionCall* _tmp19_;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeFunctionCall* _tmp25_;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeIdentifier* _tmp27_;
	ValaMethod* _tmp28_;
	ValaMemberBinding _tmp29_;
	ValaMemberBinding _tmp30_;
	ValaCCodeFunction* _tmp37_;
	ValaCCodeFunction* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_dynamic_signal_get_handler (sig);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_symbol_reference (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_METHOD, ValaMethod));
	m = _tmp4_;
	vala_code_node_accept ((ValaCodeNode*) sig, (ValaCodeVisitor*) self);
	_tmp5_ = g_strdup ("g_signal_connect_object");
	connect_func = _tmp5_;
	_tmp6_ = m;
	_tmp7_ = vala_method_get_binding (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != VALA_MEMBER_BINDING_INSTANCE) {
		if (!after) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("g_signal_connect");
			_g_free0 (connect_func);
			connect_func = _tmp9_;
		} else {
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("g_signal_connect_after");
			_g_free0 (connect_func);
			connect_func = _tmp10_;
		}
	}
	_tmp11_ = connect_func;
	_tmp12_ = vala_ccode_identifier_new (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_ccode_node_unref0 (_tmp13_);
	call = _tmp15_;
	_tmp16_ = call;
	_tmp17_ = vala_ccode_identifier_new ("obj");
	_tmp18_ = _tmp17_;
	vala_ccode_function_call_add_argument (_tmp16_, (ValaCCodeExpression*) _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = call;
	_tmp20_ = vala_ccode_identifier_new ("signal_name");
	_tmp21_ = _tmp20_;
	vala_ccode_function_call_add_argument (_tmp19_, (ValaCCodeExpression*) _tmp21_);
	_vala_ccode_node_unref0 (_tmp21_);
	_tmp22_ = call;
	_tmp23_ = vala_ccode_identifier_new ("handler");
	_tmp24_ = _tmp23_;
	vala_ccode_function_call_add_argument (_tmp22_, (ValaCCodeExpression*) _tmp24_);
	_vala_ccode_node_unref0 (_tmp24_);
	_tmp25_ = call;
	_tmp26_ = vala_ccode_identifier_new ("data");
	_tmp27_ = _tmp26_;
	vala_ccode_function_call_add_argument (_tmp25_, (ValaCCodeExpression*) _tmp27_);
	_vala_ccode_node_unref0 (_tmp27_);
	_tmp28_ = m;
	_tmp29_ = vala_method_get_binding (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ == VALA_MEMBER_BINDING_INSTANCE) {
		if (!after) {
			ValaCCodeFunctionCall* _tmp31_;
			ValaCCodeConstant* _tmp32_;
			ValaCCodeConstant* _tmp33_;
			_tmp31_ = call;
			_tmp32_ = vala_ccode_constant_new ("0");
			_tmp33_ = _tmp32_;
			vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
			_vala_ccode_node_unref0 (_tmp33_);
		} else {
			ValaCCodeFunctionCall* _tmp34_;
			ValaCCodeConstant* _tmp35_;
			ValaCCodeConstant* _tmp36_;
			_tmp34_ = call;
			_tmp35_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
			_tmp36_ = _tmp35_;
			vala_ccode_function_call_add_argument (_tmp34_, (ValaCCodeExpression*) _tmp36_);
			_vala_ccode_node_unref0 (_tmp36_);
		}
	}
	_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = call;
	vala_ccode_function_add_return (_tmp38_, (ValaCCodeExpression*) _tmp39_);
	_vala_ccode_node_unref0 (call);
	_g_free0 (connect_func);
	_vala_code_node_unref0 (m);
}

static void
vala_gobject_module_real_visit_property (ValaCodeVisitor* base,
                                         ValaProperty* prop)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaSemanticAnalyzer* _tmp3_;
	ValaSemanticAnalyzer* _tmp4_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (prop != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_property ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), prop);
	_tmp1_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_analyzer (_tmp2_);
	_tmp4_ = _tmp3_;
	if (vala_semantic_analyzer_is_gobject_property (_tmp4_, prop)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) prop);
		_tmp6_ = _tmp5_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_CLASS);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCCodeEnum* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		ValaCCodeEnumValue* _tmp12_;
		ValaCCodeEnumValue* _tmp13_;
		_tmp7_ = ((ValaCCodeBaseModule*) self)->prop_enum;
		_tmp8_ = vala_get_ccode_upper_case_name ((ValaSymbol*) prop, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf ("%s_PROPERTY", _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_ccode_enum_value_new (_tmp11_, NULL);
		_tmp13_ = _tmp12_;
		vala_ccode_enum_add_value (_tmp7_, _tmp13_);
		_vala_ccode_node_unref0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
}

static void
vala_gobject_module_real_visit_method_call (ValaCodeVisitor* base,
                                            ValaMethodCall* expr)
{
	ValaGObjectModule * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		ValaMemberAccess* _tmp6_;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		ValaMemberAccess* _tmp9_;
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp3_ = _tmp2_;
		vala_ccode_base_module_push_line ((ValaCCodeBaseModule*) self, _tmp3_);
		_tmp4_ = vala_method_call_get_call (expr);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp5_) : NULL);
		ma = _tmp6_;
		_tmp9_ = ma;
		_tmp10_ = vala_member_access_get_inner (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ != NULL) {
			ValaMemberAccess* _tmp12_;
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaTypeSymbol* _tmp17_;
			_tmp12_ = ma;
			_tmp13_ = vala_member_access_get_inner (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = ((ValaCCodeBaseModule*) self)->gobject_type;
			_tmp8_ = _tmp16_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_SYMBOL, ValaSymbol);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			ValaMemberAccess* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp21_ = ma;
			_tmp22_ = vala_member_access_get_member_name (_tmp21_);
			_tmp23_ = _tmp22_;
			if (g_strcmp0 (_tmp23_, "new") == 0) {
				_tmp20_ = TRUE;
			} else {
				ValaMemberAccess* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				_tmp24_ = ma;
				_tmp25_ = vala_member_access_get_member_name (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp20_ = g_strcmp0 (_tmp26_, "newv") == 0;
			}
			if (_tmp20_) {
				_tmp19_ = TRUE;
			} else {
				ValaMemberAccess* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				_tmp27_ = ma;
				_tmp28_ = vala_member_access_get_member_name (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp19_ = g_strcmp0 (_tmp29_, "new_valist") == 0;
			}
			if (_tmp19_) {
				_tmp18_ = TRUE;
			} else {
				ValaMemberAccess* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				_tmp30_ = ma;
				_tmp31_ = vala_member_access_get_member_name (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp18_ = g_strcmp0 (_tmp32_, "new_with_properties") == 0;
			}
			_tmp7_ = _tmp18_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ValaCCodeFunctionCall* initiallyunowned_ccall = NULL;
			ValaCCodeIdentifier* _tmp33_;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeFunctionCall* _tmp35_;
			ValaCCodeFunctionCall* _tmp36_;
			ValaCCodeFunctionCall* _tmp37_;
			ValaCCodeExpression* _tmp38_;
			ValaCCodeExpression* _tmp39_;
			ValaCCodeFunctionCall* sink_ref_ccall = NULL;
			ValaCCodeIdentifier* _tmp40_;
			ValaCCodeIdentifier* _tmp41_;
			ValaCCodeFunctionCall* _tmp42_;
			ValaCCodeFunctionCall* _tmp43_;
			ValaCCodeFunctionCall* _tmp44_;
			ValaCCodeExpression* _tmp45_;
			ValaCCodeExpression* _tmp46_;
			ValaCCodeConditionalExpression* cexpr = NULL;
			ValaCCodeFunctionCall* _tmp47_;
			ValaCCodeFunctionCall* _tmp48_;
			ValaCCodeExpression* _tmp49_;
			ValaCCodeExpression* _tmp50_;
			ValaCCodeConditionalExpression* _tmp51_;
			ValaCCodeConditionalExpression* _tmp52_;
			ValaDataType* _tmp53_;
			ValaDataType* _tmp54_;
			ValaCCodeConditionalExpression* _tmp55_;
			ValaGLibValue* _tmp56_;
			ValaGLibValue* _tmp57_;
			ValaTargetValue* _tmp58_;
			ValaTargetValue* _tmp59_;
			VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_method_call ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), expr);
			_tmp33_ = vala_ccode_identifier_new ("G_IS_INITIALLY_UNOWNED");
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp34_);
			_tmp36_ = _tmp35_;
			_vala_ccode_node_unref0 (_tmp34_);
			initiallyunowned_ccall = _tmp36_;
			_tmp37_ = initiallyunowned_ccall;
			_tmp38_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr);
			_tmp39_ = _tmp38_;
			vala_ccode_function_call_add_argument (_tmp37_, _tmp39_);
			_vala_ccode_node_unref0 (_tmp39_);
			_tmp40_ = vala_ccode_identifier_new ("g_object_ref_sink");
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp41_);
			_tmp43_ = _tmp42_;
			_vala_ccode_node_unref0 (_tmp41_);
			sink_ref_ccall = _tmp43_;
			_tmp44_ = sink_ref_ccall;
			_tmp45_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr);
			_tmp46_ = _tmp45_;
			vala_ccode_function_call_add_argument (_tmp44_, _tmp46_);
			_vala_ccode_node_unref0 (_tmp46_);
			_tmp47_ = initiallyunowned_ccall;
			_tmp48_ = sink_ref_ccall;
			_tmp49_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp47_, (ValaCCodeExpression*) _tmp48_, _tmp50_);
			_tmp52_ = _tmp51_;
			_vala_ccode_node_unref0 (_tmp50_);
			cexpr = _tmp52_;
			_tmp53_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp54_ = _tmp53_;
			_tmp55_ = cexpr;
			_tmp56_ = vala_glib_value_new (_tmp54_, (ValaCCodeExpression*) _tmp55_, FALSE);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp57_, (ValaCodeNode*) expr, NULL);
			_tmp59_ = _tmp58_;
			vala_expression_set_target_value ((ValaExpression*) expr, _tmp59_);
			_vala_target_value_unref0 (_tmp59_);
			_vala_target_value_unref0 (_tmp57_);
			_vala_ccode_node_unref0 (cexpr);
			_vala_ccode_node_unref0 (sink_ref_ccall);
			_vala_ccode_node_unref0 (initiallyunowned_ccall);
			_vala_code_node_unref0 (ma);
			return;
		} else {
			ValaMemberAccess* _tmp60_;
			ValaSymbol* _tmp61_;
			ValaSymbol* _tmp62_;
			ValaTypeSymbol* _tmp63_;
			_tmp60_ = ma;
			_tmp61_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = ((ValaCCodeBaseModule*) self)->gobject_type;
			if (_tmp62_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				{
					ValaList* _arg_list = NULL;
					ValaList* _tmp64_;
					gint _arg_size = 0;
					ValaList* _tmp65_;
					gint _tmp66_;
					gint _tmp67_;
					gint _arg_index = 0;
					_tmp64_ = vala_method_call_get_argument_list (expr);
					_arg_list = _tmp64_;
					_tmp65_ = _arg_list;
					_tmp66_ = vala_collection_get_size ((ValaCollection*) _tmp65_);
					_tmp67_ = _tmp66_;
					_arg_size = _tmp67_;
					_arg_index = -1;
					while (TRUE) {
						ValaExpression* arg = NULL;
						ValaList* _tmp68_;
						gpointer _tmp69_;
						ValaNamedArgument* named_argument = NULL;
						ValaExpression* _tmp70_;
						ValaNamedArgument* _tmp71_;
						ValaNamedArgument* _tmp72_;
						ValaProperty* prop = NULL;
						ValaClass* _tmp76_;
						ValaClass* _tmp77_;
						ValaNamedArgument* _tmp78_;
						const gchar* _tmp79_;
						const gchar* _tmp80_;
						ValaSymbol* _tmp81_;
						ValaProperty* _tmp82_;
						ValaProperty* _tmp83_;
						ValaCodeContext* _tmp96_;
						ValaCodeContext* _tmp97_;
						ValaSemanticAnalyzer* _tmp98_;
						ValaSemanticAnalyzer* _tmp99_;
						ValaProperty* _tmp100_;
						ValaExpression* _tmp109_;
						ValaDataType* _tmp110_;
						ValaDataType* _tmp111_;
						ValaProperty* _tmp112_;
						ValaDataType* _tmp113_;
						ValaDataType* _tmp114_;
						_arg_index = _arg_index + 1;
						if (!(_arg_index < _arg_size)) {
							break;
						}
						_tmp68_ = _arg_list;
						_tmp69_ = vala_list_get (_tmp68_, _arg_index);
						arg = (ValaExpression*) _tmp69_;
						_tmp70_ = arg;
						_tmp71_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, VALA_TYPE_NAMED_ARGUMENT) ? ((ValaNamedArgument*) _tmp70_) : NULL);
						named_argument = _tmp71_;
						_tmp72_ = named_argument;
						if (_tmp72_ == NULL) {
							ValaExpression* _tmp73_;
							ValaSourceReference* _tmp74_;
							ValaSourceReference* _tmp75_;
							_tmp73_ = arg;
							_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
							_tmp75_ = _tmp74_;
							vala_report_error (_tmp75_, "Named argument expected");
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_tmp76_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp77_ = _tmp76_;
						_tmp78_ = named_argument;
						_tmp79_ = vala_named_argument_get_name (_tmp78_);
						_tmp80_ = _tmp79_;
						_tmp81_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp77_, _tmp80_);
						_tmp82_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp81_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp81_) : NULL;
						if (_tmp82_ == NULL) {
							_vala_code_node_unref0 (_tmp81_);
						}
						prop = _tmp82_;
						_tmp83_ = prop;
						if (_tmp83_ == NULL) {
							ValaExpression* _tmp84_;
							ValaSourceReference* _tmp85_;
							ValaSourceReference* _tmp86_;
							ValaNamedArgument* _tmp87_;
							const gchar* _tmp88_;
							const gchar* _tmp89_;
							ValaClass* _tmp90_;
							ValaClass* _tmp91_;
							gchar* _tmp92_;
							gchar* _tmp93_;
							gchar* _tmp94_;
							gchar* _tmp95_;
							_tmp84_ = arg;
							_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp84_);
							_tmp86_ = _tmp85_;
							_tmp87_ = named_argument;
							_tmp88_ = vala_named_argument_get_name (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
							_tmp91_ = _tmp90_;
							_tmp92_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp91_);
							_tmp93_ = _tmp92_;
							_tmp94_ = g_strdup_printf ("Property `%s' not found in `%s'", _tmp89_, _tmp93_);
							_tmp95_ = _tmp94_;
							vala_report_error (_tmp86_, _tmp95_);
							_g_free0 (_tmp95_);
							_g_free0 (_tmp93_);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_tmp96_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
						_tmp97_ = _tmp96_;
						_tmp98_ = vala_code_context_get_analyzer (_tmp97_);
						_tmp99_ = _tmp98_;
						_tmp100_ = prop;
						if (!vala_semantic_analyzer_is_gobject_property (_tmp99_, _tmp100_)) {
							ValaExpression* _tmp101_;
							ValaSourceReference* _tmp102_;
							ValaSourceReference* _tmp103_;
							ValaNamedArgument* _tmp104_;
							const gchar* _tmp105_;
							const gchar* _tmp106_;
							gchar* _tmp107_;
							gchar* _tmp108_;
							_tmp101_ = arg;
							_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp101_);
							_tmp103_ = _tmp102_;
							_tmp104_ = named_argument;
							_tmp105_ = vala_named_argument_get_name (_tmp104_);
							_tmp106_ = _tmp105_;
							_tmp107_ = g_strdup_printf ("Property `%s' not supported in Object (property: value) constructor ch" \
"ain up", _tmp106_);
							_tmp108_ = _tmp107_;
							vala_report_error (_tmp103_, _tmp108_);
							_g_free0 (_tmp108_);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_tmp109_ = arg;
						_tmp110_ = vala_expression_get_value_type (_tmp109_);
						_tmp111_ = _tmp110_;
						_tmp112_ = prop;
						_tmp113_ = vala_property_get_property_type (_tmp112_);
						_tmp114_ = _tmp113_;
						if (!vala_data_type_compatible (_tmp111_, _tmp114_)) {
							ValaExpression* _tmp115_;
							ValaSourceReference* _tmp116_;
							ValaSourceReference* _tmp117_;
							ValaExpression* _tmp118_;
							ValaDataType* _tmp119_;
							ValaDataType* _tmp120_;
							gchar* _tmp121_;
							gchar* _tmp122_;
							ValaProperty* _tmp123_;
							ValaDataType* _tmp124_;
							ValaDataType* _tmp125_;
							gchar* _tmp126_;
							gchar* _tmp127_;
							gchar* _tmp128_;
							gchar* _tmp129_;
							_tmp115_ = arg;
							_tmp116_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp115_);
							_tmp117_ = _tmp116_;
							_tmp118_ = arg;
							_tmp119_ = vala_expression_get_value_type (_tmp118_);
							_tmp120_ = _tmp119_;
							_tmp121_ = vala_code_node_to_string ((ValaCodeNode*) _tmp120_);
							_tmp122_ = _tmp121_;
							_tmp123_ = prop;
							_tmp124_ = vala_property_get_property_type (_tmp123_);
							_tmp125_ = _tmp124_;
							_tmp126_ = vala_code_node_to_string ((ValaCodeNode*) _tmp125_);
							_tmp127_ = _tmp126_;
							_tmp128_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp122_, _tmp127_);
							_tmp129_ = _tmp128_;
							vala_report_error (_tmp117_, _tmp129_);
							_g_free0 (_tmp129_);
							_g_free0 (_tmp127_);
							_g_free0 (_tmp122_);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_vala_code_node_unref0 (prop);
						_vala_code_node_unref0 (named_argument);
						_vala_code_node_unref0 (arg);
					}
					_vala_iterable_unref0 (_arg_list);
				}
			}
		}
		vala_ccode_base_module_pop_line ((ValaCCodeBaseModule*) self);
		_vala_code_node_unref0 (ma);
	}
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_method_call ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), expr);
}

ValaGObjectModule*
vala_gobject_module_construct (GType object_type)
{
	ValaGObjectModule* self = NULL;
	self = (ValaGObjectModule*) vala_gtype_module_construct (object_type);
	return self;
}

ValaGObjectModule*
vala_gobject_module_new (void)
{
	return vala_gobject_module_construct (VALA_TYPE_GOBJECT_MODULE);
}

static void
vala_gobject_module_class_init (ValaGObjectModuleClass * klass,
                                gpointer klass_data)
{
	vala_gobject_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gobject_module_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGObjectModule_private_offset);
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) vala_gobject_module_real_visit_class;
	((ValaGTypeModuleClass *) klass)->generate_class_init = (void (*) (ValaGTypeModule*, ValaClass*)) vala_gobject_module_real_generate_class_init;
	((ValaCodeVisitorClass *) klass)->visit_constructor = (void (*) (ValaCodeVisitor*, ValaConstructor*)) vala_gobject_module_real_visit_constructor;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_property_getter_cname = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicProperty*)) vala_gobject_module_real_get_dynamic_property_getter_cname;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_property_setter_cname = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicProperty*)) vala_gobject_module_real_get_dynamic_property_setter_cname;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_signal_cname = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicSignal*)) vala_gobject_module_real_get_dynamic_signal_cname;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_signal_connect_wrapper_name = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicSignal*)) vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_signal_connect_after_wrapper_name = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicSignal*)) vala_gobject_module_real_get_dynamic_signal_connect_after_wrapper_name;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor*, ValaProperty*)) vala_gobject_module_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_gobject_module_real_visit_method_call;
}

static void
vala_gobject_module_instance_init (ValaGObjectModule * self,
                                   gpointer klass)
{
	self->priv = vala_gobject_module_get_instance_private (self);
}

static void
vala_gobject_module_finalize (ValaCodeVisitor * obj)
{
	ValaGObjectModule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule);
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->finalize (obj);
}

GType
vala_gobject_module_get_type (void)
{
	static volatile gsize vala_gobject_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gobject_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGObjectModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gobject_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGObjectModule), 0, (GInstanceInitFunc) vala_gobject_module_instance_init, NULL };
		GType vala_gobject_module_type_id;
		vala_gobject_module_type_id = g_type_register_static (VALA_TYPE_GTYPE_MODULE, "ValaGObjectModule", &g_define_type_info, 0);
		ValaGObjectModule_private_offset = g_type_add_instance_private (vala_gobject_module_type_id, sizeof (ValaGObjectModulePrivate));
		g_once_init_leave (&vala_gobject_module_type_id__volatile, vala_gobject_module_type_id);
	}
	return vala_gobject_module_type_id__volatile;
}

