This target allows to alter the MSS value of TCP SYN packets, to control
the maximum size for that connection (usually limiting it to your
outgoing interface's MTU minus 40 for IPv4 or 60 for IPv6, respectively).
Of course, it can only be used
in conjunction with
\fB\-p tcp\fP.
.PP
This target is used to overcome criminally braindead ISPs or servers
which block "ICMP Fragmentation Needed" or "ICMPv6 Packet Too Big"
packets.  The symptoms of this
problem are that everything works fine from your Linux
firewall/router, but machines behind it can never exchange large
packets:
.IP 1. 4
Web browsers connect, then hang with no data received.
.IP 2. 4
Small mail works fine, but large emails hang.
.IP 3. 4
ssh works fine, but scp hangs after initial handshaking.
.PP
Workaround: activate this option and add a rule to your firewall
configuration like:
.IP
 iptables \-t mangle \-A FORWARD \-p tcp \-\-tcp\-flags SYN,RST SYN
             \-j TCPMSS \-\-clamp\-mss\-to\-pmtu
.TP
\fB\-\-set\-mss\fP \fIvalue\fP
Explicitly sets MSS option to specified value. If the MSS of the packet is
already lower than \fIvalue\fP, it will \fBnot\fP be increased (from Linux
2.6.25 onwards) to avoid more problems with hosts relying on a proper MSS.
.TP
\fB\-\-clamp\-mss\-to\-pmtu\fP
Automatically clamp MSS value to (path_MTU \- 40 for IPv4; \-60 for IPv6).
This may not function as desired where asymmetric routes with differing
path MTU exist \(em the kernel uses the path MTU which it would use to send
packets from itself to the source and destination IP addresses. Prior to
Linux 2.6.25, only the path MTU to the destination IP address was
considered by this option; subsequent kernels also consider the path MTU
to the source IP address.
.PP
These options are mutually exclusive.
