/**
* @file ProgramSelectConfirm.h
*
*/

#ifndef PROGRAMSELECTCONFIRM_H_
#define PROGRAMSELECTCONFIRM_H_

#include "SDVMessage.h"
#include "sdv_iarm.h"

namespace sdv {

/**
 * @class ProgramSelectConfirm
 * @brief CCMIS ProgramSelectConfirm class definition
 *
 * @details Defines CCMIS ProgramSelectConfirm inbound message.
 */
class ProgramSelectConfirm : public SDVMessage {
public:

	/**
	 * @constructor
	 * @brief Constructor to create an ProgramSelectConfirm SDV message from the specified raw data.
	 *
	 * @param [in] buffer raw data received from SDV Server
	 */
	ProgramSelectConfirm(uint8_t* buffer);

	/**
	 * @fn getResponseCode
	 * @brief Get the response code in this message
	 *
	 * @return response code, mostly values defined in CCMIS 3.14
	 */
	SDVAGENT_PROGRAM_SELECT_STATUS getResponseCode();

	/**
	 * @fn getSourceId
	 * @brief Get the source ID in this message.
	 *
	 * @return source ID
	 */
	uint32_t getSourceId();

	/**
	 * @fn getModulation
	 * @brief Get the modulation format in this message.
	 *
	 * @return modulation format, values defined in CCMIS 3.14
	 */
	uint8_t getModulation();

	/**
	 * @fn getFrequency
	 * @brief Get the QAM tuning frequency in this message.
	 *
	 * @return tuning frequency in hertz
	 */
	uint32_t getFrequency();

	/**
	 * @fn getMpegProgramNumber
	 * @brief Get the MPEG program number in this message
	 *
	 * @return MPEG program number for transport stream
	 */
	uint16_t getMpegProgramNumber();

private:

	/**
	 * @struct ccmis_program_select_confirm
	 * @brief Data structure of CCMIS ProgramSelectConfirm that can be directly casted into packet buffer.
	 * Fields are defined in CCMIS 3.14
	 */
#pragma pack(push,1)
	typedef struct ccmis_program_select_confirm {
		struct ccmis_header header;
		uint16_t response;
		uint32_t source_id;
		uint16_t private_data_length;
		uint8_t reserved_1;
		uint8_t modulation_format;
		uint32_t tuning_frequency;
		uint16_t mpeg_program_number;
		uint16_t reserved_2;
	} CCMIS_PROGRAM_SELECT_CONFIRM;
#pragma pack(pop)

	SDVAGENT_PROGRAM_SELECT_STATUS response;
	uint32_t source_id;
	uint8_t modulation_format;
	uint32_t tuning_frequency;
	uint16_t mpeg_program_number;
};

}


#endif /* PROGRAMSELECTCONFIRM_H_ */
