/**
 * @file QueryConfirm.h
 *
 */

#ifndef QUERYCONFIRM_H_
#define QUERYCONFIRM_H_

#include "SDVMessage.h"

namespace sdv {

/**
 * @class QueryConfirm
 * @brief CCMIS QueryConfirm class definition
 *
 * @details Defines CCMIS QueryConfirm outbound message.
 */
class QueryConfirm : public SDVMessage {

public:
	/**
	 * @constructor
	 * @brief Constructor to create an QueryConfirm SDV message using the specified parameters.
	 *
	 * @param [in] macAddress
	 * @param [in] tunerIndex
	 * @param [in] sourceId
	 * @param [in] tunerUse
	 * @param [in] serviceGroupId
	 * @param [in] lastUserActivity
	 * @param [in] transactionId
	 */
	QueryConfirm(uint8_t* macAddress, uint8_t tunerIndex, uint32_t sourceId, uint8_t tunerUse,
			uint32_t serviceGroupId, uint32_t lastUserActivity, uint32_t transactionId);

	/**
	 * @fn serialize
	 * @brief Serialize this message into the specified empty buffer.
	 * The serialized data will be ready for UDP transmission to the SDV Server.
	 *
	 * @param [out] emptyBuff - empty buffer to store serialized message
	 * @param [in] maxBuffLength - maximum length of empty buffer in bytes
	 * @return length of serialized message in bytes
	 */
	size_t serialize(uint8_t* emptyBuff, size_t buffLength);


private:

	/**
	 * @struct ccmis_query_confirm
	 * @brief Data structure of CCMIS QueryConfirm that can be directly casted into packet buffer.
	 * Fields are defined in CCMIS 3.14
	 */
#pragma pack(push,1)
	typedef struct ccmis_query_confirm {
		struct ccmis_header header;
		uint16_t response;
		uint32_t source_id;
		uint16_t private_data_len;
		uint8_t tuner_use;
		uint8_t reserved;
		uint32_t service_group_id;
		uint32_t last_user_activity;
	} CCMIS_QUERY_CONFIRM;
#pragma pack(pop)


	static const uint16_t PAYLOAD_LENGTH = sizeof(struct ccmis_query_confirm) - sizeof(struct ccmis_header); //!> excludes session ID
	static const uint16_t PRIVATE_DATA_LENGTH = 0x000a;

	uint32_t source_id;
	uint8_t tuner_use;
	uint8_t retry_count;
	uint32_t service_group_id;
	uint32_t last_user_activity;
};

} /* namespace sdv */

#endif /* QUERYCONFIRM_H_ */
