/*
 *  ConfigurationParser_ut.cc
 *
 *  Created on: Jun 16, 2014
 *      Author: jbett
 */

#include "ConfigurationParser.h"
#include "mocks/IARMProxyService_mock.h"
#include "mocks/SDVEventQueue_mock.h"
#include "gtest/gtest.h"
#include <gtest/gtest.h>
#include <gmock/gmock.h>
#include <stdio.h>
#include <cstdio>
#include <fstream>


using ::testing::Test;
using ::testing::Invoke;
using ::testing::Return;
using ::testing::_;
using ::testing::An;

using namespace sdv;


uint8_t rawMcData[] = {
		0xc9,0x03,0xcf,0x00,0x00,0xdb,0x00,0x00,0x00,0x1c,0x4d,0x41,0x58,0x45,0x00,0x00,
		0x00,0x00,0xc2,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x10,0x2f,0x07,0x2f,0x40,
		0x03,0xf5,0x00,0x06,0x01,0xd0,0x27,0x88,0xfc,0x00,0x45,0x53,0x50,0x4e,0x00,0x00,
		0x00,0x00,0xc1,0x00,0x00,0x00,0xc1,0x00,0xff,0xff,0xff,0x10,0x2f,0x07,0x2f,0x40,
		0x03,0xf5,0x00,0x62,0x01,0xd0,0x27,0xc3,0xfc,0x00,0x53,0x44,0x56,0x30,0x35,0x20,
		0x48,0x42,0x4f,0x53,0x50,0x00,0xe8,0xbb,0xff,0xff,0xff,0x10,0x2e,0xab,0xa1,0xc0,
		0x03,0xf4,0x1f,0x45,0x01,0xd0,0x28,0x03,0xfc,0x00,0x4b,0x41,0x42,0x43,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x10,0x2f,0x07,0x2f,0x40,
		0x03,0xf5,0x00,0x0f,0x01,0xd0,0x28,0x45,0xfc,0x00,0x4b,0x4d,0x45,0x58,0x00,0xff,
		0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x10,0x2f,0x07,0x2f,0x40,
		0x03,0xf5,0x00,0x4d,0x01,0xd0,0x29,0x46,0xfc,0x00,0x4b,0x54,0x4c,0x41,0x00,0x03,
		0x00,0x00,0xfe,0x03,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x10,0x2e,0xab,0xa1,0xc0,
		0x03,0xf4,0x00,0x19,0x01,0xd0,0x29,0xe4,0xfc,0x00,0x54,0x61,0x6c,0x6b,0x20,0x74,
		0x6f,0x20,0x42,0x6f,0x62,0x20,0x56,0x00,0xff,0xff,0xff,0x10,0x2e,0xab,0xa1,0xc0,
		0x03,0xf4,0x00,0x3b,0x01,0xd0,0x30,0x9c,0xfc,0x00,0x44,0x49,0x53,0x4e,0x45,0x59,
		0x00,0x09,0xf0,0x44,0x6d,0x08,0x00,0x00,0xff,0xff,0xff,0x10,0x2f,0x62,0xbc,0xc0,
		0x03,0xf6,0x00,0xd0,0x01,0xd0,0x30,0xde,0xfc,0x00,0x48,0x42,0x4f,0x20,0x5a,0x6f,
		0x6e,0x65,0x20,0x45,0x61,0x73,0x74,0x00,0xff,0xff,0xff,0x10,0x2e,0x50,0x14,0x40,
		0x03,0xf3,0x00,0x11,0x01,0xd0,0x47,0xff,0xfc,0x00,0x41,0x43,0x54,0x45,0x00,0xcc,
		0xb0,0xae,0xf0,0x44,0x6d,0x08,0x00,0x00,0xff,0xff,0xff,0x10,0x2e,0xab,0xa1,0xc0,
		0x03,0xf4,0x00,0x08,0x01,0xd0,0x48,0x01,0xfc,0x00,0x53,0x44,0x56,0x30,0x38,0x20,
		0x41,0x4d,0x41,0x58,0x50,0x00,0x00,0x00,0xff,0xff,0xff,0x10,0x2e,0xab,0xa1,0xc0,
		0x03,0xf4,0x1f,0x48,0x01,0xd0,0x48,0x02,0xfc,0x00,0x54,0x68,0x72,0x69,0x6c,0x6c,
		0x65,0x72,0x20,0x4d,0x41,0x58,0x00,0x00,0xff,0xff,0xff,0x10,0x2e,0xab,0xa1,0xc0,
		0x03,0xf4,0x00,0x12,0x01,0xd0,0x48,0x03,0xfc,0x00,0x4f,0x75,0x74,0x65,0x72,0x4d,
		0x41,0x58,0x00,0x44,0x6d,0x08,0x00,0x00,0xff,0xff,0xff,0x10,0x2f,0x07,0x2f,0x40,
		0x03,0xf5,0x00,0x14,0x01,0xd0,0x64,0x16,0xfc,0x00,0x43,0x4f,0x58,0x33,0x00,0x00,
		0x00,0x00,0x08,0x02,0x00,0x00,0x08,0x02,0xff,0xff,0xff,0x10,0x2e,0x50,0x14,0x40,
		0x03,0xf3,0x00,0x09,0x01,0xd0,0x8d,0xc7,0xfc,0x00,0x53,0x44,0x56,0x30,0x33,0x20,
		0x48,0x42,0x4f,0x32,0x50,0x00,0x06,0x01,0xff,0xff,0xff,0x10,0x2f,0x62,0xbc,0xc0,
		0x03,0xf6,0x1f,0x43,0x01,0xd0,0xe7,0xdb,0xfc,0x00,0x43,0x43,0x5f,0x31,0x00,0x00,
		0x00,0x00,0xd0,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x10,0x2f,0x62,0xbc,0xc0,
		0x03,0xf6,0x00,0x15,0x01,0xc2,0xfd,0x84,0xfc,0x00,0x43,0x43,0x5f,0x32,0x00,0x00,
		0x00,0x00,0x04,0x00,0x00,0x00,0x04,0x00,0xff,0xff,0xff,0x10,0x2e,0x50,0x14,0x40,
		0x03,0xf3,0x00,0x16,0x01,0xc2,0xfd,0x85,0xfc,0x00,0x43,0x43,0x5f,0x33,0x00,0x00,
		0x00,0x00,0xb5,0x00,0x00,0x00,0xb5,0x00,0xff,0xff,0xff,0x10,0x2f,0x62,0xbc,0xc0,
		0x03,0xf6,0x00,0x17,0x01,0xc2,0xfd,0x86,0xfc,0x00,0x4d,0x43,0x31,0x20,0x52,0x26,
		0x42,0x00,0xd2,0x00,0x00,0x00,0xd2,0x00,0xff,0xff,0xff,0x10,0x2f,0x07,0x2f,0x40,
		0x03,0xf5,0x00,0x56,0x01,0xd0,0xfd,0x89,0xfc,0x00,0x4d,0x43,0x32,0x20,0x53,0x6f,
		0x6c,0x69,0x64,0x20,0x47,0x6f,0x6c,0x00,0xff,0xff,0xff,0x10,0x2f,0x62,0xbc,0xc0,
		0x03,0xf6,0x00,0x57,0x01,0xd0,0xfd,0x8a,0xfc,0x00,0x4d,0x43,0x33,0x20,0x48,0x69,
		0x74,0x20,0x4c,0x69,0x73,0x74,0x00,0x00,0xff,0xff,0xff,0x10,0x2e,0x50,0x14,0x40,
		0x03,0xf3,0x00,0x58,0x01,0xd0,0xfd,0x8b,0xfc,0x00,0x4d,0x43,0x35,0x20,0x52,0x6f,
		0x63,0x6b,0x00,0x44,0x6d,0x08,0x00,0x00,0xff,0xff,0xff,0x10,0x2f,0x07,0x2f,0x40,
		0x03,0xf5,0x00,0x5a,0x01,0xd0,0xfd,0x8d,0xfc,0x00,0x4d,0x43,0x36,0x20,0x52,0x65,
		0x74,0x72,0x6f,0x20,0x52,0x6f,0x63,0x00,0xff,0xff,0xff,0x10,0x2f,0x07,0x2f,0x40,
		0x03,0xf5,0x00,0x5b,0x01,0xd0,0xfd,0x8e,0xfc,0x00,0x4d,0x43,0x37,0x20,0x43,0x6c,
		0x61,0x73,0x73,0x69,0x63,0x20,0x52,0x00,0xff,0xff,0xff,0x10,0x2f,0x07,0x2f,0x40,
		0x03,0xf5,0x00,0x5c,0x01,0xd0,0xfd,0x8f,0xfc,0x00,0x4d,0x43,0x38,0x20,0x53,0x6f,
		0x66,0x74,0x20,0x52,0x6f,0x63,0x6b,0x00,0xff,0xff,0xff,0x10,0x2f,0x07,0x2f,0x40,
		0x03,0xf5,0x00,0x5d,0x01,0xd0,0xfd,0x90,0xfc,0x00,0x4d,0x43,0x31,0x30,0x20,0x4a,
		0x61,0x7a,0x7a,0x00,0x00,0x00,0x01,0x00,0xff,0xff,0xff,0x10,0x2f,0x07,0x2f,0x40,
		0x03,0xf5,0x00,0x5f,0x01,0xd0,0xfd,0x92,0xfc,0x00,0x52,0x61,0x64,0x69,0x6f,0x20,
		0x31,0x00,0x04,0xa6,0x07,0x00,0x00,0x00,0xff,0xff,0xff,0x10,0x2f,0x07,0x2f,0x40,
		0x03,0xf5,0x00,0x60,0x01,0xd0,0xfd,0x93,0xfc,0x00,0x52,0x61,0x64,0x69,0x6f,0x20,
		0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x10,0x2f,0x07,0x2f,0x40,
		0x03,0xf5,0x00,0x61,0x01,0xd0,0xfd,0x94,0xfc,0x00,0xfc,0x42,0x03,0x0a,0x57,0x89,
		0xac,0x10,0x09,0x02,0x00,0x00,0x00,0x00,0x04,0x1a,0x7f,0xff,0x00,0x00,0x00,0x5a,
		0x00,0x00,0x01,0x2c,0x00,0x00,0x03,0xe8,0x00,0x00,0x00,0x04,0x00,0x00,0x03,0xe8,
		0x00,0x00,0x00,0x5a,0x06,0x04,0x00,0x00,0x00,0x01,0x07,0x12,0x57,0x89,0xfc,0x00,
		0xc0,0xa8,0x03,0x00,0x40,0x0c,0x01,0x72,0x00,0x16,0x00,0x09,0x00,0x02,0x8c,0x38,
		0x95,0x27,0x55,0x55 };

char mcDataIp4[] = "172.16.9.2";
uint32_t mcDataIp4port = 22409;
uint32_t mcDataServiceGroupId = 1;

#define MCDATA_IP4_ADDR_OFFSET (57 * 16)
#define MCDATA_GROUPID_OFFSET ((59 * 16) + 9)


class ConfigurationParserTest : public Test {

public:
    void SetUp(){
        iarmProxy = new MockIARMProxyService();
        eventQueue = new MockSDVEventQueue();
        callbackInvokedWithSgChange = false;
        callbackInvokedWithIpChange = false;
    }
    void TearDown(){
        delete iarmProxy;
        delete eventQueue;
        delete testObj;

    }
    static void mcpUpdateCallback(void * ptrObject, bool isServiceGroupChange, bool isServerIpChange) {
        callbackInvokedWithSgChange = isServiceGroupChange;
        callbackInvokedWithIpChange = isServerIpChange;
    }

    static bool callbackInvokedWithSgChange;
    static bool callbackInvokedWithIpChange;
    uint32_t temp;

    ConfigurationParser* testObj;
    MockIARMProxyService* iarmProxy;
    MockSDVEventQueue* eventQueue;

};

bool ConfigurationParserTest::callbackInvokedWithSgChange;
bool ConfigurationParserTest::callbackInvokedWithIpChange;


TEST_F(ConfigurationParserTest, ConstructorTest) {

	testObj = new ConfigurationParser(iarmProxy, eventQueue, NULL, mcpUpdateCallback);

	ASSERT_TRUE(testObj != NULL);
}

TEST_F(ConfigurationParserTest, getStbMacTest) {
	// Get local eth0 MAC from linux file system
	std::string expectedMacString;
	std::ifstream macFile("/sys/class/net/eth0/address");
	std::getline(macFile, expectedMacString);
	//printf("file mac=%s\n", expectedMacString.c_str());

	testObj = new ConfigurationParser(iarmProxy, eventQueue, NULL, mcpUpdateCallback);
	uint8_t* array = testObj->getStbMac();
	char macStr[18];
	snprintf(macStr, sizeof(macStr), "%02x:%02x:%02x:%02x:%02x:%02x", array[0], array[1], array[2], array[3], array[4], array[5]);
	//printf("configuration mac=%s\n", macStr);

	ASSERT_TRUE(strcmp(expectedMacString.c_str(), macStr) == 0);
}


TEST_F(ConfigurationParserTest, firstMcUpdateReceived) {

	// Set expectations for Configuration to register for IARM RPC
	EXPECT_CALL(*iarmProxy, registerIARMRPC(_,_,_))
    .WillOnce(Invoke(iarmProxy, &MockIARMProxyService::registerIARMRPC_action2));

    // Create and start Configuration test object
    testObj = new ConfigurationParser(iarmProxy, eventQueue, NULL, mcpUpdateCallback);
    testObj->start();

    // Get callback function registered in our mock IARM
    IARM_BusCall_t newMcDataReceived_callback = iarmProxy->getRegisteredHandler("sdvAgentNewMcData");
    ASSERT_TRUE(newMcDataReceived_callback != NULL);

    // Set expectations for event queue push
    EXPECT_CALL(*eventQueue, push(_,_,_,_))
    .WillOnce(Invoke(eventQueue, &MockSDVEventQueue::pushAction));

    // Execute test
    newMcDataReceived_callback(rawMcData);
    sleep(1);  // allow event queue to fire

    // Verify registered mcp update callback invoked
    ASSERT_TRUE(callbackInvokedWithIpChange == true);
    ASSERT_TRUE(callbackInvokedWithSgChange == true);

    // Verify several data fields
    ASSERT_TRUE(strcmp(testObj->getServerIpString().c_str(), mcDataIp4) == 0);
    ASSERT_TRUE(testObj->getServerIpPort() == mcDataIp4port);
    ASSERT_TRUE(testObj->getServiceGroupId() == mcDataServiceGroupId);
}

TEST_F(ConfigurationParserTest, mcUpdateReceivedWithNoChanges) {

	// Set expectations for Configuration to register for IARM RPC
	EXPECT_CALL(*iarmProxy, registerIARMRPC(_,_,_))
    .WillOnce(Invoke(iarmProxy, &MockIARMProxyService::registerIARMRPC_action2));

    // Create and start Configuration test object
    testObj = new ConfigurationParser(iarmProxy, eventQueue, NULL, mcpUpdateCallback);
    testObj->start();

    // Get callback function registered in our mock IARM
    IARM_BusCall_t newMcDataReceived_callback = iarmProxy->getRegisteredHandler("sdvAgentNewMcData");
    ASSERT_TRUE(newMcDataReceived_callback != NULL);

    // Set expectations for event queue push
    EXPECT_CALL(*eventQueue, push(_,_,_,_))
    .WillOnce(Invoke(eventQueue, &MockSDVEventQueue::pushAction));

    // Execute initial loading of data
    newMcDataReceived_callback(rawMcData);
    sleep(1);  // allow event queue to fire

    // Verify registered mcp update callback invoked
    ASSERT_TRUE(callbackInvokedWithIpChange == true);
    ASSERT_TRUE(callbackInvokedWithSgChange == true);

    // Set expectations for event queue push
    EXPECT_CALL(*eventQueue, push(_,_,_,_))
    .WillOnce(Invoke(eventQueue, &MockSDVEventQueue::pushAction));

    callbackInvokedWithIpChange = false;
    callbackInvokedWithSgChange = false;

    // Execute test
    newMcDataReceived_callback(rawMcData);
    sleep(1);  // allow event queue to fire

    // Verify registered mcp update callback was not invoked
    ASSERT_TRUE(callbackInvokedWithIpChange == false);
    ASSERT_TRUE(callbackInvokedWithSgChange == false);

    // Verify several data fields
    ASSERT_TRUE(strcmp(testObj->getServerIpString().c_str(), mcDataIp4) == 0);
    ASSERT_TRUE(testObj->getServerIpPort() == mcDataIp4port);
    ASSERT_TRUE(testObj->getServiceGroupId() == mcDataServiceGroupId);
}

TEST_F(ConfigurationParserTest, mcUpdateReceivedWithIpChange) {

	// Set expectations for Configuration to register for IARM RPC
	EXPECT_CALL(*iarmProxy, registerIARMRPC(_,_,_))
    .WillOnce(Invoke(iarmProxy, &MockIARMProxyService::registerIARMRPC_action2));

    // Create and start Configuration test object
    testObj = new ConfigurationParser(iarmProxy, eventQueue, NULL, mcpUpdateCallback);
    testObj->start();

    // Get callback function registered in our mock IARM
    IARM_BusCall_t newMcDataReceived_callback = iarmProxy->getRegisteredHandler("sdvAgentNewMcData");
    ASSERT_TRUE(newMcDataReceived_callback != NULL);

    // Set expectations for event queue push
    EXPECT_CALL(*eventQueue, push(_,_,_,_))
    .WillOnce(Invoke(eventQueue, &MockSDVEventQueue::pushAction));

    // Execute initial loading of data
    newMcDataReceived_callback(rawMcData);
    sleep(1);  // allow event queue to fire

    // Verify registered mcp update callback invoked
    ASSERT_TRUE(callbackInvokedWithIpChange == true);
    ASSERT_TRUE(callbackInvokedWithSgChange == true);

    // Set expectations for event queue push
    EXPECT_CALL(*eventQueue, push(_,_,_,_))
    .WillOnce(Invoke(eventQueue, &MockSDVEventQueue::pushAction));

    // Initialize opposite of expectations
    callbackInvokedWithIpChange = false;
    callbackInvokedWithSgChange = true;

    // Execute test
    rawMcData[MCDATA_IP4_ADDR_OFFSET] = 173;
    newMcDataReceived_callback(rawMcData);
    sleep(1);  // allow event queue to fire

    // Verify registered mcp update callback was invoked
    ASSERT_TRUE(callbackInvokedWithIpChange == true);
    ASSERT_TRUE(callbackInvokedWithSgChange == false);

    // Verify several data fields
    ASSERT_TRUE(strcmp(testObj->getServerIpString().c_str(), "173.16.9.2") == 0);
    ASSERT_TRUE(testObj->getServerIpPort() == mcDataIp4port);
    ASSERT_TRUE(testObj->getServiceGroupId() == mcDataServiceGroupId);
}

TEST_F(ConfigurationParserTest, mcUpdateReceivedWithGroupIdChange) {

	// Set expectations for Configuration to register for IARM RPC
	EXPECT_CALL(*iarmProxy, registerIARMRPC(_,_,_))
    .WillOnce(Invoke(iarmProxy, &MockIARMProxyService::registerIARMRPC_action2));

    // Create and start Configuration test object
    testObj = new ConfigurationParser(iarmProxy, eventQueue, NULL, mcpUpdateCallback);
    testObj->start();

    // Get callback function registered in our mock IARM
    IARM_BusCall_t newMcDataReceived_callback = iarmProxy->getRegisteredHandler("sdvAgentNewMcData");
    ASSERT_TRUE(newMcDataReceived_callback != NULL);

    // Set expectations for event queue push
    EXPECT_CALL(*eventQueue, push(_,_,_,_))
    .WillOnce(Invoke(eventQueue, &MockSDVEventQueue::pushAction));

    // Execute initial loading of data
    newMcDataReceived_callback(rawMcData);
    sleep(1);  // allow event queue to fire

    // Verify registered mcp update callback invoked
    ASSERT_TRUE(callbackInvokedWithIpChange == true);
    ASSERT_TRUE(callbackInvokedWithSgChange == true);

    // Set expectations for event queue push
    EXPECT_CALL(*eventQueue, push(_,_,_,_))
    .WillOnce(Invoke(eventQueue, &MockSDVEventQueue::pushAction));

    // Initialize opposite of expectations
    callbackInvokedWithIpChange = true;
    callbackInvokedWithSgChange = false;

    // Execute test
    rawMcData[MCDATA_GROUPID_OFFSET] = 123;
    newMcDataReceived_callback(rawMcData);
    sleep(1);  // allow event queue to fire

    // Verify registered mcp update callback was invoked
    ASSERT_TRUE(callbackInvokedWithIpChange == false);
    ASSERT_TRUE(callbackInvokedWithSgChange == true);

    // Verify group ID updated
    ASSERT_TRUE(testObj->getServiceGroupId() == 123);
}
