/**
 * @file IARMProxyService_mock.cc
 *
 * @date Jun 19, 2014
 * @Author Spencer Gilroy (sgilroy@cisco.com)
 **/
#ifndef IARMPROXYSERVICE_MOCK_CC_
#define IARMPROXYSERVICE_MOCK_CC_

#include "IARMProxyService.h"
#include <gmock/gmock.h>
#include <map>


class MockIARMProxyService : public sdv::IARMProxyService {
public:
    MOCK_METHOD0(start, SERVICE_RESULT());
    MOCK_METHOD0(stop,  SERVICE_RESULT());
    MOCK_METHOD2(registerIARMRPC, IARM_Result_t(const char* rpcName, IARM_BusCall_t rpcFunction));
    MOCK_METHOD3(registerIARMRPC, IARM_Result_t(const char* rpcName, IARM_BusCall_t rpcFunction, void* rpcObject));
    MOCK_METHOD3(addEventHandler, void(const char *owner, IARM_EventId_t eventId, IARMProxyEventHander_t eventHandler));
private:
    struct cmp_str{
        bool operator()(const char *first, const char  *second){
            return strcmp(first, second) < 0;
        }
    };
    typedef std::map<const char*, IARM_BusCall_t,cmp_str> REGISTERED_HANDLERS_t;
    REGISTERED_HANDLERS_t registeredHandlers;
public:
    IARM_Result_t registerIARMRPC_action(const char* methodName, IARM_BusCall_t handler){
        registeredHandlers[methodName] = handler;
        printf("IARMProxyService_mock.registerIARMRPC_action: name=%s\n", methodName);
        return IARM_RESULT_SUCCESS;
    }
    IARM_Result_t registerIARMRPC_action2(const char* methodName, IARM_BusCall_t handler, void* rpcObject){
        registeredHandlers[methodName] = handler;
    	IARMProxyService::registerIARMRPC(methodName, handler, rpcObject);
        return IARM_RESULT_SUCCESS;
    }
    IARM_BusCall_t getRegisteredHandler(const char* methodName){
        REGISTERED_HANDLERS_t::iterator iter = registeredHandlers.find(methodName);
        return iter == registeredHandlers.end()?NULL:iter->second;
    }
};

#endif
