TARGET = QtWebSockets

TEMPLATE += lib

#COMCAST MODIFICATION BEGIN [WEBSOCKETS]
MODULE_VERSION = 5.6.2
equals(QT_MAJOR_VERSION,5):greaterThan(QT_MINOR_VERSION,0) {
    CONFIG += git_build
}
#COMCAST MODIFICATION END [WEBSOCKETS]

DEFINES += QTWEBSOCKETS_LIBRARY

QT = core-private network

QMAKE_DOCS = $$PWD/doc/qtwebsockets.qdocconf
OTHER_FILES += doc/src/*.qdoc   # show .qdoc files in Qt Creator
OTHER_FILES += doc/snippets/*.cpp
OTHER_FILES += doc/qtwebsockets.qdocconf

PUBLIC_HEADERS += \
    $$PWD/qwebsockets_global.h \
    $$PWD/qwebsocket.h \
    $$PWD/qwebsocketserver.h \
    $$PWD/qwebsocketprotocol.h \
    $$PWD/qwebsocketcorsauthenticator.h \
    $$PWD/qmaskgenerator.h

PRIVATE_HEADERS += \
    $$PWD/qwebsocket_p.h \
    $$PWD/qwebsocketserver_p.h \
    $$PWD/qwebsocketprotocol_p.h \
    $$PWD/qwebsockethandshakerequest_p.h \
    $$PWD/qwebsockethandshakeresponse_p.h \
    $$PWD/qwebsocketdataprocessor_p.h \
    $$PWD/qwebsocketcorsauthenticator_p.h \
    $$PWD/qwebsocketframe_p.h \
    $$PWD/qdefaultmaskgenerator_p.h

SOURCES += \
    $$PWD/qwebsocket.cpp \
    $$PWD/qwebsocket_p.cpp \
    $$PWD/qwebsocketserver.cpp \
    $$PWD/qwebsocketserver_p.cpp \
    $$PWD/qwebsocketprotocol.cpp \
    $$PWD/qwebsockethandshakerequest.cpp \
    $$PWD/qwebsockethandshakeresponse.cpp \
    $$PWD/qwebsocketdataprocessor.cpp \
    $$PWD/qwebsocketcorsauthenticator.cpp \
    $$PWD/qwebsocketframe.cpp \
    $$PWD/qmaskgenerator.cpp \
    $$PWD/qdefaultmaskgenerator_p.cpp

contains(QT_CONFIG, ssl) | contains(QT_CONFIG, openssl) | contains(QT_CONFIG, openssl-linked) {
    SOURCES += $$PWD/qsslserver.cpp
    PRIVATE_HEADERS += $$PWD/qsslserver_p.h
}

HEADERS += $$PUBLIC_HEADERS $$PRIVATE_HEADERS

load(qt_module)
