/*
 * Copyright (C) 2014 Filip Pizlo. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY FILIP PIZLO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL FILIP PIZLO OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

#ifndef FP_TSF_DEFINE_HELPERS_H
#define FP_TSF_DEFINE_HELPERS_H

#include "tsf.h"

/* This header is meant to only be defined by .c files generated by
   tsf_define. */

/* FIXME: add tsf_define helpers for dealing with primitive generators,
   parsers, and copiers, as well as caching array-of-primitive types. */

/* "Abort On Error" (aoe) helpers. If any error occurs, they will print
   the error to stderr and then abort. The error will indicate that it
   was during tsf_define type building. */

tsf_type_t *tsf_type_create_aoe(tsf_type_kind_t kind_code);
tsf_type_t *tsf_type_create_array_aoe(tsf_type_t *ele_type);
tsf_type_t *tsf_type_create_struct_with_native_size_aoe(size_t size);
tsf_type_t *tsf_type_create_struct_with_native_size_and_destructor_aoe(size_t size, void (*dest)(void*));
tsf_type_t *tsf_type_create_choice_with_native_map_aoe(
    tsf_type_t **type, tsf_bool_t in_place, size_t value_offset, size_t data_offset, size_t size);
void tsf_type_set_comment_aoe(tsf_type_t **type, const char *comment);

void tsf_struct_type_append_with_native_map_aoe(
    tsf_type_t **type, const char *name, tsf_type_t *ele_type, size_t offset);
void tsf_struct_type_append_primitive_with_native_map_aoe(
    tsf_type_t **type, const char *name, tsf_type_kind_t primitive_type, size_t offset);
void tsf_struct_type_append_from_callback_and_dup_with_native_map_aoe(
    tsf_type_t **type, const char *name, tsf_type_t *(*callback)(void), size_t offset);
void tsf_struct_type_append_with_native_map_with_comment_aoe(
    tsf_type_t **type, const char *name, tsf_type_t *ele_type, size_t offset, const char *comment);
void tsf_struct_type_append_primitive_with_native_map_with_comment_aoe(
    tsf_type_t **type, const char *name, tsf_type_kind_t type_kind, size_t offset,
    const char *comment);
void tsf_struct_type_append_from_callback_and_dup_with_native_map_with_comment_aoe(
    tsf_type_t **type, const char *name, tsf_type_t *(*callback)(void), size_t offset,
    const char *comment);

void tsf_choice_type_append_aoe(
    tsf_type_t **type, const char *name, tsf_type_t *ele_type);
void tsf_choice_type_append_primitive_aoe(
    tsf_type_t **type, const char *name, tsf_type_kind_t type_kind);
void tsf_choice_type_append_from_callback_and_dup_aoe(
    tsf_type_t **type, const char *name, tsf_type_t *(*callback)(void));
void tsf_choice_type_append_with_comment_aoe(
    tsf_type_t **type, const char *name, tsf_type_t *ele_type, const char *comment);
void tsf_choice_type_append_primitive_with_comment_aoe(
    tsf_type_t **type, const char *name, tsf_type_kind_t type_kind, const char *comment);
void tsf_choice_type_append_from_callback_and_dup_with_comment_aoe(
    tsf_type_t **type, const char *name, tsf_type_t *(*callback)(void), const char *comment);

void tsf_struct_type_set_optional_aoe(tsf_type_t **type, const char *name, tsf_bool_t optional);

void tsf_type_set_name_aoe(tsf_type_t **type, const char *name);
void tsf_type_set_version_aoe(tsf_type_t **type, uint32_t major, uint32_t minor, uint32_t patch);

/* Helpers for reading and writing. */

tsf_bool_t tsf_typed_data_write(tsf_stream_file_output_t *out, tsf_genrtr_t *generator, void *data);
void *tsf_typed_data_read(tsf_stream_file_input_t *in, tsf_parser_t *parser);
tsf_bool_t tsf_typed_data_read_into(tsf_stream_file_input_t *in, tsf_parser_t *parser, void *result);

#endif // FP_TSF_DEFINE_HELPERS_H

