/******************************************************************************
 *  Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors.
 *  Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 *  This program is the proprietary software of Broadcom and/or its licensors,
 *  and may only be used, duplicated, modified or distributed pursuant to the terms and
 *  conditions of a separate, written license agreement executed between you and Broadcom
 *  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 *  no license (express or implied), right to use, or waiver of any kind with respect to the
 *  Software, and Broadcom expressly reserves all rights in and to the Software and all
 *  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 *  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 *  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 *  Except as expressly set forth in the Authorized License,
 *
 *  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 *  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 *  and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 *  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 *  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 *  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 *  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 *  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 *  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 *  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 *  USE OR PERFORMANCE OF THE SOFTWARE.
 *
 *  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 *  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 *  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 *  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 *  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 *  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 *  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 *  ANY LIMITED REMEDY.
 ******************************************************************************/

#ifndef __VL_HAL_SNMP_UTILS_H__
#define __VL_HAL_SNMP_UTILS_H__

#include "cVector.h"
//#include "mpe_types.h"

#ifdef __cplusplus
extern "C" {
#endif

#define MAX_NUM_TEMP_SENSOR_TYPES   3
#define MAX_DESCR_NAME_LEN          255

typedef enum
{
  HOST_SYSTEM_SENSOR_TYPE_CPU = 1,
  HOST_SYSTEM_SENSOR_TYPE_HDD_INTERNAL,
  HOST_SYSTEM_SENSOR_TYPE_MAINBOARD,
  HOST_SYSTEM_SENSOR_TYPE_MAX
  
}HOST_SYSTEM_SENSOR_TYPE;

typedef struct _tempDescrInfo
{
  HOST_SYSTEM_SENSOR_TYPE  sensorType;
  unsigned char name[MAX_DESCR_NAME_LEN];
  int           length;
  int           tempValue;
  int           tempLastUpdate;
  int           tempMaxVal;
  
}sTempDescrInfo;

typedef enum
{
        devEthernet,
        devDISK,
	devTuner,
	dev1394

}deviceType;

typedef struct
{
	unsigned char		isDecode;
	unsigned long 		devIndex;
	unsigned long 		decoderIndex;
	deviceType 		devType;
	unsigned char		vidDecStatus;
	unsigned char		audDecStatus;
	unsigned short          videoPid;
	unsigned short          audioPid;
	unsigned short          pcrPid;
	unsigned char		progStatus;
	unsigned long           tunerLTSID;
	unsigned int		programNum;
	unsigned char		CCIData;
        unsigned char           pcrlockStatus;
        unsigned long           dcontinuities;
        unsigned long           pts_errors;
        unsigned long           ContentPktErrors;
        unsigned long           ContentPipelineErrors;
}ConnDetails;

int CHALSnmp_init(void);

unsigned int AddToConnList(ConnDetails* pConnDetails);
unsigned int RemFromConnList(unsigned long phySrcId, deviceType devType);
unsigned int GetConnListElement(ConnDetails* connDetails, unsigned int listIter);
unsigned int GetConnListSize(unsigned int* listSize);
rmf_Error vlMpeosUpdatePcrStats(ConnDetails* pConnDetails);
rmf_Error vlMpeosSnmpGetPcrAndPtsStats(ConnDetails* pConnDetails);
rmf_Error vlMpeosGetLockPcrStats(int iTunerIndex, int * pbLocked);
rmf_Error vlDisp_HdmiReadEdidBlock(int * pnBytes, unsigned char * pBytes, int nCapacity);

int HAL_SNMP_Get_HostSystemTempDetails(HOST_SYSTEM_SENSOR_TYPE sensorType, sTempDescrInfo  *pTempDescrInfo);
#ifdef __cplusplus
}
#endif

#endif
