/******************************************************************************
 *  Copyright (c) 2017 RDK Management, LLC. All rights reserved.
 *  Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 *  This program is the proprietary software of Broadcom and/or its licensors,
 *  and may only be used, duplicated, modified or distributed pursuant to the terms and
 *  conditions of a separate, written license agreement executed between you and Broadcom
 *  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 *  no license (express or implied), right to use, or waiver of any kind with respect to the
 *  Software, and Broadcom expressly reserves all rights in and to the Software and all
 *  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 *  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 *  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 *  Except as expressly set forth in the Authorized License,
 *
 *  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 *  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 *  and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 *  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 *  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 *  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 *  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 *  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 *  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 *  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 *  USE OR PERFORMANCE OF THE SOFTWARE.
 *
 *  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 *  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 *  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 *  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 *  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 *  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 *  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 *  ANY LIMITED REMEDY.
 ******************************************************************************/

#include <gst/gst.h>
#include "nexus_platform.h"
#ifdef RDK_USE_NXCLIENT
#include "nxclient.h"
#else
#include "refsw_session_simple_client.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define DEFAULT_IPC_WINDOW_WIDTH 1280
#define DEFAULT_IPC_WINDOW_HEIGHT 720

#ifdef RDK_USE_NXCLIENT
static unsigned int g_clientID = 0;
#endif

void soc_uninit()
{
    if ( !strcmp(getenv("brcm_multiprocess_mode"),"y") ) {
#ifdef RDK_USE_NXCLIENT
       NxClient_Uninit();
#else
        NEXUS_Platform_Uninit();
        simple_client_shutdown();
#endif        
    } else if (!strcmp(getenv("no_nexus_platform_init"),"y")) {
        /* do nonthing */
    } else {
        NEXUS_Platform_Uninit();
    }
}

void soc_init(int id, char *appName, int bInitSurface)
{
    if ( !strcmp(getenv("brcm_multiprocess_mode"),"y") ) {
        NEXUS_Error rc;
#ifdef RDK_USE_NXCLIENT  
        NxClient_JoinSettings joinSettings;
      
        NxClient_GetDefaultJoinSettings(&joinSettings);
        snprintf(joinSettings.name, NXCLIENT_MAX_NAME,"%s",appName);
        rc = NxClient_Join(&joinSettings);

#else
        NEXUS_ClientAuthenticationSettings authSettings;

        brc_client_client_configuration configuration;
        simple_client_get_default_config(&configuration);
        snprintf(configuration.name.string, sizeof(configuration.name.string),"%s",appName);
        simple_client_init(&configuration,&authSettings);
        
        rc = NEXUS_Platform_AuthenticatedJoin(&authSettings);
#endif
        if (rc) {
            g_print("cannot join: %d\n", rc);
            exit(1);
        }

        if ( bInitSurface ) {
#ifdef RDK_USE_NXCLIENT
          NxClient_AllocSettings allocSettings;
          NxClient_AllocResults allocResults;
          NxClient_DisplaySettings displaySettings;

           printf("Inside NscClientInit... calling NxClient_GetDefaultAllocSetting and acquiring default client surface id...\n");

           NxClient_GetDefaultAllocSettings(&allocSettings);
           allocSettings.surfaceClient = 1;

           rc = NxClient_Alloc(&allocSettings, &allocResults);
           if (!rc)
               g_clientID = allocResults.surfaceClient[0].id;
           else
               printf("NxClient_Alloc failed! Unable to obtain surface client ID (%d)...\n", rc);

           printf("Inside NscClientInit... setting display format to 720p...\n");

           NxClient_GetDisplaySettings(&displaySettings);
           displaySettings.format = NEXUS_VideoFormat_e720p;
           rc = NxClient_SetDisplaySettings(&displaySettings);
           if (rc)
               printf("unable to set display format using NxClient_SetDisplaySettings (%d)...\n", rc);
#else        
            NEXUS_SurfaceClientHandle client_surface;
            NEXUS_SurfaceClientHandle client_video_window;
            NEXUS_SurfaceClientSettings client_settings;
            NEXUS_Rect *pRect;


            client_surface = NEXUS_SurfaceClient_Acquire( 0 );
            client_video_window = NEXUS_SurfaceClient_AcquireVideoWindow( client_surface, 0 );
            
            NEXUS_SurfaceClient_GetSettings(client_video_window, &client_settings);
            pRect = &client_settings.composition.position;
            pRect->x = pRect->y = 0;
            pRect->width = DEFAULT_IPC_WINDOW_WIDTH;
            pRect->height = DEFAULT_IPC_WINDOW_HEIGHT;
            rc = NEXUS_SurfaceClient_SetSettings(client_video_window, &client_settings);
            if (rc) {
                g_print("failed to set video window: %d\n", rc);
                exit(1);
            }

            NEXUS_SurfaceClient_ReleaseVideoWindow(client_video_window);
            NEXUS_SurfaceClient_Release(client_surface);
#endif            
        }
        
    } else if (!strcmp(getenv("no_nexus_platform_init"),"y")) {
        /* do nonthing */
    } else {
        NEXUS_Platform_Init(NULL);
    }
}


extern "C" void soc_init_(int id, char *appName, int bInitSurface)
{
    soc_init(id, appName, bInitSurface );
}


