/*-----------------------------------------------------------------*/
/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/

/*-----------------------------------------------------------------*/
#ifdef USE_DSG
/*-------------------------------------------------------------------
   Include Files
-------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <net/if_arp.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/stat.h>
#include <unistd.h>
#include <unistd.h>
#include <linux/reboot.h>
#include "rmf_osal_util.h"

#include "sys_init.h"

typedef unsigned char  UCHAR;
typedef unsigned short USHORT;
typedef unsigned int   UINT;
typedef unsigned long  ULONG;

#define VL_DSG_TFTP_HOME_DIRECTORY  "/tmp/"
#define VL_DSG_TLV217_FILE_NAME     "estbconfigsettings.bin"
#define VL_DSG_TLV217_FILE_PATH     (VL_DSG_TFTP_HOME_DIRECTORY VL_DSG_TLV217_FILE_NAME)
#define VL_DSG_INVALID_DCD_VERSION  (-1)
#define VL_DSG_BCM_API_ERROR        (254)
#define VL_DSG_IPU_DHCP_TIMEOUT     (60)
#define VL_DHCP_LOG_FILE            "/tmp/dhcp_log.txt"
#define VL_DHCP_CONTROL             "/etc/udhcpc_control"
#define VL_DSG_ECM_RESET_SCRIPT     "/lib/rdk/ecm_snmp_reset.sh"

static char vlg_szMpeosFeatureEcmToHostRebootSignal[]        = {"FEATURE.ECM.TO.HOST.REBOOT.SIGNAL"};
static char vlg_szMpeosFeatureRebootOnEcmError[]             = "SYSTEM.REBOOT.ON.ECM.ERROR.COUNT";
static char vlg_szMpeosFeatureRecoverOnDsgError[]            = "SYSTEM.RECOVER.ON.DSG.ERROR.COUNT";
static char vlg_szMpeosFeatureRecoverOnDsgInvalidStateError[]= "SYSTEM.RECOVER.ON.INVALID_DSG_STATE.ERROR.COUNT";
static char vlg_szMpeosFeatureRebootOnMissingDcdCount[]      = "SYSTEM.REBOOT.ON.MISSING.DCD.ERROR.COUNT";

#define HAL_SUCCESS 0

#include "dsg_api.h"

#include "ip_types.h"
#include "dsg_types.h"
#include "vl_dsg_service.h"
#include "utilityMacros.h"
#include "bufParseUtilities.h"
#include "traceStack.h"
#include "vl_dsg_init.h"
#include "hal_module.h"
#include "utilityMacros.h"

#include "rdk_debug.h"
#include "rmf_osal_thread.h"
#include "rmf_osal_mem.h"
#include "rmf_osal_types.h"
#include "rmf_osal_util.h"

static VL_TLV_217_IP_MODE vlg_eTlvIpMode = VL_TLV_217_IP_MODE_IPV4;

#undef LOGINFO
#define LOGINFO(module, format, args...)   RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", #module " : " format, args)
#define LOGDEBUG(module, format, args...)  RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", #module " : " format, args)
#define LOGERROR(module, format, args...)  RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", #module " : " format, args)
//DECLARE_LOG_APPTYPE (LOG_APPTYPE_OCAP_PLUGINS_APPS_HALDSG)

/* Feb-04-2009: Commented... using InitializeDsgCcApplication() instead.
typedef void * (*start_routine) (void *arg);
void EstbDsgRemoteInterfaceHelperThread ( void );
int StartMyThread( char *name, int *taskId, void * (*start_routine)(void *) );
*/

#ifdef __cplusplus
extern "C" {
#endif
void HAL_SYS_Reboot(const char * pszRequestor, const char * pszReason);
void POD_Api_Lost_Flow_Ind(unsigned long id,/* flow id*/
                           unsigned char status); /* flow lost reason*/
void POD_Api_Send_DSG_Message(void *dsg_message_ptr, /* [in] DSG message data pointer */
                              unsigned short dsg_message_len  /* [in] DSG message data length */ );

unsigned char BcmSendDataToPOD( unsigned char *pBufData, /* [in] DSG data */
                                unsigned int pktlen, /* [in] length of DSG data */
                                unsigned long flow_id /* [in] flow id of DSG flow */ );

unsigned char BcmSendDSGTunnelDataToPOD( unsigned char *pBufData, /* [in] DSG data */
                                         unsigned int pktlen, /* [in] length of DSG data */
                                         unsigned long flow_id /* [in] flow id of DSG flow */ );

unsigned char BcmSendDSGTunnelDataToHost( unsigned char *pBufData, /* [in] DSG data */
                                          unsigned int pktlen, /* [in] length of DSG data */
                                          unsigned long client_type,/* [in] DSG client type */
                                          unsigned long client_id);/* [in] DSG client ID */
void POD_Api_Send_DCD_Info(void *dcd_ptr, /* [in] DCD data pointer */
                           unsigned short dcd_len  /* [in] DCD data length */ );

// For cablecard IP_U flow that needs an IP address by using DHCP client in the eCM
int DsgStartProxyDhcpRequest( unsigned char opt_len, unsigned char *mac, unsigned char *opt_data, unsigned char *ret_option );
int DsgShutDownProxyIpuStack( void );
int DsgSendCableCardIpUsData( unsigned char *pData, unsigned short len );

int InitializeDsgCcApplication(void);

void DsgEcmMacReinit();
void DsgEcmMacReinitEvent();
void DsgUpstreamChange( DsgEcmUsSettings *pDsgEcmUsSettings );
int SetupRemoteInterface(char *ifName);
#ifdef USE_SOC_SIGNAL_MASK
void SetSignalMask(void);
#endif
#ifdef __cplusplus
}
#endif


void ProcessEcmNotifications(char * buf);
// Set up the sock interface for the test thread
bool JoinMulticastSession( int socketDescriptor );

void ConfigureEcmInterface(void);
void SetMulticastInterface(void);
void PrintNewEstbPrimaryIpAddress( void );
// For cablecard IP_U flow that needs an IP address by using DHCP client in the eCM
int DsgStartProxyDhcpRequest( unsigned char opt_len, unsigned char *mac, unsigned char *opt_data, unsigned char *ret_option );
int DsgShutDownProxyIpuStack( void );
int DsgSendCableCardIpUsData( unsigned char *pData, unsigned short len );

void vlBcmDsgScan(DSG_t *pstDSG);
#if 1//def USE_SAM_MFR /* DEBUG_DSG_MAC_REINIT */
void vlBcmDsgScanOnMACReinit();
#endif // USE_SAM_MFR /* DEBUG_DSG_MAC_REINIT */
void vlBcmDsgSetDsgMode(DSG_t *pstDSG);
void vlBcmDsgSetDirectory(DSG_t *pstDSG, VL_DSG_DIRECTORY * pDirectory, int bProcessTunnels);
void vlBcmDsgSetAdvConfig(DSG_t *pstDSG);
void vlBcmPrintDsgStatus(VL_DSG_STATUS * pDsgStatus);
VL_DSG_ECM_STATUS vlBcmIsEcmOperational();
void vlBcmAttemptIpRecovery();
int vlBcmDsgDeallocateTunnel(unsigned long hBcmTunnelHandle);
static int vlBcmDsgOpenTunnel(DSG_t *pstDSG,
                       const VL_MAC_ADDRESS macAddress,
                       VL_DSG_CLIENT_ID_ENC_TYPE eClientType,
                       unsigned long eClientId,
                       VL_DSG_TUNNEL_FILTER * pTunnelFilter,
                       VL_ADSG_FILTER * pAdsgFilter);
int vlBcmDsgSetDhcpOption43(void *data, int dataLen);
int vlBcmDsgSetDhcpOption17(void *data, int dataLen);

void vldsg_getDsgEcmName(char *name);

void vlForwardDsgMessageToStack(int message, unsigned char u8data);
//void cSleep(long);

static unsigned char vlg_dsgMsgBuffer[32];
static int vlg_nCurDcdVersion = VL_DSG_INVALID_DCD_VERSION;
static int vlg_bRebootOnMissingDcdCount = 0;
static int vlg_nMissingDcdCount = 0;
static int vlg_nTotalDcdCount = 0;
static DSG_t * vlg_pstDSG = NULL;

#define VL_BCM_DSG_MAX_TUNNELS      0x40
#define VL_BCM_DSG_MAX_CLASSIFIERS  0x40
#define VL_BCM_DSG_INVALID_TUNNEL_HANDLE    0 // As per documentation 0 will never be returned (on success) by BCM DSG API.
static uint32            vlg_aTunnels[VL_BCM_DSG_MAX_TUNNELS];
static VL_MAC_ADDRESS vlg_aTunnelMacs[VL_BCM_DSG_MAX_TUNNELS];
static int    vlg_nClassifiers = 0;
static t_dsg_classifier vlg_bcm_dsg_classifiers[VL_BCM_DSG_MAX_CLASSIFIERS];
static unsigned char vlg_IPUmacAddress[VL_MAC_ADDR_SIZE];
static unsigned long vlg_nDcdDeliveryTag = VL_XCHAN_HOST2POD_SEND_DCD_INFO;
unsigned char  vlg_abufRxFrequency[VL_MAX_DSG_ENTRIES*sizeof(long)];
static int vlg_bReceivedDhcpResponse = 0;
static int vlg_bReceivedDsgDCDresponse = 0;
static int vlg_bReceivedDsgInvalidDCD = 0;
static struct stat vl_tlv_217_stat;
static char vlg_dsgEcmName[10];
static int vlg_cdl_reboot_suppressed_on_ecm_reset = FALSE;
static int vlg_dsg_reboot_suppressed_for_ip_recovery = FALSE;
static unsigned char * vlg_pDhcpV4Bytes=NULL;
static int vlg_nDhcpV4Bytes=0;
static unsigned char * vlg_pDhcpV6Bytes=NULL;
static int vlg_nDhcpV6Bytes=0;

#define VL_DSG_TLV217_POLL_DURATION     10
#define VL_DSG_TLV217_POLL_INVERVAL     1
#define VL_DSG_TLV217_POLL_COUNT        ((VL_DSG_TLV217_POLL_DURATION)/(VL_DSG_TLV217_POLL_INVERVAL))

#define VL_DSG_SLEEP_RESOLUTION         1000

void vldsg_getDsgEcmName(char *name)
{
        const char *dsgecmname = NULL;
        dsgecmname = rmf_osal_envGet("VL_WAN_IF_NAME");
        if (dsgecmname != NULL)
        {
            strncpy(name,dsgecmname,sizeof(vlg_dsgEcmName));
        }
        else
        {
            LOGERROR(HAL_MODULE_DSG,"%s(): VL_WAN_IF_NAME is NULL! \n", __FUNCTION__);
        }
        LOGDEBUG(HAL_MODULE_DSG,"%s(): vlg_dsgEcmName = %s \n", __FUNCTION__,vlg_dsgEcmName);
        return;
}

extern "C" void BcmEstbIndicateCableCardProxyDhcpResponse( unsigned long ccIpAddr, char * pDhcpResponse, unsigned char optionlen )
{
    VL_DSG_IP_UNICAST_FLOW_PARAMS dsgFlowParams;
    VL_ZERO_STRUCT(dsgFlowParams);
    //DsgPrint("DSG: BcmEstbIndicateCableCardProxyDhcpResponse: ipAddress = 0x%08X\n", ccIpAddr);
    LOGINFO(HAL_MODULE_DSG,"%s(): ipAddress = 0x%08lX\n", __FUNCTION__,ccIpAddr);

    vlg_bReceivedDhcpResponse = 1;
    dsgFlowParams.flowType = VL_XCHAN_FLOW_TYPE_IP_U;
    memcpy(dsgFlowParams.macAddress, vlg_IPUmacAddress, sizeof(dsgFlowParams.macAddress));
    dsgFlowParams.ipAddress[0] = ((ccIpAddr>> 24) & 0xff);
    dsgFlowParams.ipAddress[1] = ((ccIpAddr>> 16) & 0xff);
    dsgFlowParams.ipAddress[2] = ((ccIpAddr>>  8) & 0xff);
    dsgFlowParams.ipAddress[3] = ((ccIpAddr>>  0) & 0xff);
    dsgFlowParams.nOptionBytes = optionlen;
    dsgFlowParams.pOptionBytes = (unsigned char*)pDhcpResponse;
    DsgAsyncDataCallback(0, VL_XCHAN_POD2HOST_NEW_FLOW_CNF, VL_XCHAN_FLOW_TYPE_IP_U, (unsigned char*)&dsgFlowParams);
}

//
// DS IPU data pkt from eCM proxy Ip stack
//
extern "C" void BcmSendDsDataToCableCard( int data_len, unsigned char *pDataStart )
{
    //DsgPrint("DSG: BcmSendDsDataToCableCard: data_len = %d\n", data_len);
    VL_DSG_IP_FLOW_PACKET ipPacket;
    ipPacket.flowid  = 0;
    ipPacket.nLength = data_len;
    ipPacket.pData   = pDataStart;
    DsgAsyncDataCallback(0, VL_DSG_PVT_TAG_IPU_PKT_ECM_TO_CARD, VL_XCHAN_FLOW_TYPE_IP_U, (unsigned char*)&ipPacket);
}

extern "C" void BcmIndicateEcmReset( void )
{
    const char* envVar;
    rmf_osal_Bool bMpeosFeatureEcmToHostRebootSignal = FALSE;

    if(vlg_cdl_reboot_suppressed_on_ecm_reset)
    {
      LOGINFO(HAL_MODULE_DSG,"%s(): Received reboot indication from ECM... \n", __FUNCTION__);
      LOGINFO(HAL_MODULE_DSG,"%s(): ...Skipping eSTB reboot as CDL is in progress. \n", __FUNCTION__);
    }
   
    /* Try to get logging option. */
    envVar = rmf_osal_envGet(vlg_szMpeosFeatureEcmToHostRebootSignal);
    if (NULL != envVar)
    {
        bMpeosFeatureEcmToHostRebootSignal = (strcasecmp(envVar, "TRUE") == 0);
    }
 
    if((bMpeosFeatureEcmToHostRebootSignal) && (!vlg_cdl_reboot_suppressed_on_ecm_reset) && (!vlg_dsg_reboot_suppressed_for_ip_recovery))
    {
        LOGINFO(HAL_MODULE_DSG,"%s(): Received reboot indication from ECM. Rebooting STB... \n \n \n", __FUNCTION__);
        // Jun-04-2012 : BPV-958 : Changed to reboot(RB_AUTOBOOT) for more reliable reboot.
        // XONE-3545: Added new API to handle reboot
        HAL_SYS_Reboot(__FUNCTION__, "eCM reboot indication.");
    }
    else
    {
        vlForwardDsgMessageToStack(VL_DSG_MESSAGE_TYPE_ECM_RESET, 0);
        // Feb-11-2009: Workaround for TC165.1: re-establish 2-way after reset: force DCD to be redelivered in order to re-establish 2-way communications.
        vlg_bReceivedDsgDCDresponse = 1;
        vlg_nCurDcdVersion = VL_DSG_INVALID_DCD_VERSION;
    }
    
    // reset recovery flag indicator.
    vlg_dsg_reboot_suppressed_for_ip_recovery = FALSE;
}

void vl_dsg_ipu_dhcp_timeout_thread(void * arg)
{
    //cSleep(VL_DSG_IPU_DHCP_TIMEOUT*VL_DSG_SLEEP_RESOLUTION);
    rmf_osal_threadSleep(VL_DSG_IPU_DHCP_TIMEOUT*VL_DSG_SLEEP_RESOLUTION, 0);
    if(0 == vlg_bReceivedDhcpResponse)
    {
        DsgAsyncDataCallback(0, VL_DSG_PVT_TAG_IPU_DHCP_TIMEOUT, VL_XCHAN_FLOW_TYPE_IP_U, NULL);
    }
}

void vlBcmDsgRequestDhcpFromECM(VL_DSG_IP_UNICAST_FLOW_PARAMS * pUnicastFlowParams)
{
    switch(pUnicastFlowParams->flowType)
    {
        case VL_XCHAN_FLOW_TYPE_IP_U:
        {
    	    rmf_Error err;
            rmf_osal_ThreadId threadid = 0;
            //void * arg = NULL;
            vlg_bReceivedDhcpResponse = 0;
            memcpy(vlg_IPUmacAddress, pUnicastFlowParams->macAddress, sizeof(vlg_IPUmacAddress));
            DsgStartProxyDhcpRequest(pUnicastFlowParams->nOptionBytes,
                                     pUnicastFlowParams->macAddress,
                                     pUnicastFlowParams->pOptionBytes,
                                     NULL);
            //threadid = cThreadCreateSimple("vl_dsg_ipu_dhcp_timeout_thread", vl_dsg_ipu_dhcp_timeout_thread, arg);
            err = rmf_osal_threadCreate(vl_dsg_ipu_dhcp_timeout_thread, NULL,
                        250, 4096, &threadid,
                        "vl_dsg_ipu_dhcp_timeout_thread");

	    if ( RMF_SUCCESS != err)
	    {
		    RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Failed to create PODReset thread\n",__FUNCTION__);
	    }

        }
        break;
    }
}

VL_XCHAN_FLOW_RESULT vlBcmDsgRequestMulticastFromECM(VL_XCHAN_IP_MULTICAST_FLOW_PARAMS * pMulticastFlowParams)
{
    // Aug-25-2008: Moved generic implementation to PFC
    return VL_XCHAN_FLOW_RESULT_GRANTED;
}

VL_XCHAN_FLOW_RESULT vlBcmDsgCancelMulticastFromECM(VL_XCHAN_IP_MULTICAST_FLOW_PARAMS * pMulticastFlowParams)
{
    // Aug-25-2008: Moved generic implementation to PFC
    return VL_XCHAN_FLOW_RESULT_GRANTED;
}

int vlDsgSetConfig(DSG_t   *pstDSG, unsigned long ulTag, void* pvConfig)
{
    vlg_pstDSG = pstDSG;

    switch(ulTag)
    {
        case VL_DSG_PVT_TAG_GET_DSG_STATUS:
        {
            VL_DSG_STATUS * pDsgStatus = ((VL_DSG_STATUS*)pvConfig);
            vlBcmPrintDsgStatus(pDsgStatus);
        }
        break;

        case VL_HOST2POD_SEND_DCD_INFO:
        case VL_XCHAN_HOST2POD_SEND_DCD_INFO:
        {
            pstDSG->dsgDCD      =  *((VL_DSG_DCD*)pvConfig);
        }
        break;

        case VL_POD2HOST_SET_DSG_MODE:
        {
            pstDSG->dsgMode      =  *((VL_DSG_MODE*)pvConfig);
            vlg_nDcdDeliveryTag = VL_HOST2POD_SEND_DCD_INFO;
            vlBcmDsgSetDsgMode(pstDSG);
        }
        break;

        case VL_XCHAN_POD2HOST_SET_DSG_MODE:
        {
            pstDSG->dsgMode      =  *((VL_DSG_MODE*)pvConfig);
            vlg_nDcdDeliveryTag = VL_XCHAN_HOST2POD_SEND_DCD_INFO;
            vlBcmDsgSetDsgMode(pstDSG);
        }
        break;

        case VL_POD2HOST_DSG_ERROR:
        case VL_XCHAN_POD2HOST_DSG_ERROR:
        {
            VL_DSG_ERROR_STATUS eErrorStatus = ((VL_DSG_ERROR*)pvConfig)->eErrorStatus;
            
            DsgReportDsgError(eErrorStatus);

            if(VL_DSG_ERROR_STATUS_INVALID_DSG_CHANNEL == eErrorStatus)
            {
                vlg_bReceivedDsgDCDresponse = 1;
                vlg_bReceivedDsgInvalidDCD  = 1;
                vlBcmDsgScan(pstDSG);
            }
        }
        break;

        case VL_POD2HOST_DSG_DIRECTORY:
        {
            vlBcmDsgSetDirectory(pstDSG, (VL_DSG_DIRECTORY*)pvConfig, 1);
        }
        break;

        case VL_XCHAN_POD2HOST_CONFIG_ADV_DSG:
        {
            pstDSG->dsgAdvConfig =  *((VL_DSG_ADV_CONFIG*)pvConfig);
            vlBcmDsgSetAdvConfig(pstDSG);
        }
        break;

        case VL_XCHAN_POD2HOST_NEW_FLOW_REQ:
        {
            VL_DSG_IP_UNICAST_FLOW_PARAMS dsgUnicastFlowParams = *((VL_DSG_IP_UNICAST_FLOW_PARAMS*)pvConfig);
/*            DsgPrint("DSG: vlDsgSetConfig: received VL_XCHAN_POD2HOST_NEW_FLOW_REQ flow_type = %d\n", dsgUnicastFlowParams.flowType);*/
    		LOGINFO(HAL_MODULE_DSG,"%s():received VL_XCHAN_POD2HOST_NEW_FLOW_REQ flow_type = %lu\n", __FUNCTION__,dsgUnicastFlowParams.flowType);

            vlBcmDsgRequestDhcpFromECM(&dsgUnicastFlowParams);
        }
        break;

        case VL_DSG_PVT_TAG_IPU_PKT_CARD_TO_ECM:
        {
            VL_DSG_IP_FLOW_PACKET * pIpPacket = ((VL_DSG_IP_FLOW_PACKET*)pvConfig);
            //DsgPrint("DSG: vlDsgSetConfig: received VL_POD2ECM_DSG_IPU_FLOW flowid = 0x%06X\n", ipPacket.flowid);
            if(kFuncFail == DsgSendCableCardIpUsData(pIpPacket->pData, pIpPacket->nLength))
            {
                return -1;
            }
        }
        break;

        case VL_DSG_PVT_TAG_DSG_CLEAN_UP:
        {
            DsgShutDownProxyIpuStack();
        }
        break;

        case VL_DSG_PVT_TAG_POD_REMOVED:
        {
            DsgShutDownProxyIpuStack();
        }
        break;

        case VL_DSG_PVT_TAG_IP_MULTICAST_FLOW:
        {
            VL_XCHAN_IP_MULTICAST_FLOW_PARAMS * pDsgMulticastFlowParams = ((VL_XCHAN_IP_MULTICAST_FLOW_PARAMS*)pvConfig);
            //DsgPrint("DSG: vlDsgSetConfig: received VL_DSG_PVT_TAG_IP_MULTICAST_FLOW\n");
    		LOGINFO(HAL_MODULE_DSG,"%s():received VL_DSG_PVT_TAG_IP_MULTICAST_FLOW\n", __FUNCTION__);
            return vlBcmDsgRequestMulticastFromECM(pDsgMulticastFlowParams);
        }
        break;

        case VL_DSG_PVT_TAG_IP_CANCEL_MULTICAST_FLOW:
        {
            VL_XCHAN_IP_MULTICAST_FLOW_PARAMS * pDsgMulticastFlowParams = ((VL_XCHAN_IP_MULTICAST_FLOW_PARAMS*)pvConfig);
            LOGINFO(HAL_MODULE_DSG,"%s():received VL_DSG_PVT_TAG_IP_CANCEL_MULTICAST_FLOW\n", __FUNCTION__);
            return vlBcmDsgCancelMulticastFromECM(pDsgMulticastFlowParams);
        }
        break;

        case VL_DSG_PVT_TAG_DSG_GET_IP_INFO:
        {
            VL_HOST_IP_INFO * pIpInfo = (VL_HOST_IP_INFO*)pvConfig;
            vldsg_getDsgEcmName(vlg_dsgEcmName);
            if((NULL != pIpInfo) && (NULL != vlg_dsgEcmName))
            {
                memset(pIpInfo, 0, sizeof(VL_HOST_IP_INFO));
                strncpy(pIpInfo->szIfName, vlg_dsgEcmName, sizeof(pIpInfo->szIfName));
            }
        }
        break;
        
        case VL_DSG_PVT_TAG_SET_HOST_IP_MODE:
        {
            vlg_eTlvIpMode = *((VL_TLV_217_IP_MODE *)pvConfig);
            LOGINFO(HAL_MODULE_DSG,"%s():Received Event VL_DSG_PVT_TAG_SET_HOST_IP_MODE, TLV_IP_MODE=%d \n", __FUNCTION__, vlg_eTlvIpMode);
            
            switch(vlg_eTlvIpMode)
            {
                case VL_TLV_217_IP_MODE_IPV4:
                {
                    //system("sh ../bin/scripts/stop_dhcp_v4.sh");
                    //system("sh ../bin/scripts/start_dhcp_v4.sh");
                    //system("sh ../bin/scripts/stop_dhcp_v6.sh");
                }
                break;
                
                case VL_TLV_217_IP_MODE_IPV6:
                {
                    //system("sh ../bin/scripts/stop_dhcp_v6.sh");
                    //system("sh ../bin/scripts/start_dhcp_v6.sh");
                    //system("sh ../bin/scripts/stop_dhcp_v4.sh");
                }
                break;
                
                default:
                {
                    LOGINFO(HAL_MODULE_DSG,"%s(): VL_DSG_PVT_TAG_SET_HOST_IP_MODE: Received Mode %d: No Impl. for this mode.\n", __FUNCTION__, vlg_eTlvIpMode);
                }
                break;
            }
            break;
        }
        break;
        
        case VL_DSG_PVT_TAG_GET_DIR_MOD_CAPS:
        {
            // This HAL supports DIRECTORY modifications
            LOGINFO(HAL_MODULE_DSG,"%s(): VL_DSG_PVT_TAG_GET_DIR_MOD_CAPS: DSG HAL supports DSG directory modifications.\n", __FUNCTION__);
            return VL_DSG_RESULT_HAL_SUPPORTS;
        }
        break;
        
        case VL_DSG_PVT_TAG_SET_DIR_CONFIG:
        {
            vlBcmDsgSetDirectory(pstDSG, (VL_DSG_DIRECTORY*)pvConfig, 0);
        }
        break;

        case VL_DSG_PVT_TAG_REMOVE_HOST_TUNNEL:
        {
            VL_DSG_HOST_ENTRY * pEntry = ((VL_DSG_HOST_ENTRY*)pvConfig);
            vlBcmDsgDeallocateTunnel(pEntry->adsgFilter.hTunnelHandle);
        }
        break;

        case VL_DSG_PVT_TAG_REMOVE_CARD_TUNNEL:
        {
            VL_DSG_CARD_ENTRY * pEntry = ((VL_DSG_CARD_ENTRY*)pvConfig);
            vlBcmDsgDeallocateTunnel(pEntry->adsgFilter.hTunnelHandle);
        }
        break;

        case VL_DSG_PVT_TAG_ADD_HOST_TUNNEL:
        {
            VL_DSG_HOST_ENTRY * pEntry = ((VL_DSG_HOST_ENTRY*)pvConfig);
            vlBcmDsgOpenTunnel(pstDSG, pEntry->adsgFilter.macAddress,
                               (VL_DSG_CLIENT_ID_ENC_TYPE)pEntry->clientId.eEncodingType,
                               pEntry->clientId.nEncodedId,
                               NULL, &(pEntry->adsgFilter));
        }
        break;

        case VL_DSG_PVT_TAG_ADD_CARD_TUNNEL:
        {
            VL_DSG_CARD_ENTRY * pEntry = ((VL_DSG_CARD_ENTRY*)pvConfig);
            vlBcmDsgOpenTunnel(pstDSG, pEntry->adsgFilter.macAddress,
                               (VL_DSG_CLIENT_ID_ENC_TYPE)0, 0,
                               NULL, &(pEntry->adsgFilter));
        }
        break;

        case VL_DSG_PVT_TAG_UPDATE_DIR_CONFIG:
        {
            pstDSG->dsgDirectory =  *((VL_DSG_DIRECTORY*)pvConfig);
        }
        break;

        case VL_DSG_PVT_TAG_GET_IP_RECOVERY_CAPS:
        {
            // This HAL supports IP recovery
            LOGINFO(HAL_MODULE_DSG,"%s(): VL_DSG_PVT_TAG_GET_IP_RECOVERY_CAPS: DSG HAL supports IP recovery.\n", __FUNCTION__);
            return VL_DSG_RESULT_HAL_SUPPORTS;
        }
        break;
        
        case VL_DSG_PVT_TAG_GET_IS_ECM_OPERATIONAL:
        {
            return vlBcmIsEcmOperational();
        }
        break;
        
        case VL_DSG_PVT_TAG_SET_ATTEMPT_IP_RECOVERY:
        {
            vlBcmAttemptIpRecovery();
        }
        break;
        
        case VL_DSG_PVT_TAG_ECM_UPDATE_DHCP_OPTION_43:
        {
            VL_DSG_ECM_DHCP_OPTION_43 * pStruct = ((VL_DSG_ECM_DHCP_OPTION_43*)pvConfig);
            //vlg_pDhcpV4Bytes = (unsigned char*)vlMalloc(pStruct->nBytes);
            rmf_osal_memAllocP(RMF_OSAL_MEM_POD, pStruct->nBytes, (void**)&vlg_pDhcpV4Bytes);
            if(NULL != vlg_pDhcpV4Bytes)
            {
                memcpy(vlg_pDhcpV4Bytes, pStruct->pBytes, pStruct->nBytes);
                vlg_nDhcpV4Bytes = pStruct->nBytes;
            }

            vlBcmDsgSetDhcpOption43(vlg_pDhcpV4Bytes, vlg_nDhcpV4Bytes);
        }
        break;

        case VL_DSG_PVT_TAG_ECM_UPDATE_DHCP_OPTION_17:
        {
            VL_DSG_ECM_DHCP_OPTION_17 * pStruct = ((VL_DSG_ECM_DHCP_OPTION_17*)pvConfig);
            //vlg_pDhcpV6Bytes = (unsigned char*)vlMalloc(pStruct->nBytes);
            rmf_osal_memAllocP(RMF_OSAL_MEM_POD, pStruct->nBytes, (void**)&vlg_pDhcpV6Bytes);
            if(NULL != vlg_pDhcpV6Bytes)
            {
                memcpy(vlg_pDhcpV6Bytes, pStruct->pBytes, pStruct->nBytes);
                vlg_nDhcpV6Bytes = pStruct->nBytes;
            }

            vlBcmDsgSetDhcpOption17(vlg_pDhcpV6Bytes, vlg_nDhcpV6Bytes);
        }

        break;

        case VL_DSG_PVT_TAG_ESAFE_DHCP_STATUS:
        {
            VL_DSG_ESAFE_DHCP_STATUS * pStruct = (VL_DSG_ESAFE_DHCP_STATUS*)pvConfig;
            if(NULL != pStruct)
            {
                LOGINFO(HAL_MODULE_DSG,"%s(): VL_DSG_PVT_TAG_ESAFE_DHCP_STATUS: Updating eSAFE progress: Progress: %d, Failure Found: %d, Event Id: %d.\n", __FUNCTION__,
                                    pStruct->eProgress, pStruct->eFailureFound, pStruct->nEventId);
                SetEsafeProvisioningStatus(pStruct->eProgress,
                                           pStruct->eFailureFound,
                                           pStruct->nEventId);
            }
        }
        break;
        
        case VL_DSG_PVT_TAG_ESAFE_IP_ADDRESS:
        {
            VL_HOST_IP_INFO * pStruct = (VL_HOST_IP_INFO*)pvConfig;
            if(NULL != pStruct)
            {
		if(VL_XCHAN_IP_ADDRESS_TYPE_IPV6 == pStruct->ipAddressType)
		{
			LOGINFO(HAL_MODULE_DSG,"%s(): VL_DSG_PVT_TAG_ESAFE_IP_ADDRESS: Updating eSAFE IPv6 Address: %s, MAC: %s.\n", __FUNCTION__,
					pStruct->szIpV6GlobalAddress, pStruct->szMacAddress);
			DsgSetEstbPrimaryIpV6Addr(pStruct->aBytIpV6GlobalAddress, pStruct->aBytMacAddress);
		}
		else
		{
			LOGINFO(HAL_MODULE_DSG,"%s(): VL_DSG_PVT_TAG_ESAFE_IP_ADDRESS: Updating eSAFE IPv4 Address: %s, MAC: %s.\n", __FUNCTION__,
					pStruct->szIpAddress, pStruct->szMacAddress);
			unsigned int ipAddress = (pStruct->aBytIpAddress[3]<<24)|(pStruct->aBytIpAddress[2]<<16)|(pStruct->aBytIpAddress[1]<<8)|(pStruct->aBytIpAddress[0]<<0);
			DsgSetEstbPrimaryIpV4Addr(ipAddress, pStruct->aBytMacAddress);
		}
            }
        }
        break;
        
        default:
        {
            LOGINFO(HAL_MODULE_DSG,"%s():Received Event 0x%08X: No Impl. for this event.\n", __FUNCTION__, ulTag);
        }
        break;
    }

    return HAL_SUCCESS;
}

void vlForwardDsgMessageToStack(int message, unsigned char u8data)
{
    VL_BYTE_STREAM_ARRAY_INST(vlg_dsgMsgBuffer, WriteBuf);
    int nTagLen = 0, nLenLen = 0, nDatLen = 0;
    int nLength = 1;

    nTagLen += vlWrite3ByteLong(pWriteBuf, VL_HOST2POD_DSG_MESSAGE);

    if((VL_DSG_MESSAGE_TYPE_2_WAY_OK                      == message) ||
        (VL_DSG_MESSAGE_TYPE_DYNAMIC_CHANNEL_CHANGE       == message) ||
        (VL_DSG_MESSAGE_TYPE_CANNOT_FORWARD_2_WAY         == message) )
    {
        nLength += 1;
    }

    nLenLen += vlWriteCcApduLengthField(pWriteBuf, nLength);
    nDatLen += vlWriteByte(pWriteBuf, message);

    if(nLength > 1)
    {
        nDatLen += vlWriteByte(pWriteBuf, u8data);
    }

    DsgControlCallback(0, vlg_dsgMsgBuffer, (nTagLen + nLenLen + nDatLen));

    // MAR-01-2012: Patch for BPV-359
    if(VL_DSG_MESSAGE_TYPE_2_WAY_OK != message)
    {
        // Invalidate current DCD to prepare for re-establishment of connectivity.
        vlg_bReceivedDsgDCDresponse = 1;
        vlg_nCurDcdVersion = VL_DSG_INVALID_DCD_VERSION;
    }

}

/***************************************************************************
Summary:
    This function is called by DOCSIS app when the received DSG tunnel data
    which is terminated at POD to pass to POD.

Description:
    The DSG data shall be sent to POD via the DSG flow on extended channel.
    IMPORTANT!!! this data MUST contain 2 bytes of length in the first 2
    bytes!!!

Returns:
    0: success
    <>0: failure.

See Also:


****************************************************************************/
unsigned char BcmSendDSGTunnelDataToPOD( unsigned char *pBufData, /* [in] DSG data */
                                         unsigned int pktlen, /* [in] length of DSG data */
                                         unsigned long flow_id /* [in] flow id of DSG flow */ )
{
    // Commented: June-09-2008: No Implementation here
/*    DsgTunnelCallback(0, pBufData, pktlen);*/
  //  DsgPrint("DSG: Received BcmSendDSGTunnelDataToPOD() len = %d\n", pktlen);
 LOGINFO(HAL_MODULE_DSG,"%s():DSG: Received BcmSendDSGTunnelDataToPOD() len = %u flow_id %lu pBufData %s \n", __FUNCTION__,pktlen, flow_id, pBufData);
    return 0;
}

/***************************************************************************
Summary:
    This function is called by DOCSIS app when the received IP_U or socket data to pass
    to POD.

Description:
    The IPU or socket shall be sent to POD via the DSG flow on extended channel.
    IMPORTANT!!! There is NO 2 bytes preheader.

Returns:
    0: success
    <>0: failure.

See Also:


****************************************************************************/
unsigned char BcmSendDataToPOD( unsigned char *pBufData, /* [in] DSG data */
                                unsigned int pktlen, /* [in] length of DSG data */
                                unsigned long flow_id /* [in] flow id of DSG flow */ )
{
    // Commented: June-09-2008: No Implementation here
/*    DsgTunnelCallback(0, pBufData, pktlen);*/
    //DsgPrint("DSG: Received BcmSendDataToPOD() len = %d\n", pktlen);
LOGINFO(HAL_MODULE_DSG,"%s():DSG: Received BcmSendDataToPOD() len = %d pBufData %s flow_id %lu \n", __FUNCTION__,pktlen, pBufData, flow_id);
    return 0;
}

/***************************************************************************
Summary:
    This function is called by DOCSIS app when the received DSG tunnel which
    is terminated at host..

Description:
    The DSG data shall be sent to host.

Returns:
    0: success
    <>0: failure.

See Also:


****************************************************************************/
unsigned char BcmSendDSGTunnelDataToHost( unsigned char *pBufData, /* [in] DSG data */
                                          unsigned int pktlen, /* [in] length of DSG data */
                                          unsigned long client_type,/* [in] DSG client type */
                                          unsigned long client_id)/* [in] DSG client ID */
{
    //DsgPrint("DSG: Received BcmSendDSGTunnelDataToHost() len = %d\n", pktlen);
    LOGINFO(HAL_MODULE_DSG,"%s():DSG: Received BcmSendDSGTunnelDataToHost() len = %d pBufData %s client_type %lu client_id %lu \n", __FUNCTION__, pktlen, pBufData, client_type, client_id);
    // Commented: June-09-2008: No Implementation here
/*    DsgTunnelCallback(0, pBufData, pktlen);*/
    return 0;
}


/***************************************************************************
Summary:
    This function is called by DOCSIS app to send DCD info to the Card.

Description:
    In the advanced DSG mode, DOCSIS shall scan downstream channels for the DCD message,
    then pass the entire DCD message, except for the MAC management header, to the Card. Upon
    receipt of the DCD message, the Card shall parse the DCD info.

Returns:
    void.

See Also:


****************************************************************************/
void POD_Api_Send_DCD_Info(void *dcd_ptr, /* [in] DCD data pointer */
                           unsigned short dcd_len  /* [in] DCD data length */ )
{
    // Commented: June-09-2008: No Implementation here
/*  VL_BYTE_STREAM_ARRAY_INST(vlg_dsgDcdBuffer, WriteBuf);
    int nTagLen = vlWrite3ByteLong(pWriteBuf, vlg_nDcdDeliveryTag);
    int nLenLen = vlWriteCcApduLengthField(pWriteBuf, dcd_len);
    int nDatLen = vlWriteBuffer(pWriteBuf, dcd_ptr, dcd_len, sizeof(vlg_dsgDcdBuffer) - (nTagLen + nLenLen));
    DsgControlCallback(0, vlg_dsgDcdBuffer, (nTagLen + nLenLen + nDatLen));*/
   // DsgPrint("DSG: Received POD_Api_Send_DCD_Info() len = %d\n", dcd_len);
LOGINFO(HAL_MODULE_DSG,"%s():DSG: Received POD_Api_Send_DCD_Info() len = %d  dcd_ptr %p \n", __FUNCTION__,dcd_len, dcd_ptr);
}


/***************************************************************************
Summary:
    This function is called by DOCSIS app to send DSG message to the Card.

Description:
    In the advanced DSG mode, DOCSIS use dsg_message objects to
    - request appllcation tunnel data stream
    - indicate established 2-way commuication with UCID
    - indicate entered 1 way mode
    - indicate complete downstream scan with result
    - indicate received a DCC-REQ
    - indicate reboot event.
Returns:
    void.

See Also:


****************************************************************************/
void POD_Api_Send_DSG_Message(void *dsg_message_ptr, /* [in] DSG message data pointer */
                              unsigned short dsg_message_len  /* [in] DSG message data length */ )
{
	LOGINFO(HAL_MODULE_DSG,"%s():DSG dsg_message_ptr %p : dsg_message_len %u \n", __FUNCTION__, dsg_message_ptr, dsg_message_len);

    // Commented: June-09-2008: No Implementation here
/*  VL_BYTE_STREAM_ARRAY_INST(vlg_dsgDcdBuffer, WriteBuf);
    int nTagLen = vlWrite3ByteLong(pWriteBuf, VL_HOST2POD_DSG_MESSAGE);
    int nLenLen = vlWriteCcApduLengthField(pWriteBuf, dsg_message_len);
    int nDatLen = vlWriteBuffer(pWriteBuf, dsg_message_ptr, dsg_message_len, sizeof(vlg_dsgDcdBuffer) - (nTagLen + nLenLen));
    DsgControlCallback(0, vlg_dsgDcdBuffer, (nTagLen + nLenLen + nDatLen));*/
  //  DsgPrint("DSG: Received POD_Api_Send_DSG_Message() len = %d\n", dsg_message_len);
 LOGINFO(HAL_MODULE_DSG,"%s():DSG: Received POD_Api_Send_DSG_Message() len = %d\n", __FUNCTION__,dsg_message_len);
}

/***************************************************************************
Summary:
    This function is called by network to notify POD that IP_U or socket
    connection is lost

Description:
    When the IP_U or socket connection is lost, network will notify POD stack.
    And POD will get FLOW_LOST_ID apdu.

Returns:
    void.

See Also:


****************************************************************************/

void POD_Api_Lost_Flow_Ind(unsigned long id,/* flow id*/
                           unsigned char status) /* flow lost reason*/
{
    // Commented: June-09-2008: No Implementation here
    //DsgPrint("DSG: Received POD_Api_Lost_Flow_Ind() id = %d, status = %d\n", id, status);
LOGINFO(HAL_MODULE_DSG,"%s():DSG: Received POD_Api_Lost_Flow_Ind() id = %lu, status = %u\n", __FUNCTION__,id, status);
}

// Dsg Client functions

// The eCM calls this function to notify the eSTB that the eCM has locked on a downstream
// with DSG data. For Basic Mode, this means that the eCM has received traffic on at least one
// of the configured DSG tunnels. For Advanced Mode, this means that the eCM has received a
// DCD message.
//
// Parameters:  N/A
//
// Returns:  N/A
//
void DsgScanSuccess( void )
{
//    DsgPrint("DSG: DsgScanSuccess\n");
    LOGINFO(HAL_MODULE_DSG,"%s():DSG: DsgScanSuccess\n", __FUNCTION__);
}

// The eCM calls this function to notify the eSTB that the eCM has scanned every downstream in
// its spectrum (or channel list) without finding suitable DSG traffic.
//
// Parameters:  N/A
//
// Returns:  N/A
//
void DsgFullScanFail( void )
{
    //DsgPrint("DSG: DsgFullScanFail\n");
    LOGINFO(HAL_MODULE_DSG,"%s():DSG: DsgFullScanFail\n", __FUNCTION__);
  vlForwardDsgMessageToStack(VL_DSG_MESSAGE_TYPE_DOWNSTREAM_SCAN_COMPLETED, 0);
}

#define VL_DSG_DCD_FRAGMENT_SIZE    0x100

typedef struct _VL_DSG_DCD_ACCUMULATOR
{
    unsigned long nTag;
    int nVersion   ;
    int flow_id      ;
    unsigned char * pData;
    int nBufCapacity ;
    int nCurLength   ;

}VL_DSG_DCD_ACCUMULATOR;

static VL_DSG_DCD_ACCUMULATOR vlg_DcdAccumulator        = {VL_HOST2POD_SEND_DCD_INFO, 0, 0, NULL, 0, 0};

//static long vlg_dcd_timeout_threadid = 0;
static rmf_osal_ThreadId vlg_dcd_timeout_threadid = 0;

void vl_dsg_dcd_timeout_thread(void * arg)
{
    //cSleep(30*VL_DSG_SLEEP_RESOLUTION);
    rmf_osal_threadSleep(30*VL_DSG_SLEEP_RESOLUTION,0);
    if(0 == vlg_bReceivedDsgDCDresponse)
    {
        // the card did not respond to DCD, probably it was busy
        // reset the version to force the DCD to be re-sent
        char timestr[100];
        time_t t;
        struct tm *tmp;
        t = time(NULL);
        tmp = localtime(&t);
        memset(timestr, 0, sizeof(timestr));
        strftime(timestr, sizeof(timestr), "%T", tmp);
        LOGINFO(HAL_MODULE_DSG,"%s():DSG: Cable Card did not authorize the DCD, forcing the DCD to be re-sent, time = %s\n", __FUNCTION__, timestr);
        vlg_bReceivedDsgDCDresponse = 1;
        vlg_nCurDcdVersion = VL_DSG_INVALID_DCD_VERSION;
    }

    vlg_dcd_timeout_threadid = 0;
}

static void VL_DSG_Send_FullDCD_To_CardManager(VL_DSG_DCD_ACCUMULATOR * pAccumulator)
{
    int nBufLength = (32+pAccumulator->nCurLength);
    unsigned char * pDsgDcdBuffer = NULL; //vlMalloc(nBufLength);
    rmf_osal_memAllocP(RMF_OSAL_MEM_POD, nBufLength*sizeof(unsigned char), (void**)&pDsgDcdBuffer);

    if(NULL != pDsgDcdBuffer)
    {
        VL_BYTE_STREAM_INST(pDsgDcdBuffer, WriteBuf, pDsgDcdBuffer, nBufLength);
        int nTagLen = vlWrite3ByteLong(pWriteBuf, vlg_nDcdDeliveryTag);
        int nLenLen = 0;
        int nDatLen = 0;

        switch(vlg_nDcdDeliveryTag)
        {
            case VL_HOST2POD_SEND_DCD_INFO:
            {
                nLenLen = vlWriteCcApduLengthField(pWriteBuf, pAccumulator->nCurLength);
                nDatLen = vlWriteBuffer(pWriteBuf, pAccumulator->pData, pAccumulator->nCurLength, VL_BYTE_STREAM_REMAINDER(pWriteBuf));
            }
            break;
    
            case VL_XCHAN_HOST2POD_SEND_DCD_INFO:
            {
                nLenLen = vlWriteCcApduLengthField(pWriteBuf, pAccumulator->nCurLength+3);
                nDatLen += vlWriteByte(pWriteBuf, pAccumulator->nVersion);
                nDatLen += vlWriteByte(pWriteBuf, 1);
                nDatLen += vlWriteByte(pWriteBuf, 1);
                nDatLen += vlWriteBuffer(pWriteBuf, pAccumulator->pData, pAccumulator->nCurLength, VL_BYTE_STREAM_REMAINDER(pWriteBuf));
            }
            break;
        }
        
        //DsgPrint("DSG: VL_DSG_Send_FullDCD_To_CardManager nDataLen = %d\n", nDatLen);
        LOGINFO(HAL_MODULE_DSG,"%s():DSG: VL_DSG_Send_FullDCD_To_CardManager nDataLen = %d\n", __FUNCTION__, nDatLen);
        DsgControlCallback(0, pDsgDcdBuffer, (nTagLen + nLenLen + nDatLen));

        //vlFree(pDsgDcdBuffer);
        rmf_osal_memFreeP(RMF_OSAL_MEM_POD, pDsgDcdBuffer);
    }
    else
    {
        LOGINFO(HAL_MODULE_DSG,"%s():DSG: rmf_osalmemAallocP(%d) Failed !\n", __FUNCTION__, nBufLength);

    }
        
    // make a note that we did not receive a response from the card yet
    vlg_bReceivedDsgDCDresponse = 0;
    if((NULL != vlg_pstDSG) && (0 == vlg_dcd_timeout_threadid))
    {
        switch(vlg_pstDSG->dsgMode.eOperationalMode)
        {
            case VL_DSG_OPERATIONAL_MODE_ADV_TWO_WAY:
            case VL_DSG_OPERATIONAL_MODE_ADV_ONE_WAY:
            {

		    rmf_Error err;
                //vlg_dcd_timeout_threadid = cThreadCreateSimple("vl_dsg_dcd_timeout_thread", vl_dsg_dcd_timeout_thread, NULL);
		    err = rmf_osal_threadCreate(vl_dsg_dcd_timeout_thread, NULL,
				    250, 4096, &vlg_dcd_timeout_threadid,
				    "vl_dsg_dcd_timeout_thread");

		    if ( RMF_SUCCESS != err)
		    {
			    RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Failed to create PODReset thread\n",__FUNCTION__);
		    }
            }
            break;

            default:
            {
            }
            break;
        }
    }
}

static int VL_DSG_Send_DCD_Fragment(VL_DSG_DCD_ACCUMULATOR * pAccumulator,
                                     int nOldVersion, int nNewVersion,
                                     int nFragments, int iFragment,
                                     int msg_len, uint8 * pData)
{
    if (1 == iFragment)
    {
        // reset accumulator
        pAccumulator->nCurLength = 0;
        pAccumulator->nVersion   = nNewVersion;
    }

    // do we have enough capacity ?
    while((pAccumulator->nCurLength + msg_len) > (pAccumulator->nBufCapacity))
    {
        // allocate more capacity
        unsigned char * pNewData = NULL;//vlMalloc(pAccumulator->nBufCapacity+VL_DSG_DCD_FRAGMENT_SIZE);

        rmf_osal_memAllocP(RMF_OSAL_MEM_POD, (pAccumulator->nBufCapacity+VL_DSG_DCD_FRAGMENT_SIZE)*sizeof(unsigned char), (void**)&pNewData);
        // check for NULL
        if((NULL != pNewData) && (NULL != pAccumulator->pData))
        {
            // copy data accumulated so far
            rmf_osal_memcpy(pNewData, pAccumulator->pData, pAccumulator->nCurLength, (pAccumulator->nBufCapacity+VL_DSG_DCD_FRAGMENT_SIZE), pAccumulator->nCurLength );
            // free old buffer
            //vlFree(pAccumulator->pData);
            rmf_osal_memFreeP(RMF_OSAL_MEM_POD, pAccumulator->pData);
        }
        else if(NULL == pNewData)
        {
            pAccumulator->nCurLength = 0;
            return nOldVersion;
        }

        // switch to new buffer
        pAccumulator->pData = pNewData;
        // register new capacity
        pAccumulator->nBufCapacity += VL_DSG_DCD_FRAGMENT_SIZE;
    }

    // null check
    if(NULL != pAccumulator->pData)
    {
        // null check
        if((NULL != pData) && (msg_len > 0))
        {
            // accumulate fragment data
            rmf_osal_memcpy(pAccumulator->pData + pAccumulator->nCurLength, pData, msg_len,
	            (pAccumulator->nBufCapacity - pAccumulator->nCurLength), msg_len );
            // accumulate fragment length
            pAccumulator->nCurLength   += msg_len;
        }

        // check if last fragment
        if (iFragment == nFragments)
        {
            // send accumulated data to stack
            VL_DSG_Send_FullDCD_To_CardManager(pAccumulator);
            // reset accumulator
            pAccumulator->nCurLength = 0;
            return nNewVersion;
        }
    }

    return nOldVersion;
}

// This method will send DCD msg encapsulated with UDP packet to MA via Halif interface.
// Will wait for packet sent completion
//
// Parameters:
//      pData is the Dcd Mac msg pointer including the header
//      msg_len is the entire mac msg length
//
// Returns:
//     n/a
//
void DsgRxDCD( int msg_len, uint8 * pData )
{
    int nNewDcdVersion = pData[0];
    int nFragments     = pData[1];
    int iFragment      = pData[2];
    pData += 3; msg_len -= 3;

    if(nNewDcdVersion != vlg_nCurDcdVersion)
    {
/*        DsgPrint("DSG: DsgRxDCD ver = %d, nFrags = %d, iFrag = %d, msg_len = %d\n",
                            nNewDcdVersion, nFragments, iFragment, msg_len);*/
    LOGINFO(HAL_MODULE_DSG,"%s():DSG: DsgRxDCD ver = %d, nFrags = %d, iFrag = %d, msg_len = %d\n", __FUNCTION__,nNewDcdVersion, nFragments, iFragment, msg_len);

        vlg_nCurDcdVersion = VL_DSG_Send_DCD_Fragment(&vlg_DcdAccumulator,
                                        vlg_nCurDcdVersion, nNewDcdVersion,
                                        nFragments, iFragment,
                                        msg_len, pData);
    }
    
    vlg_nMissingDcdCount = 0;
    vlg_nTotalDcdCount++;
}

#if 1
// The eCM will call this function to notify the eSTB when DOCSIS registration is complete 
// (upstream_state = true) or when the upstream is lost (upstream_state = false).
//
// Parameters:
//              pDsgEcmUsSettings.upstreamState         true (2-way mode)
//                  false (1-way mode)
//              pDsgEcmUsSettings.ipMode                        0 (IPv4 only)
//                                                                                      1 (IPv6 only)
//                                                                                      2 (Both IPv4 and IPv6)
//
// Returns:  N/A
//
void DsgUpstreamChange( DsgEcmUsSettings *pDsgEcmUsSettings )
{
    //DsgPrint("DSG: DsgUpstreamChange us_state = %d\n", us_state);
    LOGINFO(HAL_MODULE_DSG,"%s():DSG: DsgUpstreamChange us_state = %d\n", __FUNCTION__,pDsgEcmUsSettings->upstreamState);
    LOGINFO(HAL_MODULE_DSG,"%s():DSG: DsgUpstreamChange ipMode[0 (IPv4 only),1 (IPv6 only),2 (Both IPv4 and IPv6)] = %d\n", __FUNCTION__,pDsgEcmUsSettings->ipMode);

    if(!pDsgEcmUsSettings->upstreamState)
    {
        vlForwardDsgMessageToStack(VL_DSG_MESSAGE_TYPE_ENTERING_ONE_WAY_MODE, 0);
    }
}
#else
// The eCM will call this function to notify the eSTB when DOCSIS registration is complete
// (upstream_state = true) or when the upstream is lost (upstream_state = false).
//
// Parameters:
//      us_state -  true (2-way mode)
//                  false (1-way mode)
//
// Returns:  N/A
//
void DsgUpstreamChange( bool us_state )
{
    //DsgPrint("DSG: DsgUpstreamChange us_state = %d\n", us_state);
    LOGINFO(HAL_MODULE_DSG,"%s():DSG: DsgUpstreamChange us_state = %d\n", __FUNCTION__,us_state);

    if(!us_state)
    {
        vlForwardDsgMessageToStack(VL_DSG_MESSAGE_TYPE_ENTERING_ONE_WAY_MODE, 0);
    }
}
#endif 

int vlDsgGetFileSize(char * pszPathName)
{
    int nSize = 0;
    FILE * fp = fopen(pszPathName, "rb");
    if(NULL != fp)
    {
        fseek(fp, 0, SEEK_END);
        nSize = ftell(fp);
        fclose(fp);
    }
    return nSize;
}
void vlDsgNotifyTlv217ToHost(char * pszPathName, int nSize)
{
    void * pAlloc = NULL;
    int nOffset = 0;

    rmf_osal_threadSleep(2*VL_DSG_SLEEP_RESOLUTION, 0);
    

    // open file
    FILE * fp = fopen(pszPathName, "rb");
    if(NULL != fp)
    {
        // read file
        int nRead = 0;
        fseek(fp, nOffset, SEEK_END);
        nSize = ftell(fp);
        LOGINFO(HAL_MODULE_DSG,"%s(): size of '%s' is %d.\n", __FUNCTION__,VL_DSG_TLV217_FILE_PATH, nSize);
       
        rmf_osal_memAllocP(RMF_OSAL_MEM_POD, nSize+4, &pAlloc);

        // allocate buffer
        if(NULL != pAlloc)
        {
            memset(pAlloc, 0, nSize+4);
            fseek(fp, nOffset, SEEK_SET);
            nRead = fread(pAlloc, 1, nSize, fp);
            // notify stack
            LOGINFO(HAL_MODULE_DSG,"%s(): read from '%s' succeeded. Read %d bytes.\n", __FUNCTION__,VL_DSG_TLV217_FILE_PATH, nRead);
            if(nRead <= 0)
            {
                LOGINFO(HAL_MODULE_DSG,"%s(): As %d bytes of TLV-217 have been read posting 4 bytes of zeros instead.\n", __FUNCTION__, nRead);
                nRead = 4;
            }
            DsgAsyncDataCallback(0, VL_DSG_PVT_TAG_TLV_217, nRead, pAlloc);
            //vlFree(pAlloc);
            rmf_osal_memFreeP(RMF_OSAL_MEM_POD, pAlloc);
        }
        else
        {
            LOGINFO(HAL_MODULE_DSG,"%s(): rmf_osal_memAllocP of %d bytes failed. Posting empty buffer of 4 bytes.\n", __FUNCTION__,nSize+4);
            unsigned char szBuf[4];
            memset(szBuf, 0, sizeof(szBuf));
            DsgAsyncDataCallback(0, VL_DSG_PVT_TAG_TLV_217, sizeof(szBuf), szBuf);
        }
        fclose(fp);
    }
    else
    {
        LOGINFO(HAL_MODULE_DSG,"%s(): fopen of '%s' failed. Posting empty buffer of 4 bytes.\n", __FUNCTION__,VL_DSG_TLV217_FILE_PATH);
        unsigned char szBuf[4];
        memset(szBuf, 0, sizeof(szBuf));
        DsgAsyncDataCallback(0, VL_DSG_PVT_TAG_TLV_217, sizeof(szBuf), szBuf);
    }
}

void vl_dsg_tlv217_polling_thread(void * arg)
{
    int i = 0;
    struct stat st;
    //VL_ZERO_MEMORY(st);
    memset(&st,0,sizeof(struct stat));
    char szTime[256];

    int nSize = vlDsgGetFileSize(VL_DSG_TLV217_FILE_PATH);
    ctime_r(&vl_tlv_217_stat.st_mtime, szTime);
    LOGINFO(HAL_MODULE_DSG,"%s(): size of file '%s' is %d. Previous time of file '%s' is '%s'.\n", __FUNCTION__,VL_DSG_TLV217_FILE_PATH, nSize, VL_DSG_TLV217_FILE_PATH,szTime);

    for(i = 0; i < VL_DSG_TLV217_POLL_COUNT; i++)
    {
        //cSleep(VL_DSG_TLV217_POLL_INVERVAL*VL_DSG_SLEEP_RESOLUTION);
        rmf_osal_threadSleep(VL_DSG_TLV217_POLL_INVERVAL*VL_DSG_SLEEP_RESOLUTION,0);
        int nRet = stat(VL_DSG_TLV217_FILE_PATH, &st);
        if(nRet < 0)
        {
            LOGINFO(HAL_MODULE_DSG,"%s(): stat('%s') return %d.\n", __FUNCTION__,VL_DSG_TLV217_FILE_PATH, nRet);
        }
        else
        {
            ctime_r(&st.st_mtime, szTime);
            LOGINFO(HAL_MODULE_DSG,"%s(): Time of file '%s' is '%s'.\n", __FUNCTION__,VL_DSG_TLV217_FILE_PATH, szTime);
        }
        if((st.st_mtime != vl_tlv_217_stat.st_mtime) ||
           (st.st_size  != vl_tlv_217_stat.st_size))
        {
            nSize = vlDsgGetFileSize(VL_DSG_TLV217_FILE_PATH);
            if(nSize > 0)
            {
                LOGINFO(HAL_MODULE_DSG,"%s(): '%s' updated. Size is %d.\n", __FUNCTION__,VL_DSG_TLV217_FILE_PATH, nSize);
                vlDsgNotifyTlv217ToHost(VL_DSG_TLV217_FILE_PATH, nSize);
                return;
            }
            else
            {
                LOGINFO(HAL_MODULE_DSG,"%s(): '%s' updated. Size is however still %d.\n", __FUNCTION__,VL_DSG_TLV217_FILE_PATH, nSize);
            }
        }
    }

    LOGINFO(HAL_MODULE_DSG,"%s(): '%s' not updated. Size is still %d.\n", __FUNCTION__,VL_DSG_TLV217_FILE_PATH, nSize);
    vlDsgNotifyTlv217ToHost(VL_DSG_TLV217_FILE_PATH,nSize);
}

// When the eCM establishes DOCSIS registration, it will provide its Upstream Channel ID to
// the eSTB using this function.
//
// Parameters:
//      uint8 uc_id
//
// Returns:  N/A
//
void DsgUcid( uint8 uc_id  )
{
    //char cmd_buffer[128];
    //long threadid = 0;
    //rmf_Error err;
    //rmf_osal_ThreadId threadid = 0;
    //DsgPrint("DSG: DsgUcid uc_id = %d\n", uc_id);
    LOGINFO(HAL_MODULE_DSG,"%s():DSG: DsgUcid uc_id = %d\n", __FUNCTION__,uc_id);
    vlForwardDsgMessageToStack(VL_DSG_MESSAGE_TYPE_2_WAY_OK, uc_id);
    /* Apr-05-2009: Moved to PFC
    sprintf(cmd_buffer,"route add -net 192.168.100.1 netmask 255.255.255.255 dev %s",
            VL_HAL_DSG_ECM_IF_NAME);
    //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s\n",cmd_buffer);
    LOGINFO(HAL_MODULE_DSG,"%s():%s\n", __FUNCTION__,cmd_buffer);
    system((const char *)cmd_buffer);*/
    /* 
     * Mar-13-2015 : BCOM-403 : Moved start of vl_dsg_tlv217_polling_thread() to vldsg_RestartDhcpProcess().
     */
}

// The eCM will call this function to notify the eSTB that a relevant timer event has occurred.
// The value event will be encoded as follows:
// Value    Event   Meaning
//  1   Tdsg1 timeout   Did not find DSG info on current channel - continuing scan
//  2   Tdsg2 timeout   DSG info lost from current channel - starting Tdsg4
//  3   Tdsg3 timeout   Beginning attempt to establish DOCSIS two way connection
//  4   Tdsg4 timeout   DSG info gone from current channel - starting downstream scan
//  5   Tdsg4 stop      DSG info regained on current channel
//
// Parameters:
//      uint8 tim_event - 1-5 encosed above
//
// Returns:  N/A
//
void DsgTimerEvent( uint8 tm_event )
{
    char* timout_names[] =
    {
        "Invalid",
        "Initialization",
        "Operational",
        "Two Way Retry",
        "One Way Retry",
        "Invalid",
        "Invalid",
    };

    //DsgPrint("DSG: Received '%s' Timout\n", timout_names[tm_event]);
    LOGINFO(HAL_MODULE_DSG,"%s():DSG: Received '%s' (%d) Timout\n", __FUNCTION__,timout_names[VL_SAFE_ARRAY_INDEX(tm_event, timout_names)], tm_event);

    DsgAsyncDataCallback(0, VL_DSG_PVT_TAG_ECM_TIMEOUT, tm_event, NULL);
    
    switch(tm_event)
    {
        case 4: // T4 timeout: One Way Retry...
        {
            // 1.1.1.1.1 DSG One-way Retry Timer (Tdsg4)[1]
            // This is the retry timer that determines when the DSG eCM attempts to rescan for a downstream DOCSIS channel that contains DSG packets after a Tdsg2 timeout defined in seconds.
            // The default value is 1800 seconds. If this sub-TLV is present, it is intended to overwrite the default value of Tdsg4 in the DSG eCM operational state machine.
            // If the DSG One-way Retry Timer sub-TLV is not present, then the DSG eCM MUST utilize the default value.
            // Valid range of values is 0 to 65535. A value of zero (0) indicates the DSG client must immediately begin scanning upon Tdsg1 or Tdsg2 timeout.
            // Once the eCM starts scanning it's state machine goes back to the initial state. Everything is reset.
            
            // Aug-08-2013: BPV-4906, MOT7425-726 : Discard any stale data to reflect corresponding reset of eCM state. This allows cable-card to intervene for recovery.
            // Invalidate current DCD to prepare for re-establishment of connectivity.
            vlg_bReceivedDsgDCDresponse = 1;
            vlg_nCurDcdVersion = VL_DSG_INVALID_DCD_VERSION;
            LOGINFO(HAL_MODULE_DSG,"%s():DSG: Invalidating old DCD to pick-up new/same DCD to begin the process of reconfiguring the eCM.\n", __FUNCTION__);
        }
        break;
        
        default:
        {
            // Do Nothing.
        }
        break;
    }
}

void VL_DSG_Send_FullData_Stack(int iTunnel, unsigned char * pData, unsigned long nLength)
{
    //DsgPrint("DSG: VL_DSG_Send_FullData_Stack: Forwarding Tunnel Packet len = %d\n", pAccumulator->nCurLength);
    VL_BYTE_STREAM_INST(TunnelData, WriteBuf, pData, nLength);
    vlWrite6ByteLong(pWriteBuf, vlg_aTunnelMacs[iTunnel]);
    DsgTunnelCallback(0, pData, nLength);
}


// This method is to forward DSG msg packet out to HalIf interface.
// Will wait for packet sent completion
//
// Parameters:
//      ETHERNET_PACKET *pData
//
// Returns:
//      success or fail
//
bool DsgTunnelPkt( ETHERNET_PACKET *pEthPacket )
{
    //DsgPrint("DSG: Received DsgTunnelPkt() len = %d\n", pEthPacket->pDataBufferHead->uiLen);

    if(pEthPacket && pEthPacket->pDataBufferHead && pEthPacket->pDataBufferHead->pvStart)
    {
        int iTunnel = 0;
        VL_BYTE_STREAM_INST(ETHERNET_PACKET, ParseBuf, pEthPacket->pDataBufferHead->pvStart, pEthPacket->pDataBufferHead->uiLen);
        VL_MAC_ADDRESS macAddress = vlParse6ByteLong(pParseBuf);

        for(iTunnel = 0; iTunnel < VL_BCM_DSG_MAX_TUNNELS; iTunnel++)
        {
            /*char szBuf1[100], szBuf2[100];
            DsgPrint("Checking mac %s against %s\n", VL_PRINT_LONG_TO_STR(macAddress        , VL_MAC_ADDR_SIZE, szBuf1),
            VL_PRINT_LONG_TO_STR(vlg_aTunnelMacs[iTunnel], VL_MAC_ADDR_SIZE, szBuf2));*/
            // BCM overwrites ther first four bytes of the dest mac address with the tunnel-id
            if(((macAddress>>16)&0xFFFFFFFF) == (vlg_aTunnels[iTunnel]))
            {
                VL_DSG_Send_FullData_Stack(iTunnel, (unsigned char*)pEthPacket->pDataBufferHead->pvStart, pEthPacket->pDataBufferHead->uiLen);
                DsgFreeEthernetPkt(pEthPacket);
                return true;
            }
        }
    }

    return false;
}

// When the eCM sends a "DCC-RSP (Depart)" message, the eCM must also send a
// "DCC Depart, Initialization Type <IT>" (where IT = "DCC Initialization Type")
// message to the Client Controller.
//
// Parameters:
//      uint8 dccInitType
//
// Returns:  N/A
//
void DsgDccInitType( uint8 dccInitType )
{
    //DsgPrint("DSG: DsgDccInitType dccInitType = %d\n", dccInitType);
    LOGINFO(HAL_MODULE_DSG,"%s():dccInitType = %d\n", __FUNCTION__,dccInitType);

    vlForwardDsgMessageToStack(VL_DSG_MESSAGE_TYPE_DYNAMIC_CHANNEL_CHANGE, dccInitType);
    // invalidate the DCD so that the cable card can re-authorize the downstream
    vlg_nCurDcdVersion = VL_DSG_INVALID_DCD_VERSION;
}

// eCM will call this function if one of the eSTB MAC addresses cannot be supported for data forwarding
// because of Max CPE limitations or NACO is configured to "off" in eCM configuration file (see [eDOCSIS]).
// These provisioning limitations MUST be reported to DSG Client Controller after 2-Way notification.
//
// Parameters:
//      uint8 naco
//      uint8 maxCpe
//
// Returns:  N/A
void DsgTwoWayForwardingDisabled( uint8 naco, uint8 maxCpe )
{
    //DsgPrint("DSG: DsgTwoWayForwardingDisabled naco = %d, maxCpe = %d\n", naco, maxCpe);
    LOGINFO(HAL_MODULE_DSG,"%s():naco = %d, maxCpe = %d\n", __FUNCTION__,naco, maxCpe);

    /* Jan-04-2009: Commented based on Broadcom's impl. logic.
    int fNaco = (naco == 0) ? VL_DSG_2_WAY_FAIL_REASON_NET_ACCESS_DISABLED : 0;
    int fCpe  = (maxCpe   ) ? VL_DSG_2_WAY_FAIL_REASON_MAX_CPE_LIMIT : 0;
    */
    vlForwardDsgMessageToStack(VL_DSG_MESSAGE_TYPE_CANNOT_FORWARD_2_WAY, naco);
}

// Aug-27-2013: BPV-4935 : Enabling DsgEcmMacReinit() compilation by default for this SOC.
/* DEBUG_DSG_MAC_REINIT */
// eCM will call this function if MAC reinitialization is required so this will make DSG-CC to initialize DCD version.
// Parameters:
//
// Returns:  N/A
void DsgEcmMacReinit()
{
    LOGINFO(HAL_MODULE_DSG,"%s():vlg_nCurDcdVersion is set to VL_DSG_INVALID_DCD_VERSION\n", __FUNCTION__);	

    vlForwardDsgMessageToStack(VL_DSG_MESSAGE_TYPE_ECM_RESET, 0);
    // Feb-11-2009: Workaround for TC165.1: re-establish 2-way after reset: force DCD to be redelivered in order to re-establish 2-way communications.
    vlg_bReceivedDsgDCDresponse = 1;
    
    if(VL_DSG_INVALID_DCD_VERSION == vlg_nCurDcdVersion)
    {
        vlg_nMissingDcdCount++;
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: vlg_nTotalDcdCount = %d, vlg_nMissingDcdCount = %d. Will reboot when vlg_nMissingDcdCount equals %d.\n", __FUNCTION__, vlg_nTotalDcdCount, vlg_nMissingDcdCount, (vlg_bRebootOnMissingDcdCount+1));
    }
    
    if((0 == vlg_nTotalDcdCount) && (vlg_bRebootOnMissingDcdCount > 0) && (vlg_nMissingDcdCount > vlg_bRebootOnMissingDcdCount))
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: Rebooting to recover from DCD Non-Delivery Failure...\n", __FUNCTION__);
        HAL_SYS_Reboot(__FUNCTION__, "recovery from DCD Non-Delivery");
    }
    
    vlg_nCurDcdVersion = VL_DSG_INVALID_DCD_VERSION;
}

// Aug-27-2013: BPV-4935 : Adding alternative callback...
void DsgEcmMacReinitEvent()
{
    LOGINFO(HAL_MODULE_DSG,"%s(): Forwarding call to DsgEcmMacReinit() \n", __FUNCTION__);
    DsgEcmMacReinit();
}

VL_DSG_ECM_STATUS vlBcmIsEcmOperational()
{
    int nDsgStatus = DsgStatus();
    int nCmStatus  = DsgDocsisStatus();
    
    if((nDsgStatus != 2) || (nCmStatus != 12))
    {
        return VL_DSG_ECM_STATUS_NOT_OK;
    }
    
    return VL_DSG_ECM_STATUS_OK;
}

void vlBcmRestartDSG()
{
    // patch for DELIA-14276.
    static int nRestartCount = 0;
    if((0 == vlg_nTotalDcdCount) && (vlg_bRebootOnMissingDcdCount > 0))
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: vlg_nTotalDcdCount = %d, nRestartCount = %d. Will reboot when nRestartCount equals %d.\n", __FUNCTION__, vlg_nTotalDcdCount, nRestartCount, (vlg_bRebootOnMissingDcdCount+1));
        nRestartCount++;
        if(nRestartCount > vlg_bRebootOnMissingDcdCount)
        {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: vlg_nTotalDcdCount = %d.\n", __FUNCTION__, vlg_nTotalDcdCount);
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: Rebooting to recover from DCD Non-Delivery Failure...\n", __FUNCTION__);
            HAL_SYS_Reboot(__FUNCTION__, "recovery from DCD Non-Delivery");
        }
    }
    
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s: Attempting DSG recovery...\n", __FUNCTION__);
    vlForwardDsgMessageToStack(VL_DSG_MESSAGE_TYPE_ECM_RESET, 0);
    if(NULL != vlg_pstDSG)
    {
        if(VL_DSG_OPERATIONAL_MODE_SCTE55 != vlg_pstDSG->dsgMode.eOperationalMode)
        {
            int bcmDsgMode    = kDsgDisabledMode;

            switch(vlg_pstDSG->dsgMode.eOperationalMode)
            {
                case VL_DSG_OPERATIONAL_MODE_BASIC_TWO_WAY:
                case VL_DSG_OPERATIONAL_MODE_BASIC_ONE_WAY:
                {
                    bcmDsgMode = kDsgBasicMode;
                }
                break;

                case VL_DSG_OPERATIONAL_MODE_ADV_TWO_WAY:
                case VL_DSG_OPERATIONAL_MODE_ADV_ONE_WAY:
                {
                    bcmDsgMode = kDsgAdvanceMode;
                }
                break;
            }
            DsgSetDSGMode(bcmDsgMode);
            DsgEnableDOCSIS(vlg_pstDSG->bDsgTwoWayMode);
            DsgScan(true);
        }
    }
}

void vlBcmAttemptIpRecovery()
{
    struct stat st;

    if((0 == vlg_nTotalDcdCount) && (vlg_bRebootOnMissingDcdCount > 0))
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: vlg_nTotalDcdCount = %d.\n", __FUNCTION__, vlg_nTotalDcdCount);
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: Rebooting to recover from DCD Non-Delivery Failure...\n", __FUNCTION__);
        HAL_SYS_Reboot(__FUNCTION__, "recovery from DCD Non-Delivery");
    }
    else if((0 == stat(VL_DSG_ECM_RESET_SCRIPT, &st) && (0 != st.st_ino)))
    {
         vlg_dsg_reboot_suppressed_for_ip_recovery = TRUE;
         RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s: '%s' is available. Invoking binary to reset eCM hardware.\n",__FUNCTION__, VL_DSG_ECM_RESET_SCRIPT);
         system("sh " VL_DSG_ECM_RESET_SCRIPT " &");
    }
    else
    {
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s: '%s' is NOT available.\n",__FUNCTION__, VL_DSG_ECM_RESET_SCRIPT);
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s: Attempting IP recovery...\n", __FUNCTION__);
        DsgSetDSGMode(kDsgDisabledMode);
        DsgEnableDOCSIS(1);
        vlBcmRestartDSG();
    }
}

void vlBcmPrintDsgStatus(VL_DSG_STATUS * pDsgStatus)
{
    char* dsg_names[] =
    {
        "API ERROR",
        "Scanning for info",            // = 1
        "info present",                 // = 2
        "info lost, trying to recover", // = 3
        "not started",                  // = 4

        "Unknown"
    };

    char* cm_names[] =
    {
        "API ERROR",                            // = 0
        "Initial State",                        // = 1
        "Not Ready",                            // = 2
        "Not Synchronized",                     // = 3
        "PHY Synchronized",                     // = 4
        "Upstream Parameters Acquired",         // = 5
        "Ranging Complete",                     // = 6
        "Dhcp v4 Complete",                     // = 7
        "TOD Established",                      // = 8
        "Security Established",                 // = 9
        "Config File Download Complete",        // = 10
        "Registration Complete",                // = 11
        "Operational",                          // = 12
        "Access Denied",                        // = 13
        "Eae In Progress",                      // = 14
        "Dhcp v4 In Progress",                  // = 15
        "Dhcp v6 In Progress",                  // = 16
        "Dhcp v6 Complete",                     // = 17
        "Registration In Progress",             // = 18
        "Bpi Init",                             // = 19
        "Forwarding Disabled",                  // = 20
        "Ds Topology Resolution In Progress",   // = 21
        "Ranging In Progress",                  // = 22
        "Rf Mute All",                          // = 23

        "Unknown"
    };

    int nDsgStatus = DsgStatus();
    int nCmStatus  = DsgDocsisStatus();

    //DsgPrint("DSG STATUS : %s\n", dsg_names[nDsgStatus]);
    LOGINFO(HAL_MODULE_DSG,"%s():DSG STATUS : %s (%d)\n", __FUNCTION__,dsg_names[VL_SAFE_ARRAY_INDEX(nDsgStatus, dsg_names)], nDsgStatus);
    //DsgPrint("CM  STATUS : %s\n",  cm_names[nCmStatus]);
    LOGINFO(HAL_MODULE_DSG,"%s():CM  STATUS : %s (%d)\n", __FUNCTION__,cm_names[VL_SAFE_ARRAY_INDEX(nCmStatus, cm_names)], nCmStatus);

    if(NULL != pDsgStatus)
    {
        //VL_ZERO_MEMORY(*pDsgStatus);
        memset(pDsgStatus, 0, sizeof(VL_DSG_STATUS));
        pDsgStatus->nDsgStatus      = nDsgStatus;
        pDsgStatus->nDocsisStatus   = nCmStatus;
        sprintf(pDsgStatus->szDsgStatus   , "%s", dsg_names[VL_SAFE_ARRAY_INDEX(nDsgStatus, dsg_names)]);
        sprintf(pDsgStatus->szDocsisStatus, "%s", cm_names [VL_SAFE_ARRAY_INDEX(nCmStatus , cm_names )]);
    }

    if((VL_DSG_BCM_API_ERROR == nDsgStatus) || (VL_DSG_BCM_API_ERROR == nCmStatus))
    {
        DsgAsyncDataCallback(0, VL_DSG_PVT_TAG_NON_DSG_MODE, 0, NULL);
    }
}

void vl_dsg_fp_service(void * arg)
{
    /* Feb-04-2008: Use InitializeDsgCcApplication() instead of the following below...
    //LOGINFO(HAL_MODULE_CDL,"%s() : Calling AppPreNonvolInit()\n", __FUNCTION__);
    AppPreNonvolInit();
    //LOGINFO(HAL_MODULE_CDL,"%s() : Calling AppPostNonvolInit()\n", __FUNCTION__);
    AppPostNonvolInit();
    //LOGINFO(HAL_MODULE_CDL,"%s() : Calling AppRun()\n", __FUNCTION__);
    AppRun();
    */
    //cSleep(3000);
	// DO NOT DELAY   rmf_osal_threadSleep(3000,0);
    InitializeDsgCcApplication();
}

static void vl_dsg_system_with_dhcp_if_param(const char * pszCommand, int bInBackground)
{
	char szCommand[VL_DSG_MAX_STR_SIZE];
	char szPath[VL_DSG_MAX_STR_SIZE] = "/mnt/nfs/bin/scripts/"; /*XONE-14082 : Default XONE path*/
	char * pszIf = vlg_util_get_docsis_dhcp_if_name();

        #ifdef YOCTO_BUILD
            strcpy( szPath, "/lib/rdk/" );
        #endif

	if( pszIf == NULL)
	{
		RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: Failed to get DOCSIS DHCP if name \n",__FUNCTION__);
		return;
	}

	RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s: DOCSIS DHCP if name is '%s'\n",__FUNCTION__, vlg_util_get_docsis_dhcp_if_name());
	/*start XONE-14082
	 * Seems issue with relative path some time noticing shell can not open script files
	 * so using absolute path.
	 */

	RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: Reading config file for the script path\n",__FUNCTION__);
	const char *scripts_path = rmf_osal_envGet("DHCP_V4_V6_SCRIPTS_PATH");
	if(scripts_path)
	{
		RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: Found entry in config file, script path is '%s'\n",__FUNCTION__, scripts_path);
		snprintf(szCommand, VL_DSG_MAX_STR_SIZE, "sh %s/%s %s %s", scripts_path, pszCommand, pszIf, (bInBackground?"&":""));
	}
	else
	{
		RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: Could not find entry in config file, using default path is '%s'\n",__FUNCTION__, szPath);
		snprintf(szCommand, VL_DSG_MAX_STR_SIZE, "sh %s/%s %s %s", szPath, pszCommand, pszIf, (bInBackground?"&":""));
	}
	RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s: Invoking '%s'\n",__FUNCTION__, szCommand);
	/*end XONE-14082*/
	//snprintf(szCommand, VL_DSG_MAX_STR_SIZE, "sh ../bin/scripts/%s %s %s", pszCommand, pszIf, (bInBackground?"&":""));
	system(szCommand);
}

void vldsg_RestartDhcpProcess()
{
    // Mar-13-2015 : BCOM-403 : Moving TLV processing over here as TLV process is directly associated with DHCP process.
    rmf_osal_ThreadId threadid = 0;
    rmf_Error err = rmf_osal_threadCreate(vl_dsg_tlv217_polling_thread, NULL,
		    250, 4096, &threadid,
		    "vl_dsg_tlv217_polling_thread");
    if ( RMF_SUCCESS != err)
    {
	    RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Failed to create vl_dsg_tlv217_polling_thread() thread\n",__FUNCTION__);
    }
#if 1 /* Invoke dhcp client from script based on the TLV data parsed from snmp mgr */
    RDK_LOG( RDK_LOG_INFO, HAL_MODULE_DSG,"%s(): Invoking restart_dhcp.sh\n", __FUNCTION__);
    vl_dsg_system_with_dhcp_if_param("restart_dhcp.sh", TRUE);
#else 
    // Oct-08-2012: Added support for restaring DHCP on downstream channel change
    system(VL_DHCP_CONTROL " restart 1>" VL_DHCP_LOG_FILE " 2>" VL_DHCP_LOG_FILE);
    // Oct-18-2012: BPV-1973: Re-route dhcp logs via mpeos logs
    FILE * fp = fopen(VL_DHCP_LOG_FILE, "r");
    if(NULL != fp)
    {
        char szBuf[VL_DSG_MAX_STR_SIZE+1];
        //VL_ZERO_MEMORY(szBuf);
        memset(szBuf, 0, (VL_DSG_MAX_STR_SIZE+1)*sizeof(char));
         while(NULL != fgets(szBuf, VL_DSG_MAX_STR_SIZE, fp))
        {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.SYS", VL_DHCP_CONTROL ": %s", szBuf);
        }
        fclose(fp);
    }
#endif /* Invoke dhcp client from script based on the TLV data parsed from snmp mgr */
}

void vldsg_estb_poll_ecm_operational_state(void * arg)
{
    const char* envVar;
    int nMaxEcmApiFailCount = 0;
    int nMaxDsgNotStartedFailCount = 0;
    int nMaxInvalidDsgStateFailCount = 0;
    // Jul-03-2012: Patch for BPV-1182
    //cSleep(10000);
    rmf_osal_threadSleep(10000,0);
    
    envVar = rmf_osal_envGet(vlg_szMpeosFeatureRebootOnEcmError);
    if (envVar != NULL) { nMaxEcmApiFailCount = atoi(envVar)*5; } 
    else { nMaxEcmApiFailCount = 10; }

    envVar = rmf_osal_envGet(vlg_szMpeosFeatureRecoverOnDsgError);
    if (envVar != NULL) { nMaxDsgNotStartedFailCount = atoi(envVar);  }
    else { nMaxDsgNotStartedFailCount = 15; }

    envVar = rmf_osal_envGet(vlg_szMpeosFeatureRecoverOnDsgInvalidStateError);
    if (envVar != NULL) { nMaxInvalidDsgStateFailCount = atoi(envVar);  }
    else { nMaxInvalidDsgStateFailCount = 60; } //ericz, merged from BPV-6010/5055
    
    int nEcmApiFailCount = 0;
    int nDsgNotStartedFailCount = 0;
    int nDsgInvalidStateFailCount = 0;
    int nIterCount = 0;
    while(1)
    {
        static int nPrevDsgStatus = 4;
        static int nPrevCmStatus  = 0;
        int nDsgStatus = DsgStatus();
        int nCmStatus  = DsgDocsisStatus();
        if(0 != nCmStatus)
        {
            nEcmApiFailCount = 0;
        }
        else
        {
            nEcmApiFailCount++;
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: DsgDocsisStatus returned error code %d. Failure count is %d. Will reboot when fail count equals %d.\n", __FUNCTION__, nCmStatus, nEcmApiFailCount, nMaxEcmApiFailCount);
            if((nMaxEcmApiFailCount > 0) && (nEcmApiFailCount >= nMaxEcmApiFailCount))
            {
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: Rebooting to recover from eCM communication failure...\n", __FUNCTION__);
                // XONE-3545: Added new API to handle reboot
                HAL_SYS_Reboot(__FUNCTION__, "recovery from eCM communication failure");
            }
        }
        if((nCmStatus != 0) && (nCmStatus != nPrevCmStatus))
        {
            if(12 == nCmStatus)
            {
                // Oct-08-2012: Added support for restaring DHCP on downstream channel change
                LOGINFO(HAL_MODULE_DSG,"%s(): Restarting DCHP...\n", __FUNCTION__);
                DsgAsyncDataCallback(0, VL_DSG_PVT_TAG_ECM_OPERATIONAL_NOW, 0, 0); // Mar-30-2015 : BCOM-443 : Workaround for SAM150-3563 caused by SAM150-3515.
                vldsg_RestartDhcpProcess();
            }
            nPrevCmStatus = nCmStatus;
        }
        if((nCmStatus != 0) && (NULL != vlg_pstDSG) && (VL_DSG_OPERATIONAL_MODE_SCTE55 != vlg_pstDSG->dsgMode.eOperationalMode)) // Sep-17-2012: Fix for BPV-1846
        {
            if(1 == nCmStatus) // Sep-17-2012:  Fix for BPV-1846
            {
                nDsgNotStartedFailCount++; // Sep-17-2012:  Fix for BPV-1846
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: DETECTED UN-NOTIFIED ECM REBOOT: Will attempt recovery in %d seconds\n", __FUNCTION__, (nMaxDsgNotStartedFailCount-nDsgNotStartedFailCount));
                if(nDsgNotStartedFailCount > nMaxDsgNotStartedFailCount) // Sep-17-2012:  Fix for BPV-1846
                {
                    nDsgNotStartedFailCount = 0; // Sep-17-2012:  Fix for BPV-1846
                    RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: DETECTED UN-NOTIFIED ECM REBOOT: Attempting recovery...\n", __FUNCTION__);
                    vlBcmRestartDSG();
                    vlBcmDsgSetDhcpOption43(vlg_pDhcpV4Bytes, vlg_nDhcpV4Bytes);
                    vlBcmDsgSetDhcpOption17(vlg_pDhcpV6Bytes, vlg_nDhcpV6Bytes);
                }
            }
            else
            {
                nDsgNotStartedFailCount = 0; // Sep-17-2012:  Fix for BPV-1846
            }
            
            if(((4 == nCmStatus) && (4 == nDsgStatus)) || // Dec-13-2013:  Fix for BPV-6010
               ((2 == nCmStatus) && (4 == nDsgStatus)) || // Mar-04-2014:  Fix for BPV-5055 & MOT7425-4413.
               ((4 == nCmStatus) && (2 == nDsgStatus)))   // Mar-24-2014:  Fix for PACXG1V3-100.
            {
                nDsgInvalidStateFailCount++; // Dec-13-2013:  Fix for BPV-6010
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: eCM is in an Invalid State (DSG STATUS=%d) (CM  STATUS=%d): Will attempt recovery in %d seconds\n", __FUNCTION__, nDsgStatus, nCmStatus, (nMaxInvalidDsgStateFailCount-nDsgInvalidStateFailCount));
                if(nDsgInvalidStateFailCount > nMaxInvalidDsgStateFailCount) // Dec-13-2013:  Fix for BPV-6010
                {
                    nDsgInvalidStateFailCount = 0; // Dec-13-2013:  Fix for BPV-6010
                    RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: eCM in an invalid state: Attempting recovery...\n", __FUNCTION__);
                    vlBcmRestartDSG();
                }
            }
            else
            {
                nDsgInvalidStateFailCount = 0; // Dec-13-2013:  Fix for BPV-6010
            }
            nPrevDsgStatus = nDsgStatus;
        }
        if((nDsgStatus != 2) || (nCmStatus != 12))
        {
            if(0 == (nIterCount%15))
            {
                VL_DSG_STATUS dsgStatus;
                vlBcmPrintDsgStatus(&dsgStatus);
            }
            nIterCount++;
        }
        //cSleep(1000); // Oct-08-2012: Added support for restaring DHCP on downstream channel change
        rmf_osal_threadSleep(1000,0);
    }
}

void vlBcmDsgInit()
{
    long taskId = -1;
    int result = 0;

    rmf_Error err;
    rmf_osal_ThreadId threadid = 0;
    
    vldsg_getDsgEcmName(vlg_dsgEcmName);
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s: DOCSIS WAN if name is '%s'\n",__FUNCTION__, vlg_dsgEcmName);
    SetupRemoteInterface(vlg_dsgEcmName);
    
    // enable only if eCM should enter DSG mode without Cable Card // DsgSetTimer(kTdsg3Timeout, 60 );
    DsgSetDSGMode(kDsgDisabledMode);
    DsgEnableDOCSIS(0);
#ifdef USE_SOC_SIGNAL_MASK
    SetSignalMask();
#endif

    err = rmf_osal_threadCreate(vl_dsg_fp_service, NULL,
		    250, 4096, &threadid,
		    "vl_dsg_fp_service");

    if ( RMF_SUCCESS != err)
    {
    	LOGINFO(HAL_MODULE_DSG,"%s():Unable to start the EstbDsgRemoteInterfaceHelper Thread\n", __FUNCTION__);
    }

    memset(vlg_aTunnelMacs, 0, sizeof(vlg_aTunnelMacs));

    {
        FILE * fp = fopen(VL_DSG_TLV217_FILE_PATH, "wb");
        if(NULL != fp) fclose(fp);
    }
    
    err = rmf_osal_threadCreate(vldsg_estb_poll_ecm_operational_state, NULL,
		    250, 4096, &threadid,
		    "vldsg_estb_poll_ecm_operational_state");
    if ( RMF_SUCCESS != err)
    {
    	LOGINFO(HAL_MODULE_DSG,"%s():Unable to start the EstbDsgRemoteInterfaceHelper Thread\n", __FUNCTION__);
    }
    
    const char* envVar = rmf_osal_envGet(vlg_szMpeosFeatureRebootOnMissingDcdCount);
    if (envVar != NULL) { vlg_bRebootOnMissingDcdCount = atoi(envVar); } 
    else { vlg_bRebootOnMissingDcdCount = 45; }
}

t_dsg_classifier * vlBcmDsgAddClassifier(DSG_t *pstDSG, unsigned long nClassifierId)
{
    if((NULL != pstDSG) && (vlg_nClassifiers < VL_BCM_DSG_MAX_CLASSIFIERS))
    {
        int i = 0;
        VL_DSG_IP_CPE dsgIpCpe;
        
        if((unsigned long)(-1) == nClassifierId)
        {
            t_dsg_classifier * p_dsg_classifier = &(vlg_bcm_dsg_classifiers[vlg_nClassifiers]);
            //VL_ZERO_MEMORY(*p_dsg_classifier);
            memset(p_dsg_classifier, 0, sizeof(t_dsg_classifier));
            vlg_nClassifiers++;
            return p_dsg_classifier;
        }
        else if(0 != nClassifierId)
        {
            for(i = 0; i < pstDSG->dsgDCD.nClassifiers; i++)
            {
                if(nClassifierId == pstDSG->dsgDCD.aClassifiers[i].nId)
                {
                    t_dsg_classifier * p_dsg_classifier = &(vlg_bcm_dsg_classifiers[vlg_nClassifiers]);
                    VL_BYTE_STREAM_OBJECT_INST(p_dsg_classifier->cfr_id, WriteBuf);

                    vlg_nClassifiers++;
                    //VL_ZERO_MEMORY(*p_dsg_classifier);
                    memset(p_dsg_classifier, 0, sizeof(t_dsg_classifier));
                    dsgIpCpe = pstDSG->dsgDCD.aClassifiers[i].ipCpe;

                    vlWriteShort(pWriteBuf, nClassifierId);
                    p_dsg_classifier->priority = pstDSG->dsgDCD.aClassifiers[i].nPriority;
                    p_dsg_classifier->unused   = 0;
                    
                    // Dec-29-2008: don't bother filling in other information
                    // as BCM API actually uses them to populate the tunnel MIBs
                    
                    return p_dsg_classifier;
                }
            }
        }
    }

    return NULL;
}

void vlBcmDsgUpdateClassifierWithTunnelData(DSG_t *pstDSG, t_dsg_classifier * p_dsg_classifier,
                                            VL_DSG_TUNNEL_FILTER * pTunnelFilter, VL_ADSG_FILTER * pAdsgFilter)
{
    if((NULL != pstDSG) && (NULL != p_dsg_classifier))
    {
        int i = 0;
        VL_IP_ADDRESS  srcIpAddress = 0;
        VL_IP_MASK     srcIpMask = 0;
        VL_IP_ADDRESS  destIpAddress = 0;
        long nPortStart = 65535;
        long nPortEnd = -1;
//        VL_DSG_IP_CPE dsgIpCpe;

        // from advanced config
        if(NULL != pTunnelFilter)
        {
            srcIpAddress    = pTunnelFilter->srcIpAddress;
            srcIpMask       = pTunnelFilter->srcIpMask;
            destIpAddress   = pTunnelFilter->destIpAddress;
            
            for(i = 0; (i < (int)(pTunnelFilter->nPorts)) && (i < (int)VL_ARRAY_ITEM_COUNT(pTunnelFilter->aPorts)); i++)
            {
                if(pTunnelFilter->aPorts[i] < nPortStart)
                {
                    nPortStart = pTunnelFilter->aPorts[i];
                }
                if(pTunnelFilter->aPorts[i] > nPortEnd)
                {
                    nPortEnd  = pTunnelFilter->aPorts[i];
                }
            }
        }
        // from dsg directory
        if(NULL != pAdsgFilter)
        {
            srcIpAddress    = pAdsgFilter->ipAddress;
            srcIpMask       = pAdsgFilter->ipMask;
            destIpAddress   = pAdsgFilter->destIpAddress;
            nPortStart      = pAdsgFilter->nPortStart;
            nPortEnd        = pAdsgFilter->nPortEnd;
        }

        if(0 != srcIpAddress)
        {
            VL_BYTE_STREAM_OBJECT_INST(p_dsg_classifier->source_ip_adr, WriteBuf);
            vlWriteLong(pWriteBuf, srcIpAddress);
            p_dsg_classifier->source_ip_used = 1;
        }

        if(0 != srcIpMask)
        {
            VL_BYTE_STREAM_OBJECT_INST(p_dsg_classifier->source_ip_mask, WriteBuf);
            vlWriteLong(pWriteBuf, srcIpMask);
            p_dsg_classifier->source_ip_mask_used = 1;
        }

        if(0 != destIpAddress)
        {
            VL_BYTE_STREAM_OBJECT_INST(p_dsg_classifier->dest_ip_adr, WriteBuf);
            vlWriteLong(pWriteBuf, destIpAddress);
            p_dsg_classifier->dest_ip_used = 1;
        }

        if(65535 != nPortStart)
        {
            VL_BYTE_STREAM_OBJECT_INST(p_dsg_classifier->port_start, WriteBuf);
            vlWriteShort(pWriteBuf, nPortStart);
            p_dsg_classifier->port_used = 1;
        }

        // fix the outerbound of the port
        if(nPortEnd <= 0) nPortEnd = 65535;
        
        if(-1 != nPortEnd)
        {
            VL_BYTE_STREAM_OBJECT_INST(p_dsg_classifier->port_end, WriteBuf);
            vlWriteShort(pWriteBuf, nPortEnd);
            p_dsg_classifier->port_used = 1;
        }
    }
}

int vlBcmDsgGetClassifiers(DSG_t *pstDSG, const VL_MAC_ADDRESS macAddress, VL_DSG_TUNNEL_FILTER * pTunnelFilter, VL_ADSG_FILTER * pAdsgFilter)
{
    if(NULL != pstDSG)
    {
//        VL_DSG_IP_CPE dsgIpCpe;

        vlg_nClassifiers = 0;
        t_dsg_classifier * p_dsg_classifier = NULL;
        
        // add the tunnel classifier first
        p_dsg_classifier = vlBcmDsgAddClassifier(pstDSG, (unsigned long)-1);
        vlBcmDsgUpdateClassifierWithTunnelData(pstDSG, p_dsg_classifier, pTunnelFilter, pAdsgFilter);

        /*  Dec-29-2008: don't bother filling in other information
            as BCM API actually uses them to populate the tunnel MIBs
        
            //search the DCD next for cfr_ids
            //{
            //    int i = 0;
            //    unsigned short nClassifierId = 0;
            //    for(i = 0; i < pstDSG->dsgDCD.nRules; i++)
            //    {
            //        if(macAddress == pstDSG->dsgDCD.aRules[i].dsgMacAddress)
            //        {
            //            nClassifierId = pstDSG->dsgDCD.aRules[i].nClassifierId;
            //            p_dsg_classifier = vlBcmDsgAddClassifier(pstDSG, nClassifierId);
            //        }
            //    }
            //}
        */
    }

    return vlg_nClassifiers;
}

int vlBcmDsgIsTunnelOpen(const VL_MAC_ADDRESS macAddress)
{
    /*Commented: Jan-31-2009: Different tunnels can have same mac address: int i = 0;
    //for(i = 0; i < VL_BCM_DSG_MAX_TUNNELS; i++)
    //{
	//	  Commented: Jan-31-2009: Different tunnels can have same mac address:
    //    if(macAddress == vlg_aTunnelMacs[i])
    //    {
    //        return 1;
    //    }
    //}
    */

    if(0 == macAddress)
    {
        return 1;
    }

    return 0;
}

void vlBcmDsgCloseOldTunnels()
{
    int i = 0;
    for(i = 0; i < VL_BCM_DSG_MAX_TUNNELS; i++)
    {
        if(VL_BCM_DSG_INVALID_TUNNEL_HANDLE != vlg_aTunnels[i])
        {
            DsgCloseTunnel(vlg_aTunnels[i]);
            vlg_aTunnels[i] = VL_BCM_DSG_INVALID_TUNNEL_HANDLE;
        }
    }
}

int vlBcmDsgAllocateTunnel()
{
    int i = 0;
    for(i = 0; i < VL_BCM_DSG_MAX_TUNNELS; i++)
    {
        if(VL_BCM_DSG_INVALID_TUNNEL_HANDLE == vlg_aTunnels[i])
        {
            return i;
        }
    }
    
    LOGERROR(HAL_MODULE_DSG, "%s():DSG : Unable to allocate tunnel. Returning 0 instead. Not a happy situation.\n", __FUNCTION__);
    return 0;
}

int vlBcmDsgDeallocateTunnel(unsigned long hBcmTunnelHandle)
{
    int i = 0;
    for(i = 0; i < VL_BCM_DSG_MAX_TUNNELS; i++)
    {
        if(hBcmTunnelHandle == vlg_aTunnels[i])
        {
            DsgCloseTunnel(vlg_aTunnels[i]);
            vlg_aTunnels[i] = VL_BCM_DSG_INVALID_TUNNEL_HANDLE;
            return i;
        }
    }
    
    LOGERROR(HAL_MODULE_DSG, "%s():DSG : Tunnel 0x%08X not found\n", __FUNCTION__, hBcmTunnelHandle);
    return 0;
}

int vlBcmDsgOpenTunnel(DSG_t *pstDSG,
                       const VL_MAC_ADDRESS macAddress,
                       VL_DSG_CLIENT_ID_ENC_TYPE eClientType,
                       unsigned long eClientId,
                       VL_DSG_TUNNEL_FILTER * pTunnelFilter,
                       VL_ADSG_FILTER * pAdsgFilter)
{
    // make a note that we received a response from the card
    vlg_bReceivedDsgDCDresponse = 1;

    if(!vlBcmDsgIsTunnelOpen(macAddress))
    {
        t_mac_adr bcmMacAddr;
        VL_BYTE_STREAM_ARRAY_INST(bcmMacAddr.macaddress, WriteBuf);
        vlWrite6ByteLong(pWriteBuf, macAddress);

        int iTunnel = vlBcmDsgAllocateTunnel();
        if((iTunnel >= 0) && (iTunnel < (int)VL_ARRAY_ITEM_COUNT(vlg_aTunnels)))
        {
            int nClassifiers  = vlBcmDsgGetClassifiers(pstDSG, macAddress, pTunnelFilter, pAdsgFilter);

//             DsgPrint("DSG : Opening tunnel 0x%02X%02X%02X%02X%02X%02X: nClassifiers = %d\n",
//                      bcmMacAddr.macaddress[0], bcmMacAddr.macaddress[1],
//                      bcmMacAddr.macaddress[2], bcmMacAddr.macaddress[3],
//                      bcmMacAddr.macaddress[4], bcmMacAddr.macaddress[5],
//                      nClassifiers);

            LOGDEBUG(HAL_MODULE_DSG, "%s():DSG : Opening tunnel 0x%02X%02X%02X%02X%02X%02X: nClassifiers = %d\n", __FUNCTION__,
                     bcmMacAddr.macaddress[0], bcmMacAddr.macaddress[1],
                     bcmMacAddr.macaddress[2], bcmMacAddr.macaddress[3],
                     bcmMacAddr.macaddress[4], bcmMacAddr.macaddress[5],
                     nClassifiers);

            //vlg_aTunnels[iTunnel] = DsgOpenTunnel(&bcmMacAddr, 0, NULL);
            // Dec-21-2008: Enabled association of classifier with DSG tunnels.
///            #ifdef BCM_USE_DSG_TUNNEL_SETTINGS_STRUCT // use this macro for now till we get next refsw
            {
                DsgTunnelSettings tunnelSettings;
                //VL_ZERO_MEMORY(tunnelSettings);
                memset(&tunnelSettings, 0, sizeof(tunnelSettings));
                tunnelSettings.pTunnelAddress   = &bcmMacAddr;
                tunnelSettings.clientIdType     = eClientType;
                tunnelSettings.clientIdValue    = eClientId;
                tunnelSettings.numOfClassifiers = nClassifiers;
                tunnelSettings.pClassifierList  = vlg_bcm_dsg_classifiers;

                { //BCOM-2674 : retry if DsgOpenTunnel() returns <= 0 
                    int retry_count = 0;
                    int tunnel_handle = 0;
                    do {
                        vlg_aTunnels[iTunnel] = DsgOpenTunnel(&tunnelSettings); 
                        tunnel_handle = (int) vlg_aTunnels[iTunnel];
                        if(NULL != pAdsgFilter)
                        {
                            pAdsgFilter->hTunnelHandle = vlg_aTunnels[iTunnel];
                        }

                        if (tunnel_handle <= 0) {
                            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: vlBcmDsgOpenTunnel failed, so retry %d - [0x%02X%02X%02X%02X%02X%02X]\n", __FUNCTION__, retry_count + 1,
                            bcmMacAddr.macaddress[0], bcmMacAddr.macaddress[1],
                            bcmMacAddr.macaddress[2], bcmMacAddr.macaddress[3],
                            bcmMacAddr.macaddress[4], bcmMacAddr.macaddress[5]);
                            usleep(100000);
                        }
                        else {
                          if (retry_count > 0) {
                            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: vlBcmDsgOpenTunnel succeed after retry %d - [0x%02X%02X%02X%02X%02X%02X]\n", __FUNCTION__, retry_count,
                            bcmMacAddr.macaddress[0], bcmMacAddr.macaddress[1],
                            bcmMacAddr.macaddress[2], bcmMacAddr.macaddress[3],
                            bcmMacAddr.macaddress[4], bcmMacAddr.macaddress[5]);
                          }
                          break;
                        }
                        retry_count++;
                    } while(retry_count < 7);

                    if (tunnel_handle <= 0) {
                        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: vlBcmDsgOpenTunnel failed after all retries \n", __FUNCTION__);
                    }
                }
            }
///            #else // for latest refsw remove conditional compilation and use code in the above statement
//                vlg_aTunnels[iTunnel] = DsgOpenTunnel(&bcmMacAddr, nClassifiers, vlg_bcm_dsg_classifiers);
///            #endif
            vlg_aTunnelMacs[iTunnel] = macAddress;
        }
    }
	return HAL_SUCCESS;
}

void vlBcmDsgScan(DSG_t *pstDSG)
{
    int iTunnel = 0;
    vlg_bReceivedDsgDCDresponse = 1;
    if(NULL != pstDSG)
    {
        switch(pstDSG->dsgMode.eOperationalMode)
        {
            case VL_DSG_OPERATIONAL_MODE_BASIC_TWO_WAY:
            case VL_DSG_OPERATIONAL_MODE_BASIC_ONE_WAY:
            {
                vlBcmDsgCloseOldTunnels();
                DsgResetChannelList();
                for(iTunnel = 0; iTunnel < pstDSG->dsgMode.nMacAddresses; iTunnel++)
                {
                    vlBcmDsgOpenTunnel(pstDSG, pstDSG->dsgMode.aMacAddresses[iTunnel], (VL_DSG_CLIENT_ID_ENC_TYPE)0, 0, NULL, NULL);
                }
                DsgEnableDOCSIS(pstDSG->bDsgTwoWayMode);
                DsgScan(true);
            }
            break;

            default:
            {
                DsgEnableDOCSIS(pstDSG->bDsgTwoWayMode);
                if(VL_DSG_OPERATIONAL_MODE_SCTE55 != pstDSG->dsgMode.eOperationalMode)
                {
                    DsgScan(true);
                }
            }
            break;
        }
        LOGINFO(HAL_MODULE_DSG,"%s():DSG bDsgTwoWayMode = %d : eOperationalMode = %d\n", __FUNCTION__, pstDSG->bDsgTwoWayMode, pstDSG->dsgMode.eOperationalMode);
    }

    // invalidate the DCD only after we request for scan
    vlg_nCurDcdVersion = VL_DSG_INVALID_DCD_VERSION;
}

void vlBcmDsgSetDsgMode(DSG_t *pstDSG)
{

    int bcmDsgMode    = kDsgDisabledMode;
    vlg_bReceivedDsgDCDresponse = 1;

    switch(pstDSG->dsgMode.eOperationalMode)
    {
        case VL_DSG_OPERATIONAL_MODE_BASIC_TWO_WAY:
        {
            bcmDsgMode    = kDsgBasicMode;
            pstDSG->bDsgTwoWayMode = 1;
        }
        break;

        case VL_DSG_OPERATIONAL_MODE_BASIC_ONE_WAY:
        {
            bcmDsgMode = kDsgBasicMode;
            pstDSG->bDsgTwoWayMode = 0;
        }
        break;

        case VL_DSG_OPERATIONAL_MODE_ADV_TWO_WAY:
        {
            bcmDsgMode = kDsgAdvanceMode;
            pstDSG->bDsgTwoWayMode = 1;
        }
        break;

        case VL_DSG_OPERATIONAL_MODE_ADV_ONE_WAY:
        {
            bcmDsgMode = kDsgAdvanceMode;
            pstDSG->bDsgTwoWayMode = 0;
        }
        break;
        
        case VL_DSG_OPERATIONAL_MODE_IPDM:
        case VL_DSG_OPERATIONAL_MODE_IPDIRECT_UNICAST:
        {
                //When you switch to IP direct mode, you need to disable DSG and tell the modem to scan.
                bcmDsgMode = kDsgDisabledMode;
                pstDSG->bDsgTwoWayMode = 1;
        }
        break;

        case VL_DSG_OPERATIONAL_MODE_SCTE55:
        case VL_DSG_OPERATIONAL_MODE_INVALID:
        default:
        {
            bcmDsgMode = kDsgDisabledMode;
            pstDSG->bDsgTwoWayMode = 1;
        }
        break;
    }

    DsgSetDSGMode(bcmDsgMode);
    vlBcmDsgScan(pstDSG);

    {
        //VL_ZERO_MEMORY(vl_tlv_217_stat);
        memset(&vl_tlv_217_stat, 0, sizeof(struct stat)); 
        stat(VL_DSG_TLV217_FILE_PATH, &vl_tlv_217_stat);
    }
}

void vlBcmDsgSetChannelList(int nRxFrequencies, unsigned long  aRxFrequency[VL_MAX_DSG_ENTRIES])
{
    int i = 0;
    VL_BYTE_STREAM_ARRAY_INST(vlg_abufRxFrequency, WriteBuf);
    for(i = 0; (i < nRxFrequencies) && (i < VL_MAX_DSG_ENTRIES); i++)
    {
        vlWriteLong(pWriteBuf, aRxFrequency[i]);
    }

    DsgResetChannelList();
    DsgSetChannelList(nRxFrequencies, (unsigned long*)vlg_abufRxFrequency);
}

void vlBcmDsgSetDirectory(DSG_t *pstDSG, VL_DSG_DIRECTORY * pDirectory, int bProcessTunnels)
{
    pstDSG->dsgDirectory =  *pDirectory;
    
    vlBcmDsgSetChannelList(pDirectory->nRxFrequencies, pDirectory->aRxFrequency);

    if(0 == pDirectory->nInitTimeout  ) pDirectory->nInitTimeout   = 2;
    if(0 == pDirectory->nOperTimeout  ) pDirectory->nOperTimeout   = 600;
    /* Aug-27-2013: BPV-5157 : 0 is a valid value for the following...
    //if(0 == pDirectory->nTwoWayTimeout) pDirectory->nTwoWayTimeout = 300;
    //if(0 == pDirectory->nOneWayTimeout) pDirectory->nOneWayTimeout = 1800;*/
    // Aug-27-2013: BPV-5157 : Force nTwoWayTimeout to 0 as per always online requirement...
    LOGINFO(HAL_MODULE_DSG,"%s(): BPV-5157: Setting pDirectory->nTwoWayTimeout = 0\n", __FUNCTION__);
    pDirectory->nTwoWayTimeout = 0;

    DsgSetTimer(kTdsg1Timeout, pDirectory->nInitTimeout  );
    DsgSetTimer(kTdsg2Timeout, pDirectory->nOperTimeout  );
    DsgSetTimer(kTdsg3Timeout, pDirectory->nTwoWayTimeout);
    DsgSetTimer(kTdsg4Timeout, pDirectory->nOneWayTimeout);

    if(bProcessTunnels)
    {
        int iTunnel = 0;

        vlg_bReceivedDsgDCDresponse = 1;
        vlBcmDsgCloseOldTunnels();
        
        for(iTunnel = 0; iTunnel < pDirectory->nCardEntries; iTunnel++)
        {
            vlBcmDsgOpenTunnel(pstDSG, pDirectory->aCardEntries[iTunnel].adsgFilter.macAddress,
                               (VL_DSG_CLIENT_ID_ENC_TYPE)0, 0,
                               NULL, &(pDirectory->aCardEntries[iTunnel].adsgFilter));
        }

        for(iTunnel = 0; iTunnel < pDirectory->nHostEntries; iTunnel++)
        {
            if(pstDSG->dsgDirectory.aHostEntries[iTunnel].clientId.bClientDisabled)
            {
                // Jul-14-2009: UCID classification support: UCID does not match so avoid opening this tunnel
                continue;
            }

            // changed: June-09-2008: use virtual adsg filter for extended channel host terminating flows
            vlBcmDsgOpenTunnel(pstDSG, pDirectory->aHostEntries[iTunnel].adsgFilter.macAddress,
                               pDirectory->aHostEntries[iTunnel].clientId.eEncodingType,
                               pDirectory->aHostEntries[iTunnel].clientId.nEncodedId,
                               NULL, &(pDirectory->aHostEntries[iTunnel].adsgFilter));
        }
    }
}

void vlBcmDsgSetAdvConfig(DSG_t *pstDSG)
{
    int iTunnel = 0;
    vlg_bReceivedDsgDCDresponse = 1;
    vlBcmDsgCloseOldTunnels();

    vlBcmDsgSetChannelList(pstDSG->dsgAdvConfig.nRxFrequencies, pstDSG->dsgAdvConfig.aRxFrequency);

    if(0 == pstDSG->dsgAdvConfig.nInitTimeout  ) pstDSG->dsgAdvConfig.nInitTimeout   = 2;
    if(0 == pstDSG->dsgAdvConfig.nOperTimeout  ) pstDSG->dsgAdvConfig.nOperTimeout   = 600;
    /* Aug-27-2013: BPV-5157 : 0 is a valid value for the following...
    //if(0 == pstDSG->dsgAdvConfig.nTwoWayTimeout) pstDSG->dsgAdvConfig.nTwoWayTimeout = 300;
    //if(0 == pstDSG->dsgAdvConfig.nOneWayTimeout) pstDSG->dsgAdvConfig.nOneWayTimeout = 1800;*/
    // Aug-27-2013: BPV-5157 : Force nTwoWayTimeout to 0 as per always online requirement...
    LOGINFO(HAL_MODULE_DSG,"%s(): BPV-5157: Setting pstDSG->dsgAdvConfig.nTwoWayTimeout = 0\n", __FUNCTION__);
    pstDSG->dsgAdvConfig.nTwoWayTimeout = 0;

    DsgSetTimer(kTdsg1Timeout, pstDSG->dsgAdvConfig.nInitTimeout  );
    DsgSetTimer(kTdsg2Timeout, pstDSG->dsgAdvConfig.nOperTimeout  );
    DsgSetTimer(kTdsg3Timeout, pstDSG->dsgAdvConfig.nTwoWayTimeout);
    DsgSetTimer(kTdsg4Timeout, pstDSG->dsgAdvConfig.nOneWayTimeout);

    for(iTunnel = 0; iTunnel < pstDSG->dsgAdvConfig.nTunnelFilters; iTunnel++)
    {
        vlBcmDsgOpenTunnel(pstDSG, pstDSG->dsgAdvConfig.aTunnelFilters[iTunnel].dsgMacAddress,
                           (pstDSG->dsgAdvConfig.aTunnelFilters[iTunnel].nAppId?VL_DSG_CLIENT_ID_ENC_TYPE_APP:(VL_DSG_CLIENT_ID_ENC_TYPE)0),
                           pstDSG->dsgAdvConfig.aTunnelFilters[iTunnel].nAppId,
                           &(pstDSG->dsgAdvConfig.aTunnelFilters[iTunnel]), NULL);
    }
}

int HAL_DSG_ProcessControlMessage(DSG_t *pstDSG, unsigned char *pCtrlMsgData, unsigned short dataLength)
{
    LOGDEBUG(HAL_MODULE_DSG,"%s():DSG pstDSG %p : pCtrlMsgData %p dataLength %u \n", __FUNCTION__, (void *)pstDSG, pCtrlMsgData, dataLength);
    // Changed: June-09-2008: Moved implementation to vlDsgSetConfig()
    vlBcmPrintDsgStatus(NULL);
    return HAL_SUCCESS;
}

int vlBcmDsgSetDhcpOption43(void *data, int dataLen)
{
    LOGDEBUG(HAL_MODULE_DSG,"%s():DSG DsgSetDhcpOption43  Length=%d\n", __FUNCTION__,dataLen );
    
    if((NULL != data) && (dataLen > 0))
    {
        //Not implemented vlMpeosDumpBuffer(MPE_LOG_INFO, MPE_MOD_POD, data, dataLen);

    #if 1//!defined(USE_PACE_MFR) && !defined(USE_SAM_MFR) // need to use a SOC #define instead of a OEM #define
        if (false == DsgSetDhcpOption43(data, dataLen))
        {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: DsgSetDhcpOption43 return failure.\n", __FUNCTION__);
        }
    #endif
    }
    else
    {
        LOGERROR(HAL_MODULE_DSG,"%s(): ERROR: DSG DsgSetDhcpOption43  Length=%d, pBytes = 0x%08X\n", __FUNCTION__,dataLen, data);
     }
    return HAL_SUCCESS;
}

int vlBcmDsgSetDhcpOption17(void *data, int dataLen)
{
    LOGDEBUG(HAL_MODULE_DSG,"%s():DSG DsgSetDhcpV6Option17  Length=%d\n", __FUNCTION__,dataLen );
    
    if((NULL != data) && (dataLen > 0))
    {
        //Not implemented vlMpeosDumpBuffer(MPE_LOG_INFO, MPE_MOD_POD, data, dataLen);

    #if 1//!defined(USE_PACE_MFR) && !defined(USE_SAM_MFR) // need to use a SOC #define instead of a OEM #define
        if (false == DsgSetDhcpV6Option17(data, dataLen))
        {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: DsgSetDhcpV6Option17 return failure.\n", __FUNCTION__);
        }
    #endif
    }
    else
    {
        LOGERROR(HAL_MODULE_DSG,"%s(): ERROR: DSG DsgSetDhcpV6Option17  Length=%d, pBytes = 0x%08X\n", __FUNCTION__,dataLen, data);
     }
    return HAL_SUCCESS;
}

/*-----------------------------------------------------------------*/
#endif // USE_DSG
/*-----------------------------------------------------------------*/
