/*
* ============================================================================
* RDK MANAGEMENT, LLC CONFIDENTIAL AND PROPRIETARY
* ============================================================================
* This file (and its contents) are the intellectual property of RDK Management, LLC.
* It may not be used, copied, distributed or otherwise  disclosed in whole or in
* part without the express written permission of RDK Management, LLC.
* ============================================================================
* Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
* Copyright (c) 2017 RDK Management, LLC. All rights reserved.
* ============================================================================
*/

///////////////////////////////////////////////////////////
//  rmf_SectionFilter_DSG_APPID.cpp
//  Implementation of the Class rmf_SectionFilter_DSG_APPID
//  Created on:      20-Jul-2012 12:35:05 PM
//  Original author: Sunil S
///////////////////////////////////////////////////////////
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <netdb.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <assert.h>
#include <rdk_debug.h>
#include <rmf_osal_mem.h>
#include <rmf_osal_thread.h>
#include <rmf_osal_sync.h>
#include <rmf_osal_error.h>
#include <rmf_osal_util.h>
#include "rmf_sectionfilter_dsg_appid.h"

// the port client will be connecting to
#define PORT 1234

// max number of bytes we can get at once
#define MAXDATASIZE 1024

static FILE *fptr = NULL;

#define  BLOCK_SIZE 1050

#define DEBUG_WARN printf
#define DEBUG_ERROR printf
#define DEBUG_INFO

typedef struct rmfdsgClientData{
int ibuffSize;
unsigned char buffer[BLOCK_SIZE];
}TDSGDATA;

static unsigned long RegistrationId = 0x12341234;

#define DEFAULT_IP "127.0.0.1"

VL_DSG_CLIENT_CBFUNC_t rmf_SectionFilter_DSG_APPID::dsgCallback;
unsigned long rmf_SectionFilter_DSG_APPID::dsgclientAppData;
unsigned long long rmf_SectionFilter_DSG_APPID::dsgClientId;
int rmf_SectionFilter_DSG_APPID::nSect_Count;
VL_DSG_CLIENT_ID_ENC_TYPE rmf_SectionFilter_DSG_APPID::dsgeClientType;
//DsgTunnelSession* rmf_SectionFilter_OOB::st_pDsgTunnelSessionList[MAX_OOB_SESSION] = {NULL, NULL, NULL, NULL, NULL};

rmf_SectionFilter_DSG_APPID::rmf_SectionFilter_DSG_APPID(void* pFilterParam):rmf_SectionFilter(pFilterParam)
{

    int i=0;

#ifdef USE_DSGSIMi
    m_SourceID = 0x1234;
#else
    m_SourceID = *((uint32_t*)pFilterParam);
#endif

    bOOBCopied = FALSE;
    pOOBFile = NULL;
    nSect_Count = 10000;
    for (i = 0; i < MAX_OOB_SESSION; i++)
     st_pDsgTunnelSessionList[i] = NULL;
}

rmf_SectionFilter_DSG_APPID::~rmf_SectionFilter_DSG_APPID()
{
        bOOBCopied = FALSE;
        pOOBFile = NULL;
        nSect_Count = 10000;
}

int rmf_SectionFilter_DSG_APPID::stDsgAppTunnelCallback(unsigned long RegistrationId,
                                unsigned long AppData,
                                VL_DSG_CLIENT_ID_ENC_TYPE eClientType,
                                unsigned long long        nClientId,
                                unsigned long             nBytes,
                                unsigned char*            pData)
{
        DsgTunnelSession  *pTunnelSession = (DsgTunnelSession*)AppData;
        RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER", "pTunnelSession: 0x%x\n", pTunnelSession);
        rmf_SectionFilter_DSG_APPID *pDsgSectionFilter = (rmf_SectionFilter_DSG_APPID*)pTunnelSession->m_pData;
        RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER", "pDsgSectionFilter: 0x%x\n", pDsgSectionFilter);
        
	return pDsgSectionFilter->stDsgAppTunnelCallbackfn(RegistrationId,
                                    AppData,
                                    eClientType,
                                    nClientId,
                                    nBytes,
                                    pData);
    
}

void rmf_SectionFilter_DSG_APPID::DsgClientThread(void *data)
{
    rmf_SectionFilter_DSG_APPID *pDsgSectionFilter = (rmf_SectionFilter_DSG_APPID*)data;
    pDsgSectionFilter->DsgClientThreadFn();
}

void rmf_SectionFilter_DSG_APPID::DsgClientThreadFn()
{
    int sockfd=0, numbytes=0;
    char SIM_SERVER_IP[20];
        const char *ptr;
    FILE* fp;
    char simConfFileBuf[256];
    
    struct hostent *he=NULL;
    struct sockaddr_in their_addr;
        rmf_Error retOsal = RMF_SUCCESS;
/*  
    fp = fopen("/etc/OobSimulatorConfigure","r");
        if(fp == NULL)
        {
          RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.FILTER", "\n Please create file OobSimulatorConfigure @ /opt/ramdisk/etc/ \n");
          return;
        }
    fgets(simConfFileBuf, 256, fp);
    while(NULL == strstr(simConfFileBuf, "SIM_SERVER_IP="))
    {
        fgets(simConfFileBuf, 256, fp);
    }
    strcpy(SIM_SERVER_IP, simConfFileBuf+strlen("SIM_SERVER_IP="));
    
    int i=0;
    while(SIM_SERVER_IP[i] != 0x0A)
        i++;
    SIM_SERVER_IP[i] = 0;
*/
    
    ptr = rmf_osal_envGet("VL_SIM_SERV_IP");
    
    if (NULL != ptr)
    {
        strcpy(SIM_SERVER_IP, ptr);
    }
    else
    {
        strcpy(SIM_SERVER_IP, DEFAULT_IP);
    }
    
        RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER","\n %s:: serverIp = '%s' !!!!!\n", __FUNCTION__,SIM_SERVER_IP);
        RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER","\nCalling DSG Client Simulator Register Function !!!!!\n");
    // get the host info
    if((he=gethostbyname(/*"192.168.1.196"*/SIM_SERVER_IP)) == NULL)
    {
        perror("gethostbyname()");
        return; //RegistrationId;
    }
    else
    {
          RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER","Client-The remote host is\n");
    }
    
    if((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1)
    {
        perror("socket()");
        return; //RegistrationId;
    }
    else
    {
          RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER","Client-The socket() sockfd is OK...\n");
    }
    
    // host byte order
    their_addr.sin_family = AF_INET;
    
    // short, network byte order
    their_addr.sin_port = htons(PORT);
    their_addr.sin_addr = *((struct in_addr *)he->h_addr);
    // zero the rest of the struct
    memset(&(their_addr.sin_zero), '\0', 8);
    
    if(connect(sockfd, (struct sockaddr *)&their_addr, sizeof(struct sockaddr)) == -1)
    {
    perror("connect()");
    close(sockfd);
    return; //RegistrationId;
    }
    else
    {
          RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER","Client-The connect() is OK...\n");
    }
    
    //fptr = fopen("test","w+b");
    void *buf = NULL;
    int iReadSize = sizeof(TDSGDATA);
    TDSGDATA *pDsgData = NULL;
    //buf = vlMalloc(iReadSize);
        retOsal = rmf_osal_memAllocP(RMF_OSAL_MEM_FILTER, iReadSize, &buf);
        if((RMF_SUCCESS != retOsal) || (NULL == buf))
        {
            close(sockfd);
            RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER", "Malloc failed for buf...\n");
            return;
        }

    while(1)
    {
        if((numbytes = recv(sockfd, buf, iReadSize, 0)) == -1)
        {
            rmf_osal_memFreeP(RMF_OSAL_MEM_FILTER, buf);
            perror("recv()");
            break;
        }
        else
        {
            pDsgData = (TDSGDATA *)buf;
            
            dsgCallback(RegistrationId,dsgclientAppData,dsgeClientType,dsgClientId,pDsgData->ibuffSize,pDsgData->buffer);
            
            //RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.FILTER", "Client-The recv() is OK...%d\n",pbvlDsgData->ibuffSize);
            #if 0 //for verification of send data
            char bufsize[4];
            memset(bufsize,'\0',sizeof(bufsize));
            sprintf(bufsize,"[%d]",pbvlDsgData->ibuffSize);
            fwrite(pbvlDsgData->buffer,1,pbvlDsgData->ibuffSize,fptr);
            fwrite(bufsize,1,strlen(bufsize),fptr);
            #endif
        }
    }
//    if(buf)
  //      rmf_osal_memFreeP(RMF_OSAL_MEM_FILTER, buf);
    fclose(fptr);
        RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER","\nClient-Closing sockfd\n");
    close(sockfd);
    return; //RegistrationId;
}

unsigned long rmf_SectionFilter_DSG_APPID::DsgRegisterClientSim(VL_DSG_CLIENT_CBFUNC_t pfClientCB,
                                  unsigned long       nAppData,
                                  VL_DSG_CLIENT_ID_ENC_TYPE eClientType,
                                  unsigned long long  nClientId)

{
    //pthread_t vldlgClient;
    //Store client information
    dsgCallback = pfClientCB;
    dsgclientAppData = nAppData;
    dsgClientId = nClientId;
    dsgeClientType = eClientType;
    //Create a thread and return
    static rmf_osal_ThreadId     DsgClientThreadId = 0;
    rmf_Error  ret;

    ret = rmf_osal_threadCreate(DsgClientThread,
                       this,
                       RMF_OSAL_THREAD_PRIOR_DFLT,
                       RMF_OSAL_THREAD_STACK_SIZE,
                       &DsgClientThreadId,
                       "DsgClientThread");

    if ( RMF_SUCCESS != ret ) {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.FILTER","<%s: %d> - DsgClientThread can't be created. FATAL ERROR!!!.\n", __FUNCTION__, __LINE__);
    }

    return RegistrationId;  
}

void rmf_SectionFilter_DSG_APPID::AddPidTotheList(uint8_t pid, unsigned long RegistrationId)
{
    int i = 0;

    DsgTunnelSession  *pTunnelSession = getTunnelSessionForClientId(RegistrationId);

    if (NULL == pTunnelSession)
        return;

    LockPidList(pTunnelSession);

    for (i =0; i < DSG_MAX_PID_FILTER; i++)
    {
        if (SECITON_FILTER_AVAILABLE == pTunnelSession->m_pidList[i].PidListStatus)
        {
            pTunnelSession->m_pidList[i].PidListStatus = SECITON_FILTER_INUSE;
            pTunnelSession->m_pidList[i].pid = pid;
            break;
        }
    }

    UnLockPidList(pTunnelSession);
    return;
}


void rmf_SectionFilter_DSG_APPID::RemovePidFromTheList(uint8_t pid, unsigned long RegistrationId)
{
    int i = 0;
    DsgTunnelSession  *pTunnelSession = getTunnelSessionForClientId(RegistrationId);

    if (NULL == pTunnelSession)
        return;

    LockPidList(pTunnelSession);

    for (i =0; i < DSG_MAX_PID_FILTER; i++)
    {
        if (SECITON_FILTER_INUSE == pTunnelSession->m_pidList[i].PidListStatus)
        {
            if (pTunnelSession->m_pidList[i].pid == pid)
            {
                pTunnelSession->m_pidList[i].PidListStatus = SECITON_FILTER_AVAILABLE;
                pTunnelSession->m_pidList[i].pid = -1;
                break;
            }
        }
    }

    UnLockPidList(pTunnelSession);
    return;
}

void rmf_SectionFilter_DSG_APPID::AddTunnelSessionTotheList(DsgTunnelSession* pSession)
{
    int i = 0;
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.FILTER","AddTunnelSessionTotheList Called\n");
    for (i = 0; i < MAX_OOB_SESSION; i++)
    {
        if (NULL == st_pDsgTunnelSessionList[i])
        {
            st_pDsgTunnelSessionList[i] = pSession;
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.FILTER","Session Added at Index %d\n ", i);
            return;
        }
    }

    RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.FILTER", " st_pDsgTunnelSessionList Full\n");
    return; 
}


DsgTunnelSession* rmf_SectionFilter_DSG_APPID::getTunnelSessionForAppId(int appId)
{
    int i = 0;
    for (i = 0; i < MAX_OOB_SESSION; i++)
    {
        if (NULL != st_pDsgTunnelSessionList[i])
        {
            if (st_pDsgTunnelSessionList[i]->m_dsgAppId == appId)
            {
                return st_pDsgTunnelSessionList[i];
            }
        }
    }
    
    return NULL;    
}

DsgTunnelSession* rmf_SectionFilter_DSG_APPID::getTunnelSessionForClientId(int clientId)
{
    int i = 0;
    for (i = 0; i < MAX_OOB_SESSION; i++)
    {
        if (NULL != st_pDsgTunnelSessionList[i])
        {
            if (st_pDsgTunnelSessionList[i]->m_nRegistrationId == clientId)
            {
                return st_pDsgTunnelSessionList[i];
            }
        }
    }
    
    return NULL;
}

DsgTunnelSession* rmf_SectionFilter_DSG_APPID::InitializeTunnel()
{
        rmf_Error retOsal = RMF_SUCCESS;
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.FILTER","%s:: Called\n", __FUNCTION__);

    //  check if Session exist for the same appId

    DsgTunnelSession* pTunnelSession = getTunnelSessionForAppId(m_SourceID);
    if (NULL != pTunnelSession)
        return pTunnelSession;

    retOsal = rmf_osal_memAllocP(RMF_OSAL_MEM_FILTER, sizeof(DsgTunnelSession), (void**)&pTunnelSession);
    if ((NULL == pTunnelSession) || (RMF_SUCCESS != retOsal))
        return pTunnelSession;

    memset(pTunnelSession, 0, sizeof(DsgTunnelSession));

    pTunnelSession->m_dsgAppId = m_SourceID;

   // const char * oobSectionCapturePath = rmf_osal_envGet("VL_OOB_CAPTURE_FILE_PATH");
    const char * oobSectionCapturePath = "/opt/dsg_appid_sectionData_Capture.bin";
    if (NULL == oobSectionCapturePath)
    {
        bOOBCopied = TRUE;
    }
    else
    {
        if ( (access(oobSectionCapturePath, F_OK) != -1) && NULL == pOOBFile)
        { 
            pOOBFile = fopen(oobSectionCapturePath, "a+");  
        }
        else
        {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.FILTER","%s: dsg_appid_oobSectionCapturePath file doesn't exists", __FUNCTION__);
        }
    }

    const char * oobSectionCnt = rmf_osal_envGet("VL_OOB_CAPTURE_SECTION_COUNT");
    if (NULL != oobSectionCnt)
    {
        nSect_Count = atoi(oobSectionCnt);
    }

    const char * ptr = rmf_osal_envGet("VL_SIM_SERV_IP");

    pTunnelSession->m_pData = (void*)this;
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.FILTER", "pTunnelSession: 0x%x, pTunnelSession->m_pData: 0x%x\n", pTunnelSession, pTunnelSession->m_pData);
    if (NULL != ptr)
    {
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.FILTER","Going to Simulator AppId is %d\n", pTunnelSession->m_dsgAppId);

        //DsgSimulator
        pTunnelSession->m_nRegistrationId = DsgRegisterClientSim(stDsgAppTunnelCallback, 
                                                (unsigned long)pTunnelSession,
                                                VL_DSG_CLIENT_ID_ENC_TYPE_APP, pTunnelSession->m_dsgAppId);
    }
    else
    {
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.FILTER","Going to ExtChannel AppId is %d\n", pTunnelSession->m_dsgAppId);

        //ExtChannel
        pTunnelSession->m_nRegistrationId = vlDsgRegisterClient(stDsgAppTunnelCallback, 
                                                (unsigned long)pTunnelSession,
                                                VL_DSG_CLIENT_ID_ENC_TYPE_APP, pTunnelSession->m_dsgAppId);
    }

    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.FILTER","%s:: After calling vlDsgRegisterClientSim\n", __FUNCTION__);
    if (0 == pTunnelSession->m_nRegistrationId)
    {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.FILTER","vlDsgRegisterClient Connection refused \n");
        rmf_osal_memFreeP(RMF_OSAL_MEM_FILTER, pTunnelSession);
        pTunnelSession = NULL;
    }
    else
    {
        // Tunnel Creation Success
        // Add the new pTunnelSession to the list
        AddTunnelSessionTotheList(pTunnelSession);
    //  create pidList Mutex
        int i =0;
        for(i = 0; i < DSG_MAX_SECITON_FILTER; i++)
        {
            pTunnelSession->m_sectionFilterList[i].filterStatus = SECITON_FILTER_AVAILABLE;
        }

        for (i = 0; i < DSG_MAX_PID_FILTER; i++)
        {
            pTunnelSession->m_pidList[i].PidListStatus = SECITON_FILTER_AVAILABLE;
        }

    /*  if(pthread_mutex_init(&(pTunnelSession->m_pidListMutex), NULL) != MPE_SUCCESS)
        {
            RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER", "%s:: Could not create m_sfMutex\n", __FUNCTION__);
            //return VL_SECTFLT_Error;
        }

        //  create pidList Mutex
        if(pthread_mutex_init(&(pTunnelSession->m_sfListMutex), NULL) != MPE_SUCCESS)
        {
            RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER", "%s:: Could not create m_sfMutex\n", __FUNCTION__);
            //return VL_SECTFLT_Error;
        }*/
        if(RMF_SUCCESS != rmf_osal_mutexNew(&(pTunnelSession->m_pidListMutex)))
        {
            RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER", "%s:: Could not create m_pidListMutex\n", __FUNCTION__);
        }
        
        if(RMF_SUCCESS != rmf_osal_mutexNew(&(pTunnelSession->m_sfListMutex)))
        {
            RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER", "%s:: Could not create m_sfListMutex\n", __FUNCTION__);
        }
    }
    
    return pTunnelSession;
}

bool rmf_SectionFilter_DSG_APPID::IsARegisteredPid(uint8_t pid, unsigned long RegistrationId)
{
    int i = 0;

    DsgTunnelSession  *pTunnelSession = getTunnelSessionForClientId(RegistrationId);

    if (NULL == pTunnelSession)
        return false;

    LockPidList(pTunnelSession);

    for (i =0; i < DSG_MAX_PID_FILTER; i++)
    {
        if (SECITON_FILTER_INUSE == pTunnelSession->m_pidList[i].PidListStatus)
        {
            if(pTunnelSession->m_pidList[i].pid == pid)
            {
                UnLockPidList(pTunnelSession);
                return true;
            }
        }
    }

    UnLockPidList(pTunnelSession);
    return false;
}

int rmf_SectionFilter_DSG_APPID::sw_filter(unsigned char *pData, int dataLen, SectionFilterParams     *pFilterParams)
{
        unsigned char xor_val = 0;
        unsigned char neq = 0;
        unsigned char doneq = 0;
        int passp = 1;
        int passn = 1;
        int i;

        if ( (NULL == pData) || (NULL == pFilterParams) || (0 == dataLen))
        {
                return false;
        }

        // Apply pos filter & mask

        if ( (NULL != pFilterParams->pos_value) && (NULL != pFilterParams->pos_mask))
        {
                for (i=0; i<pFilterParams->pos_length; i++)
                {
                        xor_val = (pFilterParams->pos_value[i] ^ pData[i]);
                        if ((pFilterParams->pos_mask[i] != 0 ) && (pFilterParams->pos_mask[i] & xor_val))
                        {
                                passp = 0;
                                break;
                        }
                }
        }


        if ( (NULL != pFilterParams->neg_value) && (NULL != pFilterParams->neg_mask))
        {
                for (i=0; i<pFilterParams->neg_length; i++)
                {
                        xor_val = (pFilterParams->neg_value[i] ^ pData[i]);
                        neq |= pFilterParams->neg_mask[i] & xor_val;
                        doneq |= pFilterParams->neg_mask[i];
                }

                if (doneq && !neq)
                {
                        passn = 0;
                }
        }


        return (passp && passn);
}

void rmf_SectionFilter_DSG_APPID::DispatchSectionData(unsigned char *pData, int dataLen, unsigned long RegistrationId)
{
    rmf_Error retOsal = RMF_SUCCESS;
    rmf_Section_Data *pSectionData = NULL;

    DsgTunnelSession  *pTunnelSession = getTunnelSessionForClientId(RegistrationId);
    if (NULL == pTunnelSession)
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.FILTER"," %s No Tunnel Session exist for RegistrationId %d", __FUNCTION__, RegistrationId);
        return;
    }

#if 1

    if (!bOOBCopied)
    {
        char buffer[50];
        memset(buffer, 0, 50);
        sprintf(buffer, "Number of Bytes_%d", dataLen);
        //RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.FILTER", "DispatchSectionData got %d Bytes of data\n Data:", dataLen);
        RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER","%s: got %d Bytes of data\n Data:", __FUNCTION__,dataLen);
        nSect_Count--;

        if (NULL != pOOBFile)
        {
            fwrite(buffer, 1, 50, pOOBFile);
            fwrite(pData, 1, dataLen, pOOBFile);
            fflush(pOOBFile);
            if (nSect_Count <= 0)
            {
                bOOBCopied = TRUE;
                fclose(pOOBFile);
                pOOBFile = NULL;
                //RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.FILTER", "DispatchSectionData : FINISHED Capturing to FILE\n");
                RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER","%s: FINISHED Capturing to FILE\n");
            }
        }
    }
#endif

    LocksfList(pTunnelSession); 
    if (pData[0] == 0xc5) {
        int i = 0;
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.FILTER", "=====XONE-2300: DSG SF Status DUMP====\r\n");
        for (i = 0; i < DSG_MAX_SECITON_FILTER; i++)
        {
            RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.FILTER", "==[%d]: [status=%d][handle=%d]--\r\n", 
                    i, 
                    pTunnelSession->m_sectionFilterList[i].filterStatus,
                    pTunnelSession->m_sectionFilterList[i].SectionFilterHandle);
        }
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.FILTER","=====XONE-2300: DSG SF Status DONE====\r\n");

    }

    int i;      
    for (i = 0; i < DSG_MAX_SECITON_FILTER; i++)
    {
        if (SECITON_FILTER_INUSE == pTunnelSession->m_sectionFilterList[i].filterStatus)
        {
            if (sw_filter(pData, dataLen, &(pTunnelSession->m_sectionFilterList[i].filterParams)))
            {
		   retOsal = rmf_osal_memAllocP(RMF_OSAL_MEM_FILTER, sizeof(rmf_Section_Data), (void**)&pSectionData);
		   if((pSectionData == NULL) || (retOsal != RMF_SUCCESS))
                    break;
		   memset(pSectionData, 0x0, sizeof(rmf_Section_Data));
                retOsal = rmf_osal_memAllocP(RMF_OSAL_MEM_FILTER, MAX_SECTION_SIZE, (void**)&(pSectionData->sectionData));
                //retOsal = rmf_osal_memAllocP(RMF_OSAL_MEM_FILTER, dataLen, (void**)&(pSectionData->sectionData));
                if((pSectionData->sectionData == NULL) || (retOsal != RMF_SUCCESS))
		{
		    rmf_osal_memFreeP(RMF_OSAL_MEM_FILTER, pSectionData);
                    break;
		}

                pSectionData->sectionID = getNextSectionID(); // This function has to be protected.
                if (dataLen > MAX_SECTION_SIZE)
                {
                    dataLen = MAX_SECTION_SIZE;
                }

                memcpy(pSectionData->sectionData, pData, dataLen);
                pSectionData->sectionLength = dataLen;

                RDK_LOG(RDK_LOG_TRACE5, "LOG.RDK.FILTER","%s:: calling section_avail_cb for TableID =  0x%x FilterHandle %d : \n", __FUNCTION__, pSectionData->sectionData[0], pTunnelSession->m_sectionFilterList[i].SectionFilterHandle);
                if (pSectionData->sectionData[0] == 0xc5) 
                    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.FILTER", "%s:: calling section_avail_cb for TableID =  0x%x FilterHandle %d : \n", __FUNCTION__, pSectionData->sectionData[0], pTunnelSession->m_sectionFilterList[i].SectionFilterHandle);

                //DumpBuffer(pSectionData->sectionData, dataLen);

                UnLocksfList(pTunnelSession);
                section_avail_cb(pTunnelSession->m_sectionFilterList[i].SectionFilterHandle, pSectionData);
                LocksfList(pTunnelSession);
            }
        }
    }

    UnLocksfList(pTunnelSession);
}

void rmf_SectionFilter_DSG_APPID::LockPidList(DsgTunnelSession* pDsgTunnelSession)
{
    //pthread_mutex_lock(&(pDsgTunnelSession->m_pidListMutex));
        rmf_osal_mutexAcquire(pDsgTunnelSession->m_pidListMutex);
}

void rmf_SectionFilter_DSG_APPID::UnLockPidList(DsgTunnelSession* pDsgTunnelSession)
{
    //pthread_mutex_unlock(&(pDsgTunnelSession->m_pidListMutex));
        rmf_osal_mutexRelease(pDsgTunnelSession->m_pidListMutex);
}

void rmf_SectionFilter_DSG_APPID::LocksfList(DsgTunnelSession* pDsgTunnelSession)
{
    //pthread_mutex_lock(&(pDsgTunnelSession->m_sfListMutex));
        rmf_osal_mutexAcquire(pDsgTunnelSession->m_sfListMutex);
}

void rmf_SectionFilter_DSG_APPID::UnLocksfList(DsgTunnelSession* pDsgTunnelSession)
{
    //pthread_mutex_unlock(&(pDsgTunnelSession->m_sfListMutex));
        rmf_osal_mutexRelease(pDsgTunnelSession->m_sfListMutex);
}

int rmf_SectionFilter_DSG_APPID::stDsgAppTunnelCallbackfn(unsigned long             RegistrationId,
                            unsigned long             AppData,
                            VL_DSG_CLIENT_ID_ENC_TYPE eClientType,
                            unsigned long long        nClientId,
                            unsigned long             nBytes,
                            unsigned char*            pData)
{

/* Simulator assume that only one Tunnel is created 
    if (AppData)
        ((CDSGAppTunnelFlow *)AppData)->DsgAppTunnelCallback(RegistrationId, AppData, eClientType, nClientId, nBytes, pData);
*/
    //TODO: Process the data
// The pDate contains DSG_Carousel Header followed by the mpeg Section
// pData - [0-1] -  (Version), thirdBit (reserved) Next13 bit = PID
    //usleep(10*4000);
    usleep(1000);
//  bool bCopied = FALSE;
//  int blockNumber = 0;
//  int moduleId = 0;
//  int adpLength = 0;
//  unsigned char *ptmpData = NULL;

    if ((NULL == pData) || (0 == nBytes))
    {
        return -1;
    }

    unsigned short mpegTrPID = ((pData[0] & 0x1F) << 8) | pData[1];

//  int mpegTrPID = [3-15] bit of pData;
//  This is only to optimize DSM-CC handling.
//  As a general

    if (!IsARegisteredPid(mpegTrPID, RegistrationId))
    {
        //DEBUG_ERROR("isARegisteredPid Returned NO for pid %d\n", mpegTrPID);
        return -1;
    }


    pData+=2;

    nBytes = nBytes-2;

    if (nBytes > MAX_SECTION_SIZE)
        nBytes = MAX_SECTION_SIZE;

    DispatchSectionData(pData, nBytes, RegistrationId);

    return 0;
}

RMF_SECTFLT_RESULT rmf_SectionFilter_DSG_APPID::DSG_OpenTunnelFlow(Dsg_SectionFilter_Info_t *pDsgFilterInfo)
{
// In the simulator case we are not maintaing multiple tunnel.
// Assuming that there is only one DSG Tunnel Available.
    //Dsg_SectionFilter_Info_t *pDsgFilterInfo = NULL;
    DsgTunnelSession  *pTunnelSession = NULL;
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.FILTER","%s:: Called\n", __FUNCTION__);

    //pDsgFilterInfo =  (Dsg_SectionFilter_Info_t*)(m_pSectionFilterInfo);
    if(NULL == pDsgFilterInfo)
    {
        return RMF_SECTFLT_InvalidParams;           
    }

    pDsgFilterInfo->m_ulPid                 =  -1;
    pDsgFilterInfo->m_SectionFilterHandle   =  -1;

    // Tunnel is NOT active. Create One now..
    pTunnelSession = InitializeTunnel();

    if (NULL == pTunnelSession)
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.FILTER","Failed to create the Tunnel\n");
        return RMF_SECTFLT_Error;
    }

    pDsgFilterInfo->m_nRegistrationId   =   pTunnelSession->m_nRegistrationId;

    return RMF_SECTFLT_Success;
}

RMF_SECTFLT_RESULT rmf_SectionFilter_DSG_APPID::DSG_StartPidFilter(Dsg_SectionFilter_Info_t* pDsgFilterInfo, uint8_t pid)
{
    
    //Dsg_SectionFilter_Info_t *pDsgFilterInfo = NULL;
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.FILTER","%s:: Called\n", __FUNCTION__);

    //pDsgFilterInfo =  (Dsg_SectionFilter_Info_t*)m_pSectionFilterInfo;

    // Check whether an opened Tunnel Exist for the Section Filter Obj
    if (NULL != getTunnelSessionForClientId(pDsgFilterInfo->m_nRegistrationId))
//  if (pDsgFilterInfo->m_nRegistrationId == st_pDsgTunnelSession->m_nRegistrationId)
    {
        //Add this pid to the st_pDsgTunnelSession->m_pidList;
        AddPidTotheList(pid, pDsgFilterInfo->m_nRegistrationId);
        pDsgFilterInfo->m_ulPid = pid;
    }

    return RMF_SECTFLT_Success;
}

RMF_SECTFLT_RESULT rmf_SectionFilter_DSG_APPID::DSG_AddFilter(Dsg_SectionFilter_Info_t *pDsgFilterInfo, uint8_t* pos_mask, uint8_t* pos_value,  uint16_t pos_length,
                                        uint8_t* neg_mask, uint8_t* neg_value,  uint16_t neg_length)
{
    //Dsg_SectionFilter_Info_t *pDsgFilterInfo = NULL;
        rmf_Error retOsal = RMF_SUCCESS;

    int i = 0;
    bool bFound = false;
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.FILTER","%s:: Called\n", __FUNCTION__);

    //pDsgFilterInfo =  (Dsg_SectionFilter_Info_t*)m_pSectionFilterInfo;

    // Check whether an opened Tunnel Exist for the Section Filter Obj
    DsgTunnelSession  *pTunnelSession = getTunnelSessionForClientId(pDsgFilterInfo->m_nRegistrationId);
    if (NULL != pTunnelSession)
    {
        // Check whether m_sectionFilterList is full or not 
        // if not full create get the SectionFilterInfo slot, i,  from m_sectionFilterList
        LocksfList(pTunnelSession);
        for (i = 0; i < DSG_MAX_SECITON_FILTER; i++)
        {
            if (SECITON_FILTER_AVAILABLE == pTunnelSession->m_sectionFilterList[i].filterStatus)
            {
                bFound = true;
                break;
            }
        }
        
        if (!bFound)
        {
            UnLocksfList(pTunnelSession);
            return RMF_SECTFLT_NoFilterRes;
        }

        pTunnelSession->m_sectionFilterList[i].SectionFilterHandle = getNextSectionID();
        pDsgFilterInfo->m_SectionFilterHandle = pTunnelSession->m_sectionFilterList[i].SectionFilterHandle;
        
        if (pos_length > 0)
        {
            //pTunnelSession->m_sectionFilterList[i].filterParams.pos_mask = (uint8_t*) malloc(pos_length);
            retOsal = rmf_osal_memAllocP(RMF_OSAL_MEM_FILTER, pos_length, (void**)&(pTunnelSession->m_sectionFilterList[i].filterParams.pos_mask));
            if((retOsal != RMF_SUCCESS) || (pTunnelSession->m_sectionFilterList[i].filterParams.pos_mask == NULL))
            {
                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.FILTER","%s:: Malloc failed for pos_mask\n", __FUNCTION__);
                UnLocksfList(pTunnelSession);
                return RMF_SECTFLT_OutMem;
            }

            
            //pTunnelSession->m_sectionFilterList[i].filterParams.pos_value = (uint8_t*) malloc(pos_length);
            retOsal = rmf_osal_memAllocP(RMF_OSAL_MEM_FILTER, pos_length, (void**)&(pTunnelSession->m_sectionFilterList[i].filterParams.pos_value));
            if((retOsal != RMF_SUCCESS) || (pTunnelSession->m_sectionFilterList[i].filterParams.pos_value == NULL))
            {
                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.FILTER","%s:: Malloc failed for pos_value\n", __FUNCTION__);
                rmf_osal_memFreeP(RMF_OSAL_MEM_FILTER, pTunnelSession->m_sectionFilterList[i].filterParams.pos_mask);
                                pTunnelSession->m_sectionFilterList[i].filterParams.pos_mask = NULL;
                UnLocksfList(pTunnelSession);
                return RMF_SECTFLT_OutMem;
            }

            pTunnelSession->m_sectionFilterList[i].filterParams.pos_length = pos_length;
            
            memcpy(pTunnelSession->m_sectionFilterList[i].filterParams.pos_mask, pos_mask, pos_length);
            memcpy(pTunnelSession->m_sectionFilterList[i].filterParams.pos_value, pos_value, pos_length);
            
        }
        else
        {
            pTunnelSession->m_sectionFilterList[i].filterParams.pos_length  =   0;
            pTunnelSession->m_sectionFilterList[i].filterParams.pos_value   =   NULL;
            pTunnelSession->m_sectionFilterList[i].filterParams.pos_mask    =   NULL; 
        }
    

        if (neg_length > 0)
        {
            //pTunnelSession->m_sectionFilterList[i].filterParams.neg_mask = (uint8_t*) malloc(neg_length);
            retOsal = rmf_osal_memAllocP(RMF_OSAL_MEM_FILTER, neg_length, (void**)&(pTunnelSession->m_sectionFilterList[i].filterParams.neg_mask));
            if((retOsal != RMF_SUCCESS) || (pTunnelSession->m_sectionFilterList[i].filterParams.neg_mask == NULL))
            {
                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.FILTER","%s:: Malloc failed for pos_value\n", __FUNCTION__);
                rmf_osal_memFreeP(RMF_OSAL_MEM_FILTER, pTunnelSession->m_sectionFilterList[i].filterParams.pos_mask);
                                pTunnelSession->m_sectionFilterList[i].filterParams.pos_mask = NULL;
                rmf_osal_memFreeP(RMF_OSAL_MEM_FILTER, pTunnelSession->m_sectionFilterList[i].filterParams.pos_value);
                                pTunnelSession->m_sectionFilterList[i].filterParams.pos_value = NULL;
                UnLocksfList(pTunnelSession);
                return RMF_SECTFLT_OutMem;
            }

            
            //pTunnelSession->m_sectionFilterList[i].filterParams.neg_value = (uint8_t*) malloc(neg_length);
            retOsal = rmf_osal_memAllocP(RMF_OSAL_MEM_FILTER, neg_length, (void**)&(pTunnelSession->m_sectionFilterList[i].filterParams.neg_value));
            if((retOsal != RMF_SUCCESS) || (pTunnelSession->m_sectionFilterList[i].filterParams.neg_value == NULL))
            {
                rmf_osal_memFreeP(RMF_OSAL_MEM_FILTER, pTunnelSession->m_sectionFilterList[i].filterParams.pos_mask);
                                pTunnelSession->m_sectionFilterList[i].filterParams.pos_mask = NULL;
                rmf_osal_memFreeP(RMF_OSAL_MEM_FILTER, pTunnelSession->m_sectionFilterList[i].filterParams.pos_value);
                                pTunnelSession->m_sectionFilterList[i].filterParams.pos_value = NULL;
                rmf_osal_memFreeP(RMF_OSAL_MEM_FILTER, pTunnelSession->m_sectionFilterList[i].filterParams.neg_mask);
                                pTunnelSession->m_sectionFilterList[i].filterParams.neg_mask = NULL;
                UnLocksfList(pTunnelSession);
                return RMF_SECTFLT_OutMem;
            }

            pTunnelSession->m_sectionFilterList[i].filterParams.neg_length = neg_length;
        
            memcpy(pTunnelSession->m_sectionFilterList[i].filterParams.neg_mask, neg_mask, neg_length);
            memcpy(pTunnelSession->m_sectionFilterList[i].filterParams.neg_value, neg_value, neg_length);
        }
        else
        {
            pTunnelSession->m_sectionFilterList[i].filterParams.neg_length  =   0;
            pTunnelSession->m_sectionFilterList[i].filterParams.neg_mask    =   NULL;
            pTunnelSession->m_sectionFilterList[i].filterParams.neg_value   =   NULL;
        }
    
        pTunnelSession->m_sectionFilterList[i].filterStatus = SECITON_FILTER_INUSE;
        //pTunnelSession->m_sectionFilterList[i].pSectionFilterInstance = pSectionFilterObj;

        UnLocksfList(pTunnelSession);
//      PrintSectionData();
        return RMF_SECTFLT_Success;
    }
    else
    {
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.FILTER","DSG_AddFilter Failed No Tunnel existing\n");
        return RMF_SECTFLT_Error;
    }
}

RMF_SECTFLT_RESULT rmf_SectionFilter_DSG_APPID::DSG_RemoveFilter(Dsg_SectionFilter_Info_t *pDsgFilterInfo)
{
    // This function assume the DSG_StopPidFilter is already invoked

    //Dsg_SectionFilter_Info_t *pDsgFilterInfo = NULL;

    int i = 0;
//  bool bFound = false;


    //pDsgFilterInfo =  (Dsg_SectionFilter_Info_t*)m_pSectionFilterInfo;


    // Check whether an opened Tunnel Exist for the Section Filter Obj
    DsgTunnelSession  *pTunnelSession = getTunnelSessionForClientId(pDsgFilterInfo->m_nRegistrationId);
    //if(pDsgFilterInfo->m_nRegistrationId == st_pDsgTunnelSession->m_nRegistrationId)
    if (NULL != pTunnelSession)
    {
        LocksfList(pTunnelSession);
        // match the section Handle and remove the section entry
        for (i = 0; i < DSG_MAX_SECITON_FILTER; i++)
        {
            if (SECITON_FILTER_INUSE == pTunnelSession->m_sectionFilterList[i].filterStatus)
            {
                if( pDsgFilterInfo->m_SectionFilterHandle == 
                    pTunnelSession->m_sectionFilterList[i].SectionFilterHandle)
                {
                    pTunnelSession->m_sectionFilterList[i].filterStatus = SECITON_FILTER_AVAILABLE;

                    if (pTunnelSession->m_sectionFilterList[i].filterParams.pos_length > 0)
                    {
                        rmf_osal_memFreeP(RMF_OSAL_MEM_FILTER, pTunnelSession->m_sectionFilterList[i].filterParams.pos_mask);
                        pTunnelSession->m_sectionFilterList[i].filterParams.pos_mask = NULL;
                        
                        rmf_osal_memFreeP(RMF_OSAL_MEM_FILTER, pTunnelSession->m_sectionFilterList[i].filterParams.pos_value);
                        pTunnelSession->m_sectionFilterList[i].filterParams.pos_value = NULL;
                        
                        pTunnelSession->m_sectionFilterList[i].filterParams.pos_length = 0;
                    }

                    if (pTunnelSession->m_sectionFilterList[i].filterParams.neg_length > 0)
                    {
                        rmf_osal_memFreeP(RMF_OSAL_MEM_FILTER, pTunnelSession->m_sectionFilterList[i].filterParams.neg_mask);           
                        pTunnelSession->m_sectionFilterList[i].filterParams.neg_mask = NULL;
                        
                        rmf_osal_memFreeP(RMF_OSAL_MEM_FILTER, pTunnelSession->m_sectionFilterList[i].filterParams.neg_value);
                        pTunnelSession->m_sectionFilterList[i].filterParams.neg_value = NULL;
                        
                        pTunnelSession->m_sectionFilterList[i].filterParams.neg_length = 0;
                    }

                    //pTunnelSession->m_sectionFilterList[i].pSectionFilterInstance = NULL;
                }
            }
        }

        UnLocksfList(pTunnelSession);
    }
    return RMF_SECTFLT_Success;

}

RMF_SECTFLT_RESULT rmf_SectionFilter_DSG_APPID::DSG_StopPidFilter(Dsg_SectionFilter_Info_t *pDsgFilterInfo)
{
//  Dsg_SectionFilter_Info_t *pDsgFilterInfo =  (Dsg_SectionFilter_Info_t*)m_pSectionFilterInfo;

//  if (pDsgFilterInfo->m_ulPid == pid)
    {
        RemovePidFromTheList(pDsgFilterInfo->m_ulPid, pDsgFilterInfo->m_nRegistrationId);
    }
    return RMF_SECTFLT_Success;
}

RMF_SECTFLT_RESULT rmf_SectionFilter_DSG_APPID::DSG_CloseTunnelFlow(Dsg_SectionFilter_Info_t *pDsgFilterInfo)
{
    //Dsg_SectionFilter_Info_t *pDsgFilterInfo = NULL;

    //pDsgFilterInfo =  (Dsg_SectionFilter_Info_t*)m_pSectionFilterInfo;

    pDsgFilterInfo->m_ulPid                 =  -1;
    pDsgFilterInfo->m_SectionFilterHandle   =  -1;
    pDsgFilterInfo->m_nRegistrationId       =  -1;
    // Keep the Tunner open for further filtering....
    return RMF_SECTFLT_Success;
}


RMF_SECTFLT_RESULT rmf_SectionFilter_DSG_APPID::Create(uint16_t pid, uint8_t* pos_mask, uint8_t* pos_value, uint16_t pos_length, uint8_t* neg_mask, uint8_t* neg_value, uint16_t neg_length, void **pSectionFilterInfo, uint32_t* pFilterID){
//m_SourceID    
	/* abdu : Marked as POD to get the details of the memory consumed */
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD","%s:: Called : EXTERNAL_MEMORY_POOL_ALLOCATE\n", __FUNCTION__);

    RMF_SECTFLT_RESULT              returnCode          =   RMF_SECTFLT_Error;

    //  bool                            newFilterCreated    =   FALSE;
    Dsg_SectionFilter_Info_t        *pDsgFilterInfo     =   NULL;
        rmf_Error retOsal = RMF_SUCCESS;

#if 0
    if (m_filterState != SECTFLT_INITIALIZED)
    {
        //DEBUG_ERROR("Dsg_SECTFLT_Create:: (pSectionFilterObj->m_filterState != SECTFLT_INITIALIZED)\n");
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.FILTER","%s: m_filterState != SECTFLT_INITIALIZED\n",__FUNCTION__);
        return RMF_SECTFLT_Error;
    }
#endif

    rmf_osal_mutexAcquire(m_sfMutex);

    retOsal = rmf_osal_memAllocP(RMF_OSAL_MEM_FILTER, sizeof(Dsg_SectionFilter_Info_t), (void**)&pDsgFilterInfo);
        if((retOsal != RMF_SUCCESS) || (pDsgFilterInfo == NULL))
        {
             RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.FILTER", "%s: malloc failed for pDsgFilterInfo\n");
         rmf_osal_mutexRelease(m_sfMutex);
         //DEBUG_ERROR("Dsg_SECTFLT_Create:: FAILED pDsgFilterInfo == NULL \n");
             return RMF_SECTFLT_OutMem;
    }


    returnCode = DSG_OpenTunnelFlow(pDsgFilterInfo);

    if (RMF_SECTFLT_Success != returnCode)
    {
        rmf_osal_memFreeP(RMF_OSAL_MEM_FILTER, pDsgFilterInfo);
        rmf_osal_mutexRelease(m_sfMutex);
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.FILTER","DSG_OpenTunnelFlow Failed \n");
        return returnCode;
    }

    returnCode = DSG_StartPidFilter(pDsgFilterInfo, pid);
    if (RMF_SECTFLT_Success != returnCode)
    {
        DSG_CloseTunnelFlow(pDsgFilterInfo);
        rmf_osal_memFreeP(RMF_OSAL_MEM_FILTER, pDsgFilterInfo);
        rmf_osal_mutexRelease(m_sfMutex);
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.FILTER","DSG_StartPidFilter Failed \n");
        return returnCode;
    }

    returnCode = DSG_AddFilter(pDsgFilterInfo, pos_mask, pos_value, pos_length,
            neg_mask, neg_value, neg_length);
    if (RMF_SECTFLT_Success != returnCode)
    {
        DSG_StopPidFilter(pDsgFilterInfo);
        DSG_CloseTunnelFlow(pDsgFilterInfo);

        rmf_osal_memFreeP(RMF_OSAL_MEM_FILTER, pDsgFilterInfo);
        rmf_osal_mutexRelease(m_sfMutex);
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.FILTER","DSG_AddFilter Failed \n");
        return returnCode;
    }

    *pSectionFilterInfo = (void*)pDsgFilterInfo;
    *pFilterID = (uint32_t)pDsgFilterInfo->m_SectionFilterHandle;
    
    m_filterState = SECTFLT_CREATED;
    rmf_osal_mutexRelease(m_sfMutex);

    return RMF_SECTFLT_Success;
}

RMF_SECTFLT_RESULT rmf_SectionFilter_DSG_APPID::Start(uint32_t filterID, const rmf_FilterSpec *)
{
//    VL_SECTFLT_RESULT     returnCode  =   RMF_SECTFLT_Success;
    
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.FILTER","XONE-2300: Dsg_SECTFLT_Start Called for filterId=%d\n", filterID);
    rmf_osal_mutexAcquire(m_sfMutex);
    
    if (m_filterState != SECTFLT_CREATED)
    {
        rmf_osal_mutexRelease(m_sfMutex);
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.FILTER","Dsg_SECTFLT_Start:: filter not SECTFLT_CREATED\n");
        return RMF_SECTFLT_NotReady;
    }

    m_filterState = SECTFLT_STARTED;
    rmf_osal_mutexRelease(m_sfMutex);
    return RMF_SECTFLT_Success;
}


RMF_SECTFLT_RESULT rmf_SectionFilter_DSG_APPID::Release(uint32_t filterID){
        RMF_SECTFLT_RESULT  returnCode  =   RMF_SECTFLT_Success;
    Dsg_SectionFilter_Info_t                *pDsgFilterInfo         =       NULL;
    
    rmf_osal_mutexAcquire(m_sfMutex);

    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.FILTER","XONE-2300: Dsg_SECTFLT_Release Called for filterId=%d\n", filterID);

    pDsgFilterInfo = (Dsg_SectionFilter_Info_t *)get_section_filter_info(filterID); 
#if 0
    switch(m_filterState)
    {
        case SECTFLT_INITIALIZED:
            // Nothing to release
            returnCode = RMF_SECTFLT_Success;
            break;
        case SECTFLT_RELEASED:
            // Already in release state
            returnCode = RMF_SECTFLT_Success;
            break;

        case SECTFLT_STARTED:
            Stop(filterID);
            DSG_RemoveFilter(pDsgFilterInfo);
            DSG_StopPidFilter(pDsgFilterInfo);
            returnCode = RMF_SECTFLT_Success;
            break;

        case SECTFLT_STOPPED:
        case SECTFLT_CREATED:
            DSG_RemoveFilter(pDsgFilterInfo);
            DSG_StopPidFilter(pDsgFilterInfo);
            returnCode = RMF_SECTFLT_Success;
            break;

        default:
            returnCode = RMF_SECTFLT_Error;
            break;
    }
#endif
    // Check whether an opened Tunnel Exist for the Section Filter Obj
    DsgTunnelSession  *pTunnelSession = getTunnelSessionForClientId(pDsgFilterInfo->m_nRegistrationId);
    if (NULL != pTunnelSession)
    {
        RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER","%s::Calling Stop()\n", __FUNCTION__);
        Stop(filterID);

        RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER","%s::Calling DSG_RemoveFilter()\n", __FUNCTION__);
        DSG_RemoveFilter(pDsgFilterInfo);

        RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.FILTER","%s::Calling DSG_StopPidFilter\n", __FUNCTION__);
        DSG_StopPidFilter(pDsgFilterInfo);

        returnCode = RMF_SECTFLT_Success;
    }

    m_filterState = SECTFLT_RELEASED;
    
    rmf_osal_mutexRelease(m_sfMutex);
    
    return returnCode;
}


RMF_SECTFLT_RESULT rmf_SectionFilter_DSG_APPID::Stop(uint32_t filterID){    
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.FILTER","XONE-2300: Dsg_SECTFLT_Stop Called for filterId=%d\n", filterID);
    if (m_filterState != SECTFLT_STARTED)
    {
        return RMF_SECTFLT_NotStarted;
    }

    m_filterState = SECTFLT_STOPPED;
    
    return RMF_SECTFLT_Success;
}


RMF_SECTFLT_RESULT rmf_SectionFilter_DSG_APPID::Read(uint32_t filterID, rmf_Section_Data** ppSectionData){
    RMF_SECTFLT_RESULT  returnCode  =   RMF_SECTFLT_Success;
        rmf_sf_SectionRequest_t*         pFilter_Request         = NULL;

        // Find the section request structure
        //pFilter_Request = (rmf_sf_SectionRequest_t*)vl_symbolMapTable_lookup(m_sectionRequests, (VLSymbolMapKey)filterID);
        pFilter_Request = (rmf_sf_SectionRequest_t*)m_sectionRequests->Lookup((rmf_SymbolMapKey)filterID);

        // If we can not find the request, or if it has already been
        // canceled, let the caller know
        if (pFilter_Request == NULL || pFilter_Request->state == RMF_SF_REQSTATE_CANCELLED)
        {
                return RMF_SECTFLT_InvalidParams;
        }

#if 0
    *ppSectionData = (rmf_Section_Data*)queue_pop_head(pFilter_Request->sectionsDataQueue);
#else
    *ppSectionData = (rmf_Section_Data*)rmf_queue_pop_head(pFilter_Request->m_SectionsDataQueue);
#endif    
    return returnCode;
}
