/******************************************************************************
 *    (c)2010-2013 Broadcom Corporation
 *
 * This program is the proprietary software of Broadcom Corporation and/or its licensors,
 * and may only be used, duplicated, modified or distributed pursuant to the terms and
 * conditions of a separate, written license agreement executed between you and Broadcom
 * (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 * no license (express or implied), right to use, or waiver of any kind with respect to the
 * Software, and Broadcom expressly reserves all rights in and to the Software and all
 * intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 * HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 * NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 * Except as expressly set forth in the Authorized License,
 *
 * 1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 * secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 * and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 * 2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 * AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 * WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 * THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 * OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 * LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 * OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 * USE OR PERFORMANCE OF THE SOFTWARE.
 *
 * 3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 * LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 * EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 * USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 * ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 * LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 * ANY LIMITED REMEDY.
 *
 *****************************************************************************/

//#define DIRECT_ENABLE_DEBUG

#include <direct/LockWQ.h>

#include <core/Renderer.h>
#include <core/Task.h>
#include <core/Util.h>

extern "C" {

#include "bcm_config.h"

#include <directfb.h>

#include <direct/debug.h>
#include <direct/messages.h>

#include <core/surface_allocation.h>
#include <core/surface_pool.h>
#include <core/system.h>

#include <gfx/convert.h>

#include "bcmnexus_gfx.h"
#include "bcmnexus_pool.h"

}

#if BCM_DFB_USE_TASK_MANAGER

#include "M2MC_Core.h"
#include "M2MC_Task.h"


D_DEBUG_DOMAIN( M2MC_Core,         "M2MC/Core",         "M2MC Core" );

/*********************************************************************************************************************/

namespace Broadcom {


M2MCCore::M2MCCore( unsigned int index )
     :
     index( index ),
     checkpoint2d_count( 0 ),
     busy( false )
{

     /*Brcm system data structure maintained by system module */
     DFBBCMNEXUS *pBrcmDfb = (DFBBCMNEXUS *) dfb_system_data();

     hGfx2D = GET_GRAPHICS2Dn_HND(pBrcmDfb, index);

     D_DEBUG_AT(M2MC_Core,"%s: M2MCCore - index %d\n",__FUNCTION__,index);

     /* initialise the callback, and make sure it is part of the Master */
     NEXUS_Graphics2DSettings       settings;

     NEXUS_Graphics2D_GetSettings(hGfx2D, &settings);

     settings.blockedSync                 = false;
     settings.pollingCheckpoint           = false;
     settings.checkpointCallback.callback = M2MCCore::checkpoint2D;
     settings.checkpointCallback.context  = this;
     settings.checkpointCallback.param    = index;

     settings.packetSpaceAvailable.callback = packetSpaceAvailable;
     settings.packetSpaceAvailable.context  = this;
     settings.checkpointCallback.param      = index;

     NEXUS_Graphics2D_SetSettings(hGfx2D, &settings);

     ResetTimes();

}

void
M2MCCore::ResetTimes()
{
     ts         = direct_clock_get_time( DIRECT_CLOCK_MONOTONIC );
     time_idle  = 0;
     time_total = 0;
     last_idle  = ts;
}

void
M2MCCore::switchBusy()
{
     long long now = direct_clock_get_time( DIRECT_CLOCK_MONOTONIC );

     if (now - last_idle > 500000) {
          ResetTimes();
     }
     else {
          time_total += now - ts;
          time_idle  += now - ts;

          ts = now;
     }

     busy = true;
}

void
M2MCCore::switchIdle()
{
     long long now = direct_clock_get_time( DIRECT_CLOCK_MONOTONIC );

     time_total += now - ts;

     ts = now;

     busy = false;
}

long long
M2MCCore::GetIdle( bool reset )
{
     int ret = 0;

     if (time_total) {
          long long now = direct_clock_get_time( DIRECT_CLOCK_MONOTONIC );

          time_total += now - ts;

          if (!busy)
               time_idle += now - ts;

          ts = now;

          ret = time_idle * 1000 / time_total;
     }

     if (reset)
          ResetTimes();

     return ret;
}

long long
M2MCCore::GetTotal()
{
     if (time_total) {
          long long now = direct_clock_get_time( DIRECT_CLOCK_MONOTONIC );

          time_total += now - ts;

          if (!busy)
               time_idle += now - ts;

          ts = now;
     }

     return time_total;
}

void
M2MCCore::packetSpaceAvailable( void *context, int param )
{
     M2MCCore *core = (M2MCCore *) context;

     D_DEBUG_AT( M2MC_Core, "M2MCCore[%u]::%s( %p, %d )\n", core->index, __FUNCTION__, context, param );

     Direct::LockWQ::Lock l1( core->space_lwq );

     core->space_avail = true;

     core->space_lwq.notify();
}

void
M2MCCore::checkpoint2D( void *context, int param )
{
     M2MCCore *core = (M2MCCore *) context;

core->checkpoint2d_count++;
     D_DEBUG_AT( M2MC_Core, "M2MCCore[%u]::%s( %p, %d )\n", core->index, __FUNCTION__, context, param );

     M2MCTask *task = core->fifo.pull();

     D_DEBUG_AT( M2MC_Core, "M2MCCore[%u]::%s( %p, %d ) -> %p\n", core->index, __FUNCTION__, context, param, task );

     D_MAGIC_ASSERT( task, Task );

     task->Done();

     core->switchIdle();

}

DFBResult
M2MCCore::Run( M2MCTask *task )
{
     NEXUS_Error rc = NEXUS_SUCCESS;

     D_DEBUG_AT( M2MC_Core, "M2MCCore[%u]::%s( %p, length %zu )\n", index, __FUNCTION__, (void*)this, task->buffer.GetLength() );

     switchBusy();

     while (true) {
          void         *ptr;
          unsigned int  size;
          size_t        length = task->buffer.GetLength();


          space_avail = false;

          rc = NEXUS_Graphics2D_GetPacketBuffer( hGfx2D, &ptr, &size, length );
          BDBG_ASSERT(!rc);
          if (!size) {
               D_DEBUG_AT( M2MC_Core, "  -> waiting for packet\n");

               Direct::LockWQ::Lock l1( space_lwq );

               if (!space_avail)
                    l1.wait( 2000 );

               continue;
          }

//          l1.unlock();

          D_ASSERT( size >= length );

          task->buffer.GetData( ptr, size );

          rc = NEXUS_Graphics2D_PacketWriteComplete( hGfx2D, task->buffer.GetLength() );
          BDBG_ASSERT(!rc);
          break;
     }

     fifo.waitMost( 0 );

     D_DEBUG_AT( M2MC_Core, "  -> Calling NEXUS_Graphics2D_Checkpoint\n" );

     do {
          rc = NEXUS_Graphics2D_Checkpoint( hGfx2D, NULL );
          switch (rc) {
              case NEXUS_SUCCESS:
                  D_DEBUG_AT( M2MC_Core, "     - NEXUS_SUCCESS\n" );
                  task->Done();
                  break;

              case 0x01010002://NEXUS_GRAPHICS2D_QUEUED:
                  D_DEBUG_AT( M2MC_Core, "     - NEXUS_GRAPHICS2D_QUEUED\n" );
                  fifo.push( task );
                  break;

              default:
                  D_ERROR( "M2MC/Engine: NEXUS_Graphics2D_Checkpoint failed (%d)!\n", rc );
          }
     } while (rc == NEXUS_NOT_AVAILABLE);

     return DFB_OK;
}


}

#endif /* BCM_DFB_USE_TASK_MANAGER */

