#ifndef _MAIN_H_
#define _MAIN_H_

#include <QObject>

#if defined (QT_WEBKITWIDGETS_LIB)
#include "browser.h"

class QGraphicsScene;

class TestApp: public QObject {
    Q_OBJECT;
public:
    static TestApp* getInstance();

    TestApp(QGraphicsScene* scene,
            const QList<QString>& urls,
            bool is_video,
            bool enable_gui,
            bool enable_tiled_backing_store,
            const QString& user_agent,
            bool ignore_ssl_errors);

    ~TestApp();

    void emitQuitApp();

    void setScreenshotPath(QString);

private slots:
    void quitApp();
    void loadNextUrl();
    void createNewBrowser();

private:
    QGraphicsScene *m_scene;
    QList<QString> m_urls;
    bool m_isVideo;
    bool m_enableGUI;
    bool m_enableTBS;
    QString m_userAgent;
    bool m_ignoreSSLErrors;
    QString m_screenshotPath;
    QScopedPointer<Browser> m_browser;
};
#endif

#endif  // _MAIN_H_
