/****************************************************************************
**
** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the QtWebEngine module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "content_main_delegate_qt.h"

#include "base/path_service.h"
#include "content/public/common/content_paths.h"
#include "ui/base/l10n/l10n_util.h"
#include "ui/base/ui_base_paths.h"
#include "ui/base/resource/resource_bundle.h"
#include "grit/net_resources.h"
#include "net/base/net_module.h"

#include "content_client_qt.h"
#include "renderer/content_renderer_client_qt.h"
#include "web_engine_library_info.h"

static base::StringPiece PlatformResourceProvider(int key) {
    if (key == IDR_DIR_HEADER_HTML) {
        base::StringPiece html_data = ui::ResourceBundle::GetSharedInstance().GetRawDataResource(IDR_DIR_HEADER_HTML);
        return html_data;
    }
    return base::StringPiece();
}

void ContentMainDelegateQt::PreSandboxStartup()
{
    PathService::Override(base::FILE_EXE, WebEngineLibraryInfo::getPath(base::FILE_EXE));
    PathService::Override(content::DIR_MEDIA_LIBS, WebEngineLibraryInfo::getPath(content::DIR_MEDIA_LIBS));
    PathService::Override(ui::DIR_LOCALES, WebEngineLibraryInfo::getPath(ui::DIR_LOCALES));

    net::NetModule::SetResourceProvider(PlatformResourceProvider);
    ui::ResourceBundle::InitSharedInstanceWithLocale(l10n_util::GetApplicationLocale(std::string("en-US")), 0);
}

content::ContentBrowserClient *ContentMainDelegateQt::CreateContentBrowserClient()
{
    m_browserClient.reset(new ContentBrowserClientQt);
    return m_browserClient.get();
}

//COMCAST MODIFICATION BEGIN
void InitLogging() {
  base::FilePath log_filename("/opt/logs/qwe.log");
  logging::LoggingSettings settings;
  settings.logging_dest = logging::LOG_TO_ALL;
  settings.log_file = log_filename.value().c_str();
  settings.delete_old = logging::APPEND_TO_OLD_LOG_FILE;
  logging::InitLogging(settings);
  logging::SetLogItems(true, true, true, true);
}

#if defined(ENABLE_GOOGLE_BREAKPAD)
#include "base/command_line.h"
#include "base/base_switches.h"
#include "base/debug/debugger.h"
#include "content/public/common/content_switches.h"
#include "client/linux/handler/exception_handler.h"
bool BreakpadCallback(const google_breakpad::MinidumpDescriptor& descriptor, void* context, bool succeeded)
{
    Q_UNUSED(context);
    Q_UNUSED(descriptor);
    return succeeded;
}
void InitCrashReportingSystem() {
    const CommandLine& command_line = *CommandLine::ForCurrentProcess();
    std::string process_type =
        command_line.GetSwitchValueASCII(switches::kProcessType);
    // don't setup for browser process, when being debugged or disabled
    if (process_type.empty() ||
        base::debug::BeingDebugged() ||
        command_line.HasSwitch(switches::kDisableBreakpad))
        return;
    static google_breakpad::ExceptionHandler* exceptionHandler = NULL;
    if (exceptionHandler)
        delete exceptionHandler;
    exceptionHandler = new google_breakpad::ExceptionHandler(
        google_breakpad::MinidumpDescriptor("/opt/minidumps"),
        NULL,
        BreakpadCallback,
        NULL,
        true,
        -1);
}
#else
#include "base/basictypes.h"
#include <signal.h>
void InitCrashReportingSystem() {
    // This is taken from SetupSignalHandlers, ../3rdparty/chromium/content/app/content_main_runner.cc.
    struct sigaction sigact;
    memset(&sigact, 0, sizeof(sigact));
    sigact.sa_handler = SIG_DFL;
    static const int signals_to_reset[] =
        {SIGSEGV, SIGABRT, SIGFPE, SIGILL, SIGBUS};
    for (unsigned i = 0; i < arraysize(signals_to_reset); i++) {
        CHECK(0 == sigaction(signals_to_reset[i], &sigact, NULL));
    }
}
#endif
//COMCAST MODIFICATION END

content::ContentRendererClient *ContentMainDelegateQt::CreateContentRendererClient()
{
    return new ContentRendererClientQt;
}

bool ContentMainDelegateQt::BasicStartupComplete(int *exit_code)
{
//COMCAST MODIFICATION BEGIN
    InitLogging();
    InitCrashReportingSystem();
//COMCAST MODIFICATION END
    SetContentClient(new ContentClientQt);
    return false;
}

