#!/bin/sh
enable=0
AA_DEFAULT=/etc/apparmor/apparmor_defaults
AAR_ENTRY_CNT=/tmp/aar_marker.txt
AAR_MESG_LOG=/tmp/aar_msg.txt
ACTIVE_PROFILES=`cat /sys/kernel/security/apparmor/profiles`
loop_time=3600
VMESG_FILE=/opt/logs/messages.txt
if [ ! -z "$ACTIVE_PROFILES" ]; then
     enable=1
fi
sleep 60
while [ $enable -eq 1 ]
do
   grep -i "$(date +%b\ %d\ %H)" /opt/logs/syslog_fallback.log > ${AAR_MESG_LOG}
   while read line; do
         profile=`echo $line | cut -d : -f1`
         count=`grep "profile=\"$profile\"" $AAR_MESG_LOG | wc -l`;
         if [ "$profile" = "authservice" ]; then
               line=:$count
         else
               line=,$count
         fi
         echo -n $line >> $AAR_ENTRY_CNT
   done  < $AA_DEFAULT
   echo -n -e "`date "+%Y %b %d %H:%M:%S"` APPARMOR_ENTRY_COUNT`cat $AAR_ENTRY_CNT`\n" >> ${VMESG_FILE}   
   rm -f ${AAR_MESG_LOG}
   rm -f ${AAR_ENTRY_CNT}
   sleep $loop_time
done



