/******************************************************************************
 *  Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors.
 *  Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 *  This program is the proprietary software of Broadcom and/or its licensors,
 *  and may only be used, duplicated, modified or distributed pursuant to the terms and
 *  conditions of a separate, written license agreement executed between you and Broadcom
 *  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 *  no license (express or implied), right to use, or waiver of any kind with respect to the
 *  Software, and Broadcom expressly reserves all rights in and to the Software and all
 *  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 *  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 *  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 *  Except as expressly set forth in the Authorized License,
 *
 *  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 *  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 *  and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 *  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 *  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 *  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 *  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 *  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 *  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 *  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 *  USE OR PERFORMANCE OF THE SOFTWARE.
 *
 *  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 *  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 *  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 *  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 *  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 *  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 *  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 *  ANY LIMITED REMEDY.
 ******************************************************************************/

#ifndef __VL_HAL_SNMP_TUNER_INTERFACE_H__
#define __VL_HAL_SNMP_TUNER_INTERFACE_H__


#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
	TUNER_NONE,
	TUNER_QPSK,   /* The tuner is in QPSK mode for OOB */
	TUNER_BPSK,	     /* The tuner is in BPSK mode */
	TUNER_OQPSK,	     /* The tuner is in OQPSK mode */
	TUNER_VSB8,       /* The tuner is in VSB8 mode */
	TUNER_VSB16,      /* The tuner is in VSB16 mode */
	TUNER_QAM16,      /* The tuner is in QAM16 mode */
	TUNER_QAM32,      /* The tuner is in QAM32 mode */
	TUNER_QAM64,      /* The tuner is in QAM64 mode */
	TUNER_QAM80,      /* The tuner is in QAM80 mode */
	TUNER_QAM96,      /* The tuner is in QAM96 mode */
	TUNER_QAM112,     /* The tuner is in QAM112 mode */
	TUNER_QAM128,     /* The tuner is in QAM128 mode */
	TUNER_QAM160,     /* The tuner is in QAM160 mode */
	TUNER_QAM192,     /* The tuner is in QAM192 mode */
	TUNER_QAM224,     /* The tuner is in QAM224 mode */
	TUNER_QAM256,     /* The tuner is in QAM256 mode */
	TUNER_QAM320,     /* The tuner is in QAM320 mode */
	TUNER_QAM384,     /* The tuner is in QAM384 mode */
	TUNER_QAM448,     /* The tuner is in QAM448 mode */
	TUNER_QAM512,     /* The tuner is in QAM512 mode */
	TUNER_QAM640,     /* The tuner is in QAM640 mode */
	TUNER_QAM768,     /* The tuner is in QAM768 mode */
	TUNER_QAM896,     /* The tuner is in QAM896 mode */
	TUNER_QAM1024,    /* The tuner is in QAM1024 mode */
	TUNER_ANALOG,     /* The tuner is in Analog mode */
	TUNER_NUM_OF_MODES
} SNMP_INTF_TUNER_MODE_t ;


typedef struct
{
    	unsigned long  ulCorrBytes;     /* Number of correctable byte errors for time period */
    	unsigned long  ulUnCorrBlocks;  /* Total number of uncorrectable block errors for time period */
	unsigned long  ulUnerroreds;     /* Codewords received on this channel without errors*/
    	unsigned long  ulTimeForBER;    /* Time in seconds, over which Read-Solomon was calculated */
}SNMP_INTF_TUNER_FEC_STATUS_t;


typedef enum {
	TUNER_DEVICE_LOCKED,
	TUNER_DEVICE_UNLOCKED,
	TUNER_DEVICE_TIMEOUT
}SNMP_INTF_DEVICE_LOCK_t;

typedef struct
{
	unsigned long          		tunerIndex; 
	SNMP_INTF_TUNER_MODE_t    	enTunerMode;
	unsigned long    		ulFrequency;   // in KHz
	SNMP_INTF_DEVICE_LOCK_t    	enLockStatus;           /* Current frequency lock */
	SNMP_INTF_TUNER_FEC_STATUS_t  	stFEC_Status;           /* FEC status */
	unsigned long 			ulRangeMin;  /* The lowest valid frequency in kHz */
	unsigned long 			ulRangeMax;  /* The Highest valid frequency in kHz */
	//For SNMP MIB value support
	unsigned long              	ulAGC;                  /* AGC compared to stored values */
	unsigned long              	ulSNR;                  /* Current signal to noise ratio in DB*/
	unsigned long              	ulBER;                  /* Bit Error Rate range */
	unsigned long              	ulPower;                /* in Tenth dBmV*/
	unsigned long              	ulInterleaver;
	unsigned long              	ulEqGain;
	unsigned long              	ulMainTapCoeff;
	unsigned long              	ulPCRErrors;
	unsigned long              	ulPTSErrors;
	unsigned long              	totalTuneCount;
	unsigned long              	tuneFailCount;
	unsigned long              	lastTuneFailFreq;
	unsigned long              	lockedTimeInSecs;
	unsigned long              	carrierLockLostCount;
    int                         bandwidthCode;
	unsigned long             	ulTotalExtChBytesRead; //For QPSK only
        unsigned long                   ulCorrBytes;
        unsigned long                   ulUnCorrBlocks;
        unsigned long                   ulUnerroreds;
	unsigned long  			channelMapId;
	unsigned long			dacId;	
	//End - For SNMP MIB value support

}SNMP_INTF_TUNER_INFO_t;

#define berGreaterThan10e2                   1
#define berRange10e2ToGreaterThan10e4        2
#define berRange10e4ToGreaterThan10e6        3
#define berRange10e6ToGreaterThan10e8        4
#define berRange10e8ToGreaterThan10e12       5
#define berEqualToOrLessThan10e12            6
#define berNotApplicable                     7

#define BandWidth_mHzOther                   1
#define BandWidth_mHz864                     2
#define BandWidth_mHz1002                    3

unsigned int HAL_SNMP_Get_Tuner_Info(void* ptSnmpHALTunerInfo, unsigned long tunerIndex);

unsigned int HAL_SNMP_Get_Tuner_Count(unsigned int* ptTunerCount);
void HAL_SNMP_diag_dump_tuner_stats(unsigned int nTunerId);
int HAL_SNMP_dump_presentation_params();
int HAL_SNMP_dump_decode_params(void * pvDecodeRequest, int SessionType, unsigned int iSession);

#ifdef __cplusplus
}
#endif

#endif
