###############################################################################
#  Copyright (c) 2016 RDK Management, LLC. All rights reserved.
#  Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
#
#  This program is the proprietary software of Broadcom and/or its licensors,
#  and may only be used, duplicated, modified or distributed pursuant to the terms and
#  conditions of a separate, written license agreement executed between you and Broadcom
#  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
#  no license (express or implied), right to use, or waiver of any kind with respect to the
#  Software, and Broadcom expressly reserves all rights in and to the Software and all
#  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
#  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
#  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
#
#  Except as expressly set forth in the Authorized License,
#
#  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
#  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
#  and to use this information only in connection with your use of Broadcom integrated circuit products.
#
#  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
#  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
#  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
#  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
#  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
#  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
#  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
#  USE OR PERFORMANCE OF THE SOFTWARE.
#
#  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
#  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
#  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
#  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
#  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
#  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
#  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
#  ANY LIMITED REMEDY.
###############################################################################

#source $RDK_DIR/mediaframework/soc/env_base.sh

if [ $setupSDK -eq 1 ];
then
  setupSDK=0
fi

check_ri_dsgcc()
{
	RI_DSGCC_BUILD=0

	if [ -d $RMF_DIR/../ri/ ]; then
		# check if RI in build i.e. env.xml
		grep "SDK.*,RI" $RMF_DIR/../env.xml
		if [ $? -eq 0 ]; then
			#echo "RI present!"
			RI_DSGCC_BUILD=1
		fi			
	#else
		#echo "No RI!"
	fi
	
	export RI_DSGCC_BUILD
}

check_ri_dsgcc

if [ "$COMCAST_PLATFORM" = "XI3" ] || [ "$COMCAST_PLATFORM" = "BCM97438" ] ;
then
#    configMode=CLIENT
    configMode=CLIENT_TSB
else
	if [ "$COMCAST_PLATFORM" = "BCM93385" ];
	then 
		configMode=HEADLESS_GW
	else
		configMode=HEADED_GW
	fi
	USE_QAMSRC=1
fi

#enable RMF build for all platform
echo "RMF build on $COMCAST_PLATFORM ......"

#PATCH
SOC_PATCH=$RMF_DIR/platform/soc/patches/patch.sh
if [ -e ${SOC_PATCH} ]; then
	source ${SOC_PATCH}
fi

if [ "x$DISABLE_POD" = "xy" -o "x$USE_QAMSRC" != "x1" ]; then
    disablesnmp=y
fi
 
if [ "$USE_QAMSRC" = "1" ] ;  
then
  echo =========================================================================================================================================================
  echo --------------------------BUILDING SNMP ---------------------------------
  echo =========================================================================================================================================================
  echo $SNMP_SRC_DIR
  if [ -d "$SNMP_SRC_DIR" ]
  then
    echo "SNMP dir is already installed..."
  else
    echo Installing SNMP dir, it may take few seconds depends on your system
    tar zxf $THIRDPARTY_DIR/net-snmp-5.4.2.tar.gz -C $THIRDPARTY_DIR
    echo "SNMP dir installed $SNMP_SRC_DIR"
  fi

  cd $SNMP_SRC_DIR
  if [ ! -f Makefile ]; then
    echo "Starting configure ...."
    SNMP_OPTIONS="--host=$B_REFSW_ARCH --target=i386-linux --without-rpm --with-perl-modules=no --disable-embedded-perl  --enable-mfd-rewrites --with-default-snmp-version=3 --with-sys-contact=' ' --with-sys-location=' ' --with-logfile=/var/log/snmpd.log  --with-persistent-directory=/var/net-snmp --with-out-mib-modules=ifTable --with-out-mib-modules=ifXTable --with-out-mib-modules=inetNetToMediaTable --with-out-mib-modules=snmpMIB --with-out-mib-modules=system --with-out-mib-modules=mibII/system_mib --with-out-mib-modules=mibII/sysORTable --with-out-mib-modules=host/hr_swrun --with-out-mib-modules=host/hr_swinst --with-out-mib-modules=host/hr_print --with-mib-modules=mibII/ipv6 --with-tranports=UDPIPv6 --enable-ipv6 --with-endianness=little"
    bash -c "unset CFLAGS CPPFLAGS CXXFLAGS LDFLAGS; CC=${B_REFSW_ARCH}-gcc ./configure --prefix=$SNMP_DIR $SNMP_OPTIONS"
    if [ $? -ne 0 ]; then
        echo "Configure failed. Exit."
        exit -1
    fi
	rm .snmp_built -f
	rm .snmp_installed -f
  fi

  echo "Starting make..."
  if [ ! -f .snmp_built ]; then 
	  bash -c "unset CFLAGS CPPFLAGS CXXFLAGS LDFLAGS; time make"
	  if [ $? -ne 0 ]; then
		echo "Make error. Exit."
		exit -1
	  fi
	  touch .snmp_built
  fi 

  echo "Starting make install..."
  if  [ ! -f .snmp_installed ]; then
	make install 
    if [ $? -ne 0 ]; then
      echo "Make Install error. Exit."
      exit -1
    fi
    tar zxf $THIRDPARTY_DIR/mibs.tgz -C $SNMP_DIR/share/snmp/
    touch .snmp_installed
  fi

  if [ "x$DISABLE_POD" != "xy" ] ; then 
      echo =========================================================================================================================================================
      echo --------------------------BUILDING OPENSSL ---------------------------------
      echo =========================================================================================================================================================

      echo $OPENSSL_SRC_DIR
      if [ -d "$OPENSSL_SRC_DIR" ]
      then
        echo "OPENSSL dir is already installed..."
      else
        echo Installing OPENSSL dir, it may take few seconds depends on your system
        tar zxf $THIRDPARTY_DIR/openssl-0.9.8j.patched.tar.gz -C $THIRDPARTY_DIR
        echo "OPENSSL dir installed $OPENSSL_SRC_DIR"
      fi
  
      cd $OPENSSL_SRC_DIR
      echo "Starting make..."
      if  [ ! -f .openssl_built ]; then
        sed -i "s/^include/-include/" Makefile
        time make VL_PLATFORM=BCM_NEXUS_LINUX_74XX CC=${B_REFSW_ARCH}-gcc
        if [ $? -ne 0 ]; then
          echo "Make error. Exit."
          exit -1
        fi
    	touch .openssl_built
      fi

      echo "Starting make install..."
      if [ ! -f .openssl_installed ]; then
        make install_sw INSTALL_DIR=$OPENSSL_DIR
        if [ $? -ne 0 ]; then
          echo "Make Install error. Exit."
          exit -1
        fi
    	touch .openssl_installed
      fi
  
      cd $RMF_DIR
	  
	  #Only required if RI built
	  if [ "$RI_DSGCC_BUILD" == "1" ]; then 
		  echo =========================================================================================================================================================
		  echo --------------------------BUILDING DSGCC  ---------------------------------
		  echo =========================================================================================================================================================
		  echo `pwd`
		  if [ -d platform/soc/docsis ] 
		  then 
			echo "DSGCC dir is already installed..."
		  else
			mkdir -p platform/soc/docsis
			which lndir
			if [ $? -ne 0 ]; then
			  cp -r $NEXUS_TOP/../BSEAV/docsis/* platform/soc/docsis
			else
			  lndir $NEXUS_TOP/../BSEAV/docsis/ platform/soc/docsis
			fi

			rm -rf platform/soc/docsis/StbHostApps/DsgCC/StbApp_DsgCC/linux/bcm
			rm -f platform/soc/docsis/StbHostApps/DsgCC/build/dsgcclib.a
			cd platform/soc/docsis/StbHostApps/DsgCC/build
			ADDED_CFLAGS="-fPIC" ./build dsgcc pvnet applib cablecard dcasbt cdl20 rswdload eth2 vldsgbuild
			cd -
		  fi
	  else
		mkdir -p platform/soc/docsis/StbHostApps/DsgCC/build/
		if [ "$BUILD_13_2" = "y" ] ; then
			ln -s ${WORK_DIR}/Refsw/BSEAV/docsis/StbHostApps/DsgCC/build/dsgcclib.a platform/soc/docsis/StbHostApps/DsgCC/build/
		else
			ln -s ${WORK_DIR}/Refsw/BSEAV/cable/docsis/estb/StbHostApps/DsgCC/build/dsgcclib.a platform/soc/docsis/StbHostApps/DsgCC/build/
		fi
	  fi
  
      cd $RMF_DIR

      # ---------- copy Third-party, MFR library------------------
      mkdir -p $instaldir/lib
      mkdir -p $instaldir/bin

      echo "Update libbroadcomlib.so with libbroadcomlib.so.$B_REFSW_ARCH.."
      cd platform/soc/mfrlibs/broadcomlib/
      ln -s libbroadcomlib.so.$B_REFSW_ARCH libbroadcomlib.so
      cd -
      cp -f platform/soc/mfrlibs/broadcomlib/libbroadcomlib.so $instaldir/lib/
  fi
  cd $RMF_DIR
  
  cp -a $SNMP_DIR $instaldir/bin/
  cp $THIRDPARTY_DIR/snmpd.conf $instaldir/bin/target-snmp/bin/
  ln -sf /tmp/snmpd.conf $instaldir/bin/target-snmp/sbin/
  cp $THIRDPARTY_DIR/restart_snmpd.sh $instaldir/bin/target-snmp/sbin/
  mkdir -p $FSROOT/mnt/nfs/bin
  cp -a $instaldir/bin/* $FSROOT/mnt/nfs/bin/
fi

mkdir -p $FSROOT/usr/local/lib
cp -f $RMF_DIR/../dtcp/lib/libDtcpMgr.so $FSROOT/usr/local/lib/

#Update runtime scripts
mkdir -p $instaldir/env
if [ "$RDK_PLATFORM_VENDOR" = "pace" ]; then
    cp -f platform/soc/scripts/run.sh.rng150 $instaldir/env/run.sh
else
    cp -f platform/soc/scripts/run.sh $instaldir/env
fi

cp -f platform/soc/scripts/runRMFApp rmfApp/runRMFApp

case "${COMCAST_PLATFORM^^}" in 
    "RNG150" )     
        if [ "$RDK_PLATFORM_VENDOR" = "pace" ]; then
            cp -f platform/soc/scripts/rmfconfig.ini.rng150 qamsource/rmfconfig.ini
        else
            cp -f platform/soc/scripts/rmfconfig.ini.7125 qamsource/rmfconfig.ini
        fi
        ;;
    "XG1V3" )
	 if [ "$RDK_PLATFORM_VENDOR" = "pace" ]; then
        cp -f platform/soc/scripts/rmfconfig.ini.7435.pace qamsource/rmfconfig.ini
		else
		cp -f platform/soc/scripts/rmfconfig.ini.7435.samsung qamsource/rmfconfig.ini
		fi
        ;;
    "XI3" ) 
        cp -f platform/soc/scripts/rmfconfig.ini.7428 qamsource/rmfconfig.ini
        ;;
    * )
        #default settings
        cp -f platform/soc/scripts/rmfconfig.ini.7425 qamsource/rmfconfig.ini
        ;;
esac
