/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/


#ifndef HAL_LOG_H
#define HAL_LOG_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdarg.h>
#include <sys/types.h>


#define kLogModMaxName  16


typedef enum
{
  eLogLvl_BadLogLvl = -1,
  eLogLvl_Noise = 0,
  eLogLvl_Info,
  eLogLvl_Warning,
  eLogLvl_Error,
  eLogLvl_Fatal,
  eLogLvl_MaxLevels

} ELogLvl;

typedef struct _log_level_
{
  char                                     name[kLogModMaxName];
  ELogLvl                                lvl;
  struct  _log_level_*     next;
} LogLvl;

#define kLogErr     0
#define kLogSuccess 1

typedef int (*LogOutputFunc)(const char* modName, ELogLvl lvl,
                             time_t time, pid_t pid, 
                             const char *format, va_list valist);  

typedef void* LogID;

LogID     HAL_LogRegister(const char* name);
int       HAL_LogSetOutputFunc(LogOutputFunc fp);
ELogLvl   HAL_LogGetLvl(LogID id);
ELogLvl   HAL_LogGetLvlByName(const char* name);
LogLvl*   HAL_LogGetLvlAll(void);
int       HAL_LogSetLvl(LogID id, ELogLvl lvl);
int       HAL_LogSetLvlByName(const char* name, ELogLvl lvl);
void      HAL_LogSetLvlAll(ELogLvl lvl);
void      HAL_LogSetTimestamp(int on);
void      HAL_LogSetModName(int on);
void      HAL_LogSetPID(int on);
void      HAL_Log(LogID id, ELogLvl lvl, const char* format, ...);

/* These are available always */
//#define LOGFATAL(mod, ...) HAL_Log((mod), eLogLvl_Error, ## __VA_ARGS__)
//#define HALLOGERROR(mod, ...)    HAL_Log((mod), eLogLvl_Error, ## __VA_ARGS__)
//#define LOGFATAL(mod,args...)    HAL_Log((mod), eLogLvl_Fatal, args)
//#define LOGERROR(mod,args...)    HAL_Log((mod), eLogLvl_Error, args)


#ifdef PRA_DEBUG

/* These are only available in debug build */
#define LOGWARNING(mod,args...)  HAL_Log((mod), eLogLvl_Warning, args)
#define LOGINFO(mod,args...)     HAL_Log((mod), eLogLvl_Info, args)
#define LOGDEBUG(mod,args...)    HAL_Log((mod), eLogLvl_Noise, args)

#else
#define LOGWARNING(mod, ...)     do { } while( 0 )
#define LOGINFO(mod, ...)        do { } while( 0 )
#define HALLOGDEBUG(mod, ...)       do { } while( 0 )
//#define LOGWARNING(mod,args...)     do { } while( 0 )
//#define LOGINFO(mod,args...)        do { } while( 0 )
//#define LOGDEBUG(mod,args...)       do { } while( 0 )


#endif /* PRA_DEBUG */

#ifdef __cplusplus
}
#endif


#endif /* HAL_LOG_H */
