/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/




#ifdef USE_DSG

/*-------------------------------------------------------------------
   Include Files
-------------------------------------------------------------------*/
#include <stdio.h>
#include "vl_dsg_priv.h"
#include "dsg_types.h"
#include "vl_dsg_init.h"
#include "hal_api.h"
#include "hal_module.h"
#include "hal_error.h"
//#include "utilityMacros.h"
#include "vlpluginapp_haldsgapi.h"
#include "rdk_debug.h"
#include <pdt_hal.h>


#ifdef USE_DSG
#include "vlpluginapp_haldsgapi.h"
#endif

/*-------------------------------------------------------------------
   Global Variable Definitions
-------------------------------------------------------------------*/
DSG_BASE_t stHalDSGBase;

/*===================================================================
   FUNCTION DEFINITIONS
===================================================================*/
DSG_t * DSG_GetDSGFromHandle (UINT32 hDSGHandle);
void vlBcmDsgInit();

//**************************************************
// DSG Driver Callbacks:

int DsgControlCallback(  void *        pUserData,
                         unsigned char *      pData,
                         unsigned long        length
                         )
{
    int indx = (int)(pUserData);

    if((indx >= 0) && (indx < VL_MAX_DSG_DEVICES))
    {
        if((stHalDSGBase.astDSG[indx].control_data_available_cb) != NULL)
            stHalDSGBase.astDSG[indx].control_data_available_cb((int)NULL, pData, length);
    }

    return 0;
}


int DsgTunnelCallback(   void *        pUserData,
                         unsigned char *      pData,
                         unsigned long        length
                         )
{
    int indx = (int)(pUserData);

    if((indx >= 0) && (indx < VL_MAX_DSG_DEVICES))
    {
        if((stHalDSGBase.astDSG[indx].tunnel_data_available_cb) != NULL)
            stHalDSGBase.astDSG[indx].tunnel_data_available_cb((int)NULL, pData, length);
    }

    return 0;
}

int DsgImageCallback(   void *        pUserData,
                        unsigned char *      pData,
                        unsigned long        length,
                        unsigned long        eofFlag
                    )
{
    int indx = (int)(pUserData);

    if((indx >= 0) && (indx < VL_MAX_DSG_DEVICES))
    {
        if((stHalDSGBase.astDSG[indx].image_data_available_cb) != NULL)
            stHalDSGBase.astDSG[indx].image_data_available_cb((int)NULL, pData, length, eofFlag);
    }

    return 0;
}

int DsgDownloadStatusCallback(   void *        pUserData,
                                VL_DSG_DOWNLOAD_STATE state,
                                VL_DSG_DOWNLOAD_STATE result
                            )
{
    int indx = (int)(pUserData);

    if((indx >= 0) && (indx < VL_MAX_DSG_DEVICES))
    {
        if((stHalDSGBase.astDSG[indx].download_status_cb) != NULL)
            stHalDSGBase.astDSG[indx].download_status_cb((int)NULL, (VL_DSG_DOWNLOAD_STATE)state, (VL_DSG_DOWNLOAD_RESULT)result);
    }

    return 0;
}

int DsgEcmStatusCallback(   void *        pUserData,
                            VL_DSG_ECM_STATUS status
                        )
{
    int indx = (int)(pUserData);

    if((indx >= 0) && (indx < VL_MAX_DSG_DEVICES))
    {
        if((stHalDSGBase.astDSG[indx].ecm_status_cb) != NULL)
            stHalDSGBase.astDSG[indx].ecm_status_cb((int)NULL, (VL_DSG_ECM_STATUS)status);
    }

    return 0;
}


int DsgAsyncDataCallback(   void *        pUserData,
                            unsigned long ulTag,
                            unsigned long ulQualifier,
                            void *        pStruct
                        )
{
    int indx = (int)(pUserData);

    if((indx >= 0) && (indx < VL_MAX_DSG_DEVICES))
    {
        if((stHalDSGBase.astDSG[indx].async_data_cb) != NULL)
            stHalDSGBase.astDSG[indx].async_data_cb((int)NULL, ulTag, ulQualifier, pStruct);
    }

    return 0;
}


/*===================================================================
FUNCTION: DSG_Init

DESCRIPTION:
    Initialize HAL DSG
RETURN VALUE:
   0 - Success;  Negative values - Failure
SIDE EFFECTS:
   None.
===================================================================*/
int DSG_Init (void)
{
    int indx = 0;

    DSGHAL_HANDLE        hHal = 0;
    DSG_HANDLE           hDsgDriver = 0;

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_DSG,"%s(): Entry\n", __FUNCTION__);

    memset(&stHalDSGBase,0,sizeof(stHalDSGBase));

    for(indx = 0; indx < VL_MAX_DSG_DEVICES; indx++)
    {
        // Initialize instance capabilities
        stHalDSGBase.stCapabilities.astInstanceCapabilities[indx].hDSGHandle = 0;

        /* Registering Callbacks */
        stHalDSGBase.astDSG[indx].hHal         = hHal;
        stHalDSGBase.astDSG[indx].hDsgDriver   = hDsgDriver;
        stHalDSGBase.astDSG[indx].bFree        = 1;
        stHalDSGBase.stCapabilities.usNumDSGs += 1;
        vlBcmDsgInit();
    }

    stHalDSGBase.bIsInitialized            = 1;

//  RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_DSG,"%s(): Exit\n", __FUNCTION__);
    return (HAL_SUCCESS);
}

int CHALDsg_init()
{
    return DSG_Init();
}

/*===================================================================
FUNCTION: DSG_Shutdown

DESCRIPTION:
    Shutdown HAL DSG
RETURN VALUE:
   0 - Success;  Negative values - Failure
SIDE EFFECTS:
   None.
===================================================================*/
int DSG_Shutdown(void)
{
    int indx = 0;
    //INT32  lrc;
    //BOOLEAN pRun;

    //RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_DSG,"%s(): Entry \n", __FUNCTION__);

    stHalDSGBase.bIsInitialized = 0;

    for(indx = (stHalDSGBase.stCapabilities.usNumDSGs-1); indx >= 0 ; indx--)
    {
//        DSG_HANDLE  hDsgDriver = stHalDSGBase.astDSG[indx].hDsgDriver;
        /* Un-Registering Callbacks */

        stHalDSGBase.astDSG[indx].hHal         = NULL;
        stHalDSGBase.astDSG[indx].hDsgDriver   = NULL;

        stHalDSGBase.stCapabilities.usNumDSGs -= 1;
        stHalDSGBase.stCapabilities.astInstanceCapabilities[indx].hDSGHandle = 0;
    }

    return (HAL_SUCCESS);
}

/****************************************************************
   FUNCTION: HAL_DSG_SetNotify

   DESCRIPTION:
      Sets the Notify function
   RETURN VALUE:
      0 - Success;  Negative values - Failure
****************************************************************/
int HAL_DSG_SetNotify( DEVICE_HANDLE_t hDSGHandle, void * pfnNotifyFunc, VL_DSG_NOTIFY_TYPE_t notifyType, void* pulData)
{
    DSG_t   *pstDSG = DSG_GetDSGFromHandle(hDSGHandle);

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_DSG,"%s(): Entry pulData %p\n", __FUNCTION__, pulData);
    switch(notifyType)
    {
        case VL_DSG_NOTIFY_TUNNEL_DATA:
            pstDSG->tunnel_data_available_cb    =  (VL_DSG_TUNNEL_CBFUNC_t)pfnNotifyFunc;
        break;

        case VL_DSG_NOTIFY_CONTROL_DATA:
            pstDSG->control_data_available_cb   =  (VL_DSG_CTRL_CBFUNC_t)pfnNotifyFunc;
        break;

        case VL_DSG_NOTIFY_IMAGE_DATA:
            pstDSG->image_data_available_cb     =  (VL_DSG_IMAGE_CBFUNC_t)pfnNotifyFunc;
        break;

        case VL_DSG_NOTIFY_DOWNLOAD_STATUS:
            pstDSG->download_status_cb          =  (VL_DSG_DOWNLOAD_STATUS_CBFUNC_t)pfnNotifyFunc;
        break;

        case VL_DSG_NOTIFY_ECM_STATUS:
            pstDSG->ecm_status_cb               =  (VL_DSG_ECMSTATUS_CBFUNC_t)pfnNotifyFunc;
            break;

        case VL_DSG_NOTIFY_ASYNC_DATA:
            pstDSG->async_data_cb               =  (VL_DSG_ASYNC_CBFUNC_t)pfnNotifyFunc;
            break;

        default:
            return ERROR_HAL_OUT_OF_RANGE;
        break;
    }

    return HAL_SUCCESS;
}

int vlDsgSetConfig(DSG_t   *pstDSG, unsigned long ulTag, void* pvConfig);

int HAL_DSG_SetConfig( DEVICE_HANDLE_t hDSGHandle, unsigned long ulTag, void* pvConfig)
{
    DSG_t   *pstDSG = DSG_GetDSGFromHandle(hDSGHandle);

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_DSG,"%s(): Entry \n", __FUNCTION__);

    return vlDsgSetConfig(pstDSG, ulTag, pvConfig);
}

#endif // USE_DSG
