/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/



#include "hal_api.h"
#include "rmf_osal_event.h"

#ifndef _POD_LOW_API_H_
#define _POD_LOW_API_H_

#ifdef __cplusplus
extern "C" {
#endif



typedef unsigned char  UCHAR;
typedef unsigned short USHORT;
typedef unsigned int   ULONG;



typedef unsigned long  DWORD;
typedef void START_ROUTINE(void);


/* I2C Interface */

typedef enum
{
     PODDRV_POWER_PROHIBIT,
     PODDRV_POWER_OFF ,
     PODDRV_POWER_3_3V ,
     PODDRV_POWER_5V,
     PODDRV_OOB_ON   ,
     PODDRV_OOB_OFF ,
     PODDRV_PARALLEL_INPUT_ON,
     PODDRV_PARALLEL_INPUT_OFF,
     PODDRV_CIMAX_RESET_ON ,
     PODDRV_CIMAX_RESET_OFF
}POD_POWER_MODE_t;

extern int i2c_write(unsigned char  device, unsigned short sub_addr,
                     unsigned short nbytes, unsigned char *buffer,
                     unsigned char  ack);
extern int i2c_read(unsigned char  device, unsigned short sub_addr,
                    unsigned short nbytes, unsigned char *buffer,
                    unsigned char  ack);


//from utils.h

#define PODST_RW_FAIL               0
#define PODST_RW_READ_DATA_AVAIL    1
#define PODST_RW_SUCCESS            2

#define  POLLING_PERIOD				200 /* Min Frequency of Poll msgs */
#define POLL_RESP_TIMEOUT		    5000 /* As per SCTE28 3.1 -- Change from 300ms in NRSS */
#define POD_MODULE_CHECK_POLLING_RATE 300     // in ms
#define  APPLI_TIME_SLOT			50


/* This is the standard min pthread stack size on our system */
#define DEFAULT_STACK_SIZE ( 16 * 1024)

//from transport.h

extern UINT32  ulLastTimeReceivedData;     /* Last time that the pod was written to on the data channel */

//from ci.h
extern BOOLEAN bHomingInProgress;


#if 0
/* Collect data about POD operations */
typedef struct
{
    struct
    {
        struct
        {
            USHORT usReadByte;
            USHORT usWriteByte;
        } sInfo; /* Collect general info (non-error) */
        struct
        {
            USHORT usReadByte;
            USHORT usWriteByte;
        } sError; /* Collect error metrics */

    } sI2C; /* Collect I2C metrics */

    struct
    {
        struct
        {
            USHORT usAttemptReadPkt;
            USHORT usReadPkt;
            USHORT usWritePkt;
            USHORT usWritePk_NotFR;
            USHORT usWriteFoundRead;
        } sInfo; /* Collect general info (non-error) */
        struct
        {
            USHORT usReadPkt;
            USHORT usWritePkt;
            USHORT usWritePk_NotFR;
        } sError; /* Collect error metrics */

    } sTrans; /* Collect Transport metrics */

} sPodDebugMetrics_t;

sPodDebugMetrics_t sPodDebugMetrics;

#endif



typedef struct ListElement{
	void		*Data;
	void		*pNext;
}ListElement, *pListElement;


typedef struct QUEUE
{
	UCHAR	NumberOfElement ;
	pListElement pFirst ;
	pListElement pLast ;
} QUEUE , *PQUEUE;

extern	QUEUE	TheDriverQueue;
//extern long cMsgQCreate(char *msgQueueName, long maxMsgs, long maxMsgLength, long options);
//extern long cMsgQWrite(long msgQId, char msg[], long msgLen, long msecTimeout, long priority);
//extern int cMsgQRead(long msgQId, char msg[], long msgLen, long msecTimeout);

extern rmf_osal_eventqueue_handle_t sendMsgQ;
extern rmf_osal_eventqueue_handle_t recvMsgQ;
extern rmf_osal_eventqueue_handle_t ext_channel_Queue;

typedef enum {
    MSG_CI_POLL,            /* Poll the pod for data */
	MSG_CI_SEND_TPDU,       /* Send an application TPDU to the pod */
	MSG_CI_READ_TPDU,       /* From Interrupt handler -- Data Available to read */
	MSG_CI_EXTENDED_READ,   /* From Interrupt handler -- Extended Data Available to read */
	MSG_CI_EXTENDED_WRITE,
	MSG_CI_RESET_PCMCIA,    /* Necessary resets for homing only */
	MSG_CI_RESET_POD_INTERFACE,       /* Necessary resets for homing only */
	MSG_CI_TRANS_BYPASS_CTRL,   /* TS bypasses the pod or is routed through it */

	/* The following messages are meant for debug only */
	MSG_CI_DEBUG_FLAG_POD_CHECK, /* Enable / Disable pod insert checking */
	MSG_CI_DEBUG_CIMAX_DUMP,
	MSG_CI_DEBUG_CIMAX_READ,
	MSG_CI_DEBUG_CIMAX_WRITE,
	MSG_CI_MAX_MSGS
}eMessageId_t;

typedef struct
{
    union /* union member based on which MsgId is being sent */
    {
        BOOLEAN bEnableTSBypass;      /* Bypass the POD module -- just loop back the data via the Cimax */

    }u; /* This is a union */
    UCHAR tuner_id;
}sCtrlMsg_t;

typedef struct
{
    ULONG x;
    ULONG y;
    ULONG z;
} sGenericMsg_t;


typedef struct
{
	  UCHAR			TcId;
	  USHORT		lSize;
	  UCHAR			*pOrigin;
	  UCHAR			*pData;
	  ULONG			FlowID;
} POD_BUFFER;


typedef struct
{
    eMessageId_t eMsgId;

    union /* union member based on which MsgId is being sent */
    {
        POD_BUFFER      sPodPkt;    /* Active Union member based on MsgId */
        sCtrlMsg_t      sControlMsg;/* Active Union member based on MsgId */
        sGenericMsg_t   sGenericMsg; /* Used when lazy */
    }u; /* This is a union */
} sCIMessage_t;




BOOLEAN I2C_read(UCHAR deviceAddr, UCHAR subAddr, UCHAR* pucData);
BOOLEAN I2C_write(UCHAR deviceAddr, UCHAR subAddr, UCHAR* pucData);



void PODMemFree(UCHAR * pU);
UCHAR *PODMemAllocate(USHORT size);
BOOLEAN PODWriteByte( UCHAR* pDest, UCHAR Buffer);
BOOLEAN PODReadByte( UCHAR* pSource, UCHAR* pBuffer);

BOOLEAN PODReadRegister(UINT8 accessType, UINT32 registerNo, UINT8 *pBuffer, int count);
BOOLEAN PODWriteRegister(UINT8 accessType, UINT32 registerNo, UINT8 *pBuffer, int count);

void PODMemCopy( UCHAR* Destination, UCHAR* Source, USHORT Length);
void PODSleep(USHORT TimeMs);
void PODSetVPP();
void SetPODPower( POD_POWER_MODE_t etMode );
void PODControl ( POD_POWER_MODE_t etSetting );
void PODFree(UCHAR* pDest);
void PODCheck();


pthread_t pthread_createThread( void *code,
                                void *data,
                                unsigned stackSize,
                                int priority );

DWORD PODCreateTask ( START_ROUTINE  Task );
DWORD PODCreateParamTask ( START_ROUTINE  Task, void * pArgs);
BOOLEAN PODDeleteTask (UINT32 TaskID, BOOLEAN	* pRun);
void QueueInit(QUEUE* pQueue);
void QueueDelete(QUEUE* pQueue);
BOOLEAN QueueRemoveHead(QUEUE* pQueue, sCIMessage_t *pElt);
BOOLEAN QueueAddTail(QUEUE* pQueue, sCIMessage_t* pElt);
BOOLEAN QueueAddHead(QUEUE* pQueue, sCIMessage_t* pElt);
pListElement QueueGetHead(QUEUE* pQueue);
INT32 QueueMutexDestroy(void);

void POD_TaskPhysicalLayer (void);
#ifdef __cplusplus
}
#endif


#endif

