#include "rdk_debug.h"

const char *rdk_logLevelStrings[ENUM_RDK_LOG_COUNT] =
{
    "FATAL",
    "ERROR",
    "WARNING",
    "NOTICE",
    "INFO",
    "DEBUG",

    "TRACE1",
    "TRACE2",
    "TRACE3",
    "TRACE4",
    "TRACE5",
    "TRACE6",
    "TRACE7",
    "TRACE8",
    "TRACE9",
};

rdk_Error rdk_logger_init(const char* debugConfigFile){
    return RDK_SUCCESS;
}

void rdk_dbg_MsgRaw(rdk_LogLevel level, const char *module, const char *format, ...) {
	printf("[%s, %s] ", rdk_logLevelStrings[level], module);
	va_list argptr;
    va_start(argptr, format);
    vfprintf(stdout, format, argptr);
    va_end(argptr);
}


