/*
 * IARMProxyService.h
 *
 *  Created on: Jun 2, 2014
 *      Author: jasbedar
 */

#ifndef SDVAPI_H_
#define SDVAPI_H_

#include "SDVService.h"
#include "Log.h"

#include "sdv_iarm.h"
#include "libIBus.h"
#include <stdio.h>
#include <map>


namespace sdv {


class IARMProxyService : public SDVService{
public:

	sdv::SDVService::SERVICE_RESULT start();
	sdv::SDVService::SERVICE_RESULT stop();
	typedef void (*IARMProxyEventHander_t) (void * ptrObj, void *data);

public:
	virtual ~IARMProxyService();
	virtual void addEventHandler(const char *owner, IARM_EventId_t eventId, IARMProxyEventHander_t eventHandler);
	virtual IARM_Result_t registerIARMRPC(const char* rpcName, IARM_BusCall_t rpcFunction);

	/**
	 * @fn registerIARMRPC
     * @brief Register an Remote Procedure Call function and its associated object with the IARM proxy
     *
     * @param [in] rpcName - pointer to RPC function name string
     * @param [in ]rpcFunction - RPC function pointer
     * @param [in] rpcObject - RPC object instance
     * @return IARM_Result_t
     */
	virtual IARM_Result_t registerIARMRPC(const char* rpcName, IARM_BusCall_t rpcFunction, void* rpcObject);

	/**
	 * @fn getRpcObject
	 * @brief Get the RPC object registered with the specified RPC name
	 *
	 * @param rpcName - pointer to RPC function name string
	 */
	static void* getRpcObject(const char* rpcName);


private:

	/**
	 * @typedef RPC_MAP
	 * @brief Map containing registered RPC name and corresponding object pointer
	 */
	typedef std::map <const char*, void*> RPC_MAP;

	static RPC_MAP rpcMap;
	static pthread_mutex_t mapLock;				//!< mutex for accessing map data


	static void _handler_Event(const char *owner, IARM_EventId_t eventId, void *data, size_t len);
};
} /* namespace sdv */

#endif /* SDVAPI_H_ */
