/*
* ============================================================================
* RDK MANAGEMENT, LLC CONFIDENTIAL AND PROPRIETARY
* ============================================================================
* This file (and its contents) are the intellectual property of RDK Management, LLC.
* It may not be used, copied, distributed or otherwise  disclosed in whole or in
* part without the express written permission of RDK Management, LLC.
* ============================================================================
* Copyright (c) 2014 RDK Management, LLC. All rights reserved.
* ============================================================================
*/

#ifndef SDVAGENT_HPP_
#define SDVAGENT_HPP_

#include <list>
#include <unistd.h>
#include <csignal>
#include <ctime>

#include "Log.h"
#include "SDVService.h"
#include "MessageService.h"
#include "SDVSessionHandler.h"
#include "SDVEventQueue.h"
#include "InitRequest.h"
#include "InitConfirm.h"
#include "UserActivityService.h"
#include "TRMMonitorService.h"



class SdvAgent
{
public:
    enum STATE{SDV_STATE_NOT_STARTED,
        SDV_STATE_WAITING_FOR_MCP,
        SDV_STATE_WAITING_FOR_INIT_CONFIRM,
        SDV_STATE_READY};
public:
    SdvAgent();
    ~SdvAgent();
    void start();
    void stop();

private:
	typedef void (*MCP_UPDATE_NOTIFY)(void* userData);


    /**
     * @fn mcpUpdated
     * @brief Callback to indicate the mini-carousel data has been updated with a change
     *
     * @param ptrObject - pointer to the SDVAgent object that registered the callback
	 * @param isServiceGroupChange - indicates if the service group has changed
	 * @param isServerIpChange - indicates if server IP or port has changed
     */
    static void mcpUpdated(void * ptrObject, bool isServiceGroupChange, bool isServerIpChange);

    static void initResponse(void * ptrObject,sdv::MessageService::REPONSE_STATUS_t status, sdv::SDVMessage * response);
    void sendInitRequest(int delay);
private:
    STATE _state;
    sdv::IARMProxyService * iarmProxyService;
    sdv::SDVEventQueue * _eventQueue;
    sdv::MessageService * _messageService;
    sdv::ConfigurationParser * _configParser;
    sdv::SDVSessionHandler * sessionHandler;
    sdv::TRMMonitorService * trmMonitor;
    sdv::UserActivityService * userActivity;
};

#endif /*SDVAGENT_HPP_*/
