/*
 * EventResponse.cpp
 *
 */

#include <assert.h>
#include "EventResponse.h"


using namespace sdv;


EventResponse::EventResponse(uint8_t* macAddress, uint8_t tunerIndex, uint32_t transactionId) :
		   SDVMessage(macAddress, SDVMessage::EventResponse, tunerIndex, PAYLOAD_LENGTH, transactionId) {
}

size_t EventResponse::serialize(uint8_t* emptyBuff, size_t buffLength) {
	assert(buffLength >= sizeof(struct ccmis_event_response));

	// Serialize Header fields into buffer
	SDVMessage::serialize(emptyBuff, buffLength);

	// Set Payload fields in buffer
	CCMIS_EVENT_RESPONSE* payload = (CCMIS_EVENT_RESPONSE *) emptyBuff;
	payload->response = 0x0000;  // rspOk

	return sizeof(struct ccmis_event_response);
}

