/**
 * @file EventResponse.h
 *
 */
#ifndef EVENTRESPONSE_H_
#define EVENTRESPONSE_H_

#include "SDVMessage.h"


namespace sdv {

/**
 * @class EventResponse
 * @brief CCMIS EventResponse class definition
 *
 * @details Defines CCMIS EventResponse outbound message.
 */
class EventResponse : public SDVMessage {

public:
	/**
	 * @constructor
	 * @brief Constructor to create an EventResponse SDV message using the specified parameters.
	 *
	 * @param [in] macAddress
	 * @param [in] tunerIndex
	 * @param [in] transactionId
	 */
	EventResponse(uint8_t* macAddress, uint8_t tunerIndex, uint32_t transactionId);

	/**
	 * @fn serialize
	 * @brief Serialize this message into the specified empty buffer.
	 * The serialized data will be ready for UDP transmission to the SDV Server.
	 *
	 * @param [out] emptyBuff - empty buffer to store serialized message
	 * @param [in] maxBuffLength - maximum length of empty buffer in bytes
	 * @return length of serialized message in bytes
	 */
	size_t serialize(uint8_t* emptyBuff, size_t buffLength);


private:

	/**
	 * @struct ccmis_event_response
	 * @brief Data structure of CCMIS EventResponse that can be directly casted into packet buffer.
	 * Fields are defined in CCMIS 3.14
	 */
#pragma pack(push,1)
	typedef struct ccmis_event_response {
		struct ccmis_header header;
		uint16_t response;
	} CCMIS_EVENT_RESPONSE;
#pragma pack(pop)

	static const uint16_t PAYLOAD_LENGTH = sizeof(struct ccmis_event_response) - sizeof(struct ccmis_header); //!> excludes session ID
};

} /* namespace sdv */

#endif /* EVENTRESPONSE_H_ */
