/**
* @file ProgramSelectRequest.h
*
*/
#ifndef PROGRAMSELECTREQUEST_H_
#define PROGRAMSELECTREQUEST_H_

#include "SDVMessage.h"


namespace sdv {

/**
 * @class ProgramSelectRequest
 * @brief CCMIS ProgramSelectRequest class definition
 *
 * @details Defines CCMIS ProgramSelectRequest outbound message.
 */
class ProgramSelectRequest : public SDVMessage {
public:

	/**
	 * @constructor
	 * @brief Constructor to create an InitConfirm SDV message using the specified parameters.
	 *
	 * @param [in] macAddress
	 * @param [in] tunerIndex
	 * @param [in] tunerUse
	 * @param [in] retryCount
	 * @param [in] sourceId
	 * @param [in] serviceGroupId
	 */
	ProgramSelectRequest(uint8_t* macAddress, uint8_t tunerIndex, uint8_t tunerUse, uint8_t retryCount,
			uint32_t sourceId, uint32_t serviceGroupId);

	/**
	 * @fn serialize
	 * @brief Serialize this message into the specified empty buffer.
	 * The serialized data will be ready for UDP transmission to the SDV Server.
	 *
	 * @param [out] emptyBuff - empty buffer to store serialized message
	 * @param [in] maxBuffLength - maximum length of empty buffer in bytes
	 * @return length of serialized message in bytes
	 */
	size_t serialize(uint8_t* emptyBuff, size_t buffLength);


private:

	static const uint16_t PAYLOAD_LENGTH = 0x00E;	//!< length in bytes of payload for this message
	static const uint16_t PRIVATE_DATA_LENGTH = 0x0006;

	/**
	 * @struct ccmis_program_select_request
	 * @brief Data structure of CCMIS ProgramSelectRequest that can be directly casted into packet buffer.
	 * Fields are defined in CCMIS 3.14
	 */
#pragma pack(push,1)
	typedef struct ccmis_program_select_request {
		struct ccmis_header header;
		uint8_t retry_count;
		uint8_t reserved1;
		uint32_t source_id;
		uint16_t private_data_len;
		uint8_t tuner_use;
		uint8_t reserved2;
		uint32_t service_group_id;
	} CCMIS_PROGRAM_SELECT_REQUEST;
#pragma pack(pop)

	uint8_t tuner_use;			//!< TODO: make this something more friendlier
	uint8_t retry_count;
	uint32_t source_id;
	uint32_t service_group_id;
};

}

#endif /* PROGRAMSELECTREQUEST_H_ */
