/*
 * ProgramSelectResponse.cpp
 *
 *  Created on: Jul 30, 2014
 *      Author: ktaubing
 */

#include <assert.h>
#include <netinet/in.h>
#include "ProgramSelectResponse.h"

using namespace sdv;


ProgramSelectResponse::ProgramSelectResponse(uint8_t* macAddress, uint8_t tunerIndex, uint16_t response, uint32_t transactionId) :
				   SDVMessage(macAddress, SDVMessage::ProgramSelectResponse, tunerIndex, PAYLOAD_LENGTH, transactionId) {
	this->response = response;
}


size_t ProgramSelectResponse::serialize(uint8_t* emptyBuff, size_t buffLength) {
	assert(buffLength >= sizeof(struct ccmis_program_select_response));

	// Serialize Header fields into buffer
	SDVMessage::serialize(emptyBuff, buffLength);

	// Set Payload fields in buffer
	CCMIS_PROGRAM_SELECT_RESPONSE* payload = (CCMIS_PROGRAM_SELECT_RESPONSE *) emptyBuff;
	payload->response = htons(response);
	payload->private_data_len = htons(PRIVATE_DATA_LENGTH);

	return sizeof(struct ccmis_program_select_response);
}

