/*
 * QueryConfirm.cpp
 *
 */

#include <assert.h>
#include <netinet/in.h>

#include "QueryConfirm.h"


using namespace sdv;

QueryConfirm::QueryConfirm(uint8_t* macAddress,
						   uint8_t tunerIndex,
						   uint32_t sourceId,
						   uint8_t tunerUse,
						   uint32_t serviceGroupId,
						   uint32_t lastUserActivity,
						   uint32_t transactionId) :
		   SDVMessage(macAddress, SDVMessage::QueryConfirm, tunerIndex, PAYLOAD_LENGTH, transactionId) {
	tuner_use = tunerUse;
	last_user_activity = lastUserActivity;
	source_id = sourceId;
	service_group_id = serviceGroupId;
}

size_t QueryConfirm::serialize(uint8_t* emptyBuff, size_t buffLength) {
	assert(buffLength >= sizeof(struct ccmis_query_confirm));

	// Serialize Header fields into buffer
	SDVMessage::serialize(emptyBuff, buffLength);

	// Set Payload fields in buffer
	CCMIS_QUERY_CONFIRM* payload = (CCMIS_QUERY_CONFIRM *) emptyBuff;
	payload->source_id = htonl(source_id);
	payload->tuner_use = tuner_use;
	payload->reserved = 0xff;
	payload->service_group_id = htonl(service_group_id);
	payload->private_data_len = htons(PRIVATE_DATA_LENGTH);
	payload->last_user_activity = htonl(last_user_activity);
	payload->response = 0x0000;  // rspOk


	return sizeof(struct ccmis_query_confirm);
}
