/**
 * @file QueryRequest.h
 *
 */

#ifndef QUERYREQUEST_H_
#define QUERYREQUEST_H_

#include "SDVMessage.h"


namespace sdv {

/**
 * @class QueryRequest
 * @brief CCMIS QueryRequest class definition
 *
 * @details Defines CCMIS QueryRequest inbound message.
 */
class QueryRequest : public SDVMessage {
public:

	/**
	 * @constructor
	 * @brief Constructor to create a QueryRequest SDV message from the specified raw data.
	 *
	 * @param buffer [i] raw data received from SDV Server
	 */
	QueryRequest(uint8_t* buffer);


private:

	/**
	 * @struct ccmis_query_request
	 * @brief Data structure of CCMIS QueryRequest that can be directly casted into packet buffer.
	 * Fields are defined in CCMIS 3.14
	 */
#pragma pack(push,1)
	typedef struct ccmis_query_request {
		struct ccmis_header header;
		uint16_t reserved;
	} CCMIS_QUERY_REQUEST;
#pragma pack(pop)


};

} /* namespace sdv */

#endif /* QUERYREQUEST_H_ */
